DROP TABLE IF EXISTS `space`;
CREATE TABLE `space` (
  uid int(10) unsigned NOT NULL,
  username varchar(50) NOT NULL,
  spacename varchar(50) NOT NULL,
  idiograph varchar(100) default NULL,
  picture varchar(255) default NULL,
  templates varchar(100) NOT NULL default 'default',
  ifclose tinyint(1) NOT NULL default '0',
  opendate int(10) unsigned NOT NULL default '0',
  visitday int(10) unsigned NOT NULL default '0',
  visitsum int(10) unsigned NOT NULL default '0',
  viewdate int(10) unsigned NOT NULL default '0'
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `space_blog`;
CREATE TABLE `space_blog` (
  blogid int(10) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  username varchar(50) NOT NULL,
  title varchar(100) NOT NULL,
  subject text NOT NULL,
  productid varchar(255) default NULL,
  classid tinyint(1) unsigned NOT NULL default '0',
  category int(10) unsigned NOT NULL default '0',
  reship tinyint(1) NOT NULL default '0',
  viewnum int(10) unsigned NOT NULL default '0',
  dateline int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (blogid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `space_category`;
CREATE TABLE `space_category` (
  caid int(10) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  name varchar(30) NOT NULL,
  dateline int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (caid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `space_collection`;
CREATE TABLE `space_collection` (
  collid int(10) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  id int(10) unsigned NOT NULL default '0',
  myuid int(10) unsigned NOT NULL default '0',
  idtype varchar(20) NOT NULL,
  dateline int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (collid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `space_comment`;
CREATE TABLE `space_comment` (
  cid int(10) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  id int(10) unsigned NOT NULL default '0',
  authorid int(10) unsigned NOT NULL default '0',
  author varchar(50) NOT NULL,
  ip varchar(20) NOT NULL,
  dateline int(10) unsigned NOT NULL default '0',
  message text NOT NULL,
  PRIMARY KEY  (cid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `space_friend`;
CREATE TABLE `space_friend` (
  id int(10) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  friendid int(10) unsigned NOT NULL default '0',
  fusername varchar(50) NOT NULL,
  status tinyint(1) unsigned NOT NULL default '0',
  note varchar(100) default NULL,
  dateline int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `space_message`;
CREATE TABLE `space_message` (
  messageid int(10) unsigned NOT NULL auto_increment,
  subject text NOT NULL,
  send int(10) unsigned NOT NULL default '0',
  receive int(10) unsigned NOT NULL default '0',
  dateline int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (messageid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `space_visitor`;
CREATE TABLE `space_visitor` (
  uid int(10) unsigned NOT NULL default '0',
  vuid int(10) unsigned NOT NULL default '0',
  vusername varchar(50) NOT NULL,
  dateline int(10) unsigned NOT NULL default '0'
) ENGINE=MyISAM;
