<?php
/////////////////////////////////////////////////////////////////////////////
// 这个文件是 网城创想多用户商城 项目的一部分
//
// Copyright (c) 2007 - 2009 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : member.php
 * ....空间会员管理后台
 *
 * @copyright Copyright (c) 2007 - 2009 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Wed May 06 17:01:47 CST 2009
 */

require_once('../../global.inc.php');

class ShowSpaceManage extends CommonFrameWork {
	/**
	 * 空间对象
	 *
	 * @var obj
	 */
	var $obj_space;	
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $obj_validate;
	/**
	 * 收藏对象
	 *
	 * @var obj
	 */
	var $obj_product;
	/**
	 * 应用内容
	 *
	 * @var obj
	 */
	var $default_app_array;
	
	function ShowSpaceManage(){
		$this->__construct();
	}
	function __construct(){
		//初始化信息
		$this->default_app_array = $this->constructAppModule('space','member');
	}
	
	function main(){
		
 		//验证是否登录
		$this->isMember(0); 
				
		/**
		 * 初始化空间类
		 */
		if (!is_object ( $this->obj_space )) {
			include_once("space.class.php");
			$this->obj_space = new spaceClass();
		}
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->obj_validate)){
			require_once("commonvalidate.class.php");
			$this->obj_validate = new CommonValidate();
		}
		/**
		 * 创建分页对象
		 */
		if (!is_object($this->obj_page)){
			require_once("ajaxcommonpage.class.php");
			$this->obj_page = new CommonPage();
		}		
		//检查空间是否开通
		if ( $this->_check_space ( $_SESSION['s_login']['id'] ) || $this->_input['action'] == 'open_space' ) {
			//获取公共左栏
			$this->_getLeftPage ( $_SESSION ['s_login'] ['id'] );
		} else {
			//提示开通页面
			$this->_show_space_index ();
			exit;
		}
		switch ($this->_input['action']){
			//保存添加留言
			case 'message_save_add':
				$this->_message_save_add ();
				break;
			//留言列表
			case 'message_list':
				break;
			//回复留言
			case 'message_reply':
				$this->_message_reply_add ();
				break;
			//删除留言
			case 'message_del':
				$this->_message_del ();
				break;
			//精品推荐列表
			case 'blog_commend':
				$this->_blog_list ( 1 );
				break;	
			//添加精品推荐				
			case 'blog_commend_add':
				$this->_blog_add ( 1 );
				break;	
			//编辑精品推荐
			case 'blog_commend_edit':
				$this->_blog_edit ( 1 );
				break;	
			//转载日志
			case 'reship':
				$this->_blog_reship ();
				break;									
			//日志列表
			case 'blog_list':
				$this->_blog_list ();
				break;
			//保存编辑日志
			case 'blog_save_edit':
				$this->_blog_save_edit ();
				break;
			//编辑日志
			case 'blog_edit':
				$this->_blog_edit ();
				break;
			//保存添加日志	
			case 'blog_save_add':
				$this->_blog_save_add ();
				break;
			//添加日志
			case 'blog_add':
				$this->_blog_add ();
				break;
			//删除日志
			case 'blog_del':
				$this->_blog_del ();
				break;
			//批量删除日志
			case 'del_blog_more':
				$this->_blog_del_more ();
				break;
			//批量删除精品推荐
			case 'del_blog_commend_more':
				$this->_blog_del_more ( 1 );
				break;				
			//好友列表	
			case 'friend_list':
				$this->_friend_list ();
				break;
			//邀请好友	
			case 'friend_add':
				$this->_friend_add ();
				break;
			//保存邀请好友	
			case 'friend_save_add':
				$this->_friend_save_add ();
				break;	
			//好友申请列表	
			case 'friend_invite':
				$this->_friend_invite ();
				break;	
			//通过好友验证
			case 'friend_pass':
				$this->_friend_pass ();
				break;	
			//解除好友
			case 'friend_del':
				$this->_friend_del ();
				break;
			//忽略好友请求
			case 'friend_ignore':
				$this->_friend_ignore ();
				break;
			//模板编辑	
			case 'templet':
				$this->_templet_edit ();
				break;	
			//保存模板
			case 'templet_save':
				$this->_templet_save ();
				break;			
			//个人资料编辑
			case 'profile':
				$this->_profile_edit ();
				break;
			//保存编辑个人资料
			case 'profile_save_edit':
				$this->_profile_save_edit ();
				break;	
			//增加评论
			case 'comment_add':
				$this->_comment_save_add ();
				break;		
			//回复评论						
			case 'comment_reply':
				$this->_commnet_save_reply ();
				break;
			//删除评论
			case 'commnet_del':
				$this->_comment_delete ();
				break;
			//收藏
			case 'collection':
				$this->_collection_save_add ();
				break;
			//收藏列表	
			case 'collection_list':
				$this->_collection_list ();
				break;
			//删除收藏	
			case 'collection_del':
				$this->_collection_delete ();
				break;	
			//添加分类
			case 'category_add':	
				$this->_category_add ();
				break;
			//保存添加分类
			case 'category_save_add':
				$this->_category_save_add ();
				break;
			//分类列表
			case 'category_list':
				$this->_category_list ();
				break;
			//编辑分类
			case 'category_edit':
				$this->_category_edit ();
				break;
			//保存编辑分类
			case 'category_save_edit':
				$this->_category_save_edit ();
				break;
			//删除分类
			case 'category_del':
				$this->_category_delete ();
				break;
			//产品列表
			case 'product_list':
				$this->_product_list ();
				break;
			//开通空间	
			case 'open_space':
				$this->_open_space();
				break;					
			default:
				$this->_show_space_index ();
				break;
		}
	}
	/**
	 * 从会员中心访问
	 *
	 */
	function _show_space_index () {
		@header("Location:../space/");
	}
	/**
	 * 开通空间
	 *
	 */
	function _open_space () {
 	 	//是否有空间
 	 	$space_array = $this->obj_space->getSpaceInfo ( $_SESSION['s_login']['id'], 'uid' );
 	 	if ( $space_array['uid'] != '' ) {
 			//您已经拥有了自己的空间,请不要重复开通
 			$this->redirectPath ( "error", "../app/space/index.php?uid=".$_SESSION['s_login']['id'], $this->_lang['langSysSpaceAlready'] );
 			exit; 	 		
 	 	}
		//开通空间
 		$space_info = array();
 		$space_info['uid'] = $_SESSION['s_login']['id'];
 		$space_info['username'] = $_SESSION['s_login']['name'];
 		$space_info['spacename'] = $_SESSION['s_login']['name'].$this->_lang['langSpaceForMember'];
 		$space_info['idiograph'] = $this->_lang['langSpaceContent'];
 		$result = $this->obj_space->addSpace ( $space_info );
 		if ( $result) {
 			//恭喜你已经拥有了自己的个人空间
 			$this->redirectPath ( "succ", "app/space/member.php?action=profile", $this->_lang['langSysSpaceAlready'] ); 			
 		} else {
 			//开通空间错误
 			$this->redirectPath ( "error", "../index.html", $this->_lang['langSpaceOpenErr'] );
 		}
	}	
	/**
	 * 检查是否开通空间
	 *
	 * @return bool
	 */
	function _check_space ( $uid ) {
 	 	//是否有空间
 	 	$space_array = $this->obj_space->getSpaceInfo ( $uid, 'uid' );	
 	 	if ( $space_array['uid'] == '' ) {
 	 		return false;
 	 	} else {
 	 		return true;
 	 	}
	}	
	/**
	 * 获取产品
	 *
	 */
	function _product_list () {
		/**
		 * 创建收藏对象
		 */
		if (!is_object($this->obj_product)){
			require_once("product.class.php");
			$this->obj_product = new ProductClass();
		}		
		//获取收藏商品					
		$product_array = $this->obj_product->getProductList(array('member' => $_SESSION["s_login"]['id'] ), $obj_page);
		//编辑精品推荐	
		if ( $this->_input['id'] != '' ) {
			$blog_array = $this->obj_space->getSpaceBlog ( $this->_input['id'], $_SESSION ['s_login'] ['id'], "productid" );									
			if ( is_array( $product_array ) ) {
				$productid_array = explode( ",", $blog_array['productid'] );
				foreach ( $product_array as $k => $v ) {
					if ( in_array( $product_array[$k]['p_id'], $productid_array ) ) {
						$product_array[$k]['checked'] = 'true';
					}
				}
			}				
		}	
		/**
		 * 抛出页面
		 */
		$this->output( "product_array", $product_array );
		$this->showpage( "own_product_list" );		
	}
	/**
	 * 删除分类
	 *
	 */
	function _category_delete () {
		if ( $this->_input['id'] != '' ) {
			if ( $this->obj_space->delCategory ( $this->_input['id'], $_SESSION ['s_login'] ['id'] ) ) {
				//删除分类成功
				$this->redirectPath ( "succ", "app/space/member.php?action=category_list", $this->_lang['langSpaceDeleteCategorySucc'] );				
			} else {
				//删除分类失败
				$this->redirectPath ( "error", "../app/space/member.php?action=category_list", $this->_lang['langSpaceDeleteCategoryFalse'] );
			}			
		}
	}
	/**
	 * 保存编辑分类
	 *
	 */
	function _category_save_edit () {
		/**
		 * 验证参数
		 */
		$this->obj_validate->validateparam = array ( array ( "input" => $this->_input ["txtName"],"require" => "true", "message" => $this->_lang['langSpaceCheckCategory'] ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {
			if ( $this->_input['id'] != "" ) {
				 //入库
				 $this->_input['caid'] = $this->_input['id'];
				 $this->_input['uid'] = $_SESSION ['s_login'] ['id'];
				 if ( $this->obj_space->updateCategory ( $this->_input ) ) {
					//编辑分类成功
					$this->redirectPath ( "succ", "", $this->_lang['langSpaceEditCategorySucc'] );					 	
				 } else {
					//编辑分类失败
					$this->redirectPath ( "error", "", $this->_lang['langSpaceEditCategoryFalse'] );						 	
				 }
			}			
		}
	}
	/**
	 * 编辑分类
	 *
	 */
	function _category_edit () {
		if ( $this->_input['id'] != '' ) {
			//获取分类信息
			$category_array = $this->obj_space->getCategory ( $this->_input['id'], $_SESSION ['s_login'] ['id'], "caid,name" );
		   //抛出数据
		   $this->output ( "category_array", $category_array );
		   $this->output ( "action", "category_save_edit" );
		   $this->showpage ( "own_category.add" );
		}
	}
	/**
	 * 分类列表
	 *
	 */
	function _category_list () {
		$this->obj_page->pagebarnum ( 15 );	//每页显示?条			
		//获取分类列表
		$category_array = $this->obj_space->getCategoryList ( $_SESSION ['s_login'] ['id'], $this->obj_page );
		if ( is_array( $category_array ) ) {
			foreach ( $category_array as $k => $v ) {
				$category_array[$k]['dateline'] = date ( 'Y-m-d', $category_array[$k]['dateline'] );
			}			
		}		
		$pagelist = $this->obj_page->show ( 1 ); //分页显示			
		//抛出数据
		$this->output ( "category_array", $category_array );
		$this->output ( "pagelist", $pagelist );	//分页		
		$this->showpage ( "own_category.list" );
	}
	/**
	 * 保存添加日志分类
	 *
	 */
	function _category_save_add () {
		/**
		 * 验证参数
		 */
		$this->obj_validate->validateparam = array ( array ( "input" => $this->_input ["txtName"],"require" => "true", "message" => $this->_lang['langSpaceCheckCategory'] ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {	
			//入库
			$this->_input['uid'] = $_SESSION ['s_login'] ['id'];
			if ( $this->obj_space->addCategory ( $this->_input ) ) {
				//添加分类成功
				$this->redirectPath ( "succ", "app/space/member.php?action=category_list", $this->_lang['langSpaceAddCategorySucc'] );				
			} else {
				//添加分类失败
				$this->redirectPath ( "error", "../app/space/member.php?action=category_list", $this->_lang['langSpaceAddCategoryFalse'] );
			}				
		}		
	}
	/**
	 * 添加日志分类
	 *
	 */
	function _category_add () {
		$this->output ( "action", "category_save_add" );		
		$this->showpage ( "own_category.add" );
	}
	/**
	 * 删除收藏
	 *
	 */
	function _collection_delete () {
		if ($this->_input['id'] != '') {		
			if ( $this->obj_space->delCollection ( $this->_input['id'], $_SESSION ['s_login'] ['id'] ) ) {
				//删除收藏成功
				$this->redirectPath ( "succ", "app/space/member.php?action=collection_list", $this->_lang['langDeleteCollectionSucc'] );				
			} else {
				//删除收藏失败
				$this->redirectPath ( "error", "../app/space/member.php?action=collection_list", $this->_lang['langDeleteCollectionFalse'] );
			}				
		} else {
			//操作失败，删除评论的id为空
			$this->redirectPath ( "error", "", $this->_lang['langDeleteCollectionErr'] );
		}			
	}
	/**
	 * 收藏列表
	 *
	 */
	function _collection_list () {
		$this->obj_page->pagebarnum ( 15 );	//每页显示?条				
		//获得收藏列表
		$collection_array = $this->obj_space->getCollectionList ( $_SESSION ['s_login'] ['id'], $this->obj_page );
		if ( is_array( $collection_array ) ) {
			foreach ( $collection_array as $k => $v ) {
				$collection_array[$k]['dateline'] = date ( 'Y-m-d', $collection_array[$k]['dateline'] );
				switch ( $collection_array[$k]['idtype'] ) {
					case 'space':
						$collection_array[$k]['idtype'] = $this->_lang['langSpaceName2'];
						break;
				}
			}			
		}
		$pagelist = $this->obj_page->show ( 1 ); //分页显示		
		//抛出数据
		$this->output ( "collection_array", $collection_array );	//收藏
		$this->output ( "pagelist", $pagelist );	//分页
		$this->showpage ( "own_collection.list" );
	}
	/**
	 * 收藏
	 *
	 */
	function _collection_save_add () {
		if ($this->_input['id'] != '') {	
			//检查是否已经收藏过
			$collection_array = $this->obj_space->getCollection ( $this->_input['id'], $this->_input['type'], $_SESSION ['s_login'] ['id'], "collid" );
			if ( $collection_array['collid'] == '' ) {
				$this->_input['myuid'] = $_SESSION ['s_login'] ['id'];
				if ( $this->obj_space->addCollection ( $this->_input ) ) {
					//收藏成功
					$this->redirectPath ( "succ", "app/space/index.php?uid=".$this->_input['id'], $this->_lang['langAddCollectionSucc'] );				
				} else {
					//收藏失败
					$this->redirectPath ( "error", "../app/space/index.php?uid=".$this->_input['id'], $this->_lang['langAddCollectionFalse'] );
				} 
			} else {
				//您已经收藏过
				$this->redirectPath ( "error", "../app/space/index.php?uid=".$this->_input['id'], $this->_lang['langAddCollectionis'] );					
			}				
		} else {
			//操作失败，删除评论的id为空
			$this->redirectPath ( "error", "", $this->_lang['langAddCollectionErr'] );
		}		
	}
	/**
	 * 删除评论
	 *
	 */
	function _comment_delete () {
		if ($this->_input['id'] != '') {		
			if ( $this->obj_space->delSpaceComment ( $this->_input['id'], $_SESSION ['s_login'] ['id'] ) ) {
				//删除评论成功
				$this->redirectPath ( "succ", "app/space/index.php?action=blog_view&uid={$this->_input[uid]}&bid={$this->_input[bid]}", $this->_lang['langDeleteCommentSucc'] );				
			} else {
				//删除日志失败
				$this->redirectPath ( "error", "app/space/index.php?action=blog_view&uid={$this->_input[uid]}&bid={$this->_input[bid]}", $this->_lang['langDeleteCommentFale'] );
			}				
		} else {
			//操作失败，删除评论的id为空
			$this->redirectPath ( "error", "", $this->_lang['langDeleteCommentErr'] );
		}			
	}
	/**
	 * 回复评论
	 *
	 */
	function _commnet_save_reply () {
		//获取回复的评论内容
		$commnet_array = $this->obj_space->getOneCommnet ( $this->_input['commentid'], "uid,id,author,message" );
		$commnet_array['message'] = preg_replace("/\<div class=\"quote\"\>\<span class=\"q\"\>.*?\<\/span\>\<\/div\>/is", '', $commnet_array['message']);		
		$input['message'] = addslashes("<div class=\"quote\"><span class=\"q\"><b>".$commnet_array['author']."</b>: ".Common::cutstr ( $commnet_array['message'], 150 ).'</span></div>').$this->_input['txtMessage'];		//回复评论内容
		$input['uid'] = $commnet_array['uid'];	//日志uid
		$input['id'] = $commnet_array['id'];	//日志id
		$input['authorid'] = $_SESSION ['s_login'] ['id'];	//评论人uid
		$input['author'] = $_SESSION ['s_login'] ['name'];	//评论人用户名
		$input['ip'] = $_SERVER['SERVER_ADDR'];	//IP
		if ( $this->obj_space->addCommnet ( $input ) ) {
			//评论成功
			$this->redirectPath ( "succ", "", $this->_lang['langReplyCommentSucc'] );				
		} else {
			//评论失败
			$this->redirectPath ( "error", "", $this->_lang['langReplyCommentFalse'] );				
		}			
	}
	/**
	 * 增加评论
	 *
	 */
	function _comment_save_add () {
		/**
		 * 验证参数
		 */
		$this->obj_validate->validateparam = array ( array ( "input" => $this->_input ["txtMessage"],"require" => "true", "message" => "请填写评论内容" ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {	
			//入库
			$input['uid'] = $this->_input['uid'];	//日志uid
			$input['id'] = $this->_input['id'];	//日志id
			$input['authorid'] = $_SESSION ['s_login'] ['id'];	//评论人uid
			$input['author'] = $_SESSION ['s_login'] ['name'];	//评论人用户名
			$input['ip'] = $_SERVER['SERVER_ADDR'];	//IP
			$input['message'] = $this->_input['txtMessage'];	//评论内容
			if ( $this->obj_space->addCommnet ( $input ) ) {
				//评论成功
				$this->redirectPath ( "succ", "", $this->_lang['langAddCommentSucc'] );				
			} else {
				//评论失败
				$this->redirectPath ( "error", "", $this->_lang['langAddCommentFalse'] );				
			}
		}		
	}
	/**
	 * 获取左栏公共页面
	 *
	 * @param int $uid
	 */
	function _getLeftPage ( $uid ) {
		//抛出公共左栏信息
		$space_array = $this->_getSpaceInfo ( $uid );		
		if ( $space_array['ifclose'] == '1' ) {
	 	 	//空间已经被关闭,请联系管理员
	 	 	$this->redirectPath ( "error", "../index.html", $this->_lang['langSysSpaceIfclose'] );	
	 	 	exit;				
		}		
		if ( $space_array['uid'] != '' ) {
			$visitor_array = $this->_getVisitor ( $uid );
			//获取头像
			$photo_my = $this->obj_space->getSpaceInfo ( $_SESSION ['s_login']['id'], "picture" );
			if ( $photo_my['picture'] != '' ) {
				$ex_picture = explode( ".",$photo_my['picture'] );
				$photo_my['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
				$photo_my['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
			}		
			//抛出数据
			$this->output ( "type", "member" ); //前台
			$this->output ( "visitor_array", $visitor_array );	//近期访客
			$this->output ( "s_login_id", $_SESSION ['s_login'] ['id'] ); //登录id			
			$this->output ( "space_array", $space_array ); //空间信息	
			$this->output ( "s_login_name", $_SESSION ['s_login'] ['name'] ); //登录用户名
			$this->output ( "photo_my", $photo_my ); //头像				
		}			
	}
	/**
	 * 保存编辑模板
	 *
	 */
	function _templet_save () {
		$input['templates'] = $this->_input['templates'];
		if ( $this->obj_space->updateSpace ( $this->_input['uid'], $input ) ) {
			//模板设置成功
			$this->redirectPath ( "succ", "", $this->_lang['langUpdateTempletSucc'] );
		} else {
			//模板设置失败
			$this->redirectPath ( "error", "", $this->_lang['langUpdateTempletFalse'] );
		}			
	}
	/**
	 * 显示模板管理
	 *
	 */
	function _templet_edit () {
		//获取模板信息
		$templet_array = $this->obj_space->getSpaceInfo ( $_SESSION ['s_login'] ['id'], "uid,templates" );	
		//抛出数据
		$this->output( "templet_array", $templet_array );	
		$this->showpage( "own_templet" );	
	}
	/**
	 * 保存编辑个人资料
	 *
	 */
	function _profile_save_edit () {
		/**
		 * 验证参数
		 */
		$this->obj_validate->validateparam = array (array ("input" => $this->_input ["txtSpacename"], "require" => "true", "message" => $this->_lang['langSpaceNameCheck'] ), array ("input" => $this->_input ["txtIdiograph"], "require" => "true", "message" => $this->_lang['langSpaceIndividualityCheck'] ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {			
			if ($_FILES['picture']['tmp_name'] != "") { 				
				//获取用户空间信息
				$space_array = $this->obj_space->getSpaceInfo ( $_SESSION ['s_login'] ['id'], "picture" );	
				//删除原来的图片
				if ( $space_array['picture'] != '' ) {
					$arr = @explode( '.', $space_array['picture'] );
					@unlink(BasePath.'/app/'.$arr[0].'.'.$arr[1]);
					@unlink(BasePath.'/app/'.$arr[0].'_small.'.$arr[1]);
					@unlink(BasePath.'/app/'.$arr[0].'_big.'.$arr[1]);
					@unlink(BasePath.'/app/'.$arr[0].'_mid.'.$arr[1]);
					unset($arr);		
				}
				require_once("uploadfile.class.php");
				$upload = new UploadFile();
				$upload->allow_type = explode(',',$this->_fileconfig['allowuploadimagetype']);
				//上传商品图片
				$filename = $upload->upfile("picture");
				/*按比例生成图片*/
				$cut = $this->_configinfo['productinfo']['imageresize_ifcut'];
				if ($filename !== false){
					include_once ('resizeImage.class.php');
					//判断图片大小
					$image_info = @getimagesize($filename['filename']);
					$width = $image_info[0];
					$height = $image_info[1];
					if ($width > $height){//用宽度
						$pic_param = $width;
						$small_percent = number_format($pic_param/$this->_configinfo['productinfo']['imageresize_width'],2);
					}else {//用高度
						$pic_param = $height;
						$small_percent = number_format($pic_param/$this->_configinfo['productinfo']['imageresize_height'],2);
					}
					//小图
					if (intval($small_percent) > 1){
						$obj_small = new resizeImage($filename['filename'],intval($width/$small_percent),intval($height/$small_percent),$cut);
					}elseif (intval($small_percent) == 1){
						//取与标准尺寸的差值
						$pic_percent = $small_percent;
						$pic_percent = ($pic_percent-1)>0.5?$pic_percent-1:(1-($pic_percent-1));
						$small_width = intval($width*($pic_percent));
						$small_height = intval($height*($pic_percent));
						$obj_small = new resizeImage($filename['filename'],$small_width,$small_height,$cut);
					}else {
						$obj_small = new resizeImage($filename['filename'],$width,$height,$cut);
					}
					//中图
					if (intval($pic_param/45) > 1){
						$obj_mid = new resizeImage($filename['filename'],intval($width/($pic_param/45)),intval($height/($pic_param/45)),$cut,"_mid.");
					}elseif (intval($pic_param/45) == 1){
						//取与标准尺寸的差值
						$pic_percent = number_format($pic_param/45,2);
						$pic_percent = ($pic_percent-1)>0.5?$pic_percent-1:(1-($pic_percent-1));
						$mid_width = intval($width*($pic_percent));
						$mid_height = intval($height*($pic_percent));
						$obj_mid = new resizeImage($filename['filename'],$mid_width,$mid_height,$cut,"_mid.");
					}else {
						$obj_mid = new resizeImage($filename['filename'],$width,$height,$cut,"_mid.");
					}
					//大图
					if (intval($pic_param/200) > 1){
						$obj_big = new resizeImage($filename['filename'],intval($width/intval($pic_param/200)),intval($height/intval($pic_param/200)),$cut,"_big.");
					}elseif (intval($pic_param/200) == 1){
						//取与标准尺寸的差值
						$pic_percent = number_format($pic_param/200,2);
						$pic_percent = ($pic_percent-1)>0.5?$pic_percent-1:(1-($pic_percent-1));
						$big_width = intval($width*($pic_percent));
						$big_height = intval($height*($pic_percent));
						$obj_big = new resizeImage($filename['filename'],$big_width,$big_height,$cut,"_big.");
					}else {
						$obj_big = new resizeImage($filename['filename'],$width,$height,$cut,"_big.");
					}
				}
				//图片名称$filename["getfilename"]
				$arr = @explode('.',$filename["getfilename"]);
				$return_name = $arr[0].'_small.'.$arr[1];
				unset($upload,$arr);
			}			
			//更新空间信息
 	 		$space_info = array();
			if ( $filename["getfilename"] != '' ) {
				$space_info['picture'] = $filename["getfilename"];
			} 	 		
 	 		$space_info['spacename'] = $this->_input['txtSpacename'];
 	 		$space_info['idiograph'] = $this->_input['txtIdiograph'];				
			if ( $this->obj_space->updateSpace ( $this->_input['uid'], $space_info ) ) {
				//个人资料更新成功
				$this->redirectPath ( "succ", "", $this->_lang['langSpaceMemberUpdateSucc'] );
			} else {
				//个人资料更新失败
				$this->redirectPath ( "error", "", $this->_lang['langSpaceMemberUpdateFalse'] );
			}		
		}
	}
	/**
	 * 编辑个人资料
	 *
	 */
	function _profile_edit () {
		//获取用户空间信息
		$space_array = $this->obj_space->getSpaceInfo ( $_SESSION ['s_login'] ['id'], "*" );
		if ( $space_array['picture'] != '' ) {
			$ex_picture = explode( ".",$space_array['picture'] );
			$space_array['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
		}
		//抛出页面
		$this->output ( "space_array", $space_array ); //空间信息		
		$this->showpage ( 'own_profile' );
	}
	/**
	 * 解除好友
	 *
	 */
	function _friend_del () {
		if ( $this->_input['id'] != '' ) {
			//获取好友信息
			$friend_array = $this->obj_space->getFriendInfo ( $this->_input['id'], 'uid,friendid,fusername' );
			//删除对方
			$condition['friendid'] = $friend_array['uid'];
			$condition['uid'] = $friend_array['friendid'];
			$del_id = $this->obj_space->getFriendInfoId ( $condition );
			if ( $this->obj_space->delFriend ( $del_id ) == false ) {
				//操作失败，解除对方好友失败
				$this->redirectPath ( "error", "", $this->_lang['langSpaceOtherFriendDeleteFalse'] );
				exit;
			}
			//删除自己
			if ( $this->obj_space->delFriend ( $this->_input['id'] ) ) {
				//解除好友成功
				$this->redirectPath ( "succ", "app/space/member.php?action=friend_list", $this->_lang['langSpaceFriendDeleteSucc'] );
			} else {
				//操作失败，解除好友失败
				$this->redirectPath ( "error", "../app/space/member.php?action=friend_list", $this->_lang['langSpaceFriendDeleteFalse'] );
			}
		} else {
			//操作失败，解除好友id为空
			$this->redirectPath ( "error", "../app/space/member.php?action=friend_list", $this->_lang['langSpaceFriendDeleteId'] );
		}		
	}
	/**
	 * 忽略好友请求
	 *
	 */
	function _friend_ignore () {
		if ( $this->_input['id'] != '' ) {
			//删除请求信息
			if ( $this->obj_space->delFriend ( $this->_input['id'] ) ) {
				//忽略请求成功
				$this->redirectPath ( "succ", "app/space/member.php?action=friend_invite", $this->_lang['langSpaceFriendIgnoreSucc'] );
			} else {
				//忽略请求失败
				$this->redirectPath ( "error", "../app/space/member.php?action=friend_invite", $this->_lang['langSpaceFriendIgnoreFalse'] );
			}			
		} else {
			//操作失败，忽略请求的id为空
			$this->redirectPath ( "error", "../app/space/member.php?action=friend_invite", $this->_lang['langSpaceFriendIgnoreId'] );
		}		
	}
	/**
	 * 验证好友请求
	 *
	 */
	function _friend_pass () {
		if ( $this->_input['id'] != '' ) {
			//获取好友申请信息
			$friend_array = $this->obj_space->getFriendInfo ( $this->_input['id'], 'friendid,fusername' );
			if ( $friend_array != '' ) {
				//修改验证状态
				if ( $this->obj_space->updateFriendStatus (  $this->_input['id'], 1 ) == false ) {
					//操作失败，验证状态更新失败
					$this->redirectPath ( "error", "", $this->_lang['langSpaceFriendPassUpdate'] );	
					exit;
				}
				//添加为好友
				$this->_input['uid'] = $friend_array['friendid']; //好友uid
				$this->_input['friendid'] = $_SESSION ['s_login'] ['id']; //自己uid
				$this->_input['fusername'] = $_SESSION ['s_login'] ['name']; //自己用户名
				$this->_input['status'] = 1; //验证状态
				if ( $this->obj_space->addSpaceFriend ( $this->_input ) ) {
					//通过验证成功
					$this->redirectPath ( "succ", "app/space/member.php?action=friend_list", $this->_lang['langSpaceFriendPassSucc'] );
				} else {
					//操作失败，添加对方好友失败
					$this->redirectPath ( "error", "../app/space/member.php?action=friend_list", $this->_lang['langSpaceOtherFriendPassFalse'] );
				}
			}
		} else {
			//操作失败，好友验证id为空
			$this->redirectPath ( "error", "", $this->_lang['langSpaceFriendPassId'] );
		}
	}
	/**
	 * 好友申请列表
	 *
	 */
	function _friend_invite () {
		$this->obj_page->pagebarnum ( 15 );	//每页显示?条				
		$friend_array = $this->obj_space->getSpaceFriendInviteList ( $_SESSION ['s_login'] ['id'], $this->obj_page );
		if ( is_array($friend_array) ) {
			foreach ( $friend_array as $k => $v ) {
				$friend_array[$k]['dateline'] = date ( 'Y-m-d', $friend_array[$k]['dateline'] );
			}
		}		
		$pagelist = $this->obj_page->show ( 1 ); //分页显示
		//抛出页面
		$this->output ( "friend_array", $friend_array );
		$this->output ( "pagelist", $pagelist ); //分页			
		$this->showpage ( "own_friend_invite.list" );		
	}
	/**
	 * 添加好友
	 *
	 */
	function _friend_save_add () {
		/**
		 * 验证参数
		 */
		$this->obj_validate->validateparam = array (array ("input" => $this->_input ["txtUsername"], "require" => "true", "message" => $this->_lang['langSpaceFriendName'] ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {
			if ( trim( $this->_input['txtUsername'] ) != $_SESSION ['s_login'] ['name'] ) {
				//查看用户是否存在
				$check_user = $this->obj_space->getSpaceInfo ( $this->_input['txtUsername'], 'uid,username', 1 );
				if ( $check_user['uid'] != '' ) {
					//查看是否已经添加为好友了
					$condition['uid'] = $_SESSION ['s_login'] ['id'];
					$condition['friendid'] = $check_user['uid'];
					$fid = $this->obj_space->getFriendInfoId ( $condition, 'id' );
					if ( $fid != '' ) {
						//已经是您的好友了,请不要重复添加
						$this->redirectPath ( "error", "", $this->_lang['langSpaceFriendAlready'] );
					} else {
						//入库
						$this->_input['uid'] =  $check_user['uid']; //添加好友本人uid
						$this->_input['friendid'] = $_SESSION ['s_login'] ['id']; 
						$this->_input['fusername'] = $_SESSION ['s_login'] ['name']; 
						if ( $this->obj_space->addSpaceFriend ( $this->_input ) ) {
							//添加好友请求已经发送,等待对方验证
							$this->redirectPath ( "succ", "", $this->_lang['langSpaceFriendPassAlready'] );
						} else {
							//添加好友失败
							$this->redirectPath ( "error", "", $this->_lang['langSpaceAddFriendFalse'] );
						}							
					}					
				} else {
					//添加好友失败,该用户没有开通空间
					$this->redirectPath ( "error", "", $this->_lang['langSpaceAddFriendFalseSpace'] );
				}			
			} else {
				//不能添加自己为好友
				$this->redirectPath ( "error", "", $this->_lang['langSpaceAddFriendMyself'] );
			}			
		}		
	}
	/**
	 * 邀请好友
	 *
	 */
	function _friend_add () {
		$this->showpage ( "own_friend.add" );		
	}
	/**
	 * 好友列表
	 *
	 */
	function _friend_list () {
		$this->obj_page->pagebarnum ( 15 );	//每页显示?条				
		$friend_array = $this->obj_space->getSpaceFriendList ( $_SESSION ['s_login'] ['id'],$this->obj_page );
		if ( is_array($friend_array) ) {
			foreach ( $friend_array as $k => $v ) {
				$friend_array[$k]['dateline'] = date ( 'Y-m-d', $friend_array[$k]['dateline'] );
				if ( $friend_array[$k]['picture'] != '' ) {
					$ex_picture = explode( ".",$friend_array[$k]['picture'] );
					$friend_array[$k]['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
					$friend_array[$k]['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
				}					
			}
		}	
		$pagelist = $this->obj_page->show ( 1 ); //分页显示
		//抛出页面
		$this->output ( "friend_array", $friend_array );
		$this->output ( "pagelist", $pagelist ); //分页			
		$this->output ( "cols", 4 ); //列数		
		$this->showpage ( "own_friend.list" );
	}
	/**
	 * 转载日志
	 *
	 */
	function _blog_reship () {
		if ( $this->_input['bid'] != '' ) {		
			//获取空间
			$space_array = $this->obj_space->getSpaceInfo ( $_SESSION ['s_login'] ['id'], 'uid' );
			if ( $space_array['uid'] != '' ) {
				//获得日志信息
				$blog_array = $this->obj_space->getSpaceBlog ( $this->_input['bid'] );
				$this->_input['uid'] = $_SESSION ['s_login'] ['id'];
				$this->_input['username'] = $_SESSION ['s_login'] ['name'];
				$this->_input['title'] = $blog_array['title'];
				$this->_input['subject'] = $blog_array['subject'];
				$this->_input['productid'] = $blog_array['productid'];
				$this->_input['classid'] = $blog_array['classid'];
				//入库
				if ($result = $this->obj_space->addSapceBlogReship( $this->_input )) {
					//转载日志成功
					$this->redirectPath ( "succ", "", $this->_lang['langSpaceBlogReshipSucc'] );
				} else {
					//转载日志失败
					$this->redirectPath ( "error", "", $this->_lang['langSpaceBlogReshipFalse'] );
				}					
			} else {
				//请先开通空间,才能转载日志
				$this->redirectPath ( "error", "", $this->_lang['langSpaceBlogReshipNone'] );
			}
		}				
	}
	
	/**
	 * 保存添加日志
	 *
	 */
	function _blog_save_add () {
		/**
		 * 验证参数
		 */
		$this->obj_validate->validateparam = array (array ("input" => $this->_input ["txtTitle"], "require" => "true", "message" => $this->_lang['langSpaceBlogTitleCheck'] ), array ("input" => $this->_input ["txtSubject"], "require" => "true", "message" => $this->_lang['langSpaceBlogContentCheck'] ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {
			$action = "blog_list";
			if ($this->_input['type'] == 1) {
				$action = "blog_commend";
			}			
			$this->_input['uid'] = $_SESSION ['s_login'] ['id'];
			$this->_input['username'] = $_SESSION ['s_login'] ['name'];
			//入库
			if ($result = $this->obj_space->addSapceBlog( $this->_input )) {
				//添加日志成功
				$this->redirectPath ( "succ", "app/space/member.php?action=".$action, $this->_lang['langSpaceBlogAddSucc'] );
			} else {
				//添加日志失败
				$this->redirectPath ( "error", "../app/space/member.php?action=".$action, $this->_lang['langSpaceBlogAddFalse'] );
			}
		}		
	}
	/**
	 * 添加日志
	 *
	 */
	function _blog_add ( $type=0 ) {
		if ( $type == 0 ) {
			//获取分类
			$category_array = $this->obj_space->getCategoryList ( $_SESSION["s_login"]['id'],  $obj_page );
			$this->output( "category_array", $category_array ); //分类			
		}
		//抛出页面
		$this->output ( "actions", "member.php?action=blog_save_add" );
		$this->output ( "type", $type );
		$this->showpage ( "own_blog.add" );		
	}
	/**
	 * 保存编辑日志
	 *
	 */
	function _blog_save_edit () {
		/**
		 * 验证参数
		 */
		$this->obj_validate->validateparam = array (array ("input" => $this->_input ["txtTitle"], "require" => "true", "message" => $this->_lang['langSpaceBlogTitleCheck'] ), array ("input" => $this->_input ["txtSubject"], "require" => "true", "message" => $this->_lang['langSpaceBlogContentCheck'] ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {
			//入库
			if ($result = $this->obj_space->updateSapceBlog($this->_input)) {
				//编辑日志成功
				$this->redirectPath ( "succ", "", $this->_lang['langSpaceBlogEditSucc'] );
			} else {
				//编辑日志失败
				$this->redirectPath ( "error", "", $this->_lang['langSpaceBlogEditFalse'] );
			}			
		}		
	}
	/**
	 * 编辑日志
	 *
	 */
	function _blog_edit ( $type = 0 ) {
		if ( $this->_input['id'] != '' ) {
			//获取日志内容
			$blog_array = $this->obj_space->getSpaceBlog ( $this->_input['id'], $_SESSION ['s_login'] ['id'], "blogid,title,classid,subject,productid,category" );				
			if ( $type == 0 ) {
				//获取分类
				$category_array = $this->obj_space->getCategoryList ( $_SESSION["s_login"]['id'],  $obj_page );
				$this->output( "category_array", $category_array ); //分类			
			}					
			//抛出页面
			$this->output ( "blog_array", $blog_array );		
			$this->output( "type",  $type );
			$this->output ( "actions", "member.php?action=blog_save_edit" );
			$this->showpage ( "own_blog.add" );				
		} else {
			//操作失败，编辑的日志id为空
			$this->redirectPath ( "error", "", $this->_lang['langSpaceBlogEditId'] );
		}		
	}
	/**
	 * 日志列表
	 *
	 */
	function _blog_list ( $type = 0 ) {
		require_once("common.class.php");
		$this->obj_page->pagebarnum ( 15 );	//每页显示?条	
		//获取日志
		$blog_array = $this->obj_space->getSpaceBlogList ( $_SESSION ['s_login'] ['id'], $this->obj_page, $type );
		if ( is_array($blog_array) ) {
			foreach ( $blog_array as $k => $v ) {
				$blog_array[$k]['dateline'] = date ( 'Y-m-d', $blog_array[$k]['dateline'] );
				$blog_array[$k]['title_cut'] = Common::cutstr ( $blog_array[$k]['title'], 15);
				switch ( $blog_array[$k]['classid'] ) {
					case '0':
						$blog_array[$k]['classname'] = $this->_lang['langSpaceBlogCommon']; //普通日志
						break;	
					case '1':
						$blog_array[$k]['classname'] = $this->_lang['langSpaceBlogCommend']; //经典推荐
						break;							
				}
			}
		}
		$pagelist = $this->obj_page->show ( 1 ); //分页显示
		//抛出页面
		$this->output ( "blog_array", $blog_array );
		$this->output( "type", $type );
		$this->output ( "pagelist", $pagelist); //分页	
		$this->showpage ( "own_blog.list" );
	}
	/**
	 * 删除日志
	 *
	 */
	function _blog_del () {
		if ($this->_input['id'] != '') {
			$action = "blog_list";
			if ($this->_input['type'] == 1) {
				$action = "blog_commend";
			}			
			if ( $this->obj_space->delSpaceBlog ( $this->_input['id'], $_SESSION ['s_login'] ['id'] ) ) {
				//删除日志成功
				$this->redirectPath ( "succ", "app/space/member.php?action=".$action, $this->_lang['langSpaceBlogDeleteSucc'] );
			} else {
				//删除日志失败
				$this->redirectPath ( "error", "../app/space/member.php?action=".$action, $this->_lang['langSpaceBlogDeleteFalse'] );
			}				
		} else {
			//操作失败，删除的日志id为空
			$this->redirectPath ( "error", "../app/space/member.php?action=".$action, $this->_lang['langSpaceBlogDeleteId'] );
		}		
	}
	/**
	 * 批量删除日志
	 *
	 */
	function _blog_del_more ( $type="" ) {
		$action = "blog_list";
		if ( $type == 1 ) {
			$action = "blog_commend";
		}
		if ( $this->_input['chboxBlogid'] != '' ) {
			if ( is_array( $this->_input['chboxBlogid'] ) ) {
				foreach ( $this->_input['chboxBlogid'] as $v ) {
					if ( $v != '' ) {
						//删除日志
						$result = $this->obj_space->delSpaceBlog ( $v, $_SESSION ['s_login'] ['id'] );							
					}				
				}
				if ( $result ) {
					//删除日志成功
					$this->redirectPath ( "succ", "app/space/member.php?action=".$action, $this->_lang['langSpaceBlogDeleteSucc'] );
				} else {
					//删除日志失败
					$this->redirectPath ( "error", "../app/space/member.php?action=".$action, $this->_lang['langSpaceBlogDeleteFalse'] );
				}				
			}
		} else {
			//删除日志失败
			$this->redirectPath ( "error", "../app/space/member.php?action=".$action, "请选择要删除的内容" );			
		}
	}
	/**
	 * 删除留言
	 *
	 */
	function _message_del () {
		if ( $this->_input['id'] != '' ) {
			//删除留言
			$this->_input['receive'] = $_SESSION ['s_login'] ['id'];
			if ( $this->obj_space->delMessage ( $this->_input ) ) {
				//删除留言成功
				$this->redirectPath ( "succ", "", $this->_lang['langSpaceMessageDeleteSucc'] );
			} else {
				//删除留言失败
				$this->redirectPath ( "error", "", $this->_lang['langSpaceMessageDeleteFalse'] );
			}				
		} else {
			//操作失败，删除的留言id为空
			$this->redirectPath ( "error", "", $this->_lang['langSpaceMessageDeleteId'] );
		}			
	}
	/**
	 * 回复留言
	 *
	 */
	function _message_reply_add () {
		/**
		 * 验证参数
		 */
		$this->obj_validate->validateparam = array ( array ("input" => $this->_input ["txtSubject"], "require" => "true", "message" => $this->_lang['langSpaceMessageReplyContentCheck'] ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {		
			//获取回复的留言内容
			$message_array = $this->obj_space->getSpaceMessage ( $this->_input['messageid'] );
			if ( $_SESSION ['s_login'] ['id'] == $message_array[0]['receive'] ) {
				$author = $this->_lang['langSpaceMessageHostReply'];
				$style = "background-color:#FFFDF0;";
			} else {
				$author = $_SESSION ['s_login'] ['name'].$this->_lang['langSpaceSay']."：";
			}
			$now_time = date( "Y-m-d H:i:s", time() );
			$this->_input['subject'] = $message_array[0]['subject'];
$this->_input['subject'] .= <<<EOT
<div class="hy_n">
<div class="hy_of" id="replytitle_170495047" style="background-color:#F3F5F9; display:block; float:left; width:100%">
<div class="czhy_tx2" style="width: 180px;">{$author}</div>
<div class="gw13">{$now_time}</div>
<div class="c"></div>
</div>  
<div class="hy_wd" >{$this->_input['txtSubject']}</div>
<div style="clear:both"></div>
</div>	
EOT;
			//更新留言
			if ( $this->obj_space->updateSpaceMessage ( $this->_input['messageid'],$this->_input ) ) {
				//回复留言成功
				$this->redirectPath ( "succ", "", $this->_lang['langSpaceMessageReplySucc'] );
			} else {
				//回复留言失败
				$this->redirectPath ( "error", "", $this->_lang['langSpaceMessageReplyFalse'] );
			}				
		}
	}
	/**
	 * 发送留言
	 *
	 */
	function _message_save_add () {
		/**
		 * 验证参数
		 */
		$this->obj_validate->validateparam = array ( array ("input" => $this->_input ["txtSubject"], "require" => "true", "message" => $this->_lang['langSpaceMessageContentCheck'] ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {
			if ( trim( $this->_input['receiveuid'] ) != $_SESSION ['s_login'] ['id'] ) {
				$this->_input['receive'] = $this->_input['receiveuid'];	//接受留言uid
				$this->_input['send'] = $_SESSION ['s_login'] ['id'];	//发送留言uid
				$now_time = date( "Y-m-d H:i:s", time() );
$this->_input['subject'] = <<<EOT
<div class="hy_n">
<div class="hy_of" id="replytitle_170495047" style="background-color:#F3F5F9; display:block; float:left; width:100%">
<div class="czhy_tx2" style="width: 180px;"><a class="funclink sl" href="index.php?uid={$_SESSION ['s_login'] ['id']}" title="{$_SESSION ['s_login'] ['name']}">{$_SESSION ['s_login'] ['name']}</a>{$this->_lang[langSpaceSay]}：</div>
<div class="gw13">{$now_time}</div>
<div class="c"></div>
</div>  
<div class="hy_wd" >{$this->_input['txtSubject']}</div>
<div style="clear:both"></div>
</div>			
EOT;
				if ( $this->obj_space->addSpaceMessage ( $this->_input ) ) {
					//发送留言成功
					$this->redirectPath ( "succ", "", $this->_lang['langSpaceMessageSendSucc'] );
				} else {
					//发送留言失败
					$this->redirectPath ( "error", "", $this->_lang['langSpaceMessageSendFalse'] );
				}				
			} else {
				//不能给自己留言
				$this->redirectPath ( "error", "", $this->_lang['langSpaceMessageSendMyself'] );
			}
		}
	}
	/**
	 * 获取空间信息
	 *
	 * @param int $uid
	 */
	function _getSpaceInfo ( $uid ) {			
		//获取用户空间信息
		$space_array = $this->obj_space->getSpaceInfo ( $uid, "*" );
		if ( $space_array['picture'] != '' ) {
			$ex_picture = explode( ".",$space_array['picture'] );
			$space_array['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
			$space_array['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
		}	
		return $space_array;		
	}
	/**
	 * 近期访客
	 *
	 * @param int $uid
	 * @return array
	 */
	function _getVisitor ( $uid ) {
		$visitor_array = $this->obj_space->getIndexVisitorList ( $uid );	
		if ( is_array ( $visitor_array ) ) {
			foreach ( $visitor_array as $k => $vv ) {
				if ( $vv['picture'] != '' ) {
					$ex_picture = explode( ".",$vv['picture'] );
					$visitor_array[$k]['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
					$visitor_array[$k]['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
				}					
				$visitor_array[$k]['dateline'] = date ( 'Y-m-d', $visitor_array[$k]['dateline'] );	
			}	
		}	
		return $visitor_array;
	}	
}

$space_manage = new ShowSpaceManage();
$space_manage->main();
unset($space_manage);
?>