<?php
/////////////////////////////////////////////////////////////////////////////
// 这个文件是 网城创想多用户商城 项目的一部分
//
// Copyright (c) 2007 - 2009 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : member.php
 * ....会员管理后台
 *
 * @copyright Copyright (c) 2007 - 2009 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Wed May 06 17:01:47 CST 2009
 */

require_once('../../global.inc.php');

class ShowSupplyManage extends CommonFrameWork {
	/**
	 * 供求对象
	 *
	 * @var obj
	 */
	var $obj_supply;
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 * 商品类别对象
	 *
	 * @var obj
	 */
	var $obj_product_category;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $obj_validate;
	/**
	 * 应用内容
	 *
	 * @var obj
	 */
	var $default_app_array;
	
	function ShowSupplyManage(){
		$this->__construct();
	}
	function __construct(){
		//初始化信息
		$this->default_app_array = $this->constructAppModule('supply','member');
	}
	
	function main(){
		/**
		 * 创建应用对象
		 */
		if (!is_object($this->obj_supply)){
			require_once("supply.class.php");
			$this->obj_supply = new supplyClass();
		}
		/**
		 * 创建商品分类对象
		 */
		if (!is_object($this->obj_product_category)){
			require_once("productclass.class.php");
			$this->obj_product_category = new ProductCategoryClass();
		}
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->obj_validate)){
			require_once("commonvalidate.class.php");
			$this->obj_validate = new CommonValidate();
		}
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->obj_member)){
			require_once("member.class.php");
			$this->obj_member = new MemberClass();
		}
		/**
		 * 获取回复列表
		 */
		if (!is_object($this->obj_page)){
			require_once("commonpage.class.php");
			$this->obj_page = new CommonPage();
		}
		
		//用户管理界面上的菜单
		$this->memberMenuModule();
		
		switch ($this->_input['action']){
			case 'list':
				$this->_list();
				break;
			case 'modi':
				$this->_modi();
				break;
			case 'update':
				$this->_update();
				break;
			case 'del':
				$this->_del();
				break;
			case 'change_state':
				$this->_change_state();
				break;
			default:
				$this->_list();
		}
	}
	
	/**
	 * 列表
	 */
	function _list(){
		/**
		 * 检索条件
		 */
		$condition['keyword'] = $this->_input['keyword'];
		$condition['type'] = $this->_input['type'];
		$condition['quality'] = trim($this->_input['quality']);
		$condition['state'] = 1;
		$condition['class_id'] = $this->_input['class_id'];
		$condition['listtype']  = $this->_input['listtype'];
		$condition['member_id']  = $_SESSION['s_login']['id'];
		$condition['sort'] = $this->_input['orderby'];
		
		$this->obj_page->pagebarnum(10);
		$supply_array = $this->obj_supply->getSupplyList($condition,$this->obj_page);
		$page_list = $this->obj_page->show(1);
		
		//处理时间、名称、所属类别的显示
		if (is_array($supply_array)){
			foreach ($supply_array as $k=>$v){
				$supply_array[$k]['s_time'] = $v['s_time']?date("Y-m-d",$v['s_time']):$v['s_time'];
				$supply_array[$k]['s_title'] = Char_class::cut_str($v['s_title'],25,0,$this->_configinfo['websit']['ncharset'],'');
			}
		}
		/**
		 * 页面输出
		 */
		$this->output('page_list',$page_list);
		$this->output('supply_array',$supply_array);
		$this->showpage('own_supply.list');   
	}
	
	/**
	 * 修改信息
	 */
	function _modi(){
		//信息内容
		$supply_array = $this->_check_supply();
		$supply_array = $this->_format_supply_info($supply_array);
		
		//商品类别
		$array = $this->obj_product_category->listClassDetail();
		if(!is_array($array)){
			$list_class_error = $array;
			$array = array();
		}
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v[4] == '0') {
					$ProductCateArray[] = $v;
				}
			}
		}
		/**
		 * 页面输出
		 */
		$this->output('ProductCateArray',$ProductCateArray);
		$this->output('supply_pic_num',count($supply_array['spic_arr']));
		$this->output('supply_array',$supply_array);
		$this->showpage('own_supply.modi');
	}
	
	/**
	 * 检查该信息是否属于该会员
	 */
	function _check_supply(){
		$supply_array = $this->obj_supply->getOneSupply(intval($this->_input["sid"]));
		if (empty($supply_array) || $supply_array['s_member_id'] != $_SESSION['s_login']['id']){
			$this->redirectPath('error','',$this->_lang['langCIdIsIllegal']);
		}
		return $supply_array;
	}
	
	/**
	 * 格式化信息的内容
	 */
	function _format_supply_info($supply_array){
		if (!is_array($supply_array)){
			$this->redirectPath('error','',$this->_lang['errSupplyIsEmpty']);
		}
		$supply_array['s_time'] = $supply_array['s_time']?date("Y-m-d H:i",$supply_array['s_time']):'';
		//商品类别
		$supply_array['s_class_name'] = $this->_get_product_class_path($supply_array['s_class_id']);
		//有效期
		switch ($supply_array['s_valdate']){
			case 0:
				$supply_array['s_valdate'] = 5;
				break;
			case 24*3600*5:
				$supply_array['s_valdate'] = 1;
				break;
			case 24*3600*15:
				$supply_array['s_valdate'] = 2;
				break;
			case 24*3600*30:
				$supply_array['s_valdate'] = 3;
				break;
			case 24*3600*30*4:
				$supply_array['s_valdate'] = 4;
				break;
		}
		//图片字符串进行处理,输出原图
		if ($supply_array['s_pic'] != ''){
			$line = explode('|',trim($supply_array['s_pic'],'|'));
			$spic_arr = array();
			foreach ($line as $k=>$v){
				if ($v != '') {
					$supply_array['spic_arr'][] = $v;
					unset($temp);
				}
			}
		}
		return $supply_array;
	}
	
	/**
	 * 更新信息
	 */
	function _update(){
		/**
		 * 验证表单信息
		 */
		$this->obj_validate->validateparam = array(
			array("input"=>$this->_input["class_id"],"require"=>"true","message"=>$this->_lang['errSupplyClassIsEmtpy']),
			array("input"=>$this->_input["supplyTitle"],"require"=>"true","message"=>$this->_lang['errSupplyTitleIsEmtpy']),
			array("input"=>$this->_input["Content"],"require"=>"true","message"=>$this->_lang['errSupplyContentIsEmtpy'])
		);
		$error = $this->obj_validate->validate();
		if($error != ""){
			$this->redirectPath("error","",$error);
		}else{
			
			if (strtoupper($this->_input['code']) != strtoupper($_SESSION['seccode'])){
				$this->redirectPath("error","",$this->_lang['errSupplyCodeIsWrong']);
			}
			//
			$this->_check_supply();
			
			$value_array = array();
			$value_array['s_id'] = $this->_input['sid'];
			switch ($this->_input["valdate"]){
				case '1':
					$value_array['s_valdate'] = 24*3600*5;
					break;
				case '2':
					$value_array['s_valdate'] = 24*3600*15;
					break;
				case '3':
					$value_array['s_valdate'] = 24*3600*30;
					break;
				case '4':
					$value_array['s_valdate'] = 24*3600*30*4;
					break;
				case '5':
					$value_array['s_valdate'] = 0;
					break;
			}
			$value_array["s_qq"]			=	$this->_input["qq"];
			$value_array["s_msn"]			=	$this->_input["msn"];
			$value_array["s_skype"]			=	$this->_input["skype"];
			$value_array["s_wangwang"]		=	$this->_input["wangwang"];
			$value_array["s_class_id"]		=	$this->_input["class_id"];
			$value_array["s_type"]			=	$this->_input["radioType"];
			$value_array["s_quality"]		=	$this->_input["radioQuality"];
			$value_array["s_title"]			=	$this->_input["supplyTitle"];
			$value_array["s_content"]		=	$this->_input["Content"];
			$value_array["s_phone"]			=	$this->_input["phone"];
			$value_array["s_email"]			=	$this->_input["mail"];
			$value_array["s_pic"]			=	$this->_input["p_pic"];
			$value_array["s_price"]			=	$this->_input["s_price"]?$this->_input["s_price"]:0;
			$value_array["s_price_face"]	=	$this->_input["s_price_face"]==1?1:2;
			$value_array['s_anonymous'] = ($this->_input['anonymous']==2)?2:1;
			//供求信息入库
			$result = $this->obj_supply->updateSupply($value_array,$_SESSION['s_login']['id']);
			//提示信息
			if ($result !== true){
				$this->redirectPath('error','',$this->_lang['errSupplyUpdateIsFail']);
			}else {
				$this->redirectPath('succ','app/'.$this->default_app_array['app_module_path'].'/member.php',$this->_lang['langSupplyUpdateIsSucc']);
			}
		}
	}
	
	/**
	 * 取商品类别 多级目录名
	 */
	function _get_product_class_path($class_id){
		//商品类别名称
		$cate_row = $this->obj_product_category->getPClassRow($class_id);
		for ($j=0;$j<4;$j++){
			if ($cate_row['pc_name'] != '') {
				$cate_name = ">" . $cate_row['pc_name'].$cate_name;
			}
			if ($cate_row[0]['pc_u_id'] != '0'){
				$cate_row = $this->obj_product_category->getPClassRow($cate_row['pc_u_id']);
			}else {
				break;
			}
		}
		return $cate_name;
	}
	
	/**
	 * 删除信息
	 */
	function _del(){
		if (is_array($this->_input['s_id'])){
			foreach ($this->_input['s_id'] as $k => $v){
				$this->obj_supply->delSupply(intval($v),$_SESSION['s_login']['id']);
			}
			$this->redirectPath('succ','app/'.$this->default_app_array['app_module_path'].'/member.php',$this->_lang['langSupplyDelSucc']);
		}else {
			$this->redirectPath('succ','app/'.$this->default_app_array['app_module_path'].'/member.php',$this->_lang['errSupplyDelFail']);
		}
	}
	
	/**
	 * 修改信息状态 
	 */
	function _change_state(){
		switch (intval($this->_input['state'])){
			case '1'://开启
				break;
			case '2'://关闭
				break;
			default:
				$this->redirectPath('succ','app/'.$this->default_app_array['app_module_path'].'/member.php',$this->_lang['errSupplyStateIsWrong']);
		}
		if (is_array($this->_input['s_id'])){
			foreach ($this->_input['s_id'] as $k => $v){
				$value_array = array();
				$value_array['s_id'] = intval($v);
				$value_array['s_state'] = intval($this->_input['state']);
				$this->obj_supply->updateSupply($value_array,$_SESSION['s_login']['id']);
			}
			$this->redirectPath('succ','app/'.$this->default_app_array['app_module_path'].'/member.php',$this->_lang['langSupplyStateSucc']);
		}else {
			$this->redirectPath('succ','app/'.$this->default_app_array['app_module_path'].'/member.php',$tihs->_lang['errSupplyStateFail']);
		}
	}
}

$supply_manage = new ShowSupplyManage();
$supply_manage->main();
unset($supply_manage);
?>