<?php
/////////////////////////////////////////////////////////////////////////////
// 这个文件是 网城创想多用户商城 项目的一部分
//
// Copyright (c) 2007 - 2009 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : index.php
 * ....供求信息管理
 *
 * @copyright Copyright (c) 2007 - 2009 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Sat May 09 08:40:39 CST 2009
 */

require_once("../../global.inc.php");

class SysSupplyClass extends SystemFrameWork{
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_supply;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $obj_validate;
	/**
	 * 商品类别对象
	 *
	 * @var obj
	 */
	var $obj_product_category;
	/**
	 * 应用内容
	 *
	 * @var obj
	 */
	var $default_app_array;
	/**
	 * 应用对象
	 *
	 * @var obj
	 */
	var $obj_app_class;
	
	function SysSupplyClass(){
		$this->__construct();
	}
	function __construct(){
		//初始化信息
		$this->default_app_array = $this->constructAppModule('supply','system','system');
		/**
		 * 模板输出
		 */
		$this->output('app_module',$this->default_app_array);
	}
	
	function main(){
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->objmember)){
			require_once ("member.class.php");
			$this->obj_member = new MemberClass();
		}
		/**
		 * 创建商品分类对象
		 */
		if (!is_object($this->obj_product_category)){
			require_once("productclass.class.php");
			$this->obj_product_category = new ProductCategoryClass();
		}
		/**
		 * 初始化供求信息类
		 */
		if (!is_object($this->obj_supply)){
			require_once('supply.class.php');
			$this->obj_supply = new supplyClass();
		}
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->obj_validate)){
			require_once("commonvalidate.class.php");
			$this->obj_validate = new CommonValidate();
		}
		/**
		 * 创建分页对象
		 */
		if (!is_object($this->obj_page)){
			require_once("ajaxcommonpage.class.php");
			$this->obj_page = new CommonPage();
		}
		/**
		 * 创建应用对象
		 */
		if (!is_object($this->obj_app_class)){
			require_once("app_module.class.php");
			$this->obj_app_class = new AppModuleClass();
		}
		
		switch ($this->_input['action']){
			case 'ajax_list':
				$this->_ajax_list();
				break;
			case 'manage_modi':
				$this->_manage_modi();
				break;
			case 'manage_update':
				$this->_manage_update();
				break;
			case 'recommend':
				$this->_recommend();
				break;
			case 'modi':
				$this->_modi();
				break;
			case 'update':
				$this->_update();
				break;
			case 'change_state':
				$this->_change_state();
				break;
			case 'del':
				$this->_del();
				break;
			case 'replay':
				$this->_replay();
				break;
			case 'modi_replay':
				$this->_modi_replay();
				break;
			case 'update_replay':
				$this->_update_replay();
				break;
			case 'change_re_state':
				$this->_change_re_state();
				break;
			case 're_del':
				$this->_re_del();
				break;
			case 'setup':
				$this->_setup();
				break;
			case 'setup_save':
				$this->_setup_save();
				break;
			case 'unsetup':
				$this->_unsetup();
				break;
			case 'unsetup_save':
				$this->_unsetup_save();
				break;
		}
	}
	/**
	 * 信息列表
	 */
	function _ajax_list(){
		//检索条件
		$condition['keyword'] = $this->_input['keyword'];
		$condition['type'] = $this->_input['type'];
		$condition['quality'] = trim($this->_input['quality']);
		$condition['class_id'] = $this->_input['class_id'];
		$condition['listtype']  = $this->_input['listtype'];
		$condition['anymous']  = $this->_input['anymous'];
		$condition['username']  = $this->_input['username'];
		$condition['sort'] = $this->_input['orderby'];
		
		//列表
		$this->obj_page->pagebarnum(10);
		$this->obj_page->nowindex = $this->_input['curpage']?$this->_input['curpage']:1;
		$supply_array = $this->obj_supply->getSupplyList($condition,$this->obj_page);
		$page_list = $this->obj_page->show(1);
		//处理时间、名称、所属类别的显示
		if (is_array($supply_array)){
			foreach ($supply_array as $k=>$v){
				$supply_array[$k]['s_time'] = $v['s_time']?date("Y-m-d",$v['s_time']):$v['s_time'];
				$supply_array[$k]['s_title'] = Char_class::cut_str($v['s_title'],25,0,$this->_configinfo['websit']['ncharset'],'');
				//有效期
				switch ($supply_array[$k]['s_valdate']){
					case 0:
						$supply_array[$k]['s_valdate'] = $this->_lang['langSupplyValdateNone'];
						break;
					case 24*3600*5:
						$supply_array[$k]['s_valdate'] = $this->_lang['langSupplyValdateFiveDay'];
						break;
					case 24*3600*15:
						$supply_array[$k]['s_valdate'] = $this->_lang['langSupplyValdateHalfMonth'];
						break;
					case 24*3600*30:
						$supply_array[$k]['s_valdate'] = $this->_lang['langSupplyValdateOneMonth'];
						break;
					case 24*3600*30*4:
						$supply_array[$k]['s_valdate'] = $this->_lang['langSupplyValdateOneQuarter'];
						break;
				}
			}
		}
		//商品类别
		$array = $this->obj_product_category->listClassDetail();
		if(!is_array($array)){
			$list_class_error = $array;
			$array = array();
		}
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v[4] == '0') {
					$ProductCateArray[] = $v;
				}
			}
		}
		/**
		 * 页面输出
		 */
		$this->output('ProductCateArray',$ProductCateArray);
		$this->output('curpage',$this->obj_page->nowindex);
		$this->output('page_list',$page_list);
		$this->output('condition',$this->_input);
		$this->output('supply_array',$supply_array);
		$this->showpage('sys_supply.list');
	}
	
	/**
	 * 修改
	 */
	function _manage_modi(){
		/**
		 * 页面输出
		 */
		$this->output('app_array',$this->default_app_array);
		$this->showpage('sys_supply.manage_modi');
	}
	
	/**
	 * 保存修改
	 */
	function _manage_update(){
		/**
		 * 验证提交的数据
		 */
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_id'],"require"=>"true","validator"=>"Number","message"=>$this->_lang['langSysCIDErr']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_name'],"require"=>"true","message"=>$this->_lang['errSysAppManageNameIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sort'],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errSysAppManageSortNotNumber']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_path'],"require"=>"true","message"=>$this->_lang['errSysAppManagePathIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_path'],"require"=>"true","validator"=>"NoChinese","message"=>$this->_lang['errSysAppManagePathIsIllegal']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sys_path'],"require"=>"true","message"=>$this->_lang['errSysAppManageSysPathIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sys_path'],"require"=>"true","validator"=>"NoChinese","message"=>$this->_lang['errSysAppManageSysPathIsIllegal']));
		$error = $this->obj_validate->validate();
		if ($error != ""){
			$error = $this->formatError($error);
			Common::outMessage("json",$error,0);
		}else{
			//更新
			$value_array = array();
			$value_array['app_module_id'] = $this->_input['app_module_id'];
			$value_array['app_module_name'] = $this->_input['app_module_name'];
			$value_array['app_module_sort'] = $this->_input['app_module_sort'];
			$value_array['app_module_path'] = $this->_input['app_module_path'];
			$value_array['app_module_sys_path'] = $this->_input['app_module_sys_path'];
			$value_array['app_module_state'] = $this->_input['app_module_state'];
			$result = $this->obj_app_class->updateAppModule($value_array);
			if ($result !== true){
				Common::outMessage("json",$this->_lang['errSysAppManageUpdateIsFail'],0);
			}else {
				//修改文件夹名
				if ($this->default_app_array['app_module_sys_path'] != $this->_input['app_module_sys_path']){
					if (!rename(BasePath.'/app/'.$this->default_app_array['app_module_path'].'/'.$this->default_app_array['app_module_sys_path'],BasePath.'/app/'.$this->default_app_array['app_module_path'].'/'.$this->_input['app_module_sys_path'])){
						Common::outMessage("json",$this->_lang['errSysAppManageSysPathRenameIsFail'],0);
					}
				}
				if ($this->default_app_array['app_module_path'] != $this->_input['app_module_path']){
					if (!rename(BasePath.'/app/'.$this->default_app_array['app_module_path'],BasePath.'/app/'.$this->_input['app_module_path'])){
						Common::outMessage("json",$this->_lang['errSysAppManagePathRenameIsFail'],0);
					}
				}
				Common::outMessage("json",$this->_lang['langSysAppManageUpdateIsSucc'],1);
			}
		}
	}
	
	/**
	 * 修改推荐状态
	 */
	function _recommend(){
		$value_array = array();
		$value_array["s_id"] =	intval($this->_input['supply_id']);
		if ($this->_input['recommend_id'] == 1) {
			$value_array["s_recommend"] = 2;
		}elseif ($this->_input['recommend_id'] == 2){
			$value_array["s_recommend"] = 1;
		}
		//供求信息入库
		$result = $this->obj_supply->updateSupply($value_array);
		if ($result !== true) {
			Common::outMessage("json",$this->_lang['errSupplyRecommendFail'],0);
		}else {
			/*记录操作日志*/
			SystemPowerClass::addSysLog($this->_lang['langSysLogSupplyRecommend']);
			Common::outMessage("json",$this->_lang['langSupplyRecommendSucc'],1);
		}
	}
	
	/**
	 * 修改信息
	 */
	function _modi(){
		//信息内容
		$supply_array = $this->obj_supply->getOneSupply(intval($this->_input["s_id"]));
		$supply_array = $this->_format_supply_info($supply_array);
		
		//商品类别
		$array = $this->obj_product_category->listClassDetail();
		if(!is_array($array)){
			$list_class_error = $array;
			$array = array();
		}
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v[4] == '0') {
					$ProductCateArray[] = $v;
				}
			}
		}
		/**
		 * 页面输出
		 */
		$this->output('ProductCateArray',$ProductCateArray);
		$this->output('supply_pic_num',count($supply_array['spic_arr']));
		$this->output('supply_array',$supply_array);
		$this->output('condition',$this->_input);
		$this->showpage('sys_supply.modi');
	}
	
	/**
	 * 格式化信息的内容
	 */
	function _format_supply_info($supply_array){
		$supply_array['s_time'] = $supply_array['s_time']?date("Y-m-d H:i",$supply_array['s_time']):'';
		//商品类别
		$supply_array['s_class_name'] = $this->_get_product_class_path($supply_array['s_class_id']);
		//有效期
		switch ($supply_array['s_valdate']){
			case 0:
				$supply_array['s_valdate'] = 5;
				break;
			case 24*3600*5:
				$supply_array['s_valdate'] = 1;
				break;
			case 24*3600*15:
				$supply_array['s_valdate'] = 2;
				break;
			case 24*3600*30:
				$supply_array['s_valdate'] = 3;
				break;
			case 24*3600*30*4:
				$supply_array['s_valdate'] = 4;
				break;
		}
		//图片字符串进行处理,输出原图
		if ($supply_array['s_pic'] != ''){
			$line = explode('|',$supply_array['s_pic']);
			$spic_arr = array();
			foreach ($line as $k=>$v){
				if ($v != '') {
					$supply_array['spic_arr'][] = $v;
					unset($temp);
				}
			}
		}
		return $supply_array;
	}
	
	/**
	 * 取商品类别 多级目录名
	 */
	function _get_product_class_path($class_id){
		//商品类别名称
		$cate_row = $this->obj_product_category->getPClassRow($class_id);
		for ($j=0;$j<4;$j++){
			if ($cate_row['pc_name'] != '') {
				$cate_name = ">" . $cate_row['pc_name'].$cate_name;
			}
			if ($cate_row[0]['pc_u_id'] != '0'){
				$cate_row = $this->obj_product_category->getPClassRow($cate_row['pc_u_id']);
			}else {
				break;
			}
		}
		return $cate_name;
	}
	
	/**
	 * 保存更新
	 */
	function _update(){
		/**
		 * 验证表单信息
		 */
		$this->obj_validate->validateparam = array(
			array("input"=>$this->_input["class_id"],"require"=>"true","message"=>$this->_lang['errSupplyClassIsEmtpy']),
			array("input"=>$this->_input["supplyTitle"],"require"=>"true","message"=>$this->_lang['errSupplyTitleIsEmtpy']),
			array("input"=>$this->_input["txtContent"],"require"=>"true","message"=>$this->_lang['errSupplyContentIsEmtpy'])
		);
		$error = $this->obj_validate->validate();
		if($error != ""){
			Common::outMessage("json",$error,0);
		}else{
			$value_array = array();
			$value_array['s_id'] = $this->_input['sid'];
			switch ($this->_input["valdate"]){
				case '1':
					$value_array['s_valdate'] = 24*3600*5;
					break;
				case '2':
					$value_array['s_valdate'] = 24*3600*15;
					break;
				case '3':
					$value_array['s_valdate'] = 24*3600*30;
					break;
				case '4':
					$value_array['s_valdate'] = 24*3600*30*4;
					break;
				case '5':
					$value_array['s_valdate'] = 0;
					break;
			}
			$value_array["s_qq"]			=	$this->_input["qq"];
			$value_array["s_msn"]			=	$this->_input["msn"];
			$value_array["s_skype"]			=	$this->_input["skype"];
			$value_array["s_wangwang"]		=	$this->_input["wangwang"];
			$value_array["s_class_id"]		=	$this->_input["class_id"];
			$value_array["s_type"]			=	$this->_input["radioType"];
			$value_array["s_class_id"] = $this->_input["class_id"];
			$value_array["s_type"] = $this->_input["radioType"];
			$value_array["s_quality"] = $this->_input["radioQuality"];
			$value_array["s_title"] = $this->_input["supplyTitle"];
			$value_array["s_content"] = $this->_input["txtContent"];
			$value_array["s_phone"]			=	$this->_input["phone"];
			$value_array["s_email"]			=	$this->_input["mail"];
			$value_array["s_pic"]			=	$this->_input["p_pic"];
			$value_array["s_price"]			=	$this->_input["s_price"]?$this->_input["s_price"]:0;
			$value_array["s_price_face"]	=	$this->_input["s_price_face"]==1?1:2;
			$value_array['s_anonymous'] = ($this->_input['anonymous']==2)?2:1;
			//供求信息入库
			$result = $this->obj_supply->updateSupply($value_array);
			//提示信息
			if ($result !== true){
				Common::outMessage("json",$this->_lang['errSupplyUpdateIsFail'],0);
			}else {
				Common::outMessage("json",$this->_lang['langSupplyUpdateIsSucc'],1);
			}
		}
	}
	
	/**
	 * 修改状态
	 */
	function _change_state(){
		switch ($this->_input['state']){
			case '1'://开启
				break;
			case '2'://关闭
				break;
			default:
				Common::outMessage("json",$this->_lang['errSupplyStateIsWrong'],0);
		}
		if (is_array($this->_input['s_id'])){
			foreach ($this->_input['s_id'] as $k => $v){
				$value_array = array();
				$value_array['s_id'] = intval($v);
				$value_array['s_state'] = $this->_input['state'];
				$this->obj_supply->updateSupply($value_array);
			}
			Common::outMessage("json",$this->_lang['langSupplyStateSucc'],1);
		}else {
			Common::outMessage("json",$this->_lang['errSupplyStateFail'],0);
		}
	}
	
	/**
	 * 删除
	 */
	function _del(){
		if (is_array($this->_input['s_id'])){
			foreach ($this->_input['s_id'] as $k => $v){
				$this->obj_supply->delSupply(intval($v));
			}
			Common::outMessage("json",$this->_lang['langSupplyDelSucc'],1);
		}else {
			Common::outMessage("json",$this->_lang['errSupplyDelFail'],0);
		}
	}
	
	/**
	 * 回复
	 */
	function _replay(){
		$condition['sid'] = intval($this->_input['s_id']);
		$this->obj_page->pagebarnum(5);
		$this->obj_page->nowindex = $this->_input['curpage']?$this->_input['curpage']:1;
		$supply_re_array = $this->obj_supply->getSupplyReList($condition,$this->obj_page);
		$page_list = $this->obj_page->show(1);
		//处理时间、回复者名称的显示
		if (is_array($supply_re_array)){
			foreach ($supply_re_array as $k=>$v){
				//回复时间
				$supply_re_array[$k]['sr_time'] = $v['sr_time']?date("Y-m-d H:i",$v['sr_time']):'';
			}
		}
		/**
		 * 页面输出
		 */
		$this->output("page_list", $page_list);
		$this->output('supply_re_array',$supply_re_array);
		$this->output("condition",$this->_input);
		$this->output('curpage',$this->obj_page->nowindex);
		$this->showpage("sys_supply.replay");
	}
	
	/**
	 * 修改留言
	 */
	function _modi_replay(){
		$supply_re_array = $this->obj_supply->getOneReSupply($this->_input['sr_id']);
		/**
		 * 页面输出
		 */
		$this->output('supply_re_array',$supply_re_array);
		$this->output("condition",$this->_input);
		$this->showpage("sys_supply.replay_modi");
	}
	
	/**
	 * 保存修改
	 */
	function _update_replay(){
		/**
		 * 验证表单信息
		 */
		$this->obj_validate->validateparam = array(
			array("input"=>$this->_input["sr_id"],"require"=>"true","message"=>$this->_lang['langSysCIDErr']),
			array("input"=>$this->_input["sr_title"],"require"=>"true","message"=>$this->_lang['errSupplyTitleIsEmtpy']),
			array("input"=>$this->_input["sr_content"],"require"=>"true","message"=>$this->_lang['errSupplyContentIsEmtpy'])
		);
		$error = $this->obj_validate->validate();
		if($error != ""){
			Common::outMessage("json",$error,0);
		}else{
			$value_array = array();
			$value_array['sr_id'] = $this->_input['sr_id'];
			$value_array["sr_title"] = $this->_input["sr_title"];
			$value_array["sr_content"] = $this->_input["sr_content"];
			//供求信息入库
			$result = $this->obj_supply->updateReSupply($value_array);
			//提示信息
			if ($result !== true){
				Common::outMessage("json",$this->_lang['errSupplyUpdateIsFail'],0);
			}else {
				Common::outMessage("json",$this->_lang['langSupplyUpdateIsSucc'],1);
			}
		}
	}
	
	/**
	 * 修改回复状态
	 */
	function _change_re_state(){
		switch ($this->_input['state']){
			case '1'://开启
				break;
			case '2'://关闭
				break;
			default:
				Common::outMessage("json",$this->_lang['errSupplyStateIsWrong'],0);
		}
		if (is_array($this->_input['sr_id'])){
			foreach ($this->_input['sr_id'] as $k => $v){
				$value_array = array();
				$value_array['sr_id'] = intval($v);
				$value_array['sr_state'] = $this->_input['state'];
				$this->obj_supply->updateReSupply($value_array);
			}
			Common::outMessage("json",$this->_lang['langSupplyStateSucc'],1);
		}else {
			Common::outMessage("json",$this->_lang['errSupplyStateFail'],0);
		}
	}
	
	/**
	 * 回复删除
	 */
	function _re_del(){
		if (is_array($this->_input['sr_id'])){
			foreach ($this->_input['sr_id'] as $k => $v){
				$this->obj_supply->delReSupply(intval($v));
			}
			Common::outMessage("json",$this->_lang['langSupplyDelSucc'],1);
		}else {
			Common::outMessage("json",$this->_lang['errSupplyDelFail'],0);
		}
	}
	
	/**
	 * 安装
	 */
	function _setup(){
		/**
		 * 页面输出
		 */
		$this->output('app_array',$this->default_app_array);
		$this->showpage('sys_supply.setup');
	}
	
	/**
	 * 保存安装
	 */
	function _setup_save(){
		/**
		 * 验证提交的数据
		 */
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_name'],"require"=>"true","message"=>$this->_lang['errSysAppManageNameIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sort'],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errSysAppManageSortNotNumber']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_path'],"require"=>"true","message"=>$this->_lang['errSysAppManagePathIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_path'],"require"=>"true","validator"=>"NoChinese","message"=>$this->_lang['errSysAppManagePathIsIllegal']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sys_path'],"require"=>"true","message"=>$this->_lang['errSysAppManageSysPathIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sys_path'],"require"=>"true","validator"=>"NoChinese","message"=>$this->_lang['errSysAppManageSysPathIsIllegal']));
		$error = $this->obj_validate->validate();
		if ($error != ""){
			$error = $this->formatError($error);
			Common::outMessage("json",$error,0);
		}else{
			//第一次安装
			if ($this->default_app_array['app_module_first_install'] == '0'){
				//安装数据库
				$database_result = $this->obj_app_class->setupAppModuleDatabase($this->default_app_array['app_module_path']);
				if ($database_result !== true){
					Common::outMessage("json",$this->_lang['errSysAppManageSqlIsEmpty'],0);
				}
			}
			//更新
			$value_array = array();
			$value_array['app_module_id'] = $this->default_app_array['app_module_id'];
			$value_array['app_module_name'] = $this->_input['app_module_name'];
			$value_array['app_module_sort'] = $this->_input['app_module_sort'];
			$value_array['app_module_path'] = $this->_input['app_module_path'];
			$value_array['app_module_sys_path'] = $this->_input['app_module_sys_path'];
			$value_array['app_module_state'] = $this->_input['app_module_state'];
			$value_array['app_module_install'] = '1';
			$value_array['app_module_first_install'] = '1';
			$result = $this->obj_app_class->updateAppModule($value_array);
			if ($result !== true){
				Common::outMessage("json",$this->_lang['errSysAppManageSetupIsFail'],0);
			}else {
				//修改文件夹名
				if ($this->default_app_array['app_module_sys_path'] != $this->_input['app_module_sys_path']){
					if (!rename(BasePath.'/app/'.$this->default_app_array['app_module_path'].'/'.$this->default_app_array['app_module_sys_path'],BasePath.'/app/'.$this->default_app_array['app_module_path'].'/'.$this->_input['app_module_sys_path'])){
						Common::outMessage("json",$this->_lang['errSysAppManageSysPathRenameIsFail'],0);
					}
				}
				if ($this->default_app_array['app_module_path'] != $this->_input['app_module_path']){
					if (!rename(BasePath.'/app/'.$this->default_app_array['app_module_path'],BasePath.'/app/'.$this->_input['app_module_path'])){
						Common::outMessage("json",$this->_lang['errSysAppManagePathRenameIsFail'],0);
					}
				}
				Common::outMessage("json",$this->_lang['langSysAppManageSetupIsSucc'],1);
			}
		}
	}
	
	/**
	 * 卸载
	 */
	function _unsetup(){
		/**
		 * 页面输出
		 */
		$this->output('app_array',$this->default_app_array);
		$this->showpage('sys_supply.unsetup');
	}
	
	/**
	 * 卸载保存
	 */
	function _unsetup_save(){
		//更新
		$value_array = array();
		$value_array['app_module_id'] = $this->default_app_array['app_module_id'];
		$value_array['app_module_state'] = '1';
		$value_array['app_module_install'] = '0';
		$result = $this->obj_app_class->updateAppModule($value_array);
		if ($result !== true){
			Common::outMessage("json",$this->_lang['errSysAppManageUnsetupNotExistOne']. BasePath.'/app/'.$this->default_app_array['app_module_path'] .$this->_lang['errSysAppManageUnsetupNotExistTwo'],0);
		}else {
			Common::outMessage("json",$this->_lang['langSysAppManageUnsetupIsSucc'],1);
		}
	}
}
$supply = new SysSupplyClass();
$supply->main();
unset($supply);
?>