CREATE TABLE `#__adv_theme` (
  `adv_id` smallint(5) unsigned NOT NULL auto_increment,
  `adv_title` varchar(255) default NULL,
  `adv_type` tinyint(2) NOT NULL,
  `adv_pic` varchar(100) default NULL,
  `adv_url` varchar(200) NOT NULL,
  `adv_code` varchar(100) NOT NULL,
  `adv_start_date` int(10) NOT NULL,
  `adv_end_date` int(10) NOT NULL,
  `adv_width` varchar(10) NOT NULL default '0',
  `adv_heigth` varchar(10) NOT NULL default '0',
  `adv_state` enum('0','1') NOT NULL default '0',
  `adv_sort` int(11) NOT NULL default '0',
  PRIMARY KEY  (`adv_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__app_module` (
  `app_module_id` int(11) NOT NULL auto_increment,
  `app_module_name` varchar(100) NOT NULL,
  `app_module_sign` varchar(100) NOT NULL,
  `app_module_state` enum('0','1') NOT NULL default '0',
  `app_module_sort` int(11) NOT NULL default '0',
  `app_module_install` enum('0','1') NOT NULL default '0',
  `app_module_sys_path` varchar(100) NOT NULL default 'system',
  `app_module_path` varchar(100) NOT NULL,
  `app_module_first_install` enum('0','1') NOT NULL default '0',
  `app_module_show` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`app_module_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__area` (
  `area_id` int(11) NOT NULL auto_increment,
  `area_name` varchar(20) default NULL,
  `area_intro` text,
  `area_parent_id` int(11) default '0',
  `area_sort` int(11) default '0',
  `area_path_string` varchar(30) default NULL,
  `area_deeppath` int(11) NOT NULL default '0',
  PRIMARY KEY  (`area_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__attribute` (
  `a_id` int(11) unsigned NOT NULL auto_increment,
  `pc_id` int(11) NOT NULL,
  `a_name` varchar(50) NOT NULL,
  `a_type` enum('0','1') NOT NULL default '0',
  `a_info` text,
  `a_order` tinyint(3) NOT NULL default '0',
  `a_time` int(10) default NULL,
  PRIMARY KEY  (`a_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__attribute_content` (
  `ac_id` int(11) unsigned NOT NULL auto_increment,
  `a_id` int(11) NOT NULL,
  `ac_content` varchar(50) NOT NULL,
  `ac_order` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`ac_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__bid` (
  `bid_id` int(11) unsigned NOT NULL auto_increment,
  `bid_member_id` int(11) NOT NULL,
  `bid_p_code` varchar(32) NOT NULL,
  `bid_max_price` decimal(9,2) default NULL,
  `bid_price` decimal(9,2) NOT NULL,
  `bid_count` int(8) NOT NULL default '1',
  `bid_total_price` decimal(9,2) NOT NULL,
  `bid_receive_code` varchar(32) default NULL,
  `bid_time` int(10) default NULL,
  `bid_state` enum('0','1','2') default '0',
  `bid_anonymous` enum('0','1') NOT NULL,
  PRIMARY KEY  (`bid_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__channel` (
  `channel_id` int(11) NOT NULL auto_increment,
  `channel_name` varchar(50) NOT NULL,
  `channel_state` enum('0','1') NOT NULL default '0',
  `channel_temp_name` varchar(100) default NULL,
  `channel_sort` int(11) NOT NULL default '0',
  `channel_url` varchar(100) default NULL,
  `channel_domain` varchar(100) default NULL,
  `channel_sign` varchar(100) NOT NULL,
  PRIMARY KEY  (`channel_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__collection` (
  `collection_id` int(10) unsigned NOT NULL auto_increment,
  `member_id` int(10) unsigned NOT NULL,
  `collection` int(10) unsigned NOT NULL,
  `intro` varchar(255) default NULL,
  `genre` enum('store','product') default 'store',
  `collection_time` varchar(50) NOT NULL,
  PRIMARY KEY  (`collection_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__complaint_report` (
  `complaint_report_id` int(11) NOT NULL auto_increment,
  `member_id` int(10) NOT NULL,
  `login_name` varchar(50) NOT NULL,
  `c_r_member_id` int(10) NOT NULL,
  `c_r_login_name` varchar(50) NOT NULL,
  `sp_id` int(12) default NULL,
  `p_code` varchar(32) default NULL,
  `p_name` varchar(100) default NULL,
  `c_r_class` enum('0','1','2','3','4') NOT NULL,
  `c_r_type` enum('0','1','2','3','4','5','6','7','8','9','10','11','12','13','14') NOT NULL,
  `c_r_evidence` text,
  `c_r_pic` varchar(255) default NULL,
  `c_r_pic_two` varchar(255) default NULL,
  `c_r_answer` text,
  `c_r_add_time` int(10) default NULL,
  `embargo_id` int(11) default NULL,
  `c_r_related_product` varchar(32) default NULL,
  `c_r_speculation_member_id` int(10) default NULL,
  `c_r_speculation_member_name` varchar(50) default NULL,
  `c_r_handling_state` enum('0','1','2','3') NOT NULL default '0',
  `c_r_result` varchar(255) default NULL,
  `c_r_end_time` varchar(32) default NULL,
  PRIMARY KEY  (`complaint_report_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__complaint_report_message` (
  `r_c_msg_id` int(11) NOT NULL auto_increment,
  `r_c_msg_type` enum('0','1') NOT NULL,
  `complaint_report_id` int(11) NOT NULL,
  `r_c_msg_add` varchar(32) NOT NULL,
  `r_c_content` text NOT NULL,
  PRIMARY KEY  (`r_c_msg_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__credits_log` (
  `cl_id` int(11) NOT NULL auto_increment,
  `cl_member_id` int(11) NOT NULL,
  `cl_time` int(11) NOT NULL,
  `cl_type` varchar(20) NOT NULL,
  `cl_content` varchar(100) NOT NULL,
  `cl_exp` int(11) NOT NULL default '0',
  `cl_points` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cl_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__delete_debug` (
  `delete_debug_id` int(11) NOT NULL auto_increment,
  `date_line` varchar(11) NOT NULL,
  `delete_result` text NOT NULL,
  PRIMARY KEY  (`delete_debug_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__exchange` (
  `exchange_id` int(11) NOT NULL auto_increment,
  `exchange_name` varchar(10) NOT NULL default 'CNY',
  `exchange_rate` decimal(8,2) NOT NULL default '100.00',
  `state` enum('0','1') NOT NULL default '0',
  `exchange_remark` varchar(40) default NULL,
  PRIMARY KEY  (`exchange_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__increments` (
  `i_id` tinyint(3) unsigned NOT NULL auto_increment,
  `i_low` decimal(12,2) NOT NULL,
  `i_high` decimal(12,2) NOT NULL,
  `increment` int(11) NOT NULL,
  PRIMARY KEY  (`i_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__invoice` (
  `invoice_id` int(10) NOT NULL auto_increment,
  `order_code` varchar(32) NOT NULL,
  `receive_code` varchar(32) default NULL,
  `invoice_info` varchar(250) default NULL,
  PRIMARY KEY  (`invoice_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__keyword` (
  `keyword_id` int(11) NOT NULL auto_increment,
  `keyword_name` varchar(100) NOT NULL,
  `keyword_num` int(11) NOT NULL default '0',
  `update_date` int(10) NOT NULL default '0',
  PRIMARY KEY  (`keyword_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__keyword_show` (
  `keyword_show_id` int(11) NOT NULL auto_increment,
  `show_code` varchar(100) NOT NULL,
  `keyword_content` text NOT NULL,
  `keyword_url` text NOT NULL,
  PRIMARY KEY  (`keyword_show_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__language` (
  `language_id` int(11) NOT NULL auto_increment,
  `language_sign` varchar(20) NOT NULL,
  `language_path` varchar(20) NOT NULL,
  `language_sort` int(11) NOT NULL default '0',
  `language_state` enum('0','1') NOT NULL default '0',
  `language_name` varchar(20) NOT NULL,
  PRIMARY KEY  (`language_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__link` (
  `link_id` int(11) NOT NULL auto_increment,
  `link_title` varchar(100) default NULL,
  `link_url` varchar(255) default NULL,
  `link_pic` varchar(255) default NULL,
  `link_close` enum('0','1') NOT NULL default '0',
  `link_state` enum('0','1') NOT NULL default '0',
  `link_sort` int(11) NOT NULL default '0',
  `link_type` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`link_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__mailcontent` (
  `mail_id` int(10) unsigned NOT NULL auto_increment,
  `genre` varchar(40) default NULL,
  `ifopen` enum('0','1') NOT NULL default '0',
  `title` varchar(255) default NULL,
  `maildesc` text,
  `content` text,
  `ifsystem` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`mail_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__member` (
  `member_id` int(10) unsigned NOT NULL auto_increment,
  `login_name` varchar(50) NOT NULL,
  `password` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `member_state` enum('0','1','2') NOT NULL default '1',
  `member_type` enum('0','1') NOT NULL default '0',
  `regist_time` int(11) NOT NULL,
  `last_login_time` int(10) default '0',
  PRIMARY KEY  (`member_id`),
  KEY `member_id` (`member_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__member_extend` (
  `extend_id` int(10) unsigned NOT NULL auto_increment,
  `member_id` int(10) unsigned NOT NULL,
  `true_name` varchar(30) default NULL,
  `gender` enum('m','f') NOT NULL default 'm',
  `birthday` varchar(20) default NULL,
  `province` varchar(50) default NULL,
  `city` varchar(50) default NULL,
  `address` varchar(200) default NULL,
  `zip` varchar(6) default NULL,
  `mobilephone` varchar(15) default NULL,
  `phone` varchar(15) default NULL,
  `otherphone` varchar(15) default NULL,
  `alipay` varchar(100) default NULL,
  `QQ` varchar(11) default NULL,
  `MSN` varchar(50) default NULL,
  `SKYPE` varchar(50) default NULL,
  `TAOBAO` varchar(50) default NULL,
  `buy_score_instant` int(11) NOT NULL default '0',
  `sale_score_instant` int(11) NOT NULL default '0',
  `buy_score_offline` int(11) NOT NULL default '0',
  `sale_score_offline` int(11) NOT NULL default '0',
  `buy_score` int(11) NOT NULL default '0',
  `sale_score` int(11) NOT NULL default '0',
  `sell_product_count` int(10) unsigned NOT NULL default '0',
  `recommend_product_count` int(10) unsigned NOT NULL default '0',
  `recommend_max_count` int(10) NOT NULL default '10',
  `offline` varchar(100) default NULL,
  `tenpay` varchar(100) default NULL,
  `paypal` varchar(100) default NULL,
  `product_show_time` int(10) default NULL,
  `product_number` int(10) default NULL,
  `shop_availability_time` int(10) default NULL,
  `available_predeposit` decimal(10,2) unsigned NOT NULL default '0.00',
  `freeze_predeposit` decimal(10,2) NOT NULL default '0.00',
  `personal_certify` enum('0','1','2','3') NOT NULL,
  `personal_certify_identitycard_up` varchar(100) default NULL,
  `personal_certify_identitycard_back` varchar(100) default NULL,
  `personal_certify_deny_reason` text,
  `personal_certify_update_time` int(10) default NULL,
  `area_id` int(11) default NULL,
  `predeposit` varchar(100) default NULL,
  `shop_availability_time_freeze` int(11) default '0',
  `mg_id` int(11) NOT NULL,
  `extcredits_exp` int(11) NOT NULL default '0',
  `extcredits_points` int(11) NOT NULL default '0',
  KEY `extend_id` (`extend_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__member_group` (
  `mg_id` int(11) NOT NULL auto_increment,
  `mg_name` varchar(100) NOT NULL,
  `mg_score_lower` int(11) NOT NULL,
  `mg_score_higher` int(11) NOT NULL,
  `mg_stars` tinyint(3) NOT NULL default '0',
  `mg_iflogin` tinyint(1) NOT NULL default '1',
  `mg_ifbuy` tinyint(1) NOT NULL default '1',
  `mg_ifsell` tinyint(1) NOT NULL default '1',
  `mg_ifopen_shop` tinyint(1) NOT NULL default '1',
  `mg_ifuse_credit` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`mg_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__member_pay_order` (
  `mpo_id` int(11) NOT NULL auto_increment,
  `mpo_code` varchar(32) NOT NULL,
  `mpo_member_id` int(10) NOT NULL,
  `mpo_member_name` varchar(50) NOT NULL,
  `mpo_mode_id` int(10) NOT NULL,
  `mpo_mode` varchar(100) NOT NULL,
  `mpo_money` decimal(9,2) NOT NULL,
  `mpo_currency` varchar(10) NOT NULL,
  `mpo_pay_id` int(10) NOT NULL,
  `mpo_pay_name` varchar(10) NOT NULL,
  `mpo_pay_type` enum('1','2') NOT NULL,
  `mpo_pay_sign` enum('1','2') default NULL,
  `mpo_end_time` int(10) default NULL,
  `mpo_on_type` varchar(10) NOT NULL,
  `mpo_shop_time` int(10) default NULL,
  `mpo_product_number` int(10) default NULL,
  `mpo_product_show_time` int(10) default NULL,
  PRIMARY KEY  (`mpo_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__message` (
  `message_id` int(10) unsigned NOT NULL auto_increment,
  `member_name` varchar(50) NOT NULL,
  `receive_name` varchar(50) NOT NULL,
  `title` varchar(255) default NULL,
  `content` text,
  `isnew` enum('0','1') NOT NULL default '0',
  `end_date` varchar(50) default NULL,
  `isallowdel` enum('0','1') default '1',
  `send_time` varchar(50) default NULL,
  `issave` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`message_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__message_system` (
  `message_system_id` int(10) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `send_time` int(10) NOT NULL,
  `send_object` enum('0','1','2') NOT NULL,
  `system_receive_name` varchar(255) default NULL,
  `state` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`message_system_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__news` (
  `news_id` int(11) NOT NULL auto_increment,
  `news_c_id` smallint(6) NOT NULL,
  `news_title` varchar(100) NOT NULL,
  `news_content` text,
  `news_sort` int(11) NOT NULL default '0',
  `news_date` int(11) default NULL,
  `news_jump_url` varchar(255) default NULL,
  PRIMARY KEY  (`news_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__news_class` (
  `news_c_id` smallint(6) NOT NULL auto_increment,
  `news_c_name` varchar(50) NOT NULL,
  PRIMARY KEY  (`news_c_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__news_js` (
  `news_js_id` smallint(6) NOT NULL auto_increment,
  `news_c_id` varchar(100) default NULL,
  `order_by` varchar(100) default NULL,
  `char_num` int(11) NOT NULL default '0',
  `line_num` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`news_js_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__payment_switch_log` (
  `ps_log_id` int(11) NOT NULL auto_increment,
  `ps_date_line` int(11) NOT NULL,
  `ps_type` enum('shoppay') NOT NULL,
  `ps_state` enum('0','1') NOT NULL,
  `ps_ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`ps_log_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__pay_accounts` (
  `pay_id` int(10) NOT NULL auto_increment,
  `pay_name` varchar(30) NOT NULL,
  `pay_ico` text,
  `pay_account` varchar(30) default NULL,
  `pay_consignee` varchar(10) default NULL,
  `pay_type` enum('1','2') NOT NULL,
  PRIMARY KEY  (`pay_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__predeposit_cash` (
  `predeposit_c_id` int(11) NOT NULL auto_increment,
  `member_id` int(11) NOT NULL,
  `payment` varchar(32) NOT NULL,
  `payment_trade` varchar(64) default NULL,
  `payment_type` enum('0','1') NOT NULL,
  `record_state` enum('0','1','2') NOT NULL,
  `pay_account` varchar(64) NOT NULL,
  `pay_bank` varchar(50) default NULL,
  `pay_consignee` varchar(10) default NULL,
  `pay_remark` text,
  `system_remark` text,
  `amount` decimal(10,2) NOT NULL,
  `create_time` int(11) NOT NULL,
  PRIMARY KEY  (`predeposit_c_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__predeposit_detail` (
  `predeposit_id` int(11) NOT NULL auto_increment,
  `predeposit_type` enum('0','1','2','3','4','5','6') NOT NULL,
  `predeposit_state` enum('0','1','2') NOT NULL,
  `member_id` int(11) NOT NULL,
  `available_amount` decimal(10,2) NOT NULL default '0.00',
  `to_member_id` int(11) default NULL,
  `sp_code` varchar(32) default NULL,
  `member_remark` text,
  `system_remark` text,
  `create_time` int(11) NOT NULL,
  `update_time` int(11) NOT NULL,
  `payment` varchar(100) default NULL,
  `freeze_amount` decimal(10,2) NOT NULL default '0.00',
  `predeposit_r_id` int(11) default NULL,
  `predeposit_c_id` int(11) default NULL,
  PRIMARY KEY  (`predeposit_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__predeposit_record` (
  `predeposit_r_id` int(11) NOT NULL auto_increment,
  `member_id` int(11) NOT NULL,
  `payment` varchar(32) NOT NULL,
  `payment_trade` varchar(64) default NULL,
  `sender_name` varchar(50) default NULL,
  `sender_bank` varchar(50) default NULL,
  `sender_amount` varchar(50) default NULL,
  `sender_date` int(11) default NULL,
  `sender_remark` text,
  `payment_type` enum('0','1') NOT NULL,
  `record_state` enum('0','1','2') NOT NULL default '0',
  `pay_name` varchar(30) default NULL,
  `pay_account` varchar(30) default NULL,
  `pay_consignee` varchar(10) default NULL,
  `create_time` int(11) NOT NULL,
  `system_remark` text,
  `online_amount` decimal(10,2) default NULL,
  PRIMARY KEY  (`predeposit_r_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product` (
  `p_id` int(11) unsigned NOT NULL auto_increment,
  `p_name` varchar(100) NOT NULL default '',
  `pc_id` int(11) NOT NULL default '0',
  `theme_id` int(11) NOT NULL default '0',
  `member_id` int(11) NOT NULL default '0',
  `p_code` char(32) NOT NULL,
  `p_price` decimal(10,2) NOT NULL,
  `p_point` int(11) NOT NULL default '0',
  `p_view_num` int(11) NOT NULL default '0',
  `p_start_time` int(10) default NULL,
  `p_end_time` int(10) default NULL,
  `p_valid_days` tinyint(2) default NULL,
  `p_storage` int(6) NOT NULL default '0',
  `p_state` enum('0','1') NOT NULL default '0',
  `p_pic` varchar(100) default '',
  `p_intro` text NOT NULL,
  `p_add_time` int(10) NOT NULL,
  `p_update_time` int(10) NOT NULL,
  `p_auto_publish` enum('0','1') NOT NULL default '1',
  `p_sell_type` enum('0','1','2') NOT NULL default '1',
  `p_type` enum('0','1','2') NOT NULL default '0',
  `p_group_price` decimal(10,2) default NULL,
  `p_group_mincount` int(5) default NULL,
  `p_cur_price` decimal(8,2) default '0.00',
  `p_system_step` enum('0','1') default '0',
  `p_price_step` decimal(8,2) default NULL,
  `p_province` varchar(20) default NULL,
  `p_city` varchar(20) default NULL,
  `p_transfee_charge` enum('0','1') NOT NULL default '0',
  `p_have_invoices` enum('0','1') NOT NULL default '0',
  `p_have_warranty` enum('0','1') NOT NULL default '0',
  `p_tf_py` decimal(8,2) default '0.00',
  `p_tf_kd` decimal(8,2) default '0.00',
  `p_tf_ems` decimal(8,2) default '0.00',
  `p_recommended` enum('0','1') NOT NULL default '0',
  `p_remark` text,
  `p_sold_num` int(6) default '0',
  `p_sold_sum` int(6) default '0',
  `p_store_recommended` enum('0','1') NOT NULL default '0',
  `p_class_id` int(10) default '0',
  `p_irregularities` enum('0','1') NOT NULL default '0',
  `p_index` enum('0','1') NOT NULL default '0',
  `p_pay_method` varchar(200) default NULL,
  `p_currency_category` varchar(100) NOT NULL default 'CNY',
  `p_predeposit_state` enum('0','1') default NULL,
  `p_area_id` int(11) default NULL,
  `p_ifnopub` int(11) NOT NULL default '0',
  `p_bid_num` int(11) NOT NULL default '0',
  `p_pb_id` int(11) default NULL,
  `p_genuine` tinyint(1) NOT NULL default '0',
  `p_7day_return` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`p_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_attributes` (
  `pac_id` int(11) unsigned NOT NULL auto_increment,
  `a_id` int(11) NOT NULL,
  `p_id` char(32) NOT NULL,
  `pac_content` varchar(50) NOT NULL,
  `pac_order` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`pac_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_brand` (
  `pb_id` int(11) NOT NULL auto_increment,
  `pb_u_id` int(11) NOT NULL default '0',
  `pb_name` varchar(100) NOT NULL,
  `pb_sort` int(11) NOT NULL default '0',
  `pb_state` enum('0','1') NOT NULL default '0',
  `pb_path` varchar(100) NOT NULL default '0',
  `pb_deeppath` int(11) NOT NULL default '1',
  PRIMARY KEY  (`pb_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_class` (
  `pc_id` int(11) unsigned NOT NULL auto_increment,
  `pc_u_id` int(11) NOT NULL default '0',
  `pc_name` varchar(100) NOT NULL default '',
  `pc_state` enum('0','1') NOT NULL default '1',
  `pc_intro` text NOT NULL,
  `pc_pic` varchar(100) default '',
  `pc_sort` int(11) NOT NULL default '0',
  `is_highlight` enum('0','1') NOT NULL default '0',
  `pc_deeppath` int(11) NOT NULL default '0',
  PRIMARY KEY  (`pc_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_message` (
  `message_id` int(10) unsigned NOT NULL auto_increment,
  `member_name` varchar(50) NOT NULL,
  `message_content` text NOT NULL,
  `message_recontent` text,
  `product_id` int(10) unsigned NOT NULL,
  `product_code` char(32) NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  `message_time` varchar(50) NOT NULL,
  `re_time` varchar(50) default NULL,
  `anonymous` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`message_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_pic` (
  `p_pic_id` int(11) NOT NULL auto_increment,
  `p_pic` varchar(100) NOT NULL,
  `p_code` char(32) NOT NULL,
  PRIMARY KEY  (`p_pic_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_pic_cache` (
  `p_pic_c_id` int(10) NOT NULL auto_increment,
  `p_pic_cache` varchar(100) NOT NULL,
  PRIMARY KEY  (`p_pic_c_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_sold` (
  `sp_id` int(12) unsigned NOT NULL auto_increment,
  `sp_code` char(32) NOT NULL,
  `seller_id` int(11) default NULL,
  `buyer_id` int(11) default NULL,
  `p_name` varchar(100) NOT NULL,
  `p_code` varchar(32) NOT NULL,
  `pc_id` int(11) default NULL,
  `unit_price` decimal(9,2) NOT NULL default '0.00',
  `buy_num` int(6) NOT NULL default '1',
  `tf_type` enum('1','2','3') default NULL,
  `tf_fee` decimal(9,2) NOT NULL default '0.00',
  `total_price` decimal(9,2) NOT NULL default '0.00',
  `sell_type` enum('0','1','2') NOT NULL default '1',
  `receive_code` varchar(32) NOT NULL,
  `p_pic` varchar(255) default NULL,
  `sp_html` longtext,
  `sp_state` enum('0','1','2','3','4','5','6') NOT NULL default '0',
  `sold_time` int(10) NOT NULL,
  `pay_time` int(10) default NULL,
  `deliver_time` int(10) default NULL,
  `receive_time` int(10) default NULL,
  `sole_have_comment` enum('0','1') NOT NULL default '0',
  `buy_have_comment` enum('0','1') NOT NULL,
  `sp_del` enum('0','1') NOT NULL default '0',
  `anonymous` enum('0','1') NOT NULL default '0',
  `leaveword` text,
  `alipay_id` varchar(100) default NULL,
  `sp_pay_mechod` varchar(20) default NULL,
  `sp_offline_bought` enum('0','1','2') NOT NULL default '0',
  `sp_offline_sold` enum('0','1','2') NOT NULL default '0',
  `sp_currency_category` varchar(10) NOT NULL default 'CNY',
  `close_reason` varchar(100) default NULL,
  PRIMARY KEY  (`sp_id`)
) ENGINE=MyISAM ;

CREATE TABLE `#__receive` (
  `receive_id` int(10) unsigned NOT NULL auto_increment,
  `receive_code` varchar(32) default NULL,
  `member_id` int(10) unsigned NOT NULL,
  `receive_name` varchar(50) default NULL,
  `province` varchar(100) default NULL,
  `city` varchar(100) default NULL,
  `address` varchar(255) default NULL,
  `mobilephone` varchar(12) default NULL,
  `phone` varchar(25) default NULL,
  `zip` varchar(8) default NULL,
  `receive_area_id` int(11) default NULL,
  PRIMARY KEY  (`receive_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__remind` (
  `remind_id` int(10) NOT NULL auto_increment,
  `member_id` int(10) NOT NULL,
  `login_name` varchar(50) NOT NULL,
  `date_line` int(10) NOT NULL,
  `sale_product_move` varchar(10) default NULL,
  `sale_product_del` varchar(10) default NULL,
  `sale_product_down` varchar(10) default NULL,
  `sale_order_succ` varchar(10) default NULL,
  `sale_order_bid_nosucc` varchar(10) default NULL,
  `sale_order_team_insufficient` varchar(10) default NULL,
  `sale_message_product` varchar(10) default NULL,
  `sale_message_shop` varchar(10) default NULL,
  `sale_buyer_to_succ` varchar(10) default NULL,
  `sale_shop_3_month_unreach_10` varchar(10) default NULL,
  `sale_shop_5_month_unreach_10` varchar(10) default NULL,
  `sale_shop_6_month_unreach_10` varchar(10) default NULL,
  `buyer_bid_above_notice` varchar(10) default NULL,
  `buyer_bid_above_no_num` varchar(10) default NULL,
  `buyer_bid_succ_notice` varchar(10) default NULL,
  `buyer_bid_over_no_num` varchar(10) default NULL,
  `buyer_buy_succ_notice` varchar(10) default NULL,
  `buyer_message_seller_product_answer` varchar(10) default NULL,
  `buyer_message_seller_shop_answer` varchar(10) default NULL,
  `buyer_sale_to_succ` varchar(10) default NULL,
  `buyer_team_unsucc` varchar(10) default NULL,
  `buyer_team_no_pay` varchar(10) default NULL,
  `score_have_notice` varchar(10) default NULL,
  `complaint_receive_notice` varchar(10) default NULL,
  `complaint_handling_notice` varchar(10) default NULL,
  `complaint_other_answer_notice` varchar(10) default NULL,
  PRIMARY KEY  (`remind_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__score` (
  `score_id` int(10) unsigned NOT NULL auto_increment,
  `order_id` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  `grade_member_id` int(10) unsigned NOT NULL,
  `genre` enum('b','s') NOT NULL,
  `score` int(10) NOT NULL,
  `pubtime` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `modify_reason` varchar(255) default NULL,
  `modify_time` varchar(50) default NULL,
  `score_pay_type` enum('1','2','3') NOT NULL default '1',
  PRIMARY KEY  (`score_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__section` (
  `section_id` int(11) NOT NULL auto_increment,
  `section_name` varchar(100) default NULL,
  `section_content` text,
  `section_url` varchar(100) default NULL,
  `is_show` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`section_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__settings` (
  `variable` varchar(30) NOT NULL,
  `section` varchar(30) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY  (`variable`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_class` (
  `class_id` smallint(5) unsigned NOT NULL auto_increment,
  `class_name` varchar(255) NOT NULL,
  `class_state` enum('0','1') NOT NULL default '0',
  `parent_id` smallint(5) unsigned NOT NULL default '0',
  `class_sort` smallint(5) unsigned NOT NULL default '0',
  `class_property` enum('0','1','2') NOT NULL default '0',
  PRIMARY KEY  (`class_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_info` (
  `shop_id` int(10) unsigned NOT NULL auto_increment,
  `member_id` int(10) unsigned NOT NULL,
  `shop_name` varchar(100) NOT NULL,
  `shop_class` smallint(5) unsigned NOT NULL,
  `sale_range` varchar(255) default NULL,
  `shop_province` varchar(20) default NULL,
  `shop_city` varchar(20) default NULL,
  `shop_intro` text,
  `shop_pic` varchar(100) default NULL,
  `identity_card_copy_up` varchar(100) default NULL,
  `identity_card_copy_back` varchar(100) default NULL,
  `license_copy` varchar(100) default NULL,
  `proclamation` text,
  `practice_time` varchar(50) NOT NULL,
  `shop_level` enum('0','1') NOT NULL default '0',
  `templates` enum('0','1') NOT NULL,
  `shop_style` text,
  `recommend_product_count` int(10) unsigned NOT NULL default '0',
  `ischeck` enum('0','1','2') NOT NULL default '0',
  `audit_state` enum('0','1','2','3') NOT NULL default '0',
  `shop_domain` varchar(8) default NULL,
  `shop_index` enum('0','1') NOT NULL default '0',
  `positionX` int(10) unsigned default '0',
  `positionY` int(10) unsigned default '0',
  `positionZ` int(2) unsigned default '0',
  `positionC` varchar(50) default NULL,
  `shop_banner_pic` varchar(100) default NULL,
  `shop_area_id` int(11) default NULL,
  `if_del` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`shop_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_link` (
  `link_id` int(10) unsigned NOT NULL auto_increment,
  `shop_id` int(10) unsigned NOT NULL,
  `link_shop_id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`link_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_message` (
  `message_id` int(10) unsigned NOT NULL auto_increment,
  `member_name` varchar(50) NOT NULL,
  `message_content` text NOT NULL,
  `message_recontent` text,
  `shop_id` int(10) unsigned NOT NULL,
  `message_time` varchar(50) NOT NULL,
  `re_time` varchar(50) default NULL,
  PRIMARY KEY  (`message_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_pay_detail` (
  `pay_detail_id` int(10) NOT NULL auto_increment,
  `member_id` int(10) NOT NULL,
  `pay_sign` enum('0','1','2','3') NOT NULL,
  `pay_id` int(10) default NULL,
  `pay_name` varchar(30) NOT NULL,
  `pay_account` varchar(30) default NULL,
  `pay_consignee` varchar(10) default NULL,
  `pay_type` enum('1','2') NOT NULL,
  `date_line` int(10) default NULL,
  `pay_mode_id` int(11) NOT NULL,
  `pay_mode_name` varchar(100) NOT NULL,
  `pay_mode_type` enum('0','1','2') NOT NULL,
  `pay_mode_money` decimal(10,2) NOT NULL,
  `pay_mode_product_number` int(10) default NULL,
  `pay_mode_shop_show_time` int(10) default NULL,
  `pay_mode_remark` text,
  `payment_trade` varchar(64) default NULL,
  `system_remark` text,
  `sender_number` varchar(64) default NULL,
  PRIMARY KEY  (`pay_detail_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_pay_mode` (
  `mode_id` int(10) NOT NULL auto_increment,
  `mode_name` varchar(100) NOT NULL,
  `mode_type` enum('0','1','2') NOT NULL,
  `mode_money` decimal(10,2) NOT NULL,
  `mode_product_number` int(10) default NULL,
  `mode_shop_show_time` int(10) default NULL,
  `mode_remark` text,
  PRIMARY KEY  (`mode_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_product_class` (
  `class_id` int(10) unsigned NOT NULL auto_increment,
  `class_name` varchar(255) NOT NULL,
  `class_parent_id` int(11) NOT NULL default '0',
  `class_pic` varchar(100) default NULL,
  `class_if_open` enum('0','1') NOT NULL default '0',
  `class_sort` smallint(5) unsigned NOT NULL,
  `shop_id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`class_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_tag` (
  `tag_id` int(10) unsigned NOT NULL auto_increment,
  `shop_id` int(10) unsigned NOT NULL default '0',
  `tag_name` varchar(50) NOT NULL,
  `tag_url` varchar(200) default NULL,
  `tag_content` text,
  `tag_display` tinyint(1) unsigned NOT NULL default '0',
  `tag_sort` tinyint(1) unsigned NOT NULL default '0',
  `tag_time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`tag_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__system_group` (
  `sys_group_id` int(11) NOT NULL auto_increment,
  `sys_group_name` varchar(50) NOT NULL,
  `sys_group_area_province` varchar(20) default NULL,
  `sys_group_area_city` varchar(20) default NULL,
  `sys_group_power` text,
  `sys_group_area_id` int(11) default NULL,
  PRIMARY KEY  (`sys_group_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__system_log` (
  `sys_log_id` int(11) NOT NULL auto_increment,
  `sys_member_id` int(11) NOT NULL,
  `sys_login_name` varchar(50) NOT NULL,
  `sys_log_note` varchar(255) NOT NULL,
  `sys_log_time` int(10) NOT NULL,
  `sys_log_ip` varchar(20) default NULL,
  PRIMARY KEY  (`sys_log_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__system_member` (
  `sys_member_id` int(11) NOT NULL auto_increment,
  `sys_login_name` varchar(50) NOT NULL,
  `sys_password` varchar(32) NOT NULL,
  `sys_group_id` int(11) NOT NULL,
  `sys_login_num` int(11) NOT NULL default '0',
  `sys_login_time` int(10) NOT NULL,
  `sys_email` varchar(100) NOT NULL,
  `sys_login_ip` varchar(20) default NULL,
  PRIMARY KEY  (`sys_member_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__vote` (
  `vote_id` int(11) NOT NULL auto_increment,
  `vote_title` varchar(255) default NULL,
  `vote_refresh` enum('0','1') NOT NULL default '0',
  `vote_member` enum('0','1') NOT NULL default '0',
  `vote_content` text,
  `vote_check` enum('0','1') NOT NULL default '0',
  `vote_state` enum('0','1') NOT NULL default '0',
  `vote_close` enum('0','1') NOT NULL default '0',
  `vote_start_date` int(10) NOT NULL default '0',
  `vote_end_date` int(10) NOT NULL default '0',
  `vote_date` int(10) NOT NULL default '0',
  PRIMARY KEY  (`vote_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__vote_show` (
  `vote_show_id` int(11) NOT NULL auto_increment,
  `show_name` varchar(10) NOT NULL default '0',
  `vote_id` int(11) NOT NULL default '0',
  `show_sort` int(11) NOT NULL default '0',
  PRIMARY KEY  (`vote_show_id`)
) ENGINE=MyISAM;

INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(1, 'orange_index_adv', 2, 'attachments/jpg/2008/11/22/122732849749278bf1f053a.jpg', 'http://www.shopnc.net', 'orange_index_adv', 1227283200, 1258905599, '420', '260', '0', 0);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(2, 'top_adv', 0, 'attachments/gif/2008/11/22/122732891649278d94c28ce.gif', 'http://www.shopnc.net', 'top_adv', 1227283200, 1258905599, '170', '68', '0', 0);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(3, 'top_adv_one', 0, 'attachments/gif/2008/11/22/122732895449278dba35680.gif', 'http://www.shopnc.net', 'top_adv', 1227283200, 1258905599, '170', '68', '0', 1);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(4, 'top_adv_two', 0, 'attachments/gif/2008/11/22/122732898849278ddc4c4b6.gif', 'http://www.shopnc.net', 'top_adv', 1227283200, 1258905599, '170', '68', '0', 2);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(5, 'top_adv_three', 0, 'attachments/gif/2008/11/22/122732901549278df76ea08.gif', 'http://www.shopnc.net', 'top_adv', 1227283200, 1258905599, '170', '68', '0', 3);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(6, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274104904928cc3aa037d.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 0);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(7, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274105154928cc537de2c.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 1);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(8, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274105404928cc6c31978.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 2);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(9, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274105764928cc90e4e1e.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 3);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(10, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274105994928cca7ca2e0.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 4);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(11, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274106214928ccbd89547.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 5);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(12, 'index_channel', 0, 'attachments/jpg/2008/11/23/12274118044928d15c57bd1.jpg', 'http://www.shopnc.net', 'index_channel', 1227369600, 1258991999, '500', '180', '0', 0);

INSERT INTO `#__area` (`area_id`, `area_name`, `area_intro`, `area_parent_id`, `area_sort`, `area_path_string`, `area_deeppath`) VALUES (1, '', '', 0, 0, ',0,', 1);
INSERT INTO `#__area` (`area_id`, `area_name`, `area_intro`, `area_parent_id`, `area_sort`, `area_path_string`, `area_deeppath`) VALUES (2, 'Ͽ', 'Ͽ', 1, 0, ',0,1,', 2);

INSERT INTO `#__app_module` (`app_module_id`, `app_module_name`, `app_module_sign`, `app_module_state`, `app_module_sort`, `app_module_install`, `app_module_sys_path`, `app_module_path`, `app_module_first_install`, `app_module_show`) VALUES (1, '', 'supply', '0', 0, '0', 'system', 'supply', '0', '0');
INSERT INTO `#__app_module` (`app_module_id`, `app_module_name`, `app_module_sign`, `app_module_state`, `app_module_sort`, `app_module_install`, `app_module_sys_path`, `app_module_path`, `app_module_first_install`, `app_module_show`) VALUES (2, 'Ntalker', 'ntalker', '0', 0, '0', 'system', 'ntalker', '0', '1');
INSERT INTO `#__app_module` (`app_module_id`, `app_module_name`, `app_module_sign`, `app_module_state`, `app_module_sort`, `app_module_install`, `app_module_sys_path`, `app_module_path`, `app_module_first_install`, `app_module_show`) VALUES (3, 'ֻ', 'credits_act', '0', 0, '0', 'system', 'credits_act', '0', '0');
INSERT INTO `#__app_module` (`app_module_id`, `app_module_name`, `app_module_sign`, `app_module_state`, `app_module_sort`, `app_module_install`, `app_module_sys_path`, `app_module_path`, `app_module_first_install`, `app_module_show`) VALUES (4, 'Առ', 'space', '0', 0, '0', 'system', 'space', '0', '0');

INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(1, 'CNY', 100.00, '1', '');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(2, 'USD', 694.08, '1', 'Ԫ');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(3, 'GBP', 1370.53, '1', '¹');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(4, 'JPY', 6.67, '1', 'Ԫ');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(5, 'CAD', 699.04, '1', 'ôԪ');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(6, 'EUR', 1089.36, '1', 'ŷԪ');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(7, 'HKD', 100.00, '0', 'Ԫ');

INSERT INTO `#__language` (`language_id`, `language_sign`, `language_path`, `language_sort`, `language_state`, `language_name`) VALUES(1, 'zh-cn', 'zh-cn', 1, '1', '');
INSERT INTO `#__language` (`language_id`, `language_sign`, `language_path`, `language_sort`, `language_state`, `language_name`) VALUES(2, 'zh', 'zh', 2, '0', '');

INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_close`, `link_state`, `link_sort`, `link_type`) VALUES(1, 'ShopNC', 'http://www.shopnc.net', 'attachments/gif/2008/11/22/122190001048d4b6ea0f688.gif', '0', '0', 0, '0');
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_close`, `link_state`, `link_sort`, `link_type`) VALUES(2, 'Discuz!', 'http://www.discuz.net/', 'attachments/gif/2008/11/22/122190001048d4b6ea0f690.gif', '0', '0', 0, '0');
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_close`, `link_state`, `link_sort`, `link_type`) VALUES(3, 'վֲ', 'http://zz.comsenz.com/', 'attachments/gif/2008/11/22/122190001048d4b6ea0f691.gif', '0', '0', 0, '0');
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_close`, `link_state`, `link_sort`, `link_type`) VALUES(4, 'Ntalker', 'http://www.ntalker.com/', 'attachments/gif/2008/11/22/122190001048d4b6ea0f689.gif', '0', '0', 0, '0');

INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (1, 'forget', '0', '{website}һ', '˵:ʼģ,趨ʼݱ( {XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı:{website} վ{username} ˺{newpass} {site_url} ַ', '<p>װ{username} ã</p><p>ĻԱ˺ǣ{username}</p><p>ǣ{newpass}</p><p>룡</p><p>&nbsp;</p><p>{website} ͷ </p>', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (2, 'regist', '0', '{sitename}עȷ', '˵:ʼģ,趨ʼݱ( {XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı:\r\n\r\n{sitename} վ\r\n\r\n{username} ˺\r\n\r\n{passwd} \r\n\r\n', 'װĻԱãлע{sitename}Ա˺ţ {username}룺{passwd}{sitename} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (3, 'modipass', '0', '{website}޸֪ͨ', '˵:ʼģ,趨ʼݱ( {XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı:\r\n\r\n{website} վ\r\n\r\n{username} ˺\r\n\r\n{newpass} \r\n\r\n{site_url} ַ \r\n', 'װ{username}\r\n\r\n{website}Ѿ޸ĳɹܺ\r\n\r \nǣ{newpass}\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (4, 'shopreply', '0', '{shopname}ѻظ', '˵:ʼģ,趨ʼݱ( {XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı:\r\n\r\n{website} վ\r\n\r\n{shopname} ̵\r\n\r\n{question} ˿\r\n\r\n{messagetime} ʱ\r\n\r\n{reply} ظ\r\n\r\n{username} Ա\r\n\r\n{mastername} ƹ\r\n\r\n', 'װ{username},:\r\n\r\nܸԱվĲ,{shopname}ѻظ\r \n\r\n:{question}\r\n\r\nʱ:{messagetime}\r\n\r\nƹ{mastername}Ļظ{reply}\r\n\r \n{website}ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (5, 'productreplay', '0', '{website}Ʒѻظ', '˵:ʼģ,趨ʼݱ({XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı:\r\n\r\n{website} վ\r\n\r\n{productname} Ʒ\r\n\r\n{producturl} Ʒ\r\n\r\n{question} ˿\r\n\r\n{messagetime} ʱ\r\n\r\n{reply} ظ\r\n\r\n{username} Ա\r\n\r\n{mastername} ƹ\r\n', 'װ{username},:\r\n\r\nܸԱվĲ,{productname}ѻظ\r n\r\n:{question}\r\n\r\nʱ:{messagetime}\r\n\r\nƹ{mastername}Ļظ{reply}\r\n\r \n{website}ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (6, 'product_move', '0', 'ƷƵĿ¼', '˵:ʼģ,趨ʼݱ( {XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{username} ˺\r\n{product_name} Ʒ\r\n{class_name} Ŀ¼\r\n{site_url} ַ', 'װ{username} ã\r\n\r\nƷ{product_name} ϵͳתƵ{class_name}Ŀ¼\r\n\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (7, 'product_del', '0', 'Ʒϵͳɾ', 'ʼģ,趨ʼݱ({XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{site_url} ַ \r\n\r\n', '\r\n\r\nװ{username} ã\r\nƷ{product_name} Ѿϵͳɾ\r\n{website} ͷ\r\n\r\n', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (8, 'product_down', '0', 'Ʒϵͳ¼', 'ʼģ,趨ʼݱ({XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{site_url} ַ \r\n', '\r\n\r\nװ{username} ã\r\nƷ{product_name} Ѿϵͳ¼\r\n{website} ͷ\r\n\r\n', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (9, 'message_product', '0', 'Ʒ{product_name}ҽ', 'ʼģ,趨ʼݱ({XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{product_name} ˺\r\n{site_url} ַ', 'װ{username} ã\r\n\r\nƷ{product_name} ҽԣ뼰ʱظ\r\n\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (10, 'message_shop', '0', '', 'ʼģ,趨ʼݱ({XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{site_url} ַ', 'װ{username} ã\r\n\r\nҽԣ뼰ʱ鿴\r\n\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (11, 'buyer_to_succ', '0', 'Ʒ˹뼰ʱ鿴', 'ʼģ,趨ʼݱ( {XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \n{website} վ\n{product_name}Ʒ\n{site_url} ַ', 'װ{username} ãƷ{product_name}˹ˣ뼰ʱ鿴{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (12, 'message_seller_product_answer', '0', '{product_name}ϵѾظ', 'ʼģ,趨ʼݱ({XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{product_name} Ʒ\r\n{site_url} ַ', 'װ{username} ã\r\n\r\n{product_name}ϵѾظ,뼰ʱ鿴\r\n\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (13, 'sale_to_succ', '0', 'Ʒѷ뼰ʱ', 'ʼģ,趨ʼݱ( {XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı:\r\n{website} վ\r\n{product_name}Ʒ\r\n{site_url} ַ\r\n', 'װ{username} ã\r\n\r\nƷ{product_name}ѷ뼰ʱ\r\n\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (14, 'score_have_notice', '0', 'Ľ׶ԷѾ', 'ʼģ,趨ʼݱ( {XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{product_name}Ʒ\r\n{site_url} ַ', 'װ{username} ã\r\n\r\n{ףproduct_name}ԷѾˣ뼰ʱ鿴ҲǸԷ۰\r\n\r\n {website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (15, 'complaint_receive_notice', '0', 'лԱͶ/ٱ', 'ʼģ,趨ʼݱ({XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{username}Ʒ\r\n{site_url} ַ1', 'װ{username} ã\r\n\r\nлԱͶ/ٱ ʱ鿴 ҵ̳-->ͻ-->Ͷ/ٱĿ\r\n\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (16, 'complaint_handling_notice', '0', 'յͶ߾ٱϣ뼰ʱ鿴', 'ʼģ,趨ʼݱ({XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{username}û\r\n{site_url} ַ', 'װ{username} ã\r\n\r\nյͶ߾ٱϣ뼰ʱ鿴 ҵ̳-->ͻ-->Ͷ/ٱĿ\r\n\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (17, 'complaint_other_answer_notice', '0', 'Ͷ/ٱ󣬶Է', 'ʼģ,趨ʼݱ({XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{username}Ա\r\n{site_url} ַ1', 'װ{username} ã\r\n\r\nͶ/ٱ󣬶Էߣʱ鿴 ҵ̳-->ͻ-->Ͷ/ٱĿ\r\n\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (18, 'order_succ', '0', 'Ʒѱһڼĵ', 'ʼģ,趨ʼݱ({XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{product_name} Ʒ\r\n{site_url} ַ', 'װ{username} ã\r\n\r\nƷ {product_name} һڼĵã鿴׼¼\r\n\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (19, 'bid_above_notice', '0', 'ĳѱ˳', '˵:ʼģ,趨ʼݱ( {XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{product_name} Ʒ \r\n{site_url} ַ', 'װ{username} ã\r\n\r\nĵƷ{product_name} ľļ۸Ѿ˳뼰ʱ鿴\r\n\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (20, 'buyer_buy_succ_notice', '0', 'ѳɹ{product_name}', 'ʼģ,趨ʼݱ({XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı: \r\n{website} վ\r\n{product_name}Ʒ\r\n{site_url} ַ', 'װ{username} ã\r\n\r\nѾͨһڼ۳ɹ{product_name}뼰ʱ鿴\r\n\r\n{website} ͷ', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (21, 'recommendmail', '0', 'ѸƼƷ', '˵:ʼģ,趨ʼݱ( {XXXX}),ڷʼʱ,ϵͳʵֵ滻,ģı:\r\n{receive_name}\r\n{product_url}Ʒ\r\n{content}\r\n{website} վ\r\n{site_url} ַ', 'װ{receive_name} ã<br />\r\n{content}<br />\r\nƷӣ{product_url}<br />\r\n{website} ͷ', '0');

INSERT INTO `#__member_group` (`mg_id`, `mg_name`, `mg_score_lower`, `mg_score_higher`, `mg_stars`, `mg_iflogin`, `mg_ifbuy`, `mg_ifsell`, `mg_ifopen_shop`, `mg_ifuse_credit`) VALUES (1, 'ƽ', -999999999, 0, 1, 0, 1, 1, 1, 1);
INSERT INTO `#__member_group` (`mg_id`, `mg_name`, `mg_score_lower`, `mg_score_higher`, `mg_stars`, `mg_iflogin`, `mg_ifbuy`, `mg_ifsell`, `mg_ifopen_shop`, `mg_ifuse_credit`) VALUES (2, 'ͨû', 0, 1000, 2, 1, 1, 1, 1, 1);
INSERT INTO `#__member_group` (`mg_id`, `mg_name`, `mg_score_lower`, `mg_score_higher`, `mg_stars`, `mg_iflogin`, `mg_ifbuy`, `mg_ifsell`, `mg_ifopen_shop`, `mg_ifuse_credit`) VALUES (3, 'мû', 1000, 3000, 3, 1, 1, 1, 1, 1);
INSERT INTO `#__member_group` (`mg_id`, `mg_name`, `mg_score_lower`, `mg_score_higher`, `mg_stars`, `mg_iflogin`, `mg_ifbuy`, `mg_ifsell`, `mg_ifopen_shop`, `mg_ifuse_credit`) VALUES (4, '߼û', 3000, 5000, 4, 1, 1, 1, 1, 1);
INSERT INTO `#__member_group` (`mg_id`, `mg_name`, `mg_score_lower`, `mg_score_higher`, `mg_stars`, `mg_iflogin`, `mg_ifbuy`, `mg_ifsell`, `mg_ifopen_shop`, `mg_ifuse_credit`) VALUES (5, 'רû', 5000, 999999999, 5, 1, 1, 1, 1, 1);

INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (7, 1, 'עΪShopNCĻԱ', '<p>עΪShopNCĻԱ</p><p>עΪShopNCĻԱ</p><p>עΪShopNCĻԱ</p><p>עΪShopNCĻԱ</p><p>&nbsp;</p>', 0, 1217142113, '');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (8, 1, 'ShopNC̣', '<p>ShopNC̣</p>', 1, 1216257662, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (9, 1, 'ιShopNCû汾', '<p>ιShopNCû汾</p>', 2, 1216257680, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (10, 2, 'ShopNC°汾', '<p>ShopNC°汾</p>', 0, 1216259106, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (11, 2, 'ShopNCѣ', '<p>ShopNCѣ</p>', 1, 1216258945, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (12, 2, '', '<p></p>', 2, 1216258968, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (13, 2, 'ֵͻֺ', '<p>ֵͻֺ</p>', 3, 1216258988, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (14, 3, 'ٴպ1', '<p>ٴպ1۰ٴպ1۰ٴպ1۰ٴպ1۰ٴպ1۰ٴպ1۰ٴպ1۰ٴպ1۰ٴպ1۰ٴպ1۰ٴպ1۰ٴպ1۰ٴպ1۰ٴպ1</p>', 0, 1221723979, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (15, 3, '8պҾ1', '<p>8պҾ18պҾ18պҾ18պҾ18պҾ18պҾ18պҾ18պҾ1</p>', 1, 1221723995, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (16, 3, '18ҴС', '<p>18ҴС꾭18ҴС꾭18ҴС꾭18ҴС꾭18ҴС꾭18ҴС</p>', 2, 1221724007, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (17, 3, 'Ʒװһһ2', '<p>Ʒװһһ2Ʒװһһ2Ʒװһһ2Ʒװһһ2Ʒװһһ2Ʒװһһ2Ʒװһһ2</p>', 3, 1221724021, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (18, 3, 'T', '<p>TTTTTTTT</p>', 4, 1221724040, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (19, 3, 'Ʊ70Ԫ', '<p>Ʊ70Ԫ𾪱Ʊ70Ԫ𾪱Ʊ70Ԫ𾪱Ʊ70Ԫ𾪱Ʊ70Ԫ𾪱Ʊ70Ԫ</p>', 5, 1221724052, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (20, 3, 'Ь1', '<p>Ь1Ь1Ь1Ь1Ь1Ь1Ь1Ь1</p>', 6, 1221724069, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (21, 3, 'ҷĳ,200100', '<p>ҷĳ,200100ҷĳ,200100ҷĳ,200100ҷĳ,200100ҷĳ,200100ҷĳ,200100</p>', 7, 1221724083, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (22, 4, 'ShopNC2.5°汾', '', 0, 1249022578, 'http://www.multibuy.cn');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (23, 4, 'ShopNCDiscuz!Ȩ', '<p>ShopNCDiscuz!Ȩ</p>', 1, 1249022695, '');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (24, 4, '̳', '', 2, 1249022733, 'http://www.shopnc.net/forum/');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (25, 5, 'ϸѡƷ ϵ', '<p>ϸѡƷ ϵϸѡƷ ϵϸѡƷ ϵϸѡƷ ϵϸѡƷ ϵϸѡƷ ϵϸѡƷ ϵϸѡƷ ϵϸѡƷ ϵϸѡƷ ϵϸѡƷ ϵ</p>', 0, 1221725337, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (26, 5, 'ȷϹ ѡ֧ʽ', '<p>ȷϹ ѡ֧ʽȷϹ ѡ֧ʽȷϹ ѡ֧ʽȷϹ ѡ֧ʽȷϹ ѡ֧ʽȷϹ ѡ֧ʽȷϹ ѡ֧ʽȷϹ ѡ֧ʽȷϹ ѡ֧ʽȷϹ ѡ֧ʽ</p>', 1, 1221725349, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (27, 5, 'ȷջ ʵ', '<p>ȷջ ʵȷջ ʵȷջ ʵȷջ ʵȷջ ʵȷջ ʵȷջ ʵȷջ ʵȷջ ʵ</p>', 2, 1221725686, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (28, 6, 'Ϊ ϴƷ', '<p>Ϊ ϴƷΪ ϴƷΪ ϴƷΪ ϴƷΪ ϴƷΪ ϴƷ</p>', 0, 1221725725, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (29, 6, ' տ', '<p> տ۹ տ۹ տ۹ տ۹ տ۹ տ</p>', 1, 1221725738, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (30, 6, 'Ƽ ʹ', '<p>Ƽ ʹƼ ʹƼ ʹƼ ʹƼ ʹƼ ʹƼ ʹ</p>', 2, 1221725750, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (31, 7, 'Žůν', '<p>ŽůνлŽůνлŽůνлŽůνлŽůνлŽůν</p>', 0, 1221890712, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (32, 7, 'ɹ޸ѡЬ', '<p>ɹ޸ѡЬɹ޸ѡЬɹ޸ѡЬɹ޸ѡЬɹ޸ѡЬɹ޸ѡЬɹ޸ѡЬ</p>', 1, 1221890726, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (33, 7, 'Ůϡ', '<p>Ů&ldquo;&rdquo;Ů&ldquo;&rdquo;Ů&ldquo;&rdquo;Ů&ldquo;&rdquo;Ů&ldquo;&rdquo;Ů&ldquo;&rdquo;</p>', 2, 1221890748, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (34, 7, 'ΪгСȵĶ̿Ϯ', '<p>ΪгСȵĶ̿ϮΪгСȵĶ̿ϮΪгСȵĶ̿ϮΪгСȵĶ̿ϮΪгСȵĶ̿ϮΪгСȵĶ̿Ϯ</p>', 3, 1221890764, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (35, 7, 'Tٱ ܴ', '<p>Tٱ ܴTٱ ܴTٱ ܴTٱ ܴTٱ ܴ</p>', 4, 1221890793, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (36, 7, 'ӰӰӰ', '<p>ŽůνлŽůν</p>', 5, 1221890847, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (37, 7, '', '<p></p>', 6, 1221890861, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (38, 7, 'ֻͨѶֻͨѶֻͨѶ', '<p>ֻͨѶֻͨѶֻͨѶֻͨѶֻͨѶֻͨѶֻͨѶֻͨѶֻͨѶֻͨѶֻͨѶֻͨѶֻͨѶֻͨѶ</p>', 7, 1221890885, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (39, 7, 'γγ', '<p>γγγγγγγγγγγ</p>', 8, 1221890904, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (40, 7, 'ݻݻݻ', '<p>ݻݻݻݻݻݻݻݻݻݻݻݻݻݻݻݻ</p>', 9, 1221890921, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (41, 8, '', '', 2, 1248922629, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/151.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (42, 8, 'עΪԱ', NULL, 1, 1248921487, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/zhuceyudenglu/20090411/148.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (43, 8, '', NULL, 3, 1248921639, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/zhuceyudenglu/20090411/150.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (44, 8, 'Ҫ', NULL, 4, 1248922307, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/156.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (45, 10, '֧', NULL, 1, 1248922462, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/157.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (46, 8, '鿴ѹƷ', NULL, 5, 1248922565, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/158.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (47, 11, 'ι', NULL, 1, 1248922684, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/159.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (48, 9, '뿪', NULL, 1, 1248922709, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/160.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (49, 9, 'ι', NULL, 2, 1248922734, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/161.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (50, 9, '鿴۳Ʒ', NULL, 3, 1248922773, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/162.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (51, 9, 'η', NULL, 4, 1248922804, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/163.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (52, 9, '̳ƷƼ', NULL, 5, 1248922851, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/165.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (53, 12, 'Ա޸', NULL, 1, 1248922887, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/gerenxinxixiugai/20090411/167.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (54, 12, 'Ա޸ĸϢ', NULL, 2, 1248922908, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/gerenxinxixiugai/20090411/168.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (55, 12, '޸ջַ', '', 3, 1248925025, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/gerenxinxixiugai/20090411/169.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (56, 11, 'ٱƷ', NULL, 2, 1248925057, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/jubaotousu/20090411/170.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (57, 11, 'Ͷߵ', '', 3, 1248925392, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/jubaotousu/20090411/171.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (58, 11, 'ٱ', NULL, 4, 1248925379, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/jubaotousu/20090411/172.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (59, 12, 'Ʒ', NULL, 4, 1248925430, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/shangpinguize/20090411/173.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (60, 12, '', NULL, 5, 1248925500, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/shangpinguize/20090411/174.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (61, 10, 'ע֧', NULL, 2, 1248925619, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/disanfangjiaoyipingtai/20090411/180.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (62, 10, 'עƸͨ', NULL, 3, 1248925646, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/disanfangjiaoyipingtai/20090411/181.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (63, 10, 'עᱴ', NULL, 4, 1248925697, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/disanfangjiaoyipingtai/20090411/182.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (64, 11, 'ϵ', NULL, 5, 1248925732, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/183.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (65, 10, 'ʹԤ', NULL, 5, 1248925902, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/yufukuan/20090703/214.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (66, 13, 'ۺ϶û̳ϵͳ÷Χ', NULL, 1, 1248925957, 'http://www.shopnc.net/document/multishop_help/html/shopNCzongheduoyonghubangzhuwendang/20090326/69.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (67, 13, '̳ϵͳҪϵͳҪ', NULL, 2, 1248925988, 'http://www.shopnc.net/document/multishop_help/html/shopNCzongheduoyonghuanzhuang/20090326/70.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (68, 13, '̳ϵͳص', NULL, 3, 1248926020, 'http://www.shopnc.net/document/multishop_help/html/shopNCzongheduoyonghubangzhuwendang/20090326/68.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (69, 13, 'UCϷ˵', NULL, 4, 1248926090, 'http://www.shopnc.net/document/multishop_help/html/shopNCzongheduoyonghuanzhuang/20090409/147.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (70, 13, '', NULL, 5, 1248926121, 'http://www.shopnc.net');

INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (1, 'ҳ');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (2, 'ҳ빫');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (3, 'orangeҳ');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (4, 'orangeվ');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (5, 'orangeҳ');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (6, 'orangeҳ');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (7, 'orange꾭鼼');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (8, 'Ա');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (9, '֮');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (10, '֧ʽ');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (11, 'ۺ');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (12, 'ͷ');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (13, '');

INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (4, '|5|', 'news_sort_asc', 30, 3);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (5, '|4|', 'news_sort_asc', 30, 3);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (6, '|3|', 'news_sort_asc', 30, 8);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (8, '|5|', 'news_sort_asc', 30, 3);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (9, '|6|', 'news_sort_asc', 30, 3);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (10, '|7|', 'news_sort_asc', 16, 10);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (11, '|8|', 'news_time_desc', 6, 5);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (12, '|9|', 'news_time_desc', 6, 5);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (13, '|10|', 'news_time_desc', 6, 5);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (14, '|11|', 'news_time_desc', 6, 5);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (15, '|12|', 'news_time_desc', 6, 5);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (16, '|13|', 'news_time_desc', 6, 5);

INSERT INTO `#__product_class` (`pc_id`, `pc_u_id`, `pc_name`, `pc_state`, `pc_intro`, `pc_pic`, `pc_sort`, `is_highlight`,`pc_deeppath`) VALUES (1, 0, 'ѶQQר', '1', 'ѶQQר', '', 1, '0','1');
INSERT INTO `#__product_class` (`pc_id`, `pc_u_id`, `pc_name`, `pc_state`, `pc_intro`, `pc_pic`, `pc_sort`, `is_highlight`,`pc_deeppath`) VALUES (48, 1, 'QQ', '1', 'QQ', '', 3, '0','2');

INSERT INTO `#__section` (`section_id`, `section_name`, `section_content`, `section_url`, `is_show`) VALUES(1, 'ͻ', 'ͻĽ ', '', '1');
INSERT INTO `#__section` (`section_id`, `section_name`, `section_content`, `section_url`, `is_show`) VALUES(2, 'Ӣ', 'Ӣ ', '', '1');
INSERT INTO `#__section` (`section_id`, `section_name`, `section_content`, `section_url`, `is_show`) VALUES(3, 'ϵ', 'ϵ ', '', '1');
INSERT INTO `#__section` (`section_id`, `section_name`, `section_content`, `section_url`, `is_show`) VALUES(4, 'վͼ', 'վͼ ', '', '1');
INSERT INTO `#__section` (`section_id`, `section_name`, `section_content`, `section_url`, `is_show`) VALUES(5, 'Ȩ˵', 'Ȩ˵ ', '', '1');

INSERT INTO `#__shop_class` (`class_id`, `class_name`, `class_state`, `parent_id`, `class_sort`, `class_property`) VALUES (1, '/ֵ', '1', 0, 0, '0');
INSERT INTO `#__shop_class` (`class_id`, `class_name`, `class_state`, `parent_id`, `class_sort`, `class_property`) VALUES (10, 'ƶֵͨ/IP;', '1', 1, 0, '0');

INSERT INTO `#__settings` (`variable`, `section`, `value`) VALUES ('extcredits_exp', 'credits', 'a:9:{s:6:"regist";i:10;s:16:"succ_product_put";i:5;s:8:"succ_buy";i:10;s:9:"open_shop";i:10;s:14:"member_certify";i:20;s:11:"shop_entity";i:20;s:10:"good_score";i:10;s:12:"normal_score";i:0;s:9:"bad_score";i:-10;}');
INSERT INTO `#__settings` (`variable`, `section`, `value`) VALUES ('extcredits_points', 'credits', 'a:9:{s:6:"regist";i:0;s:16:"succ_product_put";i:0;s:8:"succ_buy";i:10;s:9:"open_shop";i:0;s:14:"member_certify";i:10;s:11:"shop_entity";i:0;s:10:"good_score";i:5;s:12:"normal_score";i:0;s:9:"bad_score";i:0;}');

INSERT INTO `#__system_group` (`sys_group_id`, `sys_group_name`, `sys_group_area_province`, `sys_group_area_city`, `sys_group_power`, `sys_group_area_id`) VALUES (1, 'administrator', '', '', '|index|index~9999|system|system_baseinfo~1001|system_news~1002|system_email~1003|system_section~1004|system_power_group~1005|system_power_member~1006|system_alipay~1007|system_agreement~1008|system_channel~1009|system_channel_index~1010|system_exchange~1011|system_exchange~1012|system_shop_agreement~1013|system_credits_set~1014|product|product_category~1101|product_attribute~1102|product_product~1103|product_up_price~1104|product_html~1105|product_brand~1106|transaction|transaction_order~1201|transaction_complaint~1202|transaction_report~1202|member|member_manage~1301|member_score~1302|member_receive~1303|member_product_message~1304|member_store_shopmessage~1305|member_system_message~1306|member_personal_certify~1307|member_group~1308|store|store_category~1401|store_shop~1402|store_shoplink~1403|store_shopproductcate~1404|store_entityCheck~1405|tools|tools_area~1711|tools_channel~1701|tools_keyword~1702|tools_filter~1710|tools_adv~1703|tools_vote~1704|tools_link~1705|tools_database_backup~1706|tools_power_log~1707|tools_integration~1708|tools_conformitymember~1709|tools_statistic~1712|finance|finance_predeposit~1801|finance_shoppay~1802|app|app_list~1901|', 0);