CREATE TABLE `#__adv_theme` (
  `adv_id` smallint(5) unsigned NOT NULL auto_increment,
  `adv_title` varchar(255) default NULL,
  `adv_type` tinyint(2) NOT NULL,
  `adv_pic` varchar(100) default NULL,
  `adv_url` varchar(200) NOT NULL,
  `adv_code` varchar(100) NOT NULL,
  `adv_start_date` int(10) NOT NULL,
  `adv_end_date` int(10) NOT NULL,
  `adv_width` varchar(10) NOT NULL default '0',
  `adv_heigth` varchar(10) NOT NULL default '0',
  `adv_state` enum('0','1') NOT NULL default '0',
  `adv_sort` int(11) NOT NULL default '0',
  PRIMARY KEY  (`adv_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__app_module` (
  `app_module_id` int(11) NOT NULL auto_increment,
  `app_module_name` varchar(100) NOT NULL,
  `app_module_sign` varchar(100) NOT NULL,
  `app_module_state` enum('0','1') NOT NULL default '0',
  `app_module_sort` int(11) NOT NULL default '0',
  `app_module_install` enum('0','1') NOT NULL default '0',
  `app_module_sys_path` varchar(100) NOT NULL default 'system',
  `app_module_path` varchar(100) NOT NULL,
  `app_module_first_install` enum('0','1') NOT NULL default '0',
  `app_module_show` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`app_module_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__area` (
  `area_id` int(11) NOT NULL auto_increment,
  `area_name` varchar(20) default NULL,
  `area_intro` text,
  `area_parent_id` int(11) default '0',
  `area_sort` int(11) default '0',
  `area_path_string` varchar(30) default NULL,
  `area_deeppath` int(11) NOT NULL default '0',
  PRIMARY KEY  (`area_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__attribute` (
  `a_id` int(11) unsigned NOT NULL auto_increment,
  `pc_id` int(11) NOT NULL,
  `a_name` varchar(50) NOT NULL,
  `a_type` enum('0','1') NOT NULL default '0',
  `a_info` text,
  `a_order` tinyint(3) NOT NULL default '0',
  `a_time` int(10) default NULL,
  PRIMARY KEY  (`a_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__attribute_content` (
  `ac_id` int(11) unsigned NOT NULL auto_increment,
  `a_id` int(11) NOT NULL,
  `ac_content` varchar(50) NOT NULL,
  `ac_order` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`ac_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__bid` (
  `bid_id` int(11) unsigned NOT NULL auto_increment,
  `bid_member_id` int(11) NOT NULL,
  `bid_p_code` varchar(32) NOT NULL,
  `bid_max_price` decimal(9,2) default NULL,
  `bid_price` decimal(9,2) NOT NULL,
  `bid_count` int(8) NOT NULL default '1',
  `bid_total_price` decimal(9,2) NOT NULL,
  `bid_receive_code` varchar(32) default NULL,
  `bid_time` int(10) default NULL,
  `bid_state` enum('0','1','2') default '0',
  `bid_anonymous` enum('0','1') NOT NULL,
  PRIMARY KEY  (`bid_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__channel` (
  `channel_id` int(11) NOT NULL auto_increment,
  `channel_name` varchar(50) NOT NULL,
  `channel_state` enum('0','1') NOT NULL default '0',
  `channel_temp_name` varchar(100) default NULL,
  `channel_sort` int(11) NOT NULL default '0',
  `channel_url` varchar(100) default NULL,
  `channel_domain` varchar(100) default NULL,
  `channel_sign` varchar(100) NOT NULL,
  PRIMARY KEY  (`channel_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__collection` (
  `collection_id` int(10) unsigned NOT NULL auto_increment,
  `member_id` int(10) unsigned NOT NULL,
  `collection` int(10) unsigned NOT NULL,
  `intro` varchar(255) default NULL,
  `genre` enum('store','product') default 'store',
  `collection_time` varchar(50) NOT NULL,
  PRIMARY KEY  (`collection_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__complaint_report` (
  `complaint_report_id` int(11) NOT NULL auto_increment,
  `member_id` int(10) NOT NULL,
  `login_name` varchar(50) NOT NULL,
  `c_r_member_id` int(10) NOT NULL,
  `c_r_login_name` varchar(50) NOT NULL,
  `sp_id` int(12) default NULL,
  `p_code` varchar(32) default NULL,
  `p_name` varchar(100) default NULL,
  `c_r_class` enum('0','1','2','3','4') NOT NULL,
  `c_r_type` enum('0','1','2','3','4','5','6','7','8','9','10','11','12','13','14') NOT NULL,
  `c_r_evidence` text,
  `c_r_pic` varchar(255) default NULL,
  `c_r_pic_two` varchar(255) default NULL,
  `c_r_answer` text,
  `c_r_add_time` int(10) default NULL,
  `embargo_id` int(11) default NULL,
  `c_r_related_product` varchar(32) default NULL,
  `c_r_speculation_member_id` int(10) default NULL,
  `c_r_speculation_member_name` varchar(50) default NULL,
  `c_r_handling_state` enum('0','1','2','3') NOT NULL default '0',
  `c_r_result` varchar(255) default NULL,
  `c_r_end_time` varchar(32) default NULL,
  PRIMARY KEY  (`complaint_report_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__complaint_report_message` (
  `r_c_msg_id` int(11) NOT NULL auto_increment,
  `r_c_msg_type` enum('0','1') NOT NULL,
  `complaint_report_id` int(11) NOT NULL,
  `r_c_msg_add` varchar(32) NOT NULL,
  `r_c_content` text NOT NULL,
  PRIMARY KEY  (`r_c_msg_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__credits_log` (
  `cl_id` int(11) NOT NULL auto_increment,
  `cl_member_id` int(11) NOT NULL,
  `cl_time` int(11) NOT NULL,
  `cl_type` varchar(20) NOT NULL,
  `cl_content` varchar(100) NOT NULL,
  `cl_exp` int(11) NOT NULL default '0',
  `cl_points` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cl_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__delete_debug` (
  `delete_debug_id` int(11) NOT NULL auto_increment,
  `date_line` varchar(11) NOT NULL,
  `delete_result` text NOT NULL,
  PRIMARY KEY  (`delete_debug_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__exchange` (
  `exchange_id` int(11) NOT NULL auto_increment,
  `exchange_name` varchar(10) NOT NULL default 'CNY',
  `exchange_rate` decimal(8,2) NOT NULL default '100.00',
  `state` enum('0','1') NOT NULL default '0',
  `exchange_remark` varchar(40) default NULL,
  PRIMARY KEY  (`exchange_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__increments` (
  `i_id` tinyint(3) unsigned NOT NULL auto_increment,
  `i_low` decimal(12,2) NOT NULL,
  `i_high` decimal(12,2) NOT NULL,
  `increment` int(11) NOT NULL,
  PRIMARY KEY  (`i_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__invoice` (
  `invoice_id` int(10) NOT NULL auto_increment,
  `order_code` varchar(32) NOT NULL,
  `receive_code` varchar(32) default NULL,
  `invoice_info` varchar(250) default NULL,
  PRIMARY KEY  (`invoice_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__keyword` (
  `keyword_id` int(11) NOT NULL auto_increment,
  `keyword_name` varchar(100) NOT NULL,
  `keyword_num` int(11) NOT NULL default '0',
  `update_date` int(10) NOT NULL default '0',
  PRIMARY KEY  (`keyword_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__keyword_show` (
  `keyword_show_id` int(11) NOT NULL auto_increment,
  `show_code` varchar(100) NOT NULL,
  `keyword_content` text NOT NULL,
  `keyword_url` text NOT NULL,
  PRIMARY KEY  (`keyword_show_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__language` (
  `language_id` int(11) NOT NULL auto_increment,
  `language_sign` varchar(20) NOT NULL,
  `language_path` varchar(20) NOT NULL,
  `language_sort` int(11) NOT NULL default '0',
  `language_state` enum('0','1') NOT NULL default '0',
  `language_name` varchar(20) NOT NULL,
  PRIMARY KEY  (`language_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__link` (
  `link_id` int(11) NOT NULL auto_increment,
  `link_title` varchar(100) default NULL,
  `link_url` varchar(255) default NULL,
  `link_pic` varchar(255) default NULL,
  `link_close` enum('0','1') NOT NULL default '0',
  `link_state` enum('0','1') NOT NULL default '0',
  `link_sort` int(11) NOT NULL default '0',
  `link_type` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`link_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__mailcontent` (
  `mail_id` int(10) unsigned NOT NULL auto_increment,
  `genre` varchar(40) default NULL,
  `ifopen` enum('0','1') NOT NULL default '0',
  `title` varchar(255) default NULL,
  `maildesc` text,
  `content` text,
  `ifsystem` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`mail_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__member` (
  `member_id` int(10) unsigned NOT NULL auto_increment,
  `login_name` varchar(50) NOT NULL,
  `password` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `member_state` enum('0','1','2') NOT NULL default '1',
  `member_type` enum('0','1') NOT NULL default '0',
  `regist_time` int(11) NOT NULL,
  `last_login_time` int(10) default '0',
  PRIMARY KEY  (`member_id`),
  KEY `member_id` (`member_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__member_extend` (
  `extend_id` int(10) unsigned NOT NULL auto_increment,
  `member_id` int(10) unsigned NOT NULL,
  `true_name` varchar(30) default NULL,
  `gender` enum('m','f') NOT NULL default 'm',
  `birthday` varchar(20) default NULL,
  `province` varchar(50) default NULL,
  `city` varchar(50) default NULL,
  `address` varchar(200) default NULL,
  `zip` varchar(6) default NULL,
  `mobilephone` varchar(15) default NULL,
  `phone` varchar(15) default NULL,
  `otherphone` varchar(15) default NULL,
  `alipay` varchar(100) default NULL,
  `QQ` varchar(11) default NULL,
  `MSN` varchar(50) default NULL,
  `SKYPE` varchar(50) default NULL,
  `TAOBAO` varchar(50) default NULL,
  `buy_score_instant` int(11) NOT NULL default '0',
  `sale_score_instant` int(11) NOT NULL default '0',
  `buy_score_offline` int(11) NOT NULL default '0',
  `sale_score_offline` int(11) NOT NULL default '0',
  `buy_score` int(11) NOT NULL default '0',
  `sale_score` int(11) NOT NULL default '0',
  `sell_product_count` int(10) unsigned NOT NULL default '0',
  `recommend_product_count` int(10) unsigned NOT NULL default '0',
  `recommend_max_count` int(10) NOT NULL default '10',
  `offline` varchar(100) default NULL,
  `tenpay` varchar(100) default NULL,
  `paypal` varchar(100) default NULL,
  `product_show_time` int(10) default NULL,
  `product_number` int(10) default NULL,
  `shop_availability_time` int(10) default NULL,
  `available_predeposit` decimal(10,2) unsigned NOT NULL default '0.00',
  `freeze_predeposit` decimal(10,2) NOT NULL default '0.00',
  `personal_certify` enum('0','1','2','3') NOT NULL,
  `personal_certify_identitycard_up` varchar(100) default NULL,
  `personal_certify_identitycard_back` varchar(100) default NULL,
  `personal_certify_deny_reason` text,
  `personal_certify_update_time` int(10) default NULL,
  `area_id` int(11) default NULL,
  `predeposit` varchar(100) default NULL,
  `shop_availability_time_freeze` int(11) default '0',
  `mg_id` int(11) NOT NULL,
  `extcredits_exp` int(11) NOT NULL default '0',
  `extcredits_points` int(11) NOT NULL default '0',
  KEY `extend_id` (`extend_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__member_group` (
  `mg_id` int(11) NOT NULL auto_increment,
  `mg_name` varchar(100) NOT NULL,
  `mg_score_lower` int(11) NOT NULL,
  `mg_score_higher` int(11) NOT NULL,
  `mg_stars` tinyint(3) NOT NULL default '0',
  `mg_iflogin` tinyint(1) NOT NULL default '1',
  `mg_ifbuy` tinyint(1) NOT NULL default '1',
  `mg_ifsell` tinyint(1) NOT NULL default '1',
  `mg_ifopen_shop` tinyint(1) NOT NULL default '1',
  `mg_ifuse_credit` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`mg_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__member_pay_order` (
  `mpo_id` int(11) NOT NULL auto_increment,
  `mpo_code` varchar(32) NOT NULL,
  `mpo_member_id` int(10) NOT NULL,
  `mpo_member_name` varchar(50) NOT NULL,
  `mpo_mode_id` int(10) NOT NULL,
  `mpo_mode` varchar(100) NOT NULL,
  `mpo_money` decimal(9,2) NOT NULL,
  `mpo_currency` varchar(10) NOT NULL,
  `mpo_pay_id` int(10) NOT NULL,
  `mpo_pay_name` varchar(10) NOT NULL,
  `mpo_pay_type` enum('1','2') NOT NULL,
  `mpo_pay_sign` enum('1','2') default NULL,
  `mpo_end_time` int(10) default NULL,
  `mpo_on_type` varchar(10) NOT NULL,
  `mpo_shop_time` int(10) default NULL,
  `mpo_product_number` int(10) default NULL,
  `mpo_product_show_time` int(10) default NULL,
  PRIMARY KEY  (`mpo_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__message` (
  `message_id` int(10) unsigned NOT NULL auto_increment,
  `member_name` varchar(50) NOT NULL,
  `receive_name` varchar(50) NOT NULL,
  `title` varchar(255) default NULL,
  `content` text,
  `isnew` enum('0','1') NOT NULL default '0',
  `end_date` varchar(50) default NULL,
  `isallowdel` enum('0','1') default '1',
  `send_time` varchar(50) default NULL,
  `issave` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`message_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__message_system` (
  `message_system_id` int(10) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `send_time` int(10) NOT NULL,
  `send_object` enum('0','1','2') NOT NULL,
  `system_receive_name` varchar(255) default NULL,
  `state` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`message_system_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__news` (
  `news_id` int(11) NOT NULL auto_increment,
  `news_c_id` smallint(6) NOT NULL,
  `news_title` varchar(100) NOT NULL,
  `news_content` text,
  `news_sort` int(11) NOT NULL default '0',
  `news_date` int(11) default NULL,
  `news_jump_url` varchar(255) default NULL,
  PRIMARY KEY  (`news_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__news_class` (
  `news_c_id` smallint(6) NOT NULL auto_increment,
  `news_c_name` varchar(50) NOT NULL,
  PRIMARY KEY  (`news_c_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__news_js` (
  `news_js_id` smallint(6) NOT NULL auto_increment,
  `news_c_id` varchar(100) default NULL,
  `order_by` varchar(100) default NULL,
  `char_num` int(11) NOT NULL default '0',
  `line_num` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`news_js_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__payment_switch_log` (
  `ps_log_id` int(11) NOT NULL auto_increment,
  `ps_date_line` int(11) NOT NULL,
  `ps_type` enum('shoppay') NOT NULL,
  `ps_state` enum('0','1') NOT NULL,
  `ps_ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`ps_log_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__pay_accounts` (
  `pay_id` int(10) NOT NULL auto_increment,
  `pay_name` varchar(30) NOT NULL,
  `pay_ico` text,
  `pay_account` varchar(30) default NULL,
  `pay_consignee` varchar(10) default NULL,
  `pay_type` enum('1','2') NOT NULL,
  PRIMARY KEY  (`pay_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__predeposit_cash` (
  `predeposit_c_id` int(11) NOT NULL auto_increment,
  `member_id` int(11) NOT NULL,
  `payment` varchar(32) NOT NULL,
  `payment_trade` varchar(64) default NULL,
  `payment_type` enum('0','1') NOT NULL,
  `record_state` enum('0','1','2') NOT NULL,
  `pay_account` varchar(64) NOT NULL,
  `pay_bank` varchar(50) default NULL,
  `pay_consignee` varchar(10) default NULL,
  `pay_remark` text,
  `system_remark` text,
  `amount` decimal(10,2) NOT NULL,
  `create_time` int(11) NOT NULL,
  PRIMARY KEY  (`predeposit_c_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__predeposit_detail` (
  `predeposit_id` int(11) NOT NULL auto_increment,
  `predeposit_type` enum('0','1','2','3','4','5','6') NOT NULL,
  `predeposit_state` enum('0','1','2') NOT NULL,
  `member_id` int(11) NOT NULL,
  `available_amount` decimal(10,2) NOT NULL default '0.00',
  `to_member_id` int(11) default NULL,
  `sp_code` varchar(32) default NULL,
  `member_remark` text,
  `system_remark` text,
  `create_time` int(11) NOT NULL,
  `update_time` int(11) NOT NULL,
  `payment` varchar(100) default NULL,
  `freeze_amount` decimal(10,2) NOT NULL default '0.00',
  `predeposit_r_id` int(11) default NULL,
  `predeposit_c_id` int(11) default NULL,
  PRIMARY KEY  (`predeposit_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__predeposit_record` (
  `predeposit_r_id` int(11) NOT NULL auto_increment,
  `member_id` int(11) NOT NULL,
  `payment` varchar(32) NOT NULL,
  `payment_trade` varchar(64) default NULL,
  `sender_name` varchar(50) default NULL,
  `sender_bank` varchar(50) default NULL,
  `sender_amount` varchar(50) default NULL,
  `sender_date` int(11) default NULL,
  `sender_remark` text,
  `payment_type` enum('0','1') NOT NULL,
  `record_state` enum('0','1','2') NOT NULL default '0',
  `pay_name` varchar(30) default NULL,
  `pay_account` varchar(30) default NULL,
  `pay_consignee` varchar(10) default NULL,
  `create_time` int(11) NOT NULL,
  `system_remark` text,
  `online_amount` decimal(10,2) default NULL,
  PRIMARY KEY  (`predeposit_r_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product` (
  `p_id` int(11) unsigned NOT NULL auto_increment,
  `p_name` varchar(100) NOT NULL default '',
  `pc_id` int(11) NOT NULL default '0',
  `theme_id` int(11) NOT NULL default '0',
  `member_id` int(11) NOT NULL default '0',
  `p_code` char(32) NOT NULL,
  `p_price` decimal(10,2) NOT NULL,
  `p_point` int(11) NOT NULL default '0',
  `p_view_num` int(11) NOT NULL default '0',
  `p_start_time` int(10) default NULL,
  `p_end_time` int(10) default NULL,
  `p_valid_days` tinyint(2) default NULL,
  `p_storage` int(6) NOT NULL default '0',
  `p_state` enum('0','1') NOT NULL default '0',
  `p_pic` varchar(100) default '',
  `p_intro` text NOT NULL,
  `p_add_time` int(10) NOT NULL,
  `p_update_time` int(10) NOT NULL,
  `p_auto_publish` enum('0','1') NOT NULL default '1',
  `p_sell_type` enum('0','1','2') NOT NULL default '1',
  `p_type` enum('0','1','2') NOT NULL default '0',
  `p_group_price` decimal(10,2) default NULL,
  `p_group_mincount` int(5) default NULL,
  `p_cur_price` decimal(8,2) default '0.00',
  `p_system_step` enum('0','1') default '0',
  `p_price_step` decimal(8,2) default NULL,
  `p_province` varchar(20) default NULL,
  `p_city` varchar(20) default NULL,
  `p_transfee_charge` enum('0','1') NOT NULL default '0',
  `p_have_invoices` enum('0','1') NOT NULL default '0',
  `p_have_warranty` enum('0','1') NOT NULL default '0',
  `p_tf_py` decimal(8,2) default '0.00',
  `p_tf_kd` decimal(8,2) default '0.00',
  `p_tf_ems` decimal(8,2) default '0.00',
  `p_recommended` enum('0','1') NOT NULL default '0',
  `p_remark` text,
  `p_sold_num` int(6) default '0',
  `p_sold_sum` int(6) default '0',
  `p_store_recommended` enum('0','1') NOT NULL default '0',
  `p_class_id` int(10) default '0',
  `p_irregularities` enum('0','1') NOT NULL default '0',
  `p_index` enum('0','1') NOT NULL default '0',
  `p_pay_method` varchar(200) default NULL,
  `p_currency_category` varchar(100) NOT NULL default 'CNY',
  `p_predeposit_state` enum('0','1') default NULL,
  `p_area_id` int(11) default NULL,
  `p_ifnopub` int(11) NOT NULL default '0',
  `p_bid_num` int(11) NOT NULL default '0',
  `p_pb_id` int(11) default NULL,
  `p_genuine` tinyint(1) NOT NULL default '0',
  `p_7day_return` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`p_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_attributes` (
  `pac_id` int(11) unsigned NOT NULL auto_increment,
  `a_id` int(11) NOT NULL,
  `p_id` char(32) NOT NULL,
  `pac_content` varchar(50) NOT NULL,
  `pac_order` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`pac_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_brand` (
  `pb_id` int(11) NOT NULL auto_increment,
  `pb_u_id` int(11) NOT NULL default '0',
  `pb_name` varchar(100) NOT NULL,
  `pb_sort` int(11) NOT NULL default '0',
  `pb_state` enum('0','1') NOT NULL default '0',
  `pb_path` varchar(100) NOT NULL default '0',
  `pb_deeppath` int(11) NOT NULL default '1',
  PRIMARY KEY  (`pb_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_class` (
  `pc_id` int(11) unsigned NOT NULL auto_increment,
  `pc_u_id` int(11) NOT NULL default '0',
  `pc_name` varchar(100) NOT NULL default '',
  `pc_state` enum('0','1') NOT NULL default '1',
  `pc_intro` text NOT NULL,
  `pc_pic` varchar(100) default '',
  `pc_sort` int(11) NOT NULL default '0',
  `is_highlight` enum('0','1') NOT NULL default '0',
  `pc_deeppath` int(11) NOT NULL default '0',
  PRIMARY KEY  (`pc_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_message` (
  `message_id` int(10) unsigned NOT NULL auto_increment,
  `member_name` varchar(50) NOT NULL,
  `message_content` text NOT NULL,
  `message_recontent` text,
  `product_id` int(10) unsigned NOT NULL,
  `product_code` char(32) NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  `message_time` varchar(50) NOT NULL,
  `re_time` varchar(50) default NULL,
  `anonymous` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`message_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_pic` (
  `p_pic_id` int(11) NOT NULL auto_increment,
  `p_pic` varchar(100) NOT NULL,
  `p_code` char(32) NOT NULL,
  PRIMARY KEY  (`p_pic_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_pic_cache` (
  `p_pic_c_id` int(10) NOT NULL auto_increment,
  `p_pic_cache` varchar(100) NOT NULL,
  PRIMARY KEY  (`p_pic_c_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__product_sold` (
  `sp_id` int(12) unsigned NOT NULL auto_increment,
  `sp_code` char(32) NOT NULL,
  `seller_id` int(11) default NULL,
  `buyer_id` int(11) default NULL,
  `p_name` varchar(100) NOT NULL,
  `p_code` varchar(32) NOT NULL,
  `pc_id` int(11) default NULL,
  `unit_price` decimal(9,2) NOT NULL default '0.00',
  `buy_num` int(6) NOT NULL default '1',
  `tf_type` enum('1','2','3') default NULL,
  `tf_fee` decimal(9,2) NOT NULL default '0.00',
  `total_price` decimal(9,2) NOT NULL default '0.00',
  `sell_type` enum('0','1','2') NOT NULL default '1',
  `receive_code` varchar(32) NOT NULL,
  `p_pic` varchar(255) default NULL,
  `sp_html` longtext,
  `sp_state` enum('0','1','2','3','4','5','6') NOT NULL default '0',
  `sold_time` int(10) NOT NULL,
  `pay_time` int(10) default NULL,
  `deliver_time` int(10) default NULL,
  `receive_time` int(10) default NULL,
  `sole_have_comment` enum('0','1') NOT NULL default '0',
  `buy_have_comment` enum('0','1') NOT NULL,
  `sp_del` enum('0','1') NOT NULL default '0',
  `anonymous` enum('0','1') NOT NULL default '0',
  `leaveword` text,
  `alipay_id` varchar(100) default NULL,
  `sp_pay_mechod` varchar(20) default NULL,
  `sp_offline_bought` enum('0','1','2') NOT NULL default '0',
  `sp_offline_sold` enum('0','1','2') NOT NULL default '0',
  `sp_currency_category` varchar(10) NOT NULL default 'CNY',
  `close_reason` varchar(100) default NULL,
  PRIMARY KEY  (`sp_id`)
) ENGINE=MyISAM ;

CREATE TABLE `#__receive` (
  `receive_id` int(10) unsigned NOT NULL auto_increment,
  `receive_code` varchar(32) default NULL,
  `member_id` int(10) unsigned NOT NULL,
  `receive_name` varchar(50) default NULL,
  `province` varchar(100) default NULL,
  `city` varchar(100) default NULL,
  `address` varchar(255) default NULL,
  `mobilephone` varchar(12) default NULL,
  `phone` varchar(25) default NULL,
  `zip` varchar(8) default NULL,
  `receive_area_id` int(11) default NULL,
  PRIMARY KEY  (`receive_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__remind` (
  `remind_id` int(10) NOT NULL auto_increment,
  `member_id` int(10) NOT NULL,
  `login_name` varchar(50) NOT NULL,
  `date_line` int(10) NOT NULL,
  `sale_product_move` varchar(10) default NULL,
  `sale_product_del` varchar(10) default NULL,
  `sale_product_down` varchar(10) default NULL,
  `sale_order_succ` varchar(10) default NULL,
  `sale_order_bid_nosucc` varchar(10) default NULL,
  `sale_order_team_insufficient` varchar(10) default NULL,
  `sale_message_product` varchar(10) default NULL,
  `sale_message_shop` varchar(10) default NULL,
  `sale_buyer_to_succ` varchar(10) default NULL,
  `sale_shop_3_month_unreach_10` varchar(10) default NULL,
  `sale_shop_5_month_unreach_10` varchar(10) default NULL,
  `sale_shop_6_month_unreach_10` varchar(10) default NULL,
  `buyer_bid_above_notice` varchar(10) default NULL,
  `buyer_bid_above_no_num` varchar(10) default NULL,
  `buyer_bid_succ_notice` varchar(10) default NULL,
  `buyer_bid_over_no_num` varchar(10) default NULL,
  `buyer_buy_succ_notice` varchar(10) default NULL,
  `buyer_message_seller_product_answer` varchar(10) default NULL,
  `buyer_message_seller_shop_answer` varchar(10) default NULL,
  `buyer_sale_to_succ` varchar(10) default NULL,
  `buyer_team_unsucc` varchar(10) default NULL,
  `buyer_team_no_pay` varchar(10) default NULL,
  `score_have_notice` varchar(10) default NULL,
  `complaint_receive_notice` varchar(10) default NULL,
  `complaint_handling_notice` varchar(10) default NULL,
  `complaint_other_answer_notice` varchar(10) default NULL,
  PRIMARY KEY  (`remind_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__score` (
  `score_id` int(10) unsigned NOT NULL auto_increment,
  `order_id` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  `grade_member_id` int(10) unsigned NOT NULL,
  `genre` enum('b','s') NOT NULL,
  `score` int(10) NOT NULL,
  `pubtime` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `modify_reason` varchar(255) default NULL,
  `modify_time` varchar(50) default NULL,
  `score_pay_type` enum('1','2','3') NOT NULL default '1',
  PRIMARY KEY  (`score_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__section` (
  `section_id` int(11) NOT NULL auto_increment,
  `section_name` varchar(100) default NULL,
  `section_content` text,
  `section_url` varchar(100) default NULL,
  `is_show` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`section_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__settings` (
  `variable` varchar(30) NOT NULL,
  `section` varchar(30) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY  (`variable`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_class` (
  `class_id` smallint(5) unsigned NOT NULL auto_increment,
  `class_name` varchar(255) NOT NULL,
  `class_state` enum('0','1') NOT NULL default '0',
  `parent_id` smallint(5) unsigned NOT NULL default '0',
  `class_sort` smallint(5) unsigned NOT NULL default '0',
  `class_property` enum('0','1','2') NOT NULL default '0',
  PRIMARY KEY  (`class_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_info` (
  `shop_id` int(10) unsigned NOT NULL auto_increment,
  `member_id` int(10) unsigned NOT NULL,
  `shop_name` varchar(100) NOT NULL,
  `shop_class` smallint(5) unsigned NOT NULL,
  `sale_range` varchar(255) default NULL,
  `shop_province` varchar(20) default NULL,
  `shop_city` varchar(20) default NULL,
  `shop_intro` text,
  `shop_pic` varchar(100) default NULL,
  `identity_card_copy_up` varchar(100) default NULL,
  `identity_card_copy_back` varchar(100) default NULL,
  `license_copy` varchar(100) default NULL,
  `proclamation` text,
  `practice_time` varchar(50) NOT NULL,
  `shop_level` enum('0','1') NOT NULL default '0',
  `templates` enum('0','1') NOT NULL,
  `shop_style` text,
  `recommend_product_count` int(10) unsigned NOT NULL default '0',
  `ischeck` enum('0','1','2') NOT NULL default '0',
  `audit_state` enum('0','1','2','3') NOT NULL default '0',
  `shop_domain` varchar(8) default NULL,
  `shop_index` enum('0','1') NOT NULL default '0',
  `positionX` int(10) unsigned default '0',
  `positionY` int(10) unsigned default '0',
  `positionZ` int(2) unsigned default '0',
  `positionC` varchar(50) default NULL,
  `shop_banner_pic` varchar(100) default NULL,
  `shop_area_id` int(11) default NULL,
  `if_del` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`shop_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_link` (
  `link_id` int(10) unsigned NOT NULL auto_increment,
  `shop_id` int(10) unsigned NOT NULL,
  `link_shop_id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`link_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_message` (
  `message_id` int(10) unsigned NOT NULL auto_increment,
  `member_name` varchar(50) NOT NULL,
  `message_content` text NOT NULL,
  `message_recontent` text,
  `shop_id` int(10) unsigned NOT NULL,
  `message_time` varchar(50) NOT NULL,
  `re_time` varchar(50) default NULL,
  PRIMARY KEY  (`message_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_pay_detail` (
  `pay_detail_id` int(10) NOT NULL auto_increment,
  `member_id` int(10) NOT NULL,
  `pay_sign` enum('0','1','2','3') NOT NULL,
  `pay_id` int(10) default NULL,
  `pay_name` varchar(30) NOT NULL,
  `pay_account` varchar(30) default NULL,
  `pay_consignee` varchar(10) default NULL,
  `pay_type` enum('1','2') NOT NULL,
  `date_line` int(10) default NULL,
  `pay_mode_id` int(11) NOT NULL,
  `pay_mode_name` varchar(100) NOT NULL,
  `pay_mode_type` enum('0','1','2') NOT NULL,
  `pay_mode_money` decimal(10,2) NOT NULL,
  `pay_mode_product_number` int(10) default NULL,
  `pay_mode_shop_show_time` int(10) default NULL,
  `pay_mode_remark` text,
  `payment_trade` varchar(64) default NULL,
  `system_remark` text,
  `sender_number` varchar(64) default NULL,
  PRIMARY KEY  (`pay_detail_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_pay_mode` (
  `mode_id` int(10) NOT NULL auto_increment,
  `mode_name` varchar(100) NOT NULL,
  `mode_type` enum('0','1','2') NOT NULL,
  `mode_money` decimal(10,2) NOT NULL,
  `mode_product_number` int(10) default NULL,
  `mode_shop_show_time` int(10) default NULL,
  `mode_remark` text,
  PRIMARY KEY  (`mode_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_product_class` (
  `class_id` int(10) unsigned NOT NULL auto_increment,
  `class_name` varchar(255) NOT NULL,
  `class_parent_id` int(11) NOT NULL default '0',
  `class_pic` varchar(100) default NULL,
  `class_if_open` enum('0','1') NOT NULL default '0',
  `class_sort` smallint(5) unsigned NOT NULL,
  `shop_id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`class_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__shop_tag` (
  `tag_id` int(10) unsigned NOT NULL auto_increment,
  `shop_id` int(10) unsigned NOT NULL default '0',
  `tag_name` varchar(50) NOT NULL,
  `tag_url` varchar(200) default NULL,
  `tag_content` text,
  `tag_display` tinyint(1) unsigned NOT NULL default '0',
  `tag_sort` tinyint(1) unsigned NOT NULL default '0',
  `tag_time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`tag_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__system_group` (
  `sys_group_id` int(11) NOT NULL auto_increment,
  `sys_group_name` varchar(50) NOT NULL,
  `sys_group_area_province` varchar(20) default NULL,
  `sys_group_area_city` varchar(20) default NULL,
  `sys_group_power` text,
  `sys_group_area_id` int(11) default NULL,
  PRIMARY KEY  (`sys_group_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__system_log` (
  `sys_log_id` int(11) NOT NULL auto_increment,
  `sys_member_id` int(11) NOT NULL,
  `sys_login_name` varchar(50) NOT NULL,
  `sys_log_note` varchar(255) NOT NULL,
  `sys_log_time` int(10) NOT NULL,
  `sys_log_ip` varchar(20) default NULL,
  PRIMARY KEY  (`sys_log_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__system_member` (
  `sys_member_id` int(11) NOT NULL auto_increment,
  `sys_login_name` varchar(50) NOT NULL,
  `sys_password` varchar(32) NOT NULL,
  `sys_group_id` int(11) NOT NULL,
  `sys_login_num` int(11) NOT NULL default '0',
  `sys_login_time` int(10) NOT NULL,
  `sys_email` varchar(100) NOT NULL,
  `sys_login_ip` varchar(20) default NULL,
  PRIMARY KEY  (`sys_member_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__vote` (
  `vote_id` int(11) NOT NULL auto_increment,
  `vote_title` varchar(255) default NULL,
  `vote_refresh` enum('0','1') NOT NULL default '0',
  `vote_member` enum('0','1') NOT NULL default '0',
  `vote_content` text,
  `vote_check` enum('0','1') NOT NULL default '0',
  `vote_state` enum('0','1') NOT NULL default '0',
  `vote_close` enum('0','1') NOT NULL default '0',
  `vote_start_date` int(10) NOT NULL default '0',
  `vote_end_date` int(10) NOT NULL default '0',
  `vote_date` int(10) NOT NULL default '0',
  PRIMARY KEY  (`vote_id`)
) ENGINE=MyISAM;

CREATE TABLE `#__vote_show` (
  `vote_show_id` int(11) NOT NULL auto_increment,
  `show_name` varchar(10) NOT NULL default '0',
  `vote_id` int(11) NOT NULL default '0',
  `show_sort` int(11) NOT NULL default '0',
  PRIMARY KEY  (`vote_show_id`)
) ENGINE=MyISAM;

INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(1, 'orange_index_adv', 2, 'attachments/jpg/2008/11/22/122732849749278bf1f053a.jpg', 'http://www.shopnc.net', 'orange_index_adv', 1227283200, 1258905599, '420', '260', '0', 0);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(2, 'top_adv', 0, 'attachments/gif/2008/11/22/122732891649278d94c28ce.gif', 'http://www.shopnc.net', 'top_adv', 1227283200, 1258905599, '170', '68', '0', 0);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(3, 'top_adv_one', 0, 'attachments/gif/2008/11/22/122732895449278dba35680.gif', 'http://www.shopnc.net', 'top_adv', 1227283200, 1258905599, '170', '68', '0', 1);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(4, 'top_adv_two', 0, 'attachments/gif/2008/11/22/122732898849278ddc4c4b6.gif', 'http://www.shopnc.net', 'top_adv', 1227283200, 1258905599, '170', '68', '0', 2);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(5, 'top_adv_three', 0, 'attachments/gif/2008/11/22/122732901549278df76ea08.gif', 'http://www.shopnc.net', 'top_adv', 1227283200, 1258905599, '170', '68', '0', 3);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(6, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274104904928cc3aa037d.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 0);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(7, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274105154928cc537de2c.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 1);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(8, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274105404928cc6c31978.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 2);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(9, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274105764928cc90e4e1e.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 3);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(10, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274105994928cca7ca2e0.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 4);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(11, 'index_adv', 2, 'attachments/jpg/2008/11/23/12274106214928ccbd89547.jpg', 'http://www.shopnc.net', 'index_adv', 1227369600, 1258991999, '500', '350', '0', 5);
INSERT INTO `#__adv_theme` (`adv_id`, `adv_title`, `adv_type`, `adv_pic`, `adv_url`, `adv_code`, `adv_start_date`, `adv_end_date`, `adv_width`, `adv_heigth`, `adv_state`, `adv_sort`) VALUES(12, 'index_channel', 0, 'attachments/jpg/2008/11/23/12274118044928d15c57bd1.jpg', 'http://www.shopnc.net', 'index_channel', 1227369600, 1258991999, '500', '180', '0', 0);

INSERT INTO `#__area` (`area_id`, `area_name`, `area_intro`, `area_parent_id`, `area_sort`, `area_path_string`, `area_deeppath`) VALUES (1, '天津', '天津', 0, 0, ',0,', 1);
INSERT INTO `#__area` (`area_id`, `area_name`, `area_intro`, `area_parent_id`, `area_sort`, `area_path_string`, `area_deeppath`) VALUES (2, '南开区', '南开区', 1, 0, ',0,1,', 2);

INSERT INTO `#__app_module` (`app_module_id`, `app_module_name`, `app_module_sign`, `app_module_state`, `app_module_sort`, `app_module_install`, `app_module_sys_path`, `app_module_path`, `app_module_first_install`, `app_module_show`) VALUES (1, '供求', 'supply', '0', 0, '0', 'system', 'supply', '0', '0');
INSERT INTO `#__app_module` (`app_module_id`, `app_module_name`, `app_module_sign`, `app_module_state`, `app_module_sort`, `app_module_install`, `app_module_sys_path`, `app_module_path`, `app_module_first_install`, `app_module_show`) VALUES (2, 'Ntalker', 'ntalker', '0', 0, '0', 'system', 'ntalker', '0', '1');
INSERT INTO `#__app_module` (`app_module_id`, `app_module_name`, `app_module_sign`, `app_module_state`, `app_module_sort`, `app_module_install`, `app_module_sys_path`, `app_module_path`, `app_module_first_install`, `app_module_show`) VALUES (3, '积分活动', 'credits_act', '0', 0, '0', 'system', 'credits_act', '0', '0');
INSERT INTO `#__app_module` (`app_module_id`, `app_module_name`, `app_module_sign`, `app_module_state`, `app_module_sort`, `app_module_install`, `app_module_sys_path`, `app_module_path`, `app_module_first_install`, `app_module_show`) VALUES (4, '会员空间', 'space', '0', 0, '0', 'system', 'space', '0', '0');

INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(1, 'CNY', 100.00, '1', '人民币');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(2, 'USD', 694.08, '1', '美元');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(3, 'GBP', 1370.53, '1', '德国马克');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(4, 'JPY', 6.67, '1', '日元');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(5, 'CAD', 699.04, '1', '加拿大元');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(6, 'EUR', 1089.36, '1', '欧元');
INSERT INTO `#__exchange` (`exchange_id`, `exchange_name`, `exchange_rate`, `state`, `exchange_remark`) VALUES(7, 'HKD', 100.00, '0', '港元');

INSERT INTO `#__language` (`language_id`, `language_sign`, `language_path`, `language_sort`, `language_state`, `language_name`) VALUES(1, 'zh-cn', 'zh-cn', 1, '1', '简体中文');
INSERT INTO `#__language` (`language_id`, `language_sign`, `language_path`, `language_sort`, `language_state`, `language_name`) VALUES(2, 'zh', 'zh', 2, '0', '繁体语言');

INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_close`, `link_state`, `link_sort`, `link_type`) VALUES(1, 'ShopNC', 'http://www.shopnc.net', 'attachments/gif/2008/11/22/122190001048d4b6ea0f688.gif', '0', '0', 0, '0');
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_close`, `link_state`, `link_sort`, `link_type`) VALUES(2, 'Discuz!', 'http://www.discuz.net/', 'attachments/gif/2008/11/22/122190001048d4b6ea0f690.gif', '0', '0', 0, '0');
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_close`, `link_state`, `link_sort`, `link_type`) VALUES(3, '《站长》俱乐部', 'http://zz.comsenz.com/', 'attachments/gif/2008/11/22/122190001048d4b6ea0f691.gif', '0', '0', 0, '0');
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_close`, `link_state`, `link_sort`, `link_type`) VALUES(4, 'Ntalker', 'http://www.ntalker.com/', 'attachments/gif/2008/11/22/122190001048d4b6ea0f689.gif', '0', '0', 0, '0');

INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (1, 'forget', '0', '您在{website}找回密码', '说明:在邮件模版中,设定了邮件内容变量(形如 {XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下:{website} 网站名称{username} 账号{newpass} 新密码{site_url} 网址', '<p>亲爱的{username} 您好：</p><p>您的会员账号是：{username}</p><p>您的新密码是：{newpass}</p><p>建议您立即更新您的密码！</p><p>&nbsp;</p><p>{website} 客服中心 </p>', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (2, 'regist', '0', '您在{sitename}的注册确认信', '说明:在邮件模版中,设定了邮件内容变量(形如 {XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下:\r\n\r\n{sitename} 网站名称\r\n\r\n{username} 账号\r\n\r\n{passwd} 密码\r\n\r\n', '亲爱的会员您好：感谢您注册{sitename}会员您的账号： {username}您的密码：{passwd}{sitename} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (3, 'modipass', '0', '您在{website}的密码修改通知', '说明:在邮件模版中,设定了邮件内容变量(形如 {XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下:\r\n\r\n{website} 网站名称\r\n\r\n{username} 账号\r\n\r\n{newpass} 新密码\r\n\r\n{site_url} 网址 \r\n', '亲爱的{username}：\r\n\r\n您在{website}的密码已经修改成功，请您保管好您的新密码\r\n\r \n您的新密码是：{newpass}\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (4, 'shopreply', '0', '您给{shopname}的留言已回复', '说明:在邮件模版中,设定了邮件内容变量(形如 {XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下:\r\n\r\n{website} 网站名称\r\n\r\n{shopname} 商店名\r\n\r\n{question} 顾客留言内容\r\n\r\n{messagetime} 留言时间\r\n\r\n{reply} 店主回复内容\r\n\r\n{username} 会员姓名\r\n\r\n{mastername} 掌柜姓名\r\n\r\n', '亲爱的{username},您好:\r\n\r\n很高兴您对本网站的参与,您给{shopname}的留言已回复\r \n\r\n您的留言内容:{question}\r\n\r\n发表时间:{messagetime}\r\n\r\n掌柜{mastername}的回复：{reply}\r\n\r \n{website}客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (5, 'productreplay', '0', '您在{website}的商品评论已回复', '说明:在邮件模版中,设定了邮件内容变量(形如{XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下:\r\n\r\n{website} 网站名称\r\n\r\n{productname} 商品名\r\n\r\n{producturl} 商品连接\r\n\r\n{question} 顾客留言内容\r\n\r\n{messagetime} 留言时间\r\n\r\n{reply} 店主回复内容\r\n\r\n{username} 会员姓名\r\n\r\n{mastername} 掌柜姓名\r\n', '亲爱的{username},您好:\r\n\r\n很高兴您对本网站的参与,您给{productname}的留言已回复\r n\r\n您的留言内容:{question}\r\n\r\n发表时间:{messagetime}\r\n\r\n掌柜{mastername}的回复：{reply}\r\n\r \n{website}客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (6, 'product_move', '0', '商品被移到其他目录', '说明:在邮件模版中,设定了邮件内容变量(形如 {XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{username} 账号\r\n{product_name} 商品名称\r\n{class_name} 目录名称\r\n{site_url} 网址', '亲爱的{username} 您好：\r\n\r\n您的商品：{product_name} 被系统转移到了{class_name}目录下\r\n\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (7, 'product_del', '0', '商品被系统删除', '在邮件模版中,设定了邮件内容变量(形如{XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{site_url} 网址 \r\n等\r\n', '\r\n\r\n亲爱的{username} 您好：\r\n您的商品：{product_name} 已经被系统删除\r\n{website} 客服中心\r\n\r\n', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (8, 'product_down', '0', '商品被系统下架', '在邮件模版中,设定了邮件内容变量(形如{XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{site_url} 网址 \r\n等', '\r\n\r\n亲爱的{username} 您好：\r\n您的商品：{product_name} 已经被系统下架\r\n{website} 客服中心\r\n\r\n', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (9, 'message_product', '0', '您的商品{product_name}有买家进行留言', '在邮件模版中,设定了邮件内容变量(形如{XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{product_name} 账号\r\n{site_url} 网址', '亲爱的{username} 您好：\r\n\r\n您的商品{product_name} 有买家进行了留言，请及时回复\r\n\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (10, 'message_shop', '0', '您的商铺有人留言', '在邮件模版中,设定了邮件内容变量(形如{XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{site_url} 网址', '亲爱的{username} 您好：\r\n\r\n您的商铺有买家进行了留言，请及时查看\r\n\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (11, 'buyer_to_succ', '0', '您的商品有人购买，请及时查看', '在邮件模版中,设定了邮件内容变量(形如 {XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \n{website} 网站名称\n{product_name}商品名称\n{site_url} 网址', '亲爱的{username} 您好：您的商品{product_name}有人购买了，请及时查看{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (12, 'message_seller_product_answer', '0', '您在{product_name}上的留言已经被回复了', '在邮件模版中,设定了邮件内容变量(形如{XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{product_name} 商品名称\r\n{site_url} 网址', '亲爱的{username} 您好：\r\n\r\n您在{product_name}上的留言已经被回复了,请及时查看\r\n\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (13, 'sale_to_succ', '0', '您购买的商品卖家已发货，请及时查收', '在邮件模版中,设定了邮件内容变量(形如 {XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下:\r\n{website} 网站名称\r\n{product_name}商品名称\r\n{site_url} 网址\r\n', '亲爱的{username} 您好：\r\n\r\n您的商品{product_name}卖家已发货，请及时查收\r\n\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (14, 'score_have_notice', '0', '您的交易对方已经给予评价了', '在邮件模版中,设定了邮件内容变量(形如 {XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{product_name}商品名称\r\n{site_url} 网址', '亲爱的{username} 您好：\r\n\r\n您的{交易（product_name}）对方已经给予评价了，请及时查看，并且也别忘记给予对方评价吧\r\n\r\n {website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (15, 'complaint_receive_notice', '0', '有会员对您进行了投诉/举报', '在邮件模版中,设定了邮件内容变量(形如{XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{username}商品名称\r\n{site_url} 网址1', '亲爱的{username} 您好：\r\n\r\n有会员对您进行了投诉/举报 ，请您及时查看 我的商城-->客户服务-->投诉/举报栏目\r\n\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (16, 'complaint_handling_notice', '0', '您发起或收到的投诉举报处理完毕，请及时查看', '在邮件模版中,设定了邮件内容变量(形如{XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{username}用户名\r\n{site_url} 网址', '亲爱的{username} 您好：\r\n\r\n您发起或收到的投诉举报处理完毕，请及时查看 我的商城-->客户服务-->投诉/举报栏目\r\n\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (17, 'complaint_other_answer_notice', '0', '你投诉/举报后，对方进行了申诉', '在邮件模版中,设定了邮件内容变量(形如{XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{username}会员名称\r\n{site_url} 网址1', '亲爱的{username} 您好：\r\n\r\n你投诉/举报后，对方进行了申诉，请您及时查看 我的商城-->客户服务-->投诉/举报栏目\r\n\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (18, 'order_succ', '0', '您的商品已被一口价拍得', '在邮件模版中,设定了邮件内容变量(形如{XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{product_name} 商品名称\r\n{site_url} 网址', '亲爱的{username} 您好：\r\n\r\n您的商品 {product_name} 已有人一口价拍得，请查看交易记录\r\n\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (19, 'bid_above_notice', '0', '您的出价已被别人超过', '说明:在邮件模版中,设定了邮件内容变量(形如 {XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{product_name} 商品名称 \r\n{site_url} 网址', '亲爱的{username} 您好：\r\n\r\n您竞拍的商品{product_name} 的竞拍价格已经被别人超过，请及时查看\r\n\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (20, 'buyer_buy_succ_notice', '0', '您已成功购得{product_name}', '在邮件模版中,设定了邮件内容变量(形如{XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下: \r\n{website} 网站名称\r\n{product_name}商品名称\r\n{site_url} 网址', '亲爱的{username} 您好：\r\n\r\n您已经通过一口价成功购得{product_name}，请及时查看\r\n\r\n{website} 客服中心', '0');
INSERT INTO `#__mailcontent` (`mail_id`, `genre`, `ifopen`, `title`, `maildesc`, `content`, `ifsystem`) VALUES (21, 'recommendmail', '0', '您的朋友给您推荐的商品', '说明:在邮件模版中,设定了邮件内容变量(形如 {XXXX}),在发出邮件时,系统会用实际值替换本变量,本模板的变量定义如下:\r\n{receive_name}接收人名称\r\n{product_url}商品链接\r\n{content}发送内容\r\n{website} 网站名称\r\n{site_url} 网址', '亲爱的{receive_name} 您好：<br />\r\n{content}<br />\r\n商品链接：{product_url}<br />\r\n{website} 客服中心', '0');

INSERT INTO `#__member_group` (`mg_id`, `mg_name`, `mg_score_lower`, `mg_score_higher`, `mg_stars`, `mg_iflogin`, `mg_ifbuy`, `mg_ifsell`, `mg_ifopen_shop`, `mg_ifuse_credit`) VALUES (1, '平民', -999999999, 0, 1, 0, 1, 1, 1, 1);
INSERT INTO `#__member_group` (`mg_id`, `mg_name`, `mg_score_lower`, `mg_score_higher`, `mg_stars`, `mg_iflogin`, `mg_ifbuy`, `mg_ifsell`, `mg_ifopen_shop`, `mg_ifuse_credit`) VALUES (2, '普通用户', 0, 1000, 2, 1, 1, 1, 1, 1);
INSERT INTO `#__member_group` (`mg_id`, `mg_name`, `mg_score_lower`, `mg_score_higher`, `mg_stars`, `mg_iflogin`, `mg_ifbuy`, `mg_ifsell`, `mg_ifopen_shop`, `mg_ifuse_credit`) VALUES (3, '中级用户', 1000, 3000, 3, 1, 1, 1, 1, 1);
INSERT INTO `#__member_group` (`mg_id`, `mg_name`, `mg_score_lower`, `mg_score_higher`, `mg_stars`, `mg_iflogin`, `mg_ifbuy`, `mg_ifsell`, `mg_ifopen_shop`, `mg_ifuse_credit`) VALUES (4, '高级用户', 3000, 5000, 4, 1, 1, 1, 1, 1);
INSERT INTO `#__member_group` (`mg_id`, `mg_name`, `mg_score_lower`, `mg_score_higher`, `mg_stars`, `mg_iflogin`, `mg_ifbuy`, `mg_ifsell`, `mg_ifopen_shop`, `mg_ifuse_credit`) VALUES (5, '专家用户', 5000, 999999999, 5, 1, 1, 1, 1, 1);

INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (7, 1, '如何注册成为ShopNC的会员？', '<p>如何注册成为ShopNC的会员？</p><p>如何注册成为ShopNC的会员？</p><p>如何注册成为ShopNC的会员？</p><p>如何注册成为ShopNC的会员？</p><p>&nbsp;</p>', 0, 1217142113, '');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (8, 1, '如何在ShopNC开设网络店铺？', '<p>如何在ShopNC开设网络店铺？</p>', 1, 1216257662, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (9, 1, '如何购买ShopNC多用户版本？', '<p>如何购买ShopNC多用户版本？</p>', 2, 1216257680, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (10, 2, 'ShopNC最新版本上线', '<p>ShopNC最新版本上线</p>', 0, 1216259106, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (11, 2, '来ShopNC开店免费！', '<p>来ShopNC开店免费！</p>', 1, 1216258945, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (12, 2, '促销！促销！大促销！', '<p>促销！促销！大促销！</p>', 2, 1216258968, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (13, 2, '充值送积分好礼限量换', '<p>充值送积分好礼限量换</p>', 3, 1216258988, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (14, 3, '百搭日韩风衣清仓1折', '<p>百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折百搭日韩风衣清仓1折</p>', 0, 1221723979, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (15, 3, '8月人气日韩家居1折', '<p>8月人气日韩家居1折8月人气日韩家居1折8月人气日韩家居1折8月人气日韩家居1折8月人气日韩家居1折8月人气日韩家居1折8月人气日韩家居1折8月人气日韩家居1折</p>', 1, 1221723995, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (16, 3, '经典的18家创意小店', '<p>经典的18家创意小店经典的18家创意小店经典的18家创意小店经典的18家创意小店经典的18家创意小店经典的18家创意小店</p>', 2, 1221724007, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (17, 3, '品牌男装买一送一2折', '<p>品牌男装买一送一2折品牌男装买一送一2折品牌男装买一送一2折品牌男装买一送一2折品牌男装买一送一2折品牌男装买一送一2折品牌男装买一送一2折</p>', 3, 1221724021, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (18, 3, '韩版修身超赞T恤特卖', '<p>韩版修身超赞T恤特卖韩版修身超赞T恤特卖韩版修身超赞T恤特卖韩版修身超赞T恤特卖韩版修身超赞T恤特卖韩版修身超赞T恤特卖韩版修身超赞T恤特卖韩版修身超赞T恤特卖</p>', 4, 1221724040, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (19, 3, '惊爆！北京机票70元起', '<p>惊爆！北京机票70元起惊爆！北京机票70元起惊爆！北京机票70元起惊爆！北京机票70元起惊爆！北京机票70元起惊爆！北京机票70元起</p>', 5, 1221724052, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (20, 3, '美鞋靓包换季大出清1折', '<p>美鞋靓包换季大出清1折美鞋靓包换季大出清1折美鞋靓包换季大出清1折美鞋靓包换季大出清1折美鞋靓包换季大出清1折美鞋靓包换季大出清1折美鞋靓包换季大出清1折美鞋靓包换季大出清1折</p>', 6, 1221724069, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (21, 3, '家纺城,买200送100', '<p>家纺城,买200送100家纺城,买200送100家纺城,买200送100家纺城,买200送100家纺城,买200送100家纺城,买200送100</p>', 7, 1221724083, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (22, 4, 'ShopNC发布2.5最新版本', '', 0, 1249022578, 'http://www.multibuy.cn');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (23, 4, '购买ShopNC赠送Discuz!授权', '<p>购买ShopNC赠送Discuz!授权</p>', 1, 1249022695, '');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (24, 4, '技术问题请访问论坛', '', 2, 1249022733, 'http://www.shopnc.net/forum/');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (25, 5, '精挑细选商品 联系卖', '<p>精挑细选商品 联系卖精挑细选商品 联系卖精挑细选商品 联系卖精挑细选商品 联系卖精挑细选商品 联系卖精挑细选商品 联系卖精挑细选商品 联系卖精挑细选商品 联系卖精挑细选商品 联系卖精挑细选商品 联系卖精挑细选商品 联系卖</p>', 0, 1221725337, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (26, 5, '确认购买 选择支付方式', '<p>确认购买 选择支付方式确认购买 选择支付方式确认购买 选择支付方式确认购买 选择支付方式确认购买 选择支付方式确认购买 选择支付方式确认购买 选择支付方式确认购买 选择支付方式确认购买 选择支付方式确认购买 选择支付方式</p>', 1, 1221725349, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (27, 5, '确认收货 作出真实', '<p>确认收货 作出真实确认收货 作出真实确认收货 作出真实确认收货 作出真实确认收货 作出真实确认收货 作出真实确认收货 作出真实确认收货 作出真实确认收货 作出真实</p>', 2, 1221725686, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (28, 6, '成为卖家 上传发布商品', '<p>成为卖家 上传发布商品成为卖家 上传发布商品成为卖家 上传发布商品成为卖家 上传发布商品成为卖家 上传发布商品成为卖家 上传发布商品</p>', 0, 1221725725, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (29, 6, '管理店铺 发货收款评价', '<p>管理店铺 发货收款评价管理店铺 发货收款评价管理店铺 发货收款评价管理店铺 发货收款评价管理店铺 发货收款评价管理店铺 发货收款评价</p>', 1, 1221725738, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (30, 6, '申请推荐 使用拍拍助理', '<p>申请推荐 使用拍拍助理申请推荐 使用拍拍助理申请推荐 使用拍拍助理申请推荐 使用拍拍助理申请推荐 使用拍拍助理申请推荐 使用拍拍助理申请推荐 使用拍拍助理</p>', 2, 1221725750, NULL);
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (31, 7, '花团锦簇入秋，暖调花饰渐流行', '<p>花团锦簇入秋，暖调花饰渐流行花团锦簇入秋，暖调花饰渐流行花团锦簇入秋，暖调花饰渐流行花团锦簇入秋，暖调花饰渐流行花团锦簇入秋，暖调花饰渐流行花团锦簇入秋，暖调花饰渐流行</p>', 0, 1221890712, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (32, 7, '晒后修复美脚请选购美肤的鞋子', '<p>晒后修复美脚请选购美肤的鞋子晒后修复美脚请选购美肤的鞋子晒后修复美脚请选购美肤的鞋子晒后修复美脚请选购美肤的鞋子晒后修复美脚请选购美肤的鞋子晒后修复美脚请选购美肤的鞋子晒后修复美脚请选购美肤的鞋子</p>', 1, 1221890726, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (33, 7, '女孩疯狂爱上“洛莉”手提电脑', '<p>女孩疯狂爱上&ldquo;洛莉&rdquo;手提电脑女孩疯狂爱上&ldquo;洛莉&rdquo;手提电脑女孩疯狂爱上&ldquo;洛莉&rdquo;手提电脑女孩疯狂爱上&ldquo;洛莉&rdquo;手提电脑女孩疯狂爱上&ldquo;洛莉&rdquo;手提电脑女孩疯狂爱上&ldquo;洛莉&rdquo;手提电脑</p>', 2, 1221890748, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (34, 7, '为型男赤裸小腿的短裤风来袭', '<p>为型男赤裸小腿的短裤风来袭为型男赤裸小腿的短裤风来袭为型男赤裸小腿的短裤风来袭为型男赤裸小腿的短裤风来袭为型男赤裸小腿的短裤风来袭为型男赤裸小腿的短裤风来袭</p>', 3, 1221890764, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (35, 7, 'T恤百变搭配 入秋后照样能穿', '<p>T恤百变搭配 入秋后照样能穿T恤百变搭配 入秋后照样能穿T恤百变搭配 入秋后照样能穿T恤百变搭配 入秋后照样能穿T恤百变搭配 入秋后照样能穿</p>', 4, 1221890793, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (36, 7, '摄影摄像摄影摄像摄影摄像', '<p>花团锦簇入秋，暖调花饰渐流行花团锦簇入秋，暖调花饰渐流行</p>', 5, 1221890847, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (37, 7, '随身视听随身视听随身视听', '<p>随身视听随身视听随身视听随身视听随身视听随身视听随身视听随身视听随身视听</p>', 6, 1221890861, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (38, 7, '手机通讯手机通讯手机通讯', '<p>手机通讯手机通讯手机通讯手机通讯手机通讯手机通讯手机通讯手机通讯手机通讯手机通讯手机通讯手机通讯手机通讯手机通讯</p>', 7, 1221890885, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (39, 7, '潮流服饰潮流服饰潮流服饰', '<p>潮流服饰潮流服饰潮流服饰潮流服饰潮流服饰潮流服饰潮流服饰潮流服饰潮流服饰潮流服饰潮流服饰潮流服饰</p>', 8, 1221890904, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (40, 7, '美容护肤美容护肤美容护肤', '<p>美容护肤美容护肤美容护肤美容护肤美容护肤美容护肤美容护肤美容护肤美容护肤美容护肤美容护肤美容护肤美容护肤美容护肤美容护肤美容护肤</p>', 9, 1221890921, 'http://www.shopnc.net');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (41, 8, '如何搜索', '', 2, 1248922629, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/151.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (42, 8, '如何注册成为会员', NULL, 1, 1248921487, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/zhuceyudenglu/20090411/148.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (43, 8, '忘记密码', NULL, 3, 1248921639, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/zhuceyudenglu/20090411/150.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (44, 8, '我要买', NULL, 4, 1248922307, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/156.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (45, 10, '在线支付', NULL, 1, 1248922462, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/157.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (46, 8, '查看已购买商品', NULL, 5, 1248922565, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/158.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (47, 11, '如何购物评价', NULL, 1, 1248922684, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/159.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (48, 9, '如何申请开店', NULL, 1, 1248922709, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/160.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (49, 9, '如何管理店铺', NULL, 2, 1248922734, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/161.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (50, 9, '查看售出商品', NULL, 3, 1248922773, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/162.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (51, 9, '如何发货', NULL, 4, 1248922804, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/163.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (52, 9, '商城商品推荐', NULL, 5, 1248922851, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/165.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (53, 12, '会员修改密码', NULL, 1, 1248922887, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/gerenxinxixiugai/20090411/167.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (54, 12, '会员修改个人信息', NULL, 2, 1248922908, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/gerenxinxixiugai/20090411/168.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (55, 12, '修改收货地址', '', 3, 1248925025, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/gerenxinxixiugai/20090411/169.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (56, 11, '举报店主或商品', NULL, 2, 1248925057, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/jubaotousu/20090411/170.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (57, 11, '投诉店铺', '', 3, 1248925392, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/jubaotousu/20090411/171.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (58, 11, '举报申诉', NULL, 4, 1248925379, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/jubaotousu/20090411/172.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (59, 12, '商品发布规则', NULL, 4, 1248925430, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/shangpinguize/20090411/173.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (60, 12, '拍卖规则', NULL, 5, 1248925500, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/shangpinguize/20090411/174.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (61, 10, '如何注册支付宝', NULL, 2, 1248925619, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/disanfangjiaoyipingtai/20090411/180.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (62, 10, '如何注册财付通', NULL, 3, 1248925646, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/disanfangjiaoyipingtai/20090411/181.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (63, 10, '如何注册贝宝', NULL, 4, 1248925697, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/disanfangjiaoyipingtai/20090411/182.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (64, 11, '如何联系卖家', NULL, 5, 1248925732, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/woshimaijia/20090411/183.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (65, 10, '使用预付款购物', NULL, 5, 1248925902, 'http://www.shopnc.net/document/multishop_help/html/document/multishop_help/html/shiyong__qiantai/yufukuan/20090703/214.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (66, 13, '综合多用户商城系统适用范围', NULL, 1, 1248925957, 'http://www.shopnc.net/document/multishop_help/html/shopNCzongheduoyonghubangzhuwendang/20090326/69.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (67, 13, '商城系统需要系统要求', NULL, 2, 1248925988, 'http://www.shopnc.net/document/multishop_help/html/shopNCzongheduoyonghuanzhuang/20090326/70.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (68, 13, '商城系统技术特点', NULL, 3, 1248926020, 'http://www.shopnc.net/document/multishop_help/html/shopNCzongheduoyonghubangzhuwendang/20090326/68.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (69, 13, 'UC整合方法说明', NULL, 4, 1248926090, 'http://www.shopnc.net/document/multishop_help/html/shopNCzongheduoyonghuanzhuang/20090409/147.html');
INSERT INTO `#__news` (`news_id`, `news_c_id`, `news_title`, `news_content`, `news_sort`, `news_date`, `news_jump_url`) VALUES (70, 13, '关于我们', NULL, 5, 1248926121, 'http://www.shopnc.net');

INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (1, '首页问题与帮助');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (2, '首页活动与公告');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (3, 'orange首页活动与促销');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (4, 'orange网站公告');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (5, 'orange首页我是买家');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (6, 'orange首页我是卖家');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (7, 'orange网店经验技巧');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (8, '会员中心');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (9, '店主之家');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (10, '支付方式');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (11, '售后服务');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (12, '客服中心');
INSERT INTO `#__news_class` (`news_c_id`, `news_c_name`) VALUES (13, '关于我们');

INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (4, '|5|', 'news_sort_asc', 30, 3);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (5, '|4|', 'news_sort_asc', 30, 3);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (6, '|3|', 'news_sort_asc', 30, 8);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (8, '|5|', 'news_sort_asc', 30, 3);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (9, '|6|', 'news_sort_asc', 30, 3);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (10, '|7|', 'news_sort_asc', 16, 10);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (11, '|8|', 'news_time_desc', 6, 5);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (12, '|9|', 'news_time_desc', 6, 5);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (13, '|10|', 'news_time_desc', 6, 5);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (14, '|11|', 'news_time_desc', 6, 5);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (15, '|12|', 'news_time_desc', 6, 5);
INSERT INTO `#__news_js` (`news_js_id`, `news_c_id`, `order_by`, `char_num`, `line_num`) VALUES (16, '|13|', 'news_time_desc', 6, 5);

INSERT INTO `#__product_class` (`pc_id`, `pc_u_id`, `pc_name`, `pc_state`, `pc_intro`, `pc_pic`, `pc_sort`, `is_highlight`,`pc_deeppath`) VALUES (1, 0, '腾讯QQ专区', '1', '腾讯QQ专区', '', 1, '0','1');
INSERT INTO `#__product_class` (`pc_id`, `pc_u_id`, `pc_name`, `pc_state`, `pc_intro`, `pc_pic`, `pc_sort`, `is_highlight`,`pc_deeppath`) VALUES (48, 1, 'QQ号', '1', 'QQ号', '', 3, '0','2');

INSERT INTO `#__section` (`section_id`, `section_name`, `section_content`, `section_url`, `is_show`) VALUES(1, '客户中心', '客户中心介绍 ', '', '1');
INSERT INTO `#__section` (`section_id`, `section_name`, `section_content`, `section_url`, `is_show`) VALUES(2, '诚征英才', '诚征英才 ', '', '1');
INSERT INTO `#__section` (`section_id`, `section_name`, `section_content`, `section_url`, `is_show`) VALUES(3, '联系我们', '联系我们 ', '', '1');
INSERT INTO `#__section` (`section_id`, `section_name`, `section_content`, `section_url`, `is_show`) VALUES(4, '网站地图', '网站地图 ', '', '1');
INSERT INTO `#__section` (`section_id`, `section_name`, `section_content`, `section_url`, `is_show`) VALUES(5, '版权说明', '版权说明 ', '', '1');

INSERT INTO `#__shop_class` (`class_id`, `class_name`, `class_state`, `parent_id`, `class_sort`, `class_property`) VALUES (1, '网游/充值卡', '1', 0, 0, '0');
INSERT INTO `#__shop_class` (`class_id`, `class_name`, `class_state`, `parent_id`, `class_sort`, `class_property`) VALUES (10, '移动联通充值中心/IP长途', '1', 1, 0, '0');

INSERT INTO `#__settings` (`variable`, `section`, `value`) VALUES ('extcredits_exp', 'credits', 'a:9:{s:6:"regist";i:10;s:16:"succ_product_put";i:5;s:8:"succ_buy";i:10;s:9:"open_shop";i:10;s:14:"member_certify";i:20;s:11:"shop_entity";i:20;s:10:"good_score";i:10;s:12:"normal_score";i:0;s:9:"bad_score";i:-10;}');
INSERT INTO `#__settings` (`variable`, `section`, `value`) VALUES ('extcredits_points', 'credits', 'a:9:{s:6:"regist";i:0;s:16:"succ_product_put";i:0;s:8:"succ_buy";i:10;s:9:"open_shop";i:0;s:14:"member_certify";i:10;s:11:"shop_entity";i:0;s:10:"good_score";i:5;s:12:"normal_score";i:0;s:9:"bad_score";i:0;}');

INSERT INTO `#__system_group` (`sys_group_id`, `sys_group_name`, `sys_group_area_province`, `sys_group_area_city`, `sys_group_power`, `sys_group_area_id`) VALUES (1, 'administrator', '', '', '|index|index~9999|system|system_baseinfo~1001|system_news~1002|system_email~1003|system_section~1004|system_power_group~1005|system_power_member~1006|system_alipay~1007|system_agreement~1008|system_channel~1009|system_channel_index~1010|system_exchange~1011|system_exchange~1012|system_shop_agreement~1013|system_credits_set~1014|product|product_category~1101|product_attribute~1102|product_product~1103|product_up_price~1104|product_html~1105|product_brand~1106|transaction|transaction_order~1201|transaction_complaint~1202|transaction_report~1202|member|member_manage~1301|member_score~1302|member_receive~1303|member_product_message~1304|member_store_shopmessage~1305|member_system_message~1306|member_personal_certify~1307|member_group~1308|store|store_category~1401|store_shop~1402|store_shoplink~1403|store_shopproductcate~1404|store_entityCheck~1405|tools|tools_area~1711|tools_channel~1701|tools_keyword~1702|tools_filter~1710|tools_adv~1703|tools_vote~1704|tools_link~1705|tools_database_backup~1706|tools_power_log~1707|tools_integration~1708|tools_conformitymember~1709|tools_statistic~1712|finance|finance_predeposit~1801|finance_shoppay~1802|app|app_list~1901|', 0);