<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : own_collection.php   FILE_PATH : \multishop\member\own_collection.php
 * ....用户收藏管理
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Sat Sep 15 16:01:39 CST 2007
 */

require_once("../global.inc.php");

class OwnCollectionManage extends CommonFrameWork{
	/**
	 * 收藏对象
	 *
	 * @var obj
	 */
	var $obj_collection;

	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;
	/**
	 * 商品对象
	 *
	 * @var obj
	 */
	var $obj_product;

	function main(){
		/**
		 * 创建收藏对象
		 */
		if (!is_object($this->obj_collection)){
			require_once("collection.class.php");
			$this->obj_collection = new CollectionClass();
		}

		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("member");

		/**
		 * 语言包
		 */
		$this->getlang("collection");



		switch($this->_input['action']){
			case "new":
				$this->saveCollection();
				break;
			case "save":
				$this->saveCollection();
				break;
			case "aj_del":
				$this->_aj_delCollection();
				break;
			case "del":
				$this->memberMenuModule();
				$this->_delCollection();
				break;
			default:
				$this->_getCollectionList();
		}
	}

	/**
	 * 收藏商店显示页面
	 *
	 */
	function _storeCollection(){
		/**
		 * 页面输出
		 */
		$this->output('collection_genre',   $this->_input['genre']);
		$this->output('collection_id',   $this->_input['collection']);
		$this->showpage("own_collection.store");
	}

	/**
	 * 保存收藏
	 *	$this->_input['collection'] 会员ID
	 */
	function saveCollection(){
		//您尚未登陆
		if($_SESSION['s_login']['login'] != 1){
			echo "-1";   
			exit;
		}
		//自己不成收藏自己
		if ($_SESSION["s_login"]['id'] == $this->_input['collection']){
			echo "0";   
			exit;
		}
		$this->_input['memberid'] = $_SESSION["s_login"]['id'];
		$result = $this->obj_collection->addCollection($this->_input);
		if ($result == false){
			echo "2";   //已经收藏过了
		}else{
			echo "1";   //收藏成功
		}
	}

	/**
	 * 收藏列表
	 *
	 */
	function _getCollectionList(){
		$this->memberMenuModule();
		
		if ($this->_input['genre'] == ""){
			$this->_input['genre'] = "store";
		}
		/**
		 * 创建分页对象
		 */
		if (!is_object($this->obj_page)){
			require_once("commonpage.class.php");
			$this->obj_page = new CommonPage();
		}
		/**
		 * 创建商品对象
		 */
		if (!is_object($this->obj_product)){
			require_once("product.class.php");
			$this->obj_product = new ProductClass();
		}
		
		$this->obj_page->pagebarnum(20);    //每页20条记录
		$collection_array = $this->obj_collection->getCollection($this->obj_page,$_SESSION["s_login"]['id'],$this->_input['genre']);
		$pagelist = $this->obj_page->show(1);      //分页显示
		/**
		 * 页面输出
		 */
		$this->output('collection_array',   $collection_array);
		$this->output('InfoSelectorTarget',Common::getTargetMenu("collection"));
		$this->output('pagelist', $pagelist);
		$this->output('genre', $this->_input['genre']);
		$this->showpage("own_collection.manage");
	}

	/**
	 * 删除收藏
	 *
	 */
	function _delCollection(){
		if (intval($this->_input["collectionid"]) > 0){
			$resutl = $this->obj_collection->deleteOperateCollection(intval($this->_input["collectionid"]),$_SESSION["s_login"]['id']);
		}
		if ($resutl !== true){
			$this->redirectPath("succ","member/own_collection.php?genre=" . $this->_input['genre'],'删除收藏失败');
		}else {
			$this->redirectPath("succ","member/own_collection.php?genre=" . $this->_input['genre'],$this->_lang['langCollDelCollectionOk']);
		}
	}
	
	/**
	 * aj 删除收藏
	 */
	function _aj_delCollection(){
		if (intval($this->_input["collection"]) > 0){
			$this->obj_collection->deleteCollection(intval($this->_input["collection"]),$_SESSION["s_login"]['id'],$this->_input['genre']);
			echo '1';
		}
	}
}
$collection_manage = new OwnCollectionManage();
$collection_manage->main();
unset($collection_manage);
?>