<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : own_member.php   FILE_PATH : \multishop\member\own_member_pay.php
 * ....会员付费
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Sat Jul 3 15:07:41 CST 2008
 */

require ("../global.inc.php");

class OwnMemberPayPal extends CommonFrameWork
{
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	
	/**
	 * 会员付费对象
	 *
	 */
	var $obj_number_pay;
	
	/**
	 * 订单对象
	 * 
	 */
	var $obj_order;
	
	/**
	 * 分页对象
	 *
	 */
	var $obj_page;
	
	/**
	 * 支付对象
	 *
	 */
	var $obj_pay;
	
	/**
	 * 货币对象
	 *
	 */
	var $obj_currency;
	
	/**
	 * 贝宝对象
	 *
	 */
	var $obj_paypal;
	
	function main(){
		
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->obj_member))
		{
			require_once ("member.class.php");
			$this->obj_member = new MemberClass();
		}
		
		/**
		 * 初始化分页类
		 */
		if (!is_object($this->obj_page))
		{
			require_once("commonpage.class.php");
			$this->obj_page = new CommonPage();
		}
		
		/**
		 * 创建会员付费对象
		 */
		if (!is_object($this->obj_number_pay))
		{
			require_once("shop_pay.class.php");
			$this->obj_number_pay = new shopPayClass();
		}
		
		/**
		 * 创建支付对象(在线支付，线下支付)
		 */
		if (!is_object($this->obj_pay))
		{
			require_once("pay_accounts.class.php");
			$this->obj_pay = new payAccountsClass(); 
		}
		
		/**
		 *创建货币对象 
		 */
		if (!is_object($this->obj_currency))
		{
			require_once("exchange.class.php");
			$this->obj_currency = new ExchangeClass();
		}
		
		/**
		 * 创建订单对象
		 */
		if (!is_object($this->obj_order)) 
		{
			require_once("pay_order.class.php");
			$this->obj_order = new payOrderClass();
		}
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("member");

		/**
		 * 语言包
		 */
		$this->getlang("member_pay");
		
		//用户管理界面上的菜单
		$this->memberMenuModule();
		
		/**
		 * 执行操作
		 */
		switch($this->_input['action']){
			case "pay":
				$this->MemberPayPage();
				break;
			case "payment":
				$this->memberPayMent();
				break;
			case 'list':
				$this->listPayNote();
				break;
			default:
				$this->MemberPayPage();
		}
	}	
	
	/**
	 * 会员缴费页面
	 * 
	 */
	function MemberPayPage()
	{
		//取当前会员的信息
		$member_condition = array();
		$member_condition['id'] = $_SESSION['s_login']['id'];
		$member_info = array();
		$member_info = $this->obj_member->getMemberInfo($member_condition,'*','more');

		//判断当前会员是否绑定支付帐号
//		if (empty($member_info['alipay']) && empty($member_info['tenpay']) && empty($member_info['paypal']))
//		{
//			unset($member_condition,$member_info);
//			$this->redirectPath("error","./own_payment.php",'您至少要填写一个支付帐号才可以进行交易');
//		}
		
		//取当前的缴费模式
		$condition = array();
		$condition['mode_type'] = $this->_configinfo['paymode']['shop_pay_mode'];
		
		if ($condition['mode_type'] != 'free')
		{
			$mode_list = array();
			$mode_list = @$this->obj_number_pay->listShopMode($condition);
			unset($condition);
	
			//判断当前的缴费方式（在线支付，线下支付）
			$condition = array();
			$condition['pay_type'] = 2; //线下
			$pay_downline = array();
			$pay_downline = @$this->obj_pay->listLinePayMode($condition);
			if (count($pay_downline) != 0)
			{
				$mark = 2;  //线下
				$this->output("pay_downline",$pay_downline);
			}
			
			$condition['pay_type'] = 1; //在线
			$pay_online = array();
			$pay_online = @$this->obj_pay->listLinePayMode($condition);
			unset($condition);
			if (count($pay_online) != 0)
			{
				$account = array();
				for ($i=0;$i<count($pay_online);$i++)
				{
					if ($pay_online[$i]['pay_account'] != '')
					{
						$account[$i] = $pay_online[$i];
					}
				}

				if (count($account) != 0)
				{
					$mark = 1;	//在线
					$this->output("pay_online",$pay_online);					
				}
			}
			if (count($pay_downline) != 0 && count($account) != 0)
			{
				$mark = 3; //支持2在线和线下支付
			}
			
			//取paypal支持的货币种类
			if (!is_object($this->obj_paypal))
			{
				require_once("../shoppay/paypal/payment_module.php");
				$this->obj_paypal = new paypalPaymentMethod();
			}
			$paypal_info = array();
			$paypal_info = $this->obj_paypal->payment_param();
			
			//取商城支持的货币种类
			$condition_exchange['state'] = 1;
			$exchange_array = @$this->obj_currency->listExchange($condition_exchange);

			$sustain_currency = array();
			for ($i=0;$i<count($exchange_array);$i++)
			{
				$sustain_currency[$i] = $exchange_array[$i]['exchange_name'];
			}			
		
			//取商城支持的paypal货币种类
			$currency_info = array();
			for ($i=0;$i<count($paypal_info);$i++)
			{
				if (in_array($paypal_info['currency'][$i], $sustain_currency))
				{
					$currency_info[$i] = $paypal_info['currency'][$i];
				}
			}

			unset($condition_exchange,$paypal_info,$sustain_currency);
			
			/**
			 * 页面输出
			 */
			$this->output("currency_info",$currency_info);
			$this->output("mode_type",$this->_configinfo['paymode']['shop_pay_mode']);
			$this->output("mark",$mark);
			$this->output("mode_list",$mode_list);
			$this->output("exchange_array",$exchange_array);
			$this->showpage("own_member.pay");
		}
	}
	
	/**
	 * 会员付费操作
	 * 
	 */
	function memberPayMent()
	{
		//判断是否选择了支付方式
		if (empty($this->_input['select_id']))
		{
			$this->redirectPath("error","./own_member_pay.php",$this->_lang['langMPNeedSelectOne']);
		}
			
		//取所选的支付方式
		$pay_info = array();
		$pay_info = $this->obj_pay->getOneLinePay($this->_input['select_id']);

		//取当前会员信息
		$condition = array();
		$condition['id'] = $_SESSION['s_login']['id'];
		$member_info = array();
		$member_info = $this->obj_member->getMemberInfo($condition,'*','more');

		//判断会员是否有所选的在线支付方式的帐号
		if ($this->_input['selectPayType'] == 1) 
		{
			if (empty($member_info[$pay_info['pay_name']]))
			{
				unset($condition,$member_info);
				$this->redirectPath("error","./own_member_pay.php",$this->_lang['langMPNotLock'].$pay_info['pay_name'].$this->_lang['langMPAccounts']);
			}
		}

		//取所选的规格
		$pay_mode = array();
		$pay_mode = $this->obj_number_pay->getOneModeInfo($this->_input['textMode']);
					
		//生成订单号
		$last_id = $this->obj_order->getLastId();
		if("" == $last_id)
		{
			$last_id = 1;
		}
		else
		{
			$last_id += 1;
		}
		$chars = array(
			"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k",
			"l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v",
			"w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G",
			"H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R",
			"S", "T", "U", "V", "W", "X", "Y", "Z"
		);
		include_once("common.class.php");
		$random_string = Common::genRandomString($chars, 4);
			
		//生成会员付费订单内容
		$member_pay_order                    = array();
		$member_pay_order['mpo_code']        = md5($last_id.$random_string);
		$member_pay_order['mpo_member_id']   = $condition['id'];
		$member_pay_order['mpo_member_name'] = $member_info['login_name'];
		$member_pay_order['mpo_mode_id']     = $pay_mode['mode_id'];
		$member_pay_order['mpo_mode']        = (empty($pay_mode['mode_product_number']) && empty($pay_mode['mode_product_show_day'])) ? $pay_mode['mode_money'].$this->_lang['langCYuan'].'/'.$pay_mode['mode_time'].$this->_lang['langMPDay'] : $pay_mode['mode_money'].$this->_lang['langCYuan'].'/'.$this->_lang['langMPCanSaleProduct'].$pay_mode['mode_product_number'].$this->_lang['langMPPiece'].'/'.$this->_lang['langMPCanShow'].$pay_mode['mode_product_show_day'].$this->_lang['langMPDay'];
		$member_pay_order['mpo_money']       = $pay_mode['mode_money'];
		$member_pay_order['mpo_currency']    = $this->_input['select_currency'];
		$member_pay_order['mpo_pay_id']      = $this->_input['select_id'];
		$member_pay_order['mpo_pay_name']    = $pay_info['pay_name'];
		$member_pay_order['mpo_pay_type']    = $this->_input['selectPayType'];
		$member_pay_order['mpo_pay_sign']    = 0; //1为已成功交费,0为未交费
		$member_pay_order['mpo_on_type']     = $this->_configinfo['paymode']['shop_pay_mode'];
		
		unset($pay_info,$condition,$member_info,$pay_mode,$chars);
				
		//保存会员付费订单
		if ($this->obj_order->savePayOrder($member_pay_order))
		{
			if ($this->_input['selectPayType'] == 2) //线下支付
			{
				$this->redirectPath("succ","",$this->_lang['langMPPleaseAdmin']);
			}
			//跳转到支付方式
			@header('location: ../shoppay/'.$member_pay_order['mpo_pay_name'].'/index.php?mpo_code='.$member_pay_order['mpo_code']);
		}
	}
	
	/**
	 * 会员缴费记录
	 *
	 */
	function listPayNote(){
		
		$this->obj_page->pagebarnum(15);
		
		//取当前会员信息
		$condition_member = array();
		$condition_member['mpo_member_id'] = $_SESSION['s_login']['id'];

		//根据会员id 取缴费记录
		$member_note = array();
		$member_note = $this->obj_order->listShopPayNote($condition_member,$this->obj_page);

		$page_list = $this->obj_page->show(1);
		/**
		 * 页面输出
		 */
		$this->output("page_list",$page_list);
		$this->output("member_note",$member_note);
		$this->showpage("own_member_pay.note");
	}
}
$paypal = new OwnMemberPayPal();
$paypal->main();
unset($paypal);
?>