<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : own_message.php   FILE_PATH : \multishop\member\own_message.php
 * ....短消息管理
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Sat Sep 22 11:02:30 CST 2007
 */

require ("../global.inc.php");
class OwnMessageManage extends CommonFrameWork{
	/**
	 * 短消息对象
	 *
	 * @var obj
	 */
	var $obj_message;

	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $objvalidate;
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;

	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $objmember;

	function main(){
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("member");

		/**
		 * 语言包
		 */
		$this->getlang("shop");

		/**
		 * 创建短消息对象
		 */
		if (!is_object($this->obj_message)){
			require_once("message.class.php");
			$this->obj_message = new MessageClass();
		}
		
		//会员菜单
		$this->memberMenuModule();
		/**
		 * 根据参数调用相应的方法
		 */
		switch ($this->_input['action']){
			case "add":
				$this->_addMessage();
				break;
			case "save":
				$this->_saveMessage();
				break;
			case "send":
				//选项卡：收件箱；发件箱
				$this->output('InfoSelectorTarget',Common::getTargetMenu("message"));
				$this->_getList("send");
				break;
			case "show":
				$this->_getMessage();
				break;
			case "re":
				$this->_reMessage();
				break;
			case "del":
				$this->_delMessage();
				break;
			case "clean":
				$this->_clean_message();
				break;
			case "derived":
				$this->_derived_message();
				break;
			default:
				//选项卡：收件箱；发件箱
				$this->output('InfoSelectorTarget',Common::getTargetMenu("message"));
				$this->_getList("receive");
		}
	}

	/**
	 * 得到收件箱列表
	 *
	 * @param string $genre receive收件列表，send保存的发件列表
	 */
	function _getList($genre){
		/**
		 * 创建分页对象
		 */
		if (!is_object($this->obj_page)){
			require_once("commonpage.class.php");
			$this->obj_page = new CommonPage();
		}

		$this->obj_page->pagebarnum(20);    //每页20条记录

		//得到登录会员短消息列表
		$condition['genre'] = $genre;
		$condition['member_name'] = $_SESSION['s_login']['name'];
		$condition['order'] = 2;
		$message_array = $this->obj_message->getMessage($condition,$this->obj_page);

		$pagelist = $this->obj_page->show(1);      //分页显示
		//处理人名称的显示
		if (is_array($message_array)){
			foreach ($message_array as $k=>$v){
				if ($genre == "send"){
					$message_array[$k]['send_name'] = $v['receive_name'];
				}else{
					$message_array[$k]['send_name'] = $v['member_name'];
				}
				$message_array[$k]['send_time'] = @date("Y-m-d H:i",$v['send_time']);
			}
		}
		
		/*统计信箱信件数量*/
		$condition_num['genre'] = $genre;/*收件 发件 类别*/
		$condition_num['member_name'] = $_SESSION['s_login']['name'];/*用户名*/
		$condition_num['isallowdel'] = 1;/*是否允许删除，1为允许*/
		$condition_num['no_message_id'] = 0;/*排除系统信件*/
		$count = $this->_get_message_num($condition_num);
		
		/**
		 * 页面输出
		 */
		$this->output('message_genre',$genre);   //输出列表类型
		$this->output('message_array',$message_array);   //输出短消息列表
		$this->output('message_pagelist',$pagelist);      //输出短消息分页
		$this->output('message_num',$count['count']);   //信息数量
		$this->output('message_percent',$count['percent']);   //信息数量
		$this->showpage('own_message.list');     //显示
	}

	/**
	 * 发送短消息
	 *
	 */
	function _saveMessage(){
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->objvalidate)){
			require_once("commonvalidate.class.php");
			$this->objvalidate = new CommonValidate();
		}

		/**
		 * 创建会员对象
		 */
		if (!is_object($this->objmember)){
			require_once ("member.class.php");
			$this->objmember = new MemberClass();
		}

		/**
		 * 验证信息
		 */

		$this->objvalidate->setValidate(array("input"=>$this->_input['txtReceive_name'],"require"=>"true","validator"=>"Compare","operator"=>"!=","to"=>$_SESSION['s_login']['name'],"message"=>$this->_lang['errShopEnterReceiveMan']));    //请填写接受人名称
		$this->objvalidate->setValidate(array("input"=>$this->_input['txtTitle'],"require"=>"true","message"=>$this->_lang['errShopEnterTitle']));    //请填写标题
		$this->objvalidate->setValidate(array("input"=>$this->_input['txtContent'],"require"=>"true","message"=>$this->_lang['errShopEnterContent']));   //请填写内容
		$error = $this->objvalidate->validate();

		if ($error != "" ){
			//发生错误处理
			$this->redirectPath("error","",$error);
		}else{
			//验证接受短消息的人是否存在
			if ($this->objmember->checkMemberExist(array("member_name"=>$this->_input['txtReceive_name'])) == true){
				//检查接收短信息人的信箱是否已满
				$condition_num['genre'] = 'receive';/*收件 类别*/
				$condition_num['member_name'] = $this->_input['txtReceive_name'];/*用户名*/
				$condition_num['isallowdel'] = 1;/*是否允许删除，1为允许*/
				$condition_num['no_message_id'] = 0;/*排除系统信件*/
				$count = $this->_get_message_num($condition_num);
				if ($count['count'] == 200){
					$this->redirectPath("error","",$this->_lang['errShopReceiveIsFull']);
				}
				//新增一条站内短消息
				$this->_input['member_name'] = $_SESSION['s_login']['name'];
				$this->_input['txtContent'] = Common::replacebr($this->_input['txtContent']);
				$this->obj_message->addMessage($this->_input);

				//发送消息成功，跳转到成功页面
				$this->redirectPath("succ","member/own_message.php",$this->_lang['langShopSucSendOk']);   //您已经成功给对方发送了短消息！
			}else{
				//发生错误处理
				$this->redirectPath("error","",$this->_lang['errShopReceiveNotExist']);   //您发送的会员不存在
			}
		}
	}

	/**
	 * 增加短消息
	 *
	 */
	function _addMessage(){
		$message_array['member_name'] = $this->_input['username'];   //接收人
		$this->output('message_array',$message_array);    //输出留言信息
		$this->showpage('own_message.add');    //显示
	}

	/**
	 * 得到一条短消息
	 *
	 */
	function _getMessage(){

		//得到会员接受到的某条信息
		$condition['genre'] = $this->_input['genre'];
		$condition['member_name'] = $_SESSION['s_login']['name'];
		$condition['message_id'] = $this->_input['messageid'];
		$message_array = $this->obj_message->getOneMessage($condition);
		$message_array['send_time'] = @date("Y-m-d H:i",$message_array['send_time']);
		
		/*判断如果是系统短信，关联系统短信内容*/
		if ($message_array['member_name'] == '0' && is_numeric($message_array['content'])){
			$condition = "";
			$condition['message_system_id'] = $message_array['content'];
			$system_content = $this->obj_message->getOneMessage($condition,'content','message_system');
			$message_array['content'] = $system_content['content'];
		}
		
		/*判断是否未读，如果未读则状态变成已读*/
		if ($message_array['isnew'] == '0'){
			$update_array = array();
			$update_array['isnew'] = 1;
			$this->obj_message->updateMessageState($message_array['message_id'],$update_array);
		}
		
		
		$this->output('message_array',$message_array);   //输出留言信息
		$this->output('message_genre',$this->_input['genre']);    //留言类型

		$this->showpage('own_message.show');   //显示

	}

	/**
	 * 回复短消息
	 *
	 */
	function _reMessage(){
		//得到会员接受到的某条信息
		$condition['genre'] = "receive";
		$condition['member_name'] = $_SESSION['s_login']['name'];
		$condition['message_id'] = $this->_input['messageid'];
		$message_array = $this->obj_message->getOneMessage($condition);
		$this->output('message_array',$message_array);    //输出留言信息
		$this->showpage('own_message.add');  //显示
	}

	/**
	 * 删除短消息
	 *
	 */
	function _delMessage(){
		//删除会员接受或发送的某条留言
		if ($this->_input['messageid'] != ""){

			$condition['genre'] = $this->_input['genre'];
			$condition['send_name'] = $_SESSION['s_login']['name'];
			if ($this->_input['genre'] == 'receive'){
				$this->obj_message->delMessage($this->_input['messageid']);
			}elseif ($this->_input['genre'] == 'send'){
				$update_array = array();
				$update_array['issave'] = 0;
				if (is_array($this->_input['messageid'])){
					foreach ($this->_input['messageid'] as $v){
						$this->obj_message->updateMessageState($v,$update_array);
					}
				}else {
					$this->obj_message->updateMessageState($this->_input['messageid'],$update_array);
				}
			}
			$this->redirectPath("succ","member/own_message.php",$this->_lang['langShopSucDeleMessageOk']);//您已经成功删除了短消息
		}else{
			//如果没有删除的内容则返回上一页
			$this->redirectPath("refer");
		}
	}
	
	/**
	 * 清空收件箱
	 */
	function _clean_message(){
		
		$genre = $this->_input['genre'];/*收件箱或发件箱*/
		if ($genre == 'receive'){
			$condition['isallowdel'] = 1;
			$condition['genre'] = 'receive';
			$condition['member_name'] = $_SESSION['s_login']['name'];
			$condition['order'] = 2;
			$message_array = $this->obj_message->getMessage($condition,$this->obj_page,'message_id');
			/*清空*/
			if (is_array($message_array)){
				foreach ($message_array as $v){
					$this->obj_message->delMessage($v['message_id']);
				}
			}
		}elseif ($genre == 'send'){
			$condition['isallowdel'] = 1;
			$condition['genre'] = 'send';
			$condition['member_name'] = $_SESSION['s_login']['name'];
			$condition['order'] = 2;
			$message_array = $this->obj_message->getMessage($condition,$this->obj_page,'message_id');
			/*清空*/
			if (is_array($message_array)){
				$update_array = array();
				$update_array['issave'] = 0;
				foreach ($message_array as $v){
					$this->obj_message->updateMessageState($v['message_id'],$update_array);
				}
			}
		}
		$this->redirectPath("succ","member/own_message.php",$this->_lang['langShopSucDeleMessageOk']);//您已经成功删除了短消息
	}
	
	/**
	 * 导出短信息
	 */
	function _derived_message(){
		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=message.htm");
		//这里的filename为显示在WEB客户端的文件名。
		header("Content-Description: PHP5 Generated Data");
		
		//得到登录会员短消息列表
		$condition['genre'] = $this->_input['genre'];
		$condition['member_name'] = $_SESSION['s_login']['name'];
		$condition['order'] = 2;
		$message_array = $this->obj_message->getMessage($condition,$this->obj_page,'*');
		//处理人名称的显示
		if (is_array($message_array)){
			foreach ($message_array as $k=>$v){
				if ($genre == "send"){
					$message_array[$k]['send_name'] = $v['receive_name'];
				}else{
					$message_array[$k]['send_name'] = $v['member_name'];
				}
				$message_array[$k]['send_time'] = @date("Y-m-d H:i",$v['send_time']);
			}
		}
		$this->output('genre',$this->_input['genre']);   //输出短消息列表
		$this->output('message_array',$message_array);   //输出短消息列表
		$this->showpage('own_message.derived');     //显示
	}
	
	/**
	 * 统计信箱信件数量
	 */
	function _get_message_num($condition){
		
		$array = $this->obj_message->getMessage($condition,$this->obj_page,'*');
		/*计算信件数量比例*/
		if ($condition['genre'] == 'send'){
			$result['percent'] = intval(count($array));
		}else if ($condition['genre'] == 'receive'){
			$result['percent'] = intval(count($array)/2);
		}
		$result['count'] = count($array);
		return $result;	
	}
	
	
}
$message = new OwnMessageManage();
$message->main();
unset($message);
?>