<?php
/////////////////////////////////////////////////////////////////////////////
// 这个文件是 网城创想多用户商城 项目的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : own_shopstyle.php   FILE_PATH : E:\www\multishop\trunk\member\own_shopstyle.php
 * ....商店模板选择
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Fri Oct 03 10:05:31 CST 2008
 */

require_once("../global.inc.php");

class OwnShopStyleManage extends CommonFrameWork{
	/**
	 * 商铺对象
	 *
	 * @var obj
	 */
	var $obj_shop;
	
	function main(){
		/**
		 * 创建商铺对象
		 */
		if (!is_object($this->obj_shop)){
			require_once("shop.class.php");
			$this->obj_shop = new ShopClass();
		}
		
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("member");
		
		/**
		 * 语言包
		 */
		$this->getlang("shop");
		$this->getlang("shopstyle");
		//会员店铺管理菜单
		$this->shopMenuModule();
		/**
		 * 根据参数调用相应的方法
		 */
		switch ($this->_input['action']){
			case "save":
				$this->_saveStyle();
				break;
			default:
				$this->_getStyleList();
		}
		
	}
	
	/**
	 * 得到样式列表
	 *
	 */
	function _getStyleList(){
		$shop_array = $this->obj_shop->getOneShop($_SESSION['s_shop']['id']);//商店信息
		
		if (file_exists(BasePath . "/templates/storestyle/style.xml")){
			$hdc = new XmlParse(BasePath . "/templates/storestyle/style.xml");
			$data_count = $hdc->count_tag("root:style","1:?");
			for($i=1;$i<=$data_count;$i++){
				$file_name = $hdc->get_attribute("root:style","1:" . $i,"filename");
				$style_name = $hdc->get_tag_text("root:style:value","1:" . $i);
				$style_info = $hdc->get_attribute("root:style","1:" . $i,"info");
				$style_array[$i-1]['file'] = $file_name;
				//$style_array[$i-1]['name'] = $style_name;
				//对模板名称进行转码，转成设置的字符字符编码
//				$style_array[$i-1]['name'] = mb_convert_encoding($style_name,$this->_configinfo['websit']['ncharset'],"UTF-8");
				if ($this->_configinfo['websit']['ncharset'] == 'GBK'){
		        	$style_array[$i-1]['name'] = Common::nc_change_charset($style_name,'utf8_to_gbk');
		        }else {
		        	$style_array[$i-1]['name'] = $style_name;
		        }
				$style_array[$i-1]['info'] = $style_info;
			}
		}
		/**
		 * 页面输出
		 */
		$this->output('shop_array',   $shop_array);      //输出商店信息
		$this->output('style_array',   $style_array);      //输出样式列表列表
		$this->showpage('own_shopstyle.modi');
	}
	
	/**
	 * 修改样式
	 *
	 */
	function _saveStyle(){
		//模板路径
		$templates_path = $this->_configinfo['websit']['site_url'].'/tempates/'.$this->_configinfo['websit']['templatesname'];
		
		$this->_input['hideShopId'] = $_SESSION['s_shop']['id'];
		$this->_input['templates'] = $this->_input['sel_type'];
		if ($this->_input['sel_type'] == '1'){//自定义模板
			$default_shop_style = array(
			'action'=>'save',
			'dragsubmit'=>$this->_lang['langCsave'],
			'bodycolor'=>'#ffffff',
			'bodyimage'=>'',
			'bodyrepeat'=>'',
			'bodyattachment'=>'',
			'fontcolor'=>'',
			'linkcolor'=>'',
			'cursor'=>'url('.$this->_configinfo['websit']['site_title'].'/templates/'.$this->_configinfo['websit']['templatesname'].'/store/img/cursors/mouse010.ani)',
			'showside'=>'0',
			'headcolor'=>'',
			'headimage'=>$this->_configinfo['websit']['site_title'].'/templates/'.$this->_configinfo['websit']['templatesname'].'/store/img/h001.jpg',
			'headrepeat'=>'',
			'headtextcolor'=>'',
			'contentcolor'=>'',
			'contentimage'=>$this->_configinfo['websit']['site_title'].'/templates/'.$this->_configinfo['websit']['templatesname'].'/store/img/h006.jpg',
			'contentrepeat'=>'',
			'sidecolor'=>'',
			'sideimage'=>'',
			'siderepeat'=>'',
			'maincolor'=>'',
			'mainimage'=>'',
			'mainrepeat'=>'',
			'moduleleft'=>'link',
			'cmodule'=>'main_recommended_product',
			'blocktitlecolor'=>'',
			'blocktitleimage'=>'',
			'blocktitlerepeat'=>'',
			'blocktitletextcolor'=>'',
			'blockcolor'=>'',
			'blockimage'=>'',
			'blockrepeat'=>'',
			'blocktextcolor'=>'',
			'choiceblockleft'=>'shop_product_class,intro,proclamation,link',
			'choiceblockmain'=>'main_recommended_product,main_product,main_message',
			'choiceblockright'=>'',
			'layout'=>'1',
			'slayout'=>'2',
		);
			$this->obj_shop->operateShop($this->_input);
			//生成静态文件
			//商铺信息
			$this->shop_id = $_SESSION['s_shop']['id'];
			$shop_array = $this->storeBaseInfo();
			$arr = unserialize($shop_array['shop_style'])?unserialize($shop_array['shop_style']):unserialize($default_shop_style);
			//左边显示
			if ($arr['slayout'] == '2') {
				//页面显示的版区
				$side_template = explode(',',$arr['choiceblockleft']);
				$main_template = explode(',',$arr['choiceblockmain']);
				//抛出左边版区
				$this->output('side_template',$side_template);
				$this->output('main_template',$main_template);
			}else if ($arr['slayout'] == '0') {//右边显示
				//初始化页面内容
				$side_template  = explode(',',$arr['choiceblockright']);
				$main_template  = explode(',',$arr['choiceblockmain']);
				//抛出右边版区
				$this->output('side_template',$side_template);
				$this->output('main_template',$main_template);
			}else if ($arr['slayout'] == '-1') {//两端显示
				//页面显示的版区
				$left_template = explode(',',$arr['choiceblockleft']);
				$right_template = explode(',',$arr['choiceblockright']);
				$main_template = explode(',',$arr['choiceblockmain']);
				//合并左右两边数组
				$side_template_merge = array_merge($left_template,$right_template);
				$side_template = array();
				if (is_array($side_template_merge)){
					foreach ($side_template_merge as $value) {
						$side_template[] = $value;
					}
				}
				//抛出左边版区
				$this->output('left_template',$left_template);
				$this->output('right_template',$right_template);
				$this->output('main_template',$main_template);
				$this->output('side_template',$side_template);
			}else {
				$arr['slayout'] = 2;
			}
			/**
			 * 页面输出
			 */
			//添加title,keyword信息
			$this->output('title_message', $shop_array['shop_name'].' - ');
			$this->output('keyword_message', ','.$shop_array['shop_name']);
			$this->output('arrBlog',$arr);
			$this->output('member_id',$shop_array['member_id']);
			$this->output('shop_url',$shop_array['shop_link']);
			/**
			 * 设置模板路径
			 */
			$this->setsubtemplates("store");
			$html      = $this->fetchpage('store_index_temp');
			$file_name = '../html/store/'.$shop_array['member_id'].'.html';
			//删除原来的店铺模板
			@unlink($file_name);
			//生成静态
			require_once("makehtml.class.php");
			MakeHtml::tohtmlfile($file_name, $html);
			
			$url = $this->_configinfo['websit']['site_url'].'/store/control.php';
			header("location: ".$url);
			exit;
		}else {
			$this->obj_shop->operateShop($this->_input);
			$this->redirectPath("succ","member/own_shopstyle.php",$this->_lang['langSStyleSelectOk']);
		}
		
	}
}
$shop_style = new OwnShopStyleManage();
$shop_style->main();
unset($shop_style);
?>