<?php
require ("../../global.inc.php");

class Alipay extends CommonFrameWork{
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 * 预存款对象
	 *
	 */
	var $obj_predeposit;
	/**
	 * 商城账户对象
	 *
	 * @var obj
	 */
	var $obj_pay;
	
	function main(){
		if($_SESSION['s_login']['id'] == ''){
			$this->redirectPath("error","",$this->_lang['langCMemberIsEmpty']);
		}
		if ($this->_input['predeposit_r_id'] == '' && $this->_input['out_trade_no'] == ''){
			$this->redirectPath("error","",$this->_lang['langCIdIsIllegal']);
		}
		if ($this->_input['predeposit_r_id'] != ''){
			$out_trade_no = $this->_input['predeposit_r_id'];
		}elseif ($this->_input['out_trade_no'] != ''){
			$out_trade_no = $this->_input['out_trade_no'];
		}
		
		/**
		 * 加载语言包
		 */
		$this->getlang('own_predeposit');
		
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->obj_member)){
			require_once ("member.class.php");
			$this->obj_member = new MemberClass();
		}
		/**
		 * 初始化预存款类
		 */
		if (!is_object($this->obj_predeposit)){
			require_once("predeposit.class.php");
			$this->obj_predeposit = new PredepositClass();
		}
		
		//取帐号配置文件信息
		$account_array = $this->_getconfigini("payment.ini.php");
		//验证信息是否与会员相符
		$record_array = $this->obj_predeposit->getOnePredepositRecordById($out_trade_no);
		if ($record_array['member_id'] != $_SESSION['s_login']['id']){
			$this->redirectPath("error","",$this->_lang['langCIdIsIllegal']);
		}
		$array = array();
		$array['online_amount'] = $record_array['online_amount'];//金额
		$array['predeposit_r_id'] = $record_array['predeposit_r_id'];//信息ID
		$array['url'] = $this->_configinfo['websit']['site_url'].'/member/own_predeposit.php?action=record_list';//查看链接
		$array['email'] = $account_array['online']['alipay'];//系统邮箱
		$array['payment_trade'] = $record_array['payment_trade'];//交易流水号
		$array['site_url'] = $this->_configinfo['websit']['site_url'];//网站地址
		$array['alipay_partner'] = $account_array['online']['alipay_partner'];//合作伙伴ID
		$array['alipay_security_code'] = $account_array['online']['alipay_security_code'];//安全检验码
		$array['_input_charset'] = $this->_configinfo['websit']['ncharset'];
		if (strtoupper($this->_configinfo['websit']['ncharset']) == 'UTF-8'){
			$this->_lang['langPredepositPay'] = Common::nc_change_charset($this->_lang['langPredepositPay'],'utf8_to_gbk');
		}
		$array['subject'] = $this->_lang['langPredepositPay'];
		$array['body'] = $this->_lang['langPredepositPay'];
		return $array;
	}

	/**
	 * 接收支付宝的通知
	 */
	 function input_alipay(){
		return $this->_input;
	 }
	
	/**
	 * 更新充值记录交易状态
	 * $out_trade_no 交易编号
	 * $trade_status 交易状态,$out_trade_no,$trade_status
	 */
	function update_record($input){
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->obj_member)){
			require_once ("member.class.php");
			$this->obj_member = new MemberClass();
		}
		/**
		 * 初始化预存款类
		 */
		if (!is_object($this->obj_predeposit)){
			require_once("predeposit.class.php");
			$this->obj_predeposit = new PredepositClass();
		}
		
		$predeposit_r_id = $input['out_trade_no'];//充值记录
		$record_array = $this->obj_predeposit->getOnePredepositRecordById($predeposit_r_id);
		if (is_array($record_array)){
			//更新充值信息
			$value_array = array();
			$value_array['predeposit_r_id'] = $predeposit_r_id;
			$value_array['payment_trade'] = $input['trade_no'];
			$value_array['record_state'] = '1';
			$this->obj_predeposit->updatePredepositRecord($value_array);
			unset($value_array);
			//增加预付款明细
			$value_array = array();
			$value_array['predeposit_type'] = '0';//会员充值
			$value_array['predeposit_state'] = '1';
			$value_array['member_id'] = $record_array['member_id'];
			$value_array['available_amount'] = $record_array['online_amount'];
			$value_array['system_remark'] = $this->_lang['langAlipayOnlinePay'];
			$value_array['create_time'] = time();
			$value_array['update_time'] = time();
			$value_array['payment'] = $record_array['payment'];
			$value_array['predeposit_r_id'] = $predeposit_r_id;
			$this->obj_predeposit->addPredepositDetail($value_array);
			unset($value_array);
			//对会员帐户进行资金操作
			$value_array = array();
			$value_array['available_predeposit'] = $record_array['online_amount'];
			$this->obj_member->modifyMember($value_array,$record_array['member_id'],'predeposit');
			unset($value_array);
			return true;
		}else {
			echo "ID非法";
		}
	}
}

$alipay_manage = new Alipay();
$array = $alipay_manage->main();

$partner = $array["alipay_partner"];	//合作伙伴ID，使用支付宝之前必须填写！！！
$security_code = $array["alipay_security_code"];	//安全检验码，使用支付宝之前必须填写！！！
$seller_email = $array['email'];//卖家邮箱
$_input_charset = $array['_input_charset']; //字符编码格式
$sign_type = "MD5"; //加密方式
$transport= "http";//访问模式,你可以根据自己的服务器是否支持ssl访问而选择http以及https访问模式
$notify_url = $array['site_url']."/predeposit_pay/alipay/notify_url.php";// 异步返回地址
$return_url = $array['site_url']."/predeposit_pay/alipay/return_url.php"; //同步返回地址
?>