<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : index.php   FILE_PATH : \multishop\store\index.php
 * ....商铺首页面
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Fri Sep 14 15:21:19 CST 2007
 */

require_once("../global.inc.php");

class StoreIndex extends CommonFrameWork{
	/**
	 * 商铺宝贝分类对象
	 *
	 * @var obj
	 */
	var $obj_category;
	/**
	 * 商铺友情链接
	 *
	 * @var obj
	 */
	var $obj_link;
	/**
	 * 商铺留言对象
	 *
	 * @var obj
	 */
	var $obj_shop_message;
	/**
	 * 商品对象
	 *
	 * @var obj
	 */
	var $obj_product;
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 * 2级域名对象
	 *
	 * @var obj
	 */
	var $obj_domain;
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;
	/**
	 * 商铺信息
	 *
	 * @var obj
	 */
	var $shop_array;
	/**
	 * 商品订单信息
	 *
	 * @var obj
	 */
	var $obj_product_order;
	/**
	 * 商店信息
	 *
	 * @var obj
	 */
	var $obj_shop;
	/**
	 * 地区信息
	 *
	 * @var obj
	 */
	var $obj_area;
	/**
	 * 店铺标签
	 *
	 * @var object
	 */
	var $obj_shoptag;	
	function main(){
		/**
		 * 创建商铺宝贝分类对象
		 */
		if (!is_object($this->obj_category)){
			require_once("shopproductcategory.class.php");
			$this->obj_category = new ShopProductCategoryClass();
		}
		/**
		 * 创建商铺留言对象
		 */
		if (!is_object($this->obj_shop_message)){
			require_once("shopmessage.class.php");
			$this->obj_shop_message = new ShopMessageClass();
		}
		/**
		 * 创建商铺友情链接对象
		 */
		if (!is_object($this->obj_link)){
			require_once("shoplink.class.php");
			$this->obj_link = new ShopLinkClass();
		}
		/**
		 * 创建商品对象
		 */
		if (!is_object($this->obj_product)){
			require_once("product.class.php");
			$this->obj_product = new ProductClass();
		}
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->obj_member)){
			require_once ("member.class.php");
			$this->obj_member = new MemberClass();
		}
		/**
		 * 初始化分页类
		 */
		if (!is_object($this->obj_page)){
			require_once("commonpage.class.php");
			$this->obj_page = new CommonPage();
		}
		/**
		 * 初始化域名解析类
		 */
		if (!is_object($this->obj_domain)){
			require_once("domain.class.php");
			$this->obj_domain = new Domain();
		}
		/**
		 * 实例化商品订单类
		 */
		if (!is_object($this->obj_product_order)){
			require_once("order.class.php");
			$this->obj_product_order = new ProductOrderClass();
		}
		/**
		 * 实例化商店类
		 */
		if (!is_object($this->obj_shop)){
			require_once("shop.class.php");
			$this->obj_shop = new ShopClass();
		}
		/**
		 * 实例化地区类
		 */
		if (!is_object($this->obj_area)){
			require_once("area.class.php");
			$this->obj_area = new AreaClass();
		}
		/**
		 * 实例化店铺标签类
		 */
		if (!is_object($this->obj_shoptag)) {
			include_once("shoptag.class.php");
			$this->obj_shoptag = new ShopTag ();
		}		
		/**
		 * 语言包
		 */
		$this->getlang("store");
		$this->getlang("store_control,shop");
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("store");
		
		switch($this->_input['action']){
			case "ajax_intro":
				$this->check_shop();
				$this->_ajax_intro();
				break;
			case "ajax_proclamation":
				$this->check_shop();
				$this->_ajax_proclamation();
				break;
			case "ajax_shop_product_class":
				$this->check_shop();
				$this->_ajax_shop_product_class();
				break;
			case "ajax_link":
				$this->check_shop();
				$this->_ajax_link();
				break;
			case "ajax_main_product":
				$this->check_shop();
				$this->_ajax_main_product();
				break;
			case "ajax_main_message":
				$this->check_shop();
				$this->_ajax_main_message();
				break;
			case "ajax_head":
				$this->check_shop();
				$this->_ajax_head();
				break;
			case "ajax_main_recommended_product":
				$this->check_shop();
				$this->_ajax_main_recommended_product();
				break;
			case "ajax_shoptag":
				$this->check_shop();
				$this->_ajax_shop_tag();
				break;				
			case "getQuickLinks":
				$this->_getQuickLinks();
				break;
			default:
				$this->check_shop();
				$this->judgeShopAvailabilityTime();
				
		}
	}
	
	/**
	 * 判断店铺的有效期限   按店铺有效期限收费ontime
	 * 
	 */
	function judgeShopAvailabilityTime()
	{
		//判断店铺使用时间
		if ($this->_configinfo['paymode']['shop_pay_mode'] == '1'){
			$condition['id'] = $this->_input['userid'];
			$member_array = $this->obj_member->getMemberInfo($condition,'*','more');
			if (time() > $member_array['shop_availability_time']){//过期
				unset($condition,$member_array);
				$this->redirectPath("error",'',$this->_lang['langSetShopOverdue']);
			}
		}
		
		//判断模板形式
		if ($this->shop_array['templates'] == '0'){//现有模板
			//店铺标签导航
			$tag_array = $this->_get_shop_tag();
			//店铺商品类别
			$category_array = $this->get_shop_product_cate();
			//店铺友情连接
			$link_array = $this->get_link();
			$tag_content = "";
			if ($this->_input['tag'] != '') {
				//获取标签内容
				if (is_array($tag_array)) {
					foreach ($tag_array as $kt=>$vt) {
						if ($tag_array[$kt]['tag_id'] == $this->_input['tag']) {
							$tag_content = $tag_array[$kt]['tag_content'];
							break;
						}
					}
				}
			} 
			if (empty($tag_content)){
				//店铺留言
				$message_array = $this->get_message();				
				//更新到期团购商品订单状态
				$this->obj_product_order->updateProductOrderInCondition();
				//更新到期商品状态
				$this->obj_product->updateProductInCondition();				
				/**
				 * 宝贝查询条件
				 */
				$obj_condition['key'] = $this->_input['keyword'];
				$obj_condition['keygenre'] = $this->_input['searchtype'];
				$obj_condition['member'] = $this->_input['userid'];
				$obj_condition['p_class_id'] = $this->_input['classid'];
				switch ($this->_input['list']){
					case "new":
						break;
					case "end":
						break;
					default:
						break;
				}
				//商品状态
				$obj_condition['state'] = 1;
				/**
				 * 按价格排序
				 */
				if($this->_input['price'] == "down"){
					$obj_condition['order'] = 2;
					$obj_condition['sorttype'] = 0;
				}elseif($this->_input['price'] == "up"){
					$obj_condition['order'] = 2;
					$obj_condition['sorttype'] = 1;
				}
				//商铺所有的商品
				$this->obj_page->pagebarnum(12);
				$product_array = $this->obj_product->getProductList($obj_condition, $this->obj_page); 
				$page_list = $this->obj_page->show(1);
				//判断商品是否使用静态链接
				$product_array = $this->obj_product->checkProductIfHtml($product_array,$this->_configinfo['productinfo']['ifhtml']);
				//对商品图片进行缩放
				$product_array = $this->obj_product->productPicRatio($product_array,'p_pic',"100");
				for($i=0;$i<count($product_array);$i++){
					//剩余时间
					$left_time = $product_array[$i]['p_end_time'] - time();
					$product_array[$i]['left_days'] = intval($left_time / (24*60*60));
					$product_array[$i]['left_hours'] = intval(($left_time % (24*60*60)) / (60*60));
					$product_array[$i]['left_minutes'] = intval((($left_time % (60*60))) / 60);
				}
				
				//推荐商品
				$obj_recommended_condition['member'] = $this->_input['userid'];
				$obj_recommended_condition['store_recommended'] = 1;
				$product_store_recommended = $this->obj_product->getProductList($obj_recommended_condition, $obj_recommended_page);
				$product_store_recommended = $this->obj_product->checkProductIfHtml($product_store_recommended,$this->_configinfo['productinfo']['ifhtml']);
				//对推荐商品图片进行缩放
				$product_store_recommended = $this->obj_product->productPicRatio($product_store_recommended,'p_pic',"100");
				//商品地址 开启二级域名的情况
				if ($this->_configinfo['subdomain']['ifsubdomain'] == 1){
					foreach ($product_store_recommended as $v => $k){
						$product_store_recommended[$v]['html_url'] = str_replace('..',$this->_configinfo['websit']['site_url'],$v['html_url']);
					}
					foreach ($product_array as $v => $k){
						$product_array[$v]['html_url'] = str_replace('..',$this->_configinfo['websit']['site_url'],$v['html_url']);
					}
				}				
			}
			//取店铺信用度
			$condition_member['id'] = $this->_input['userid'];
			$member_array = $this->obj_member->getMemberInfo($condition_member,"*","more");
			$buy_score = $this->obj_member->creditLevel($member_array['buy_score']);
			$sale_score = $this->obj_member->creditLevel($member_array['sale_score']);			
			//店铺地区
			$shop_area = $this->get_area();
			//插件
			$this->get_app();
			
			/**
			 * 页面输出
			 */
			$this->output('title_message', $this->shop_array['shop_name'].'-');
			$this->output('keyword_message', ','.$this->shop_array['shop_name']);
			$this->output('userid',   $this->_input['userid']);     //输出店主ID
			$this->output('classid',   $this->_input['classid']);     //输出店铺商品分类ID
			$this->output('product_array',   $product_array);     //输出商铺所有的商品
			$this->output('product_count',$member_array['sell_product_count']);
			$this->output("shop_recommended_product_array", $product_store_recommended);	//输出店铺推荐商品
			$this->output('message_array',   $message_array);     //输出商铺留言
			$this->output('category_array',   $category_array);     //输出商铺分类
			$this->output('member_array',   $member_array);     //店主会员信息
			$this->output('link_array',   $link_array);     //输出商铺友情连接
			$this->output("page_list", $page_list);
			$this->output("buy_score", $buy_score);//买家信用
			$this->output("sale_score", $sale_score);//卖家信用
			$this->output("shop_area", $shop_area);
			$this->output("tag_array",$tag_array);//标签列表
			$this->output("tag_content",$tag_content);//标签内容
			$this->output("view_type", $this->_input['view_type']);//浏览形式 列表/图片
			$this->output("list", $this->_input['list']);//店铺商品排序
			$this->output("price_sort", $this->_input['price']);//店铺价格排序
			$this->showpage("store_index.default");
		}else {//自定义模板
			//如果没有静态页面，则重新生成
			if (!file_exists(BasePath."/html/store/".$this->_input['userid'].".html")){
				/**
				 * 创建店铺静态页面对象
				 */
				if (!is_object($obj_html_store)){
					require_once("../home/html.store.php");
					$this->obj_html_store = new HtmlStoreManage();
				}
				$result = $this->obj_html_store->_make_store_html($this->shop_array['shop_id']);
			}
			echo file_get_contents("../html/store/".$this->_input['userid'].".html");
			exit;
		}
	}
	/**
	 * 获取店铺导航标签
	 *
	 * @return array
	 */
	function _get_shop_tag(){
		//店铺标签导航
		$condition['shop_id'] = $this->shop_array['shop_id'];
		$condition['tag_display'] = 'block';
		$condition['order_by'] = "tag_sort desc";
		$tag_array = $this->obj_shoptag->getTagList ($condition,$obj_page);	
		return 	$tag_array;
	}
	/**
	 * 调用头部
	 */
	function _ajax_head(){
		/**
		 * 设置模板路径 
		 */
		$this->setsubtemplates("");
		$this->showpage("header");
	}
	/**
	 * 静态商铺首页AJAX读取信息——商铺标签
	 *
	 */
	function _ajax_shop_tag () {
		$tag_array = $this->_get_shop_tag();
		/**
		 * 页面输出
		 */		
		$this->output("tag_id",$this->_input['tag']);
		$this->output("tag_array", $tag_array);
		$this->showpage('store_ajax_tag');
	}
	/**
	 * 静态商铺首页AJAX读取信息——商铺内容
	 */
	function _ajax_intro(){
		//取店铺信用度
		$condition_member['id'] = $this->_input['userid'];
		$member_array = $this->obj_member->getMemberInfo($condition_member,"*","more");
		$buy_score = $this->obj_member->creditLevel($member_array['buy_score']);
		$sale_score = $this->obj_member->creditLevel($member_array['sale_score']);
		//店铺地区
		$shop_area = $this->get_area();
		/**
		 * 页面输出
		 */
		$this->output("shop_area", $shop_area);
		$this->output("member_array", $member_array);
		$this->output("buy_score", $buy_score);//买家信用
		$this->output("sale_score", $sale_score);//卖家信用
		$this->output('product_count',$member_array['sell_product_count']);
		$this->showpage('store_ajax_intro');
	}
	/**
	 * 静态商铺首页AJAX读取信息——商铺公告
	 */
	function _ajax_proclamation(){
		/**
		 * 页面输出
		 */
		$this->output("shop_proclamation", $this->shop_array['proclamation']);//商铺公告
		$this->showpage('store_ajax_proclamation');
	}
	/**
	 * 静态商铺首页AJAX读取信息——商铺商品分类
	 */
	function _ajax_shop_product_class(){
		$category_array = $this->get_shop_product_cate();
		/**
		 * 页面输出
		 */
		$this->output('shop_category',$category_array);
		$this->showpage('store_ajax_shop_product_class');
	}
	/**
	 * 静态商铺首页AJAX读取信息——商铺友情链接
	 */
	function _ajax_link(){
		$link_array = $this->get_link();
		/**
		 * 模板输出
		 */
		$this->output('shop_link',$link_array);
		$this->showpage('store_ajax_link');
	}
	/**
	 * 静态商铺首页AJAX读取信息——商铺商品列表
	 */
	function _ajax_main_product(){
		//更新到期团购商品订单状态
		$this->obj_product_order->updateProductOrderInCondition();
		//更新到期商品状态
		$this->obj_product->updateProductInCondition();
		//商铺所有的商品
		$obj_condition['member'] = $this->shop_array['member_id'];
		$obj_condition['order'] = 1;
		$obj_condition['sorttype'] = 1;
		$obj_condition['state'] = 1;
		$this->obj_page->pagebarnum(15);
		$product_array = $this->obj_product->getProductList($obj_condition, $this->obj_page);
		//判断是否使用静态链接
		$product_array = $this->obj_product->checkProductIfHtml($product_array,$this->_configinfo['productinfo']['ifhtml']);
		//对商品图片进行缩放
		$product_array = $this->obj_product->productPicRatio($product_array,'resize_pic',"150");
		if (is_array($product_array)){
			for($i=0;$i<count($product_array);$i++){
				//商品剩余时间
				$left_time = $product_array[$i]['p_end_time'] - time();
				$product_array[$i]['left_days'] = intval($left_time / (24*60*60));
				$product_array[$i]['left_hours'] = intval(($left_time % (24*60*60)) / (60*60));
				$product_array[$i]['left_minutes'] = intval((($left_time % (60*60))) / 60);
				//静态链接
				if ($v['html_url'] != ''){
					$product_array[$i]['html_url'] = $this->_configinfo['websit']['site_url'].str_replace('..','',$product_array[$i]['html_url']);
				}
				//切商品名
				$product_array[$i]['p_short_name'] = Char_class::cut_str($product_array[$i]['p_name'],30,0,$this->_configinfo['websit']['ncharset']);
			}
		}
		/**
		 * 页面输出
		 */
		$this->output('shop_product',$product_array);
		$this->showpage('store_ajax_product');
	}
	/**
	 * 静态商铺首页AJAX读取信息——商铺留言
	 */
	function _ajax_main_message(){
		$message_array = $this->get_message();
		/**
		 * 模板输出
		 */
		$this->output('shop_message',$message_array);
		$this->showpage('store_ajax_message');
	}
	/**
	 * 静态商铺首页AJAX读取信息——橱窗推荐商品
	 */
	function _ajax_main_recommended_product(){
		$obj_recommended_condition['member'] = $this->shop_array['member_id'];
		$obj_recommended_condition['store_recommended'] = 1;
		$this->obj_page->pagebarnum(10);    //每页10条记录
		$product_store_recommended = $this->obj_product->getProductList($obj_recommended_condition, $this->obj_page);
		//是否使用静态页
		$product_store_recommended = $this->obj_product->checkProductIfHtml($product_store_recommended,$this->_configinfo['productinfo']['ifhtml']);
		if (is_array($product_store_recommended)){
			foreach ($product_store_recommended as $k => $v){
				if ($v['html_url'] != ''){
					$product_store_recommended[$k]['html_url'] = $this->_configinfo['websit']['site_url'].str_replace('..','',$v['html_url']);
				}
				$product_store_recommended[$k]['p_short_name'] = Char_class::cut_str($product_store_recommended[$k]['p_name'],30,0,$this->_configinfo['websit']['ncharset']);
			}
		}
		/*对商品图片进行缩放*/
		$product_store_recommended = $this->obj_product->productPicRatio($product_store_recommended,'resize_pic',"150");
		/**
		 * 模板输出
		 */
		$this->output('shop_store_recommended',$product_store_recommended);
		$this->showpage('store_ajax_recommended_product');
	}
	
	/**
	 * head快速导航
	 */
	function _getQuickLinks(){
		//设置模板路径
		$this->setsubtemplates("");
		$array = $this->getQuickLinks();
		//判断是否登录
		if ($_SESSION["s_login"]['login'] == 1){
			$this->output('login_sign',1);
			//判断是否有店铺
			if ($_SESSION["s_login"]['type'] == '1'){
				$this->output('shop_sign',1);
			}
		}
		
		//插件列表
		$app_list = $this->menuAppList();
		/**
		 * 页面输出
		 */
		$this->output('QuickLinks',$array);
		$this->output('app_list',$app_list);
		$this->showpage("quick_links");
	}
	
	
	/**
	 * 对店铺链接进行检测
	 */
	function check_shop(){
		//开启2级域名
		if($this->_configinfo['subdomain']['ifsubdomain'] == '1' && $this->_configinfo['subdomain']['domainroot'] != ''){
			if (intval($this->_input['userid']) > 0 ){//跳转到该会员的2级域名下
				$shop_array = $this->obj_shop->getOneShopByMemeberId($this->_input['userid']);
				if (empty($shop_array)){//没有店铺
					$this->redirectPath("error",$this->_configinfo['websit']['site_url']."/index.html",$this->_lang['langStoreMemberIsNotOpen']);
				}
			}else {//切割域名，取userid
				$line = @explode($this->_configinfo['subdomain']['domainroot'],$_SERVER['HTTP_HOST']);
				$line = @explode($this->_configinfo['subdomain']['domainprefix'],$line[0]);
				$domain_id = $line[1];
				unset($line);
				$shop_array = $this->obj_shop->getOneShopByDomainId($domain_id);
				if (!empty($shop_array)){//有会员
					$this->_input['userid'] = $shop_array['member_id'];
				}else {//如果是非法的，则跳转
					@header("Location: ".$this->_configinfo['websit']['site_url']."/index.html");
					exit;
				}
			}
			//本店2级域名链接
			$domain_url = 'http://'.$this->_configinfo['subdomain']['domainprefix'].$shop_array['shop_domain'].$this->_configinfo['subdomain']['domainroot'];
			$this->output('shop_domain_url',$domain_url);
		}else {//不开启2级域名,判断如果以2级域名的形式访问的话，则对链接进行整理，为普通访问形式
			if (intval($this->_input['userid']) <= 0 ){
				//切割域名，取userid
				$line = @explode($this->_configinfo['subdomain']['domainroot'],$_SERVER['HTTP_HOST']);
				$line = @explode($this->_configinfo['subdomain']['domainprefix'],$line[0]);
				$user_id = $line[1];
				unset($line);
				if (intval($user_id) > 0){
					@header("Location: ".$this->_configinfo['websit']['site_url'].'/store/index.php?userid='.$user_id);
				}else {//如果是非法的，则跳转
					@header("Location: ".$this->_configinfo['websit']['site_url']."/index.html");
				}
				exit;
			}
		}
		//判断商铺信息，并且输出到模板上商铺信息
		$this->ifStore();
		$this->shop_array = $this->storeBaseInfo();
		return true;
	}
	
	/**
	 * 取店铺 
	 */
	function get_shop_product_cate(){
		//店铺商品分类
		$condition_shop_product_cate['shop_id'] = $this->shop_array['shop_id'];
		$condition_shop_product_cate['order_by'] = " shop_product_class.class_parent_id asc,shop_product_class.class_sort asc,shop_product_class.class_id asc ";
		$category_array = $this->obj_category->getCategory($condition_shop_product_cate,$page);
		//整理数组为多级
		$category_array = $this->obj_category->_makeCategoryArray($category_array);
		return $category_array;
	}
	
	/**
	 * 取友情链接
	 */
	function get_link(){
		$condition['shop_id'] = $this->shop_array['shop_id'];
		$link_array = $this->obj_link->getLink($condition,$page);
		//转换成2级域名形式
		if(is_array($link_array)){
			$link_domain = $this->obj_domain->getDomain($_SERVER['HTTP_HOST']);
			foreach($link_array as $k => $v){
				if ($v['shop_domain'] != '' && $this->_configinfo['subdomain']['ifsubdomain'] == '1'){
					$link_array[$k]['url'] = 'http://'.$this->_configinfo['subdomain']['domainprefix'].$v['shop_domain'].'.'.$link_domain;
				}else {
					$link_array[$k]['url'] = $this->_configinfo['websit']['site_url']."/store/index.php?userid=".$v['link_shop_id'];
				}
			}
		}
		return $link_array;
	}
	
	/**
	 * 取店铺地区
	 */
	function get_area(){
		if ($this->shop_array['shop_area_id'] !=''){
			$sel_area = $this->obj_area->getAreaPathList($this->shop_array['shop_area_id']);
			return $sel_area;
		}else {
			return false;
		}
	}
	
	/**
	 * 取店铺留言
	 */
	function get_message(){
		$this->obj_page->pagebarnum(3);
		$message_array = $this->obj_shop_message->getMessage($this->obj_page,$this->shop_array['shop_id'],true);
		if (is_array($message_array)){
			foreach ($message_array as $k => $v){
				$message_array[$k]['message_time'] = date("Y-m-d H:i",$v['message_time']);
			}
		}
		return $message_array;
	}
	
	/**
	 * 插件输出
	 */
	function get_app(){
		//插件
		$this->appModuleSignOutput('ntalker','ntalker_sign');
	}
}
$store = new StoreIndex();
$store->main();
unset($store);
?>