<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : intro.php   FILE_PATH : \multishop\store\intro.php
 * ....店铺介绍
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Sat Sep 15 10:18:10 CST 2007
 */

require_once("../global.inc.php");

class StoreIntro extends CommonFrameWork{
	/**
	 * 地区信息
	 *
	 * @var obj
	 */
	var $obj_area;
	
	function main(){
		$this->ifStore();
		/**
		 * 实例化地区类
		 */
		if (!is_object($this->obj_area)){
			require_once("area.class.php");
			$this->obj_area = new AreaClass();
		}
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("store");
		
		/**
		 * 语言包
		 */
		$this->getlang("store_intro");
		$shop_array = $this->storeBaseInfo();    //店铺基本信息
		
		if ($shop_array['shop_area_id'] != ''){
			$sel_area = $this->obj_area->getAreaPathList($shop_array['shop_area_id']);
		}
		
		/**
		 * 页面输出
		 */
		$this->output('title_message', $shop_array['shop_name'].' - ');
		$this->output('keyword_message', ','.$shop_array['shop_name']);
		$this->output('shop_array',$shop_array);
		$this->output('sel_area',$sel_area);
		$this->showpage("store_intro");
	}
}
$intro = new StoreIntro();
$intro->main();
unset($intro);
?>