<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : message.php   FILE_PATH : \multishop\store\message.php
 * ....商铺留言显示
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Sat Sep 15 13:36:23 CST 2007
 */

require_once("../global.inc.php");

class StoreMessage extends CommonFrameWork{
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;
	/**
	 * 商铺留言对象
	 *
	 * @var obj
	 */
	var $obj_shopmessage;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $objvalidate;
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 * 网站提醒对象
	 *
	 * @var obj
	 */
	var $obj_remind;
	/**
	 * 商店对象
	 *
	 * @var obj
	 */
	var $obj_shop;
	/**
	 * 地区信息
	 *
	 * @var obj
	 */
	var $obj_area;
	/**
	 * 商铺宝贝分类对象
	 *
	 * @var obj
	 */
	var $obj_category;
	/**
	 * 商铺友情链接
	 *
	 * @var obj
	 */
	var $obj_link;
	
	function main(){
		/**
		 * 创建商铺留言对象
		 */
		if (!is_object($this->obj_shopmessage)){
			require_once("shopmessage.class.php");
			$this->obj_shopmessage = new ShopMessageClass();
		}
		/**
		 * 创建分页对象
		 */
		if (!is_object($this->obj_page)){
			require_once("commonpage.class.php");
			$this->obj_page = new CommonPage();
		}
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->objvalidate)){
			require_once("commonvalidate.class.php");
			$this->objvalidate = new CommonValidate();
		}
		/**
		 * 初始化店铺对象
		 */
		if (!is_object($this->obj_shop)){
			require_once("shop.class.php");
			$this->obj_shop = new ShopClass();
		}
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->obj_member)){
			require_once("member.class.php");
			$this->obj_member = new MemberClass();
		}
		/**
		 * 实例化地区类
		 */
		if (!is_object($this->obj_area)){
			require_once("area.class.php");
			$this->obj_area = new AreaClass();
		}
		/**
		 * 创建商铺宝贝分类对象
		 */
		if (!is_object($this->obj_category)){
			require_once("shopproductcategory.class.php");
			$this->obj_category = new ShopProductCategoryClass();
		}
		/**
		 * 创建商铺友情链接对象
		 */
		if (!is_object($this->obj_link)){
			require_once("shoplink.class.php");
			$this->obj_link = new ShopLinkClass();
		}
		
		
		
		//开启2级域名
		if($this->_configinfo['subdomain']['ifsubdomain'] == '1' && $this->_configinfo['subdomain']['domainroot'] != ''){
			if (intval($this->_input['userid']) > 0 ){//跳转到该会员的2级域名下
				$shop_array = $this->obj_shop->getOneShopByMemeberId($this->_input['userid']);
				if (empty($shop_array)){//没有店铺
					$this->redirectPath("error",$this->_configinfo['websit']['site_url']."/index.html",$this->_lang['langStoreMemberIsNotOpen']);
				}
			}else {
				//切割域名，取userid
				$line = @explode($this->_configinfo['subdomain']['domainroot'],$_SERVER['HTTP_HOST']);
				$line = @explode($this->_configinfo['subdomain']['domainprefix'],$line[0]);
				$domain_id = $line[1];
				unset($line);
				$shop_array = $this->obj_shop->getOneShopByDomainId($domain_id);
				if (!empty($shop_array)){//有会员
					$this->_input['userid'] = $shop_array['member_id'];
				}else {//如果是非法的，则跳转
					@header("Location: ".$this->_configinfo['websit']['site_url']."/index.html");
					exit;
				}
			}
			//本店2级域名链接
			$domain_url = 'http://'.$this->_configinfo['subdomain']['domainprefix'].$shop_array['shop_domain'].$this->_configinfo['subdomain']['domainroot'];
			$this->output('shop_domain_url',$domain_url);
		}else {//不开启2级域名,判断如果以2级域名的形式访问的话，则对链接进行整理，为普通访问形式
			if (intval($this->_input['userid']) <= 0 ){
				//切割域名，取userid
				$line = @explode($this->_configinfo['subdomain']['domainroot'],$_SERVER['HTTP_HOST']);
				$line = @explode($this->_configinfo['subdomain']['domainprefix'],$line[0]);
				$user_id = $line[1];
				unset($line);
				if (intval($user_id) > 0){
					@header("Location: ".$this->_configinfo['websit']['site_url'].'/store/message.php?userid='.$user_id);
				}else {//如果是非法的，则跳转
					@header("Location: ".$this->_configinfo['websit']['site_url']."/index.html");
				}
				exit;
			}
		}
		//店铺基本信息
		$this->ifStore();
		$this->shop_array = $this->storeBaseInfo();
		
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("store");
		
		/**
		 * 语言包
		 */
		$this->getlang("store");
		$this->getlang("store_message");
		$this->getlang("store_control");
		
		switch($this->_input['action']){
			case "new":
				$this->_addMessage();
				break;
			case "save":
				$this->_saveAddMessage();
				break;
			default:
				$this->_getMessageList();
		}
	}

	/**
	 * 留言列表
	 */
	function _getMessageList(){
		
		//首先要确定末班布局，取出模板上其他栏目的信息
		$this->shop_id = $this->shop_array['shop_id'];
		$shop_array = $this->storeBaseInfo();
		if ($shop_array['templates'] == '0'){//现有模板
			$this->obj_page->pagebarnum(20);    //每页20条记录
			$message_array = $this->obj_shopmessage->getMessage($this->obj_page,$this->shop_id,true);     //得到留言列表
			$pagelist = $this->obj_page->show(1);    //分页显示
			
			if (is_array($message_array)){
				foreach ($message_array as $k => $v){
					$message_array[$k]['message_time'] = @date("Y-m-d H:i",$v['message_time']);
				}
			}
			//店铺商品类别
			$this->_output_shop_product_category();
			//店铺友情链接
			$this->_output_shop_link();
			//店铺地址输出
			$this->_output_shop_area();
			//会员内容输出
			$this->_output_member();
			/**
			 * 模板输出
			 */
			$this->output('shop_message_array',$message_array);    //输出商铺留言列表
			$this->output('shop_message_pagelist',$pagelist);      //输出商铺留言分页
			$this->showpage("store_message.list_default");
		}else {//自定义模板
			$arr = unserialize($this->shop_array['shop_style']);
			//左边显示
			if ($arr['slayout'] == '2') {
				//页面显示的版区
				$side_template = explode(',',$arr['choiceblockleft']);
				//抛出左边版区
				$this->output('side_template',$side_template);
			}else if ($arr['slayout'] == '0') {//右边显示
				//初始化页面内容
				$side_template  = explode(',',$arr['choiceblockright']);
				//抛出右边版区
				$this->output('side_template',$side_template);
			}else if ($arr['slayout'] == '-1') {//两端显示
				//页面显示的版区
				$left_template = explode(',',$arr['choiceblockleft']);
				$right_template = explode(',',$arr['choiceblockright']);
				//合并左右两边数组
				$side_template_merge = array_merge($left_template,$right_template);
				$side_template = array();
				if (is_array($side_template_merge)){
					foreach ($side_template_merge as $value) {
						$side_template[] = $value;
					}
				}
				//抛出左边版区
				$this->output('left_template',$left_template);
				$this->output('right_template',$right_template);
				$this->output('side_template',$side_template);
			}else {
				$arr['slayout'] = 2;
			}
			
			$this->obj_page->pagebarnum(20);    //每页20条记录
			$message_array = $this->obj_shopmessage->getMessage($this->obj_page,$this->shop_array['shop_id'],true);     //得到留言列表
			$pagelist = $this->obj_page->show(1);    //分页显示
			
			if (is_array($message_array)){
				foreach ($message_array as $k => $v){
					$message_array[$k]['message_time'] = @date("Y-m-d H:i",$v['message_time']);
				}
			}
			/**
			 * 页面输出
			 */
			$this->output('userid',$_SESSION['s_login']['id']);
			$this->output('arrBlog',$arr);//页面布局
			$this->output('page_list',$page_list);
			$this->output('shop_url',$shop_array['shop_link']);
			$this->output('shop_array',$shop_array);
			$this->output('shop_message',$message_array);    //输出商铺留言列表
			$this->output('page_list',$pagelist);      //输出商铺留言分页
			$this->showpage("store_message.list");
		}
	}
	
	/**
	 * 发表留言
	 *
	 */
	function _addMessage(){
		$this->isMember();
		//首先要确定末班布局，取出模板上其他栏目的信息
		$this->shop_id = $this->shop_array['shop_id'];
		$shop_array = $this->storeBaseInfo();
		if ($shop_array['templates'] == '0'){//现有模板
			//店铺商品类别
			$this->_output_shop_product_category();
			//店铺友情链接
			$this->_output_shop_link();
			//店铺地址输出
			$this->_output_shop_area();
			//会员内容输出
			$this->_output_member();
			/**
			 * 页面输出
			 */
			$this->output('userid',$this->_input['userid']);
			$this->showpage('store_message.add_default');
		}else {//自定义模板
			$arr = unserialize($this->shop_array['shop_style']);
			//左边显示
			if ($arr['slayout'] == '2') {
				//页面显示的版区
				$side_template = explode(',',$arr['choiceblockleft']);
				//抛出左边版区
				$this->output('side_template',$side_template);
			}else if ($arr['slayout'] == '0') {//右边显示
				//初始化页面内容
				$side_template  = explode(',',$arr['choiceblockright']);
				//抛出右边版区
				$this->output('side_template',$side_template);
			}else if ($arr['slayout'] == '-1') {//两端显示
				//页面显示的版区
				$left_template = explode(',',$arr['choiceblockleft']);
				$right_template = explode(',',$arr['choiceblockright']);
				//合并左右两边数组
				$side_template_merge = array_merge($left_template,$right_template);
				$side_template = array();
				if (is_array($side_template_merge)){
					foreach ($side_template_merge as $value) {
						$side_template[] = $value;
					}
				}
				//抛出左边版区
				$this->output('left_template',$left_template);
				$this->output('right_template',$right_template);
				$this->output('side_template',$side_template);
			}else {
				$arr['slayout'] = 2;
			}
			/**
			 * 页面输出
			 */
			$this->output('userid',$_SESSION['s_login']['id']);
			$this->output('shop_url',$shop_array['shop_link']);
			$this->output('arrBlog',$arr);//页面布局
			$this->output('shop_array',$shop_array);
			$this->showpage("store_message.add");
		}
	}
	
	/**
	 * 保存留言
	 *
	 */
	function _saveAddMessage(){
		/**
		 * 检验输入信息
		 */
		$this->objvalidate->validateparam = array(
		array("input"=>$this->_input["txtMessage"],"require"=>"true","message"=>$this->_lang['errSMessageMakeLeaveWord']),//请填写留言内容
		array("input"=>strtoupper($this->_input['code']),"require"=>"true","validator"=>"Compare","operator"=>"==","to"=>strtoupper($_SESSION['seccode']),"message"=>$this->_lang['errSMessageInputCode'])//您输入的验证码不对
		); 
		/**
		 * 检验的错误信息
		 */
		$error = $this->objvalidate->validate();
		if ($error != ""){
			$this->redirectPath("error","","$error");
		}else{
			/**
			 * 网站提醒操作
			 */
			if (!is_object($this->obj_remind)){
				require_once('remind.class.php');
				$this->obj_remind = new RemindClass();
			}
			
			$condition['id'] = $this->_input['userid'];
			$member_array = $this->obj_member->getMemberInfo($condition);
	
			$value_array = array();
			$value_array['username'] = $member_array['login_name'];
			$this->obj_remind->setMessageOrMail('sale_message_shop','message_shop',$value_array,$member_array['login_name'],$this->_configinfo);

			$this->_input['MemberName'] = $_SESSION['s_login']['name'];
			$this->_input['hideShopID'] = $this->shop_id;
			$this->obj_shopmessage->addMessage($this->_input);   //将留言内容存放到数据库中
			$this->redirectPath("succ","store/message.php?userid=" . $this->_input['userid'],$this->_lang['langSMessageLeaveWordSucceed']);//您已经成功给店家留言
		}
	}
	
	/**
	 * 输出店铺商品类别
	 */
	function _output_shop_product_category(){
		//店铺商品分类
		$condition_shop_product_cate['shop_id'] = $this->shop_array['shop_id'];
		$condition_shop_product_cate['order_by'] = " shop_product_class.class_parent_id asc,shop_product_class.class_sort asc,shop_product_class.class_id asc ";
		$category_array = $this->obj_category->getCategory($condition_shop_product_cate,$page);
		//整理数组为多级
		$category_array = $this->obj_category->_makeCategoryArray($category_array);
		/**
		 * 页面输出
		 */
		$this->output('category_array',   $category_array);
	}
	/**
	 * 输出店铺友情链接
	 */
	function _output_shop_link(){
		//店铺友情连接
		$condition_link['shop_id'] = $this->shop_array['shop_id'];
		$link_array = $this->obj_link->getLink($condition_link,$page);
		/**
		 * 页面输出
		 */
		$this->output('link_array',   $link_array);
	}
	/**
	 * 地区内容
	 */
	function _output_shop_area(){
		//取店铺地区
		if ($this->shop_array['shop_area_id'] !=''){
			$sel_area = $this->obj_area->getAreaPathList($this->shop_array['shop_area_id']);
		}
		/**
		 * 页面输出
		 */
		$this->output('sel_area',$sel_area); 
	}
	/**
	 * 会员内容
	 */
	function _output_member(){
		//会员
		$condition['id'] = $this->_input['userid'];
		$member_array = $this->obj_member->getMemberInfo($condition,'*','more');
		/**
		 * 页面输出
		 */
		$this->output('member_array',$member_array); 
	}
	
}
$message = new StoreMessage();
$message->main();
unset($message);
?>