<?php 
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
* FILE_NAME : shop_map.php   FILE_PATH : \store\shop_map.php
* ....店铺地图
*
* @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
* @author ShopNC Develop Team 
* @package 
* @subpackage 
* @version Fri Mar 14 18:14:57 CST 2008
*/

require_once("../global.inc.php");

class StoreIntro extends CommonFrameWork{
	function main(){
		//初始化店铺信息
		$this->ifStore();
		if ($this->member_type != 1){
			//如果不是商铺是会员的话跳转到会员信息页面
			$this->redirectPath("common","store/userinfo.php?userid=" . $this->_input['userid'],"");
		}
		$shop_array = $this->storeBaseInfo();    //店铺基本信息
		/**
		 * 设置店铺模板路径
		 */
		$this->setsubtemplates("store");
		/**
		 * 页面输出
		 */
		$this->output('title_message', $shop_array['shop_name'].' - ');
		$this->output('keyword_message', ','.$shop_array['shop_name']);
		$this->output("shop_map_array",$shop_array);
		$this->showpage("store_map");
	}
}
$intro = new StoreIntro();
$intro->main();
unset($intro);
?>