
/*
    crmeb_java 1.3.1 版本
    适合新用户或者重新部署的用户使用
    如果使用此脚本不用运行其他版本的sql文件
*/


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Dump of table eb_article
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_article`;

CREATE TABLE `eb_article` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章管理ID',
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT '分类id',
  `title` varchar(255) NOT NULL COMMENT '文章标题',
  `author` varchar(255) DEFAULT '' COMMENT '文章作者',
  `image_input` varchar(255) NOT NULL COMMENT '文章图片',
  `synopsis` varchar(255) DEFAULT '' COMMENT '文章简介',
  `share_title` varchar(255) DEFAULT '' COMMENT '文章分享标题',
  `share_synopsis` varchar(255) DEFAULT '' COMMENT '文章分享简介',
  `visit` varchar(255) DEFAULT '' COMMENT '浏览次数',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `url` varchar(255) DEFAULT '' COMMENT '原文链接',
  `media_id` varchar(100) DEFAULT NULL COMMENT '微信素材id',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员id',
  `mer_id` int(10) unsigned DEFAULT '0' COMMENT '商户id',
  `product_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品关联id',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门(小程序)',
  `is_banner` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否轮播图(小程序)',
  `content` text NOT NULL COMMENT '文章内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章管理表';

LOCK TABLES `eb_article` WRITE;
/*!40000 ALTER TABLE `eb_article` DISABLE KEYS */;

INSERT INTO `eb_article` (`id`, `cid`, `title`, `author`, `image_input`, `synopsis`, `share_title`, `share_synopsis`, `visit`, `sort`, `url`, `media_id`, `status`, `hide`, `admin_id`, `mer_id`, `product_id`, `is_hot`, `is_banner`, `content`, `create_time`, `update_time`)
VALUES
	(1,'304','苹果发布会','测试1','image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png','苹果发布会','苹果发布会','苹果发布会','56',0,'https://www.tapd.cn/',NULL,0,0,0,0,0,1,1,'<h1 style=\"margin: 8px 0px 25px; padding: 0px; font-size: 40px; line-height: 1.5; color: rgb(51, 51, 51); font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal;\">雷军晒鸟巢照片网友直接沸腾了！小米11要在鸟巢召开发布会？</h1><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\">自从小米宣布小米11全球首发骁龙888后，小米这款新旗舰机就备受很多米粉的期待，因为小米11不仅带来性能强大的骁龙888，其还是小米最为经典的数字旗舰机，要知道今年小米10系列摆脱售价的束缚冲击了高端市场，各方面都获得了网友的认可，并且直接从年初热卖了年底，而第二款高端数字旗舰小米11自然更受期待。</p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\"><img class=\"content-picture\" src=\"https://inews.gtimg.com/newsapp_bt/0/12914276555/1000\" style=\"display: block; border: 0px none; vertical-align: middle; max-width: 100%; margin: 0.6em auto;\"/></p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\">网友期待小米11并非是随便说说，这点从雷军微博下的网友评论就能看得出来，不仅每天都有大量的网友催促官宣，而且雷军一篇正常的博文，都会被网友解读出跟小米11有关，已经到了疯狂的地部了。这不，雷军今天拍了一张树上有鸟巢的照片，让网友猜测有几个？结果网友不是猜11个，就解读暗示小米11将在鸟巢发布。</p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\"><img class=\"content-picture\" src=\"https://inews.gtimg.com/newsapp_bt/0/12914293278/1000\" style=\"display: block; border: 0px none; vertical-align: middle; max-width: 100%; margin: 0.6em auto;\"/></p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\">近年来小米新品发布会大都在小米科技园，而最大的一场是去年小米9发布的时候，而今年本来打算小米10系列和雷军十周年演讲办一场大型活动，但最后被突发的疫情给打乱了，那么现在国内疫情已经控制，小米11系列会不会是大型发布会呢？而就目前的情况来看，几乎没可能，因为疫情没有彻底结束。</p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\"><img class=\"content-picture\" src=\"https://inews.gtimg.com/newsapp_bt/0/12914287269/1000\" style=\"display: block; border: 0px none; vertical-align: middle; max-width: 100%; margin: 0.6em auto;\"/></p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\">最后：虽然网友各种催促小米11的发布，但到底何时官宣还不清楚，可以确定的是小米11不远了，因为此前的消息显示，小米11将在12月25日后才能发布，也就是说下周可能会正式官宣。</p><p><br style=\"white-space: normal;\"/></p><p><br/></p>','2020-12-15 17:22:11','2020-12-31 16:15:41'),
	(2,'508','饮品发布会','测试1','image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','苹果发布会111','饮品发布会','苹果发布会111','12',0,'https://app.beta.java.crmeb.net/static/html/pc.html',NULL,0,0,0,0,0,1,1,'<p><span style=\"color: rgb(96, 98, 102); font-family: arial, sans-serif; font-size: 12px; background-color: rgb(232, 244, 255);\">苹果发布会</span></p>','2020-12-15 17:49:56','2020-12-31 16:11:43'),
	(3,'508','测试1','111','image/user/2020/12/15/72b701aad808457695a49b472f7548ec54rrx6rl74.png','111','测试1','111','2',0,'',NULL,0,0,0,0,0,0,0,'<p>111</p>','2020-12-17 09:31:50','2020-12-17 09:31:50');

/*!40000 ALTER TABLE `eb_article` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_category
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_category`;

CREATE TABLE `eb_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `path` varchar(255) NOT NULL DEFAULT '/0/' COMMENT '路径',
  `name` varchar(50) NOT NULL COMMENT '分类名称',
  `type` smallint(2) DEFAULT '1' COMMENT '类型，1 产品分类，2 附件分类，3 文章分类， 4 设置分类， 5 菜单分类',
  `url` varchar(255) DEFAULT '' COMMENT '地址',
  `extra` text COMMENT '扩展字段 Jsos格式',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态, 1正常，0失效',
  `sort` int(5) NOT NULL DEFAULT '99999' COMMENT '排序',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `status+pid` (`pid`,`status`) USING BTREE,
  KEY `id+status+url` (`path`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='分类表';

LOCK TABLES `eb_category` WRITE;
/*!40000 ALTER TABLE `eb_category` DISABLE KEYS */;

INSERT INTO `eb_category` (`id`, `pid`, `path`, `name`, `type`, `url`, `extra`, `status`, `sort`, `create_time`, `update_time`)
VALUES
	(42,0,'/0/','商品',5,'/store','s-goods',1,1,'2020-04-28 17:03:34','2020-08-12 12:29:13'),
	(43,42,'/0/42/','商品管理',5,'/store/index',NULL,1,1,'2020-04-28 17:04:20','2020-08-12 12:29:13'),
	(44,42,'/0/42/','商品分类',5,'/store/sort',NULL,1,1,'2020-04-28 17:04:40','2020-08-12 12:29:13'),
	(45,0,'/0/','订单',5,'/order','s-order',1,1,'2020-04-28 17:04:56','2020-08-12 12:29:13'),
	(46,45,'/0/45/','订单管理',5,'/order/index','s-order',1,1,'2020-04-28 17:05:17','2020-08-12 12:29:13'),
	(47,0,'/0/','用户',5,'/user','user-solid',1,1,'2020-04-28 17:05:53','2020-08-12 12:29:13'),
	(48,47,'/0/47/','用户管理',5,'/user/index',NULL,1,1,'2020-04-28 17:07:13','2020-08-12 12:29:13'),
	(49,47,'/0/47/','用户标签',5,'/user/label',NULL,1,1,'2020-04-28 17:42:21','2020-08-12 12:29:13'),
	(51,0,'/0/','设置',5,'/operation','s-tools',1,-9,'2020-05-06 09:40:14','2020-08-12 12:29:13'),
	(52,51,'/0/51/','管理权限',5,'/operation/roleManager',NULL,1,1,'2020-05-06 09:40:35','2020-08-12 12:29:13'),
	(53,52,'/0/51/52/','身份管理',5,'/operation//roleManager/identityManager',NULL,1,1,'2020-05-06 09:40:51','2020-08-12 12:29:13'),
	(54,52,'/0/51/52/','管理员列表',5,'/operation//roleManager/adminList',NULL,1,1,'2020-05-06 09:41:11','2020-08-12 12:29:13'),
	(55,52,'/0/51/52/','权限规则',5,'/operation//roleManager/promiseRules',NULL,1,1,'2020-05-06 09:41:46','2020-08-12 12:29:13'),
	(56,0,'/0/','内容',5,'/content','s-management',1,1,'2020-05-07 12:00:33','2020-08-12 12:29:13'),
	(57,56,'/0/56/','文章管理',5,'/content/articleManager',NULL,1,1,'2020-05-07 12:02:39','2020-08-12 12:29:13'),
	(58,56,'/0/56/','文章分类',5,'/content/classifManager',NULL,1,1,'2020-05-07 12:02:46','2020-08-12 12:29:13'),
	(66,0,'/0/','维护',5,'/maintain','s-open',1,-10,'2020-05-09 16:02:05','2020-08-12 12:29:13'),
	(67,66,'/0/66/','开发配置',5,'/maintain/devconfiguration',NULL,1,0,'2020-05-09 16:06:46','2021-01-18 11:27:43'),
	(68,67,'/0/66/67/','配置分类',5,'/maintain/devconfiguration/configCategory',NULL,1,0,'2020-05-09 16:07:09','2020-08-12 12:29:13'),
	(69,67,'/0/66/67/','组合数据',5,'/maintain/devconfiguration/combineddata',NULL,1,0,'2020-05-09 16:08:00','2020-08-12 12:29:13'),
	(80,51,'/0/51/','系统设置',5,'/operation/setting',NULL,1,9,'2020-05-20 09:44:47','2020-12-10 11:30:07'),
	(81,0,'/0/','基础配置',6,'基础配置','64',1,1,'2020-05-20 10:02:57','2020-08-12 12:29:13'),
	(93,81,'/0/81/','站点配置',6,'站点配置','64',1,1,'2020-05-21 11:04:20','2020-08-12 12:29:13'),
	(94,100,'/0/100/','客服配置',6,'云智服','76',1,1,'2020-05-21 11:04:37','2020-09-09 17:09:47'),
	(95,0,'/0/','商城配置',6,'商城配置','77',1,2,'2020-05-21 11:10:20','2020-08-12 12:29:13'),
	(96,95,'/0/95/','商城基础配置',6,'商城基础配置','77',1,1,'2020-05-21 11:10:40','2020-08-12 12:29:13'),
	(98,95,'/0/95/','小票打印配置',6,'小票打印配置','75',0,1,'2020-05-21 11:11:11','2020-08-13 14:07:02'),
	(99,95,'/0/95/','充值配置',6,'充值配置','78',1,1,'2020-05-21 11:11:28','2020-08-12 12:29:13'),
	(100,0,'/0/','应用配置',6,'应用配置',NULL,1,1,'2020-05-21 12:31:49','2020-08-12 12:29:13'),
	(101,100,'/0/100/','公众号配置',6,'公众号配置','65',1,1,'2020-05-21 12:32:07','2020-08-12 12:29:13'),
	(102,100,'/0/100/','小程序配置',6,'小程序配置','66',1,1,'2020-05-21 12:32:18','2020-08-12 12:29:13'),
	(103,0,'/0/','支付配置',6,'支付配置',NULL,1,1,'2020-05-21 12:33:36','2020-08-12 12:29:13'),
	(104,103,'/0/103/','公众号/H5 支付配置',6,'公众号/H5 支付配置','67',1,1,'2020-05-21 12:33:54','2021-01-08 14:26:38'),
	(105,103,'/0/103/','小程序支付配置',6,'小程序支付配置','68',1,1,'2020-05-21 12:34:36','2020-08-12 12:29:13'),
	(106,103,'/0/103/','线下支付',6,'线下支付','79',1,1,'2020-05-21 12:34:48','2020-08-12 12:29:13'),
	(107,103,'/0/103/','余额支付',6,'余额支付','80',1,1,'2020-05-21 12:35:01','2020-08-12 12:29:13'),
	(108,0,'/0/','文件上传配置',6,'文件上传配置',NULL,1,1,'2020-05-21 12:35:16','2020-08-12 12:29:13'),
	(109,108,'/0/108/','基础配置',6,'基础配置','108',1,1,'2020-05-21 12:35:28','2020-09-14 10:33:54'),
	(110,108,'/0/108/','阿里云配置',6,'阿里云配置','81',1,1,'2020-05-21 12:36:01','2020-08-12 12:29:13'),
	(111,108,'/0/108/','七牛云配置',6,'七牛云配置','82',1,1,'2020-05-21 12:36:12','2020-08-12 12:29:13'),
	(112,108,'/0/108/','腾讯云配置',6,'腾讯云配置','83',1,1,'2020-05-21 12:36:22','2020-08-12 12:29:13'),
	(113,0,'/0/','应用',5,'/appSetting','s-promotion',1,1,'2020-05-21 16:12:53','2020-08-12 12:29:13'),
	(114,113,'/0/113/','公众号',5,'/appSetting/publicAccount',NULL,1,1,'2020-05-21 16:13:18','2020-08-12 12:29:13'),
	(115,114,'/0/113/114/','微信菜单',5,'/appSetting//publicAccount/wxMenus',NULL,1,1,'2020-05-21 16:13:36','2020-08-12 12:29:13'),
	(118,0,'/0/','营销',5,'/marketing','s-marketing',1,1,'2020-05-25 14:39:52','2020-08-12 12:29:13'),
	(119,118,'/0/118/','优惠券',5,'/marketing/coupon',NULL,1,1,'2020-05-25 14:40:13','2020-08-12 12:29:13'),
	(123,118,'/0/118/','积分',5,'/marketing/integral',NULL,1,1,'2020-05-25 14:41:33','2020-08-12 12:29:13'),
	(127,42,'/0/42/','商品规格',5,'/store/attr',NULL,1,1,'2020-05-25 18:12:11','2020-08-12 12:29:13'),
	(128,42,'/0/42/','商品评论',5,'/store/comment',NULL,1,1,'2020-05-27 10:16:30','2020-08-12 12:29:13'),
	(129,51,'/0/51/','提货点',5,'/operation/systemStore',NULL,1,1,'2020-05-27 11:42:51','2020-08-27 10:57:46'),
	(130,129,'/0/51/129/','提货点',5,'/operation/systemStore/point',NULL,1,1,'2020-05-27 11:46:10','2020-08-27 10:56:49'),
	(131,129,'/0/51/129/','核销员',5,'/operation/systemStore/clerkList',NULL,1,1,'2020-05-27 11:51:16','2020-08-27 10:56:39'),
	(132,129,'/0/51/129/','核销订单',5,'/operation/systemStore/order',NULL,1,1,'2020-05-27 11:54:00','2020-08-27 10:56:43'),
	(134,95,'/0/95/','首页配置',6,'index_config','69',1,5,'2020-06-02 17:35:58','2020-08-19 15:04:47'),
	(135,0,'/0/','小树树2',2,'url',NULL,1,1,'2020-06-03 15:50:15','2020-08-12 12:29:13'),
	(136,135,'/0/135/','小树娃',2,'url',NULL,1,1,'2020-06-03 16:59:50','2020-08-12 12:29:13'),
	(137,135,'/0/135/','小紅',2,'url',NULL,1,1,'2020-06-03 17:15:50','2020-08-12 12:29:13'),
	(138,136,'/0/135/136/','小鼠',2,'url',NULL,1,1,'2020-06-03 17:25:39','2020-08-12 12:29:13'),
	(139,113,'/0/113/','小程序',5,'/appSetting/publicRoutine',NULL,1,1,'2020-06-05 09:56:17','2020-08-12 12:29:13'),
	(140,139,'/0/113/139/','我的模板',5,'/appSetting/publicRoutine/routineTemplate',NULL,1,1,'2020-06-05 09:56:58','2020-08-27 14:07:47'),
	(141,114,'/0/113/114/','自动回复',5,'/appSetting/publicAccount/wxReply',NULL,1,1,'2020-06-15 16:15:32','2020-08-12 12:29:13'),
	(146,0,'/0/','分销',5,'/distribution','s-check',1,1,'2020-07-18 16:31:09','2020-12-07 09:35:02'),
	(147,146,'/0/146/','分销员管理',5,'/distribution/index',NULL,1,1,'2020-07-18 16:31:49','2020-12-18 10:22:25'),
	(148,146,'/0/146/','分销配置',5,'/distribution/distributionconfig',NULL,1,1,'2020-07-18 16:32:06','2020-12-18 10:22:19'),
	(149,51,'/0/51/','短信',5,'/operation/systemSms',NULL,0,1,'2020-07-21 16:51:29','2020-12-24 15:55:25'),
	(150,149,'/0/51/149/','短信账户',5,'/operation/systemSms/config',NULL,0,1,'2020-07-21 16:52:48','2020-12-24 15:55:24'),
	(151,149,'/0/51/149/','短信模板',5,'/operation/systemSms/template',NULL,0,1,'2020-07-21 19:45:26','2020-12-24 15:55:24'),
	(152,149,'/0/51/149/','短信购买',5,'/operation/systemSms/pay',NULL,0,1,'2020-07-21 19:45:46','2020-12-24 15:55:22'),
	(158,119,'/0/118/119/','优惠券',5,'/marketing/coupon/list',NULL,1,1,'2020-07-24 16:13:10','2020-08-29 10:15:34'),
	(159,119,'/0/118/119/','会员领取记录',5,'/marketing/coupon/record',NULL,1,1,'2020-07-24 16:13:37','2020-08-12 12:29:13'),
	(160,123,'/0/118/123/','积分配置',5,'/marketing/integral/integralconfig',NULL,1,1,'2020-07-24 16:14:48','2020-08-12 12:29:13'),
	(161,123,'/0/118/123/','积分日志',5,'/marketing/integral/integrallog',NULL,1,1,'2020-07-24 16:15:11','2020-08-12 12:29:13'),
	(162,47,'/0/47/','用户等级',5,'/user/grade',NULL,1,1,'2020-07-24 16:21:48','2020-08-12 12:29:13'),
	(164,47,'/0/47/','用户分组',5,'/user/group',NULL,1,1,'2020-07-24 16:22:46','2020-08-12 12:29:13'),
	(165,51,'/0/51/','物流',5,'/operation/logistics',NULL,1,1,'2020-07-24 16:37:56','2020-08-27 10:57:55'),
	(166,165,'/0/51/165/','城市数据',5,'/operation/logistics/cityList',NULL,1,1,'2020-07-24 16:38:22','2020-08-12 12:29:13'),
	(167,165,'/0/51/165/','物流公司',5,'/operation/logistics/companyList',NULL,1,1,'2020-07-24 16:38:46','2020-08-12 12:29:13'),
	(168,165,'/0/51/165/','运费模板',5,'/operation/logistics/shippingTemplates',NULL,1,1,'2020-07-24 16:39:03','2020-08-12 12:29:13'),
	(169,165,'/0/51/165/','物流配置',5,'/operation/logistics/logisticsConfig',NULL,1,1,'2020-07-24 16:39:27','2020-08-12 12:29:13'),
	(171,141,'/0/113/114/141/','微信关注回复',5,'/appSetting/publicAccount/wxReply/follow',NULL,1,1,'2020-07-24 16:42:52','2020-08-12 12:29:13'),
	(172,141,'/0/113/114/141/','关键字回复',5,'/appSetting/publicAccount/wxReply/keyword',NULL,1,1,'2020-07-24 16:43:09','2020-08-12 12:29:13'),
	(173,141,'/0/113/114/141/','无效关键词回复',5,'/appSetting/publicAccount/wxReply/replyIndex',NULL,1,1,'2020-07-24 16:43:23','2020-08-12 12:29:13'),
	(174,114,'/0/113/114/','微信模板',5,'/appSetting//publicAccount/template',NULL,1,1,'2020-07-24 16:43:52','2020-08-29 10:05:10'),
	(175,43,'/0/42/43/','商品添加',5,'api/admin/store/product/save',NULL,0,1,'2020-07-24 16:46:04','2020-08-31 10:07:27'),
	(176,43,'/0/42/43/','商品修改',5,'api/admin/store/product/update',NULL,0,1,'2020-07-24 16:46:19','2020-08-31 10:07:24'),
	(177,43,'/0/42/43/','商品详情',5,'api/admin/store/product/info',NULL,0,1,'2020-07-24 16:46:33','2020-08-31 10:07:25'),
	(181,182,'/0/182/','测试分类01',2,'url',NULL,1,1,'2020-08-10 10:18:52','2020-08-12 12:29:13'),
	(182,0,'/0/','测试分类02',2,'url',NULL,1,1,'2020-08-10 10:20:14','2020-08-12 12:29:13'),
	(183,0,'/0/','测试分类03',2,'url',NULL,1,1,'2020-08-10 10:31:17','2020-08-12 12:29:13'),
	(184,181,'/0/181/','测试二级分类01',2,'url',NULL,1,1,'2020-08-10 10:34:50','2020-08-12 12:29:13'),
	(185,0,'/0/','ADIDAS 春季新品运动鞋图片1',2,'url',NULL,1,1,'2020-08-10 10:40:52','2020-08-12 12:29:13'),
	(188,184,'/0/181/184/','测试四级分类01',2,'url',NULL,1,1,'2020-08-10 11:08:32','2020-08-12 12:29:13'),
	(240,10000,'/0/','2323',2,'url',NULL,1,1,'2020-08-11 15:20:28','2020-08-12 12:29:13'),
	(245,0,'/0/272/','热门推荐',1,'','image/content/2020/08/10/814d9f0beba040d2904079d7b99fc586el2l3odbj3.png',0,0,'2020-08-12 11:42:27','2021-01-15 09:25:49'),
	(246,245,'/0/272/245/','新品上市',1,'www','image/store/2020/08/13/95e065018ba24172b2e2dd2e2833360coobdzkt671.png',1,0,'2020-08-12 11:42:58','2020-10-21 17:25:21'),
	(248,245,'/0/272/245/','热卖商品',1,'www','image/store/2020/08/13/29b418bf2543477d8417a85e779e6d79clby7stw86.png',1,0,'2020-08-12 11:50:40','2020-10-21 17:25:25'),
	(250,67,'/0/66/67/','表单配置',5,'/maintain/devconfiguration/formConfig',NULL,1,0,'2020-08-12 12:09:56','2020-08-12 12:29:13'),
	(258,245,'/0/272/245/','折扣专区',1,'www','image/store/2020/08/13/1826c7f20771444e888501d91332f129wik43qfgmw.png',1,0,'2020-08-12 13:59:31','2020-10-21 17:25:28'),
	(267,0,'/0/','主页',5,'/dashboard','s-home',1,10,'2020-08-13 10:31:07','2021-01-14 16:40:18'),
	(268,0,'/0/','图标素材',2,'url',NULL,0,1,'2020-08-13 10:36:08','2020-08-13 10:36:08'),
	(270,0,'/0/','banner',2,'url',NULL,0,1,'2020-08-13 11:35:39','2020-08-13 11:35:39'),
	(271,0,'/0/','分类素材',2,'url',NULL,0,1,'2020-08-13 11:46:28','2020-08-13 11:46:28'),
	(272,0,'/0/','家用电器',1,'','image/store/2020/08/13/88dfb08327f7470d8285613aa1bd9ab3xk2qzolbad.png',1,0,'2020-08-13 12:03:40','2020-08-13 13:51:17'),
	(273,272,'/0/272/','电视',1,'','image/store/2020/08/13/15e36da884e44f91939a92468d0c848fxftnm6thvc.png',1,0,'2020-08-13 12:05:23','2020-08-13 12:05:23'),
	(274,272,'/0/272/','冰箱',1,'www','image/store/2020/08/13/0c1fb92238ce4f67b9c2cb03c9c932c8a28451t0g7.png',1,0,'2020-08-13 12:06:47','2020-08-13 12:06:47'),
	(275,272,'/0/272/','洗衣机',1,'www','image/store/2020/08/13/6f722314cefa418fada5eab9e09bf86aqutumxihsx.png',1,0,'2020-08-13 12:07:57','2020-08-13 12:07:57'),
	(276,272,'/0/272/','生活电器',1,'','image/store/2020/08/13/df0f8dfb34c1424abde8737039c5f58b1acdgq3h7w.png',1,0,'2020-08-13 12:11:36','2020-08-13 12:11:36'),
	(277,272,'/0/272/','厨卫电器',1,'','image/store/2020/08/13/cb007f931afb4386bfff7f80b8971203c5qc2k1j1n.png',1,0,'2020-08-13 12:12:38','2020-08-13 12:12:38'),
	(279,272,'/0/272/','清凉一夏',1,'','image/store/2020/08/13/306ee4383bbf460494e8b3368782a076ugnezzb362.png',1,0,'2020-08-13 12:15:11','2020-08-13 12:26:18'),
	(280,0,'/0/','家装家具',1,'','image/store/2020/08/14/547bfd86471b412eb4f163e07cfc2027uzzul0xoyl.jpg',1,0,'2020-08-13 12:17:25','2020-08-29 10:48:17'),
	(281,0,'/0/','户外出行',1,'','image/content/2020/08/14/d992711f08ae45369ec1bd56a30c462880pnyxs5xg.jpg',1,0,'2020-08-13 12:17:54','2020-08-29 10:48:28'),
	(282,0,'/0/','美妆个护',1,'','image/setting/2020/08/14/26b3e7b4591e47f8b49e805082925dd8l36r29lmqo.jpg',1,0,'2020-08-13 12:18:04','2020-08-29 10:48:38'),
	(283,0,'/0/','3C数码',1,'','image/content/2020/08/13/312234fff7f24c37bcedd117f1572b3e5z7eydhpyr.png',1,0,'2020-08-13 12:18:14','2020-08-29 10:48:52'),
	(284,0,'/0/283/','日用文创',1,'','image/content/2020/08/14/27cf4c1051ea4bed82d74aed62e5df1121o78nxu6p.jpg',0,0,'2020-08-13 12:18:30','2020-12-31 15:55:21'),
	(285,280,'/0/280/','智能门锁',1,'','image/store/2020/08/13/f4f47201c43e42ac82b83ed711199774ggihs7g6yb.png',1,0,'2020-08-13 13:31:48','2020-08-13 13:31:48'),
	(286,280,'/0/280/','居家照明',1,'','image/store/2020/08/13/f0771d0db94847bbb2cb60ebe5201aa0tzzjzor6d5.png',1,0,'2020-08-13 13:33:06','2020-08-13 13:33:06'),
	(287,280,'/0/280/','家装建材',1,'','image/store/2020/08/13/4209c46356f4478ea3ed2b8adfc8dd4d4udgw8nsig.png',1,0,'2020-08-13 13:34:22','2020-08-13 13:34:22'),
	(288,281,'/0/281/','健身运动',1,'','image/store/2020/08/13/183bae2de334412f8593325805bb45e07xvwxc6nbn.png',1,0,'2020-08-13 13:35:37','2020-08-13 13:35:37'),
	(289,281,'/0/281/','户外装备',1,'','image/store/2020/08/13/767c7e25f56543f398e11896d356b46a1t4l6k8qk0.png',1,0,'2020-08-13 13:36:34','2020-08-13 13:36:34'),
	(290,281,'/0/281/','骑行配件',1,'','image/store/2020/08/13/8525ef6066a04537aa5ee92234dc2edcf1iyqm9gq9.png',1,0,'2020-08-13 13:37:23','2020-08-13 13:37:23'),
	(291,282,'/0/282/','美妆工具',1,'','image/store/2020/08/13/57f108bff43744c88323c666d77cac72g4p0a23tpo.png',1,0,'2020-08-13 13:38:32','2020-08-13 13:38:32'),
	(292,282,'/0/282/','口腔清洁',1,'','image/store/2020/08/13/72f39322b33249e0b3441908e3b657b2rzf7g4x37c.png',1,0,'2020-08-13 13:39:33','2020-08-13 13:39:33'),
	(293,282,'/0/282/','彩妆香氛',1,'','image/store/2020/08/13/bf981c370d9d44f998803310fedb8af3yr9suwbwp1.png',1,0,'2020-08-13 13:40:34','2020-08-13 13:40:34'),
	(294,282,'/0/282/','面部护肤',1,'','image/store/2020/08/13/59a066f8bb5145cbada4b7a08965cf15b26idurig9.png',1,0,'2020-08-13 13:42:19','2020-08-13 13:42:19'),
	(295,282,'/0/282/','身体护理',1,'','image/store/2020/08/13/769f2ba251114a75bc3da94166770482zv3tb4ogjy.png',1,0,'2020-08-13 13:43:21','2020-08-13 13:43:21'),
	(296,282,'/0/282/','其他工具',1,'','image/store/2020/08/13/5c9d8b4b4a2e4fc782558787fc941e24o6u5iv52dl.png',1,0,'2020-08-13 13:44:15','2020-08-13 13:44:15'),
	(297,283,'/0/283/','手机',1,'','image/store/2020/08/13/3a985dc276b941c093a12332500d9784ce3bed9l0c.png',1,0,'2020-08-13 13:45:52','2020-08-13 13:45:52'),
	(298,283,'/0/283/','平板电脑',1,'','image/store/2020/08/13/5771a123b9a24666b5cdcf531f7744d6grduvuarjw.png',1,0,'2020-08-13 13:46:22','2020-08-13 13:46:22'),
	(299,283,'/0/283/','数码配件',1,'','image/store/2020/08/13/760282c126c74ff7a335c3efd6bb2e27vduh9zraqs.png',1,0,'2020-08-13 13:47:16','2020-08-13 13:47:16'),
	(300,284,'/0/284/','日用杂货',1,'','image/store/2020/08/13/ba82799518704655ab2fdc254336de08wtb2ofda96.png',1,0,'2020-08-13 13:48:30','2020-08-13 13:48:30'),
	(301,284,'/0/284/','纸品湿巾',1,'','image/store/2020/08/13/eb7a947539d94cd495ea6493e37a3e35lkqmcnnl9q.png',1,0,'2020-08-13 13:49:30','2020-08-13 13:49:30'),
	(302,284,'/0/284/','办公文具',1,'','image/store/2020/08/13/a84efcfa299c4269af95d671e122d4770vrq87ttfz.png',0,0,'2020-08-13 13:50:39','2020-08-18 19:18:34'),
	(303,0,'/0/','产品',2,'url',NULL,0,1,'2020-08-13 13:53:11','2020-08-13 13:53:11'),
	(304,0,'/0/','iphone 11 新品发布会',3,'','image/content/2020/08/13/b1b14c22e72940ba96e0775fd0b4432cka3o1j1tlg.png',1,1,'2020-08-13 15:18:13','2020-12-17 16:53:32'),
	(306,283,'/0/283/','小米笔记本',1,'','image/store/2020/08/14/547bfd86471b412eb4f163e07cfc2027uzzul0xoyl.jpg',1,0,'2020-08-14 14:19:04','2020-08-14 14:19:04'),
	(311,137,'/0/135/137/','ceshi ',2,'url',NULL,0,1,'2020-08-17 17:10:41','2020-08-17 17:10:41'),
	(316,139,'/0/113/139/','公共模板',5,'/appSetting/publicRoutine/publicRoutineTemplate',NULL,1,1,'2020-08-27 14:15:41','2020-08-27 14:16:11'),
	(317,452,'/0/452/','订单核销',5,'/javaMobile/orderCancellation',NULL,1,0,'2020-08-27 14:51:47','2020-09-12 15:19:51'),
	(318,43,'/0/42/43/','商品删除',5,'api/admin/store/product/delete',NULL,0,0,'2020-08-28 16:12:53','2020-08-31 10:07:24'),
	(319,43,'/0/42/43/','商品上架',5,'api/admin/store/product/putOnShell',NULL,0,0,'2020-08-28 16:14:14','2020-08-31 10:07:22'),
	(320,43,'/0/42/43/','商品下架',5,'api/admin/store/product/offShell',NULL,0,0,'2020-08-28 16:14:33','2020-08-31 10:07:23'),
	(321,43,'/0/42/43/','库存变动',5,'api/admin/store/product/stock',NULL,0,0,'2020-08-28 16:15:07','2020-08-31 10:07:21'),
	(322,43,'/0/42/43/','虚拟销量',5,'api/admin/store/product/ficti',NULL,0,0,'2020-08-28 16:15:59','2020-08-31 10:07:21'),
	(323,127,'/0/42/127/','规格添加',5,'api/admin/store/product/rule/save',NULL,0,0,'2020-08-28 16:25:25','2020-08-28 16:26:44'),
	(324,127,'/0/42/127/','规格修改',5,'api/admin/store/product/update',NULL,0,0,'2020-08-28 16:25:40','2020-08-28 16:25:48'),
	(325,127,'/0/42/127/','规格删除',5,'api/admin/store/product/delete',NULL,0,0,'2020-08-28 16:26:01','2020-09-15 09:49:16'),
	(326,127,'/0/42/127/','规格详情',5,'api/admin/store/product/rule/info',NULL,0,0,'2020-08-28 16:26:37','2020-08-28 16:26:37'),
	(327,127,'/0/42/127/','规格列表',5,'api/admin/store/product/rule/list',NULL,0,0,'2020-08-28 16:26:59','2020-08-28 16:26:59'),
	(328,128,'/0/42/128/','商品评论添加',5,'api/admin/store/product/reply/save',NULL,0,0,'2020-08-28 16:27:53','2020-08-28 16:27:53'),
	(329,128,'/0/42/128/','商品评论修改',5,'api/admin/store/product/reply/update',NULL,0,0,'2020-08-28 16:28:18','2020-08-28 16:28:18'),
	(330,128,'/0/42/128/','商品评论列表',5,'api/admin/store/product/reply/list',NULL,0,0,'2020-08-28 16:29:45','2020-08-28 16:29:45'),
	(331,128,'/0/42/128/','商品评论删除',5,'api/admin/store/product/reply/delete',NULL,0,0,'2020-08-28 16:29:57','2020-08-28 16:30:02'),
	(332,128,'/0/42/128/','商品评论详情',5,'api/admin/store/product/reply/info',NULL,0,0,'2020-08-28 16:30:17','2020-08-28 16:30:17'),
	(333,128,'/0/42/128/','商品评论回复',5,'api/admin/store/product/reply/comment',NULL,0,0,'2020-08-28 16:30:38','2020-08-28 16:30:38'),
	(334,46,'/0/45/46/','订单列表',5,'api/admin/store/order/list',NULL,0,0,'2020-08-29 09:33:16','2020-08-29 09:33:16'),
	(335,46,'/0/45/46/','订单删除',5,'api/admin/store/order/delete',NULL,0,0,'2020-08-29 09:33:49','2020-08-29 09:33:49'),
	(336,46,'/0/45/46/','订单详情',5,'api/admin/store/order/info',NULL,0,0,'2020-08-29 09:34:04','2020-08-29 09:34:04'),
	(337,46,'/0/45/46/','订单标记',5,'api/admin/store/order/mark',NULL,0,0,'2020-08-29 09:34:25','2020-08-29 09:34:25'),
	(338,46,'/0/45/46/','订单退款',5,'api/admin/store/order/refund',NULL,0,0,'2020-08-29 09:34:38','2020-08-29 09:34:38'),
	(339,46,'/0/45/46/','订单拒绝退款',5,'api/admin/store/order/refund/refuse',NULL,0,0,'2020-08-29 09:35:08','2020-08-29 09:35:08'),
	(340,46,'/0/45/46/','订单发货',5,'api/admin/store/order/send',NULL,0,0,'2020-08-29 09:35:33','2020-08-29 09:35:33'),
	(341,46,'/0/45/46/','订单更新',5,'api/admin/store/order/update',NULL,0,0,'2020-08-29 09:35:44','2020-08-29 09:35:44'),
	(342,46,'/0/45/46/','订单物流查询',5,'api/admin/store/order/getLogisticsInfo',NULL,0,0,'2020-08-29 09:36:12','2020-08-29 09:36:12'),
	(343,46,'/0/45/46/','订单日志查看',5,'api/admin/store/order/status/list',NULL,0,0,'2020-08-29 09:37:43','2020-08-29 09:37:43'),
	(344,48,'/0/47/48/','用户列表',5,'api/admin/user/list',NULL,0,0,'2020-08-29 09:38:35','2020-08-29 09:38:35'),
	(345,48,'/0/47/48/','用户修改',5,'api/admin/user/update',NULL,0,0,'2020-08-29 09:39:12','2020-08-29 09:39:12'),
	(346,48,'/0/47/48/','用户详情',5,'api/admin/user/infobycondition',NULL,0,0,'2020-08-29 09:39:22','2020-08-29 09:41:16'),
	(347,48,'/0/47/48/','用户分组',5,'api/admin/user/group',NULL,0,0,'2020-08-29 09:39:31','2020-08-29 09:39:31'),
	(348,48,'/0/47/48/','用户删除',5,'api/admin/user/delete',NULL,0,0,'2020-08-29 09:39:49','2020-08-29 09:39:49'),
	(349,48,'/0/47/48/','用户打标签',5,'api/admin/user/tag',NULL,0,0,'2020-08-29 09:40:02','2020-08-29 09:40:02'),
	(350,48,'/0/47/48/','修改积分余额',5,'api/admin/user/operate/founds',NULL,0,0,'2020-08-29 09:41:50','2020-08-29 09:41:50'),
	(351,162,'/0/47/162/','用户等级添加',5,'api/admin/system/user/level/save',NULL,0,0,'2020-08-29 09:43:32','2020-08-29 09:44:47'),
	(352,162,'/0/47/162/','用户等级修改',5,'api/admin/system/user/level/update',NULL,0,0,'2020-08-29 09:46:00','2020-08-29 09:46:00'),
	(353,162,'/0/47/162/','用户等级删除',5,'api/admin/system/user/level/delete',NULL,0,0,'2020-08-29 09:46:13','2020-08-29 09:46:13'),
	(354,162,'/0/47/162/','用户等级列表',5,'api/admin/system/user/level/list',NULL,0,0,'2020-08-29 09:46:50','2020-08-29 09:46:50'),
	(355,162,'/0/47/162/','用户等级详情',5,'api/admin/system/user/level/info',NULL,0,0,'2020-08-29 09:47:05','2020-08-29 09:47:05'),
	(356,162,'/0/47/162/','用户等级是否显示',5,'api/admin/system/user/level/use',NULL,0,0,'2020-08-29 09:47:41','2020-08-29 09:47:41'),
	(357,49,'/0/47/49/','用户标签添加',5,'api/admin/user/tag/save',NULL,0,0,'2020-08-29 09:48:13','2020-08-29 09:49:20'),
	(358,49,'/0/47/49/','用户标签修改',5,'api/admin/user/tag/update',NULL,0,0,'2020-08-29 09:48:26','2020-08-29 09:49:27'),
	(359,49,'/0/47/49/','用户标签删除',5,'api/admin/user/tag/list',NULL,0,0,'2020-08-29 09:49:12','2020-08-29 09:49:37'),
	(360,49,'/0/47/49/','用户标签详情',5,'api/admin/user/tag/info',NULL,0,0,'2020-08-29 09:49:51','2020-08-29 09:49:51'),
	(361,49,'/0/47/49/','用户标签列表',5,'api/admin/user/tag/list',NULL,0,0,'2020-08-29 09:50:11','2020-08-29 09:50:11'),
	(362,164,'/0/47/164/','用户分组添加',5,'api/admin/user/group/list',NULL,0,0,'2020-08-29 09:52:08','2020-08-29 09:52:08'),
	(363,164,'/0/47/164/','用户分组修改',5,'api/admin/user/group/update',NULL,0,0,'2020-08-29 09:52:23','2020-08-29 09:52:23'),
	(364,164,'/0/47/164/','用户分组删除',5,'api/admin/user/group/delete',NULL,0,0,'2020-08-29 09:52:35','2020-08-29 09:52:35'),
	(365,164,'/0/47/164/','用户分组详情',5,'api/admin/user/group/info',NULL,0,0,'2020-08-29 09:52:55','2020-08-29 09:52:55'),
	(366,164,'/0/47/164/','用户分组列表',5,'api/admin/user/group/list',NULL,0,0,'2020-08-29 09:53:09','2020-08-29 09:53:09'),
	(367,57,'/0/56/57/','文章添加',5,'api/admin/article/save',NULL,0,0,'2020-08-29 09:54:14','2020-08-29 09:54:14'),
	(368,57,'/0/56/57/','文章删除',5,'api/admin/article/delete',NULL,0,0,'2020-08-29 09:55:05','2020-08-29 09:55:05'),
	(369,57,'/0/56/57/','文章修改',5,'api/admin/article/update',NULL,0,0,'2020-08-29 09:55:15','2020-08-29 09:55:15'),
	(370,57,'/0/56/57/','文章列表',5,'api/admin/article/list',NULL,0,0,'2020-08-29 09:55:23','2020-08-29 09:55:23'),
	(371,57,'/0/56/57/','文章详情',5,'api/admin/article/info',NULL,0,0,'2020-08-29 09:55:39','2020-08-29 09:55:39'),
	(372,57,'/0/56/57/','文章绑定产品',5,'api/admin/article/bind/product',NULL,0,0,'2020-08-29 09:56:40','2020-08-29 09:56:40'),
	(373,115,'/0/113/114/115/','微信菜单保存',5,'api/admin/wechat/menu/public/create',NULL,0,0,'2020-08-29 09:59:41','2020-08-29 09:59:41'),
	(374,115,'/0/113/114/115/','微信菜单删除',5,'api/admin/wechat/menu/public/delete',NULL,0,0,'2020-08-29 10:00:02','2020-08-29 10:00:02'),
	(375,172,'/0/113/114/141/172/','关键字添加',5,'api/admin/wechat/keywords/reply/save',NULL,0,0,'2020-08-29 10:02:20','2020-08-29 10:02:20'),
	(376,172,'/0/113/114/141/172/','关键字删除',5,'api/admin/wechat/keywords/reply/delete',NULL,0,0,'2020-08-29 10:02:48','2020-08-29 10:02:48'),
	(377,172,'/0/113/114/141/172/','关键字修改',5,'api/admin/wechat/keywords/reply/update',NULL,0,0,'2020-08-29 10:03:00','2020-08-29 10:03:00'),
	(378,172,'/0/113/114/141/172/','关键字状态更新',5,'api/admin/wechat/keywords/reply/status',NULL,0,0,'2020-08-29 10:03:16','2020-08-29 10:03:16'),
	(379,172,'/0/113/114/141/172/','关键字列表',5,'api/admin/wechat/keywords/reply/list',NULL,0,0,'2020-08-29 10:03:28','2020-08-29 10:03:28'),
	(380,172,'/0/113/114/141/172/','关键字详情',5,'api/admin/wechat/keywords/reply/info',NULL,0,0,'2020-08-29 10:03:42','2020-08-29 10:03:42'),
	(381,174,'/0/113/114/174/','微信模板添加',5,'api/admin/wechat/template/save',NULL,0,0,'2020-08-29 10:05:03','2020-08-29 10:06:14'),
	(382,174,'/0/113/114/174/','微信模板修改',5,'api/admin/wechat/template/update',NULL,0,0,'2020-08-29 10:05:35','2020-08-29 10:06:19'),
	(383,174,'/0/113/114/174/','微信模板删除',5,'api/admin/wechat/template/delete',NULL,0,0,'2020-08-29 10:05:44','2020-08-29 10:06:24'),
	(384,174,'/0/113/114/174/','微信模板列表',5,'api/admin/wechat/template/list',NULL,0,0,'2020-08-29 10:06:06','2020-08-29 10:06:06'),
	(385,174,'/0/113/114/174/','微信模板状态更新',5,'api/admin/wechat/template/status',NULL,0,0,'2020-08-29 10:06:55','2020-08-29 10:06:55'),
	(386,174,'/0/113/114/174/','微信模板详情',5,'api/admin/wechat/template/info',NULL,0,0,'2020-08-29 10:07:11','2020-08-29 10:07:11'),
	(387,174,'/0/113/114/174/','微信模板行业信息',5,'api/admin/wechat/template/industry',NULL,0,0,'2020-08-29 10:07:32','2020-08-29 10:07:32'),
	(388,140,'/0/113/139/140/','我的模板列表',5,'api/admin/wechat/program/my/temp/list',NULL,0,0,'2020-08-29 10:08:13','2020-08-29 10:08:13'),
	(389,140,'/0/113/139/140/','我的模板添加',5,'api/admin/wechat/program/my/temp/save',NULL,0,0,'2020-08-29 10:08:31','2020-08-29 10:08:31'),
	(390,140,'/0/113/139/140/','我的模板修改',5,'api/admin/wechat/program/my/temp/update',NULL,0,0,'2020-08-29 10:08:41','2020-08-29 10:08:41'),
	(391,140,'/0/113/139/140/','我的模板详情',5,'api/admin/wechat/program/my/temp/info',NULL,0,0,'2020-08-29 10:09:19','2020-08-29 10:09:19'),
	(392,140,'/0/113/139/140/','我的模板状态更新',5,'api/admin/wechat/program/my/temp/status',NULL,0,0,'2020-08-29 10:09:44','2020-08-29 10:09:44'),
	(393,316,'/0/113/139/316/','公共模板行业信息',5,'api/admin/wechat/program/category',NULL,0,0,'2020-08-29 10:10:28','2020-08-29 10:10:28'),
	(394,316,'/0/113/139/316/','公共模板列表',5,'api/admin/wechat/program/public/temp/list',NULL,0,0,'2020-08-29 10:10:54','2020-08-29 10:10:54'),
	(395,316,'/0/113/139/316/','公共模板详情',5,'api/admin/wechat/program/public/temp/info',NULL,0,0,'2020-08-29 10:11:17','2020-08-29 10:11:17'),
	(396,140,'/0/113/139/140/','根据公共模板获取关键词列表',5,'api/admin/wechat/program/getWeChatKeywordsByTid',NULL,0,0,'2020-08-29 10:11:56','2020-08-29 10:11:56'),
	(397,158,'/0/118/119/158/','优惠券添加',5,'api/admin/marketing/coupon/save',NULL,0,0,'2020-08-29 10:12:37','2020-08-29 10:16:13'),
	(398,158,'/0/118/119/158/','优惠券状态更新',5,'api/admin/marketing/coupon/update/status',NULL,0,0,'2020-08-29 10:13:10','2020-08-29 10:16:20'),
	(399,158,'/0/118/119/158/','优惠券列表',5,'api/admin/marketing/coupon/list',NULL,0,0,'2020-08-29 10:13:22','2020-08-29 10:16:21'),
	(400,158,'/0/118/119/158/','优惠券详情',5,'api/admin/marketing/coupon/info',NULL,0,0,'2020-08-29 10:13:42','2020-08-29 10:17:04'),
	(401,159,'/0/118/119/159/','会员领取记录列表',5,'api/admin/marketing/coupon/user/list',NULL,0,0,'2020-08-29 10:17:53','2020-08-29 10:17:53'),
	(402,159,'/0/118/119/159/','领取优惠券',5,'api/admin/marketing/coupon/user/receive',NULL,0,0,'2020-08-29 10:18:21','2020-08-29 10:18:48'),
	(403,54,'/0/51/52/54/','管理员添加',5,'api/admin/system/admin/save',NULL,0,0,'2020-08-29 10:22:43','2020-08-29 10:26:11'),
	(404,54,'/0/51/52/54/','管理员修改',5,'api/admin/system/admin/update',NULL,0,0,'2020-08-29 10:23:00','2020-08-29 10:26:09'),
	(405,54,'/0/51/52/54/','管理员删除',5,'api/admin/system/admin/delete',NULL,0,0,'2020-08-29 10:23:11','2020-08-29 10:26:06'),
	(406,54,'/0/51/52/54/','管理员列表',5,'api/admin/system/admin/list',NULL,0,0,'2020-08-29 10:23:21','2020-08-29 10:26:04'),
	(407,54,'/0/51/52/54/','管理员详情',5,'api/admin/system/admin/info',NULL,0,0,'2020-08-29 10:23:31','2020-08-29 10:26:01'),
	(408,53,'/0/51/52/53/','身份添加',5,'api/admin/system/role/save',NULL,0,0,'2020-08-29 10:26:52','2020-08-29 10:26:52'),
	(409,53,'/0/51/52/53/','身份删除',5,'api/admin/system/role/delete',NULL,0,0,'2020-08-29 10:27:07','2020-08-29 10:27:07'),
	(410,53,'/0/51/52/53/','身份修改',5,'api/admin/system/role/update',NULL,0,0,'2020-08-29 10:27:27','2020-08-29 10:27:27'),
	(411,53,'/0/51/52/53/','身份列表',5,'api/admin/system/role/list',NULL,0,0,'2020-08-29 10:27:39','2020-08-29 10:27:39'),
	(416,166,'/0/51/165/166/','城市列表',5,'api/admin/system/city/list',NULL,0,0,'2020-08-29 10:34:12','2020-08-29 10:34:12'),
	(417,166,'/0/51/165/166/','城市详情',5,'api/admin/system/city/info',NULL,0,0,'2020-08-29 10:34:24','2020-08-29 10:34:24'),
	(418,166,'/0/51/165/166/','城市修改',5,'api/admin/system/city/update',NULL,0,0,'2020-08-29 10:34:33','2020-08-29 10:34:33'),
	(419,166,'/0/51/165/166/','城市状态更新',5,'api/admin/system/city/update/status',NULL,0,0,'2020-08-29 10:34:56','2020-08-29 10:34:56'),
	(420,167,'/0/51/165/167/','物流公司添加',5,'api/admin/express/save',NULL,0,0,'2020-08-29 10:35:36','2020-08-29 10:35:36'),
	(421,167,'/0/51/165/167/','物流公司修改',5,'api/admin/express/update',NULL,0,0,'2020-08-29 10:35:52','2020-08-29 10:35:52'),
	(422,167,'/0/51/165/167/','物流公司删除',5,'api/admin/express/delete',NULL,0,0,'2020-08-29 10:36:03','2020-08-29 10:36:03'),
	(423,167,'/0/51/165/167/','物流公司详情',5,'api/admin/express/info',NULL,0,0,'2020-08-29 10:36:14','2020-08-29 10:36:14'),
	(424,167,'/0/51/165/167/','物流公司列表',5,'api/admin/express/list',NULL,0,0,'2020-08-29 10:36:27','2020-08-29 10:36:27'),
	(425,168,'/0/51/165/168/','物流模板添加',5,'api/admin/express/shipping/templates/save',NULL,0,0,'2020-08-29 10:37:49','2020-08-29 10:37:49'),
	(426,168,'/0/51/165/168/','物流模板修改',5,'api/admin/express/shipping/templates/update',NULL,0,0,'2020-08-29 10:38:01','2020-08-29 10:38:01'),
	(427,168,'/0/51/165/168/','物流模板删除',5,'api/admin/express/shipping/templates/delete',NULL,0,0,'2020-08-29 10:38:11','2020-08-29 10:38:11'),
	(428,168,'/0/51/165/168/','物流模板详情',5,'api/admin/express/shipping/templates/info',NULL,0,0,'2020-08-29 10:38:22','2020-08-29 10:38:27'),
	(429,168,'/0/51/165/168/','物流模板列表',5,'api/admin/express/shipping/templates/list',NULL,0,0,'2020-08-29 10:38:48','2020-08-29 10:38:48'),
	(430,168,'/0/51/165/168/','付费区域',5,'api/admin/express/shipping/region/list',NULL,0,0,'2020-08-29 10:39:22','2020-08-29 10:39:22'),
	(431,168,'/0/51/165/168/','免费区域',5,'api/admin/express/shipping/free/list',NULL,0,0,'2020-08-29 10:39:38','2020-08-29 10:39:38'),
	(432,69,'/0/66/67/69/','数据组添加',5,'api/admin/system/group/save',NULL,0,0,'2020-08-29 10:41:33','2020-08-29 10:41:33'),
	(433,69,'/0/66/67/69/','数据组修改',5,'api/admin/system/group/update',NULL,0,0,'2020-08-29 10:41:49','2020-08-29 10:41:49'),
	(434,69,'/0/66/67/69/','数据组删除',5,'api/admin/system/group/delete',NULL,0,0,'2020-08-29 10:41:59','2020-08-29 10:41:59'),
	(435,69,'/0/66/67/69/','数据组列表',5,'api/admin/system/group/list',NULL,0,0,'2020-08-29 10:42:11','2020-08-29 10:42:11'),
	(436,69,'/0/66/67/69/','数据组详情',5,'api/admin/system/group/info',NULL,0,0,'2020-08-29 10:42:22','2020-08-29 10:42:22'),
	(437,69,'/0/66/67/69/','组合数据添加',5,'api/admin/system/group/data/save',NULL,0,0,'2020-08-29 10:43:00','2020-08-29 10:43:00'),
	(438,69,'/0/66/67/69/','组合数据修改',5,'api/admin/system/group/data/update',NULL,0,0,'2020-08-29 10:43:16','2020-08-29 10:43:16'),
	(439,69,'/0/66/67/69/','组合数据删除',5,'api/admin/system/group/data/delete',NULL,0,0,'2020-08-29 10:43:41','2020-08-29 10:43:41'),
	(440,69,'/0/66/67/69/','组合数据列表',5,'api/admin/system/group/data/list',NULL,0,0,'2020-08-29 10:44:07','2020-08-29 10:44:07'),
	(441,69,'/0/66/67/69/','组合数据详情',5,'api/admin/system/group/data/info',NULL,0,0,'2020-08-29 10:44:16','2020-08-29 10:44:16'),
	(442,250,'/0/66/67/250/','表单添加',5,'api/admin/system/form/temp/save',NULL,0,0,'2020-08-29 10:45:23','2020-08-29 10:45:23'),
	(443,250,'/0/66/67/250/','表单删除',5,'api/admin/system/form/temp/delete',NULL,0,0,'2020-08-29 10:45:40','2020-08-29 10:45:40'),
	(444,250,'/0/66/67/250/','表单修改',5,'api/admin/system/form/temp/update',NULL,0,0,'2020-08-29 10:46:06','2020-08-29 10:46:06'),
	(445,250,'/0/66/67/250/','表单列表',5,'api/admin/system/form/temp/list',NULL,0,0,'2020-08-29 10:46:16','2020-08-29 10:46:16'),
	(446,43,'/0/42/43/','商品列表',5,'api/admin/store/product/list',NULL,0,0,'2020-08-29 16:04:19','2020-08-31 10:07:19'),
	(450,452,'/0/452/','订单统计',5,'/javaMobile/orderStatistics',NULL,1,0,'2020-09-03 10:27:31','2020-09-12 15:20:13'),
	(452,0,'/0/','移动端管理',5,'/javaMobile','mobile-phone',1,0,'2020-09-07 11:21:03','2020-09-12 15:18:48'),
	(454,100,'/0/100/','99Api',6,'99Api','122',1,4,'2020-09-08 12:17:36','2020-09-08 12:18:44'),
	(459,118,'/0/118/','秒杀管理',5,'/marketing/seckill',NULL,1,0,'2020-09-17 10:02:39','2020-09-17 10:02:39'),
	(460,459,'/0/118/459/','秒杀配置',5,'/marketing/seckill/config',NULL,1,0,'2020-09-17 10:37:42','2020-09-17 10:41:30'),
	(461,459,'/0/118/459/','秒杀商品',5,'/marketing/seckill/list',NULL,1,0,'2020-09-17 10:38:27','2020-09-17 10:41:40'),
	(464,0,'/0/','财务',5,'/financial','s-finance',1,1,'2020-09-17 14:34:44','2020-09-17 14:34:44'),
	(465,464,'/0/464/','财务操作',5,'/financial/commission',NULL,1,0,'2020-09-17 14:35:37','2020-09-17 14:35:37'),
	(466,465,'/0/464/465/','申请提现',5,'/financial/commission/template',NULL,1,0,'2020-09-17 14:36:04','2020-09-17 14:36:04'),
	(467,464,'/0/464/','财务记录',5,'/financial/record',NULL,1,0,'2020-09-17 14:36:40','2020-09-17 14:36:40'),
	(468,467,'/0/464/467/','充值记录',5,'/financial/record/charge',NULL,1,0,'2020-09-17 14:36:55','2020-09-17 14:37:22'),
	(469,467,'/0/464/467/','资金监控',5,'/financial/record/monitor',NULL,1,0,'2020-09-17 14:37:35','2020-09-17 14:37:35'),
	(470,464,'/0/464/','佣金记录',5,'/financial/brokerage',NULL,1,0,'2020-09-17 14:38:16','2020-09-17 14:38:16'),
	(477,477,'/0/477/','22222',1,'','image/content/2020/10/19/6c8ba5e093384f589d212ff77e898d39kpfzjv8h3c.png',1,999999999,'2020-10-20 14:44:07','2020-10-20 14:44:29'),
	(488,245,'/0/272/245/','精品首发',1,'',NULL,1,0,'2020-10-21 10:19:17','2020-10-21 17:25:31'),
	(489,245,'/0/272/245/','ds ',1,'',NULL,1,0,'2020-10-22 15:53:13','2020-10-22 15:53:13'),
	(492,118,'/0/118/','砍价管理',5,'/marketing/bargain',NULL,1,0,'2020-11-16 12:29:25','2020-11-16 12:29:25'),
	(493,492,'/0/118/492/','砍价商品',5,'/marketing/bargain/bargainGoods',NULL,1,0,'2020-11-16 14:19:46','2020-11-16 14:19:46'),
	(494,492,'/0/118/492/','砍价列表',5,'/marketing/bargain/bargainList',NULL,1,0,'2020-11-16 14:38:57','2020-11-16 14:38:57'),
	(495,118,'/0/118/','拼团管理',5,'/marketing/groupBuy',NULL,1,0,'2020-11-19 14:06:51','2020-11-19 14:06:51'),
	(496,495,'/0/118/495/','拼团商品',5,'/marketing/groupBuy/groupGoods',NULL,1,0,'2020-11-19 14:07:32','2020-11-19 14:07:32'),
	(497,495,'/0/118/495/','拼团列表',5,'/marketing/groupBuy/groupList',NULL,1,0,'2020-11-19 14:07:57','2020-11-19 14:07:57'),
	(500,0,'/0/','第三方接口设置',6,'short_letter_switch',NULL,1,1,'2020-12-10 10:58:25','2020-12-10 10:59:39'),
	(501,500,'/0/500/','短信配置',6,'short_letter_switch','111',1,1,'2020-12-10 10:59:08','2020-12-10 12:05:54'),
	(502,500,'/0/500/','采集商品配置',6,'copy_product','127',1,1,'2020-12-10 11:00:32','2020-12-10 12:18:38'),
	(503,500,'/0/500/','物流查询',6,'logistics_select','128',1,1,'2020-12-10 11:00:51','2020-12-10 12:18:57'),
	(504,500,'/0/500/','电子面单',6,'electronic_sheet','129',1,1,'2020-12-10 11:01:03','2020-12-10 12:19:02'),
	(505,51,'/0/51/','一号通',5,'/operation/onePass',NULL,1,8,'2020-12-10 11:06:44','2020-12-10 11:07:46'),
	(506,0,'/0/','华为新品发布会',3,'','image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png',1,0,'2020-12-15 17:45:43','2020-12-17 16:53:34'),
	(507,0,'/0/','小米新品发布会',3,'','image/user/2020/12/15/22f159f3c4f94173b1461dedcb993696i8wlul1mqj.jpg',1,0,'2020-12-15 17:46:13','2020-12-17 16:53:33'),
	(508,0,'/0/','饮品新品发布会',3,'1','image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg',1,2,'2020-12-15 17:46:55','2020-12-17 09:16:20'),
	(523,0,'/0/','p',2,'url',NULL,0,1,'2020-12-29 11:02:55','2020-12-29 11:02:55'),
	(524,0,'/0/','888',2,'url',NULL,0,1,'2020-12-29 14:26:03','2020-12-29 14:26:03'),
	(525,0,'/0/','999',2,'url',NULL,0,1,'2020-12-29 14:26:51','2020-12-29 14:26:51'),
	(526,0,'/0/','1',2,'url',NULL,0,1,'2020-12-29 15:03:37','2020-12-29 15:03:37'),
	(528,0,'/0/','JORDAN专栏',1,'','image/content/2021/01/15/c8bb13307db9431ea04c26ef2b5586e33zbgdu0mu1.png',1,0,'2021-01-16 09:20:11','2021-01-16 09:20:11'),
	(529,528,'/0/528/','篮球鞋',1,'','image/store/2021/01/16/fa418fd0a5d34c9cbd96c3ed48e90cb3r0sbrl7pn5.png',1,0,'2021-01-16 09:20:24','2021-01-16 09:21:13'),
	(530,528,'/0/528/','滑板鞋',1,'','image/store/2021/01/16/41bd871869e34a8384b932b50d1f9dd6dwle1zzptr.png',1,0,'2021-01-16 09:20:45','2021-01-16 09:21:45'),
	(531,66,'/0/66/','素材管理',5,'/maintain/picture',NULL,1,1,'2021-01-18 11:28:38','2021-01-18 11:28:38'),
	(532,0,'/0/','测试',1,'','image/operation/2021/01/16/9aeac2ba7558464193e114f947793491e96m4h4w5m.jpg',1,0,'2021-01-18 12:16:34','2021-01-18 12:16:34');

/*!40000 ALTER TABLE `eb_category` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_express
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_express`;

CREATE TABLE `eb_express` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '快递公司id',
  `code` varchar(50) NOT NULL DEFAULT '' COMMENT '快递公司简称',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '快递公司全称',
  `partner_id` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要月结账号',
  `partner_key` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要月结密码',
  `net` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要取件网店',
  `account` varchar(100) NOT NULL DEFAULT '' COMMENT '账号',
  `password` varchar(100) NOT NULL DEFAULT '' COMMENT '密码',
  `net_name` varchar(100) NOT NULL DEFAULT '' COMMENT '网点名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否可用',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `is_show` (`is_show`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='快递公司表';

LOCK TABLES `eb_express` WRITE;
/*!40000 ALTER TABLE `eb_express` DISABLE KEYS */;

INSERT INTO `eb_express` (`id`, `code`, `name`, `partner_id`, `partner_key`, `net`, `account`, `password`, `net_name`, `sort`, `is_show`, `status`)
VALUES
	(1,'yunda','韵达快递',1,1,0,'','','',0,1,0),
	(2,'yuantong','圆通速递',1,1,0,'','','',0,1,0),
	(3,'zhongtong','中通快递',1,1,0,'','','',0,1,0),
	(4,'shentong','申通快递',1,1,1,'','','',0,1,0),
	(5,'huitongkuaidi','百世快递',1,1,0,'','','',0,1,0),
	(6,'jd','京东物流',1,0,0,'','','',0,1,0),
	(7,'jtexpress','极兔速递',0,0,0,'','','',0,1,1),
	(8,'tiantian','天天快递',1,1,1,'','','',0,1,0),
	(9,'debangwuliu','德邦',0,0,0,'','','',0,1,1),
	(10,'debangkuaidi','德邦快递',1,0,0,'','','',0,1,0),
	(11,'zhongyouex','众邮快递',0,0,0,'','','',0,1,1),
	(12,'youshuwuliu','优速快递',1,1,0,'','','',0,1,0),
	(13,'zhongtongkuaiyun','中通快运',0,0,0,'','','',0,1,1),
	(14,'zhaijisong','宅急送',0,0,0,'','','',0,1,1),
	(15,'suning','苏宁物流',0,0,0,'','','',0,1,1),
	(16,'baishiwuliu','百世快运',0,0,0,'','','',0,1,1),
	(17,'zhimakaimen','芝麻开门',0,0,0,'','','',0,1,1),
	(18,'yundakuaiyun','韵达快运',0,0,0,'','','',0,1,1),
	(19,'annengwuliu','安能快运',0,0,0,'','','',0,1,1),
	(20,'lianhaowuliu','联昊通',0,0,0,'','','',0,1,1),
	(21,'ubonex','优邦速运',0,0,0,'','','',0,1,1),
	(22,'kuayue','跨越速运',1,1,0,'','','',0,1,0),
	(23,'yuantongkuaiyun','圆通快运',0,0,0,'','','',0,1,1),
	(24,'zhongyouwuliu','中邮物流',0,0,0,'','','',0,1,1),
	(25,'annto','安得物流',0,0,0,'','','',0,1,1),
	(26,'danniao','丹鸟',0,0,0,'','','',0,1,1),
	(27,'suer','速尔快递',1,0,1,'','','',0,1,0),
	(28,'chinaicip','卓志速运',0,0,0,'','','',0,1,1),
	(29,'zhonghuan','中环快递',0,0,0,'','','',0,1,1),
	(30,'yimidida','壹米滴答',0,0,0,'','','',0,1,1),
	(31,'shpost','同城快寄',0,0,0,'','','',0,1,1),
	(32,'kuaijiesudi','快捷速递',0,0,0,'','','',0,1,1),
	(33,'disifang','递四方',0,0,0,'','','',0,1,1),
	(34,'lntjs','特急送',0,0,0,'','','',0,1,1),
	(35,'rrs','日日顺物流',0,0,0,'','','',0,1,1),
	(36,'sxjdfreight','顺心捷达',0,0,0,'','','',0,1,1),
	(37,'idamalu','大马鹿',0,0,0,'','','',0,1,1),
	(38,'xinfengwuliu','信丰物流',1,1,0,'','','',0,1,0),
	(39,'ztky','中铁快运',0,0,0,'','','',0,1,1),
	(40,'btexpress','邦泰快运',0,0,0,'','','',0,1,1),
	(41,'tiandihuayu','天地华宇',0,0,0,'','','',0,1,1),
	(42,'lianbangkuaidi','联邦快递',0,0,0,'','','',0,1,1),
	(43,'banma','斑马物流',0,0,0,'','','',0,1,1),
	(44,'longbanwuliu','龙邦速递',0,0,0,'','','',0,1,1),
	(45,'flyway','程光快递',0,0,0,'','','',0,1,1),
	(46,'subida','速必达',0,0,0,'','','',0,1,1),
	(47,'jinguangsudikuaijian','京广速递',0,0,0,'','','',0,1,1),
	(48,'weitepai','微特派',0,0,0,'','','',0,1,1),
	(49,'yuxinwuliu','宇鑫物流',0,0,0,'','','',0,1,1),
	(50,'sdto','速达通',0,0,0,'','','',0,1,1),
	(51,'huisenky','汇森速运',0,0,0,'','','',0,1,1),
	(52,'guotongkuaidi','国通快递',1,1,1,'','','',0,1,0),
	(53,'bsht','百事亨通',0,0,0,'','','',0,1,1),
	(54,'jiuyescm','九曳供应链',0,0,0,'','','',0,1,1),
	(55,'sunjex','新杰物流',0,0,0,'','','',0,1,1),
	(56,'zhongtiewuliu','中铁物流',0,0,0,'','','',0,1,1),
	(57,'adapost','安达速递',0,0,0,'','','',0,1,1),
	(58,'wanjiawuliu','万家物流',0,0,0,'','','',0,1,1),
	(59,'shenghuiwuliu','盛辉物流',0,0,0,'','','',0,1,1),
	(60,'zhengyikuaidi','鑫正一快递',0,0,0,'','','',0,1,1),
	(61,'savor','海信物流',0,0,0,'','','',0,1,1),
	(62,'qexpress','易达通快递',0,0,0,'','','',0,1,1),
	(63,'sanhuwuliu','叁虎物流',0,0,0,'','','',0,1,1),
	(64,'polarexpress','极地快递',0,0,0,'','','',0,1,1),
	(65,'rufengda','如风达',0,0,0,'','','',0,1,1),
	(66,'wanxiangwuliu','万象物流',0,0,0,'','','',0,1,1),
	(67,'zhongtongphone','中通（带电话）',0,0,0,'','','',0,1,1),
	(68,'lbex','龙邦物流',0,0,0,'','','',0,1,1),
	(69,'jinan','金岸物流',0,0,0,'','','',0,1,1),
	(70,'sxexpress','三象速递',0,0,0,'','','',0,1,1),
	(71,'jiayunmeiwuliu','加运美',0,0,0,'','','',0,1,1),
	(72,'hac56','瀚朝物流',0,0,0,'','','',0,1,1),
	(73,'la911','鼎润物流',0,0,0,'','','',0,1,1),
	(74,'mosuda','魔速达',0,0,0,'','','',0,1,1),
	(75,'suteng','广东速腾物流',0,0,0,'','','',0,1,1),
	(76,'feiyuanvipshop','飞远配送',0,0,0,'','','',0,1,1),
	(77,'pingandatengfei','平安达腾飞',0,0,0,'','','',0,1,1),
	(78,'guexp','全联速运',0,0,0,'','','',0,1,1),
	(79,'hengluwuliu','恒路物流',0,0,0,'','','',0,1,1),
	(80,'wjkwl','万家康物流',0,0,0,'','','',0,1,1),
	(81,'xdexpress','迅达速递',0,0,0,'','','',0,1,1),
	(82,'yw56','燕文物流',0,0,0,'','','',0,1,1),
	(83,'bflg','上海缤纷物流',0,0,0,'','','',0,1,1),
	(84,'nebuex','星云速递',0,0,0,'','','',0,1,1),
	(85,'unitedex','联合速运',0,0,0,'','','',0,1,1),
	(86,'jiajiwuliu','佳吉快运',0,0,0,'','','',0,1,1),
	(87,'beebird','锋鸟物流',0,0,0,'','','',0,1,1),
	(88,'tzky','铁中快运',0,0,0,'','','',0,1,1),
	(89,'httx56','汇通天下物流',0,0,0,'','','',0,1,1),
	(90,'jumstc','聚盟共建',0,0,0,'','','',0,1,1),
	(91,'shunfengkuaiyun','顺丰快运',0,0,0,'','','',0,1,1),
	(92,'crazyexpress','疯狂快递',0,0,0,'','','',0,1,1),
	(93,'sut56','速通物流',0,0,0,'','','',0,1,1),
	(94,'zengyisudi','增益速递',0,0,0,'','','',0,1,1),
	(95,'valueway','美通',0,0,0,'','','',0,1,1),
	(96,'jssdt56','时达通',0,0,0,'','','',0,1,1),
	(97,'yuanfeihangwuliu','原飞航',0,0,0,'','','',0,1,1),
	(98,'zhongsukuaidi','中速快递',0,0,0,'','','',0,1,1),
	(99,'ane66','安能快递',1,0,0,'','','',0,1,0),
	(100,'anxl','安迅物流',0,0,0,'','','',0,1,1),
	(101,'fujisuyun','富吉速运',0,0,0,'','','',0,1,1),
	(102,'jiajikuaidi','佳吉快递',0,0,0,'','','',0,1,1),
	(103,'ndwl','南方传媒物流',0,0,0,'','','',0,1,1),
	(104,'huangmajia','黄马甲',0,0,0,'','','',0,1,1),
	(105,'hnht56','鸿泰物流',0,0,0,'','','',0,1,1),
	(106,'shangda','上大物流',0,0,0,'','','',0,1,1),
	(107,'ytkd','运通中港快递',0,0,0,'','','',0,1,1),
	(108,'dekuncn','德坤物流',0,0,0,'','','',0,1,1),
	(109,'quansutong','全速通',0,0,0,'','','',0,1,1),
	(110,'cccc58','中集冷云',0,0,0,'','','',0,1,1),
	(111,'dfwl','达发物流',0,0,0,'','','',0,1,1),
	(112,'quanfengkuaidi','全峰快递',0,0,0,'','','',0,1,1),
	(113,'fastgoexpress','速派快递',0,0,0,'','','',0,1,1),
	(114,'yujtong','宇捷通',0,0,0,'','','',0,1,1),
	(115,'chuangyi','创一快递',0,0,0,'','','',0,1,1),
	(116,'ganzhongnengda','能达速递',0,0,0,'','','',0,1,1),
	(117,'yidatong','易达通',0,0,0,'','','',0,1,1),
	(118,'oneexpress','一速递',0,0,0,'','','',0,1,1),
	(119,'datianwuliu','大田物流',0,0,0,'','','',0,1,1),
	(120,'quanyikuaidi','全一快递',1,0,0,'','','',0,1,0),
	(121,'pjbest','品骏快递',1,1,0,'','','',0,1,0),
	(122,'shangqiao56','商桥物流',0,0,0,'','','',0,1,1),
	(123,'tianma','天马迅达',0,0,0,'','','',0,1,1),
	(124,'yousutongda','优速通达',0,0,0,'','','',0,1,1),
	(125,'yuananda','源安达',0,0,0,'','','',0,1,1),
	(126,'astexpress','安世通快递',0,0,0,'','','',0,1,1),
	(127,'exfresh','安鲜达',0,0,0,'','','',0,1,1),
	(128,'jialidatong','嘉里大通',0,0,0,'','','',0,1,1),
	(129,'nanjingshengbang','晟邦物流',0,0,0,'','','',0,1,1),
	(130,'pfcexpress','皇家物流',0,0,0,'','','',0,1,1),
	(131,'qinyuan','秦远物流',0,0,0,'','','',0,1,1),
	(132,'runhengfeng','全时速运',0,0,0,'','','',0,1,1),
	(133,'dayangwuliu','大洋物流',0,0,0,'','','',0,1,1),
	(134,'heimao56','黑猫速运',0,0,0,'','','',0,1,1),
	(135,'huaxiahuoyun','华夏货运',0,0,0,'','','',0,1,1),
	(136,'longfx','LUCFLOW EXPRESS',0,0,0,'','','',0,1,1),
	(137,'zjstky','苏通快运',0,0,0,'','','',0,1,1),
	(138,'zlink','三真驿道',0,0,0,'','','',0,1,1),
	(139,'hd','宏递快运',0,0,0,'','','',0,1,1),
	(140,'hrex','锦程快递',0,0,0,'','','',0,1,1),
	(141,'sfwl','盛丰物流',0,0,0,'','','',0,1,1),
	(142,'yuanchengwuliu','远成物流',0,0,0,'','','',0,1,1),
	(143,'eshunda','俄顺达',0,0,0,'','','',0,1,1),
	(144,'est365','东方汇',0,0,0,'','','',0,1,1),
	(145,'lijisong','成都立即送',0,0,0,'','','',0,1,1),
	(146,'morelink56','MoreLink',0,0,0,'','','',0,1,1),
	(147,'topspeedex','中运全速',0,0,0,'','','',0,1,1),
	(148,'yunfeng56','韵丰物流',0,0,0,'','','',0,1,1),
	(149,'express7th','7号速递',0,0,0,'','','',0,1,1),
	(150,'wherexpess','威盛快递',0,0,0,'','','',0,1,1),
	(151,'yizhengdasuyun','一正达速运',0,0,0,'','','',0,1,1),
	(152,'youyou','优优速递',0,0,0,'','','',0,1,1),
	(153,'ztong','智通物流',0,0,0,'','','',0,1,1),
	(154,'chinapostcb','中邮电商',0,0,0,'','','',0,1,1),
	(155,'hlyex','好来运',0,0,0,'','','',0,1,1),
	(156,'jgwl','景光物流',0,0,0,'','','',0,1,1),
	(157,'jiujiuwl','久久物流',0,0,0,'','','',0,1,1),
	(158,'minghangkuaidi','民航快递',0,0,0,'','','',0,1,1),
	(159,'quansu','全速物流',0,0,0,'','','',0,1,1),
	(160,'tywl99','天翼物流',0,0,0,'','','',0,1,1),
	(161,'wondersyd','中邮速递',0,0,0,'','','',0,1,1),
	(162,'yafengsudi','亚风速递',0,0,0,'','','',0,1,1),
	(163,'ytchengnuoda','承诺达',1,1,0,'','','',0,1,0),
	(164,'anxindakuaixi','安信达',0,0,0,'','','',0,1,1),
	(165,'chengtong','城通物流',0,0,0,'','','',0,1,1),
	(166,'eupackage','易优包裹',0,0,0,'','','',0,1,1),
	(167,'ftky365','丰通快运',0,0,0,'','','',0,1,1),
	(168,'gslhkd','联合快递',0,0,0,'','','',0,1,1),
	(169,'jiayiwuliu','佳怡物流',0,0,0,'','','',0,1,1),
	(170,'jieborne','捷邦物流',0,0,0,'','','',0,1,1),
	(171,'jxfex','集先锋快递',0,0,0,'','','',0,1,1),
	(172,'luben','陆本速递 LUBEN EXPRESS',0,0,0,'','','',0,1,1),
	(173,'tykd','天翼快递',0,0,0,'','','',0,1,1),
	(174,'baitengwuliu','百腾物流',0,0,0,'','','',0,1,1),
	(175,'biaojikuaidi','彪记快递',0,0,0,'','','',0,1,1),
	(176,'boyol','贝业物流',0,0,0,'','','',0,1,1),
	(177,'exsuda','E速达',0,0,0,'','','',0,1,1),
	(178,'feikangda','飞康达',0,0,0,'','','',0,1,1),
	(179,'jiacheng','佳成快递 ',0,0,0,'','','',0,1,1),
	(180,'jingshun','景顺物流',0,0,0,'','','',0,1,1),
	(181,'mingliangwuliu','明亮物流',0,0,0,'','','',0,1,1),
	(182,'shunjiefengda','顺捷丰达',0,0,0,'','','',0,1,1),
	(183,'sundarexpress','顺达快递',0,0,0,'','','',0,1,1),
	(184,'yaofeikuaidi','耀飞同城快递',0,0,0,'','','',0,1,1),
	(185,'1ziton','一智通',0,0,0,'','','',0,1,1),
	(186,'alog','心怡物流',0,0,0,'','','',0,1,1),
	(187,'bdatong','八达通',0,0,0,'','','',0,1,1),
	(188,'bosind','堡昕德速递',0,0,0,'','','',0,1,1),
	(189,'buytong','百通物流',0,0,0,'','','',0,1,1),
	(190,'changyuwuliu','长宇物流',0,0,0,'','','',0,1,1),
	(191,'chuanxiwuliu','传喜物流',0,0,0,'','','',0,1,1),
	(192,'chunghwa56','中骅物流',0,0,0,'','','',0,1,1),
	(193,'cnspeedster','速舟物流',0,0,0,'','','',0,1,1),
	(194,'didasuyun','递达速运',0,0,0,'','','',0,1,1),
	(195,'emswuliu','EMS物流',0,0,0,'','','',0,1,1),
	(196,'feibaokuaidi','飞豹快递',0,0,0,'','','',0,1,1),
	(197,'gda','安的快递',0,0,0,'','','',0,1,1),
	(198,'gdkjk56','快捷快物流',0,0,0,'','','',0,1,1),
	(199,'guoeryue','天天快物流',0,0,0,'','','',0,1,1),
	(200,'hotwms','皇家云仓',0,0,0,'','','',0,1,1),
	(201,'ht22','海淘物流',0,0,0,'','','',0,1,1),
	(202,'huaqikuaiyun','华企快运',0,0,0,'','','',0,1,1),
	(203,'jcsuda','嘉诚速达',0,0,0,'','','',0,1,1),
	(204,'longcps','加拿大龙行速运',0,0,0,'','','',0,1,1),
	(205,'newsway','家家通快递',0,0,0,'','','',0,1,1),
	(206,'qbexpress','秦邦快运',0,0,0,'','','',0,1,1),
	(207,'quanritongkuaidi','全日通',0,0,0,'','','',0,1,1),
	(208,'sanshengco','三盛快递',0,0,0,'','','',0,1,1),
	(209,'shangcheng','尚橙物流',0,0,0,'','','',0,1,1),
	(210,'shunfenghk','顺丰-繁体',0,0,0,'','','',0,1,1),
	(211,'spring56','春风物流',0,0,0,'','','',0,1,1),
	(212,'sxhongmajia','红马甲物流',0,0,0,'','','',0,1,1),
	(213,'szshihuatong56','世华通物流',0,0,0,'','','',0,1,1),
	(214,'wto56kj','臣邦同城',0,0,0,'','','',0,1,1),
	(215,'xiangteng','翔腾物流',0,0,0,'','','',0,1,1),
	(216,'xunsuexpress','迅速快递',0,0,0,'','','',0,1,1),
	(217,'yongchangwuliu','永昌物流',0,0,0,'','','',0,1,1),
	(218,'yuanzhijiecheng','元智捷诚',0,0,0,'','','',0,1,1),
	(219,'yuefengwuliu','越丰物流',0,0,0,'','','',0,1,1),
	(220,'zhongjiwuliu','中技物流',0,0,0,'','','',0,1,1),
	(221,'zlxdjwl','中粮鲜到家物流',0,0,0,'','','',0,1,1),
	(222,'adaexpress','明大快递',0,0,0,'','','',0,1,1),
	(223,'advancing','安达信',0,0,0,'','','',0,1,1),
	(224,'agopost','全程快递',0,0,0,'','','',0,1,1),
	(225,'ahdf','德方物流',0,0,0,'','','',0,1,1),
	(226,'ahkbps','卡邦配送',0,0,0,'','','',0,1,1),
	(227,'aliexpress','无忧物流',0,0,0,'','','',0,1,1),
	(228,'anjiatongcheng','安家同城快运',0,0,0,'','','',0,1,1),
	(229,'anjie88','安捷物流',0,0,0,'','','',0,1,1),
	(230,'anjiekuaidi','青岛安捷快递',0,0,0,'','','',0,1,1),
	(231,'anlexpress','新干线快递',0,0,0,'','','',0,1,1),
	(232,'apgecommerce','apgecommerce',0,0,0,'','','',0,1,1),
	(233,'ariesfar','艾瑞斯远',0,0,0,'','','',0,1,1),
	(234,'ausbondexpress','澳邦国际物流',0,0,0,'','','',0,1,1),
	(235,'auvanda','中联速递',0,0,0,'','','',0,1,1),
	(236,'baishiyp','百世云配',0,0,0,'','','',0,1,1),
	(237,'bangsongwuliu','邦送物流',0,0,0,'','','',0,1,1),
	(238,'baotongkd','宝通快递',0,0,0,'','','',0,1,1),
	(239,'baoxianda','报通快递',0,0,0,'','','',0,1,1),
	(240,'bazirim','皮牙子快递',0,0,0,'','','',0,1,1),
	(241,'beckygo','佰麒快递',0,0,0,'','','',0,1,1),
	(242,'bee001','蜜蜂速递',0,0,0,'','','',0,1,1),
	(243,'benteng','奔腾物流',0,0,0,'','','',0,1,1),
	(244,'bjqywl','青云物流',0,0,0,'','','',0,1,1),
	(245,'bjxsrd','鑫锐达',0,0,0,'','','',0,1,1),
	(246,'bljt56','佰乐捷通',0,0,0,'','','',0,1,1),
	(247,'bmlchina','标杆物流',0,0,0,'','','',0,1,1),
	(248,'bqcwl','百千诚物流',0,0,0,'','','',0,1,1),
	(249,'byht','展勤快递',0,0,0,'','','',0,1,1),
	(250,'canhold','能装能送',0,0,0,'','','',0,1,1),
	(251,'cbo56','钏博物流',0,0,0,'','','',0,1,1),
	(252,'ccd','河南次晨达',0,0,0,'','','',0,1,1),
	(253,'cdjx56','捷祥物流',0,0,0,'','','',0,1,1),
	(254,'cdxinchen56','鑫宸物流',0,0,0,'','','',0,1,1),
	(255,'cex','城铁速递',0,0,0,'','','',0,1,1),
	(256,'cfss','银雁专送',0,0,0,'','','',0,1,1),
	(257,'chengji','城际快递',0,0,0,'','','',0,1,1),
	(258,'chengpei','河北橙配',0,0,0,'','','',0,1,1),
	(259,'chinastarlogistics','华欣物流',0,0,0,'','','',0,1,1),
	(260,'chinatzx','同舟行物流',0,0,0,'','','',0,1,1),
	(261,'chllog','嘉荣物流',0,0,0,'','','',0,1,1),
	(262,'cht361','诚和通',0,0,0,'','','',0,1,1),
	(263,'city56','城市映急',0,0,0,'','','',0,1,1),
	(264,'cjkoreaexpress','大韩通运',0,0,0,'','','',0,1,1),
	(265,'cneulogistics','中欧物流',0,0,0,'','','',0,1,1),
	(266,'cpsair','华中快递',0,0,0,'','','',0,1,1),
	(267,'cqxingcheng','重庆星程快递',0,0,0,'','','',0,1,1),
	(268,'crossbox','环旅快运',0,0,0,'','','',0,1,1),
	(269,'csxss','新时速物流',0,0,0,'','','',0,1,1),
	(270,'czwlyn','云南诚中物流',0,0,0,'','','',0,1,1),
	(271,'dadaoex','大道物流',0,0,0,'','','',0,1,1),
	(272,'dande56','丹递56',0,0,0,'','','',0,1,1),
	(273,'dasu','达速物流',0,0,0,'','','',0,1,1),
	(274,'dechuangwuliu','深圳德创物流',0,0,0,'','','',0,1,1),
	(275,'decnlh','德中快递',0,0,0,'','','',0,1,1),
	(276,'dfkuaidi','东风快递',0,0,0,'','','',0,1,1),
	(277,'dfpost','达方物流',0,0,0,'','','',0,1,1),
	(278,'di5pll','递五方云仓',0,0,0,'','','',0,1,1),
	(279,'diantongkuaidi','店通快递',0,0,0,'','','',0,1,1),
	(280,'dianyi','云南滇驿物流',0,0,0,'','','',0,1,1),
	(281,'dingdong','叮咚快递',0,0,0,'','','',0,1,1),
	(282,'djy56','天翔东捷运',0,0,0,'','','',0,1,1),
	(283,'donghanwl','东瀚物流',0,0,0,'','','',0,1,1),
	(284,'donghong','东红物流',0,0,0,'','','',0,1,1),
	(285,'dongjun','成都东骏物流',0,0,0,'','','',0,1,1),
	(286,'duodao56','duodao56',0,0,0,'','','',0,1,1),
	(287,'edaeuexpress','易达快运',0,0,0,'','','',0,1,1),
	(288,'efspost','EFSPOST',0,0,0,'','','',0,1,1),
	(289,'el56','易联通达',0,0,0,'','','',0,1,1),
	(290,'eusacn','优莎速运',0,0,0,'','','',0,1,1),
	(291,'excocotree','可可树美中速运',0,0,0,'','','',0,1,1),
	(292,'fanyukuaidi','凡宇快递',0,0,0,'','','',0,1,1),
	(293,'fastzt','正途供应链',0,0,0,'','','',0,1,1),
	(294,'fbkd','飞邦快递',0,0,0,'','','',0,1,1),
	(295,'feihukuaidi','飞狐快递',0,0,0,'','','',0,1,1),
	(296,'feikuaida','飞快达',0,0,0,'','','',0,1,1),
	(297,'fenghuangkuaidi','凤凰快递',0,0,0,'','','',0,1,1),
	(298,'fengyee','丰羿',0,0,0,'','','',0,1,1),
	(299,'flysman','飞力士物流',0,0,0,'','','',0,1,1),
	(300,'fsexp','全速快递',0,0,0,'','','',0,1,1),
	(301,'ftlexpress','法翔速运',0,0,0,'','','',0,1,1),
	(302,'fyex','飞云快递系统',0,0,0,'','','',0,1,1),
	(303,'gaotieex','高铁快运',0,0,0,'','','',0,1,1),
	(304,'gdct56','广东诚通物流',0,0,0,'','','',0,1,1),
	(305,'gdqwwl','全网物流',0,0,0,'','','',0,1,1),
	(306,'gdrz58','容智快运',0,0,0,'','','',0,1,1),
	(307,'gdxp','新鹏快递',0,0,0,'','','',0,1,1),
	(308,'ghl','环创物流',0,0,0,'','','',0,1,1),
	(309,'gjwl','冠捷物流 ',0,0,0,'','','',0,1,1),
	(310,'gml','英脉物流',0,0,0,'','','',0,1,1),
	(311,'goldjet','高捷快运',0,0,0,'','','',0,1,1),
	(312,'gongsuda','共速达',0,0,0,'','','',0,1,1),
	(313,'gooday365','日日顺智慧物联',0,0,0,'','','',0,1,1),
	(314,'gscq365','哥士传奇速递',0,0,0,'','','',0,1,1),
	(315,'gswtkd','万通快递',0,0,0,'','','',0,1,1),
	(316,'gtongsudi','广通速递',0,0,0,'','','',0,1,1),
	(317,'gttexpress','GTT EXPRESS快递',0,0,0,'','','',0,1,1),
	(318,'guangdongtonglu','广东通路',0,0,0,'','','',0,1,1),
	(319,'guosong','国送快运',0,0,0,'','','',0,1,1),
	(320,'gxwl','光线速递',0,0,0,'','','',0,1,1),
	(321,'gzxingcheng','贵州星程快递',0,0,0,'','','',0,1,1),
	(322,'haihongwangsong','海红网送',0,0,0,'','','',0,1,1),
	(323,'haimengsudi','海盟速递',0,0,0,'','','',0,1,1),
	(324,'haixingqiao','海星桥快递',0,0,0,'','','',0,1,1),
	(325,'haizhongzhuanyun','海中转运',0,0,0,'','','',0,1,1),
	(326,'hanfengjl','翰丰快递',0,0,0,'','','',0,1,1),
	(327,'hangrui','上海航瑞货运',0,0,0,'','','',0,1,1),
	(328,'hangyu','航宇快递',0,0,0,'','','',0,1,1),
	(329,'haoyoukuai','好又快物流',0,0,0,'','','',0,1,1),
	(330,'happylink','开心快递',0,0,0,'','','',0,1,1),
	(331,'hdcexpress','汇达物流',0,0,0,'','','',0,1,1),
	(332,'hengrui56','恒瑞物流',0,0,0,'','','',0,1,1),
	(333,'hexinexpress','合心速递',0,0,0,'','','',0,1,1),
	(334,'hgy56','环国运物流',0,0,0,'','','',0,1,1),
	(335,'hhair56','华瀚快递',0,0,0,'','','',0,1,1),
	(336,'hjs','猴急送',0,0,0,'','','',0,1,1),
	(337,'hlkytj','互联快运',0,0,0,'','','',0,1,1),
	(338,'hlpgyl','共联配',0,0,0,'','','',0,1,1),
	(339,'hltop','海联快递',0,0,0,'','','',0,1,1),
	(340,'hmus','华美快递',0,0,0,'','','',0,1,1),
	(341,'hnfy','飞鹰物流',0,0,0,'','','',0,1,1),
	(342,'hnqst','河南全速通',0,0,0,'','','',0,1,1),
	(343,'hnssd56','顺时达物流',0,0,0,'','','',0,1,1),
	(344,'hnzqwl','中强物流',0,0,0,'','','',0,1,1),
	(345,'homexpress','居家通',0,0,0,'','','',0,1,1),
	(346,'hongbeixin','红背心',0,0,0,'','','',0,1,1),
	(347,'hongpinwuliu','宏品物流',0,0,0,'','','',0,1,1),
	(348,'hongywl','红远物流',0,0,0,'','','',0,1,1),
	(349,'hrbzykd','卓烨快递',0,0,0,'','','',0,1,1),
	(350,'hre','高铁速递',0,0,0,'','','',0,1,1),
	(351,'hsgtsd','海硕高铁速递',0,0,0,'','','',0,1,1),
	(352,'htongexpress','华通快运',0,0,0,'','','',0,1,1),
	(353,'htwd','华通务达物流',0,0,0,'','','',0,1,1),
	(354,'huada','华达快运',0,0,0,'','','',0,1,1),
	(355,'huandonglg','环东物流',0,0,0,'','','',0,1,1),
	(356,'huiqiangkuaidi','汇强快递',0,0,0,'','','',0,1,1),
	(357,'huoban','兰州伙伴物流',0,0,0,'','','',0,1,1),
	(358,'hutongwuliu','户通物流',0,0,0,'','','',0,1,1),
	(359,'hyeship','鸿远物流',0,0,0,'','','',0,1,1),
	(360,'hyytes','恒宇运通',0,0,0,'','','',0,1,1),
	(361,'hzpl','华航快递',0,0,0,'','','',0,1,1),
	(362,'idada','大达物流',0,0,0,'','','',0,1,1),
	(363,'jdexpressusa','骏达快递',0,0,0,'','','',0,1,1),
	(364,'jdpplus','急递',0,0,0,'','','',0,1,1),
	(365,'jiajiatong56','佳家通货运',0,0,0,'','','',0,1,1),
	(366,'jiajiawl','加佳物流',0,0,0,'','','',0,1,1),
	(367,'jiazhoumao','加州猫速递',0,0,0,'','','',0,1,1),
	(368,'jieanda','捷安达',0,0,0,'','','',0,1,1),
	(369,'jinchengwuliu','锦程物流',0,0,0,'','','',0,1,1),
	(370,'jindawuliu','金大物流',0,0,0,'','','',0,1,1),
	(371,'jintongkd','劲通快递',0,0,0,'','','',0,1,1),
	(372,'jinyuekuaidi','晋越快递',0,0,0,'','','',0,1,1),
	(373,'jisu','冀速物流',0,0,0,'','','',0,1,1),
	(374,'jiugong','九宫物流',0,0,0,'','','',0,1,1),
	(375,'jiuyicn','久易快递',0,0,0,'','','',0,1,1),
	(376,'jixianda','急先达',0,0,0,'','','',0,1,1),
	(377,'jjx888','佳捷翔物流',0,0,0,'','','',0,1,1),
	(378,'jsexpress','骏绅物流',0,0,0,'','','',0,1,1),
	(379,'juding','聚鼎物流',0,0,0,'','','',0,1,1),
	(380,'juwu','聚物物流',0,0,0,'','','',0,1,1),
	(381,'juzhongda','聚中大',0,0,0,'','','',0,1,1),
	(382,'kejie','科捷物流',0,0,0,'','','',0,1,1),
	(383,'kerrytj','嘉里大荣物流',0,0,0,'','','',0,1,1),
	(384,'kfwnet','快服务',0,0,0,'','','',0,1,1),
	(385,'khzto','柬埔寨中通',0,0,0,'','','',0,1,1),
	(386,'koalaexp','考拉速递',0,0,0,'','','',0,1,1),
	(387,'ksudi','快速递',0,0,0,'','','',0,1,1),
	(388,'kuai8','快8速运',0,0,0,'','','',0,1,1),
	(389,'kuaidawuliu','快达物流',0,0,0,'','','',0,1,1),
	(390,'kuaitao','快淘快递',0,0,0,'','','',0,1,1),
	(391,'kuaiyouda','四川快优达速递',0,0,0,'','','',0,1,1),
	(392,'kxda','凯信达',0,0,0,'','','',0,1,1),
	(393,'lanbiaokuaidi','蓝镖快递',0,0,0,'','','',0,1,1),
	(394,'lanhukuaidi','蓝弧快递',0,0,0,'','','',0,1,1),
	(395,'lasy56','林安物流',0,0,0,'','','',0,1,1),
	(396,'lbbk','立白宝凯物流',0,0,0,'','','',0,1,1),
	(397,'ledaowuliu','楽道物流',0,0,0,'','','',0,1,1),
	(398,'ledii','乐递供应链',0,0,0,'','','',0,1,1),
	(399,'letseml','美联快递',0,0,0,'','','',0,1,1),
	(400,'lianbangkuaidien','联邦快递-英文',0,0,0,'','','',0,1,1),
	(401,'lianyun','联运快递',0,0,0,'','','',0,1,1),
	(402,'lishi','丽狮物流',0,0,0,'','','',0,1,1),
	(403,'littlebearbear','小熊物流',0,0,0,'','','',0,1,1),
	(404,'longlangkuaidi','隆浪快递',0,0,0,'','','',0,1,1),
	(405,'longvast','长风物流',0,0,0,'','','',0,1,1),
	(406,'lqht','恒通快递',0,0,0,'','','',0,1,1),
	(407,'ltexp','乐天速递',0,0,0,'','','',0,1,1),
	(408,'lutong','鲁通快运',0,0,0,'','','',0,1,1),
	(409,'mailikuaidi','麦力快递',0,0,0,'','','',0,1,1),
	(410,'mailongdy','迈隆递运',0,0,0,'','','',0,1,1),
	(411,'mangguo','芒果速递',0,0,0,'','','',0,1,1),
	(412,'mchy','木春货运',0,0,0,'','','',0,1,1),
	(413,'meidaexpress','美达快递',0,0,0,'','','',0,1,1),
	(414,'meitai','美泰物流',0,0,0,'','','',0,1,1),
	(415,'milkyway','银河物流',0,0,0,'','','',0,1,1),
	(416,'minbangsudi','民邦速递',0,0,0,'','','',0,1,1),
	(417,'mjexp','美龙快递',0,0,0,'','','',0,1,1),
	(418,'mxe56','中俄速通（淼信）',0,0,0,'','','',0,1,1),
	(419,'nalexpress','新亚物流',0,0,0,'','','',0,1,1),
	(420,'nedahm','红马速递',0,0,0,'','','',0,1,1),
	(421,'nell','尼尔快递',0,0,0,'','','',0,1,1),
	(422,'niuzaiexpress','牛仔速运',0,0,0,'','','',0,1,1),
	(423,'njhaobo','浩博物流',0,0,0,'','','',0,1,1),
	(424,'nmhuahe','华赫物流',0,0,0,'','','',0,1,1),
	(425,'nntengda','腾达速递',0,0,0,'','','',0,1,1),
	(426,'onway','昂威物流',0,0,0,'','','',0,1,1),
	(427,'overseaex','波音速递',0,0,0,'','','',0,1,1),
	(428,'peex','派尔快递',0,0,0,'','','',0,1,1),
	(429,'peisihuoyunkuaidi','配思货运',0,0,0,'','','',0,1,1),
	(430,'peixingwuliu','陪行物流',0,0,0,'','','',0,1,1),
	(431,'pengcheng','鹏程快递',0,0,0,'','','',0,1,1),
	(432,'pinsuxinda','品速心达快递',0,0,0,'','','',0,1,1),
	(433,'pinxinkuaidi','品信快递',0,0,0,'','','',0,1,1),
	(434,'pmt0704be','龙行天下',0,0,0,'','','',0,1,1),
	(435,'polarisexpress','北极星快运',0,0,0,'','','',0,1,1),
	(436,'pzhjst','急顺通',0,0,0,'','','',0,1,1),
	(437,'qhxykd','雪域快递',0,0,0,'','','',0,1,1),
	(438,'qhxyyg','雪域易购',0,0,0,'','','',0,1,1),
	(439,'qianli','千里速递',0,0,0,'','','',0,1,1),
	(440,'qskdyxgs','千顺快递',0,0,0,'','','',0,1,1),
	(441,'quanchuan56','全川物流',0,0,0,'','','',0,1,1),
	(442,'quanjitong','全际通',0,0,0,'','','',0,1,1),
	(443,'quantwl','全通快运',0,0,0,'','','',0,1,1),
	(444,'quanxintong','全信通快递',0,0,0,'','','',0,1,1),
	(445,'qzx56','全之鑫物流',0,0,0,'','','',0,1,1),
	(446,'rhtexpress','睿和泰速运',0,0,0,'','','',0,1,1),
	(447,'riyuwuliu','日昱物流',0,0,0,'','','',0,1,1),
	(448,'rokin','荣庆物流',0,0,0,'','','',0,1,1),
	(449,'rrskx','日日顺快线',0,0,0,'','','',0,1,1),
	(450,'santaisudi','三态速递',0,0,0,'','','',0,1,1),
	(451,'sccod','丰程物流',0,0,0,'','','',0,1,1),
	(452,'scsujiada','速佳达快运',0,0,0,'','','',0,1,1),
	(453,'scxingcheng','四川星程快递',0,0,0,'','','',0,1,1),
	(454,'sczpds','速呈',0,0,0,'','','',0,1,1),
	(455,'sdsy888','首达速运',0,0,0,'','','',0,1,1),
	(456,'sfift','十方通物流',0,0,0,'','','',0,1,1),
	(457,'sfjhd','圣飞捷快递',0,0,0,'','','',0,1,1),
	(458,'shanda56','衫达快运',0,0,0,'','','',0,1,1),
	(459,'shanghaikuaitong','上海快通',0,0,0,'','','',0,1,1),
	(460,'shangtuguoji','尚途国际货运',0,0,0,'','','',0,1,1),
	(461,'shaoke','捎客物流',0,0,0,'','','',0,1,1),
	(462,'shd56','商海德物流',0,0,0,'','','',0,1,1),
	(463,'shenganwuliu','圣安物流',0,0,0,'','','',0,1,1),
	(464,'shengtongscm','盛通快递',0,0,0,'','','',0,1,1),
	(465,'shenjun','神骏物流',0,0,0,'','','',0,1,1),
	(466,'shenma','神马快递',0,0,0,'','','',0,1,1),
	(467,'shiningexpress','阳光快递',0,0,0,'','','',0,1,1),
	(468,'shipbyace','王牌快递',0,0,0,'','','',0,1,1),
	(469,'shipsoho','苏豪快递',0,0,0,'','','',0,1,1),
	(470,'shiyunkuaidi','世运快递',0,0,0,'','','',0,1,1),
	(471,'shunfengtongcheng','顺丰同城',0,0,0,'','','',0,1,1),
	(472,'shunjieda','顺捷达',0,0,0,'','','',0,1,1),
	(473,'shunshid','顺士达速运',0,0,0,'','','',0,1,1),
	(474,'signedexpress','签收快递',0,0,0,'','','',0,1,1),
	(475,'sihaiet','四海快递',0,0,0,'','','',0,1,1),
	(476,'sihiexpress','四海捷运',0,0,0,'','','',0,1,1),
	(477,'sixroad','易普递',0,0,0,'','','',0,1,1),
	(478,'sofast56','嗖一下同城快递',0,0,0,'','','',0,1,1),
	(479,'speeda','行必达',0,0,0,'','','',0,1,1),
	(480,'speedoex','申必达',0,0,0,'','','',0,1,1),
	(481,'staky','首通快运',0,0,0,'','','',0,1,1),
	(482,'starex','星速递',0,0,0,'','','',0,1,1),
	(483,'staryvr','星运快递',0,0,0,'','','',0,1,1),
	(484,'stkd','顺通快递',0,0,0,'','','',0,1,1),
	(485,'subaoex','速豹',0,0,0,'','','',0,1,1),
	(486,'sucheng','速呈宅配',0,0,0,'','','',0,1,1),
	(487,'sucmj','特急便物流',0,0,0,'','','',0,1,1),
	(488,'sufengkuaidi','速风快递',0,0,0,'','','',0,1,1),
	(489,'suijiawuliu','穗佳物流',0,0,0,'','','',0,1,1),
	(490,'sujievip','郑州速捷',0,0,0,'','','',0,1,1),
	(491,'sunspeedy','新速航',0,0,0,'','','',0,1,1),
	(492,'supinexpress','速品快递',0,0,0,'','','',0,1,1),
	(493,'szuem','联运通物流',0,0,0,'','','',0,1,1),
	(494,'taijin','泰进物流',0,0,0,'','','',0,1,1),
	(495,'taimek','天美快递',0,0,0,'','','',0,1,1),
	(496,'tianxiang','天翔快递',0,0,0,'','','',0,1,1),
	(497,'tianzong','天纵物流',0,0,0,'','','',0,1,1),
	(498,'timedg','万家通快递',0,0,0,'','','',0,1,1),
	(499,'tlky','天联快运',0,0,0,'','','',0,1,1),
	(500,'tmg','株式会社T.M.G',0,0,0,'','','',0,1,1),
	(501,'tongdaxing','通达兴物流',0,0,0,'','','',0,1,1),
	(502,'tonghetianxia','通和天下',0,0,0,'','','',0,1,1),
	(503,'ugoexpress','邮鸽速运',0,0,0,'','','',0,1,1),
	(504,'uluckex','优联吉运',0,0,0,'','','',0,1,1),
	(505,'vps','维普恩物流',0,0,0,'','','',0,1,1),
	(506,'wanboex','万博快递',0,0,0,'','','',0,1,1),
	(507,'wandougongzhu','豌豆物流',0,0,0,'','','',0,1,1),
	(508,'wanjiatong','宁夏万家通',0,0,0,'','','',0,1,1),
	(509,'wdm','万达美',0,0,0,'','','',0,1,1),
	(510,'westwing','西翼物流',0,0,0,'','','',0,1,1),
	(511,'wexpress','威速递',0,0,0,'','','',0,1,1),
	(512,'winit','万邑通',0,0,0,'','','',0,1,1),
	(513,'wlfast','凡仕特物流',0,0,0,'','','',0,1,1),
	(514,'wowvip','沃埃家',0,0,0,'','','',0,1,1),
	(515,'wtdchina','威时沛运货运',0,0,0,'','','',0,1,1),
	(516,'wuliuky','五六快运',0,0,0,'','','',0,1,1),
	(517,'wuyuansudi','伍圆速递',0,0,0,'','','',0,1,1),
	(518,'xdshipping','国晶物流',0,0,0,'','','',0,1,1),
	(519,'xflt56','蓝天物流',0,0,0,'','','',0,1,1),
	(520,'xianchengliansudi','西安城联速递',0,0,0,'','','',0,1,1),
	(521,'xiangdawuliu','湘达物流',0,0,0,'','','',0,1,1),
	(522,'xianglongyuntong','祥龙运通物流',0,0,0,'','','',0,1,1),
	(523,'xilaikd','西安喜来快递',0,0,0,'','','',0,1,1),
	(524,'xingyuankuaidi','新元快递',0,0,0,'','','',0,1,1),
	(525,'xinning','新宁物流',0,0,0,'','','',0,1,1),
	(526,'xsrd','鑫世锐达',0,0,0,'','','',0,1,1),
	(527,'xtb','鑫通宝物流',0,0,0,'','','',0,1,1),
	(528,'xyd666','鑫远东速运',0,0,0,'','','',0,1,1),
	(529,'yatfai','一辉物流',0,0,0,'','','',0,1,1),
	(530,'ycgky','远成快运',0,0,0,'','','',0,1,1),
	(531,'ydglobe','云达通',0,0,0,'','','',0,1,1),
	(532,'ydhex','YDH',0,0,0,'','','',0,1,1),
	(533,'yhtlogistics','宇航通物流',0,0,0,'','','',0,1,1),
	(534,'yibangwuliu','一邦速递',0,0,0,'','','',0,1,1),
	(535,'yidihui','驿递汇速递',0,0,0,'','','',0,1,1),
	(536,'yiex','宜送物流',0,0,0,'','','',0,1,1),
	(537,'yifankd','艺凡快递',0,0,0,'','','',0,1,1),
	(538,'yihangmall','易航物流',0,0,0,'','','',0,1,1),
	(539,'yilingsuyun','亿领速运',0,0,0,'','','',0,1,1),
	(540,'yinjiesudi','银捷速递',0,0,0,'','','',0,1,1),
	(541,'yiqisong','一起送',0,0,0,'','','',0,1,1),
	(542,'yisong','宜送',0,0,0,'','','',0,1,1),
	(543,'yitongda','易通达',0,0,0,'','','',0,1,1),
	(544,'yiyou','易邮速运',0,0,0,'','','',0,1,1),
	(545,'yjhgo','武汉优进汇',0,0,0,'','','',0,1,1),
	(546,'ynztsy','纵通速运',0,0,0,'','','',0,1,1),
	(547,'youjia','友家速递',0,0,0,'','','',0,1,1),
	(548,'youlai','邮来速递',0,0,0,'','','',0,1,1),
	(549,'ypsd','壹品速递',0,0,0,'','','',0,1,1),
	(550,'ytky168','运通快运',0,0,0,'','','',0,1,1),
	(551,'yuandun','远盾物流',0,0,0,'','','',0,1,1),
	(552,'yue777','玥玛速运',0,0,0,'','','',1,0,1),
	(553,'yufeng','御风速运',0,0,0,'','','',0,1,1),
	(554,'yujiawl','宇佳物流',0,0,0,'','','',0,1,1),
	(555,'yuntong','运通速运',0,0,0,'','','',0,1,1),
	(556,'yuntongkuaidi','运通中港',0,0,0,'','','',0,1,1),
	(557,'ywexpress','远为快递',0,0,0,'','','',0,1,1),
	(558,'yyexp','西安运逸快递',0,0,0,'','','',0,1,1),
	(559,'yyqc56','一运全成物流',0,0,0,'','','',0,1,1),
	(560,'zf365','珠峰速运',0,0,0,'','','',0,1,1),
	(561,'zhdwl','众辉达物流',0,0,0,'','','',0,1,1),
	(562,'zhitengwuliu','志腾物流',0,0,0,'','','',0,1,1),
	(563,'zhongtianwanyun','中天万运',0,0,0,'','','',0,1,1),
	(564,'zhongxinda','忠信达',0,0,0,'','','',0,1,1),
	(565,'zhpex','众派速递',0,0,0,'','','',0,1,1),
	(566,'zhuoshikuaiyun','卓实快运',0,0,0,'','','',0,1,1),
	(567,'zjcy56','创运物流',0,0,0,'','','',0,1,1),
	(568,'zsda56','转瞬达集运',0,0,0,'','','',0,1,1),
	(569,'zsky123','准实快运',0,0,0,'','','',0,1,1),
	(570,'zsmhwl','明辉物流',0,0,0,'','','',0,1,1),
	(571,'zy100','中远快运',0,0,0,'','','',0,1,1);

/*!40000 ALTER TABLE `eb_express` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_shipping_templates
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_shipping_templates`;

CREATE TABLE `eb_shipping_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `name` varchar(255) NOT NULL COMMENT '模板名称',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '计费方式',
  `appoint` tinyint(1) NOT NULL DEFAULT '0' COMMENT '指定包邮',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='运费模板';

LOCK TABLES `eb_shipping_templates` WRITE;
/*!40000 ALTER TABLE `eb_shipping_templates` DISABLE KEYS */;

INSERT INTO `eb_shipping_templates` (`id`, `name`, `type`, `appoint`, `sort`, `create_time`, `update_time`)
VALUES
	(1,'包邮',1,0,0,'2020-12-07 17:28:39','2020-12-07 17:28:39'),
	(2,'全国包邮',1,0,0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(3,'1，10，1，5',1,0,0,'2020-12-23 10:05:45','2020-12-23 10:05:45');

/*!40000 ALTER TABLE `eb_shipping_templates` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_shipping_templates_free
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_shipping_templates_free`;

CREATE TABLE `eb_shipping_templates_free` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `temp_id` int(11) NOT NULL DEFAULT '0' COMMENT '模板ID',
  `city_id` int(11) NOT NULL DEFAULT '0' COMMENT '城市ID',
  `title` text COMMENT '描述',
  `number` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '包邮件数',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '包邮金额',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '计费方式',
  `uniqid` varchar(32) NOT NULL DEFAULT '' COMMENT '分组唯一值',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否无效',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='运费模板包邮';



# Dump of table eb_shipping_templates_region
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_shipping_templates_region`;

CREATE TABLE `eb_shipping_templates_region` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `temp_id` int(11) NOT NULL DEFAULT '0' COMMENT '模板ID',
  `city_id` int(11) NOT NULL DEFAULT '0' COMMENT '城市ID',
  `title` text COMMENT '描述',
  `first` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '首件',
  `first_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '首件运费',
  `renewal` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '续件',
  `renewal_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '续件运费',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '计费方式 1按件数 2按重量 3按体积',
  `uniqid` varchar(32) NOT NULL DEFAULT '' COMMENT '分组唯一值',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否无效',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='运费模板指定区域费用';

LOCK TABLES `eb_shipping_templates_region` WRITE;
/*!40000 ALTER TABLE `eb_shipping_templates_region` DISABLE KEYS */;

INSERT INTO `eb_shipping_templates_region` (`id`, `temp_id`, `city_id`, `title`, `first`, `first_price`, `renewal`, `renewal_price`, `type`, `uniqid`, `status`, `create_time`, `update_time`)
VALUES
	(739,2,2,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(740,2,7363,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(741,2,13268,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(742,2,18128,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(743,2,24371,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(744,2,26779,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(745,2,32688,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(746,2,38160,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(747,2,44570,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(748,2,49190,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(749,2,52018,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(750,2,58247,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(751,2,61804,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(752,2,66813,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(753,2,67748,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(754,2,69390,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(755,2,71850,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(756,2,72975,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(757,2,76726,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(758,2,79163,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(759,2,81000,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(760,2,84092,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(761,2,87613,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(762,2,92738,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(763,2,96064,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(764,2,99538,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(765,2,100904,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(766,2,101772,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(767,2,101884,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(768,2,104457,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(769,2,107065,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(770,2,108166,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(771,2,109847,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(772,2,110889,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(773,2,112552,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(774,2,113777,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(775,2,114940,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(776,2,115225,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(777,2,117932,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(778,2,119789,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(779,2,121081,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(780,2,122142,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(781,2,122730,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(782,2,123698,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(783,2,125249,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(784,2,126156,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(785,2,127070,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(786,2,127834,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(787,2,128421,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(788,2,129977,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(789,2,131738,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(790,2,133209,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(791,2,135392,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(792,2,137206,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(793,2,138721,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(794,2,139340,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(795,2,140601,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(796,2,141361,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(797,2,142786,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(798,2,143990,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(799,2,145666,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(800,2,149079,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(801,2,150915,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(802,2,151830,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(803,2,152413,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(804,2,153313,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(805,2,154201,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(806,2,155076,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(807,2,156713,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(808,2,157130,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(809,2,158623,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(810,2,159769,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(811,2,161651,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(812,2,161793,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(813,2,167905,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(814,2,169375,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(815,2,170724,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(816,2,173635,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(817,2,174764,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(818,2,176920,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(819,2,178999,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(820,2,180743,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(821,2,182538,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(822,2,185201,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(823,2,186657,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(824,2,187441,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(825,2,189402,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(826,2,191020,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(827,2,194395,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(828,2,197850,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(829,2,203852,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(830,2,205101,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(831,2,206438,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(832,2,209250,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(833,2,214260,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(834,2,215955,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(835,2,216449,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(836,2,221610,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(837,2,224650,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(838,2,226469,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(839,2,227482,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(840,2,228630,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(841,2,229844,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(842,2,230476,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(843,2,230981,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(844,2,231499,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(845,2,233236,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(846,2,234109,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(847,2,235483,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(848,2,237607,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(849,2,239084,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(850,2,241180,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(851,2,242634,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(852,2,243399,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(853,2,244378,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(854,2,247478,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(855,2,248059,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(856,2,249098,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(857,2,251197,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(858,2,253905,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(859,2,256112,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(860,2,258160,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(861,2,260230,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(862,2,262699,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(863,2,264862,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(864,2,265677,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(865,2,266521,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(866,2,269107,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(867,2,269654,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(868,2,270222,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(869,2,274444,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(870,2,277615,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(871,2,280562,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(872,2,282841,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(873,2,285861,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(874,2,291235,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(875,2,298025,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(876,2,301711,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(877,2,304309,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(878,2,306339,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(879,2,313063,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(880,2,320179,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(881,2,326706,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(882,2,330547,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(883,2,333140,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(884,2,336050,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(885,2,337144,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(886,2,344133,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(887,2,349382,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(888,2,355972,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(889,2,361375,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(890,2,367396,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(891,2,370304,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(892,2,372971,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(893,2,376365,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(894,2,379245,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(895,2,382878,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(896,2,383890,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(897,2,387707,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(898,2,389719,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(899,2,392737,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(900,2,395254,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(901,2,396611,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(902,2,398169,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(903,2,403311,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(904,2,408287,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(905,2,411925,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(906,2,417174,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(907,2,420258,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(908,2,420825,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(909,2,424449,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(910,2,425508,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(911,2,427710,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(912,2,429501,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(913,2,432415,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(914,2,432829,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(915,2,434548,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(916,2,437779,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(917,2,440639,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(918,2,445040,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(919,2,446212,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(920,2,447268,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(921,2,449865,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(922,2,452124,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(923,2,453799,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(924,2,455283,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(925,2,456303,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(926,2,459251,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(927,2,463141,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(928,2,465105,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(929,2,467562,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(930,2,468660,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(931,2,470123,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(932,2,472709,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(933,2,476148,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(934,2,479103,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(935,2,481319,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(936,2,483251,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(937,2,486129,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(938,2,487721,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(939,2,488589,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(940,2,488954,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(941,2,490106,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(942,2,490919,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(943,2,492341,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(944,2,494394,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(945,2,496438,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(946,2,498104,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(947,2,499489,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(948,2,501867,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(949,2,502828,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(950,2,504366,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(951,2,505298,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(952,2,506616,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(953,2,507255,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(954,2,507557,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(955,2,508648,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(956,2,510408,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(957,2,511463,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(958,2,513434,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(959,2,514790,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(960,2,516858,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(961,2,517933,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(962,2,518407,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(963,2,518808,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(964,2,519929,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(965,2,521166,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(966,2,522786,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(967,2,524814,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(968,2,525638,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(969,2,527443,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(970,2,528339,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(971,2,529345,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(972,2,529878,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(973,2,530060,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(974,2,530070,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(975,2,530468,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(976,2,533329,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(977,2,540700,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(978,2,545533,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(979,2,550275,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(980,2,551809,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(981,2,552358,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(982,2,554142,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(983,2,556077,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(984,2,560191,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(985,2,563242,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(986,2,565735,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(987,2,568202,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(988,2,570733,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(989,2,576992,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(990,2,578485,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(991,2,581870,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(992,2,585049,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(993,2,588538,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(994,2,589779,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(995,2,592598,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(996,2,594864,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(997,2,596525,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(998,2,599659,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(999,2,604132,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1000,2,605834,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1001,2,607029,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1002,2,609309,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1003,2,610607,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1004,2,614530,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1005,2,617670,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1006,2,619017,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1007,2,622734,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1008,2,624373,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1009,2,626181,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1010,2,627981,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1011,2,628776,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1012,2,629781,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1013,2,631276,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1014,2,631811,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1015,2,632971,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1016,2,634006,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1017,2,635219,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1018,2,636688,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1019,2,637778,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1020,2,638092,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1021,2,639368,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1022,2,639802,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1023,2,640107,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1024,2,640333,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1025,2,640675,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1026,2,642571,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1027,2,643863,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1028,2,644423,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1029,2,645076,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1030,2,646392,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1031,2,646579,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1032,2,649979,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1033,2,650575,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1034,2,652581,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1035,2,655295,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1036,2,657848,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1037,2,660643,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1038,2,663046,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1039,2,667681,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1040,2,669707,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1041,2,671120,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1042,2,672330,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1043,2,672385,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1044,2,672577,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1045,2,673463,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1046,2,676215,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1047,2,677568,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1048,2,678560,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1049,2,680191,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1050,2,680815,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1051,2,682322,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1052,2,684415,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1053,2,687916,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1054,2,689265,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1055,2,690095,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1056,2,691278,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1057,2,693040,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1058,2,693342,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1059,2,693672,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1060,2,694220,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1061,2,694478,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1062,2,694846,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1063,2,695260,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1064,2,695883,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1065,2,696252,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1066,2,696928,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1067,2,697887,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1068,2,698441,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1069,2,699583,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1070,2,699773,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1071,2,700070,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1072,2,700489,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1073,2,701559,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1074,2,702104,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1075,2,703119,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1076,2,704779,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1077,2,705145,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1078,2,708117,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1079,2,709792,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1080,2,711218,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1081,2,712893,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1082,2,713697,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1083,2,714402,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1084,2,717531,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1085,2,719868,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1086,2,720118,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1087,2,722024,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1088,2,725488,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1089,2,727730,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1090,2,729928,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1091,2,730843,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1092,2,734179,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1093,2,736051,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1094,2,737856,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1095,2,737861,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1096,2,739957,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1097,2,740510,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1098,2,742126,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1099,2,742636,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1100,2,743938,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1101,2,745674,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1102,2,748553,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1103,2,749571,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1104,2,749930,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1105,2,749957,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1106,2,752150,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1107,2,752169,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1108,3,2,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1109,3,7363,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1110,3,13268,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1111,3,18128,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1112,3,24371,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1113,3,26779,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1114,3,32688,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1115,3,38160,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1116,3,44570,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1117,3,49190,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1118,3,52018,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1119,3,58247,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1120,3,61804,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1121,3,66813,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1122,3,67748,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1123,3,69390,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1124,3,71850,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1125,3,72975,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1126,3,76726,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1127,3,79163,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1128,3,81000,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1129,3,84092,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1130,3,87613,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1131,3,92738,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1132,3,96064,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1133,3,99538,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1134,3,100904,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1135,3,101772,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1136,3,101884,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1137,3,104457,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1138,3,107065,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1139,3,108166,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1140,3,109847,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1141,3,110889,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1142,3,112552,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1143,3,113777,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1144,3,114940,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1145,3,115225,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1146,3,117932,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1147,3,119789,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1148,3,121081,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1149,3,122142,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1150,3,122730,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1151,3,123698,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1152,3,125249,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1153,3,126156,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1154,3,127070,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1155,3,127834,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1156,3,128421,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1157,3,129977,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1158,3,131738,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1159,3,133209,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1160,3,135392,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1161,3,137206,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1162,3,138721,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1163,3,139340,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1164,3,140601,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1165,3,141361,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1166,3,142786,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1167,3,143990,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1168,3,145666,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1169,3,149079,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1170,3,150915,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1171,3,151830,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1172,3,152413,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1173,3,153313,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1174,3,154201,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1175,3,155076,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1176,3,156713,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1177,3,157130,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1178,3,158623,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1179,3,159769,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1180,3,161651,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1181,3,161793,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1182,3,167905,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1183,3,169375,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1184,3,170724,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1185,3,173635,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1186,3,174764,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1187,3,176920,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1188,3,178999,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1189,3,180743,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1190,3,182538,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1191,3,185201,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1192,3,186657,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1193,3,187441,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1194,3,189402,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1195,3,191020,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1196,3,194395,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1197,3,197850,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1198,3,203852,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1199,3,205101,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1200,3,206438,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1201,3,209250,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1202,3,214260,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1203,3,215955,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1204,3,216449,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1205,3,221610,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1206,3,224650,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1207,3,226469,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1208,3,227482,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1209,3,228630,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1210,3,229844,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1211,3,230476,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1212,3,230981,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1213,3,231499,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1214,3,233236,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1215,3,234109,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1216,3,235483,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1217,3,237607,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1218,3,239084,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1219,3,241180,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1220,3,242634,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1221,3,243399,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1222,3,244378,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1223,3,247478,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1224,3,248059,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1225,3,249098,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1226,3,251197,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1227,3,253905,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1228,3,256112,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1229,3,258160,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1230,3,260230,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1231,3,262699,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1232,3,264862,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1233,3,265677,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1234,3,266521,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1235,3,269107,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1236,3,269654,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1237,3,270222,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1238,3,274444,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1239,3,277615,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1240,3,280562,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1241,3,282841,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1242,3,285861,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1243,3,291235,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1244,3,298025,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1245,3,301711,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1246,3,304309,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1247,3,306339,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1248,3,313063,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1249,3,320179,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1250,3,326706,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1251,3,330547,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1252,3,333140,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1253,3,336050,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1254,3,337144,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1255,3,344133,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1256,3,349382,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1257,3,355972,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1258,3,361375,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1259,3,367396,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1260,3,370304,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1261,3,372971,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1262,3,376365,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1263,3,379245,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1264,3,382878,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1265,3,383890,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1266,3,387707,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1267,3,389719,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1268,3,392737,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1269,3,395254,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1270,3,396611,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1271,3,398169,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1272,3,403311,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1273,3,408287,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1274,3,411925,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1275,3,417174,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1276,3,420258,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1277,3,420825,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1278,3,424449,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1279,3,425508,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1280,3,427710,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1281,3,429501,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1282,3,432415,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1283,3,432829,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1284,3,434548,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1285,3,437779,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1286,3,440639,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1287,3,445040,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1288,3,446212,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1289,3,447268,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1290,3,449865,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1291,3,452124,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1292,3,453799,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1293,3,455283,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1294,3,456303,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1295,3,459251,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1296,3,463141,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1297,3,465105,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1298,3,467562,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1299,3,468660,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1300,3,470123,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1301,3,472709,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1302,3,476148,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1303,3,479103,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1304,3,481319,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1305,3,483251,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1306,3,486129,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1307,3,487721,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1308,3,488589,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1309,3,488954,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1310,3,490106,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1311,3,490919,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1312,3,492341,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1313,3,494394,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1314,3,496438,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1315,3,498104,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1316,3,499489,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1317,3,501867,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1318,3,502828,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1319,3,504366,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1320,3,505298,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1321,3,506616,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1322,3,507255,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1323,3,507557,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1324,3,508648,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1325,3,510408,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1326,3,511463,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1327,3,513434,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1328,3,514790,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1329,3,516858,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1330,3,517933,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1331,3,518407,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1332,3,518808,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1333,3,519929,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1334,3,521166,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1335,3,522786,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1336,3,524814,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1337,3,525638,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1338,3,527443,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1339,3,528339,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1340,3,529345,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1341,3,529878,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1342,3,530060,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1343,3,530070,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1344,3,530468,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1345,3,533329,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1346,3,540700,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1347,3,545533,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1348,3,550275,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1349,3,551809,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1350,3,552358,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1351,3,554142,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1352,3,556077,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1353,3,560191,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1354,3,563242,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1355,3,565735,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1356,3,568202,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1357,3,570733,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1358,3,576992,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1359,3,578485,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1360,3,581870,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1361,3,585049,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1362,3,588538,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1363,3,589779,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1364,3,592598,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1365,3,594864,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1366,3,596525,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1367,3,599659,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1368,3,604132,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1369,3,605834,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1370,3,607029,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1371,3,609309,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1372,3,610607,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1373,3,614530,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1374,3,617670,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1375,3,619017,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1376,3,622734,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1377,3,624373,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1378,3,626181,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1379,3,627981,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1380,3,628776,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1381,3,629781,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1382,3,631276,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1383,3,631811,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1384,3,632971,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1385,3,634006,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1386,3,635219,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1387,3,636688,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1388,3,637778,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1389,3,638092,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1390,3,639368,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1391,3,639802,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1392,3,640107,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1393,3,640333,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1394,3,640675,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1395,3,642571,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1396,3,643863,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1397,3,644423,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1398,3,645076,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1399,3,646392,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1400,3,646579,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1401,3,649979,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1402,3,650575,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1403,3,652581,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1404,3,655295,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1405,3,657848,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1406,3,660643,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1407,3,663046,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1408,3,667681,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1409,3,669707,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1410,3,671120,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1411,3,672330,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1412,3,672385,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1413,3,672577,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1414,3,673463,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1415,3,676215,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1416,3,677568,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1417,3,678560,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1418,3,680191,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1419,3,680815,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1420,3,682322,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1421,3,684415,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1422,3,687916,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1423,3,689265,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1424,3,690095,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1425,3,691278,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1426,3,693040,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1427,3,693342,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1428,3,693672,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1429,3,694220,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1430,3,694478,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1431,3,694846,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1432,3,695260,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1433,3,695883,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1434,3,696252,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1435,3,696928,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1436,3,697887,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1437,3,698441,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1438,3,699583,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1439,3,699773,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1440,3,700070,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1441,3,700489,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1442,3,701559,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1443,3,702104,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1444,3,703119,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1445,3,704779,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1446,3,705145,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1447,3,708117,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1448,3,709792,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1449,3,711218,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1450,3,712893,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1451,3,713697,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1452,3,714402,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1453,3,717531,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1454,3,719868,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1455,3,720118,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1456,3,722024,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1457,3,725488,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1458,3,727730,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1459,3,729928,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1460,3,730843,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1461,3,734179,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1462,3,736051,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1463,3,737856,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1464,3,737861,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1465,3,739957,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1466,3,740510,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1467,3,742126,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1468,3,742636,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1469,3,743938,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1470,3,745674,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1471,3,748553,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1472,3,749571,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1473,3,749930,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1474,3,749957,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1475,3,752150,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1476,3,752169,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1477,1,2,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1478,1,7363,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1479,1,13268,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1480,1,18128,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1481,1,24371,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1482,1,26779,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1483,1,32688,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1484,1,38160,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1485,1,44570,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1486,1,49190,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1487,1,52018,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1488,1,58247,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1489,1,61804,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1490,1,66813,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1491,1,67748,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1492,1,69390,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1493,1,71850,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1494,1,72975,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1495,1,76726,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1496,1,79163,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1497,1,81000,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1498,1,84092,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1499,1,87613,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1500,1,92738,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1501,1,96064,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1502,1,99538,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1503,1,100904,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1504,1,101772,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1505,1,101884,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1506,1,104457,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1507,1,107065,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1508,1,108166,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1509,1,109847,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1510,1,110889,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1511,1,112552,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1512,1,113777,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1513,1,114940,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1514,1,115225,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1515,1,117932,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1516,1,119789,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1517,1,121081,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1518,1,122142,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1519,1,122730,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1520,1,123698,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1521,1,125249,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1522,1,126156,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1523,1,127070,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1524,1,127834,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1525,1,128421,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1526,1,129977,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:03','2021-01-07 16:01:29'),
	(1527,1,131738,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1528,1,133209,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1529,1,135392,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1530,1,137206,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1531,1,138721,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1532,1,139340,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1533,1,140601,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1534,1,141361,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1535,1,142786,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1536,1,143990,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1537,1,145666,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1538,1,149079,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1539,1,150915,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1540,1,151830,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1541,1,152413,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1542,1,153313,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1543,1,154201,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1544,1,155076,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1545,1,156713,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1546,1,157130,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1547,1,158623,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1548,1,159769,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1549,1,161651,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1550,1,161793,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1551,1,167905,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1552,1,169375,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1553,1,170724,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1554,1,173635,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1555,1,174764,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1556,1,176920,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1557,1,178999,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1558,1,180743,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1559,1,182538,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1560,1,185201,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1561,1,186657,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1562,1,187441,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1563,1,189402,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1564,1,191020,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1565,1,194395,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1566,1,197850,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1567,1,203852,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1568,1,205101,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1569,1,206438,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1570,1,209250,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1571,1,214260,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1572,1,215955,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1573,1,216449,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1574,1,221610,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1575,1,224650,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1576,1,226469,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1577,1,227482,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1578,1,228630,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1579,1,229844,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1580,1,230476,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1581,1,230981,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1582,1,231499,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1583,1,233236,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1584,1,234109,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1585,1,235483,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1586,1,237607,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1587,1,239084,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1588,1,241180,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1589,1,242634,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1590,1,243399,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1591,1,244378,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1592,1,247478,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1593,1,248059,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1594,1,249098,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1595,1,251197,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1596,1,253905,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1597,1,256112,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1598,1,258160,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1599,1,260230,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1600,1,262699,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1601,1,264862,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1602,1,265677,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1603,1,266521,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1604,1,269107,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1605,1,269654,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1606,1,270222,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1607,1,274444,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1608,1,277615,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1609,1,280562,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1610,1,282841,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1611,1,285861,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1612,1,291235,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1613,1,298025,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1614,1,301711,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1615,1,304309,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1616,1,306339,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1617,1,313063,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1618,1,320179,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1619,1,326706,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1620,1,330547,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1621,1,333140,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1622,1,336050,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1623,1,337144,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1624,1,344133,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1625,1,349382,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1626,1,355972,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1627,1,361375,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1628,1,367396,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1629,1,370304,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1630,1,372971,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1631,1,376365,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1632,1,379245,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1633,1,382878,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1634,1,383890,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1635,1,387707,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1636,1,389719,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1637,1,392737,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1638,1,395254,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1639,1,396611,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1640,1,398169,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1641,1,403311,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1642,1,408287,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1643,1,411925,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1644,1,417174,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1645,1,420258,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1646,1,420825,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1647,1,424449,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1648,1,425508,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1649,1,427710,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1650,1,429501,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1651,1,432415,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1652,1,432829,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1653,1,434548,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1654,1,437779,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1655,1,440639,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1656,1,445040,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1657,1,446212,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1658,1,447268,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1659,1,449865,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1660,1,452124,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1661,1,453799,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1662,1,455283,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1663,1,456303,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1664,1,459251,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1665,1,463141,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1666,1,465105,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1667,1,467562,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1668,1,468660,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1669,1,470123,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1670,1,472709,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1671,1,476148,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1672,1,479103,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1673,1,481319,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1674,1,483251,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1675,1,486129,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1676,1,487721,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1677,1,488589,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1678,1,488954,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1679,1,490106,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1680,1,490919,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1681,1,492341,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1682,1,494394,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1683,1,496438,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1684,1,498104,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1685,1,499489,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1686,1,501867,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1687,1,502828,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1688,1,504366,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1689,1,505298,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1690,1,506616,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1691,1,507255,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1692,1,507557,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1693,1,508648,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1694,1,510408,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1695,1,511463,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1696,1,513434,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1697,1,514790,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1698,1,516858,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1699,1,517933,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1700,1,518407,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1701,1,518808,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1702,1,519929,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1703,1,521166,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1704,1,522786,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1705,1,524814,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1706,1,525638,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1707,1,527443,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1708,1,528339,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1709,1,529345,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1710,1,529878,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1711,1,530060,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1712,1,530070,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1713,1,530468,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1714,1,533329,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1715,1,540700,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1716,1,545533,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1717,1,550275,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1718,1,551809,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1719,1,552358,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1720,1,554142,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1721,1,556077,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1722,1,560191,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1723,1,563242,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1724,1,565735,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1725,1,568202,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1726,1,570733,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1727,1,576992,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1728,1,578485,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1729,1,581870,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1730,1,585049,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1731,1,588538,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1732,1,589779,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1733,1,592598,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1734,1,594864,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1735,1,596525,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1736,1,599659,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1737,1,604132,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1738,1,605834,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1739,1,607029,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1740,1,609309,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1741,1,610607,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1742,1,614530,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1743,1,617670,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1744,1,619017,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1745,1,622734,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1746,1,624373,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1747,1,626181,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1748,1,627981,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1749,1,628776,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1750,1,629781,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1751,1,631276,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1752,1,631811,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1753,1,632971,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1754,1,634006,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1755,1,635219,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1756,1,636688,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1757,1,637778,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1758,1,638092,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1759,1,639368,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1760,1,639802,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1761,1,640107,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1762,1,640333,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1763,1,640675,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1764,1,642571,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1765,1,643863,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1766,1,644423,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1767,1,645076,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1768,1,646392,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1769,1,646579,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1770,1,649979,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1771,1,650575,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1772,1,652581,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:04','2021-01-07 16:01:29'),
	(1773,1,655295,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1774,1,657848,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1775,1,660643,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1776,1,663046,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1777,1,667681,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1778,1,669707,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1779,1,671120,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1780,1,672330,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1781,1,672385,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1782,1,672577,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1783,1,673463,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1784,1,676215,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1785,1,677568,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1786,1,678560,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1787,1,680191,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1788,1,680815,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1789,1,682322,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1790,1,684415,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1791,1,687916,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1792,1,689265,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1793,1,690095,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1794,1,691278,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1795,1,693040,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1796,1,693342,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1797,1,693672,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1798,1,694220,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1799,1,694478,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1800,1,694846,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1801,1,695260,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1802,1,695883,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1803,1,696252,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1804,1,696928,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1805,1,697887,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1806,1,698441,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1807,1,699583,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1808,1,699773,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1809,1,700070,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1810,1,700489,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1811,1,701559,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1812,1,702104,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1813,1,703119,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1814,1,704779,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1815,1,705145,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1816,1,708117,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1817,1,709792,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1818,1,711218,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1819,1,712893,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1820,1,713697,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1821,1,714402,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1822,1,717531,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1823,1,719868,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1824,1,720118,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1825,1,722024,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1826,1,725488,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1827,1,727730,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1828,1,729928,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1829,1,730843,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1830,1,734179,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1831,1,736051,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1832,1,737856,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1833,1,737861,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1834,1,739957,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1835,1,740510,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1836,1,742126,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1837,1,742636,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1838,1,743938,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1839,1,745674,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1840,1,748553,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1841,1,749571,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1842,1,749930,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1843,1,749957,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1844,1,752150,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1845,1,752169,'[[0,0]]',1.00,0.00,1.00,1.00,1,'6275f260778f23332ed93e994125b80f',1,'2021-01-07 16:01:05','2021-01-07 16:01:29'),
	(1846,1,67748,'[[67747,67748]]',1.00,1.00,1.00,1.00,1,'553aa27a779ff544d045d997e7095d75',1,'2021-01-07 16:01:05','2021-01-07 16:01:29');

/*!40000 ALTER TABLE `eb_shipping_templates_region` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_sms_record
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_sms_record`;

CREATE TABLE `eb_sms_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '短信发送记录编号',
  `uid` varchar(255) NOT NULL COMMENT '短信平台账号',
  `phone` char(11) NOT NULL COMMENT '接受短信的手机号',
  `content` text COMMENT '短信内容',
  `add_ip` varchar(30) DEFAULT NULL COMMENT '添加记录ip',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `template` varchar(255) DEFAULT '' COMMENT '短信模板ID',
  `resultcode` int(6) unsigned DEFAULT NULL COMMENT '状态码 100=成功,130=失败,131=空号,132=停机,133=关机,134=无状态',
  `record_id` int(11) unsigned DEFAULT NULL COMMENT '发送记录id',
  `memo` text COMMENT '短信平台返回信息',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='短信发送记录表';

LOCK TABLES `eb_sms_record` WRITE;
/*!40000 ALTER TABLE `eb_sms_record` DISABLE KEYS */;

INSERT INTO `eb_sms_record` (`id`, `uid`, `phone`, `content`, `add_ip`, `create_time`, `template`, `resultcode`, `record_id`, `memo`)
VALUES
	(1,'tangkai','13148369181','','','2020-08-28 11:40:47','518076',400,0,'黑名单:号码一天重复提交过多'),
	(2,'tangkai','13148369181',NULL,'','2020-08-28 12:00:26','518076',400,0,'黑名单:号码一天重复提交过多'),
	(3,'tangkai','18838971183',NULL,'','2020-08-28 12:00:26','518076',400,0,'黑名单:号码一天重复提交过多'),
	(4,'tangkai','18838971183',NULL,'','2020-08-28 12:00:27','518076',400,0,'黑名单:号码一天重复提交过多'),
	(5,'tangkai','15827579751',NULL,'','2020-08-28 12:00:27','518076',400,0,'黑名单:号码一天重复提交过多'),
	(6,'tangkai','18292417675','【CRMEB】您的验证码是：974706，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 14:09:19','518076',200,1768913,'发送成功'),
	(7,'tangkai','18292417675','【CRMEB】您的验证码是：867348，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 14:11:53','518076',200,1768924,'发送成功'),
	(8,'tangkai','18292417675','【CRMEB】您的验证码是：563940，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 14:31:04','518076',200,1768981,'发送成功'),
	(9,'tangkai','18292417675','【CRMEB】您的验证码是：644422，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 14:41:02','518076',200,1769031,'发送成功'),
	(10,'tangkai','18292417675','【CRMEB】您的验证码是：405277，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 15:12:13','518076',200,1769149,'发送成功'),
	(11,'tangkai','18991352728','【CRMEB】您的验证码是：767022，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 15:12:14','518076',200,1769150,'发送成功'),
	(12,'tangkai','18991352728','【CRMEB】您的验证码是：976966，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 15:26:19','518076',NULL,1769177,'发送成功'),
	(13,'tangkai','18292417675','【CRMEB】您的验证码是：695966，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 15:26:22','518076',NULL,1769179,'发送成功'),
	(14,'tangkai','18292417675','【CRMEB】您的验证码是：313185，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 15:32:33','518076',100,1769200,'发送成功'),
	(15,'tangkai','18160744473','【CRMEB】您的验证码是：485703，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-31 17:30:35','518076',200,9059,'ok'),
	(16,'tangkai','13663765325','【CRMEB】您的验证码是：828620，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-31 18:18:04','518076',200,9251,'ok'),
	(17,'tangkai','18559645067','【CRMEB】您的验证码是：251699，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-01 14:05:41','518076',200,11161,'ok'),
	(18,'tangkai','13008426948','【CRMEB】您的验证码是：543720，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-01 15:02:20','518076',200,11339,'ok'),
	(19,'tangkai','13017670582','【CRMEB】您的验证码是：877091，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-02 11:53:15','518076',200,14747,'ok'),
	(20,'tangkai','18045121009','【CRMEB】您的验证码是：754399，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-02 14:04:36','518076',200,15732,'ok'),
	(21,'tangkai','17769822165','【CRMEB】您的验证码是：996088，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-02 14:05:26','518076',200,15734,'ok'),
	(22,'tangkai','19901751521','【CRMEB】您的验证码是：271329，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 09:49:01','518076',200,18045,'ok'),
	(23,'tangkai','18991352728','【CRMEB】您的验证码是：204923，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 10:48:16','518076',200,18294,'ok'),
	(24,'tangkai','15605995727','【CRMEB】您的验证码是：792269，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 14:11:27','518076',200,18873,'ok'),
	(25,'tangkai','15163893976','【CRMEB】您的验证码是：210830，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 14:27:43','518076',200,18944,'ok'),
	(26,'tangkai','13265534579','【CRMEB】您的验证码是：663266，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 22:47:12','518076',200,20580,'ok'),
	(27,'tangkai','13265534579','【CRMEB】您的验证码是：651410，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 22:48:07','518076',200,20581,'ok'),
	(28,'tangkai','13265534579','【CRMEB】您的验证码是：803344，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 22:55:12','518076',200,20590,'ok'),
	(29,'tangkai','15558117521','【CRMEB】您的验证码是：569520，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-04 14:34:52','518076',200,22094,'ok'),
	(30,'tangkai','18256504106','【CRMEB】您的验证码是：891492，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-04 14:49:17','518076',200,22139,'ok'),
	(31,'tangkai','13113133932','【CRMEB】您的验证码是：344928，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-06 20:50:13','518076',200,30019,'ok'),
	(32,'tangkai','18381419318','【CRMEB】您的验证码是：191368，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-07 00:23:05','518076',200,30553,'ok'),
	(33,'tangkai','18566660230','【CRMEB】您的验证码是：647855，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-08 00:16:12','518076',200,34876,'ok'),
	(34,'tangkai','15941724722','【CRMEB】您的验证码是：502252，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-08 10:03:12','518076',200,35358,'ok'),
	(35,'tangkai','13309212766','【CRMEB】您的验证码是：125909，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-10 14:27:03','518076',200,46106,'ok'),
	(36,'tangkai','13309212766','【CRMEB】您的验证码是：127087，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-10 14:33:53','518076',200,46137,'ok'),
	(37,'tangkai','13720673941','【CRMEB】您的验证码是：787704，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 11:04:17','518076',200,49847,'ok'),
	(38,'tangkai','13720673941','【CRMEB】您的验证码是：883233，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 11:06:07','518076',200,49857,'ok'),
	(39,'tangkai','13720673941','【CRMEB】您的验证码是：274437，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 11:09:12','518076',200,49877,'ok'),
	(40,'tangkai','13309212766','【CRMEB】您的验证码是：187118，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 11:34:28','518076',200,49987,'ok'),
	(41,'tangkai','13309212766','【CRMEB】您的验证码是：722920，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 11:53:30','518076',200,50075,'ok'),
	(42,'tangkai','13309212766','【CRMEB】您的验证码是：833605，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 14:02:16','518076',200,50597,'ok'),
	(43,'tangkai','13309212766','【CRMEB】您的验证码是：870649，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 14:50:23','518076',200,50831,'ok'),
	(44,'tangkai','13309212766','【CRMEB】您的验证码是：660619，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 16:10:54','518076',200,51282,'ok'),
	(45,'tangkai','13309212766','【CRMEB】您的验证码是：961942，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 18:08:48','518076',200,51953,'ok'),
	(46,'tangkai','13720673941','【CRMEB】您的验证码是：693282，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 18:56:53','518076',200,52309,'ok'),
	(47,'tangkai','13720673941','【CRMEB】您的验证码是：636458，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 18:59:03','518076',200,52327,'ok'),
	(48,'tangkai','13720673941','【CRMEB】您的验证码是：504494，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 19:17:24','518076',200,52527,'ok'),
	(49,'tangkai','13720673941','【CRMEB】您的验证码是：672439，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 09:04:10','518076',200,59694,'ok'),
	(50,'tangkai','13720673941','【CRMEB】您的验证码是：457069，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 09:18:44','518076',200,59833,'ok'),
	(51,'tangkai','13309212766','【CRMEB】您的验证码是：646213，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 09:39:35','518076',200,59999,'ok'),
	(52,'tangkai','13309212766','【CRMEB】您的验证码是：373480，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 09:52:00','518076',200,60093,'ok'),
	(53,'tangkai','13309212766','【CRMEB】您的验证码是：510064，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 09:58:35','518076',200,60147,'ok'),
	(54,'tangkai','13309212766','【CRMEB】您的验证码是：677318，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 10:54:50','518076',200,60482,'ok'),
	(55,'tangkai','13720673941','【CRMEB】您的验证码是：218498，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 11:28:30','518076',200,60701,'ok'),
	(56,'tangkai','13309212766','【CRMEB】您的验证码是：242621，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 18:18:26','518076',200,62641,'ok'),
	(57,'tangkai','13720673941','【CRMEB】您的验证码是：995280，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 09:56:31','518076',200,67436,'ok'),
	(58,'tangkai','13720673941','【CRMEB】您的验证码是：720034，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 10:00:01','518076',200,67456,'ok'),
	(59,'tangkai','13309212766','【CRMEB】您的验证码是：666148，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 11:59:05','518076',200,68029,'ok'),
	(60,'tangkai','18292417675','【CRMEB】您的验证码是：194129，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 14:18:18','518076',200,68544,'ok'),
	(61,'tangkai','18292417675','【CRMEB】您的验证码是：764261，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 14:19:21','518076',200,68547,'ok'),
	(62,'tangkai','18292417675','【CRMEB】您的验证码是：688509，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 14:21:45','518076',200,68557,'ok'),
	(63,'tangkai','18292417675','【CRMEB】您的验证码是：194292，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 14:57:44','518076',200,68690,'ok'),
	(64,'tangkai','18292417675','【CRMEB】您的验证码是：246846，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:13:40','518076',200,69232,'ok'),
	(65,'tangkai','18292417675','【CRMEB】您的验证码是：551812，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:14:25','518076',200,69236,'ok'),
	(66,'tangkai','18292417675','【CRMEB】您的验证码是：406573，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:15:20','518076',200,69242,'ok'),
	(67,'tangkai','18292417675','【CRMEB】您的验证码是：413763，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:16:26','518076',200,69254,'ok'),
	(68,'tangkai','18292417675','【CRMEB】您的验证码是：737340，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:18:31','518076',200,69268,'ok'),
	(69,'tangkai','18292417675','【CRMEB】您的验证码是：644387，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:18:50','518076',200,69272,'ok'),
	(70,'tangkai','18292417675','【CRMEB】您的验证码是：183682，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:20:56','518076',200,69282,'ok'),
	(71,'tangkai','13720673941','【CRMEB】您的验证码是：189800，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:00:16','518076',200,69663,'ok'),
	(72,'tangkai','13700000002','【CRMEB】您的验证码是：644556，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:10:19','518076',200,69711,'ok'),
	(73,'tangkai','13700000003','【CRMEB】您的验证码是：814686，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:13:14','518076',200,69720,'ok'),
	(74,'tangkai','13720673941','【CRMEB】您的验证码是：946396，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:17:15','518076',200,69732,'ok'),
	(75,'tangkai','13720673941','【CRMEB】您的验证码是：972160，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:19:19','518076',200,69737,'ok'),
	(76,'tangkai','13700000001','【CRMEB】您的验证码是：248321，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:51:56','518076',200,69862,'ok'),
	(77,'tangkai','13309212766','【CRMEB】您的验证码是：519939，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 09:48:50','518076',200,70961,'ok'),
	(78,'tangkai','13309212766','【CRMEB】您的验证码是：338536，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 09:49:58','518076',200,70966,'ok'),
	(79,'tangkai','13700000001','【CRMEB】您的验证码是：139655，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 10:00:27','518076',200,71004,'ok'),
	(80,'tangkai','13720673941','【CRMEB】您的验证码是：267684，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 10:34:52','518076',200,71162,'ok'),
	(81,'tangkai','13700000002','【CRMEB】您的验证码是：809276，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 10:41:17','518076',200,71210,'ok'),
	(82,'tangkai','15661508370','【CRMEB】您的验证码是：384523，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 14:37:18','518076',200,72296,'ok'),
	(83,'tangkai','13184560789','【CRMEB】您的验证码是：837699，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:46:46','518076',200,72695,'ok'),
	(84,'tangkai','13184560789','【CRMEB】您的验证码是：184963，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:46:50','518076',200,72696,'ok'),
	(85,'tangkai','13184560789','【CRMEB】您的验证码是：506478，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:47:30','518076',200,72706,'ok'),
	(86,'tangkai','13184560789','【CRMEB】您的验证码是：736146，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:00','518076',200,72716,'ok'),
	(87,'tangkai','13184560789','【CRMEB】您的验证码是：785172，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72717,'ok'),
	(88,'tangkai','13184560789','【CRMEB】您的验证码是：867450，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72718,'ok'),
	(89,'tangkai','13184560789','【CRMEB】您的验证码是：854281，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72719,'ok'),
	(90,'tangkai','13184560789','【CRMEB】您的验证码是：144427，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72720,'ok'),
	(91,'tangkai','13184560789','【CRMEB】您的验证码是：734511，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72721,'ok'),
	(92,'tangkai','13184560789','【CRMEB】您的验证码是：165676，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72722,'ok'),
	(93,'tangkai','13184560789','【CRMEB】您的验证码是：392193，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72723,'ok'),
	(94,'tangkai','13184560789','【CRMEB】您的验证码是：857505，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72724,'ok'),
	(95,'tangkai','13184560789','【CRMEB】您的验证码是：622349，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72725,'ok'),
	(96,'tangkai','13184560789','【CRMEB】您的验证码是：347833，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72726,'ok'),
	(97,'tangkai','13184560789','【CRMEB】您的验证码是：895722，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72727,'ok'),
	(98,'tangkai','13184560789','【CRMEB】您的验证码是：323586，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72729,'ok'),
	(99,'tangkai','13184560789','【CRMEB】您的验证码是：943357，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:03','518076',200,72731,'ok'),
	(100,'tangkai','13184560789','【CRMEB】您的验证码是：884220，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:06','518076',200,72741,'ok'),
	(101,'tangkai','13184560789','【CRMEB】您的验证码是：649157，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:06','518076',200,72742,'ok'),
	(102,'tangkai','13184560789','【CRMEB】您的验证码是：734925，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:06','518076',200,72743,'ok'),
	(103,'tangkai','13184560789','【CRMEB】您的验证码是：284661，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:07','518076',200,72744,'ok'),
	(104,'tangkai','13184560789','【CRMEB】您的验证码是：904448，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:07','518076',200,72745,'ok'),
	(105,'tangkai','13184560789','【CRMEB】您的验证码是：182636，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:08','518076',200,72746,'ok'),
	(106,'tangkai','13184560789','【CRMEB】您的验证码是：396399，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:08','518076',200,72748,'ok'),
	(107,'tangkai','13184560789','【CRMEB】您的验证码是：198321，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:08','518076',200,72750,'ok'),
	(108,'tangkai','13087851131','【CRMEB】您的验证码是：333445，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:51:55','518076',200,72771,'ok'),
	(109,'tangkai','13087851131','【CRMEB】您的验证码是：650353，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:00','518076',200,72774,'ok'),
	(110,'tangkai','13087851131','【CRMEB】您的验证码是：245741，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:01','518076',200,72775,'ok'),
	(111,'tangkai','13087851131','【CRMEB】您的验证码是：479831，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:01','518076',200,72776,'ok'),
	(112,'tangkai','13087851131','【CRMEB】您的验证码是：829694，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:01','518076',200,72777,'ok'),
	(113,'tangkai','13087851131','【CRMEB】您的验证码是：783356，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:01','518076',200,72779,'ok'),
	(114,'tangkai','13087851131','【CRMEB】您的验证码是：595729，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:10','518076',200,72780,'ok'),
	(115,'tangkai','13087851131','【CRMEB】您的验证码是：546176，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:11','518076',200,72781,'ok'),
	(116,'tangkai','18991352728','【CRMEB】您的验证码是：820810，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:55:30','518076',200,72793,'ok'),
	(117,'tangkai','18991352728','【CRMEB】您的验证码是：836750，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:55:35','518076',200,72794,'ok'),
	(118,'tangkai','13184560789','【CRMEB】您的验证码是：545282，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:56:05','518076',200,72801,'ok'),
	(119,'tangkai','13184560789','【CRMEB】您的验证码是：157750，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:58:45','518076',200,72816,'ok'),
	(120,'tangkai','18991352728','【CRMEB】您的验证码是：367321，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 17:36:24','518076',200,73324,'ok'),
	(121,'tangkai','13720673941','【CRMEB】您的验证码是：136380，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 19:31:23','518076',200,73760,'ok'),
	(122,'tangkai','17623551311','【CRMEB】您的验证码是：679222，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-16 16:49:00','518076',200,76305,'ok'),
	(123,'tangkai','18991352728','【CRMEB】您的验证码是：309254，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-17 16:16:42','518076',200,79694,'ok'),
	(124,'tangkai','17633657563','【CRMEB】您的验证码是：231381，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-17 21:58:58','518076',200,81311,'ok'),
	(125,'tangkai','19974870606','【CRMEB】您的验证码是：382149，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-17 22:49:03','518076',200,81488,'ok'),
	(126,'tangkai','18991352728','【CRMEB】您的验证码是：406151，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-18 10:13:36','518076',200,82368,'ok'),
	(127,'tangkai','19937853103','【CRMEB】您的验证码是：946916，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-18 10:45:56','518076',200,82491,'ok'),
	(128,'tangkai','19937853103','【CRMEB】您的验证码是：142074，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-18 10:52:01','518076',200,82511,'ok'),
	(129,'tangkai','15975200658','【CRMEB】您的验证码是：858246，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-18 15:00:06','518076',200,83486,'ok'),
	(130,'tangkai','13184560789','【CRMEB】您的验证码是：565910，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-19 09:56:59','518076',200,85441,'ok'),
	(131,'tangkai','13194080052','【CRMEB】您的验证码是：311202，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-19 14:51:25','518076',200,86363,'ok'),
	(132,'tangkai','18925242347','【CRMEB】您的验证码是：334195，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-19 14:55:29','518076',200,86381,'ok'),
	(133,'tangkai','13459485879','【CRMEB】您的验证码是：289388，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-20 17:12:47','518076',200,89723,'ok'),
	(134,'tangkai','15578973389','【CRMEB】您的验证码是：502314，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-22 10:19:05','518076',200,95375,'ok'),
	(135,'tangkai','13513775156','【CRMEB】您的验证码是：724604，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-22 13:59:03','518076',200,96159,'ok'),
	(136,'tangkai','15975200658','【CRMEB】您的验证码是：720963，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-22 16:10:49','518076',200,96761,'ok'),
	(137,'tangkai','15878781234','【CRMEB】您的验证码是：839679，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-23 14:17:12','518076',200,100388,'ok'),
	(138,'tangkai','15518727891','【CRMEB】您的验证码是：423166，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-23 22:30:27','518076',200,102419,'ok'),
	(139,'tangkai','17358507603','【CRMEB】您的验证码是：355482，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-24 21:02:26','518076',200,106306,'ok'),
	(140,'tangkai','18861202652','【CRMEB】您的验证码是：393783，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-25 14:28:14','518076',200,108925,'ok'),
	(141,'tangkai','18661202652','【CRMEB】您的验证码是：776710，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-25 14:29:24','518076',200,108932,'ok'),
	(142,'tangkai','18328706641','【CRMEB】您的验证码是：585595，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-27 13:53:37','518076',200,117884,'ok'),
	(143,'tangkai','18328706641','【CRMEB】您的验证码是：336259，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-28 19:05:05','518076',200,124269,'ok'),
	(144,'tangkai','17606199566','【CRMEB】您的验证码是：799832，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 16:32:15','518076',200,127792,'ok'),
	(145,'tangkai','17606199566','【CRMEB】您的验证码是：770239，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 16:32:49','518076',200,127795,'ok'),
	(146,'tangkai','18658666691','【CRMEB】您的验证码是：996867，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 16:52:59','518076',200,127914,'ok'),
	(147,'tangkai','17607183962','【CRMEB】您的验证码是：129111，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 17:25:00','518076',200,128065,'ok'),
	(148,'tangkai','17050291004','【CRMEB】您的验证码是：924474，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 20:15:00','518076',200,128732,'ok'),
	(149,'tangkai','18292417675','【CRMEB】您的验证码是：415971，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 22:09:55','518076',200,129116,'ok'),
	(150,'tangkai','13717017105','【CRMEB】您的验证码是：545871，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-05 17:19:02','518076',200,142430,'ok'),
	(151,'tangkai','13718017105','【CRMEB】您的验证码是：406395，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-05 17:20:12','518076',200,142434,'ok'),
	(152,'tangkai','13718017105','【CRMEB】您的验证码是：562266，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-05 17:20:12','518076',200,142435,'ok'),
	(153,'tangkai','13718017105','【CRMEB】您的验证码是：276381，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-05 17:21:27','518076',200,142438,'ok'),
	(154,'tangkai','13533512317','【CRMEB】您的验证码是：375746，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-08 14:20:18','518076',200,149398,'ok'),
	(155,'tangkai','18934190345','【CRMEB】您的验证码是：357405，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 11:36:36','518076',200,152058,'ok'),
	(156,'tangkai','18615596654','【CRMEB】您的验证码是：236285，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 12:01:31','518076',200,152132,'ok'),
	(157,'tangkai','15975200658','【CRMEB】您的验证码是：649973，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 14:22:47','518076',200,152498,'ok'),
	(158,'tangkai','18069787937','【CRMEB】您的验证码是：197704，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 15:42:12','518076',200,152772,'ok'),
	(159,'tangkai','17702155558','【CRMEB】您的验证码是：748843，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 16:27:02','518076',200,152947,'ok'),
	(160,'tangkai','18144113993','【CRMEB】您的验证码是：820684，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 20:22:03','518076',200,153885,'ok'),
	(161,'tangkai','13184560789','【CRMEB】您的验证码是：737208，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 09:49:10','518076',200,154890,'ok'),
	(162,'tangkai','13184560789','【CRMEB】您的验证码是：649777，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 09:57:48','518076',200,154939,'ok'),
	(163,'tangkai','18515588835','【CRMEB】您的验证码是：396877，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 10:57:38','518076',200,155207,'ok'),
	(164,'tangkai','15538081797','【CRMEB】您的验证码是：946852，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 15:21:20','518076',200,156397,'ok'),
	(165,'tangkai','15538081797','【CRMEB】您的验证码是：580059，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 15:22:11','518076',200,156400,'ok'),
	(166,'tangkai','15538081797','【CRMEB】您的验证码是：250597，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 15:29:35','518076',200,156437,'ok'),
	(167,'tangkai','13163680032','【CRMEB】您的验证码是：711996，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-13 11:01:43','518076',200,168135,'ok'),
	(168,'tangkai','13720673941','【CRMEB】您的验证码是：386227，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-14 10:34:09','518076',200,172254,'ok'),
	(169,'tangkai','13720673941','【CRMEB】您的验证码是：919727，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-14 10:36:39','518076',200,172266,'ok'),
	(170,'tangkai','18784236930','【CRMEB】您的验证码是：487451，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-14 10:59:24','518076',200,172377,'ok'),
	(171,'tangkai','18621661161','【CRMEB】您的验证码是：488105，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-15 19:19:57','518076',200,178648,'ok'),
	(172,'tangkai','18927201280','【CRMEB】您的验证码是：407669，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-16 09:18:14','518076',200,179738,'ok'),
	(173,'tangkai','18621263027','【CRMEB】您的验证码是：769326，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-16 21:55:14','518076',200,185582,'ok'),
	(174,'tangkai','18621263027','【CRMEB】您的验证码是：671890，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-16 21:56:14','518076',200,185586,'ok'),
	(175,'tangkai','18292417675','【CRMEB】您的验证码是：855073，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-17 10:51:05','518076',200,186481,'ok'),
	(176,'tangkai','18292417675','【CRMEB】您的验证码是：403393，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-17 10:51:45','518076',200,186484,'ok'),
	(177,'tangkai','18292417675','【CRMEB】您的验证码是：869839，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-17 10:53:48','518076',200,186494,'ok'),
	(178,'tangkai','13378451282','【CRMEB】您的验证码是：803422，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-17 21:25:52','518076',200,188893,'ok'),
	(179,'tangkai','17797628196','【CRMEB】您的验证码是：353905，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-19 14:35:20','518076',200,194418,'ok'),
	(180,'tangkai','17797628196','【CRMEB】您的验证码是：431240，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-19 14:36:45','518076',200,194426,'ok'),
	(181,'tangkai','13849059616','【CRMEB】您的验证码是：867294，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-19 14:41:22','518076',200,194450,'ok'),
	(182,'tangkai','13849059616','【CRMEB】您的验证码是：376196，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-19 14:42:45','518076',200,194453,'ok'),
	(183,'tangkai','18980337507','【CRMEB】您的验证码是：701353，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-19 17:19:41','518076',200,195346,'ok'),
	(184,'tangkai','18547265999','【CRMEB】您的验证码是：959314，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-20 10:31:43','518076',200,198344,'ok'),
	(185,'tangkai','13720673941','【CRMEB】您的验证码是：171770，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-20 14:51:14','518076',200,199791,'ok'),
	(186,'tangkai','13317096647','【CRMEB】您的验证码是：580413，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-20 15:53:39','518076',200,200144,'ok'),
	(187,'tangkai','15928784684','【CRMEB】您的验证码是：406378，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 10:12:31','518076',200,203092,'ok'),
	(188,'tangkai','13146149227','【CRMEB】您的验证码是：336240，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 12:03:20','518076',200,203794,'ok'),
	(189,'tangkai','13146149227','【CRMEB】您的验证码是：402666，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 12:04:25','518076',200,203800,'ok'),
	(190,'tangkai','15978419983','【CRMEB】您的验证码是：999176，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 13:14:14','518076',200,204160,'ok'),
	(191,'tangkai','15978419983','【CRMEB】您的验证码是：656099，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 13:30:28','518076',200,204245,'ok'),
	(192,'tangkai','15978419983','【CRMEB】您的验证码是：141559，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 13:39:03','518076',200,204286,'ok'),
	(193,'tangkai','15209189276','【CRMEB】您的验证码是：898205，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 17:42:14','518076',200,205364,'ok'),
	(194,'tangkai','13720673941','【CRMEB】您的验证码是：219886，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 18:16:42','518076',200,205490,'ok'),
	(195,'tangkai','13502834774','【CRMEB】您的验证码是：915801，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 11:01:19','518076',200,207380,'ok'),
	(196,'tangkai','18620447521','【CRMEB】您的验证码是：569918，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 14:17:04','518076',200,208186,'ok'),
	(197,'tangkai','15538081797','【CRMEB】您的验证码是：356045，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 15:08:24','518076',200,208413,'ok'),
	(198,'tangkai','15538081797','【CRMEB】您的验证码是：183629，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 15:10:14','518076',200,208425,'ok'),
	(199,'tangkai','13032979631','【CRMEB】您的验证码是：494701，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 16:47:29','518076',200,208880,'ok'),
	(200,'tangkai','13032979631','【CRMEB】您的验证码是：321277，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 16:48:59','518076',200,208886,'ok'),
	(201,'tangkai','18096645945','【CRMEB】您的验证码是：494857，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 17:09:51','518076',200,208953,'ok'),
	(202,'tangkai','13032979631','【CRMEB】您的验证码是：773663，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 17:48:25','518076',200,209103,'ok'),
	(203,'tangkai','13032979631','【CRMEB】您的验证码是：585283，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 17:50:20','518076',200,209113,'ok'),
	(204,'tangkai','18292417675','【CRMEB】您的验证码是：222602，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 17:58:05','518076',200,209141,'ok'),
	(205,'tangkai','18292417675','【CRMEB】您的验证码是：494291，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:08:24','518076',200,209174,'ok'),
	(206,'tangkai','18292417675','【CRMEB】您的验证码是：960562，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:16:11','518076',200,209197,'ok'),
	(207,'tangkai','18292417675','【CRMEB】您的验证码是：311627，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:20:26','518076',200,209218,'ok'),
	(208,'tangkai','18292417675','【CRMEB】您的验证码是：593219，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:26:11','518076',200,209237,'ok'),
	(209,'tangkai','18292417675','【CRMEB】您的验证码是：117429，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:31:41','518076',200,209256,'ok'),
	(210,'tangkai','18292417675','【CRMEB】您的验证码是：299078，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:38:03','518076',200,209281,'ok'),
	(211,'tangkai','18292417675','【CRMEB】您的验证码是：651467，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:45:56','518076',200,209305,'ok'),
	(212,'tangkai','18292417675','【CRMEB】您的验证码是：351786，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:52:16','518076',200,209315,'ok'),
	(213,'tangkai','18954232923','【CRMEB】您的验证码是：522314，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 22:57:51','518076',200,210188,'ok'),
	(214,'tangkai','18954232923','【CRMEB】您的验证码是：938454，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 22:58:56','518076',200,210191,'ok'),
	(215,'tangkai','18954232923','【CRMEB】您的验证码是：336106，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 22:59:41','518076',200,210192,'ok'),
	(216,'tangkai','18292417675','【CRMEB】您的验证码是：666209，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 09:38:30','518076',200,210727,'ok'),
	(217,'tangkai','18292417675','【CRMEB】您的验证码是：853029，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 10:07:19','518076',200,210814,'ok'),
	(218,'tangkai','18292417675','【CRMEB】您的验证码是：188904，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 10:20:12','518076',200,210856,'ok'),
	(219,'tangkai','18292417675','【CRMEB】您的验证码是：626850，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 10:24:47','518076',200,210871,'ok'),
	(220,'tangkai','13146149227','【CRMEB】您的验证码是：853464，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 10:34:38','518076',200,210921,'ok'),
	(221,'tangkai','18292417675','【CRMEB】您的验证码是：554113，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 11:14:25','518076',200,211068,'ok'),
	(222,'tangkai','18292417675','【CRMEB】您的验证码是：627379，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 11:23:13','518076',200,211094,'ok'),
	(223,'tangkai','18292417675','【CRMEB】您的验证码是：605376，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 11:31:22','518076',200,211122,'ok'),
	(224,'tangkai','18292417675','【CRMEB】您的验证码是：435231，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 11:35:56','518076',200,211144,'ok'),
	(225,'tangkai','18991352728','【CRMEB】您的验证码是：783470，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 14:33:53','518076',200,227689,'ok'),
	(226,'tangkai','15573005460','【CRMEB】您的验证码是：524879，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 17:52:51','518076',200,228441,'ok'),
	(227,'tangkai','18838971183','【CRMEB】您的验证码是：825105，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 20:39:59','518076',200,228897,'ok'),
	(228,'tangkai','18838971183','【CRMEB】您的验证码是：260208，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 20:40:49','518076',200,228905,'ok'),
	(229,'tangkai','18838971183','【CRMEB】您的验证码是：978389，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 20:43:29','518076',200,228919,'ok'),
	(230,'tangkai','18838971183','【CRMEB】您的验证码是：687615，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 20:44:29','518076',200,228924,'ok'),
	(231,'tangkai','18838971183','【CRMEB】您的验证码是：353435，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 20:46:59','518076',200,228932,'ok'),
	(232,'tangkai','18292417675','【CRMEB】您的验证码是：563402，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 22:24:45','518076',200,229206,'ok'),
	(233,'tangkai','18292417675','【CRMEB】您的验证码是：356457，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 22:25:45','518076',200,229207,'ok'),
	(234,'tangkai','17324773990','【CRMEB】您的验证码是：528190，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 23:08:00','518076',200,229289,'ok'),
	(235,'tangkai','17324773990','【CRMEB】您的验证码是：867782，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 23:08:00','518076',200,229291,'ok'),
	(236,'tangkai','17324773990','【CRMEB】您的验证码是：975876，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 23:08:00','518076',200,229293,'ok'),
	(237,'tangkai','17324773990','【CRMEB】您的验证码是：397728，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 23:08:00','518076',200,229295,'ok'),
	(238,'tangkai','15071339510','【CRMEB】您的验证码是：730299，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 23:46:25','518076',200,229358,'ok'),
	(239,'tangkai','18128950786','【CRMEB】您的验证码是：188394，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 14:23:24','518076',200,230712,'ok'),
	(240,'tangkai','18128950786','【CRMEB】您的验证码是：958660，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 14:27:35','518076',200,230730,'ok'),
	(241,'tangkai','13641859149','【CRMEB】您的验证码是：323311，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 15:43:29','518076',200,231103,'ok'),
	(242,'tangkai','13720673941','【CRMEB】您的验证码是：431997，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 16:22:24','518076',200,231264,'ok'),
	(243,'tangkai','13720673941','【CRMEB】您的验证码是：197144，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 16:51:04','518076',200,231406,'ok'),
	(244,'tangkai','15959669996','【CRMEB】您的验证码是：757464，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 18:50:03','518076',200,231804,'ok'),
	(245,'tangkai','13032979631','【CRMEB】您的验证码是：310159，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 11:57:26','518076',200,233697,'ok'),
	(246,'tangkai','13032979631','【CRMEB】您的验证码是：583926，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 12:10:57','518076',200,233756,'ok'),
	(247,'tangkai','13032979631','【CRMEB】您的验证码是：619635，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 12:19:04','518076',200,233785,'ok'),
	(248,'tangkai','18559645067','【CRMEB】您的验证码是：634575，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 13:38:30','518076',200,234065,'ok'),
	(249,'tangkai','15209189276','【CRMEB】您的验证码是：393001，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 14:19:25','518076',200,234237,'ok'),
	(250,'tangkai','18292417675','【CRMEB】您的验证码是：767265，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 14:22:49','518076',200,234252,'ok'),
	(251,'tangkai','18292417675','【CRMEB】您的验证码是：783037，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 14:32:02','518076',200,234281,'ok'),
	(252,'tangkai','18292417675','【CRMEB】您的验证码是：273714，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 14:53:08','518076',200,234388,'ok'),
	(253,'tangkai','18292417675','【CRMEB】您的验证码是：838454，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 14:58:41','518076',200,234410,'ok'),
	(254,'tangkai','18292417675','【CRMEB】您的验证码是：244795，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 15:17:29','518076',200,234509,'ok'),
	(255,'tangkai','18292417675','【CRMEB】您的验证码是：919455，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 15:38:49','518076',200,234637,'ok'),
	(256,'tangkai','18292417675','【CRMEB】您的验证码是：678075，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 15:48:10','518076',200,234674,'ok'),
	(257,'tangkai','18292417675','【CRMEB】您的验证码是：112572，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 15:50:35','518076',200,234680,'ok'),
	(258,'tangkai','18292417675','【CRMEB】您的验证码是：611501，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 15:53:20','518076',200,234694,'ok'),
	(259,'tangkai','18292417675','【CRMEB】您的验证码是：517175，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:23:15','518076',200,234788,'ok'),
	(260,'tangkai','18292417675','【CRMEB】您的验证码是：935843，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:34:10','518076',200,234834,'ok'),
	(261,'tangkai','18292417675','【CRMEB】您的验证码是：313652，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:40:17','518076',200,234854,'ok'),
	(262,'tangkai','18292417675','【CRMEB】您的验证码是：571649，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:44:18','518076',200,234872,'ok'),
	(263,'tangkai','18292417675','【CRMEB】您的验证码是：756980，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:51:46','518076',200,234905,'ok'),
	(264,'tangkai','18292417675','【CRMEB】您的验证码是：550456，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:56:49','518076',200,234926,'ok'),
	(265,'tangkai','18292417675','【CRMEB】您的验证码是：442999，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 17:01:00','518076',200,234956,'ok'),
	(266,'tangkai','13720673941','【CRMEB】您的验证码是：632457，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 17:09:48','518076',200,235025,'ok'),
	(267,'tangkai','17570717162','【CRMEB】您的验证码是：465526，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 17:11:22','518076',200,235045,'ok'),
	(268,'tangkai','17621561841','【CRMEB】您的验证码是：374346，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-01 16:28:58','518076',200,241076,'ok'),
	(269,'tangkai','17777665965','【CRMEB】您的验证码是：930100，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-02 15:35:32','518076',200,244147,'ok'),
	(270,'tangkai','17602192032','【CRMEB】您的验证码是：819672，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-02 16:12:28','518076',200,244319,'ok'),
	(271,'tangkai','18306425113','【CRMEB】您的验证码是：296321，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-02 16:13:23','518076',200,244321,'ok'),
	(272,'hzw','18709277397','【CRMEB】您的验证码是：315366，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-02 17:17:55','518076',200,83542,'ok'),
	(273,'tangkai','17570717162','【CRMEB】您的验证码是：872767，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-02 17:34:18','518076',200,244665,'ok'),
	(274,'hzw','18709277397','【CRMEB】您的验证码是：539853，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 09:58:02','518076',200,83558,'ok'),
	(275,'hzw','18709277397','【CRMEB】您的验证码是：182708，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 09:58:02','518076',200,83559,'ok'),
	(276,'hzw','18709277397','【CRMEB】您的验证码是：709069，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 10:19:32','518076',200,83560,'ok'),
	(277,'hzw','18709277397','【CRMEB】您的验证码是：710617，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 11:11:33','518076',200,83562,'ok'),
	(278,'hzw','18709277397','【CRMEB】您的验证码是：634906，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 15:28:45','518076',200,83565,'ok'),
	(279,'hzw','15928784684','【CRMEB】您的验证码是：205458，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 15:34:54','518076',200,83566,'ok'),
	(280,'hzw','15928784684','【CRMEB】您的验证码是：745219，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 10:11:52','518076',200,83585,'ok'),
	(281,'hzw','18328064516','【CRMEB】您的验证码是：377803，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 10:12:52','518076',200,83587,'ok'),
	(282,'hzw','18328064516','【CRMEB】您的验证码是：299484，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 10:49:02','518076',200,83589,'ok'),
	(283,'hzw','18328064516','【CRMEB】您的验证码是：320250，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 13:06:33','518076',200,83598,'ok'),
	(284,'tangkai','13123597920','【CRMEB】您的验证码是：232968，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 13:21:53','518076',200,83599,'ok'),
	(285,'hzw','15928784684','【CRMEB】您的验证码是：759742，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 13:39:03','518076',200,83600,'ok'),
	(286,'hzw','15928784684','【CRMEB】您的验证码是：113489，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 13:41:05','518076',200,83601,'ok'),
	(287,'hzw','18709277397','【CRMEB】您的验证码是：681032，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 14:06:13','518076',200,83602,'ok'),
	(288,'hzw','18709277397','【CRMEB】您的验证码是：813479，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 14:37:59','518076',200,83603,'ok'),
	(289,'tangkai','13530104677','【CRMEB】您的验证码是：361693，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 14:56:08','518076',200,83604,'ok'),
	(290,'tangkai','13530104677','【CRMEB】您的验证码是：867189，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 14:57:23','518076',200,83606,'ok'),
	(291,'hzw','18709277397','【CRMEB】您的验证码是：384391，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 15:03:23','518076',200,83607,'ok'),
	(292,'hzw','18709277397','【CRMEB】您的验证码是：624065，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 15:03:33','518076',200,83608,'ok'),
	(293,'hzw','18709277397','【CRMEB】您的验证码是：256956，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 15:03:43','518076',200,83609,'ok'),
	(294,'hzw','18709277397','【CRMEB】您的验证码是：567804，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 15:03:53','518076',200,83610,'ok'),
	(295,'hzw','15928784684','【CRMEB】您的验证码是：568185，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 19:01:32','518076',200,83620,'ok'),
	(296,'hzw','18328064516','【CRMEB】您的验证码是：235618，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 19:03:47','518076',200,83621,'ok'),
	(297,'hzw','18328064516','【CRMEB】您的验证码是：347641，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 09:11:24','518076',200,83629,'ok'),
	(298,'hzw','18328064516','【CRMEB】您的验证码是：681894，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 09:13:34','518076',200,83630,'ok'),
	(299,'tangkai','13700696591','【CRMEB】您的验证码是：545361，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 09:26:54','518076',200,83631,'ok'),
	(300,'hzw','18328064516','【CRMEB】您的验证码是：932260，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 11:41:55','518076',200,83642,'ok'),
	(301,'hzw','18328064516','【CRMEB】您的验证码是：857790，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 11:44:45','518076',200,83643,'ok'),
	(302,'hzw','15928784684','【CRMEB】您的验证码是：406195，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 11:45:55','518076',200,83644,'ok'),
	(303,'hzw','15928784684','【CRMEB】您的验证码是：595381，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 11:48:20','518076',200,83645,'ok'),
	(304,'hzw','18328064516','【CRMEB】您的验证码是：385221，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 11:49:20','518076',200,83646,'ok'),
	(305,'hzw','18328064516','【CRMEB】您的验证码是：905275，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 12:00:43','518076',200,83647,'ok'),
	(306,'hzw','15928784684','【CRMEB】您的验证码是：431112，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 12:02:00','518076',200,83648,'ok'),
	(307,'hzw','15928784684','【CRMEB】您的验证码是：475245，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 12:03:18','518076',200,83649,'ok'),
	(308,'hzw','15928784684','【CRMEB】您的验证码是：863119，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 13:11:16','518076',200,83650,'ok'),
	(309,'hzw','15928784684','【CRMEB】您的验证码是：602244，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 13:13:00','518076',200,83651,'ok'),
	(310,'hzw','15928784684','【CRMEB】您的验证码是：364602，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 14:42:25','518076',200,83652,'ok'),
	(311,'tangkai','15060035130','【CRMEB】您的验证码是：997367，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 15:05:35','518076',200,83653,'ok'),
	(312,'hzw','16680431664','【CRMEB】您的验证码是：351931，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:14','518076',200,83902,'ok'),
	(313,'hzw','15729480622','【CRMEB】您的验证码是：862605，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:14','518076',200,83903,'ok'),
	(314,'hzw','13112311231','【CRMEB】您的验证码是：328693，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:18','518076',200,83904,'ok'),
	(315,'hzw','13404197669','【CRMEB】您的验证码是：590676，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:18','518076',200,83905,'ok'),
	(316,'hzw','15014114321','【CRMEB】您的验证码是：597859，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:18','518076',200,83906,'ok'),
	(317,'hzw','13007626064','【CRMEB】您的验证码是：782763，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:18','518076',200,83907,'ok'),
	(318,'hzw','15014114321','【CRMEB】您的验证码是：683344，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:18','518076',200,83908,'ok'),
	(319,'hzw','15539977367','【CRMEB】您的验证码是：445114，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:19','518076',200,83909,'ok'),
	(320,'hzw','15990392500','【CRMEB】您的验证码是：166196，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:19','518076',200,83910,'ok'),
	(321,'hzw','18292417675','【CRMEB】您的验证码是：995452，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 17:59:38','518076',200,83917,'ok'),
	(322,'hzw','18292417675','【CRMEB】您的验证码是：114945，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 09:31:06','518076',200,83918,'ok'),
	(323,'hzw','15210928291','【CRMEB】您的验证码是：212691，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 11:02:46','518076',200,83925,'ok'),
	(324,'hzw','18834144748','【CRMEB】您的验证码是：750830，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 14:43:44','518076',200,83929,'ok'),
	(325,'hzw','13826300503','【CRMEB】您的验证码是：986571，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 14:58:44','518076',200,83931,'ok'),
	(326,'hzw','18985155612','【CRMEB】您的验证码是：939016，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 16:16:49','518076',200,83943,'ok'),
	(327,'hzw','13146149227','【CRMEB】您的验证码是：692860，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 16:19:59','518076',200,83944,'ok'),
	(328,'hzw','15832013094','【CRMEB】您的验证码是：949280，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 00:44:32','518076',200,83987,'ok'),
	(329,'hzw','18538848465','【CRMEB】您的验证码是：402264，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 10:37:04','518076',200,83989,'ok'),
	(330,'hzw','13999205182','【CRMEB】您的验证码是：177885，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 12:37:41','518076',200,83997,'ok'),
	(331,'hzw','13510288662','【CRMEB】您的验证码是：220506，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 14:46:46','518076',200,84001,'ok'),
	(332,'hzw','13934656499','【CRMEB】您的验证码是：596295，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 15:12:21','518076',200,84003,'ok'),
	(333,'hzw','18292417675','【CRMEB】您的验证码是：734257，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 15:22:11','518076',200,84007,'ok'),
	(334,'hzw','18292417675','【CRMEB】您的验证码是：634355，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 15:22:53','518076',200,84008,'ok'),
	(335,'hzw','15314547651','【CRMEB】您的验证码是：399169，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 20:42:15','518076',200,84012,'ok'),
	(336,'hzw','13502834774','【CRMEB】您的验证码是：468759，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 21:54:21','518076',200,84015,'ok'),
	(337,'hzw','18922166169','【CRMEB】您的验证码是：771279，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 10:13:47','518076',200,84022,'ok'),
	(338,'hzw','13053590359','【CRMEB】您的验证码是：976229，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 10:25:52','518076',200,84023,'ok'),
	(339,'hzw','18670490538','【CRMEB】您的验证码是：531128，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 10:30:53','518076',200,84024,'ok'),
	(340,'hzw','15883731460','【CRMEB】您的验证码是：447175，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:18:11','518076',200,84025,'ok'),
	(341,'hzw','15563636363','【CRMEB】您的验证码是：384508，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:20:04','518076',200,84026,'ok'),
	(342,'hzw','15618987268','【CRMEB】您的验证码是：822535，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:26:55','518076',200,84027,'ok'),
	(343,'hzw','13502834774','【CRMEB】您的验证码是：273703，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:28:51','518076',200,84028,'ok'),
	(344,'hzw','15563636363','【CRMEB】您的验证码是：477940，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:32:17','518076',200,84029,'ok'),
	(345,'hzw','13502834774','【CRMEB】您的验证码是：405320，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:33:52','518076',200,84030,'ok'),
	(346,'hzw','18396918056','【CRMEB】您的验证码是：745533，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 12:50:34','518076',200,84036,'ok'),
	(347,'hzw','13502834774','【CRMEB】您的验证码是：425250，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 13:01:31','518076',200,84037,'ok'),
	(348,'hzw','13502834774','【CRMEB】您的验证码是：202943，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 13:02:56','518076',200,84038,'ok'),
	(349,'hzw','18763699805','【CRMEB】您的验证码是：828707，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 17:03:27','518076',200,84044,'ok'),
	(350,'hzw','13502834774','【CRMEB】您的验证码是：874034，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 17:19:01','518076',200,84045,'ok'),
	(351,'hzw','13502834774','【CRMEB】您的验证码是：558594，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 17:24:47','518076',200,84046,'ok'),
	(352,'hzw','13666666666','【CRMEB】您的验证码是：894485，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 18:26:51','518076',200,84049,'ok'),
	(353,'hzw','13502834774','【CRMEB】您的验证码是：576398，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 18:39:16','518076',200,84051,'ok'),
	(354,'hzw','15313240480','【CRMEB】您的验证码是：215221，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 10:14:17','518076',200,84061,'ok'),
	(355,'hzw','18974705750','【CRMEB】您的验证码是：591908，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 10:22:53','518076',200,84063,'ok'),
	(356,'hzw','18974705750','【CRMEB】您的验证码是：424309，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 10:26:23','518076',200,84064,'ok'),
	(357,'hzw','18719137665','【CRMEB】您的验证码是：897778，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 10:53:19','518076',200,84067,'ok'),
	(358,'hzw','17768799270','【CRMEB】您的验证码是：747077，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 14:32:34','518076',200,84072,'ok'),
	(359,'stivepeim','18602800120','【CRMEB】您的验证码是：600200，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 18:00:54','518076',200,84081,'ok'),
	(360,'stivepeim','18292417675','【CRMEB】您的验证码是：478600，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 18:02:03','518076',200,84082,'ok'),
	(361,'stivepeim','18292417675','【CRMEB】您的验证码是：423419，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-21 08:31:26','518076',200,84089,'ok'),
	(362,'stivepeim','18670490538','【CRMEB】您的验证码是：796630，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-21 08:32:56','518076',200,84090,'ok'),
	(363,'stivepeim','18670490538','【CRMEB】您的验证码是：650348，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-22 12:37:45','518076',200,84097,'ok'),
	(364,'stivepeim','13401124693','【CRMEB】您的验证码是：751320，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 00:09:37','518076',200,84111,'ok'),
	(365,'stivepeim','13335133317','【CRMEB】您的验证码是：767539，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 09:30:24','518076',200,84112,'ok'),
	(366,'stivepeim','13335133317','【CRMEB】您的验证码是：316193，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 09:31:08','518076',200,84113,'ok'),
	(367,'stivepeim','15883731460','【CRMEB】您的验证码是：380817，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 14:59:55','518076',200,84118,'ok'),
	(368,'hzw','18292417675','【CRMEB】您的验证码是：191976，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 17:59:37','518076',200,84121,'ok'),
	(369,'hzw','18292417675','【CRMEB】您的验证码是：403541，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 18:00:17','518076',200,84122,'ok'),
	(370,'hzw','15928784684','【CRMEB】您的验证码是：855484，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 18:34:37','518076',200,84124,'ok'),
	(371,'stivepeim','18328706641','【CRMEB】您的验证码是：132372，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 18:48:17','518076',200,84125,'ok'),
	(372,'stivepeim','13826008519','【CRMEB】您的验证码是：804021，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 18:54:12','518076',200,84126,'ok'),
	(373,'hzw','15928784684','【CRMEB】您的验证码是：608935，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 09:12:35','518076',200,84132,'ok'),
	(374,'stivepeim','15883731460','【CRMEB】您的验证码是：839678，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 09:56:02','518076',200,84133,'ok'),
	(375,'stivepeim','15883731460','【CRMEB】您的验证码是：778900，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 09:56:37','518076',200,84134,'ok'),
	(376,'hzw','18120558100','【CRMEB】您的验证码是：777126，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 10:14:47','518076',200,84135,'ok'),
	(377,'stivepeim','13707394226','【CRMEB】您的验证码是：361718，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 11:09:32','518076',200,84136,'ok'),
	(378,'stivepeim','13681200110','【CRMEB】您的验证码是：719029，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 11:10:12','518076',200,84137,'ok'),
	(379,'stivepeim','18911459503','【CRMEB】您的验证码是：194633，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 11:20:37','518076',200,84138,'ok'),
	(380,'stivepeim','18128950786','【CRMEB】您的验证码是：785711，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 11:32:53','518076',200,84139,'ok'),
	(381,'hzw','15928784684','【CRMEB】您的验证码是：611952，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 13:01:48','518076',200,84141,'ok'),
	(382,'stivepeim','15117975238','【CRMEB】您的验证码是：878367，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 13:18:53','518076',200,84142,'ok'),
	(383,'stivepeim','15117975238','【CRMEB】您的验证码是：711836，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 13:22:03','518076',200,84143,'ok'),
	(384,'stivepeim','15117975238','【CRMEB】您的验证码是：846192，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 13:23:31','518076',200,84144,'ok'),
	(385,'hzw','15928784684','【CRMEB】您的验证码是：844032，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 13:38:35','518076',200,84145,'ok'),
	(386,'hzw','15928784684','【CRMEB】您的验证码是：465409，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 15:37:19','518076',200,84151,'ok'),
	(387,'stivepeim','15311432805','【CRMEB】您的验证码是：564376，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 11:35:00','518076',200,428076,'ok'),
	(388,'stivepeim','13161656682','【CRMEB】您的验证码是：178247，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 11:35:35','518076',200,428080,'ok'),
	(389,'stivepeim','18328064516','【CRMEB】您的验证码是：581927，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 11:46:44','518076',200,428132,'ok'),
	(390,'stivepeim','18979264999','【CRMEB】您的验证码是：822784，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 11:58:41','518076',200,428199,'ok'),
	(391,'stivepeim','17700278601','【CRMEB】您的验证码是：394998，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 12:52:50','518076',200,428454,'ok'),
	(392,'stivepeim','13720673941','【CRMEB】您的验证码是：899634，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 14:17:35','518076',200,430030,'ok'),
	(393,'stivepeim','18569641151','【CRMEB】您的验证码是：714896，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 18:51:32','518076',200,431566,'ok'),
	(394,'stivepeim','18271671874','【CRMEB】您的验证码是：373986，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-05 12:28:51','518076',200,436611,'ok'),
	(395,'stivepeim','18389161167','【CRMEB】您的验证码是：194739，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-05 15:51:27','518076',200,438815,'ok'),
	(396,'stivepeim','18271671874','【CRMEB】您的验证码是：315648，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-06 15:56:58','518076',200,447460,'ok'),
	(397,'stivepeim','13502834774','【CRMEB】您的验证码是：320915，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-06 21:28:10','518076',200,450197,'ok'),
	(398,'stivepeim','13502834774','【CRMEB】您的验证码是：410482，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-06 21:57:40','518076',200,450296,'ok'),
	(399,'stivepeim','18225103925','【CRMEB】您的验证码是：803371，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 09:12:02','518076',200,451288,'ok'),
	(400,'stivepeim','13309212766','【CRMEB】您的验证码是：408993，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 09:28:02','518076',200,451607,'ok'),
	(401,'stivepeim','13309212766','【CRMEB】您的验证码是：454662，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 09:28:52','518076',200,451641,'ok'),
	(402,'stivepeim','18670490538','【CRMEB】您的验证码是：656519，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:24:13','518076',200,452900,'ok'),
	(403,'stivepeim','18292417675','【CRMEB】您的验证码是：704719，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:26:12','518076',200,452918,'ok'),
	(404,'stivepeim','18670490538','【CRMEB】您的验证码是：342221，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:27:12','518076',200,452930,'ok'),
	(405,'stivepeim','18670490538','【CRMEB】您的验证码是：321310，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:28:37','518076',200,452938,'ok'),
	(406,'stivepeim','18670490538','【CRMEB】您的验证码是：982681，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:29:42','518076',200,452943,'ok'),
	(407,'stivepeim','18528253808','【CRMEB】您的验证码是：743209，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:37:12','518076',200,452990,'ok'),
	(408,'stivepeim','15882436005','【CRMEB】您的验证码是：973922，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:38:57','518076',200,453001,'ok'),
	(409,'stivepeim','15882436005','【CRMEB】您的验证码是：974573，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:46:02','518076',200,453048,'ok'),
	(410,'stivepeim','18528253808','【CRMEB】您的验证码是：940051，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 11:01:53','518076',200,453204,'ok'),
	(411,'stivepeim','13813813813','【CRMEB】您的验证码是：934098，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 11:16:38','518076',200,453314,'ok'),
	(412,'stivepeim','19957104508','【CRMEB】您的验证码是：782045，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 15:20:03','518076',200,456853,'ok'),
	(413,'stivepeim','13927459644','【CRMEB】您的验证码是：297288，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 22:18:19','518076',200,463263,'ok'),
	(414,'stivepeim','18292417675','【CRMEB】您的验证码是：359383，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-08 09:59:26','518076',200,466184,'ok'),
	(415,'stivepeim','18292417675','【CRMEB】您的验证码是：786330，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-08 10:03:31','518076',200,466231,'ok'),
	(416,'stivepeim','13671176582','【CRMEB】您的验证码是：735686，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-08 10:43:19','518076',200,466577,'ok'),
	(417,'stivepeim','15801961236','【CRMEB】您的验证码是：367992，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-08 16:26:40','518076',200,470531,'ok'),
	(418,'stivepeim','18710383544','【CRMEB】您的验证码是：553271，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 11:14:33','518076',200,477446,'ok'),
	(419,'stivepeim','18710383544','【CRMEB】您的验证码是：116062，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 11:33:28','518076',200,477588,'ok'),
	(420,'stivepeim','18710383544','【CRMEB】您的验证码是：362854，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 11:33:58','518076',200,477592,'ok'),
	(421,'stivepeim','18710383544','【CRMEB】您的验证码是：798373，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 11:35:13','518076',200,477601,'ok'),
	(422,'stivepeim','18236770957','【CRMEB】您的验证码是：120298，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 11:56:08','518076',200,477754,'ok'),
	(423,'stivepeim','13428893120','【CRMEB】您的验证码是：715803，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 14:13:33','518076',200,479796,'ok'),
	(424,'stivepeim','15165092036','【CRMEB】您的验证码是：666567，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 14:22:58','518076',200,479851,'ok'),
	(425,'stivepeim','18292417675','【CRMEB】您的验证码是：753758，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 16:34:39','518076',200,480823,'ok'),
	(426,'stivepeim','18292417675','【CRMEB】您的验证码是：326402，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 16:35:39','518076',200,480835,'ok'),
	(427,'stivepeim','18292417675','【CRMEB】您的验证码是：273030，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 16:36:49','518076',200,480847,'ok'),
	(428,'stivepeim','18709277397','【CRMEB】您的验证码是：334478，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-10 11:21:17','518076',200,487412,'ok'),
	(429,'stivepeim','17687976756','【CRMEB】您的验证码是：724780，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-10 14:52:24','518076',200,490254,'ok'),
	(430,'stivepeim','15102908975','【CRMEB】您的验证码是：670459，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-10 14:52:54','518076',200,490260,'ok'),
	(431,'18710383544','13720673941','【CRMEB】您的验证码是：906156，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 15:57:04','518076',200,84541,'ok'),
	(432,'18710383544','18292417675','【CRMEB】您的验证码是：177051，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 15:57:04','518076',200,84542,'ok'),
	(433,'13110665982','13262250632','【CRMEB】您的验证码是：968375，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 15:57:04','518076',200,84543,'ok'),
	(434,'18710383544','13720673941','【CRMEB】您的验证码是：509442，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 15:57:05','518076',200,84544,'ok'),
	(435,'18710383544','13720673941','【CRMEB】您的验证码是：292005，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 16:01:29','518076',200,84546,'ok'),
	(436,'13110665982','13482584235','【CRMEB】您的验证码是：177809，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 16:02:19','518076',200,84547,'ok'),
	(437,'18710383544','13279146082','【CRMEB】您的验证码是：327083，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 16:12:14','518076',200,84548,'ok'),
	(438,'13110665982','13756868993','【CRMEB】您的验证码是：523621，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 16:25:07','518076',200,84549,'ok'),
	(439,'13110665982','18519100842','【CRMEB】您的验证码是：850821，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 17:00:01','518076',200,84550,'ok'),
	(440,'13110665982','13928835046','【CRMEB】您的验证码是：839790，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 19:11:06','518076',200,84551,'ok'),
	(441,'13110665982','18922166169','【CRMEB】您的验证码是：786461，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 23:04:22','518076',200,84552,'ok'),
	(442,'13110665982','13928835046','【CRMEB】您的验证码是：758982，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 09:32:56','518076',200,84553,'ok'),
	(443,'13110665982','17700740858','【CRMEB】您的验证码是：258127，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 10:17:30','518076',200,84555,'ok'),
	(444,'18710383544','13720673941','【CRMEB】您的验证码是：843441，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 10:24:00','518076',200,84556,'ok'),
	(445,'18710383544','13720673941','【CRMEB】您的验证码是：349974，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 10:24:00','518076',200,84557,'ok'),
	(446,'13110665982','15940818637','【CRMEB】您的验证码是：289836，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:45:09','518076',200,84563,'ok'),
	(447,'13110665982','15940818637','【CRMEB】您的验证码是：810995，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:45:09','518076',200,84564,'ok'),
	(448,'13110665982','15940818637','【CRMEB】您的验证码是：960414，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:45:09','518076',200,84565,'ok'),
	(449,'13110665982','15020025163','【CRMEB】您的验证码是：942842，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:45:09','518076',200,84566,'ok'),
	(450,'13110665982','15020025163','【CRMEB】您的验证码是：524137，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:45:10','518076',200,84567,'ok'),
	(451,'13110665982','15940818637','【CRMEB】您的验证码是：790030，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:51:54','518076',200,84568,'ok'),
	(452,'13110665982','15940818637','【CRMEB】您的验证码是：840586，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 12:21:34','518076',200,84574,'ok'),
	(453,'13110665982','18125658802','【CRMEB】您的验证码是：314246，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 14:16:10','518076',200,84575,'ok'),
	(454,'13110665982','15860124109','【CRMEB】您的验证码是：960266，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 15:27:05','518076',200,84576,'ok'),
	(455,'13110665982','17700278601','【CRMEB】您的验证码是：754114，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 15:38:05','518076',200,84577,'ok'),
	(456,'13110665982','18369390581','【CRMEB】您的验证码是：778077，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 16:07:06','518076',200,84578,'ok'),
	(457,'18710383544','13720673941','【CRMEB】您的验证码是：329735，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 16:49:25','518076',200,84580,'ok'),
	(458,'13110665982','13797260973','【CRMEB】您的验证码是：129134，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 18:05:15','518076',200,84582,'ok'),
	(459,'13110665982','19844564879','【CRMEB】您的验证码是：726641，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:17:55','518076',200,84583,'ok'),
	(460,'13110665982','18957168329','【CRMEB】您的验证码是：741292，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:17:55','518076',200,84584,'ok'),
	(461,'13572597243','13720673941','【CRMEB】您的验证码是：850139，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:17:55','518076',200,84585,'ok'),
	(462,'13572597243','13720673941','【CRMEB】您的验证码是：434363，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:17:55','518076',200,84586,'ok'),
	(463,'13572597243','13720673941','【CRMEB】您的验证码是：904373，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:17:55','518076',200,84587,'ok'),
	(464,'18710383544','13720673941','【CRMEB】您的验证码是：315498，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:18:24','518076',200,84588,'ok'),
	(465,'18710383544','18292417675','【CRMEB】您的验证码是：877563，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:06:52','518076',200,84589,'ok'),
	(466,'18710383544','13720673941','【CRMEB】您的验证码是：572794，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:09:37','518076',200,84590,'ok'),
	(467,'18710383544','13720673941','【CRMEB】您的验证码是：442240，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:18:48','518076',200,84591,'ok'),
	(468,'18710383544','13720673941','【CRMEB】您的验证码是：562418，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:23:32','518076',200,84592,'ok'),
	(469,'18710383544','18710383544','【CRMEB】您的验证码是：121801，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:46:17','518076',200,84593,'ok'),
	(470,'18710383544','13720673941','【CRMEB】您的验证码是：635182，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:51:17','518076',200,84594,'ok'),
	(471,'18710383544','18710383544','【CRMEB】您的验证码是：807171，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:52:47','518076',200,84595,'ok'),
	(472,'18710383544','13720673941','【CRMEB】您的验证码是：334894，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:55:37','518076',200,84596,'ok'),
	(473,'18710383544','13720673941','【CRMEB】您的验证码是：715175，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:56:52','518076',200,84597,'ok'),
	(474,'18710383544','13720673941','【CRMEB】您的验证码是：565320，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 11:00:58','518076',200,84598,'ok'),
	(475,'18710383544','13720673941','【CRMEB】您的验证码是：349918，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 11:16:08','518076',200,84599,'ok'),
	(476,'13110665982','18595714999','【CRMEB】您的验证码是：984691，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 11:17:43','518076',200,84600,'ok'),
	(477,'18710383544','13720673941','【CRMEB】您的验证码是：215426，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 11:20:23','518076',200,84601,'ok'),
	(478,'13110665982','17700740525','【CRMEB】您的验证码是：313548，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 14:04:34','518076',200,84603,'ok'),
	(479,'18710383544','18292417675','【CRMEB】您的验证码是：222635，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 15:02:39','518076',200,84607,'ok'),
	(480,'13572597243','13309212766','【CRMEB】您的验证码是：240139，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 17:14:29','518076',200,84618,'ok'),
	(481,'13572597243','18292417675','【CRMEB】您的验证码是：261076，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 17:14:29','518076',200,84619,'ok'),
	(482,'13572597243','18292417675','【CRMEB】您的验证码是：231151，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 17:14:29','518076',200,84620,'ok'),
	(483,'18710383544','123','【CRMEB】您的验证码是：931141，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-24 16:03:15','518076',200,84622,'ok'),
	(484,'18710383544','13309212766','【CRMEB】您的验证码是：742483，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-24 16:08:25','518076',200,84623,'ok'),
	(485,'18710383544','123','【CRMEB】您的验证码是：656338，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-24 16:14:10','518076',200,84624,'ok'),
	(486,'18710383544','18606162350','【CRMEB】您的验证码是：687844，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-24 16:48:15','518076',200,84626,'ok'),
	(487,'18710383544','18606162350','【CRMEB】您的验证码是：327285，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-24 17:05:35','518076',200,84627,'ok'),
	(488,'18710383544','18606162350','【CRMEB】您的验证码是：787076，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-24 17:06:35','518076',200,84628,'ok'),
	(489,'18710383544','18091205509','【CRMEB】您的验证码是：798424，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-24 18:19:21','518076',200,84629,'ok'),
	(490,'18710383544','18908195827','【CRMEB】您的验证码是：752690，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-24 22:21:47','518076',200,84630,'ok'),
	(491,'18710383544','13596016143','【CRMEB】您的验证码是：269027，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 08:49:46','518076',200,84631,'ok'),
	(492,'18710383544','18689462443','【CRMEB】您的验证码是：799704，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 09:29:20','518076',200,84632,'ok'),
	(493,'18710383544','18771629300','【CRMEB】您的验证码是：339297，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 10:39:16','518076',200,84633,'ok'),
	(494,'18710383544','18689462443','【CRMEB】您的验证码是：969814，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 11:18:51','518076',200,84634,'ok'),
	(495,'18710383544','13805406318','【CRMEB】您的验证码是：442905，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 14:27:27','518076',200,84635,'ok'),
	(496,'18710383544','13420128941','【CRMEB】您的验证码是：411471，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 14:43:06','518076',200,84636,'ok'),
	(497,'18710383544','13420128941','【CRMEB】您的验证码是：296672，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 14:49:06','518076',200,84637,'ok'),
	(498,'18710383544','18922166169','【CRMEB】您的验证码是：381822，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 15:03:37','518076',200,84638,'ok'),
	(499,'18710383544','17331459912','【CRMEB】您的验证码是：519213，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 17:00:57','518076',200,84639,'ok'),
	(500,'18710383544','17331459912','【CRMEB】您的验证码是：804152，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 17:05:32','518076',200,84640,'ok'),
	(501,'18710383544','13159859003','【CRMEB】您的验证码是：700771，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 19:48:58','518076',200,84642,'ok'),
	(502,'18710383544','15895501711','【CRMEB】您的验证码是：195530，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 21:31:03','518076',200,84644,'ok'),
	(503,'18710383544','13756868993','【CRMEB】您的验证码是：315195，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 22:38:43','518076',200,84645,'ok'),
	(504,'18710383544','18688888888','【CRMEB】您的验证码是：653496，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-25 23:23:18','518076',200,84646,'ok'),
	(505,'18710383544','18668090643','【CRMEB】您的验证码是：681481，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 08:57:57','518076',200,84647,'ok'),
	(506,'18710383544','13260969896','【CRMEB】您的验证码是：468435，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 09:40:31','518076',200,84649,'ok'),
	(507,'18710383544','18668090643','【CRMEB】您的验证码是：598294，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 09:40:36','518076',200,84650,'ok'),
	(508,'18710383544','13756868993','【CRMEB】您的验证码是：620648，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 10:39:11','518076',200,84651,'ok'),
	(509,'18710383544','13309212765','【CRMEB】您的验证码是：586439，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 10:41:01','518076',200,84652,'ok'),
	(510,'18710383544','13309212766','【CRMEB】您的验证码是：843535，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 10:42:11','518076',200,84653,'ok'),
	(511,'18710383544','18689462443','【CRMEB】您的验证码是：406814，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 10:54:36','518076',200,84654,'ok'),
	(512,'18710383544','18385007600','【CRMEB】您的验证码是：203927，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 14:01:43','518076',200,84657,'ok'),
	(513,'18710383544','17702067821','【CRMEB】您的验证码是：689141，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 14:14:47','518076',200,84659,'ok'),
	(514,'18710383544','15366199577','【CRMEB】您的验证码是：351592，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 14:29:47','518076',200,84660,'ok'),
	(515,'18710383544','15631857507','【CRMEB】您的验证码是：201655，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 15:26:27','518076',200,84662,'ok'),
	(516,'18710383544','18241114450','【CRMEB】您的验证码是：905647，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 16:49:22','518076',200,84663,'ok'),
	(517,'18710383544','15607140140','【CRMEB】您的验证码是：340694，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 19:10:33','518076',200,84666,'ok'),
	(518,'18710383544','15607140140','【CRMEB】您的验证码是：961343，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 19:19:48','518076',200,84667,'ok'),
	(519,'18710383544','17331459912','【CRMEB】您的验证码是：874234，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-26 19:36:13','518076',200,84668,'ok'),
	(520,'18710383544','18027286233','【CRMEB】您的验证码是：647118，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-27 10:41:28','518076',200,84671,'ok'),
	(521,'18710383544','18994799259','【CRMEB】您的验证码是：590873，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 07:46:48','518076',200,84675,'ok'),
	(522,'18710383544','18689462443','【CRMEB】您的验证码是：854853，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 09:30:23','518076',200,84676,'ok'),
	(523,'18710383544','18411632871','【CRMEB】您的验证码是：141690，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 11:41:08','518076',200,84681,'ok'),
	(524,'18710383544','18508477884','【CRMEB】您的验证码是：113122，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 11:49:43','518076',200,84682,'ok'),
	(525,'18710383544','18201162824','【CRMEB】您的验证码是：428434，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 11:54:23','518076',200,84683,'ok'),
	(526,'18710383544','15538081797','【CRMEB】您的验证码是：481716，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 13:32:18','518076',200,84685,'ok'),
	(527,'18710383544','15538081797','【CRMEB】您的验证码是：838594，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 13:38:33','518076',200,84686,'ok'),
	(528,'18710383544','15211668515','【CRMEB】您的验证码是：712924，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 13:52:58','518076',200,84687,'ok'),
	(529,'18710383544','18689462443','【CRMEB】您的验证码是：741690，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 14:06:08','518076',200,84688,'ok'),
	(530,'18710383544','15625491020','【CRMEB】您的验证码是：322801，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 16:31:48','518076',200,84697,'ok'),
	(531,'18710383544','18508477884','【CRMEB】您的验证码是：115036，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 16:38:34','518076',200,84698,'ok'),
	(532,'18710383544','13530088790','【CRMEB】您的验证码是：199243，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 17:24:29','518076',200,84699,'ok'),
	(533,'18710383544','18689462443','【CRMEB】您的验证码是：915010，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 18:06:28','518076',200,84700,'ok'),
	(534,'18710383544','15505591353','【CRMEB】您的验证码是：235953，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-28 19:51:04','518076',200,84706,'ok'),
	(535,'18710383544','15127152357','【CRMEB】您的验证码是：796678，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-29 11:00:50','518076',200,84713,'ok'),
	(536,'18710383544','15209189276','【CRMEB】您的验证码是：875100，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-16 11:39:42','518076',200,84849,'ok'),
	(537,'18710383544','13709134835','【CRMEB】您的验证码是：315952，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-16 11:46:56','518076',200,84850,'ok'),
	(538,'18710383544','15209189276','【CRMEB】您的验证码是：322403，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-16 16:19:28','518076',200,84854,'ok'),
	(539,'18710383544','13720608141','【CRMEB】您的验证码是：885955，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-18 16:34:05','518076',200,84856,'ok'),
	(540,'18710383544','13720367491','【CRMEB】您的验证码是：960866，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-18 16:34:53','518076',200,84857,'ok');

/*!40000 ALTER TABLE `eb_sms_record` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_bargain
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_bargain`;

CREATE TABLE `eb_store_bargain` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '砍价商品ID',
  `product_id` int(11) unsigned NOT NULL COMMENT '关联商品ID',
  `title` varchar(255) NOT NULL COMMENT '砍价活动名称',
  `image` varchar(150) NOT NULL COMMENT '砍价活动图片',
  `unit_name` varchar(16) DEFAULT NULL COMMENT '单位名称',
  `stock` int(11) unsigned DEFAULT NULL COMMENT '库存',
  `sales` int(11) unsigned DEFAULT NULL COMMENT '销量',
  `images` varchar(2000) NOT NULL COMMENT '砍价商品轮播图',
  `start_time` bigint(14) unsigned NOT NULL COMMENT '砍价开启时间',
  `stop_time` bigint(14) unsigned NOT NULL COMMENT '砍价结束时间',
  `store_name` varchar(255) DEFAULT NULL COMMENT '砍价商品名称',
  `price` decimal(8,2) unsigned DEFAULT NULL COMMENT '砍价金额',
  `min_price` decimal(8,2) unsigned DEFAULT NULL COMMENT '砍价商品最低价',
  `num` int(11) unsigned DEFAULT NULL COMMENT '购买数量限制——单个活动每个用户发起砍价次数限制',
  `bargain_max_price` decimal(8,2) unsigned DEFAULT NULL COMMENT '用户每次砍价的最大金额',
  `bargain_min_price` decimal(8,2) unsigned DEFAULT NULL COMMENT '用户每次砍价的最小金额',
  `bargain_num` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '帮砍次数——单个商品用户可以帮砍的次数',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '砍价状态 0(到砍价时间不自动开启)  1(到砍价时间自动开启时间)',
  `give_integral` int(11) DEFAULT '0' COMMENT '反多少积分',
  `info` varchar(255) DEFAULT NULL COMMENT '砍价活动简介',
  `cost` decimal(8,2) unsigned DEFAULT NULL COMMENT '成本价',
  `sort` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐0不推荐1推荐',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除 0未删除 1删除',
  `add_time` bigint(14) unsigned DEFAULT NULL COMMENT '添加时间',
  `is_postage` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否包邮 0不包邮 1包邮',
  `postage` decimal(10,2) unsigned DEFAULT NULL COMMENT '邮费',
  `rule` text COMMENT '砍价规则',
  `look` int(11) unsigned DEFAULT '0' COMMENT '砍价商品浏览量',
  `share` int(11) unsigned DEFAULT '0' COMMENT '砍价商品分享量',
  `temp_id` int(11) DEFAULT NULL COMMENT '运费模板ID',
  `weight` decimal(8,2) DEFAULT '0.00' COMMENT '重量',
  `volume` decimal(8,2) DEFAULT '0.00' COMMENT '体积',
  `quota` int(10) NOT NULL DEFAULT '0' COMMENT '限购总数',
  `quota_show` int(10) NOT NULL DEFAULT '0' COMMENT '限量总数显示',
  `people_num` int(11) DEFAULT NULL COMMENT '砍价人数——需要多少人砍价成功',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='砍价表';

LOCK TABLES `eb_store_bargain` WRITE;
/*!40000 ALTER TABLE `eb_store_bargain` DISABLE KEYS */;

INSERT INTO `eb_store_bargain` (`id`, `product_id`, `title`, `image`, `unit_name`, `stock`, `sales`, `images`, `start_time`, `stop_time`, `store_name`, `price`, `min_price`, `num`, `bargain_max_price`, `bargain_min_price`, `bargain_num`, `status`, `give_integral`, `info`, `cost`, `sort`, `is_hot`, `is_del`, `add_time`, `is_postage`, `postage`, `rule`, `look`, `share`, `temp_id`, `weight`, `volume`, `quota`, `quota_show`, `people_num`)
VALUES
	(7,4,'砍价商品','image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg','件',998,0,'[\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\"]',1607961600000,1608652799999,'砍价商品',100.00,0.00,1,NULL,NULL,2,0,0,'砍价商品',50.00,0,0,1,1608003990658,1,NULL,'',28,1,2,0.00,0.00,998,998,2),
	(8,5,'可乐','image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png','件',995,4,'[\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\"]',1607961600000,1608652799999,'可乐',100.00,0.00,10,NULL,NULL,2,0,0,'可乐',50.00,0,0,1,1608005976205,1,NULL,'',73,7,2,0.00,0.00,995,998,2),
	(9,7,'腰果','image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','盒',9996,3,'[\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\"]',1608480000000,1609430399999,'腰果',100000.00,10.00,10,NULL,NULL,2,0,0,'腰果腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范',50.00,9999,0,1,1608171505772,1,NULL,'<p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">苹果<a href=\"https://www.chinaz.com/tags/iPhone12ProMax.shtml\" target=\"_blank\" style=\"box-sizing: border-box; outline: 0px; color: rgb(66, 66, 66); text-decoration-line: none; padding: 0px 0px 2px; border-bottom: 1px dashed rgb(51, 51, 51); cursor: pointer;\">iPhone12ProMax</a>是今年苹果性能配置最强的一个型号，也因此成为很多人打算购买的一款手机，那么这款手机在什么时候会发售上市呢，线下门店什么时候能买到，我们来一起看下具体的时间介绍吧。</p><p class=\"article-content__img\" style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: center; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; white-space: normal; background-color: rgb(255, 255, 255);\"><img src=\"https://upload.chinaz.com/2020/1105/6374018479209622675668582.jpg\" title=\"苹果.jpg\" alt=\"苹果.jpg\" style=\"display: inline-block; box-sizing: border-box; outline: 0px; border: 1px solid rgb(238, 238, 238); max-width: 800px; background: url(&quot;../img/bglogo2.svg&quot;) center center no-repeat rgb(247, 248, 249); box-shadow: rgba(27, 95, 160, 0.1) 0px 1px 3px; margin: 0px auto;\"/></p><p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">1、iPhone12ProMax发售时间:11月6日晚上9点开启预售，11月13日正式发售上市</p><p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">2、如果在11月6日第一时间预约的用户，那么有机会在11月13日当天就可以发货，或者在苹果直营店取货</p><p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">3、iPhone12ProMax价格:9299元（128GB）、10099元(256GB)、11899元(512GB)</p><p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">4、iPhone12ProMax预计会十分热销，尤其是256GB、512GB的版本有可能出现加价的情况，另外海蓝色和石墨色两个颜色也会比较多人购买</p><p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">5、建议在11月6日晚上9点准时就前往官网下单付款，预计最快可以在发售日当天可以取货，如果速度较慢的话，可能需要等到超过1-2周时间才发货</p><p><br style=\"white-space: normal;\"/></p><p><br style=\"white-space: normal;\"/></p><p><br/></p>',56,6,2,0.00,0.00,97,97,2),
	(10,17,'HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男','image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png','件',97,2,'[\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\",\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\",\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\",\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\"]',1608739200000,1609430399999,'HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男',218.00,0.00,10,NULL,NULL,2,0,30,'HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男',100.00,100,0,1,1608778497038,1,NULL,'',33,3,2,0.00,0.00,49,50,2),
	(11,15,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男','//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg','件',99,1,'[\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\"]',1608739200000,1609430399999,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',159.00,10.00,1,NULL,NULL,2,0,20,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',100.00,99,0,1,1608795633474,1,NULL,'',18,1,2,0.00,0.00,99,100,2),
	(12,19,'【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男','\\/\\/img.alicdn.com\\/imgextra\\/i1\\/693060164\\/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg','件',100,0,'[\"//img.alicdn.com/imgextra/i1/693060164/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg\",\"//img.alicdn.com/imgextra/i3/693060164/O1CN01hRYyYC1D59aGylQuO_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01IzHD3j1D59aKgOB4A_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i3/693060164/O1CN01tL10tb1D59aGbm21Z_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i3/693060164/O1CN01XnrWtq1D59aGblUki_!!693060164.jpg\"]',1608739200000,1609430399999,'【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男',428.00,NULL,1,NULL,NULL,2,0,20,'【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男',200.00,98,0,1,1608795848549,1,NULL,'',0,0,2,0.00,0.00,100,100,2),
	(13,18,'HLA/海澜之家时尚牛津纺清新休闲衬衫经典透气长袖衬衫男','\\/\\/img.alicdn.com\\/imgextra\\/i1\\/693060164\\/O1CN01RpM8LX1D59bLOf3oS_!!693060164-0-picasso.jpg','件',100,0,'[\"//img.alicdn.com/imgextra/i1/693060164/O1CN01RpM8LX1D59bLOf3oS_!!693060164-0-picasso.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01dF577A1D59aGtHK0G_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01HLjBvU1D59aGbkHts_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i3/693060164/O1CN010NqZB91D59aDJ2NtU_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01zMx89N1D59aDJ1e8g_!!693060164.jpg\"]',1608739200000,1609430399999,'HLA/海澜之家时尚牛津纺清新休闲衬衫经典透气长袖衬衫男',98.00,10.00,10,NULL,NULL,2,0,20,'HLA/海澜之家时尚牛津纺清新休闲衬衫经典透气长袖衬衫男',50.00,97,0,1,1608801336366,1,NULL,'',1,0,2,0.00,0.00,100,100,2),
	(14,1,'圈粉','image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','T',8,1,'[\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\"]',1608739200000,1609430399999,'圈粉',99.00,10.00,10,NULL,NULL,2,0,1,'圈粉',9.00,1,0,1,1608801684290,1,NULL,'',9,1,1,0.00,0.00,8,9,2),
	(15,9,'【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机','http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg','件',992,0,'[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\"]',1610294400000,1612108799999,'【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机',10000.00,0.00,1,NULL,NULL,2,0,0,'【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机',5000.00,1000,0,1,1608804585678,1,NULL,'',36,1,2,0.00,0.00,992,992,2),
	(16,30,'Jordan 官方 AIR JORDAN 3 RETRO AJ3复刻男子运动鞋CT8532','image/store/2021/01/16/41bd871869e34a8384b932b50d1f9dd6dwle1zzptr.png','件',99,1,'[\"image/content/2021/01/16/f8aad4ff9c8f46a9bb0c70b94e17ae5fs8n6kpu79x.png\",\"image/content/2021/01/16/f9c2bf85441f47228f347a5af977a9d2aqwfda4vo1.png\",\"image/content/2021/01/16/3ce969fa970d4964a00ad7cfc084a994b74qnp857n.png\",\"image/content/2021/01/16/fb9c8cd0ebbb4fdfa032e12ce960601ci0jdz6qtvb.png\",\"image/content/2021/01/16/80a97c58b69a41298995ad0ae4f6cf93y8mfo0o6gf.png\"]',1610726400000,1612108799999,'Jordan 官方 AIR JORDAN 3 RETRO AJ3复刻男子运动鞋CT8532',1399.00,899.00,1,NULL,NULL,2,1,50,'Jordan 官方 AIR JORDAN 3 RETRO AJ3复刻男子运动鞋CT8532\n',899.00,0,0,0,1610784540904,1,NULL,'<p>1、爱说大话按考生的卡仕达卡号是卡号是a</p><p>2、爱说大话安静看书的卡号是的看见啥空间哈萨克就的蛤科进士会打瞌睡</p><p>3、卡的蛤科进士很快就撒好的卡上dksa</p><p>4、赛道和课件撒好的卡上卡号是的卡斯阿瑟东撒旦按时打算大撒按时撒阿瑟东</p><p><img src=\"https://image.java.crmeb.net/image/store/2021/01/16/fa418fd0a5d34c9cbd96c3ed48e90cb3r0sbrl7pn5.png\"/><br/></p>',37,4,3,0.00,0.00,9,10,4),
	(17,29,'Jordan 官方JORDAN DELTA PRM 男子运动鞋休闲低帮DB5768','\\/\\/img.alicdn.com\\/imgextra\\/i1\\/3327042818\\/O1CN01scRUu71WggkH5pMyZ_!!0-item_pic.jpg','件',100,0,'[\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01scRUu71WggkH5pMyZ_!!0-item_pic.jpg\",\"//img.alicdn.com/imgextra/i3/3327042818/O1CN016KiWMv1WggkJyFBev_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01NEmPEE1WggkIq1JEl_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01X7ZMqz1WggkGccsqW_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01vtecgS1WggkIq2W4j_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01lobRbM1WggkAp7avm_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01v1ZC6B1WggkFUt1YO_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01oypbPj1WggkAp7BzL_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01d7dkVR1WggkJCXdoo_!!3327042818.jpg\"]',1610726400000,1612108799999,'Jordan 官方JORDAN DELTA PRM 男子运动鞋休闲低帮DB5768',899.00,599.00,1,NULL,NULL,2,0,0,'Jordan 官方JORDAN DELTA PRM 男子运动鞋休闲低帮DB5768',599.00,0,0,1,1610786875967,1,NULL,'',13,1,3,0.00,0.00,1,1,2),
	(18,29,'Jordan 官方JORDAN DELTA PRM 男子运动鞋休闲低帮DB5768','\\/\\/img.alicdn.com\\/imgextra\\/i1\\/3327042818\\/O1CN01scRUu71WggkH5pMyZ_!!0-item_pic.jpg','件',100,0,'[\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01scRUu71WggkH5pMyZ_!!0-item_pic.jpg\",\"//img.alicdn.com/imgextra/i3/3327042818/O1CN016KiWMv1WggkJyFBev_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01NEmPEE1WggkIq1JEl_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01X7ZMqz1WggkGccsqW_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01vtecgS1WggkIq2W4j_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01lobRbM1WggkAp7avm_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01v1ZC6B1WggkFUt1YO_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01oypbPj1WggkAp7BzL_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01d7dkVR1WggkJCXdoo_!!3327042818.jpg\"]',1610726400000,1612108799999,'Jordan 官方JORDAN DELTA PRM 男子运动鞋休闲低帮DB5768',1399.00,899.00,1,NULL,NULL,1,1,0,'Jordan 官方JORDAN DELTA PRM 男子运动鞋休闲低帮DB5768',599.00,0,0,0,1610787684822,1,NULL,'',5,0,3,0.00,0.00,10,10,2);

/*!40000 ALTER TABLE `eb_store_bargain` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_bargain_user
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_bargain_user`;

CREATE TABLE `eb_store_bargain_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户参与砍价表ID',
  `uid` int(11) unsigned DEFAULT NULL COMMENT '用户ID',
  `bargain_id` int(11) unsigned DEFAULT NULL COMMENT '砍价商品id',
  `bargain_price_min` decimal(8,2) unsigned DEFAULT NULL COMMENT '砍价的最低价',
  `bargain_price` decimal(8,2) DEFAULT NULL COMMENT '砍价金额',
  `price` decimal(8,2) unsigned DEFAULT NULL COMMENT '砍掉的价格',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态 1参与中 2 活动结束参与失败 3活动结束参与成功',
  `add_time` bigint(14) unsigned DEFAULT NULL COMMENT '参与时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否取消',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='用户参与砍价表';

LOCK TABLES `eb_store_bargain_user` WRITE;
/*!40000 ALTER TABLE `eb_store_bargain_user` DISABLE KEYS */;

INSERT INTO `eb_store_bargain_user` (`id`, `uid`, `bargain_id`, `bargain_price_min`, `bargain_price`, `price`, `status`, `add_time`, `is_del`)
VALUES
	(12,32,7,0.00,100.00,39.01,1,1608004075309,0),
	(13,34,7,0.00,100.00,100.00,3,1608004377566,0),
	(14,35,7,0.00,100.00,30.03,1,1608005770142,0),
	(15,34,8,0.00,100.00,100.00,3,1608006027147,0),
	(16,37,8,0.00,100.00,65.84,2,1608081781425,0),
	(17,32,9,10.00,100.00,90.00,2,1608171548727,0),
	(18,34,9,10.00,100.00,90.00,3,1608171856182,0),
	(19,34,9,10.00,100.00,90.00,3,1608173309575,0),
	(20,35,9,10.00,100.00,90.00,2,1608173803620,0),
	(21,31,8,0.00,100.00,100.00,3,1608174472131,0),
	(22,34,8,0.00,100.00,100.00,3,1608174496581,0),
	(23,31,8,0.00,100.00,100.00,3,1608174861386,0),
	(24,31,8,0.00,100.00,100.00,3,1608175057778,0),
	(25,31,9,10.00,100.00,90.00,3,1608175378237,0),
	(26,34,9,10.00,100.00,31.33,2,1608175471160,0),
	(27,46,9,10.00,100.00,21.32,2,1608175763657,0),
	(28,46,8,0.00,100.00,100.00,2,1608176185879,0),
	(29,31,9,10.00,100.00,90.00,2,1608176288953,0),
	(30,31,8,0.00,100.00,100.00,3,1608279146228,0),
	(31,32,8,0.00,100.00,63.70,2,1608530574057,0),
	(32,52,9,10.00,100.00,24.05,1,1608540119301,0),
	(33,59,8,0.00,100.00,74.00,2,1608604646856,0),
	(34,54,8,0.00,100.00,36.71,2,1608608083248,0),
	(35,34,10,0.00,218.00,218.00,3,1608781873956,0),
	(36,32,10,0.00,218.00,86.30,1,1608781873987,0),
	(37,49,10,0.00,218.00,218.00,3,1608782109173,0),
	(38,35,10,0.00,218.00,64.77,1,1608782177280,0),
	(39,34,10,0.00,218.00,218.00,3,1608782787357,0),
	(40,170,9,10.00,100000.00,59126.00,1,1608792500012,0),
	(41,34,11,10.00,159.00,149.00,3,1608796387540,0),
	(42,34,13,10.00,98.00,29.30,1,1608801353098,0),
	(43,34,14,10.00,99.00,89.00,3,1608801739868,0),
	(44,186,11,10.00,159.00,96.56,2,1608818526068,0),
	(45,193,11,10.00,159.00,91.00,2,1608822053685,0),
	(46,198,11,10.00,159.00,57.58,2,1608857491002,0),
	(47,227,11,10.00,159.00,42.30,2,1608947366090,0),
	(48,256,14,10.00,99.00,51.28,2,1609170728994,0),
	(49,256,11,10.00,159.00,117.52,2,1609170736433,0),
	(50,273,14,10.00,99.00,41.94,2,1609252765662,0),
	(51,372,15,0.00,10000.00,7443.27,1,1610420259026,0),
	(52,375,15,0.00,10000.00,10000.00,1,1610448037767,0),
	(53,376,15,0.00,10000.00,5288.15,1,1610450095374,0),
	(54,380,15,0.00,10000.00,6628.60,1,1610695805458,0),
	(55,52,16,899.00,1399.00,500.00,3,1610784616770,0),
	(56,385,16,899.00,1399.00,267.65,1,1610785206271,0),
	(57,52,17,599.00,899.00,300.00,1,1610786937350,0),
	(58,385,17,599.00,899.00,143.31,1,1610786982724,0),
	(59,35,17,599.00,899.00,104.25,1,1610787081422,0),
	(60,52,18,899.00,1399.00,178.11,1,1610787699474,0),
	(61,57,16,899.00,1399.00,195.79,1,1610788487706,0);

/*!40000 ALTER TABLE `eb_store_bargain_user` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_bargain_user_help
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_bargain_user_help`;

CREATE TABLE `eb_store_bargain_user_help` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '砍价用户帮助表ID',
  `uid` int(11) unsigned DEFAULT NULL COMMENT '帮助的用户id',
  `bargain_id` int(11) unsigned DEFAULT NULL COMMENT '砍价商品ID',
  `bargain_user_id` int(11) unsigned DEFAULT NULL COMMENT '用户参与砍价表id',
  `price` decimal(8,2) unsigned DEFAULT NULL COMMENT '帮助砍价多少金额',
  `add_time` bigint(14) unsigned DEFAULT NULL COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='砍价用户帮助表';

LOCK TABLES `eb_store_bargain_user_help` WRITE;
/*!40000 ALTER TABLE `eb_store_bargain_user_help` DISABLE KEYS */;

INSERT INTO `eb_store_bargain_user_help` (`id`, `uid`, `bargain_id`, `bargain_user_id`, `price`, `add_time`)
VALUES
	(16,32,7,12,39.01,1608004075416),
	(17,34,7,13,71.94,1608004377729),
	(18,35,7,13,28.06,1608004625949),
	(19,35,7,14,30.03,1608005770365),
	(20,34,8,15,61.64,1608006027318),
	(21,35,8,15,38.36,1608006090829),
	(22,37,8,16,65.84,1608081781530),
	(23,32,9,17,23.39,1608171548836),
	(24,34,9,17,66.61,1608171583038),
	(25,34,9,18,29.90,1608171856390),
	(26,35,9,18,60.10,1608171894526),
	(27,34,9,19,38.30,1608173309751),
	(28,35,9,19,51.70,1608173380308),
	(29,35,9,20,61.73,1608173803767),
	(30,34,9,20,28.27,1608173820217),
	(31,31,8,21,51.49,1608174472350),
	(32,34,8,21,48.51,1608174495439),
	(33,34,8,22,46.69,1608174496668),
	(34,31,8,23,20.32,1608174861596),
	(35,34,8,23,79.68,1608174956435),
	(36,31,8,24,21.79,1608175058107),
	(37,46,8,24,78.21,1608175114624),
	(38,31,9,25,69.02,1608175378454),
	(39,34,9,26,31.33,1608175471306),
	(40,46,9,25,20.98,1608175592439),
	(41,46,9,27,21.32,1608175763952),
	(42,46,8,28,57.55,1608176186072),
	(43,31,9,29,71.54,1608176289115),
	(44,46,9,29,18.46,1608176307857),
	(45,31,8,28,42.45,1608274312031),
	(46,31,8,30,56.57,1608279146395),
	(47,46,8,30,43.43,1608279190099),
	(48,32,8,31,63.70,1608530574165),
	(49,35,8,22,53.31,1608530815208),
	(50,52,9,32,24.05,1608540119413),
	(51,59,8,33,74.00,1608604646954),
	(52,54,8,34,36.71,1608608083361),
	(53,34,10,35,142.40,1608781874069),
	(54,32,10,36,86.30,1608781874093),
	(55,49,10,37,84.48,1608782109277),
	(56,35,10,35,75.60,1608782176167),
	(57,35,10,38,64.77,1608782177366),
	(58,34,10,37,133.52,1608782204219),
	(59,34,10,39,73.76,1608782787666),
	(60,170,9,40,59126.00,1608792500193),
	(61,35,10,39,144.24,1608795523348),
	(62,34,11,41,102.44,1608796387645),
	(63,35,11,41,46.56,1608796434028),
	(64,34,13,42,29.30,1608801353190),
	(65,34,14,43,27.04,1608801739969),
	(66,35,14,43,61.96,1608801763533),
	(67,186,11,44,96.56,1608818526227),
	(68,193,11,45,91.00,1608822053854),
	(69,198,11,46,57.58,1608857491187),
	(70,227,11,47,42.30,1608947366176),
	(71,256,14,48,51.28,1609170729212),
	(72,256,11,49,117.52,1609170736579),
	(73,273,14,50,41.94,1609252765841),
	(74,372,15,51,7443.27,1610420259159),
	(75,375,15,52,3358.21,1610448037847),
	(76,376,15,52,6641.79,1610450091874),
	(77,376,15,53,5288.15,1610450095550),
	(78,380,15,54,6628.60,1610695805598),
	(79,52,16,55,283.54,1610784616870),
	(80,35,16,55,143.61,1610784706621),
	(81,34,16,55,23.46,1610784735425),
	(82,385,16,55,49.39,1610785204878),
	(83,385,16,56,120.56,1610785206323),
	(84,52,17,57,128.44,1610786937447),
	(85,35,17,57,171.56,1610786966454),
	(86,385,17,58,143.31,1610786982816),
	(87,35,17,59,104.25,1610787081618),
	(88,35,16,56,147.09,1610787125154),
	(89,52,18,60,178.11,1610787700243),
	(90,57,16,61,195.79,1610788487843);

/*!40000 ALTER TABLE `eb_store_bargain_user_help` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_cart
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_cart`;

CREATE TABLE `eb_store_cart` (
  `id` bigint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '购物车表ID',
  `uid` int(10) unsigned NOT NULL COMMENT '用户ID',
  `type` varchar(32) NOT NULL COMMENT '类型',
  `product_id` int(10) unsigned NOT NULL COMMENT '商品ID',
  `product_attr_unique` varchar(16) NOT NULL DEFAULT '' COMMENT '商品属性',
  `cart_num` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '商品数量',
  `is_new` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为立即购买',
  `combination_id` int(11) unsigned DEFAULT '0' COMMENT '拼团id',
  `seckill_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `bargain_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '砍价id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT 'g',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '购物车状态',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`uid`) USING BTREE,
  KEY `goods_id` (`product_id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `uid_2` (`uid`) USING BTREE,
  KEY `uid_3` (`uid`,`is_new`) USING BTREE,
  KEY `type` (`type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='购物车表';

LOCK TABLES `eb_store_cart` WRITE;
/*!40000 ALTER TABLE `eb_store_cart` DISABLE KEYS */;

INSERT INTO `eb_store_cart` (`id`, `uid`, `type`, `product_id`, `product_attr_unique`, `cart_num`, `is_new`, `combination_id`, `seckill_id`, `bargain_id`, `create_time`, `update_time`, `status`)
VALUES
	(2,3,'product',1,'41',1,1,0,0,0,'2020-12-07 18:00:11',NULL,0),
	(4,4,'product',1,'41',1,1,0,0,0,'2020-12-08 14:51:23',NULL,0),
	(6,4,'product',1,'41',1,1,0,0,0,'2020-12-08 14:53:11',NULL,0),
	(7,11,'product',1,'41',1,1,0,0,0,'2020-12-09 14:30:18',NULL,0),
	(9,12,'product',1,'197',1,1,0,0,0,'2020-12-09 16:41:32',NULL,0),
	(10,11,'product',1,'197',1,1,0,0,0,'2020-12-09 16:45:30',NULL,0),
	(11,11,'product',3,'208',1,1,0,0,0,'2020-12-10 10:10:04',NULL,0),
	(12,14,'product',3,'208',1,1,0,0,0,'2020-12-10 10:22:37',NULL,0),
	(13,11,'product',3,'208',1,1,0,0,0,'2020-12-10 10:24:13',NULL,0),
	(14,14,'product',3,'208',1,1,0,0,0,'2020-12-10 10:27:34',NULL,0),
	(15,14,'product',3,'208',1,1,0,0,0,'2020-12-10 10:33:47',NULL,0),
	(16,14,'product',3,'208',1,1,0,0,0,'2020-12-10 10:33:53',NULL,0),
	(17,17,'product',1,'197',1,1,0,0,0,'2020-12-10 14:38:30',NULL,0),
	(19,28,'product',3,'208',1,1,0,0,0,'2020-12-13 08:27:18',NULL,0),
	(20,28,'product',2,'207',1,1,0,0,0,'2020-12-13 08:27:42',NULL,0),
	(21,28,'product',1,'197',1,1,0,0,0,'2020-12-13 08:28:06',NULL,0),
	(22,31,'product',3,'210',1,1,0,0,0,'2020-12-14 16:59:48',NULL,0),
	(23,31,'product',3,'211',1,1,0,0,0,'2020-12-14 17:05:58',NULL,0),
	(26,34,'product',4,'212',1,1,0,0,0,'2020-12-15 09:56:20',NULL,0),
	(27,35,'product',2,'207',1,1,0,0,0,'2020-12-15 10:09:44',NULL,0),
	(28,34,'product',1,'197',1,1,0,0,0,'2020-12-15 10:10:14',NULL,0),
	(29,36,'product',1,'197',1,1,0,0,0,'2020-12-15 11:04:41',NULL,0),
	(30,36,'product',1,'197',1,1,0,0,0,'2020-12-15 11:04:41',NULL,0),
	(31,32,'product',5,'218',1,1,0,0,0,'2020-12-15 15:13:01',NULL,0),
	(32,32,'product',5,'218',1,1,0,0,0,'2020-12-15 15:18:33',NULL,0),
	(33,34,'product',5,'218',1,1,0,0,0,'2020-12-15 15:19:43',NULL,0),
	(34,35,'product',5,'218',1,1,0,0,0,'2020-12-16 09:58:21',NULL,0),
	(35,35,'product',5,'218',1,1,0,0,0,'2020-12-16 10:00:21',NULL,0),
	(37,33,'product',1,'197',1,1,0,0,0,'2020-12-16 10:25:56',NULL,0),
	(38,33,'product',1,'197',1,1,0,0,0,'2020-12-16 10:44:20',NULL,0),
	(39,33,'product',3,'211',1,1,0,0,0,'2020-12-16 10:46:54',NULL,0),
	(40,33,'product',1,'197',1,1,0,0,0,'2020-12-16 10:58:26',NULL,0),
	(41,33,'product',1,'197',1,1,0,0,0,'2020-12-16 11:26:43',NULL,0),
	(42,33,'product',1,'197',1,1,0,0,0,'2020-12-16 11:28:25',NULL,0),
	(43,32,'product',7,'222',5,1,0,0,0,'2020-12-16 14:33:13',NULL,0),
	(45,34,'product',7,'222',2,1,0,0,0,'2020-12-17 11:53:55',NULL,0),
	(46,33,'product',6,'221',1,1,0,0,0,'2020-12-17 15:15:00',NULL,0),
	(49,44,'product',3,'211',1,1,0,0,0,'2020-12-17 15:55:53',NULL,0),
	(50,31,'product',6,'221',1,1,0,0,0,'2020-12-17 16:21:50',NULL,0),
	(51,31,'product',1,'197',3,1,0,0,0,'2020-12-17 16:24:08',NULL,0),
	(55,34,'product',7,'308',1,0,0,0,0,'2020-12-17 18:13:06',NULL,0),
	(56,34,'product',7,'308',1,0,0,0,0,'2020-12-17 18:13:13',NULL,0),
	(60,46,'product',10,'309',1,0,0,0,0,'2020-12-18 09:49:14',NULL,1),
	(61,46,'product',10,'309',1,0,0,0,0,'2020-12-18 09:49:33',NULL,1),
	(62,46,'product',1,'197',1,0,0,0,0,'2020-12-18 09:49:57',NULL,0),
	(63,46,'product',1,'421',1,0,0,0,0,'2020-12-18 09:50:05',NULL,0),
	(87,35,'product',1,'393',1,0,0,0,0,'2020-12-18 15:36:47',NULL,0),
	(88,35,'product',1,'393',1,0,0,0,0,'2020-12-18 15:36:54',NULL,0),
	(89,35,'product',1,'393',1,0,0,0,0,'2020-12-18 15:37:04',NULL,0),
	(90,35,'product',7,'308',1,0,0,0,0,'2020-12-18 15:37:30',NULL,0),
	(93,33,'product',3,'211',1,1,0,0,0,'2020-12-18 15:53:36',NULL,0),
	(95,34,'product',7,'308',1,1,0,0,0,'2020-12-18 16:14:06',NULL,0),
	(97,35,'product',7,'308',1,1,0,0,0,'2020-12-18 16:18:39',NULL,0),
	(101,32,'product',1,'393',1,1,0,0,0,'2020-12-18 16:55:17',NULL,0),
	(103,31,'product',10,'309',2,0,0,0,0,'2020-12-21 12:14:13',NULL,1),
	(107,36,'product',10,'309',1,1,0,0,0,'2020-12-21 15:26:15',NULL,1),
	(109,33,'product',10,'309',1,1,0,0,0,'2020-12-21 15:34:15',NULL,1),
	(111,33,'product',1,'393',1,0,0,0,0,'2020-12-21 15:44:06',NULL,0),
	(117,44,'product',9,'373',1,1,0,0,0,'2020-12-21 17:28:53',NULL,1),
	(118,44,'product',9,'373',1,1,0,0,0,'2020-12-21 17:34:08',NULL,1),
	(119,44,'product',2,'207',2,1,0,0,0,'2020-12-21 17:34:28',NULL,0),
	(120,44,'product',9,'349',1,1,0,0,0,'2020-12-21 17:36:18',NULL,1),
	(122,44,'product',9,'373',1,1,0,0,0,'2020-12-21 17:40:59',NULL,1),
	(124,44,'product',9,'373',1,1,0,0,0,'2020-12-21 17:45:38',NULL,1),
	(125,44,'product',9,'373',1,1,0,0,0,'2020-12-21 17:48:26',NULL,1),
	(127,44,'product',6,'221',1,1,0,0,0,'2020-12-21 17:52:05',NULL,0),
	(137,52,'product',17,'839',1,1,0,0,0,'2020-12-22 15:47:09',NULL,0),
	(139,57,'product',15,'847',1,1,0,0,0,'2020-12-22 15:50:04',NULL,0),
	(140,32,'product',15,'847',1,1,0,0,0,'2020-12-22 15:57:54',NULL,0),
	(142,57,'product',15,'847',1,1,0,0,0,'2020-12-22 16:37:13',NULL,0),
	(144,52,'product',15,'847',2,1,0,0,0,'2020-12-22 16:39:23',NULL,0),
	(145,52,'product',15,'848',2,1,0,0,0,'2020-12-22 16:39:29',NULL,0),
	(146,32,'product',1,'393',1,1,0,0,0,'2020-12-22 16:44:16',NULL,0),
	(148,32,'product',7,'308',1,1,0,0,0,'2020-12-22 16:48:28',NULL,0),
	(149,32,'product',7,'308',1,1,0,0,0,'2020-12-22 16:48:55',NULL,0),
	(150,32,'product',7,'308',1,1,0,0,0,'2020-12-22 16:49:24',NULL,0),
	(151,32,'product',1,'393',1,1,0,0,0,'2020-12-22 17:03:09',NULL,0),
	(153,63,'product',10,'309',1,1,0,0,0,'2020-12-22 21:02:28',NULL,1),
	(154,63,'product',10,'309',1,1,0,0,0,'2020-12-22 21:03:02',NULL,1),
	(156,52,'product',15,'845',1,1,0,0,0,'2020-12-23 09:32:39',NULL,0),
	(157,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:33:22',NULL,0),
	(158,52,'product',15,'848',1,1,0,0,0,'2020-12-23 09:34:01',NULL,0),
	(159,52,'product',15,'848',1,1,0,0,0,'2020-12-23 09:34:07',NULL,0),
	(160,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:35:06',NULL,0),
	(161,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:35:17',NULL,0),
	(162,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:35:38',NULL,0),
	(163,57,'product',15,'848',1,1,0,0,0,'2020-12-23 09:36:01',NULL,0),
	(164,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:38:51',NULL,0),
	(165,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:38:54',NULL,0),
	(166,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:38:57',NULL,0),
	(167,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:45:09',NULL,0),
	(168,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:45:19',NULL,0),
	(169,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:45:45',NULL,0),
	(170,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:45:52',NULL,0),
	(171,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:46:02',NULL,0),
	(172,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:46:06',NULL,0),
	(173,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:47:11',NULL,0),
	(176,52,'product',15,'1319',2,1,0,0,0,'2020-12-23 10:05:56',NULL,0),
	(177,52,'product',15,'1319',3,1,0,0,0,'2020-12-23 10:06:30',NULL,0),
	(179,33,'product',1,'393',1,1,0,0,0,'2020-12-23 10:07:17',NULL,0),
	(182,65,'product',10,'309',1,1,0,0,0,'2020-12-23 10:23:25',NULL,1),
	(188,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 11:03:08',NULL,0),
	(194,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 11:42:38',NULL,0),
	(195,57,'product',15,'1319',1,1,0,0,0,'2020-12-23 11:42:56',NULL,0),
	(198,35,'product',20,'1271',1,1,0,0,0,'2020-12-23 12:02:35',NULL,1),
	(202,23,'product',1,'397',1,1,0,0,0,'2020-12-23 15:02:01',NULL,0),
	(203,52,'product',17,'839',1,1,0,0,0,'2020-12-23 15:09:26',NULL,0),
	(204,23,'product',17,'839',1,1,0,0,0,'2020-12-23 15:15:03',NULL,0),
	(205,23,'product',17,'839',1,1,0,0,0,'2020-12-23 15:16:29',NULL,0),
	(206,23,'product',1,'397',1,1,0,0,0,'2020-12-23 15:17:53',NULL,0),
	(207,57,'product',15,'1319',19,1,0,0,0,'2020-12-23 16:50:10',NULL,0),
	(208,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 16:54:51',NULL,0),
	(209,52,'product',17,'839',1,1,0,0,0,'2020-12-23 16:59:23',NULL,0),
	(210,52,'product',17,'839',1,1,0,0,0,'2020-12-23 16:59:33',NULL,0),
	(211,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 17:00:50',NULL,0),
	(212,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 17:03:52',NULL,0),
	(213,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 17:04:14',NULL,0),
	(214,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 17:06:13',NULL,0),
	(215,57,'product',15,'1319',1,1,0,0,0,'2020-12-23 17:07:32',NULL,0),
	(216,52,'product',17,'839',1,1,0,0,0,'2020-12-23 17:11:17',NULL,0),
	(217,52,'product',17,'839',1,1,0,0,0,'2020-12-23 17:15:57',NULL,0),
	(218,52,'product',17,'839',1,1,0,0,0,'2020-12-23 17:16:11',NULL,0),
	(219,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 17:16:37',NULL,0),
	(220,52,'product',15,'1319',2,1,0,0,0,'2020-12-23 17:16:54',NULL,0),
	(223,52,'product',19,'906',1,1,0,0,0,'2020-12-23 17:19:53',NULL,0),
	(224,52,'product',15,'1319',2,1,0,0,0,'2020-12-23 17:20:11',NULL,0),
	(225,71,'product',17,'839',6,0,0,0,0,'2020-12-23 17:21:38',NULL,0),
	(226,32,'product',17,'839',1,1,0,0,0,'2020-12-23 17:23:12',NULL,0),
	(227,32,'product',1,'397',1,1,0,0,0,'2020-12-23 17:23:54',NULL,0),
	(228,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 17:33:30',NULL,0),
	(230,75,'product',7,'308',1,1,0,0,0,'2020-12-23 17:34:40',NULL,0),
	(231,52,'product',17,'839',1,1,0,0,0,'2020-12-23 17:35:08',NULL,0),
	(233,74,'product',10,'309',1,1,0,0,0,'2020-12-23 17:38:29',NULL,1),
	(234,74,'product',10,'309',1,1,0,0,0,'2020-12-23 17:38:30',NULL,1),
	(235,32,'product',17,'839',1,1,0,0,0,'2020-12-23 17:39:34',NULL,0),
	(237,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 17:44:31',NULL,0),
	(238,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 17:55:41',NULL,0),
	(239,52,'product',17,'839',1,1,0,0,0,'2020-12-23 17:55:59',NULL,0),
	(240,52,'product',17,'839',1,1,0,0,0,'2020-12-23 17:57:50',NULL,0),
	(241,52,'product',17,'839',1,1,0,0,0,'2020-12-23 17:58:04',NULL,0),
	(243,52,'product',1,'397',1,1,0,0,0,'2020-12-23 17:59:30',NULL,0),
	(244,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 18:01:20',NULL,0),
	(245,52,'product',19,'906',1,1,0,0,0,'2020-12-23 18:01:45',NULL,0),
	(246,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 18:04:39',NULL,0),
	(247,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 18:06:38',NULL,0),
	(248,98,'product',17,'839',1,0,0,0,0,'2020-12-23 18:13:14',NULL,0),
	(249,99,'product',10,'309',1,1,0,0,0,'2020-12-23 18:15:41',NULL,1),
	(250,99,'product',10,'309',1,1,0,0,0,'2020-12-23 18:15:41',NULL,1),
	(251,99,'product',10,'309',1,1,0,0,0,'2020-12-23 18:15:41',NULL,1),
	(252,99,'product',10,'309',1,1,0,0,0,'2020-12-23 18:15:41',NULL,1),
	(253,32,'product',1,'397',1,1,0,0,0,'2020-12-23 18:18:22',NULL,0),
	(254,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 18:29:25',NULL,0),
	(255,130,'product',1,'397',1,1,0,0,0,'2020-12-23 21:37:52',NULL,0),
	(257,140,'product',10,'309',1,1,0,0,0,'2020-12-24 01:47:04',NULL,1),
	(258,140,'product',10,'309',1,1,0,0,0,'2020-12-24 01:47:04',NULL,1),
	(259,144,'product',17,'839',1,1,0,0,0,'2020-12-24 04:19:50',NULL,0),
	(260,144,'product',17,'839',1,1,0,0,0,'2020-12-24 04:19:51',NULL,0),
	(261,144,'product',17,'839',1,1,0,0,0,'2020-12-24 04:19:51',NULL,0),
	(262,144,'product',17,'839',1,1,0,0,0,'2020-12-24 04:19:52',NULL,0),
	(263,144,'product',17,'839',1,1,0,0,0,'2020-12-24 04:19:53',NULL,0),
	(264,144,'product',17,'839',3,0,0,0,0,'2020-12-24 04:19:53',NULL,0),
	(265,144,'product',17,'839',1,1,0,0,0,'2020-12-24 04:19:55',NULL,0),
	(266,144,'product',17,'839',1,1,0,0,0,'2020-12-24 04:19:57',NULL,0),
	(267,145,'product',14,'922',1,0,0,0,0,'2020-12-24 04:45:58',NULL,0),
	(268,32,'product',2,'207',1,1,0,0,0,'2020-12-24 09:14:16',NULL,0),
	(270,32,'product',17,'839',1,1,0,0,0,'2020-12-24 09:24:04',NULL,0),
	(272,157,'product',17,'839',1,1,0,0,0,'2020-12-24 09:31:19',NULL,0),
	(273,32,'product',1,'397',1,1,0,0,0,'2020-12-24 09:32:11',NULL,0),
	(275,32,'product',13,'489',1,1,0,0,0,'2020-12-24 09:43:21',NULL,1),
	(276,32,'product',13,'489',1,1,0,0,0,'2020-12-24 10:01:59',NULL,1),
	(280,159,'product',17,'839',1,1,0,0,0,'2020-12-24 15:56:38',NULL,0),
	(281,173,'product',15,'1318',1,1,0,0,0,'2020-12-24 16:00:12',NULL,0),
	(282,179,'product',10,'309',1,1,0,0,0,'2020-12-24 17:16:25',NULL,1),
	(283,179,'product',17,'839',1,0,0,0,0,'2020-12-24 17:18:41',NULL,0),
	(284,183,'product',15,'1319',1,1,0,0,0,'2020-12-24 19:18:45',NULL,0),
	(285,184,'product',1,'397',1,1,0,0,0,'2020-12-24 19:22:56',NULL,0),
	(286,184,'product',10,'309',1,1,0,0,0,'2020-12-24 19:24:59',NULL,1),
	(287,185,'product',15,'1319',1,1,0,0,0,'2020-12-24 21:40:28',NULL,0),
	(289,199,'product',15,'1319',1,1,0,0,0,'2020-12-25 09:26:16',NULL,0),
	(295,222,'product',17,'839',1,1,0,0,0,'2020-12-25 22:39:27',NULL,0),
	(296,222,'product',15,'1319',1,1,0,0,0,'2020-12-25 22:40:36',NULL,0),
	(297,227,'product',17,'839',1,1,0,0,0,'2020-12-26 09:37:17',NULL,0),
	(298,230,'product',17,'839',1,1,0,0,0,'2020-12-26 09:41:09',NULL,0),
	(299,230,'product',17,'839',1,1,0,0,0,'2020-12-26 09:42:32',NULL,0),
	(301,227,'product',10,'309',1,1,0,0,0,'2020-12-26 09:55:26',NULL,1),
	(302,230,'product',1,'397',1,1,0,0,0,'2020-12-26 10:06:11',NULL,0),
	(303,222,'product',17,'839',1,1,0,0,0,'2020-12-26 11:42:23',NULL,0),
	(304,222,'product',17,'839',1,1,0,0,0,'2020-12-26 11:45:12',NULL,0),
	(305,44,'product',9,'1418',1,1,0,0,0,'2020-12-26 12:30:38',NULL,1),
	(307,239,'product',17,'839',1,1,0,0,0,'2020-12-26 15:27:01',NULL,0),
	(308,240,'product',17,'839',1,1,0,0,0,'2020-12-26 16:49:54',NULL,0),
	(314,249,'product',15,'1319',1,1,0,0,0,'2020-12-27 17:08:07',NULL,0),
	(315,78,'product',10,'309',1,1,0,0,0,'2020-12-27 20:49:05',NULL,1),
	(316,215,'product',1,'417',1,0,0,0,0,'2020-12-28 10:40:55',NULL,0),
	(317,253,'product',1,'397',1,0,0,0,0,'2020-12-28 11:42:47',NULL,0),
	(318,255,'product',17,'839',1,1,0,0,0,'2020-12-28 11:55:21',NULL,0),
	(319,256,'product',14,'922',1,1,0,0,0,'2020-12-28 12:32:23',NULL,0),
	(320,256,'product',1,'397',1,1,0,0,0,'2020-12-28 12:36:39',NULL,0),
	(321,257,'product',15,'1319',1,1,0,0,0,'2020-12-28 13:33:07',NULL,0),
	(322,257,'product',10,'309',1,1,0,0,0,'2020-12-28 13:35:47',NULL,1),
	(323,257,'product',10,'309',1,1,0,0,0,'2020-12-28 13:35:47',NULL,1),
	(324,257,'product',1,'397',1,1,0,0,0,'2020-12-28 13:36:44',NULL,0),
	(326,44,'product',1,'397',1,1,0,0,0,'2020-12-28 16:27:10',NULL,0),
	(327,44,'product',1,'397',1,1,0,0,0,'2020-12-28 16:30:47',NULL,0),
	(328,44,'product',1,'397',1,1,0,0,0,'2020-12-28 16:39:27',NULL,0),
	(329,44,'product',20,'1271',1,1,0,0,0,'2020-12-28 16:49:52',NULL,1),
	(330,254,'product',1,'401',1,0,0,0,0,'2020-12-28 17:19:47',NULL,0),
	(331,46,'product',20,'1271',1,1,0,0,0,'2020-12-28 17:35:01',NULL,1),
	(332,46,'product',20,'1124',1,1,0,0,0,'2020-12-28 17:39:42',NULL,1),
	(334,46,'product',20,'1124',1,1,0,0,0,'2020-12-28 17:49:08',NULL,1),
	(343,207,'product',1,'421',1,0,0,0,0,'2020-12-28 18:06:59',NULL,0),
	(345,262,'product',17,'839',1,1,0,0,0,'2020-12-28 18:17:55',NULL,0),
	(346,262,'product',17,'839',1,1,0,0,0,'2020-12-28 18:18:00',NULL,0),
	(347,262,'product',17,'839',1,1,0,0,0,'2020-12-28 18:18:41',NULL,0),
	(348,262,'product',17,'839',1,1,0,0,0,'2020-12-28 18:18:47',NULL,0),
	(349,262,'product',17,'842',1,1,0,0,0,'2020-12-28 18:24:02',NULL,0),
	(350,262,'product',17,'842',1,1,0,0,0,'2020-12-28 18:24:07',NULL,0),
	(351,262,'product',17,'842',1,1,0,0,0,'2020-12-28 18:24:12',NULL,0),
	(352,256,'product',1,'397',1,0,0,0,0,'2020-12-28 23:47:53',NULL,0),
	(353,256,'product',1,'385',1,0,0,0,0,'2020-12-28 23:47:56',NULL,0),
	(354,256,'product',10,'309',1,1,0,0,0,'2020-12-28 23:48:21',NULL,1),
	(355,256,'product',15,'1319',1,1,0,0,0,'2020-12-28 23:48:41',NULL,0),
	(356,256,'product',15,'1319',1,1,0,0,0,'2020-12-28 23:48:45',NULL,0),
	(357,256,'product',17,'839',1,1,0,0,0,'2020-12-28 23:49:12',NULL,0),
	(358,256,'product',17,'839',1,1,0,0,0,'2020-12-28 23:49:18',NULL,0),
	(359,256,'product',20,'1582',1,1,0,0,0,'2020-12-28 23:49:55',NULL,1),
	(360,256,'product',20,'1582',1,1,0,0,0,'2020-12-28 23:50:00',NULL,1),
	(361,256,'product',17,'839',1,1,0,0,0,'2020-12-28 23:52:36',NULL,0),
	(362,256,'product',17,'839',1,1,0,0,0,'2020-12-28 23:53:05',NULL,0),
	(399,215,'product',17,'839',1,0,0,0,0,'2020-12-29 13:42:36',NULL,0),
	(402,36,'product',17,'839',1,1,0,0,0,'2020-12-29 15:29:45',NULL,0),
	(403,36,'product',15,'1319',1,1,0,0,0,'2020-12-29 15:29:54',NULL,0),
	(415,215,'product',9,'1418',1,0,0,0,0,'2020-12-29 17:24:55',NULL,1),
	(425,33,'product',17,'839',1,1,0,0,0,'2020-12-29 18:13:30',NULL,0),
	(427,46,'product',17,'839',1,1,0,0,0,'2020-12-29 18:14:02',NULL,0),
	(428,33,'product',15,'1319',1,1,0,0,0,'2020-12-29 18:14:19',NULL,0),
	(429,46,'product',17,'839',1,1,0,0,0,'2020-12-29 18:14:25',NULL,0),
	(430,46,'product',1,'397',1,1,0,0,0,'2020-12-29 18:14:36',NULL,0),
	(431,46,'product',1,'397',1,1,0,0,0,'2020-12-29 18:15:29',NULL,0),
	(432,33,'product',15,'1319',1,1,0,0,0,'2020-12-29 18:16:12',NULL,0),
	(433,46,'product',1,'397',1,1,0,0,0,'2020-12-29 18:16:38',NULL,0),
	(434,33,'product',15,'1319',1,1,0,0,0,'2020-12-29 18:16:48',NULL,0),
	(435,46,'product',1,'397',1,1,0,0,0,'2020-12-29 18:16:57',NULL,0),
	(436,46,'product',17,'839',1,1,0,0,0,'2020-12-29 18:17:18',NULL,0),
	(437,33,'product',15,'1319',1,1,0,0,0,'2020-12-29 18:17:23',NULL,0),
	(438,46,'product',17,'839',1,1,0,0,0,'2020-12-29 18:18:37',NULL,0),
	(439,33,'product',15,'1319',1,1,0,0,0,'2020-12-29 18:19:10',NULL,0),
	(440,33,'product',10,'309',1,1,0,0,0,'2020-12-29 18:19:50',NULL,1),
	(445,33,'product',15,'1319',1,1,0,0,0,'2020-12-29 18:32:43',NULL,0),
	(457,273,'product',17,'839',1,1,0,0,0,'2020-12-29 22:37:31',NULL,0),
	(458,273,'product',17,'839',1,1,0,0,0,'2020-12-29 22:37:36',NULL,0),
	(459,273,'product',17,'839',1,1,0,0,0,'2020-12-29 22:37:40',NULL,0),
	(460,273,'product',17,'839',1,1,0,0,0,'2020-12-29 22:37:44',NULL,0),
	(461,273,'product',17,'839',1,1,0,0,0,'2020-12-29 22:37:48',NULL,0),
	(462,273,'product',15,'1319',1,1,0,0,0,'2020-12-29 22:37:59',NULL,0),
	(463,273,'product',15,'1326',2,1,0,0,0,'2020-12-29 22:38:53',NULL,0),
	(464,273,'product',1,'385',1,0,0,0,0,'2020-12-29 22:39:01',NULL,0),
	(466,275,'product',15,'1319',1,1,0,0,0,'2020-12-30 09:19:50',NULL,0),
	(468,33,'product',15,'1319',1,1,0,0,0,'2020-12-30 09:26:56',NULL,0),
	(469,33,'product',15,'1319',1,1,0,0,0,'2020-12-30 09:27:47',NULL,0),
	(470,33,'product',15,'1319',1,1,0,0,0,'2020-12-30 09:31:15',NULL,0),
	(472,33,'product',15,'1319',1,1,0,0,0,'2020-12-30 10:53:35',NULL,0),
	(473,36,'product',15,'1319',1,1,0,0,0,'2020-12-30 11:06:46',NULL,0),
	(484,283,'product',17,'839',1,1,0,0,0,'2020-12-30 15:35:13',NULL,0),
	(485,283,'product',17,'839',1,0,0,0,0,'2020-12-30 15:35:13',NULL,0),
	(486,283,'product',17,'839',1,1,0,0,0,'2020-12-30 15:35:14',NULL,0),
	(487,283,'product',17,'839',1,1,0,0,0,'2020-12-30 15:35:14',NULL,0),
	(488,283,'product',17,'839',1,1,0,0,0,'2020-12-30 15:35:17',NULL,0),
	(489,283,'product',17,'839',1,1,0,0,0,'2020-12-30 15:35:42',NULL,0),
	(490,283,'product',17,'839',1,1,0,0,0,'2020-12-30 15:35:42',NULL,0),
	(491,283,'product',17,'839',1,1,0,0,0,'2020-12-30 15:35:42',NULL,0),
	(492,283,'product',17,'839',1,1,0,0,0,'2020-12-30 15:35:42',NULL,0),
	(493,283,'product',17,'839',1,1,0,0,0,'2020-12-30 15:35:42',NULL,0),
	(494,283,'product',17,'839',1,1,0,0,0,'2020-12-30 15:35:42',NULL,0),
	(495,283,'product',17,'839',1,1,0,0,0,'2020-12-30 15:35:43',NULL,0),
	(499,46,'product',20,'1435',1,1,0,0,0,'2020-12-30 15:59:33',NULL,1),
	(502,285,'product',10,'309',1,0,0,0,0,'2020-12-30 20:14:01',NULL,1),
	(509,316,'product',10,'309',1,1,0,0,0,'2021-01-01 11:13:59',NULL,1),
	(510,322,'product',1,'388',1,1,0,0,0,'2021-01-02 12:16:04',NULL,0),
	(511,322,'product',7,'308',1,1,0,0,0,'2021-01-02 12:16:11',NULL,0),
	(512,322,'product',17,'839',1,0,0,0,0,'2021-01-02 12:16:30',NULL,0),
	(513,31,'product',17,'839',1,1,0,0,0,'2021-01-04 10:43:25',NULL,0),
	(514,31,'product',17,'839',1,1,0,0,0,'2021-01-04 11:11:21',NULL,0),
	(515,31,'product',17,'839',1,1,0,0,0,'2021-01-04 11:57:03',NULL,0),
	(516,335,'product',15,'1319',1,0,0,0,0,'2021-01-04 14:46:26',NULL,0),
	(517,215,'product',17,'839',1,1,0,0,0,'2021-01-04 17:03:10',NULL,0),
	(518,345,'product',15,'1319',1,1,0,0,0,'2021-01-04 19:36:57',NULL,0),
	(519,345,'product',15,'1319',1,0,0,0,0,'2021-01-04 19:38:02',NULL,0),
	(520,345,'product',15,'1319',1,1,0,0,0,'2021-01-04 19:38:02',NULL,0),
	(521,345,'product',15,'1319',1,1,0,0,0,'2021-01-04 19:38:05',NULL,0),
	(522,345,'product',15,'1319',1,1,0,0,0,'2021-01-04 19:38:05',NULL,0),
	(523,345,'product',15,'1319',1,1,0,0,0,'2021-01-04 19:38:06',NULL,0),
	(524,345,'product',15,'1319',1,1,0,0,0,'2021-01-04 19:38:06',NULL,0),
	(525,345,'product',15,'1319',1,1,0,0,0,'2021-01-04 19:38:07',NULL,0),
	(526,345,'product',15,'1319',1,1,0,0,0,'2021-01-04 19:38:07',NULL,0),
	(527,345,'product',15,'1319',1,1,0,0,0,'2021-01-04 19:38:07',NULL,0),
	(528,346,'product',17,'839',1,1,0,0,0,'2021-01-04 21:57:45',NULL,0),
	(529,346,'product',17,'839',1,1,0,0,0,'2021-01-04 21:57:45',NULL,0),
	(530,346,'product',17,'839',1,1,0,0,0,'2021-01-04 21:57:46',NULL,0),
	(531,346,'product',17,'839',1,1,0,0,0,'2021-01-04 21:57:52',NULL,0),
	(532,346,'product',17,'839',1,1,0,0,0,'2021-01-04 21:57:52',NULL,0),
	(533,33,'product',17,'839',1,1,0,0,0,'2021-01-05 12:32:55',NULL,0),
	(534,159,'product',17,'838',3,0,0,0,0,'2021-01-05 14:07:28',NULL,0),
	(535,37,'product',17,'842',1,1,0,0,0,'2021-01-05 15:51:03',NULL,0),
	(538,159,'product',17,'841',1,0,0,0,0,'2021-01-05 16:39:09',NULL,0),
	(539,159,'product',17,'839',1,0,0,0,0,'2021-01-05 16:45:35',NULL,0),
	(540,36,'product',20,'1778',1,1,0,0,0,'2021-01-05 17:08:04',NULL,1),
	(541,36,'product',20,'1690',1,1,0,0,0,'2021-01-05 17:08:44',NULL,1),
	(542,36,'product',1,'385',1,1,0,0,0,'2021-01-05 17:08:54',NULL,0),
	(543,36,'product',1,'385',1,1,0,0,0,'2021-01-05 17:09:10',NULL,0),
	(544,36,'product',20,'1658',1,1,0,0,0,'2021-01-05 17:22:35',NULL,1),
	(545,36,'product',10,'309',1,1,0,0,0,'2021-01-05 17:23:19',NULL,1),
	(546,36,'product',20,'1778',1,1,0,0,0,'2021-01-05 17:24:54',NULL,1),
	(547,36,'product',20,'1778',1,1,0,0,0,'2021-01-05 17:26:43',NULL,1),
	(550,36,'product',1,'385',1,1,0,0,0,'2021-01-05 17:35:07',NULL,0),
	(551,36,'product',1,'385',1,1,0,0,0,'2021-01-05 17:35:21',NULL,0),
	(552,46,'product',17,'839',1,1,0,0,0,'2021-01-05 17:37:30',NULL,0),
	(553,23,'product',17,'839',1,1,0,0,0,'2021-01-05 17:38:21',NULL,0),
	(554,23,'product',17,'839',1,1,0,0,0,'2021-01-05 17:40:08',NULL,0),
	(555,23,'product',17,'839',1,1,0,0,0,'2021-01-05 17:45:25',NULL,0),
	(556,23,'product',17,'839',1,1,0,0,0,'2021-01-05 17:51:20',NULL,0),
	(557,37,'product',15,'1319',1,1,0,0,0,'2021-01-05 18:09:05',NULL,0),
	(558,356,'product',10,'309',1,1,0,0,0,'2021-01-06 15:41:15',NULL,1),
	(559,356,'product',10,'309',1,0,0,0,0,'2021-01-06 15:41:22',NULL,1),
	(560,357,'product',20,'1778',1,1,0,0,0,'2021-01-06 16:12:01',NULL,1),
	(561,357,'product',20,'1778',1,1,0,0,0,'2021-01-06 16:12:01',NULL,1),
	(562,357,'product',20,'1778',1,1,0,0,0,'2021-01-06 16:12:06',NULL,1),
	(563,357,'product',20,'1818',1,1,0,0,0,'2021-01-06 16:12:13',NULL,1),
	(564,360,'product',17,'839',1,1,0,0,0,'2021-01-07 08:37:38',NULL,0),
	(565,360,'product',17,'839',1,1,0,0,0,'2021-01-07 08:37:43',NULL,0),
	(566,360,'product',17,'839',1,1,0,0,0,'2021-01-07 08:37:49',NULL,0),
	(567,361,'product',17,'839',1,1,0,0,0,'2021-01-07 10:35:17',NULL,0),
	(568,361,'product',17,'839',1,1,0,0,0,'2021-01-07 10:35:22',NULL,0),
	(570,33,'product',17,'839',1,1,0,0,0,'2021-01-07 10:38:37',NULL,0),
	(571,33,'product',17,'839',1,1,0,0,0,'2021-01-07 11:05:57',NULL,0),
	(574,37,'product',17,'839',1,1,0,0,0,'2021-01-07 14:54:10',NULL,0),
	(575,37,'product',17,'839',1,1,0,0,0,'2021-01-07 14:54:45',NULL,0),
	(576,37,'product',15,'1319',1,0,0,0,0,'2021-01-07 15:12:03',NULL,0),
	(578,364,'product',17,'839',1,1,0,0,0,'2021-01-07 15:58:14',NULL,0),
	(579,36,'product',10,'309',1,1,0,0,0,'2021-01-07 15:59:39',NULL,1),
	(584,349,'product',10,'309',1,1,0,0,0,'2021-01-07 16:54:53',NULL,1),
	(585,349,'product',10,'309',1,1,0,0,0,'2021-01-07 16:55:09',NULL,1),
	(586,37,'product',17,'839',1,1,0,0,0,'2021-01-07 17:59:58',NULL,0),
	(587,37,'product',17,'839',1,1,0,0,0,'2021-01-07 18:00:25',NULL,0),
	(588,37,'product',17,'1830',1,1,0,0,0,'2021-01-07 18:41:02',NULL,0),
	(589,37,'product',17,'1830',1,1,0,0,0,'2021-01-07 18:41:35',NULL,0),
	(590,37,'product',15,'1319',1,1,0,0,0,'2021-01-07 18:42:27',NULL,0),
	(591,37,'product',17,'1835',1,1,0,0,0,'2021-01-07 18:42:44',NULL,0),
	(592,37,'product',17,'1835',1,1,0,0,0,'2021-01-07 18:43:09',NULL,0),
	(593,37,'product',17,'1840',1,1,0,0,0,'2021-01-07 19:19:37',NULL,0),
	(594,37,'product',17,'1840',1,1,0,0,0,'2021-01-07 19:23:14',NULL,0),
	(595,37,'product',17,'1840',1,1,0,0,0,'2021-01-07 19:40:20',NULL,0),
	(596,37,'product',17,'1840',1,1,0,0,0,'2021-01-07 19:41:08',NULL,0),
	(597,44,'product',17,'1840',1,1,0,0,0,'2021-01-08 09:58:46',NULL,0),
	(598,44,'product',17,'1840',1,1,0,0,0,'2021-01-08 09:58:59',NULL,0),
	(599,44,'product',17,'1840',1,1,0,0,0,'2021-01-08 11:23:19',NULL,0),
	(600,44,'product',17,'1840',1,1,0,0,0,'2021-01-08 11:29:22',NULL,0),
	(601,33,'product',15,'1319',1,1,0,0,0,'2021-01-08 11:38:44',NULL,0),
	(605,44,'product',17,'1840',1,1,0,0,0,'2021-01-09 11:37:36',NULL,0),
	(609,44,'product',1,'388',1,1,0,0,0,'2021-01-09 17:33:18',NULL,0),
	(611,36,'product',15,'1319',1,1,0,0,0,'2021-01-11 10:56:44',NULL,0),
	(612,36,'product',15,'1319',1,1,0,0,0,'2021-01-11 10:57:17',NULL,0),
	(613,36,'product',1,'388',1,1,0,0,0,'2021-01-11 11:06:46',NULL,0),
	(614,36,'product',20,'1778',1,1,0,0,0,'2021-01-11 11:07:00',NULL,1),
	(615,36,'product',20,'1778',1,1,0,0,0,'2021-01-11 11:07:06',NULL,1),
	(616,33,'product',17,'1855',1,1,0,0,0,'2021-01-11 11:15:12',NULL,0),
	(617,33,'product',15,'1319',1,1,0,0,0,'2021-01-11 14:41:14',NULL,0),
	(618,33,'product',15,'1319',1,1,0,0,0,'2021-01-11 14:52:27',NULL,0),
	(619,33,'product',15,'1319',1,1,0,0,0,'2021-01-11 14:52:51',NULL,0),
	(620,33,'product',15,'1319',1,1,0,0,0,'2021-01-11 14:53:33',NULL,0),
	(621,36,'product',15,'1319',1,1,0,0,0,'2021-01-11 15:36:12',NULL,0),
	(622,23,'product',20,'1778',1,1,0,0,0,'2021-01-11 15:37:42',NULL,1),
	(623,36,'product',1,'385',1,1,0,0,0,'2021-01-12 09:51:21',NULL,0),
	(624,36,'product',15,'1319',1,1,0,0,0,'2021-01-12 09:54:05',NULL,0),
	(625,371,'product',10,'309',1,1,0,0,0,'2021-01-12 10:17:23',NULL,1),
	(626,371,'product',10,'309',1,1,0,0,0,'2021-01-12 10:17:35',NULL,1),
	(628,23,'product',17,'1855',1,1,0,0,0,'2021-01-12 10:24:36',NULL,0),
	(629,44,'product',17,'1855',1,1,0,0,0,'2021-01-12 10:30:34',NULL,0),
	(630,37,'product',17,'1855',1,1,0,0,0,'2021-01-12 11:33:35',NULL,0),
	(632,375,'product',10,'309',1,1,0,0,0,'2021-01-12 17:12:51',NULL,1),
	(633,375,'product',10,'309',1,1,0,0,0,'2021-01-12 17:12:55',NULL,1),
	(634,375,'product',10,'309',1,1,0,0,0,'2021-01-12 17:13:01',NULL,1),
	(635,375,'product',10,'309',1,1,0,0,0,'2021-01-12 17:13:05',NULL,1),
	(636,375,'product',20,'1778',1,1,0,0,0,'2021-01-12 17:13:52',NULL,1),
	(637,375,'product',20,'1778',1,1,0,0,0,'2021-01-12 17:13:56',NULL,1),
	(638,375,'product',22,'1123',1,1,0,0,0,'2021-01-12 17:32:28',NULL,1),
	(639,375,'product',22,'1123',1,1,0,0,0,'2021-01-12 17:32:33',NULL,1),
	(640,375,'product',22,'1123',1,1,0,0,0,'2021-01-12 17:32:38',NULL,1),
	(641,375,'product',22,'1123',1,1,0,0,0,'2021-01-12 17:32:47',NULL,1),
	(642,375,'product',22,'1123',1,1,0,0,0,'2021-01-12 17:32:52',NULL,1),
	(643,375,'product',22,'1123',1,1,0,0,0,'2021-01-12 17:33:04',NULL,1),
	(644,375,'product',22,'1123',1,1,0,0,0,'2021-01-12 17:33:23',NULL,1),
	(645,375,'product',20,'1810',10,1,0,0,0,'2021-01-12 18:03:22',NULL,1),
	(647,375,'product',20,'1778',1,1,0,0,0,'2021-01-12 18:03:58',NULL,1),
	(648,375,'product',15,'1319',3,0,0,0,0,'2021-01-12 18:11:17',NULL,0),
	(649,375,'product',20,'1778',1,0,0,0,0,'2021-01-12 18:12:12',NULL,1),
	(650,375,'product',9,'1395',1,0,0,0,0,'2021-01-12 18:42:08',NULL,1),
	(652,375,'product',17,'1854',1,1,0,0,0,'2021-01-13 09:39:42',NULL,0),
	(653,375,'product',17,'1854',1,0,0,0,0,'2021-01-13 09:39:46',NULL,0),
	(654,375,'product',15,'1319',1,1,0,0,0,'2021-01-13 09:54:23',NULL,0),
	(655,375,'product',15,'1319',1,1,0,0,0,'2021-01-13 09:54:31',NULL,0),
	(657,375,'product',20,'1778',1,1,0,0,0,'2021-01-13 14:35:08',NULL,1),
	(660,32,'product',17,'1855',1,1,0,0,0,'2021-01-14 10:45:20',NULL,0),
	(672,52,'product',17,'1915',1,1,0,0,0,'2021-01-14 15:25:10',NULL,0),
	(673,52,'product',17,'1915',1,1,0,0,0,'2021-01-14 15:26:12',NULL,0),
	(674,52,'product',17,'1915',1,1,0,0,0,'2021-01-14 15:27:12',NULL,0),
	(675,52,'product',17,'1915',1,1,0,0,0,'2021-01-14 15:27:20',NULL,0),
	(677,52,'product',17,'1921',1,1,0,0,0,'2021-01-14 15:28:38',NULL,0),
	(680,44,'product',15,'1319',2,0,0,0,0,'2021-01-14 15:36:28',NULL,0),
	(682,52,'product',17,'1921',1,1,0,0,0,'2021-01-15 09:12:13',NULL,0),
	(684,32,'product',15,'1319',1,1,0,0,0,'2021-01-15 09:19:21',NULL,0),
	(685,32,'product',15,'1319',1,1,0,0,0,'2021-01-15 09:19:25',NULL,0),
	(689,57,'product',28,'1963',1,1,0,0,0,'2021-01-15 10:02:40',NULL,1),
	(690,57,'product',28,'1963',1,1,0,0,0,'2021-01-15 10:02:49',NULL,1),
	(691,57,'product',28,'1963',1,1,0,0,0,'2021-01-15 10:02:57',NULL,1),
	(696,57,'product',28,'1963',1,1,0,0,0,'2021-01-15 10:10:22',NULL,1),
	(697,57,'product',28,'1963',1,1,0,0,0,'2021-01-15 10:11:20',NULL,1),
	(700,32,'product',17,'1921',1,1,0,0,0,'2021-01-15 10:19:30',NULL,0),
	(705,23,'product',15,'1319',1,1,0,0,0,'2021-01-15 11:03:17',NULL,0),
	(706,23,'product',15,'1319',1,1,0,0,0,'2021-01-15 11:03:23',NULL,0),
	(709,52,'product',15,'1319',1,1,0,0,0,'2021-01-15 11:07:05',NULL,0),
	(710,52,'product',15,'1319',1,1,0,0,0,'2021-01-15 11:07:15',NULL,0),
	(713,23,'product',26,'1919',1,1,0,0,0,'2021-01-15 11:10:25',NULL,1),
	(715,52,'product',26,'1919',1,1,0,0,0,'2021-01-15 11:13:29',NULL,1),
	(716,52,'product',26,'1919',2,1,0,0,0,'2021-01-15 11:13:39',NULL,1),
	(718,52,'product',26,'1919',2,1,0,0,0,'2021-01-15 11:15:11',NULL,1),
	(719,52,'product',28,'1963',1,1,0,0,0,'2021-01-15 11:19:45',NULL,1),
	(720,52,'product',29,'1989',1,1,0,0,0,'2021-01-15 11:20:16',NULL,1),
	(721,52,'product',28,'1963',1,1,0,0,0,'2021-01-15 11:21:28',NULL,1),
	(722,52,'product',28,'1963',1,1,0,0,0,'2021-01-15 11:21:36',NULL,1),
	(724,37,'product',28,'1963',1,1,0,0,0,'2021-01-15 11:29:39',NULL,1),
	(725,37,'product',28,'1963',1,1,0,0,0,'2021-01-15 11:29:59',NULL,1),
	(726,44,'product',15,'1319',1,1,0,0,0,'2021-01-15 11:35:08',NULL,0),
	(727,44,'product',15,'1319',1,1,0,0,0,'2021-01-15 11:35:32',NULL,0),
	(728,37,'product',28,'1963',1,1,0,0,0,'2021-01-15 11:53:52',NULL,1),
	(729,384,'product',6,'221',1,1,0,0,0,'2021-01-15 18:15:57',NULL,0),
	(730,384,'product',17,'1921',1,0,0,0,0,'2021-01-15 18:16:14',NULL,0),
	(731,57,'product',30,'2028',1,1,0,0,0,'2021-01-16 09:53:08',NULL,1),
	(732,52,'product',30,'2022',1,1,0,0,0,'2021-01-16 09:53:50',NULL,1),
	(733,52,'product',30,'2022',1,1,0,0,0,'2021-01-16 09:53:55',NULL,1),
	(734,52,'product',30,'2022',1,1,0,0,0,'2021-01-16 09:54:03',NULL,1),
	(737,52,'product',28,'2013',1,0,0,0,0,'2021-01-16 10:45:58',NULL,1),
	(744,52,'product',30,'2039',1,1,0,0,0,'2021-01-16 11:38:45',NULL,1),
	(747,386,'product',30,'2051',1,1,0,0,0,'2021-01-16 12:16:16',NULL,1),
	(748,386,'product',15,'1319',1,1,0,0,0,'2021-01-16 12:17:22',NULL,0),
	(749,386,'product',30,'2051',1,1,0,0,0,'2021-01-16 12:17:38',NULL,1),
	(750,386,'product',28,'2005',1,1,0,0,0,'2021-01-16 12:18:41',NULL,1),
	(751,386,'product',29,'2002',1,1,0,0,0,'2021-01-16 12:20:48',NULL,1),
	(752,386,'product',30,'2051',1,1,0,0,0,'2021-01-16 12:21:13',NULL,1),
	(753,386,'product',30,'2051',1,1,0,0,0,'2021-01-16 12:26:48',NULL,1),
	(754,386,'product',30,'2051',1,1,0,0,0,'2021-01-16 12:28:19',NULL,1),
	(755,52,'product',30,'2051',1,1,0,0,0,'2021-01-16 14:08:09',NULL,1),
	(758,52,'product',30,'2051',1,1,0,0,0,'2021-01-16 14:27:01',NULL,1),
	(760,52,'product',30,'2051',1,1,0,0,0,'2021-01-16 14:46:43',NULL,1),
	(761,52,'product',30,'2051',1,1,0,0,0,'2021-01-16 14:46:56',NULL,1),
	(762,52,'product',30,'2051',1,1,0,0,0,'2021-01-16 14:47:15',NULL,1),
	(763,52,'product',30,'2051',1,1,0,0,0,'2021-01-16 14:48:04',NULL,1),
	(764,52,'product',30,'2051',1,1,0,0,0,'2021-01-16 14:48:30',NULL,1),
	(770,32,'product',26,'2059',1,1,0,0,0,'2021-01-18 14:29:58',NULL,1),
	(771,32,'product',26,'2059',1,1,0,0,0,'2021-01-18 14:30:19',NULL,1),
	(772,32,'product',26,'2059',1,1,0,0,0,'2021-01-18 14:30:37',NULL,1);

/*!40000 ALTER TABLE `eb_store_cart` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_combination
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_combination`;

CREATE TABLE `eb_store_combination` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '拼团商品ID',
  `product_id` int(10) unsigned NOT NULL COMMENT '商品id',
  `mer_id` int(10) unsigned DEFAULT '0' COMMENT '商户id',
  `image` varchar(255) NOT NULL COMMENT '推荐图',
  `images` varchar(2000) NOT NULL COMMENT '轮播图',
  `title` varchar(255) NOT NULL COMMENT '活动标题',
  `attr` varchar(255) DEFAULT NULL COMMENT '活动属性',
  `people` int(2) unsigned NOT NULL COMMENT '参团人数',
  `info` varchar(255) NOT NULL COMMENT '简介',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '价格',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `sales` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '销量',
  `stock` int(10) unsigned NOT NULL COMMENT '库存',
  `add_time` bigint(14) NOT NULL COMMENT '添加时间',
  `is_host` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '推荐',
  `is_show` tinyint(1) unsigned NOT NULL COMMENT '商品状态',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `combination` tinyint(1) unsigned DEFAULT '1',
  `mer_use` tinyint(1) unsigned DEFAULT NULL COMMENT '商户是否可用1可用0不可用',
  `is_postage` tinyint(1) unsigned DEFAULT NULL COMMENT '是否包邮1是0否',
  `postage` decimal(10,2) unsigned DEFAULT NULL COMMENT '邮费',
  `start_time` bigint(14) unsigned NOT NULL COMMENT '拼团开始时间',
  `stop_time` bigint(14) unsigned NOT NULL COMMENT '拼团结束时间',
  `effective_time` int(11) NOT NULL DEFAULT '0' COMMENT '拼团订单有效时间(小时)',
  `cost` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '拼图商品成本',
  `browse` int(11) DEFAULT '0' COMMENT '浏览量',
  `unit_name` varchar(32) NOT NULL DEFAULT '' COMMENT '单位名',
  `temp_id` int(11) NOT NULL COMMENT '运费模板ID',
  `weight` decimal(8,2) DEFAULT '0.00' COMMENT '重量',
  `volume` decimal(8,2) DEFAULT '0.00' COMMENT '体积',
  `num` int(11) DEFAULT NULL COMMENT '单次购买数量',
  `quota` int(10) NOT NULL DEFAULT '0' COMMENT '限购总数',
  `quota_show` int(10) NOT NULL DEFAULT '0' COMMENT '限量总数显示',
  `ot_price` decimal(10,2) NOT NULL COMMENT '原价',
  `once_num` int(11) NOT NULL DEFAULT '0' COMMENT '每个订单可购买数量',
  `virtual_ration` int(11) NOT NULL DEFAULT '100' COMMENT '虚拟成团百分比',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='拼团商品表';

LOCK TABLES `eb_store_combination` WRITE;
/*!40000 ALTER TABLE `eb_store_combination` DISABLE KEYS */;

INSERT INTO `eb_store_combination` (`id`, `product_id`, `mer_id`, `image`, `images`, `title`, `attr`, `people`, `info`, `price`, `sort`, `sales`, `stock`, `add_time`, `is_host`, `is_show`, `is_del`, `combination`, `mer_use`, `is_postage`, `postage`, `start_time`, `stop_time`, `effective_time`, `cost`, `browse`, `unit_name`, `temp_id`, `weight`, `volume`, `num`, `quota`, `quota_show`, `ot_price`, `once_num`, `virtual_ration`)
VALUES
	(1,1,0,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','[\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\"]','圈粉',NULL,2,'圈粉',99.00,1,1,429,1607409888895,1,0,1,1,NULL,0,NULL,1606752000000,1609430399999,24,9.00,0,'T',1,0.00,0.00,1,429,430,9.00,1,50),
	(2,2,0,'image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','[\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\"]','iphone11',NULL,2,'苹果11',1.00,1,0,20,1607500143618,0,0,1,1,NULL,0,NULL,1606752000000,1612108799999,24,12000.00,0,'123',1,0.00,0.00,10,20,20,12000.00,1,1),
	(3,2,0,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','[\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\"]','iphone11',NULL,10,'苹果11',9999.00,1,0,19,1608186172374,0,0,1,1,NULL,0,NULL,1606752000000,1612108799999,24,12000.00,0,'123',1,0.00,0.00,1,19,19,12000.00,1,50),
	(4,9,0,'http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg','[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\"]','【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机',NULL,10,'【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机',1.00,0,0,2997,1608191461386,1,0,1,1,NULL,0,NULL,1606752000000,1612108799999,24,0.00,0,'件',2,0.00,0.00,1,2997,2997,0.00,1,50),
	(5,9,0,'http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg','[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\"]','【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机',NULL,2,'【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机',10000.00,0,5,992,1608257979654,1,0,1,1,NULL,0,NULL,1608134400000,1608652799999,1,0.00,0,'件',2,0.00,0.00,5,1,1,0.00,12,50),
	(6,7,0,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','[\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\"]','腰果',NULL,2,'腰果',99.90,0,1,1120,1608258015222,1,0,1,1,NULL,0,NULL,1608134400000,1608825599999,1,200.00,0,'盒',2,0.00,0.00,1,1120,1120,200.00,1,50),
	(7,13,0,'img.alicdn.com\\/imgextra\\/i4\\/1794176171\\/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg','[\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01GwvntW1vSMkhgUUw5_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i3/1794176171/O1CN01OdxsQm1vSMkfOhu8B_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i4/1794176171/O1CN013HlIBb1vSMklCF1Hj_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01bB9sy01vSMkjBsRO7_!!1794176171.jpg\"]','P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机',NULL,3,'P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机',1000.00,0,0,995,1608524012225,0,0,1,1,NULL,0,NULL,1608480000000,1609430399999,1,0.00,0,'件',2,0.00,0.00,10,995,995,0.00,10,66),
	(8,1,0,'image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','[\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\"]','圈粉',NULL,2,'圈粉',99.00,1,1,9,1608542699711,0,0,1,1,NULL,0,NULL,1610640000000,1612108799999,1,9.00,0,'T',1,0.00,0.00,1,9,9,9.00,10,50),
	(9,17,0,'image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png','[\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\",\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\",\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\",\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\"]','HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男',NULL,2,'HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男',218.00,100,5,94,1608778532378,1,0,1,1,NULL,0,NULL,1609776000000,1611158399999,1,299.00,0,'件',2,0.00,0.00,10,0,1,299.00,1,100),
	(10,14,0,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','[\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\"]','笔记本电脑',NULL,2,'笔记本电脑',1000.00,0,0,999,1608805482098,0,0,1,1,NULL,0,NULL,1608739200000,1609430399999,1,10000.00,0,'台',2,0.00,0.00,1,999,999,10000.00,10,100),
	(11,15,0,'//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg','[\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\"]','【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',NULL,18,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',159.00,99,1,1751,1610503613720,1,0,1,1,NULL,0,NULL,1610467200000,1612022399999,1,199.00,0,'件',3,0.00,0.00,1,1751,1752,199.00,11,94),
	(12,30,0,'image/store/2021/01/16/41bd871869e34a8384b932b50d1f9dd6dwle1zzptr.png','[\"image/content/2021/01/16/f8aad4ff9c8f46a9bb0c70b94e17ae5fs8n6kpu79x.png\",\"image/content/2021/01/16/f9c2bf85441f47228f347a5af977a9d2aqwfda4vo1.png\",\"image/content/2021/01/16/3ce969fa970d4964a00ad7cfc084a994b74qnp857n.png\",\"image/content/2021/01/16/fb9c8cd0ebbb4fdfa032e12ce960601ci0jdz6qtvb.png\",\"image/content/2021/01/16/80a97c58b69a41298995ad0ae4f6cf93y8mfo0o6gf.png\"]','Jordan 官方 AIR JORDAN 3 RETRO AJ3复刻男子运动鞋CT8532',NULL,2,'Jordan 官方 AIR JORDAN 3 RETRO AJ3复刻男子运动鞋CT8532\n',899.00,0,9,90,1610942789251,1,1,0,1,NULL,0,NULL,1610899200000,1612108799999,1,1899.00,0,'件',2,0.00,0.00,4,1,10,1899.00,2,100),
	(13,28,0,'image/content/2021/01/15/c8bb13307db9431ea04c26ef2b5586e33zbgdu0mu1.png','[\"//img.alicdn.com/imgextra/i3/3327042818/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\",\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01JSyvWP1WggkHZ4JV4_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01sypoLu1WggkFgvjkz_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i2/3327042818/O1CN012ZNCw21Wggk3e048T_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01E77iW21Wggk9rMrVh_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01RjoAqG1WggkHZ42sg_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01wE59b41WggkEW0A8U_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01KMrteX1WggkHBdK18_!!3327042818.jpg\",\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01aGJf9x1Wggk3e0Ovi_!!3327042818.jpg\"]','Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152',NULL,2,'Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152',899.00,0,2,97,1610943232363,1,1,0,1,NULL,0,NULL,1610899200000,1612108799999,1,1599.00,0,'件',3,0.00,0.00,1,8,10,1599.00,1,50),
	(14,27,0,'image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png','[\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\"]','测试商品',NULL,2,'测试商品',100.00,0,0,100,1610952564745,0,1,0,1,NULL,0,NULL,1610899200000,1612108799999,1,200.00,0,'件',3,0.00,0.00,1,1,1,200.00,1,100);

/*!40000 ALTER TABLE `eb_store_combination` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_coupon
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_coupon`;

CREATE TABLE `eb_store_coupon` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '优惠券表ID',
  `name` varchar(64) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  `money` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '兑换的优惠券面值',
  `is_limited` tinyint(1) DEFAULT '0' COMMENT '是否限量, 默认0 不限量， 1限量',
  `total` int(11) NOT NULL DEFAULT '0' COMMENT '发放总数',
  `last_total` int(11) DEFAULT '0' COMMENT '剩余数量',
  `use_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '使用类型 1 全场通用, 2 商品券, 3 品类券',
  `primary_key` varchar(255) NOT NULL DEFAULT '' COMMENT '所属商品id / 分类id',
  `min_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '最低消费，0代表不限制',
  `receive_start_time` timestamp NOT NULL COMMENT '可领取开始时间',
  `receive_end_time` timestamp NULL DEFAULT NULL COMMENT '可领取结束时间',
  `is_fixed_time` tinyint(1) DEFAULT '0' COMMENT '是否固定使用时间, 默认0 否， 1是',
  `use_start_time` timestamp NULL DEFAULT NULL COMMENT '可使用时间范围 开始时间',
  `use_end_time` timestamp NULL DEFAULT NULL COMMENT '可使用时间范围 结束时间',
  `day` int(4) DEFAULT '0' COMMENT '天数',
  `type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '优惠券类型 1 手动领取, 2 新人券, 3 赠送券',
  `sort` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态（0：关闭，1：开启）',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除 状态（0：否，1：是）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `state` (`status`) USING BTREE,
  KEY `is_del` (`is_del`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='优惠券表';

LOCK TABLES `eb_store_coupon` WRITE;
/*!40000 ALTER TABLE `eb_store_coupon` DISABLE KEYS */;

INSERT INTO `eb_store_coupon` (`id`, `name`, `money`, `is_limited`, `total`, `last_total`, `use_type`, `primary_key`, `min_price`, `receive_start_time`, `receive_end_time`, `is_fixed_time`, `use_start_time`, `use_end_time`, `day`, `type`, `sort`, `status`, `is_del`, `create_time`, `update_time`)
VALUES
	(8,'通用满0减1.5手动领取券',1.50,1,10,8,1,'',0.00,'2020-12-23 14:26:29',NULL,0,'2021-01-15 10:36:44','2021-01-16 10:36:44',1,1,0,1,0,'2020-12-23 14:26:29','2020-12-23 14:26:29'),
	(10,'商品满0减1.5手动领取券',1.50,1,10,10,2,'17,15,19,18',0.00,'2020-12-23 00:00:00','2020-12-25 23:59:59',1,'2020-12-23 00:00:00','2020-12-31 23:59:59',0,1,0,1,0,'2020-12-23 14:36:04','2020-12-23 14:36:04'),
	(12,'品类满0减1.5手动领取券',1.50,0,0,-2,3,'516',0.00,'2020-12-23 14:45:32',NULL,0,'2021-01-15 10:36:43','2021-01-16 10:36:43',1,1,0,1,0,'2020-12-23 14:45:32','2020-12-23 14:45:32'),
	(13,'品类满0减1.5手动领取券',1.50,0,0,-8,3,'516',0.00,'2020-12-23 14:46:44',NULL,0,'2021-01-15 10:36:42','2021-01-16 10:36:42',1,1,0,1,0,'2020-12-23 14:46:44','2020-12-23 14:46:44'),
	(14,'通用满0减1.5赠送券',1.50,1,10,10,1,'',1.00,'2020-12-23 14:50:06',NULL,0,NULL,NULL,1,3,0,1,0,'2020-12-23 14:50:06','2020-12-23 14:50:06'),
	(15,'通用满0减1.5新人券',1.50,1,10,10,1,'',1.00,'2020-12-23 14:50:19',NULL,0,NULL,NULL,1,2,0,1,0,'2020-12-23 14:50:19','2020-12-23 14:50:19'),
	(16,'通用满0减1.5手动人券',1.50,1,10,9,1,'',1.00,'2020-12-23 14:50:30',NULL,0,'2021-01-15 10:36:42','2021-01-16 10:36:42',1,1,0,1,0,'2020-12-23 14:50:30','2020-12-23 14:50:30'),
	(17,'TY新人券',10.00,0,0,0,1,'',0.00,'2020-12-23 14:53:59',NULL,0,NULL,NULL,1,2,0,1,0,'2020-12-23 14:53:59','2020-12-23 14:53:59'),
	(18,'TY赠送券',10.00,0,0,0,1,'',0.00,'2020-12-23 14:54:48',NULL,0,NULL,NULL,1,3,0,1,0,'2020-12-23 14:54:48','2020-12-23 14:54:48'),
	(19,'品类满100减1.5手动领取券',1.50,0,0,-1,3,'516',100.00,'2020-12-23 15:01:45',NULL,0,'2021-01-15 10:36:41','2021-01-16 10:36:41',1,1,0,1,0,'2020-12-23 15:01:45','2020-12-23 15:01:45'),
	(20,'优惠券库存数量测试000',10.00,1,1,0,1,'',2000.00,'2020-12-23 15:29:06',NULL,0,'2021-01-15 10:36:40','2021-01-16 10:36:40',1,1,0,1,0,'2020-12-23 15:29:06','2020-12-23 15:29:06'),
	(21,'领取后使用时间测试',1.00,0,0,-2,1,'',0.00,'2020-12-23 16:29:42',NULL,0,'2021-01-15 10:36:39','2021-01-16 10:36:39',1,1,0,1,0,'2020-12-23 16:29:42','2020-12-23 16:29:42'),
	(22,'领取后使用时间段测试',1.00,0,0,-2,1,'',2.00,'2020-12-23 16:31:17',NULL,1,'2020-12-25 08:00:00','2020-12-31 20:00:00',0,1,0,1,0,'2020-12-23 16:31:17','2020-12-23 16:31:17'),
	(23,'未到期领取测试000',3.00,0,0,0,1,'',0.00,'2020-12-25 00:00:00','2020-12-31 00:00:00',0,NULL,NULL,1,1,0,1,0,'2020-12-23 16:33:23','2020-12-23 16:33:23'),
	(24,'通用新人赠送券01',10.00,0,0,0,1,'',0.00,'2020-12-23 16:57:23',NULL,0,NULL,NULL,1,2,0,1,0,'2020-12-23 16:57:23','2020-12-23 17:21:39'),
	(25,'满218可以使用',9.99,0,0,-4,1,'',218.00,'2020-12-23 17:00:14',NULL,0,'2021-01-15 10:36:38','2021-01-16 10:36:38',1,1,0,1,0,'2020-12-23 17:00:14','2020-12-23 17:00:14'),
	(26,'满169可用',5.55,0,0,-4,1,'',169.00,'2020-12-23 17:02:03',NULL,0,'2021-01-15 10:36:37','2021-01-16 10:36:37',1,1,0,1,0,'2020-12-23 17:02:03','2020-12-23 17:02:03'),
	(27,'满159可用',6.66,0,0,-3,1,'',159.00,'2020-12-23 17:02:43',NULL,0,'2021-01-15 10:36:36','2021-01-16 10:36:36',1,1,0,1,0,'2020-12-23 17:02:43','2020-12-23 17:02:43'),
	(28,'使用时间测试',1.11,0,0,-3,1,'',0.00,'2020-12-23 17:42:56',NULL,1,'2020-12-23 00:00:00','2020-12-23 17:44:00',0,1,0,1,0,'2020-12-23 17:42:56','2020-12-23 17:42:56'),
	(29,'林更新同款商品优惠券',2.22,0,0,-3,2,'18,19,17',0.00,'2020-12-23 17:44:22',NULL,0,'2021-01-15 10:36:35','2021-01-16 10:36:35',1,1,0,1,0,'2020-12-23 17:44:22','2020-12-23 17:44:22'),
	(30,'每日一新品类券',3.33,0,0,-5,3,'516',0.00,'2020-12-23 17:57:25',NULL,0,'2021-01-15 10:36:33','2021-01-16 10:36:33',1,1,0,1,0,'2020-12-23 17:57:25','2020-12-23 17:57:25'),
	(31,'HZW专属券',1.00,1,1,0,1,'',0.00,'2021-01-07 11:48:17',NULL,0,'2021-01-07 00:00:00','2021-01-08 00:00:00',1,1,10,1,0,'2021-01-07 11:48:17','2021-01-07 14:21:19'),
	(32,'HZW时间段测试优惠券',1.00,1,10,1,1,'',0.00,'2021-01-07 14:31:25',NULL,1,'2021-01-07 00:00:00','2021-01-14 00:00:00',0,1,10,1,0,'2021-01-07 14:31:25','2021-01-07 14:31:25'),
	(33,'HZW未到时间通用券',1.00,1,10,5,1,'',0.00,'2021-01-07 14:33:47',NULL,1,'2021-01-10 08:00:00','2021-01-15 20:00:00',0,1,9,1,0,'2021-01-07 14:33:47','2021-01-07 14:33:47'),
	(34,'HZW时间段测试优惠券1.7',1.00,0,0,-1,3,'291',0.00,'2021-01-07 00:00:00','2021-01-08 00:00:00',1,'2021-01-07 00:00:00','2021-01-14 00:00:00',0,1,10,1,0,'2021-01-07 16:45:03','2021-01-07 16:45:03'),
	(35,'HZW时间段测试优惠券1.7',1.00,0,0,0,3,'291',0.00,'2021-01-07 23:00:00','2021-01-08 00:00:00',1,'2021-01-07 00:00:00','2021-01-14 00:00:00',0,1,10,1,0,'2021-01-07 16:47:52','2021-01-07 16:47:52'),
	(36,'HZW品类测试券',5.00,1,10,2,3,'516',0.00,'2021-01-07 17:58:33',NULL,0,'2021-01-15 10:36:28','2021-01-16 10:36:28',1,1,9,1,0,'2021-01-07 17:58:33','2021-01-07 17:58:33'),
	(37,'1',1.00,0,0,0,1,'',0.00,'2021-01-14 09:34:34',NULL,0,NULL,NULL,1,2,0,0,0,'2021-01-14 09:34:34','2021-01-14 09:34:34'),
	(38,'手动领取通用券01',1.00,0,0,0,2,'28',0.00,'2021-01-15 10:43:52',NULL,0,NULL,NULL,1,1,0,1,0,'2021-01-15 10:43:52','2021-01-15 10:43:52'),
	(39,'手动领取品类券01',1.00,0,0,-1,3,'516',0.00,'2021-01-15 10:44:49',NULL,0,'2021-01-15 11:35:23','2021-01-16 11:35:23',1,1,0,1,0,'2021-01-15 10:44:49','2021-01-15 10:44:49'),
	(40,'门槛100券',1.00,0,0,-1,3,'516',100.00,'2021-01-15 10:45:40',NULL,0,'2021-01-15 11:09:22','2021-01-16 11:09:22',1,1,0,1,0,'2021-01-15 10:45:40','2021-01-15 10:45:40'),
	(41,'门槛1000券',1.00,1,1,0,1,'',1000.00,'2021-01-15 10:52:08',NULL,0,'2021-01-15 10:52:41','2021-01-16 10:52:41',1,1,0,1,0,'2021-01-15 10:52:08','2021-01-15 10:52:08'),
	(42,'门槛99券',1.00,1,1,0,1,'',99.00,'2021-01-15 10:53:18',NULL,0,'2021-01-15 10:53:29','2021-01-16 10:53:29',1,1,0,1,0,'2021-01-15 10:53:18','2021-01-15 10:53:18'),
	(43,'使用时间测试券000',1.00,0,0,-3,1,'',0.00,'2021-01-15 11:00:37',NULL,0,'2021-01-16 12:02:48','2021-01-17 12:02:48',1,1,0,1,0,'2021-01-15 11:00:37','2021-01-15 11:00:37'),
	(44,'年终极品优惠券0000',1.00,1,1,0,1,'',99.00,'2021-01-15 11:03:47',NULL,1,'2021-02-11 00:00:00','2021-02-26 00:00:00',0,1,0,1,0,'2021-01-15 11:03:47','2021-01-15 11:03:47'),
	(45,'卓丹；商品券000',100.00,0,0,-2,2,'28,29',0.00,'2021-01-15 11:18:45',NULL,0,'2021-01-15 11:29:22','2021-01-16 11:29:22',1,1,0,1,0,'2021-01-15 11:18:45','2021-01-15 11:18:45'),
	(46,'卓丹；品类券',200.00,0,0,-1,3,'516',0.00,'2021-01-15 11:19:18',NULL,0,'2021-01-15 11:19:25','2021-01-16 11:19:25',1,1,0,1,0,'2021-01-15 11:19:18','2021-01-15 11:19:18'),
	(47,'通用券01',1.00,0,0,-2,1,'',0.00,'2021-01-16 11:15:45',NULL,0,'2021-01-16 11:53:33','2021-01-17 11:53:33',1,1,0,1,0,'2021-01-16 11:15:45','2021-01-16 11:15:45'),
	(48,'商品券01',1.00,0,0,-5,2,'30,29,28',0.00,'2021-01-16 11:16:55',NULL,0,'2021-01-18 15:18:52','2021-01-19 15:18:52',1,1,0,1,0,'2021-01-16 11:16:55','2021-01-16 11:16:55'),
	(49,'品类券01',1.00,0,0,-5,3,'530',0.00,'2021-01-16 11:17:28',NULL,0,'2021-01-18 15:18:52','2021-01-19 15:18:52',1,1,0,1,0,'2021-01-16 11:17:28','2021-01-16 11:17:28'),
	(50,'新人券01',2.00,0,0,-4,1,'',0.00,'2021-01-16 11:19:05',NULL,0,'2021-01-18 15:18:52','2021-01-19 15:18:52',1,2,0,1,0,'2021-01-16 11:19:05','2021-01-16 11:19:05'),
	(51,'赠送券01',1.00,0,0,-5,1,'',0.00,'2021-01-16 11:20:38',NULL,0,'2021-01-18 15:18:52','2021-01-19 15:18:52',1,3,0,1,0,'2021-01-16 11:20:38','2021-01-16 11:20:38'),
	(52,'领取时间测试券01',3.00,0,0,-1,1,'',0.00,'2021-01-16 00:00:00','2021-01-16 12:00:00',1,'2021-01-16 00:00:00','2021-01-31 00:00:00',0,1,0,1,0,'2021-01-16 11:58:23','2021-01-16 11:58:23'),
	(53,'领取数量测试券01',3.00,1,1,0,1,'',0.00,'2021-01-16 12:01:00',NULL,0,'2021-01-16 12:01:28','2021-01-17 12:01:28',1,1,0,1,0,'2021-01-16 12:01:00','2021-01-16 12:01:00'),
	(54,'领取时间测试券02',3.00,0,0,0,1,'',0.00,'2021-01-16 00:00:00','2021-01-16 12:04:00',1,'2021-01-16 00:00:00','2021-01-31 00:00:00',0,1,0,1,0,'2021-01-16 12:03:39','2021-01-16 12:03:39'),
	(55,'使用测试：通用券001',10.00,0,0,-2,1,'',0.00,'2021-01-16 12:11:01',NULL,0,'2021-01-16 14:08:06','2021-01-17 14:08:06',1,1,0,1,0,'2021-01-16 12:11:01','2021-01-16 12:11:01'),
	(56,'使用测试：JORDNA商品券001',10.00,0,0,-2,2,'28,29,30',0.00,'2021-01-16 12:11:38',NULL,0,'2021-01-16 14:08:03','2021-01-17 14:08:03',1,1,0,0,0,'2021-01-16 12:11:38','2021-01-16 14:12:25'),
	(57,'使用测试：篮球鞋分类001',10.00,0,0,-1,3,'529',0.00,'2021-01-16 12:12:01',NULL,0,'2021-01-16 12:13:03','2021-01-17 12:13:03',1,1,0,1,0,'2021-01-16 12:12:01','2021-01-16 12:12:01'),
	(58,'使用测试：1399门槛券01',199.00,0,0,-2,1,'',1399.00,'2021-01-16 12:12:40',NULL,0,'2021-01-16 14:08:00','2021-01-17 14:08:00',1,1,0,1,0,'2021-01-16 12:12:40','2021-01-16 12:12:40'),
	(59,'使用测试：JORDNA商品券002',10.00,0,0,-2,2,'30,29,28',0.00,'2021-01-16 12:26:34',NULL,0,'2021-01-16 14:07:58','2021-01-17 14:07:58',1,1,0,1,0,'2021-01-16 12:26:34','2021-01-16 12:26:34'),
	(60,'使用测试：JORDNA商品券003',10.00,0,0,-1,2,'30,29,28',0.00,'2021-01-16 14:21:55',NULL,0,'2021-01-16 14:24:52','2021-01-17 14:24:52',1,1,0,1,0,'2021-01-16 14:21:55','2021-01-16 14:21:55'),
	(61,'使用测试：使用过期时间测试',1.00,0,0,-1,1,'',0.00,'2021-01-16 14:36:16',NULL,1,'2021-01-16 00:00:00','2021-01-16 14:37:00',0,1,10,1,0,'2021-01-16 14:36:16','2021-01-16 14:36:16'),
	(62,'测不限量',5.00,0,0,0,1,'',0.00,'2021-01-16 14:39:36',NULL,0,NULL,NULL,30,2,999,1,0,'2021-01-16 14:39:36','2021-01-16 14:39:36');

/*!40000 ALTER TABLE `eb_store_coupon` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_coupon_user
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_coupon_user`;

CREATE TABLE `eb_store_coupon_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `coupon_id` int(10) NOT NULL COMMENT '优惠券发布id',
  `cid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '兑换的项目id',
  `uid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '领取人id',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  `money` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '优惠券的面值',
  `min_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '最低消费多少金额可用优惠券',
  `type` varchar(32) NOT NULL DEFAULT 'send' COMMENT '获取方式，send后台发放, 用户领取 get',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0：未使用，1：已使用, 2:已失效）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `start_time` timestamp NULL DEFAULT NULL COMMENT '开始使用时间',
  `end_time` timestamp NULL DEFAULT NULL COMMENT '过期时间',
  `use_time` timestamp NULL DEFAULT NULL COMMENT '使用时间',
  `use_type` tinyint(1) DEFAULT '1' COMMENT '使用类型 1 全场通用, 2 商品券, 3 品类券',
  `primary_key` varchar(255) DEFAULT NULL COMMENT '所属商品id / 分类id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `cid` (`cid`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `end_time` (`end_time`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='优惠券记录表';

LOCK TABLES `eb_store_coupon_user` WRITE;
/*!40000 ALTER TABLE `eb_store_coupon_user` DISABLE KEYS */;

INSERT INTO `eb_store_coupon_user` (`id`, `coupon_id`, `cid`, `uid`, `name`, `money`, `min_price`, `type`, `status`, `create_time`, `update_time`, `start_time`, `end_time`, `use_time`, `use_type`, `primary_key`)
VALUES
	(1,1,0,11,'优惠',10.00,0.00,'send',2,'2020-12-09 15:10:47','2020-12-09 15:10:47','2020-12-09 00:00:00','2020-12-20 00:00:00',NULL,1,NULL),
	(2,1,0,28,'优惠',10.00,0.00,'send',2,'2020-12-13 08:24:24','2020-12-13 08:24:24','2020-12-13 00:00:00','2020-12-24 00:00:00',NULL,1,NULL),
	(3,1,0,31,'优惠',10.00,0.00,'send',2,'2020-12-14 17:06:43','2020-12-14 17:06:43','2020-12-14 00:00:00','2020-12-25 00:00:00',NULL,1,NULL),
	(4,1,0,38,'优惠',10.00,0.00,'send',2,'2020-12-15 10:15:07','2020-12-15 10:15:07','2020-12-15 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(5,2,0,34,'发送优惠券',10.00,0.00,'send',2,'2020-12-15 16:06:27','2020-12-15 16:06:27','2020-12-15 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(6,1,0,43,'优惠',10.00,0.00,'send',2,'2020-12-16 16:49:35','2020-12-16 16:49:35','2020-12-16 00:00:00','2020-12-27 00:00:00',NULL,1,NULL),
	(7,2,0,43,'发送优惠券',10.00,0.00,'send',2,'2020-12-16 16:49:36','2020-12-16 16:49:36','2020-12-16 00:00:00','2020-12-27 00:00:00',NULL,1,NULL),
	(8,1,0,45,'优惠',10.00,0.00,'send',2,'2020-12-17 10:24:32','2020-12-17 10:24:32','2020-12-17 00:00:00','2020-12-28 00:00:00',NULL,1,NULL),
	(9,2,0,45,'发送优惠券',10.00,0.00,'send',2,'2020-12-17 10:24:33','2020-12-17 10:24:33','2020-12-17 00:00:00','2020-12-28 00:00:00',NULL,1,NULL),
	(10,1,0,47,'优惠',10.00,0.00,'send',2,'2020-12-17 11:36:52','2020-12-17 11:36:52','2020-12-17 00:00:00','2020-12-28 00:00:00',NULL,1,NULL),
	(11,2,0,47,'发送优惠券',10.00,0.00,'send',2,'2020-12-17 11:36:56','2020-12-17 11:36:56','2020-12-17 00:00:00','2020-12-28 00:00:00',NULL,1,NULL),
	(12,1,0,44,'优惠',10.00,0.00,'send',2,'2020-12-18 15:44:20','2020-12-18 15:44:20','2020-12-18 00:00:00','2020-12-29 00:00:00',NULL,1,NULL),
	(13,1,0,46,'优惠',10.00,0.00,'send',2,'2020-12-18 15:47:37','2020-12-18 15:47:37','2020-12-18 00:00:00','2020-12-29 00:00:00',NULL,1,NULL),
	(14,1,0,33,'优惠',10.00,0.00,'send',2,'2020-12-18 16:07:49','2020-12-18 16:07:49','2020-12-18 00:00:00','2020-12-29 00:00:00',NULL,1,NULL),
	(15,1,0,54,'优惠',10.00,0.00,'send',2,'2020-12-21 20:05:13','2020-12-21 20:05:13','2020-12-21 00:00:00','2021-01-01 00:00:00',NULL,1,NULL),
	(16,2,0,54,'发送优惠券',10.00,0.00,'send',2,'2020-12-21 20:05:14','2020-12-21 20:05:14','2020-12-21 00:00:00','2021-01-01 00:00:00',NULL,1,NULL),
	(17,1,0,56,'优惠',10.00,0.00,'send',2,'2020-12-22 08:50:16','2020-12-22 08:50:16','2020-12-22 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(18,2,0,56,'发送优惠券',10.00,0.00,'send',2,'2020-12-22 08:50:17','2020-12-22 08:50:17','2020-12-22 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(19,1,0,63,'优惠',10.00,0.00,'send',2,'2020-12-22 21:01:47','2020-12-22 21:01:47','2020-12-22 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(20,2,0,63,'发送优惠券',10.00,0.00,'send',2,'2020-12-22 21:01:48','2020-12-22 21:01:48','2020-12-22 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(21,1,0,64,'优惠',10.00,0.00,'send',2,'2020-12-23 09:51:26','2020-12-23 09:51:26','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(22,2,0,64,'发送优惠券',10.00,0.00,'send',2,'2020-12-23 09:51:26','2020-12-23 09:51:26','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(23,1,0,65,'优惠',10.00,0.00,'send',2,'2020-12-23 10:22:32','2020-12-23 10:22:32','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(24,2,0,65,'发送优惠券',10.00,0.00,'send',2,'2020-12-23 10:22:34','2020-12-23 10:22:34','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(25,2,0,66,'发送优惠券',10.00,0.00,'send',2,'2020-12-23 10:40:18','2020-12-23 10:40:18','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(26,1,0,66,'优惠',10.00,0.00,'send',2,'2020-12-23 10:40:20','2020-12-23 10:40:20','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(27,1,0,67,'优惠',10.00,0.00,'send',2,'2020-12-23 10:53:31','2020-12-23 10:53:31','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(28,2,0,67,'发送优惠券',10.00,0.00,'send',2,'2020-12-23 10:53:32','2020-12-23 10:53:32','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(29,1,0,68,'优惠',10.00,0.00,'send',2,'2020-12-23 12:31:15','2020-12-23 12:31:15','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(30,2,0,68,'发送优惠券',10.00,0.00,'send',2,'2020-12-23 12:31:17','2020-12-23 12:31:17','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(32,20,0,57,'优惠券库存数量测试000',10.00,2000.00,'send',2,'2020-12-23 15:29:29','2020-12-23 15:29:29','2020-12-23 00:00:00','2020-12-25 00:00:00',NULL,1,NULL),
	(36,25,0,52,'满218可以使用',9.99,218.00,'send',2,'2020-12-23 17:03:41','2020-12-23 17:03:41','2020-12-23 00:00:00','2020-12-25 00:00:00',NULL,1,NULL),
	(37,26,0,52,'满169可用',5.55,169.00,'send',2,'2020-12-23 17:03:42','2020-12-23 17:03:42','2020-12-23 00:00:00','2020-12-25 00:00:00',NULL,1,NULL),
	(38,27,0,52,'满159可用',6.66,159.00,'send',2,'2020-12-23 17:03:43','2020-12-23 17:03:43','2020-12-23 00:00:00','2020-12-25 00:00:00',NULL,1,NULL),
	(39,22,0,52,'领取后使用时间段测试',1.00,2.00,'send',2,'2020-12-23 17:06:00','2020-12-23 17:06:00','2020-12-25 08:00:00','2020-12-31 20:00:00',NULL,1,NULL),
	(40,27,0,32,'满159可用',6.66,159.00,'send',2,'2020-12-23 17:22:47','2020-12-23 17:22:47','2020-12-23 00:00:00','2020-12-25 00:00:00',NULL,1,NULL),
	(41,28,0,52,'使用时间测试',1.11,0.00,'send',2,'2020-12-23 17:43:01','2020-12-23 17:43:01','2020-12-23 00:00:00','2020-12-23 17:44:00',NULL,1,NULL),
	(42,29,0,52,'林更新同款商品优惠券',2.22,0.00,'send',2,'2020-12-23 17:53:35','2020-12-23 17:53:35','2020-12-23 00:00:00','2020-12-25 00:00:00',NULL,2,NULL),
	(43,30,0,52,'每日一新品类券',3.33,0.00,'send',2,'2020-12-23 17:57:35','2020-12-23 17:57:35','2020-12-23 00:00:00','2020-12-25 00:00:00',NULL,3,NULL),
	(44,30,0,23,'每日一新品类券',3.33,0.00,'send',2,'2020-12-23 18:11:40','2020-12-23 18:11:40','2020-12-23 00:00:00','2020-12-25 00:00:00',NULL,3,NULL),
	(45,29,0,23,'林更新同款商品优惠券',2.22,0.00,'send',2,'2020-12-23 18:11:41','2020-12-23 18:11:41','2020-12-23 00:00:00','2020-12-25 00:00:00',NULL,2,NULL),
	(46,24,0,32,'通用新人赠送券01',10.00,0.00,'send',2,'2020-12-23 18:13:41','2020-12-23 18:13:41','2020-12-23 00:00:00','2020-12-25 00:00:00',NULL,1,NULL),
	(47,30,0,171,'每日一新品类券',3.33,0.00,'send',2,'2020-12-24 14:22:22','2020-12-24 14:22:22','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,3,NULL),
	(48,29,0,171,'林更新同款商品优惠券',2.22,0.00,'send',2,'2020-12-24 14:22:24','2020-12-24 14:22:24','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,2,NULL),
	(49,28,0,171,'使用时间测试',1.11,0.00,'send',2,'2020-12-24 14:22:26','2020-12-24 14:22:26','2020-12-23 00:00:00','2020-12-23 17:44:00',NULL,1,NULL),
	(50,27,0,171,'满159可用',6.66,159.00,'send',2,'2020-12-24 14:22:26','2020-12-24 14:22:26','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(51,26,0,171,'满169可用',5.55,169.00,'send',2,'2020-12-24 14:22:27','2020-12-24 14:22:27','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(52,25,0,171,'满218可以使用',9.99,218.00,'send',2,'2020-12-24 14:22:28','2020-12-24 14:22:28','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(53,24,0,171,'通用新人赠送券01',10.00,0.00,'send',2,'2020-12-24 14:22:28','2020-12-24 14:22:28','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(54,22,0,171,'领取后使用时间段测试',1.00,2.00,'send',2,'2020-12-24 14:22:29','2020-12-24 14:22:29','2020-12-25 08:00:00','2020-12-31 20:00:00',NULL,1,NULL),
	(55,21,0,171,'领取后使用时间测试',1.00,0.00,'send',2,'2020-12-24 14:22:31','2020-12-24 14:22:31','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(56,20,0,171,'优惠券库存数量测试000',10.00,2000.00,'send',2,'2020-12-24 14:22:32','2020-12-24 14:22:32','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(57,19,0,171,'品类满100减1.5手动领取券',1.50,100.00,'send',2,'2020-12-24 14:22:33','2020-12-24 14:22:33','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,3,NULL),
	(58,18,0,171,'TY赠送券',10.00,0.00,'send',2,'2020-12-24 14:22:34','2020-12-24 14:22:34','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(59,17,0,171,'TY新人券',10.00,0.00,'send',2,'2020-12-24 14:22:35','2020-12-24 14:22:35','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(60,16,0,171,'通用满0减1.5手动人券',1.50,1.00,'send',2,'2020-12-24 14:22:36','2020-12-24 14:22:36','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(61,15,0,171,'通用满0减1.5新人券',1.50,1.00,'send',2,'2020-12-24 14:22:37','2020-12-24 14:22:37','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(62,14,0,171,'通用满0减1.5赠送券',1.50,1.00,'send',2,'2020-12-24 14:22:38','2020-12-24 14:22:38','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(63,13,0,171,'品类满0减1.5手动领取券',1.50,0.00,'send',2,'2020-12-24 14:22:39','2020-12-24 14:22:39','2020-12-24 00:00:00','2020-12-26 00:00:00',NULL,3,NULL),
	(64,25,0,199,'满218可以使用',9.99,218.00,'send',2,'2020-12-25 09:28:46','2020-12-25 09:28:46','2020-12-25 00:00:00','2020-12-27 00:00:00',NULL,1,NULL),
	(65,30,0,227,'每日一新品类券',3.33,0.00,'send',2,'2020-12-26 09:54:49','2020-12-26 09:54:49','2020-12-26 00:00:00','2020-12-28 00:00:00',NULL,3,NULL),
	(66,29,0,227,'林更新同款商品优惠券',2.22,0.00,'send',2,'2020-12-26 09:54:50','2020-12-26 09:54:50','2020-12-26 00:00:00','2020-12-28 00:00:00',NULL,2,NULL),
	(67,28,0,227,'使用时间测试',1.11,0.00,'send',2,'2020-12-26 09:54:51','2020-12-26 09:54:51','2020-12-23 00:00:00','2020-12-23 17:44:00',NULL,1,NULL),
	(68,27,0,227,'满159可用',6.66,159.00,'send',2,'2020-12-26 09:54:52','2020-12-26 09:54:52','2020-12-26 00:00:00','2020-12-28 00:00:00',NULL,1,NULL),
	(69,26,0,227,'满169可用',5.55,169.00,'send',2,'2020-12-26 09:54:53','2020-12-26 09:54:53','2020-12-26 00:00:00','2020-12-28 00:00:00',NULL,1,NULL),
	(70,24,0,269,'通用新人赠送券01',10.00,0.00,'send',2,'2020-12-29 10:09:43','2020-12-29 10:09:43','2020-12-29 00:00:00','2020-12-31 00:00:00',NULL,1,NULL),
	(71,30,0,284,'每日一新品类券',3.33,0.00,'send',2,'2020-12-30 17:13:29','2020-12-30 17:13:29','2020-12-30 00:00:00','2021-01-01 00:00:00',NULL,3,NULL),
	(72,29,0,284,'林更新同款商品优惠券',2.22,0.00,'send',2,'2020-12-30 17:13:31','2020-12-30 17:13:31','2020-12-30 00:00:00','2021-01-01 00:00:00',NULL,2,NULL),
	(73,28,0,284,'使用时间测试',1.11,0.00,'send',2,'2020-12-30 17:13:35','2020-12-30 17:13:35','2020-12-23 00:00:00','2020-12-23 17:44:00',NULL,1,NULL),
	(74,15,0,279,'通用满0减1.5新人券',1.50,1.00,'send',2,'2020-12-31 12:05:06','2020-12-31 12:05:06','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(75,30,0,295,'每日一新品类券',3.33,0.00,'send',2,'2020-12-31 20:43:44','2020-12-31 20:43:44','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,3,NULL),
	(76,29,0,295,'林更新同款商品优惠券',2.22,0.00,'send',2,'2020-12-31 20:43:45','2020-12-31 20:43:45','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,2,NULL),
	(77,28,0,295,'使用时间测试',1.11,0.00,'send',2,'2020-12-31 20:43:46','2020-12-31 20:43:46','2020-12-23 00:00:00','2020-12-23 17:44:00',NULL,1,NULL),
	(78,24,0,295,'通用新人赠送券01',10.00,0.00,'send',2,'2020-12-31 20:43:53','2020-12-31 20:43:53','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(79,22,0,295,'领取后使用时间段测试',1.00,2.00,'send',2,'2020-12-31 20:43:54','2020-12-31 20:43:54','2020-12-25 08:00:00','2020-12-31 20:00:00',NULL,1,NULL),
	(80,21,0,295,'领取后使用时间测试',1.00,0.00,'send',2,'2020-12-31 20:43:55','2020-12-31 20:43:55','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(81,18,0,295,'TY赠送券',10.00,0.00,'send',2,'2020-12-31 20:43:58','2020-12-31 20:43:58','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(82,17,0,295,'TY新人券',10.00,0.00,'send',2,'2020-12-31 20:44:00','2020-12-31 20:44:00','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(83,16,0,295,'通用满0减1.5手动人券',1.50,1.00,'send',2,'2020-12-31 20:44:02','2020-12-31 20:44:02','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(84,15,0,295,'通用满0减1.5新人券',1.50,1.00,'send',2,'2020-12-31 20:44:03','2020-12-31 20:44:03','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(85,14,0,295,'通用满0减1.5赠送券',1.50,1.00,'send',2,'2020-12-31 20:44:04','2020-12-31 20:44:04','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(86,13,0,295,'品类满0减1.5手动领取券',1.50,0.00,'send',2,'2020-12-31 20:44:04','2020-12-31 20:44:04','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,3,NULL),
	(87,12,0,295,'品类满0减1.5手动领取券',1.50,0.00,'send',2,'2020-12-31 20:44:05','2020-12-31 20:44:05','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,3,NULL),
	(88,8,0,295,'通用满0减1.5手动领取券',1.50,0.00,'send',2,'2020-12-31 20:44:06','2020-12-31 20:44:06','2020-12-31 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(89,30,0,296,'每日一新品类券',3.33,0.00,'send',2,'2021-01-01 02:25:47','2021-01-01 02:25:47','2021-01-01 00:00:00','2021-01-03 00:00:00',NULL,3,NULL),
	(90,29,0,296,'林更新同款商品优惠券',2.22,0.00,'send',2,'2021-01-01 02:25:50','2021-01-01 02:25:50','2021-01-01 00:00:00','2021-01-03 00:00:00',NULL,2,NULL),
	(91,28,0,296,'使用时间测试',1.11,0.00,'send',2,'2021-01-01 02:25:53','2021-01-01 02:25:53','2020-12-23 00:00:00','2020-12-23 17:44:00',NULL,1,NULL),
	(92,27,0,296,'满159可用',6.66,159.00,'send',2,'2021-01-01 02:25:56','2021-01-01 02:25:56','2021-01-01 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(93,26,0,296,'满169可用',5.55,169.00,'send',2,'2021-01-01 02:25:58','2021-01-01 02:25:58','2021-01-01 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(94,25,0,296,'满218可以使用',9.99,218.00,'send',2,'2021-01-01 02:26:01','2021-01-01 02:26:01','2021-01-01 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(95,28,0,297,'使用时间测试',1.11,0.00,'send',2,'2021-01-01 02:26:18','2021-01-01 02:26:18','2020-12-23 00:00:00','2020-12-23 17:44:00',NULL,1,NULL),
	(96,27,0,297,'满159可用',6.66,159.00,'send',2,'2021-01-01 02:26:22','2021-01-01 02:26:22','2021-01-01 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(97,26,0,297,'满169可用',5.55,169.00,'send',2,'2021-01-01 02:26:25','2021-01-01 02:26:25','2021-01-01 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(98,25,0,297,'满218可以使用',9.99,218.00,'send',2,'2021-01-01 02:26:28','2021-01-01 02:26:28','2021-01-01 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(99,24,0,297,'通用新人赠送券01',10.00,0.00,'send',2,'2021-01-01 02:26:30','2021-01-01 02:26:30','2021-01-01 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(100,22,0,297,'领取后使用时间段测试',1.00,2.00,'send',2,'2021-01-01 02:26:33','2021-01-01 02:26:33','2020-12-25 08:00:00','2020-12-31 20:00:00',NULL,1,NULL),
	(101,30,0,322,'每日一新品类券',3.33,0.00,'send',2,'2021-01-02 12:15:29','2021-01-02 12:15:29','2021-01-02 00:00:00','2021-01-04 00:00:00',NULL,3,NULL),
	(102,27,0,333,'满159可用',6.66,159.00,'send',2,'2021-01-04 14:12:00','2021-01-04 14:12:00','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(103,26,0,333,'满169可用',5.55,169.00,'send',2,'2021-01-04 14:12:01','2021-01-04 14:12:01','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(104,25,0,333,'满218可以使用',9.99,218.00,'send',2,'2021-01-04 14:12:01','2021-01-04 14:12:01','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(105,24,0,333,'通用新人赠送券01',10.00,0.00,'send',2,'2021-01-04 14:12:02','2021-01-04 14:12:02','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(106,22,0,333,'领取后使用时间段测试',1.00,2.00,'send',2,'2021-01-04 14:12:04','2021-01-04 14:12:04','2020-12-25 08:00:00','2020-12-31 20:00:00',NULL,1,NULL),
	(107,21,0,333,'领取后使用时间测试',1.00,0.00,'send',2,'2021-01-04 14:12:05','2021-01-04 14:12:05','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(108,20,0,333,'优惠券库存数量测试000',10.00,2000.00,'send',2,'2021-01-04 14:12:06','2021-01-04 14:12:06','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(109,19,0,333,'品类满100减1.5手动领取券',1.50,100.00,'send',2,'2021-01-04 14:12:06','2021-01-04 14:12:06','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,3,NULL),
	(110,15,0,333,'通用满0减1.5新人券',1.50,1.00,'send',2,'2021-01-04 14:12:08','2021-01-04 14:12:08','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(111,16,0,333,'通用满0减1.5手动人券',1.50,1.00,'send',2,'2021-01-04 14:12:09','2021-01-04 14:12:09','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(112,14,0,333,'通用满0减1.5赠送券',1.50,1.00,'send',2,'2021-01-04 14:12:10','2021-01-04 14:12:10','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(113,13,0,333,'品类满0减1.5手动领取券',1.50,0.00,'send',2,'2021-01-04 14:12:10','2021-01-04 14:12:10','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,3,NULL),
	(114,8,0,333,'通用满0减1.5手动领取券',1.50,0.00,'send',2,'2021-01-04 14:12:14','2021-01-04 14:12:14','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(115,12,0,333,'品类满0减1.5手动领取券',1.50,0.00,'send',2,'2021-01-04 14:12:14','2021-01-04 14:12:14','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,3,NULL),
	(116,18,0,333,'TY赠送券',10.00,0.00,'send',2,'2021-01-04 14:12:19','2021-01-04 14:12:19','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(117,30,0,333,'每日一新品类券',3.33,0.00,'send',2,'2021-01-04 14:12:26','2021-01-04 14:12:26','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,3,NULL),
	(118,29,0,333,'林更新同款商品优惠券',2.22,0.00,'send',2,'2021-01-04 14:12:27','2021-01-04 14:12:27','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,2,NULL),
	(119,28,0,333,'使用时间测试',1.11,0.00,'send',2,'2021-01-04 14:12:28','2021-01-04 14:12:28','2020-12-23 00:00:00','2020-12-23 17:44:00',NULL,1,NULL),
	(120,17,0,333,'TY新人券',10.00,0.00,'send',2,'2021-01-04 14:12:30','2021-01-04 14:12:30','2021-01-04 00:00:00','2021-01-06 00:00:00',NULL,1,NULL),
	(121,30,0,355,'每日一新品类券',3.33,0.00,'send',2,'2021-01-06 11:48:40','2021-01-06 11:48:40','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,3,NULL),
	(122,29,0,355,'林更新同款商品优惠券',2.22,0.00,'send',2,'2021-01-06 11:48:42','2021-01-06 11:48:42','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,2,NULL),
	(123,30,0,359,'每日一新品类券',3.33,0.00,'send',2,'2021-01-06 21:37:07','2021-01-06 21:37:07','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,3,NULL),
	(124,27,0,359,'满159可用',6.66,159.00,'send',2,'2021-01-06 21:37:09','2021-01-06 21:37:09','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(125,25,0,359,'满218可以使用',9.99,218.00,'send',2,'2021-01-06 21:37:10','2021-01-06 21:37:10','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(126,26,0,359,'满169可用',5.55,169.00,'send',2,'2021-01-06 21:37:11','2021-01-06 21:37:11','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(127,24,0,359,'通用新人赠送券01',10.00,0.00,'send',2,'2021-01-06 21:37:11','2021-01-06 21:37:11','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(128,22,0,359,'领取后使用时间段测试',1.00,2.00,'send',2,'2021-01-06 21:37:12','2021-01-06 21:37:12','2020-12-25 08:00:00','2020-12-31 20:00:00',NULL,1,NULL),
	(129,21,0,359,'领取后使用时间测试',1.00,0.00,'send',2,'2021-01-06 21:37:13','2021-01-06 21:37:13','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(130,20,0,359,'优惠券库存数量测试000',10.00,2000.00,'send',2,'2021-01-06 21:37:13','2021-01-06 21:37:13','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(131,19,0,359,'品类满100减1.5手动领取券',1.50,100.00,'send',2,'2021-01-06 21:37:14','2021-01-06 21:37:14','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,3,NULL),
	(132,18,0,359,'TY赠送券',10.00,0.00,'send',2,'2021-01-06 21:37:15','2021-01-06 21:37:15','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(133,17,0,359,'TY新人券',10.00,0.00,'send',2,'2021-01-06 21:37:16','2021-01-06 21:37:16','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(134,16,0,359,'通用满0减1.5手动人券',1.50,1.00,'send',2,'2021-01-06 21:37:16','2021-01-06 21:37:16','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(135,15,0,359,'通用满0减1.5新人券',1.50,1.00,'send',2,'2021-01-06 21:37:18','2021-01-06 21:37:18','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(136,14,0,359,'通用满0减1.5赠送券',1.50,1.00,'send',2,'2021-01-06 21:37:18','2021-01-06 21:37:18','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(137,13,0,359,'品类满0减1.5手动领取券',1.50,0.00,'send',2,'2021-01-06 21:37:19','2021-01-06 21:37:19','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,3,NULL),
	(138,12,0,359,'品类满0减1.5手动领取券',1.50,0.00,'send',2,'2021-01-06 21:37:20','2021-01-06 21:37:20','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,3,NULL),
	(139,8,0,359,'通用满0减1.5手动领取券',1.50,0.00,'send',2,'2021-01-06 21:37:20','2021-01-06 21:37:20','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(140,29,0,359,'林更新同款商品优惠券',2.22,0.00,'send',2,'2021-01-06 21:37:22','2021-01-06 21:37:22','2021-01-06 00:00:00','2021-01-08 00:00:00',NULL,2,NULL),
	(141,30,0,360,'每日一新品类券',3.33,0.00,'send',2,'2021-01-07 08:37:00','2021-01-07 08:37:00','2021-01-07 00:00:00','2021-01-09 00:00:00',NULL,3,NULL),
	(142,29,0,360,'林更新同款商品优惠券',2.22,0.00,'send',2,'2021-01-07 08:37:05','2021-01-07 08:37:05','2021-01-07 00:00:00','2021-01-09 00:00:00',NULL,2,NULL),
	(143,30,0,37,'每日一新品类券',3.33,0.00,'send',2,'2021-01-07 11:03:20','2021-01-07 11:03:20','2021-01-07 00:00:00','2021-01-09 00:00:00',NULL,3,NULL),
	(146,31,0,37,'HZW专属券',1.00,0.00,'receive',1,'2021-01-07 14:21:31','2021-01-07 14:21:31','2021-01-07 00:00:00','2021-01-08 00:00:00',NULL,1,NULL),
	(147,32,0,37,'HZW时间段测试优惠券',1.00,0.00,'receive',2,'2021-01-07 14:31:43','2021-01-07 14:31:43','2021-01-07 00:00:00','2021-01-14 00:00:00',NULL,1,NULL),
	(148,33,0,37,'HZW未到时间通用券',1.00,0.00,'receive',2,'2021-01-07 14:33:59','2021-01-07 14:33:59','2021-01-10 08:00:00','2021-01-15 20:00:00',NULL,1,NULL),
	(149,25,0,37,'满218可以使用',9.99,218.00,'receive',2,'2021-01-07 15:11:49','2021-01-07 15:11:49','2021-01-07 15:11:49','2021-01-08 15:11:49',NULL,1,NULL),
	(150,26,0,37,'满169可用',5.55,169.00,'receive',2,'2021-01-07 15:11:53','2021-01-07 15:11:53','2021-01-07 15:11:53','2021-01-08 15:11:53',NULL,1,NULL),
	(151,32,0,44,'HZW时间段测试优惠券',1.00,0.00,'receive',2,'2021-01-07 16:10:08','2021-01-07 16:10:08','2021-01-07 00:00:00','2021-01-14 00:00:00',NULL,1,NULL),
	(152,30,0,44,'每日一新品类券',3.33,0.00,'receive',2,'2021-01-07 16:48:12','2021-01-07 16:48:12','2021-01-07 16:48:12','2021-01-08 16:48:12',NULL,3,NULL),
	(154,13,0,44,'品类满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-07 18:34:30','2021-01-07 18:34:30','2021-01-07 18:34:30','2021-01-08 18:34:30',NULL,3,NULL),
	(155,12,0,44,'品类满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-07 18:34:41','2021-01-07 18:34:41','2021-01-07 18:34:41','2021-01-08 18:34:41',NULL,3,NULL),
	(157,34,0,37,'HZW时间段测试优惠券1.7',1.00,0.00,'receive',2,'2021-01-07 19:40:09','2021-01-07 19:40:09','2021-01-07 00:00:00','2021-01-14 00:00:00',NULL,3,'291'),
	(158,36,0,37,'HZW品类测试券',5.00,0.00,'receive',2,'2021-01-07 19:40:53','2021-01-07 19:40:53','2021-01-07 19:40:53','2021-01-08 19:40:53',NULL,3,'516'),
	(159,32,0,365,'HZW时间段测试优惠券',1.00,0.00,'receive',2,'2021-01-09 03:12:46','2021-01-09 03:12:46','2021-01-07 00:00:00','2021-01-14 00:00:00',NULL,1,NULL),
	(160,33,0,365,'HZW未到时间通用券',1.00,0.00,'receive',2,'2021-01-09 03:12:49','2021-01-09 03:12:49','2021-01-10 08:00:00','2021-01-15 20:00:00',NULL,1,NULL),
	(161,28,0,365,'使用时间测试',1.11,0.00,'receive',2,'2021-01-09 03:12:52','2021-01-09 03:12:52','2020-12-23 00:00:00','2020-12-23 17:44:00',NULL,1,NULL),
	(162,27,0,365,'满159可用',6.66,159.00,'receive',2,'2021-01-09 03:12:55','2021-01-09 03:12:55','2021-01-09 03:12:55','2021-01-10 03:12:55',NULL,1,NULL),
	(163,26,0,365,'满169可用',5.55,169.00,'receive',2,'2021-01-09 03:12:57','2021-01-09 03:12:57','2021-01-09 03:12:57','2021-01-10 03:12:57',NULL,1,NULL),
	(164,25,0,365,'满218可以使用',9.99,218.00,'receive',2,'2021-01-09 03:13:00','2021-01-09 03:13:00','2021-01-09 03:13:00','2021-01-10 03:13:00',NULL,1,NULL),
	(165,13,0,32,'品类满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-11 09:59:38','2021-01-11 09:59:38','2021-01-11 09:59:38','2021-01-12 09:59:38',NULL,3,'516'),
	(166,13,0,34,'品类满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-11 10:01:06','2021-01-11 10:01:06','2021-01-11 10:01:06','2021-01-12 10:01:06',NULL,3,'516'),
	(167,13,0,37,'品类满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-12 11:44:28','2021-01-12 11:44:28','2021-01-12 11:44:28','2021-01-13 11:44:28',NULL,3,'516'),
	(168,32,0,375,'HZW时间段测试优惠券',1.00,0.00,'receive',2,'2021-01-12 16:07:59','2021-01-12 16:07:59','2021-01-07 00:00:00','2021-01-14 00:00:00',NULL,1,NULL),
	(169,36,0,375,'HZW品类测试券',5.00,0.00,'receive',2,'2021-01-12 16:37:44','2021-01-12 16:37:44','2021-01-12 16:37:44','2021-01-13 16:37:44',NULL,3,'516'),
	(170,32,0,376,'HZW时间段测试优惠券',1.00,0.00,'receive',2,'2021-01-12 17:06:21','2021-01-12 17:06:21','2021-01-07 00:00:00','2021-01-14 00:00:00',NULL,1,NULL),
	(171,36,0,376,'HZW品类测试券',5.00,0.00,'receive',2,'2021-01-12 17:06:22','2021-01-12 17:06:22','2021-01-12 17:06:22','2021-01-13 17:06:22',NULL,3,'516'),
	(172,33,0,376,'HZW未到时间通用券',1.00,0.00,'receive',2,'2021-01-12 17:06:23','2021-01-12 17:06:23','2021-01-10 08:00:00','2021-01-15 20:00:00',NULL,1,NULL),
	(173,30,0,376,'每日一新品类券',3.33,0.00,'receive',2,'2021-01-12 17:06:24','2021-01-12 17:06:24','2021-01-12 17:06:24','2021-01-13 17:06:24',NULL,3,'516'),
	(174,29,0,376,'林更新同款商品优惠券',2.22,0.00,'receive',2,'2021-01-12 17:06:24','2021-01-12 17:06:24','2021-01-12 17:06:24','2021-01-13 17:06:24',NULL,2,'18,19,17'),
	(175,30,0,375,'每日一新品类券',3.33,0.00,'receive',2,'2021-01-12 18:11:14','2021-01-12 18:11:14','2021-01-12 18:11:14','2021-01-13 18:11:14',NULL,3,'516'),
	(176,13,0,32,'品类满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-13 12:26:28','2021-01-13 12:26:28','2021-01-13 12:26:28','2021-01-14 12:26:28',NULL,3,'516'),
	(177,32,0,380,'HZW时间段测试优惠券',1.00,0.00,'receive',2,'2021-01-14 12:16:17','2021-01-14 12:16:17','2021-01-07 00:00:00','2021-01-14 00:00:00',NULL,1,NULL),
	(178,36,0,380,'HZW品类测试券',5.00,0.00,'receive',2,'2021-01-14 12:16:17','2021-01-14 12:16:17','2021-01-14 12:16:17','2021-01-15 12:16:17',NULL,3,'516'),
	(179,33,0,380,'HZW未到时间通用券',1.00,0.00,'receive',2,'2021-01-14 12:16:18','2021-01-14 12:16:18','2021-01-10 08:00:00','2021-01-15 20:00:00',NULL,1,NULL),
	(180,30,0,380,'每日一新品类券',3.33,0.00,'receive',2,'2021-01-14 12:16:19','2021-01-14 12:16:19','2021-01-14 12:16:19','2021-01-15 12:16:19',NULL,3,'516'),
	(181,29,0,380,'林更新同款商品优惠券',2.22,0.00,'receive',2,'2021-01-14 12:16:19','2021-01-14 12:16:19','2021-01-14 12:16:19','2021-01-15 12:16:19',NULL,2,'18,19,17'),
	(182,28,0,380,'使用时间测试',1.11,0.00,'receive',2,'2021-01-14 12:16:20','2021-01-14 12:16:20','2020-12-23 00:00:00','2020-12-23 17:44:00',NULL,1,NULL),
	(183,27,0,380,'满159可用',6.66,159.00,'receive',2,'2021-01-14 12:16:21','2021-01-14 12:16:21','2021-01-14 12:16:21','2021-01-15 12:16:21',NULL,1,NULL),
	(184,26,0,380,'满169可用',5.55,169.00,'receive',2,'2021-01-14 12:16:22','2021-01-14 12:16:22','2021-01-14 12:16:22','2021-01-15 12:16:22',NULL,1,NULL),
	(185,25,0,380,'满218可以使用',9.99,218.00,'receive',2,'2021-01-14 12:16:22','2021-01-14 12:16:22','2021-01-14 12:16:22','2021-01-15 12:16:22',NULL,1,NULL),
	(186,22,0,380,'领取后使用时间段测试',1.00,2.00,'receive',2,'2021-01-14 12:16:26','2021-01-14 12:16:26','2020-12-25 08:00:00','2020-12-31 20:00:00',NULL,1,NULL),
	(187,21,0,380,'领取后使用时间测试',1.00,0.00,'receive',2,'2021-01-14 12:16:26','2021-01-14 12:16:26','2021-01-14 12:16:26','2021-01-15 12:16:26',NULL,1,NULL),
	(188,36,0,52,'HZW品类测试券',5.00,0.00,'receive',2,'2021-01-14 15:25:50','2021-01-14 15:25:50','2021-01-14 15:25:50','2021-01-15 15:25:50',NULL,3,'516'),
	(189,13,0,52,'品类满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-14 15:26:04','2021-01-14 15:26:04','2021-01-14 15:26:04','2021-01-15 15:26:04',NULL,3,'516'),
	(190,8,0,52,'通用满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-14 15:26:06','2021-01-14 15:31:09','2021-01-14 15:26:06','2021-01-15 15:26:06',NULL,1,NULL),
	(191,13,0,32,'品类满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-15 09:18:05','2021-01-15 09:18:05','2021-01-15 09:18:05','2021-01-16 09:18:05',NULL,3,'516'),
	(192,32,0,381,'HZW时间段测试优惠券',1.00,0.00,'receive',2,'2021-01-15 10:36:27','2021-01-15 10:36:27','2021-01-07 00:00:00','2021-01-14 00:00:00',NULL,1,NULL),
	(193,36,0,381,'HZW品类测试券',5.00,0.00,'receive',2,'2021-01-15 10:36:28','2021-01-15 10:36:28','2021-01-15 10:36:28','2021-01-16 10:36:28',NULL,3,'516'),
	(194,33,0,381,'HZW未到时间通用券',1.00,0.00,'receive',2,'2021-01-15 10:36:31','2021-01-15 10:36:31','2021-01-10 08:00:00','2021-01-15 20:00:00',NULL,1,NULL),
	(195,30,0,381,'每日一新品类券',3.33,0.00,'receive',2,'2021-01-15 10:36:33','2021-01-15 10:36:33','2021-01-15 10:36:33','2021-01-16 10:36:33',NULL,3,'516'),
	(196,29,0,381,'林更新同款商品优惠券',2.22,0.00,'receive',2,'2021-01-15 10:36:35','2021-01-15 10:36:35','2021-01-15 10:36:35','2021-01-16 10:36:35',NULL,2,'18,19,17'),
	(197,28,0,381,'使用时间测试',1.11,0.00,'receive',2,'2021-01-15 10:36:35','2021-01-15 10:36:35','2020-12-23 00:00:00','2020-12-23 17:44:00',NULL,1,NULL),
	(198,27,0,381,'满159可用',6.66,159.00,'receive',2,'2021-01-15 10:36:36','2021-01-15 10:36:36','2021-01-15 10:36:36','2021-01-16 10:36:36',NULL,1,NULL),
	(199,26,0,381,'满169可用',5.55,169.00,'receive',2,'2021-01-15 10:36:37','2021-01-15 10:36:37','2021-01-15 10:36:37','2021-01-16 10:36:37',NULL,1,NULL),
	(200,25,0,381,'满218可以使用',9.99,218.00,'receive',2,'2021-01-15 10:36:38','2021-01-15 10:36:38','2021-01-15 10:36:38','2021-01-16 10:36:38',NULL,1,NULL),
	(201,22,0,381,'领取后使用时间段测试',1.00,2.00,'receive',2,'2021-01-15 10:36:39','2021-01-15 10:36:39','2020-12-25 08:00:00','2020-12-31 20:00:00',NULL,1,NULL),
	(202,21,0,381,'领取后使用时间测试',1.00,0.00,'receive',2,'2021-01-15 10:36:39','2021-01-15 10:36:39','2021-01-15 10:36:39','2021-01-16 10:36:39',NULL,1,NULL),
	(203,20,0,381,'优惠券库存数量测试000',10.00,2000.00,'receive',2,'2021-01-15 10:36:40','2021-01-15 10:36:40','2021-01-15 10:36:40','2021-01-16 10:36:40',NULL,1,NULL),
	(204,19,0,381,'品类满100减1.5手动领取券',1.50,100.00,'receive',2,'2021-01-15 10:36:41','2021-01-15 10:36:41','2021-01-15 10:36:41','2021-01-16 10:36:41',NULL,3,'516'),
	(205,16,0,381,'通用满0减1.5手动人券',1.50,1.00,'receive',2,'2021-01-15 10:36:42','2021-01-15 10:36:42','2021-01-15 10:36:42','2021-01-16 10:36:42',NULL,1,NULL),
	(206,13,0,381,'品类满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-15 10:36:42','2021-01-15 10:36:42','2021-01-15 10:36:42','2021-01-16 10:36:42',NULL,3,'516'),
	(207,12,0,381,'品类满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-15 10:36:43','2021-01-15 10:36:43','2021-01-15 10:36:43','2021-01-16 10:36:43',NULL,3,'516'),
	(208,8,0,381,'通用满0减1.5手动领取券',1.50,0.00,'receive',2,'2021-01-15 10:36:44','2021-01-15 10:36:44','2021-01-15 10:36:44','2021-01-16 10:36:44',NULL,1,NULL),
	(209,32,0,381,'HZW时间段测试优惠券',1.00,0.00,'receive',2,'2021-01-15 10:36:45','2021-01-15 10:36:45','2021-01-07 00:00:00','2021-01-14 00:00:00',NULL,1,NULL),
	(210,41,0,57,'门槛1000券',1.00,1000.00,'receive',2,'2021-01-15 10:52:41','2021-01-15 10:52:41','2021-01-15 10:52:41','2021-01-16 10:52:41',NULL,1,NULL),
	(211,42,0,52,'门槛99券',1.00,99.00,'receive',1,'2021-01-15 10:53:29','2021-01-15 10:53:29','2021-01-15 10:53:29','2021-01-16 10:53:29',NULL,1,NULL),
	(212,42,0,57,'门槛99券',1.00,99.00,'receive',2,'2021-01-15 10:53:29','2021-01-15 10:53:29','2021-01-15 10:53:29','2021-01-16 10:53:29',NULL,1,NULL),
	(213,43,0,52,'使用时间测试券000',1.00,0.00,'receive',2,'2021-01-15 11:00:43','2021-01-15 11:00:43','2021-01-15 11:00:43','2021-01-16 11:00:43',NULL,1,NULL),
	(214,44,0,52,'年终极品优惠券0000',1.00,99.00,'receive',0,'2021-01-15 11:03:55','2021-01-15 11:03:55','2021-02-11 00:00:00','2021-02-26 00:00:00',NULL,1,NULL),
	(215,40,0,52,'门槛100券',1.00,100.00,'receive',2,'2021-01-15 11:09:22','2021-01-15 11:09:22','2021-01-15 11:09:22','2021-01-16 11:09:22',NULL,3,'516'),
	(216,46,0,52,'卓丹；品类券',200.00,0.00,'receive',2,'2021-01-15 11:19:25','2021-01-15 11:19:25','2021-01-15 11:19:25','2021-01-16 11:19:25',NULL,3,'516'),
	(217,45,0,52,'卓丹；商品券000',100.00,0.00,'receive',2,'2021-01-15 11:19:26','2021-01-15 11:19:26','2021-01-15 11:19:26','2021-01-16 11:19:26',NULL,2,'28,29'),
	(218,45,0,37,'卓丹；商品券000',100.00,0.00,'receive',2,'2021-01-15 11:29:22','2021-01-15 11:29:22','2021-01-15 11:29:22','2021-01-16 11:29:22',NULL,2,'28,29'),
	(219,39,0,44,'手动领取品类券01',1.00,0.00,'receive',2,'2021-01-15 11:35:23','2021-01-15 11:35:23','2021-01-15 11:35:23','2021-01-16 11:35:23',NULL,3,'516'),
	(220,32,0,382,'HZW时间段测试优惠券',1.00,0.00,'receive',2,'2021-01-15 17:44:39','2021-01-15 17:44:39','2021-01-07 00:00:00','2021-01-14 00:00:00',NULL,1,NULL),
	(221,47,0,57,'通用券01',1.00,0.00,'receive',2,'2021-01-16 11:18:17','2021-01-16 11:18:17','2021-01-16 11:18:17','2021-01-17 11:18:17',NULL,1,NULL),
	(222,49,0,57,'品类券01',1.00,0.00,'receive',2,'2021-01-16 11:18:18','2021-01-16 11:18:18','2021-01-16 11:18:18','2021-01-17 11:18:18',NULL,3,'530'),
	(223,48,0,57,'商品券01',1.00,0.00,'receive',2,'2021-01-16 11:18:18','2021-01-16 11:18:18','2021-01-16 11:18:18','2021-01-17 11:18:18',NULL,2,'30,29,28'),
	(224,51,0,52,'赠送券01',1.00,0.00,'receive',2,'2021-01-16 11:37:29','2021-01-16 11:37:29','2021-01-16 11:37:29','2021-01-17 11:37:29',NULL,1,NULL),
	(225,47,0,385,'通用券01',1.00,0.00,'receive',2,'2021-01-16 11:53:33','2021-01-16 11:53:33','2021-01-16 11:53:33','2021-01-17 11:53:33',NULL,1,NULL),
	(226,52,0,57,'领取时间测试券01',3.00,0.00,'receive',0,'2021-01-16 11:58:45','2021-01-16 11:58:45','2021-01-16 00:00:00','2021-01-31 00:00:00',NULL,1,NULL),
	(227,43,0,386,'使用时间测试券000',1.00,0.00,'receive',2,'2021-01-16 12:01:03','2021-01-16 12:01:03','2021-01-16 12:01:03','2021-01-17 12:01:03',NULL,1,NULL),
	(228,53,0,386,'领取数量测试券01',3.00,0.00,'receive',2,'2021-01-16 12:01:28','2021-01-16 12:01:28','2021-01-16 12:01:28','2021-01-17 12:01:28',NULL,1,NULL),
	(229,43,0,57,'使用时间测试券000',1.00,0.00,'receive',2,'2021-01-16 12:02:48','2021-01-16 12:02:48','2021-01-16 12:02:48','2021-01-17 12:02:48',NULL,1,NULL),
	(230,58,0,386,'使用测试：1399门槛券01',199.00,1399.00,'receive',2,'2021-01-16 12:13:02','2021-01-16 12:13:02','2021-01-16 12:13:02','2021-01-17 12:13:02',NULL,1,NULL),
	(231,57,0,386,'使用测试：篮球鞋分类001',10.00,0.00,'receive',2,'2021-01-16 12:13:03','2021-01-16 12:13:03','2021-01-16 12:13:03','2021-01-17 12:13:03',NULL,3,'529'),
	(232,56,0,386,'使用测试：JORDNA商品券001',10.00,0.00,'receive',2,'2021-01-16 12:13:04','2021-01-16 12:13:04','2021-01-16 12:13:04','2021-01-17 12:13:04',NULL,2,'28,29,30'),
	(233,55,0,386,'使用测试：通用券001',10.00,0.00,'receive',2,'2021-01-16 12:13:05','2021-01-16 12:13:05','2021-01-16 12:13:05','2021-01-17 12:13:05',NULL,1,NULL),
	(234,59,0,386,'使用测试：JORDNA商品券002',10.00,0.00,'receive',2,'2021-01-16 12:26:44','2021-01-16 12:26:44','2021-01-16 12:26:44','2021-01-17 12:26:44',NULL,2,'30,29,28'),
	(235,59,0,52,'使用测试：JORDNA商品券002',10.00,0.00,'receive',2,'2021-01-16 14:07:58','2021-01-16 14:07:58','2021-01-16 14:07:58','2021-01-17 14:07:58',NULL,2,'30,29,28'),
	(236,58,0,52,'使用测试：1399门槛券01',199.00,1399.00,'receive',2,'2021-01-16 14:08:00','2021-01-16 14:08:00','2021-01-16 14:08:00','2021-01-17 14:08:00',NULL,1,NULL),
	(237,56,0,52,'使用测试：JORDNA商品券001',10.00,0.00,'receive',2,'2021-01-16 14:08:03','2021-01-16 14:08:03','2021-01-16 14:08:03','2021-01-17 14:08:03',NULL,2,'28,29,30'),
	(238,55,0,52,'使用测试：通用券001',10.00,0.00,'receive',2,'2021-01-16 14:08:06','2021-01-16 14:08:06','2021-01-16 14:08:06','2021-01-17 14:08:06',NULL,1,NULL),
	(239,60,0,52,'使用测试：JORDNA商品券003',10.00,0.00,'receive',1,'2021-01-16 14:24:52','2021-01-16 14:24:52','2021-01-16 14:24:52','2021-01-17 14:24:52',NULL,2,'30,29,28'),
	(240,61,0,52,'使用测试：使用过期时间测试',1.00,0.00,'receive',2,'2021-01-16 14:37:28','2021-01-16 14:37:28','2021-01-16 00:00:00','2021-01-16 14:37:00',NULL,1,NULL),
	(241,51,0,52,'赠送券01',1.00,0.00,'receive',0,'2021-01-18 12:23:22','2021-01-18 12:23:22','2021-01-18 12:23:22','2021-01-19 12:23:22',NULL,1,NULL),
	(242,50,0,52,'新人券01',2.00,0.00,'receive',0,'2021-01-18 12:23:22','2021-01-18 12:23:22','2021-01-18 12:23:22','2021-01-19 12:23:22',NULL,1,NULL),
	(243,49,0,52,'品类券01',1.00,0.00,'receive',0,'2021-01-18 12:23:22','2021-01-18 12:23:22','2021-01-18 12:23:22','2021-01-19 12:23:22',NULL,3,'530'),
	(244,48,0,52,'商品券01',1.00,0.00,'receive',0,'2021-01-18 12:23:22','2021-01-18 12:23:22','2021-01-18 12:23:22','2021-01-19 12:23:22',NULL,2,'30,29,28'),
	(245,51,0,35,'赠送券01',1.00,0.00,'receive',0,'2021-01-18 12:31:22','2021-01-18 12:31:22','2021-01-18 12:31:22','2021-01-19 12:31:22',NULL,1,NULL),
	(246,50,0,35,'新人券01',2.00,0.00,'receive',0,'2021-01-18 12:31:22','2021-01-18 12:31:22','2021-01-18 12:31:22','2021-01-19 12:31:22',NULL,1,NULL),
	(247,49,0,35,'品类券01',1.00,0.00,'receive',0,'2021-01-18 12:31:22','2021-01-18 12:31:22','2021-01-18 12:31:22','2021-01-19 12:31:22',NULL,3,'530'),
	(248,48,0,35,'商品券01',1.00,0.00,'receive',0,'2021-01-18 12:31:22','2021-01-18 12:31:22','2021-01-18 12:31:22','2021-01-19 12:31:22',NULL,2,'30,29,28'),
	(249,51,0,32,'赠送券01',1.00,0.00,'receive',0,'2021-01-18 14:46:09','2021-01-18 14:46:09','2021-01-18 14:46:09','2021-01-19 14:46:09',NULL,1,NULL),
	(250,50,0,32,'新人券01',2.00,0.00,'receive',0,'2021-01-18 14:46:09','2021-01-18 14:46:09','2021-01-18 14:46:09','2021-01-19 14:46:09',NULL,1,NULL),
	(251,49,0,32,'品类券01',1.00,0.00,'receive',0,'2021-01-18 14:46:09','2021-01-18 14:46:09','2021-01-18 14:46:09','2021-01-19 14:46:09',NULL,3,'530'),
	(252,48,0,32,'商品券01',1.00,0.00,'receive',0,'2021-01-18 14:46:09','2021-01-18 14:46:09','2021-01-18 14:46:09','2021-01-19 14:46:09',NULL,2,'30,29,28'),
	(253,51,0,37,'赠送券01',1.00,0.00,'receive',0,'2021-01-18 15:18:52','2021-01-18 15:18:52','2021-01-18 15:18:52','2021-01-19 15:18:52',NULL,1,NULL),
	(254,50,0,37,'新人券01',2.00,0.00,'receive',0,'2021-01-18 15:18:52','2021-01-18 15:18:52','2021-01-18 15:18:52','2021-01-19 15:18:52',NULL,1,NULL),
	(255,49,0,37,'品类券01',1.00,0.00,'receive',0,'2021-01-18 15:18:52','2021-01-18 15:18:52','2021-01-18 15:18:52','2021-01-19 15:18:52',NULL,3,'530'),
	(256,48,0,37,'商品券01',1.00,0.00,'receive',0,'2021-01-18 15:18:52','2021-01-18 15:18:52','2021-01-18 15:18:52','2021-01-19 15:18:52',NULL,2,'30,29,28');

/*!40000 ALTER TABLE `eb_store_coupon_user` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_order
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_order`;

CREATE TABLE `eb_store_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单ID',
  `order_id` varchar(32) NOT NULL COMMENT '订单号',
  `uid` int(11) unsigned NOT NULL COMMENT '用户id',
  `real_name` varchar(32) NOT NULL COMMENT '用户姓名',
  `user_phone` varchar(18) NOT NULL COMMENT '用户电话',
  `user_address` varchar(100) NOT NULL COMMENT '详细地址',
  `freight_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '运费金额',
  `total_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单商品总数',
  `total_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单总价',
  `total_postage` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '邮费',
  `pay_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '实际支付金额',
  `pay_postage` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '支付邮费',
  `deduction_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '抵扣金额',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券id',
  `coupon_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '优惠券金额',
  `paid` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '支付状态',
  `pay_time` timestamp NULL DEFAULT NULL COMMENT '支付时间',
  `pay_type` varchar(32) NOT NULL COMMENT '支付方式',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态（0：待发货；1：待收货；2：已收货，待评价；3：已完成；）',
  `refund_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0 未退款 1 申请中 2 已退款 3 退款中',
  `refund_reason_wap_img` varchar(5000) DEFAULT NULL COMMENT '退款图片',
  `refund_reason_wap_explain` varchar(255) DEFAULT NULL COMMENT '退款用户说明',
  `refund_reason_wap` varchar(255) DEFAULT NULL COMMENT '前台退款原因',
  `refund_reason` varchar(255) DEFAULT NULL COMMENT '不退款的理由',
  `refund_reason_time` timestamp NULL DEFAULT NULL COMMENT '退款时间',
  `refund_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `delivery_name` varchar(64) DEFAULT NULL COMMENT '快递名称/送货人姓名',
  `delivery_type` varchar(32) DEFAULT NULL COMMENT '发货类型',
  `delivery_id` varchar(64) DEFAULT NULL COMMENT '快递单号/手机号',
  `gain_integral` int(11) DEFAULT '0' COMMENT '消费赚取积分',
  `use_integral` int(11) DEFAULT '0' COMMENT '使用积分',
  `back_integral` int(11) DEFAULT '0' COMMENT '给用户退了多少积分',
  `mark` varchar(512) NOT NULL COMMENT '备注',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `unique` char(32) NOT NULL COMMENT '唯一id(md5加密)类似id',
  `remark` varchar(512) DEFAULT NULL COMMENT '管理员备注',
  `mer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商户ID',
  `is_mer_check` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `combination_id` int(11) unsigned DEFAULT '0' COMMENT '拼团商品id0一般商品',
  `pink_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '拼团id 0没有拼团',
  `cost` decimal(8,2) unsigned NOT NULL COMMENT '成本价',
  `seckill_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `bargain_id` int(11) unsigned DEFAULT '0' COMMENT '砍价id',
  `verify_code` varchar(12) NOT NULL DEFAULT '' COMMENT '核销码',
  `store_id` int(11) NOT NULL DEFAULT '0' COMMENT '门店id',
  `shipping_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '配送方式 1=快递 ，2=门店自提',
  `clerk_id` int(11) NOT NULL DEFAULT '0' COMMENT '店员id/核销员id',
  `is_channel` tinyint(1) unsigned DEFAULT '0' COMMENT '支付渠道(0微信公众号1微信小程序2余额)',
  `is_remind` tinyint(1) unsigned DEFAULT '0' COMMENT '消息提醒',
  `is_system_del` tinyint(1) DEFAULT '0' COMMENT '后台是否删除',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `delivery_code` varchar(50) DEFAULT NULL COMMENT '快递公司简称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `order_id_2` (`order_id`,`uid`) USING BTREE,
  UNIQUE KEY `unique` (`unique`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `add_time` (`create_time`) USING BTREE,
  KEY `pay_price` (`pay_price`) USING BTREE,
  KEY `paid` (`paid`) USING BTREE,
  KEY `pay_time` (`pay_time`) USING BTREE,
  KEY `pay_type` (`pay_type`) USING BTREE,
  KEY `status` (`status`) USING BTREE,
  KEY `is_del` (`is_del`) USING BTREE,
  KEY `coupon_id` (`coupon_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单表';

LOCK TABLES `eb_store_order` WRITE;
/*!40000 ALTER TABLE `eb_store_order` DISABLE KEYS */;

INSERT INTO `eb_store_order` (`id`, `order_id`, `uid`, `real_name`, `user_phone`, `user_address`, `freight_price`, `total_num`, `total_price`, `total_postage`, `pay_price`, `pay_postage`, `deduction_price`, `coupon_id`, `coupon_price`, `paid`, `pay_time`, `pay_type`, `create_time`, `status`, `refund_status`, `refund_reason_wap_img`, `refund_reason_wap_explain`, `refund_reason_wap`, `refund_reason`, `refund_reason_time`, `refund_price`, `delivery_name`, `delivery_type`, `delivery_id`, `gain_integral`, `use_integral`, `back_integral`, `mark`, `is_del`, `unique`, `remark`, `mer_id`, `is_mer_check`, `combination_id`, `pink_id`, `cost`, `seckill_id`, `bargain_id`, `verify_code`, `store_id`, `shipping_type`, `clerk_id`, `is_channel`, `is_remind`, `is_system_del`, `update_time`, `delivery_code`)
VALUES
	(3,'wx2020120814523442599',4,'裴明','18292417675','陕西省西安市雁塔区曲江三迪枫丹(西安市雁塔区)',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-08 14:52:34',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'eba52e5b454393b0474a246dfbb331ed',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-08 14:52:34',NULL),
	(4,'wx2020120814564193287',1,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2020-12-08 14:56:42','yue','2020-12-08 14:56:41',1,0,NULL,'用户取消拼团订单，申请退款',NULL,'就不退','2020-12-09 14:57:00',99.00,NULL,NULL,NULL,0,0,NULL,'',0,'d0a960ab37f241d21ac5aff9ad05d2aa',NULL,0,0,1,1,9.00,0,0,'',0,1,0,0,0,0,'2020-12-09 15:27:13',NULL),
	(5,'wx2020120914341124901',11,'王超超','18741256325','陕西省西安市新城区韩森寨',0.00,1,99.00,1.00,100.00,1.00,0.00,0,0.00,0,NULL,'weixin','2020-12-09 14:34:11',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'5e86ff22b76d8a702266b9ba9849ac0f',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-09 14:34:11',NULL),
	(6,'wx2020120916400840588',12,'pmm','18292417675','山西省太原市市辖区xxx',0.00,1,99.00,1.00,100.00,1.00,0.00,0,0.00,1,'2020-12-09 16:40:09','yue','2020-12-09 16:40:08',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'0364228d2586798b472ba695ff871e22',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-09 16:40:08',NULL),
	(7,'wx2020121010100962322',11,'王超超','18741256325','陕西省西安市新城区韩森寨',0.00,1,0.00,1.00,1.00,1.00,0.00,1,0.00,1,'2020-12-10 10:10:48','yue','2020-12-10 10:10:09',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'17c5defbce0434da90792d69e32bd58e',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-10 10:10:47',NULL),
	(8,'wx2020121010333151706',14,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-10 10:33:31',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'7d74b9aaffbc4af8f3497a224be12754',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-10 10:33:31',NULL),
	(9,'wx2020121010335820375',14,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-10 10:33:58',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'c295990b159f66a3d11061af139e2c85',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-10 10:33:58',NULL),
	(10,'wx2020121015281113274',19,'小脑斧','13991666666','河南省郑州市二七区手术室',0.00,1,99.00,1.00,100.00,1.00,0.00,0,0.00,1,'2020-12-10 15:28:12','yue','2020-12-10 15:28:11',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'d074a1b539fa3808d72b9085d5de0fda',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-10 15:28:11',NULL),
	(11,'wx2020121115214342940',19,'小脑斧','13991666666','河南省郑州市二七区手术室',0.00,1,10.00,1.00,11.00,1.00,0.00,0,0.00,1,'2020-12-11 15:21:44','yue','2020-12-11 15:21:43',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'3e9abf0d940139662e48943a001d43f1',NULL,0,0,0,0,0.00,2,0,'',0,1,0,0,0,0,'2020-12-11 15:21:43',NULL),
	(12,'wx2020121417063762574',31,'小脑虎','18888888888','陕西省西安市市辖区哈罗闪问',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-14 17:06:43','weixin','2020-12-14 17:06:37',1,1,'','','收货地址填错了',NULL,'2020-12-31 14:31:04',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'6dbacab06bada2baff73b0cc57c3eb86',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:37',NULL),
	(13,'wx2020121509310499980',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2020-12-15 09:31:04','yue','2020-12-15 09:31:04',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'12478683083d4ff3ee0b982ed0fe3ad0',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-15 09:31:04',NULL),
	(14,'wx2020121509571880738',34,'弄','13000000000','山西省太原市小店区哦吼',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-15 09:57:18',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',1,'3e140d88ca25f0eea4864247a09f07c0',NULL,0,0,0,0,50.00,0,6,'',0,1,0,0,0,0,'2020-12-24 16:00:30',NULL),
	(15,'wx2020121510242722269',34,'哦破功','13000000000','山西省太原市迎泽区我咯后',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,1,'2020-12-15 10:24:28','yue','2020-12-15 10:24:27',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'cbd550728e6e54746adb962d98510fce',NULL,0,0,0,0,9.00,0,1,'',0,1,0,0,0,0,'2020-12-15 10:24:28',NULL),
	(16,'wx2020121510340894903',34,'你明明','13000000000','山西省太原市迎泽区您咯咯',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,1,'2020-12-15 10:34:09','yue','2020-12-15 10:34:08',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'f8644284cc2d58f9e21772506165487c',NULL,0,0,0,0,9.00,0,1,'',0,1,0,0,0,0,'2020-12-15 10:34:08',NULL),
	(17,'wx2020121512091540969',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,1,'2020-12-15 12:09:16','yue','2020-12-15 12:09:15',1,2,'','','收货地址填错了',NULL,'2020-12-15 12:09:49',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'90db80982fb8ba6784bee9ac22639fc7',NULL,0,0,0,0,50.00,0,7,'',0,1,0,0,0,0,'2021-01-06 11:55:37',NULL),
	(18,'wx2020121512220125249',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,1,'2020-12-15 12:22:01','yue','2020-12-15 12:22:01',1,2,'','','收货地址填错了',NULL,'2020-12-15 12:22:33',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'5e3db13cd8990ef5f73458a5333d62e0',NULL,0,0,0,0,50.00,0,8,'',0,1,0,0,0,0,'2021-01-06 11:55:37',NULL),
	(19,'wx2020121610080832644',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-16 10:08:09','yue','2020-12-16 10:08:08',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'b7b9ee4b8671ae84db3f0a7e31795617',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-16 10:08:08',NULL),
	(20,'wx2020121710255399818',34,'哦看看','13000000000','山西省太原市小店区天空',0.00,1,10.00,0.00,10.00,0.00,0.00,0,0.00,1,'2020-12-17 10:25:54','yue','2020-12-17 10:25:53',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'88916ec80741bc7cced824a598336d40',NULL,0,0,0,0,50.00,0,9,'1103802502',1,2,0,0,0,0,'2020-12-17 10:25:53',NULL),
	(21,'wx2020121710500477396',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10.00,0.00,10.00,0.00,0.00,0,0.00,1,'2020-12-17 10:50:04','yue','2020-12-17 10:50:04',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'宅急送','express','4271130024851',0,0,NULL,'',0,'265aeb96f3ed7834b5ebe907c2a6031f',NULL,0,0,0,0,50.00,0,9,'',0,1,0,0,0,0,'2020-12-17 16:35:49','yunda'),
	(22,'wx2020121711011792401',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-17 11:01:18','yue','2020-12-17 11:01:17',2,0,NULL,NULL,NULL,NULL,NULL,0.00,'中远快运','express','11111111',0,0,NULL,'',0,'42894127e7be235cb964059c35a76840',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-31 15:25:28','zy100'),
	(23,'wx2020121711094336795',31,'小小小','18788888888','陕西省西安市市辖区哈罗闪问',0.00,1,0.00,0.00,0.00,0.00,0.00,3,0.00,1,'2020-12-17 11:09:43','yue','2020-12-17 11:09:43',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'666',0,'01055c01576e4ad9f55a0e34afb9cce1',NULL,0,0,0,0,50.00,0,8,'1014441745',1,2,0,0,0,0,'2020-12-17 11:09:43',NULL),
	(24,'wx2020121711164951593',31,'哦哦哦哦哦哦哦哦哦','13996969696','陕西省西安市市辖区哈罗闪问',0.00,1,0.00,0.00,0.00,0.00,0.00,3,0.00,1,'2020-12-17 11:16:50','yue','2020-12-17 11:16:49',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'老兰家',0,'08f4fbf72f10572d27988a63f9da3c1b',NULL,0,0,0,0,50.00,0,8,'1008360594',1,2,0,0,0,0,'2020-12-17 11:16:49',NULL),
	(25,'wx2020121711191485032',31,'骷髅精灵','13255568866','陕西省西安市市辖区哈罗闪问',0.00,1,0.00,0.00,0.00,0.00,0.00,3,0.00,1,'2020-12-17 11:19:14','yue','2020-12-17 11:19:14',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'事情',0,'9ba4aadc7f097ab202522e4781879d83',NULL,0,0,0,0,50.00,0,8,'1061693849',1,2,0,0,0,0,'2020-12-17 11:19:14',NULL),
	(26,'wx2020121711275488287',31,'家里','13566666666','陕西省西安市市辖区哈罗闪问',0.00,1,10.00,0.00,10.00,0.00,0.00,0,0.00,1,'2020-12-17 11:27:54','yue','2020-12-17 11:27:54',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'682cd420febfd6ae864e8b3c49f274c1',NULL,0,0,0,0,50.00,0,9,'1049718718',1,2,31,0,0,0,'2021-01-04 10:25:04',NULL),
	(27,'wx2020121715303097225',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-17 15:30:30','yue','2020-12-17 15:30:30',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'84fe2ed4bbeb28e3e3bdf1a2d199e513','000',0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-18 10:11:01',NULL),
	(28,'wx2020121715484227501',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-17 15:48:42','yue','2020-12-17 15:48:42',1,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'297a613384792fa66594d15373333965',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-17 16:50:45',NULL),
	(29,'wx2020121810312869500',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-18 10:31:29','yue','2020-12-18 10:31:28',0,2,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-18 11:32:00',100.00,NULL,NULL,NULL,0,0,NULL,'',0,'c5f5bbf4365d099b110a17ed98c1e588',NULL,0,0,6,2,200.00,0,0,'',0,1,0,0,0,0,'2020-12-18 14:11:01',NULL),
	(33,'wx2020121812200429132',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-18 12:20:04','yue','2020-12-18 12:20:04',0,2,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-18 13:21:00',10000.00,NULL,NULL,NULL,0,0,NULL,'',0,'e8f69cd65673aecb396f90cf9be14044',NULL,0,0,5,3,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-18 14:12:06',NULL),
	(34,'wx2020121816074924636',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-18 16:07:49','yue','2020-12-18 16:07:49',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'77f6fc287ccee9f82c5083355e53635d',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-18 16:07:49',NULL),
	(35,'wx2020121816133212326',31,'小脑虎','18888888888','陕西省西安市市辖区哈罗闪问',0.00,1,0.00,0.00,0.00,0.00,0.00,3,0.00,1,'2020-12-18 16:13:32','yue','2020-12-18 16:13:32',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'a6ee8b02133926114264cb0996385073',NULL,0,0,0,0,50.00,0,8,'',0,1,0,0,0,0,'2020-12-18 16:13:32',NULL),
	(36,'wx2020121816145190688',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-18 16:14:51','yue','2020-12-18 16:14:51',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'59fbe1f11aa4ab5ce7f61730cad1ec73',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-18 16:16:36',NULL),
	(37,'wx2020121816185070850',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-18 16:18:50','yue','2020-12-18 16:18:50',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'004471afdbc19b9cf31d85fce2d4d674',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-18 16:19:28',NULL),
	(38,'wx2020121816221255319',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-18 16:22:12','yue','2020-12-18 16:22:12',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'d6d25617ad27e8cd22d8f5c3e45e8201',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-18 16:22:12',NULL),
	(39,'wx2020121816340982642',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-18 16:34:09','yue','2020-12-18 16:34:09',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'5ac05427021aa8ac4de36b794cfd264d',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-18 16:34:28',NULL),
	(40,'wx2020122109200782038',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 09:20:07','yue','2020-12-21 09:20:07',0,2,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 10:21:00',100.00,NULL,NULL,NULL,0,0,NULL,'',0,'b1876fa24c9d9b21aae3a5995043585b',NULL,0,0,6,4,200.00,0,0,'',0,1,0,0,0,0,'2020-12-21 10:44:34',NULL),
	(41,'wx2020122109521158533',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 09:52:11','yue','2020-12-21 09:52:11',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 10:53:00',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'7579be4beba7a4825ae8109d8c7cae68',NULL,0,0,6,5,200.00,0,0,'',0,1,0,0,0,0,'2020-12-21 10:53:00',NULL),
	(47,'wx2020122110275816086',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 10:27:58','yue','2020-12-21 10:27:58',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 11:28:00',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'af5bb6da7f1468bf3332362a795e7c97',NULL,0,0,5,6,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 11:28:00',NULL),
	(48,'wx2020122110292756428',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 10:29:27','yue','2020-12-21 10:29:27',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 11:30:00',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'dd0ff4df55061cc0a5c10da16ddaa291',NULL,0,0,5,7,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 11:30:00',NULL),
	(49,'wx2020122110321878437',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 10:32:18','yue','2020-12-21 10:32:18',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'e856dd148adb1ba3e2567d5efe937384',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 10:32:18',NULL),
	(50,'wx2020122114074074895',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,0.00,0.00,0.00,0.00,0.00,5,0.00,1,'2020-12-21 14:07:41','yue','2020-12-21 14:07:40',1,2,'','123','收货地址填错了',NULL,'2020-12-21 14:13:07',0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'7b9e1daf07979b5751c5777c4776941e',NULL,0,0,0,0,50.00,0,8,'',0,1,0,0,0,0,'2021-01-06 11:55:37',NULL),
	(51,'wx2020122114233252378',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 14:23:32','yue','2020-12-21 14:23:32',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 15:24:00',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'2747266eda56c1c79c6bc766c9b594e7',NULL,0,0,5,8,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 15:24:00',NULL),
	(53,'wx2020122114282959962',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 14:28:29','yue','2020-12-21 14:28:29',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 14:33:41',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'a39314b38b269b594c580114148d1f44',NULL,0,0,5,9,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:31:46',NULL),
	(60,'wx2020122114511734340',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 14:51:18','yue','2020-12-21 14:51:17',0,2,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 14:54:49',10000.00,NULL,NULL,NULL,0,0,NULL,'',0,'3bd11f69f8913d71cc7ab68ec7a36d12',NULL,0,0,5,10,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:32:05',NULL),
	(62,'wx2020122115114984625',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 15:11:49','yue','2020-12-21 15:11:49',1,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'0e27a1b967182ebd05ce77f152318a4e',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 15:12:05',NULL),
	(63,'wx2020122115223548316',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,0.00,0.00,0.00,0.00,0.00,14,0.00,1,'2020-12-21 15:22:36','yue','2020-12-21 15:22:35',1,2,'','','收货地址填错了',NULL,'2020-12-21 15:22:47',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'382b66c8fae905d0cb5f3bc4828ba235',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:37',NULL),
	(64,'wx2020122115233996100',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,0.00,0.00,0.00,0.00,0.00,14,0.00,1,'2020-12-21 15:23:39','yue','2020-12-21 15:23:39',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'b0e678ab2612866580143d45b937969d',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 15:23:39',NULL),
	(65,'wx2020122115262677348',36,'裴明','18292417675','陕西省西安市雁塔区曲江三迪枫丹(西安市雁塔区)',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-21 15:26:26',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'69f3b042a4608d7b442c309b85366f00',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 15:26:26',NULL),
	(66,'wx2020122115331955777',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 15:33:19','yue','2020-12-21 15:33:19',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'425ab0db61672dbf4a613c5b6ca909fb',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 16:15:46',NULL),
	(67,'wx2020122115424487003',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 15:42:44','yue','2020-12-21 15:42:44',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'64e80f0755aefd2b3092bc33f7431aa9',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 16:00:48',NULL),
	(68,'wx2020122116481683827',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 16:48:16','yue','2020-12-21 16:48:16',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'6a1e5bd75651c840c650cca6d24e7e1e',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 16:48:16',NULL),
	(70,'wx2020122117264652661',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,9999.00,0.00,9999.00,0.00,0.00,0,0.00,1,'2020-12-21 17:26:46','yue','2020-12-21 17:26:46',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'f02cd298e3486c0a36e38c0a218ffd69',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:26:46',NULL),
	(71,'wx2020122117283272511',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 17:28:32','yue','2020-12-21 17:28:32',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'8152b69a0adcd0f7b9673546389a4641',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:28:32',NULL),
	(72,'wx2020122117332179451',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:33:21',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'d83fbdbd0c082169009f1e831baa11b8',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:33:21',NULL),
	(73,'wx2020122117341142628',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:34:11',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'f1fa143bf774470d6a3555fb7f4297f4',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:34:11',NULL),
	(74,'wx2020122117343199322',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,2,19998.00,0.00,19998.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:34:31',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'b80d5c3a26264c7f2d98d122c28a5c52',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:34:31',NULL),
	(75,'wx2020122117362351213',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:36:23',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'8d25ba71a99e13d7a4d7ddcfa95ec535',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:36:23',NULL),
	(76,'wx2020122117382759574',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 17:38:27','yue','2020-12-21 17:38:27',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'4f217cc2b2bcfc8d8c5793404a637e27',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:38:27',NULL),
	(77,'wx2020122117422051015',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:42:20',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'e8d36dd8a82618b84f1f2dc72ef81481',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:42:20',NULL),
	(78,'wx2020122117423677200',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:42:36',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'377794292f5f79ff2f0799fd93601e69',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:42:36',NULL),
	(79,'wx2020122117444765286',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 17:45:09','yue','2020-12-21 17:44:47',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'d92c4a3d47824d109529a015889a755a',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:45:09',NULL),
	(80,'wx2020122117454399292',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:45:43',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'8e2239b0f1d237663b9d07020e05b0dc',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:45:43',NULL),
	(81,'wx2020122117483291058',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:48:32',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'1598667dd62b7c9921cbec2fabc9ab0e',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:48:32',NULL),
	(82,'wx2020122117500844685',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 17:50:08','yue','2020-12-21 17:50:08',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'a328a183a558c82ecb0f5889449ed42d',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:50:08',NULL),
	(83,'wx2020122117521228249',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-23 10:45:52','yue','2020-12-21 17:52:12',1,1,'image/product/2020/12/23/5ca31ee50e6345d0bb2a9dd361bb8c3ajghjcf8fdt.jpg','1','收货地址填错了',NULL,'2020-12-23 10:46:14',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'537c4d794e0baaa0eb14c614bcc4ede5',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:37',NULL),
	(84,'wx2020122118045677666',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 18:04:56',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 19:05:00',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'432cd14020373550ef57ae58a38a79be',NULL,0,0,5,11,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 19:05:00',NULL),
	(85,'wx2020122118143513973',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 18:14:35','yue','2020-12-21 18:14:35',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'5246b45cba82edec30ec35d986ca41d3',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:45:51',NULL),
	(86,'wx2020122209201057028',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,1.00,0.00,1.00,0.00,0.00,0,0.00,1,'2020-12-22 09:20:10','yue','2020-12-22 09:20:10',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'079e8db221467ba20cd52ba2e57bb9a9',NULL,0,0,0,0,5000.00,3,0,'',0,1,0,0,0,0,'2020-12-22 09:20:10',NULL),
	(87,'wx2020122210260376698',52,'邓鹏飞','13720768304','陕西省西安市碑林区李家村',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-22 10:26:03','yue','2020-12-22 10:26:03',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'a42c7fcf25f089b1a660b6a9af108602',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-22 10:26:03',NULL),
	(94,'wx2020122211130180408',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-22 11:13:01','yue','2020-12-22 11:13:01',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'9127a10a2001bb9db5e0b8a63491d041',NULL,0,0,0,0,0.00,4,0,'',0,1,0,0,0,0,'2020-12-22 11:13:01',NULL),
	(95,'wx2020122211134565041',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-22 11:13:45','yue','2020-12-22 11:13:45',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'5b7accd80d28ff6d76b937790bd84aca',NULL,0,0,0,0,0.00,4,0,'',0,1,0,0,0,0,'2020-12-22 11:13:45',NULL),
	(96,'wx2020122211230061503',52,'邓鹏飞','13720768304','陕西省西安市碑林区李家村',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-22 11:23:00','yue','2020-12-22 11:23:00',3,0,NULL,NULL,NULL,NULL,NULL,0.00,'张三','send','13720000000',0,0,NULL,'',0,'bd1073f92014c2081d2bddc9fa20800b',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 12:04:51',NULL),
	(97,'wx2020122212114695001',52,'邓鹏飞','13720768304','陕西省西安市碑林区李家村',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-22 12:11:47','yue','2020-12-22 12:11:46',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'ad0828605e0e7ce55ec2cefcdbaf030d',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 12:13:20',NULL),
	(98,'wx2020122214393439358',52,'邓鹏飞','13720768304','陕西省西安市碑林区李家村',0.00,1,428.00,0.00,428.00,0.00,0.00,0,0.00,1,'2020-12-22 14:39:34','yue','2020-12-22 14:39:34',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'23b246e0f542c98c1fa41b7c16948533',NULL,0,0,0,0,200.00,0,0,'',0,1,0,0,0,0,'2020-12-22 14:40:24',NULL),
	(99,'wx2020122214442834679',52,'邓鹏飞','13720768304','陕西省西安市碑林区李家村',0.00,1,428.00,0.00,428.00,0.00,0.00,0,0.00,1,'2020-12-22 14:44:28','yue','2020-12-22 14:44:28',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'b43b1806abeaa3a7da5ca102396cc951',NULL,0,0,0,0,200.00,0,0,'',0,1,0,0,0,0,'2020-12-22 14:45:15',NULL),
	(100,'wx2020122215075846470',40,'郭萌','18792851671','陕西省西安市未央区三桥街道启航佳苑A区',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-22 15:07:58','yue','2020-12-22 15:07:58',2,0,NULL,NULL,NULL,NULL,NULL,0.00,'宅急送','express','11111111',0,0,NULL,'',0,'3b0e8efa9433d6be7bff72ec0a44ef4d',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 15:13:23','zhaijisong'),
	(101,'wx2020122215481030538',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-22 15:48:10',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'用户备注信息：爱是好几个撒的的撒还是爱是大收到爱是',1,'1d93ee92247cc9108d2d8842e1806128',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,1,'2020-12-22 16:08:35',NULL),
	(102,'wx2020122215493955805',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-22 16:35:41','yue','2020-12-22 15:49:39',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'用户备注信息\n',0,'e4b97cbf058089ab75db0b06c4f1eaeb','商家备注撒空军的哈空间还是的卡号是动撒 \n',0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:36:38',NULL),
	(103,'wx2020122216051281857',34,'周杰伦','13000000080','山西省太原市小店区天空',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-22 16:05:12','yue','2020-12-22 16:05:12',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'7d7c148917ee9560a945a123d829fa0a','11111111',0,0,0,0,100.00,0,0,'1056967153',1,2,0,0,0,0,'2020-12-23 10:24:18',NULL),
	(104,'wx2020122216372298293',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,189.00,10.00,189.00,10.00,0.00,0,0.00,0,NULL,'weixin','2020-12-22 16:37:22',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'7527c51a3a81ec9cbfee0edfeec5a424',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:38:23',NULL),
	(105,'wx2020122216393355859',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,2,400.00,10.00,400.00,10.00,0.00,0,0.00,1,'2020-12-22 18:38:49','yue','2020-12-22 16:39:33',2,0,NULL,NULL,NULL,NULL,NULL,0.00,'张三','send','13799999999',0,0,NULL,'',0,'3823683b040640a842f427484d2655bb',NULL,0,0,0,0,200.00,0,0,'',0,1,0,0,0,0,'2020-12-22 18:45:31',NULL),
	(106,'wx2020122216442839614',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2020-12-22 16:44:44','yue','2020-12-22 16:44:28',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'ed8f5096f6d0a8330dc4ff05c00bd800',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:44:44',NULL),
	(107,'wx2020122216452214922',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-22 16:45:22',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'670fcbe85594b8e1e28f92364796d553',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:45:22',NULL),
	(108,'wx2020122216483483964',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-22 16:48:34',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',1,'06ab8afdbb533333ec8598d7298fe941',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-24 11:31:10',NULL),
	(109,'wx2020122216492870786',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-22 16:49:28',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',1,'21e8cf4a7c0ae613a53a0a0359c0dd6d',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-24 11:31:16',NULL),
	(110,'wx2020122217471627665',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-22 17:47:16','yue','2020-12-22 17:47:16',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'6c370cebb73686dd5e8ff6cac3df03a6',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 17:47:16',NULL),
	(111,'wx2020122309184791316',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-23 09:18:47','yue','2020-12-23 09:18:47',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'79cc7fdd9a30606c71e11d879752b2ac',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 09:18:47',NULL),
	(112,'wx2020122309495948526',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-23 09:49:59',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'5e5af53c0cf578309d0966aa185f0d2c',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 09:49:59',NULL),
	(113,'wx2020122309562077157',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-23 09:56:47','weixin','2020-12-23 09:56:20',1,2,'image/product/2020/12/23/5e6d782806404df4b320cbafe482dc2fukoeynvgji.jpg,image/product/2020/12/23/54aae5047bd84046bdf28d15d996d6edhu3cttrpgh.jpg,image/product/2020/12/23/7beef5e3fd3d4585841330fef41f1ccbk8kl048xrs.jpg,image/product/2020/12/23/b40e03b8dfe94e1fa2844db0d969cd8dvx6gofuzh8.jpg','爸爸拒腐防变句','与描述不符 ',NULL,'2020-12-23 09:59:25',0.01,NULL,NULL,NULL,0,0,NULL,'',0,'a78b7eaeea9fc8cf04cc241bed1fae1f',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:37',NULL),
	(114,'wx2020122310020184796',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,2,318.00,0.00,318.00,0.00,0.00,0,0.00,1,'2020-12-23 10:02:01','yue','2020-12-23 10:02:01',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'c8ce50097668d2be8f90c922e12ab86b',NULL,0,0,0,0,200.00,0,0,'',0,1,0,0,0,0,'2020-12-23 10:02:01',NULL),
	(115,'wx2020122310065234660',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 10:06:52','yue','2020-12-23 10:06:52',1,2,'image/product/2020/12/23/3fc898a1dbdc4baa935f905dfc238bb5eubvon632g.png,image/product/2020/12/23/49601be69e534901b636b73c532104b458pu93jdjb.png,image/product/2020/12/23/488d99bb46bf458d93440b7d9d38abb9ptx1mu11h2.png,image/product/2020/12/23/a2b3221c55394c28bc284e611d462abaydw0abbvy4.png,image/product/2020/12/23/985aaa3f9c7d41078e37d3e441116781qdyffn3m4j.png','删除退款图片提交测试000','收货地址填错了','撒大公司大撒好的是的骄傲是个安公司杀阿达','2020-12-23 10:18:44',169.00,'李四','send','13777777777',0,0,NULL,'',0,'46fdf6c444be4cb71206ed0167b609ce',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:37',NULL),
	(116,'wx2020122310072161276',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2021-01-08 14:18:24','yue','2020-12-23 10:07:21',1,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'17fe112a8a9ebef2a26b547f61a51779',NULL,0,0,0,0,9.00,0,0,'',0,1,0,3,0,0,'2020-12-23 10:07:21',NULL),
	(117,'wx2020122310151174175',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-23 10:15:11','yue','2020-12-23 10:15:11',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'b2373d288c0b1a7d2d32f96911fac015',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 10:15:11',NULL),
	(118,'wx2020122310231072806',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 10:23:10','yue','2020-12-23 10:23:10',1,2,'','','收货地址填错了',NULL,'2020-12-23 10:23:28',169.00,NULL,NULL,NULL,0,0,NULL,'',0,'0e2b393c336d81d9b73143a5da28f893',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:38',NULL),
	(119,'wx2020122310250586939',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,0.00,10.00,169.00,0,0.00,1,'2020-12-23 10:25:05','yue','2020-12-23 10:25:05',0,2,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,169,NULL,'',0,'a53c72680267923c6b4b9b5b7e5025ea',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 10:25:30',NULL),
	(120,'wx2020122310284278825',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,0.00,10.00,169.00,0,0.00,1,'2020-12-23 10:28:42','yue','2020-12-23 10:28:42',1,2,'','','收货地址填错了',NULL,'2020-12-23 10:51:12',0.00,'宅急送','express','ZJS007001908104',0,169,NULL,'',0,'111447e1522197f22a6bc6371aa2d841',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:38','zhaijisong'),
	(121,'wx2020122310470542404',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2020-12-23 10:47:05','yue','2020-12-23 10:47:05',1,1,'','bxy','收货地址填错了',NULL,'2020-12-23 10:52:45',0.00,NULL,NULL,NULL,0,0,NULL,'',0,'73a32ade057447ce5ef27bf0e4d67eee',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:38',NULL),
	(122,'wx2020122310552413118',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-23 10:55:24','yue','2020-12-23 10:55:24',1,2,'','','收货地址填错了',NULL,'2020-12-23 10:55:36',100.00,NULL,NULL,NULL,0,0,NULL,'',0,'dcec8e3db867a3ddee041ab32b3ed32e',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:38',NULL),
	(123,'wx2020122310572142276',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 10:57:21','yue','2020-12-23 10:57:21',1,2,'','就是的撒环境的哈撒可见度啊是大','未按预定时间发货 ',NULL,'2020-12-23 11:00:56',100.00,NULL,NULL,NULL,0,0,NULL,'',0,'fffe386546fd69fec37e7efbad5c6e46',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:38',NULL),
	(124,'wx2020122311114753098',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,0.00,10.00,169.00,0,0.00,1,'2020-12-23 11:11:47','yue','2020-12-23 11:11:47',1,1,'','','收货地址填错了',NULL,'2020-12-23 17:36:15',0.00,NULL,NULL,NULL,0,169,NULL,'',0,'be99f2d96172a39dc9285e1858577aec',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:38',NULL),
	(125,'wx2020122311152434561',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 11:15:24','yue','2020-12-23 11:15:24',1,0,'','sada sdas dasd ','收货地址填错了',NULL,'2020-12-23 11:16:06',169.00,NULL,NULL,NULL,0,0,NULL,'',0,'ac10c484ca32037f0e12b73e8d46c2a8',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:54:51',NULL),
	(126,'wx2020122311200436357',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-23 11:20:04','yue','2020-12-23 11:20:04',2,0,'','asdasd sad ','收货地址填错了',NULL,'2020-12-23 11:20:18',218.00,NULL,NULL,NULL,0,0,NULL,'',0,'9565b3f306426377e16e50f20b5e5004',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:54:51',NULL),
	(127,'wx2020122311395981104',57,'周三','14356677890','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-23 11:39:59','yue','2020-12-23 11:39:59',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'17da8e1e2fc49d2829b741057b6580fa',NULL,0,0,0,0,100.00,0,0,'1063427418',4,2,0,0,0,0,'2020-12-23 11:48:54',NULL),
	(128,'wx2020122311404837671',52,'周四','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 11:40:48','yue','2020-12-23 11:40:48',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'94ee3ede3df84bf6a0462749e4c451de',NULL,0,0,0,0,100.00,0,0,'1074161540',4,2,0,0,0,0,'2020-12-23 11:44:37',NULL),
	(129,'wx2020122311560381331',52,'无良','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 11:56:03','yue','2020-12-23 11:56:03',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'6078cc9fadf2f32ea3390dc5f632bb3c',NULL,0,0,0,0,100.00,0,0,'1001543090',4,2,0,0,0,0,'2020-12-23 11:56:11',NULL),
	(130,'wx2020122311592785945',57,'王大蛋','13899999999','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-23 11:59:27','yue','2020-12-23 11:59:27',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'ae320a6ed4aa467758e4ab565a6a624d',NULL,0,0,0,0,100.00,0,0,'1018775670',4,2,0,0,0,0,'2020-12-23 12:00:32',NULL),
	(131,'wx2020122312025526047',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-23 12:02:55',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'44cb5fcd6f2d47172373e06191a8da65',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-23 12:02:55',NULL),
	(132,'wx2020122312033016234',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-23 12:03:35','weixin','2020-12-23 12:03:30',1,2,'','不知你自己最可靠','收货地址填错了',NULL,'2020-12-23 12:03:47',0.01,NULL,NULL,NULL,0,0,NULL,'',0,'c68199e4a2c2cef6b3858f0610c73fd1',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:38',NULL),
	(133,'wx2020122312170277299',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-23 12:17:02','yue','2020-12-23 12:17:02',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'宅急送','express','ZJS007001908480',0,0,NULL,'',0,'05726dfeb58ed7dcb01abad9888e5798',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 12:18:09','zhaijisong'),
	(134,'wx2020122315023988973',23,'张三','020-81167888','广东省广州市海珠区新港中路397号',0.00,1,99.00,0.00,0.00,0.00,99.00,0,0.00,1,'2020-12-23 15:02:53','yue','2020-12-23 15:02:39',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,99,NULL,'',0,'aa72e57112777e77ef319389569811c6',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-23 15:02:53',NULL),
	(135,'wx2020122317343336483',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,162.34,10.00,0.00,36,6.66,1,'2020-12-23 17:34:33','yue','2020-12-23 17:34:33',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'f71c14d2dfc81c9db4cbfc066c24c2be',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 17:34:33',NULL),
	(136,'wx2020122317360046762',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,0.00,211.34,0.00,0.00,36,6.66,1,'2020-12-23 17:36:00','yue','2020-12-23 17:36:00',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'4041c47636a1c4870154df5ec75b5c4f',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 17:36:00',NULL),
	(137,'wx2020122317414268568',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,0.00,218.00,0.00,0.00,36,0.00,1,'2020-12-23 17:41:42','yue','2020-12-23 17:41:42',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'e7c7189efa665acd8376b9cd1af2e313',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 17:41:42',NULL),
	(138,'wx2020122317585548544',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,162.34,10.00,0.00,36,6.66,1,'2020-12-23 17:58:55','yue','2020-12-23 17:58:55',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'c16c685b19bace7aed733ec0f8a6eb94',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 17:58:55',NULL),
	(139,'wx2020122318161241035',99,'梁晶','15202970763','北京市北京市海淀区蔺高新居(未央区三桥蔺高新居西北东路东)',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-23 18:16:12',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'559aba6bf733c25da0debbfac7cd954d',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-23 18:16:12',NULL),
	(140,'wx2020122321385615735',130,'哦哦','15555555556','河北省秦皇岛市北戴河区公司',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-23 21:38:56',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'f7c2daf630353218b003dc233227fd1b',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 21:38:56',NULL),
	(141,'wx2020122409225536571',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,1000.00,0.00,1000.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-24 09:22:55',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',1,'da1841b0f9611ac135e30bc03daf025d',NULL,0,0,0,0,111.00,0,0,'',0,1,0,0,0,0,'2020-12-24 11:31:13',NULL),
	(142,'wx2020122409230964576',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,1000.00,0.00,1000.00,0.00,0.00,0,0.00,1,'2020-12-24 09:23:09','yue','2020-12-24 09:23:09',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'14c9344af95ff454c8184118fa682181',NULL,0,0,0,0,111.00,0,0,'',0,1,0,0,0,0,'2020-12-24 09:23:09',NULL),
	(143,'wx2020122409305560523',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,1000.00,0.00,0.00,0.00,1000.00,0,0.00,1,'2020-12-24 09:30:55','yue','2020-12-24 09:30:55',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,500,NULL,'',0,'18d0d8e0f589f70fb79e6db34a2a12ec',NULL,0,0,0,0,111.00,0,0,'',0,1,0,0,0,0,'2020-12-24 09:30:55',NULL),
	(144,'wx2020122409393758415',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,1000.00,0.00,0.00,0.00,1000.00,0,0.00,1,'2020-12-24 09:39:38','yue','2020-12-24 09:39:37',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,500,NULL,'',0,'8f72dd5a4197cb51d6f608d66c774d1a',NULL,0,0,0,0,111.00,0,0,'',0,1,0,0,0,0,'2020-12-24 09:39:38',NULL),
	(145,'wx2020122411012869005',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-24 11:01:28','yue','2020-12-24 11:01:28',1,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,NULL,'',0,'d8c8fadcd3ed7c9e1badea8756061e7c',NULL,0,0,0,0,100.00,6,0,'',0,1,0,0,0,0,'2020-12-24 11:03:12',NULL),
	(146,'wx2020122411071094958',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-24 11:07:11','yue','2020-12-24 11:07:10',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'7b654e832e7987daadcb68d28d74cccf',NULL,0,0,0,0,100.00,6,0,'',0,1,0,0,0,0,'2020-12-24 11:07:11',NULL),
	(147,'wx2020122411071151636',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-24 11:07:11','yue','2020-12-24 11:07:11',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'7bf78cff2562a41a3af38910a02b9093',NULL,0,0,0,0,100.00,6,0,'',0,1,0,0,0,0,'2020-12-24 11:07:11',NULL),
	(148,'wx2020122411300080333',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-24 11:30:00',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',1,'6e10c8acf7f72cac18745d561037c425',NULL,0,0,0,0,100.00,6,0,'',0,1,0,0,0,0,'2020-12-24 11:30:44',NULL),
	(149,'wx2020122411573493429',49,'吴昊天','15094024404','陕西省西安市未央区启航时代广场A座(西安市未央区)',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,1,'2020-12-24 11:57:34','yue','2020-12-24 11:57:34',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'c52d398f0c4bb3df227f859a1f2ac2f7',NULL,0,0,0,0,100.00,0,10,'',0,1,0,0,0,0,'2020-12-24 11:57:34',NULL),
	(150,'wx2020122411573474384',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,0.00,0.00,0.00,0.00,0.00,5,0.00,1,'2020-12-24 11:57:34','yue','2020-12-24 11:57:34',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'781d5477d344c65cb48af6dedd5699f3',NULL,0,0,0,0,100.00,0,10,'',0,1,0,0,0,0,'2020-12-24 11:57:34',NULL),
	(151,'wx2020122412032043346',58,'惩罚你','18346549647','山西省太原市市辖区发个好的v',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,1,'2020-12-24 12:03:20','yue','2020-12-24 12:03:20',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'392d9765e9058e49a9b5179d66a87df2',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-24 12:03:20',NULL),
	(152,'wx2020122414455881047',170,'刚刚','15211668515','内蒙古自治区呼和浩特市市辖区哈哈哈',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-24 14:45:58',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,NULL,'',0,'37f7df77b046ae12a1871d742ccb77f2',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-24 14:45:58',NULL),
	(153,'wx2020122415590838032',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10.00,0.00,10.00,0.00,0.00,0,0.00,1,'2020-12-24 15:59:08','yue','2020-12-24 15:59:08',1,1,'image/product/2020/12/24/aa1117af755b4377a01056dd4d31ecd8s0erg16i3r.jpeg,image/product/2020/12/24/ce0872c532ef4321a4ed5502f383b16cre8yu1m944.png','','收货地址填错了',NULL,'2020-12-24 16:03:13',0.00,NULL,NULL,NULL,0,0,0,'',0,'4378ad7600fb824093789d9e48788bec',NULL,0,0,0,0,100.00,0,11,'',0,1,0,0,0,0,'2021-01-06 11:55:38',NULL),
	(154,'wx2020122416081745944',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,1.00,0.00,1.00,0.00,0.00,40,0.00,1,'2020-12-24 16:08:17','yue','2020-12-24 16:08:17',1,1,'','','收货地址填错了',NULL,'2020-12-24 16:08:23',0.00,NULL,NULL,NULL,0,0,0,'',0,'b3ddf354efe6ac6900657176d23dfeb4',NULL,0,0,0,0,5000.00,3,0,'',0,1,0,0,0,0,'2021-01-06 11:55:38',NULL),
	(155,'wx2020122416140044329',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-24 16:14:00','yue','2020-12-24 16:14:00',1,1,'','','收货地址填错了',NULL,'2020-12-24 16:14:06',0.00,NULL,NULL,NULL,0,0,0,'',0,'cb6e24190488e0570257465ebdfc8a7e',NULL,0,0,9,12,100.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:38',NULL),
	(156,'wx2020122416480588025',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-24 16:48:05','yue','2020-12-24 16:48:05',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'19294b5a321f43df57975daf846be945',NULL,0,0,9,13,100.00,0,0,'',0,1,0,0,0,0,'2020-12-24 16:48:05',NULL),
	(157,'wx2020122417112812546',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,0.00,0.00,0.00,0.00,0.00,5,0.00,1,'2020-12-24 17:11:28','yue','2020-12-24 17:11:28',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,0,'',0,'369cfff89ab6e97811b0f8bd2e7d7cf7',NULL,0,0,0,0,100.00,0,10,'',0,1,0,0,0,0,'2020-12-24 17:12:04',NULL),
	(158,'wx2020122417225221482',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10.00,0.00,10.00,0.00,0.00,0,0.00,1,'2020-12-24 17:22:52','yue','2020-12-24 17:22:52',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,0,'',0,'6829994925e3105d3398cca78f3f5e85',NULL,0,0,0,0,9.00,0,14,'',0,1,0,0,0,0,'2020-12-24 17:23:08',NULL),
	(159,'wx2020122419251712158',184,'袁先生','17708155860','西藏自治区拉萨市堆龙德庆区通站路拉萨站',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-24 19:25:17',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'282b4b7b8a854eb79f8801648e147733',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-24 19:25:17',NULL),
	(160,'wx2020122423023064867',193,'安亚文','18575684015','省市区红酒',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-24 23:02:30',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'f1235e256a5d29928a53b9ba8f6cd8a1',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-24 23:02:30',NULL),
	(161,'wx2020122509301170006',199,'你你怎么','18522233698','北京市北京市石景山区石门路小锅饭豆腐馆(模式口店)',0.00,1,159.00,0.00,159.00,0.00,0.00,64,0.00,0,NULL,'weixin','2020-12-25 09:30:11',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'3b82f5a3f5611e38c58d5085c9b0db2c',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-25 09:30:11',NULL),
	(162,'wx2020122509381921638',32,'123','13000000000','山西省太原市小店区213',0.00,1,99.00,0.00,99.00,0.00,0.00,40,0.00,1,'2020-12-25 09:38:19','yue','2020-12-25 09:38:19',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'aff7087bb9e533147bfe6a6735f789eb',NULL,0,0,0,0,9.00,0,0,'1009905195',4,2,0,0,0,0,'2020-12-25 09:38:34',NULL),
	(163,'wx2020122609385771141',227,'王老五','18668090636','吉林省辽源市东辽县南京市江宁区',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-26 09:38:57',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'7d8d870a13621b707901d60d8e44d072',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-26 09:38:57',NULL),
	(164,'wx2020122609415912378',227,'王老五','18668090636','吉林省辽源市东辽县南京市江宁区',0.00,1,10.00,0.00,10.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-26 09:41:59',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'53102ac89c7b614c2c9f276f8052e6a2',NULL,0,0,8,14,9.00,0,0,'',0,1,0,0,0,0,'2020-12-26 09:41:59',NULL),
	(165,'wx2020122609423466799',230,'陈先生','13260969896','山西省太原市市辖区1111111',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-26 09:42:34',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',1,'ca9849678e4047065fd1cc970e0a7362',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-26 10:05:36',NULL),
	(166,'wx2020122609501325327',227,'王老五','18668090636','吉林省辽源市东辽县南京市江宁区',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-26 09:50:13',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'bc5361c2e7ff644f2e485f828615e5b8',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-26 09:50:13',NULL),
	(167,'wx2020122609553043828',227,'王老五','18668090636','吉林省辽源市东辽县南京市江宁区',0.00,1,0.00,0.00,0.00,0.00,0.00,65,0.00,1,'2020-12-26 09:56:14','yue','2020-12-26 09:55:30',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'3d93b888c9293e086ab1507a2543bd1f',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-26 09:56:14',NULL),
	(168,'wx2020122610062089001',230,'陈先生','13260969896','山西省太原市市辖区1111111',0.00,1,99.00,0.00,94.00,0.00,5.00,0,0.00,0,NULL,'weixin','2020-12-26 10:06:20',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,10,0,'',0,'7d382f24843f17e419b28bd19b966b4d',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-26 10:06:20',NULL),
	(169,'wx2020122614323066751',236,'www','15366199577','新疆维吾尔自治区乌鲁木齐市市辖区adsf',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-26 14:32:30',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'c3ca50d6010992ffe06436e1c3071139',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-26 14:32:30',NULL),
	(170,'wx2020122616501987505',240,'张三','18241114451','山西省太原市市辖区萨达',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-26 16:50:19',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'218169abd433e26671478315bd25e55a',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-26 16:50:19',NULL),
	(171,'wx2020122813334468476',257,'张三','15632363212','吉林省辽源市东辽县更多的是',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 13:33:44',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'908e2cb32e8f98b54f6399ecfe0f9f4a',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-28 13:33:44',NULL),
	(172,'wx2020122813355129132',257,'张三','15632363212','吉林省辽源市东辽县更多的是',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 13:35:51',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'a70643a7cadf4e47411a3668494c5771',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-28 13:35:51',NULL),
	(173,'wx2020122813364793267',257,'张三','15632363212','吉林省辽源市东辽县更多的是',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 13:36:47',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'82652d8a34d12170690216c58b85a723',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-28 13:36:47',NULL),
	(174,'wx2020122813401672362',258,'张三','15236896521','内蒙古自治区包头市昆都仑区来咯图垃圾具体',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 13:40:16',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'78591c5d9c1883d355644e7e3ce74528',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-28 13:40:16',NULL),
	(175,'wx2020122817474787929',31,'小脑虎','18888888888','陕西省西安市市辖区哈罗闪问',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 17:47:47',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'f2dd0ba217c09a6f09f600abed8ca932',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-28 17:47:47',NULL),
	(176,'wx2020122817494390751',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 17:49:43',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'3b697948e6a4f01ef41c2dafcc55bc17',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-28 17:49:43',NULL),
	(177,'wx2020122817543170230',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 17:54:31',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'21dae61a6f58fe6475489195a28a8dfc',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-28 17:54:31',NULL),
	(178,'wx2020122817582466391',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 17:58:24',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'669f28a382ac23b0a57282f67cde688c',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-28 17:58:24',NULL),
	(179,'wx2020122817582968089',31,'小脑虎','18888888888','陕西省西安市市辖区哈罗闪问',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 17:58:29',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'3964b05191906efc0499ae1c8f406d33',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-28 17:58:29',NULL),
	(180,'wx2020122818012694271',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 18:01:26',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'923080c013b992e4ed35093e8f975817',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-28 18:01:26',NULL),
	(181,'wx2020122818022051858',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 18:02:20',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'a43172b0f1f7be6b91a648ac897f7d53',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-28 18:02:20',NULL),
	(182,'wx2020122818023855833',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 18:02:38',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'55810ee502df1f711b7ede7544545218',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-28 18:02:38',NULL),
	(183,'wx2020122818054856452',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 18:05:48',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'6b8ed6dd1c481f1ae5cc5cf3bdaadf84',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-28 18:05:48',NULL),
	(184,'wx2020122818092984010',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-28 18:09:29',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'9eafe3fcdd4f7d59d74163b6071dd431',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-28 18:09:29',NULL),
	(185,'wx2020122910002820861',31,'小脑虎','18888888888','陕西省西安市市辖区哈罗闪问',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 10:00:28',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'18a3c9b4c3487ae0681b0a33d229584f',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 10:00:28',NULL),
	(186,'wx2020122910142187646',31,'小脑虎','18888888888','陕西省西安市市辖区哈罗闪问',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 10:14:21',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'b7caf6f692a037926f58f5e123349e89',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 10:14:21',NULL),
	(187,'wx2020122910242592267',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-29 10:24:36','weixin','2020-12-29 10:24:25',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'b27fad0d27f186f8fa075784b9823ae2',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 10:24:36',NULL),
	(188,'wx2020122910251713481',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.00,0.00,0.00,0.00,0.00,13,0.00,0,NULL,'weixin','2020-12-29 10:25:17',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'6da05d96c504ed437e5c4c95a38258a5',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-29 10:25:17',NULL),
	(189,'wx2020122910275664336',23,'张三','020-81167888','广东省广州市海珠区新港中路397号',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 10:27:56',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'9818b308d1365b08192a79159505f46b',NULL,0,0,0,0,10.00,0,0,'',0,1,0,1,0,0,'2020-12-29 10:27:56',NULL),
	(190,'wx2020122910343580616',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 10:34:35',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'13965fa2ecce083337f5b0a03addf838',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 10:34:35',NULL),
	(191,'wx2020122910521832583',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 10:52:18',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'8e854f902594d7eb383e749e04d2cfcb',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 10:52:18',NULL),
	(192,'wx2020122910530561388',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 10:53:05',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'b1c4dcadb3717e3dee9ae42c3eb0dbea',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 10:53:05',NULL),
	(193,'wx2020122911003267409',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:00:32',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'1a9926a1b5bdbf4e09e83716bb44e374',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:00:32',NULL),
	(194,'wx2020122911035890562',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-29 11:04:45','weixin','2020-12-29 11:03:58',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'fa9df3411d2bf0c06e32ba8108fe122a',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:04:45',NULL),
	(195,'wx2020122911070468245',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:07:04',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'c633fd66fb4337cae80630f033014f02',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:07:04',NULL),
	(196,'wx2020122911091022052',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:09:10',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'73e2951ed826e0152615ff81485b6abb',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:09:10',NULL),
	(197,'wx2020122911233839432',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.00,0.00,0.00,0.00,0.00,13,0.00,0,NULL,'weixin','2020-12-29 11:23:38',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'191afeab56de46169053c1439611a97f',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:23:38',NULL),
	(198,'wx2020122911235419615',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:23:54',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'9f9294b5122bf06029bc8a14b4967535',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:23:54',NULL),
	(199,'wx2020122911263515991',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:26:35',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'39decce79aef53a4af0dfd34ddbf3663',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:26:35',NULL),
	(200,'wx2020122911363388809',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:36:33',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'33c04356972ca1d0a9d2320f160d1c57',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:36:33',NULL),
	(201,'wx2020122911365429166',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,20.00,0.00,20.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:36:54',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'7f47493a02ee36dc5929a58221676634',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:36:54',NULL),
	(202,'wx2020122911371180308',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,139.00,0.00,139.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:37:11',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'1e33038e70f40c58788b2774b35dc278',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:37:11',NULL),
	(203,'wx2020122911381477253',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:38:14',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'fd704eb275039994567d99d2240c6bcb',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:38:14',NULL),
	(204,'wx2020122911442020951',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:44:20',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'d78340c4b6cb3bb6375fd0afea57fd59',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:44:20',NULL),
	(205,'wx2020122911443853349',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:44:38',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'aef82df96a6112cc901806ce3e01350c',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:44:38',NULL),
	(206,'wx2020122911452921436',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:45:29',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'d5b0ab9c88b5a74f860bee48a9f9c474',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:45:29',NULL),
	(207,'wx2020122911511749997',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:51:17',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'82685afe4f71dcd6566fb51f8b314d24',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:51:17',NULL),
	(208,'wx2020122911514063543',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:51:40',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'4136e632a8a0ea7bb72b8725ce877971',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:51:40',NULL),
	(209,'wx2020122911531829356',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:53:18',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'3161595737e9178bdffa8d0728e8af58',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:53:18',NULL),
	(210,'wx2020122911574730957',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:57:47',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'ce47925732f479e6d603810fb19843ee',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:57:47',NULL),
	(211,'wx2020122911585920936',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 11:58:59',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'cde1f9deb3cec161b46f92b4bf6fca17',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 11:58:59',NULL),
	(212,'wx2020122912003567831',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 12:00:35',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'284341e25ff79322c06a093cf76bbe0b',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 12:00:35',NULL),
	(213,'wx2020122912010763790',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 12:01:07',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'8793d711542ddb64f830756cf2d0f1fa',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 12:01:07',NULL),
	(214,'wx2020122912013316911',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 12:01:33',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'2f34c76350ae9148d7fe0bff7fed4b6d',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 12:01:33',NULL),
	(215,'wx2020122912111795198',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 12:11:17',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'7311789f3b9f170aaedc6dbf99767953',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 12:11:17',NULL),
	(216,'wx2020122912113891006',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 12:11:38',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'cb1984f2dbd5af1496b562de2de2ffff',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 12:11:38',NULL),
	(217,'wx2020122912231289060',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 12:23:12',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'b3155ed9959856b4c7abb8dcee23601c',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 12:23:12',NULL),
	(218,'wx2020122912232721205',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 12:23:27',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'37b4f3058ca4f7e877aa93b20ee4139e',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 12:23:27',NULL),
	(219,'wx2020122912240289498',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 12:24:02',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'65a9154004f1bb6df89133c1eb24c00f',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 12:24:02',NULL),
	(220,'wx2020122912264993844',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 12:26:49',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'f40915e301d71d8432066928c130ea97',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 12:26:49',NULL),
	(221,'wx2020122915211053396',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 15:21:10',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'9bdc2a96d02aa6dafdc5c5eb6b2b6775',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 15:21:10',NULL),
	(222,'wx2020122915215252998',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 15:21:52',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'65de57c95bdee07273b190a6c7b5365a',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 15:21:52',NULL),
	(223,'wx2020122915303954291',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 15:30:39',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'4acc01dc38d0523583c789d272f7cbef',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 15:30:39',NULL),
	(224,'wx2020122915354927978',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 15:35:49',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'f637b34aa157551a4aca31167f47b629',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 15:35:49',NULL),
	(225,'wx2020122915445280074',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 15:44:52',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'9922a92aff41f8dd654663ff3d9946b4',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 15:44:52',NULL),
	(226,'wx2020122915472916175',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 15:47:29',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'c4b2cb0255ca470c30746077039b0a33',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 15:47:29',NULL),
	(227,'wx2020122916521242993',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 16:52:12',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'88a91ec490df573eeaefc1521f21a835',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 16:52:12',NULL),
	(228,'wx2020122916524818422',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 16:52:48',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'cddabe4914caf276a7472001cde44ec3',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 16:52:48',NULL),
	(229,'wx2020122916585340109',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 16:58:53',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'3f47120e71aa6b8f8eee37c2aad56078',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 16:58:53',NULL),
	(230,'wx2020122917032636792',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 17:03:26',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'e18079699aaf8a5b3af0f9a62eb49c5c',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 17:03:26',NULL),
	(231,'wx2020122917121574672',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 17:12:15',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'38b1f5704546d4dd57d3f0d8aa4a24aa',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 17:12:15',NULL),
	(232,'wx2020122917243563373',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 17:24:35',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'c9c4c53d41297f3287b9484b626c2401',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 17:24:35',NULL),
	(233,'wx2020122917293524080',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 17:29:35',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'20a004701420a02cf35d9aa7f69d68b3',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 17:29:35',NULL),
	(234,'wx2020122917322271932',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 17:32:22',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'52a728db1685ecce20af7905832d5258',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 17:32:22',NULL),
	(235,'wx2020122917324669472',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 17:32:46',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'bebdbbfe2769bb317b3dd7577570de61',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 17:32:46',NULL),
	(236,'wx2020122917383376012',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 17:38:33',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'67000c66f0a795b8fc09339c99f5ccbd',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 17:38:33',NULL),
	(237,'wx2020122917402249466',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-29 17:40:45','weixin','2020-12-29 17:40:22',1,1,'','退钱','收货地址填错了',NULL,'2020-12-31 10:04:53',0.00,NULL,NULL,NULL,0,0,0,'',0,'05f9c00b4071a6ddfd333f30558e4ae8',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:55:38',NULL),
	(238,'wx2020122917450151195',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 17:45:01',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'c3899b1e4807c0b76f7e389777dbaa12',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 17:45:01',NULL),
	(239,'wx2020122917593519340',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 17:59:35',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'a95f48fcd9625d5c84fe615d896cc690',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 17:59:35',NULL),
	(240,'wx2020122918045768371',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 18:04:57',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'9fc9799f8a86fdf06c7b1e093082c13c',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:04:57',NULL),
	(241,'wx2020122918065125689',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-29 18:07:46','weixin','2020-12-29 18:06:51',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'95191f65ff245fca6a9bf5cf11dffd93',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:07:46',NULL),
	(242,'wx2020122918134412787',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 18:13:44',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'40bd0589ba2df2228b23441090cf5a1f',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:13:44',NULL),
	(243,'h52020122918202149579',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,0.00,0.00,0.00,0.00,0.00,14,0.00,0,NULL,'yue','2020-12-29 18:20:21',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'872fb5766fd9e9f0b07c4bcb2d7d42d0',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,3,0,0,'2020-12-29 18:20:21',NULL),
	(244,'h52020122918204332632',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,0,NULL,'yue','2020-12-29 18:20:43',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'88c5de83f2fb795480713edddc575a82',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2020-12-29 18:20:43',NULL),
	(245,'wx2020122918251874481',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 18:25:18',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'730b1e20b544bbeb823914526e90d026',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:25:18',NULL),
	(246,'wx2020122918323559992',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 18:32:35',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'a09c96a3674d0c349604a0b43d7e1438',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:32:35',NULL),
	(247,'wx2020122918401011767',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 18:40:10',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'12b23164478ecf435d1f46c1b4ca30db',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:40:10',NULL),
	(248,'wx2020122918472285828',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 18:47:22',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'122e4154a9a2a9e1bcb296fcfb528168',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:47:22',NULL),
	(249,'wx2020122918520229313',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 18:52:02',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'94723cbc7320f86fb01413dc1bfdf3d7',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:52:02',NULL),
	(250,'wx2020122918521317604',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 18:52:13',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'2e607874d990e8ca518622b13a73b6c3',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:52:13',NULL),
	(251,'wx2020122918534675270',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 18:53:46',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'cb467e736fe1a5744340b136707b58f8',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:53:46',NULL),
	(252,'wx2020122918544328810',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 18:54:43',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'0ef1d6851c36aebdfd171937f633448d',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:54:43',NULL),
	(253,'wx2020122919022878688',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 19:02:28',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'10cf58b7814608ac191e8930968b2a3a',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-29 19:02:28',NULL),
	(254,'wx2020122919085437011',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 19:08:54',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'ea67b4e52131b3f24c3901eb5e3ee7e4',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-29 19:08:54',NULL),
	(255,'wx2020122919152438684',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 19:15:24',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'ed6f250a03155e760ddd09017b43f433',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-29 19:15:24',NULL),
	(256,'wx2020122919263317592',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 19:26:33',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'dfc83b3372fe45b3fb27cbcbe05ea1d6',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 19:26:33',NULL),
	(257,'wx2020122919545163470',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-29 19:54:51',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'299fa3bc87800f4013fdf9d87af7d738',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 19:54:51',NULL),
	(258,'wx2020123009185231968',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 09:18:52',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'c39bc979ad375f8f49f673441e04fd62',NULL,0,0,0,0,100.00,0,0,'',0,1,0,2,0,0,'2020-12-30 09:18:52',NULL),
	(259,'h52020123009253733433',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,0,NULL,'yue','2020-12-30 09:25:37',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'b2d207d616acd460b2ac95c794a325e9',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2020-12-30 09:25:37',NULL),
	(260,'wx2020123010402999123',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 10:40:29',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'40427c322489fb1758cc740016c9e7eb',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 10:40:29',NULL),
	(261,'wx2020123011093257546',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 11:09:32',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'da8bfdb150b5340610968c24625b369f',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 11:09:32',NULL),
	(262,'wx2020123011133138948',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 11:13:31',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'52c575129e788f0bda5a3e5c1ab2abca',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 11:13:31',NULL),
	(263,'wx2020123011192313363',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 11:19:23',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'c7d195053d5a8d4c6d3d7074605fd1bc',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 11:19:23',NULL),
	(264,'wx2020123011490921114',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 11:49:09',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'31de9d3152c6332049d42ff4e46dccb4',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 11:49:09',NULL),
	(265,'wx2020123011561636835',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 11:56:16',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'fbb880ac0908b5259cccf00b32c3a62f',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 11:56:16',NULL),
	(266,'wx2020123012063854190',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 12:06:38',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'b675b1aef6b98f6ac166d81623ccc683',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 12:06:38',NULL),
	(267,'wx2020123013582848607',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 13:58:28',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'4b316dc107f809693bef6e9882e9daec',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 13:58:28',NULL),
	(268,'h52020123013592375532',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-30 13:59:23','yue','2020-12-30 13:59:23',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'fb5b541fae9f7b7149b087721a3fae42',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2020-12-30 13:59:23',NULL),
	(269,'wx2020123014044045593',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 14:04:40',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'d8d2f4c8ab8fd79a9af53d1360318df0',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 14:04:40',NULL),
	(270,'wx2020123015274994489',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 15:27:49',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'c6f5f6d74e835c3969d7c390f4380728',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 15:27:49',NULL),
	(271,'wx2020123015484489595',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-30 15:48:44',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'49437e8d1cf0825f5ce5cd3b1960007c',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 15:48:44',NULL),
	(272,'wx2020123015502858766',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,NULL,'weixin','2020-12-30 15:50:28',1,0,'','退钱','收货地址填错了','11','2020-12-31 10:04:29',0.00,NULL,NULL,NULL,0,0,0,'',0,'5ea2a5a3e33e550493d95ab1785b2a97',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2021-01-06 11:54:40',NULL),
	(273,'h52020123015513630654',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-30 15:51:36','yue','2020-12-30 15:51:36',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'bb0918b066542bfd7a36fb89fe7bd075',NULL,0,0,0,0,10.00,0,0,'',0,1,0,3,0,0,'2020-12-30 15:51:36',NULL),
	(274,'wx2020123016000697483',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-30 16:00:47','yue','2020-12-30 16:00:06',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',0,'51e9b89a29e7c3943bfebe96ef00a379',NULL,0,0,0,0,10.00,0,0,'',0,1,0,3,0,0,'2020-12-30 16:00:47',NULL),
	(275,'wx2020123017311036904',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-31 16:30:15','yue','2020-12-30 17:31:10',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0,0,0,'',0,'7df118eb8c864603d4df76ac1eb32271',NULL,0,0,0,0,10.00,0,0,'',0,1,0,3,0,0,'2020-12-31 16:30:54',NULL),
	(276,'h52020123115110917616',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-31 15:11:09','yue','2020-12-31 15:11:09',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,79,0,0,'',0,'63bfdedeedb2688bb16e6ef04e2c083b',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2020-12-31 15:11:09',NULL),
	(277,'h52020123115151099773',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,20.00,0.00,20.00,0.00,0.00,0,0.00,1,'2020-12-31 15:15:10','yue','2020-12-31 15:15:10',2,0,NULL,NULL,NULL,NULL,NULL,0.00,'宅急送','express','1111111111111',10,0,0,'',0,'2a7895bd829b36deecf5a08192fce847',NULL,0,0,0,0,10.00,0,0,'',0,1,0,3,0,0,'2020-12-31 15:31:42','zhaijisong'),
	(278,'h52020123115213945283',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-31 15:21:40','yue','2020-12-31 15:21:39',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'中远快运','express','111',0,0,0,'',0,'7779c82d5ec1dea4fd4a98ffbb34f22a',NULL,0,0,0,0,10.00,0,0,'',0,1,0,3,0,0,'2020-12-31 15:21:40','zy100'),
	(279,'h52020123116263457062',31,'小脑虎','18888888888','陕西省西安市市辖区哈罗闪问',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-31 16:26:34','yue','2020-12-31 16:26:34',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,104,0,0,'',0,'e4ed94379f6186d1d209fafcb859cae5',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2020-12-31 16:27:14',NULL),
	(280,'h52020123116290118838',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-31 16:29:01','yue','2020-12-31 16:29:01',2,1,'','','收货地址填错了','买家已收货，不支持退款','2021-01-06 10:44:52',0.00,NULL,'fictitious',NULL,104,0,0,'',0,'acc532487de54276b9657a8c1dcb294f',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-06 10:45:34',NULL),
	(281,'h52020123117531493675',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-31 17:53:15','yue','2020-12-31 17:53:14',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'顺丰快运','express','SF20210114873782',0,0,0,'',0,'a2a41900a2664a90da8467eefa4e501d',NULL,0,0,0,0,10.00,0,0,'',0,1,0,3,0,0,'2020-12-31 17:53:14','shunfengkuaiyun'),
	(282,'wx2021010515521751158',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,218.00,0.00,10.00,0.00,0.00,0,0.00,1,'2021-01-05 15:53:54','yue','2021-01-05 15:52:17',1,2,'','','收货地址填错了',NULL,'2021-01-05 17:00:17',10.00,NULL,NULL,NULL,0,0,0,'',0,'dffbc395fbe360c8cd82fb3d16595ebc','2121',0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02',NULL),
	(283,'h52021010516054786246',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,218.00,0.00,0.00,0.00,218.00,0,0.00,1,'2021-01-05 16:05:47','yue','2021-01-05 16:05:47',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,30,109,0,'',0,'4b8995e8ac1df29f306706807a9ff9c8',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-05 16:05:47',NULL),
	(284,'h52021010517270544489',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2021-01-05 17:27:05','yue','2021-01-05 17:27:05',1,2,'','','收货地址填错了',NULL,'2021-01-05 17:27:14',169.00,NULL,NULL,NULL,104,0,0,'',0,'e4a27395c02259d4c5d6f45c91434f73',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02',NULL),
	(285,'wx2021010517331212184',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-05 17:33:12',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,139,0,0,'',0,'47d245e874acef722ccaf25c9ea7f394',NULL,0,0,0,0,100.00,0,0,'',0,1,0,2,0,0,'2021-01-05 17:33:12',NULL),
	(286,'h52021010710374346916',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2021-01-07 10:37:43','yue','2021-01-07 10:37:43',2,0,NULL,NULL,NULL,NULL,NULL,0.00,'圆通快运','express','YT518616789443',50,0,0,'',0,'5b4eef29a2d62304ea199539699020ea',NULL,0,0,0,0,9.00,0,0,'',0,1,0,3,0,0,'2021-01-07 10:37:43','yuantongkuaiyun'),
	(287,'h52021010711324342956',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2021-01-07 11:32:44','yue','2021-01-07 11:32:43',1,2,NULL,NULL,NULL,NULL,NULL,99.00,'顺丰快运','express','SF1039563119174',50,0,0,'',0,'7acfcc13787b1be5bb36dad0e752df2e',NULL,0,0,0,0,9.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02','shunfengkuaiyun'),
	(288,'h52021010711445038877',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2021-01-07 11:44:50','yue','2021-01-07 11:44:50',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'百世快运','express','557040050980690',104,0,0,'',0,'be11b424d54adffa9210761ffabe8d3b',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-07 11:44:50','baishiwuliu'),
	(289,'h52021010715401891542',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,99.00,0.00,98.00,0.00,0.00,150,1.00,1,'2021-01-07 15:40:18','yue','2021-01-07 15:40:18',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,50,0,0,'',0,'ad53e74b3267e7b2352f9dfe7484226a',NULL,0,0,0,0,9.00,0,0,'',0,1,0,3,0,0,'2021-01-07 15:40:18',NULL),
	(290,'wx2021010716062211671',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,99.00,0.00,98.00,0.00,0.00,150,1.00,0,NULL,'weixin','2021-01-07 16:06:22',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,50,0,0,'',0,'adad476eabfa77d254a84cdd9faf380d',NULL,0,0,0,0,9.00,0,0,'',0,1,0,2,0,0,'2021-01-07 16:06:22',NULL),
	(291,'h52021010716073123732',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,99.00,0.00,98.00,0.00,0.00,150,1.00,1,'2021-01-07 16:07:31','yue','2021-01-07 16:07:31',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,50,0,0,'',0,'c2f2e3edb7e3d20071befae745e2d458',NULL,0,0,0,0,9.00,0,0,'',0,1,0,3,0,0,'2021-01-07 16:07:31',NULL),
	(292,'h52021010716363891435',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,99.00,0.00,98.00,0.00,0.00,150,1.00,1,'2021-01-07 16:36:38','yue','2021-01-07 16:36:38',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,50,0,0,'',0,'d4451fc936fe990337151a34e9cd1a12',NULL,0,0,0,0,9.00,0,0,'',0,1,0,3,0,0,'2021-01-07 16:36:38',NULL),
	(293,'h52021010716434579861',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,99.00,0.00,98.00,0.00,0.00,146,1.00,1,'2021-01-07 16:43:45','yue','2021-01-07 16:43:45',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,50,0,0,'',0,'ff312144fb55fec33ecbf6ef682c855f',NULL,0,0,0,0,9.00,0,0,'',0,1,0,3,0,0,'2021-01-07 16:43:45',NULL),
	(294,'h52021010816121056069',48,'裴明','18292417675','陕西省西安市雁塔区曲江三迪枫丹(西安市雁塔区)',0.00,1,20.00,0.00,20.00,0.00,0.00,0,0.00,1,'2021-01-08 16:12:10','yue','2021-01-08 16:12:10',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'顺通快递','express','SF1039563119174',10,0,0,'',0,'8dfb07250b3c3ee281001f17b35e0d38',NULL,0,0,0,0,10.00,0,0,'',0,1,0,3,0,0,'2021-01-08 16:12:10','stkd'),
	(295,'wx2021010816162890492',48,'裴明','18292417675','陕西省西安市雁塔区曲江三迪枫丹(西安市雁塔区)',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2021-01-08 16:16:43','yue','2021-01-08 16:16:28',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'顺通快递','express','SF1039563119174',99,0,0,'',0,'39d7339bcff34ea8e0c77d2c6b83e76d',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-08 16:16:28','stkd'),
	(296,'h52021010911455763870',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,20.00,0.00,20.00,0.00,0.00,0,0.00,0,NULL,'offline','2021-01-09 11:45:57',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,10,0,0,'',0,'31b9dc587288d695dd835ebd09d2b584',NULL,0,0,0,0,10.00,0,0,'',0,1,0,3,0,0,'2021-01-09 11:45:57',NULL),
	(297,'wx2021010917322975684',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-09 17:32:29',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,50,0,0,'',0,'3294271afb3443ba2f2e039ac315b13d',NULL,0,0,0,0,9.00,0,0,'',0,1,0,2,0,0,'2021-01-09 17:32:29',NULL),
	(298,'h52021011109592633219',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2021-01-11 09:59:27','yue','2021-01-11 09:59:26',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,109,0,0,'',0,'71516523c5456b9c6840b7d8f053d97f',NULL,0,0,9,15,100.00,0,0,'',0,1,0,3,0,0,'2021-01-11 09:59:26',NULL),
	(299,'h52021011110004316516',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2021-01-11 10:00:44','yue','2021-01-11 10:00:43',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,109,0,0,'',0,'64b5ad45284057f093040c20bfa6836a',NULL,0,0,9,15,100.00,0,0,'',0,1,0,3,0,0,'2021-01-11 10:00:43',NULL),
	(300,'h52021011110083870349',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2021-01-11 10:08:38','yue','2021-01-11 10:08:38',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,109,0,0,'',0,'5149ee6f308d5d83fc6c955e4b29d464',NULL,0,0,9,17,100.00,0,0,'',0,1,0,3,0,0,'2021-01-11 10:08:38',NULL),
	(301,'wx2021011110244273444',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-11 10:24:42',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,50,0,0,'',1,'e83959573f9d815bee70d64bceab9687',NULL,0,0,0,0,9.00,1,0,'',0,1,0,2,0,1,'2021-01-11 10:24:42',NULL),
	(302,'h52021011110251129298',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2021-01-11 10:25:11','yue','2021-01-11 10:25:11',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,50,0,0,'',0,'847f6f1d0a853b5fc7a1edb7176a6f5a',NULL,0,0,0,0,9.00,1,0,'',0,1,0,3,0,0,'2021-01-11 10:25:11',NULL),
	(303,'wx2021011110264395309',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,1.00,0.00,0.00,0.00,1.00,0,0.00,1,'2021-01-11 10:26:43','weixin','2021-01-11 10:26:43',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,2,0,'',0,'15b0c56476b15b833806e67d9190e8dd',NULL,0,0,0,0,1.00,0,0,'',0,1,0,2,0,0,'2021-01-11 10:26:43',NULL),
	(304,'h52021011111062790359',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,1,'2021-01-11 11:06:27','yue','2021-01-11 11:06:27',2,2,NULL,NULL,NULL,NULL,NULL,0.00,'顺丰快运','express','SF1039563119174',0,0,0,'',0,'c51c9e58dbd44606114d7f67273fb749',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02','shunfengkuaiyun'),
	(305,'h52021011211435862517',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2021-01-12 11:43:58','yue','2021-01-12 11:43:58',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,139,0,0,'',0,'9f18e75933442f0dcd0448bd66aa2574',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-12 11:43:58',NULL),
	(306,'h52021011309264525045',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,20.00,0.00,20.00,0.00,0.00,0,0.00,1,'2021-01-13 09:26:45','yue','2021-01-13 09:26:45',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'韵达快递','express','4311711465622',10,0,0,'',0,'6ac1f3fbe0b17a4c648398fe32760387',NULL,0,0,0,0,10.00,0,0,'',0,1,0,3,0,0,'2021-01-13 09:26:45','yunda'),
	(307,'h52021011312261198055',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2021-01-13 12:26:11','yue','2021-01-13 12:26:11',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,139,0,0,'',0,'a38e7773be3ff4ba3ce4bb6ec8c43226',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-13 12:26:11',NULL),
	(308,'h52021011410393477933',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,50.00,0.00,50.00,0.00,0.00,0,0.00,1,'2021-01-14 10:39:34','yue','2021-01-14 10:39:34',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,25,0,0,'',0,'0657cdb5781e74efade47fbb420c358a',NULL,0,0,0,0,20.00,0,0,'',0,1,0,3,0,0,'2021-01-14 10:39:34',NULL),
	(309,'wx2021011410472556974',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-14 10:47:25',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,139,0,0,'',1,'28c1b796268efc1be71469c585d3360b',NULL,0,0,0,0,100.00,0,0,'',0,1,0,2,0,0,'2021-01-14 10:47:25',NULL),
	(310,'wx2021011411184127192',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-14 11:18:41',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,139,0,0,'',1,'70a6ee9a830f17c15dd8a77d84c66219',NULL,0,0,0,0,100.00,0,0,'',0,1,0,2,0,0,'2021-01-14 11:18:41',NULL),
	(311,'h52021011412191571749',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,0.00,10.00,169.00,0,0.00,1,'2021-01-14 12:19:15','yue','2021-01-14 12:19:15',2,2,'','','收货地址填错了',NULL,'2021-01-14 12:20:39',0.00,NULL,'fictitious',NULL,20,338,0,'',0,'83caee2465822f8cc47bf17791fee4d5',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02',NULL),
	(312,'h52021011412211633441',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2021-01-14 12:21:16','yue','2021-01-14 12:21:16',0,2,'','','收货地址填错了',NULL,'2021-01-14 12:21:23',169.00,NULL,NULL,NULL,104,0,0,'',0,'218100e7a1b54b9ce76322aa5233894e',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02',NULL),
	(313,'h52021011412260251225',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2021-01-14 12:26:02','yue','2021-01-14 12:26:02',1,2,'','','收货地址填错了',NULL,'2021-01-14 12:26:31',100.00,'中远快运','express','ZY123123123123123',50,0,0,'',0,'a6c6de65599d65f312daadb9df1be055',NULL,0,0,0,0,50.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02','zy100'),
	(314,'h52021011414065798318',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,50.00,0.00,50.00,0.00,0.00,0,0.00,1,'2021-01-14 14:06:57','yue','2021-01-14 14:06:57',0,2,'','','收货地址填错了',NULL,'2021-01-14 14:07:45',50.00,NULL,NULL,NULL,25,0,0,'',0,'723f9f5352e5727c9adb47435da967d7',NULL,0,0,0,0,20.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02',NULL),
	(315,'h52021011414133724073',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,50.00,0.00,50.00,0.00,0.00,0,0.00,1,'2021-01-14 14:13:37','yue','2021-01-14 14:13:37',0,0,'','','收货地址填错了','1','2021-01-14 14:16:18',50.00,NULL,NULL,NULL,25,0,0,'',0,'0b550760bad562212b0d2cf8d432767d',NULL,0,0,0,0,20.00,0,0,'',0,1,0,3,0,0,'2021-01-14 14:13:37',NULL),
	(316,'h52021011415070397256',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2021-01-14 15:07:03','yue','2021-01-14 15:07:03',0,1,'image/product/2021/01/14/fcdfed90060e415396918a9a4ec620af683kod0uxv.jpg,image/product/2021/01/14/b6f888f9a49b43d89141e25ece7b4b7flg5nntr8o1.jpg,image/product/2021/01/14/cdaf1895d23e406799c994321d16ec8eayafy7pcmr.png','啊实打实的阿瑟东按时aa','收到商品损坏了 ',NULL,'2021-01-14 15:07:55',0.00,NULL,NULL,NULL,50,0,0,'',0,'1da60442b4b36e06817beed563e3d13f',NULL,0,0,0,0,50.00,0,0,'',0,1,0,3,0,0,'2021-01-14 15:07:03',NULL),
	(317,'wx2021011415283038155',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,10.00,226.50,10.00,0.00,190,1.50,0,NULL,'weixin','2021-01-14 15:28:30',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,143,0,0,'',1,'8e26969e33fae1f3e9c560d282b0424d',NULL,0,0,0,0,100.00,0,0,'',0,1,0,2,0,1,'2021-01-14 15:28:30',NULL),
	(318,'wx2021011415312524600',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,10.00,228.00,10.00,0.00,0,0.00,0,NULL,'weixin','2021-01-14 15:31:25',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,144,0,0,'',1,'2cfa104b2c9dbd33758235ccdb6d4e79',NULL,0,0,0,0,100.00,0,0,'',0,1,0,2,0,1,'2021-01-14 15:31:25',NULL),
	(319,'h52021011509120551012',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,10.00,228.00,10.00,0.00,0,0.00,1,'2021-01-15 09:12:05','yue','2021-01-15 09:12:05',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,144,0,0,'',0,'53dbe5b12dc647701c3158eebde3b367',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-15 09:12:05',NULL),
	(320,'h52021011509174116510',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,218.00,10.00,228.00,10.00,0.00,0,0.00,1,'2021-01-15 09:17:41','yue','2021-01-15 09:17:41',0,2,'','','收货地址填错了',NULL,'2021-01-15 09:17:55',228.00,NULL,NULL,NULL,144,0,0,'',0,'911e1aad1b4cf7b3c81f287bbce71961',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02',NULL),
	(321,'h52021011509211218945',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2021-01-15 09:21:12','yue','2021-01-15 09:21:12',2,2,'','','收货地址填错了',NULL,'2021-01-15 09:21:50',169.00,NULL,'fictitious',NULL,104,0,0,'',0,'7e5b2174bd3b8a0e45b26b2329e1867b',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02',NULL),
	(322,'h52021011510005375617',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,0,NULL,'yue','2021-01-15 10:00:53',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,699,0,0,'',0,'17455b38ee594cf1a6a48bd49165d98a',NULL,0,0,0,0,500.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:00:53',NULL),
	(323,'h52021011510035816697',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,0,NULL,'yue','2021-01-15 10:03:58',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,699,0,0,'',0,'0888693fa8f034219bcfe987157ae137',NULL,0,0,0,0,500.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:03:58',NULL),
	(324,'h52021011510050550489',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,1399.00,0.00,1409.00,10.00,0.00,0,0.00,1,'2021-01-15 10:05:05','yue','2021-01-15 10:05:05',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'中远快运','express','ZY123123123123123132',704,0,0,'',0,'1770c9d8f52ecc17c19d3f2e4bec4bbd','阿瑟东都是的撒',0,0,0,0,500.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:05:05','zy100'),
	(325,'h52021011510080736053',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,0,NULL,'yue','2021-01-15 10:08:07',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,699,0,0,'',0,'16f22d8ce735546f44c6bf16226b1e22',NULL,0,0,0,0,500.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:08:07',NULL),
	(326,'h52021011510082426985',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,0,NULL,'yue','2021-01-15 10:08:24',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,699,0,0,'',0,'f5e64fff9541b84df9fb9de16ad1097f','啊飒飒倒萨大大大    ',0,0,0,0,500.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:08:24',NULL),
	(327,'wx2021011510134824253',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,10.00,1500.00,10.00,0.00,0,0.00,1,'2021-01-15 10:16:56','yue','2021-01-15 10:13:48',2,2,'','','收货地址填错了',NULL,'2021-01-15 10:18:38',1500.00,'中远快运','express','ZYKD00000000000000000',0,0,0,'',0,'49b54d70b8b573203ed0354ae439d627',NULL,0,0,0,0,500.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02','zy100'),
	(328,'h52021011510170397378',37,'文超','18788888888','启航时代提货点',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2021-01-15 10:17:03','yue','2021-01-15 10:17:03',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,104,0,0,'122313',0,'2323c00f43eb90bd259935d0fb287f8a',NULL,0,0,0,0,100.00,0,0,'1068902040',4,2,0,3,0,0,'2021-01-15 10:17:03',NULL),
	(329,'h52021011510174055305',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2021-01-15 10:17:40','yue','2021-01-15 10:17:40',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,84,0,0,'',0,'58ba9d552a1effcabdf67c7154d6da3d',NULL,0,0,11,18,100.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:17:40',NULL),
	(330,'h52021011510192148544',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,10.00,1409.00,10.00,0.00,0,0.00,1,'2021-01-15 10:19:21','yue','2021-01-15 10:19:21',2,1,'','','收货地址填错了',NULL,'2021-01-15 10:19:52',0.00,'中远快运','express','ZYKD0000000000',704,0,0,'',0,'f8026923f0972d9ccee3ffc303e04270',NULL,0,0,0,0,500.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:19:21','zy100'),
	(331,'h52021011510204755334',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,10.00,1409.00,10.00,0.00,0,0.00,1,'2021-01-15 10:20:47','yue','2021-01-15 10:20:47',0,1,'image/product/2021/01/15/b092c4978dae4ebfbdca263ca038ac086j1ucll12d.png','','收货地址填错了',NULL,'2021-01-15 10:21:13',0.00,NULL,NULL,NULL,704,0,0,'',0,'8365a91b18c14a8e6a515cce47d69277',NULL,0,0,0,0,500.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:20:47',NULL),
	(332,'wx2021011510210648132',24,'晓汀','13991666666','山西省太原市杏花岭区哦哦哦哦哦哦哦哦哦',0.00,1,0.01,0.00,0.00,0.00,0.01,0,0.00,0,NULL,'weixin','2021-01-15 10:21:06',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,1,0,'',0,'1cfe889f8d3576ddfc9a9b09550a2842',NULL,0,0,0,0,10.00,0,0,'',0,1,0,1,0,0,'2021-01-15 10:21:06',NULL),
	(333,'h52021011510224852222',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2021-01-15 10:22:48','yue','2021-01-15 10:22:48',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,50,0,0,'',0,'bec67eaf30e9b5e10da21c8a522a5f8d',NULL,0,0,0,0,9.00,1,0,'',0,1,0,3,0,0,'2021-01-15 10:22:48',NULL),
	(334,'h52021011510235738273',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,10.00,154.50,10.00,1254.50,0,0.00,1,'2021-01-15 10:23:58','yue','2021-01-15 10:23:57',0,2,'','','收货地址填错了',NULL,'2021-01-15 10:26:52',154.50,NULL,NULL,NULL,77,2509,0,'',0,'4b5b2f1803dba374d166ae42ceaa09fa',NULL,0,0,0,0,500.00,0,0,'',0,1,0,3,0,0,'2021-01-15 10:36:02',NULL),
	(335,'h52021011510371070099',52,'邓鹏飞','13720673941','启航时代提货点',0.00,1,218.00,10.00,228.00,10.00,0.00,0,0.00,1,'2021-01-15 10:37:10','yue','2021-01-15 10:37:10',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,144,0,0,'',0,'a678e4ff350be4594a08283004236526',NULL,0,0,0,0,100.00,0,0,'1085451383',4,2,1,3,0,0,'2021-01-15 10:37:33',NULL),
	(336,'h52021011511043037030',23,'张三','020-81167888','广东省广州市海珠区新港中路397号',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'yue','2021-01-15 11:04:30',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,99,0,0,'',0,'18cd0e1121ee61ca046718ed2f55a096',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-15 11:04:30',NULL),
	(337,'wx2021011511074226826',23,'张三','020-81167888','广东省广州市海珠区新港中路397号',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-15 11:07:42',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,99,0,0,'',0,'8fcd3c21322a32efa3b044bab9890a94',NULL,0,0,0,0,100.00,0,0,'',0,1,0,1,0,0,'2021-01-15 11:07:42',NULL),
	(338,'h52021011511091469464',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2021-01-15 11:09:14','yue','2021-01-15 11:09:14',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,104,0,0,'',0,'10706b56bd77f09d7c45731cac63378c',NULL,0,0,0,0,100.00,0,0,'',0,1,0,3,0,0,'2021-01-15 11:09:14',NULL),
	(339,'wx2021011511100177863',23,'张三','020-81167888','广东省广州市海珠区新港中路397号',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-15 11:10:01',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,99,0,0,'',0,'7e11e0987e7d001b242cb947c404a6c2',NULL,0,0,0,0,100.00,0,0,'',0,1,0,1,0,0,'2021-01-15 11:10:01',NULL),
	(340,'h52021011511104518238',23,'张三','020-81167888','广东省广州市海珠区新港中路397号',0.00,1,50.00,0.00,50.00,0.00,0.00,0,0.00,0,NULL,'yue','2021-01-15 11:10:45',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,25,0,0,'',0,'ecf068c9a84f47251107108d0ad3276a',NULL,0,0,0,0,20.00,0,0,'',0,1,0,3,0,0,'2021-01-15 11:10:45',NULL),
	(341,'h52021011511150391646',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,2,100.00,0.00,99.00,0.00,0.00,211,1.00,1,'2021-01-15 11:15:03','yue','2021-01-15 11:15:03',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,49,0,0,'',0,'deb4dcebb4266edec478fe637e8ca5db',NULL,0,0,0,0,40.00,0,0,'',0,1,0,3,0,0,'2021-01-15 11:15:03',NULL),
	(342,'h52021011511273530517',23,'张三','020-81167888','广东省广州市海珠区新港中路397号',0.00,1,50.00,0.00,50.00,0.00,0.00,0,0.00,1,'2021-01-15 11:27:35','yue','2021-01-15 11:27:35',1,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,25,0,0,'',0,'d8b575b7aa39ccfe60462699b56cf553',NULL,0,0,0,0,20.00,0,0,'',0,1,0,3,0,0,'2021-01-15 11:27:35',NULL),
	(343,'h52021011610283760752',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-16 10:28:38','yue','2021-01-16 10:28:37',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,749,0,0,'',1,'da900fd79f641b42d47ef78615b5ccfe',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,1,'2021-01-16 10:28:37',NULL),
	(344,'wx2021011610380569960',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-16 10:39:16','yue','2021-01-16 10:38:05',2,0,NULL,NULL,NULL,NULL,NULL,0.00,'顺丰快运','express','SF0000000000000000',749,0,0,'',0,'8d688808476ec49fefc211ec6d5dd281',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-16 10:38:05','shunfengkuaiyun'),
	(345,'h52021011610470014192',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-16 10:47:00','yue','2021-01-16 10:47:00',2,0,NULL,NULL,NULL,NULL,NULL,0.00,'张三','send','13700000000',749,0,0,'',0,'41c8f16a94dab3eece4269c99cd9b9f9',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-16 10:47:00',NULL),
	(346,'h52021011610521258287',52,'邓鹏飞','13720673941','启航时代提货点',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-16 10:52:12','yue','2021-01-16 10:52:12',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,749,0,0,'明天 10点我自己上门提货',0,'17b753c879b5a6104e613a1546db4cd7',NULL,0,0,0,0,899.00,0,0,'1020777675',4,2,1,3,0,0,'2021-01-16 10:52:36',NULL),
	(347,'wx2021011610562194638',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-16 10:56:21',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,749,0,0,'',1,'3dd162238e6d369a447c36d12216bb32',NULL,0,0,0,0,899.00,0,0,'',0,1,0,2,0,1,'2021-01-16 10:56:21',NULL),
	(348,'wx2021011610573147808',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-16 10:57:31',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,749,0,0,'',1,'a413305410a597bf91def3b0f9e91c0b',NULL,0,0,0,0,899.00,0,0,'',0,1,0,2,0,1,'2021-01-16 10:57:31',NULL),
	(349,'wx2021011610591854537',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-16 10:59:18',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0,0,0,'',1,'d7af68f0e8039ec9a7772ae71e5e26c3',NULL,0,0,0,0,899.00,0,0,'',0,1,0,2,0,1,'2021-01-16 11:04:13',NULL),
	(350,'h52021011611055640689',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-16 11:05:56','yue','2021-01-16 11:05:56',0,2,'image/product/2021/01/16/388be41ee5e540378edcc83b1b9abf36rpi9e3s4vr.png,image/product/2021/01/16/86a7db3eab354a2ca1bc6c3476ac0a8cajkwhw50cw.png,image/product/2021/01/16/4983461a69294c088fcf887965ee8e607x949h0z8t.png','按时打卡广东萨格和较高的萨哈回家萨格回家撒的感觉撒倒萨大撒旦 ','收到商品损坏了 ','爱上巨大轰动卡号的卡号是看见啥空间的哈撒可见度阿瑟东打撒','2021-01-16 11:08:11',1399.00,NULL,NULL,NULL,749,0,0,'',0,'43b98d33b50df1447a1914b057d1b5c7',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-16 11:10:28',NULL),
	(351,'h52021011611365521486',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-16 11:36:56','yue','2021-01-16 11:36:55',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,749,0,0,'',0,'ccbb5713b2aa32ef0b0606bbbd0c8cb4',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-16 11:36:55',NULL),
	(352,'h52021011611385330518',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-16 11:38:53','yue','2021-01-16 11:38:53',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,749,0,0,'',0,'5a983a2bebbb673e43c0b83459582be9',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-16 11:38:53',NULL),
	(353,'h52021011611414039421',385,'王麻子','15209189276','山西省太原市市辖区111111',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-16 11:41:40','yue','2021-01-16 11:41:40',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,749,0,0,'',0,'914872e29fc70efcb53f1db582ea7215',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-16 11:41:40',NULL),
	(354,'h52021011614200741693',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,50.00,0.00,50.00,0.00,0.00,0,0.00,1,'2021-01-16 14:20:07','yue','2021-01-16 14:20:07',2,2,'','1111','收货地址填错了',NULL,'2021-01-16 14:21:15',50.00,NULL,'fictitious',NULL,25,0,0,'',0,'efb4508697dbd700a992754d30aba811',NULL,0,0,0,0,20.00,0,0,'',0,1,0,3,0,0,'2021-01-16 14:22:29',NULL),
	(355,'wx2021011614263050722',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,50.00,0.00,0.00,0.00,50.00,0,0.00,1,'2021-01-16 14:26:30','weixin','2021-01-16 14:26:30',0,1,'','','收货地址填错了',NULL,'2021-01-16 14:27:12',0.00,NULL,NULL,NULL,0,100,0,'',0,'42bd4f7a905b373baf0c1ea347bbc939',NULL,0,0,0,0,20.00,0,0,'',0,1,0,2,0,0,'2021-01-16 14:26:30',NULL),
	(356,'h52021011614275051860',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1389.00,0.00,0.00,239,10.00,1,'2021-01-16 14:27:50','yue','2021-01-16 14:27:50',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,744,0,0,'安科技大厦卡号的卡号是的空间哈吉斯和健康撒海底隧道撒旦',0,'d096aa4d05bf51614909f804acd9dc2c',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-16 14:27:50',NULL),
	(357,'h52021011614492142913',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-16 14:49:21','yue','2021-01-16 14:49:21',0,2,'','','收货地址填错了',NULL,'2021-01-16 14:50:46',1399.00,NULL,NULL,NULL,63,0,0,'',0,'2bf9ad7331fa590018bc63b3b8a47fcc',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-16 14:51:29',NULL),
	(358,'h52021011614512867238',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-16 14:51:28','yue','2021-01-16 14:51:28',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,63,0,0,'',0,'781281fe91c06e8b7885627394abfe6c',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-16 14:51:28',NULL),
	(359,'h52021011614551697088',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-16 14:55:16','yue','2021-01-16 14:55:16',2,2,'','哈吉上的卡号是客家话','信息填错了，重新拍 ',NULL,'2021-01-16 14:59:03',1399.00,NULL,'fictitious',NULL,63,0,0,'',0,'dc393f85e255d985d4e1dc30e48f573e',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-16 14:59:29',NULL),
	(360,'h52021011615163582791',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,1399.00,0.00,1301.53,0.00,97.47,0,0.00,1,'2021-01-16 15:16:35','yue','2021-01-16 15:16:35',0,2,'','','收货地址填错了',NULL,'2021-01-16 15:17:30',1301.53,NULL,NULL,NULL,63,9747,0,'',0,'57b00dcdcee13665c9b01ce37aa2a1a4',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-16 15:18:29',NULL),
	(361,'h52021011615390255193',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,899.00,10.00,909.00,10.00,0.00,0,0.00,1,'2021-01-16 15:39:02','yue','2021-01-16 15:39:02',0,2,'','','收货地址填错了',NULL,'2021-01-16 15:49:40',909.00,NULL,NULL,NULL,59,0,0,'',0,'2388f06a5f36eca49cf5fa6e57e3a8b9',NULL,0,0,0,0,899.00,7,0,'',0,1,0,3,0,0,'2021-01-16 15:50:29',NULL),
	(362,'h52021011615413715064',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-16 15:41:37','yue','2021-01-16 15:41:37',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',0,'5e00b9c07c8dbdbc485919462873a50f',NULL,0,0,0,0,500.00,9,0,'',0,1,0,3,0,0,'2021-01-16 15:41:37',NULL),
	(363,'wx2021011615414613887',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-16 15:41:46',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',1,'54584d98fa4c3ed01c813569b20a8ef5',NULL,0,0,0,0,500.00,9,0,'',0,1,0,2,0,0,'2021-01-16 15:41:46',NULL),
	(364,'wx2021011615471365633',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,0,NULL,'weixin','2021-01-16 15:47:13',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',1,'c4f6bb1993733b977ed721d8cca48124',NULL,0,0,0,0,500.00,9,0,'',0,1,0,2,0,0,'2021-01-16 15:47:13',NULL),
	(365,'h52021011615584692110',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-16 15:58:47','yue','2021-01-16 15:58:46',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,58,0,0,'',0,'ae44449f691880277dd1d8f4c0f40390',NULL,0,0,0,0,899.00,10,0,'',0,1,0,3,0,0,'2021-01-16 15:58:46',NULL),
	(366,'h52021011616035913916',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,1399.00,0.00,1409.00,10.00,0.00,0,0.00,1,'2021-01-16 16:03:59','yue','2021-01-16 16:03:59',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,14,0,0,'',0,'779bb0c7262f96409e9bd195c6d8d303',NULL,0,0,0,0,599.00,0,0,'',0,1,0,3,0,0,'2021-01-16 16:03:59',NULL),
	(367,'h52021011617585579751',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,899.00,10.00,909.00,10.00,0.00,0,0.00,1,'2021-01-16 17:58:57','yue','2021-01-16 17:58:55',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,59,0,0,'',0,'8223090e4be0c63fdd8a9619965f4103',NULL,0,0,0,0,899.00,0,16,'',0,1,0,3,0,0,'2021-01-16 17:58:56',NULL),
	(368,'h52021011812200822020',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,899.00,10.00,909.00,10.00,0.00,0,0.00,1,'2021-01-18 12:20:08','yue','2021-01-18 12:20:08',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,9,0,0,'自动拼团',0,'194a54c30cf8d1c1f8a841bb4c61fda5',NULL,0,0,13,19,500.00,0,0,'',0,1,0,3,0,0,'2021-01-18 12:20:08',NULL),
	(369,'h52021011812225836215',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 12:22:58','yue','2021-01-18 12:22:58',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,8,0,0,'',0,'63046dd880cfd9ca3f6b503d89386f85',NULL,0,0,12,20,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 12:22:58',NULL),
	(370,'h52021011812305933191',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 12:31:00','yue','2021-01-18 12:30:59',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',0,'f5b5ea654e1d433a1fa54cdcc5a06fdb',NULL,0,0,12,20,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 12:30:59',NULL),
	(371,'h52021011814043012080',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 14:04:30','yue','2021-01-18 14:04:30',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',0,'cf42ac84f4e7fc28191eda8694306446',NULL,0,0,12,22,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 14:04:30',NULL),
	(372,'h52021011814045280843',35,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 14:04:52','yue','2021-01-18 14:04:52',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',0,'2eb063e0c9e9c00babbbe425f0ad52de',NULL,0,0,12,23,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 14:04:52',NULL),
	(373,'h52021011814052989482',35,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 14:05:29','yue','2021-01-18 14:05:29',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',0,'25078d378c04871192033178556edc81',NULL,0,0,12,24,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 14:05:29',NULL),
	(374,'h52021011814062683481',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 14:06:26','yue','2021-01-18 14:06:26',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',0,'b5f45a5971f678f4dc6f3da1e90edb02',NULL,0,0,12,25,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 14:06:26',NULL),
	(375,'h52021011814170034434',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 14:17:00','yue','2021-01-18 14:17:00',0,2,'','','收货地址填错了',NULL,'2021-01-18 15:22:38',899.00,NULL,NULL,NULL,8,0,0,'',0,'3c84609e64db1ed5e826493a8abb2375',NULL,0,0,12,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 15:23:40',NULL),
	(376,'h52021011814221551985',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 14:22:15','yue','2021-01-18 14:22:15',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',0,'58e75fd4e874fc87312b195ed82b81ad',NULL,0,0,12,24,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 14:22:15',NULL),
	(377,'h52021011814240462723',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 14:24:04','yue','2021-01-18 14:24:04',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',0,'e149fc6befaf4feaed5e0d809e4d1794',NULL,0,0,12,24,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 14:24:04',NULL),
	(378,'h52021011814265326851',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 14:26:53','yue','2021-01-18 14:26:53',0,2,'','','收货地址填错了',NULL,'2021-01-18 14:41:23',0.00,NULL,NULL,NULL,8,0,0,'',0,'62387da813ba724c0d5841fa8dbcd6f8',NULL,0,0,12,24,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 14:43:04',NULL),
	(380,'h52021011814300296784',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 14:30:02','yue','2021-01-18 14:30:02',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',0,'32800fc06bd784fdfc5ed2fac7ac05cf',NULL,0,0,13,0,500.00,0,0,'',0,1,0,3,0,0,'2021-01-18 14:30:02',NULL),
	(381,'h52021011814455398313',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-18 14:45:53','yue','2021-01-18 14:45:53',0,2,'','','收货地址填错了',NULL,'2021-01-18 14:46:01',1399.00,NULL,NULL,NULL,63,0,0,'',0,'8a6b9511482fa2b95c08c8ba6d8ee8cd',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 14:47:04',NULL),
	(382,'h52021011814500056088',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,100.00,10.00,110.00,10.00,0.00,0,0.00,1,'2021-01-18 14:50:00','yue','2021-01-18 14:50:00',0,2,'image/product/2021/01/18/955b8ebb5db94613a634a0bfd67bdf58ro2l2xfoic.jpg','暗红色的空间哈撒可见度和啊科技时代😂','未按预定时间发货 ',NULL,'2021-01-18 14:51:53',110.00,NULL,NULL,NULL,1,0,0,'',0,'c40690dfefa866f0be23af10afaa34d1',NULL,0,0,14,27,50.00,0,0,'',0,1,0,3,0,0,'2021-01-18 14:53:04',NULL),
	(383,'h52021011815020898404',35,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2021-01-18 15:02:08','yue','2021-01-18 15:02:08',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,1,0,0,'',0,'8b54a2ece7531e41396a2f689dfac44e',NULL,0,0,0,0,50.00,0,0,'',0,1,0,3,0,0,'2021-01-18 15:02:08',NULL),
	(384,'h52021011815181755493',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 15:18:17','yue','2021-01-18 15:18:17',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'开团第一单',0,'71365d3fb80ff3cdf43540ee568fa648',NULL,0,0,12,28,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 15:18:17',NULL),
	(385,'h52021011815242678577',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,899.00,0.00,899.00,0.00,0.00,0,0.00,1,'2021-01-18 15:24:26','yue','2021-01-18 15:24:26',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,8,0,0,'',0,'e1bfa04034fc27d7f0196356b8b164ae',NULL,0,0,12,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 15:24:26',NULL),
	(386,'h52021011816001580302',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,1399.00,0.00,1399.00,0.00,0.00,0,0.00,1,'2021-01-18 16:00:15','yue','2021-01-18 16:00:15',2,0,NULL,NULL,NULL,NULL,NULL,0.00,'中远快运','express','123123123',63,0,0,'',0,'be3a88dca28ca48ff8c7b5287def8f79',NULL,0,0,0,0,899.00,0,0,'',0,1,0,3,0,0,'2021-01-18 16:00:15','zy100');

/*!40000 ALTER TABLE `eb_store_order` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_order_info
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_order_info`;

CREATE TABLE `eb_store_order_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `order_id` int(11) unsigned NOT NULL COMMENT '订单id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `info` text NOT NULL COMMENT '购买东西的详细信息',
  `unique` char(32) NOT NULL COMMENT '唯一id',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `oid` (`order_id`,`unique`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单购物详情表';

LOCK TABLES `eb_store_order_info` WRITE;
/*!40000 ALTER TABLE `eb_store_order_info` DISABLE KEYS */;

INSERT INTO `eb_store_order_info` (`id`, `order_id`, `product_id`, `info`, `unique`, `create_time`, `update_time`)
VALUES
	(3,3,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":430,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":430,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":2,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":41,\"stock\":7}},\"uid\":4,\"productAttrUnique\":\"41\",\"bargainId\":0,\"id\":5}','41','2020-12-08 14:52:34','2020-12-08 14:52:34'),
	(4,4,1,'{\"productId\":1,\"vipTruePrice\":0,\"combinationId\":1,\"costPrice\":9.00,\"trueStock\":9,\"pinkId\":0,\"truePrice\":99.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"sort\":1,\"sales\":0,\"price\":99.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"stock\":430,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"8GB,800,全网通\",\"weight\":9.00,\"type\":3,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"quota\":9,\"quotaShow\":9,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"8GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":53,\"stock\":9}},\"productAttrUnique\":\"53\"}','53','2020-12-08 14:56:41','2020-12-08 14:56:41'),
	(5,5,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":428,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":428,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":3,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":41,\"stock\":6}},\"uid\":11,\"productAttrUnique\":\"41\",\"bargainId\":0,\"id\":7}','41','2020-12-09 14:34:11','2020-12-09 14:34:11'),
	(6,6,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":427,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":427,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":197,\"stock\":5}},\"uid\":12,\"productAttrUnique\":\"197\",\"bargainId\":0,\"id\":8}','197','2020-12-09 16:40:08','2020-12-09 16:40:08'),
	(7,7,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":1000,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":1,\"keyword\":\"电脑电脑\",\"stock\":1000,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":208,\"stock\":1000}},\"uid\":11,\"productAttrUnique\":\"208\",\"bargainId\":0,\"id\":11}','208','2020-12-10 10:10:09','2020-12-10 10:10:09'),
	(8,8,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":999,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":1,\"keyword\":\"电脑电脑\",\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":208,\"stock\":999}},\"uid\":14,\"productAttrUnique\":\"208\",\"bargainId\":0,\"id\":14}','208','2020-12-10 10:33:31','2020-12-10 10:33:31'),
	(9,9,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":998,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":1,\"keyword\":\"电脑电脑\",\"stock\":998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":208,\"stock\":998}},\"uid\":14,\"productAttrUnique\":\"208\",\"bargainId\":0,\"id\":16}','208','2020-12-10 10:33:58','2020-12-10 10:33:58'),
	(10,10,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":426,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":6,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":426,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":1,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":197,\"stock\":4}},\"uid\":19,\"productAttrUnique\":\"197\",\"bargainId\":0,\"id\":18}','197','2020-12-10 15:28:11','2020-12-10 15:28:11'),
	(11,11,2,'{\"productId\":2,\"seckillId\":2,\"vipTruePrice\":0,\"costPrice\":0.00,\"trueStock\":20,\"truePrice\":10.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"123\",\"otPrice\":12000.00,\"isPostage\":false,\"sort\":1,\"sales\":0,\"postage\":0.00,\"price\":10.00,\"storeName\":\"iphone11\",\"id\":2,\"storeInfo\":\"苹果11\",\"tempId\":1,\"stock\":20,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":2,\"otPrice\":12000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10.00,\"quota\":20,\"quotaShow\":20,\"unique\":\"\",\"id\":209,\"stock\":20}},\"productAttrUnique\":\"209\"}','209','2020-12-11 15:21:43','2020-12-11 15:21:43'),
	(12,12,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":997,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":3,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":2,\"keyword\":\"电脑电脑\",\"stock\":997,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"id\":211,\"stock\":997}},\"uid\":31,\"productAttrUnique\":\"211\",\"bargainId\":0,\"id\":24}','211','2020-12-14 17:06:37','2020-12-14 17:06:37'),
	(13,13,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":425,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":7,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":425,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":2,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":197,\"stock\":3}},\"uid\":33,\"productAttrUnique\":\"197\",\"bargainId\":0,\"id\":25}','197','2020-12-15 09:31:04','2020-12-15 09:31:04'),
	(14,14,4,'{\"productId\":4,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":999,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":0,\"price\":100.00,\"storeName\":\"砍价商品\",\"id\":6,\"storeInfo\":\"砍价商品\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":999,\"unique\":\"\",\"id\":213,\"stock\":999}},\"productAttrUnique\":\"213\",\"bargainId\":6}','213','2020-12-15 09:57:18','2020-12-15 09:57:18'),
	(15,15,1,'{\"productId\":1,\"vipTruePrice\":0,\"costPrice\":9.00,\"trueStock\":9,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"unitName\":\"T\",\"isPostage\":true,\"sort\":1,\"sales\":0,\"price\":10.00,\"storeName\":\"圈粉1\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"stock\":9,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"8GB,100,全网通\",\"weight\":9.00,\"type\":2,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":10.00,\"quota\":9,\"unique\":\"\",\"id\":148,\"stock\":9}},\"productAttrUnique\":\"148\",\"bargainId\":1}','148','2020-12-15 10:24:28','2020-12-15 10:24:28'),
	(16,16,1,'{\"productId\":1,\"vipTruePrice\":0,\"costPrice\":9.00,\"trueStock\":8,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"unitName\":\"T\",\"isPostage\":true,\"sort\":1,\"sales\":1,\"price\":10.00,\"storeName\":\"圈粉1\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"stock\":8,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"8GB,100,全网通\",\"weight\":9.00,\"type\":2,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":10.00,\"quota\":8,\"unique\":\"\",\"id\":215,\"stock\":8}},\"productAttrUnique\":\"215\",\"bargainId\":1}','215','2020-12-15 10:34:08','2020-12-15 10:34:08'),
	(17,17,4,'{\"productId\":4,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":998,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":0,\"price\":100.00,\"storeName\":\"砍价商品\",\"id\":7,\"storeInfo\":\"砍价商品\",\"tempId\":2,\"stock\":998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":998,\"unique\":\"\",\"id\":217,\"stock\":998}},\"productAttrUnique\":\"217\",\"bargainId\":7}','217','2020-12-15 12:09:15','2020-12-15 12:09:15'),
	(18,18,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":999,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":0,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":999,\"unique\":\"\",\"id\":219,\"stock\":999}},\"productAttrUnique\":\"219\",\"bargainId\":8}','219','2020-12-15 12:22:01','2020-12-15 12:22:01'),
	(19,19,5,'{\"productId\":5,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":999,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":150.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"可乐\",\"id\":5,\"storeInfo\":\"可乐\",\"tempId\":2,\"keyword\":\"可乐\",\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":5,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":218,\"stock\":998}},\"uid\":35,\"productAttrUnique\":\"218\",\"bargainId\":0,\"id\":36}','218','2020-12-16 10:08:08','2020-12-16 10:08:08'),
	(20,20,7,'{\"productId\":7,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":9999,\"truePrice\":10.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"isPostage\":true,\"sort\":0,\"sales\":0,\"price\":100.00,\"storeName\":\"腰果\",\"id\":9,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":9999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":9,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":100,\"unique\":\"\",\"id\":225,\"stock\":9999}},\"productAttrUnique\":\"225\",\"bargainId\":9}','225','2020-12-17 10:25:53','2020-12-17 10:25:53'),
	(21,21,7,'{\"productId\":7,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":9998,\"truePrice\":10.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"isPostage\":true,\"sort\":0,\"sales\":1,\"price\":100.00,\"storeName\":\"腰果\",\"id\":9,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":9998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":9,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":99,\"unique\":\"\",\"id\":229,\"stock\":9998}},\"productAttrUnique\":\"229\",\"bargainId\":9}','229','2020-12-17 10:50:04','2020-12-17 10:50:04'),
	(22,22,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":996,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":2,\"keyword\":\"电脑电脑\",\"stock\":996,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"id\":211,\"stock\":996}},\"uid\":46,\"productAttrUnique\":\"211\",\"bargainId\":0,\"id\":44}','211','2020-12-17 11:01:17','2020-12-17 11:01:17'),
	(23,23,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":999,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":0,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":999,\"unique\":\"\",\"id\":224,\"stock\":999}},\"productAttrUnique\":\"224\",\"bargainId\":8}','224','2020-12-17 11:09:43','2020-12-17 11:09:43'),
	(24,24,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":998,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":1,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":998,\"unique\":\"\",\"id\":230,\"stock\":998}},\"productAttrUnique\":\"230\",\"bargainId\":8}','230','2020-12-17 11:16:49','2020-12-17 11:16:49'),
	(25,25,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":997,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":2,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":997,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":997,\"unique\":\"\",\"id\":230,\"stock\":997}},\"productAttrUnique\":\"230\",\"bargainId\":8}','230','2020-12-17 11:19:14','2020-12-17 11:19:14'),
	(26,26,7,'{\"productId\":7,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":9997,\"truePrice\":10.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"isPostage\":true,\"sort\":0,\"sales\":2,\"price\":100.00,\"storeName\":\"腰果\",\"id\":9,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":9997,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":9,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":98,\"unique\":\"\",\"id\":229,\"stock\":9997}},\"productAttrUnique\":\"229\",\"bargainId\":9}','229','2020-12-17 11:27:54','2020-12-17 11:27:54'),
	(27,27,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":9996,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":3,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":9996,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":222,\"stock\":9996}},\"uid\":35,\"productAttrUnique\":\"222\",\"bargainId\":0,\"id\":47}','222','2020-12-17 15:30:30','2020-12-17 15:30:30'),
	(28,28,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":999,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":999}},\"uid\":33,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":48}','221','2020-12-17 15:48:42','2020-12-17 15:48:42'),
	(29,29,7,'{\"productId\":7,\"vipTruePrice\":0,\"combinationId\":6,\"costPrice\":200.00,\"trueStock\":18,\"pinkId\":0,\"truePrice\":100.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"price\":100.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":6,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":18,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":18,\"quotaShow\":18,\"unique\":\"\",\"id\":348,\"stock\":18}},\"productAttrUnique\":\"348\"}','348','2020-12-18 10:31:29','2020-12-18 10:31:29'),
	(30,33,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":999,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":999,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":999}},\"productAttrUnique\":\"346\"}','346','2020-12-18 12:20:04','2020-12-18 12:20:04'),
	(31,34,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":995,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":2,\"keyword\":\"电脑电脑\",\"stock\":995,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"id\":211,\"stock\":995}},\"uid\":33,\"productAttrUnique\":\"211\",\"bargainId\":0,\"id\":94}','211','2020-12-18 16:07:49','2020-12-18 16:07:49'),
	(32,35,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":996,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":3,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":996,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":996,\"unique\":\"\",\"id\":230,\"stock\":996}},\"productAttrUnique\":\"230\",\"bargainId\":8}','230','2020-12-18 16:13:32','2020-12-18 16:13:32'),
	(33,36,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":18,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":18,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":18}},\"uid\":35,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":96}','308','2020-12-18 16:14:51','2020-12-18 16:14:51'),
	(34,37,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":17,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":17,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":17}},\"uid\":35,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":98}','308','2020-12-18 16:18:50','2020-12-18 16:18:50'),
	(35,38,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":998,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":998}},\"uid\":34,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":99}','221','2020-12-18 16:22:12','2020-12-18 16:22:12'),
	(36,39,5,'{\"productId\":5,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":994,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":150.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"可乐\",\"id\":5,\"storeInfo\":\"可乐\",\"tempId\":2,\"keyword\":\"可乐\",\"stock\":994,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":5,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":218,\"stock\":993}},\"uid\":35,\"productAttrUnique\":\"218\",\"bargainId\":0,\"id\":100}','218','2020-12-18 16:34:09','2020-12-18 16:34:09'),
	(37,40,7,'{\"productId\":7,\"vipTruePrice\":0,\"combinationId\":6,\"costPrice\":200.00,\"trueStock\":18,\"pinkId\":0,\"truePrice\":100.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"price\":100.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":6,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":18,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":18,\"quotaShow\":18,\"unique\":\"\",\"id\":348,\"stock\":18}},\"productAttrUnique\":\"348\"}','348','2020-12-21 09:20:07','2020-12-21 09:20:07'),
	(38,41,7,'{\"productId\":7,\"vipTruePrice\":0,\"combinationId\":6,\"costPrice\":200.00,\"trueStock\":17,\"pinkId\":0,\"truePrice\":100.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"sort\":0,\"sales\":1,\"price\":100.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":6,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":280,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":3,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":17,\"quotaShow\":17,\"unique\":\"\",\"id\":463,\"stock\":17}},\"productAttrUnique\":\"463\"}','463','2020-12-21 09:52:11','2020-12-21 09:52:11'),
	(39,47,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":999,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":999,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":999}},\"productAttrUnique\":\"346\"}','346','2020-12-21 10:27:58','2020-12-21 10:27:58'),
	(40,48,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":998,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":1,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":998,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":998}},\"productAttrUnique\":\"346\"}','346','2020-12-21 10:29:27','2020-12-21 10:29:27'),
	(41,49,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35962,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":2,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35962,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"银色,128GB,换修无忧年付版\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"银色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"换修无忧年付版\\\"}\",\"id\":378,\"stock\":999}},\"uid\":32,\"productAttrUnique\":\"378\",\"bargainId\":0,\"id\":102}','378','2020-12-21 10:32:18','2020-12-21 10:32:18'),
	(42,50,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":995,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":4,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":995,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":995,\"unique\":\"\",\"id\":230,\"stock\":995}},\"productAttrUnique\":\"230\",\"bargainId\":8}','230','2020-12-21 14:07:41','2020-12-21 14:07:41'),
	(43,51,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":997,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":2,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":997,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":997,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":997}},\"productAttrUnique\":\"346\"}','346','2020-12-21 14:23:32','2020-12-21 14:23:32'),
	(44,53,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":996,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":3,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":996,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":996,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":996}},\"productAttrUnique\":\"346\"}','346','2020-12-21 14:28:29','2020-12-21 14:28:29'),
	(45,60,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":995,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":4,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":995,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":995,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":995}},\"productAttrUnique\":\"346\"}','346','2020-12-21 14:51:18','2020-12-21 14:51:18'),
	(46,62,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":15,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":7,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":15,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":15}},\"uid\":37,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":104}','308','2020-12-21 15:11:49','2020-12-21 15:11:49'),
	(47,63,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":100,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":100,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":100}},\"uid\":33,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":105}','309','2020-12-21 15:22:35','2020-12-21 15:22:35'),
	(48,64,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":99,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":99,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":99}},\"uid\":33,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":106}','309','2020-12-21 15:23:39','2020-12-21 15:23:39'),
	(49,65,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":98,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":98,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":98}},\"uid\":36,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":107}','309','2020-12-21 15:26:26','2020-12-21 15:26:26'),
	(50,66,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":997,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":997,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":997}},\"uid\":37,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":108}','221','2020-12-21 15:33:19','2020-12-21 15:33:19'),
	(51,67,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":996,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":3,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":996,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":996}},\"uid\":37,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":110}','221','2020-12-21 15:42:44','2020-12-21 15:42:44'),
	(52,68,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":995,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":995,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":995}},\"uid\":32,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":113}','221','2020-12-21 16:48:16','2020-12-21 16:48:16'),
	(53,70,2,'{\"productId\":2,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":19,\"isNew\":true,\"truePrice\":9999.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":0.00,\"unitName\":\"123\",\"otPrice\":12000.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"297\",\"price\":9999.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"iphone11\",\"id\":2,\"storeInfo\":\"苹果11\",\"tempId\":1,\"keyword\":\"苹果手机\",\"stock\":19,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":0.00,\"productId\":2,\"otPrice\":12000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":9999.00,\"unique\":\"\",\"id\":207,\"stock\":19}},\"uid\":46,\"productAttrUnique\":\"207\",\"bargainId\":0,\"id\":115}','207','2020-12-21 17:26:46','2020-12-21 17:26:46'),
	(54,71,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35958,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":6,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35958,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":999}},\"uid\":46,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":116}','373','2020-12-21 17:28:32','2020-12-21 17:28:32'),
	(55,72,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35958,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":6,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35958,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":998}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":117}','373','2020-12-21 17:33:22','2020-12-21 17:33:22'),
	(56,73,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35957,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":7,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35957,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":997}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":118}','373','2020-12-21 17:34:11','2020-12-21 17:34:11'),
	(57,74,2,'{\"productId\":2,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":18,\"isNew\":true,\"truePrice\":9999.00,\"type\":\"product\",\"cartNum\":2,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":0.00,\"unitName\":\"123\",\"otPrice\":12000.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"297\",\"price\":9999.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"iphone11\",\"id\":2,\"storeInfo\":\"苹果11\",\"tempId\":1,\"keyword\":\"苹果手机\",\"stock\":18,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":0.00,\"productId\":2,\"otPrice\":12000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":9999.00,\"unique\":\"\",\"id\":207,\"stock\":18}},\"uid\":44,\"productAttrUnique\":\"207\",\"bargainId\":0,\"id\":119}','207','2020-12-21 17:34:31','2020-12-21 17:34:31'),
	(58,75,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35956,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":8,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35956,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":349,\"stock\":995}},\"uid\":44,\"productAttrUnique\":\"349\",\"bargainId\":0,\"id\":120}','349','2020-12-21 17:36:23','2020-12-21 17:36:23'),
	(59,76,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":994,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":994,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":994}},\"uid\":37,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":121}','221','2020-12-21 17:38:27','2020-12-21 17:38:27'),
	(60,77,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35955,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":9,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35955,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":996}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":122}','373','2020-12-21 17:42:20','2020-12-21 17:42:20'),
	(61,78,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35954,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":10,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35954,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":995}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":122}','373','2020-12-21 17:42:36','2020-12-21 17:42:36'),
	(62,79,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":14,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":8,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":14,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":8,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":14}},\"uid\":46,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":123}','308','2020-12-21 17:44:47','2020-12-21 17:44:47'),
	(63,80,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35953,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":11,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35953,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":994}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":124}','373','2020-12-21 17:45:43','2020-12-21 17:45:43'),
	(64,81,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35952,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":12,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35952,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":993}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":125}','373','2020-12-21 17:48:32','2020-12-21 17:48:32'),
	(65,82,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35951,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":13,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35951,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":992}},\"uid\":37,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":126}','373','2020-12-21 17:50:08','2020-12-21 17:50:08'),
	(66,83,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":993,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":6,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":993,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":993}},\"uid\":44,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":127}','221','2020-12-21 17:52:12','2020-12-21 17:52:12'),
	(67,84,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":999,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":4,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":2992,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,换修无忧年付版\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":999,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"换修无忧年付版\\\"}\",\"id\":636,\"stock\":999}},\"productAttrUnique\":\"636\"}','636','2020-12-21 18:04:57','2020-12-21 18:04:57'),
	(68,85,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35949,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":15,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35949,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":8,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":991}},\"uid\":35,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":128}','373','2020-12-21 18:14:35','2020-12-21 18:14:35'),
	(69,86,9,'{\"productId\":9,\"seckillId\":3,\"vipTruePrice\":0,\"costPrice\":5000.00,\"trueStock\":997,\"truePrice\":1.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"postage\":0.00,\"price\":1.00,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":3,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":3994,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":3,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1.00,\"quota\":997,\"quotaShow\":997,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":464,\"stock\":997}},\"productAttrUnique\":\"464\"}','464','2020-12-22 09:20:10','2020-12-22 09:20:10'),
	(70,87,14,'{\"productId\":14,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":1,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":10.00,\"unitName\":\"台\",\"otPrice\":1000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"笔记本电脑\",\"id\":14,\"storeInfo\":\"笔记本电脑\",\"tempId\":2,\"keyword\":\"笔记本电脑\",\"stock\":1,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":10.00,\"productId\":14,\"otPrice\":1000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":843,\"stock\":1}},\"uid\":52,\"productAttrUnique\":\"843\",\"bargainId\":0,\"id\":129}','843','2020-12-22 10:26:03','2020-12-22 10:26:03'),
	(71,94,14,'{\"productId\":14,\"seckillId\":4,\"vipTruePrice\":0,\"costPrice\":0.00,\"trueStock\":999,\"truePrice\":100.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":0.00,\"unitName\":\"台\",\"otPrice\":1000.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"postage\":0.00,\"price\":100.00,\"storeName\":\"笔记本电脑\",\"id\":4,\"storeInfo\":\"笔记本电脑\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":0.00,\"productId\":4,\"otPrice\":1000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":999,\"quotaShow\":999,\"unique\":\"\",\"id\":645,\"stock\":999}},\"productAttrUnique\":\"645\"}','645','2020-12-22 11:13:01','2020-12-22 11:13:01'),
	(72,95,14,'{\"productId\":14,\"seckillId\":4,\"vipTruePrice\":0,\"costPrice\":0.00,\"trueStock\":999,\"truePrice\":100.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":0.00,\"unitName\":\"台\",\"otPrice\":1000.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"postage\":0.00,\"price\":100.00,\"storeName\":\"笔记本电脑\",\"id\":4,\"storeInfo\":\"笔记本电脑\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":0.00,\"productId\":4,\"otPrice\":1000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":999,\"quotaShow\":999,\"unique\":\"\",\"id\":645,\"stock\":999}},\"productAttrUnique\":\"645\"}','645','2020-12-22 11:13:45','2020-12-22 11:13:45'),
	(73,96,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1800,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":0,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1800,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":100}},\"uid\":52,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":132}','847','2020-12-22 11:23:00','2020-12-22 11:23:00'),
	(74,97,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1799,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":1,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1799,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":99}},\"uid\":52,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":133}','847','2020-12-22 12:11:47','2020-12-22 12:11:47'),
	(75,98,19,'{\"productId\":19,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":200.00,\"trueStock\":1200,\"isNew\":true,\"truePrice\":428.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i1\\\\/693060164\\\\/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg\",\"cost\":200.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":98,\"sales\":0,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01hRYyYC1D59aGylQuO_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01IzHD3j1D59aKgOB4A_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01tL10tb1D59aGbm21Z_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01XnrWtq1D59aGblUki_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":428.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"id\":19,\"storeInfo\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"tempId\":2,\"keyword\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"stock\":1200,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\",\"cost\":200.00,\"productId\":19,\"otPrice\":0.00,\"suk\":\"190/104A/XXXL,蓝灰25\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":428.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"190/104A/XXXL\\\",\\\"颜色\\\":\\\"蓝灰25\\\"}\",\"id\":906,\"stock\":100}},\"uid\":52,\"productAttrUnique\":\"906\",\"bargainId\":0,\"id\":134}','906','2020-12-22 14:39:34','2020-12-22 14:39:34'),
	(76,99,19,'{\"productId\":19,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":200.00,\"trueStock\":1199,\"isNew\":true,\"truePrice\":428.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i1\\\\/693060164\\\\/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg\",\"cost\":200.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":98,\"sales\":1,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01hRYyYC1D59aGylQuO_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01IzHD3j1D59aKgOB4A_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01tL10tb1D59aGbm21Z_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01XnrWtq1D59aGblUki_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":428.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"id\":19,\"storeInfo\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"tempId\":2,\"keyword\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"stock\":1199,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\",\"cost\":200.00,\"productId\":19,\"otPrice\":0.00,\"suk\":\"190/104A/XXXL,蓝灰25\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":428.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"190/104A/XXXL\\\",\\\"颜色\\\":\\\"蓝灰25\\\"}\",\"id\":906,\"stock\":99}},\"uid\":52,\"productAttrUnique\":\"906\",\"bargainId\":0,\"id\":135}','906','2020-12-22 14:44:28','2020-12-22 14:44:28'),
	(77,100,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":500,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":0,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":500,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":100}},\"uid\":40,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":136}','839','2020-12-22 15:07:58','2020-12-22 15:07:58'),
	(78,101,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":499,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":499,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":99}},\"uid\":52,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":137}','839','2020-12-22 15:48:10','2020-12-22 15:48:10'),
	(79,102,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1798,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":2,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1798,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":98}},\"uid\":57,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":138}','847','2020-12-22 15:49:39','2020-12-22 15:49:39'),
	(80,103,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1797,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":3,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1797,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":97}},\"uid\":34,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":141}','847','2020-12-22 16:05:12','2020-12-22 16:05:12'),
	(81,104,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1796,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":4,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1796,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,粉红58\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"粉红58\\\"}\",\"id\":848,\"stock\":100}},\"uid\":57,\"productAttrUnique\":\"848\",\"bargainId\":0,\"id\":143}','848','2020-12-22 16:37:22','2020-12-22 16:37:22'),
	(82,105,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1795,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":2,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":5,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1795,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,粉红58\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"粉红58\\\"}\",\"id\":848,\"stock\":99}},\"uid\":52,\"productAttrUnique\":\"848\",\"bargainId\":0,\"id\":145}','848','2020-12-22 16:39:33','2020-12-22 16:39:33'),
	(83,106,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":422,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":10,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":422,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":393,\"stock\":2}},\"uid\":32,\"productAttrUnique\":\"393\",\"bargainId\":0,\"id\":146}','393','2020-12-22 16:44:29','2020-12-22 16:44:29'),
	(84,107,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1793,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":7,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1793,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":96}},\"uid\":35,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":147}','847','2020-12-22 16:45:22','2020-12-22 16:45:22'),
	(85,108,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":13,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":9,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":13,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":9,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":13}},\"uid\":32,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":148}','308','2020-12-22 16:48:34','2020-12-22 16:48:34'),
	(86,109,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":12,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":10,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":12,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":10,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":12}},\"uid\":32,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":150}','308','2020-12-22 16:49:28','2020-12-22 16:49:28'),
	(87,110,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":499,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":499,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":99}},\"uid\":32,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":152}','839','2020-12-22 17:47:16','2020-12-22 17:47:16'),
	(88,111,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":498,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":498,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":98}},\"uid\":52,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":155}','839','2020-12-23 09:18:47','2020-12-23 09:18:47'),
	(89,112,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1792,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":8,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1792,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":95}},\"uid\":52,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":173}','847','2020-12-23 09:50:00','2020-12-23 09:50:00'),
	(90,113,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":1920,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":1920,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1124,\"stock\":10}},\"uid\":57,\"productAttrUnique\":\"1124\",\"bargainId\":0,\"id\":174}','1124','2020-12-23 09:56:20','2020-12-23 09:56:20'),
	(91,114,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1791,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":2,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":9,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1791,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":94}},\"uid\":52,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":175}','847','2020-12-23 10:02:01','2020-12-23 10:02:01'),
	(92,115,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1789,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":11,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1789,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":92}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":178}','1319','2020-12-23 10:06:52','2020-12-23 10:06:52'),
	(93,116,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":421,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":11,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":421,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":1,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":393,\"stock\":1}},\"uid\":33,\"productAttrUnique\":\"393\",\"bargainId\":0,\"id\":179}','393','2020-12-23 10:07:21','2020-12-23 10:07:21'),
	(94,117,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":497,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":3,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":497,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":97}},\"uid\":33,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":180}','839','2020-12-23 10:15:11','2020-12-23 10:15:11'),
	(95,118,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1789,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":11,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1789,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":92}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":181}','1319','2020-12-23 10:23:10','2020-12-23 10:23:10'),
	(96,119,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1789,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":11,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1789,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":92}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":183}','1319','2020-12-23 10:25:05','2020-12-23 10:25:05'),
	(97,120,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1789,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":11,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1789,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":92}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":184}','1319','2020-12-23 10:28:42','2020-12-23 10:28:42'),
	(98,121,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":420,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":12,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":420,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"32GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"32GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":409,\"stock\":9}},\"uid\":44,\"productAttrUnique\":\"409\",\"bargainId\":0,\"id\":185}','409','2020-12-23 10:47:05','2020-12-23 10:47:05'),
	(99,122,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":496,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":496,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":96}},\"uid\":52,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":186}','839','2020-12-23 10:55:24','2020-12-23 10:55:24'),
	(100,123,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1789,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":11,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1789,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":92}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":187}','1319','2020-12-23 10:57:21','2020-12-23 10:57:21'),
	(101,124,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1788,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":12,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1788,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":91}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":189}','1319','2020-12-23 11:11:47','2020-12-23 11:11:47'),
	(102,125,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1787,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":13,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1787,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":90}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":190}','1319','2020-12-23 11:15:24','2020-12-23 11:15:24'),
	(103,126,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":496,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":496,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":96}},\"uid\":52,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":191}','839','2020-12-23 11:20:04','2020-12-23 11:20:04'),
	(104,127,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1786,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":14,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1786,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":89}},\"uid\":57,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":193}','1319','2020-12-23 11:39:59','2020-12-23 11:39:59'),
	(105,128,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1786,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":14,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1786,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":89}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":192}','1319','2020-12-23 11:40:48','2020-12-23 11:40:48'),
	(106,129,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1784,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":16,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1784,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":87}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":197}','1319','2020-12-23 11:56:03','2020-12-23 11:56:03'),
	(107,130,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1784,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":16,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1784,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":87}},\"uid\":57,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":196}','1319','2020-12-23 11:59:27','2020-12-23 11:59:27'),
	(108,131,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":1920,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":1920,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1124,\"stock\":10}},\"uid\":35,\"productAttrUnique\":\"1124\",\"bargainId\":0,\"id\":199}','1124','2020-12-23 12:02:55','2020-12-23 12:02:55'),
	(109,132,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":1919,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":1919,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1124,\"stock\":9}},\"uid\":57,\"productAttrUnique\":\"1124\",\"bargainId\":0,\"id\":200}','1124','2020-12-23 12:03:30','2020-12-23 12:03:30'),
	(110,133,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":495,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":495,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":95}},\"uid\":33,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":201}','839','2020-12-23 12:17:02','2020-12-23 12:17:02'),
	(111,134,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":419,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":13,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":419,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"16GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"16GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":397,\"stock\":9}},\"uid\":23,\"productAttrUnique\":\"397\",\"bargainId\":0,\"id\":202}','397','2020-12-23 15:02:39','2020-12-23 15:02:39'),
	(112,135,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1782,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":18,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1782,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":85}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":229}','1319','2020-12-23 17:34:33','2020-12-23 17:34:33'),
	(113,136,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":494,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":6,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":494,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":94}},\"uid\":52,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":232}','839','2020-12-23 17:36:00','2020-12-23 17:36:00'),
	(114,137,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":493,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":7,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":493,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":93}},\"uid\":52,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":236}','839','2020-12-23 17:41:42','2020-12-23 17:41:42'),
	(115,138,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1781,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":19,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1781,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":8,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":84}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":242}','1319','2020-12-23 17:58:55','2020-12-23 17:58:55'),
	(116,139,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":97,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":3,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":97,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":97}},\"uid\":99,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":252}','309','2020-12-23 18:16:12','2020-12-23 18:16:12'),
	(117,140,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":492,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":8,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":492,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":8,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":92}},\"uid\":130,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":256}','839','2020-12-23 21:38:56','2020-12-23 21:38:56'),
	(118,141,13,'{\"productId\":13,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":111.00,\"trueStock\":107460,\"isNew\":true,\"truePrice\":1000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"img.alicdn.com\\\\/imgextra\\\\/i4\\\\/1794176171\\\\/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg\",\"cost\":111.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01GwvntW1vSMkhgUUw5_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/1794176171/O1CN01OdxsQm1vSMkfOhu8B_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN013HlIBb1vSMklCF1Hj_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01bB9sy01vSMkjBsRO7_!!1794176171.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"472\",\"price\":1000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"id\":13,\"storeInfo\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"tempId\":2,\"keyword\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"stock\":107460,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":111.00,\"productId\":13,\"otPrice\":0.00,\"suk\":\"暗夜黑【8G运行】 5％选择这款,套餐二,512GB,中国大陆\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1000.00,\"unique\":\"\",\"attrValue\":\"{\\\"机身颜色\\\":\\\"暗夜黑【8G运行】 5％选择这款\\\",\\\"套餐类型\\\":\\\"套餐二\\\",\\\"存储容量\\\":\\\"512GB\\\",\\\"版本类型\\\":\\\"中国大陆\\\"}\",\"id\":489,\"stock\":995}},\"uid\":32,\"productAttrUnique\":\"489\",\"bargainId\":0,\"id\":269}','489','2020-12-24 09:22:55','2020-12-24 09:22:55'),
	(119,142,13,'{\"productId\":13,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":111.00,\"trueStock\":107459,\"isNew\":true,\"truePrice\":1000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"img.alicdn.com\\\\/imgextra\\\\/i4\\\\/1794176171\\\\/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg\",\"cost\":111.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01GwvntW1vSMkhgUUw5_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/1794176171/O1CN01OdxsQm1vSMkfOhu8B_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN013HlIBb1vSMklCF1Hj_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01bB9sy01vSMkjBsRO7_!!1794176171.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"472\",\"price\":1000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"id\":13,\"storeInfo\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"tempId\":2,\"keyword\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"stock\":107459,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":111.00,\"productId\":13,\"otPrice\":0.00,\"suk\":\"暗夜黑【8G运行】 5％选择这款,套餐二,512GB,中国大陆\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1000.00,\"unique\":\"\",\"attrValue\":\"{\\\"机身颜色\\\":\\\"暗夜黑【8G运行】 5％选择这款\\\",\\\"套餐类型\\\":\\\"套餐二\\\",\\\"存储容量\\\":\\\"512GB\\\",\\\"版本类型\\\":\\\"中国大陆\\\"}\",\"id\":489,\"stock\":994}},\"uid\":32,\"productAttrUnique\":\"489\",\"bargainId\":0,\"id\":269}','489','2020-12-24 09:23:09','2020-12-24 09:23:09'),
	(120,143,13,'{\"productId\":13,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":111.00,\"trueStock\":107458,\"isNew\":true,\"truePrice\":1000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"img.alicdn.com\\\\/imgextra\\\\/i4\\\\/1794176171\\\\/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg\",\"cost\":111.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":2,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01GwvntW1vSMkhgUUw5_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/1794176171/O1CN01OdxsQm1vSMkfOhu8B_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN013HlIBb1vSMklCF1Hj_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01bB9sy01vSMkjBsRO7_!!1794176171.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"472\",\"price\":1000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"id\":13,\"storeInfo\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"tempId\":2,\"keyword\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"stock\":107458,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":111.00,\"productId\":13,\"otPrice\":0.00,\"suk\":\"暗夜黑【8G运行】 5％选择这款,套餐二,512GB,中国大陆\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1000.00,\"unique\":\"\",\"attrValue\":\"{\\\"机身颜色\\\":\\\"暗夜黑【8G运行】 5％选择这款\\\",\\\"套餐类型\\\":\\\"套餐二\\\",\\\"存储容量\\\":\\\"512GB\\\",\\\"版本类型\\\":\\\"中国大陆\\\"}\",\"id\":489,\"stock\":993}},\"uid\":32,\"productAttrUnique\":\"489\",\"bargainId\":0,\"id\":271}','489','2020-12-24 09:30:55','2020-12-24 09:30:55'),
	(121,144,13,'{\"productId\":13,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":111.00,\"trueStock\":107457,\"isNew\":true,\"truePrice\":1000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"img.alicdn.com\\\\/imgextra\\\\/i4\\\\/1794176171\\\\/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg\",\"cost\":111.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":3,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01GwvntW1vSMkhgUUw5_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/1794176171/O1CN01OdxsQm1vSMkfOhu8B_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN013HlIBb1vSMklCF1Hj_!!1794176171.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01bB9sy01vSMkjBsRO7_!!1794176171.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"472\",\"price\":1000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"id\":13,\"storeInfo\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"tempId\":2,\"keyword\":\"P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机\",\"stock\":107457,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":111.00,\"productId\":13,\"otPrice\":0.00,\"suk\":\"暗夜黑【8G运行】 5％选择这款,套餐二,512GB,中国大陆\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1000.00,\"unique\":\"\",\"attrValue\":\"{\\\"机身颜色\\\":\\\"暗夜黑【8G运行】 5％选择这款\\\",\\\"套餐类型\\\":\\\"套餐二\\\",\\\"存储容量\\\":\\\"512GB\\\",\\\"版本类型\\\":\\\"中国大陆\\\"}\",\"id\":489,\"stock\":992}},\"uid\":32,\"productAttrUnique\":\"489\",\"bargainId\":0,\"id\":274}','489','2020-12-24 09:39:38','2020-12-24 09:39:38'),
	(122,145,17,'{\"productId\":17,\"seckillId\":6,\"vipTruePrice\":0,\"costPrice\":100.00,\"trueStock\":91,\"truePrice\":218.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"sort\":100,\"sales\":0,\"postage\":0.00,\"price\":218.00,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":6,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":291,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":6,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":91,\"quotaShow\":91,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1347,\"stock\":91}},\"productAttrUnique\":\"1347\"}','1347','2020-12-24 11:01:28','2020-12-24 11:01:28'),
	(123,146,17,'{\"productId\":17,\"seckillId\":6,\"vipTruePrice\":0,\"costPrice\":100.00,\"trueStock\":90,\"truePrice\":218.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"sort\":100,\"sales\":1,\"postage\":0.00,\"price\":218.00,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":6,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":290,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":6,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":1,\"quotaShow\":1,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1357,\"stock\":90}},\"productAttrUnique\":\"1357\"}','1357','2020-12-24 11:07:11','2020-12-24 11:07:11'),
	(124,147,17,'{\"productId\":17,\"seckillId\":6,\"vipTruePrice\":0,\"costPrice\":100.00,\"trueStock\":90,\"truePrice\":218.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"sort\":100,\"sales\":1,\"postage\":0.00,\"price\":218.00,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":6,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":290,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":6,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":1,\"quotaShow\":1,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1357,\"stock\":90}},\"productAttrUnique\":\"1357\"}','1357','2020-12-24 11:07:11','2020-12-24 11:07:11'),
	(125,148,17,'{\"productId\":17,\"seckillId\":6,\"vipTruePrice\":0,\"costPrice\":100.00,\"trueStock\":100,\"truePrice\":218.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"sort\":100,\"sales\":2,\"postage\":0.00,\"price\":218.00,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":6,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":289,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":6,\"otPrice\":299.00,\"suk\":\"170/88A/M,牛仔蓝66\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":100,\"quotaShow\":100,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1362,\"stock\":100}},\"productAttrUnique\":\"1362\"}','1362','2020-12-24 11:30:00','2020-12-24 11:30:00'),
	(126,149,17,'{\"productId\":17,\"vipTruePrice\":0,\"costPrice\":100.00,\"trueStock\":100,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":100,\"sales\":0,\"price\":218.00,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":10,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":100,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":10,\"otPrice\":299.00,\"suk\":\"170/88A/M,牛仔蓝66\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":1,\"unique\":\"\",\"id\":1365,\"stock\":100}},\"productAttrUnique\":\"1365\",\"bargainId\":10}','1365','2020-12-24 11:57:34','2020-12-24 11:57:34'),
	(127,150,17,'{\"productId\":17,\"vipTruePrice\":0,\"costPrice\":100.00,\"trueStock\":100,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":100,\"sales\":0,\"price\":218.00,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":10,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":100,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":10,\"otPrice\":299.00,\"suk\":\"170/88A/M,牛仔蓝66\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":1,\"unique\":\"\",\"id\":1365,\"stock\":100}},\"productAttrUnique\":\"1365\",\"bargainId\":10}','1365','2020-12-24 11:57:34','2020-12-24 11:57:34'),
	(128,151,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":96,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":96,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":96}},\"uid\":58,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":277}','309','2020-12-24 12:03:20','2020-12-24 12:03:20'),
	(129,152,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":489,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":11,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":489,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":11,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":89}},\"uid\":170,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":279}','839','2020-12-24 14:45:58','2020-12-24 14:45:58'),
	(130,153,15,'{\"productId\":15,\"vipTruePrice\":0,\"costPrice\":100.00,\"trueStock\":100,\"truePrice\":10.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":99,\"sales\":0,\"price\":159.00,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":11,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"stock\":100,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":11,\"otPrice\":199.00,\"suk\":\"165/84A/S,燕麦54\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"quota\":100,\"unique\":\"\",\"id\":1369,\"stock\":100}},\"productAttrUnique\":\"1369\",\"bargainId\":11}','1369','2020-12-24 15:59:08','2020-12-24 15:59:08'),
	(131,154,9,'{\"productId\":9,\"seckillId\":3,\"vipTruePrice\":0,\"costPrice\":5000.00,\"trueStock\":993,\"truePrice\":1.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":1,\"postage\":0.00,\"price\":1.00,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":3,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":3990,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":3,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1.00,\"quota\":993,\"quotaShow\":993,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":1370,\"stock\":993}},\"productAttrUnique\":\"1370\"}','1370','2020-12-24 16:08:17','2020-12-24 16:08:17'),
	(132,155,17,'{\"productId\":17,\"vipTruePrice\":0,\"combinationId\":9,\"costPrice\":100.00,\"trueStock\":91,\"pinkId\":0,\"truePrice\":218.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":299.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"sort\":100,\"sales\":0,\"price\":218.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":9,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":291,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":9,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":91,\"quotaShow\":91,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1351,\"stock\":91}},\"productAttrUnique\":\"1351\"}','1351','2020-12-24 16:14:00','2020-12-24 16:14:00'),
	(133,156,17,'{\"productId\":17,\"vipTruePrice\":0,\"combinationId\":9,\"costPrice\":100.00,\"trueStock\":99,\"pinkId\":0,\"truePrice\":218.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":299.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"sort\":100,\"sales\":1,\"price\":218.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":9,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":99,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":9,\"otPrice\":299.00,\"suk\":\"170/88A/M,牛仔蓝66\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":2,\"quotaShow\":2,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1376,\"stock\":99}},\"productAttrUnique\":\"1376\"}','1376','2020-12-24 16:48:05','2020-12-24 16:48:05'),
	(134,157,17,'{\"productId\":17,\"vipTruePrice\":0,\"costPrice\":100.00,\"trueStock\":98,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":100,\"sales\":1,\"price\":218.00,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":10,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":98,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":10,\"otPrice\":299.00,\"suk\":\"170/88A/M,牛仔蓝66\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":50,\"unique\":\"\",\"id\":1377,\"stock\":98}},\"productAttrUnique\":\"1377\",\"bargainId\":10}','1377','2020-12-24 17:11:28','2020-12-24 17:11:28'),
	(135,158,1,'{\"productId\":1,\"vipTruePrice\":0,\"costPrice\":9.00,\"trueStock\":9,\"truePrice\":10.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"isPostage\":true,\"sort\":1,\"sales\":0,\"price\":99.00,\"storeName\":\"圈粉\",\"id\":14,\"storeInfo\":\"圈粉\",\"tempId\":1,\"stock\":9,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":14,\"otPrice\":9.00,\"suk\":\"128GB,100,全网通\",\"weight\":9.00,\"type\":2,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"quota\":9,\"unique\":\"\",\"id\":1379,\"stock\":9}},\"productAttrUnique\":\"1379\",\"bargainId\":14}','1379','2020-12-24 17:22:52','2020-12-24 17:22:52'),
	(136,159,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":95,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":95,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":95}},\"uid\":184,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":286}','309','2020-12-24 19:25:17','2020-12-24 19:25:17'),
	(137,160,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1779,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":21,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1779,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":9,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":83}},\"uid\":193,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":288}','1319','2020-12-24 23:02:30','2020-12-24 23:02:30'),
	(138,161,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1778,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":22,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1778,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":10,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":82}},\"uid\":199,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":290}','1319','2020-12-25 09:30:11','2020-12-25 09:30:11'),
	(139,162,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":417,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":15,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":417,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"16GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":1,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"16GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":397,\"stock\":8}},\"uid\":32,\"productAttrUnique\":\"397\",\"bargainId\":0,\"id\":291}','397','2020-12-25 09:38:19','2020-12-25 09:38:19'),
	(140,163,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":485,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":15,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":485,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":13,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":87}},\"uid\":227,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":297}','839','2020-12-26 09:38:57','2020-12-26 09:38:57'),
	(141,164,1,'{\"productId\":1,\"vipTruePrice\":0,\"combinationId\":8,\"costPrice\":9.00,\"trueStock\":8,\"pinkId\":0,\"truePrice\":10.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"sort\":1,\"sales\":0,\"price\":10.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":8,\"storeInfo\":\"圈粉\",\"tempId\":1,\"stock\":8,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":8,\"otPrice\":9.00,\"suk\":\"128GB,100,全网通\",\"weight\":9.00,\"type\":3,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":10.00,\"quota\":8,\"quotaShow\":8,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":1433,\"stock\":8}},\"productAttrUnique\":\"1433\"}','1433','2020-12-26 09:41:59','2020-12-26 09:41:59'),
	(142,165,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":484,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":16,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":484,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":14,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":86}},\"uid\":230,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":299}','839','2020-12-26 09:42:34','2020-12-26 09:42:34'),
	(143,166,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":94,\"isNew\":false,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":6,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":94,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":94}},\"uid\":227,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":300}','309','2020-12-26 09:50:13','2020-12-26 09:50:13'),
	(144,167,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":93,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":7,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":93,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":93}},\"uid\":227,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":301}','309','2020-12-26 09:55:30','2020-12-26 09:55:30'),
	(145,168,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":415,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":17,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":415,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"16GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":2,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"16GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":397,\"stock\":7}},\"uid\":230,\"productAttrUnique\":\"397\",\"bargainId\":0,\"id\":302}','397','2020-12-26 10:06:20','2020-12-26 10:06:20'),
	(146,169,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":484,\"isNew\":false,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":16,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":484,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"190/104A/XXXL,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"190/104A/XXXL\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":842,\"stock\":100}},\"uid\":236,\"productAttrUnique\":\"842\",\"bargainId\":0,\"id\":306}','842','2020-12-26 14:32:30','2020-12-26 14:32:30'),
	(147,170,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":483,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":17,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":483,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":14,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":86}},\"uid\":240,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":308}','839','2020-12-26 16:50:19','2020-12-26 16:50:19'),
	(148,171,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1777,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":23,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1777,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":11,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":81}},\"uid\":257,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":321}','1319','2020-12-28 13:33:44','2020-12-28 13:33:44'),
	(149,172,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":92,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":8,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":92,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":8,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":92}},\"uid\":257,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":323}','309','2020-12-28 13:35:51','2020-12-28 13:35:51'),
	(150,173,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":414,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":18,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":414,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"16GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":3,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"16GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":397,\"stock\":6}},\"uid\":257,\"productAttrUnique\":\"397\",\"bargainId\":0,\"id\":324}','397','2020-12-28 13:36:47','2020-12-28 13:36:47'),
	(151,174,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1776,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":24,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1776,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":12,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":80}},\"uid\":258,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":325}','1319','2020-12-28 13:40:16','2020-12-28 13:40:16'),
	(152,175,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2909,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":2,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2909,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":999}},\"uid\":31,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":333}','1435','2020-12-28 17:47:47','2020-12-28 17:47:47'),
	(153,176,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2908,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":3,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2908,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":998}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":335}','1435','2020-12-28 17:49:43','2020-12-28 17:49:43'),
	(154,177,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2907,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":4,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2907,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":997}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":336}','1435','2020-12-28 17:54:31','2020-12-28 17:54:31'),
	(155,178,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2906,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2906,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":996}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":337}','1435','2020-12-28 17:58:24','2020-12-28 17:58:24'),
	(156,179,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2905,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":6,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2905,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":995}},\"uid\":31,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":338}','1435','2020-12-28 17:58:29','2020-12-28 17:58:29'),
	(157,180,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2904,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":7,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2904,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":994}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":340}','1435','2020-12-28 18:01:26','2020-12-28 18:01:26'),
	(158,181,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2903,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":8,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2903,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":993}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":339}','1435','2020-12-28 18:02:20','2020-12-28 18:02:20'),
	(159,182,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2902,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":9,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2902,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":992}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":341}','1435','2020-12-28 18:02:38','2020-12-28 18:02:38'),
	(160,183,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2901,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":10,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2901,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":8,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":991}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":342}','1435','2020-12-28 18:05:48','2020-12-28 18:05:48'),
	(161,184,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2900,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":11,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2900,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":9,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":990}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":344}','1435','2020-12-28 18:09:29','2020-12-28 18:09:29'),
	(162,185,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2899,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":12,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2899,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":10,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":989}},\"uid\":31,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":363}','1435','2020-12-29 10:00:28','2020-12-29 10:00:28'),
	(163,186,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2898,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":13,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2898,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":11,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":988}},\"uid\":31,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":364}','1435','2020-12-29 10:14:21','2020-12-29 10:14:21'),
	(164,187,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2897,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":14,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2897,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":12,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":987}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":365}','1435','2020-12-29 10:24:25','2020-12-29 10:24:25'),
	(165,188,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":91,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":9,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":91,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":9,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":91}},\"uid\":46,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":366}','309','2020-12-29 10:25:17','2020-12-29 10:25:17'),
	(166,189,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2896,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":15,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2896,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":13,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":986}},\"uid\":23,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":367}','1435','2020-12-29 10:27:56','2020-12-29 10:27:56'),
	(167,190,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2895,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":16,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2895,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":14,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":985}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":368}','1435','2020-12-29 10:34:35','2020-12-29 10:34:35'),
	(168,191,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2894,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":17,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2894,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":15,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":984}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":369}','1435','2020-12-29 10:52:18','2020-12-29 10:52:18'),
	(169,192,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2893,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":18,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2893,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":16,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":983}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":370}','1435','2020-12-29 10:53:05','2020-12-29 10:53:05'),
	(170,193,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2892,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":19,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2892,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":17,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":982}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":371}','1435','2020-12-29 11:00:32','2020-12-29 11:00:32'),
	(171,194,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2891,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":20,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2891,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":18,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":981}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":372}','1435','2020-12-29 11:03:58','2020-12-29 11:03:58'),
	(172,195,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2890,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":21,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2890,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":19,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":980}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":373}','1435','2020-12-29 11:07:04','2020-12-29 11:07:04'),
	(173,196,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2889,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":22,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2889,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":20,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":979}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":374}','1435','2020-12-29 11:09:10','2020-12-29 11:09:10'),
	(174,197,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":90,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":10,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":90,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":10,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":90}},\"uid\":46,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":375}','309','2020-12-29 11:23:38','2020-12-29 11:23:38'),
	(175,198,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":413,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":19,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":413,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"16GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":4,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"16GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":397,\"stock\":5}},\"uid\":46,\"productAttrUnique\":\"397\",\"bargainId\":0,\"id\":376}','397','2020-12-29 11:23:54','2020-12-29 11:23:54'),
	(176,199,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":412,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":20,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":412,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"16GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":5,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"16GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":397,\"stock\":4}},\"uid\":46,\"productAttrUnique\":\"397\",\"bargainId\":0,\"id\":377}','397','2020-12-29 11:26:35','2020-12-29 11:26:35'),
	(177,200,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2888,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":23,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2888,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":21,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":978}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":378}','1435','2020-12-29 11:36:33','2020-12-29 11:36:33'),
	(178,201,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2887,\"isNew\":true,\"truePrice\":20.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":24,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2887,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试2,2,12,是\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":20.00,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试2\\\",\\\"生成\\\":\\\"2\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"是\\\"}\",\"id\":1582,\"stock\":10}},\"uid\":46,\"productAttrUnique\":\"1582\",\"bargainId\":0,\"id\":379}','1582','2020-12-29 11:36:54','2020-12-29 11:36:54'),
	(179,202,24,'{\"productId\":24,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":139986,\"isNew\":true,\"truePrice\":139.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http:\\\\/\\\\/img30.360buyimg.com\\\\/popWaterMark\\\\/jfs\\\\/t1\\\\/138203\\\\/3\\\\/19369\\\\/160173\\\\/5fe1eec8E4e044a62\\\\/887ee589177b7d34.jpg\",\"cost\":50.00,\"unitName\":\"个\",\"otPrice\":139.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/138203/3/19369/160173/5fe1eec8E4e044a62/887ee589177b7d34.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/137988/36/19651/122239/5fe2ce8dE68fb722f/00648b4f02870a39.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/148608/26/15298/132874/5fbb8cd4E5f233aff/d9406bfb524528f9.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/148480/39/19703/93142/5fe2ce92E84e8b1fe/b1f13161fdc078fe.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/145353/7/19636/112878/5fe2d1f5Eb83b9312/a3fa09975faa818b.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151593/29/5302/471046/5fa9586dE92711957/01fead04ac7c0eb3.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/145677/35/13531/288227/5fa9586eEa9d02dc5/4ef621bf47030d5e.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516,517\",\"price\":139.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【官方名品丨限量首发】【精选牛皮丨专柜品质】加绒可选 轻奢手工定制真皮高帮男靴舒适百搭防水马丁靴 黑色-单里款 41\",\"id\":24,\"storeInfo\":\"【官方名品丨限量首发】【精选牛皮丨专柜品质】加绒可选 轻奢手工定制真皮高帮男靴舒适百搭防水马丁靴 黑色-单里款 41\",\"tempId\":2,\"keyword\":\"啦\",\"stock\":139986,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"http:\\\\/\\\\/img30.360buyimg.com\\\\/popWaterMark\\\\/jfs\\\\/t1\\\\/138203\\\\/3\\\\/19369\\\\/160173\\\\/5fe1eec8E4e044a62\\\\/887ee589177b7d34.jpg\",\"cost\":50.00,\"productId\":24,\"otPrice\":139.00,\"suk\":\"黑色-加绒款,38\",\"weight\":1.00,\"type\":0,\"sales\":0,\"barCode\":\"123\",\"brokerageTwo\":0.00,\"volume\":1.00,\"price\":139.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"黑色-加绒款\\\",\\\"尺码\\\":\\\"38\\\"}\",\"id\":1387,\"stock\":9999}},\"uid\":46,\"productAttrUnique\":\"1387\",\"bargainId\":0,\"id\":380}','1387','2020-12-29 11:37:11','2020-12-29 11:37:11'),
	(180,203,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":482,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":18,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":482,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":15,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":85}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":381}','839','2020-12-29 11:38:14','2020-12-29 11:38:14'),
	(181,204,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":481,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":19,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":481,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":16,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":84}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":382}','839','2020-12-29 11:44:20','2020-12-29 11:44:20'),
	(182,205,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":480,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":20,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":480,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":17,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":83}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":383}','839','2020-12-29 11:44:38','2020-12-29 11:44:38'),
	(183,206,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":479,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":21,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":479,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":18,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":82}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":384}','839','2020-12-29 11:45:29','2020-12-29 11:45:29'),
	(184,207,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":478,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":22,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":478,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":19,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":81}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":385}','839','2020-12-29 11:51:17','2020-12-29 11:51:17'),
	(185,208,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":477,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":23,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":477,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":20,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":80}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":386}','839','2020-12-29 11:51:40','2020-12-29 11:51:40'),
	(186,209,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":476,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":24,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":476,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":21,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":79}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":387}','839','2020-12-29 11:53:18','2020-12-29 11:53:18'),
	(187,210,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":475,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":25,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":475,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":22,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":78}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":388}','839','2020-12-29 11:57:47','2020-12-29 11:57:47');

INSERT INTO `eb_store_order_info` (`id`, `order_id`, `product_id`, `info`, `unique`, `create_time`, `update_time`)
VALUES
	(188,211,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":474,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":26,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":474,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":23,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":77}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":389}','839','2020-12-29 11:58:59','2020-12-29 11:58:59'),
	(189,212,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":473,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":27,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":473,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":24,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":76}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":390}','839','2020-12-29 12:00:35','2020-12-29 12:00:35'),
	(190,213,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":472,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":28,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":472,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":25,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":75}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":391}','839','2020-12-29 12:01:07','2020-12-29 12:01:07'),
	(191,214,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":471,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":29,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":471,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":26,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":74}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":392}','839','2020-12-29 12:01:33','2020-12-29 12:01:33'),
	(192,215,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":470,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":30,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":470,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":27,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":73}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":393}','839','2020-12-29 12:11:17','2020-12-29 12:11:17'),
	(193,216,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":469,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":31,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":469,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":28,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":72}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":394}','839','2020-12-29 12:11:38','2020-12-29 12:11:38'),
	(194,217,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":468,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":32,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":468,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":29,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":71}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":395}','839','2020-12-29 12:23:12','2020-12-29 12:23:12'),
	(195,218,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":467,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":33,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":467,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":30,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":70}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":396}','839','2020-12-29 12:23:27','2020-12-29 12:23:27'),
	(196,219,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":466,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":34,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":466,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":31,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":69}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":397}','839','2020-12-29 12:24:02','2020-12-29 12:24:02'),
	(197,220,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":465,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":35,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":465,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":32,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":68}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":398}','839','2020-12-29 12:26:49','2020-12-29 12:26:49'),
	(198,221,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":464,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":36,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":464,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":33,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":67}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":400}','839','2020-12-29 15:21:10','2020-12-29 15:21:10'),
	(199,222,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":463,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":37,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":463,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":34,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":66}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":401}','839','2020-12-29 15:21:52','2020-12-29 15:21:52'),
	(200,223,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":462,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":38,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":462,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":35,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":65}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":404}','839','2020-12-29 15:30:39','2020-12-29 15:30:39'),
	(201,224,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":461,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":39,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":461,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":36,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":64}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":405}','839','2020-12-29 15:35:49','2020-12-29 15:35:49'),
	(202,225,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":460,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":40,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":460,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":37,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":63}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":406}','839','2020-12-29 15:44:52','2020-12-29 15:44:52'),
	(203,226,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":459,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":41,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":459,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":38,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":62}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":407}','839','2020-12-29 15:47:29','2020-12-29 15:47:29'),
	(204,227,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":458,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":42,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":458,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":39,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":61}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":408}','839','2020-12-29 16:52:12','2020-12-29 16:52:12'),
	(205,228,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":457,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":43,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":457,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":40,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":60}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":409}','839','2020-12-29 16:52:48','2020-12-29 16:52:48'),
	(206,229,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":456,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":44,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":456,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":41,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":59}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":410}','839','2020-12-29 16:58:53','2020-12-29 16:58:53'),
	(207,230,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":455,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":45,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":455,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":42,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":58}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":411}','839','2020-12-29 17:03:26','2020-12-29 17:03:26'),
	(208,231,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":454,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":46,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":454,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":43,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":57}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":412}','839','2020-12-29 17:12:15','2020-12-29 17:12:15'),
	(209,232,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":453,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":47,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":453,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":44,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":56}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":414}','839','2020-12-29 17:24:35','2020-12-29 17:24:35'),
	(210,233,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":452,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":48,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":452,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":45,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":55}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":416}','839','2020-12-29 17:29:35','2020-12-29 17:29:35'),
	(211,234,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":451,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":49,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":451,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":46,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":54}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":417}','839','2020-12-29 17:32:22','2020-12-29 17:32:22'),
	(212,235,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":450,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":50,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":450,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":47,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":53}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":418}','839','2020-12-29 17:32:46','2020-12-29 17:32:46'),
	(213,236,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":449,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":51,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":449,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":48,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":52}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":419}','839','2020-12-29 17:38:33','2020-12-29 17:38:33'),
	(214,237,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2886,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":25,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2886,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":22,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":977}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":420}','1435','2020-12-29 17:40:22','2020-12-29 17:40:22'),
	(215,238,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":448,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":52,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":448,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":49,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":51}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":421}','839','2020-12-29 17:45:01','2020-12-29 17:45:01'),
	(216,239,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":447,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":53,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":447,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":50,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":50}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":422}','839','2020-12-29 17:59:35','2020-12-29 17:59:35'),
	(217,240,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":446,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":54,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":446,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":51,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":49}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":423}','839','2020-12-29 18:04:57','2020-12-29 18:04:57'),
	(218,241,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2885,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":26,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2885,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":23,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":976}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":424}','1435','2020-12-29 18:06:51','2020-12-29 18:06:51'),
	(219,242,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":445,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":55,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":445,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":52,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":48}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":426}','839','2020-12-29 18:13:44','2020-12-29 18:13:44'),
	(220,243,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":89,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":11,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":89,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":11,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":89}},\"uid\":33,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":441}','309','2020-12-29 18:20:21','2020-12-29 18:20:21'),
	(221,244,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1775,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":25,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1775,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":13,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":79}},\"uid\":33,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":442}','1319','2020-12-29 18:20:43','2020-12-29 18:20:43'),
	(222,245,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":444,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":56,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":444,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":53,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":47}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":443}','839','2020-12-29 18:25:18','2020-12-29 18:25:18'),
	(223,246,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":411,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":21,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":411,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"16GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":6,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"16GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":397,\"stock\":3}},\"uid\":46,\"productAttrUnique\":\"397\",\"bargainId\":0,\"id\":444}','397','2020-12-29 18:32:35','2020-12-29 18:32:35'),
	(224,247,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":410,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":22,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":410,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"16GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":7,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"16GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":397,\"stock\":2}},\"uid\":46,\"productAttrUnique\":\"397\",\"bargainId\":0,\"id\":446}','397','2020-12-29 18:40:10','2020-12-29 18:40:10'),
	(225,248,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":443,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":57,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":443,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":54,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":46}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":447}','839','2020-12-29 18:47:22','2020-12-29 18:47:22'),
	(226,249,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1774,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":26,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1774,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":14,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":78}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":449}','1319','2020-12-29 18:52:02','2020-12-29 18:52:02'),
	(227,250,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":409,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":23,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":409,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"16GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":8,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"16GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":397,\"stock\":1}},\"uid\":46,\"productAttrUnique\":\"397\",\"bargainId\":0,\"id\":448}','397','2020-12-29 18:52:13','2020-12-29 18:52:13'),
	(228,251,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":442,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":58,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":442,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":55,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":45}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":450}','839','2020-12-29 18:53:46','2020-12-29 18:53:46'),
	(229,252,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":441,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":59,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":441,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":56,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":44}},\"uid\":46,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":451}','839','2020-12-29 18:54:43','2020-12-29 18:54:43'),
	(230,253,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":408,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":24,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":408,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":2,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":385,\"stock\":7}},\"uid\":46,\"productAttrUnique\":\"385\",\"bargainId\":0,\"id\":452}','385','2020-12-29 19:02:28','2020-12-29 19:02:28'),
	(231,254,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":407,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":25,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":407,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":3,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":385,\"stock\":6}},\"uid\":46,\"productAttrUnique\":\"385\",\"bargainId\":0,\"id\":453}','385','2020-12-29 19:08:54','2020-12-29 19:08:54'),
	(232,255,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":406,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":26,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":406,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":4,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":385,\"stock\":5}},\"uid\":46,\"productAttrUnique\":\"385\",\"bargainId\":0,\"id\":454}','385','2020-12-29 19:15:24','2020-12-29 19:15:24'),
	(233,256,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1773,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":27,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1773,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":15,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":77}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":455}','1319','2020-12-29 19:26:33','2020-12-29 19:26:33'),
	(234,257,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1772,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":28,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1772,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":16,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":76}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":456}','1319','2020-12-29 19:54:51','2020-12-29 19:54:51'),
	(235,258,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1771,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":29,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1771,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":17,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":75}},\"uid\":33,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":465}','1319','2020-12-30 09:18:52','2020-12-30 09:18:52'),
	(236,259,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1770,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":30,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1770,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":18,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":74}},\"uid\":33,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":467}','1319','2020-12-30 09:25:37','2020-12-30 09:25:37'),
	(237,260,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1769,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":31,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1769,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":19,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":73}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":471}','1319','2020-12-30 10:40:29','2020-12-30 10:40:29'),
	(238,261,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1768,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":32,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1768,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":20,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":72}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":474}','1319','2020-12-30 11:09:32','2020-12-30 11:09:32'),
	(239,262,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1767,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":33,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1767,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":21,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":71}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":475}','1319','2020-12-30 11:13:31','2020-12-30 11:13:31'),
	(240,263,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1766,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":34,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1766,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":22,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":70}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":476}','1319','2020-12-30 11:19:23','2020-12-30 11:19:23'),
	(241,264,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1765,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":35,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1765,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":23,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":69}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":477}','1319','2020-12-30 11:49:09','2020-12-30 11:49:09'),
	(242,265,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1764,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":36,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1764,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":24,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":68}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":478}','1319','2020-12-30 11:56:16','2020-12-30 11:56:16'),
	(243,266,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1763,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":37,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1763,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":25,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":67}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":479}','1319','2020-12-30 12:06:38','2020-12-30 12:06:38'),
	(244,267,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1762,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":38,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1762,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":26,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":66}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":480}','1319','2020-12-30 13:58:28','2020-12-30 13:58:28'),
	(245,268,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1761,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":39,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1761,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":27,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":65}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":481}','1319','2020-12-30 13:59:23','2020-12-30 13:59:23'),
	(246,269,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1760,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":40,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1760,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":28,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":64}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":482}','1319','2020-12-30 14:04:40','2020-12-30 14:04:40'),
	(247,270,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1759,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":41,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1759,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":29,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":63}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":483}','1319','2020-12-30 15:27:49','2020-12-30 15:27:49'),
	(248,271,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1758,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":42,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1758,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":30,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":62}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":496}','1319','2020-12-30 15:48:44','2020-12-30 15:48:44'),
	(249,272,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2884,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":27,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2884,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":24,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":975}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":497}','1435','2020-12-30 15:50:28','2020-12-30 15:50:28'),
	(250,273,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2883,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":28,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2883,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":25,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":974}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":498}','1435','2020-12-30 15:51:36','2020-12-30 15:51:36'),
	(251,274,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2882,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":29,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2882,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":26,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":973}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":500}','1435','2020-12-30 16:00:06','2020-12-30 16:00:06'),
	(252,275,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2881,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":30,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2881,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":27,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":972}},\"uid\":44,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":501}','1435','2020-12-30 17:31:10','2020-12-30 17:31:10'),
	(253,276,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1757,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":43,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1757,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":31,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":61}},\"uid\":46,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":503}','1319','2020-12-31 15:11:09','2020-12-31 15:11:09'),
	(254,277,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2880,\"isNew\":true,\"truePrice\":20.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":31,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2880,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,2,12,df \",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":20.00,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"2\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1451,\"stock\":10}},\"uid\":46,\"productAttrUnique\":\"1451\",\"bargainId\":0,\"id\":504}','1451','2020-12-31 15:15:10','2020-12-31 15:15:10'),
	(255,278,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2879,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":32,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2879,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":28,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":971}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":505}','1435','2020-12-31 15:21:39','2020-12-31 15:21:39'),
	(256,279,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1756,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":44,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1756,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"180/96A/XL,黑色53\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"180/96A/XL\\\",\\\"颜色\\\":\\\"黑色53\\\"}\",\"id\":1327,\"stock\":100}},\"uid\":31,\"productAttrUnique\":\"1327\",\"bargainId\":0,\"id\":506}','1327','2020-12-31 16:26:34','2020-12-31 16:26:34'),
	(257,280,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1755,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":45,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1755,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"185/100A/XXL,黑色53\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"185/100A/XXL\\\",\\\"颜色\\\":\\\"黑色53\\\"}\",\"id\":1330,\"stock\":100}},\"uid\":37,\"productAttrUnique\":\"1330\",\"bargainId\":0,\"id\":507}','1330','2020-12-31 16:29:01','2020-12-31 16:29:01'),
	(258,281,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2878,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":33,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2878,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":29,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1435,\"stock\":970}},\"uid\":46,\"productAttrUnique\":\"1435\",\"bargainId\":0,\"id\":508}','1435','2020-12-31 17:53:14','2020-12-31 17:53:14'),
	(259,282,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":440,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":60,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":440,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"190/104A/XXXL,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"190/104A/XXXL\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":842,\"stock\":99}},\"uid\":37,\"productAttrUnique\":\"842\",\"bargainId\":0,\"id\":536}','842','2021-01-05 15:52:17','2021-01-05 15:52:17'),
	(260,283,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":439,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":61,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":439,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"185/100A/XXL,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"185/100A/XXL\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":841,\"stock\":100}},\"uid\":37,\"productAttrUnique\":\"841\",\"bargainId\":0,\"id\":537}','841','2021-01-05 16:05:47','2021-01-05 16:05:47'),
	(261,284,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":15.90,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1754,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":46,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1754,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"185/100A/XXL,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"185/100A/XXL\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1328,\"stock\":100}},\"uid\":37,\"productAttrUnique\":\"1328\",\"bargainId\":0,\"id\":548}','1328','2021-01-05 17:27:05','2021-01-05 17:27:05'),
	(262,285,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":438,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":62,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":438,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":57,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":43}},\"uid\":33,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":549}','839','2021-01-05 17:33:12','2021-01-05 17:33:12'),
	(263,286,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":9.90,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":405,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":27,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":405,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":5,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":385,\"stock\":4}},\"uid\":33,\"productAttrUnique\":\"385\",\"bargainId\":0,\"id\":569}','385','2021-01-07 10:37:43','2021-01-07 10:37:43'),
	(264,287,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":9.90,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":404,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":28,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":404,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":6,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":385,\"stock\":3}},\"uid\":33,\"productAttrUnique\":\"385\",\"bargainId\":0,\"id\":572}','385','2021-01-07 11:32:43','2021-01-07 11:32:43'),
	(265,288,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":15.90,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1753,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":47,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1753,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":32,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":60}},\"uid\":33,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":573}','1319','2021-01-07 11:44:50','2021-01-07 11:44:50'),
	(266,289,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":9.90,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":403,\"isNew\":false,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":29,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":403,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":7,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":385,\"stock\":2}},\"uid\":37,\"productAttrUnique\":\"385\",\"bargainId\":0,\"id\":577}','385','2021-01-07 15:40:18','2021-01-07 15:40:18'),
	(267,290,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":9.90,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":402,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":30,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":402,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":8,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":385,\"stock\":1}},\"uid\":37,\"productAttrUnique\":\"385\",\"bargainId\":0,\"id\":580}','385','2021-01-07 16:06:22','2021-01-07 16:06:22'),
	(268,291,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":9.90,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":401,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":31,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":401,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,联通\",\"weight\":9.00,\"type\":0,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"联通\\\"}\",\"id\":388,\"stock\":9}},\"uid\":37,\"productAttrUnique\":\"388\",\"bargainId\":0,\"id\":581}','388','2021-01-07 16:07:31','2021-01-07 16:07:31'),
	(269,292,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":9.90,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":400,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":32,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":400,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,联通\",\"weight\":9.00,\"type\":0,\"sales\":1,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"联通\\\"}\",\"id\":388,\"stock\":8}},\"uid\":37,\"productAttrUnique\":\"388\",\"bargainId\":0,\"id\":582}','388','2021-01-07 16:36:38','2021-01-07 16:36:38'),
	(270,293,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":9.90,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":399,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":33,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":399,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"32GB,100,联通\",\"weight\":9.00,\"type\":0,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"32GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"联通\\\"}\",\"id\":412,\"stock\":9}},\"uid\":37,\"productAttrUnique\":\"412\",\"bargainId\":0,\"id\":583}','412','2021-01-07 16:43:45','2021-01-07 16:43:45'),
	(271,294,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":20.00,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2877,\"isNew\":true,\"truePrice\":20.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":34,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2877,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试2,2,12,是\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":20.00,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试2\\\",\\\"生成\\\":\\\"2\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"是\\\"}\",\"id\":1778,\"stock\":9}},\"uid\":48,\"productAttrUnique\":\"1778\",\"bargainId\":0,\"id\":602}','1778','2021-01-08 16:12:10','2021-01-08 16:12:10'),
	(272,295,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":159.00,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1753,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":47,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1753,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":33,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":59}},\"uid\":48,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":603}','1319','2021-01-08 16:16:28','2021-01-08 16:16:28'),
	(273,296,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":2.00,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2876,\"isNew\":true,\"truePrice\":20.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":35,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2876,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试2,2,12,是\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":20.00,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试2\\\",\\\"生成\\\":\\\"2\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"是\\\"}\",\"id\":1778,\"stock\":8}},\"uid\":33,\"productAttrUnique\":\"1778\",\"bargainId\":0,\"id\":604}','1778','2021-01-09 11:45:57','2021-01-09 11:45:57'),
	(274,297,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":99.00,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":398,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"isSub\":false,\"sort\":1,\"sales\":34,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":398,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,联通\",\"weight\":9.00,\"type\":0,\"sales\":2,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"联通\\\"}\",\"id\":388,\"stock\":7}},\"uid\":44,\"productAttrUnique\":\"388\",\"bargainId\":0,\"id\":608}','388','2021-01-09 17:32:29','2021-01-09 17:32:29'),
	(275,298,17,'{\"productId\":17,\"vipTruePrice\":218.00,\"combinationId\":9,\"costPrice\":100.00,\"trueStock\":97,\"pinkId\":0,\"truePrice\":218.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":299.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"sort\":100,\"sales\":2,\"price\":218.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":9,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":97,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":9,\"otPrice\":299.00,\"suk\":\"170/88A/M,牛仔蓝66\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":2,\"quotaShow\":2,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1859,\"stock\":97}},\"productAttrUnique\":\"1859\"}','1859','2021-01-11 09:59:26','2021-01-11 09:59:26'),
	(276,299,17,'{\"productId\":17,\"vipTruePrice\":218.00,\"combinationId\":9,\"costPrice\":100.00,\"trueStock\":96,\"pinkId\":15,\"truePrice\":218.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":299.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"sort\":100,\"sales\":3,\"price\":218.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":9,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":96,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":9,\"otPrice\":299.00,\"suk\":\"170/88A/M,牛仔蓝66\",\"weight\":0.00,\"type\":3,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":1,\"quotaShow\":2,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1859,\"stock\":96}},\"productAttrUnique\":\"1859\"}','1859','2021-01-11 10:00:43','2021-01-11 10:00:43'),
	(277,300,17,'{\"productId\":17,\"vipTruePrice\":218.00,\"combinationId\":9,\"costPrice\":100.00,\"trueStock\":95,\"pinkId\":0,\"truePrice\":218.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":299.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"sort\":100,\"sales\":4,\"price\":218.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":9,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"stock\":95,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":9,\"otPrice\":299.00,\"suk\":\"170/88A/M,牛仔蓝66\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"quota\":1,\"quotaShow\":1,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1860,\"stock\":95}},\"productAttrUnique\":\"1860\"}','1860','2021-01-11 10:08:38','2021-01-11 10:08:38'),
	(278,301,1,'{\"productId\":1,\"seckillId\":1,\"vipTruePrice\":0,\"costPrice\":9.00,\"trueStock\":9,\"truePrice\":99.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":0.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"sort\":1,\"sales\":0,\"postage\":0.00,\"price\":99.00,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"stock\":9,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,移动\",\"weight\":9.00,\"type\":1,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"quota\":9,\"quotaShow\":9,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"移动\\\"}\",\"id\":1864,\"stock\":9}},\"productAttrUnique\":\"1864\"}','1864','2021-01-11 10:24:42','2021-01-11 10:24:42'),
	(279,302,1,'{\"productId\":1,\"seckillId\":1,\"vipTruePrice\":0,\"costPrice\":9.00,\"trueStock\":8,\"truePrice\":99.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":0.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"sort\":1,\"sales\":1,\"postage\":0.00,\"price\":99.00,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"stock\":8,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,移动\",\"weight\":9.00,\"type\":1,\"sales\":1,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"quota\":8,\"quotaShow\":9,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"移动\\\"}\",\"id\":1864,\"stock\":8}},\"productAttrUnique\":\"1864\"}','1864','2021-01-11 10:25:11','2021-01-11 10:25:11'),
	(280,303,25,'{\"productId\":25,\"seckillId\":0,\"vipTruePrice\":0.10,\"combinationId\":0,\"costPrice\":1.00,\"trueStock\":1,\"isNew\":true,\"truePrice\":1.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":1.00,\"unitName\":\"件\",\"otPrice\":1.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\\\",\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516,517\",\"price\":1.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"测优惠券\",\"id\":25,\"storeInfo\":\"测优惠券\",\"tempId\":2,\"keyword\":\"测优惠券\",\"stock\":1,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":1.00,\"productId\":25,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1.00,\"unique\":\"\",\"id\":1823,\"stock\":1}},\"uid\":32,\"productAttrUnique\":\"1823\",\"bargainId\":0,\"id\":610}','1823','2021-01-11 10:26:43','2021-01-11 10:26:43'),
	(281,304,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0.00,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":88,\"isNew\":false,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":12,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":88,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":12,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":88}},\"uid\":33,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":112}','309','2021-01-11 11:06:27','2021-01-11 11:06:27'),
	(282,305,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":434,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":65,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":434,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1855,\"stock\":42}},\"uid\":37,\"productAttrUnique\":\"1855\",\"bargainId\":0,\"id\":631}','1855','2021-01-12 11:43:58','2021-01-12 11:43:58'),
	(283,306,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":2.00,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2875,\"isNew\":true,\"truePrice\":20.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":36,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2875,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试2,2,12,是\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":20.00,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试2\\\",\\\"生成\\\":\\\"2\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"是\\\"}\",\"id\":1778,\"stock\":7}},\"uid\":33,\"productAttrUnique\":\"1778\",\"bargainId\":0,\"id\":651}','1778','2021-01-13 09:26:45','2021-01-13 09:26:45'),
	(284,307,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":433,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":66,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":433,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1855,\"stock\":41}},\"uid\":32,\"productAttrUnique\":\"1855\",\"bargainId\":0,\"id\":656}','1855','2021-01-13 12:26:11','2021-01-13 12:26:11'),
	(285,308,26,'{\"productId\":26,\"seckillId\":0,\"vipTruePrice\":5.00,\"combinationId\":0,\"costPrice\":20.00,\"trueStock\":12,\"isNew\":true,\"truePrice\":50.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\",\"cost\":20.00,\"unitName\":\"台\",\"otPrice\":100.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273\",\"price\":50.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":26,\"storeInfo\":\"电脑\",\"tempId\":2,\"keyword\":\"电脑\",\"stock\":12,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\",\"cost\":20.00,\"productId\":26,\"otPrice\":100.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":50.00,\"unique\":\"\",\"id\":1902,\"stock\":12}},\"uid\":32,\"productAttrUnique\":\"1902\",\"bargainId\":0,\"id\":659}','1902','2021-01-14 10:39:34','2021-01-14 10:39:34'),
	(286,309,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":432,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":67,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":432,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1855,\"stock\":40}},\"uid\":32,\"productAttrUnique\":\"1855\",\"bargainId\":0,\"id\":661}','1855','2021-01-14 10:47:25','2021-01-14 10:47:25'),
	(287,310,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":431,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":68,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":431,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1915,\"stock\":39}},\"uid\":52,\"productAttrUnique\":\"1915\",\"bargainId\":0,\"id\":664}','1915','2021-01-14 11:18:41','2021-01-14 11:18:41'),
	(288,311,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":15.90,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1752,\"isNew\":false,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":48,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1752,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":34,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":58}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":665}','1319','2021-01-14 12:19:15','2021-01-14 12:19:15'),
	(289,312,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":15.90,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1751,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":49,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1751,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":35,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":57}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":666}','1319','2021-01-14 12:21:16','2021-01-14 12:21:16'),
	(290,313,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":10.00,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":992,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":7,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":992,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":992}},\"uid\":52,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":667}','221','2021-01-14 12:26:02','2021-01-14 12:26:02'),
	(291,314,26,'{\"productId\":26,\"seckillId\":0,\"vipTruePrice\":5.00,\"combinationId\":0,\"costPrice\":20.00,\"trueStock\":50,\"isNew\":true,\"truePrice\":50.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\",\"cost\":20.00,\"unitName\":\"台\",\"otPrice\":100.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273\",\"price\":50.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":26,\"storeInfo\":\"电脑\",\"tempId\":2,\"keyword\":\"电脑\",\"stock\":50,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\",\"cost\":20.00,\"productId\":26,\"otPrice\":100.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":50.00,\"unique\":\"\",\"id\":1919,\"stock\":50}},\"uid\":32,\"productAttrUnique\":\"1919\",\"bargainId\":0,\"id\":668}','1919','2021-01-14 14:06:57','2021-01-14 14:06:57'),
	(292,315,26,'{\"productId\":26,\"seckillId\":0,\"vipTruePrice\":5.00,\"combinationId\":0,\"costPrice\":20.00,\"trueStock\":50,\"isNew\":true,\"truePrice\":50.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\",\"cost\":20.00,\"unitName\":\"台\",\"otPrice\":100.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273\",\"price\":50.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":26,\"storeInfo\":\"电脑\",\"tempId\":2,\"keyword\":\"电脑\",\"stock\":50,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\",\"cost\":20.00,\"productId\":26,\"otPrice\":100.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":50.00,\"unique\":\"\",\"id\":1919,\"stock\":50}},\"uid\":32,\"productAttrUnique\":\"1919\",\"bargainId\":0,\"id\":669}','1919','2021-01-14 14:13:37','2021-01-14 14:13:37'),
	(293,316,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":10.00,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":992,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":7,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":992,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":992}},\"uid\":52,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":671}','221','2021-01-14 15:07:03','2021-01-14 15:07:03'),
	(294,317,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":430,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":69,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":3,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":430,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1921,\"stock\":38}},\"uid\":52,\"productAttrUnique\":\"1921\",\"bargainId\":0,\"id\":676}','1921','2021-01-14 15:28:30','2021-01-14 15:28:30'),
	(295,318,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":430,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":69,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":3,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":430,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1921,\"stock\":38}},\"uid\":52,\"productAttrUnique\":\"1921\",\"bargainId\":0,\"id\":678}','1921','2021-01-14 15:31:25','2021-01-14 15:31:25'),
	(296,319,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":430,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":69,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":3,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":430,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1921,\"stock\":38}},\"uid\":52,\"productAttrUnique\":\"1921\",\"bargainId\":0,\"id\":681}','1921','2021-01-15 09:12:05','2021-01-15 09:12:05'),
	(297,320,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":429,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":70,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":3,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":429,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1921,\"stock\":37}},\"uid\":32,\"productAttrUnique\":\"1921\",\"bargainId\":0,\"id\":683}','1921','2021-01-15 09:17:41','2021-01-15 09:17:41'),
	(298,321,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":15.90,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1754,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":46,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1754,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":32,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":60}},\"uid\":32,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":686}','1319','2021-01-15 09:21:12','2021-01-15 09:21:12'),
	(299,322,28,'{\"productId\":28,\"seckillId\":0,\"vipTruePrice\":1399.00,\"combinationId\":0,\"costPrice\":500.00,\"trueStock\":1800,\"isNew\":true,\"truePrice\":1399.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/15/c8bb13307db9431ea04c26ef2b5586e33zbgdu0mu1.png\",\"cost\":500.00,\"unitName\":\"件\",\"otPrice\":1599.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01JSyvWP1WggkHZ4JV4_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01sypoLu1WggkFgvjkz_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN012ZNCw21Wggk3e048T_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01E77iW21Wggk9rMrVh_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01RjoAqG1WggkHZ42sg_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01wE59b41WggkEW0A8U_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01KMrteX1WggkHBdK18_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01aGJf9x1Wggk3e0Ovi_!!3327042818.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516,517\",\"price\":1399.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"id\":28,\"storeInfo\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"tempId\":3,\"keyword\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"stock\":1800,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i3\\\\/3327042818\\\\/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\",\"cost\":500.00,\"productId\":28,\"otPrice\":1599.00,\"suk\":\"36.5,200海滩浅黄/金属金/暗硫黄/亮深红/白色\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1399.00,\"unique\":\"\",\"attrValue\":\"{\\\"鞋码\\\":\\\"36.5\\\",\\\"颜色分类\\\":\\\"200海滩浅黄/金属金/暗硫黄/亮深红/白色\\\"}\",\"id\":1963,\"stock\":100}},\"uid\":57,\"productAttrUnique\":\"1963\",\"bargainId\":0,\"id\":687}','1963','2021-01-15 10:00:53','2021-01-15 10:00:53'),
	(300,323,28,'{\"productId\":28,\"seckillId\":0,\"vipTruePrice\":1399.00,\"combinationId\":0,\"costPrice\":500.00,\"trueStock\":1799,\"isNew\":true,\"truePrice\":1399.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/15/c8bb13307db9431ea04c26ef2b5586e33zbgdu0mu1.png\",\"cost\":500.00,\"unitName\":\"件\",\"otPrice\":1599.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01JSyvWP1WggkHZ4JV4_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01sypoLu1WggkFgvjkz_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN012ZNCw21Wggk3e048T_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01E77iW21Wggk9rMrVh_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01RjoAqG1WggkHZ42sg_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01wE59b41WggkEW0A8U_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01KMrteX1WggkHBdK18_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01aGJf9x1Wggk3e0Ovi_!!3327042818.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516,517\",\"price\":1399.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"id\":28,\"storeInfo\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"tempId\":3,\"keyword\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"stock\":1799,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i3\\\\/3327042818\\\\/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\",\"cost\":500.00,\"productId\":28,\"otPrice\":1599.00,\"suk\":\"36.5,200海滩浅黄/金属金/暗硫黄/亮深红/白色\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1399.00,\"unique\":\"\",\"attrValue\":\"{\\\"鞋码\\\":\\\"36.5\\\",\\\"颜色分类\\\":\\\"200海滩浅黄/金属金/暗硫黄/亮深红/白色\\\"}\",\"id\":1963,\"stock\":99}},\"uid\":57,\"productAttrUnique\":\"1963\",\"bargainId\":0,\"id\":692}','1963','2021-01-15 10:03:58','2021-01-15 10:03:58'),
	(301,324,28,'{\"productId\":28,\"seckillId\":0,\"vipTruePrice\":139.90,\"combinationId\":0,\"costPrice\":500.00,\"trueStock\":1798,\"isNew\":true,\"truePrice\":1399.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/15/c8bb13307db9431ea04c26ef2b5586e33zbgdu0mu1.png\",\"cost\":500.00,\"unitName\":\"件\",\"otPrice\":1599.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":2,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01JSyvWP1WggkHZ4JV4_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01sypoLu1WggkFgvjkz_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN012ZNCw21Wggk3e048T_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01E77iW21Wggk9rMrVh_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01RjoAqG1WggkHZ42sg_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01wE59b41WggkEW0A8U_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01KMrteX1WggkHBdK18_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01aGJf9x1Wggk3e0Ovi_!!3327042818.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516,517\",\"price\":1399.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"id\":28,\"storeInfo\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"tempId\":3,\"keyword\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"stock\":1798,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i3\\\\/3327042818\\\\/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\",\"cost\":500.00,\"productId\":28,\"otPrice\":1599.00,\"suk\":\"36.5,200海滩浅黄/金属金/暗硫黄/亮深红/白色\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1399.00,\"unique\":\"\",\"attrValue\":\"{\\\"鞋码\\\":\\\"36.5\\\",\\\"颜色分类\\\":\\\"200海滩浅黄/金属金/暗硫黄/亮深红/白色\\\"}\",\"id\":1963,\"stock\":98}},\"uid\":35,\"productAttrUnique\":\"1963\",\"bargainId\":0,\"id\":693}','1963','2021-01-15 10:05:05','2021-01-15 10:05:05'),
	(302,325,28,'{\"productId\":28,\"seckillId\":0,\"vipTruePrice\":1399.00,\"combinationId\":0,\"costPrice\":500.00,\"trueStock\":1797,\"isNew\":true,\"truePrice\":1399.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/15/c8bb13307db9431ea04c26ef2b5586e33zbgdu0mu1.png\",\"cost\":500.00,\"unitName\":\"件\",\"otPrice\":1599.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":3,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01JSyvWP1WggkHZ4JV4_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01sypoLu1WggkFgvjkz_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN012ZNCw21Wggk3e048T_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01E77iW21Wggk9rMrVh_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01RjoAqG1WggkHZ42sg_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01wE59b41WggkEW0A8U_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01KMrteX1WggkHBdK18_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01aGJf9x1Wggk3e0Ovi_!!3327042818.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516,517\",\"price\":1399.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"id\":28,\"storeInfo\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"tempId\":3,\"keyword\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"stock\":1797,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i3\\\\/3327042818\\\\/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\",\"cost\":500.00,\"productId\":28,\"otPrice\":1599.00,\"suk\":\"36.5,200海滩浅黄/金属金/暗硫黄/亮深红/白色\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1399.00,\"unique\":\"\",\"attrValue\":\"{\\\"鞋码\\\":\\\"36.5\\\",\\\"颜色分类\\\":\\\"200海滩浅黄/金属金/暗硫黄/亮深红/白色\\\"}\",\"id\":1963,\"stock\":97}},\"uid\":57,\"productAttrUnique\":\"1963\",\"bargainId\":0,\"id\":694}','1963','2021-01-15 10:08:07','2021-01-15 10:08:07'),
	(303,326,28,'{\"productId\":28,\"seckillId\":0,\"vipTruePrice\":1399.00,\"combinationId\":0,\"costPrice\":500.00,\"trueStock\":1796,\"isNew\":true,\"truePrice\":1399.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/15/c8bb13307db9431ea04c26ef2b5586e33zbgdu0mu1.png\",\"cost\":500.00,\"unitName\":\"件\",\"otPrice\":1599.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":4,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01JSyvWP1WggkHZ4JV4_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01sypoLu1WggkFgvjkz_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN012ZNCw21Wggk3e048T_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01E77iW21Wggk9rMrVh_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01RjoAqG1WggkHZ42sg_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01wE59b41WggkEW0A8U_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01KMrteX1WggkHBdK18_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01aGJf9x1Wggk3e0Ovi_!!3327042818.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516,517\",\"price\":1399.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"id\":28,\"storeInfo\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"tempId\":3,\"keyword\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"stock\":1796,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i3\\\\/3327042818\\\\/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\",\"cost\":500.00,\"productId\":28,\"otPrice\":1599.00,\"suk\":\"36.5,200海滩浅黄/金属金/暗硫黄/亮深红/白色\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1399.00,\"unique\":\"\",\"attrValue\":\"{\\\"鞋码\\\":\\\"36.5\\\",\\\"颜色分类\\\":\\\"200海滩浅黄/金属金/暗硫黄/亮深红/白色\\\"}\",\"id\":1963,\"stock\":96}},\"uid\":57,\"productAttrUnique\":\"1963\",\"bargainId\":0,\"id\":695}','1963','2021-01-15 10:08:24','2021-01-15 10:08:24'),
	(304,327,28,'{\"productId\":28,\"seckillId\":0,\"vipTruePrice\":139.90,\"combinationId\":0,\"costPrice\":500.00,\"trueStock\":1795,\"isNew\":true,\"truePrice\":1399.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/15/c8bb13307db9431ea04c26ef2b5586e33zbgdu0mu1.png\",\"cost\":500.00,\"unitName\":\"件\",\"otPrice\":1599.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01JSyvWP1WggkHZ4JV4_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01sypoLu1WggkFgvjkz_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN012ZNCw21Wggk3e048T_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01E77iW21Wggk9rMrVh_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01RjoAqG1WggkHZ42sg_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01wE59b41WggkEW0A8U_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01KMrteX1WggkHBdK18_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01aGJf9x1Wggk3e0Ovi_!!3327042818.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516,517\",\"price\":1399.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"id\":28,\"storeInfo\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"tempId\":3,\"keyword\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"stock\":1795,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i3\\\\/3327042818\\\\/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\",\"cost\":500.00,\"productId\":28,\"otPrice\":1599.00,\"suk\":\"36.5,200海滩浅黄/金属金/暗硫黄/亮深红/白色\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1399.00,\"unique\":\"\",\"attrValue\":\"{\\\"鞋码\\\":\\\"36.5\\\",\\\"颜色分类\\\":\\\"200海滩浅黄/金属金/暗硫黄/亮深红/白色\\\"}\",\"id\":1963,\"stock\":95}},\"uid\":52,\"productAttrUnique\":\"1963\",\"bargainId\":0,\"id\":698}','1963','2021-01-15 10:13:48','2021-01-15 10:13:48'),
	(305,328,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":15.90,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1754,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":46,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1754,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":32,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":60}},\"uid\":37,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":688}','1319','2021-01-15 10:17:03','2021-01-15 10:17:03'),
	(306,329,15,'{\"productId\":15,\"vipTruePrice\":159.00,\"combinationId\":11,\"costPrice\":100.00,\"trueStock\":58,\"pinkId\":0,\"truePrice\":159.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":199.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"sort\":99,\"sales\":0,\"price\":159.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":11,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"stock\":1752,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":11,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"quota\":58,\"quotaShow\":58,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1886,\"stock\":58}},\"productAttrUnique\":\"1886\"}','1886','2021-01-15 10:17:40','2021-01-15 10:17:40'),
	(307,330,28,'{\"productId\":28,\"seckillId\":0,\"vipTruePrice\":139.90,\"combinationId\":0,\"costPrice\":500.00,\"trueStock\":1794,\"isNew\":true,\"truePrice\":1399.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/15/c8bb13307db9431ea04c26ef2b5586e33zbgdu0mu1.png\",\"cost\":500.00,\"unitName\":\"件\",\"otPrice\":1599.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":6,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01JSyvWP1WggkHZ4JV4_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01sypoLu1WggkFgvjkz_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN012ZNCw21Wggk3e048T_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01E77iW21Wggk9rMrVh_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01RjoAqG1WggkHZ42sg_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01wE59b41WggkEW0A8U_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01KMrteX1WggkHBdK18_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01aGJf9x1Wggk3e0Ovi_!!3327042818.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516,517\",\"price\":1399.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"id\":28,\"storeInfo\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"tempId\":3,\"keyword\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"stock\":1794,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i3\\\\/3327042818\\\\/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\",\"cost\":500.00,\"productId\":28,\"otPrice\":1599.00,\"suk\":\"36.5,200海滩浅黄/金属金/暗硫黄/亮深红/白色\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1399.00,\"unique\":\"\",\"attrValue\":\"{\\\"鞋码\\\":\\\"36.5\\\",\\\"颜色分类\\\":\\\"200海滩浅黄/金属金/暗硫黄/亮深红/白色\\\"}\",\"id\":1963,\"stock\":94}},\"uid\":52,\"productAttrUnique\":\"1963\",\"bargainId\":0,\"id\":699}','1963','2021-01-15 10:19:21','2021-01-15 10:19:21'),
	(308,331,28,'{\"productId\":28,\"seckillId\":0,\"vipTruePrice\":139.90,\"combinationId\":0,\"costPrice\":500.00,\"trueStock\":1794,\"isNew\":true,\"truePrice\":1399.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/15/c8bb13307db9431ea04c26ef2b5586e33zbgdu0mu1.png\",\"cost\":500.00,\"unitName\":\"件\",\"otPrice\":1599.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":6,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01JSyvWP1WggkHZ4JV4_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01sypoLu1WggkFgvjkz_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN012ZNCw21Wggk3e048T_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01E77iW21Wggk9rMrVh_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01RjoAqG1WggkHZ42sg_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01wE59b41WggkEW0A8U_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01KMrteX1WggkHBdK18_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01aGJf9x1Wggk3e0Ovi_!!3327042818.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516,517\",\"price\":1399.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"id\":28,\"storeInfo\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"tempId\":3,\"keyword\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"stock\":1794,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i3\\\\/3327042818\\\\/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\",\"cost\":500.00,\"productId\":28,\"otPrice\":1599.00,\"suk\":\"36.5,200海滩浅黄/金属金/暗硫黄/亮深红/白色\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1399.00,\"unique\":\"\",\"attrValue\":\"{\\\"鞋码\\\":\\\"36.5\\\",\\\"颜色分类\\\":\\\"200海滩浅黄/金属金/暗硫黄/亮深红/白色\\\"}\",\"id\":1963,\"stock\":94}},\"uid\":52,\"productAttrUnique\":\"1963\",\"bargainId\":0,\"id\":702}','1963','2021-01-15 10:20:47','2021-01-15 10:20:47'),
	(309,332,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0.01,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":2874,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":37,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":2874,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1631,\"stock\":969}},\"uid\":24,\"productAttrUnique\":\"1631\",\"bargainId\":0,\"id\":701}','1631','2021-01-15 10:21:06','2021-01-15 10:21:06'),
	(310,333,1,'{\"productId\":1,\"seckillId\":1,\"vipTruePrice\":0,\"costPrice\":9.00,\"trueStock\":8,\"truePrice\":99.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":0.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"giveIntegral\":1,\"sort\":1,\"sales\":1,\"postage\":0.00,\"price\":99.00,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"stock\":8,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,100,移动\",\"weight\":9.00,\"type\":1,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"quota\":1,\"quotaShow\":1,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"移动\\\"}\",\"id\":1991,\"stock\":8}},\"productAttrUnique\":\"1991\"}','1991','2021-01-15 10:22:48','2021-01-15 10:22:48'),
	(311,334,28,'{\"productId\":28,\"seckillId\":0,\"vipTruePrice\":139.90,\"combinationId\":0,\"costPrice\":500.00,\"trueStock\":1793,\"isNew\":true,\"truePrice\":1399.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/15/c8bb13307db9431ea04c26ef2b5586e33zbgdu0mu1.png\",\"cost\":500.00,\"unitName\":\"件\",\"otPrice\":1599.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":7,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN01JSyvWP1WggkHZ4JV4_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01sypoLu1WggkFgvjkz_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/3327042818/O1CN012ZNCw21Wggk3e048T_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01E77iW21Wggk9rMrVh_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i1/3327042818/O1CN01RjoAqG1WggkHZ42sg_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01wE59b41WggkEW0A8U_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/3327042818/O1CN01KMrteX1WggkHBdK18_!!3327042818.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/3327042818/O1CN01aGJf9x1Wggk3e0Ovi_!!3327042818.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516,517\",\"price\":1399.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"id\":28,\"storeInfo\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"tempId\":3,\"keyword\":\"Jordan官方JORDAN DELTA GC 男子运动鞋休闲低帮CZ8152\",\"stock\":1793,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i3\\\\/3327042818\\\\/O1CN011dTL061WgglZAR62j_!!0-item_pic.jpg\",\"cost\":500.00,\"productId\":28,\"otPrice\":1599.00,\"suk\":\"36.5,200海滩浅黄/金属金/暗硫黄/亮深红/白色\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1399.00,\"unique\":\"\",\"attrValue\":\"{\\\"鞋码\\\":\\\"36.5\\\",\\\"颜色分类\\\":\\\"200海滩浅黄/金属金/暗硫黄/亮深红/白色\\\"}\",\"id\":1963,\"stock\":93}},\"uid\":52,\"productAttrUnique\":\"1963\",\"bargainId\":0,\"id\":703}','1963','2021-01-15 10:23:57','2021-01-15 10:23:57'),
	(312,335,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":21.80,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":429,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"giveIntegral\":30,\"isSub\":false,\"sort\":100,\"sales\":70,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":3,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":429,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":1921,\"stock\":37}},\"uid\":52,\"productAttrUnique\":\"1921\",\"bargainId\":0,\"id\":704}','1921','2021-01-15 10:37:10','2021-01-15 10:37:10'),
	(313,336,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":159.00,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1752,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":48,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1752,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":34,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":58}},\"uid\":23,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":707}','1319','2021-01-15 11:04:30','2021-01-15 11:04:30'),
	(314,337,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":159.00,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1751,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":49,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1751,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":35,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":57}},\"uid\":23,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":708}','1319','2021-01-15 11:07:42','2021-01-15 11:07:42'),
	(315,338,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":159.00,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1750,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":50,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1750,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":36,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":56}},\"uid\":44,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":711}','1319','2021-01-15 11:09:14','2021-01-15 11:09:14'),
	(316,339,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":159.00,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1749,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"giveIntegral\":20,\"isSub\":false,\"sort\":99,\"sales\":51,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1749,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":37,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":55}},\"uid\":23,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":712}','1319','2021-01-15 11:10:01','2021-01-15 11:10:01'),
	(317,340,26,'{\"productId\":26,\"seckillId\":0,\"vipTruePrice\":50.00,\"combinationId\":0,\"costPrice\":20.00,\"trueStock\":50,\"isNew\":true,\"truePrice\":50.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\",\"cost\":20.00,\"unitName\":\"台\",\"otPrice\":100.00,\"isPostage\":false,\"giveIntegral\":0,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273\",\"price\":50.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":26,\"storeInfo\":\"电脑\",\"tempId\":2,\"keyword\":\"电脑\",\"stock\":50,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2021/01/14/1fc43e2f3fbe4cb7858993b2b7af2cc8gz29mhdmon.jpg\",\"cost\":20.00,\"productId\":26,\"otPrice\":100.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":50.00,\"unique\":\"\",\"id\":1919,\"stock\":50}},\"uid\":23,\"productAttrUnique\":\"1919\",\"bargainId\":0,\"id\":714}','1919','2021-01-15 11:10:45','2021-01-15 11:10:45'),
	(318,341,26,'{\"productId\":26,\"seckillId\":0,\"vipTruePrice\":5.00,\"combinationId\":0,\"costPrice\":20.00,\"trueStock\":49,\