/**
    本sql为 crmeb_java 1.3 老版本sql
 */


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Dump of table eb_article
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_article`;

CREATE TABLE `eb_article` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章管理ID',
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT '分类id',
  `title` varchar(255) NOT NULL COMMENT '文章标题',
  `author` varchar(255) DEFAULT '' COMMENT '文章作者',
  `image_input` varchar(255) NOT NULL COMMENT '文章图片',
  `synopsis` varchar(255) DEFAULT '' COMMENT '文章简介',
  `share_title` varchar(255) DEFAULT '' COMMENT '文章分享标题',
  `share_synopsis` varchar(255) DEFAULT '' COMMENT '文章分享简介',
  `visit` varchar(255) DEFAULT '' COMMENT '浏览次数',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `url` varchar(255) DEFAULT '' COMMENT '原文链接',
  `media_id` varchar(100) DEFAULT NULL COMMENT '微信素材id',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员id',
  `mer_id` int(10) unsigned DEFAULT '0' COMMENT '商户id',
  `product_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品关联id',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门(小程序)',
  `is_banner` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否轮播图(小程序)',
  `content` text NOT NULL COMMENT '文章内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章管理表';

LOCK TABLES `eb_article` WRITE;
/*!40000 ALTER TABLE `eb_article` DISABLE KEYS */;

INSERT INTO `eb_article` (`id`, `cid`, `title`, `author`, `image_input`, `synopsis`, `share_title`, `share_synopsis`, `visit`, `sort`, `url`, `media_id`, `status`, `hide`, `admin_id`, `mer_id`, `product_id`, `is_hot`, `is_banner`, `content`, `create_time`, `update_time`)
VALUES
	(1,'304','苹果发布会','测试','image/content/2020/12/25/7c3df4ac668042d9b9207e6a9690bc20tagf519g2f.jpg','苹果发布会','苹果发布会','苹果发布会','6',0,'https://www.tapd.cn/',NULL,0,0,0,0,0,1,1,'<h1 style=\"margin: 8px 0px 25px; padding: 0px; font-size: 40px; line-height: 1.5; color: rgb(51, 51, 51); font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal;\">雷军晒鸟照片网友直接沸腾了！小米11要在鸟巢召开发布会？</h1><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\">自从小米宣布小米11全球首发骁龙888后，小米这款新旗舰机就备受很多米粉的期待，因为小米11不仅带来性能强大的骁龙888，其还是小米最为经典的数字旗舰机，要知道今年小米10系列摆脱售价的束缚冲击了高端市场，各方面都获得了网友的认可，并且直接从年初热卖了年底，而第二款高端数字旗舰小米11自然更受期待。</p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\"><img class=\"content-picture\" src=\"https://inews.gtimg.com/newsapp_bt/0/12914276555/1000\" style=\"display: block; border: 0px none; vertical-align: middle; max-width: 100%; margin: 0.6em auto;\"/></p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\">网友期待小米11并非是随便说说，这点从雷军微博下的网友评论就能看得出来，不仅每天都有大量的网友催促官宣，而且雷军一篇正常的博文，都会被网友解读出跟小米11有关，已经到了疯狂的地部了。这不，雷军今天拍了一张树上有鸟巢的照片，让网友猜测有几个？结果网友不是猜11个，就解读暗示小米11将在鸟巢发布。</p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\"><img class=\"content-picture\" src=\"https://inews.gtimg.com/newsapp_bt/0/12914293278/1000\" style=\"display: block; border: 0px none; vertical-align: middle; max-width: 100%; margin: 0.6em auto;\"/></p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\">近年来小米新品发布会大都在小米科技园，而最大的一场是去年小米9发布的时候，而今年本来打算小米10系列和雷军十周年演讲办一场大型活动，但最后被突发的疫情给打乱了，那么现在国内疫情已经控制，小米11系列会不会是大型发布会呢？而就目前的情况来看，几乎没可能，因为疫情没有彻底结束。</p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\"><img class=\"content-picture\" src=\"https://inews.gtimg.com/newsapp_bt/0/12914287269/1000\" style=\"display: block; border: 0px none; vertical-align: middle; max-width: 100%; margin: 0.6em auto;\"/></p><p class=\"one-p\" style=\"margin-top: 0px; margin-bottom: 2em; padding: 0px; line-height: 2.2; overflow-wrap: break-word; font-family: &quot;Microsoft Yahei&quot;, Avenir, &quot;Segoe UI&quot;, &quot;Hiragino Sans GB&quot;, STHeiti, &quot;Microsoft Sans Serif&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: 18px; white-space: normal;\">最后：虽然网友各种催促小米11的发布，但到底何时官宣还不清楚，可以确定的是小米11不远了，因为此前的消息显示，小米11将在12月25日后才能发布，也就是说下周可能会正式官宣。</p><p><br style=\"white-space: normal;\"/></p><p><br/></p>','2020-12-15 17:22:11','2020-12-25 16:21:54'),
	(2,'508','饮品发布会','测试1','image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png','苹果发布会111','饮品发布会','苹果发布会111','',0,'https://app.beta.java.crmeb.net/static/html/pc.html',NULL,0,0,0,0,0,1,1,'<p><span style=\"color: rgb(96, 98, 102); font-family: arial, sans-serif; font-size: 12px; background-color: rgb(232, 244, 255);\">苹果发布会</span></p>','2020-12-15 17:49:56','2020-12-16 09:21:50'),
	(3,'508','测试1','111','image/user/2020/12/15/72b701aad808457695a49b472f7548ec54rrx6rl74.png','111','测试1','111','',0,'',NULL,0,0,0,0,0,0,0,'<p>111</p>','2020-12-17 09:31:50','2020-12-17 09:31:50'),
	(4,'508','1','2','image/operation/2020/12/28/439cfd536aed4c18b501026ed97b52bbknv4zd5c4v.jpg','12','1','12','',0,'',NULL,0,0,0,0,0,0,0,'<p>12</p>','2020-12-28 18:24:31','2020-12-28 18:24:31');

/*!40000 ALTER TABLE `eb_article` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_category
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_category`;

CREATE TABLE `eb_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `path` varchar(255) NOT NULL DEFAULT '/0/' COMMENT '路径',
  `name` varchar(50) NOT NULL COMMENT '分类名称',
  `type` smallint(2) DEFAULT '1' COMMENT '类型，1 产品分类，2 附件分类，3 文章分类， 4 设置分类， 5 菜单分类',
  `url` varchar(255) DEFAULT '' COMMENT '地址',
  `extra` text COMMENT '扩展字段 Jsos格式',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态, 1正常，0失效',
  `sort` int(5) NOT NULL DEFAULT '99999' COMMENT '排序',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `status+pid` (`pid`,`status`) USING BTREE,
  KEY `id+status+url` (`path`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='分类表';

LOCK TABLES `eb_category` WRITE;
/*!40000 ALTER TABLE `eb_category` DISABLE KEYS */;

INSERT INTO `eb_category` (`id`, `pid`, `path`, `name`, `type`, `url`, `extra`, `status`, `sort`, `create_time`, `update_time`)
VALUES
	(42,0,'/0/','商品',5,'/store','s-goods',1,1,'2020-04-28 17:03:34','2020-08-12 12:29:13'),
	(43,42,'/0/42/','商品管理',5,'/store/index',NULL,1,1,'2020-04-28 17:04:20','2020-08-12 12:29:13'),
	(44,42,'/0/42/','商品分类',5,'/store/sort',NULL,1,1,'2020-04-28 17:04:40','2020-08-12 12:29:13'),
	(45,0,'/0/','订单',5,'/order','s-order',1,1,'2020-04-28 17:04:56','2020-08-12 12:29:13'),
	(46,45,'/0/45/','订单管理',5,'/order/index','s-order',1,1,'2020-04-28 17:05:17','2020-08-12 12:29:13'),
	(47,0,'/0/','用户',5,'/user','user-solid',1,1,'2020-04-28 17:05:53','2020-08-12 12:29:13'),
	(48,47,'/0/47/','用户管理',5,'/user/index',NULL,1,1,'2020-04-28 17:07:13','2020-08-12 12:29:13'),
	(49,47,'/0/47/','用户标签',5,'/user/label',NULL,1,1,'2020-04-28 17:42:21','2020-08-12 12:29:13'),
	(51,0,'/0/','设置',5,'/operation','s-tools',1,-9,'2020-05-06 09:40:14','2020-08-12 12:29:13'),
	(52,51,'/0/51/','管理权限',5,'/operation/roleManager',NULL,1,1,'2020-05-06 09:40:35','2020-08-12 12:29:13'),
	(53,52,'/0/51/52/','身份管理',5,'/operation//roleManager/identityManager',NULL,1,1,'2020-05-06 09:40:51','2020-08-12 12:29:13'),
	(54,52,'/0/51/52/','管理员列表',5,'/operation//roleManager/adminList',NULL,1,1,'2020-05-06 09:41:11','2020-08-12 12:29:13'),
	(55,52,'/0/51/52/','权限规则',5,'/operation//roleManager/promiseRules',NULL,1,1,'2020-05-06 09:41:46','2020-08-12 12:29:13'),
	(56,0,'/0/','内容',5,'/content','s-management',1,1,'2020-05-07 12:00:33','2020-08-12 12:29:13'),
	(57,56,'/0/56/','文章管理',5,'/content/articleManager',NULL,1,1,'2020-05-07 12:02:39','2020-08-12 12:29:13'),
	(58,56,'/0/56/','文章分类',5,'/content/classifManager',NULL,1,1,'2020-05-07 12:02:46','2020-08-12 12:29:13'),
	(66,0,'/0/','维护',5,'/maintain','s-open',1,-10,'2020-05-09 16:02:05','2020-08-12 12:29:13'),
	(67,66,'/0/66/','开发配置',5,'/maintain//devconfiguration',NULL,1,0,'2020-05-09 16:06:46','2020-08-12 12:29:13'),
	(68,67,'/0/66/67/','配置分类',5,'/maintain/devconfiguration/configCategory',NULL,1,0,'2020-05-09 16:07:09','2020-08-12 12:29:13'),
	(69,67,'/0/66/67/','组合数据',5,'/maintain/devconfiguration/combineddata',NULL,1,0,'2020-05-09 16:08:00','2020-08-12 12:29:13'),
	(80,51,'/0/51/','系统设置',5,'/operation/setting',NULL,1,9,'2020-05-20 09:44:47','2020-12-10 11:30:07'),
	(81,0,'/0/','基础配置',6,'基础配置','64',1,1,'2020-05-20 10:02:57','2020-08-12 12:29:13'),
	(93,81,'/0/81/','站点配置',6,'站点配置','64',1,1,'2020-05-21 11:04:20','2020-08-12 12:29:13'),
	(94,100,'/0/100/','客服配置',6,'云智服','76',1,1,'2020-05-21 11:04:37','2020-09-09 17:09:47'),
	(95,0,'/0/','商城配置',6,'商城配置','77',1,2,'2020-05-21 11:10:20','2020-08-12 12:29:13'),
	(96,95,'/0/95/','商城基础配置',6,'商城基础配置','77',1,1,'2020-05-21 11:10:40','2020-08-12 12:29:13'),
	(98,95,'/0/95/','小票打印配置',6,'小票打印配置','75',0,1,'2020-05-21 11:11:11','2020-08-13 14:07:02'),
	(99,95,'/0/95/','充值配置',6,'充值配置','78',1,1,'2020-05-21 11:11:28','2020-08-12 12:29:13'),
	(100,0,'/0/','应用配置',6,'应用配置',NULL,1,1,'2020-05-21 12:31:49','2020-08-12 12:29:13'),
	(101,100,'/0/100/','公众号配置',6,'公众号配置','65',1,1,'2020-05-21 12:32:07','2020-08-12 12:29:13'),
	(102,100,'/0/100/','小程序配置',6,'小程序配置','66',1,1,'2020-05-21 12:32:18','2020-08-12 12:29:13'),
	(103,0,'/0/','支付配置',6,'支付配置',NULL,1,1,'2020-05-21 12:33:36','2020-08-12 12:29:13'),
	(104,103,'/0/103/','公众号支付配置',6,'公众号支付配置','67',1,1,'2020-05-21 12:33:54','2020-08-12 12:29:13'),
	(105,103,'/0/103/','小程序支付配置',6,'小程序支付配置','68',1,1,'2020-05-21 12:34:36','2020-08-12 12:29:13'),
	(106,103,'/0/103/','线下支付',6,'线下支付','79',1,1,'2020-05-21 12:34:48','2020-08-12 12:29:13'),
	(107,103,'/0/103/','余额支付',6,'余额支付','80',1,1,'2020-05-21 12:35:01','2020-08-12 12:29:13'),
	(108,0,'/0/','文件上传配置',6,'文件上传配置',NULL,1,1,'2020-05-21 12:35:16','2020-08-12 12:29:13'),
	(109,108,'/0/108/','基础配置',6,'基础配置','108',1,1,'2020-05-21 12:35:28','2020-09-14 10:33:54'),
	(110,108,'/0/108/','阿里云配置',6,'阿里云配置','81',1,1,'2020-05-21 12:36:01','2020-08-12 12:29:13'),
	(111,108,'/0/108/','七牛云配置',6,'七牛云配置','82',1,1,'2020-05-21 12:36:12','2020-08-12 12:29:13'),
	(112,108,'/0/108/','腾讯云配置',6,'腾讯云配置','83',1,1,'2020-05-21 12:36:22','2020-08-12 12:29:13'),
	(113,0,'/0/','应用',5,'/appSetting','s-promotion',1,1,'2020-05-21 16:12:53','2020-08-12 12:29:13'),
	(114,113,'/0/113/','公众号',5,'/appSetting/publicAccount',NULL,1,1,'2020-05-21 16:13:18','2020-08-12 12:29:13'),
	(115,114,'/0/113/114/','微信菜单',5,'/appSetting//publicAccount/wxMenus',NULL,1,1,'2020-05-21 16:13:36','2020-08-12 12:29:13'),
	(118,0,'/0/','营销',5,'/marketing','s-marketing',1,1,'2020-05-25 14:39:52','2020-08-12 12:29:13'),
	(119,118,'/0/118/','优惠券',5,'/marketing/coupon',NULL,1,1,'2020-05-25 14:40:13','2020-08-12 12:29:13'),
	(123,118,'/0/118/','积分',5,'/marketing/integral',NULL,1,1,'2020-05-25 14:41:33','2020-08-12 12:29:13'),
	(127,42,'/0/42/','商品规格',5,'/store/attr',NULL,1,1,'2020-05-25 18:12:11','2020-08-12 12:29:13'),
	(128,42,'/0/42/','商品评论',5,'/store/comment',NULL,1,1,'2020-05-27 10:16:30','2020-08-12 12:29:13'),
	(129,51,'/0/51/','提货点',5,'/operation/systemStore',NULL,1,1,'2020-05-27 11:42:51','2020-08-27 10:57:46'),
	(130,129,'/0/51/129/','提货点',5,'/operation/systemStore/point',NULL,1,1,'2020-05-27 11:46:10','2020-08-27 10:56:49'),
	(131,129,'/0/51/129/','核销员',5,'/operation/systemStore/clerkList',NULL,1,1,'2020-05-27 11:51:16','2020-08-27 10:56:39'),
	(132,129,'/0/51/129/','核销订单',5,'/operation/systemStore/order',NULL,1,1,'2020-05-27 11:54:00','2020-08-27 10:56:43'),
	(134,95,'/0/95/','首页配置',6,'index_config','69',1,5,'2020-06-02 17:35:58','2020-08-19 15:04:47'),
	(135,0,'/0/','小树树2',2,'url',NULL,1,1,'2020-06-03 15:50:15','2020-08-12 12:29:13'),
	(136,135,'/0/135/','小树娃',2,'url',NULL,1,1,'2020-06-03 16:59:50','2020-08-12 12:29:13'),
	(137,135,'/0/135/','小紅',2,'url',NULL,1,1,'2020-06-03 17:15:50','2020-08-12 12:29:13'),
	(138,136,'/0/135/136/','小鼠',2,'url',NULL,1,1,'2020-06-03 17:25:39','2020-08-12 12:29:13'),
	(139,113,'/0/113/','小程序',5,'/appSetting/publicRoutine',NULL,1,1,'2020-06-05 09:56:17','2020-08-12 12:29:13'),
	(140,139,'/0/113/139/','我的模板',5,'/appSetting/publicRoutine/routineTemplate',NULL,1,1,'2020-06-05 09:56:58','2020-08-27 14:07:47'),
	(141,114,'/0/113/114/','自动回复',5,'/appSetting/publicAccount/wxReply',NULL,1,1,'2020-06-15 16:15:32','2020-08-12 12:29:13'),
	(146,0,'/0/','分销',5,'/distribution','s-check',1,1,'2020-07-18 16:31:09','2020-12-07 09:35:02'),
	(147,146,'/0/146/','分销员管理',5,'/distribution/index',NULL,1,1,'2020-07-18 16:31:49','2020-12-18 10:22:25'),
	(148,146,'/0/146/','分销配置',5,'/distribution/distributionconfig',NULL,1,1,'2020-07-18 16:32:06','2020-12-18 10:22:19'),
	(149,51,'/0/51/','短信',5,'/operation/systemSms',NULL,1,1,'2020-07-21 16:51:29','2020-08-27 10:57:37'),
	(150,149,'/0/51/149/','短信账户',5,'/operation/systemSms/config',NULL,1,1,'2020-07-21 16:52:48','2020-08-12 12:29:13'),
	(151,149,'/0/51/149/','短信模板',5,'/operation/systemSms/template',NULL,1,1,'2020-07-21 19:45:26','2020-08-12 12:29:13'),
	(152,149,'/0/51/149/','短信购买',5,'/operation/systemSms/pay',NULL,1,1,'2020-07-21 19:45:46','2020-08-12 12:29:13'),
	(158,119,'/0/118/119/','优惠券',5,'/marketing/coupon/list',NULL,1,1,'2020-07-24 16:13:10','2020-08-29 10:15:34'),
	(159,119,'/0/118/119/','会员领取记录',5,'/marketing/coupon/record',NULL,1,1,'2020-07-24 16:13:37','2020-08-12 12:29:13'),
	(160,123,'/0/118/123/','积分配置',5,'/marketing/integral/integralconfig',NULL,1,1,'2020-07-24 16:14:48','2020-08-12 12:29:13'),
	(161,123,'/0/118/123/','积分日志',5,'/marketing/integral/integrallog',NULL,1,1,'2020-07-24 16:15:11','2020-08-12 12:29:13'),
	(162,47,'/0/47/','用户等级',5,'/user/grade',NULL,1,1,'2020-07-24 16:21:48','2020-08-12 12:29:13'),
	(164,47,'/0/47/','用户分组',5,'/user/group',NULL,1,1,'2020-07-24 16:22:46','2020-08-12 12:29:13'),
	(165,51,'/0/51/','物流',5,'/operation/logistics',NULL,1,1,'2020-07-24 16:37:56','2020-08-27 10:57:55'),
	(166,165,'/0/51/165/','城市数据',5,'/operation/logistics/cityList',NULL,1,1,'2020-07-24 16:38:22','2020-08-12 12:29:13'),
	(167,165,'/0/51/165/','物流公司',5,'/operation/logistics/companyList',NULL,1,1,'2020-07-24 16:38:46','2020-08-12 12:29:13'),
	(168,165,'/0/51/165/','运费模板',5,'/operation/logistics/shippingTemplates',NULL,1,1,'2020-07-24 16:39:03','2020-08-12 12:29:13'),
	(169,165,'/0/51/165/','物流配置',5,'/operation/logistics/logisticsConfig',NULL,1,1,'2020-07-24 16:39:27','2020-08-12 12:29:13'),
	(171,141,'/0/113/114/141/','微信关注回复',5,'/appSetting/publicAccount/wxReply/follow',NULL,1,1,'2020-07-24 16:42:52','2020-08-12 12:29:13'),
	(172,141,'/0/113/114/141/','关键字回复',5,'/appSetting/publicAccount/wxReply/keyword',NULL,1,1,'2020-07-24 16:43:09','2020-08-12 12:29:13'),
	(173,141,'/0/113/114/141/','无效关键词回复',5,'/appSetting/publicAccount/wxReply/replyIndex',NULL,1,1,'2020-07-24 16:43:23','2020-08-12 12:29:13'),
	(174,114,'/0/113/114/','微信模板',5,'/appSetting//publicAccount/template',NULL,1,1,'2020-07-24 16:43:52','2020-08-29 10:05:10'),
	(175,43,'/0/42/43/','商品添加',5,'api/admin/store/product/save',NULL,0,1,'2020-07-24 16:46:04','2020-08-31 10:07:27'),
	(176,43,'/0/42/43/','商品修改',5,'api/admin/store/product/update',NULL,0,1,'2020-07-24 16:46:19','2020-08-31 10:07:24'),
	(177,43,'/0/42/43/','商品详情',5,'api/admin/store/product/info',NULL,0,1,'2020-07-24 16:46:33','2020-08-31 10:07:25'),
	(181,182,'/0/182/','测试分类01',2,'url',NULL,1,1,'2020-08-10 10:18:52','2020-08-12 12:29:13'),
	(182,0,'/0/','测试分类02',2,'url',NULL,1,1,'2020-08-10 10:20:14','2020-08-12 12:29:13'),
	(183,0,'/0/','测试分类03',2,'url',NULL,1,1,'2020-08-10 10:31:17','2020-08-12 12:29:13'),
	(184,181,'/0/181/','测试二级分类01',2,'url',NULL,1,1,'2020-08-10 10:34:50','2020-08-12 12:29:13'),
	(185,0,'/0/','ADIDAS 春季新品运动鞋图片1',2,'url',NULL,1,1,'2020-08-10 10:40:52','2020-08-12 12:29:13'),
	(188,184,'/0/181/184/','测试四级分类01',2,'url',NULL,1,1,'2020-08-10 11:08:32','2020-08-12 12:29:13'),
	(240,10000,'/0/','2323',2,'url',NULL,1,1,'2020-08-11 15:20:28','2020-08-12 12:29:13'),
	(245,0,'/0/272/','热门推荐',1,'','image/content/2020/08/10/814d9f0beba040d2904079d7b99fc586el2l3odbj3.png',1,0,'2020-08-12 11:42:27','2020-10-21 11:34:05'),
	(246,245,'/0/272/245/','新品上市',1,'www','image/store/2020/08/13/95e065018ba24172b2e2dd2e2833360coobdzkt671.png',1,0,'2020-08-12 11:42:58','2020-10-21 17:25:21'),
	(248,245,'/0/272/245/','热卖商品',1,'www','image/store/2020/08/13/29b418bf2543477d8417a85e779e6d79clby7stw86.png',1,0,'2020-08-12 11:50:40','2020-10-21 17:25:25'),
	(250,67,'/0/66/67/','表单配置',5,'/maintain/devconfiguration/formConfig',NULL,1,0,'2020-08-12 12:09:56','2020-08-12 12:29:13'),
	(258,245,'/0/272/245/','折扣专区',1,'www','image/store/2020/08/13/1826c7f20771444e888501d91332f129wik43qfgmw.png',1,0,'2020-08-12 13:59:31','2020-10-21 17:25:28'),
	(267,0,'/0/','控制台',5,'/dashboard','menu',1,10,'2020-08-13 10:31:07','2020-12-03 09:32:05'),
	(268,0,'/0/','图标素材',2,'url',NULL,0,1,'2020-08-13 10:36:08','2020-08-13 10:36:08'),
	(270,0,'/0/','banner',2,'url',NULL,0,1,'2020-08-13 11:35:39','2020-08-13 11:35:39'),
	(271,0,'/0/','分类素材',2,'url',NULL,0,1,'2020-08-13 11:46:28','2020-08-13 11:46:28'),
	(272,0,'/0/','家用电器',1,'','image/store/2020/08/13/88dfb08327f7470d8285613aa1bd9ab3xk2qzolbad.png',1,0,'2020-08-13 12:03:40','2021-01-06 15:58:49'),
	(273,272,'/0/272/','电视',1,'','image/store/2020/08/13/15e36da884e44f91939a92468d0c848fxftnm6thvc.png',1,0,'2020-08-13 12:05:23','2020-08-13 12:05:23'),
	(274,272,'/0/272/','冰箱',1,'www','image/store/2020/08/13/0c1fb92238ce4f67b9c2cb03c9c932c8a28451t0g7.png',1,0,'2020-08-13 12:06:47','2020-08-13 12:06:47'),
	(275,272,'/0/272/','洗衣机',1,'www','image/store/2020/08/13/6f722314cefa418fada5eab9e09bf86aqutumxihsx.png',1,0,'2020-08-13 12:07:57','2020-08-13 12:07:57'),
	(276,272,'/0/272/','生活电器',1,'','image/store/2020/08/13/df0f8dfb34c1424abde8737039c5f58b1acdgq3h7w.png',1,0,'2020-08-13 12:11:36','2020-08-13 12:11:36'),
	(277,272,'/0/272/','厨卫电器',1,'','image/store/2020/08/13/cb007f931afb4386bfff7f80b8971203c5qc2k1j1n.png',1,0,'2020-08-13 12:12:38','2020-08-13 12:12:38'),
	(279,272,'/0/272/','清凉一夏',1,'','image/store/2020/08/13/306ee4383bbf460494e8b3368782a076ugnezzb362.png',1,0,'2020-08-13 12:15:11','2020-08-13 12:26:18'),
	(280,0,'/0/','家装家具',1,'','image/store/2020/08/14/547bfd86471b412eb4f163e07cfc2027uzzul0xoyl.jpg',1,0,'2020-08-13 12:17:25','2020-08-29 10:48:17'),
	(281,0,'/0/','户外出行',1,'','image/content/2020/08/14/d992711f08ae45369ec1bd56a30c462880pnyxs5xg.jpg',1,0,'2020-08-13 12:17:54','2020-08-29 10:48:28'),
	(282,0,'/0/','美妆个护',1,'','image/setting/2020/08/14/26b3e7b4591e47f8b49e805082925dd8l36r29lmqo.jpg',1,0,'2020-08-13 12:18:04','2020-08-29 10:48:38'),
	(283,0,'/0/','3C数码',1,'','image/content/2020/08/13/312234fff7f24c37bcedd117f1572b3e5z7eydhpyr.png',1,0,'2020-08-13 12:18:14','2020-08-29 10:48:52'),
	(284,0,'/0/283/','日用文创',1,'','image/content/2020/08/14/27cf4c1051ea4bed82d74aed62e5df1121o78nxu6p.jpg',1,0,'2020-08-13 12:18:30','2020-10-21 10:00:39'),
	(285,280,'/0/280/','智能门锁',1,'','image/store/2020/08/13/f4f47201c43e42ac82b83ed711199774ggihs7g6yb.png',1,0,'2020-08-13 13:31:48','2020-08-13 13:31:48'),
	(286,280,'/0/280/','居家照明',1,'','image/store/2020/08/13/f0771d0db94847bbb2cb60ebe5201aa0tzzjzor6d5.png',1,0,'2020-08-13 13:33:06','2020-08-13 13:33:06'),
	(287,280,'/0/280/','家装建材',1,'','image/store/2020/08/13/4209c46356f4478ea3ed2b8adfc8dd4d4udgw8nsig.png',1,0,'2020-08-13 13:34:22','2020-08-13 13:34:22'),
	(288,281,'/0/281/','健身运动',1,'','image/store/2020/08/13/183bae2de334412f8593325805bb45e07xvwxc6nbn.png',1,0,'2020-08-13 13:35:37','2020-08-13 13:35:37'),
	(289,281,'/0/281/','户外装备',1,'','image/store/2020/08/13/767c7e25f56543f398e11896d356b46a1t4l6k8qk0.png',1,0,'2020-08-13 13:36:34','2020-08-13 13:36:34'),
	(290,281,'/0/281/','骑行配件',1,'','image/store/2020/08/13/8525ef6066a04537aa5ee92234dc2edcf1iyqm9gq9.png',1,0,'2020-08-13 13:37:23','2020-08-13 13:37:23'),
	(291,282,'/0/282/','美妆工具',1,'','image/store/2020/08/13/57f108bff43744c88323c666d77cac72g4p0a23tpo.png',1,0,'2020-08-13 13:38:32','2020-08-13 13:38:32'),
	(292,282,'/0/282/','口腔清洁',1,'','image/store/2020/08/13/72f39322b33249e0b3441908e3b657b2rzf7g4x37c.png',1,0,'2020-08-13 13:39:33','2020-08-13 13:39:33'),
	(293,282,'/0/282/','彩妆香氛',1,'','image/store/2020/08/13/bf981c370d9d44f998803310fedb8af3yr9suwbwp1.png',1,0,'2020-08-13 13:40:34','2020-08-13 13:40:34'),
	(294,282,'/0/282/','面部护肤',1,'','image/store/2020/08/13/59a066f8bb5145cbada4b7a08965cf15b26idurig9.png',1,0,'2020-08-13 13:42:19','2020-08-13 13:42:19'),
	(295,282,'/0/282/','身体护理',1,'','image/store/2020/08/13/769f2ba251114a75bc3da94166770482zv3tb4ogjy.png',1,0,'2020-08-13 13:43:21','2020-08-13 13:43:21'),
	(296,282,'/0/282/','其他工具',1,'','image/store/2020/08/13/5c9d8b4b4a2e4fc782558787fc941e24o6u5iv52dl.png',1,0,'2020-08-13 13:44:15','2020-08-13 13:44:15'),
	(297,283,'/0/283/','手机',1,'','image/store/2020/08/13/3a985dc276b941c093a12332500d9784ce3bed9l0c.png',1,0,'2020-08-13 13:45:52','2020-08-13 13:45:52'),
	(298,283,'/0/283/','平板电脑',1,'','image/store/2020/08/13/5771a123b9a24666b5cdcf531f7744d6grduvuarjw.png',1,0,'2020-08-13 13:46:22','2020-08-13 13:46:22'),
	(299,283,'/0/283/','数码配件',1,'','image/store/2020/08/13/760282c126c74ff7a335c3efd6bb2e27vduh9zraqs.png',1,0,'2020-08-13 13:47:16','2020-08-13 13:47:16'),
	(300,284,'/0/284/','日用杂货',1,'','image/store/2020/08/13/ba82799518704655ab2fdc254336de08wtb2ofda96.png',1,0,'2020-08-13 13:48:30','2020-08-13 13:48:30'),
	(301,284,'/0/284/','纸品湿巾',1,'','image/store/2020/08/13/eb7a947539d94cd495ea6493e37a3e35lkqmcnnl9q.png',1,0,'2020-08-13 13:49:30','2020-08-13 13:49:30'),
	(302,284,'/0/284/','办公文具',1,'','image/store/2020/08/13/a84efcfa299c4269af95d671e122d4770vrq87ttfz.png',1,0,'2020-08-13 13:50:39','2020-12-24 14:03:46'),
	(303,0,'/0/','产品',2,'url',NULL,0,1,'2020-08-13 13:53:11','2020-08-13 13:53:11'),
	(304,0,'/0/','iphone 11 新品发布会',3,'','image/content/2020/08/13/b1b14c22e72940ba96e0775fd0b4432cka3o1j1tlg.png',1,1,'2020-08-13 15:18:13','2020-12-17 16:53:32'),
	(306,283,'/0/283/','小米笔记本',1,'','image/store/2020/08/14/547bfd86471b412eb4f163e07cfc2027uzzul0xoyl.jpg',1,0,'2020-08-14 14:19:04','2020-08-14 14:19:04'),
	(308,188,'/0/181/184/188/','asd ',2,'url',NULL,0,1,'2020-08-15 09:30:29','2020-08-15 09:30:29'),
	(311,137,'/0/135/137/','ceshi ',2,'url',NULL,0,1,'2020-08-17 17:10:41','2020-08-17 17:10:41'),
	(316,139,'/0/113/139/','公共模板',5,'/appSetting/publicRoutine/publicRoutineTemplate',NULL,1,1,'2020-08-27 14:15:41','2020-08-27 14:16:11'),
	(317,452,'/0/452/','订单核销',5,'/javaMobile/orderCancellation',NULL,1,0,'2020-08-27 14:51:47','2020-09-12 15:19:51'),
	(318,43,'/0/42/43/','商品删除',5,'api/admin/store/product/delete',NULL,0,0,'2020-08-28 16:12:53','2020-08-31 10:07:24'),
	(319,43,'/0/42/43/','商品上架',5,'api/admin/store/product/putOnShell',NULL,0,0,'2020-08-28 16:14:14','2020-08-31 10:07:22'),
	(320,43,'/0/42/43/','商品下架',5,'api/admin/store/product/offShell',NULL,0,0,'2020-08-28 16:14:33','2020-08-31 10:07:23'),
	(321,43,'/0/42/43/','库存变动',5,'api/admin/store/product/stock',NULL,0,0,'2020-08-28 16:15:07','2020-08-31 10:07:21'),
	(322,43,'/0/42/43/','虚拟销量',5,'api/admin/store/product/ficti',NULL,0,0,'2020-08-28 16:15:59','2020-08-31 10:07:21'),
	(323,127,'/0/42/127/','规格添加',5,'api/admin/store/product/rule/save',NULL,0,0,'2020-08-28 16:25:25','2020-08-28 16:26:44'),
	(324,127,'/0/42/127/','规格修改',5,'api/admin/store/product/update',NULL,0,0,'2020-08-28 16:25:40','2020-08-28 16:25:48'),
	(325,127,'/0/42/127/','规格删除',5,'api/admin/store/product/delete',NULL,0,0,'2020-08-28 16:26:01','2020-09-15 09:49:16'),
	(326,127,'/0/42/127/','规格详情',5,'api/admin/store/product/rule/info',NULL,0,0,'2020-08-28 16:26:37','2020-08-28 16:26:37'),
	(327,127,'/0/42/127/','规格列表',5,'api/admin/store/product/rule/list',NULL,0,0,'2020-08-28 16:26:59','2020-08-28 16:26:59'),
	(328,128,'/0/42/128/','商品评论添加',5,'api/admin/store/product/reply/save',NULL,0,0,'2020-08-28 16:27:53','2020-08-28 16:27:53'),
	(329,128,'/0/42/128/','商品评论修改',5,'api/admin/store/product/reply/update',NULL,0,0,'2020-08-28 16:28:18','2020-08-28 16:28:18'),
	(330,128,'/0/42/128/','商品评论列表',5,'api/admin/store/product/reply/list',NULL,0,0,'2020-08-28 16:29:45','2020-08-28 16:29:45'),
	(331,128,'/0/42/128/','商品评论删除',5,'api/admin/store/product/reply/delete',NULL,0,0,'2020-08-28 16:29:57','2020-08-28 16:30:02'),
	(332,128,'/0/42/128/','商品评论详情',5,'api/admin/store/product/reply/info',NULL,0,0,'2020-08-28 16:30:17','2020-08-28 16:30:17'),
	(333,128,'/0/42/128/','商品评论回复',5,'api/admin/store/product/reply/comment',NULL,0,0,'2020-08-28 16:30:38','2020-08-28 16:30:38'),
	(334,46,'/0/45/46/','订单列表',5,'api/admin/store/order/list',NULL,0,0,'2020-08-29 09:33:16','2020-08-29 09:33:16'),
	(335,46,'/0/45/46/','订单删除',5,'api/admin/store/order/delete',NULL,0,0,'2020-08-29 09:33:49','2020-08-29 09:33:49'),
	(336,46,'/0/45/46/','订单详情',5,'api/admin/store/order/info',NULL,0,0,'2020-08-29 09:34:04','2020-08-29 09:34:04'),
	(337,46,'/0/45/46/','订单标记',5,'api/admin/store/order/mark',NULL,0,0,'2020-08-29 09:34:25','2020-08-29 09:34:25'),
	(338,46,'/0/45/46/','订单退款',5,'api/admin/store/order/refund',NULL,0,0,'2020-08-29 09:34:38','2020-08-29 09:34:38'),
	(339,46,'/0/45/46/','订单拒绝退款',5,'api/admin/store/order/refund/refuse',NULL,0,0,'2020-08-29 09:35:08','2020-08-29 09:35:08'),
	(340,46,'/0/45/46/','订单发货',5,'api/admin/store/order/send',NULL,0,0,'2020-08-29 09:35:33','2020-08-29 09:35:33'),
	(341,46,'/0/45/46/','订单更新',5,'api/admin/store/order/update',NULL,0,0,'2020-08-29 09:35:44','2020-08-29 09:35:44'),
	(342,46,'/0/45/46/','订单物流查询',5,'api/admin/store/order/getLogisticsInfo',NULL,0,0,'2020-08-29 09:36:12','2020-08-29 09:36:12'),
	(343,46,'/0/45/46/','订单日志查看',5,'api/admin/store/order/status/list',NULL,0,0,'2020-08-29 09:37:43','2020-08-29 09:37:43'),
	(344,48,'/0/47/48/','用户列表',5,'api/admin/user/list',NULL,0,0,'2020-08-29 09:38:35','2020-08-29 09:38:35'),
	(345,48,'/0/47/48/','用户修改',5,'api/admin/user/update',NULL,0,0,'2020-08-29 09:39:12','2020-08-29 09:39:12'),
	(346,48,'/0/47/48/','用户详情',5,'api/admin/user/infobycondition',NULL,0,0,'2020-08-29 09:39:22','2020-08-29 09:41:16'),
	(347,48,'/0/47/48/','用户分组',5,'api/admin/user/group',NULL,0,0,'2020-08-29 09:39:31','2020-08-29 09:39:31'),
	(348,48,'/0/47/48/','用户删除',5,'api/admin/user/delete',NULL,0,0,'2020-08-29 09:39:49','2020-08-29 09:39:49'),
	(349,48,'/0/47/48/','用户打标签',5,'api/admin/user/tag',NULL,0,0,'2020-08-29 09:40:02','2020-08-29 09:40:02'),
	(350,48,'/0/47/48/','修改积分余额',5,'api/admin/user/operate/founds',NULL,0,0,'2020-08-29 09:41:50','2020-08-29 09:41:50'),
	(351,162,'/0/47/162/','用户等级添加',5,'api/admin/system/user/level/save',NULL,0,0,'2020-08-29 09:43:32','2020-08-29 09:44:47'),
	(352,162,'/0/47/162/','用户等级修改',5,'api/admin/system/user/level/update',NULL,0,0,'2020-08-29 09:46:00','2020-08-29 09:46:00'),
	(353,162,'/0/47/162/','用户等级删除',5,'api/admin/system/user/level/delete',NULL,0,0,'2020-08-29 09:46:13','2020-08-29 09:46:13'),
	(354,162,'/0/47/162/','用户等级列表',5,'api/admin/system/user/level/list',NULL,0,0,'2020-08-29 09:46:50','2020-08-29 09:46:50'),
	(355,162,'/0/47/162/','用户等级详情',5,'api/admin/system/user/level/info',NULL,0,0,'2020-08-29 09:47:05','2020-08-29 09:47:05'),
	(356,162,'/0/47/162/','用户等级是否显示',5,'api/admin/system/user/level/use',NULL,0,0,'2020-08-29 09:47:41','2020-08-29 09:47:41'),
	(357,49,'/0/47/49/','用户标签添加',5,'api/admin/user/tag/save',NULL,0,0,'2020-08-29 09:48:13','2020-08-29 09:49:20'),
	(358,49,'/0/47/49/','用户标签修改',5,'api/admin/user/tag/update',NULL,0,0,'2020-08-29 09:48:26','2020-08-29 09:49:27'),
	(359,49,'/0/47/49/','用户标签删除',5,'api/admin/user/tag/list',NULL,0,0,'2020-08-29 09:49:12','2020-08-29 09:49:37'),
	(360,49,'/0/47/49/','用户标签详情',5,'api/admin/user/tag/info',NULL,0,0,'2020-08-29 09:49:51','2020-08-29 09:49:51'),
	(361,49,'/0/47/49/','用户标签列表',5,'api/admin/user/tag/list',NULL,0,0,'2020-08-29 09:50:11','2020-08-29 09:50:11'),
	(362,164,'/0/47/164/','用户分组添加',5,'api/admin/user/group/list',NULL,0,0,'2020-08-29 09:52:08','2020-08-29 09:52:08'),
	(363,164,'/0/47/164/','用户分组修改',5,'api/admin/user/group/update',NULL,0,0,'2020-08-29 09:52:23','2020-08-29 09:52:23'),
	(364,164,'/0/47/164/','用户分组删除',5,'api/admin/user/group/delete',NULL,0,0,'2020-08-29 09:52:35','2020-08-29 09:52:35'),
	(365,164,'/0/47/164/','用户分组详情',5,'api/admin/user/group/info',NULL,0,0,'2020-08-29 09:52:55','2020-08-29 09:52:55'),
	(366,164,'/0/47/164/','用户分组列表',5,'api/admin/user/group/list',NULL,0,0,'2020-08-29 09:53:09','2020-08-29 09:53:09'),
	(367,57,'/0/56/57/','文章添加',5,'api/admin/article/save',NULL,0,0,'2020-08-29 09:54:14','2020-08-29 09:54:14'),
	(368,57,'/0/56/57/','文章删除',5,'api/admin/article/delete',NULL,0,0,'2020-08-29 09:55:05','2020-08-29 09:55:05'),
	(369,57,'/0/56/57/','文章修改',5,'api/admin/article/update',NULL,0,0,'2020-08-29 09:55:15','2020-08-29 09:55:15'),
	(370,57,'/0/56/57/','文章列表',5,'api/admin/article/list',NULL,0,0,'2020-08-29 09:55:23','2020-08-29 09:55:23'),
	(371,57,'/0/56/57/','文章详情',5,'api/admin/article/info',NULL,0,0,'2020-08-29 09:55:39','2020-08-29 09:55:39'),
	(372,57,'/0/56/57/','文章绑定产品',5,'api/admin/article/bind/product',NULL,0,0,'2020-08-29 09:56:40','2020-08-29 09:56:40'),
	(373,115,'/0/113/114/115/','微信菜单保存',5,'api/admin/wechat/menu/public/create',NULL,0,0,'2020-08-29 09:59:41','2020-08-29 09:59:41'),
	(374,115,'/0/113/114/115/','微信菜单删除',5,'api/admin/wechat/menu/public/delete',NULL,0,0,'2020-08-29 10:00:02','2020-08-29 10:00:02'),
	(375,172,'/0/113/114/141/172/','关键字添加',5,'api/admin/wechat/keywords/reply/save',NULL,0,0,'2020-08-29 10:02:20','2020-08-29 10:02:20'),
	(376,172,'/0/113/114/141/172/','关键字删除',5,'api/admin/wechat/keywords/reply/delete',NULL,0,0,'2020-08-29 10:02:48','2020-08-29 10:02:48'),
	(377,172,'/0/113/114/141/172/','关键字修改',5,'api/admin/wechat/keywords/reply/update',NULL,0,0,'2020-08-29 10:03:00','2020-08-29 10:03:00'),
	(378,172,'/0/113/114/141/172/','关键字状态更新',5,'api/admin/wechat/keywords/reply/status',NULL,0,0,'2020-08-29 10:03:16','2020-08-29 10:03:16'),
	(379,172,'/0/113/114/141/172/','关键字列表',5,'api/admin/wechat/keywords/reply/list',NULL,0,0,'2020-08-29 10:03:28','2020-08-29 10:03:28'),
	(380,172,'/0/113/114/141/172/','关键字详情',5,'api/admin/wechat/keywords/reply/info',NULL,0,0,'2020-08-29 10:03:42','2020-08-29 10:03:42'),
	(381,174,'/0/113/114/174/','微信模板添加',5,'api/admin/wechat/template/save',NULL,0,0,'2020-08-29 10:05:03','2020-08-29 10:06:14'),
	(382,174,'/0/113/114/174/','微信模板修改',5,'api/admin/wechat/template/update',NULL,0,0,'2020-08-29 10:05:35','2020-08-29 10:06:19'),
	(383,174,'/0/113/114/174/','微信模板删除',5,'api/admin/wechat/template/delete',NULL,0,0,'2020-08-29 10:05:44','2020-08-29 10:06:24'),
	(384,174,'/0/113/114/174/','微信模板列表',5,'api/admin/wechat/template/list',NULL,0,0,'2020-08-29 10:06:06','2020-08-29 10:06:06'),
	(385,174,'/0/113/114/174/','微信模板状态更新',5,'api/admin/wechat/template/status',NULL,0,0,'2020-08-29 10:06:55','2020-08-29 10:06:55'),
	(386,174,'/0/113/114/174/','微信模板详情',5,'api/admin/wechat/template/info',NULL,0,0,'2020-08-29 10:07:11','2020-08-29 10:07:11'),
	(387,174,'/0/113/114/174/','微信模板行业信息',5,'api/admin/wechat/template/industry',NULL,0,0,'2020-08-29 10:07:32','2020-08-29 10:07:32'),
	(388,140,'/0/113/139/140/','我的模板列表',5,'api/admin/wechat/program/my/temp/list',NULL,0,0,'2020-08-29 10:08:13','2020-08-29 10:08:13'),
	(389,140,'/0/113/139/140/','我的模板添加',5,'api/admin/wechat/program/my/temp/save',NULL,0,0,'2020-08-29 10:08:31','2020-08-29 10:08:31'),
	(390,140,'/0/113/139/140/','我的模板修改',5,'api/admin/wechat/program/my/temp/update',NULL,0,0,'2020-08-29 10:08:41','2020-08-29 10:08:41'),
	(391,140,'/0/113/139/140/','我的模板详情',5,'api/admin/wechat/program/my/temp/info',NULL,0,0,'2020-08-29 10:09:19','2020-08-29 10:09:19'),
	(392,140,'/0/113/139/140/','我的模板状态更新',5,'api/admin/wechat/program/my/temp/status',NULL,0,0,'2020-08-29 10:09:44','2020-08-29 10:09:44'),
	(393,316,'/0/113/139/316/','公共模板行业信息',5,'api/admin/wechat/program/category',NULL,0,0,'2020-08-29 10:10:28','2020-08-29 10:10:28'),
	(394,316,'/0/113/139/316/','公共模板列表',5,'api/admin/wechat/program/public/temp/list',NULL,0,0,'2020-08-29 10:10:54','2020-08-29 10:10:54'),
	(395,316,'/0/113/139/316/','公共模板详情',5,'api/admin/wechat/program/public/temp/info',NULL,0,0,'2020-08-29 10:11:17','2020-08-29 10:11:17'),
	(396,140,'/0/113/139/140/','根据公共模板获取关键词列表',5,'api/admin/wechat/program/getWeChatKeywordsByTid',NULL,0,0,'2020-08-29 10:11:56','2020-08-29 10:11:56'),
	(397,158,'/0/118/119/158/','优惠券添加',5,'api/admin/marketing/coupon/save',NULL,0,0,'2020-08-29 10:12:37','2020-08-29 10:16:13'),
	(398,158,'/0/118/119/158/','优惠券状态更新',5,'api/admin/marketing/coupon/update/status',NULL,0,0,'2020-08-29 10:13:10','2020-08-29 10:16:20'),
	(399,158,'/0/118/119/158/','优惠券列表',5,'api/admin/marketing/coupon/list',NULL,0,0,'2020-08-29 10:13:22','2020-08-29 10:16:21'),
	(400,158,'/0/118/119/158/','优惠券详情',5,'api/admin/marketing/coupon/info',NULL,0,0,'2020-08-29 10:13:42','2020-08-29 10:17:04'),
	(401,159,'/0/118/119/159/','会员领取记录列表',5,'api/admin/marketing/coupon/user/list',NULL,0,0,'2020-08-29 10:17:53','2020-08-29 10:17:53'),
	(402,159,'/0/118/119/159/','领取优惠券',5,'api/admin/marketing/coupon/user/receive',NULL,0,0,'2020-08-29 10:18:21','2020-08-29 10:18:48'),
	(403,54,'/0/51/52/54/','管理员添加',5,'api/admin/system/admin/save',NULL,0,0,'2020-08-29 10:22:43','2020-08-29 10:26:11'),
	(404,54,'/0/51/52/54/','管理员修改',5,'api/admin/system/admin/update',NULL,0,0,'2020-08-29 10:23:00','2020-08-29 10:26:09'),
	(405,54,'/0/51/52/54/','管理员删除',5,'api/admin/system/admin/delete',NULL,0,0,'2020-08-29 10:23:11','2020-08-29 10:26:06'),
	(406,54,'/0/51/52/54/','管理员列表',5,'api/admin/system/admin/list',NULL,0,0,'2020-08-29 10:23:21','2020-08-29 10:26:04'),
	(407,54,'/0/51/52/54/','管理员详情',5,'api/admin/system/admin/info',NULL,0,0,'2020-08-29 10:23:31','2020-08-29 10:26:01'),
	(408,53,'/0/51/52/53/','身份添加',5,'api/admin/system/role/save',NULL,0,0,'2020-08-29 10:26:52','2020-08-29 10:26:52'),
	(409,53,'/0/51/52/53/','身份删除',5,'api/admin/system/role/delete',NULL,0,0,'2020-08-29 10:27:07','2020-08-29 10:27:07'),
	(410,53,'/0/51/52/53/','身份修改',5,'api/admin/system/role/update',NULL,0,0,'2020-08-29 10:27:27','2020-08-29 10:27:27'),
	(411,53,'/0/51/52/53/','身份列表',5,'api/admin/system/role/list',NULL,0,0,'2020-08-29 10:27:39','2020-08-29 10:27:39'),
	(412,53,'/0/51/52/53/','身份详情',5,'api/admin/system/role/info',NULL,0,0,'2020-08-29 10:27:49','2020-08-29 10:27:49'),
	(413,53,'/0/51/52/53/','身份菜单（树形结构）',5,'api/admin/system/role/menu',NULL,0,0,'2020-08-29 10:28:30','2020-08-29 10:28:30'),
	(416,166,'/0/51/165/166/','城市列表',5,'api/admin/system/city/list',NULL,0,0,'2020-08-29 10:34:12','2020-08-29 10:34:12'),
	(417,166,'/0/51/165/166/','城市详情',5,'api/admin/system/city/info',NULL,0,0,'2020-08-29 10:34:24','2020-08-29 10:34:24'),
	(418,166,'/0/51/165/166/','城市修改',5,'api/admin/system/city/update',NULL,0,0,'2020-08-29 10:34:33','2020-08-29 10:34:33'),
	(419,166,'/0/51/165/166/','城市状态更新',5,'api/admin/system/city/update/status',NULL,0,0,'2020-08-29 10:34:56','2020-08-29 10:34:56'),
	(420,167,'/0/51/165/167/','物流公司添加',5,'api/admin/express/save',NULL,0,0,'2020-08-29 10:35:36','2020-08-29 10:35:36'),
	(421,167,'/0/51/165/167/','物流公司修改',5,'api/admin/express/update',NULL,0,0,'2020-08-29 10:35:52','2020-08-29 10:35:52'),
	(422,167,'/0/51/165/167/','物流公司删除',5,'api/admin/express/delete',NULL,0,0,'2020-08-29 10:36:03','2020-08-29 10:36:03'),
	(423,167,'/0/51/165/167/','物流公司详情',5,'api/admin/express/info',NULL,0,0,'2020-08-29 10:36:14','2020-08-29 10:36:14'),
	(424,167,'/0/51/165/167/','物流公司列表',5,'api/admin/express/list',NULL,0,0,'2020-08-29 10:36:27','2020-08-29 10:36:27'),
	(425,168,'/0/51/165/168/','物流模板添加',5,'api/admin/express/shipping/templates/save',NULL,0,0,'2020-08-29 10:37:49','2020-08-29 10:37:49'),
	(426,168,'/0/51/165/168/','物流模板修改',5,'api/admin/express/shipping/templates/update',NULL,0,0,'2020-08-29 10:38:01','2020-08-29 10:38:01'),
	(427,168,'/0/51/165/168/','物流模板删除',5,'api/admin/express/shipping/templates/delete',NULL,0,0,'2020-08-29 10:38:11','2020-08-29 10:38:11'),
	(428,168,'/0/51/165/168/','物流模板详情',5,'api/admin/express/shipping/templates/info',NULL,0,0,'2020-08-29 10:38:22','2020-08-29 10:38:27'),
	(429,168,'/0/51/165/168/','物流模板列表',5,'api/admin/express/shipping/templates/list',NULL,0,0,'2020-08-29 10:38:48','2020-08-29 10:38:48'),
	(430,168,'/0/51/165/168/','付费区域',5,'api/admin/express/shipping/region/list',NULL,0,0,'2020-08-29 10:39:22','2020-08-29 10:39:22'),
	(431,168,'/0/51/165/168/','免费区域',5,'api/admin/express/shipping/free/list',NULL,0,0,'2020-08-29 10:39:38','2020-08-29 10:39:38'),
	(432,69,'/0/66/67/69/','数据组添加',5,'api/admin/system/group/save',NULL,0,0,'2020-08-29 10:41:33','2020-08-29 10:41:33'),
	(433,69,'/0/66/67/69/','数据组修改',5,'api/admin/system/group/update',NULL,0,0,'2020-08-29 10:41:49','2020-08-29 10:41:49'),
	(434,69,'/0/66/67/69/','数据组删除',5,'api/admin/system/group/delete',NULL,0,0,'2020-08-29 10:41:59','2020-08-29 10:41:59'),
	(435,69,'/0/66/67/69/','数据组列表',5,'api/admin/system/group/list',NULL,0,0,'2020-08-29 10:42:11','2020-08-29 10:42:11'),
	(436,69,'/0/66/67/69/','数据组详情',5,'api/admin/system/group/info',NULL,0,0,'2020-08-29 10:42:22','2020-08-29 10:42:22'),
	(437,69,'/0/66/67/69/','组合数据添加',5,'api/admin/system/group/data/save',NULL,0,0,'2020-08-29 10:43:00','2020-08-29 10:43:00'),
	(438,69,'/0/66/67/69/','组合数据修改',5,'api/admin/system/group/data/update',NULL,0,0,'2020-08-29 10:43:16','2020-08-29 10:43:16'),
	(439,69,'/0/66/67/69/','组合数据删除',5,'api/admin/system/group/data/delete',NULL,0,0,'2020-08-29 10:43:41','2020-08-29 10:43:41'),
	(440,69,'/0/66/67/69/','组合数据列表',5,'api/admin/system/group/data/list',NULL,0,0,'2020-08-29 10:44:07','2020-08-29 10:44:07'),
	(441,69,'/0/66/67/69/','组合数据详情',5,'api/admin/system/group/data/info',NULL,0,0,'2020-08-29 10:44:16','2020-08-29 10:44:16'),
	(442,250,'/0/66/67/250/','表单添加',5,'api/admin/system/form/temp/save',NULL,0,0,'2020-08-29 10:45:23','2020-08-29 10:45:23'),
	(443,250,'/0/66/67/250/','表单删除',5,'api/admin/system/form/temp/delete',NULL,0,0,'2020-08-29 10:45:40','2020-08-29 10:45:40'),
	(444,250,'/0/66/67/250/','表单修改',5,'api/admin/system/form/temp/update',NULL,0,0,'2020-08-29 10:46:06','2020-08-29 10:46:06'),
	(445,250,'/0/66/67/250/','表单列表',5,'api/admin/system/form/temp/list',NULL,0,0,'2020-08-29 10:46:16','2020-08-29 10:46:16'),
	(446,43,'/0/42/43/','商品列表',5,'api/admin/store/product/list',NULL,0,0,'2020-08-29 16:04:19','2020-08-31 10:07:19'),
	(450,452,'/0/452/','订单统计',5,'/javaMobile/orderStatistics',NULL,1,0,'2020-09-03 10:27:31','2020-09-12 15:20:13'),
	(452,0,'/0/','移动端管理',5,'/javaMobile','mobile-phone',1,0,'2020-09-07 11:21:03','2020-09-12 15:18:48'),
	(454,100,'/0/100/','99Api',6,'99Api','122',1,4,'2020-09-08 12:17:36','2020-09-08 12:18:44'),
	(459,118,'/0/118/','秒杀管理',5,'/marketing/seckill',NULL,1,0,'2020-09-17 10:02:39','2020-09-17 10:02:39'),
	(460,459,'/0/118/459/','秒杀配置',5,'/marketing/seckill/config',NULL,1,0,'2020-09-17 10:37:42','2020-09-17 10:41:30'),
	(461,459,'/0/118/459/','秒杀商品',5,'/marketing/seckill/list',NULL,1,0,'2020-09-17 10:38:27','2020-09-17 10:41:40'),
	(464,0,'/0/','财务',5,'/financial','s-finance',1,1,'2020-09-17 14:34:44','2020-09-17 14:34:44'),
	(465,464,'/0/464/','财务操作',5,'/financial/commission',NULL,1,0,'2020-09-17 14:35:37','2020-09-17 14:35:37'),
	(466,465,'/0/464/465/','申请提现',5,'/financial/commission/template',NULL,1,0,'2020-09-17 14:36:04','2020-09-17 14:36:04'),
	(467,464,'/0/464/','财务记录',5,'/financial/record',NULL,1,0,'2020-09-17 14:36:40','2020-09-17 14:36:40'),
	(468,467,'/0/464/467/','充值记录',5,'/financial/record/charge',NULL,1,0,'2020-09-17 14:36:55','2020-09-17 14:37:22'),
	(469,467,'/0/464/467/','资金监控',5,'/financial/record/monitor',NULL,1,0,'2020-09-17 14:37:35','2020-09-17 14:37:35'),
	(470,464,'/0/464/','佣金记录',5,'/financial/brokerage',NULL,1,0,'2020-09-17 14:38:16','2020-09-17 14:38:16'),
	(477,477,'/0/477/','22222',1,'','image/content/2020/10/19/6c8ba5e093384f589d212ff77e898d39kpfzjv8h3c.png',1,999999999,'2020-10-20 14:44:07','2020-10-20 14:44:29'),
	(488,245,'/0/272/245/','精品首发',1,'',NULL,1,0,'2020-10-21 10:19:17','2020-10-21 17:25:31'),
	(489,245,'/0/272/245/','ds ',1,'',NULL,1,0,'2020-10-22 15:53:13','2020-10-22 15:53:13'),
	(492,118,'/0/118/','砍价管理',5,'/marketing/bargain',NULL,1,0,'2020-11-16 12:29:25','2020-11-16 12:29:25'),
	(493,492,'/0/118/492/','砍价商品',5,'/marketing/bargain/bargainGoods',NULL,1,0,'2020-11-16 14:19:46','2020-11-16 14:19:46'),
	(494,492,'/0/118/492/','砍价列表',5,'/marketing/bargain/bargainList',NULL,1,0,'2020-11-16 14:38:57','2020-11-16 14:38:57'),
	(495,118,'/0/118/','拼团管理',5,'/marketing/groupBuy',NULL,1,0,'2020-11-19 14:06:51','2020-11-19 14:06:51'),
	(496,495,'/0/118/495/','拼团商品',5,'/marketing/groupBuy/groupGoods',NULL,1,0,'2020-11-19 14:07:32','2020-11-19 14:07:32'),
	(497,495,'/0/118/495/','拼团列表',5,'/marketing/groupBuy/groupList',NULL,1,0,'2020-11-19 14:07:57','2020-11-19 14:07:57'),
	(500,0,'/0/','第三方接口设置',6,'short_letter_switch',NULL,1,1,'2020-12-10 10:58:25','2020-12-10 10:59:39'),
	(501,500,'/0/500/','短信配置',6,'short_letter_switch','111',1,1,'2020-12-10 10:59:08','2020-12-10 12:05:54'),
	(502,500,'/0/500/','采集商品配置',6,'copy_product','127',1,1,'2020-12-10 11:00:32','2020-12-10 12:18:38'),
	(503,500,'/0/500/','物流查询',6,'logistics_select','128',1,1,'2020-12-10 11:00:51','2020-12-10 12:18:57'),
	(504,500,'/0/500/','电子面单',6,'electronic_sheet','129',1,1,'2020-12-10 11:01:03','2020-12-10 12:19:02'),
	(505,51,'/0/51/','一号通',5,'/operation/onePass',NULL,1,8,'2020-12-10 11:06:44','2020-12-10 11:07:46'),
	(506,0,'/0/','华为新品发布会',3,'','image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png',1,0,'2020-12-15 17:45:43','2020-12-17 16:53:34'),
	(507,0,'/0/','小米新品发布会',3,'','image/user/2020/12/15/22f159f3c4f94173b1461dedcb993696i8wlul1mqj.jpg',1,0,'2020-12-15 17:46:13','2020-12-17 16:53:33'),
	(508,0,'/0/','饮品新品发布会',3,'1','image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg',0,2,'2020-12-15 17:46:55','2021-01-05 17:18:18'),
	(515,0,'/0/','每日新品',1,'','image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png',1,10,'2020-12-22 09:16:27','2020-12-24 14:02:05'),
	(516,515,'/0/515/','12.22日商品',1,'','image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg',1,11,'2020-12-22 09:18:18','2020-12-23 16:56:27'),
	(517,515,'/0/515/','12.21日商品',1,'','image/user/2020/12/15/22f159f3c4f94173b1461dedcb993696i8wlul1mqj.jpg',1,10,'2020-12-22 09:34:15','2020-12-23 16:56:29'),
	(518,284,'/0/283/284/','a',1,'',NULL,1,0,'2020-12-23 16:17:19','2020-12-23 16:17:19'),
	(519,0,'/0/','齿轮/轴',1,'','image/store/2020/12/24/00165274455e44069f1b00c35a67fd763aeptjeuoe.png',1,20,'2020-12-24 16:24:09','2021-01-04 09:26:55'),
	(521,308,'/0/181/184/188/308/','666',2,'url',NULL,0,1,'2020-12-26 13:17:41','2020-12-26 13:17:41'),
	(522,0,'/0/','1',3,'1','image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg',1,2,'2020-12-28 17:54:09','2021-01-06 09:38:11'),
	(523,138,'/0/135/136/138/','123',2,'url',NULL,0,1,'2020-12-30 11:49:35','2020-12-30 11:49:35'),
	(524,0,'/0/','123',1,'123','image/operation/2020/12/28/439cfd536aed4c18b501026ed97b52bbknv4zd5c4v.jpg',1,0,'2020-12-30 11:49:41','2021-01-04 10:31:53'),
	(525,524,'/0/524/','999',1,'','image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg',1,0,'2021-01-04 10:30:02','2021-01-04 10:31:51'),
	(526,0,'/0/','一级分类',1,'','image/operation/2020/12/28/439cfd536aed4c18b501026ed97b52bbknv4zd5c4v.jpg',1,0,'2021-01-05 11:52:31','2021-01-05 11:52:31'),
	(527,0,'/0/','测试产品',1,'',NULL,1,0,'2021-01-06 11:00:57','2021-01-06 11:00:57');

/*!40000 ALTER TABLE `eb_category` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_express
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_express`;

CREATE TABLE `eb_express` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '快递公司id',
  `code` varchar(50) NOT NULL DEFAULT '' COMMENT '快递公司简称',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '快递公司全称',
  `partner_id` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要月结账号',
  `partner_key` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要月结密码',
  `net` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要取件网店',
  `account` varchar(100) NOT NULL DEFAULT '' COMMENT '账号',
  `password` varchar(100) NOT NULL DEFAULT '' COMMENT '密码',
  `net_name` varchar(100) NOT NULL DEFAULT '' COMMENT '网点名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否可用',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `is_show` (`is_show`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='快递公司表';

LOCK TABLES `eb_express` WRITE;
/*!40000 ALTER TABLE `eb_express` DISABLE KEYS */;

INSERT INTO `eb_express` (`id`, `code`, `name`, `partner_id`, `partner_key`, `net`, `account`, `password`, `net_name`, `sort`, `is_show`, `status`)
VALUES
	(1,'yunda','韵达快递',1,1,0,'','','',0,1,0),
	(2,'yuantong','圆通速递',1,1,0,'','','',0,1,0),
	(3,'zhongtong','中通快递',1,1,0,'','','',0,1,0),
	(4,'shentong','申通快递',1,1,1,'','','',0,1,0),
	(5,'huitongkuaidi','百世快递',1,1,0,'','','',0,1,0),
	(6,'jd','京东物流',1,0,0,'','','',0,1,0),
	(7,'jtexpress','极兔速递',0,0,0,'','','',0,1,1),
	(8,'tiantian','天天快递',1,1,1,'','','',0,1,0),
	(9,'debangwuliu','德邦',0,0,0,'','','',0,1,1),
	(10,'debangkuaidi','德邦快递',1,0,0,'','','',0,1,0),
	(11,'zhongyouex','众邮快递',0,0,0,'','','',0,1,1),
	(12,'youshuwuliu','优速快递',1,1,0,'','','',0,1,0),
	(13,'zhongtongkuaiyun','中通快运',0,0,0,'','','',0,1,1),
	(14,'zhaijisong','宅急送',0,0,0,'','','',0,1,1),
	(15,'suning','苏宁物流',0,0,0,'','','',0,1,1),
	(16,'baishiwuliu','百世快运',0,0,0,'','','',0,1,1),
	(17,'zhimakaimen','芝麻开门',0,0,0,'','','',0,1,1),
	(18,'yundakuaiyun','韵达快运',0,0,0,'','','',0,1,1),
	(19,'annengwuliu','安能快运',0,0,0,'','','',0,1,1),
	(20,'lianhaowuliu','联昊通',0,0,0,'','','',0,1,1),
	(21,'ubonex','优邦速运',0,0,0,'','','',0,1,1),
	(22,'kuayue','跨越速运',1,1,0,'','','',0,1,0),
	(23,'yuantongkuaiyun','圆通快运',0,0,0,'','','',0,1,1),
	(24,'zhongyouwuliu','中邮物流',0,0,0,'','','',0,1,1),
	(25,'annto','安得物流',0,0,0,'','','',0,1,1),
	(26,'danniao','丹鸟',0,0,0,'','','',0,1,1),
	(27,'suer','速尔快递',1,0,1,'','','',0,1,0),
	(28,'chinaicip','卓志速运',0,0,0,'','','',0,1,1),
	(29,'zhonghuan','中环快递',0,0,0,'','','',0,1,1),
	(30,'yimidida','壹米滴答',0,0,0,'','','',0,1,1),
	(31,'shpost','同城快寄',0,0,0,'','','',0,1,1),
	(32,'kuaijiesudi','快捷速递',0,0,0,'','','',0,1,1),
	(33,'disifang','递四方',0,0,0,'','','',0,1,1),
	(34,'lntjs','特急送',0,0,0,'','','',0,1,1),
	(35,'rrs','日日顺物流',0,0,0,'','','',0,1,1),
	(36,'sxjdfreight','顺心捷达',0,0,0,'','','',0,1,1),
	(37,'idamalu','大马鹿',0,0,0,'','','',0,1,1),
	(38,'xinfengwuliu','信丰物流',1,1,0,'','','',0,1,0),
	(39,'ztky','中铁快运',0,0,0,'','','',0,1,1),
	(40,'btexpress','邦泰快运',0,0,0,'','','',0,1,1),
	(41,'tiandihuayu','天地华宇',0,0,0,'','','',0,1,1),
	(42,'lianbangkuaidi','联邦快递',0,0,0,'','','',0,1,1),
	(43,'banma','斑马物流',0,0,0,'','','',0,1,1),
	(44,'longbanwuliu','龙邦速递',0,0,0,'','','',0,1,1),
	(45,'flyway','程光快递',0,0,0,'','','',0,1,1),
	(46,'subida','速必达',0,0,0,'','','',0,1,1),
	(47,'jinguangsudikuaijian','京广速递',0,0,0,'','','',0,1,1),
	(48,'weitepai','微特派',0,0,0,'','','',0,1,1),
	(49,'yuxinwuliu','宇鑫物流',0,0,0,'','','',0,1,1),
	(50,'sdto','速达通',0,0,0,'','','',0,1,1),
	(51,'huisenky','汇森速运',0,0,0,'','','',0,1,1),
	(52,'guotongkuaidi','国通快递',1,1,1,'','','',0,1,0),
	(53,'bsht','百事亨通',0,0,0,'','','',0,1,1),
	(54,'jiuyescm','九曳供应链',0,0,0,'','','',0,1,1),
	(55,'sunjex','新杰物流',0,0,0,'','','',0,1,1),
	(56,'zhongtiewuliu','中铁物流',0,0,0,'','','',0,1,1),
	(57,'adapost','安达速递',0,0,0,'','','',0,1,1),
	(58,'wanjiawuliu','万家物流',0,0,0,'','','',0,1,1),
	(59,'shenghuiwuliu','盛辉物流',0,0,0,'','','',0,1,1),
	(60,'zhengyikuaidi','鑫正一快递',0,0,0,'','','',0,1,1),
	(61,'savor','海信物流',0,0,0,'','','',0,1,1),
	(62,'qexpress','易达通快递',0,0,0,'','','',0,1,1),
	(63,'sanhuwuliu','叁虎物流',0,0,0,'','','',0,1,1),
	(64,'polarexpress','极地快递',0,0,0,'','','',0,1,1),
	(65,'rufengda','如风达',0,0,0,'','','',0,1,1),
	(66,'wanxiangwuliu','万象物流',0,0,0,'','','',0,1,1),
	(67,'zhongtongphone','中通（带电话）',0,0,0,'','','',0,1,1),
	(68,'lbex','龙邦物流',0,0,0,'','','',0,1,1),
	(69,'jinan','金岸物流',0,0,0,'','','',0,1,1),
	(70,'sxexpress','三象速递',0,0,0,'','','',0,1,1),
	(71,'jiayunmeiwuliu','加运美',0,0,0,'','','',0,1,1),
	(72,'hac56','瀚朝物流',0,0,0,'','','',0,1,1),
	(73,'la911','鼎润物流',0,0,0,'','','',0,1,1),
	(74,'mosuda','魔速达',0,0,0,'','','',0,1,1),
	(75,'suteng','广东速腾物流',0,0,0,'','','',0,1,1),
	(76,'feiyuanvipshop','飞远配送',0,0,0,'','','',0,1,1),
	(77,'pingandatengfei','平安达腾飞',0,0,0,'','','',0,1,1),
	(78,'guexp','全联速运',0,0,0,'','','',0,1,1),
	(79,'hengluwuliu','恒路物流',0,0,0,'','','',0,1,1),
	(80,'wjkwl','万家康物流',0,0,0,'','','',0,1,1),
	(81,'xdexpress','迅达速递',0,0,0,'','','',0,1,1),
	(82,'yw56','燕文物流',0,0,0,'','','',0,1,1),
	(83,'bflg','上海缤纷物流',0,0,0,'','','',0,1,1),
	(84,'nebuex','星云速递',0,0,0,'','','',0,1,1),
	(85,'unitedex','联合速运',0,0,0,'','','',0,1,1),
	(86,'jiajiwuliu','佳吉快运',0,0,0,'','','',0,1,1),
	(87,'beebird','锋鸟物流',0,0,0,'','','',0,1,1),
	(88,'tzky','铁中快运',0,0,0,'','','',0,1,1),
	(89,'httx56','汇通天下物流',0,0,0,'','','',0,1,1),
	(90,'jumstc','聚盟共建',0,0,0,'','','',0,1,1),
	(91,'shunfengkuaiyun','顺丰快运',0,0,0,'','','',0,1,1),
	(92,'crazyexpress','疯狂快递',0,0,0,'','','',0,1,1),
	(93,'sut56','速通物流',0,0,0,'','','',0,1,1),
	(94,'zengyisudi','增益速递',0,0,0,'','','',0,1,1),
	(95,'valueway','美通',0,0,0,'','','',0,1,1),
	(96,'jssdt56','时达通',0,0,0,'','','',0,1,1),
	(97,'yuanfeihangwuliu','原飞航',0,0,0,'','','',0,1,1),
	(98,'zhongsukuaidi','中速快递',0,0,0,'','','',0,1,1),
	(99,'ane66','安能快递',1,0,0,'','','',0,1,0),
	(100,'anxl','安迅物流',0,0,0,'','','',0,1,1),
	(101,'fujisuyun','富吉速运',0,0,0,'','','',0,1,1),
	(102,'jiajikuaidi','佳吉快递',0,0,0,'','','',0,1,1),
	(103,'ndwl','南方传媒物流',0,0,0,'','','',0,1,1),
	(104,'huangmajia','黄马甲',0,0,0,'','','',0,1,1),
	(105,'hnht56','鸿泰物流',0,0,0,'','','',0,1,1),
	(106,'shangda','上大物流',0,0,0,'','','',0,1,1),
	(107,'ytkd','运通中港快递',0,0,0,'','','',0,1,1),
	(108,'dekuncn','德坤物流',0,0,0,'','','',0,1,1),
	(109,'quansutong','全速通',0,0,0,'','','',0,1,1),
	(110,'cccc58','中集冷云',0,0,0,'','','',0,1,1),
	(111,'dfwl','达发物流',0,0,0,'','','',0,1,1),
	(112,'quanfengkuaidi','全峰快递',0,0,0,'','','',0,1,1),
	(113,'fastgoexpress','速派快递',0,0,0,'','','',0,1,1),
	(114,'yujtong','宇捷通',0,0,0,'','','',0,1,1),
	(115,'chuangyi','创一快递',0,0,0,'','','',0,1,1),
	(116,'ganzhongnengda','能达速递',0,0,0,'','','',0,1,1),
	(117,'yidatong','易达通',0,0,0,'','','',0,1,1),
	(118,'oneexpress','一速递',0,0,0,'','','',0,1,1),
	(119,'datianwuliu','大田物流',0,0,0,'','','',0,1,1),
	(120,'quanyikuaidi','全一快递',1,0,0,'','','',0,1,0),
	(121,'pjbest','品骏快递',1,1,0,'','','',0,1,0),
	(122,'shangqiao56','商桥物流',0,0,0,'','','',0,1,1),
	(123,'tianma','天马迅达',0,0,0,'','','',0,1,1),
	(124,'yousutongda','优速通达',0,0,0,'','','',0,1,1),
	(125,'yuananda','源安达',0,0,0,'','','',0,1,1),
	(126,'astexpress','安世通快递',0,0,0,'','','',0,1,1),
	(127,'exfresh','安鲜达',0,0,0,'','','',0,1,1),
	(128,'jialidatong','嘉里大通',0,0,0,'','','',0,1,1),
	(129,'nanjingshengbang','晟邦物流',0,0,0,'','','',0,1,1),
	(130,'pfcexpress','皇家物流',0,0,0,'','','',0,1,1),
	(131,'qinyuan','秦远物流',0,0,0,'','','',0,1,1),
	(132,'runhengfeng','全时速运',0,0,0,'','','',0,1,1),
	(133,'dayangwuliu','大洋物流',0,0,0,'','','',0,1,1),
	(134,'heimao56','黑猫速运',0,0,0,'','','',0,1,1),
	(135,'huaxiahuoyun','华夏货运',0,0,0,'','','',0,1,1),
	(136,'longfx','LUCFLOW EXPRESS',0,0,0,'','','',0,1,1),
	(137,'zjstky','苏通快运',0,0,0,'','','',0,1,1),
	(138,'zlink','三真驿道',0,0,0,'','','',0,1,1),
	(139,'hd','宏递快运',0,0,0,'','','',0,1,1),
	(140,'hrex','锦程快递',0,0,0,'','','',0,1,1),
	(141,'sfwl','盛丰物流',0,0,0,'','','',0,1,1),
	(142,'yuanchengwuliu','远成物流',0,0,0,'','','',0,1,1),
	(143,'eshunda','俄顺达',0,0,0,'','','',0,1,1),
	(144,'est365','东方汇',0,0,0,'','','',0,1,1),
	(145,'lijisong','成都立即送',0,0,0,'','','',0,1,1),
	(146,'morelink56','MoreLink',0,0,0,'','','',0,1,1),
	(147,'topspeedex','中运全速',0,0,0,'','','',0,1,1),
	(148,'yunfeng56','韵丰物流',0,0,0,'','','',0,1,1),
	(149,'express7th','7号速递',0,0,0,'','','',0,1,1),
	(150,'wherexpess','威盛快递',0,0,0,'','','',0,1,1),
	(151,'yizhengdasuyun','一正达速运',0,0,0,'','','',0,1,1),
	(152,'youyou','优优速递',0,0,0,'','','',0,1,1),
	(153,'ztong','智通物流',0,0,0,'','','',0,1,1),
	(154,'chinapostcb','中邮电商',0,0,0,'','','',0,1,1),
	(155,'hlyex','好来运',0,0,0,'','','',0,1,1),
	(156,'jgwl','景光物流',0,0,0,'','','',0,1,1),
	(157,'jiujiuwl','久久物流',0,0,0,'','','',0,1,1),
	(158,'minghangkuaidi','民航快递',0,0,0,'','','',0,1,1),
	(159,'quansu','全速物流',0,0,0,'','','',0,1,1),
	(160,'tywl99','天翼物流',0,0,0,'','','',0,1,1),
	(161,'wondersyd','中邮速递',0,0,0,'','','',0,1,1),
	(162,'yafengsudi','亚风速递',0,0,0,'','','',0,1,1),
	(163,'ytchengnuoda','承诺达',1,1,0,'','','',0,1,0),
	(164,'anxindakuaixi','安信达',0,0,0,'','','',0,1,1),
	(165,'chengtong','城通物流',0,0,0,'','','',0,1,1),
	(166,'eupackage','易优包裹',0,0,0,'','','',0,1,1),
	(167,'ftky365','丰通快运',0,0,0,'','','',0,1,1),
	(168,'gslhkd','联合快递',0,0,0,'','','',0,1,1),
	(169,'jiayiwuliu','佳怡物流',0,0,0,'','','',0,1,1),
	(170,'jieborne','捷邦物流',0,0,0,'','','',0,1,1),
	(171,'jxfex','集先锋快递',0,0,0,'','','',0,1,1),
	(172,'luben','陆本速递 LUBEN EXPRESS',0,0,0,'','','',0,1,1),
	(173,'tykd','天翼快递',0,0,0,'','','',0,1,1),
	(174,'baitengwuliu','百腾物流',0,0,0,'','','',0,1,1),
	(175,'biaojikuaidi','彪记快递',0,0,0,'','','',0,1,1),
	(176,'boyol','贝业物流',0,0,0,'','','',0,1,1),
	(177,'exsuda','E速达',0,0,0,'','','',0,1,1),
	(178,'feikangda','飞康达',0,0,0,'','','',0,1,1),
	(179,'jiacheng','佳成快递 ',0,0,0,'','','',0,1,1),
	(180,'jingshun','景顺物流',0,0,0,'','','',0,1,1),
	(181,'mingliangwuliu','明亮物流',0,0,0,'','','',0,1,1),
	(182,'shunjiefengda','顺捷丰达',0,0,0,'','','',0,1,1),
	(183,'sundarexpress','顺达快递',0,0,0,'','','',0,1,1),
	(184,'yaofeikuaidi','耀飞同城快递',0,0,0,'','','',0,1,1),
	(185,'1ziton','一智通',0,0,0,'','','',0,1,1),
	(186,'alog','心怡物流',0,0,0,'','','',0,1,1),
	(187,'bdatong','八达通',0,0,0,'','','',0,1,1),
	(188,'bosind','堡昕德速递',0,0,0,'','','',0,1,1),
	(189,'buytong','百通物流',0,0,0,'','','',0,1,1),
	(190,'changyuwuliu','长宇物流',0,0,0,'','','',0,1,1),
	(191,'chuanxiwuliu','传喜物流',0,0,0,'','','',0,1,1),
	(192,'chunghwa56','中骅物流',0,0,0,'','','',0,1,1),
	(193,'cnspeedster','速舟物流',0,0,0,'','','',0,1,1),
	(194,'didasuyun','递达速运',0,0,0,'','','',0,1,1),
	(195,'emswuliu','EMS物流',0,0,0,'','','',0,1,1),
	(196,'feibaokuaidi','飞豹快递',0,0,0,'','','',0,1,1),
	(197,'gda','安的快递',0,0,0,'','','',0,1,1),
	(198,'gdkjk56','快捷快物流',0,0,0,'','','',0,1,1),
	(199,'guoeryue','天天快物流',0,0,0,'','','',0,1,1),
	(200,'hotwms','皇家云仓',0,0,0,'','','',0,1,1),
	(201,'ht22','海淘物流',0,0,0,'','','',0,1,1),
	(202,'huaqikuaiyun','华企快运',0,0,0,'','','',0,1,1),
	(203,'jcsuda','嘉诚速达',0,0,0,'','','',0,1,1),
	(204,'longcps','加拿大龙行速运',0,0,0,'','','',0,1,1),
	(205,'newsway','家家通快递',0,0,0,'','','',0,1,1),
	(206,'qbexpress','秦邦快运',0,0,0,'','','',0,1,1),
	(207,'quanritongkuaidi','全日通',0,0,0,'','','',0,1,1),
	(208,'sanshengco','三盛快递',0,0,0,'','','',0,1,1),
	(209,'shangcheng','尚橙物流',0,0,0,'','','',0,1,1),
	(210,'shunfenghk','顺丰-繁体',0,0,0,'','','',0,1,1),
	(211,'spring56','春风物流',0,0,0,'','','',0,1,1),
	(212,'sxhongmajia','红马甲物流',0,0,0,'','','',0,1,1),
	(213,'szshihuatong56','世华通物流',0,0,0,'','','',0,1,1),
	(214,'wto56kj','臣邦同城',0,0,0,'','','',0,1,1),
	(215,'xiangteng','翔腾物流',0,0,0,'','','',0,1,1),
	(216,'xunsuexpress','迅速快递',0,0,0,'','','',0,1,1),
	(217,'yongchangwuliu','永昌物流',0,0,0,'','','',0,1,1),
	(218,'yuanzhijiecheng','元智捷诚',0,0,0,'','','',0,1,1),
	(219,'yuefengwuliu','越丰物流',0,0,0,'','','',0,1,1),
	(220,'zhongjiwuliu','中技物流',0,0,0,'','','',0,1,1),
	(221,'zlxdjwl','中粮鲜到家物流',0,0,0,'','','',0,1,1),
	(222,'adaexpress','明大快递',0,0,0,'','','',0,1,1),
	(223,'advancing','安达信',0,0,0,'','','',0,1,1),
	(224,'agopost','全程快递',0,0,0,'','','',0,1,1),
	(225,'ahdf','德方物流',0,0,0,'','','',0,1,1),
	(226,'ahkbps','卡邦配送',0,0,0,'','','',0,1,1),
	(227,'aliexpress','无忧物流',0,0,0,'','','',0,1,1),
	(228,'anjiatongcheng','安家同城快运',0,0,0,'','','',0,1,1),
	(229,'anjie88','安捷物流',0,0,0,'','','',0,1,1),
	(230,'anjiekuaidi','青岛安捷快递',0,0,0,'','','',0,1,1),
	(231,'anlexpress','新干线快递',0,0,0,'','','',0,1,1),
	(232,'apgecommerce','apgecommerce',0,0,0,'','','',0,1,1),
	(233,'ariesfar','艾瑞斯远',0,0,0,'','','',0,1,1),
	(234,'ausbondexpress','澳邦国际物流',0,0,0,'','','',0,1,1),
	(235,'auvanda','中联速递',0,0,0,'','','',0,1,1),
	(236,'baishiyp','百世云配',0,0,0,'','','',0,1,1),
	(237,'bangsongwuliu','邦送物流',0,0,0,'','','',0,1,1),
	(238,'baotongkd','宝通快递',0,0,0,'','','',0,1,1),
	(239,'baoxianda','报通快递',0,0,0,'','','',0,1,1),
	(240,'bazirim','皮牙子快递',0,0,0,'','','',0,1,1),
	(241,'beckygo','佰麒快递',0,0,0,'','','',0,1,1),
	(242,'bee001','蜜蜂速递',0,0,0,'','','',0,1,1),
	(243,'benteng','奔腾物流',0,0,0,'','','',0,1,1),
	(244,'bjqywl','青云物流',0,0,0,'','','',0,1,1),
	(245,'bjxsrd','鑫锐达',0,0,0,'','','',0,1,1),
	(246,'bljt56','佰乐捷通',0,0,0,'','','',0,1,1),
	(247,'bmlchina','标杆物流',0,0,0,'','','',0,1,1),
	(248,'bqcwl','百千诚物流',0,0,0,'','','',0,1,1),
	(249,'byht','展勤快递',0,0,0,'','','',0,1,1),
	(250,'canhold','能装能送',0,0,0,'','','',0,1,1),
	(251,'cbo56','钏博物流',0,0,0,'','','',0,1,1),
	(252,'ccd','河南次晨达',0,0,0,'','','',0,1,1),
	(253,'cdjx56','捷祥物流',0,0,0,'','','',0,1,1),
	(254,'cdxinchen56','鑫宸物流',0,0,0,'','','',0,1,1),
	(255,'cex','城铁速递',0,0,0,'','','',0,1,1),
	(256,'cfss','银雁专送',0,0,0,'','','',0,1,1),
	(257,'chengji','城际快递',0,0,0,'','','',0,1,1),
	(258,'chengpei','河北橙配',0,0,0,'','','',0,1,1),
	(259,'chinastarlogistics','华欣物流',0,0,0,'','','',0,1,1),
	(260,'chinatzx','同舟行物流',0,0,0,'','','',0,1,1),
	(261,'chllog','嘉荣物流',0,0,0,'','','',0,1,1),
	(262,'cht361','诚和通',0,0,0,'','','',0,1,1),
	(263,'city56','城市映急',0,0,0,'','','',0,1,1),
	(264,'cjkoreaexpress','大韩通运',0,0,0,'','','',0,1,1),
	(265,'cneulogistics','中欧物流',0,0,0,'','','',0,1,1),
	(266,'cpsair','华中快递',0,0,0,'','','',0,1,1),
	(267,'cqxingcheng','重庆星程快递',0,0,0,'','','',0,1,1),
	(268,'crossbox','环旅快运',0,0,0,'','','',0,1,1),
	(269,'csxss','新时速物流',0,0,0,'','','',0,1,1),
	(270,'czwlyn','云南诚中物流',0,0,0,'','','',0,1,1),
	(271,'dadaoex','大道物流',0,0,0,'','','',0,1,1),
	(272,'dande56','丹递56',0,0,0,'','','',0,1,1),
	(273,'dasu','达速物流',0,0,0,'','','',0,1,1),
	(274,'dechuangwuliu','深圳德创物流',0,0,0,'','','',0,1,1),
	(275,'decnlh','德中快递',0,0,0,'','','',0,1,1),
	(276,'dfkuaidi','东风快递',0,0,0,'','','',0,1,1),
	(277,'dfpost','达方物流',0,0,0,'','','',0,1,1),
	(278,'di5pll','递五方云仓',0,0,0,'','','',0,1,1),
	(279,'diantongkuaidi','店通快递',0,0,0,'','','',0,1,1),
	(280,'dianyi','云南滇驿物流',0,0,0,'','','',0,1,1),
	(281,'dingdong','叮咚快递',0,0,0,'','','',0,1,1),
	(282,'djy56','天翔东捷运',0,0,0,'','','',0,1,1),
	(283,'donghanwl','东瀚物流',0,0,0,'','','',0,1,1),
	(284,'donghong','东红物流',0,0,0,'','','',0,1,1),
	(285,'dongjun','成都东骏物流',0,0,0,'','','',0,1,1),
	(286,'duodao56','duodao56',0,0,0,'','','',0,1,1),
	(287,'edaeuexpress','易达快运',0,0,0,'','','',0,1,1),
	(288,'efspost','EFSPOST',0,0,0,'','','',0,1,1),
	(289,'el56','易联通达',0,0,0,'','','',0,1,1),
	(290,'eusacn','优莎速运',0,0,0,'','','',0,1,1),
	(291,'excocotree','可可树美中速运',0,0,0,'','','',0,1,1),
	(292,'fanyukuaidi','凡宇快递',0,0,0,'','','',0,1,1),
	(293,'fastzt','正途供应链',0,0,0,'','','',0,1,1),
	(294,'fbkd','飞邦快递',0,0,0,'','','',0,1,1),
	(295,'feihukuaidi','飞狐快递',0,0,0,'','','',0,1,1),
	(296,'feikuaida','飞快达',0,0,0,'','','',0,1,1),
	(297,'fenghuangkuaidi','凤凰快递',0,0,0,'','','',0,1,1),
	(298,'fengyee','丰羿',0,0,0,'','','',0,1,1),
	(299,'flysman','飞力士物流',0,0,0,'','','',0,1,1),
	(300,'fsexp','全速快递',0,0,0,'','','',0,1,1),
	(301,'ftlexpress','法翔速运',0,0,0,'','','',0,1,1),
	(302,'fyex','飞云快递系统',0,0,0,'','','',0,1,1),
	(303,'gaotieex','高铁快运',0,0,0,'','','',0,1,1),
	(304,'gdct56','广东诚通物流',0,0,0,'','','',0,1,1),
	(305,'gdqwwl','全网物流',0,0,0,'','','',0,1,1),
	(306,'gdrz58','容智快运',0,0,0,'','','',0,1,1),
	(307,'gdxp','新鹏快递',0,0,0,'','','',0,1,1),
	(308,'ghl','环创物流',0,0,0,'','','',0,1,1),
	(309,'gjwl','冠捷物流 ',0,0,0,'','','',0,1,1),
	(310,'gml','英脉物流',0,0,0,'','','',0,1,1),
	(311,'goldjet','高捷快运',0,0,0,'','','',0,1,1),
	(312,'gongsuda','共速达',0,0,0,'','','',0,1,1),
	(313,'gooday365','日日顺智慧物联',0,0,0,'','','',0,1,1),
	(314,'gscq365','哥士传奇速递',0,0,0,'','','',0,1,1),
	(315,'gswtkd','万通快递',0,0,0,'','','',0,1,1),
	(316,'gtongsudi','广通速递',0,0,0,'','','',0,1,1),
	(317,'gttexpress','GTT EXPRESS快递',0,0,0,'','','',0,1,1),
	(318,'guangdongtonglu','广东通路',0,0,0,'','','',0,1,1),
	(319,'guosong','国送快运',0,0,0,'','','',0,1,1),
	(320,'gxwl','光线速递',0,0,0,'','','',0,1,1),
	(321,'gzxingcheng','贵州星程快递',0,0,0,'','','',0,1,1),
	(322,'haihongwangsong','海红网送',0,0,0,'','','',0,1,1),
	(323,'haimengsudi','海盟速递',0,0,0,'','','',0,1,1),
	(324,'haixingqiao','海星桥快递',0,0,0,'','','',0,1,1),
	(325,'haizhongzhuanyun','海中转运',0,0,0,'','','',0,1,1),
	(326,'hanfengjl','翰丰快递',0,0,0,'','','',0,1,1),
	(327,'hangrui','上海航瑞货运',0,0,0,'','','',0,1,1),
	(328,'hangyu','航宇快递',0,0,0,'','','',0,1,1),
	(329,'haoyoukuai','好又快物流',0,0,0,'','','',0,1,1),
	(330,'happylink','开心快递',0,0,0,'','','',0,1,1),
	(331,'hdcexpress','汇达物流',0,0,0,'','','',0,1,1),
	(332,'hengrui56','恒瑞物流',0,0,0,'','','',0,1,1),
	(333,'hexinexpress','合心速递',0,0,0,'','','',0,1,1),
	(334,'hgy56','环国运物流',0,0,0,'','','',0,1,1),
	(335,'hhair56','华瀚快递',0,0,0,'','','',0,1,1),
	(336,'hjs','猴急送',0,0,0,'','','',0,1,1),
	(337,'hlkytj','互联快运',0,0,0,'','','',0,1,1),
	(338,'hlpgyl','共联配',0,0,0,'','','',0,1,1),
	(339,'hltop','海联快递',0,0,0,'','','',0,1,1),
	(340,'hmus','华美快递',0,0,0,'','','',0,1,1),
	(341,'hnfy','飞鹰物流',0,0,0,'','','',0,1,1),
	(342,'hnqst','河南全速通',0,0,0,'','','',0,1,1),
	(343,'hnssd56','顺时达物流',0,0,0,'','','',0,1,1),
	(344,'hnzqwl','中强物流',0,0,0,'','','',0,1,1),
	(345,'homexpress','居家通',0,0,0,'','','',0,1,1),
	(346,'hongbeixin','红背心',0,0,0,'','','',0,1,1),
	(347,'hongpinwuliu','宏品物流',0,0,0,'','','',0,1,1),
	(348,'hongywl','红远物流',0,0,0,'','','',0,1,1),
	(349,'hrbzykd','卓烨快递',0,0,0,'','','',0,1,1),
	(350,'hre','高铁速递',0,0,0,'','','',0,1,1),
	(351,'hsgtsd','海硕高铁速递',0,0,0,'','','',0,1,1),
	(352,'htongexpress','华通快运',0,0,0,'','','',0,1,1),
	(353,'htwd','华通务达物流',0,0,0,'','','',0,1,1),
	(354,'huada','华达快运',0,0,0,'','','',0,1,1),
	(355,'huandonglg','环东物流',0,0,0,'','','',0,1,1),
	(356,'huiqiangkuaidi','汇强快递',0,0,0,'','','',0,1,1),
	(357,'huoban','兰州伙伴物流',0,0,0,'','','',0,1,1),
	(358,'hutongwuliu','户通物流',0,0,0,'','','',0,1,1),
	(359,'hyeship','鸿远物流',0,0,0,'','','',0,1,1),
	(360,'hyytes','恒宇运通',0,0,0,'','','',0,1,1),
	(361,'hzpl','华航快递',0,0,0,'','','',0,1,1),
	(362,'idada','大达物流',0,0,0,'','','',0,1,1),
	(363,'jdexpressusa','骏达快递',0,0,0,'','','',0,1,1),
	(364,'jdpplus','急递',0,0,0,'','','',0,1,1),
	(365,'jiajiatong56','佳家通货运',0,0,0,'','','',0,1,1),
	(366,'jiajiawl','加佳物流',0,0,0,'','','',0,1,1),
	(367,'jiazhoumao','加州猫速递',0,0,0,'','','',0,1,1),
	(368,'jieanda','捷安达',0,0,0,'','','',0,1,1),
	(369,'jinchengwuliu','锦程物流',0,0,0,'','','',0,1,1),
	(370,'jindawuliu','金大物流',0,0,0,'','','',0,1,1),
	(371,'jintongkd','劲通快递',0,0,0,'','','',0,1,1),
	(372,'jinyuekuaidi','晋越快递',0,0,0,'','','',0,1,1),
	(373,'jisu','冀速物流',0,0,0,'','','',0,1,1),
	(374,'jiugong','九宫物流',0,0,0,'','','',0,1,1),
	(375,'jiuyicn','久易快递',0,0,0,'','','',0,1,1),
	(376,'jixianda','急先达',0,0,0,'','','',0,1,1),
	(377,'jjx888','佳捷翔物流',0,0,0,'','','',0,1,1),
	(378,'jsexpress','骏绅物流',0,0,0,'','','',0,1,1),
	(379,'juding','聚鼎物流',0,0,0,'','','',0,1,1),
	(380,'juwu','聚物物流',0,0,0,'','','',0,1,1),
	(381,'juzhongda','聚中大',0,0,0,'','','',0,1,1),
	(382,'kejie','科捷物流',0,0,0,'','','',0,1,1),
	(383,'kerrytj','嘉里大荣物流',0,0,0,'','','',0,1,1),
	(384,'kfwnet','快服务',0,0,0,'','','',0,1,1),
	(385,'khzto','柬埔寨中通',0,0,0,'','','',0,1,1),
	(386,'koalaexp','考拉速递',0,0,0,'','','',0,1,1),
	(387,'ksudi','快速递',0,0,0,'','','',0,1,1),
	(388,'kuai8','快8速运',0,0,0,'','','',0,1,1),
	(389,'kuaidawuliu','快达物流',0,0,0,'','','',0,1,1),
	(390,'kuaitao','快淘快递',0,0,0,'','','',0,1,1),
	(391,'kuaiyouda','四川快优达速递',0,0,0,'','','',0,1,1),
	(392,'kxda','凯信达',0,0,0,'','','',0,1,1),
	(393,'lanbiaokuaidi','蓝镖快递',0,0,0,'','','',0,1,1),
	(394,'lanhukuaidi','蓝弧快递',0,0,0,'','','',0,1,1),
	(395,'lasy56','林安物流',0,0,0,'','','',0,1,1),
	(396,'lbbk','立白宝凯物流',0,0,0,'','','',0,1,1),
	(397,'ledaowuliu','楽道物流',0,0,0,'','','',0,1,1),
	(398,'ledii','乐递供应链',0,0,0,'','','',0,1,1),
	(399,'letseml','美联快递',0,0,0,'','','',0,1,1),
	(400,'lianbangkuaidien','联邦快递-英文',0,0,0,'','','',0,1,1),
	(401,'lianyun','联运快递',0,0,0,'','','',0,1,1),
	(402,'lishi','丽狮物流',0,0,0,'','','',0,1,1),
	(403,'littlebearbear','小熊物流',0,0,0,'','','',0,1,1),
	(404,'longlangkuaidi','隆浪快递',0,0,0,'','','',0,1,1),
	(405,'longvast','长风物流',0,0,0,'','','',0,1,1),
	(406,'lqht','恒通快递',0,0,0,'','','',0,1,1),
	(407,'ltexp','乐天速递',0,0,0,'','','',0,1,1),
	(408,'lutong','鲁通快运',0,0,0,'','','',0,1,1),
	(409,'mailikuaidi','麦力快递',0,0,0,'','','',0,1,1),
	(410,'mailongdy','迈隆递运',0,0,0,'','','',0,1,1),
	(411,'mangguo','芒果速递',0,0,0,'','','',0,1,1),
	(412,'mchy','木春货运',0,0,0,'','','',0,1,1),
	(413,'meidaexpress','美达快递',0,0,0,'','','',0,1,1),
	(414,'meitai','美泰物流',0,0,0,'','','',0,1,1),
	(415,'milkyway','银河物流',0,0,0,'','','',0,1,1),
	(416,'minbangsudi','民邦速递',0,0,0,'','','',0,1,1),
	(417,'mjexp','美龙快递',0,0,0,'','','',0,1,1),
	(418,'mxe56','中俄速通（淼信）',0,0,0,'','','',0,1,1),
	(419,'nalexpress','新亚物流',0,0,0,'','','',0,1,1),
	(420,'nedahm','红马速递',0,0,0,'','','',0,1,1),
	(421,'nell','尼尔快递',0,0,0,'','','',0,1,1),
	(422,'niuzaiexpress','牛仔速运',0,0,0,'','','',0,1,1),
	(423,'njhaobo','浩博物流',0,0,0,'','','',0,1,1),
	(424,'nmhuahe','华赫物流',0,0,0,'','','',0,1,1),
	(425,'nntengda','腾达速递',0,0,0,'','','',0,1,1),
	(426,'onway','昂威物流',0,0,0,'','','',0,1,1),
	(427,'overseaex','波音速递',0,0,0,'','','',0,1,1),
	(428,'peex','派尔快递',0,0,0,'','','',0,1,1),
	(429,'peisihuoyunkuaidi','配思货运',0,0,0,'','','',0,1,1),
	(430,'peixingwuliu','陪行物流',0,0,0,'','','',0,1,1),
	(431,'pengcheng','鹏程快递',0,0,0,'','','',0,1,1),
	(432,'pinsuxinda','品速心达快递',0,0,0,'','','',0,1,1),
	(433,'pinxinkuaidi','品信快递',0,0,0,'','','',0,1,1),
	(434,'pmt0704be','龙行天下',0,0,0,'','','',0,1,1),
	(435,'polarisexpress','北极星快运',0,0,0,'','','',0,1,1),
	(436,'pzhjst','急顺通',0,0,0,'','','',0,1,1),
	(437,'qhxykd','雪域快递',0,0,0,'','','',0,1,1),
	(438,'qhxyyg','雪域易购',0,0,0,'','','',0,1,1),
	(439,'qianli','千里速递',0,0,0,'','','',0,1,1),
	(440,'qskdyxgs','千顺快递',0,0,0,'','','',0,1,1),
	(441,'quanchuan56','全川物流',0,0,0,'','','',0,1,1),
	(442,'quanjitong','全际通',0,0,0,'','','',0,1,1),
	(443,'quantwl','全通快运',0,0,0,'','','',0,1,1),
	(444,'quanxintong','全信通快递',0,0,0,'','','',0,1,1),
	(445,'qzx56','全之鑫物流',0,0,0,'','','',0,1,1),
	(446,'rhtexpress','睿和泰速运',0,0,0,'','','',0,1,1),
	(447,'riyuwuliu','日昱物流',0,0,0,'','','',0,1,1),
	(448,'rokin','荣庆物流',0,0,0,'','','',0,1,1),
	(449,'rrskx','日日顺快线',0,0,0,'','','',0,1,1),
	(450,'santaisudi','三态速递',0,0,0,'','','',0,1,1),
	(451,'sccod','丰程物流',0,0,0,'','','',0,1,1),
	(452,'scsujiada','速佳达快运',0,0,0,'','','',0,1,1),
	(453,'scxingcheng','四川星程快递',0,0,0,'','','',0,1,1),
	(454,'sczpds','速呈',0,0,0,'','','',0,1,1),
	(455,'sdsy888','首达速运',0,0,0,'','','',0,1,1),
	(456,'sfift','十方通物流',0,0,0,'','','',0,1,1),
	(457,'sfjhd','圣飞捷快递',0,0,0,'','','',0,1,1),
	(458,'shanda56','衫达快运',0,0,0,'','','',0,1,1),
	(459,'shanghaikuaitong','上海快通',0,0,0,'','','',0,1,1),
	(460,'shangtuguoji','尚途国际货运',0,0,0,'','','',0,1,1),
	(461,'shaoke','捎客物流',0,0,0,'','','',0,1,1),
	(462,'shd56','商海德物流',0,0,0,'','','',0,1,1),
	(463,'shenganwuliu','圣安物流',0,0,0,'','','',0,1,1),
	(464,'shengtongscm','盛通快递',0,0,0,'','','',0,1,1),
	(465,'shenjun','神骏物流',0,0,0,'','','',0,1,1),
	(466,'shenma','神马快递',0,0,0,'','','',0,1,1),
	(467,'shiningexpress','阳光快递',0,0,0,'','','',0,1,1),
	(468,'shipbyace','王牌快递',0,0,0,'','','',0,1,1),
	(469,'shipsoho','苏豪快递',0,0,0,'','','',0,1,1),
	(470,'shiyunkuaidi','世运快递',0,0,0,'','','',0,1,1),
	(471,'shunfengtongcheng','顺丰同城',0,0,0,'','','',0,1,1),
	(472,'shunjieda','顺捷达',0,0,0,'','','',0,1,1),
	(473,'shunshid','顺士达速运',0,0,0,'','','',0,1,1),
	(474,'signedexpress','签收快递',0,0,0,'','','',0,1,1),
	(475,'sihaiet','四海快递',0,0,0,'','','',0,1,1),
	(476,'sihiexpress','四海捷运',0,0,0,'','','',0,1,1),
	(477,'sixroad','易普递',0,0,0,'','','',0,1,1),
	(478,'sofast56','嗖一下同城快递',0,0,0,'','','',0,1,1),
	(479,'speeda','行必达',0,0,0,'','','',0,1,1),
	(480,'speedoex','申必达',0,0,0,'','','',0,1,1),
	(481,'staky','首通快运',0,0,0,'','','',0,1,1),
	(482,'starex','星速递',0,0,0,'','','',0,1,1),
	(483,'staryvr','星运快递',0,0,0,'','','',0,1,1),
	(484,'stkd','顺通快递',0,0,0,'','','',0,1,1),
	(485,'subaoex','速豹',0,0,0,'','','',0,1,1),
	(486,'sucheng','速呈宅配',0,0,0,'','','',0,1,1),
	(487,'sucmj','特急便物流',0,0,0,'','','',0,1,1),
	(488,'sufengkuaidi','速风快递',0,0,0,'','','',0,1,1),
	(489,'suijiawuliu','穗佳物流',0,0,0,'','','',0,1,1),
	(490,'sujievip','郑州速捷',0,0,0,'','','',0,1,1),
	(491,'sunspeedy','新速航',0,0,0,'','','',0,1,1),
	(492,'supinexpress','速品快递',0,0,0,'','','',0,1,1),
	(493,'szuem','联运通物流',0,0,0,'','','',0,1,1),
	(494,'taijin','泰进物流',0,0,0,'','','',0,1,1),
	(495,'taimek','天美快递',0,0,0,'','','',0,1,1),
	(496,'tianxiang','天翔快递',0,0,0,'','','',0,1,1),
	(497,'tianzong','天纵物流',0,0,0,'','','',0,1,1),
	(498,'timedg','万家通快递',0,0,0,'','','',0,1,1),
	(499,'tlky','天联快运',0,0,0,'','','',0,1,1),
	(500,'tmg','株式会社T.M.G',0,0,0,'','','',0,1,1),
	(501,'tongdaxing','通达兴物流',0,0,0,'','','',0,1,1),
	(502,'tonghetianxia','通和天下',0,0,0,'','','',0,1,1),
	(503,'ugoexpress','邮鸽速运',0,0,0,'','','',0,1,1),
	(504,'uluckex','优联吉运',0,0,0,'','','',0,1,1),
	(505,'vps','维普恩物流',0,0,0,'','','',0,1,1),
	(506,'wanboex','万博快递',0,0,0,'','','',0,1,1),
	(507,'wandougongzhu','豌豆物流',0,0,0,'','','',0,1,1),
	(508,'wanjiatong','宁夏万家通',0,0,0,'','','',0,1,1),
	(509,'wdm','万达美',0,0,0,'','','',0,1,1),
	(510,'westwing','西翼物流',0,0,0,'','','',0,1,1),
	(511,'wexpress','威速递',0,0,0,'','','',0,1,1),
	(512,'winit','万邑通',0,0,0,'','','',0,1,1),
	(513,'wlfast','凡仕特物流',0,0,0,'','','',0,1,1),
	(514,'wowvip','沃埃家',0,0,0,'','','',0,1,1),
	(515,'wtdchina','威时沛运货运',0,0,0,'','','',0,1,1),
	(516,'wuliuky','五六快运',0,0,0,'','','',0,1,1),
	(517,'wuyuansudi','伍圆速递',0,0,0,'','','',0,1,1),
	(518,'xdshipping','国晶物流',0,0,0,'','','',0,1,1),
	(519,'xflt56','蓝天物流',0,0,0,'','','',0,1,1),
	(520,'xianchengliansudi','西安城联速递',0,0,0,'','','',0,1,1),
	(521,'xiangdawuliu','湘达物流',0,0,0,'','','',0,1,1),
	(522,'xianglongyuntong','祥龙运通物流',0,0,0,'','','',0,1,1),
	(523,'xilaikd','西安喜来快递',0,0,0,'','','',0,1,1),
	(524,'xingyuankuaidi','新元快递',0,0,0,'','','',0,1,1),
	(525,'xinning','新宁物流',0,0,0,'','','',0,1,1),
	(526,'xsrd','鑫世锐达',0,0,0,'','','',0,1,1),
	(527,'xtb','鑫通宝物流',0,0,0,'','','',0,1,1),
	(528,'xyd666','鑫远东速运',0,0,0,'','','',0,1,1),
	(529,'yatfai','一辉物流',0,0,0,'','','',0,1,1),
	(530,'ycgky','远成快运',0,0,0,'','','',0,1,1),
	(531,'ydglobe','云达通',0,0,0,'','','',0,1,1),
	(532,'ydhex','YDH',0,0,0,'','','',0,1,1),
	(533,'yhtlogistics','宇航通物流',0,0,0,'','','',0,1,1),
	(534,'yibangwuliu','一邦速递',0,0,0,'','','',0,1,1),
	(535,'yidihui','驿递汇速递',0,0,0,'','','',0,1,1),
	(536,'yiex','宜送物流',0,0,0,'','','',0,1,1),
	(537,'yifankd','艺凡快递',0,0,0,'','','',0,1,1),
	(538,'yihangmall','易航物流',0,0,0,'','','',0,1,1),
	(539,'yilingsuyun','亿领速运',0,0,0,'','','',0,1,1),
	(540,'yinjiesudi','银捷速递',0,0,0,'','','',0,1,1),
	(541,'yiqisong','一起送',0,0,0,'','','',0,1,1),
	(542,'yisong','宜送',0,0,0,'','','',0,1,1),
	(543,'yitongda','易通达',0,0,0,'','','',0,1,1),
	(544,'yiyou','易邮速运',0,0,0,'','','',0,1,1),
	(545,'yjhgo','武汉优进汇',0,0,0,'','','',0,1,1),
	(546,'ynztsy','纵通速运',0,0,0,'','','',0,1,1),
	(547,'youjia','友家速递',0,0,0,'','','',0,1,1),
	(548,'youlai','邮来速递',0,0,0,'','','',0,1,1),
	(549,'ypsd','壹品速递',0,0,0,'','','',0,1,1),
	(550,'ytky168','运通快运',0,0,0,'','','',0,1,1),
	(551,'yuandun','远盾物流',0,0,0,'','','',0,1,1),
	(552,'yue777','玥玛速运',0,0,0,'','','',1,1,1),
	(553,'yufeng','御风速运',0,0,0,'','','',0,1,1),
	(554,'yujiawl','宇佳物流',0,0,0,'','','',0,1,1),
	(555,'yuntong','运通速运',0,0,0,'','','',0,1,1),
	(556,'yuntongkuaidi','运通中港',0,0,0,'','','',0,1,1),
	(557,'ywexpress','远为快递',0,0,0,'','','',0,1,1),
	(558,'yyexp','西安运逸快递',0,0,0,'','','',0,1,1),
	(559,'yyqc56','一运全成物流',0,0,0,'','','',0,1,1),
	(560,'zf365','珠峰速运',0,0,0,'','','',0,1,1),
	(561,'zhdwl','众辉达物流',0,0,0,'','','',0,1,1),
	(562,'zhitengwuliu','志腾物流',0,0,0,'','','',0,1,1),
	(563,'zhongtianwanyun','中天万运',0,0,0,'','','',0,1,1),
	(564,'zhongxinda','忠信达',0,0,0,'','','',0,1,1),
	(565,'zhpex','众派速递',0,0,0,'','','',0,1,1),
	(566,'zhuoshikuaiyun','卓实快运',0,0,0,'','','',0,1,1),
	(567,'zjcy56','创运物流',0,0,0,'','','',0,1,1),
	(568,'zsda56','转瞬达集运',0,0,0,'','','',0,1,1),
	(569,'zsky123','准实快运',0,0,0,'','','',0,1,1),
	(570,'zsmhwl','明辉物流',0,0,0,'','','',0,1,1),
	(571,'zy100','中远快运',0,0,0,'','','',0,1,1);

/*!40000 ALTER TABLE `eb_express` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_shipping_templates
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_shipping_templates`;

CREATE TABLE `eb_shipping_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `name` varchar(255) NOT NULL COMMENT '模板名称',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '计费方式',
  `appoint` tinyint(1) NOT NULL DEFAULT '0' COMMENT '指定包邮',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='运费模板';

LOCK TABLES `eb_shipping_templates` WRITE;
/*!40000 ALTER TABLE `eb_shipping_templates` DISABLE KEYS */;

INSERT INTO `eb_shipping_templates` (`id`, `name`, `type`, `appoint`, `sort`, `create_time`, `update_time`)
VALUES
	(1,'包邮',1,0,0,'2020-12-07 17:28:39','2020-12-07 17:28:39'),
	(2,'全国包邮',1,0,0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(3,'1，10，1，5',1,0,0,'2020-12-23 10:05:45','2020-12-23 10:05:45');

/*!40000 ALTER TABLE `eb_shipping_templates` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_shipping_templates_free
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_shipping_templates_free`;

CREATE TABLE `eb_shipping_templates_free` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `temp_id` int(11) NOT NULL DEFAULT '0' COMMENT '模板ID',
  `city_id` int(11) NOT NULL DEFAULT '0' COMMENT '城市ID',
  `title` text COMMENT '描述',
  `number` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '包邮件数',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '包邮金额',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '计费方式',
  `uniqid` varchar(32) NOT NULL DEFAULT '' COMMENT '分组唯一值',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否无效',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='运费模板包邮';



# Dump of table eb_shipping_templates_region
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_shipping_templates_region`;

CREATE TABLE `eb_shipping_templates_region` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `temp_id` int(11) NOT NULL DEFAULT '0' COMMENT '模板ID',
  `city_id` int(11) NOT NULL DEFAULT '0' COMMENT '城市ID',
  `title` text COMMENT '描述',
  `first` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '首件',
  `first_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '首件运费',
  `renewal` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '续件',
  `renewal_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '续件运费',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '计费方式 1按件数 2按重量 3按体积',
  `uniqid` varchar(32) NOT NULL DEFAULT '' COMMENT '分组唯一值',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否无效',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='运费模板指定区域费用';

LOCK TABLES `eb_shipping_templates_region` WRITE;
/*!40000 ALTER TABLE `eb_shipping_templates_region` DISABLE KEYS */;

INSERT INTO `eb_shipping_templates_region` (`id`, `temp_id`, `city_id`, `title`, `first`, `first_price`, `renewal`, `renewal_price`, `type`, `uniqid`, `status`, `create_time`, `update_time`)
VALUES
	(370,1,2,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(371,1,7363,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(372,1,13268,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(373,1,18128,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(374,1,24371,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(375,1,26779,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(376,1,32688,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(377,1,38160,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(378,1,44570,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(379,1,49190,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(380,1,52018,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(381,1,58247,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(382,1,61804,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(383,1,66813,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(384,1,67748,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(385,1,69390,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(386,1,71850,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(387,1,72975,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(388,1,76726,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(389,1,79163,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(390,1,81000,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(391,1,84092,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(392,1,87613,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(393,1,92738,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(394,1,96064,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(395,1,99538,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(396,1,100904,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(397,1,101772,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(398,1,101884,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(399,1,104457,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(400,1,107065,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(401,1,108166,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(402,1,109847,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(403,1,110889,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(404,1,112552,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(405,1,113777,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(406,1,114940,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(407,1,115225,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(408,1,117932,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(409,1,119789,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(410,1,121081,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(411,1,122142,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(412,1,122730,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(413,1,123698,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(414,1,125249,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(415,1,126156,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(416,1,127070,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(417,1,127834,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(418,1,128421,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(419,1,129977,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(420,1,131738,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(421,1,133209,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(422,1,135392,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(423,1,137206,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(424,1,138721,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(425,1,139340,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(426,1,140601,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(427,1,141361,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(428,1,142786,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(429,1,143990,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(430,1,145666,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(431,1,149079,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(432,1,150915,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(433,1,151830,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(434,1,152413,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(435,1,153313,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(436,1,154201,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(437,1,155076,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(438,1,156713,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(439,1,157130,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(440,1,158623,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(441,1,159769,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(442,1,161651,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(443,1,161793,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(444,1,167905,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(445,1,169375,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(446,1,170724,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(447,1,173635,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(448,1,174764,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(449,1,176920,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(450,1,178999,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(451,1,180743,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(452,1,182538,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(453,1,185201,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(454,1,186657,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(455,1,187441,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(456,1,189402,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(457,1,191020,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(458,1,194395,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(459,1,197850,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(460,1,203852,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(461,1,205101,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(462,1,206438,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(463,1,209250,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(464,1,214260,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(465,1,215955,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(466,1,216449,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(467,1,221610,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(468,1,224650,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(469,1,226469,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(470,1,227482,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(471,1,228630,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(472,1,229844,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(473,1,230476,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(474,1,230981,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(475,1,231499,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(476,1,233236,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(477,1,234109,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(478,1,235483,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(479,1,237607,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(480,1,239084,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(481,1,241180,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(482,1,242634,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(483,1,243399,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(484,1,244378,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(485,1,247478,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(486,1,248059,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(487,1,249098,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(488,1,251197,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(489,1,253905,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(490,1,256112,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(491,1,258160,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(492,1,260230,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(493,1,262699,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(494,1,264862,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(495,1,265677,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(496,1,266521,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(497,1,269107,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(498,1,269654,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(499,1,270222,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(500,1,274444,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(501,1,277615,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(502,1,280562,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(503,1,282841,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(504,1,285861,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(505,1,291235,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(506,1,298025,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(507,1,301711,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(508,1,304309,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(509,1,306339,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(510,1,313063,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(511,1,320179,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(512,1,326706,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(513,1,330547,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(514,1,333140,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(515,1,336050,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(516,1,337144,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(517,1,344133,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(518,1,349382,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(519,1,355972,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(520,1,361375,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(521,1,367396,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(522,1,370304,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(523,1,372971,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(524,1,376365,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(525,1,379245,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(526,1,382878,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(527,1,383890,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(528,1,387707,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(529,1,389719,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(530,1,392737,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(531,1,395254,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(532,1,396611,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(533,1,398169,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(534,1,403311,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(535,1,408287,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(536,1,411925,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(537,1,417174,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(538,1,420258,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(539,1,420825,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(540,1,424449,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(541,1,425508,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(542,1,427710,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(543,1,429501,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(544,1,432415,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(545,1,432829,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(546,1,434548,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(547,1,437779,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(548,1,440639,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(549,1,445040,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(550,1,446212,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(551,1,447268,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(552,1,449865,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(553,1,452124,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(554,1,453799,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(555,1,455283,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(556,1,456303,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(557,1,459251,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(558,1,463141,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(559,1,465105,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(560,1,467562,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(561,1,468660,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(562,1,470123,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(563,1,472709,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(564,1,476148,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(565,1,479103,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(566,1,481319,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(567,1,483251,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(568,1,486129,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(569,1,487721,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(570,1,488589,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:50','2020-12-14 17:02:52'),
	(571,1,488954,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(572,1,490106,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(573,1,490919,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(574,1,492341,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(575,1,494394,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(576,1,496438,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(577,1,498104,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(578,1,499489,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(579,1,501867,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(580,1,502828,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(581,1,504366,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(582,1,505298,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(583,1,506616,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(584,1,507255,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(585,1,507557,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(586,1,508648,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(587,1,510408,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(588,1,511463,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(589,1,513434,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(590,1,514790,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(591,1,516858,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(592,1,517933,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(593,1,518407,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(594,1,518808,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(595,1,519929,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(596,1,521166,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(597,1,522786,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(598,1,524814,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(599,1,525638,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(600,1,527443,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(601,1,528339,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(602,1,529345,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(603,1,529878,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(604,1,530060,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(605,1,530070,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(606,1,530468,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(607,1,533329,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(608,1,540700,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(609,1,545533,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(610,1,550275,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(611,1,551809,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(612,1,552358,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(613,1,554142,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(614,1,556077,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(615,1,560191,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(616,1,563242,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(617,1,565735,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(618,1,568202,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(619,1,570733,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(620,1,576992,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(621,1,578485,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(622,1,581870,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(623,1,585049,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(624,1,588538,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(625,1,589779,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(626,1,592598,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(627,1,594864,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(628,1,596525,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(629,1,599659,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(630,1,604132,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(631,1,605834,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(632,1,607029,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(633,1,609309,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(634,1,610607,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(635,1,614530,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(636,1,617670,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(637,1,619017,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(638,1,622734,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(639,1,624373,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(640,1,626181,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(641,1,627981,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(642,1,628776,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(643,1,629781,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(644,1,631276,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(645,1,631811,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(646,1,632971,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(647,1,634006,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(648,1,635219,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(649,1,636688,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(650,1,637778,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(651,1,638092,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(652,1,639368,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(653,1,639802,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(654,1,640107,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(655,1,640333,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(656,1,640675,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(657,1,642571,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(658,1,643863,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(659,1,644423,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(660,1,645076,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(661,1,646392,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(662,1,646579,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(663,1,649979,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(664,1,650575,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(665,1,652581,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(666,1,655295,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(667,1,657848,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(668,1,660643,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(669,1,663046,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(670,1,667681,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(671,1,669707,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(672,1,671120,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(673,1,672330,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(674,1,672385,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(675,1,672577,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(676,1,673463,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(677,1,676215,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(678,1,677568,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(679,1,678560,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(680,1,680191,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(681,1,680815,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(682,1,682322,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(683,1,684415,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(684,1,687916,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(685,1,689265,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(686,1,690095,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(687,1,691278,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(688,1,693040,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(689,1,693342,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(690,1,693672,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(691,1,694220,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(692,1,694478,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(693,1,694846,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(694,1,695260,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(695,1,695883,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(696,1,696252,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(697,1,696928,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(698,1,697887,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(699,1,698441,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(700,1,699583,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(701,1,699773,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(702,1,700070,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(703,1,700489,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(704,1,701559,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(705,1,702104,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(706,1,703119,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(707,1,704779,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(708,1,705145,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(709,1,708117,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(710,1,709792,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(711,1,711218,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(712,1,712893,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(713,1,713697,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(714,1,714402,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(715,1,717531,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(716,1,719868,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(717,1,720118,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(718,1,722024,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(719,1,725488,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(720,1,727730,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(721,1,729928,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(722,1,730843,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(723,1,734179,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(724,1,736051,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(725,1,737856,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(726,1,737861,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(727,1,739957,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(728,1,740510,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(729,1,742126,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(730,1,742636,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(731,1,743938,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(732,1,745674,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(733,1,748553,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(734,1,749571,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(735,1,749930,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(736,1,749957,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(737,1,752150,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(738,1,752169,'[[0,0]]',1.00,0.00,1.00,1.00,1,'9f57fce7c4b6b91ce7f060d97be252b5',1,'2020-12-14 17:02:51','2020-12-14 17:02:52'),
	(739,2,2,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(740,2,7363,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(741,2,13268,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(742,2,18128,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(743,2,24371,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(744,2,26779,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(745,2,32688,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(746,2,38160,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(747,2,44570,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(748,2,49190,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(749,2,52018,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(750,2,58247,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(751,2,61804,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(752,2,66813,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(753,2,67748,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(754,2,69390,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(755,2,71850,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(756,2,72975,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(757,2,76726,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(758,2,79163,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(759,2,81000,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(760,2,84092,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(761,2,87613,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(762,2,92738,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(763,2,96064,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(764,2,99538,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(765,2,100904,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(766,2,101772,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(767,2,101884,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(768,2,104457,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(769,2,107065,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(770,2,108166,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(771,2,109847,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(772,2,110889,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(773,2,112552,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(774,2,113777,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(775,2,114940,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(776,2,115225,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(777,2,117932,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(778,2,119789,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(779,2,121081,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(780,2,122142,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(781,2,122730,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(782,2,123698,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(783,2,125249,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(784,2,126156,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(785,2,127070,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(786,2,127834,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(787,2,128421,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(788,2,129977,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(789,2,131738,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(790,2,133209,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(791,2,135392,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(792,2,137206,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(793,2,138721,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(794,2,139340,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(795,2,140601,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(796,2,141361,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(797,2,142786,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(798,2,143990,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(799,2,145666,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(800,2,149079,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(801,2,150915,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(802,2,151830,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(803,2,152413,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(804,2,153313,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(805,2,154201,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(806,2,155076,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(807,2,156713,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(808,2,157130,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(809,2,158623,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(810,2,159769,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(811,2,161651,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(812,2,161793,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(813,2,167905,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(814,2,169375,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(815,2,170724,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(816,2,173635,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(817,2,174764,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(818,2,176920,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(819,2,178999,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(820,2,180743,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(821,2,182538,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(822,2,185201,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(823,2,186657,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(824,2,187441,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(825,2,189402,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(826,2,191020,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(827,2,194395,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(828,2,197850,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(829,2,203852,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(830,2,205101,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(831,2,206438,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(832,2,209250,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(833,2,214260,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(834,2,215955,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(835,2,216449,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:18','2020-12-14 17:05:18'),
	(836,2,221610,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(837,2,224650,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(838,2,226469,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(839,2,227482,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(840,2,228630,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(841,2,229844,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(842,2,230476,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(843,2,230981,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(844,2,231499,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(845,2,233236,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(846,2,234109,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(847,2,235483,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(848,2,237607,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(849,2,239084,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(850,2,241180,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(851,2,242634,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(852,2,243399,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(853,2,244378,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(854,2,247478,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(855,2,248059,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(856,2,249098,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(857,2,251197,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(858,2,253905,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(859,2,256112,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(860,2,258160,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(861,2,260230,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(862,2,262699,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(863,2,264862,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(864,2,265677,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(865,2,266521,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(866,2,269107,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(867,2,269654,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(868,2,270222,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(869,2,274444,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(870,2,277615,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(871,2,280562,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(872,2,282841,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(873,2,285861,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(874,2,291235,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(875,2,298025,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(876,2,301711,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(877,2,304309,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(878,2,306339,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(879,2,313063,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(880,2,320179,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(881,2,326706,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(882,2,330547,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(883,2,333140,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(884,2,336050,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(885,2,337144,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(886,2,344133,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(887,2,349382,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(888,2,355972,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(889,2,361375,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(890,2,367396,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(891,2,370304,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(892,2,372971,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(893,2,376365,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(894,2,379245,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(895,2,382878,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(896,2,383890,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(897,2,387707,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(898,2,389719,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(899,2,392737,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(900,2,395254,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(901,2,396611,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(902,2,398169,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(903,2,403311,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(904,2,408287,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(905,2,411925,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(906,2,417174,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(907,2,420258,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(908,2,420825,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(909,2,424449,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(910,2,425508,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(911,2,427710,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(912,2,429501,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(913,2,432415,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(914,2,432829,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(915,2,434548,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(916,2,437779,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(917,2,440639,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(918,2,445040,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(919,2,446212,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(920,2,447268,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(921,2,449865,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(922,2,452124,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(923,2,453799,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(924,2,455283,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(925,2,456303,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(926,2,459251,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(927,2,463141,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(928,2,465105,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(929,2,467562,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(930,2,468660,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(931,2,470123,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(932,2,472709,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(933,2,476148,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(934,2,479103,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(935,2,481319,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(936,2,483251,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(937,2,486129,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(938,2,487721,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(939,2,488589,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(940,2,488954,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(941,2,490106,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(942,2,490919,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(943,2,492341,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(944,2,494394,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(945,2,496438,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(946,2,498104,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(947,2,499489,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(948,2,501867,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(949,2,502828,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(950,2,504366,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(951,2,505298,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(952,2,506616,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(953,2,507255,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(954,2,507557,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(955,2,508648,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(956,2,510408,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(957,2,511463,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(958,2,513434,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(959,2,514790,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(960,2,516858,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(961,2,517933,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(962,2,518407,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(963,2,518808,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(964,2,519929,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(965,2,521166,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(966,2,522786,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(967,2,524814,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(968,2,525638,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(969,2,527443,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(970,2,528339,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(971,2,529345,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(972,2,529878,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(973,2,530060,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(974,2,530070,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(975,2,530468,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(976,2,533329,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(977,2,540700,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(978,2,545533,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(979,2,550275,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(980,2,551809,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(981,2,552358,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(982,2,554142,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(983,2,556077,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(984,2,560191,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(985,2,563242,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(986,2,565735,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(987,2,568202,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(988,2,570733,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(989,2,576992,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(990,2,578485,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(991,2,581870,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(992,2,585049,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(993,2,588538,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(994,2,589779,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(995,2,592598,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(996,2,594864,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(997,2,596525,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(998,2,599659,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(999,2,604132,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1000,2,605834,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1001,2,607029,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1002,2,609309,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1003,2,610607,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1004,2,614530,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1005,2,617670,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1006,2,619017,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1007,2,622734,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1008,2,624373,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1009,2,626181,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1010,2,627981,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1011,2,628776,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1012,2,629781,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1013,2,631276,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1014,2,631811,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1015,2,632971,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1016,2,634006,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1017,2,635219,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1018,2,636688,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1019,2,637778,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1020,2,638092,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1021,2,639368,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1022,2,639802,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1023,2,640107,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1024,2,640333,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1025,2,640675,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1026,2,642571,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1027,2,643863,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1028,2,644423,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1029,2,645076,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1030,2,646392,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1031,2,646579,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1032,2,649979,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1033,2,650575,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1034,2,652581,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1035,2,655295,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1036,2,657848,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1037,2,660643,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1038,2,663046,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1039,2,667681,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1040,2,669707,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1041,2,671120,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1042,2,672330,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1043,2,672385,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1044,2,672577,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1045,2,673463,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1046,2,676215,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1047,2,677568,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1048,2,678560,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1049,2,680191,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1050,2,680815,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1051,2,682322,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1052,2,684415,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1053,2,687916,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1054,2,689265,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1055,2,690095,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1056,2,691278,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1057,2,693040,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1058,2,693342,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1059,2,693672,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1060,2,694220,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1061,2,694478,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1062,2,694846,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1063,2,695260,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1064,2,695883,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1065,2,696252,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1066,2,696928,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1067,2,697887,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1068,2,698441,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1069,2,699583,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1070,2,699773,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1071,2,700070,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1072,2,700489,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1073,2,701559,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1074,2,702104,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1075,2,703119,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1076,2,704779,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1077,2,705145,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1078,2,708117,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1079,2,709792,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1080,2,711218,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1081,2,712893,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1082,2,713697,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1083,2,714402,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1084,2,717531,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1085,2,719868,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:19','2020-12-14 17:05:19'),
	(1086,2,720118,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1087,2,722024,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1088,2,725488,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1089,2,727730,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1090,2,729928,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1091,2,730843,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1092,2,734179,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1093,2,736051,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1094,2,737856,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1095,2,737861,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1096,2,739957,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1097,2,740510,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1098,2,742126,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1099,2,742636,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1100,2,743938,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1101,2,745674,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1102,2,748553,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1103,2,749571,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1104,2,749930,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1105,2,749957,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1106,2,752150,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1107,2,752169,'[[0,0]]',1.00,0.00,1.00,0.00,1,'6d45fa7e976159f3b44629a8b2f8ce71',0,'2020-12-14 17:05:20','2020-12-14 17:05:20'),
	(1108,3,2,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1109,3,7363,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1110,3,13268,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1111,3,18128,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1112,3,24371,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1113,3,26779,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1114,3,32688,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1115,3,38160,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1116,3,44570,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1117,3,49190,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1118,3,52018,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1119,3,58247,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1120,3,61804,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1121,3,66813,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1122,3,67748,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1123,3,69390,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1124,3,71850,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1125,3,72975,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1126,3,76726,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1127,3,79163,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1128,3,81000,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1129,3,84092,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1130,3,87613,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1131,3,92738,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1132,3,96064,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1133,3,99538,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1134,3,100904,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1135,3,101772,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1136,3,101884,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1137,3,104457,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1138,3,107065,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1139,3,108166,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1140,3,109847,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1141,3,110889,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1142,3,112552,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1143,3,113777,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1144,3,114940,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1145,3,115225,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1146,3,117932,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1147,3,119789,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1148,3,121081,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1149,3,122142,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1150,3,122730,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1151,3,123698,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1152,3,125249,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1153,3,126156,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1154,3,127070,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1155,3,127834,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1156,3,128421,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1157,3,129977,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1158,3,131738,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1159,3,133209,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1160,3,135392,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1161,3,137206,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1162,3,138721,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1163,3,139340,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1164,3,140601,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1165,3,141361,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1166,3,142786,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1167,3,143990,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1168,3,145666,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1169,3,149079,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1170,3,150915,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1171,3,151830,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1172,3,152413,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1173,3,153313,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1174,3,154201,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1175,3,155076,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1176,3,156713,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1177,3,157130,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1178,3,158623,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1179,3,159769,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1180,3,161651,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1181,3,161793,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1182,3,167905,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1183,3,169375,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1184,3,170724,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1185,3,173635,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1186,3,174764,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1187,3,176920,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1188,3,178999,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1189,3,180743,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1190,3,182538,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1191,3,185201,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1192,3,186657,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1193,3,187441,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1194,3,189402,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1195,3,191020,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1196,3,194395,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1197,3,197850,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1198,3,203852,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1199,3,205101,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1200,3,206438,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1201,3,209250,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1202,3,214260,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1203,3,215955,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1204,3,216449,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1205,3,221610,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1206,3,224650,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1207,3,226469,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1208,3,227482,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1209,3,228630,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1210,3,229844,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1211,3,230476,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1212,3,230981,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:45','2020-12-23 10:05:45'),
	(1213,3,231499,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1214,3,233236,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1215,3,234109,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1216,3,235483,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1217,3,237607,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1218,3,239084,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1219,3,241180,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1220,3,242634,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1221,3,243399,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1222,3,244378,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1223,3,247478,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1224,3,248059,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1225,3,249098,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1226,3,251197,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1227,3,253905,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1228,3,256112,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1229,3,258160,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1230,3,260230,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1231,3,262699,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1232,3,264862,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1233,3,265677,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1234,3,266521,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1235,3,269107,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1236,3,269654,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1237,3,270222,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1238,3,274444,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1239,3,277615,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1240,3,280562,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1241,3,282841,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1242,3,285861,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1243,3,291235,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1244,3,298025,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1245,3,301711,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1246,3,304309,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1247,3,306339,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1248,3,313063,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1249,3,320179,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1250,3,326706,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1251,3,330547,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1252,3,333140,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1253,3,336050,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1254,3,337144,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1255,3,344133,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1256,3,349382,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1257,3,355972,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1258,3,361375,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1259,3,367396,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1260,3,370304,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1261,3,372971,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1262,3,376365,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1263,3,379245,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1264,3,382878,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1265,3,383890,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1266,3,387707,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1267,3,389719,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1268,3,392737,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1269,3,395254,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1270,3,396611,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1271,3,398169,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1272,3,403311,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1273,3,408287,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1274,3,411925,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1275,3,417174,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1276,3,420258,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1277,3,420825,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1278,3,424449,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1279,3,425508,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1280,3,427710,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1281,3,429501,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1282,3,432415,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1283,3,432829,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1284,3,434548,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1285,3,437779,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1286,3,440639,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1287,3,445040,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1288,3,446212,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1289,3,447268,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1290,3,449865,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1291,3,452124,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1292,3,453799,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1293,3,455283,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1294,3,456303,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1295,3,459251,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1296,3,463141,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1297,3,465105,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1298,3,467562,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1299,3,468660,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1300,3,470123,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1301,3,472709,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1302,3,476148,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1303,3,479103,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1304,3,481319,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1305,3,483251,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1306,3,486129,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1307,3,487721,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1308,3,488589,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1309,3,488954,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1310,3,490106,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1311,3,490919,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1312,3,492341,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1313,3,494394,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1314,3,496438,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1315,3,498104,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1316,3,499489,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1317,3,501867,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1318,3,502828,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1319,3,504366,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1320,3,505298,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1321,3,506616,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1322,3,507255,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1323,3,507557,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1324,3,508648,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1325,3,510408,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1326,3,511463,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1327,3,513434,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1328,3,514790,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1329,3,516858,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1330,3,517933,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1331,3,518407,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1332,3,518808,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1333,3,519929,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1334,3,521166,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1335,3,522786,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1336,3,524814,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1337,3,525638,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1338,3,527443,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1339,3,528339,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1340,3,529345,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1341,3,529878,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1342,3,530060,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1343,3,530070,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1344,3,530468,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1345,3,533329,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1346,3,540700,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1347,3,545533,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1348,3,550275,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1349,3,551809,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1350,3,552358,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1351,3,554142,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1352,3,556077,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1353,3,560191,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1354,3,563242,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1355,3,565735,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1356,3,568202,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1357,3,570733,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1358,3,576992,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1359,3,578485,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1360,3,581870,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1361,3,585049,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1362,3,588538,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1363,3,589779,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1364,3,592598,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1365,3,594864,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1366,3,596525,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1367,3,599659,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1368,3,604132,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1369,3,605834,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1370,3,607029,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1371,3,609309,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1372,3,610607,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1373,3,614530,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1374,3,617670,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1375,3,619017,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1376,3,622734,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1377,3,624373,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1378,3,626181,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1379,3,627981,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1380,3,628776,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1381,3,629781,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1382,3,631276,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1383,3,631811,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1384,3,632971,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1385,3,634006,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1386,3,635219,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1387,3,636688,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1388,3,637778,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1389,3,638092,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1390,3,639368,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1391,3,639802,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1392,3,640107,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1393,3,640333,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1394,3,640675,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1395,3,642571,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1396,3,643863,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1397,3,644423,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1398,3,645076,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1399,3,646392,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1400,3,646579,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1401,3,649979,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1402,3,650575,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1403,3,652581,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1404,3,655295,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1405,3,657848,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1406,3,660643,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1407,3,663046,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1408,3,667681,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1409,3,669707,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1410,3,671120,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1411,3,672330,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1412,3,672385,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1413,3,672577,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1414,3,673463,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1415,3,676215,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1416,3,677568,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1417,3,678560,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1418,3,680191,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1419,3,680815,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1420,3,682322,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1421,3,684415,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1422,3,687916,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1423,3,689265,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1424,3,690095,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1425,3,691278,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1426,3,693040,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1427,3,693342,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1428,3,693672,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1429,3,694220,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1430,3,694478,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1431,3,694846,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1432,3,695260,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1433,3,695883,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1434,3,696252,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1435,3,696928,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1436,3,697887,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1437,3,698441,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1438,3,699583,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1439,3,699773,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1440,3,700070,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1441,3,700489,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1442,3,701559,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1443,3,702104,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1444,3,703119,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1445,3,704779,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1446,3,705145,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1447,3,708117,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1448,3,709792,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1449,3,711218,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1450,3,712893,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1451,3,713697,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1452,3,714402,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1453,3,717531,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1454,3,719868,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1455,3,720118,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1456,3,722024,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1457,3,725488,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1458,3,727730,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1459,3,729928,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1460,3,730843,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:46','2020-12-23 10:05:46'),
	(1461,3,734179,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1462,3,736051,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1463,3,737856,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1464,3,737861,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1465,3,739957,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1466,3,740510,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1467,3,742126,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1468,3,742636,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1469,3,743938,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1470,3,745674,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1471,3,748553,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1472,3,749571,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1473,3,749930,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1474,3,749957,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1475,3,752150,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47'),
	(1476,3,752169,'[[0,0]]',1.00,10.00,1.00,5.00,1,'219eff58625d2d16ae1ea99c821bfe38',0,'2020-12-23 10:05:47','2020-12-23 10:05:47');

/*!40000 ALTER TABLE `eb_shipping_templates_region` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_sms_record
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_sms_record`;

CREATE TABLE `eb_sms_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '短信发送记录编号',
  `uid` varchar(255) NOT NULL COMMENT '短信平台账号',
  `phone` char(11) NOT NULL COMMENT '接受短信的手机号',
  `content` text COMMENT '短信内容',
  `add_ip` varchar(30) DEFAULT NULL COMMENT '添加记录ip',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `template` varchar(255) DEFAULT '' COMMENT '短信模板ID',
  `resultcode` int(6) unsigned DEFAULT NULL COMMENT '状态码 100=成功,130=失败,131=空号,132=停机,133=关机,134=无状态',
  `record_id` int(11) unsigned DEFAULT NULL COMMENT '发送记录id',
  `memo` text COMMENT '短信平台返回信息',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='短信发送记录表';

LOCK TABLES `eb_sms_record` WRITE;
/*!40000 ALTER TABLE `eb_sms_record` DISABLE KEYS */;

INSERT INTO `eb_sms_record` (`id`, `uid`, `phone`, `content`, `add_ip`, `create_time`, `template`, `resultcode`, `record_id`, `memo`)
VALUES
	(1,'tangkai','13148369181','','','2020-08-28 11:40:47','518076',400,0,'黑名单:号码一天重复提交过多'),
	(2,'tangkai','13148369181',NULL,'','2020-08-28 12:00:26','518076',400,0,'黑名单:号码一天重复提交过多'),
	(3,'tangkai','18838971183',NULL,'','2020-08-28 12:00:26','518076',400,0,'黑名单:号码一天重复提交过多'),
	(4,'tangkai','18838971183',NULL,'','2020-08-28 12:00:27','518076',400,0,'黑名单:号码一天重复提交过多'),
	(5,'tangkai','15827579751',NULL,'','2020-08-28 12:00:27','518076',400,0,'黑名单:号码一天重复提交过多'),
	(6,'tangkai','18292417675','【CRMEB】您的验证码是：974706，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 14:09:19','518076',200,1768913,'发送成功'),
	(7,'tangkai','18292417675','【CRMEB】您的验证码是：867348，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 14:11:53','518076',200,1768924,'发送成功'),
	(8,'tangkai','18292417675','【CRMEB】您的验证码是：563940，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 14:31:04','518076',200,1768981,'发送成功'),
	(9,'tangkai','18292417675','【CRMEB】您的验证码是：644422，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 14:41:02','518076',200,1769031,'发送成功'),
	(10,'tangkai','18292417675','【CRMEB】您的验证码是：405277，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 15:12:13','518076',200,1769149,'发送成功'),
	(11,'tangkai','18991352728','【CRMEB】您的验证码是：767022，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 15:12:14','518076',200,1769150,'发送成功'),
	(12,'tangkai','18991352728','【CRMEB】您的验证码是：976966，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 15:26:19','518076',NULL,1769177,'发送成功'),
	(13,'tangkai','18292417675','【CRMEB】您的验证码是：695966，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 15:26:22','518076',NULL,1769179,'发送成功'),
	(14,'tangkai','18292417675','【CRMEB】您的验证码是：313185，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-28 15:32:33','518076',100,1769200,'发送成功'),
	(15,'tangkai','18160744473','【CRMEB】您的验证码是：485703，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-31 17:30:35','518076',200,9059,'ok'),
	(16,'tangkai','13663765325','【CRMEB】您的验证码是：828620，有效期为1分钟。如非本人操作，可不用理会。','','2020-08-31 18:18:04','518076',200,9251,'ok'),
	(17,'tangkai','18559645067','【CRMEB】您的验证码是：251699，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-01 14:05:41','518076',200,11161,'ok'),
	(18,'tangkai','13008426948','【CRMEB】您的验证码是：543720，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-01 15:02:20','518076',200,11339,'ok'),
	(19,'tangkai','13017670582','【CRMEB】您的验证码是：877091，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-02 11:53:15','518076',200,14747,'ok'),
	(20,'tangkai','18045121009','【CRMEB】您的验证码是：754399，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-02 14:04:36','518076',200,15732,'ok'),
	(21,'tangkai','17769822165','【CRMEB】您的验证码是：996088，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-02 14:05:26','518076',200,15734,'ok'),
	(22,'tangkai','19901751521','【CRMEB】您的验证码是：271329，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 09:49:01','518076',200,18045,'ok'),
	(23,'tangkai','18991352728','【CRMEB】您的验证码是：204923，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 10:48:16','518076',200,18294,'ok'),
	(24,'tangkai','15605995727','【CRMEB】您的验证码是：792269，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 14:11:27','518076',200,18873,'ok'),
	(25,'tangkai','15163893976','【CRMEB】您的验证码是：210830，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 14:27:43','518076',200,18944,'ok'),
	(26,'tangkai','13265534579','【CRMEB】您的验证码是：663266，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 22:47:12','518076',200,20580,'ok'),
	(27,'tangkai','13265534579','【CRMEB】您的验证码是：651410，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 22:48:07','518076',200,20581,'ok'),
	(28,'tangkai','13265534579','【CRMEB】您的验证码是：803344，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-03 22:55:12','518076',200,20590,'ok'),
	(29,'tangkai','15558117521','【CRMEB】您的验证码是：569520，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-04 14:34:52','518076',200,22094,'ok'),
	(30,'tangkai','18256504106','【CRMEB】您的验证码是：891492，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-04 14:49:17','518076',200,22139,'ok'),
	(31,'tangkai','13113133932','【CRMEB】您的验证码是：344928，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-06 20:50:13','518076',200,30019,'ok'),
	(32,'tangkai','18381419318','【CRMEB】您的验证码是：191368，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-07 00:23:05','518076',200,30553,'ok'),
	(33,'tangkai','18566660230','【CRMEB】您的验证码是：647855，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-08 00:16:12','518076',200,34876,'ok'),
	(34,'tangkai','15941724722','【CRMEB】您的验证码是：502252，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-08 10:03:12','518076',200,35358,'ok'),
	(35,'tangkai','13309212766','【CRMEB】您的验证码是：125909，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-10 14:27:03','518076',200,46106,'ok'),
	(36,'tangkai','13309212766','【CRMEB】您的验证码是：127087，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-10 14:33:53','518076',200,46137,'ok'),
	(37,'tangkai','13720673941','【CRMEB】您的验证码是：787704，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 11:04:17','518076',200,49847,'ok'),
	(38,'tangkai','13720673941','【CRMEB】您的验证码是：883233，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 11:06:07','518076',200,49857,'ok'),
	(39,'tangkai','13720673941','【CRMEB】您的验证码是：274437，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 11:09:12','518076',200,49877,'ok'),
	(40,'tangkai','13309212766','【CRMEB】您的验证码是：187118，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 11:34:28','518076',200,49987,'ok'),
	(41,'tangkai','13309212766','【CRMEB】您的验证码是：722920，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 11:53:30','518076',200,50075,'ok'),
	(42,'tangkai','13309212766','【CRMEB】您的验证码是：833605，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 14:02:16','518076',200,50597,'ok'),
	(43,'tangkai','13309212766','【CRMEB】您的验证码是：870649，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 14:50:23','518076',200,50831,'ok'),
	(44,'tangkai','13309212766','【CRMEB】您的验证码是：660619，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 16:10:54','518076',200,51282,'ok'),
	(45,'tangkai','13309212766','【CRMEB】您的验证码是：961942，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 18:08:48','518076',200,51953,'ok'),
	(46,'tangkai','13720673941','【CRMEB】您的验证码是：693282，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 18:56:53','518076',200,52309,'ok'),
	(47,'tangkai','13720673941','【CRMEB】您的验证码是：636458，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 18:59:03','518076',200,52327,'ok'),
	(48,'tangkai','13720673941','【CRMEB】您的验证码是：504494，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-11 19:17:24','518076',200,52527,'ok'),
	(49,'tangkai','13720673941','【CRMEB】您的验证码是：672439，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 09:04:10','518076',200,59694,'ok'),
	(50,'tangkai','13720673941','【CRMEB】您的验证码是：457069，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 09:18:44','518076',200,59833,'ok'),
	(51,'tangkai','13309212766','【CRMEB】您的验证码是：646213，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 09:39:35','518076',200,59999,'ok'),
	(52,'tangkai','13309212766','【CRMEB】您的验证码是：373480，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 09:52:00','518076',200,60093,'ok'),
	(53,'tangkai','13309212766','【CRMEB】您的验证码是：510064，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 09:58:35','518076',200,60147,'ok'),
	(54,'tangkai','13309212766','【CRMEB】您的验证码是：677318，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 10:54:50','518076',200,60482,'ok'),
	(55,'tangkai','13720673941','【CRMEB】您的验证码是：218498，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 11:28:30','518076',200,60701,'ok'),
	(56,'tangkai','13309212766','【CRMEB】您的验证码是：242621，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-12 18:18:26','518076',200,62641,'ok'),
	(57,'tangkai','13720673941','【CRMEB】您的验证码是：995280，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 09:56:31','518076',200,67436,'ok'),
	(58,'tangkai','13720673941','【CRMEB】您的验证码是：720034，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 10:00:01','518076',200,67456,'ok'),
	(59,'tangkai','13309212766','【CRMEB】您的验证码是：666148，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 11:59:05','518076',200,68029,'ok'),
	(60,'tangkai','18292417675','【CRMEB】您的验证码是：194129，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 14:18:18','518076',200,68544,'ok'),
	(61,'tangkai','18292417675','【CRMEB】您的验证码是：764261，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 14:19:21','518076',200,68547,'ok'),
	(62,'tangkai','18292417675','【CRMEB】您的验证码是：688509，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 14:21:45','518076',200,68557,'ok'),
	(63,'tangkai','18292417675','【CRMEB】您的验证码是：194292，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 14:57:44','518076',200,68690,'ok'),
	(64,'tangkai','18292417675','【CRMEB】您的验证码是：246846，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:13:40','518076',200,69232,'ok'),
	(65,'tangkai','18292417675','【CRMEB】您的验证码是：551812，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:14:25','518076',200,69236,'ok'),
	(66,'tangkai','18292417675','【CRMEB】您的验证码是：406573，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:15:20','518076',200,69242,'ok'),
	(67,'tangkai','18292417675','【CRMEB】您的验证码是：413763，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:16:26','518076',200,69254,'ok'),
	(68,'tangkai','18292417675','【CRMEB】您的验证码是：737340，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:18:31','518076',200,69268,'ok'),
	(69,'tangkai','18292417675','【CRMEB】您的验证码是：644387，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:18:50','518076',200,69272,'ok'),
	(70,'tangkai','18292417675','【CRMEB】您的验证码是：183682，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 17:20:56','518076',200,69282,'ok'),
	(71,'tangkai','13720673941','【CRMEB】您的验证码是：189800，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:00:16','518076',200,69663,'ok'),
	(72,'tangkai','13700000002','【CRMEB】您的验证码是：644556，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:10:19','518076',200,69711,'ok'),
	(73,'tangkai','13700000003','【CRMEB】您的验证码是：814686，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:13:14','518076',200,69720,'ok'),
	(74,'tangkai','13720673941','【CRMEB】您的验证码是：946396，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:17:15','518076',200,69732,'ok'),
	(75,'tangkai','13720673941','【CRMEB】您的验证码是：972160，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:19:19','518076',200,69737,'ok'),
	(76,'tangkai','13700000001','【CRMEB】您的验证码是：248321，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-14 19:51:56','518076',200,69862,'ok'),
	(77,'tangkai','13309212766','【CRMEB】您的验证码是：519939，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 09:48:50','518076',200,70961,'ok'),
	(78,'tangkai','13309212766','【CRMEB】您的验证码是：338536，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 09:49:58','518076',200,70966,'ok'),
	(79,'tangkai','13700000001','【CRMEB】您的验证码是：139655，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 10:00:27','518076',200,71004,'ok'),
	(80,'tangkai','13720673941','【CRMEB】您的验证码是：267684，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 10:34:52','518076',200,71162,'ok'),
	(81,'tangkai','13700000002','【CRMEB】您的验证码是：809276，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 10:41:17','518076',200,71210,'ok'),
	(82,'tangkai','15661508370','【CRMEB】您的验证码是：384523，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 14:37:18','518076',200,72296,'ok'),
	(83,'tangkai','13184560789','【CRMEB】您的验证码是：837699，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:46:46','518076',200,72695,'ok'),
	(84,'tangkai','13184560789','【CRMEB】您的验证码是：184963，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:46:50','518076',200,72696,'ok'),
	(85,'tangkai','13184560789','【CRMEB】您的验证码是：506478，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:47:30','518076',200,72706,'ok'),
	(86,'tangkai','13184560789','【CRMEB】您的验证码是：736146，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:00','518076',200,72716,'ok'),
	(87,'tangkai','13184560789','【CRMEB】您的验证码是：785172，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72717,'ok'),
	(88,'tangkai','13184560789','【CRMEB】您的验证码是：867450，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72718,'ok'),
	(89,'tangkai','13184560789','【CRMEB】您的验证码是：854281，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72719,'ok'),
	(90,'tangkai','13184560789','【CRMEB】您的验证码是：144427，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72720,'ok'),
	(91,'tangkai','13184560789','【CRMEB】您的验证码是：734511，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72721,'ok'),
	(92,'tangkai','13184560789','【CRMEB】您的验证码是：165676，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:01','518076',200,72722,'ok'),
	(93,'tangkai','13184560789','【CRMEB】您的验证码是：392193，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72723,'ok'),
	(94,'tangkai','13184560789','【CRMEB】您的验证码是：857505，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72724,'ok'),
	(95,'tangkai','13184560789','【CRMEB】您的验证码是：622349，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72725,'ok'),
	(96,'tangkai','13184560789','【CRMEB】您的验证码是：347833，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72726,'ok'),
	(97,'tangkai','13184560789','【CRMEB】您的验证码是：895722，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72727,'ok'),
	(98,'tangkai','13184560789','【CRMEB】您的验证码是：323586，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:02','518076',200,72729,'ok'),
	(99,'tangkai','13184560789','【CRMEB】您的验证码是：943357，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:03','518076',200,72731,'ok'),
	(100,'tangkai','13184560789','【CRMEB】您的验证码是：884220，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:06','518076',200,72741,'ok'),
	(101,'tangkai','13184560789','【CRMEB】您的验证码是：649157，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:06','518076',200,72742,'ok'),
	(102,'tangkai','13184560789','【CRMEB】您的验证码是：734925，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:06','518076',200,72743,'ok'),
	(103,'tangkai','13184560789','【CRMEB】您的验证码是：284661，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:07','518076',200,72744,'ok'),
	(104,'tangkai','13184560789','【CRMEB】您的验证码是：904448，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:07','518076',200,72745,'ok'),
	(105,'tangkai','13184560789','【CRMEB】您的验证码是：182636，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:08','518076',200,72746,'ok'),
	(106,'tangkai','13184560789','【CRMEB】您的验证码是：396399，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:08','518076',200,72748,'ok'),
	(107,'tangkai','13184560789','【CRMEB】您的验证码是：198321，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:48:08','518076',200,72750,'ok'),
	(108,'tangkai','13087851131','【CRMEB】您的验证码是：333445，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:51:55','518076',200,72771,'ok'),
	(109,'tangkai','13087851131','【CRMEB】您的验证码是：650353，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:00','518076',200,72774,'ok'),
	(110,'tangkai','13087851131','【CRMEB】您的验证码是：245741，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:01','518076',200,72775,'ok'),
	(111,'tangkai','13087851131','【CRMEB】您的验证码是：479831，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:01','518076',200,72776,'ok'),
	(112,'tangkai','13087851131','【CRMEB】您的验证码是：829694，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:01','518076',200,72777,'ok'),
	(113,'tangkai','13087851131','【CRMEB】您的验证码是：783356，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:01','518076',200,72779,'ok'),
	(114,'tangkai','13087851131','【CRMEB】您的验证码是：595729，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:10','518076',200,72780,'ok'),
	(115,'tangkai','13087851131','【CRMEB】您的验证码是：546176，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:52:11','518076',200,72781,'ok'),
	(116,'tangkai','18991352728','【CRMEB】您的验证码是：820810，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:55:30','518076',200,72793,'ok'),
	(117,'tangkai','18991352728','【CRMEB】您的验证码是：836750，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:55:35','518076',200,72794,'ok'),
	(118,'tangkai','13184560789','【CRMEB】您的验证码是：545282，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:56:05','518076',200,72801,'ok'),
	(119,'tangkai','13184560789','【CRMEB】您的验证码是：157750，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 15:58:45','518076',200,72816,'ok'),
	(120,'tangkai','18991352728','【CRMEB】您的验证码是：367321，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 17:36:24','518076',200,73324,'ok'),
	(121,'tangkai','13720673941','【CRMEB】您的验证码是：136380，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-15 19:31:23','518076',200,73760,'ok'),
	(122,'tangkai','17623551311','【CRMEB】您的验证码是：679222，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-16 16:49:00','518076',200,76305,'ok'),
	(123,'tangkai','18991352728','【CRMEB】您的验证码是：309254，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-17 16:16:42','518076',200,79694,'ok'),
	(124,'tangkai','17633657563','【CRMEB】您的验证码是：231381，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-17 21:58:58','518076',200,81311,'ok'),
	(125,'tangkai','19974870606','【CRMEB】您的验证码是：382149，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-17 22:49:03','518076',200,81488,'ok'),
	(126,'tangkai','18991352728','【CRMEB】您的验证码是：406151，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-18 10:13:36','518076',200,82368,'ok'),
	(127,'tangkai','19937853103','【CRMEB】您的验证码是：946916，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-18 10:45:56','518076',200,82491,'ok'),
	(128,'tangkai','19937853103','【CRMEB】您的验证码是：142074，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-18 10:52:01','518076',200,82511,'ok'),
	(129,'tangkai','15975200658','【CRMEB】您的验证码是：858246，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-18 15:00:06','518076',200,83486,'ok'),
	(130,'tangkai','13184560789','【CRMEB】您的验证码是：565910，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-19 09:56:59','518076',200,85441,'ok'),
	(131,'tangkai','13194080052','【CRMEB】您的验证码是：311202，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-19 14:51:25','518076',200,86363,'ok'),
	(132,'tangkai','18925242347','【CRMEB】您的验证码是：334195，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-19 14:55:29','518076',200,86381,'ok'),
	(133,'tangkai','13459485879','【CRMEB】您的验证码是：289388，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-20 17:12:47','518076',200,89723,'ok'),
	(134,'tangkai','15578973389','【CRMEB】您的验证码是：502314，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-22 10:19:05','518076',200,95375,'ok'),
	(135,'tangkai','13513775156','【CRMEB】您的验证码是：724604，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-22 13:59:03','518076',200,96159,'ok'),
	(136,'tangkai','15975200658','【CRMEB】您的验证码是：720963，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-22 16:10:49','518076',200,96761,'ok'),
	(137,'tangkai','15878781234','【CRMEB】您的验证码是：839679，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-23 14:17:12','518076',200,100388,'ok'),
	(138,'tangkai','15518727891','【CRMEB】您的验证码是：423166，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-23 22:30:27','518076',200,102419,'ok'),
	(139,'tangkai','17358507603','【CRMEB】您的验证码是：355482，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-24 21:02:26','518076',200,106306,'ok'),
	(140,'tangkai','18861202652','【CRMEB】您的验证码是：393783，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-25 14:28:14','518076',200,108925,'ok'),
	(141,'tangkai','18661202652','【CRMEB】您的验证码是：776710，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-25 14:29:24','518076',200,108932,'ok'),
	(142,'tangkai','18328706641','【CRMEB】您的验证码是：585595，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-27 13:53:37','518076',200,117884,'ok'),
	(143,'tangkai','18328706641','【CRMEB】您的验证码是：336259，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-28 19:05:05','518076',200,124269,'ok'),
	(144,'tangkai','17606199566','【CRMEB】您的验证码是：799832，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 16:32:15','518076',200,127792,'ok'),
	(145,'tangkai','17606199566','【CRMEB】您的验证码是：770239，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 16:32:49','518076',200,127795,'ok'),
	(146,'tangkai','18658666691','【CRMEB】您的验证码是：996867，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 16:52:59','518076',200,127914,'ok'),
	(147,'tangkai','17607183962','【CRMEB】您的验证码是：129111，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 17:25:00','518076',200,128065,'ok'),
	(148,'tangkai','17050291004','【CRMEB】您的验证码是：924474，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 20:15:00','518076',200,128732,'ok'),
	(149,'tangkai','18292417675','【CRMEB】您的验证码是：415971，有效期为1分钟。如非本人操作，可不用理会。','','2020-09-29 22:09:55','518076',200,129116,'ok'),
	(150,'tangkai','13717017105','【CRMEB】您的验证码是：545871，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-05 17:19:02','518076',200,142430,'ok'),
	(151,'tangkai','13718017105','【CRMEB】您的验证码是：406395，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-05 17:20:12','518076',200,142434,'ok'),
	(152,'tangkai','13718017105','【CRMEB】您的验证码是：562266，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-05 17:20:12','518076',200,142435,'ok'),
	(153,'tangkai','13718017105','【CRMEB】您的验证码是：276381，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-05 17:21:27','518076',200,142438,'ok'),
	(154,'tangkai','13533512317','【CRMEB】您的验证码是：375746，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-08 14:20:18','518076',200,149398,'ok'),
	(155,'tangkai','18934190345','【CRMEB】您的验证码是：357405，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 11:36:36','518076',200,152058,'ok'),
	(156,'tangkai','18615596654','【CRMEB】您的验证码是：236285，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 12:01:31','518076',200,152132,'ok'),
	(157,'tangkai','15975200658','【CRMEB】您的验证码是：649973，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 14:22:47','518076',200,152498,'ok'),
	(158,'tangkai','18069787937','【CRMEB】您的验证码是：197704，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 15:42:12','518076',200,152772,'ok'),
	(159,'tangkai','17702155558','【CRMEB】您的验证码是：748843，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 16:27:02','518076',200,152947,'ok'),
	(160,'tangkai','18144113993','【CRMEB】您的验证码是：820684，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-09 20:22:03','518076',200,153885,'ok'),
	(161,'tangkai','13184560789','【CRMEB】您的验证码是：737208，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 09:49:10','518076',200,154890,'ok'),
	(162,'tangkai','13184560789','【CRMEB】您的验证码是：649777，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 09:57:48','518076',200,154939,'ok'),
	(163,'tangkai','18515588835','【CRMEB】您的验证码是：396877，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 10:57:38','518076',200,155207,'ok'),
	(164,'tangkai','15538081797','【CRMEB】您的验证码是：946852，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 15:21:20','518076',200,156397,'ok'),
	(165,'tangkai','15538081797','【CRMEB】您的验证码是：580059，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 15:22:11','518076',200,156400,'ok'),
	(166,'tangkai','15538081797','【CRMEB】您的验证码是：250597，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-10 15:29:35','518076',200,156437,'ok'),
	(167,'tangkai','13163680032','【CRMEB】您的验证码是：711996，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-13 11:01:43','518076',200,168135,'ok'),
	(168,'tangkai','13720673941','【CRMEB】您的验证码是：386227，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-14 10:34:09','518076',200,172254,'ok'),
	(169,'tangkai','13720673941','【CRMEB】您的验证码是：919727，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-14 10:36:39','518076',200,172266,'ok'),
	(170,'tangkai','18784236930','【CRMEB】您的验证码是：487451，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-14 10:59:24','518076',200,172377,'ok'),
	(171,'tangkai','18621661161','【CRMEB】您的验证码是：488105，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-15 19:19:57','518076',200,178648,'ok'),
	(172,'tangkai','18927201280','【CRMEB】您的验证码是：407669，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-16 09:18:14','518076',200,179738,'ok'),
	(173,'tangkai','18621263027','【CRMEB】您的验证码是：769326，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-16 21:55:14','518076',200,185582,'ok'),
	(174,'tangkai','18621263027','【CRMEB】您的验证码是：671890，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-16 21:56:14','518076',200,185586,'ok'),
	(175,'tangkai','18292417675','【CRMEB】您的验证码是：855073，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-17 10:51:05','518076',200,186481,'ok'),
	(176,'tangkai','18292417675','【CRMEB】您的验证码是：403393，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-17 10:51:45','518076',200,186484,'ok'),
	(177,'tangkai','18292417675','【CRMEB】您的验证码是：869839，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-17 10:53:48','518076',200,186494,'ok'),
	(178,'tangkai','13378451282','【CRMEB】您的验证码是：803422，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-17 21:25:52','518076',200,188893,'ok'),
	(179,'tangkai','17797628196','【CRMEB】您的验证码是：353905，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-19 14:35:20','518076',200,194418,'ok'),
	(180,'tangkai','17797628196','【CRMEB】您的验证码是：431240，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-19 14:36:45','518076',200,194426,'ok'),
	(181,'tangkai','13849059616','【CRMEB】您的验证码是：867294，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-19 14:41:22','518076',200,194450,'ok'),
	(182,'tangkai','13849059616','【CRMEB】您的验证码是：376196，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-19 14:42:45','518076',200,194453,'ok'),
	(183,'tangkai','18980337507','【CRMEB】您的验证码是：701353，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-19 17:19:41','518076',200,195346,'ok'),
	(184,'tangkai','18547265999','【CRMEB】您的验证码是：959314，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-20 10:31:43','518076',200,198344,'ok'),
	(185,'tangkai','13720673941','【CRMEB】您的验证码是：171770，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-20 14:51:14','518076',200,199791,'ok'),
	(186,'tangkai','13317096647','【CRMEB】您的验证码是：580413，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-20 15:53:39','518076',200,200144,'ok'),
	(187,'tangkai','15928784684','【CRMEB】您的验证码是：406378，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 10:12:31','518076',200,203092,'ok'),
	(188,'tangkai','13146149227','【CRMEB】您的验证码是：336240，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 12:03:20','518076',200,203794,'ok'),
	(189,'tangkai','13146149227','【CRMEB】您的验证码是：402666，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 12:04:25','518076',200,203800,'ok'),
	(190,'tangkai','15978419983','【CRMEB】您的验证码是：999176，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 13:14:14','518076',200,204160,'ok'),
	(191,'tangkai','15978419983','【CRMEB】您的验证码是：656099，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 13:30:28','518076',200,204245,'ok'),
	(192,'tangkai','15978419983','【CRMEB】您的验证码是：141559，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 13:39:03','518076',200,204286,'ok'),
	(193,'tangkai','15209189276','【CRMEB】您的验证码是：898205，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 17:42:14','518076',200,205364,'ok'),
	(194,'tangkai','13720673941','【CRMEB】您的验证码是：219886，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-21 18:16:42','518076',200,205490,'ok'),
	(195,'tangkai','13502834774','【CRMEB】您的验证码是：915801，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 11:01:19','518076',200,207380,'ok'),
	(196,'tangkai','18620447521','【CRMEB】您的验证码是：569918，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 14:17:04','518076',200,208186,'ok'),
	(197,'tangkai','15538081797','【CRMEB】您的验证码是：356045，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 15:08:24','518076',200,208413,'ok'),
	(198,'tangkai','15538081797','【CRMEB】您的验证码是：183629，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 15:10:14','518076',200,208425,'ok'),
	(199,'tangkai','13032979631','【CRMEB】您的验证码是：494701，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 16:47:29','518076',200,208880,'ok'),
	(200,'tangkai','13032979631','【CRMEB】您的验证码是：321277，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 16:48:59','518076',200,208886,'ok'),
	(201,'tangkai','18096645945','【CRMEB】您的验证码是：494857，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 17:09:51','518076',200,208953,'ok'),
	(202,'tangkai','13032979631','【CRMEB】您的验证码是：773663，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 17:48:25','518076',200,209103,'ok'),
	(203,'tangkai','13032979631','【CRMEB】您的验证码是：585283，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 17:50:20','518076',200,209113,'ok'),
	(204,'tangkai','18292417675','【CRMEB】您的验证码是：222602，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 17:58:05','518076',200,209141,'ok'),
	(205,'tangkai','18292417675','【CRMEB】您的验证码是：494291，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:08:24','518076',200,209174,'ok'),
	(206,'tangkai','18292417675','【CRMEB】您的验证码是：960562，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:16:11','518076',200,209197,'ok'),
	(207,'tangkai','18292417675','【CRMEB】您的验证码是：311627，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:20:26','518076',200,209218,'ok'),
	(208,'tangkai','18292417675','【CRMEB】您的验证码是：593219，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:26:11','518076',200,209237,'ok'),
	(209,'tangkai','18292417675','【CRMEB】您的验证码是：117429，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:31:41','518076',200,209256,'ok'),
	(210,'tangkai','18292417675','【CRMEB】您的验证码是：299078，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:38:03','518076',200,209281,'ok'),
	(211,'tangkai','18292417675','【CRMEB】您的验证码是：651467，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:45:56','518076',200,209305,'ok'),
	(212,'tangkai','18292417675','【CRMEB】您的验证码是：351786，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 18:52:16','518076',200,209315,'ok'),
	(213,'tangkai','18954232923','【CRMEB】您的验证码是：522314，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 22:57:51','518076',200,210188,'ok'),
	(214,'tangkai','18954232923','【CRMEB】您的验证码是：938454，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 22:58:56','518076',200,210191,'ok'),
	(215,'tangkai','18954232923','【CRMEB】您的验证码是：336106，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-22 22:59:41','518076',200,210192,'ok'),
	(216,'tangkai','18292417675','【CRMEB】您的验证码是：666209，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 09:38:30','518076',200,210727,'ok'),
	(217,'tangkai','18292417675','【CRMEB】您的验证码是：853029，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 10:07:19','518076',200,210814,'ok'),
	(218,'tangkai','18292417675','【CRMEB】您的验证码是：188904，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 10:20:12','518076',200,210856,'ok'),
	(219,'tangkai','18292417675','【CRMEB】您的验证码是：626850，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 10:24:47','518076',200,210871,'ok'),
	(220,'tangkai','13146149227','【CRMEB】您的验证码是：853464，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 10:34:38','518076',200,210921,'ok'),
	(221,'tangkai','18292417675','【CRMEB】您的验证码是：554113，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 11:14:25','518076',200,211068,'ok'),
	(222,'tangkai','18292417675','【CRMEB】您的验证码是：627379，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 11:23:13','518076',200,211094,'ok'),
	(223,'tangkai','18292417675','【CRMEB】您的验证码是：605376，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 11:31:22','518076',200,211122,'ok'),
	(224,'tangkai','18292417675','【CRMEB】您的验证码是：435231，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-23 11:35:56','518076',200,211144,'ok'),
	(225,'tangkai','18991352728','【CRMEB】您的验证码是：783470，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 14:33:53','518076',200,227689,'ok'),
	(226,'tangkai','15573005460','【CRMEB】您的验证码是：524879，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 17:52:51','518076',200,228441,'ok'),
	(227,'tangkai','18838971183','【CRMEB】您的验证码是：825105，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 20:39:59','518076',200,228897,'ok'),
	(228,'tangkai','18838971183','【CRMEB】您的验证码是：260208，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 20:40:49','518076',200,228905,'ok'),
	(229,'tangkai','18838971183','【CRMEB】您的验证码是：978389，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 20:43:29','518076',200,228919,'ok'),
	(230,'tangkai','18838971183','【CRMEB】您的验证码是：687615，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 20:44:29','518076',200,228924,'ok'),
	(231,'tangkai','18838971183','【CRMEB】您的验证码是：353435，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 20:46:59','518076',200,228932,'ok'),
	(232,'tangkai','18292417675','【CRMEB】您的验证码是：563402，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 22:24:45','518076',200,229206,'ok'),
	(233,'tangkai','18292417675','【CRMEB】您的验证码是：356457，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 22:25:45','518076',200,229207,'ok'),
	(234,'tangkai','17324773990','【CRMEB】您的验证码是：528190，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 23:08:00','518076',200,229289,'ok'),
	(235,'tangkai','17324773990','【CRMEB】您的验证码是：867782，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 23:08:00','518076',200,229291,'ok'),
	(236,'tangkai','17324773990','【CRMEB】您的验证码是：975876，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 23:08:00','518076',200,229293,'ok'),
	(237,'tangkai','17324773990','【CRMEB】您的验证码是：397728，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 23:08:00','518076',200,229295,'ok'),
	(238,'tangkai','15071339510','【CRMEB】您的验证码是：730299，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-28 23:46:25','518076',200,229358,'ok'),
	(239,'tangkai','18128950786','【CRMEB】您的验证码是：188394，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 14:23:24','518076',200,230712,'ok'),
	(240,'tangkai','18128950786','【CRMEB】您的验证码是：958660，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 14:27:35','518076',200,230730,'ok'),
	(241,'tangkai','13641859149','【CRMEB】您的验证码是：323311，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 15:43:29','518076',200,231103,'ok'),
	(242,'tangkai','13720673941','【CRMEB】您的验证码是：431997，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 16:22:24','518076',200,231264,'ok'),
	(243,'tangkai','13720673941','【CRMEB】您的验证码是：197144，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 16:51:04','518076',200,231406,'ok'),
	(244,'tangkai','15959669996','【CRMEB】您的验证码是：757464，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-29 18:50:03','518076',200,231804,'ok'),
	(245,'tangkai','13032979631','【CRMEB】您的验证码是：310159，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 11:57:26','518076',200,233697,'ok'),
	(246,'tangkai','13032979631','【CRMEB】您的验证码是：583926，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 12:10:57','518076',200,233756,'ok'),
	(247,'tangkai','13032979631','【CRMEB】您的验证码是：619635，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 12:19:04','518076',200,233785,'ok'),
	(248,'tangkai','18559645067','【CRMEB】您的验证码是：634575，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 13:38:30','518076',200,234065,'ok'),
	(249,'tangkai','15209189276','【CRMEB】您的验证码是：393001，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 14:19:25','518076',200,234237,'ok'),
	(250,'tangkai','18292417675','【CRMEB】您的验证码是：767265，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 14:22:49','518076',200,234252,'ok'),
	(251,'tangkai','18292417675','【CRMEB】您的验证码是：783037，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 14:32:02','518076',200,234281,'ok'),
	(252,'tangkai','18292417675','【CRMEB】您的验证码是：273714，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 14:53:08','518076',200,234388,'ok'),
	(253,'tangkai','18292417675','【CRMEB】您的验证码是：838454，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 14:58:41','518076',200,234410,'ok'),
	(254,'tangkai','18292417675','【CRMEB】您的验证码是：244795，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 15:17:29','518076',200,234509,'ok'),
	(255,'tangkai','18292417675','【CRMEB】您的验证码是：919455，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 15:38:49','518076',200,234637,'ok'),
	(256,'tangkai','18292417675','【CRMEB】您的验证码是：678075，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 15:48:10','518076',200,234674,'ok'),
	(257,'tangkai','18292417675','【CRMEB】您的验证码是：112572，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 15:50:35','518076',200,234680,'ok'),
	(258,'tangkai','18292417675','【CRMEB】您的验证码是：611501，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 15:53:20','518076',200,234694,'ok'),
	(259,'tangkai','18292417675','【CRMEB】您的验证码是：517175，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:23:15','518076',200,234788,'ok'),
	(260,'tangkai','18292417675','【CRMEB】您的验证码是：935843，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:34:10','518076',200,234834,'ok'),
	(261,'tangkai','18292417675','【CRMEB】您的验证码是：313652，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:40:17','518076',200,234854,'ok'),
	(262,'tangkai','18292417675','【CRMEB】您的验证码是：571649，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:44:18','518076',200,234872,'ok'),
	(263,'tangkai','18292417675','【CRMEB】您的验证码是：756980，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:51:46','518076',200,234905,'ok'),
	(264,'tangkai','18292417675','【CRMEB】您的验证码是：550456，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 16:56:49','518076',200,234926,'ok'),
	(265,'tangkai','18292417675','【CRMEB】您的验证码是：442999，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 17:01:00','518076',200,234956,'ok'),
	(266,'tangkai','13720673941','【CRMEB】您的验证码是：632457，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 17:09:48','518076',200,235025,'ok'),
	(267,'tangkai','17570717162','【CRMEB】您的验证码是：465526，有效期为1分钟。如非本人操作，可不用理会。','','2020-10-30 17:11:22','518076',200,235045,'ok'),
	(268,'tangkai','17621561841','【CRMEB】您的验证码是：374346，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-01 16:28:58','518076',200,241076,'ok'),
	(269,'tangkai','17777665965','【CRMEB】您的验证码是：930100，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-02 15:35:32','518076',200,244147,'ok'),
	(270,'tangkai','17602192032','【CRMEB】您的验证码是：819672，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-02 16:12:28','518076',200,244319,'ok'),
	(271,'tangkai','18306425113','【CRMEB】您的验证码是：296321，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-02 16:13:23','518076',200,244321,'ok'),
	(272,'hzw','18709277397','【CRMEB】您的验证码是：315366，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-02 17:17:55','518076',200,83542,'ok'),
	(273,'tangkai','17570717162','【CRMEB】您的验证码是：872767，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-02 17:34:18','518076',200,244665,'ok'),
	(274,'hzw','18709277397','【CRMEB】您的验证码是：539853，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 09:58:02','518076',200,83558,'ok'),
	(275,'hzw','18709277397','【CRMEB】您的验证码是：182708，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 09:58:02','518076',200,83559,'ok'),
	(276,'hzw','18709277397','【CRMEB】您的验证码是：709069，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 10:19:32','518076',200,83560,'ok'),
	(277,'hzw','18709277397','【CRMEB】您的验证码是：710617，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 11:11:33','518076',200,83562,'ok'),
	(278,'hzw','18709277397','【CRMEB】您的验证码是：634906，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 15:28:45','518076',200,83565,'ok'),
	(279,'hzw','15928784684','【CRMEB】您的验证码是：205458，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-03 15:34:54','518076',200,83566,'ok'),
	(280,'hzw','15928784684','【CRMEB】您的验证码是：745219，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 10:11:52','518076',200,83585,'ok'),
	(281,'hzw','18328064516','【CRMEB】您的验证码是：377803，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 10:12:52','518076',200,83587,'ok'),
	(282,'hzw','18328064516','【CRMEB】您的验证码是：299484，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 10:49:02','518076',200,83589,'ok'),
	(283,'hzw','18328064516','【CRMEB】您的验证码是：320250，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 13:06:33','518076',200,83598,'ok'),
	(284,'tangkai','13123597920','【CRMEB】您的验证码是：232968，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 13:21:53','518076',200,83599,'ok'),
	(285,'hzw','15928784684','【CRMEB】您的验证码是：759742，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 13:39:03','518076',200,83600,'ok'),
	(286,'hzw','15928784684','【CRMEB】您的验证码是：113489，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 13:41:05','518076',200,83601,'ok'),
	(287,'hzw','18709277397','【CRMEB】您的验证码是：681032，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 14:06:13','518076',200,83602,'ok'),
	(288,'hzw','18709277397','【CRMEB】您的验证码是：813479，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 14:37:59','518076',200,83603,'ok'),
	(289,'tangkai','13530104677','【CRMEB】您的验证码是：361693，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 14:56:08','518076',200,83604,'ok'),
	(290,'tangkai','13530104677','【CRMEB】您的验证码是：867189，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 14:57:23','518076',200,83606,'ok'),
	(291,'hzw','18709277397','【CRMEB】您的验证码是：384391，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 15:03:23','518076',200,83607,'ok'),
	(292,'hzw','18709277397','【CRMEB】您的验证码是：624065，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 15:03:33','518076',200,83608,'ok'),
	(293,'hzw','18709277397','【CRMEB】您的验证码是：256956，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 15:03:43','518076',200,83609,'ok'),
	(294,'hzw','18709277397','【CRMEB】您的验证码是：567804，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 15:03:53','518076',200,83610,'ok'),
	(295,'hzw','15928784684','【CRMEB】您的验证码是：568185，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 19:01:32','518076',200,83620,'ok'),
	(296,'hzw','18328064516','【CRMEB】您的验证码是：235618，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-04 19:03:47','518076',200,83621,'ok'),
	(297,'hzw','18328064516','【CRMEB】您的验证码是：347641，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 09:11:24','518076',200,83629,'ok'),
	(298,'hzw','18328064516','【CRMEB】您的验证码是：681894，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 09:13:34','518076',200,83630,'ok'),
	(299,'tangkai','13700696591','【CRMEB】您的验证码是：545361，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 09:26:54','518076',200,83631,'ok'),
	(300,'hzw','18328064516','【CRMEB】您的验证码是：932260，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 11:41:55','518076',200,83642,'ok'),
	(301,'hzw','18328064516','【CRMEB】您的验证码是：857790，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 11:44:45','518076',200,83643,'ok'),
	(302,'hzw','15928784684','【CRMEB】您的验证码是：406195，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 11:45:55','518076',200,83644,'ok'),
	(303,'hzw','15928784684','【CRMEB】您的验证码是：595381，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 11:48:20','518076',200,83645,'ok'),
	(304,'hzw','18328064516','【CRMEB】您的验证码是：385221，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 11:49:20','518076',200,83646,'ok'),
	(305,'hzw','18328064516','【CRMEB】您的验证码是：905275，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 12:00:43','518076',200,83647,'ok'),
	(306,'hzw','15928784684','【CRMEB】您的验证码是：431112，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 12:02:00','518076',200,83648,'ok'),
	(307,'hzw','15928784684','【CRMEB】您的验证码是：475245，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 12:03:18','518076',200,83649,'ok'),
	(308,'hzw','15928784684','【CRMEB】您的验证码是：863119，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 13:11:16','518076',200,83650,'ok'),
	(309,'hzw','15928784684','【CRMEB】您的验证码是：602244，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 13:13:00','518076',200,83651,'ok'),
	(310,'hzw','15928784684','【CRMEB】您的验证码是：364602，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 14:42:25','518076',200,83652,'ok'),
	(311,'tangkai','15060035130','【CRMEB】您的验证码是：997367，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-05 15:05:35','518076',200,83653,'ok'),
	(312,'hzw','16680431664','【CRMEB】您的验证码是：351931，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:14','518076',200,83902,'ok'),
	(313,'hzw','15729480622','【CRMEB】您的验证码是：862605，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:14','518076',200,83903,'ok'),
	(314,'hzw','13112311231','【CRMEB】您的验证码是：328693，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:18','518076',200,83904,'ok'),
	(315,'hzw','13404197669','【CRMEB】您的验证码是：590676，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:18','518076',200,83905,'ok'),
	(316,'hzw','15014114321','【CRMEB】您的验证码是：597859，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:18','518076',200,83906,'ok'),
	(317,'hzw','13007626064','【CRMEB】您的验证码是：782763，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:18','518076',200,83907,'ok'),
	(318,'hzw','15014114321','【CRMEB】您的验证码是：683344，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:18','518076',200,83908,'ok'),
	(319,'hzw','15539977367','【CRMEB】您的验证码是：445114，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:19','518076',200,83909,'ok'),
	(320,'hzw','15990392500','【CRMEB】您的验证码是：166196，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 15:42:19','518076',200,83910,'ok'),
	(321,'hzw','18292417675','【CRMEB】您的验证码是：995452，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-16 17:59:38','518076',200,83917,'ok'),
	(322,'hzw','18292417675','【CRMEB】您的验证码是：114945，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 09:31:06','518076',200,83918,'ok'),
	(323,'hzw','15210928291','【CRMEB】您的验证码是：212691，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 11:02:46','518076',200,83925,'ok'),
	(324,'hzw','18834144748','【CRMEB】您的验证码是：750830，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 14:43:44','518076',200,83929,'ok'),
	(325,'hzw','13826300503','【CRMEB】您的验证码是：986571，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 14:58:44','518076',200,83931,'ok'),
	(326,'hzw','18985155612','【CRMEB】您的验证码是：939016，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 16:16:49','518076',200,83943,'ok'),
	(327,'hzw','13146149227','【CRMEB】您的验证码是：692860，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-17 16:19:59','518076',200,83944,'ok'),
	(328,'hzw','15832013094','【CRMEB】您的验证码是：949280，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 00:44:32','518076',200,83987,'ok'),
	(329,'hzw','18538848465','【CRMEB】您的验证码是：402264，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 10:37:04','518076',200,83989,'ok'),
	(330,'hzw','13999205182','【CRMEB】您的验证码是：177885，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 12:37:41','518076',200,83997,'ok'),
	(331,'hzw','13510288662','【CRMEB】您的验证码是：220506，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 14:46:46','518076',200,84001,'ok'),
	(332,'hzw','13934656499','【CRMEB】您的验证码是：596295，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 15:12:21','518076',200,84003,'ok'),
	(333,'hzw','18292417675','【CRMEB】您的验证码是：734257，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 15:22:11','518076',200,84007,'ok'),
	(334,'hzw','18292417675','【CRMEB】您的验证码是：634355，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 15:22:53','518076',200,84008,'ok'),
	(335,'hzw','15314547651','【CRMEB】您的验证码是：399169，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 20:42:15','518076',200,84012,'ok'),
	(336,'hzw','13502834774','【CRMEB】您的验证码是：468759，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-18 21:54:21','518076',200,84015,'ok'),
	(337,'hzw','18922166169','【CRMEB】您的验证码是：771279，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 10:13:47','518076',200,84022,'ok'),
	(338,'hzw','13053590359','【CRMEB】您的验证码是：976229，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 10:25:52','518076',200,84023,'ok'),
	(339,'hzw','18670490538','【CRMEB】您的验证码是：531128，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 10:30:53','518076',200,84024,'ok'),
	(340,'hzw','15883731460','【CRMEB】您的验证码是：447175，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:18:11','518076',200,84025,'ok'),
	(341,'hzw','15563636363','【CRMEB】您的验证码是：384508，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:20:04','518076',200,84026,'ok'),
	(342,'hzw','15618987268','【CRMEB】您的验证码是：822535，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:26:55','518076',200,84027,'ok'),
	(343,'hzw','13502834774','【CRMEB】您的验证码是：273703，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:28:51','518076',200,84028,'ok'),
	(344,'hzw','15563636363','【CRMEB】您的验证码是：477940，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:32:17','518076',200,84029,'ok'),
	(345,'hzw','13502834774','【CRMEB】您的验证码是：405320，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 11:33:52','518076',200,84030,'ok'),
	(346,'hzw','18396918056','【CRMEB】您的验证码是：745533，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 12:50:34','518076',200,84036,'ok'),
	(347,'hzw','13502834774','【CRMEB】您的验证码是：425250，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 13:01:31','518076',200,84037,'ok'),
	(348,'hzw','13502834774','【CRMEB】您的验证码是：202943，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 13:02:56','518076',200,84038,'ok'),
	(349,'hzw','18763699805','【CRMEB】您的验证码是：828707，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 17:03:27','518076',200,84044,'ok'),
	(350,'hzw','13502834774','【CRMEB】您的验证码是：874034，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 17:19:01','518076',200,84045,'ok'),
	(351,'hzw','13502834774','【CRMEB】您的验证码是：558594，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 17:24:47','518076',200,84046,'ok'),
	(352,'hzw','13666666666','【CRMEB】您的验证码是：894485，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 18:26:51','518076',200,84049,'ok'),
	(353,'hzw','13502834774','【CRMEB】您的验证码是：576398，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-19 18:39:16','518076',200,84051,'ok'),
	(354,'hzw','15313240480','【CRMEB】您的验证码是：215221，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 10:14:17','518076',200,84061,'ok'),
	(355,'hzw','18974705750','【CRMEB】您的验证码是：591908，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 10:22:53','518076',200,84063,'ok'),
	(356,'hzw','18974705750','【CRMEB】您的验证码是：424309，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 10:26:23','518076',200,84064,'ok'),
	(357,'hzw','18719137665','【CRMEB】您的验证码是：897778，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 10:53:19','518076',200,84067,'ok'),
	(358,'hzw','17768799270','【CRMEB】您的验证码是：747077，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 14:32:34','518076',200,84072,'ok'),
	(359,'stivepeim','18602800120','【CRMEB】您的验证码是：600200，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 18:00:54','518076',200,84081,'ok'),
	(360,'stivepeim','18292417675','【CRMEB】您的验证码是：478600，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-20 18:02:03','518076',200,84082,'ok'),
	(361,'stivepeim','18292417675','【CRMEB】您的验证码是：423419，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-21 08:31:26','518076',200,84089,'ok'),
	(362,'stivepeim','18670490538','【CRMEB】您的验证码是：796630，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-21 08:32:56','518076',200,84090,'ok'),
	(363,'stivepeim','18670490538','【CRMEB】您的验证码是：650348，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-22 12:37:45','518076',200,84097,'ok'),
	(364,'stivepeim','13401124693','【CRMEB】您的验证码是：751320，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 00:09:37','518076',200,84111,'ok'),
	(365,'stivepeim','13335133317','【CRMEB】您的验证码是：767539，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 09:30:24','518076',200,84112,'ok'),
	(366,'stivepeim','13335133317','【CRMEB】您的验证码是：316193，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 09:31:08','518076',200,84113,'ok'),
	(367,'stivepeim','15883731460','【CRMEB】您的验证码是：380817，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 14:59:55','518076',200,84118,'ok'),
	(368,'hzw','18292417675','【CRMEB】您的验证码是：191976，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 17:59:37','518076',200,84121,'ok'),
	(369,'hzw','18292417675','【CRMEB】您的验证码是：403541，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 18:00:17','518076',200,84122,'ok'),
	(370,'hzw','15928784684','【CRMEB】您的验证码是：855484，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 18:34:37','518076',200,84124,'ok'),
	(371,'stivepeim','18328706641','【CRMEB】您的验证码是：132372，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 18:48:17','518076',200,84125,'ok'),
	(372,'stivepeim','13826008519','【CRMEB】您的验证码是：804021，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-23 18:54:12','518076',200,84126,'ok'),
	(373,'hzw','15928784684','【CRMEB】您的验证码是：608935，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 09:12:35','518076',200,84132,'ok'),
	(374,'stivepeim','15883731460','【CRMEB】您的验证码是：839678，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 09:56:02','518076',200,84133,'ok'),
	(375,'stivepeim','15883731460','【CRMEB】您的验证码是：778900，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 09:56:37','518076',200,84134,'ok'),
	(376,'hzw','18120558100','【CRMEB】您的验证码是：777126，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 10:14:47','518076',200,84135,'ok'),
	(377,'stivepeim','13707394226','【CRMEB】您的验证码是：361718，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 11:09:32','518076',200,84136,'ok'),
	(378,'stivepeim','13681200110','【CRMEB】您的验证码是：719029，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 11:10:12','518076',200,84137,'ok'),
	(379,'stivepeim','18911459503','【CRMEB】您的验证码是：194633，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 11:20:37','518076',200,84138,'ok'),
	(380,'stivepeim','18128950786','【CRMEB】您的验证码是：785711，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 11:32:53','518076',200,84139,'ok'),
	(381,'hzw','15928784684','【CRMEB】您的验证码是：611952，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 13:01:48','518076',200,84141,'ok'),
	(382,'stivepeim','15117975238','【CRMEB】您的验证码是：878367，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 13:18:53','518076',200,84142,'ok'),
	(383,'stivepeim','15117975238','【CRMEB】您的验证码是：711836，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 13:22:03','518076',200,84143,'ok'),
	(384,'stivepeim','15117975238','【CRMEB】您的验证码是：846192，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 13:23:31','518076',200,84144,'ok'),
	(385,'hzw','15928784684','【CRMEB】您的验证码是：844032，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 13:38:35','518076',200,84145,'ok'),
	(386,'hzw','15928784684','【CRMEB】您的验证码是：465409，有效期为1分钟。如非本人操作，可不用理会。','','2020-11-24 15:37:19','518076',200,84151,'ok'),
	(387,'stivepeim','15311432805','【CRMEB】您的验证码是：564376，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 11:35:00','518076',200,428076,'ok'),
	(388,'stivepeim','13161656682','【CRMEB】您的验证码是：178247，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 11:35:35','518076',200,428080,'ok'),
	(389,'stivepeim','18328064516','【CRMEB】您的验证码是：581927，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 11:46:44','518076',200,428132,'ok'),
	(390,'stivepeim','18979264999','【CRMEB】您的验证码是：822784，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 11:58:41','518076',200,428199,'ok'),
	(391,'stivepeim','17700278601','【CRMEB】您的验证码是：394998，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 12:52:50','518076',200,428454,'ok'),
	(392,'stivepeim','13720673941','【CRMEB】您的验证码是：899634，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 14:17:35','518076',200,430030,'ok'),
	(393,'stivepeim','18569641151','【CRMEB】您的验证码是：714896，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-04 18:51:32','518076',200,431566,'ok'),
	(394,'stivepeim','18271671874','【CRMEB】您的验证码是：373986，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-05 12:28:51','518076',200,436611,'ok'),
	(395,'stivepeim','18389161167','【CRMEB】您的验证码是：194739，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-05 15:51:27','518076',200,438815,'ok'),
	(396,'stivepeim','18271671874','【CRMEB】您的验证码是：315648，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-06 15:56:58','518076',200,447460,'ok'),
	(397,'stivepeim','13502834774','【CRMEB】您的验证码是：320915，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-06 21:28:10','518076',200,450197,'ok'),
	(398,'stivepeim','13502834774','【CRMEB】您的验证码是：410482，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-06 21:57:40','518076',200,450296,'ok'),
	(399,'stivepeim','18225103925','【CRMEB】您的验证码是：803371，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 09:12:02','518076',200,451288,'ok'),
	(400,'stivepeim','13309212766','【CRMEB】您的验证码是：408993，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 09:28:02','518076',200,451607,'ok'),
	(401,'stivepeim','13309212766','【CRMEB】您的验证码是：454662，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 09:28:52','518076',200,451641,'ok'),
	(402,'stivepeim','18670490538','【CRMEB】您的验证码是：656519，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:24:13','518076',200,452900,'ok'),
	(403,'stivepeim','18292417675','【CRMEB】您的验证码是：704719，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:26:12','518076',200,452918,'ok'),
	(404,'stivepeim','18670490538','【CRMEB】您的验证码是：342221，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:27:12','518076',200,452930,'ok'),
	(405,'stivepeim','18670490538','【CRMEB】您的验证码是：321310，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:28:37','518076',200,452938,'ok'),
	(406,'stivepeim','18670490538','【CRMEB】您的验证码是：982681，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:29:42','518076',200,452943,'ok'),
	(407,'stivepeim','18528253808','【CRMEB】您的验证码是：743209，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:37:12','518076',200,452990,'ok'),
	(408,'stivepeim','15882436005','【CRMEB】您的验证码是：973922，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:38:57','518076',200,453001,'ok'),
	(409,'stivepeim','15882436005','【CRMEB】您的验证码是：974573，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 10:46:02','518076',200,453048,'ok'),
	(410,'stivepeim','18528253808','【CRMEB】您的验证码是：940051，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 11:01:53','518076',200,453204,'ok'),
	(411,'stivepeim','13813813813','【CRMEB】您的验证码是：934098，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 11:16:38','518076',200,453314,'ok'),
	(412,'stivepeim','19957104508','【CRMEB】您的验证码是：782045，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 15:20:03','518076',200,456853,'ok'),
	(413,'stivepeim','13927459644','【CRMEB】您的验证码是：297288，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-07 22:18:19','518076',200,463263,'ok'),
	(414,'stivepeim','18292417675','【CRMEB】您的验证码是：359383，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-08 09:59:26','518076',200,466184,'ok'),
	(415,'stivepeim','18292417675','【CRMEB】您的验证码是：786330，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-08 10:03:31','518076',200,466231,'ok'),
	(416,'stivepeim','13671176582','【CRMEB】您的验证码是：735686，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-08 10:43:19','518076',200,466577,'ok'),
	(417,'stivepeim','15801961236','【CRMEB】您的验证码是：367992，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-08 16:26:40','518076',200,470531,'ok'),
	(418,'stivepeim','18710383544','【CRMEB】您的验证码是：553271，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 11:14:33','518076',200,477446,'ok'),
	(419,'stivepeim','18710383544','【CRMEB】您的验证码是：116062，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 11:33:28','518076',200,477588,'ok'),
	(420,'stivepeim','18710383544','【CRMEB】您的验证码是：362854，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 11:33:58','518076',200,477592,'ok'),
	(421,'stivepeim','18710383544','【CRMEB】您的验证码是：798373，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 11:35:13','518076',200,477601,'ok'),
	(422,'stivepeim','18236770957','【CRMEB】您的验证码是：120298，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 11:56:08','518076',200,477754,'ok'),
	(423,'stivepeim','13428893120','【CRMEB】您的验证码是：715803，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 14:13:33','518076',200,479796,'ok'),
	(424,'stivepeim','15165092036','【CRMEB】您的验证码是：666567，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 14:22:58','518076',200,479851,'ok'),
	(425,'stivepeim','18292417675','【CRMEB】您的验证码是：753758，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 16:34:39','518076',200,480823,'ok'),
	(426,'stivepeim','18292417675','【CRMEB】您的验证码是：326402，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 16:35:39','518076',200,480835,'ok'),
	(427,'stivepeim','18292417675','【CRMEB】您的验证码是：273030，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-09 16:36:49','518076',200,480847,'ok'),
	(428,'stivepeim','18709277397','【CRMEB】您的验证码是：334478，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-10 11:21:17','518076',200,487412,'ok'),
	(429,'stivepeim','17687976756','【CRMEB】您的验证码是：724780，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-10 14:52:24','518076',200,490254,'ok'),
	(430,'stivepeim','15102908975','【CRMEB】您的验证码是：670459，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-10 14:52:54','518076',200,490260,'ok'),
	(431,'18710383544','13720673941','【CRMEB】您的验证码是：906156，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 15:57:04','518076',200,84541,'ok'),
	(432,'18710383544','18292417675','【CRMEB】您的验证码是：177051，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 15:57:04','518076',200,84542,'ok'),
	(433,'13110665982','13262250632','【CRMEB】您的验证码是：968375，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 15:57:04','518076',200,84543,'ok'),
	(434,'18710383544','13720673941','【CRMEB】您的验证码是：509442，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 15:57:05','518076',200,84544,'ok'),
	(435,'18710383544','13720673941','【CRMEB】您的验证码是：292005，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 16:01:29','518076',200,84546,'ok'),
	(436,'13110665982','13482584235','【CRMEB】您的验证码是：177809，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 16:02:19','518076',200,84547,'ok'),
	(437,'18710383544','13279146082','【CRMEB】您的验证码是：327083，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 16:12:14','518076',200,84548,'ok'),
	(438,'13110665982','13756868993','【CRMEB】您的验证码是：523621，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 16:25:07','518076',200,84549,'ok'),
	(439,'13110665982','18519100842','【CRMEB】您的验证码是：850821，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 17:00:01','518076',200,84550,'ok'),
	(440,'13110665982','13928835046','【CRMEB】您的验证码是：839790，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 19:11:06','518076',200,84551,'ok'),
	(441,'13110665982','18922166169','【CRMEB】您的验证码是：786461，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-21 23:04:22','518076',200,84552,'ok'),
	(442,'13110665982','13928835046','【CRMEB】您的验证码是：758982，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 09:32:56','518076',200,84553,'ok'),
	(443,'13110665982','17700740858','【CRMEB】您的验证码是：258127，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 10:17:30','518076',200,84555,'ok'),
	(444,'18710383544','13720673941','【CRMEB】您的验证码是：843441，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 10:24:00','518076',200,84556,'ok'),
	(445,'18710383544','13720673941','【CRMEB】您的验证码是：349974，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 10:24:00','518076',200,84557,'ok'),
	(446,'13110665982','15940818637','【CRMEB】您的验证码是：289836，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:45:09','518076',200,84563,'ok'),
	(447,'13110665982','15940818637','【CRMEB】您的验证码是：810995，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:45:09','518076',200,84564,'ok'),
	(448,'13110665982','15940818637','【CRMEB】您的验证码是：960414，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:45:09','518076',200,84565,'ok'),
	(449,'13110665982','15020025163','【CRMEB】您的验证码是：942842，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:45:09','518076',200,84566,'ok'),
	(450,'13110665982','15020025163','【CRMEB】您的验证码是：524137，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:45:10','518076',200,84567,'ok'),
	(451,'13110665982','15940818637','【CRMEB】您的验证码是：790030，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 11:51:54','518076',200,84568,'ok'),
	(452,'13110665982','15940818637','【CRMEB】您的验证码是：840586，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 12:21:34','518076',200,84574,'ok'),
	(453,'13110665982','18125658802','【CRMEB】您的验证码是：314246，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 14:16:10','518076',200,84575,'ok'),
	(454,'13110665982','15860124109','【CRMEB】您的验证码是：960266，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 15:27:05','518076',200,84576,'ok'),
	(455,'13110665982','17700278601','【CRMEB】您的验证码是：754114，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 15:38:05','518076',200,84577,'ok'),
	(456,'13110665982','18369390581','【CRMEB】您的验证码是：778077，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 16:07:06','518076',200,84578,'ok'),
	(457,'18710383544','13720673941','【CRMEB】您的验证码是：329735，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 16:49:25','518076',200,84580,'ok'),
	(458,'13110665982','13797260973','【CRMEB】您的验证码是：129134，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-22 18:05:15','518076',200,84582,'ok'),
	(459,'13110665982','19844564879','【CRMEB】您的验证码是：726641，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:17:55','518076',200,84583,'ok'),
	(460,'13110665982','18957168329','【CRMEB】您的验证码是：741292，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:17:55','518076',200,84584,'ok'),
	(461,'13572597243','13720673941','【CRMEB】您的验证码是：850139，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:17:55','518076',200,84585,'ok'),
	(462,'13572597243','13720673941','【CRMEB】您的验证码是：434363，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:17:55','518076',200,84586,'ok'),
	(463,'13572597243','13720673941','【CRMEB】您的验证码是：904373，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:17:55','518076',200,84587,'ok'),
	(464,'18710383544','13720673941','【CRMEB】您的验证码是：315498，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 09:18:24','518076',200,84588,'ok'),
	(465,'18710383544','18292417675','【CRMEB】您的验证码是：877563，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:06:52','518076',200,84589,'ok'),
	(466,'18710383544','13720673941','【CRMEB】您的验证码是：572794，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:09:37','518076',200,84590,'ok'),
	(467,'18710383544','13720673941','【CRMEB】您的验证码是：442240，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:18:48','518076',200,84591,'ok'),
	(468,'18710383544','13720673941','【CRMEB】您的验证码是：562418，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:23:32','518076',200,84592,'ok'),
	(469,'18710383544','18710383544','【CRMEB】您的验证码是：121801，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:46:17','518076',200,84593,'ok'),
	(470,'18710383544','13720673941','【CRMEB】您的验证码是：635182，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:51:17','518076',200,84594,'ok'),
	(471,'18710383544','18710383544','【CRMEB】您的验证码是：807171，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:52:47','518076',200,84595,'ok'),
	(472,'18710383544','13720673941','【CRMEB】您的验证码是：334894，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:55:37','518076',200,84596,'ok'),
	(473,'18710383544','13720673941','【CRMEB】您的验证码是：715175，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 10:56:52','518076',200,84597,'ok'),
	(474,'18710383544','13720673941','【CRMEB】您的验证码是：565320，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 11:00:58','518076',200,84598,'ok'),
	(475,'18710383544','13720673941','【CRMEB】您的验证码是：349918，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 11:16:08','518076',200,84599,'ok'),
	(476,'13110665982','18595714999','【CRMEB】您的验证码是：984691，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 11:17:43','518076',200,84600,'ok'),
	(477,'18710383544','13720673941','【CRMEB】您的验证码是：215426，有效期为1分钟。如非本人操作，可不用理会。','','2020-12-23 11:20:23','518076',200,84601,'ok'),
	(478,'18710383544','17600223760','【CRMEB】您的验证码是：382038，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:57','518076',200,785506,'ok'),
	(479,'18710383544','18292417675','【CRMEB】您的验证码是：479755，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:57','518076',200,785507,'ok'),
	(480,'18710383544','13622787781','【CRMEB】您的验证码是：685983，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:58','518076',200,785508,'ok'),
	(481,'18710383544','18709277397','【CRMEB】您的验证码是：975787，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:58','518076',200,785509,'ok'),
	(482,'18710383544','13622787781','【CRMEB】您的验证码是：604393，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:58','518076',200,785510,'ok'),
	(483,'18710383544','15978419983','【CRMEB】您的验证码是：319403，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:58','518076',200,785511,'ok'),
	(484,'18710383544','18709277397','【CRMEB】您的验证码是：576071，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:58','518076',200,785512,'ok'),
	(485,'18710383544','15978419983','【CRMEB】您的验证码是：724571，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:58','518076',200,785513,'ok'),
	(486,'18710383544','13622787781','【CRMEB】您的验证码是：699630，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:59','518076',200,785514,'ok'),
	(487,'18710383544','18709277397','【CRMEB】您的验证码是：892422，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:59','518076',200,785515,'ok'),
	(488,'18710383544','17554179228','【CRMEB】您的验证码是：273464，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:59','518076',200,785516,'ok'),
	(489,'18710383544','18709277397','【CRMEB】您的验证码是：149920，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:09:59','518076',200,785517,'ok'),
	(490,'18710383544','13622787781','【CRMEB】您的验证码是：730016，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 12:10:00','518076',200,785518,'ok'),
	(491,'stivepeim','17633850697','【CRMEB】您的验证码是：980748，有效期为1分钟。如非本人操作，可不用理会。','','2021-01-07 13:39:06','518076',200,786045,'ok');

/*!40000 ALTER TABLE `eb_sms_record` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_bargain
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_bargain`;

CREATE TABLE `eb_store_bargain` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '砍价商品ID',
  `product_id` int(11) unsigned NOT NULL COMMENT '关联商品ID',
  `title` varchar(255) NOT NULL COMMENT '砍价活动名称',
  `image` varchar(150) NOT NULL COMMENT '砍价活动图片',
  `unit_name` varchar(16) DEFAULT NULL COMMENT '单位名称',
  `stock` int(11) unsigned DEFAULT NULL COMMENT '库存',
  `sales` int(11) unsigned DEFAULT NULL COMMENT '销量',
  `images` varchar(2000) NOT NULL COMMENT '砍价商品轮播图',
  `start_time` bigint(14) unsigned NOT NULL COMMENT '砍价开启时间',
  `stop_time` bigint(14) unsigned NOT NULL COMMENT '砍价结束时间',
  `store_name` varchar(255) DEFAULT NULL COMMENT '砍价商品名称',
  `price` decimal(8,2) unsigned DEFAULT NULL COMMENT '砍价金额',
  `min_price` decimal(8,2) unsigned DEFAULT NULL COMMENT '砍价商品最低价',
  `num` int(11) unsigned DEFAULT NULL COMMENT '购买数量限制——单个活动每个用户发起砍价次数限制',
  `bargain_max_price` decimal(8,2) unsigned DEFAULT NULL COMMENT '用户每次砍价的最大金额',
  `bargain_min_price` decimal(8,2) unsigned DEFAULT NULL COMMENT '用户每次砍价的最小金额',
  `bargain_num` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '帮砍次数——单个商品用户可以帮砍的次数',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '砍价状态 0(到砍价时间不自动开启)  1(到砍价时间自动开启时间)',
  `give_integral` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '反多少积分',
  `info` varchar(255) DEFAULT NULL COMMENT '砍价活动简介',
  `cost` decimal(8,2) unsigned DEFAULT NULL COMMENT '成本价',
  `sort` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐0不推荐1推荐',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除 0未删除 1删除',
  `add_time` bigint(14) unsigned DEFAULT NULL COMMENT '添加时间',
  `is_postage` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否包邮 0不包邮 1包邮',
  `postage` decimal(10,2) unsigned DEFAULT NULL COMMENT '邮费',
  `rule` text COMMENT '砍价规则',
  `look` int(11) unsigned DEFAULT '0' COMMENT '砍价商品浏览量',
  `share` int(11) unsigned DEFAULT '0' COMMENT '砍价商品分享量',
  `temp_id` int(11) DEFAULT NULL COMMENT '运费模板ID',
  `weight` decimal(8,2) DEFAULT '0.00' COMMENT '重量',
  `volume` decimal(8,2) DEFAULT '0.00' COMMENT '体积',
  `quota` int(10) NOT NULL DEFAULT '0' COMMENT '限购总数',
  `quota_show` int(10) NOT NULL DEFAULT '0' COMMENT '限量总数显示',
  `people_num` int(11) DEFAULT NULL COMMENT '砍价人数——需要多少人砍价成功',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='砍价表';

LOCK TABLES `eb_store_bargain` WRITE;
/*!40000 ALTER TABLE `eb_store_bargain` DISABLE KEYS */;

INSERT INTO `eb_store_bargain` (`id`, `product_id`, `title`, `image`, `unit_name`, `stock`, `sales`, `images`, `start_time`, `stop_time`, `store_name`, `price`, `min_price`, `num`, `bargain_max_price`, `bargain_min_price`, `bargain_num`, `status`, `give_integral`, `info`, `cost`, `sort`, `is_hot`, `is_del`, `add_time`, `is_postage`, `postage`, `rule`, `look`, `share`, `temp_id`, `weight`, `volume`, `quota`, `quota_show`, `people_num`)
VALUES
	(7,4,'砍价商品','image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg','件',998,0,'[\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\"]',1607961600000,1608652799999,'砍价商品',100.00,0.00,1,NULL,NULL,2,0,0.00,'砍价商品',50.00,0,0,1,1608003990658,1,NULL,'',28,1,2,0.00,0.00,998,998,2),
	(8,5,'可乐','image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png','件',995,4,'[\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\"]',1607961600000,1608652799999,'可乐',100.00,0.00,10,NULL,NULL,2,0,0.00,'可乐',50.00,0,0,0,1608005976205,1,NULL,'',73,7,2,0.00,0.00,995,998,2),
	(9,7,'腰果222','image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','1盒',9996,3,'[\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\"]',1608480000000,1609430399999,'腰果',100000.00,10.00,4,NULL,NULL,3,0,0.00,'腰果腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范德萨发大师傅搭撒发撒旦腰果萨菲搭撒反倒是范德萨范德萨范德萨安防大厦发生地范',50.00,222,0,0,1608171505772,1,NULL,'<p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">苹果<a href=\"https://www.chinaz.com/tags/iPhone12ProMax.shtml\" target=\"_blank\" style=\"box-sizing: border-box; outline: 0px; color: rgb(66, 66, 66); text-decoration-line: none; padding: 0px 0px 2px; border-bottom: 1px dashed rgb(51, 51, 51); cursor: pointer;\">iPhone12ProMax</a>是今年苹果性能配置最强的一个型号，也因此成为很多人打算购买的一款手机，那么这款手机在什么时候会发售上市呢，线下门店什么时候能买到，我们来一起看下具体的时间介绍吧。</p><p class=\"article-content__img\" style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: center; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; white-space: normal; background-color: rgb(255, 255, 255);\"><img src=\"https://upload.chinaz.com/2020/1105/6374018479209622675668582.jpg\" title=\"苹果.jpg\" alt=\"苹果.jpg\" style=\"display: inline-block; box-sizing: border-box; outline: 0px; border: 1px solid rgb(238, 238, 238); max-width: 800px; background: url(&quot;../img/bglogo2.svg&quot;) center center no-repeat rgb(247, 248, 249); box-shadow: rgba(27, 95, 160, 0.1) 0px 1px 3px; margin: 0px auto;\"/></p><p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">1、iPhone12ProMax发售时间:11月6日晚上9点开启预售，11月13日正式发售上市</p><p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">2、如果在11月6日第一时间预约的用户，那么有机会在11月13日当天就可以发货，或者在苹果直营店取货</p><p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">3、iPhone12ProMax价格:9299元（128GB）、10099元(256GB)、11899元(512GB)</p><p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">4、iPhone12ProMax预计会十分热销，尤其是256GB、512GB的版本有可能出现加价的情况，另外海蓝色和石墨色两个颜色也会比较多人购买</p><p style=\"margin-top: 0px; margin-bottom: 24px; box-sizing: border-box; outline: 0px; padding: 0px; line-height: 32px; text-align: justify; color: rgb(74, 74, 74); word-break: break-word; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">5、建议在11月6日晚上9点准时就前往官网下单付款，预计最快可以在发售日当天可以取货，如果速度较慢的话，可能需要等到超过1-2周时间才发货</p><p><br style=\"white-space: normal;\"/></p><p><br style=\"white-space: normal;\"/></p><p><br/></p>',55,6,2,0.00,0.00,97,97,2),
	(10,15,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男','//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg','件',100,0,'[\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\"]',1608652800000,1608998399999,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',159.00,0.00,1,NULL,NULL,2,0,20.00,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',100.00,99,0,0,1608710896391,1,NULL,'',12,0,3,0.00,0.00,100,100,2),
	(11,15,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男','//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg','件',100,0,'[\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\"]',1609171200000,1611849599999,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',159.00,NULL,1,NULL,NULL,2,0,20.00,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',100.00,99,0,0,1609247005094,1,NULL,'',0,0,3,0.00,0.00,100,100,2),
	(12,22,'德国WMF福腾宝不粘锅麦饭石色炒锅30cm炒菜锅少烟锅具煎锅平底煎炒锅煎蛋不粘锅电磁炉燃气煤气灶通用 星辰炒锅30cm','http:\\/\\/img30.360buyimg.com\\/popWaterMark\\/jfs\\/t1\\/153225\\/32\\/10463\\/284339\\/5fde2371Ea335d101\\/af0ac9f754c62c64.jpg','T',99,0,'[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/153225/32/10463/284339/5fde2371Ea335d101/af0ac9f754c62c64.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/142029/15/19116/143184/5fde2377Ebd8f5d1a/1e2cc7b676dafa5b.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/124795/21/8431/178793/5f24fa7aE3c42082c/c49aab117de72a92.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/112499/1/13861/192935/5f24fa7bEc0393353/bb013b8ad0df4aef.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/125430/18/8538/235422/5f24fa7bEd898b82c/f8d812d624ab7286.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/116535/12/13475/127375/5f24fa7aE3a8493c1/c39bbf2e500c09c4.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/149061/31/4197/66051/5f24fa7bE908d9d80/edc3f234e403bb46.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/69690/24/10859/195176/5d8829d9Ed4c9fb0f/3a7b4dede959ef81.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/147829/23/5528/148331/5f37acb2E653c3d4b/3fe090754f7054d0.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/113505/35/13736/88865/5f24fa79Eda4854c2/f63e65af6ed122e9.jpg\"]',1609862400000,1612972799999,'德国WMF福腾宝不粘锅麦饭石色炒锅30cm炒菜锅少烟锅具煎锅平底煎炒锅煎蛋不粘锅电磁炉燃气煤气灶通用 星辰炒锅30cm',99.00,NULL,1,NULL,NULL,2,0,1.00,'德国WMF福腾宝不粘锅麦饭石色炒锅30cm炒菜锅少烟锅具煎锅平底煎炒锅煎蛋不粘锅电磁炉燃气煤气灶通用 星辰炒锅30cm',99.00,0,0,0,1609939162192,1,NULL,'',0,0,2,0.00,0.00,99,99,2),
	(13,7,'腰果','image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','1盒',11,0,'[\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\"]',1609948800000,1610121599999,'腰果',100.00,0.00,1,NULL,NULL,2,0,0.00,'腰果',50.00,1,0,0,1610000289996,1,NULL,'',0,0,2,0.00,0.00,11,11,2),
	(14,7,'腰果1111','image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','1盒',11,0,'[\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\"]',1609948800000,1610121599999,'腰果',100.00,0.00,4,NULL,NULL,3,0,0.00,'腰果2222',50.00,99,0,0,1610001205367,1,NULL,'<p>1111111111111111111111</p>',0,0,2,0.00,0.00,11,11,2),
	(15,7,'腰果11','image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','1盒',11,0,'[\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\"]',1609948800000,1610121599999,'腰果',100.00,0.00,4,NULL,NULL,3,0,0.00,'腰果222',50.00,99,0,0,1610001255211,1,NULL,'<p>111111111</p>',0,0,2,0.00,0.00,11,11,2),
	(16,7,'腰果111','image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','22盒',11,0,'[\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\"]',1609948800000,1610121599999,'腰果',100.00,0.00,19,NULL,NULL,20,0,0.00,'腰果2222',50.00,999,0,0,1610001373276,1,NULL,'<p>222</p>',0,0,2,0.00,0.00,11,11,21),
	(17,7,'腰果1111','image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','1盒',11,0,'[\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\"]',1609948800000,1610121599999,'腰果',100.00,0.00,5,NULL,NULL,4,0,0.00,'腰果222',50.00,2,0,0,1610001425220,1,NULL,'',0,0,2,0.00,0.00,11,11,3);

/*!40000 ALTER TABLE `eb_store_bargain` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_bargain_user
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_bargain_user`;

CREATE TABLE `eb_store_bargain_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户参与砍价表ID',
  `uid` int(11) unsigned DEFAULT NULL COMMENT '用户ID',
  `bargain_id` int(11) unsigned DEFAULT NULL COMMENT '砍价商品id',
  `bargain_price_min` decimal(8,2) unsigned DEFAULT NULL COMMENT '砍价的最低价',
  `bargain_price` decimal(8,2) DEFAULT NULL COMMENT '砍价金额',
  `price` decimal(8,2) unsigned DEFAULT NULL COMMENT '砍掉的价格',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态 1参与中 2 活动结束参与失败 3活动结束参与成功',
  `add_time` bigint(14) unsigned DEFAULT NULL COMMENT '参与时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否取消',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='用户参与砍价表';

LOCK TABLES `eb_store_bargain_user` WRITE;
/*!40000 ALTER TABLE `eb_store_bargain_user` DISABLE KEYS */;

INSERT INTO `eb_store_bargain_user` (`id`, `uid`, `bargain_id`, `bargain_price_min`, `bargain_price`, `price`, `status`, `add_time`, `is_del`)
VALUES
	(12,32,7,0.00,100.00,39.01,1,1608004075309,0),
	(13,34,7,0.00,100.00,100.00,3,1608004377566,0),
	(14,35,7,0.00,100.00,30.03,1,1608005770142,0),
	(15,34,8,0.00,100.00,100.00,3,1608006027147,0),
	(16,37,8,0.00,100.00,65.84,2,1608081781425,0),
	(17,32,9,10.00,100.00,90.00,2,1608171548727,0),
	(18,34,9,10.00,100.00,90.00,3,1608171856182,0),
	(19,34,9,10.00,100.00,90.00,3,1608173309575,0),
	(20,35,9,10.00,100.00,90.00,2,1608173803620,0),
	(21,31,8,0.00,100.00,100.00,3,1608174472131,0),
	(22,34,8,0.00,100.00,100.00,3,1608174496581,0),
	(23,31,8,0.00,100.00,100.00,3,1608174861386,0),
	(24,31,8,0.00,100.00,100.00,3,1608175057778,0),
	(25,31,9,10.00,100.00,90.00,3,1608175378237,0),
	(26,34,9,10.00,100.00,31.33,2,1608175471160,0),
	(27,46,9,10.00,100.00,21.32,2,1608175763657,0),
	(28,46,8,0.00,100.00,100.00,2,1608176185879,0),
	(29,31,9,10.00,100.00,90.00,2,1608176288953,0),
	(30,31,8,0.00,100.00,100.00,3,1608279146228,0),
	(31,32,8,0.00,100.00,63.70,2,1608530574057,0),
	(32,52,9,10.00,100.00,24.05,2,1608540119301,0),
	(33,59,8,0.00,100.00,74.00,2,1608604646856,0),
	(34,54,8,0.00,100.00,36.71,2,1608608083248,0);

/*!40000 ALTER TABLE `eb_store_bargain_user` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_bargain_user_help
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_bargain_user_help`;

CREATE TABLE `eb_store_bargain_user_help` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '砍价用户帮助表ID',
  `uid` int(11) unsigned DEFAULT NULL COMMENT '帮助的用户id',
  `bargain_id` int(11) unsigned DEFAULT NULL COMMENT '砍价商品ID',
  `bargain_user_id` int(11) unsigned DEFAULT NULL COMMENT '用户参与砍价表id',
  `price` decimal(8,2) unsigned DEFAULT NULL COMMENT '帮助砍价多少金额',
  `add_time` bigint(14) unsigned DEFAULT NULL COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='砍价用户帮助表';

LOCK TABLES `eb_store_bargain_user_help` WRITE;
/*!40000 ALTER TABLE `eb_store_bargain_user_help` DISABLE KEYS */;

INSERT INTO `eb_store_bargain_user_help` (`id`, `uid`, `bargain_id`, `bargain_user_id`, `price`, `add_time`)
VALUES
	(16,32,7,12,39.01,1608004075416),
	(17,34,7,13,71.94,1608004377729),
	(18,35,7,13,28.06,1608004625949),
	(19,35,7,14,30.03,1608005770365),
	(20,34,8,15,61.64,1608006027318),
	(21,35,8,15,38.36,1608006090829),
	(22,37,8,16,65.84,1608081781530),
	(23,32,9,17,23.39,1608171548836),
	(24,34,9,17,66.61,1608171583038),
	(25,34,9,18,29.90,1608171856390),
	(26,35,9,18,60.10,1608171894526),
	(27,34,9,19,38.30,1608173309751),
	(28,35,9,19,51.70,1608173380308),
	(29,35,9,20,61.73,1608173803767),
	(30,34,9,20,28.27,1608173820217),
	(31,31,8,21,51.49,1608174472350),
	(32,34,8,21,48.51,1608174495439),
	(33,34,8,22,46.69,1608174496668),
	(34,31,8,23,20.32,1608174861596),
	(35,34,8,23,79.68,1608174956435),
	(36,31,8,24,21.79,1608175058107),
	(37,46,8,24,78.21,1608175114624),
	(38,31,9,25,69.02,1608175378454),
	(39,34,9,26,31.33,1608175471306),
	(40,46,9,25,20.98,1608175592439),
	(41,46,9,27,21.32,1608175763952),
	(42,46,8,28,57.55,1608176186072),
	(43,31,9,29,71.54,1608176289115),
	(44,46,9,29,18.46,1608176307857),
	(45,31,8,28,42.45,1608274312031),
	(46,31,8,30,56.57,1608279146395),
	(47,46,8,30,43.43,1608279190099),
	(48,32,8,31,63.70,1608530574165),
	(49,35,8,22,53.31,1608530815208),
	(50,52,9,32,24.05,1608540119413),
	(51,59,8,33,74.00,1608604646954),
	(52,54,8,34,36.71,1608608083361);

/*!40000 ALTER TABLE `eb_store_bargain_user_help` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_cart
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_cart`;

CREATE TABLE `eb_store_cart` (
  `id` bigint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '购物车表ID',
  `uid` int(10) unsigned NOT NULL COMMENT '用户ID',
  `type` varchar(32) NOT NULL COMMENT '类型',
  `product_id` int(10) unsigned NOT NULL COMMENT '商品ID',
  `product_attr_unique` varchar(16) NOT NULL DEFAULT '' COMMENT '商品属性',
  `cart_num` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '商品数量',
  `is_new` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为立即购买',
  `combination_id` int(11) unsigned DEFAULT '0' COMMENT '拼团id',
  `seckill_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `bargain_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '砍价id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT 'g',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '购物车状态',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`uid`) USING BTREE,
  KEY `goods_id` (`product_id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `uid_2` (`uid`) USING BTREE,
  KEY `uid_3` (`uid`,`is_new`) USING BTREE,
  KEY `type` (`type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='购物车表';

LOCK TABLES `eb_store_cart` WRITE;
/*!40000 ALTER TABLE `eb_store_cart` DISABLE KEYS */;

INSERT INTO `eb_store_cart` (`id`, `uid`, `type`, `product_id`, `product_attr_unique`, `cart_num`, `is_new`, `combination_id`, `seckill_id`, `bargain_id`, `create_time`, `update_time`, `status`)
VALUES
	(2,3,'product',1,'41',1,1,0,0,0,'2020-12-07 18:00:11',NULL,0),
	(4,4,'product',1,'41',1,1,0,0,0,'2020-12-08 14:51:23',NULL,0),
	(6,4,'product',1,'41',1,1,0,0,0,'2020-12-08 14:53:11',NULL,0),
	(7,11,'product',1,'41',1,1,0,0,0,'2020-12-09 14:30:18',NULL,0),
	(9,12,'product',1,'197',1,1,0,0,0,'2020-12-09 16:41:32',NULL,0),
	(10,11,'product',1,'197',1,1,0,0,0,'2020-12-09 16:45:30',NULL,0),
	(11,11,'product',3,'208',1,1,0,0,0,'2020-12-10 10:10:04',NULL,0),
	(12,14,'product',3,'208',1,1,0,0,0,'2020-12-10 10:22:37',NULL,0),
	(13,11,'product',3,'208',1,1,0,0,0,'2020-12-10 10:24:13',NULL,0),
	(14,14,'product',3,'208',1,1,0,0,0,'2020-12-10 10:27:34',NULL,0),
	(15,14,'product',3,'208',1,1,0,0,0,'2020-12-10 10:33:47',NULL,0),
	(16,14,'product',3,'208',1,1,0,0,0,'2020-12-10 10:33:53',NULL,0),
	(17,17,'product',1,'197',1,1,0,0,0,'2020-12-10 14:38:30',NULL,0),
	(19,28,'product',3,'208',1,1,0,0,0,'2020-12-13 08:27:18',NULL,0),
	(20,28,'product',2,'207',1,1,0,0,0,'2020-12-13 08:27:42',NULL,0),
	(21,28,'product',1,'197',1,1,0,0,0,'2020-12-13 08:28:06',NULL,0),
	(22,31,'product',3,'210',1,1,0,0,0,'2020-12-14 16:59:48',NULL,0),
	(23,31,'product',3,'211',1,1,0,0,0,'2020-12-14 17:05:58',NULL,0),
	(26,34,'product',4,'212',1,1,0,0,0,'2020-12-15 09:56:20',NULL,0),
	(27,35,'product',2,'207',1,1,0,0,0,'2020-12-15 10:09:44',NULL,0),
	(28,34,'product',1,'197',1,1,0,0,0,'2020-12-15 10:10:14',NULL,0),
	(29,36,'product',1,'197',1,1,0,0,0,'2020-12-15 11:04:41',NULL,0),
	(30,36,'product',1,'197',1,1,0,0,0,'2020-12-15 11:04:41',NULL,0),
	(31,32,'product',5,'218',1,1,0,0,0,'2020-12-15 15:13:01',NULL,0),
	(32,32,'product',5,'218',1,1,0,0,0,'2020-12-15 15:18:33',NULL,0),
	(33,34,'product',5,'218',1,1,0,0,0,'2020-12-15 15:19:43',NULL,0),
	(34,35,'product',5,'218',1,1,0,0,0,'2020-12-16 09:58:21',NULL,0),
	(35,35,'product',5,'218',1,1,0,0,0,'2020-12-16 10:00:21',NULL,0),
	(37,33,'product',1,'197',1,1,0,0,0,'2020-12-16 10:25:56',NULL,0),
	(38,33,'product',1,'197',1,1,0,0,0,'2020-12-16 10:44:20',NULL,0),
	(39,33,'product',3,'211',1,1,0,0,0,'2020-12-16 10:46:54',NULL,0),
	(40,33,'product',1,'197',1,1,0,0,0,'2020-12-16 10:58:26',NULL,0),
	(41,33,'product',1,'197',1,1,0,0,0,'2020-12-16 11:26:43',NULL,0),
	(42,33,'product',1,'197',1,1,0,0,0,'2020-12-16 11:28:25',NULL,0),
	(43,32,'product',7,'222',5,1,0,0,0,'2020-12-16 14:33:13',NULL,0),
	(45,34,'product',7,'222',2,1,0,0,0,'2020-12-17 11:53:55',NULL,0),
	(46,33,'product',6,'221',1,1,0,0,0,'2020-12-17 15:15:00',NULL,0),
	(49,44,'product',3,'211',1,1,0,0,0,'2020-12-17 15:55:53',NULL,0),
	(50,31,'product',6,'221',1,1,0,0,0,'2020-12-17 16:21:50',NULL,0),
	(51,31,'product',1,'197',3,1,0,0,0,'2020-12-17 16:24:08',NULL,0),
	(55,34,'product',7,'308',1,0,0,0,0,'2020-12-17 18:13:06',NULL,0),
	(56,34,'product',7,'308',1,0,0,0,0,'2020-12-17 18:13:13',NULL,0),
	(60,46,'product',10,'309',1,0,0,0,0,'2020-12-18 09:49:14',NULL,0),
	(61,46,'product',10,'309',1,0,0,0,0,'2020-12-18 09:49:33',NULL,0),
	(62,46,'product',1,'197',1,0,0,0,0,'2020-12-18 09:49:57',NULL,0),
	(63,46,'product',1,'197',1,0,0,0,0,'2020-12-18 09:50:05',NULL,0),
	(68,34,'product',9,'373',1,0,0,0,0,'2020-12-18 14:26:52',NULL,0),
	(69,34,'product',9,'373',1,0,0,0,0,'2020-12-18 14:27:19',NULL,0),
	(83,44,'product',5,'218',1,0,0,0,0,'2020-12-18 15:26:51',NULL,0),
	(84,44,'product',5,'218',1,0,0,0,0,'2020-12-18 15:27:15',NULL,0),
	(87,35,'product',1,'393',1,0,0,0,0,'2020-12-18 15:36:47',NULL,0),
	(88,35,'product',1,'393',1,0,0,0,0,'2020-12-18 15:36:54',NULL,0),
	(89,35,'product',1,'393',1,0,0,0,0,'2020-12-18 15:37:04',NULL,0),
	(90,35,'product',7,'308',1,0,0,0,0,'2020-12-18 15:37:30',NULL,0),
	(93,33,'product',3,'211',1,1,0,0,0,'2020-12-18 15:53:36',NULL,0),
	(95,34,'product',7,'308',1,1,0,0,0,'2020-12-18 16:14:06',NULL,0),
	(97,35,'product',7,'308',1,1,0,0,0,'2020-12-18 16:18:39',NULL,0),
	(101,32,'product',1,'393',1,1,0,0,0,'2020-12-18 16:55:17',NULL,0),
	(103,31,'product',10,'309',2,0,0,0,0,'2020-12-21 12:14:13',NULL,0),
	(107,36,'product',10,'309',1,1,0,0,0,'2020-12-21 15:26:15',NULL,0),
	(109,33,'product',10,'309',1,1,0,0,0,'2020-12-21 15:34:15',NULL,0),
	(111,33,'product',1,'393',1,0,0,0,0,'2020-12-21 15:44:06',NULL,0),
	(112,33,'product',10,'309',1,0,0,0,0,'2020-12-21 15:45:45',NULL,0),
	(117,44,'product',9,'373',1,1,0,0,0,'2020-12-21 17:28:53',NULL,0),
	(118,44,'product',9,'373',1,1,0,0,0,'2020-12-21 17:34:08',NULL,0),
	(119,44,'product',2,'207',2,1,0,0,0,'2020-12-21 17:34:28',NULL,0),
	(120,44,'product',9,'349',1,1,0,0,0,'2020-12-21 17:36:18',NULL,0),
	(122,44,'product',9,'373',1,1,0,0,0,'2020-12-21 17:40:59',NULL,0),
	(124,44,'product',9,'373',1,1,0,0,0,'2020-12-21 17:45:38',NULL,0),
	(125,44,'product',9,'373',1,1,0,0,0,'2020-12-21 17:48:26',NULL,0),
	(127,44,'product',6,'221',1,1,0,0,0,'2020-12-21 17:52:05',NULL,0),
	(137,52,'product',17,'839',1,1,0,0,0,'2020-12-22 15:47:09',NULL,0),
	(139,57,'product',15,'847',1,1,0,0,0,'2020-12-22 15:50:04',NULL,0),
	(140,32,'product',15,'847',1,1,0,0,0,'2020-12-22 15:57:54',NULL,0),
	(142,57,'product',15,'847',1,1,0,0,0,'2020-12-22 16:37:13',NULL,0),
	(144,52,'product',15,'847',2,1,0,0,0,'2020-12-22 16:39:23',NULL,0),
	(145,52,'product',15,'848',2,1,0,0,0,'2020-12-22 16:39:29',NULL,0),
	(146,32,'product',1,'393',1,1,0,0,0,'2020-12-22 16:44:16',NULL,0),
	(148,32,'product',7,'308',1,1,0,0,0,'2020-12-22 16:48:28',NULL,0),
	(149,32,'product',7,'308',1,1,0,0,0,'2020-12-22 16:48:55',NULL,0),
	(150,32,'product',7,'308',1,1,0,0,0,'2020-12-22 16:49:24',NULL,0),
	(151,32,'product',1,'393',1,1,0,0,0,'2020-12-22 17:03:09',NULL,0),
	(153,63,'product',10,'309',1,1,0,0,0,'2020-12-22 21:02:28',NULL,0),
	(154,63,'product',10,'309',1,1,0,0,0,'2020-12-22 21:03:02',NULL,0),
	(156,52,'product',15,'845',1,1,0,0,0,'2020-12-23 09:32:39',NULL,0),
	(157,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:33:22',NULL,0),
	(158,52,'product',15,'848',1,1,0,0,0,'2020-12-23 09:34:01',NULL,0),
	(159,52,'product',15,'848',1,1,0,0,0,'2020-12-23 09:34:07',NULL,0),
	(160,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:35:06',NULL,0),
	(161,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:35:17',NULL,0),
	(162,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:35:38',NULL,0),
	(163,57,'product',15,'848',1,1,0,0,0,'2020-12-23 09:36:01',NULL,0),
	(164,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:38:51',NULL,0),
	(165,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:38:54',NULL,0),
	(166,52,'product',17,'842',2,1,0,0,0,'2020-12-23 09:38:57',NULL,0),
	(167,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:45:09',NULL,0),
	(168,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:45:19',NULL,0),
	(169,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:45:45',NULL,0),
	(170,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:45:52',NULL,0),
	(171,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:46:02',NULL,0),
	(172,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:46:06',NULL,0),
	(173,52,'product',15,'847',1,1,0,0,0,'2020-12-23 09:47:11',NULL,0),
	(176,52,'product',15,'1319',2,1,0,0,0,'2020-12-23 10:05:56',NULL,0),
	(177,52,'product',15,'1319',3,1,0,0,0,'2020-12-23 10:06:30',NULL,0),
	(179,33,'product',1,'393',1,1,0,0,0,'2020-12-23 10:07:17',NULL,0),
	(182,65,'product',10,'309',1,1,0,0,0,'2020-12-23 10:23:25',NULL,0),
	(188,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 11:03:08',NULL,0),
	(194,52,'product',15,'1319',1,1,0,0,0,'2020-12-23 11:42:38',NULL,0),
	(195,57,'product',15,'1319',1,1,0,0,0,'2020-12-23 11:42:56',NULL,0),
	(198,35,'product',20,'1271',1,1,0,0,0,'2020-12-23 12:02:35',NULL,0),
	(200,70,'product',10,'309',1,1,0,0,0,'2020-12-23 15:05:17',NULL,0),
	(201,132,'product',15,'1319',1,1,0,0,0,'2020-12-23 16:25:59',NULL,0),
	(202,137,'product',1,'397',1,1,0,0,0,'2020-12-23 16:26:16',NULL,0),
	(204,140,'product',1,'397',1,1,0,0,0,'2020-12-23 16:29:54',NULL,0),
	(205,140,'product',10,'309',1,1,0,0,0,'2020-12-23 16:30:32',NULL,0),
	(206,144,'product',10,'309',1,1,0,0,0,'2020-12-23 16:34:07',NULL,0),
	(207,144,'product',10,'309',1,1,0,0,0,'2020-12-23 16:34:09',NULL,0),
	(211,124,'product',1,'397',1,1,0,0,0,'2020-12-23 16:42:05',NULL,0),
	(212,156,'product',10,'309',1,1,0,0,0,'2020-12-23 16:50:01',NULL,0),
	(213,158,'product',1,'397',1,1,0,0,0,'2020-12-23 16:53:19',NULL,0),
	(214,162,'product',10,'309',1,1,0,0,0,'2020-12-23 16:58:31',NULL,0),
	(215,165,'product',10,'309',1,1,0,0,0,'2020-12-23 17:00:24',NULL,0),
	(217,158,'product',1,'397',1,1,0,0,0,'2020-12-23 17:04:44',NULL,0),
	(218,169,'product',1,'397',1,1,0,0,0,'2020-12-23 17:07:37',NULL,0),
	(219,33,'product',10,'309',1,1,0,0,0,'2021-01-07 11:27:37',NULL,1),
	(220,33,'product',7,'1852',1,1,0,0,0,'2021-01-07 12:11:03',NULL,1),
	(221,33,'product',7,'1852',1,1,0,0,0,'2021-01-07 12:11:45',NULL,1),
	(222,33,'product',7,'1852',1,1,0,0,0,'2021-01-07 12:14:22',NULL,1),
	(223,175,'product',6,'2162',1,1,0,0,0,'2021-01-07 13:39:42',NULL,1),
	(227,33,'product',10,'309',1,1,0,0,0,'2021-01-07 14:42:31',NULL,1),
	(228,33,'product',6,'2162',1,1,0,0,0,'2021-01-07 14:43:24',NULL,1),
	(229,33,'product',6,'2162',1,1,0,0,0,'2021-01-07 14:46:29',NULL,1);

/*!40000 ALTER TABLE `eb_store_cart` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_combination
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_combination`;

CREATE TABLE `eb_store_combination` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '拼团商品ID',
  `product_id` int(10) unsigned NOT NULL COMMENT '商品id',
  `mer_id` int(10) unsigned DEFAULT '0' COMMENT '商户id',
  `image` varchar(255) NOT NULL COMMENT '推荐图',
  `images` varchar(2000) NOT NULL COMMENT '轮播图',
  `title` varchar(255) NOT NULL COMMENT '活动标题',
  `attr` varchar(255) DEFAULT NULL COMMENT '活动属性',
  `people` int(2) unsigned NOT NULL COMMENT '参团人数',
  `info` varchar(255) NOT NULL COMMENT '简介',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '价格',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `sales` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '销量',
  `stock` int(10) unsigned NOT NULL COMMENT '库存',
  `add_time` bigint(14) NOT NULL COMMENT '添加时间',
  `is_host` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '推荐',
  `is_show` tinyint(1) unsigned NOT NULL COMMENT '商品状态',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `combination` tinyint(1) unsigned DEFAULT '1',
  `mer_use` tinyint(1) unsigned DEFAULT NULL COMMENT '商户是否可用1可用0不可用',
  `is_postage` tinyint(1) unsigned DEFAULT NULL COMMENT '是否包邮1是0否',
  `postage` decimal(10,2) unsigned DEFAULT NULL COMMENT '邮费',
  `start_time` bigint(14) unsigned NOT NULL COMMENT '拼团开始时间',
  `stop_time` bigint(14) unsigned NOT NULL COMMENT '拼团结束时间',
  `effective_time` int(11) NOT NULL DEFAULT '0' COMMENT '拼团订单有效时间(小时)',
  `cost` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '拼图商品成本',
  `browse` int(11) DEFAULT '0' COMMENT '浏览量',
  `unit_name` varchar(32) NOT NULL DEFAULT '' COMMENT '单位名',
  `temp_id` int(11) NOT NULL COMMENT '运费模板ID',
  `weight` decimal(8,2) DEFAULT '0.00' COMMENT '重量',
  `volume` decimal(8,2) DEFAULT '0.00' COMMENT '体积',
  `num` int(11) DEFAULT NULL COMMENT '单次购买数量',
  `quota` int(10) NOT NULL DEFAULT '0' COMMENT '限购总数',
  `quota_show` int(10) NOT NULL DEFAULT '0' COMMENT '限量总数显示',
  `ot_price` decimal(10,2) NOT NULL COMMENT '原价',
  `once_num` int(11) NOT NULL DEFAULT '0' COMMENT '每个订单可购买数量',
  `virtual_ration` int(11) NOT NULL DEFAULT '100' COMMENT '虚拟成团百分比',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='拼团商品表';

LOCK TABLES `eb_store_combination` WRITE;
/*!40000 ALTER TABLE `eb_store_combination` DISABLE KEYS */;

INSERT INTO `eb_store_combination` (`id`, `product_id`, `mer_id`, `image`, `images`, `title`, `attr`, `people`, `info`, `price`, `sort`, `sales`, `stock`, `add_time`, `is_host`, `is_show`, `is_del`, `combination`, `mer_use`, `is_postage`, `postage`, `start_time`, `stop_time`, `effective_time`, `cost`, `browse`, `unit_name`, `temp_id`, `weight`, `volume`, `num`, `quota`, `quota_show`, `ot_price`, `once_num`, `virtual_ration`)
VALUES
	(1,1,0,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','[\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\"]','圈粉',NULL,2,'圈粉',99.00,1,1,429,1607409888895,1,0,1,1,NULL,0,NULL,1606752000000,1609430399999,24,9.00,0,'T',1,0.00,0.00,1,429,430,9.00,1,50),
	(2,2,0,'image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','[\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\"]','iphone11',NULL,2,'苹果11',1.00,1,0,20,1607500143618,0,0,1,1,NULL,0,NULL,1606752000000,1612108799999,24,12000.00,0,'123',1,0.00,0.00,10,20,20,12000.00,1,1),
	(3,2,0,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','[\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\"]','iphone11',NULL,10,'苹果11',9999.00,1,0,19,1608186172374,0,0,1,1,NULL,0,NULL,1606752000000,1612108799999,24,12000.00,0,'123',1,0.00,0.00,1,19,19,12000.00,1,50),
	(4,9,0,'http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg','[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\"]','【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机',NULL,10,'【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机',1.00,0,0,2997,1608191461386,1,0,1,1,NULL,0,NULL,1606752000000,1612108799999,24,0.00,0,'件',2,0.00,0.00,1,2997,2997,0.00,1,50),
	(5,9,0,'http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg','[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\"]','【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机',NULL,2,'【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机',10000.00,0,5,2990,1608257979654,1,0,0,1,NULL,0,NULL,1608134400000,1608652799999,1,0.00,0,'件',2,0.00,0.00,5,2990,2990,0.00,12,50),
	(6,7,0,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','[\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\"]','腰果',NULL,2,'腰果',99.90,0,1,1120,1608258015222,1,0,1,1,NULL,0,NULL,1608134400000,1608825599999,1,200.00,0,'盒',2,0.00,0.00,1,1120,1120,200.00,1,50),
	(7,13,0,'img.alicdn.com\\/imgextra\\/i4\\/1794176171\\/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg','[\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01GwvntW1vSMkhgUUw5_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i3/1794176171/O1CN01OdxsQm1vSMkfOhu8B_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i4/1794176171/O1CN013HlIBb1vSMklCF1Hj_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01bB9sy01vSMkjBsRO7_!!1794176171.jpg\"]','P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机',NULL,3,'P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机',1000.00,0,0,995,1608524012225,0,0,1,1,NULL,0,NULL,1608480000000,1609430399999,1,0.00,0,'件',2,0.00,0.00,10,995,995,0.00,10,66),
	(8,1,0,'image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','[\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\"]','圈粉',NULL,2,'圈粉',10.00,1,0,27,1608542699711,0,1,0,1,NULL,0,NULL,1607961600000,1609343999999,1,9.00,0,'T',1,0.00,0.00,1,27,27,9.00,1,50),
	(9,15,0,'//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg','[\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\"]','【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',NULL,2,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',159.00,99,0,1780,1608795666844,0,1,0,1,NULL,0,NULL,1608912000000,1609084799999,1,199.00,0,'件',3,0.00,0.00,9,1780,1780,199.00,3,50),
	(10,15,0,'//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg','[\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\"]','【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',NULL,2,'【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男',159.00,99,0,1780,1609247066041,0,1,0,1,NULL,0,NULL,1609171200000,1611935999999,1,199.00,0,'件',3,0.00,0.00,1,1780,1780,199.00,1,50),
	(11,23,0,'http://img30.360buyimg.com/popWaterMark/jfs/t1/141117/35/18227/113537/5fd8376eE93b27175/f9d8a919c323560b.jpg','[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141117/35/18227/113537/5fd8376eE93b27175/f9d8a919c323560b.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146689/39/16724/158244/5fc8d670Edc0060dd/e70c58b46a3f420f.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/129677/10/18512/127024/5fc8d672E1f941708/006aa769a7e9983f.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141276/6/16690/236799/5fc8d671E6a50f438/34e9a1976467c13b.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151245/40/9184/108874/5fc8d672Efc76dfca/11f7d90e1fa1250a.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/143182/36/16820/181394/5fc8d70eE49ad4826/b1171a27eb80b2e8.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141234/22/16836/107030/5fc8d670Ea6396c2e/dc1f5db7393b9057.jpg\"]','杯具熊（BEDDYBEAR）儿童保温杯带吸管儿童水杯316不锈钢双盖两用便携儿童保温壶600ML限量圣诞款-大脸鹿',NULL,2,'杯具熊（BEDDYBEAR）儿童保温杯带吸管儿童水杯316不锈钢双盖两用便携儿童保温壶600ML限量圣诞款-大脸鹿',228.00,0,0,119988,1609897932291,0,0,0,1,NULL,0,NULL,1609948800000,1613750399999,1,228.00,0,'个',2,0.00,0.00,1,13332,13332,228.00,1,50),
	(12,23,0,'http://img30.360buyimg.com/popWaterMark/jfs/t1/141117/35/18227/113537/5fd8376eE93b27175/f9d8a919c323560b.jpg','[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141117/35/18227/113537/5fd8376eE93b27175/f9d8a919c323560b.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146689/39/16724/158244/5fc8d670Edc0060dd/e70c58b46a3f420f.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/129677/10/18512/127024/5fc8d672E1f941708/006aa769a7e9983f.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141276/6/16690/236799/5fc8d671E6a50f438/34e9a1976467c13b.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151245/40/9184/108874/5fc8d672Efc76dfca/11f7d90e1fa1250a.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/143182/36/16820/181394/5fc8d70eE49ad4826/b1171a27eb80b2e8.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141234/22/16836/107030/5fc8d670Ea6396c2e/dc1f5db7393b9057.jpg\"]','杯具熊（BEDDYBEAR）儿童保温杯带吸管儿童水杯316不锈钢双盖两用便携儿童保温壶600ML限量圣诞款-大脸鹿',NULL,2,'杯具熊（BEDDYBEAR）儿童保温杯带吸管儿童水杯316不锈钢双盖两用便携儿童保温壶600ML限量圣诞款-大脸鹿',228.00,0,0,119988,1609898761823,0,0,0,1,NULL,0,NULL,1609948800000,1613318399999,1,228.00,0,'个',2,0.00,0.00,3,119988,119988,228.00,4,50),
	(13,23,0,'http://img30.360buyimg.com/popWaterMark/jfs/t1/141117/35/18227/113537/5fd8376eE93b27175/f9d8a919c323560b.jpg','[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141117/35/18227/113537/5fd8376eE93b27175/f9d8a919c323560b.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146689/39/16724/158244/5fc8d670Edc0060dd/e70c58b46a3f420f.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/129677/10/18512/127024/5fc8d672E1f941708/006aa769a7e9983f.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141276/6/16690/236799/5fc8d671E6a50f438/34e9a1976467c13b.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151245/40/9184/108874/5fc8d672Efc76dfca/11f7d90e1fa1250a.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/143182/36/16820/181394/5fc8d70eE49ad4826/b1171a27eb80b2e8.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141234/22/16836/107030/5fc8d670Ea6396c2e/dc1f5db7393b9057.jpg\"]','杯具熊（BEDDYBEAR）儿童保温杯带吸管儿童水杯316不锈钢双盖两用便携儿童保温壶600ML限量圣诞款-大脸鹿',NULL,4,'杯具熊（BEDDYBEAR）儿童保温杯带吸管儿童水杯316不锈钢双盖两用便携儿童保温壶600ML限量圣诞款-大脸鹿',228.00,6,0,119988,1609898928538,0,0,0,1,NULL,0,NULL,1609948800000,1613577599999,5,228.00,0,'个',2,0.00,0.00,3,119988,119988,228.00,2,75);

/*!40000 ALTER TABLE `eb_store_combination` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_coupon
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_coupon`;

CREATE TABLE `eb_store_coupon` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '优惠券表ID',
  `name` varchar(64) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  `money` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '兑换的优惠券面值',
  `is_limited` tinyint(1) DEFAULT '0' COMMENT '是否限量, 默认0 不限量， 1限量',
  `total` int(11) NOT NULL DEFAULT '0' COMMENT '发放总数',
  `last_total` int(11) DEFAULT '0' COMMENT '剩余数量',
  `use_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '使用类型 1 全场通用, 2 商品券, 3 品类券',
  `primary_key` varchar(255) NOT NULL DEFAULT '' COMMENT '所属商品id / 分类id',
  `min_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '最低消费，0代表不限制',
  `receive_start_time` timestamp NOT NULL COMMENT '可领取开始时间',
  `receive_end_time` timestamp NULL DEFAULT NULL COMMENT '可领取结束时间',
  `is_fixed_time` tinyint(1) DEFAULT '0' COMMENT '是否固定使用时间, 默认0 否， 1是',
  `use_start_time` timestamp NULL DEFAULT NULL COMMENT '可使用时间范围 开始时间',
  `use_end_time` timestamp NULL DEFAULT NULL COMMENT '可使用时间范围 结束时间',
  `day` int(4) DEFAULT '0' COMMENT '天数',
  `type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '优惠券类型 1 手动领取, 2 新人券, 3 赠送券',
  `sort` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态（0：关闭，1：开启）',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除 状态（0：否，1：是）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `state` (`status`) USING BTREE,
  KEY `is_del` (`is_del`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='优惠券表';

LOCK TABLES `eb_store_coupon` WRITE;
/*!40000 ALTER TABLE `eb_store_coupon` DISABLE KEYS */;

INSERT INTO `eb_store_coupon` (`id`, `name`, `money`, `is_limited`, `total`, `last_total`, `use_type`, `primary_key`, `min_price`, `receive_start_time`, `receive_end_time`, `is_fixed_time`, `use_start_time`, `use_end_time`, `day`, `type`, `sort`, `status`, `is_del`, `create_time`, `update_time`)
VALUES
	(1,'优惠',10.00,0,0,0,1,'',0.00,'2020-12-09 15:10:35',NULL,0,NULL,NULL,10,1,1,1,0,'2020-12-09 15:10:34','2020-12-29 14:33:46'),
	(2,'发送优惠券',10.00,0,0,0,1,'',0.00,'2020-12-15 16:06:10',NULL,0,NULL,NULL,10,1,0,1,0,'2020-12-15 16:06:10','2020-12-15 16:06:14'),
	(3,'888',1.00,0,0,0,1,'',0.00,'2020-12-01 00:00:00','2020-12-21 00:00:00',0,NULL,NULL,10,1,0,1,0,'2020-12-22 12:02:31','2020-12-22 12:02:31'),
	(4,' 踩踩踩',1.00,0,0,0,1,'',0.00,'2020-12-23 16:23:13',NULL,0,NULL,NULL,2,2,0,1,0,'2020-12-23 16:23:13','2020-12-23 17:56:34'),
	(5,'可乐商品大礼包',1.00,0,0,0,2,'5',0.00,'2020-12-26 16:53:37',NULL,1,'2020-12-26 00:00:00','2020-12-30 00:00:00',0,3,0,1,0,'2020-12-26 16:53:37','2020-12-26 16:53:37'),
	(6,'test',10.00,0,0,0,1,'',100.00,'2020-12-28 17:35:36',NULL,0,NULL,NULL,40,1,0,1,0,'2020-12-28 17:35:36','2020-12-28 17:35:36'),
	(7,'test1111',10.00,1,100000,100000,1,'',0.00,'2020-12-28 17:37:03',NULL,0,NULL,NULL,100,3,0,1,0,'2020-12-28 17:37:03','2020-12-28 17:37:03'),
	(8,'test11111',10.00,1,100000,100000,1,'',100.00,'2020-12-28 17:41:04',NULL,0,NULL,NULL,90,3,0,1,0,'2020-12-28 17:41:04','2020-12-29 14:33:39'),
	(9,'优惠',10.00,0,0,0,1,'',1.00,'2020-12-29 17:56:56',NULL,0,NULL,NULL,10,1,1,1,0,'2020-12-29 17:56:56','2020-12-29 17:56:56'),
	(10,'优惠',10.00,0,0,0,1,'',1.00,'2020-12-29 17:57:12',NULL,0,NULL,NULL,10,1,1,1,0,'2020-12-29 17:57:12','2020-12-29 17:57:12');

/*!40000 ALTER TABLE `eb_store_coupon` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_coupon_user
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_coupon_user`;

CREATE TABLE `eb_store_coupon_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `coupon_id` int(10) NOT NULL COMMENT '优惠券发布id',
  `cid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '兑换的项目id',
  `uid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '领取人id',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  `money` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '优惠券的面值',
  `min_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '最低消费多少金额可用优惠券',
  `type` varchar(32) NOT NULL DEFAULT 'send' COMMENT '获取方式，send后台发放, 用户领取 get',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0：未使用，1：已使用, 2:已失效）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `start_time` timestamp NULL DEFAULT NULL COMMENT '开始使用时间',
  `end_time` timestamp NULL DEFAULT NULL COMMENT '过期时间',
  `use_time` timestamp NULL DEFAULT NULL COMMENT '使用时间',
  `use_type` tinyint(1) DEFAULT '1' COMMENT '使用类型 1 全场通用, 2 商品券, 3 品类券',
  `primary_key` varchar(255) DEFAULT NULL COMMENT '所属商品id / 分类id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `cid` (`cid`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `end_time` (`end_time`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='优惠券记录表';

LOCK TABLES `eb_store_coupon_user` WRITE;
/*!40000 ALTER TABLE `eb_store_coupon_user` DISABLE KEYS */;

INSERT INTO `eb_store_coupon_user` (`id`, `coupon_id`, `cid`, `uid`, `name`, `money`, `min_price`, `type`, `status`, `create_time`, `update_time`, `start_time`, `end_time`, `use_time`, `use_type`, `primary_key`)
VALUES
	(1,1,0,11,'优惠',10.00,0.00,'send',0,'2020-12-09 15:10:47','2020-12-09 15:10:47','2020-12-09 00:00:00','2020-12-20 00:00:00',NULL,1,NULL),
	(2,1,0,28,'优惠',10.00,0.00,'send',0,'2020-12-13 08:24:24','2020-12-13 08:24:24','2020-12-13 00:00:00','2020-12-24 00:00:00',NULL,1,NULL),
	(3,1,0,31,'优惠',10.00,0.00,'send',0,'2020-12-14 17:06:43','2020-12-14 17:06:43','2020-12-14 00:00:00','2020-12-25 00:00:00',NULL,1,NULL),
	(4,1,0,38,'优惠',10.00,0.00,'send',0,'2020-12-15 10:15:07','2020-12-15 10:15:07','2020-12-15 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(5,2,0,34,'发送优惠券',10.00,0.00,'send',0,'2020-12-15 16:06:27','2020-12-15 16:06:27','2020-12-15 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(6,1,0,43,'优惠',10.00,0.00,'send',0,'2020-12-16 16:49:35','2020-12-16 16:49:35','2020-12-16 00:00:00','2020-12-27 00:00:00',NULL,1,NULL),
	(7,2,0,43,'发送优惠券',10.00,0.00,'send',0,'2020-12-16 16:49:36','2020-12-16 16:49:36','2020-12-16 00:00:00','2020-12-27 00:00:00',NULL,1,NULL),
	(8,1,0,45,'优惠',10.00,0.00,'send',0,'2020-12-17 10:24:32','2020-12-17 10:24:32','2020-12-17 00:00:00','2020-12-28 00:00:00',NULL,1,NULL),
	(9,2,0,45,'发送优惠券',10.00,0.00,'send',0,'2020-12-17 10:24:33','2020-12-17 10:24:33','2020-12-17 00:00:00','2020-12-28 00:00:00',NULL,1,NULL),
	(10,1,0,47,'优惠',10.00,0.00,'send',0,'2020-12-17 11:36:52','2020-12-17 11:36:52','2020-12-17 00:00:00','2020-12-28 00:00:00',NULL,1,NULL),
	(11,2,0,47,'发送优惠券',10.00,0.00,'send',0,'2020-12-17 11:36:56','2020-12-17 11:36:56','2020-12-17 00:00:00','2020-12-28 00:00:00',NULL,1,NULL),
	(12,1,0,44,'优惠',10.00,0.00,'send',0,'2020-12-18 15:44:20','2020-12-18 15:44:20','2020-12-18 00:00:00','2020-12-29 00:00:00',NULL,1,NULL),
	(13,1,0,46,'优惠',10.00,0.00,'send',0,'2020-12-18 15:47:37','2020-12-18 15:47:37','2020-12-18 00:00:00','2020-12-29 00:00:00',NULL,1,NULL),
	(14,1,0,33,'优惠',10.00,0.00,'send',0,'2020-12-18 16:07:49','2020-12-18 16:07:49','2020-12-18 00:00:00','2020-12-29 00:00:00',NULL,1,NULL),
	(15,1,0,54,'优惠',10.00,0.00,'send',0,'2020-12-21 20:05:13','2020-12-21 20:05:13','2020-12-21 00:00:00','2021-01-01 00:00:00',NULL,1,NULL),
	(16,2,0,54,'发送优惠券',10.00,0.00,'send',0,'2020-12-21 20:05:14','2020-12-21 20:05:14','2020-12-21 00:00:00','2021-01-01 00:00:00',NULL,1,NULL),
	(17,1,0,56,'优惠',10.00,0.00,'send',0,'2020-12-22 08:50:16','2020-12-22 08:50:16','2020-12-22 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(18,2,0,56,'发送优惠券',10.00,0.00,'send',0,'2020-12-22 08:50:17','2020-12-22 08:50:17','2020-12-22 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(19,1,0,63,'优惠',10.00,0.00,'send',0,'2020-12-22 21:01:47','2020-12-22 21:01:47','2020-12-22 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(20,2,0,63,'发送优惠券',10.00,0.00,'send',0,'2020-12-22 21:01:48','2020-12-22 21:01:48','2020-12-22 00:00:00','2021-01-02 00:00:00',NULL,1,NULL),
	(21,1,0,64,'优惠',10.00,0.00,'send',0,'2020-12-23 09:51:26','2020-12-23 09:51:26','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(22,2,0,64,'发送优惠券',10.00,0.00,'send',0,'2020-12-23 09:51:26','2020-12-23 09:51:26','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(23,1,0,65,'优惠',10.00,0.00,'send',0,'2020-12-23 10:22:32','2020-12-23 10:22:32','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(24,2,0,65,'发送优惠券',10.00,0.00,'send',0,'2020-12-23 10:22:34','2020-12-23 10:22:34','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(25,2,0,66,'发送优惠券',10.00,0.00,'send',0,'2020-12-23 10:40:18','2020-12-23 10:40:18','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(26,1,0,66,'优惠',10.00,0.00,'send',0,'2020-12-23 10:40:20','2020-12-23 10:40:20','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(27,1,0,67,'优惠',10.00,0.00,'send',0,'2020-12-23 10:53:31','2020-12-23 10:53:31','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(28,2,0,67,'发送优惠券',10.00,0.00,'send',0,'2020-12-23 10:53:32','2020-12-23 10:53:32','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(29,1,0,68,'优惠',10.00,0.00,'send',0,'2020-12-23 12:31:15','2020-12-23 12:31:15','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(30,2,0,68,'发送优惠券',10.00,0.00,'send',0,'2020-12-23 12:31:17','2020-12-23 12:31:17','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(31,1,0,90,'优惠',10.00,0.00,'send',0,'2020-12-23 16:01:47','2020-12-23 16:01:47','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(32,1,0,109,'优惠',10.00,0.00,'send',0,'2020-12-23 16:10:30','2020-12-23 16:10:30','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(33,2,0,109,'发送优惠券',10.00,0.00,'send',0,'2020-12-23 16:18:33','2020-12-23 16:18:33','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(34,1,0,156,'优惠',10.00,0.00,'send',0,'2020-12-23 16:49:48','2020-12-23 16:49:48','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(35,2,0,156,'发送优惠券',10.00,0.00,'send',0,'2020-12-23 16:49:57','2020-12-23 16:49:57','2020-12-23 00:00:00','2021-01-03 00:00:00',NULL,1,NULL),
	(36,4,0,174,' 踩踩踩',1.00,0.00,'send',0,'2020-12-23 19:54:37','2020-12-23 19:54:37','2020-12-23 00:00:00','2020-12-26 00:00:00',NULL,1,NULL),
	(37,1,0,174,'优惠',10.00,0.00,'send',0,'2020-12-24 10:27:06','2020-12-24 10:27:06','2020-12-24 00:00:00','2021-01-04 00:00:00',NULL,1,NULL),
	(38,1,0,172,'优惠',10.00,0.00,'send',0,'2020-12-24 12:28:18','2020-12-24 12:28:18','2020-12-24 00:00:00','2021-01-04 00:00:00',NULL,1,NULL),
	(39,2,0,174,'发送优惠券',10.00,0.00,'send',0,'2020-12-24 13:58:08','2020-12-24 13:58:08','2020-12-24 00:00:00','2021-01-04 00:00:00',NULL,1,NULL),
	(40,2,0,173,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(41,2,0,172,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(42,2,0,171,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(43,2,0,170,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(44,2,0,169,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(45,2,0,168,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(46,2,0,167,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(47,2,0,166,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(48,2,0,165,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(49,2,0,164,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(50,2,0,163,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(51,2,0,162,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(52,2,0,161,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(53,2,0,160,'发送优惠券',10.00,0.00,'send',0,'2020-12-25 16:09:55','2020-12-25 16:09:55','2020-12-25 00:00:00','2021-01-05 00:00:00',NULL,1,NULL),
	(54,5,0,173,'可乐商品大礼包',1.00,0.00,'send',0,'2020-12-28 17:58:28','2020-12-28 17:58:28','2020-12-26 00:00:00','2020-12-30 00:00:00',NULL,2,NULL),
	(55,5,0,171,'可乐商品大礼包',1.00,0.00,'send',0,'2020-12-28 17:58:28','2020-12-28 17:58:28','2020-12-26 00:00:00','2020-12-30 00:00:00',NULL,2,NULL),
	(56,8,0,174,'test11111',10.00,100.00,'send',0,'2020-12-28 19:48:24','2020-12-28 19:48:24','2020-12-28 00:00:00','2021-03-29 00:00:00',NULL,1,NULL),
	(57,10,0,174,'优惠',10.00,1.00,'send',0,'2020-12-30 14:58:22','2020-12-30 14:58:22','2020-12-30 00:00:00','2021-01-10 00:00:00',NULL,1,NULL),
	(58,1,0,173,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(59,1,0,171,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(60,1,0,170,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(61,1,0,169,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(62,1,0,168,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(63,1,0,167,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(64,1,0,166,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(65,1,0,165,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(66,1,0,164,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(67,1,0,163,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(68,1,0,162,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(69,1,0,161,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(70,1,0,160,'优惠',10.00,0.00,'send',0,'2020-12-31 22:29:38','2020-12-31 22:29:38','2020-12-31 00:00:00','2021-01-11 00:00:00',NULL,1,NULL),
	(71,8,0,173,'test11111',10.00,100.00,'send',0,'2021-01-01 18:10:56','2021-01-01 18:10:56','2021-01-01 00:00:00','2021-04-02 00:00:00',NULL,1,NULL),
	(72,7,0,174,'test1111',10.00,0.00,'send',0,'2021-01-06 10:27:19','2021-01-06 10:27:19','2021-01-06 00:00:00','2021-04-17 00:00:00',NULL,1,NULL),
	(73,10,0,175,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(74,10,0,173,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(75,10,0,172,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(76,10,0,171,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(77,10,0,170,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(78,10,0,169,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(79,10,0,168,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(80,10,0,167,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(81,10,0,166,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(82,10,0,165,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(83,10,0,164,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(84,10,0,163,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(85,10,0,162,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(86,10,0,161,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:38','2021-01-07 14:29:38','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(87,9,0,175,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(88,9,0,174,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(89,9,0,173,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(90,9,0,172,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(91,9,0,171,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(92,9,0,170,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(93,9,0,169,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(94,9,0,168,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(95,9,0,167,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(96,9,0,166,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(97,9,0,165,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(98,9,0,164,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(99,9,0,163,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(100,9,0,162,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL),
	(101,9,0,161,'优惠',10.00,1.00,'send',0,'2021-01-07 14:29:47','2021-01-07 14:29:47','2021-01-07 00:00:00','2021-01-18 00:00:00',NULL,1,NULL);

/*!40000 ALTER TABLE `eb_store_coupon_user` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_order
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_order`;

CREATE TABLE `eb_store_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单ID',
  `order_id` varchar(32) NOT NULL COMMENT '订单号',
  `uid` int(11) unsigned NOT NULL COMMENT '用户id',
  `real_name` varchar(32) NOT NULL COMMENT '用户姓名',
  `user_phone` varchar(18) NOT NULL COMMENT '用户电话',
  `user_address` varchar(100) NOT NULL COMMENT '详细地址',
  `freight_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '运费金额',
  `total_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单商品总数',
  `total_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单总价',
  `total_postage` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '邮费',
  `pay_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '实际支付金额',
  `pay_postage` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '支付邮费',
  `deduction_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '抵扣金额',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券id',
  `coupon_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '优惠券金额',
  `paid` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '支付状态',
  `pay_time` timestamp NULL DEFAULT NULL COMMENT '支付时间',
  `pay_type` varchar(32) NOT NULL COMMENT '支付方式',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态（-1 : 申请退款 -2 : 退货成功 0：待发货；1：待收货；2：已收货，待评价；3：已完成；）',
  `refund_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0 未退款 1 申请中 2 已退款',
  `refund_reason_wap_img` varchar(5000) DEFAULT NULL COMMENT '退款图片',
  `refund_reason_wap_explain` varchar(255) DEFAULT NULL COMMENT '退款用户说明',
  `refund_reason_wap` varchar(255) DEFAULT NULL COMMENT '前台退款原因',
  `refund_reason` varchar(255) DEFAULT NULL COMMENT '不退款的理由',
  `refund_reason_time` timestamp NULL DEFAULT NULL COMMENT '退款时间',
  `refund_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `delivery_name` varchar(64) DEFAULT NULL COMMENT '快递名称/送货人姓名',
  `delivery_type` varchar(32) DEFAULT NULL COMMENT '发货类型',
  `delivery_id` varchar(64) DEFAULT NULL COMMENT '快递单号/手机号',
  `gain_integral` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '消费赚取积分',
  `use_integral` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '使用积分',
  `back_integral` decimal(8,2) unsigned DEFAULT NULL COMMENT '给用户退了多少积分',
  `mark` varchar(512) NOT NULL COMMENT '备注',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `unique` char(32) NOT NULL COMMENT '唯一id(md5加密)类似id',
  `remark` varchar(512) DEFAULT NULL COMMENT '管理员备注',
  `mer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商户ID',
  `is_mer_check` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `combination_id` int(11) unsigned DEFAULT '0' COMMENT '拼团商品id0一般商品',
  `pink_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '拼团id 0没有拼团',
  `cost` decimal(8,2) unsigned NOT NULL COMMENT '成本价',
  `seckill_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `bargain_id` int(11) unsigned DEFAULT '0' COMMENT '砍价id',
  `verify_code` varchar(12) NOT NULL DEFAULT '' COMMENT '核销码',
  `store_id` int(11) NOT NULL DEFAULT '0' COMMENT '门店id',
  `shipping_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '配送方式 1=快递 ，2=门店自提',
  `clerk_id` int(11) NOT NULL DEFAULT '0' COMMENT '店员id/核销员id',
  `is_channel` tinyint(1) unsigned DEFAULT '0' COMMENT '支付渠道(0微信公众号1微信小程序)',
  `is_remind` tinyint(1) unsigned DEFAULT '0' COMMENT '消息提醒',
  `is_system_del` tinyint(1) DEFAULT '0' COMMENT '后台是否删除',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `delivery_code` varchar(50) DEFAULT NULL COMMENT '快递公司简称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `order_id_2` (`order_id`,`uid`) USING BTREE,
  UNIQUE KEY `unique` (`unique`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `add_time` (`create_time`) USING BTREE,
  KEY `pay_price` (`pay_price`) USING BTREE,
  KEY `paid` (`paid`) USING BTREE,
  KEY `pay_time` (`pay_time`) USING BTREE,
  KEY `pay_type` (`pay_type`) USING BTREE,
  KEY `status` (`status`) USING BTREE,
  KEY `is_del` (`is_del`) USING BTREE,
  KEY `coupon_id` (`coupon_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单表';

LOCK TABLES `eb_store_order` WRITE;
/*!40000 ALTER TABLE `eb_store_order` DISABLE KEYS */;

INSERT INTO `eb_store_order` (`id`, `order_id`, `uid`, `real_name`, `user_phone`, `user_address`, `freight_price`, `total_num`, `total_price`, `total_postage`, `pay_price`, `pay_postage`, `deduction_price`, `coupon_id`, `coupon_price`, `paid`, `pay_time`, `pay_type`, `create_time`, `status`, `refund_status`, `refund_reason_wap_img`, `refund_reason_wap_explain`, `refund_reason_wap`, `refund_reason`, `refund_reason_time`, `refund_price`, `delivery_name`, `delivery_type`, `delivery_id`, `gain_integral`, `use_integral`, `back_integral`, `mark`, `is_del`, `unique`, `remark`, `mer_id`, `is_mer_check`, `combination_id`, `pink_id`, `cost`, `seckill_id`, `bargain_id`, `verify_code`, `store_id`, `shipping_type`, `clerk_id`, `is_channel`, `is_remind`, `is_system_del`, `update_time`, `delivery_code`)
VALUES
	(3,'wx2020120814523442599',4,'裴明','18292417675','陕西省西安市雁塔区曲江三迪枫丹(西安市雁塔区)',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-08 14:52:34',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'eba52e5b454393b0474a246dfbb331ed',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-08 14:52:34',NULL),
	(4,'wx2020120814564193287',1,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2020-12-08 14:56:42','yue','2020-12-08 14:56:41',1,0,NULL,'用户取消拼团订单，申请退款',NULL,'就不退','2020-12-09 14:57:00',99.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'d0a960ab37f241d21ac5aff9ad05d2aa',NULL,0,0,1,1,9.00,0,0,'',0,1,0,0,0,0,'2020-12-09 15:27:13',NULL),
	(5,'wx2020120914341124901',11,'王超超','18741256325','陕西省西安市新城区韩森寨',0.00,1,99.00,1.00,100.00,1.00,0.00,0,0.00,0,NULL,'weixin','2020-12-09 14:34:11',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'5e86ff22b76d8a702266b9ba9849ac0f',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-09 14:34:11',NULL),
	(6,'wx2020120916400840588',12,'pmm','18292417675','山西省太原市市辖区xxx',0.00,1,99.00,1.00,100.00,1.00,0.00,0,0.00,1,'2020-12-09 16:40:09','yue','2020-12-09 16:40:08',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'0364228d2586798b472ba695ff871e22',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-09 16:40:08',NULL),
	(7,'wx2020121010100962322',11,'王超超','18741256325','陕西省西安市新城区韩森寨',0.00,1,0.00,1.00,1.00,1.00,0.00,1,0.00,1,'2020-12-10 10:10:48','yue','2020-12-10 10:10:09',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'17c5defbce0434da90792d69e32bd58e',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-10 10:10:47',NULL),
	(8,'wx2020121010333151706',14,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-10 10:33:31',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'7d74b9aaffbc4af8f3497a224be12754',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-10 10:33:31',NULL),
	(9,'wx2020121010335820375',14,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-10 10:33:58',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'c295990b159f66a3d11061af139e2c85',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-10 10:33:58',NULL),
	(10,'wx2020121015281113274',19,'小脑斧','13991666666','河南省郑州市二七区手术室',0.00,1,99.00,1.00,100.00,1.00,0.00,0,0.00,1,'2020-12-10 15:28:12','yue','2020-12-10 15:28:11',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'d074a1b539fa3808d72b9085d5de0fda',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-10 15:28:11',NULL),
	(11,'wx2020121115214342940',19,'小脑斧','13991666666','河南省郑州市二七区手术室',0.00,1,10.00,1.00,11.00,1.00,0.00,0,0.00,1,'2020-12-11 15:21:44','yue','2020-12-11 15:21:43',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'3e9abf0d940139662e48943a001d43f1',NULL,0,0,0,0,0.00,2,0,'',0,1,0,0,0,0,'2020-12-11 15:21:43',NULL),
	(12,'wx2020121417063762574',31,'小脑虎','18888888888','陕西省西安市市辖区哈罗闪问',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-14 17:06:43','weixin','2020-12-14 17:06:37',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'6dbacab06bada2baff73b0cc57c3eb86',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-14 17:06:43',NULL),
	(13,'wx2020121509310499980',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2020-12-15 09:31:04','yue','2020-12-15 09:31:04',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'12478683083d4ff3ee0b982ed0fe3ad0',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-15 09:31:04',NULL),
	(14,'wx2020121509571880738',34,'弄','13000000000','山西省太原市小店区哦吼',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-15 09:57:18',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'3e140d88ca25f0eea4864247a09f07c0',NULL,0,0,0,0,50.00,0,6,'',0,1,0,0,0,0,'2020-12-15 09:57:18',NULL),
	(15,'wx2020121510242722269',34,'哦破功','13000000000','山西省太原市迎泽区我咯后',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,1,'2020-12-15 10:24:28','yue','2020-12-15 10:24:27',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'cbd550728e6e54746adb962d98510fce',NULL,0,0,0,0,9.00,0,1,'',0,1,0,0,0,0,'2020-12-15 10:24:28',NULL),
	(16,'wx2020121510340894903',34,'你明明','13000000000','山西省太原市迎泽区您咯咯',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,1,'2020-12-15 10:34:09','yue','2020-12-15 10:34:08',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'f8644284cc2d58f9e21772506165487c',NULL,0,0,0,0,9.00,0,1,'',0,1,0,0,0,0,'2020-12-15 10:34:08',NULL),
	(17,'wx2020121512091540969',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,1,'2020-12-15 12:09:16','yue','2020-12-15 12:09:15',-1,2,'','','收货地址填错了',NULL,'2020-12-15 12:09:49',0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'90db80982fb8ba6784bee9ac22639fc7',NULL,0,0,0,0,50.00,0,7,'',0,1,0,0,0,0,'2020-12-15 12:10:22',NULL),
	(18,'wx2020121512220125249',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,1,'2020-12-15 12:22:01','yue','2020-12-15 12:22:01',-1,2,'','','收货地址填错了',NULL,'2020-12-15 12:22:33',0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'5e3db13cd8990ef5f73458a5333d62e0',NULL,0,0,0,0,50.00,0,8,'',0,1,0,0,0,0,'2020-12-15 12:23:18',NULL),
	(19,'wx2020121610080832644',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-16 10:08:09','yue','2020-12-16 10:08:08',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'b7b9ee4b8671ae84db3f0a7e31795617',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-16 10:08:08',NULL),
	(20,'wx2020121710255399818',34,'哦看看','13000000000','山西省太原市小店区天空',0.00,1,10.00,0.00,10.00,0.00,0.00,0,0.00,1,'2020-12-17 10:25:54','yue','2020-12-17 10:25:53',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'88916ec80741bc7cced824a598336d40',NULL,0,0,0,0,50.00,0,9,'1103802502',1,2,0,0,0,0,'2020-12-29 18:32:55',NULL),
	(21,'wx2020121710500477396',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10.00,0.00,10.00,0.00,0.00,0,0.00,1,'2020-12-17 10:50:04','yue','2020-12-17 10:50:04',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'宅急送','express','4271130024851',0.00,0.00,NULL,'',0,'265aeb96f3ed7834b5ebe907c2a6031f',NULL,0,0,0,0,50.00,0,9,'',0,1,0,0,0,0,'2020-12-17 16:35:49','yunda'),
	(22,'wx2020121711011792401',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-17 11:01:18','yue','2020-12-17 11:01:17',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'中远快运','express','11111111',0.00,0.00,NULL,'',0,'42894127e7be235cb964059c35a76840',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-17 14:35:38','zy100'),
	(23,'wx2020121711094336795',31,'小小小','18788888888','陕西省西安市市辖区哈罗闪问',0.00,1,0.00,0.00,0.00,0.00,0.00,3,0.00,1,'2020-12-17 11:09:43','yue','2020-12-17 11:09:43',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'666',0,'01055c01576e4ad9f55a0e34afb9cce1',NULL,0,0,0,0,50.00,0,8,'1014441745',1,2,0,0,0,0,'2020-12-29 17:23:49',NULL),
	(24,'wx2020121711164951593',31,'哦哦哦哦哦哦哦哦哦','13996969696','陕西省西安市市辖区哈罗闪问',0.00,1,0.00,0.00,0.00,0.00,0.00,3,0.00,1,'2020-12-17 11:16:50','yue','2020-12-17 11:16:49',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'老兰家',0,'08f4fbf72f10572d27988a63f9da3c1b',NULL,0,0,0,0,50.00,0,8,'1008360594',1,2,0,0,0,0,'2020-12-27 15:13:43',NULL),
	(25,'wx2020121711191485032',31,'骷髅精灵','13255568866','陕西省西安市市辖区哈罗闪问',0.00,1,0.00,0.00,0.00,0.00,0.00,3,0.00,1,'2020-12-17 11:19:14','yue','2020-12-17 11:19:14',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'事情',0,'9ba4aadc7f097ab202522e4781879d83',NULL,0,0,0,0,50.00,0,8,'1061693849',1,2,0,0,0,0,'2020-12-24 15:48:20',NULL),
	(26,'wx2020121711275488287',31,'家里','13566666666','陕西省西安市市辖区哈罗闪问',0.00,1,10.00,0.00,10.00,0.00,0.00,0,0.00,1,'2020-12-17 11:27:54','yue','2020-12-17 11:27:54',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'682cd420febfd6ae864e8b3c49f274c1',NULL,0,0,0,0,50.00,0,9,'1049718718',1,2,0,0,0,0,'2020-12-23 17:02:54',NULL),
	(27,'wx2020121715303097225',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-17 15:30:30','yue','2020-12-17 15:30:30',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'84fe2ed4bbeb28e3e3bdf1a2d199e513','000',0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-18 10:11:01',NULL),
	(28,'wx2020121715484227501',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-17 15:48:42','yue','2020-12-17 15:48:42',1,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'297a613384792fa66594d15373333965',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-17 16:50:45',NULL),
	(29,'wx2020121810312869500',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-18 10:31:29','yue','2020-12-18 10:31:28',0,2,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-18 11:32:00',100.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'c5f5bbf4365d099b110a17ed98c1e588',NULL,0,0,6,2,200.00,0,0,'',0,1,0,0,0,0,'2020-12-18 14:11:01',NULL),
	(33,'wx2020121812200429132',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-18 12:20:04','yue','2020-12-18 12:20:04',0,2,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-18 13:21:00',10000.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'e8f69cd65673aecb396f90cf9be14044',NULL,0,0,5,3,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-18 14:12:06',NULL),
	(34,'wx2020121816074924636',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-18 16:07:49','yue','2020-12-18 16:07:49',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'77f6fc287ccee9f82c5083355e53635d',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-18 16:07:49',NULL),
	(35,'wx2020121816133212326',31,'小脑虎','18888888888','陕西省西安市市辖区哈罗闪问',0.00,1,0.00,0.00,0.00,0.00,0.00,3,0.00,1,'2020-12-18 16:13:32','yue','2020-12-18 16:13:32',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'a6ee8b02133926114264cb0996385073',NULL,0,0,0,0,50.00,0,8,'',0,1,0,0,0,0,'2020-12-18 16:13:32',NULL),
	(36,'wx2020121816145190688',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-18 16:14:51','yue','2020-12-18 16:14:51',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'59fbe1f11aa4ab5ce7f61730cad1ec73',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-18 16:16:36',NULL),
	(37,'wx2020121816185070850',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-18 16:18:50','yue','2020-12-18 16:18:50',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'004471afdbc19b9cf31d85fce2d4d674',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-18 16:19:28',NULL),
	(38,'wx2020121816221255319',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-18 16:22:12','yue','2020-12-18 16:22:12',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'d6d25617ad27e8cd22d8f5c3e45e8201',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-18 16:22:12',NULL),
	(39,'wx2020121816340982642',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-18 16:34:09','yue','2020-12-18 16:34:09',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'5ac05427021aa8ac4de36b794cfd264d',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-18 16:34:28',NULL),
	(40,'wx2020122109200782038',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 09:20:07','yue','2020-12-21 09:20:07',0,2,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 10:21:00',100.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'b1876fa24c9d9b21aae3a5995043585b',NULL,0,0,6,4,200.00,0,0,'',0,1,0,0,0,0,'2020-12-21 10:44:34',NULL),
	(41,'wx2020122109521158533',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 09:52:11','yue','2020-12-21 09:52:11',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 10:53:00',0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'7579be4beba7a4825ae8109d8c7cae68',NULL,0,0,6,5,200.00,0,0,'',0,1,0,0,0,0,'2020-12-21 10:53:00',NULL),
	(47,'wx2020122110275816086',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 10:27:58','yue','2020-12-21 10:27:58',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 11:28:00',0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'af5bb6da7f1468bf3332362a795e7c97',NULL,0,0,5,6,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 11:28:00',NULL),
	(48,'wx2020122110292756428',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 10:29:27','yue','2020-12-21 10:29:27',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 11:30:00',0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'dd0ff4df55061cc0a5c10da16ddaa291',NULL,0,0,5,7,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 11:30:00',NULL),
	(49,'wx2020122110321878437',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 10:32:18','yue','2020-12-21 10:32:18',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'e856dd148adb1ba3e2567d5efe937384',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 10:32:18',NULL),
	(50,'wx2020122114074074895',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,0.00,0.00,0.00,0.00,0.00,5,0.00,1,'2020-12-21 14:07:41','yue','2020-12-21 14:07:40',-1,2,'','123','收货地址填错了',NULL,'2020-12-21 14:13:07',0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'7b9e1daf07979b5751c5777c4776941e',NULL,0,0,0,0,50.00,0,8,'',0,1,0,0,0,0,'2020-12-21 14:13:29',NULL),
	(51,'wx2020122114233252378',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 14:23:32','yue','2020-12-21 14:23:32',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 15:24:00',0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'2747266eda56c1c79c6bc766c9b594e7',NULL,0,0,5,8,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 15:24:00',NULL),
	(53,'wx2020122114282959962',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 14:28:29','yue','2020-12-21 14:28:29',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 14:33:41',0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'a39314b38b269b594c580114148d1f44',NULL,0,0,5,9,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:31:46',NULL),
	(60,'wx2020122114511734340',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 14:51:18','yue','2020-12-21 14:51:17',0,2,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 14:54:49',10000.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'3bd11f69f8913d71cc7ab68ec7a36d12',NULL,0,0,5,10,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:32:05',NULL),
	(62,'wx2020122115114984625',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 15:11:49','yue','2020-12-21 15:11:49',1,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'0e27a1b967182ebd05ce77f152318a4e',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 15:12:05',NULL),
	(63,'wx2020122115223548316',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,0.00,0.00,0.00,0.00,0.00,14,0.00,1,'2020-12-21 15:22:36','yue','2020-12-21 15:22:35',-1,2,'','','收货地址填错了',NULL,'2020-12-21 15:22:47',0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'382b66c8fae905d0cb5f3bc4828ba235',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 15:23:08',NULL),
	(64,'wx2020122115233996100',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,0.00,0.00,0.00,0.00,0.00,14,0.00,1,'2020-12-21 15:23:39','yue','2020-12-21 15:23:39',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'b0e678ab2612866580143d45b937969d',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 15:23:39',NULL),
	(65,'wx2020122115262677348',36,'裴明','18292417675','陕西省西安市雁塔区曲江三迪枫丹(西安市雁塔区)',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-21 15:26:26',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'69f3b042a4608d7b442c309b85366f00',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 15:26:26',NULL),
	(66,'wx2020122115331955777',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 15:33:19','yue','2020-12-21 15:33:19',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'425ab0db61672dbf4a613c5b6ca909fb',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 16:15:46',NULL),
	(67,'wx2020122115424487003',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 15:42:44','yue','2020-12-21 15:42:44',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'64e80f0755aefd2b3092bc33f7431aa9',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 16:00:48',NULL),
	(68,'wx2020122116481683827',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 16:48:16','yue','2020-12-21 16:48:16',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'6a1e5bd75651c840c650cca6d24e7e1e',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 16:48:16',NULL),
	(70,'wx2020122117264652661',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,9999.00,0.00,9999.00,0.00,0.00,0,0.00,1,'2020-12-21 17:26:46','yue','2020-12-21 17:26:46',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'f02cd298e3486c0a36e38c0a218ffd69',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:26:46',NULL),
	(71,'wx2020122117283272511',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 17:28:32','yue','2020-12-21 17:28:32',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'8152b69a0adcd0f7b9673546389a4641',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:28:32',NULL),
	(72,'wx2020122117332179451',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:33:21',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'d83fbdbd0c082169009f1e831baa11b8',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:33:21',NULL),
	(73,'wx2020122117341142628',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:34:11',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'f1fa143bf774470d6a3555fb7f4297f4',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:34:11',NULL),
	(74,'wx2020122117343199322',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,2,19998.00,0.00,19998.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:34:31',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'b80d5c3a26264c7f2d98d122c28a5c52',NULL,0,0,0,0,0.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:34:31',NULL),
	(75,'wx2020122117362351213',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:36:23',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'8d25ba71a99e13d7a4d7ddcfa95ec535',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:36:23',NULL),
	(76,'wx2020122117382759574',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 17:38:27','yue','2020-12-21 17:38:27',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'4f217cc2b2bcfc8d8c5793404a637e27',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:38:27',NULL),
	(77,'wx2020122117422051015',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:42:20',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'e8d36dd8a82618b84f1f2dc72ef81481',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:42:20',NULL),
	(78,'wx2020122117423677200',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:42:36',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'377794292f5f79ff2f0799fd93601e69',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:42:36',NULL),
	(79,'wx2020122117444765286',46,'王文超','18710383544','陕西省西安市新城区韩森寨二十九街坊三单元',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-21 17:45:09','yue','2020-12-21 17:44:47',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'d92c4a3d47824d109529a015889a755a',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:45:09',NULL),
	(80,'wx2020122117454399292',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:45:43',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'8e2239b0f1d237663b9d07020e05b0dc',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:45:43',NULL),
	(81,'wx2020122117483291058',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 17:48:32',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'1598667dd62b7c9921cbec2fabc9ab0e',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:48:32',NULL),
	(82,'wx2020122117500844685',37,'潇潇','13888888888','浙江省温州市瓯海区啊啊啊',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 17:50:08','yue','2020-12-21 17:50:08',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'a328a183a558c82ecb0f5889449ed42d',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 17:50:08',NULL),
	(83,'wx2020122117521228249',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-23 10:45:52','yue','2020-12-21 17:52:12',-1,1,'image/product/2020/12/23/5ca31ee50e6345d0bb2a9dd361bb8c3ajghjcf8fdt.jpg','1','收货地址填错了',NULL,'2020-12-23 10:46:14',0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'537c4d794e0baaa0eb14c614bcc4ede5',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-23 10:46:14',NULL),
	(84,'wx2020122118045677666',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,0,NULL,'yue','2020-12-21 18:04:56',0,1,NULL,'用户取消拼团订单，申请退款',NULL,'拼团订单取消，申请退款','2020-12-21 19:05:00',0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'432cd14020373550ef57ae58a38a79be',NULL,0,0,5,11,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-21 19:05:00',NULL),
	(85,'wx2020122118143513973',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,10000.00,0.00,10000.00,0.00,0.00,0,0.00,1,'2020-12-21 18:14:35','yue','2020-12-21 18:14:35',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'5246b45cba82edec30ec35d986ca41d3',NULL,0,0,0,0,5000.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:45:51',NULL),
	(86,'wx2020122209201057028',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,1.00,0.00,1.00,0.00,0.00,0,0.00,1,'2020-12-22 09:20:10','yue','2020-12-22 09:20:10',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'079e8db221467ba20cd52ba2e57bb9a9',NULL,0,0,0,0,5000.00,3,0,'',0,1,0,0,0,0,'2020-12-22 09:20:10',NULL),
	(87,'wx2020122210260376698',52,'邓鹏飞','13720768304','陕西省西安市碑林区李家村',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-22 10:26:03','yue','2020-12-22 10:26:03',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'a42c7fcf25f089b1a660b6a9af108602',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-22 10:26:03',NULL),
	(94,'wx2020122211130180408',34,'啦啦啦啦','13000000000','山西省太原市小店区天空',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-22 11:13:01','yue','2020-12-22 11:13:01',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'9127a10a2001bb9db5e0b8a63491d041',NULL,0,0,0,0,0.00,4,0,'',0,1,0,0,0,0,'2020-12-22 11:13:01',NULL),
	(95,'wx2020122211134565041',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2020-12-22 11:13:45','yue','2020-12-22 11:13:45',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'5b7accd80d28ff6d76b937790bd84aca',NULL,0,0,0,0,0.00,4,0,'',0,1,0,0,0,0,'2020-12-22 11:13:45',NULL),
	(96,'wx2020122211230061503',52,'邓鹏飞','13720768304','陕西省西安市碑林区李家村',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-22 11:23:00','yue','2020-12-22 11:23:00',3,0,NULL,NULL,NULL,NULL,NULL,0.00,'张三','send','13720000000',0.00,0.00,NULL,'',0,'bd1073f92014c2081d2bddc9fa20800b',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 12:04:51',NULL),
	(97,'wx2020122212114695001',52,'邓鹏飞','13720768304','陕西省西安市碑林区李家村',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-22 12:11:47','yue','2020-12-22 12:11:46',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'ad0828605e0e7ce55ec2cefcdbaf030d',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 12:13:20',NULL),
	(98,'wx2020122214393439358',52,'邓鹏飞','13720768304','陕西省西安市碑林区李家村',0.00,1,428.00,0.00,428.00,0.00,0.00,0,0.00,1,'2020-12-22 14:39:34','yue','2020-12-22 14:39:34',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'23b246e0f542c98c1fa41b7c16948533',NULL,0,0,0,0,200.00,0,0,'',0,1,0,0,0,0,'2020-12-22 14:40:24',NULL),
	(99,'wx2020122214442834679',52,'邓鹏飞','13720768304','陕西省西安市碑林区李家村',0.00,1,428.00,0.00,428.00,0.00,0.00,0,0.00,1,'2020-12-22 14:44:28','yue','2020-12-22 14:44:28',3,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'b43b1806abeaa3a7da5ca102396cc951',NULL,0,0,0,0,200.00,0,0,'',0,1,0,0,0,0,'2020-12-22 14:45:15',NULL),
	(100,'wx2020122215075846470',40,'郭萌','18792851671','陕西省西安市未央区三桥街道启航佳苑A区',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-22 15:07:58','yue','2020-12-22 15:07:58',2,0,NULL,NULL,NULL,NULL,NULL,0.00,'宅急送','express','11111111',0.00,0.00,NULL,'',0,'3b0e8efa9433d6be7bff72ec0a44ef4d',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 15:13:23','zhaijisong'),
	(101,'wx2020122215481030538',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-22 15:48:10',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'用户备注信息：爱是好几个撒的的撒还是爱是大收到爱是',1,'1d93ee92247cc9108d2d8842e1806128',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,1,'2020-12-22 16:08:35',NULL),
	(102,'wx2020122215493955805',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-22 16:35:41','yue','2020-12-22 15:49:39',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'用户备注信息\n',0,'e4b97cbf058089ab75db0b06c4f1eaeb','商家备注撒空军的哈空间还是的卡号是动撒 \n',0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:36:38',NULL),
	(103,'wx2020122216051281857',34,'周杰伦','13000000080','山西省太原市小店区天空',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-22 16:05:12','yue','2020-12-22 16:05:12',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'7d7c148917ee9560a945a123d829fa0a','11111111',0,0,0,0,100.00,0,0,'1056967153',1,2,0,0,0,0,'2020-12-23 10:24:18',NULL),
	(104,'wx2020122216372298293',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,189.00,10.00,189.00,10.00,0.00,0,0.00,0,NULL,'weixin','2020-12-22 16:37:22',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'7527c51a3a81ec9cbfee0edfeec5a424',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:38:23',NULL),
	(105,'wx2020122216393355859',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,2,400.00,10.00,400.00,10.00,0.00,0,0.00,1,'2020-12-22 18:38:49','yue','2020-12-22 16:39:33',2,0,NULL,NULL,NULL,NULL,NULL,0.00,'张三','send','13799999999',0.00,0.00,NULL,'',0,'3823683b040640a842f427484d2655bb',NULL,0,0,0,0,200.00,0,0,'',0,1,0,0,0,0,'2020-12-22 18:45:31',NULL),
	(106,'wx2020122216442839614',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2020-12-22 16:44:44','yue','2020-12-22 16:44:28',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'ed8f5096f6d0a8330dc4ff05c00bd800',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:44:44',NULL),
	(107,'wx2020122216452214922',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-22 16:45:22',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'670fcbe85594b8e1e28f92364796d553',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:45:22',NULL),
	(108,'wx2020122216483483964',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-22 16:48:34',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'06ab8afdbb533333ec8598d7298fe941',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:48:34',NULL),
	(109,'wx2020122216492870786',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-22 16:49:28',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'21e8cf4a7c0ae613a53a0a0359c0dd6d',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2020-12-22 16:49:28',NULL),
	(110,'wx2020122217471627665',32,'完全而','13000000000','山西省太原市小店区213',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-22 17:47:16','yue','2020-12-22 17:47:16',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'6c370cebb73686dd5e8ff6cac3df03a6',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-22 17:47:16',NULL),
	(111,'wx2020122309184791316',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-23 09:18:47','yue','2020-12-23 09:18:47',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'22','send','13523232222',0.00,0.00,NULL,'',0,'79cc7fdd9a30606c71e11d879752b2ac',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:53:51',NULL),
	(112,'wx2020122309495948526',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-23 09:49:59',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'5e5af53c0cf578309d0966aa185f0d2c',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 09:49:59',NULL),
	(113,'wx2020122309562077157',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-23 09:56:47','weixin','2020-12-23 09:56:20',-1,2,'image/product/2020/12/23/5e6d782806404df4b320cbafe482dc2fukoeynvgji.jpg,image/product/2020/12/23/54aae5047bd84046bdf28d15d996d6edhu3cttrpgh.jpg,image/product/2020/12/23/7beef5e3fd3d4585841330fef41f1ccbk8kl048xrs.jpg,image/product/2020/12/23/b40e03b8dfe94e1fa2844db0d969cd8dvx6gofuzh8.jpg','爸爸拒腐防变句','与描述不符 ',NULL,'2020-12-23 09:59:25',0.01,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'a78b7eaeea9fc8cf04cc241bed1fae1f',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-23 09:59:59',NULL),
	(114,'wx2020122310020184796',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,2,318.00,0.00,318.00,0.00,0.00,0,0.00,1,'2020-12-23 10:02:01','yue','2020-12-23 10:02:01',1,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'c8ce50097668d2be8f90c922e12ab86b',NULL,0,0,0,0,200.00,0,0,'',0,1,0,0,0,0,'2020-12-25 16:10:52',NULL),
	(115,'wx2020122310065234660',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 10:06:52','yue','2020-12-23 10:06:52',-1,2,'image/product/2020/12/23/3fc898a1dbdc4baa935f905dfc238bb5eubvon632g.png,image/product/2020/12/23/49601be69e534901b636b73c532104b458pu93jdjb.png,image/product/2020/12/23/488d99bb46bf458d93440b7d9d38abb9ptx1mu11h2.png,image/product/2020/12/23/a2b3221c55394c28bc284e611d462abaydw0abbvy4.png,image/product/2020/12/23/985aaa3f9c7d41078e37d3e441116781qdyffn3m4j.png','删除退款图片提交测试000','收货地址填错了','撒大公司大撒好的是的骄傲是个安公司杀阿达','2020-12-23 10:18:44',169.00,'李四','send','13777777777',0.00,0.00,NULL,'',0,'46fdf6c444be4cb71206ed0167b609ce',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 10:20:15',NULL),
	(116,'wx2020122310072161276',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2021-01-07 14:35:57','yue','2020-12-23 10:07:21',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'17fe112a8a9ebef2a26b547f61a51779',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2021-01-07 14:35:58',NULL),
	(117,'wx2020122310151174175',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-23 10:15:11','yue','2020-12-23 10:15:11',1,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'b2373d288c0b1a7d2d32f96911fac015',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-25 16:10:46',NULL),
	(118,'wx2020122310231072806',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 10:23:10','yue','2020-12-23 10:23:10',-1,2,'','','收货地址填错了',NULL,'2020-12-23 10:23:28',169.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'0e2b393c336d81d9b73143a5da28f893',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 10:23:55',NULL),
	(119,'wx2020122310250586939',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,0.00,10.00,169.00,0,0.00,1,'2020-12-23 10:25:05','yue','2020-12-23 10:25:05',0,2,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,169.00,NULL,'',0,'a53c72680267923c6b4b9b5b7e5025ea',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 10:25:30',NULL),
	(120,'wx2020122310284278825',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,0.00,10.00,169.00,0,0.00,1,'2020-12-23 10:28:42','yue','2020-12-23 10:28:42',-1,2,'','','收货地址填错了',NULL,'2020-12-23 10:51:12',0.00,'宅急送','express','ZJS007001908104',0.00,169.00,NULL,'',0,'111447e1522197f22a6bc6371aa2d841',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 10:51:46','zhaijisong'),
	(121,'wx2020122310470542404',44,'吵','18710352145','陕西省西安市未央区后卫寨',0.00,1,99.00,0.00,99.00,0.00,0.00,0,0.00,1,'2020-12-23 10:47:05','yue','2020-12-23 10:47:05',-1,1,'','bxy','收货地址填错了',NULL,'2020-12-23 10:52:45',0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'73a32ade057447ce5ef27bf0e4d67eee',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2020-12-23 10:52:45',NULL),
	(122,'wx2020122310552413118',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-23 10:55:24','yue','2020-12-23 10:55:24',-1,2,'','','收货地址填错了',NULL,'2020-12-23 10:55:36',100.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'dcec8e3db867a3ddee041ab32b3ed32e',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 10:56:15',NULL),
	(123,'wx2020122310572142276',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 10:57:21','yue','2020-12-23 10:57:21',-1,2,'','就是的撒环境的哈撒可见度啊是大','未按预定时间发货 ',NULL,'2020-12-23 11:00:56',100.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'fffe386546fd69fec37e7efbad5c6e46',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 11:01:27',NULL),
	(124,'wx2020122311114753098',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,0.00,10.00,169.00,0,0.00,1,'2020-12-23 11:11:47','yue','2020-12-23 11:11:47',1,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,169.00,NULL,'',0,'be99f2d96172a39dc9285e1858577aec','1',0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-24 08:45:25',NULL),
	(125,'wx2020122311152434561',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 11:15:24','yue','2020-12-23 11:15:24',-1,0,'','sada sdas dasd ','收货地址填错了',NULL,'2020-12-23 11:16:06',169.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'ac10c484ca32037f0e12b73e8d46c2a8',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 11:17:07',NULL),
	(126,'wx2020122311200436357',52,'张三苏','13222222222','上海市上海市黄浦区连岭村',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-23 11:20:04','yue','2020-12-23 11:20:04',-1,0,'','asdasd sad ','收货地址填错了',NULL,'2020-12-23 11:20:18',218.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'9565b3f306426377e16e50f20b5e5004',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 11:20:45',NULL),
	(127,'wx2020122311395981104',57,'周三','14356677890','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-23 11:39:59','yue','2020-12-23 11:39:59',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'17da8e1e2fc49d2829b741057b6580fa',NULL,0,0,0,0,100.00,0,0,'1063427418',4,2,0,0,0,0,'2020-12-23 11:48:54',NULL),
	(128,'wx2020122311404837671',52,'周四','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 11:40:48','yue','2020-12-23 11:40:48',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'94ee3ede3df84bf6a0462749e4c451de',NULL,0,0,0,0,100.00,0,0,'1074161540',4,2,0,0,0,0,'2020-12-23 11:44:37',NULL),
	(129,'wx2020122311560381331',52,'无良','13222222222','上海市上海市黄浦区连岭村',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 11:56:03','yue','2020-12-23 11:56:03',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'6078cc9fadf2f32ea3390dc5f632bb3c',NULL,0,0,0,0,100.00,0,0,'1001543090',4,2,0,0,0,0,'2020-12-23 11:56:11',NULL),
	(130,'wx2020122311592785945',57,'王大蛋','13899999999','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,159.00,0.00,159.00,0.00,0.00,0,0.00,1,'2020-12-23 11:59:27','yue','2020-12-23 11:59:27',2,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'ae320a6ed4aa467758e4ab565a6a624d',NULL,0,0,0,0,100.00,0,0,'1018775670',4,2,0,0,0,0,'2020-12-23 12:00:32',NULL),
	(131,'wx2020122312025526047',35,'啊啊啊啊','13000000000','山西省太原市小店区规格高',0.00,1,7.01,1.00,3.01,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-23 12:02:55',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'44cb5fcd6f2d47172373e06191a8da65',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-23 16:07:32',NULL),
	(132,'wx2020122312033016234',57,'邓鹏飞','13720673941','陕西省西安市未央区世纪大道启航时代广场A座(未央区西咸路501号)',0.00,1,0.01,0.00,0.01,0.00,0.00,0,0.00,1,'2020-12-23 12:03:35','weixin','2020-12-23 12:03:30',-1,2,'','不知你自己最可靠','收货地址填错了',NULL,'2020-12-23 12:03:47',0.01,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'c68199e4a2c2cef6b3858f0610c73fd1',NULL,0,0,0,0,10.00,0,0,'',0,1,0,0,0,0,'2020-12-23 12:04:23',NULL),
	(133,'wx2020122312170277299',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,218.00,0.00,218.00,0.00,0.00,0,0.00,1,'2020-12-23 12:17:02','yue','2020-12-23 12:17:02',1,0,NULL,NULL,NULL,NULL,NULL,0.00,'宅急送','express','ZJS007001908480',0.00,0.00,NULL,'',0,'05726dfeb58ed7dcb01abad9888e5798',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-23 12:18:09','zhaijisong'),
	(134,'wx2020122314390784302',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,159.00,10.00,169.00,10.00,0.00,0,0.00,1,'2020-12-23 14:39:07','yue','2020-12-23 14:39:07',1,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'fictitious',NULL,0.00,0.00,NULL,'',0,'2d1d5e84fe0763acc713412acf7960c0','222',0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-29 18:28:26',NULL),
	(135,'wx2020122316263838537',132,'胡上杰','16657119554','浙江省杭州市拱墅区二维火大厦火邮局',0.00,1,163.00,2.00,159.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-23 16:26:38',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'e6145c863929fab394149eb79de170cb',NULL,0,0,0,0,100.00,0,0,'',0,1,0,0,0,0,'2020-12-30 15:36:07',NULL),
	(136,'wx2020122316303338912',140,'丁起明','15245068336','黑龙江省哈尔滨市南岗区鸿朗花园二期',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-23 16:30:33',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'c83ff3fe87662db5ef8ef8400220a022',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-23 16:30:33',NULL),
	(137,'wx2020122316342699486',144,'脚丫子','15209321131','新疆维吾尔自治区乌鲁木齐市沙依巴克区南站路135号 乌鲁木齐南站',0.00,1,0.00,0.00,0.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-23 16:34:26',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'3493d97a2bfe7b7516f49a20af8d1c6c','哈哈啊哈哈好哈挥洒的哈斯柯达hi我等会我秦皇岛好',0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2020-12-26 19:17:37',NULL),
	(138,'wx2020122316382567082',71,'湖','13812741739','省市区hihi',0.00,2,0.00,0.00,7.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-23 16:38:25',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'b838a29014804c2ac5808244b90ce2ff',NULL,0,0,0,0,10009.00,0,0,'',0,1,0,0,0,0,'2020-12-30 16:09:31',NULL),
	(139,'wx2020122317042741409',158,'测试','15512341234','北京市东城区芳苑乡财产分割错错错',0.00,1,101.00,0.00,95.00,0.00,0.00,0,0.00,0,NULL,'weixin','2020-12-23 17:04:27',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'8bb29ca5b21adf32d5b1aa823cbbf771',NULL,0,0,0,0,9.00,0,0,'',0,1,0,0,0,0,'2021-01-04 11:30:23',NULL),
	(140,'wx2021010714350527325',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,0.00,0.00,0.00,0.00,0.00,14,0.00,1,'2021-01-07 14:35:06','yue','2021-01-07 14:35:05',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'d399c2fcb7407f6bb42431fa7ed80832',NULL,0,0,0,0,10000.00,0,0,'',0,1,0,0,0,0,'2021-01-07 14:35:07',NULL),
	(141,'wx2021010714353839220',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2021-01-07 14:35:40','yue','2021-01-07 14:35:38',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'2f3f9d41ac04a6939f18c161f043e080',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2021-01-07 14:35:40',NULL),
	(142,'wx2021010714420657767',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2021-01-07 14:42:08','yue','2021-01-07 14:42:06',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'1a225f4ad38d2df3a1b10d12175fbf80',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2021-01-07 14:42:08',NULL),
	(143,'wx2021010714550449184',33,'stivepeim','18292417675','山西省太原市市辖区xxx',0.00,1,100.00,0.00,100.00,0.00,0.00,0,0.00,1,'2021-01-07 14:55:05','yue','2021-01-07 14:55:04',0,0,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,0.00,0.00,NULL,'',0,'8a380a57a97e7b40377ee91a917d78b2',NULL,0,0,0,0,50.00,0,0,'',0,1,0,0,0,0,'2021-01-07 14:55:05',NULL);

/*!40000 ALTER TABLE `eb_store_order` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_order_info
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_order_info`;

CREATE TABLE `eb_store_order_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `order_id` int(11) unsigned NOT NULL COMMENT '订单id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `info` text NOT NULL COMMENT '购买东西的详细信息',
  `unique` char(32) NOT NULL COMMENT '唯一id',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `oid` (`order_id`,`unique`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单购物详情表';

LOCK TABLES `eb_store_order_info` WRITE;
/*!40000 ALTER TABLE `eb_store_order_info` DISABLE KEYS */;

INSERT INTO `eb_store_order_info` (`id`, `order_id`, `product_id`, `info`, `unique`, `create_time`, `update_time`)
VALUES
	(3,3,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":430,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":430,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":2,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":41,\"stock\":7}},\"uid\":4,\"productAttrUnique\":\"41\",\"bargainId\":0,\"id\":5}','41','2020-12-08 14:52:34','2020-12-08 14:52:34'),
	(4,4,1,'{\"productId\":1,\"vipTruePrice\":0,\"combinationId\":1,\"costPrice\":9.00,\"trueStock\":9,\"pinkId\":0,\"truePrice\":99.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"sort\":1,\"sales\":0,\"price\":99.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"stock\":430,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"8GB,800,全网通\",\"weight\":9.00,\"type\":3,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"quota\":9,\"quotaShow\":9,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"8GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":53,\"stock\":9}},\"productAttrUnique\":\"53\"}','53','2020-12-08 14:56:41','2020-12-08 14:56:41'),
	(5,5,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":428,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":428,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":3,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":41,\"stock\":6}},\"uid\":11,\"productAttrUnique\":\"41\",\"bargainId\":0,\"id\":7}','41','2020-12-09 14:34:11','2020-12-09 14:34:11'),
	(6,6,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":427,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":427,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":197,\"stock\":5}},\"uid\":12,\"productAttrUnique\":\"197\",\"bargainId\":0,\"id\":8}','197','2020-12-09 16:40:08','2020-12-09 16:40:08'),
	(7,7,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":1000,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":1,\"keyword\":\"电脑电脑\",\"stock\":1000,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":208,\"stock\":1000}},\"uid\":11,\"productAttrUnique\":\"208\",\"bargainId\":0,\"id\":11}','208','2020-12-10 10:10:09','2020-12-10 10:10:09'),
	(8,8,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":999,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":1,\"keyword\":\"电脑电脑\",\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":208,\"stock\":999}},\"uid\":14,\"productAttrUnique\":\"208\",\"bargainId\":0,\"id\":14}','208','2020-12-10 10:33:31','2020-12-10 10:33:31'),
	(9,9,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":998,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":1,\"keyword\":\"电脑电脑\",\"stock\":998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":208,\"stock\":998}},\"uid\":14,\"productAttrUnique\":\"208\",\"bargainId\":0,\"id\":16}','208','2020-12-10 10:33:58','2020-12-10 10:33:58'),
	(10,10,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":426,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":6,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":426,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":1,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":197,\"stock\":4}},\"uid\":19,\"productAttrUnique\":\"197\",\"bargainId\":0,\"id\":18}','197','2020-12-10 15:28:11','2020-12-10 15:28:11'),
	(11,11,2,'{\"productId\":2,\"seckillId\":2,\"vipTruePrice\":0,\"costPrice\":0.00,\"trueStock\":20,\"truePrice\":10.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"123\",\"otPrice\":12000.00,\"isPostage\":false,\"sort\":1,\"sales\":0,\"postage\":0.00,\"price\":10.00,\"storeName\":\"iphone11\",\"id\":2,\"storeInfo\":\"苹果11\",\"tempId\":1,\"stock\":20,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":2,\"otPrice\":12000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10.00,\"quota\":20,\"quotaShow\":20,\"unique\":\"\",\"id\":209,\"stock\":20}},\"productAttrUnique\":\"209\"}','209','2020-12-11 15:21:43','2020-12-11 15:21:43'),
	(12,12,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":997,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":3,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":2,\"keyword\":\"电脑电脑\",\"stock\":997,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"id\":211,\"stock\":997}},\"uid\":31,\"productAttrUnique\":\"211\",\"bargainId\":0,\"id\":24}','211','2020-12-14 17:06:37','2020-12-14 17:06:37'),
	(13,13,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":425,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":7,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":425,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":2,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":197,\"stock\":3}},\"uid\":33,\"productAttrUnique\":\"197\",\"bargainId\":0,\"id\":25}','197','2020-12-15 09:31:04','2020-12-15 09:31:04'),
	(14,14,4,'{\"productId\":4,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":999,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":0,\"price\":100.00,\"storeName\":\"砍价商品\",\"id\":6,\"storeInfo\":\"砍价商品\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":999,\"unique\":\"\",\"id\":213,\"stock\":999}},\"productAttrUnique\":\"213\",\"bargainId\":6}','213','2020-12-15 09:57:18','2020-12-15 09:57:18'),
	(15,15,1,'{\"productId\":1,\"vipTruePrice\":0,\"costPrice\":9.00,\"trueStock\":9,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"unitName\":\"T\",\"isPostage\":true,\"sort\":1,\"sales\":0,\"price\":10.00,\"storeName\":\"圈粉1\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"stock\":9,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"8GB,100,全网通\",\"weight\":9.00,\"type\":2,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":10.00,\"quota\":9,\"unique\":\"\",\"id\":148,\"stock\":9}},\"productAttrUnique\":\"148\",\"bargainId\":1}','148','2020-12-15 10:24:28','2020-12-15 10:24:28'),
	(16,16,1,'{\"productId\":1,\"vipTruePrice\":0,\"costPrice\":9.00,\"trueStock\":8,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"unitName\":\"T\",\"isPostage\":true,\"sort\":1,\"sales\":1,\"price\":10.00,\"storeName\":\"圈粉1\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"stock\":8,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"8GB,100,全网通\",\"weight\":9.00,\"type\":2,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":10.00,\"quota\":8,\"unique\":\"\",\"id\":215,\"stock\":8}},\"productAttrUnique\":\"215\",\"bargainId\":1}','215','2020-12-15 10:34:08','2020-12-15 10:34:08'),
	(17,17,4,'{\"productId\":4,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":998,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":0,\"price\":100.00,\"storeName\":\"砍价商品\",\"id\":7,\"storeInfo\":\"砍价商品\",\"tempId\":2,\"stock\":998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":998,\"unique\":\"\",\"id\":217,\"stock\":998}},\"productAttrUnique\":\"217\",\"bargainId\":7}','217','2020-12-15 12:09:15','2020-12-15 12:09:15'),
	(18,18,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":999,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":0,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":999,\"unique\":\"\",\"id\":219,\"stock\":999}},\"productAttrUnique\":\"219\",\"bargainId\":8}','219','2020-12-15 12:22:01','2020-12-15 12:22:01'),
	(19,19,5,'{\"productId\":5,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":999,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":150.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"可乐\",\"id\":5,\"storeInfo\":\"可乐\",\"tempId\":2,\"keyword\":\"可乐\",\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":5,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":218,\"stock\":998}},\"uid\":35,\"productAttrUnique\":\"218\",\"bargainId\":0,\"id\":36}','218','2020-12-16 10:08:08','2020-12-16 10:08:08'),
	(20,20,7,'{\"productId\":7,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":9999,\"truePrice\":10.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"isPostage\":true,\"sort\":0,\"sales\":0,\"price\":100.00,\"storeName\":\"腰果\",\"id\":9,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":9999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":9,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":100,\"unique\":\"\",\"id\":225,\"stock\":9999}},\"productAttrUnique\":\"225\",\"bargainId\":9}','225','2020-12-17 10:25:53','2020-12-17 10:25:53'),
	(21,21,7,'{\"productId\":7,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":9998,\"truePrice\":10.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"isPostage\":true,\"sort\":0,\"sales\":1,\"price\":100.00,\"storeName\":\"腰果\",\"id\":9,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":9998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":9,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":99,\"unique\":\"\",\"id\":229,\"stock\":9998}},\"productAttrUnique\":\"229\",\"bargainId\":9}','229','2020-12-17 10:50:04','2020-12-17 10:50:04'),
	(22,22,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":996,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":2,\"keyword\":\"电脑电脑\",\"stock\":996,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"id\":211,\"stock\":996}},\"uid\":46,\"productAttrUnique\":\"211\",\"bargainId\":0,\"id\":44}','211','2020-12-17 11:01:17','2020-12-17 11:01:17'),
	(23,23,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":999,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":0,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":999,\"unique\":\"\",\"id\":224,\"stock\":999}},\"productAttrUnique\":\"224\",\"bargainId\":8}','224','2020-12-17 11:09:43','2020-12-17 11:09:43'),
	(24,24,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":998,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":1,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":998,\"unique\":\"\",\"id\":230,\"stock\":998}},\"productAttrUnique\":\"230\",\"bargainId\":8}','230','2020-12-17 11:16:49','2020-12-17 11:16:49'),
	(25,25,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":997,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":2,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":997,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":997,\"unique\":\"\",\"id\":230,\"stock\":997}},\"productAttrUnique\":\"230\",\"bargainId\":8}','230','2020-12-17 11:19:14','2020-12-17 11:19:14'),
	(26,26,7,'{\"productId\":7,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":9997,\"truePrice\":10.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"isPostage\":true,\"sort\":0,\"sales\":2,\"price\":100.00,\"storeName\":\"腰果\",\"id\":9,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":9997,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":9,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":98,\"unique\":\"\",\"id\":229,\"stock\":9997}},\"productAttrUnique\":\"229\",\"bargainId\":9}','229','2020-12-17 11:27:54','2020-12-17 11:27:54'),
	(27,27,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":9996,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":3,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":9996,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":222,\"stock\":9996}},\"uid\":35,\"productAttrUnique\":\"222\",\"bargainId\":0,\"id\":47}','222','2020-12-17 15:30:30','2020-12-17 15:30:30'),
	(28,28,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":999,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":999}},\"uid\":33,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":48}','221','2020-12-17 15:48:42','2020-12-17 15:48:42'),
	(29,29,7,'{\"productId\":7,\"vipTruePrice\":0,\"combinationId\":6,\"costPrice\":200.00,\"trueStock\":18,\"pinkId\":0,\"truePrice\":100.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"price\":100.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":6,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":18,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":18,\"quotaShow\":18,\"unique\":\"\",\"id\":348,\"stock\":18}},\"productAttrUnique\":\"348\"}','348','2020-12-18 10:31:29','2020-12-18 10:31:29'),
	(30,33,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":999,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":999,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":999}},\"productAttrUnique\":\"346\"}','346','2020-12-18 12:20:04','2020-12-18 12:20:04'),
	(31,34,3,'{\"productId\":3,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":995,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"unitName\":\"个\",\"otPrice\":1.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"273,274,275,276,277,279\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"电脑\",\"id\":3,\"storeInfo\":\"电脑电脑电脑\",\"tempId\":2,\"keyword\":\"电脑电脑\",\"stock\":995,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":0.00,\"productId\":3,\"otPrice\":1.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"id\":211,\"stock\":995}},\"uid\":33,\"productAttrUnique\":\"211\",\"bargainId\":0,\"id\":94}','211','2020-12-18 16:07:49','2020-12-18 16:07:49'),
	(32,35,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":996,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":3,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":996,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":996,\"unique\":\"\",\"id\":230,\"stock\":996}},\"productAttrUnique\":\"230\",\"bargainId\":8}','230','2020-12-18 16:13:32','2020-12-18 16:13:32'),
	(33,36,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":18,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":18,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":18}},\"uid\":35,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":96}','308','2020-12-18 16:14:51','2020-12-18 16:14:51'),
	(34,37,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":17,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":17,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":17}},\"uid\":35,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":98}','308','2020-12-18 16:18:50','2020-12-18 16:18:50'),
	(35,38,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":998,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":998}},\"uid\":34,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":99}','221','2020-12-18 16:22:12','2020-12-18 16:22:12'),
	(36,39,5,'{\"productId\":5,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":994,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":150.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"可乐\",\"id\":5,\"storeInfo\":\"可乐\",\"tempId\":2,\"keyword\":\"可乐\",\"stock\":994,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":5,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":218,\"stock\":993}},\"uid\":35,\"productAttrUnique\":\"218\",\"bargainId\":0,\"id\":100}','218','2020-12-18 16:34:09','2020-12-18 16:34:09'),
	(37,40,7,'{\"productId\":7,\"vipTruePrice\":0,\"combinationId\":6,\"costPrice\":200.00,\"trueStock\":18,\"pinkId\":0,\"truePrice\":100.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"price\":100.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":6,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":18,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":18,\"quotaShow\":18,\"unique\":\"\",\"id\":348,\"stock\":18}},\"productAttrUnique\":\"348\"}','348','2020-12-21 09:20:07','2020-12-21 09:20:07'),
	(38,41,7,'{\"productId\":7,\"vipTruePrice\":0,\"combinationId\":6,\"costPrice\":200.00,\"trueStock\":17,\"pinkId\":0,\"truePrice\":100.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"sort\":0,\"sales\":1,\"price\":100.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":6,\"storeInfo\":\"腰果\",\"tempId\":2,\"stock\":280,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":200.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":3,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":17,\"quotaShow\":17,\"unique\":\"\",\"id\":463,\"stock\":17}},\"productAttrUnique\":\"463\"}','463','2020-12-21 09:52:11','2020-12-21 09:52:11'),
	(39,47,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":999,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":999,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":999}},\"productAttrUnique\":\"346\"}','346','2020-12-21 10:27:58','2020-12-21 10:27:58'),
	(40,48,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":998,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":1,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":998,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":998,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":998}},\"productAttrUnique\":\"346\"}','346','2020-12-21 10:29:27','2020-12-21 10:29:27'),
	(41,49,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35962,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":2,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35962,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"银色,128GB,换修无忧年付版\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"银色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"换修无忧年付版\\\"}\",\"id\":378,\"stock\":999}},\"uid\":32,\"productAttrUnique\":\"378\",\"bargainId\":0,\"id\":102}','378','2020-12-21 10:32:18','2020-12-21 10:32:18'),
	(42,50,5,'{\"productId\":5,\"vipTruePrice\":0,\"costPrice\":50.00,\"trueStock\":995,\"truePrice\":0.00,\"type\":\"2\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"unitName\":\"件\",\"isPostage\":true,\"sort\":0,\"sales\":4,\"price\":100.00,\"storeName\":\"可乐\",\"id\":8,\"storeInfo\":\"可乐\",\"tempId\":2,\"stock\":995,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"cost\":50.00,\"productId\":8,\"otPrice\":150.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":2,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":995,\"unique\":\"\",\"id\":230,\"stock\":995}},\"productAttrUnique\":\"230\",\"bargainId\":8}','230','2020-12-21 14:07:41','2020-12-21 14:07:41'),
	(43,51,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":997,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":2,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":997,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":997,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":997}},\"productAttrUnique\":\"346\"}','346','2020-12-21 14:23:32','2020-12-21 14:23:32'),
	(44,53,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":996,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":3,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":996,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":996,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":996}},\"productAttrUnique\":\"346\"}','346','2020-12-21 14:28:29','2020-12-21 14:28:29'),
	(45,60,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":995,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":4,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":995,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":3,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":995,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":346,\"stock\":995}},\"productAttrUnique\":\"346\"}','346','2020-12-21 14:51:18','2020-12-21 14:51:18'),
	(46,62,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":15,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":7,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":15,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":15}},\"uid\":37,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":104}','308','2020-12-21 15:11:49','2020-12-21 15:11:49'),
	(47,63,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":100,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":100,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":100}},\"uid\":33,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":105}','309','2020-12-21 15:22:35','2020-12-21 15:22:35'),
	(48,64,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":99,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":99,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":99}},\"uid\":33,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":106}','309','2020-12-21 15:23:39','2020-12-21 15:23:39'),
	(49,65,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":98,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":98,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":98}},\"uid\":36,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":107}','309','2020-12-21 15:26:26','2020-12-21 15:26:26'),
	(50,66,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":997,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":997,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":997}},\"uid\":37,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":108}','221','2020-12-21 15:33:19','2020-12-21 15:33:19'),
	(51,67,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":996,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":3,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":996,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":996}},\"uid\":37,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":110}','221','2020-12-21 15:42:44','2020-12-21 15:42:44'),
	(52,68,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":995,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":995,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":995}},\"uid\":32,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":113}','221','2020-12-21 16:48:16','2020-12-21 16:48:16'),
	(53,70,2,'{\"productId\":2,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":19,\"isNew\":true,\"truePrice\":9999.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":0.00,\"unitName\":\"123\",\"otPrice\":12000.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"297\",\"price\":9999.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"iphone11\",\"id\":2,\"storeInfo\":\"苹果11\",\"tempId\":1,\"keyword\":\"苹果手机\",\"stock\":19,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":0.00,\"productId\":2,\"otPrice\":12000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":9999.00,\"unique\":\"\",\"id\":207,\"stock\":19}},\"uid\":46,\"productAttrUnique\":\"207\",\"bargainId\":0,\"id\":115}','207','2020-12-21 17:26:46','2020-12-21 17:26:46'),
	(54,71,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35958,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":6,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35958,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":999}},\"uid\":46,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":116}','373','2020-12-21 17:28:32','2020-12-21 17:28:32'),
	(55,72,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35958,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":6,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35958,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":998}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":117}','373','2020-12-21 17:33:22','2020-12-21 17:33:22'),
	(56,73,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35957,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":7,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35957,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":997}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":118}','373','2020-12-21 17:34:11','2020-12-21 17:34:11'),
	(57,74,2,'{\"productId\":2,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":0.00,\"trueStock\":18,\"isNew\":true,\"truePrice\":9999.00,\"type\":\"product\",\"cartNum\":2,\"productInfo\":{\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":0.00,\"unitName\":\"123\",\"otPrice\":12000.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"297\",\"price\":9999.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"iphone11\",\"id\":2,\"storeInfo\":\"苹果11\",\"tempId\":1,\"keyword\":\"苹果手机\",\"stock\":18,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":0.00,\"productId\":2,\"otPrice\":12000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":9999.00,\"unique\":\"\",\"id\":207,\"stock\":18}},\"uid\":44,\"productAttrUnique\":\"207\",\"bargainId\":0,\"id\":119}','207','2020-12-21 17:34:31','2020-12-21 17:34:31'),
	(58,75,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35956,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":8,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35956,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":349,\"stock\":995}},\"uid\":44,\"productAttrUnique\":\"349\",\"bargainId\":0,\"id\":120}','349','2020-12-21 17:36:23','2020-12-21 17:36:23'),
	(59,76,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":994,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":994,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":994}},\"uid\":37,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":121}','221','2020-12-21 17:38:27','2020-12-21 17:38:27'),
	(60,77,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35955,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":9,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35955,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":996}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":122}','373','2020-12-21 17:42:20','2020-12-21 17:42:20'),
	(61,78,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35954,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":10,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35954,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":995}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":122}','373','2020-12-21 17:42:36','2020-12-21 17:42:36'),
	(62,79,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":14,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":8,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":14,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":8,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":14}},\"uid\":46,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":123}','308','2020-12-21 17:44:47','2020-12-21 17:44:47'),
	(63,80,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35953,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":11,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35953,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":994}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":124}','373','2020-12-21 17:45:43','2020-12-21 17:45:43'),
	(64,81,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35952,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":12,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35952,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":993}},\"uid\":44,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":125}','373','2020-12-21 17:48:32','2020-12-21 17:48:32'),
	(65,82,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35951,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":13,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35951,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":992}},\"uid\":37,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":126}','373','2020-12-21 17:50:08','2020-12-21 17:50:08'),
	(66,83,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":993,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":6,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":993,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":221,\"stock\":993}},\"uid\":44,\"productAttrUnique\":\"221\",\"bargainId\":0,\"id\":127}','221','2020-12-21 17:52:12','2020-12-21 17:52:12'),
	(67,84,9,'{\"productId\":9,\"vipTruePrice\":0,\"combinationId\":5,\"costPrice\":5000.00,\"trueStock\":999,\"pinkId\":0,\"truePrice\":10000.00,\"type\":\"3\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":4,\"price\":10000.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":5,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":2992,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":5,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,换修无忧年付版\",\"weight\":0.00,\"type\":3,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"quota\":999,\"quotaShow\":999,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"换修无忧年付版\\\"}\",\"id\":636,\"stock\":999}},\"productAttrUnique\":\"636\"}','636','2020-12-21 18:04:57','2020-12-21 18:04:57'),
	(68,85,9,'{\"productId\":9,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":5000.00,\"trueStock\":35949,\"isNew\":true,\"truePrice\":10000.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":5000.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":15,\"sliderImage\":\"[\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\\\",\\\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"490,315,472\",\"price\":10000.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":9,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"keyword\":\"手机\",\"stock\":35949,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":9,\"otPrice\":0.00,\"suk\":\"金色,512GB,值享焕新版\",\"weight\":0.00,\"type\":0,\"sales\":8,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":10000.00,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"金色\\\",\\\"版本\\\":\\\"512GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":373,\"stock\":991}},\"uid\":35,\"productAttrUnique\":\"373\",\"bargainId\":0,\"id\":128}','373','2020-12-21 18:14:35','2020-12-21 18:14:35'),
	(69,86,9,'{\"productId\":9,\"seckillId\":3,\"vipTruePrice\":0,\"costPrice\":5000.00,\"trueStock\":997,\"truePrice\":1.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"cost\":0.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"postage\":0.00,\"price\":1.00,\"storeName\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"id\":3,\"storeInfo\":\"【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机\",\"tempId\":2,\"stock\":3994,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"cost\":5000.00,\"productId\":3,\"otPrice\":0.00,\"suk\":\"海蓝色,128GB,值享焕新版\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":1.00,\"quota\":997,\"quotaShow\":997,\"unique\":\"\",\"attrValue\":\"{\\\"颜色\\\":\\\"海蓝色\\\",\\\"版本\\\":\\\"128GB\\\",\\\"购买方式\\\":\\\"值享焕新版\\\"}\",\"id\":464,\"stock\":997}},\"productAttrUnique\":\"464\"}','464','2020-12-22 09:20:10','2020-12-22 09:20:10'),
	(70,87,14,'{\"productId\":14,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":1,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":10.00,\"unitName\":\"台\",\"otPrice\":1000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"笔记本电脑\",\"id\":14,\"storeInfo\":\"笔记本电脑\",\"tempId\":2,\"keyword\":\"笔记本电脑\",\"stock\":1,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":10.00,\"productId\":14,\"otPrice\":1000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":843,\"stock\":1}},\"uid\":52,\"productAttrUnique\":\"843\",\"bargainId\":0,\"id\":129}','843','2020-12-22 10:26:03','2020-12-22 10:26:03'),
	(71,94,14,'{\"productId\":14,\"seckillId\":4,\"vipTruePrice\":0,\"costPrice\":0.00,\"trueStock\":999,\"truePrice\":100.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":0.00,\"unitName\":\"台\",\"otPrice\":1000.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"postage\":0.00,\"price\":100.00,\"storeName\":\"笔记本电脑\",\"id\":4,\"storeInfo\":\"笔记本电脑\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":0.00,\"productId\":4,\"otPrice\":1000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":999,\"quotaShow\":999,\"unique\":\"\",\"id\":645,\"stock\":999}},\"productAttrUnique\":\"645\"}','645','2020-12-22 11:13:01','2020-12-22 11:13:01'),
	(72,95,14,'{\"productId\":14,\"seckillId\":4,\"vipTruePrice\":0,\"costPrice\":0.00,\"trueStock\":999,\"truePrice\":100.00,\"type\":\"1\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":0.00,\"unitName\":\"台\",\"otPrice\":1000.00,\"isPostage\":false,\"sort\":0,\"sales\":0,\"postage\":0.00,\"price\":100.00,\"storeName\":\"笔记本电脑\",\"id\":4,\"storeInfo\":\"笔记本电脑\",\"tempId\":2,\"stock\":999,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"cost\":0.00,\"productId\":4,\"otPrice\":1000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":1,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"quota\":999,\"quotaShow\":999,\"unique\":\"\",\"id\":645,\"stock\":999}},\"productAttrUnique\":\"645\"}','645','2020-12-22 11:13:45','2020-12-22 11:13:45'),
	(73,96,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1800,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":0,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1800,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":100}},\"uid\":52,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":132}','847','2020-12-22 11:23:00','2020-12-22 11:23:00'),
	(74,97,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1799,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":1,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1799,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":99}},\"uid\":52,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":133}','847','2020-12-22 12:11:47','2020-12-22 12:11:47'),
	(75,98,19,'{\"productId\":19,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":200.00,\"trueStock\":1200,\"isNew\":true,\"truePrice\":428.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i1\\\\/693060164\\\\/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg\",\"cost\":200.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":98,\"sales\":0,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01hRYyYC1D59aGylQuO_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01IzHD3j1D59aKgOB4A_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01tL10tb1D59aGbm21Z_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01XnrWtq1D59aGblUki_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":428.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"id\":19,\"storeInfo\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"tempId\":2,\"keyword\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"stock\":1200,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\",\"cost\":200.00,\"productId\":19,\"otPrice\":0.00,\"suk\":\"190/104A/XXXL,蓝灰25\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":428.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"190/104A/XXXL\\\",\\\"颜色\\\":\\\"蓝灰25\\\"}\",\"id\":906,\"stock\":100}},\"uid\":52,\"productAttrUnique\":\"906\",\"bargainId\":0,\"id\":134}','906','2020-12-22 14:39:34','2020-12-22 14:39:34'),
	(76,99,19,'{\"productId\":19,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":200.00,\"trueStock\":1199,\"isNew\":true,\"truePrice\":428.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"\\\\/\\\\/img.alicdn.com\\\\/imgextra\\\\/i1\\\\/693060164\\\\/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg\",\"cost\":200.00,\"unitName\":\"件\",\"otPrice\":0.00,\"isPostage\":false,\"isSub\":false,\"sort\":98,\"sales\":1,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01hRYyYC1D59aGylQuO_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01IzHD3j1D59aKgOB4A_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01tL10tb1D59aGbm21Z_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i3/693060164/O1CN01XnrWtq1D59aGblUki_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":428.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"id\":19,\"storeInfo\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"tempId\":2,\"keyword\":\"【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男\",\"stock\":1199,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"\",\"cost\":200.00,\"productId\":19,\"otPrice\":0.00,\"suk\":\"190/104A/XXXL,蓝灰25\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":428.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"190/104A/XXXL\\\",\\\"颜色\\\":\\\"蓝灰25\\\"}\",\"id\":906,\"stock\":99}},\"uid\":52,\"productAttrUnique\":\"906\",\"bargainId\":0,\"id\":135}','906','2020-12-22 14:44:28','2020-12-22 14:44:28'),
	(77,100,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":500,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":0,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":500,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":100}},\"uid\":40,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":136}','839','2020-12-22 15:07:58','2020-12-22 15:07:58'),
	(78,101,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":499,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":499,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":99}},\"uid\":52,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":137}','839','2020-12-22 15:48:10','2020-12-22 15:48:10'),
	(79,102,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1798,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":2,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1798,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":98}},\"uid\":57,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":138}','847','2020-12-22 15:49:39','2020-12-22 15:49:39'),
	(80,103,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1797,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":3,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1797,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":97}},\"uid\":34,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":141}','847','2020-12-22 16:05:12','2020-12-22 16:05:12'),
	(81,104,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1796,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":4,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1796,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,粉红58\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"粉红58\\\"}\",\"id\":848,\"stock\":100}},\"uid\":57,\"productAttrUnique\":\"848\",\"bargainId\":0,\"id\":143}','848','2020-12-22 16:37:22','2020-12-22 16:37:22'),
	(82,105,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1795,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":2,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":5,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1795,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,粉红58\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"粉红58\\\"}\",\"id\":848,\"stock\":99}},\"uid\":52,\"productAttrUnique\":\"848\",\"bargainId\":0,\"id\":145}','848','2020-12-22 16:39:33','2020-12-22 16:39:33'),
	(83,106,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":422,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":10,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":422,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":393,\"stock\":2}},\"uid\":32,\"productAttrUnique\":\"393\",\"bargainId\":0,\"id\":146}','393','2020-12-22 16:44:29','2020-12-22 16:44:29'),
	(84,107,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1793,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":7,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1793,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":96}},\"uid\":35,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":147}','847','2020-12-22 16:45:22','2020-12-22 16:45:22'),
	(85,108,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":13,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":9,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":13,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":9,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":13}},\"uid\":32,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":148}','308','2020-12-22 16:48:34','2020-12-22 16:48:34'),
	(86,109,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":12,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":10,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":12,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":10,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":308,\"stock\":12}},\"uid\":32,\"productAttrUnique\":\"308\",\"bargainId\":0,\"id\":150}','308','2020-12-22 16:49:28','2020-12-22 16:49:28'),
	(87,110,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":499,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":1,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":499,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":99}},\"uid\":32,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":152}','839','2020-12-22 17:47:16','2020-12-22 17:47:16'),
	(88,111,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":498,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":2,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":498,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":98}},\"uid\":52,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":155}','839','2020-12-23 09:18:47','2020-12-23 09:18:47'),
	(89,112,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1792,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":8,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1792,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":95}},\"uid\":52,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":173}','847','2020-12-23 09:50:00','2020-12-23 09:50:00'),
	(90,113,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":1920,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":1920,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1124,\"stock\":10}},\"uid\":57,\"productAttrUnique\":\"1124\",\"bargainId\":0,\"id\":174}','1124','2020-12-23 09:56:20','2020-12-23 09:56:20'),
	(91,114,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1791,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":2,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":9,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":2,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1791,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":847,\"stock\":94}},\"uid\":52,\"productAttrUnique\":\"847\",\"bargainId\":0,\"id\":175}','847','2020-12-23 10:02:01','2020-12-23 10:02:01'),
	(92,115,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1789,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":11,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1789,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":92}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":178}','1319','2020-12-23 10:06:52','2020-12-23 10:06:52'),
	(93,116,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":421,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":11,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":421,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"128GB,800,全网通\",\"weight\":9.00,\"type\":0,\"sales\":1,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"128GB\\\",\\\"ROM\\\":\\\"800\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":393,\"stock\":1}},\"uid\":33,\"productAttrUnique\":\"393\",\"bargainId\":0,\"id\":179}','393','2020-12-23 10:07:21','2020-12-23 10:07:21'),
	(94,117,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":497,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":3,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":497,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":97}},\"uid\":33,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":180}','839','2020-12-23 10:15:11','2020-12-23 10:15:11'),
	(95,118,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1789,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":11,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1789,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":92}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":181}','1319','2020-12-23 10:23:10','2020-12-23 10:23:10'),
	(96,119,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1789,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":11,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1789,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":92}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":183}','1319','2020-12-23 10:25:05','2020-12-23 10:25:05'),
	(97,120,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1789,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":11,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1789,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":92}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":184}','1319','2020-12-23 10:28:42','2020-12-23 10:28:42'),
	(98,121,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":420,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":12,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":420,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"32GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"32GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":409,\"stock\":9}},\"uid\":44,\"productAttrUnique\":\"409\",\"bargainId\":0,\"id\":185}','409','2020-12-23 10:47:05','2020-12-23 10:47:05'),
	(99,122,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":496,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":496,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":96}},\"uid\":52,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":186}','839','2020-12-23 10:55:24','2020-12-23 10:55:24'),
	(100,123,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1789,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":11,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1789,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":92}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":187}','1319','2020-12-23 10:57:21','2020-12-23 10:57:21'),
	(101,124,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1788,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":12,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1788,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":91}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":189}','1319','2020-12-23 11:11:47','2020-12-23 11:11:47'),
	(102,125,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1787,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":13,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1787,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":2,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":90}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":190}','1319','2020-12-23 11:15:24','2020-12-23 11:15:24'),
	(103,126,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":496,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":496,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":96}},\"uid\":52,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":191}','839','2020-12-23 11:20:04','2020-12-23 11:20:04'),
	(104,127,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1786,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":14,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1786,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":89}},\"uid\":57,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":193}','1319','2020-12-23 11:39:59','2020-12-23 11:39:59'),
	(105,128,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1786,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":14,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1786,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":89}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":192}','1319','2020-12-23 11:40:48','2020-12-23 11:40:48'),
	(106,129,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1784,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":16,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1784,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":87}},\"uid\":52,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":197}','1319','2020-12-23 11:56:03','2020-12-23 11:56:03'),
	(107,130,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1784,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":16,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1784,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":87}},\"uid\":57,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":196}','1319','2020-12-23 11:59:27','2020-12-23 11:59:27'),
	(108,131,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":1920,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":0,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":1920,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":0,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1124,\"stock\":10}},\"uid\":35,\"productAttrUnique\":\"1124\",\"bargainId\":0,\"id\":199}','1124','2020-12-23 12:02:55','2020-12-23 12:02:55'),
	(109,132,20,'{\"productId\":20,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10.00,\"trueStock\":1919,\"isNew\":true,\"truePrice\":0.01,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"cost\":10.00,\"unitName\":\"套\",\"otPrice\":30.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":1,\"sliderImage\":\"[\\\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\\\",\\\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"517\",\"price\":0.01,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"单规格商品测试\",\"id\":20,\"storeInfo\":\"单规格商品测试\",\"tempId\":2,\"keyword\":\"单规格商品测试\",\"stock\":1919,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"cost\":10.00,\"productId\":20,\"otPrice\":30.00,\"suk\":\"测试,1,12,df \",\"weight\":0.00,\"type\":0,\"sales\":1,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.01,\"unique\":\"\",\"attrValue\":\"{\\\"测试\\\":\\\"测试\\\",\\\"生成\\\":\\\"1\\\",\\\"从啊\\\":\\\"12\\\",\\\"额为\\\":\\\"df \\\"}\",\"id\":1124,\"stock\":9}},\"uid\":57,\"productAttrUnique\":\"1124\",\"bargainId\":0,\"id\":200}','1124','2020-12-23 12:03:30','2020-12-23 12:03:30'),
	(110,133,17,'{\"productId\":17,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":495,\"isNew\":true,\"truePrice\":218.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":299.00,\"isPostage\":false,\"isSub\":false,\"sort\":100,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\\\",\\\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\\\",\\\"image/content/2020/12/22/b882a1f490de4abbb4528a834ab77016a5m7pvum0t.png\\\",\\\"image/content/2020/12/22/9ecc938f82a147a98b4c27bfd5ba85f1sgt9duneus.png\\\",\\\"image/content/2020/12/22/2549fa79a9df4b4790ed3c3e896223e2g4v5ezm22w.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":218.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"id\":17,\"storeInfo\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"tempId\":2,\"keyword\":\"HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男\",\"stock\":495,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"cost\":100.00,\"productId\":17,\"otPrice\":299.00,\"suk\":\"175/92A/L,牛仔蓝66\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":218.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"175/92A/L\\\",\\\"颜色\\\":\\\"牛仔蓝66\\\"}\",\"id\":839,\"stock\":95}},\"uid\":33,\"productAttrUnique\":\"839\",\"bargainId\":0,\"id\":201}','839','2020-12-23 12:17:02','2020-12-23 12:17:02'),
	(111,134,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1782,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":18,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1782,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":85}},\"uid\":33,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":199}','1319','2020-12-23 14:39:07','2020-12-23 14:39:07'),
	(112,135,15,'{\"productId\":15,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":100.00,\"trueStock\":1781,\"isNew\":true,\"truePrice\":159.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"cost\":100.00,\"unitName\":\"件\",\"otPrice\":199.00,\"isPostage\":false,\"isSub\":false,\"sort\":99,\"sales\":19,\"sliderImage\":\"[\\\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\\\",\\\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"516\",\"price\":159.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"id\":15,\"storeInfo\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"tempId\":3,\"keyword\":\"【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男\",\"stock\":1781,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"cost\":100.00,\"productId\":15,\"otPrice\":199.00,\"suk\":\"170/88A/M,燕麦54\",\"weight\":0.00,\"type\":0,\"sales\":8,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":159.00,\"unique\":\"\",\"attrValue\":\"{\\\"尺码\\\":\\\"170/88A/M\\\",\\\"颜色\\\":\\\"燕麦54\\\"}\",\"id\":1319,\"stock\":84}},\"uid\":132,\"productAttrUnique\":\"1319\",\"bargainId\":0,\"id\":203}','1319','2020-12-23 16:26:38','2020-12-23 16:26:38'),
	(113,136,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":97,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":3,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":97,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":3,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":97}},\"uid\":140,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":205}','309','2020-12-23 16:30:33','2020-12-23 16:30:33'),
	(114,137,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":96,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":4,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":96,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":4,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":96}},\"uid\":144,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":207}','309','2020-12-23 16:34:26','2020-12-23 16:34:26'),
	(115,138,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":95,\"isNew\":false,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":5,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":95,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":5,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":95}},\"uid\":71,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":210}','309','2020-12-23 16:38:25','2020-12-23 16:38:25'),
	(116,138,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":419,\"isNew\":false,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":13,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":419,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"16GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":0,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"16GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":397,\"stock\":9}},\"uid\":71,\"productAttrUnique\":\"397\",\"bargainId\":0,\"id\":209}','397','2020-12-23 16:38:25','2020-12-23 16:38:25'),
	(117,139,1,'{\"productId\":1,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":9.00,\"trueStock\":418,\"isNew\":true,\"truePrice\":99.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"cost\":9.00,\"unitName\":\"T\",\"otPrice\":9.00,\"isPostage\":false,\"isSub\":false,\"sort\":1,\"sales\":14,\"sliderImage\":\"[\\\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":99.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"圈粉\",\"id\":1,\"storeInfo\":\"圈粉\",\"tempId\":1,\"keyword\":\"圈粉\",\"stock\":418,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"cost\":9.00,\"productId\":1,\"otPrice\":9.00,\"suk\":\"16GB,100,全网通\",\"weight\":9.00,\"type\":0,\"sales\":1,\"barCode\":\"9\",\"brokerageTwo\":0.00,\"volume\":9.00,\"price\":99.00,\"unique\":\"\",\"attrValue\":\"{\\\"ram\\\":\\\"16GB\\\",\\\"ROM\\\":\\\"100\\\",\\\"网络\\\":\\\"全网通\\\"}\",\"id\":397,\"stock\":8}},\"uid\":158,\"productAttrUnique\":\"397\",\"bargainId\":0,\"id\":216}','397','2020-12-23 17:04:27','2020-12-23 17:04:27'),
	(118,140,10,'{\"productId\":10,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":10000.00,\"trueStock\":94,\"isNew\":true,\"truePrice\":0.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"unitName\":\"件\",\"otPrice\":10000.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":6,\"sliderImage\":\"[\\\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\\\",\\\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"246,248,258,488,489\",\"price\":0.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"大衣\",\"id\":10,\"storeInfo\":\"大衣\",\"tempId\":2,\"keyword\":\"大衣\",\"stock\":94,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg\",\"cost\":10000.00,\"productId\":10,\"otPrice\":10000.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":6,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":0.00,\"unique\":\"\",\"id\":309,\"stock\":94}},\"uid\":33,\"productAttrUnique\":\"309\",\"bargainId\":0,\"id\":224}','309','2021-01-07 14:35:06','2021-01-07 14:35:06'),
	(119,141,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":992,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":7,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\",\\\"image/content/2021/01/07/691116f900d54cef80d9df281e0252965kf4ltmy3f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":992,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":7,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":2162,\"stock\":992}},\"uid\":33,\"productAttrUnique\":\"2162\",\"bargainId\":0,\"id\":225}','2162','2021-01-07 14:35:40','2021-01-07 14:35:40'),
	(120,142,7,'{\"productId\":7,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":11,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"unitName\":\"盒\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":11,\"sliderImage\":\"[\\\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"腰果\",\"id\":7,\"storeInfo\":\"腰果\",\"tempId\":2,\"keyword\":\"腰果\",\"stock\":11,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"cost\":50.00,\"productId\":7,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":11,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":1852,\"stock\":11}},\"uid\":33,\"productAttrUnique\":\"1852\",\"bargainId\":0,\"id\":226}','1852','2021-01-07 14:42:08','2021-01-07 14:42:08'),
	(121,143,6,'{\"productId\":6,\"seckillId\":0,\"vipTruePrice\":0,\"combinationId\":0,\"costPrice\":50.00,\"trueStock\":991,\"isNew\":true,\"truePrice\":100.00,\"type\":\"product\",\"cartNum\":1,\"productInfo\":{\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"unitName\":\"件\",\"otPrice\":200.00,\"isPostage\":false,\"isSub\":false,\"sort\":0,\"sales\":8,\"sliderImage\":\"[\\\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\\\",\\\"image/content/2021/01/07/691116f900d54cef80d9df281e0252965kf4ltmy3f.png\\\"]\",\"barCode\":\"\",\"postage\":0.00,\"cateId\":\"315,472\",\"price\":100.00,\"vipPrice\":0.00,\"merId\":0,\"storeName\":\"百事可乐\",\"id\":6,\"storeInfo\":\"百事可乐\",\"tempId\":2,\"keyword\":\"百事可乐\",\"stock\":991,\"attrInfo\":{\"brokerage\":0.00,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"cost\":50.00,\"productId\":6,\"otPrice\":200.00,\"suk\":\"默认\",\"weight\":0.00,\"type\":0,\"sales\":8,\"barCode\":\"\",\"brokerageTwo\":0.00,\"volume\":0.00,\"price\":100.00,\"unique\":\"\",\"id\":2162,\"stock\":991}},\"uid\":33,\"productAttrUnique\":\"2162\",\"bargainId\":0,\"id\":230}','2162','2021-01-07 14:55:05','2021-01-07 14:55:05');

/*!40000 ALTER TABLE `eb_store_order_info` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_order_status
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_order_status`;

CREATE TABLE `eb_store_order_status` (
  `oid` int(10) unsigned NOT NULL COMMENT '订单id',
  `change_type` varchar(32) NOT NULL COMMENT '操作类型',
  `change_message` varchar(256) NOT NULL COMMENT '操作备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '操作时间',
  KEY `oid` (`oid`) USING BTREE,
  KEY `change_type` (`change_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单操作记录表';

LOCK TABLES `eb_store_order_status` WRITE;
/*!40000 ALTER TABLE `eb_store_order_status` DISABLE KEYS */;

INSERT INTO `eb_store_order_status` (`oid`, `change_type`, `change_message`, `create_time`)
VALUES
	(1,'cache_key_create_order','订单生成','2020-12-07 17:45:12'),
	(2,'cache_key_create_order','订单生成','2020-12-07 18:00:51'),
	(2,'pay_success','用户付款成功','2020-12-07 18:00:51'),
	(3,'cache_key_create_order','订单生成','2020-12-08 14:52:34'),
	(4,'cache_key_create_order','订单生成','2020-12-08 14:56:41'),
	(4,'pay_success','用户付款成功','2020-12-08 14:56:41'),
	(5,'cache_key_create_order','订单生成','2020-12-09 14:34:11'),
	(4,'refund_refuse','不退款款因：就不退','2020-12-09 15:27:14'),
	(6,'cache_key_create_order','订单生成','2020-12-09 16:40:08'),
	(6,'pay_success','用户付款成功','2020-12-09 16:40:08'),
	(7,'cache_key_create_order','订单生成','2020-12-10 10:10:09'),
	(7,'pay_success','用户付款成功','2020-12-10 10:10:47'),
	(8,'cache_key_create_order','订单生成','2020-12-10 10:33:31'),
	(9,'cache_key_create_order','订单生成','2020-12-10 10:33:58'),
	(10,'cache_key_create_order','订单生成','2020-12-10 15:28:11'),
	(10,'pay_success','用户付款成功','2020-12-10 15:28:11'),
	(11,'cache_key_create_order','订单生成','2020-12-11 15:21:43'),
	(11,'pay_success','用户付款成功','2020-12-11 15:21:43'),
	(12,'cache_key_create_order','订单生成','2020-12-14 17:06:37'),
	(12,'pay_success','用户付款成功','2020-12-14 17:06:43'),
	(13,'cache_key_create_order','订单生成','2020-12-15 09:31:04'),
	(13,'pay_success','用户付款成功','2020-12-15 09:31:04'),
	(14,'cache_key_create_order','订单生成','2020-12-15 09:57:18'),
	(15,'cache_key_create_order','订单生成','2020-12-15 10:24:28'),
	(15,'pay_success','用户付款成功','2020-12-15 10:24:28'),
	(16,'cache_key_create_order','订单生成','2020-12-15 10:34:08'),
	(16,'pay_success','用户付款成功','2020-12-15 10:34:08'),
	(17,'cache_key_create_order','订单生成','2020-12-15 12:09:15'),
	(17,'pay_success','用户付款成功','2020-12-15 12:09:15'),
	(17,'apply_refund','用户申请退款原因：','2020-12-15 12:09:49'),
	(17,'refund_price','退款给用户0元','2020-12-15 12:10:22'),
	(17,'order_refund_apply','申请退款','2020-12-15 12:10:54'),
	(18,'cache_key_create_order','订单生成','2020-12-15 12:22:01'),
	(18,'pay_success','用户付款成功','2020-12-15 12:22:01'),
	(18,'apply_refund','用户申请退款原因：','2020-12-15 12:22:33'),
	(18,'refund_price','退款给用户0元','2020-12-15 12:23:18'),
	(18,'order_refund_apply','申请退款','2020-12-15 12:23:54'),
	(19,'cache_key_create_order','订单生成','2020-12-16 10:08:08'),
	(19,'pay_success','用户付款成功','2020-12-16 10:08:08'),
	(20,'cache_key_create_order','订单生成','2020-12-17 10:25:53'),
	(20,'pay_success','用户付款成功','2020-12-17 10:25:53'),
	(21,'cache_key_create_order','订单生成','2020-12-17 10:50:04'),
	(21,'pay_success','用户付款成功','2020-12-17 10:50:04'),
	(22,'cache_key_create_order','订单生成','2020-12-17 11:01:17'),
	(22,'pay_success','用户付款成功','2020-12-17 11:01:17'),
	(23,'cache_key_create_order','订单生成','2020-12-17 11:09:43'),
	(23,'pay_success','用户付款成功','2020-12-17 11:09:43'),
	(24,'cache_key_create_order','订单生成','2020-12-17 11:16:49'),
	(24,'pay_success','用户付款成功','2020-12-17 11:16:49'),
	(25,'cache_key_create_order','订单生成','2020-12-17 11:19:14'),
	(25,'pay_success','用户付款成功','2020-12-17 11:19:14'),
	(26,'cache_key_create_order','订单生成','2020-12-17 11:27:54'),
	(26,'pay_success','用户付款成功','2020-12-17 11:27:54'),
	(22,'express','已发货 快递公司：中远快运, 快递单号：11111111','2020-12-17 14:35:38'),
	(21,'express','已发货 快递公司：宅急送, 快递单号：ZJS007001890652','2020-12-17 14:58:20'),
	(27,'cache_key_create_order','订单生成','2020-12-17 15:30:30'),
	(27,'pay_success','用户付款成功','2020-12-17 15:30:30'),
	(28,'cache_key_create_order','订单生成','2020-12-17 15:48:42'),
	(28,'pay_success','用户付款成功','2020-12-17 15:48:42'),
	(28,'delivery_fictitious','delivery_fictitious','2020-12-17 16:50:45'),
	(27,'delivery_fictitious','delivery_fictitious','2020-12-17 16:51:40'),
	(29,'cache_key_create_order','订单生成','2020-12-18 10:31:29'),
	(29,'pay_success','用户付款成功','2020-12-18 10:31:29'),
	(33,'cache_key_create_order','订单生成','2020-12-18 12:20:04'),
	(33,'pay_success','用户付款成功','2020-12-18 12:20:04'),
	(29,'refund_price','退款给用户100元','2020-12-18 14:11:01'),
	(29,'order_refund_apply','申请退款','2020-12-18 14:11:03'),
	(33,'refund_price','退款给用户10000元','2020-12-18 14:12:06'),
	(33,'order_refund_apply','申请退款','2020-12-18 14:13:03'),
	(34,'cache_key_create_order','订单生成','2020-12-18 16:07:49'),
	(34,'pay_success','用户付款成功','2020-12-18 16:07:49'),
	(35,'cache_key_create_order','订单生成','2020-12-18 16:13:32'),
	(35,'pay_success','用户付款成功','2020-12-18 16:13:32'),
	(36,'cache_key_create_order','订单生成','2020-12-18 16:14:51'),
	(36,'pay_success','用户付款成功','2020-12-18 16:14:51'),
	(36,'delivery_fictitious','delivery_fictitious','2020-12-18 16:16:31'),
	(36,'user_take_delivery','用户已收货','2020-12-18 16:16:53'),
	(37,'cache_key_create_order','订单生成','2020-12-18 16:18:50'),
	(37,'pay_success','用户付款成功','2020-12-18 16:18:50'),
	(37,'delivery_fictitious','delivery_fictitious','2020-12-18 16:19:23'),
	(37,'user_take_delivery','用户已收货','2020-12-18 16:19:53'),
	(38,'cache_key_create_order','订单生成','2020-12-18 16:22:12'),
	(38,'pay_success','用户付款成功','2020-12-18 16:22:12'),
	(39,'cache_key_create_order','订单生成','2020-12-18 16:34:09'),
	(39,'pay_success','用户付款成功','2020-12-18 16:34:09'),
	(39,'delivery_fictitious','delivery_fictitious','2020-12-18 16:34:23'),
	(39,'user_take_delivery','用户已收货','2020-12-18 16:34:53'),
	(40,'cache_key_create_order','订单生成','2020-12-21 09:20:07'),
	(40,'pay_success','用户付款成功','2020-12-21 09:20:07'),
	(41,'cache_key_create_order','订单生成','2020-12-21 09:52:11'),
	(41,'pay_success','用户付款成功','2020-12-21 09:52:11'),
	(47,'cache_key_create_order','订单生成','2020-12-21 10:27:58'),
	(47,'pay_success','用户付款成功','2020-12-21 10:27:58'),
	(48,'cache_key_create_order','订单生成','2020-12-21 10:29:27'),
	(48,'pay_success','用户付款成功','2020-12-21 10:29:27'),
	(49,'cache_key_create_order','订单生成','2020-12-21 10:32:18'),
	(49,'pay_success','用户付款成功','2020-12-21 10:32:18'),
	(40,'refund_price','退款给用户100元','2020-12-21 10:44:34'),
	(40,'order_refund_apply','申请退款','2020-12-21 10:45:00'),
	(40,'order_refund_apply','申请退款','2020-12-21 10:45:12'),
	(50,'cache_key_create_order','订单生成','2020-12-21 14:07:41'),
	(50,'pay_success','用户付款成功','2020-12-21 14:07:41'),
	(50,'delivery_fictitious','delivery_fictitious','2020-12-21 14:09:52'),
	(50,'user_take_delivery','用户已收货','2020-12-21 14:10:16'),
	(50,'apply_refund','用户申请退款原因：123','2020-12-21 14:13:07'),
	(50,'refund_price','退款给用户0元','2020-12-21 14:13:29'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:14:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:15:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:16:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:17:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:18:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:19:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:20:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:21:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:22:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:23:16'),
	(51,'cache_key_create_order','订单生成','2020-12-21 14:23:32'),
	(51,'pay_success','用户付款成功','2020-12-21 14:23:32'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:24:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:25:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:26:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:27:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:28:16'),
	(53,'cache_key_create_order','订单生成','2020-12-21 14:28:29'),
	(53,'pay_success','用户付款成功','2020-12-21 14:28:29'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:29:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:30:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:31:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:32:16'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:33:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:34:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:35:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:36:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:37:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:38:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:39:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:40:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:41:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:42:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:43:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:44:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:45:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:46:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:47:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:48:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:49:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:50:25'),
	(60,'cache_key_create_order','订单生成','2020-12-21 14:51:18'),
	(60,'pay_success','用户付款成功','2020-12-21 14:51:18'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:51:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:52:42'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:53:42'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:54:42'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:55:42'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:56:42'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:57:42'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:58:42'),
	(50,'order_refund_apply','申请退款','2020-12-21 14:59:42'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:00:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:01:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:02:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:03:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:04:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:05:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:06:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:07:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:08:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:09:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:10:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:11:43'),
	(62,'cache_key_create_order','订单生成','2020-12-21 15:11:49'),
	(62,'pay_success','用户付款成功','2020-12-21 15:11:49'),
	(62,'delivery_fictitious','delivery_fictitious','2020-12-21 15:12:05'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:12:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:13:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:14:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:15:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:16:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:17:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:18:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:19:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:20:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:21:43'),
	(63,'cache_key_create_order','订单生成','2020-12-21 15:22:35'),
	(63,'pay_success','用户付款成功','2020-12-21 15:22:36'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:22:43'),
	(63,'apply_refund','用户申请退款原因：','2020-12-21 15:22:47'),
	(63,'refund_price','退款给用户0元','2020-12-21 15:23:08'),
	(64,'cache_key_create_order','订单生成','2020-12-21 15:23:39'),
	(64,'pay_success','用户付款成功','2020-12-21 15:23:39'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:23:43'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:23:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:24:43'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:24:43'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:25:43'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:25:43'),
	(65,'cache_key_create_order','订单生成','2020-12-21 15:26:26'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:26:43'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:26:44'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:27:44'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:27:44'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:28:44'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:28:44'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:29:44'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:29:44'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:30:44'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:30:44'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:31:18'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:31:18'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:32:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:32:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:33:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:33:19'),
	(66,'cache_key_create_order','订单生成','2020-12-21 15:33:19'),
	(66,'pay_success','用户付款成功','2020-12-21 15:33:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:34:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:34:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:35:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:35:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:36:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:36:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:37:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:37:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:38:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:38:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:39:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:39:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:40:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:40:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:41:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:41:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:42:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:42:19'),
	(67,'cache_key_create_order','订单生成','2020-12-21 15:42:44'),
	(67,'pay_success','用户付款成功','2020-12-21 15:42:44'),
	(66,'delivery_fictitious','delivery_fictitious','2020-12-21 15:43:04'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:43:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:43:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:44:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:44:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:45:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:45:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:46:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:46:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:47:19'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:47:19'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:48:20'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:48:20'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:49:20'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:49:20'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:50:20'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:50:20'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:51:10'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:51:10'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:52:10'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:52:10'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:53:10'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:53:10'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:54:10'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:54:10'),
	(67,'delivery_fictitious','delivery_fictitious','2020-12-21 15:54:48'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:55:07'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:55:10'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:56:10'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:56:14'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:57:10'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:57:10'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:57:28'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:57:31'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:58:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:58:11'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:58:52'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:58:59'),
	(50,'order_refund_apply','申请退款','2020-12-21 15:59:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 15:59:11'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:00:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:00:11'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:00:45'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:00:56'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:01:09'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:01:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:01:11'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:02:09'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:02:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:02:11'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:02:27'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:02:28'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:02:41'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:03:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:03:11'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:03:49'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:04:09'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:04:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:04:21'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:05:09'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:05:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:05:11'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:06:09'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:06:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:06:11'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:07:09'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:07:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:07:11'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:08:09'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:08:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:08:11'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:09:09'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:09:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:09:11'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:10:09'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:10:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:10:11'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:11:10'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:11:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:11:11'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:12:10'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:12:11'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:12:11'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:13:23'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:13:23'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:13:23'),
	(67,'user_take_delivery','用户已收货','2020-12-21 16:14:23'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:14:23'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:14:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:15:24'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:15:24'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:16:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:16:24'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:16:24'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:17:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:17:24'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:17:24'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:18:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:18:25'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:18:25'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:19:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:19:25'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:19:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:20:23'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:20:25'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:20:41'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:20:42'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:21:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:21:25'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:21:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:21:42'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:21:43'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:22:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:22:25'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:22:25'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:23:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:23:25'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:23:25'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:24:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:24:25'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:24:25'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:25:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:25:25'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:25:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:25:55'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:26:25'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:27:25'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:28:01'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:28:03'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:28:25'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:29:07'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:29:18'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:29:19'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:29:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:30:07'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:30:07'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:30:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:30:40'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:30:40'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:30:41'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:31:07'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:31:13'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:31:24'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:31:43'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:32:11'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:32:13'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:32:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:33:13'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:34:02'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:34:13'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:35:13'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:35:13'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:35:25'),
	(50,'order_refund_apply','申请退款','2020-12-21 16:36:13'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:36:13'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:36:15'),
	(63,'order_refund_apply','申请退款','2020-12-21 16:36:21'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:37:25'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:38:25'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:39:25'),
	(66,'user_take_delivery','用户已收货','2020-12-21 16:40:17'),
	(68,'cache_key_create_order','订单生成','2020-12-21 16:48:16'),
	(68,'pay_success','用户付款成功','2020-12-21 16:48:16'),
	(70,'cache_key_create_order','订单生成','2020-12-21 17:26:46'),
	(70,'pay_success','用户付款成功','2020-12-21 17:26:46'),
	(71,'cache_key_create_order','订单生成','2020-12-21 17:28:32'),
	(71,'pay_success','用户付款成功','2020-12-21 17:28:32'),
	(60,'refund_price','退款给用户10000元','2020-12-21 17:32:05'),
	(60,'order_refund_apply','申请退款','2020-12-21 17:32:17'),
	(72,'cache_key_create_order','订单生成','2020-12-21 17:33:22'),
	(73,'cache_key_create_order','订单生成','2020-12-21 17:34:11'),
	(74,'cache_key_create_order','订单生成','2020-12-21 17:34:32'),
	(75,'cache_key_create_order','订单生成','2020-12-21 17:36:23'),
	(76,'cache_key_create_order','订单生成','2020-12-21 17:38:27'),
	(76,'pay_success','用户付款成功','2020-12-21 17:38:27'),
	(77,'cache_key_create_order','订单生成','2020-12-21 17:42:20'),
	(78,'cache_key_create_order','订单生成','2020-12-21 17:42:36'),
	(79,'cache_key_create_order','订单生成','2020-12-21 17:44:47'),
	(79,'pay_success','用户付款成功','2020-12-21 17:45:09'),
	(80,'cache_key_create_order','订单生成','2020-12-21 17:45:43'),
	(81,'cache_key_create_order','订单生成','2020-12-21 17:48:32'),
	(82,'cache_key_create_order','订单生成','2020-12-21 17:50:08'),
	(82,'pay_success','用户付款成功','2020-12-21 17:50:08'),
	(83,'cache_key_create_order','订单生成','2020-12-21 17:52:12'),
	(84,'cache_key_create_order','订单生成','2020-12-21 18:04:57'),
	(85,'cache_key_create_order','订单生成','2020-12-21 18:14:35'),
	(85,'pay_success','用户付款成功','2020-12-21 18:14:35'),
	(85,'delivery_fictitious','delivery_fictitious','2020-12-21 18:14:53'),
	(85,'user_take_delivery','用户已收货','2020-12-21 18:15:45'),
	(86,'cache_key_create_order','订单生成','2020-12-22 09:20:10'),
	(86,'pay_success','用户付款成功','2020-12-22 09:20:10'),
	(87,'cache_key_create_order','订单生成','2020-12-22 10:26:03'),
	(87,'pay_success','用户付款成功','2020-12-22 10:26:03'),
	(94,'cache_key_create_order','订单生成','2020-12-22 11:13:01'),
	(94,'pay_success','用户付款成功','2020-12-22 11:13:01'),
	(95,'cache_key_create_order','订单生成','2020-12-22 11:13:45'),
	(95,'pay_success','用户付款成功','2020-12-22 11:13:45'),
	(96,'cache_key_create_order','订单生成','2020-12-22 11:23:00'),
	(96,'pay_success','用户付款成功','2020-12-22 11:23:00'),
	(96,'delivery','已配送 发货人：张三, 发货人电话：13720000000','2020-12-22 12:02:55'),
	(96,'user_take_delivery','用户已收货','2020-12-22 12:03:33'),
	(97,'cache_key_create_order','订单生成','2020-12-22 12:11:47'),
	(97,'pay_success','用户付款成功','2020-12-22 12:11:47'),
	(97,'delivery_fictitious','delivery_fictitious','2020-12-22 12:12:06'),
	(97,'user_take_delivery','用户已收货','2020-12-22 12:12:33'),
	(98,'cache_key_create_order','订单生成','2020-12-22 14:39:34'),
	(98,'pay_success','用户付款成功','2020-12-22 14:39:34'),
	(98,'delivery_fictitious','delivery_fictitious','2020-12-22 14:39:47'),
	(98,'user_take_delivery','用户已收货','2020-12-22 14:40:18'),
	(99,'cache_key_create_order','订单生成','2020-12-22 14:44:28'),
	(99,'pay_success','用户付款成功','2020-12-22 14:44:28'),
	(99,'delivery_fictitious','delivery_fictitious','2020-12-22 14:44:57'),
	(99,'user_take_delivery','用户已收货','2020-12-22 14:45:34'),
	(100,'cache_key_create_order','订单生成','2020-12-22 15:07:58'),
	(100,'pay_success','用户付款成功','2020-12-22 15:07:58'),
	(100,'express','已发货 快递公司：宅急送, 快递单号：11111111','2020-12-22 15:12:59'),
	(100,'user_take_delivery','用户已收货','2020-12-22 15:13:34'),
	(101,'cache_key_create_order','订单生成','2020-12-22 15:48:10'),
	(102,'cache_key_create_order','订单生成','2020-12-22 15:49:39'),
	(103,'cache_key_create_order','订单生成','2020-12-22 16:05:12'),
	(103,'pay_success','用户付款成功','2020-12-22 16:05:12'),
	(101,'cancel_order','取消订单','2020-12-22 16:08:06'),
	(102,'pay_success','用户付款成功','2020-12-22 16:35:41'),
	(104,'cache_key_create_order','订单生成','2020-12-22 16:37:22'),
	(105,'cache_key_create_order','订单生成','2020-12-22 16:39:33'),
	(106,'cache_key_create_order','订单生成','2020-12-22 16:44:29'),
	(106,'pay_success','用户付款成功','2020-12-22 16:44:44'),
	(107,'cache_key_create_order','订单生成','2020-12-22 16:45:22'),
	(108,'cache_key_create_order','订单生成','2020-12-22 16:48:34'),
	(109,'cache_key_create_order','订单生成','2020-12-22 16:49:28'),
	(110,'cache_key_create_order','订单生成','2020-12-22 17:47:16'),
	(110,'pay_success','用户付款成功','2020-12-22 17:47:16'),
	(105,'pay_success','用户付款成功','2020-12-22 18:38:49'),
	(105,'delivery','已配送 发货人：张三, 发货人电话：13799999999','2020-12-22 18:44:04'),
	(105,'user_take_delivery','用户已收货','2020-12-22 18:46:10'),
	(111,'cache_key_create_order','订单生成','2020-12-23 09:18:47'),
	(111,'pay_success','用户付款成功','2020-12-23 09:18:47'),
	(112,'cache_key_create_order','订单生成','2020-12-23 09:50:00'),
	(113,'cache_key_create_order','订单生成','2020-12-23 09:56:20'),
	(113,'pay_success','用户付款成功','2020-12-23 09:56:47'),
	(113,'apply_refund','用户申请退款原因：爸爸拒腐防变句','2020-12-23 09:59:25'),
	(113,'refund_price','退款给用户0.01元','2020-12-23 09:59:59'),
	(113,'order_refund_apply','申请退款','2020-12-23 10:00:02'),
	(114,'cache_key_create_order','订单生成','2020-12-23 10:02:01'),
	(114,'pay_success','用户付款成功','2020-12-23 10:02:01'),
	(115,'cache_key_create_order','订单生成','2020-12-23 10:06:52'),
	(115,'pay_success','用户付款成功','2020-12-23 10:06:52'),
	(116,'cache_key_create_order','订单生成','2020-12-23 10:07:21'),
	(115,'delivery','已配送 发货人：李四, 发货人电话：13777777777','2020-12-23 10:08:19'),
	(115,'apply_refund','用户申请退款原因：请教各位吉萨高地环境广东刷卡该卡给大收到啊','2020-12-23 10:09:34'),
	(115,'user_take_delivery','用户已收货','2020-12-23 10:10:02'),
	(115,'refund_refuse','不退款款因：撒大公司大撒好的是的骄傲是个安公司杀阿达','2020-12-23 10:10:37'),
	(117,'cache_key_create_order','订单生成','2020-12-23 10:15:11'),
	(117,'pay_success','用户付款成功','2020-12-23 10:15:11'),
	(115,'user_take_delivery','用户已收货','2020-12-23 10:17:02'),
	(115,'apply_refund','用户申请退款原因：删除退款图片提交测试000','2020-12-23 10:18:44'),
	(115,'refund_price','退款给用户169元','2020-12-23 10:20:15'),
	(115,'order_refund_apply','申请退款','2020-12-23 10:21:02'),
	(118,'cache_key_create_order','订单生成','2020-12-23 10:23:10'),
	(118,'pay_success','用户付款成功','2020-12-23 10:23:10'),
	(118,'apply_refund','用户申请退款原因：','2020-12-23 10:23:28'),
	(118,'refund_price','退款给用户169元','2020-12-23 10:23:55'),
	(118,'order_refund_apply','申请退款','2020-12-23 10:24:02'),
	(119,'cache_key_create_order','订单生成','2020-12-23 10:25:05'),
	(119,'pay_success','用户付款成功','2020-12-23 10:25:05'),
	(119,'refund_price','退款给用户0元','2020-12-23 10:25:30'),
	(119,'order_refund_apply','申请退款','2020-12-23 10:26:02'),
	(120,'cache_key_create_order','订单生成','2020-12-23 10:28:42'),
	(120,'pay_success','用户付款成功','2020-12-23 10:28:42'),
	(120,'express','已发货 快递公司：宅急送, 快递单号：ZJS007001908104','2020-12-23 10:29:25'),
	(83,'pay_success','用户付款成功','2020-12-23 10:45:52'),
	(83,'apply_refund','用户申请退款原因：1','2020-12-23 10:46:14'),
	(121,'cache_key_create_order','订单生成','2020-12-23 10:47:05'),
	(121,'pay_success','用户付款成功','2020-12-23 10:47:05'),
	(120,'user_take_delivery','用户已收货','2020-12-23 10:51:02'),
	(120,'apply_refund','用户申请退款原因：','2020-12-23 10:51:12'),
	(120,'refund_price','退款给用户0元','2020-12-23 10:51:46'),
	(120,'order_refund_apply','申请退款','2020-12-23 10:52:02'),
	(121,'apply_refund','用户申请退款原因：bxy','2020-12-23 10:52:45'),
	(122,'cache_key_create_order','订单生成','2020-12-23 10:55:24'),
	(122,'pay_success','用户付款成功','2020-12-23 10:55:24'),
	(122,'apply_refund','用户申请退款原因：','2020-12-23 10:55:36'),
	(122,'refund_price','退款给用户100元','2020-12-23 10:56:15'),
	(122,'order_refund_apply','申请退款','2020-12-23 10:57:03'),
	(123,'cache_key_create_order','订单生成','2020-12-23 10:57:21'),
	(123,'pay_success','用户付款成功','2020-12-23 10:57:21'),
	(123,'apply_refund','用户申请退款原因：就是的撒环境的哈撒可见度啊是大','2020-12-23 11:00:56'),
	(123,'refund_price','退款给用户100元','2020-12-23 11:01:27'),
	(123,'order_refund_apply','申请退款','2020-12-23 11:02:08'),
	(124,'cache_key_create_order','订单生成','2020-12-23 11:11:47'),
	(124,'pay_success','用户付款成功','2020-12-23 11:11:47'),
	(125,'cache_key_create_order','订单生成','2020-12-23 11:15:24'),
	(125,'pay_success','用户付款成功','2020-12-23 11:15:24'),
	(125,'apply_refund','用户申请退款原因：sada sdas dasd ','2020-12-23 11:16:06'),
	(125,'refund_price','退款给用户169元','2020-12-23 11:17:07'),
	(125,'order_refund_apply','申请退款','2020-12-23 11:17:08'),
	(126,'cache_key_create_order','订单生成','2020-12-23 11:20:04'),
	(126,'pay_success','用户付款成功','2020-12-23 11:20:04'),
	(126,'apply_refund','用户申请退款原因：asdasd sad ','2020-12-23 11:20:18'),
	(126,'refund_price','退款给用户218元','2020-12-23 11:20:45'),
	(126,'order_refund_apply','申请退款','2020-12-23 11:21:08'),
	(127,'cache_key_create_order','订单生成','2020-12-23 11:39:59'),
	(127,'pay_success','用户付款成功','2020-12-23 11:39:59'),
	(128,'cache_key_create_order','订单生成','2020-12-23 11:40:48'),
	(128,'pay_success','用户付款成功','2020-12-23 11:40:48'),
	(129,'cache_key_create_order','订单生成','2020-12-23 11:56:03'),
	(129,'pay_success','用户付款成功','2020-12-23 11:56:03'),
	(130,'cache_key_create_order','订单生成','2020-12-23 11:59:27'),
	(130,'pay_success','用户付款成功','2020-12-23 11:59:27'),
	(131,'cache_key_create_order','订单生成','2020-12-23 12:02:55'),
	(132,'cache_key_create_order','订单生成','2020-12-23 12:03:30'),
	(132,'pay_success','用户付款成功','2020-12-23 12:03:35'),
	(132,'apply_refund','用户申请退款原因：不知你自己最可靠','2020-12-23 12:03:47'),
	(132,'refund_price','退款给用户0.01元','2020-12-23 12:04:23'),
	(132,'order_refund_apply','申请退款','2020-12-23 12:05:08'),
	(133,'cache_key_create_order','订单生成','2020-12-23 12:17:02'),
	(133,'pay_success','用户付款成功','2020-12-23 12:17:02'),
	(133,'express','已发货 快递公司：宅急送, 快递单号：ZJS007001908480','2020-12-23 12:18:09'),
	(134,'cache_key_create_order','订单生成','2020-12-23 14:39:07'),
	(134,'pay_success','用户付款成功','2020-12-23 14:39:07'),
	(135,'cache_key_create_order','订单生成','2020-12-23 16:26:38'),
	(136,'cache_key_create_order','订单生成','2020-12-23 16:30:33'),
	(137,'cache_key_create_order','订单生成','2020-12-23 16:34:26'),
	(138,'cache_key_create_order','订单生成','2020-12-23 16:38:25'),
	(139,'cache_key_create_order','订单生成','2020-12-23 17:04:27'),
	(124,'delivery_fictitious','delivery_fictitious','2020-12-24 08:45:25'),
	(134,'delivery_fictitious','delivery_fictitious','2020-12-25 16:10:32'),
	(117,'delivery_fictitious','delivery_fictitious','2020-12-25 16:10:46'),
	(114,'delivery_fictitious','delivery_fictitious','2020-12-25 16:10:52'),
	(111,'delivery','已配送 发货人：22, 发货人电话：13523232222','2020-12-29 18:53:51'),
	(140,'cache_key_create_order','订单生成','2021-01-07 14:35:06'),
	(140,'pay_success','用户付款成功','2021-01-07 14:35:07'),
	(141,'cache_key_create_order','订单生成','2021-01-07 14:35:40'),
	(141,'pay_success','用户付款成功','2021-01-07 14:35:40'),
	(116,'pay_success','用户付款成功','2021-01-07 14:35:58'),
	(142,'cache_key_create_order','订单生成','2021-01-07 14:42:08'),
	(142,'pay_success','用户付款成功','2021-01-07 14:42:08'),
	(143,'cache_key_create_order','订单生成','2021-01-07 14:55:05'),
	(143,'pay_success','用户付款成功','2021-01-07 14:55:05');

/*!40000 ALTER TABLE `eb_store_order_status` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_pink
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_pink`;

CREATE TABLE `eb_store_pink` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '拼团ID',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `order_id` varchar(32) NOT NULL COMMENT '订单id 生成',
  `order_id_key` int(10) unsigned NOT NULL COMMENT '订单id  数据库',
  `total_num` int(10) unsigned NOT NULL COMMENT '购买商品个数',
  `total_price` decimal(10,2) unsigned NOT NULL COMMENT '购买总金额',
  `cid` int(10) unsigned NOT NULL COMMENT '拼团商品id',
  `pid` int(10) unsigned NOT NULL COMMENT '商品id',
  `people` int(10) unsigned NOT NULL COMMENT '拼图总人数',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '拼团商品单价',
  `add_time` bigint(14) NOT NULL COMMENT '开始时间',
  `stop_time` bigint(14) NOT NULL COMMENT '结束时间',
  `k_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '团长id 0为团长',
  `is_tpl` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否发送模板消息0未发送1已发送',
  `is_refund` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否退款 0未退款 1已退款',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态1进行中2已完成3未完成',
  `is_virtual` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否虚拟拼团',
  `nickname` varchar(64) NOT NULL DEFAULT '' COMMENT '用户昵称',
  `avatar` varchar(256) NOT NULL DEFAULT '' COMMENT '用户头像',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='拼团表';

LOCK TABLES `eb_store_pink` WRITE;
/*!40000 ALTER TABLE `eb_store_pink` DISABLE KEYS */;

INSERT INTO `eb_store_pink` (`id`, `uid`, `order_id`, `order_id_key`, `total_num`, `total_price`, `cid`, `pid`, `people`, `price`, `add_time`, `stop_time`, `k_id`, `is_tpl`, `is_refund`, `status`, `is_virtual`, `nickname`, `avatar`)
VALUES
	(2,34,'wx2020121810312869500',29,1,100.00,6,7,3,100.00,1608258689061,1608262289061,0,0,0,3,0,'A????????','https://thirdwx.qlogo.cn/mmopen/vi_32/Zwfn0ApJTJpUbjeap0ckXazhmf2BwaEZXwyovgYpibsYJK5CYQfUiaUricqZb9VG561ENUK3aDWarzkAKLVSv4FDw/132'),
	(3,34,'wx2020121812200429132',33,1,10000.00,5,9,3,10000.00,1608265204431,1608268804431,0,0,0,3,0,'A????????','https://thirdwx.qlogo.cn/mmopen/vi_32/Zwfn0ApJTJpUbjeap0ckXazhmf2BwaEZXwyovgYpibsYJK5CYQfUiaUricqZb9VG561ENUK3aDWarzkAKLVSv4FDw/132'),
	(4,32,'wx2020122109200782038',40,1,100.00,6,7,3,100.00,1608513607550,1608517207550,0,0,0,3,0,'c740dbd9668d','image/store/2020/08/15/adae23e354114cd5bd8f3cae740741c23opxeh8kw2.jpg'),
	(5,34,'wx2020122109521158533',41,1,100.00,6,7,3,100.00,1608515531200,1608519131200,0,0,0,3,0,'A????????','https://thirdwx.qlogo.cn/mmopen/vi_32/Zwfn0ApJTJpUbjeap0ckXazhmf2BwaEZXwyovgYpibsYJK5CYQfUiaUricqZb9VG561ENUK3aDWarzkAKLVSv4FDw/132'),
	(6,32,'wx2020122110275816086',47,1,10000.00,5,9,3,10000.00,1608517678922,1608521278922,0,0,0,3,0,'c740dbd9668d','image/store/2020/08/15/adae23e354114cd5bd8f3cae740741c23opxeh8kw2.jpg'),
	(7,34,'wx2020122110292756428',48,1,10000.00,5,9,3,10000.00,1608517767081,1608521367081,0,0,0,3,0,'A????????','https://thirdwx.qlogo.cn/mmopen/vi_32/Zwfn0ApJTJpUbjeap0ckXazhmf2BwaEZXwyovgYpibsYJK5CYQfUiaUricqZb9VG561ENUK3aDWarzkAKLVSv4FDw/132'),
	(8,34,'wx2020122114233252378',51,1,10000.00,5,9,2,10000.00,1608531812932,1608535412932,0,0,0,3,0,'A????????','https://thirdwx.qlogo.cn/mmopen/vi_32/Zwfn0ApJTJpUbjeap0ckXazhmf2BwaEZXwyovgYpibsYJK5CYQfUiaUricqZb9VG561ENUK3aDWarzkAKLVSv4FDw/132'),
	(9,37,'wx2020122114282959962',53,1,10000.00,5,9,2,10000.00,1608532109059,1608532421440,0,0,0,3,0,'小脑斧','image/store/2020/08/15/adae23e354114cd5bd8f3cae740741c23opxeh8kw2.jpg'),
	(10,34,'wx2020122114511734340',60,1,10000.00,5,9,2,10000.00,1608533478123,1608533689983,0,0,0,3,0,'A????????','https://thirdwx.qlogo.cn/mmopen/vi_32/Zwfn0ApJTJpUbjeap0ckXazhmf2BwaEZXwyovgYpibsYJK5CYQfUiaUricqZb9VG561ENUK3aDWarzkAKLVSv4FDw/132'),
	(11,44,'wx2020122118045677666',84,1,10000.00,5,9,2,10000.00,1608545097086,1608548697086,0,0,0,3,0,'吵吵','image/store/2020/08/15/adae23e354114cd5bd8f3cae740741c23opxeh8kw2.jpg');

/*!40000 ALTER TABLE `eb_store_pink` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_product
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_product`;

CREATE TABLE `eb_store_product` (
  `id` mediumint(11) NOT NULL AUTO_INCREMENT COMMENT '商品id',
  `mer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商户Id(0为总后台管理员创建,不为0的时候是商户后台创建)',
  `image` varchar(256) NOT NULL COMMENT '商品图片',
  `slider_image` varchar(2000) NOT NULL COMMENT '轮播图',
  `store_name` varchar(128) NOT NULL COMMENT '商品名称',
  `store_info` varchar(256) NOT NULL COMMENT '商品简介',
  `keyword` varchar(256) NOT NULL COMMENT '关键字',
  `bar_code` varchar(15) NOT NULL DEFAULT '' COMMENT '商品条码（一维码）',
  `cate_id` varchar(64) NOT NULL COMMENT '分类id',
  `price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品价格',
  `vip_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '会员价格',
  `ot_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '市场价',
  `postage` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '邮费',
  `unit_name` varchar(32) NOT NULL COMMENT '单位名',
  `sort` smallint(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `sales` mediumint(11) unsigned NOT NULL DEFAULT '0' COMMENT '销量',
  `stock` mediumint(11) unsigned NOT NULL DEFAULT '0' COMMENT '库存',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态（0：未上架，1：上架）',
  `is_hot` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否热卖',
  `is_benefit` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否优惠',
  `is_best` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否精品',
  `is_new` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否新品',
  `add_time` int(11) unsigned NOT NULL COMMENT '添加时间',
  `is_postage` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否包邮',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `mer_use` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '商户是否代理 0不可代理1可代理',
  `give_integral` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '获得积分',
  `cost` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '成本价',
  `is_seckill` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀状态 0 未开启 1已开启',
  `is_bargain` tinyint(1) unsigned DEFAULT NULL COMMENT '砍价状态 0未开启 1开启',
  `is_good` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否优品推荐',
  `is_sub` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否单独分佣',
  `ficti` mediumint(11) DEFAULT '100' COMMENT '虚拟销量',
  `browse` int(11) DEFAULT '0' COMMENT '浏览量',
  `code_path` varchar(64) NOT NULL DEFAULT '' COMMENT '商品二维码地址(用户小程序海报)',
  `soure_link` varchar(255) DEFAULT '' COMMENT '淘宝京东1688类型',
  `video_link` varchar(200) NOT NULL DEFAULT '' COMMENT '主图视频链接',
  `temp_id` int(11) NOT NULL DEFAULT '1' COMMENT '运费模板ID',
  `spec_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '规格 0单 1多',
  `activity` varchar(255) NOT NULL DEFAULT '' COMMENT '活动显示排序0=默认, 1=秒杀，2=砍价，3=拼团',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `cate_id` (`cate_id`) USING BTREE,
  KEY `is_hot` (`is_hot`) USING BTREE,
  KEY `is_benefit` (`is_benefit`) USING BTREE,
  KEY `is_best` (`is_best`) USING BTREE,
  KEY `is_new` (`is_new`) USING BTREE,
  KEY `toggle_on_sale, is_del` (`is_del`) USING BTREE,
  KEY `price` (`price`) USING BTREE,
  KEY `is_show` (`is_show`) USING BTREE,
  KEY `sort` (`sort`) USING BTREE,
  KEY `sales` (`sales`) USING BTREE,
  KEY `add_time` (`add_time`) USING BTREE,
  KEY `is_postage` (`is_postage`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='商品表';

LOCK TABLES `eb_store_product` WRITE;
/*!40000 ALTER TABLE `eb_store_product` DISABLE KEYS */;

INSERT INTO `eb_store_product` (`id`, `mer_id`, `image`, `slider_image`, `store_name`, `store_info`, `keyword`, `bar_code`, `cate_id`, `price`, `vip_price`, `ot_price`, `postage`, `unit_name`, `sort`, `sales`, `stock`, `is_show`, `is_hot`, `is_benefit`, `is_best`, `is_new`, `add_time`, `is_postage`, `is_del`, `mer_use`, `give_integral`, `cost`, `is_seckill`, `is_bargain`, `is_good`, `is_sub`, `ficti`, `browse`, `code_path`, `soure_link`, `video_link`, `temp_id`, `spec_type`, `activity`)
VALUES
	(1,0,'image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','[\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\"]','圈粉','圈粉','圈粉','','246,248,258,488,489',99.00,0.00,9.00,0.00,'T',1,15,417,0,1,1,1,1,1609351045,0,0,0,1.00,9.00,0,NULL,1,0,1,33,'','','',1,1,'0, 1, 2, 3'),
	(2,0,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','[\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\"]','iphone11','苹果11','苹果手机','','297',0.00,0.00,0.00,0.00,'123',1,4,0,0,1,0,1,0,1610000234,0,0,0,1.00,0.00,0,NULL,0,0,1,0,'','','',1,1,'0, 1, 2, 3'),
	(5,0,'image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png','[\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"image/content/2021/01/07/691116f900d54cef80d9df281e0252965kf4ltmy3f.png\"]','可乐','可乐','可乐','','315,472',100.00,0.00,150.00,0.00,'件',0,5,992,1,0,0,0,0,1609987476,0,0,0,0.00,50.00,0,NULL,0,0,0,0,'','','',2,0,'0, 1, 2, 3'),
	(6,0,'image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg','[\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"image/content/2021/01/07/691116f900d54cef80d9df281e0252965kf4ltmy3f.png\"]','百事可乐','百事可乐','百事可乐','','315,472',100.00,0.00,200.00,0.00,'件',0,9,990,1,1,1,1,1,1609988164,0,0,0,0.00,50.00,0,NULL,1,0,0,6,'','','',2,0,'0, 1, 2, 3'),
	(7,0,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','[\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\"]','腰果','腰果','腰果','','315,472',100.00,0.00,200.00,0.00,'盒',0,12,10,1,1,1,1,1,1609117806,0,0,0,0.00,50.00,0,NULL,1,0,0,8,'','','',2,0,'0, 1, 2, 3'),
	(9,0,'http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg','[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/126824/39/18470/105470/5fac932fE40a97853/af543410cdd835d4.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151523/11/5403/78214/5faa2132Ed170865f/097502adeaf9a726.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146519/21/13742/80940/5faa2135E655cdc7e/7c43ae7561a1e504.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/127673/16/17981/80836/5faa2137E38f751d0/be2c476178ce9eb2.jpg\"]','【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机','【值享焕新版】Apple iPhone 12 Pro Max (A2412) 128GB 金色 支持移动联通电信5G 双卡双待手机','手机','','490,315,472',10000.00,0.00,0.00,0.00,'件',0,17,35947,1,0,0,1,0,1609117933,0,0,0,0.00,5000.00,0,NULL,0,0,0,2,'','','',2,1,'0, 1, 2, 3'),
	(10,0,'image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg','[\"image/content/2020/12/18/f6400b07464d4e4b8db7d0b0ebe624c5rtrk8wpwii.jpg\",\"image/content/2020/12/18/ca8b64ee2bf243fb8c202f0d366e99777cfbox0dos.jpg\"]','大衣','大衣','大衣','','246,248,258,488,489',0.00,0.00,10000.00,0.00,'件',0,7,93,1,1,1,1,1,1608254513,0,0,0,0.00,10000.00,0,NULL,1,0,0,25,'','','',2,0,''),
	(13,0,'img.alicdn.com\\/imgextra\\/i4\\/1794176171\\/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg','[\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01CbG9KF1vSMkiYjjJr_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01GwvntW1vSMkhgUUw5_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i3/1794176171/O1CN01OdxsQm1vSMkfOhu8B_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i4/1794176171/O1CN013HlIBb1vSMklCF1Hj_!!1794176171.jpg\",\"//img.alicdn.com/imgextra/i4/1794176171/O1CN01bB9sy01vSMkjBsRO7_!!1794176171.jpg\"]','P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机','P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机','P40pro千元安卓游戏智能便宜学生手机送oppo华为荣耀小米vivo耳机','','472',1000.00,0.00,0.00,0.00,'件',0,0,107460,1,0,0,0,0,1608523638,0,0,0,0.00,111.00,0,NULL,0,0,0,0,'','','',2,1,''),
	(14,0,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','[\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\"]','笔记本电脑','笔记本电脑','笔记本电脑','','315,472',1000.00,0.00,10000.00,0.00,'台',0,3,2997,1,0,0,0,0,1608607877,0,0,0,0.00,200.00,0,NULL,0,0,0,0,'','','',2,1,'0, 1, 2, 3'),
	(15,0,'//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg','[\"//img.alicdn.com/imgextra/i1/693060164/O1CN01hpz9pv1D59bK6Feeu_!!693060164-0-picasso.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01o4wQO51D59aPTY7Si_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i4/693060164/O1CN01XUYWuC1D59aEaxV6B_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01MZnemI1D59aOll0EU_!!693060164.jpg\"]','【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男','【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男','【烈儿推荐/周杰伦同款】HLA/海澜之家长袖针织衫2020秋季上衣男','','516',0.00,0.00,0.00,0.00,'件',90,20,100,0,1,1,1,1,1609899814,0,0,0,20.00,0.00,0,NULL,1,1,100,53,'','','',3,0,'0, 1, 2, 3'),
	(17,0,'image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png','[\"image/operation/2020/12/28/439cfd536aed4c18b501026ed97b52bbknv4zd5c4v.jpg\",\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\"]','HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男','HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男','HLA/海澜之家多色款长袖针织衫休闲熊猫系列简约舒适毛衣男','','516',0.00,0.00,0.00,0.00,'件',100,6,0,0,1,1,1,1,1609898561,0,0,0,30.00,0.00,0,NULL,1,1,100,11,'','','',2,0,'0, 2, 1, 3'),
	(18,0,'\\/\\/img.alicdn.com\\/imgextra\\/i1\\/693060164\\/O1CN01RpM8LX1D59bLOf3oS_!!693060164-0-picasso.jpg','[\"//img.alicdn.com/imgextra/i1/693060164/O1CN01RpM8LX1D59bLOf3oS_!!693060164-0-picasso.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01dF577A1D59aGtHK0G_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01HLjBvU1D59aGbkHts_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i3/693060164/O1CN010NqZB91D59aDJ2NtU_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01zMx89N1D59aDJ1e8g_!!693060164.jpg\"]','HLA/海澜之家时尚牛津纺清新休闲衬衫经典透气长袖衬衫男','HLA/海澜之家时尚牛津纺清新休闲衬衫经典透气长袖衬衫男','HLA/海澜之家时尚牛津纺清新休闲衬衫经典透气长袖衬衫男','','516',98.00,0.00,0.00,0.00,'件',97,0,1400,0,0,0,0,0,1609324188,0,0,0,20.00,50.00,0,NULL,0,0,100,1,'','','',2,1,'0, 1, 2, 3'),
	(19,0,'\\/\\/img.alicdn.com\\/imgextra\\/i1\\/693060164\\/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg','[\"//img.alicdn.com/imgextra/i1/693060164/O1CN01z3AofQ1D59bJUK8Yg_!!693060164-0-picasso.jpg\",\"//img.alicdn.com/imgextra/i3/693060164/O1CN01hRYyYC1D59aGylQuO_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i2/693060164/O1CN01IzHD3j1D59aKgOB4A_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i3/693060164/O1CN01tL10tb1D59aGbm21Z_!!693060164.jpg\",\"//img.alicdn.com/imgextra/i3/693060164/O1CN01XnrWtq1D59aGblUki_!!693060164.jpg\"]','【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男','【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男','【林更新同款】HLA/海澜之家舒适简约半高领净色羊绒衫柔软保暖男','','516',428.00,0.00,0.00,0.00,'件',98,2,1198,0,0,0,0,0,1609313970,0,0,0,20.00,200.00,0,NULL,0,0,0,1,'','','',2,1,'0, 1, 2, 3'),
	(20,0,'image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png','[\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\",\"image/content/2020/12/22/7bb3780abce24917b4af15337a8e8c7ds0wepy9ccf.png\"]','单规格商品测试','单规格商品测试','单规格商品测试','','517',0.01,0.00,30.00,0.00,'套',0,2,1918,1,0,0,0,0,1608771259,0,0,0,0.00,10.00,0,NULL,0,0,0,2,'','','',2,1,'0, 1, 2, 3'),
	(21,0,'http:\\/\\/img30.360buyimg.com\\/popWaterMark\\/jfs\\/t1\\/153225\\/32\\/10463\\/284339\\/5fde2371Ea335d101\\/af0ac9f754c62c64.jpg','[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/153225/32/10463/284339/5fde2371Ea335d101/af0ac9f754c62c64.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/142029/15/19116/143184/5fde2377Ebd8f5d1a/1e2cc7b676dafa5b.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/124795/21/8431/178793/5f24fa7aE3c42082c/c49aab117de72a92.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/112499/1/13861/192935/5f24fa7bEc0393353/bb013b8ad0df4aef.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/125430/18/8538/235422/5f24fa7bEd898b82c/f8d812d624ab7286.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/116535/12/13475/127375/5f24fa7aE3a8493c1/c39bbf2e500c09c4.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/149061/31/4197/66051/5f24fa7bE908d9d80/edc3f234e403bb46.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/69690/24/10859/195176/5d8829d9Ed4c9fb0f/3a7b4dede959ef81.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/147829/23/5528/148331/5f37acb2E653c3d4b/3fe090754f7054d0.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/113505/35/13736/88865/5f24fa79Eda4854c2/f63e65af6ed122e9.jpg\"]','德国WMF福腾宝不粘锅麦饭石色炒锅30cm炒菜锅少烟锅具煎锅平底煎炒锅煎蛋不粘锅电磁炉燃气煤气灶通用 星辰炒锅30cm','德国WMF福腾宝不粘锅麦饭石色炒锅30cm炒菜锅少烟锅具煎锅平底煎炒锅煎蛋不粘锅电磁炉燃气煤气灶通用 星辰炒锅30cm','锅','','516,517,246,248,258,488,489',99.00,0.00,0.00,0.00,'T',0,0,198,1,0,0,0,0,1608631625,0,0,0,1.00,99.00,0,NULL,0,0,1,0,'','','',2,1,''),
	(22,0,'http:\\/\\/img30.360buyimg.com\\/popWaterMark\\/jfs\\/t1\\/153225\\/32\\/10463\\/284339\\/5fde2371Ea335d101\\/af0ac9f754c62c64.jpg','[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/153225/32/10463/284339/5fde2371Ea335d101/af0ac9f754c62c64.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/142029/15/19116/143184/5fde2377Ebd8f5d1a/1e2cc7b676dafa5b.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/124795/21/8431/178793/5f24fa7aE3c42082c/c49aab117de72a92.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/112499/1/13861/192935/5f24fa7bEc0393353/bb013b8ad0df4aef.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/125430/18/8538/235422/5f24fa7bEd898b82c/f8d812d624ab7286.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/116535/12/13475/127375/5f24fa7aE3a8493c1/c39bbf2e500c09c4.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/149061/31/4197/66051/5f24fa7bE908d9d80/edc3f234e403bb46.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/69690/24/10859/195176/5d8829d9Ed4c9fb0f/3a7b4dede959ef81.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/147829/23/5528/148331/5f37acb2E653c3d4b/3fe090754f7054d0.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/113505/35/13736/88865/5f24fa79Eda4854c2/f63e65af6ed122e9.jpg\"]','德国WMF福腾宝不粘锅麦饭石色炒锅30cm炒菜锅少烟锅具煎锅平底煎炒锅煎蛋不粘锅电磁炉燃气煤气灶通用 星辰炒锅30cm','德国WMF福腾宝不粘锅麦饭石色炒锅30cm炒菜锅少烟锅具煎锅平底煎炒锅煎蛋不粘锅电磁炉燃气煤气灶通用 星辰炒锅30cm','锅','','516,517,246,248,258,488,489',99.00,0.00,0.00,0.00,'T',0,0,198,1,0,0,0,0,1609898806,0,0,0,1.00,99.00,0,NULL,0,0,1,0,'','','',2,1,'0, 1, 2, 3'),
	(23,0,'http://img30.360buyimg.com/popWaterMark/jfs/t1/141117/35/18227/113537/5fd8376eE93b27175/f9d8a919c323560b.jpg','[\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141117/35/18227/113537/5fd8376eE93b27175/f9d8a919c323560b.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/146689/39/16724/158244/5fc8d670Edc0060dd/e70c58b46a3f420f.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/129677/10/18512/127024/5fc8d672E1f941708/006aa769a7e9983f.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141276/6/16690/236799/5fc8d671E6a50f438/34e9a1976467c13b.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/151245/40/9184/108874/5fc8d672Efc76dfca/11f7d90e1fa1250a.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/143182/36/16820/181394/5fc8d70eE49ad4826/b1171a27eb80b2e8.jpg\",\"http://img30.360buyimg.com/popWaterMark/jfs/t1/141234/22/16836/107030/5fc8d670Ea6396c2e/dc1f5db7393b9057.jpg\"]','杯具熊（BEDDYBEAR）儿童保温杯带吸管儿童水杯316不锈钢双盖两用便携儿童保温壶600ML限量圣诞款-大脸鹿','杯具熊（BEDDYBEAR）儿童保温杯带吸管儿童水杯316不锈钢双盖两用便携儿童保温壶600ML限量圣诞款-大脸鹿','杯具熊','','516,517',228.00,0.00,228.00,0.00,'个',0,0,119988,0,0,0,0,0,1608689208,0,0,0,0.00,100.00,0,NULL,0,0,999,0,'','','',2,1,'');

/*!40000 ALTER TABLE `eb_store_product` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_product_attr
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_product_attr`;

CREATE TABLE `eb_store_product_attr` (
  `id` mediumint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `attr_name` varchar(32) NOT NULL COMMENT '属性名',
  `attr_values` varchar(256) NOT NULL COMMENT '属性值',
  `type` tinyint(1) DEFAULT '0' COMMENT '活动类型 0=商品，1=秒杀，2=砍价，3=拼团',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `store_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='商品属性表';

LOCK TABLES `eb_store_product_attr` WRITE;
/*!40000 ALTER TABLE `eb_store_product_attr` DISABLE KEYS */;

INSERT INTO `eb_store_product_attr` (`id`, `product_id`, `attr_name`, `attr_values`, `type`)
VALUES
	(4,1,'ram','8GB,16GB,32GB,128GB',3),
	(5,1,'ROM','100,800,1T',3),
	(6,1,'网络','全网通,移动,联通,电信',3),
	(10,1,'规格','默认',2),
	(12,2,'规格','默认',2),
	(13,3,'规格','默认',2),
	(14,4,'规格','默认',2),
	(16,2,'规格','默认',3),
	(20,5,'规格','默认',2),
	(25,3,'规格','默认',0),
	(26,4,'规格','默认',0),
	(27,6,'规格','默认',2),
	(28,7,'规格','默认',2),
	(30,8,'规格','默认',2),
	(34,9,'规格','默认',2),
	(35,3,'规格','默认',3),
	(36,8,'颜色','海蓝色,金色,石墨色,银色',0),
	(37,8,'版本','128GB,256GB,512GB',0),
	(38,8,'购买方式','公开版,值享焕新版,换修无忧年付版',0),
	(42,4,'颜色','海蓝色,金色,石墨色,银色',3),
	(43,4,'版本','128GB,256GB,512GB',3),
	(44,4,'购买方式','公开版,值享焕新版,换修无忧年付版',3),
	(46,10,'规格','默认',0),
	(53,6,'规格','默认',3),
	(71,13,'机身颜色','魅蓝色【8G运行】 5％选择这款,暗夜黑【8G运行】 5％选择这款,星云紫【8G运行】 5％选择这款,魅蓝色【10G运行】 10％选择这款,暗夜黑【10G运行】 10％选择这款,星云紫 【10G运行】 10％选择这款,魅蓝色【12G运行】 85％选择这款,暗夜黑【12G运行】 85％选择这款,星云紫【12G运行】 85％选择这款',0),
	(72,13,'套餐类型','官方标配,套餐一,套餐二,套餐三',0),
	(73,13,'存储容量','128GB,256GB,512GB',0),
	(74,13,'版本类型','中国大陆',0),
	(75,7,'机身颜色','魅蓝色【8G运行】 5％选择这款,暗夜黑【8G运行】 5％选择这款,星云紫【8G运行】 5％选择这款,魅蓝色【10G运行】 10％选择这款,暗夜黑【10G运行】 10％选择这款,星云紫 【10G运行】 10％选择这款,魅蓝色【12G运行】 85％选择这款,暗夜黑【12G运行】 85％选择这款,星云紫【12G运行】 85％选择这款',3),
	(76,7,'套餐类型','官方标配,套餐一,套餐二,套餐三',3),
	(77,7,'存储容量','128GB,256GB,512GB',3),
	(78,7,'版本类型','中国大陆',3),
	(100,8,'ram','8GB,16GB,32GB,128GB',3),
	(101,8,'ROM','100,800,1T',3),
	(102,8,'网络','全网通,移动,联通,电信',3),
	(103,1,'ram','8GB,16GB,32GB,128GB',1),
	(104,1,'ROM','100,800,1T',1),
	(105,1,'网络','全网通,移动,联通,电信',1),
	(120,16,'尺码','165/84A/S,170/88A/M,175/92A/L,180/96A/XL,185/100A/XXL,190/104A/XXXL',0),
	(121,16,'颜色','黑色53,粉红58,燕麦54',0),
	(136,5,'颜色','海蓝色,金色,石墨色,银色',3),
	(137,5,'版本','128GB,256GB,512GB',3),
	(138,5,'购买方式','公开版,值享焕新版,换修无忧年付版',3),
	(149,14,'ram','8GB,16GB,32GB,128GB',0),
	(150,14,'ROM','100,800,1T',0),
	(151,14,'网络','全网通,移动,联通,电信',0),
	(152,5,'ram','8GB,16GB,32GB,128GB',1),
	(153,5,'ROM','100,800,1T',1),
	(154,5,'网络','全网通,移动,联通,电信',1),
	(159,21,'颜色','星辰炒锅30cm,星辰炒锅32CM',0),
	(167,23,'颜色','3D浮雕-粉色独角兽,3D浮雕-蓝色鲸鱼,3D浮雕-红色恐龙,3D浮雕-狮子王,3D浮雕-棕色麋鹿,3D浮雕-红色熊猫,3D圣诞-大脸鹿,3D圣诞-星球鹿,3D圣诞-守护鹿,3D圣诞-抱抱熊,3D圣诞-幸运鹿,3D浮雕-小飞象',0),
	(168,10,'规格','默认',2),
	(177,20,'测试','测试,测试1,测试2',0),
	(178,20,'生成','1,2,3,4',0),
	(179,20,'从啊','12,a\'s,s\'d,d\'f',0),
	(180,20,'额为','再次,撒旦,df ,是',0),
	(181,3,'颜色','海蓝色,金色,石墨色,银色',1),
	(182,3,'版本','128GB,256GB,512GB',1),
	(183,3,'购买方式','公开版,值享焕新版,换修无忧年付版',1),
	(184,6,'规格','默认',1),
	(185,7,'规格','默认',1),
	(186,8,'尺码','170/88A/M,175/92A/L,180/96A/XL,185/100A/XXL,190/104A/XXXL',1),
	(187,8,'颜色','牛仔蓝66',1),
	(206,10,'num','01',1),
	(207,10,'测试21','黑色,白色',1),
	(208,11,'规格','默认',1),
	(209,7,'规格','默认',0),
	(210,9,'颜色','海蓝色,金色,石墨色,银色',0),
	(211,9,'版本','128GB,256GB,512GB',0),
	(212,9,'购买方式','公开版,值享焕新版,换修无忧年付版',0),
	(213,9,'尺码','165/84A/S,170/88A/M,175/92A/L,180/96A/XL,185/100A/XXL,190/104A/XXXL',3),
	(214,9,'颜色','黑色53,粉红58,燕麦54',3),
	(215,12,'尺码','165/84A/S,170/88A/M,175/92A/L,180/96A/XL,185/100A/XXL,190/104A/XXXL',1),
	(216,12,'颜色','蓝灰25,黑色26',1),
	(221,13,'尺码','165/84A/S,170/88A/M,175/92A/L,180/96A/XL,185/100A/XXL,190/104A/XXXL',1),
	(222,13,'颜色','黑色53,粉红58,燕麦54',1),
	(223,11,'规格','默认',2),
	(224,10,'尺码','165/84A/S,170/88A/M,175/92A/L,180/96A/XL,185/100A/XXL,190/104A/XXXL',3),
	(225,10,'颜色','黑色53,粉红58,燕麦54',3),
	(228,19,'尺码','165/84A/S,170/88A/M,175/92A/L,180/96A/XL,185/100A/XXL,190/104A/XXXL',0),
	(229,19,'颜色','蓝灰25,黑色26',0),
	(232,18,'尺码','175/96A,180/100A,165/84A,170/88A,175/92A,180/104A,180/108A',0),
	(233,18,'颜色','浅绿03,浅蓝05',0),
	(236,1,'ram','8GB,16GB,32GB,128GB',0),
	(237,1,'ROM','100,800,1T',0),
	(238,1,'网络','全网通,移动,联通,电信',0),
	(245,9,'尺码','170/88A/M,175/92A/L,180/96A/XL,185/100A/XXL,190/104A/XXXL',1),
	(246,9,'颜色','牛仔蓝66',1),
	(250,11,'颜色','3D浮雕-粉色独角兽,3D浮雕-蓝色鲸鱼,3D浮雕-红色恐龙,3D浮雕-狮子王,3D浮雕-棕色麋鹿,3D浮雕-红色熊猫,3D圣诞-大脸鹿,3D圣诞-星球鹿,3D圣诞-守护鹿,3D圣诞-抱抱熊,3D圣诞-幸运鹿,3D浮雕-小飞象',3),
	(251,17,'规格','默认',0),
	(252,12,'颜色','3D浮雕-粉色独角兽,3D浮雕-蓝色鲸鱼,3D浮雕-红色恐龙,3D浮雕-狮子王,3D浮雕-棕色麋鹿,3D浮雕-红色熊猫,3D圣诞-大脸鹿,3D圣诞-星球鹿,3D圣诞-守护鹿,3D圣诞-抱抱熊,3D圣诞-幸运鹿,3D浮雕-小飞象',3),
	(253,22,'颜色','星辰炒锅30cm,星辰炒锅32CM',0),
	(254,13,'颜色','3D浮雕-粉色独角兽,3D浮雕-蓝色鲸鱼,3D浮雕-红色恐龙,3D浮雕-狮子王,3D浮雕-棕色麋鹿,3D浮雕-红色熊猫,3D圣诞-大脸鹿,3D圣诞-星球鹿,3D圣诞-守护鹿,3D圣诞-抱抱熊,3D圣诞-幸运鹿,3D浮雕-小飞象',3),
	(255,15,'规格','默认',0),
	(256,12,'规格','默认',2),
	(261,5,'规格','默认',0),
	(262,6,'规格','默认',0),
	(263,2,'ram','8GB,16GB,32GB,128GB',0),
	(264,2,'ROM','100,800,1T',0),
	(265,2,'网络','全网通,移动,联通,电信',0),
	(266,2,'test','2',0),
	(267,13,'规格','默认',2),
	(268,14,'规格','默认',2),
	(269,15,'规格','默认',2),
	(270,16,'规格','默认',2),
	(271,17,'规格','默认',2);

/*!40000 ALTER TABLE `eb_store_product_attr` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_product_attr_result
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_product_attr_result`;

CREATE TABLE `eb_store_product_attr_result` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `product_id` int(10) unsigned NOT NULL COMMENT '商品ID',
  `result` text NOT NULL COMMENT '商品属性参数',
  `change_time` int(10) unsigned NOT NULL COMMENT '上次修改时间',
  `type` tinyint(1) DEFAULT '0' COMMENT '活动类型 0=商品，1=秒杀，2=砍价，3=拼团',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='商品属性详情表';

LOCK TABLES `eb_store_product_attr_result` WRITE;
/*!40000 ALTER TABLE `eb_store_product_attr_result` DISABLE KEYS */;

INSERT INTO `eb_store_product_attr_result` (`id`, `product_id`, `result`, `change_time`, `type`)
VALUES
	(2,1,'[{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":1,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,100,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":2,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,100,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":3,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,100,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":4,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,100,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":5,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,800,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":6,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,800,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":7,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,800,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":8,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,800,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":9,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,1T,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":10,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,1T,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":11,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,1T,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":12,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,1T,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":13,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,100,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":14,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,100,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":15,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,100,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":16,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,100,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":17,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,800,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":18,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,800,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":19,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,800,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":20,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,800,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":21,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,1T,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":22,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,1T,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":23,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,1T,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":24,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"16GB,1T,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":25,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,100,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":26,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,100,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":27,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,100,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":28,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,100,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":29,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,800,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":30,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,800,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":31,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,800,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":32,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,800,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":33,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,1T,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":34,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,1T,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":35,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,1T,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":36,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"32GB,1T,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":37,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,100,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":38,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,100,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":39,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,100,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":40,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,100,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":41,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":7,\"stock\":7,\"suk\":\"128GB,800,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":42,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,800,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":43,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,800,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":44,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,800,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":45,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,1T,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":46,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,1T,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":47,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,1T,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":48,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,1T,电信\",\"volume\":9.00,\"weight\":9.00}]',1607409889,3),
	(10,4,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":0.00,\"id\":151,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"minPrice\":0,\"otPrice\":12000.00,\"price\":9999,\"productId\":4,\"quota\":20,\"sales\":0,\"stock\":20,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1607498719,2),
	(11,3,'[{\"attrValue\":{\"ROM\":\"100\",\"网络\":\"全网通\",\"ram\":\"8GB\"},\"barCode\":\"9\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":9.00,\"id\":1,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"minPrice\":0,\"otPrice\":9.00,\"price\":99,\"quota\":9,\"stock\":9,\"suk\":\"8GB,100,全网通\",\"volume\":9.00,\"weight\":9.00}]',1607498730,2),
	(12,2,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":0.00,\"id\":149,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"minPrice\":0,\"otPrice\":12000.00,\"price\":9999,\"productId\":2,\"quota\":20,\"sales\":0,\"stock\":20,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1607498738,2),
	(14,5,'[{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":157,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"minPrice\":0,\"otPrice\":9.00,\"price\":1,\"quota\":9,\"stock\":9,\"suk\":\"8GB,100,全网通\",\"volume\":9.00,\"weight\":9.00}]',1607501956,2),
	(18,1,'[{\"attrValue\":{\"ROM\":\"100\",\"网络\":\"全网通\",\"ram\":\"8GB\"},\"barCode\":\"9\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":9.00,\"id\":157,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"minPrice\":0,\"otPrice\":9.00,\"price\":10,\"quota\":8,\"stock\":8,\"suk\":\"8GB,100,全网通\",\"volume\":9.00,\"weight\":9.00}]',1607999147,2),
	(19,6,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":50.00,\"id\":214,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"minPrice\":0,\"otPrice\":150.00,\"price\":100,\"productId\":6,\"quota\":998,\"sales\":1,\"stock\":998,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1608003674,2),
	(20,7,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"cost\":50.00,\"id\":212,\"image\":\"image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg\",\"minPrice\":0,\"otPrice\":150.00,\"price\":100,\"productId\":4,\"quota\":998,\"sales\":1,\"stock\":998,\"suk\":\"默认\",\"type\":false,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1608003990,2),
	(29,8,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":50.00,\"id\":224,\"image\":\"image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png\",\"minPrice\":0,\"otPrice\":150.00,\"price\":100,\"productId\":8,\"quota\":998,\"sales\":1,\"stock\":998,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1608174813,2),
	(30,8,'[{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"},\"brokerage\":0,\"cost\":5000,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"price\":10000,\"productId\":8,\"stock\":999}]',1608188719,0),
	(32,3,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":12000.00,\"id\":231,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":12000.00,\"price\":9999,\"productId\":3,\"quota\":19,\"quotaShow\":19,\"sales\":0,\"stock\":19,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1608188942,3),
	(33,4,'[{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":5000.00,\"id\":269,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":1,\"productId\":4,\"quota\":999,\"stock\":999,\"suk\":\"海蓝色,128GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":5000.00,\"id\":268,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":1,\"productId\":4,\"quota\":999,\"stock\":999,\"suk\":\"海蓝色,128GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":5000.00,\"id\":270,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":1,\"productId\":4,\"quota\":999,\"stock\":999,\"suk\":\"海蓝色,128GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00}]',1608191461,3),
	(46,13,'[{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995},{\"attrValue\":{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"},\"brokerage\":0,\"cost\":111,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"price\":1000,\"productId\":13,\"stock\":995}]',1608523640,0),
	(47,7,'[{\"attrValue\":{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":111.00,\"id\":532,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"otPrice\":0.00,\"price\":1000,\"productId\":7,\"quota\":995,\"stock\":995,\"suk\":\"星云紫 【10G运行】 10％选择这款,套餐一,128GB,中国大陆\",\"volume\":0.00,\"weight\":0.00}]',1608524012,3),
	(58,8,'[{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":385,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":10,\"productId\":8,\"quota\":9,\"stock\":9,\"suk\":\"128GB,100,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":386,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":8,\"quota\":9,\"stock\":9,\"suk\":\"128GB,100,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"checked\":true,\"cost\":9.00,\"id\":387,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":8,\"quota\":9,\"stock\":9,\"suk\":\"128GB,100,移动\",\"volume\":9.00,\"weight\":9.00}]',1608542699,3),
	(59,1,'[{\"attrValue\":{\"ROM\":\"100\",\"网络\":\"全网通\",\"ram\":\"128GB\"},\"barCode\":\"9\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":9.00,\"id\":385,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,100,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ROM\":\"100\",\"网络\":\"电信\",\"ram\":\"128GB\"},\"barCode\":\"9\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":9.00,\"id\":386,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,100,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ROM\":\"100\",\"网络\":\"移动\",\"ram\":\"128GB\"},\"barCode\":\"9\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":9.00,\"id\":387,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99,\"productId\":1,\"quota\":9,\"stock\":9,\"suk\":\"128GB,100,移动\",\"volume\":9.00,\"weight\":9.00}]',1608542972,1),
	(66,2,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"cost\":0.00,\"id\":637,\"image\":\"image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg\",\"otPrice\":12000.00,\"price\":10,\"productId\":2,\"quota\":19,\"quotaShow\":19,\"sales\":1,\"stock\":19,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1608600248,1),
	(70,4,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"cost\":0.00,\"id\":644,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"otPrice\":1000.00,\"price\":100,\"productId\":4,\"quota\":999,\"quotaShow\":999,\"sales\":0,\"stock\":999,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1608600983,1),
	(72,6,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":646,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":647,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":648,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":649,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":650,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":651,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":652,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":653,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":654,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":655,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":656,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":657,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":658,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":659,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":660,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":661,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":662,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":663,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":664,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":665,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":666,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":667,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":668,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":669,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":670,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":671,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":672,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":673,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":674,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":675,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":676,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":677,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":16,\"quotaShow\":16,\"sales\":2,\"stock\":16,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":678,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":679,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":680,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":681,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":682,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":683,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":684,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":685,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":686,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":687,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":688,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":689,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":690,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":691,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":692,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":693,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":694,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":695,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":696,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":697,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":698,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":699,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":700,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":701,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":702,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":703,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":704,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":705,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":706,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":707,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":17,\"quotaShow\":17,\"sales\":1,\"stock\":17,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":708,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":100,\"productId\":6,\"quota\":18,\"quotaShow\":18,\"sales\":0,\"stock\":18,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00},{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":200.00,\"id\":709,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"otPrice\":200.00,\"price\":99.9,\"productId\":6,\"quota\":16,\"quotaShow\":16,\"sales\":2,\"stock\":16,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1608602024,3),
	(74,16,'[{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"黑色53\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"粉红58\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"燕麦54\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"黑色53\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"粉红58\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"燕麦54\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"黑色53\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"粉红58\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"燕麦54\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"黑色53\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"粉红58\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"燕麦54\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"黑色53\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"粉红58\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"燕麦54\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"黑色53\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"粉红58\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"price\":159,\"productId\":16,\"stock\":100},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"燕麦54\"},\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"price\":159,\"productId\":16,\"stock\":100}]',1608602992,0),
	(81,5,'[{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":5000.00,\"id\":349,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000,\"productId\":5,\"quota\":993,\"stock\":993,\"suk\":\"海蓝色,128GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":5000.00,\"id\":350,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000,\"productId\":5,\"quota\":999,\"stock\":999,\"suk\":\"海蓝色,128GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":5000.00,\"id\":351,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000,\"productId\":5,\"quota\":998,\"stock\":998,\"suk\":\"海蓝色,128GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00}]',1608604678,3),
	(86,14,'[{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"cost\":200,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"otPrice\":10000,\"price\":1000,\"productId\":14,\"stock\":999,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"cost\":200,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"otPrice\":10000,\"price\":1000,\"productId\":14,\"stock\":999,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"联通\"},\"cost\":200,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"otPrice\":10000,\"price\":1000,\"productId\":14,\"stock\":999,\"volume\":0,\"weight\":0}]',1608607878,0),
	(87,5,'[{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"联通\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":924,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"otPrice\":10000.00,\"price\":1000,\"productId\":5,\"quota\":999,\"stock\":999,\"suk\":\"128GB,1T,联通\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":922,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"otPrice\":10000.00,\"price\":1000,\"productId\":5,\"quota\":999,\"stock\":999,\"suk\":\"16GB,100,全网通\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":923,\"image\":\"image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg\",\"otPrice\":10000.00,\"price\":1000,\"productId\":5,\"quota\":999,\"stock\":999,\"suk\":\"32GB,100,全网通\",\"volume\":0.00,\"weight\":0.00}]',1608607946,1),
	(89,21,'[{\"attrValue\":{\"颜色\":\"星辰炒锅30cm\"},\"barCode\":\"99\",\"brokerage\":0,\"cost\":99,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"price\":99,\"productId\":21,\"stock\":99,\"volume\":99,\"weight\":99},{\"attrValue\":{\"颜色\":\"星辰炒锅32CM\"},\"barCode\":\"99\",\"brokerage\":0,\"cost\":99,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"price\":99,\"productId\":21,\"stock\":99,\"volume\":99,\"weight\":99}]',1608631625,0),
	(93,23,'[{\"attrValue\":{\"颜色\":\"3D浮雕-粉色独角兽\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1},{\"attrValue\":{\"颜色\":\"3D浮雕-蓝色鲸鱼\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1},{\"attrValue\":{\"颜色\":\"3D浮雕-红色恐龙\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1},{\"attrValue\":{\"颜色\":\"3D浮雕-狮子王\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1},{\"attrValue\":{\"颜色\":\"3D浮雕-棕色麋鹿\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1},{\"attrValue\":{\"颜色\":\"3D浮雕-红色熊猫\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1},{\"attrValue\":{\"颜色\":\"3D圣诞-大脸鹿\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1},{\"attrValue\":{\"颜色\":\"3D圣诞-星球鹿\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1},{\"attrValue\":{\"颜色\":\"3D圣诞-守护鹿\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1},{\"attrValue\":{\"颜色\":\"3D圣诞-抱抱熊\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1},{\"attrValue\":{\"颜色\":\"3D圣诞-幸运鹿\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1},{\"attrValue\":{\"颜色\":\"3D浮雕-小飞象\"},\"barCode\":\"123\",\"brokerage\":0,\"cost\":100,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228,\"price\":228,\"productId\":23,\"stock\":9999,\"volume\":1,\"weight\":1}]',1608689208,0),
	(99,20,'[{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1365,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":0.01,\"productId\":20,\"stock\":8,\"suk\":\"测试,1,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1366,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1367,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1368,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1369,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1370,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1371,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1372,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1373,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1374,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1375,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1376,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1377,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1378,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1379,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1380,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,1,s\'d,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1381,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1382,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1383,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1384,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1385,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1386,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1387,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1388,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1389,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1390,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1391,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1392,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1393,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1394,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1395,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1396,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,2,s\'d,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1397,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1398,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1399,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1400,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1401,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1402,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1403,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1404,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1405,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1406,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1407,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1408,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1409,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1410,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1411,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1412,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,3,s\'d,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1413,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1414,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1415,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1416,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1417,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1418,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1419,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1420,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1421,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1422,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1423,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1424,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1425,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1426,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1427,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1428,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试,4,s\'d,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1429,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1430,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1431,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1432,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1433,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1434,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1435,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1436,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1437,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1438,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1439,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1440,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1441,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1442,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1443,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1444,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,1,s\'d,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1445,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1446,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1447,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1448,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1449,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1450,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1451,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1452,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1453,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1454,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1455,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1456,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1457,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1458,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1459,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1460,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,2,s\'d,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1461,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1462,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1463,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1464,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1465,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1466,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1467,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1468,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1469,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1470,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1471,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1472,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1473,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1474,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1475,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1476,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,3,s\'d,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1477,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1478,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1479,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1480,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1481,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1482,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1483,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1484,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1485,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1486,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1487,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1488,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1489,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1490,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1491,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1492,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试1,4,s\'d,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1493,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1494,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1495,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1496,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1497,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1498,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1499,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1500,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1501,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1502,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1503,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1504,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1505,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1506,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1507,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1508,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,1,s\'d,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1509,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1510,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1511,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1512,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1513,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1514,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1515,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1516,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1517,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1518,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1519,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1520,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1521,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1522,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1523,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1524,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,2,s\'d,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1525,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1526,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1527,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1528,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1529,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1530,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1531,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1532,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1533,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1534,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1535,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1536,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1537,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1538,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1539,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1540,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,3,s\'d,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1541,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,12,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1542,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,12,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1543,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,12,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1544,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,12,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1545,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,a\'s,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1546,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,a\'s,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1547,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,a\'s,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1548,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,a\'s,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1549,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,d\'f,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1550,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,d\'f,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1551,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,d\'f,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1552,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,d\'f,是\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"df \"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1553,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,s\'d,df \",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"再次\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1554,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,s\'d,再次\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1555,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,s\'d,撒旦\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"是\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":10.00,\"id\":1556,\"image\":\"image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg\",\"otPrice\":30.00,\"price\":20.00,\"productId\":20,\"stock\":10,\"suk\":\"测试2,4,s\'d,是\",\"volume\":0.00,\"weight\":0.00}]',1608771260,0),
	(100,3,'[{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":5000.00,\"id\":349,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":1,\"productId\":3,\"quota\":993,\"stock\":993,\"suk\":\"海蓝色,128GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":5000.00,\"id\":350,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":1,\"productId\":3,\"quota\":999,\"stock\":999,\"suk\":\"海蓝色,128GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":5000.00,\"id\":356,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":1,\"productId\":3,\"quota\":999,\"stock\":999,\"suk\":\"海蓝色,512GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":5000.00,\"id\":357,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":1,\"productId\":3,\"quota\":999,\"stock\":999,\"suk\":\"海蓝色,512GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00}]',1608780402,1),
	(101,8,'[{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"牛仔蓝66\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1347,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"otPrice\":299.00,\"price\":218,\"productId\":8,\"quota\":100,\"stock\":100,\"suk\":\"170/88A/M,牛仔蓝66\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"牛仔蓝66\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1348,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"otPrice\":299.00,\"price\":218,\"productId\":8,\"quota\":94,\"stock\":94,\"suk\":\"175/92A/L,牛仔蓝66\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"牛仔蓝66\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1349,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"otPrice\":299.00,\"price\":218,\"productId\":8,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,牛仔蓝66\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"牛仔蓝66\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1350,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"otPrice\":299.00,\"price\":218,\"productId\":8,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,牛仔蓝66\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"牛仔蓝66\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1351,\"image\":\"image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png\",\"otPrice\":299.00,\"price\":218,\"productId\":8,\"quota\":100,\"stock\":100,\"suk\":\"190/104A/XXXL,牛仔蓝66\",\"volume\":0.00,\"weight\":0.00}]',1608794411,1),
	(112,10,'[{\"attrValue\":{\"num\":\"01\",\"测试21\":\"白色\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":0.00,\"id\":1847,\"image\":\"\",\"otPrice\":0.00,\"price\":0.3,\"productId\":10,\"quota\":1,\"stock\":0,\"suk\":\"01,白色\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"num\":\"01\",\"测试21\":\"黑色\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":0.00,\"id\":1848,\"image\":\"\",\"otPrice\":0.00,\"price\":0.3,\"productId\":10,\"quota\":1,\"stock\":0,\"suk\":\"01,黑色\",\"volume\":0.00,\"weight\":0.00}]',1609055795,1),
	(113,9,'[{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":349,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":993,\"suk\":\"海蓝色,128GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":350,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"海蓝色,128GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":351,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":998,\"suk\":\"海蓝色,128GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":352,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"海蓝色,256GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":353,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"海蓝色,256GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":354,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"海蓝色,256GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":355,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"海蓝色,512GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":356,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"海蓝色,512GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":357,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"海蓝色,512GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":358,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"石墨色,128GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":359,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"石墨色,128GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":360,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"石墨色,128GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":361,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"石墨色,256GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":362,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"石墨色,256GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":363,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"石墨色,256GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":364,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"石墨色,512GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":365,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"石墨色,512GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":366,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"石墨色,512GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":367,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"金色,128GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":368,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"金色,128GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":369,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"金色,128GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":370,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"金色,256GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":371,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"金色,256GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":372,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"金色,256GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":373,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":990,\"suk\":\"金色,512GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":374,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"金色,512GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":375,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"金色,512GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":376,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"银色,128GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":377,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"银色,128GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":378,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":998,\"suk\":\"银色,128GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":379,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"银色,256GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":380,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"银色,256GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":381,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"银色,256GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":382,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"银色,512GB,值享焕新版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":383,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"银色,512GB,公开版\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":5000.00,\"id\":384,\"image\":\"image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png\",\"otPrice\":0.00,\"price\":10000.00,\"productId\":9,\"stock\":999,\"suk\":\"银色,512GB,换修无忧年付版\",\"volume\":0.00,\"weight\":0.00}]',1609117933,0),
	(114,10,'[{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1316,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"minPrice\":0,\"otPrice\":199.00,\"price\":159,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,燕麦54\",\"volume\":0.00,\"weight\":0.00}]',1609125522,2),
	(115,9,'[{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1316,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1317,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1318,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1319,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":83,\"stock\":83,\"suk\":\"170/88A/M,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1320,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":97,\"stock\":97,\"suk\":\"170/88A/M,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1321,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"170/88A/M,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1322,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"175/92A/L,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1323,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"175/92A/L,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1324,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"175/92A/L,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1325,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1326,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1327,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1328,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1329,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1330,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1331,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"190/104A/XXXL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1332,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"190/104A/XXXL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1333,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"190/104A/XXXL,黑色53\",\"volume\":0.00,\"weight\":0.00}]',1609138805,3),
	(116,12,'[{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1352,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1353,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,黑色26\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1354,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":100,\"stock\":100,\"suk\":\"170/88A/M,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1355,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":100,\"stock\":100,\"suk\":\"170/88A/M,黑色26\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1356,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":100,\"stock\":100,\"suk\":\"175/92A/L,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1357,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":100,\"stock\":100,\"suk\":\"175/92A/L,黑色26\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1358,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1359,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,黑色26\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1360,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1361,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,黑色26\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1362,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":98,\"stock\":98,\"suk\":\"190/104A/XXXL,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":200.00,\"id\":1363,\"image\":\"\",\"otPrice\":0.00,\"price\":428,\"productId\":12,\"quota\":100,\"stock\":100,\"suk\":\"190/104A/XXXL,黑色26\",\"volume\":0.00,\"weight\":0.00}]',1609220166,1),
	(118,15,'[{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1316,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"165/84A/S,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1317,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"165/84A/S,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1318,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"165/84A/S,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1319,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":83,\"suk\":\"170/88A/M,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1320,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":97,\"suk\":\"170/88A/M,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1321,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"170/88A/M,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1322,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"175/92A/L,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1323,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"175/92A/L,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1324,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"175/92A/L,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1325,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"180/96A/XL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1326,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"180/96A/XL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1327,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"180/96A/XL,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1328,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"185/100A/XXL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1329,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"185/100A/XXL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1330,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"185/100A/XXL,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1331,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"190/104A/XXXL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1332,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"190/104A/XXXL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":100.00,\"id\":1333,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159.00,\"productId\":15,\"stock\":100,\"suk\":\"190/104A/XXXL,黑色53\",\"volume\":0.00,\"weight\":0.00}]',1609228543,0),
	(119,13,'[{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1922,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1923,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1924,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1925,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":83,\"stock\":83,\"suk\":\"170/88A/M,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1926,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":97,\"stock\":97,\"suk\":\"170/88A/M,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1927,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"170/88A/M,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1928,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"175/92A/L,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1929,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"175/92A/L,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1930,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"175/92A/L,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1931,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1932,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1933,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1934,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1935,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1936,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1937,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"190/104A/XXXL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1938,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"190/104A/XXXL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1939,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":13,\"quota\":100,\"stock\":100,\"suk\":\"190/104A/XXXL,黑色53\",\"volume\":0.00,\"weight\":0.00}]',1609230960,1),
	(120,11,'[{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1922,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,燕麦54\",\"volume\":0.00,\"weight\":0.00}]',1609247005,2),
	(121,10,'[{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1922,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1923,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1924,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"165/84A/S,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1925,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":83,\"stock\":83,\"suk\":\"170/88A/M,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1926,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":97,\"stock\":97,\"suk\":\"170/88A/M,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1927,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"170/88A/M,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1928,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"175/92A/L,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1929,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"175/92A/L,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1930,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"175/92A/L,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1931,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1932,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1933,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"180/96A/XL,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1934,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1935,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1936,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"185/100A/XXL,黑色53\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"燕麦54\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1937,\"image\":\"image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"190/104A/XXXL,燕麦54\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"粉红58\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1938,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"190/104A/XXXL,粉红58\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"黑色53\"},\"barCode\":\"\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1939,\"image\":\"image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png\",\"otPrice\":199.00,\"price\":159,\"productId\":10,\"quota\":100,\"stock\":100,\"suk\":\"190/104A/XXXL,黑色53\",\"volume\":0.00,\"weight\":0.00}]',1609247066,3),
	(123,19,'[{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1352,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":100,\"suk\":\"165/84A/S,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"165/84A/S\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1353,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":100,\"suk\":\"165/84A/S,黑色26\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1354,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":100,\"suk\":\"170/88A/M,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A/M\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1355,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":100,\"suk\":\"170/88A/M,黑色26\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1356,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":100,\"suk\":\"175/92A/L,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A/L\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1357,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":100,\"suk\":\"175/92A/L,黑色26\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1358,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":100,\"suk\":\"180/96A/XL,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/96A/XL\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1359,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":100,\"suk\":\"180/96A/XL,黑色26\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1360,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":100,\"suk\":\"185/100A/XXL,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"185/100A/XXL\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1361,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":100,\"suk\":\"185/100A/XXL,黑色26\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"蓝灰25\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1362,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":98,\"suk\":\"190/104A/XXXL,蓝灰25\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"黑色26\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":200.00,\"id\":1363,\"image\":\"\",\"otPrice\":0.00,\"price\":428.00,\"productId\":19,\"stock\":100,\"suk\":\"190/104A/XXXL,黑色26\",\"volume\":0.00,\"weight\":0.00}]',1609313970,0),
	(125,18,'[{\"attrValue\":{\"尺码\":\"165/84A\",\"颜色\":\"浅绿03\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":908,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"165/84A,浅绿03\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"165/84A\",\"颜色\":\"浅蓝05\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":909,\"image\":\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"165/84A,浅蓝05\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A\",\"颜色\":\"浅绿03\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":910,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"170/88A,浅绿03\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"170/88A\",\"颜色\":\"浅蓝05\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":911,\"image\":\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"170/88A,浅蓝05\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A\",\"颜色\":\"浅绿03\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":912,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"175/92A,浅绿03\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/92A\",\"颜色\":\"浅蓝05\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":913,\"image\":\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"175/92A,浅蓝05\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/96A\",\"颜色\":\"浅绿03\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":914,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"175/96A,浅绿03\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"175/96A\",\"颜色\":\"浅蓝05\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":915,\"image\":\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"175/96A,浅蓝05\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/100A\",\"颜色\":\"浅绿03\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":916,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"180/100A,浅绿03\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/100A\",\"颜色\":\"浅蓝05\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":917,\"image\":\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"180/100A,浅蓝05\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/104A\",\"颜色\":\"浅绿03\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":918,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"180/104A,浅绿03\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/104A\",\"颜色\":\"浅蓝05\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":919,\"image\":\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"180/104A,浅蓝05\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/108A\",\"颜色\":\"浅绿03\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":920,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"180/108A,浅绿03\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"尺码\":\"180/108A\",\"颜色\":\"浅蓝05\"},\"barCode\":\"\",\"brokerage\":0.00,\"cost\":50.00,\"id\":921,\"image\":\"image/store/2020/12/22/2e3f392d46d44b9a9203631106ec077f6kfezlfq3y.png\",\"otPrice\":0.00,\"price\":98.00,\"productId\":18,\"stock\":100,\"suk\":\"180/108A,浅蓝05\",\"volume\":0.00,\"weight\":0.00}]',1609324188,0),
	(127,1,'[{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":385,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"128GB,100,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":386,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"128GB,100,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":387,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"128GB,100,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":388,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"128GB,100,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":389,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"128GB,1T,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":390,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"128GB,1T,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":391,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"128GB,1T,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":392,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"128GB,1T,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":393,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":0,\"suk\":\"128GB,800,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":394,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"128GB,800,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":395,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"128GB,800,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":396,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"128GB,800,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":397,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":7,\"suk\":\"16GB,100,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":398,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"16GB,100,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":399,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"16GB,100,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":400,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"16GB,100,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":401,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"16GB,1T,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":402,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"16GB,1T,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":403,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"16GB,1T,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":404,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"16GB,1T,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":405,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"16GB,800,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":406,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"16GB,800,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":407,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"16GB,800,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":408,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"16GB,800,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":409,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":8,\"suk\":\"32GB,100,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":410,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"32GB,100,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":411,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"32GB,100,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":412,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"32GB,100,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":413,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"32GB,1T,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":414,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"32GB,1T,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":415,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"32GB,1T,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":416,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"32GB,1T,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":417,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"32GB,800,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":418,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"32GB,800,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":419,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"32GB,800,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":420,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"32GB,800,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":421,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":7,\"suk\":\"8GB,100,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":422,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"8GB,100,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":423,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"8GB,100,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":424,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"8GB,100,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":425,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"8GB,1T,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":426,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"8GB,1T,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":427,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"8GB,1T,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":428,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"8GB,1T,联通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"全网通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":429,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":8,\"suk\":\"8GB,800,全网通\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"电信\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":430,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"8GB,800,电信\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"移动\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":431,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"8GB,800,移动\",\"volume\":9.00,\"weight\":9.00},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"联通\"},\"barCode\":\"9\",\"brokerage\":0.00,\"cost\":9.00,\"id\":432,\"image\":\"image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png\",\"otPrice\":9.00,\"price\":99.00,\"productId\":1,\"stock\":9,\"suk\":\"8GB,800,联通\",\"volume\":9.00,\"weight\":9.00}]',1609351045,0),
	(130,17,'[{\"attrValue\":{\"1\":\"1\",\"测试\":\"value\"},\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":17,\"stock\":100,\"volume\":0,\"weight\":0},{\"attrValue\":{\"1\":\"1\",\"测试\":\"44\"},\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":17,\"stock\":100,\"volume\":0,\"weight\":0},{\"attrValue\":{\"1\":\"22\",\"测试\":\"value\"},\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":17,\"stock\":100,\"volume\":0,\"weight\":0},{\"attrValue\":{\"1\":\"22\",\"测试\":\"44\"},\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":17,\"stock\":100,\"volume\":0,\"weight\":0}]',1609529223,0),
	(131,9,'[{\"attrValue\":{\"1\":\"1\",\"测试\":\"44\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":0.00,\"id\":2060,\"image\":\"\",\"otPrice\":0.00,\"price\":0.1,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"1,44\",\"volume\":0.00,\"weight\":0.00},{\"attrValue\":{\"1\":\"1\",\"测试\":\"value\"},\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":0.00,\"id\":2059,\"image\":\"\",\"otPrice\":0.00,\"price\":0.1,\"productId\":9,\"quota\":100,\"stock\":100,\"suk\":\"1,value\",\"volume\":0.00,\"weight\":0.00}]',1609741549,1),
	(132,11,'[{\"attrValue\":{\"颜色\":\"3D圣诞-大脸鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1340,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D圣诞-大脸鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-守护鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1342,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D圣诞-守护鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-幸运鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1344,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D圣诞-幸运鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-抱抱熊\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1343,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D圣诞-抱抱熊\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-星球鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1341,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D圣诞-星球鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-小飞象\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1345,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D浮雕-小飞象\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-棕色麋鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1338,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D浮雕-棕色麋鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-狮子王\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1337,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D浮雕-狮子王\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-粉色独角兽\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1334,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D浮雕-粉色独角兽\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-红色恐龙\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1336,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D浮雕-红色恐龙\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-红色熊猫\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1339,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D浮雕-红色熊猫\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-蓝色鲸鱼\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1335,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":11,\"quota\":1111,\"stock\":9999,\"suk\":\"3D浮雕-蓝色鲸鱼\",\"volume\":1.00,\"weight\":1.00}]',1609897932,3),
	(133,12,'[{\"attrValue\":{\"颜色\":\"3D圣诞-大脸鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1340,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D圣诞-大脸鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-守护鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1342,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D圣诞-守护鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-幸运鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1344,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D圣诞-幸运鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-抱抱熊\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1343,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D圣诞-抱抱熊\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-星球鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1341,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D圣诞-星球鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-小飞象\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1345,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-小飞象\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-棕色麋鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1338,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-棕色麋鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-狮子王\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1337,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-狮子王\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-粉色独角兽\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1334,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-粉色独角兽\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-红色恐龙\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1336,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-红色恐龙\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-红色熊猫\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1339,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-红色熊猫\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-蓝色鲸鱼\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1335,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":12,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-蓝色鲸鱼\",\"volume\":1.00,\"weight\":1.00}]',1609898761,3),
	(134,22,'[{\"attrValue\":{\"颜色\":\"星辰炒锅30cm\"},\"barCode\":\"99\",\"brokerage\":0.00,\"cost\":99.00,\"id\":1122,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"otPrice\":0.00,\"price\":99.00,\"productId\":22,\"stock\":99,\"suk\":\"星辰炒锅30cm\",\"volume\":99.00,\"weight\":99.00},{\"attrValue\":{\"颜色\":\"星辰炒锅32CM\"},\"barCode\":\"99\",\"brokerage\":0.00,\"cost\":99.00,\"id\":1123,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"otPrice\":0.00,\"price\":99.00,\"productId\":22,\"stock\":99,\"suk\":\"星辰炒锅32CM\",\"volume\":99.00,\"weight\":99.00}]',1609898806,0),
	(135,13,'[{\"attrValue\":{\"颜色\":\"3D圣诞-大脸鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1340,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D圣诞-大脸鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-守护鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1342,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D圣诞-守护鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-幸运鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1344,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D圣诞-幸运鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-抱抱熊\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1343,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D圣诞-抱抱熊\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D圣诞-星球鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1341,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D圣诞-星球鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-小飞象\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1345,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-小飞象\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-棕色麋鹿\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1338,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-棕色麋鹿\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-狮子王\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1337,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-狮子王\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-粉色独角兽\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1334,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-粉色独角兽\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-红色恐龙\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1336,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-红色恐龙\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-红色熊猫\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1339,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-红色熊猫\",\"volume\":1.00,\"weight\":1.00},{\"attrValue\":{\"颜色\":\"3D浮雕-蓝色鲸鱼\"},\"barCode\":\"123\",\"brokerage\":0.00,\"checked\":true,\"cost\":100.00,\"id\":1335,\"image\":\"image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png\",\"otPrice\":228.00,\"price\":228,\"productId\":13,\"quota\":9999,\"stock\":9999,\"suk\":\"3D浮雕-蓝色鲸鱼\",\"volume\":1.00,\"weight\":1.00}]',1609898928,3),
	(136,12,'[{\"attrValue\":{\"颜色\":\"星辰炒锅30cm\"},\"barCode\":\"99\",\"brokerage\":0.00,\"checked\":true,\"cost\":99.00,\"id\":2095,\"image\":\"image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png\",\"otPrice\":0.00,\"price\":99,\"quota\":99,\"stock\":99,\"suk\":\"星辰炒锅30cm\",\"volume\":99.00,\"weight\":99.00}]',1609939162,2),
	(140,2,'[{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"全网通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"移动\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"联通\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0},{\"attrValue\":{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"电信\",\"test\":\"2\"},\"barCode\":\"\",\"brokerage\":0,\"cost\":0,\"image\":\"\",\"otPrice\":0,\"price\":0,\"productId\":2,\"stock\":0,\"volume\":0,\"weight\":0}]',1610000234,0);

INSERT INTO `eb_store_product_attr_result` (`id`, `product_id`, `result`, `change_time`, `type`)
VALUES
	(141,13,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"cost\":50.00,\"id\":1852,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"minPrice\":0,\"otPrice\":200.00,\"price\":100,\"productId\":7,\"quota\":11,\"sales\":11,\"stock\":11,\"suk\":\"默认\",\"type\":false,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1610000290,2),
	(142,14,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"cost\":50.00,\"id\":1852,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"minPrice\":0,\"otPrice\":200.00,\"price\":100,\"productId\":7,\"quota\":11,\"sales\":11,\"stock\":11,\"suk\":\"默认\",\"type\":false,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1610001205,2),
	(143,15,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"cost\":50.00,\"id\":1852,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"minPrice\":0,\"otPrice\":200.00,\"price\":100,\"productId\":7,\"quota\":11,\"sales\":11,\"stock\":11,\"suk\":\"默认\",\"type\":false,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1610001255,2),
	(144,16,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"cost\":50.00,\"id\":1852,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"minPrice\":0,\"otPrice\":200.00,\"price\":100,\"productId\":7,\"quota\":11,\"sales\":11,\"stock\":11,\"suk\":\"默认\",\"type\":false,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1610001373,2),
	(145,17,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"cost\":50.00,\"id\":1852,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"minPrice\":0,\"otPrice\":200.00,\"price\":100,\"productId\":7,\"quota\":11,\"sales\":11,\"stock\":11,\"suk\":\"默认\",\"type\":false,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1610001425,2),
	(146,9,'[{\"barCode\":\"\",\"brokerage\":0.00,\"brokerageTwo\":0.00,\"checked\":true,\"cost\":50.00,\"id\":2163,\"image\":\"image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg\",\"minPrice\":10,\"otPrice\":200.00,\"price\":100000,\"productId\":9,\"quota\":97,\"sales\":3,\"stock\":9996,\"suk\":\"默认\",\"type\":true,\"unique\":\"\",\"volume\":0.00,\"weight\":0.00}]',1610001530,2);

/*!40000 ALTER TABLE `eb_store_product_attr_result` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table eb_store_product_attr_value
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_store_product_attr_value`;

CREATE TABLE `eb_store_product_attr_value` (
  `id` mediumint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `product_id` int(10) unsigned NOT NULL COMMENT '商品ID',
  `suk` varchar(128) NOT NULL COMMENT '商品属性索引值 (attr_value|attr_value[|....])',
  `stock` int(10) unsigned NOT NULL COMMENT '属性对应的库存',
  `sales` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '销量',
  `price` decimal(8,2) unsigned NOT NULL COMMENT '属性金额',
  `image` varchar(1000) DEFAULT NULL COMMENT '图片',
  `unique` char(8) NOT NULL DEFAULT '' COMMENT '唯一值',
  `cost` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '成本价',
  `bar_code` varchar(50) NOT NULL DEFAULT '' COMMENT '商品条码',
  `ot_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '原价',
  `weight` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `volume` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '体积',
  `brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '一级返佣',
  `brokerage_two` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '二级返佣',
  `type` tinyint(1) DEFAULT '0' COMMENT '活动类型 0=商品，1=秒杀，2=砍价，3=拼团',
  `quota` int(11) DEFAULT NULL COMMENT '活动限购数量',
  `quota_show` int(11) DEFAULT NULL COMMENT '活动限购数量显示',
  `attr_value` text COMMENT 'attr_values 创建更新时的属性对应',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `unique` (`unique`,`suk`) USING BTREE,
  KEY `store_id` (`product_id`,`suk`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品属性值表';

LOCK TABLES `eb_store_product_attr_value` WRITE;
/*!40000 ALTER TABLE `eb_store_product_attr_value` DISABLE KEYS */;

INSERT INTO `eb_store_product_attr_value` (`id`, `product_id`, `suk`, `stock`, `sales`, `price`, `image`, `unique`, `cost`, `bar_code`, `ot_price`, `weight`, `volume`, `brokerage`, `brokerage_two`, `type`, `quota`, `quota_show`, `attr_value`)
VALUES
	(49,1,'8GB,100,全网通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"全网通\"}'),
	(50,1,'8GB,100,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"移动\"}'),
	(51,1,'8GB,100,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"联通\"}'),
	(52,1,'8GB,100,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"8GB\",\"ROM\":\"100\",\"网络\":\"电信\"}'),
	(53,1,'8GB,800,全网通',8,1,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,8,9,'{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"全网通\"}'),
	(54,1,'8GB,800,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"移动\"}'),
	(55,1,'8GB,800,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"联通\"}'),
	(56,1,'8GB,800,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"8GB\",\"ROM\":\"800\",\"网络\":\"电信\"}'),
	(57,1,'8GB,1T,全网通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"}'),
	(58,1,'8GB,1T,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"移动\"}'),
	(59,1,'8GB,1T,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"联通\"}'),
	(60,1,'8GB,1T,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"8GB\",\"ROM\":\"1T\",\"网络\":\"电信\"}'),
	(61,1,'16GB,100,全网通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"全网通\"}'),
	(62,1,'16GB,100,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"移动\"}'),
	(63,1,'16GB,100,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"联通\"}'),
	(64,1,'16GB,100,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"电信\"}'),
	(65,1,'16GB,800,全网通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"全网通\"}'),
	(66,1,'16GB,800,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"移动\"}'),
	(67,1,'16GB,800,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"联通\"}'),
	(68,1,'16GB,800,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"800\",\"网络\":\"电信\"}'),
	(69,1,'16GB,1T,全网通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"}'),
	(70,1,'16GB,1T,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"移动\"}'),
	(71,1,'16GB,1T,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"联通\"}'),
	(72,1,'16GB,1T,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"16GB\",\"ROM\":\"1T\",\"网络\":\"电信\"}'),
	(73,1,'32GB,100,全网通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"全网通\"}'),
	(74,1,'32GB,100,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"移动\"}'),
	(75,1,'32GB,100,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"联通\"}'),
	(76,1,'32GB,100,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"电信\"}'),
	(77,1,'32GB,800,全网通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"全网通\"}'),
	(78,1,'32GB,800,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"移动\"}'),
	(79,1,'32GB,800,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"联通\"}'),
	(80,1,'32GB,800,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"800\",\"网络\":\"电信\"}'),
	(81,1,'32GB,1T,全网通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"}'),
	(82,1,'32GB,1T,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"移动\"}'),
	(83,1,'32GB,1T,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"联通\"}'),
	(84,1,'32GB,1T,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"32GB\",\"ROM\":\"1T\",\"网络\":\"电信\"}'),
	(85,1,'128GB,100,全网通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"全网通\"}'),
	(86,1,'128GB,100,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"移动\"}'),
	(87,1,'128GB,100,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"联通\"}'),
	(88,1,'128GB,100,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"电信\"}'),
	(89,1,'128GB,800,全网通',7,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,7,7,'{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"全网通\"}'),
	(90,1,'128GB,800,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"移动\"}'),
	(91,1,'128GB,800,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"联通\"}'),
	(92,1,'128GB,800,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"800\",\"网络\":\"电信\"}'),
	(93,1,'128GB,1T,全网通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"全网通\"}'),
	(94,1,'128GB,1T,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"移动\"}'),
	(95,1,'128GB,1T,联通',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"联通\"}'),
	(96,1,'128GB,1T,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"电信\"}'),
	(152,4,'默认',20,0,9999.00,'image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','',0.00,'',12000.00,0.00,0.00,0.00,0.00,2,20,NULL,NULL),
	(153,3,'8GB,100,全网通',9,0,99.00,'image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','',9.00,'9',9.00,9.00,9.00,0.00,0.00,2,9,NULL,NULL),
	(154,2,'默认',20,0,9999.00,'image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','',0.00,'',12000.00,0.00,0.00,0.00,0.00,2,20,NULL,NULL),
	(156,2,'默认',20,0,1.00,'image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','',12000.00,'',12000.00,0.00,0.00,0.00,0.00,3,20,20,NULL),
	(205,5,'8GB,100,全网通',9,0,1.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,2,9,NULL,NULL),
	(211,3,'默认',994,6,0.01,'image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','',0.00,'',1.00,0.00,0.00,0.00,0.00,0,NULL,NULL,NULL),
	(212,4,'默认',998,1,100.00,'image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg','',50.00,'',150.00,0.00,0.00,0.00,0.00,0,NULL,NULL,NULL),
	(215,1,'8GB,100,全网通',7,1,10.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,2,7,NULL,NULL),
	(216,6,'默认',998,1,100.00,'image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg','',50.00,'',150.00,0.00,0.00,0.00,0.00,2,998,NULL,NULL),
	(217,7,'默认',998,1,100.00,'image/content/2020/12/15/7e7b4599f6074a72a79dc27950b504e84z1qjcadfx.jpg','',50.00,'',150.00,0.00,0.00,0.00,0.00,2,998,NULL,NULL),
	(230,8,'默认',995,4,100.00,'image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png','',50.00,'',150.00,0.00,0.00,0.00,0.00,2,995,NULL,NULL),
	(231,3,'默认',19,0,9999.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',12000.00,'',12000.00,0.00,0.00,0.00,0.00,3,19,19,NULL),
	(232,8,'海蓝色,128GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"}'),
	(233,8,'海蓝色,128GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"}'),
	(234,8,'海蓝色,128GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(235,8,'海蓝色,256GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"}'),
	(236,8,'海蓝色,256GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"}'),
	(237,8,'海蓝色,256GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(238,8,'海蓝色,512GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"}'),
	(239,8,'海蓝色,512GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"}'),
	(240,8,'海蓝色,512GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(241,8,'金色,128GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"}'),
	(242,8,'金色,128GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"}'),
	(243,8,'金色,128GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(244,8,'金色,256GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"}'),
	(245,8,'金色,256GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"}'),
	(246,8,'金色,256GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(247,8,'金色,512GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"}'),
	(248,8,'金色,512GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"}'),
	(249,8,'金色,512GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(250,8,'石墨色,128GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"}'),
	(251,8,'石墨色,128GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"}'),
	(252,8,'石墨色,128GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(253,8,'石墨色,256GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"}'),
	(254,8,'石墨色,256GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"}'),
	(255,8,'石墨色,256GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(256,8,'石墨色,512GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"}'),
	(257,8,'石墨色,512GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"}'),
	(258,8,'石墨色,512GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(259,8,'银色,128GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"}'),
	(260,8,'银色,128GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"}'),
	(261,8,'银色,128GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(262,8,'银色,256GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"}'),
	(263,8,'银色,256GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"}'),
	(264,8,'银色,256GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(265,8,'银色,512GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"}'),
	(266,8,'银色,512GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"}'),
	(267,8,'银色,512GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(304,3,'默认',19,0,9999.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',12000.00,'',12000.00,0.00,0.00,0.00,0.00,3,19,19,NULL),
	(305,4,'海蓝色,128GB,值享焕新版',999,0,1.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,3,999,999,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"}'),
	(306,4,'海蓝色,128GB,公开版',999,0,1.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,3,999,999,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"}'),
	(307,4,'海蓝色,128GB,换修无忧年付版',999,0,1.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,3,999,999,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(309,10,'默认',93,7,0.00,'image/content/2020/12/18/317cb71eb4164130a97b3a3f2f8e518dcqfb5od83r.jpg','',10000.00,'',10000.00,0.00,0.00,0.00,0.00,0,NULL,NULL,NULL),
	(469,13,'魅蓝色【8G运行】 5％选择这款,官方标配,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(470,13,'魅蓝色【8G运行】 5％选择这款,官方标配,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(471,13,'魅蓝色【8G运行】 5％选择这款,官方标配,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(472,13,'魅蓝色【8G运行】 5％选择这款,套餐一,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(473,13,'魅蓝色【8G运行】 5％选择这款,套餐一,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(474,13,'魅蓝色【8G运行】 5％选择这款,套餐一,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(475,13,'魅蓝色【8G运行】 5％选择这款,套餐二,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(476,13,'魅蓝色【8G运行】 5％选择这款,套餐二,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(477,13,'魅蓝色【8G运行】 5％选择这款,套餐二,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(478,13,'魅蓝色【8G运行】 5％选择这款,套餐三,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(479,13,'魅蓝色【8G运行】 5％选择这款,套餐三,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(480,13,'魅蓝色【8G运行】 5％选择这款,套餐三,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(481,13,'暗夜黑【8G运行】 5％选择这款,官方标配,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(482,13,'暗夜黑【8G运行】 5％选择这款,官方标配,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(483,13,'暗夜黑【8G运行】 5％选择这款,官方标配,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(484,13,'暗夜黑【8G运行】 5％选择这款,套餐一,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(485,13,'暗夜黑【8G运行】 5％选择这款,套餐一,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(486,13,'暗夜黑【8G运行】 5％选择这款,套餐一,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(487,13,'暗夜黑【8G运行】 5％选择这款,套餐二,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(488,13,'暗夜黑【8G运行】 5％选择这款,套餐二,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(489,13,'暗夜黑【8G运行】 5％选择这款,套餐二,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(490,13,'暗夜黑【8G运行】 5％选择这款,套餐三,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(491,13,'暗夜黑【8G运行】 5％选择这款,套餐三,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(492,13,'暗夜黑【8G运行】 5％选择这款,套餐三,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(493,13,'星云紫【8G运行】 5％选择这款,官方标配,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(494,13,'星云紫【8G运行】 5％选择这款,官方标配,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(495,13,'星云紫【8G运行】 5％选择这款,官方标配,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(496,13,'星云紫【8G运行】 5％选择这款,套餐一,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(497,13,'星云紫【8G运行】 5％选择这款,套餐一,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(498,13,'星云紫【8G运行】 5％选择这款,套餐一,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(499,13,'星云紫【8G运行】 5％选择这款,套餐二,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(500,13,'星云紫【8G运行】 5％选择这款,套餐二,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(501,13,'星云紫【8G运行】 5％选择这款,套餐二,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(502,13,'星云紫【8G运行】 5％选择这款,套餐三,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(503,13,'星云紫【8G运行】 5％选择这款,套餐三,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(504,13,'星云紫【8G运行】 5％选择这款,套餐三,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【8G运行】 5％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(505,13,'魅蓝色【10G运行】 10％选择这款,官方标配,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(506,13,'魅蓝色【10G运行】 10％选择这款,官方标配,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(507,13,'魅蓝色【10G运行】 10％选择这款,官方标配,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(508,13,'魅蓝色【10G运行】 10％选择这款,套餐一,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(509,13,'魅蓝色【10G运行】 10％选择这款,套餐一,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(510,13,'魅蓝色【10G运行】 10％选择这款,套餐一,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(511,13,'魅蓝色【10G运行】 10％选择这款,套餐二,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(512,13,'魅蓝色【10G运行】 10％选择这款,套餐二,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(513,13,'魅蓝色【10G运行】 10％选择这款,套餐二,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(514,13,'魅蓝色【10G运行】 10％选择这款,套餐三,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(515,13,'魅蓝色【10G运行】 10％选择这款,套餐三,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(516,13,'魅蓝色【10G运行】 10％选择这款,套餐三,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(517,13,'暗夜黑【10G运行】 10％选择这款,官方标配,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(518,13,'暗夜黑【10G运行】 10％选择这款,官方标配,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(519,13,'暗夜黑【10G运行】 10％选择这款,官方标配,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(520,13,'暗夜黑【10G运行】 10％选择这款,套餐一,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(521,13,'暗夜黑【10G运行】 10％选择这款,套餐一,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(522,13,'暗夜黑【10G运行】 10％选择这款,套餐一,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(523,13,'暗夜黑【10G运行】 10％选择这款,套餐二,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(524,13,'暗夜黑【10G运行】 10％选择这款,套餐二,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(525,13,'暗夜黑【10G运行】 10％选择这款,套餐二,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(526,13,'暗夜黑【10G运行】 10％选择这款,套餐三,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(527,13,'暗夜黑【10G运行】 10％选择这款,套餐三,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(528,13,'暗夜黑【10G运行】 10％选择这款,套餐三,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(529,13,'星云紫 【10G运行】 10％选择这款,官方标配,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(530,13,'星云紫 【10G运行】 10％选择这款,官方标配,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(531,13,'星云紫 【10G运行】 10％选择这款,官方标配,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(532,13,'星云紫 【10G运行】 10％选择这款,套餐一,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(533,13,'星云紫 【10G运行】 10％选择这款,套餐一,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(534,13,'星云紫 【10G运行】 10％选择这款,套餐一,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(535,13,'星云紫 【10G运行】 10％选择这款,套餐二,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(536,13,'星云紫 【10G运行】 10％选择这款,套餐二,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(537,13,'星云紫 【10G运行】 10％选择这款,套餐二,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(538,13,'星云紫 【10G运行】 10％选择这款,套餐三,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(539,13,'星云紫 【10G运行】 10％选择这款,套餐三,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(540,13,'星云紫 【10G运行】 10％选择这款,套餐三,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(541,13,'魅蓝色【12G运行】 85％选择这款,官方标配,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(542,13,'魅蓝色【12G运行】 85％选择这款,官方标配,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(543,13,'魅蓝色【12G运行】 85％选择这款,官方标配,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(544,13,'魅蓝色【12G运行】 85％选择这款,套餐一,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(545,13,'魅蓝色【12G运行】 85％选择这款,套餐一,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(546,13,'魅蓝色【12G运行】 85％选择这款,套餐一,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(547,13,'魅蓝色【12G运行】 85％选择这款,套餐二,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(548,13,'魅蓝色【12G运行】 85％选择这款,套餐二,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(549,13,'魅蓝色【12G运行】 85％选择这款,套餐二,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(550,13,'魅蓝色【12G运行】 85％选择这款,套餐三,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(551,13,'魅蓝色【12G运行】 85％选择这款,套餐三,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(552,13,'魅蓝色【12G运行】 85％选择这款,套餐三,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"魅蓝色【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(553,13,'暗夜黑【12G运行】 85％选择这款,官方标配,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(554,13,'暗夜黑【12G运行】 85％选择这款,官方标配,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(555,13,'暗夜黑【12G运行】 85％选择这款,官方标配,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(556,13,'暗夜黑【12G运行】 85％选择这款,套餐一,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(557,13,'暗夜黑【12G运行】 85％选择这款,套餐一,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(558,13,'暗夜黑【12G运行】 85％选择这款,套餐一,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(559,13,'暗夜黑【12G运行】 85％选择这款,套餐二,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(560,13,'暗夜黑【12G运行】 85％选择这款,套餐二,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(561,13,'暗夜黑【12G运行】 85％选择这款,套餐二,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(562,13,'暗夜黑【12G运行】 85％选择这款,套餐三,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(563,13,'暗夜黑【12G运行】 85％选择这款,套餐三,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(564,13,'暗夜黑【12G运行】 85％选择这款,套餐三,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"暗夜黑【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(565,13,'星云紫【12G运行】 85％选择这款,官方标配,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(566,13,'星云紫【12G运行】 85％选择这款,官方标配,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(567,13,'星云紫【12G运行】 85％选择这款,官方标配,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"官方标配\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(568,13,'星云紫【12G运行】 85％选择这款,套餐一,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(569,13,'星云紫【12G运行】 85％选择这款,套餐一,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(570,13,'星云紫【12G运行】 85％选择这款,套餐一,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(571,13,'星云紫【12G运行】 85％选择这款,套餐二,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(572,13,'星云紫【12G运行】 85％选择这款,套餐二,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(573,13,'星云紫【12G运行】 85％选择这款,套餐二,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐二\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(574,13,'星云紫【12G运行】 85％选择这款,套餐三,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(575,13,'星云紫【12G运行】 85％选择这款,套餐三,256GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"256GB\",\"版本类型\":\"中国大陆\"}'),
	(576,13,'星云紫【12G运行】 85％选择这款,套餐三,512GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"机身颜色\":\"星云紫【12G运行】 85％选择这款\",\"套餐类型\":\"套餐三\",\"存储容量\":\"512GB\",\"版本类型\":\"中国大陆\"}'),
	(577,7,'星云紫 【10G运行】 10％选择这款,套餐一,128GB,中国大陆',995,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',111.00,'',0.00,0.00,0.00,0.00,0.00,3,995,995,'{\"机身颜色\":\"星云紫 【10G运行】 10％选择这款\",\"套餐类型\":\"套餐一\",\"存储容量\":\"128GB\",\"版本类型\":\"中国大陆\"}'),
	(623,8,'128GB,100,全网通',9,0,10.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"全网通\"}'),
	(624,8,'128GB,100,电信',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"电信\"}'),
	(625,8,'128GB,100,移动',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,3,9,9,'{\"ram\":\"128GB\",\"ROM\":\"100\",\"网络\":\"移动\"}'),
	(626,1,'100,全网通,128GB',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,1,9,9,'{\"ROM\":\"100\",\"网络\":\"全网通\",\"ram\":\"128GB\"}'),
	(627,1,'100,电信,128GB',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,1,9,9,'{\"ROM\":\"100\",\"网络\":\"电信\",\"ram\":\"128GB\"}'),
	(628,1,'100,移动,128GB',9,0,99.00,'image/content/2020/12/07/9c2a3160cbe04f36aa3340cc8f97dc67a9ai2hbt9f.png','',9.00,'9',9.00,9.00,9.00,0.00,0.00,1,9,9,'{\"ROM\":\"100\",\"网络\":\"移动\",\"ram\":\"128GB\"}'),
	(638,2,'默认',19,1,10.00,'image/content/2020/12/09/54a1bf16b68c4bf89d1c73ad52dd9442i2rjuut93f.jpg','',0.00,'',12000.00,0.00,0.00,0.00,0.00,1,19,19,NULL),
	(645,4,'默认',997,2,100.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',0.00,'',1000.00,0.00,0.00,0.00,0.00,1,997,999,NULL),
	(710,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(711,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(712,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(713,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(714,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(715,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(716,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(717,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(718,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(719,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(720,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(721,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(722,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(723,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(724,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(725,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(726,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(727,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(728,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(729,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(730,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(731,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(732,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(733,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(734,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(735,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(736,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(737,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(738,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(739,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(740,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(741,6,'默认',16,2,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,16,16,NULL),
	(742,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(743,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(744,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(745,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(746,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(747,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(748,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(749,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(750,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(751,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(752,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(753,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(754,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(755,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(756,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(757,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(758,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(759,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(760,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(761,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(762,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(763,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(764,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(765,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(766,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(767,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(768,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(769,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(770,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(771,6,'默认',17,1,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,17,17,NULL),
	(772,6,'默认',18,0,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,18,18,NULL),
	(773,6,'默认',16,2,99.90,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',200.00,'',200.00,0.00,0.00,0.00,0.00,3,16,16,NULL),
	(792,16,'165/84A/S,黑色53',100,0,159.00,'image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"165/84A/S\",\"颜色\":\"黑色53\"}'),
	(793,16,'165/84A/S,粉红58',100,0,159.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"165/84A/S\",\"颜色\":\"粉红58\"}'),
	(794,16,'165/84A/S,燕麦54',100,0,159.00,'image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"165/84A/S\",\"颜色\":\"燕麦54\"}'),
	(795,16,'170/88A/M,黑色53',100,0,159.00,'image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"170/88A/M\",\"颜色\":\"黑色53\"}'),
	(796,16,'170/88A/M,粉红58',100,0,159.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"170/88A/M\",\"颜色\":\"粉红58\"}'),
	(797,16,'170/88A/M,燕麦54',100,0,159.00,'image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"170/88A/M\",\"颜色\":\"燕麦54\"}'),
	(798,16,'175/92A/L,黑色53',100,0,159.00,'image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"175/92A/L\",\"颜色\":\"黑色53\"}'),
	(799,16,'175/92A/L,粉红58',100,0,159.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"175/92A/L\",\"颜色\":\"粉红58\"}'),
	(800,16,'175/92A/L,燕麦54',100,0,159.00,'image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"175/92A/L\",\"颜色\":\"燕麦54\"}'),
	(801,16,'180/96A/XL,黑色53',100,0,159.00,'image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"180/96A/XL\",\"颜色\":\"黑色53\"}'),
	(802,16,'180/96A/XL,粉红58',100,0,159.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"180/96A/XL\",\"颜色\":\"粉红58\"}'),
	(803,16,'180/96A/XL,燕麦54',100,0,159.00,'image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"180/96A/XL\",\"颜色\":\"燕麦54\"}'),
	(804,16,'185/100A/XXL,黑色53',100,0,159.00,'image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"185/100A/XXL\",\"颜色\":\"黑色53\"}'),
	(805,16,'185/100A/XXL,粉红58',100,0,159.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"185/100A/XXL\",\"颜色\":\"粉红58\"}'),
	(806,16,'185/100A/XXL,燕麦54',100,0,159.00,'image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"185/100A/XXL\",\"颜色\":\"燕麦54\"}'),
	(807,16,'190/104A/XXXL,黑色53',100,0,159.00,'image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"黑色53\"}'),
	(808,16,'190/104A/XXXL,粉红58',100,0,159.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"粉红58\"}'),
	(809,16,'190/104A/XXXL,燕麦54',100,0,159.00,'image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png','',100.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"燕麦54\"}'),
	(865,5,'海蓝色,128GB,值享焕新版',993,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,3,993,993,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"}'),
	(866,5,'海蓝色,128GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,3,999,999,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"}'),
	(867,5,'海蓝色,128GB,换修无忧年付版',998,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,3,998,998,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(922,14,'16GB,100,全网通',999,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',200.00,'',10000.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"全网通\"}'),
	(923,14,'32GB,100,全网通',999,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',200.00,'',10000.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"全网通\"}'),
	(924,14,'128GB,1T,联通',999,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',200.00,'',10000.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"联通\"}'),
	(925,5,'128GB,1T,联通',999,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',200.00,'',10000.00,0.00,0.00,0.00,0.00,1,999,999,'{\"ram\":\"128GB\",\"ROM\":\"1T\",\"网络\":\"联通\"}'),
	(926,5,'16GB,100,全网通',999,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',200.00,'',10000.00,0.00,0.00,0.00,0.00,1,999,999,'{\"ram\":\"16GB\",\"ROM\":\"100\",\"网络\":\"全网通\"}'),
	(927,5,'32GB,100,全网通',999,0,1000.00,'image/store/2020/12/21/9d3d059effbc4e09981a22977b8b162agk0y0isk2v.jpg','',200.00,'',10000.00,0.00,0.00,0.00,0.00,1,999,999,'{\"ram\":\"32GB\",\"ROM\":\"100\",\"网络\":\"全网通\"}'),
	(1120,21,'星辰炒锅30cm',99,0,99.00,'image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png','',99.00,'99',0.00,99.00,99.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"星辰炒锅30cm\"}'),
	(1121,21,'星辰炒锅32CM',99,0,99.00,'image/store/2020/12/22/3fe00af0f91e4346a5e1912109c7620c1irlmbmq8i.png','',99.00,'99',0.00,99.00,99.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"星辰炒锅32CM\"}'),
	(1334,23,'3D浮雕-粉色独角兽',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D浮雕-粉色独角兽\"}'),
	(1335,23,'3D浮雕-蓝色鲸鱼',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D浮雕-蓝色鲸鱼\"}'),
	(1336,23,'3D浮雕-红色恐龙',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D浮雕-红色恐龙\"}'),
	(1337,23,'3D浮雕-狮子王',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D浮雕-狮子王\"}'),
	(1338,23,'3D浮雕-棕色麋鹿',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D浮雕-棕色麋鹿\"}'),
	(1339,23,'3D浮雕-红色熊猫',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D浮雕-红色熊猫\"}'),
	(1340,23,'3D圣诞-大脸鹿',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D圣诞-大脸鹿\"}'),
	(1341,23,'3D圣诞-星球鹿',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D圣诞-星球鹿\"}'),
	(1342,23,'3D圣诞-守护鹿',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D圣诞-守护鹿\"}'),
	(1343,23,'3D圣诞-抱抱熊',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D圣诞-抱抱熊\"}'),
	(1344,23,'3D圣诞-幸运鹿',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D圣诞-幸运鹿\"}'),
	(1345,23,'3D浮雕-小飞象',9999,0,228.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'123',228.00,1.00,1.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"3D浮雕-小飞象\"}'),
	(1557,20,'测试,1,12,df ',8,0,0.01,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1558,20,'测试,1,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1559,20,'测试,1,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1560,20,'测试,1,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1561,20,'测试,1,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1562,20,'测试,1,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1563,20,'测试,1,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1564,20,'测试,1,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1565,20,'测试,1,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1566,20,'测试,1,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1567,20,'测试,1,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1568,20,'测试,1,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1569,20,'测试,1,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1570,20,'测试,1,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1571,20,'测试,1,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1572,20,'测试,1,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1573,20,'测试,2,12,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1574,20,'测试,2,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1575,20,'测试,2,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1576,20,'测试,2,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1577,20,'测试,2,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1578,20,'测试,2,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1579,20,'测试,2,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1580,20,'测试,2,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1581,20,'测试,2,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1582,20,'测试,2,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1583,20,'测试,2,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1584,20,'测试,2,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1585,20,'测试,2,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1586,20,'测试,2,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1587,20,'测试,2,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1588,20,'测试,2,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1589,20,'测试,3,12,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1590,20,'测试,3,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1591,20,'测试,3,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1592,20,'测试,3,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1593,20,'测试,3,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1594,20,'测试,3,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1595,20,'测试,3,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1596,20,'测试,3,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1597,20,'测试,3,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1598,20,'测试,3,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1599,20,'测试,3,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1600,20,'测试,3,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1601,20,'测试,3,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1602,20,'测试,3,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1603,20,'测试,3,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1604,20,'测试,3,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1605,20,'测试,4,12,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1606,20,'测试,4,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1607,20,'测试,4,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1608,20,'测试,4,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1609,20,'测试,4,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1610,20,'测试,4,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1611,20,'测试,4,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1612,20,'测试,4,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1613,20,'测试,4,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1614,20,'测试,4,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1615,20,'测试,4,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1616,20,'测试,4,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1617,20,'测试,4,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1618,20,'测试,4,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1619,20,'测试,4,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1620,20,'测试,4,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1621,20,'测试1,1,12,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1622,20,'测试1,1,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1623,20,'测试1,1,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1624,20,'测试1,1,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1625,20,'测试1,1,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1626,20,'测试1,1,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1627,20,'测试1,1,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1628,20,'测试1,1,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1629,20,'测试1,1,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1630,20,'测试1,1,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1631,20,'测试1,1,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1632,20,'测试1,1,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1633,20,'测试1,1,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1634,20,'测试1,1,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1635,20,'测试1,1,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1636,20,'测试1,1,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1637,20,'测试1,2,12,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1638,20,'测试1,2,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1639,20,'测试1,2,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1640,20,'测试1,2,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1641,20,'测试1,2,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1642,20,'测试1,2,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1643,20,'测试1,2,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1644,20,'测试1,2,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1645,20,'测试1,2,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1646,20,'测试1,2,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1647,20,'测试1,2,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1648,20,'测试1,2,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1649,20,'测试1,2,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1650,20,'测试1,2,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1651,20,'测试1,2,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1652,20,'测试1,2,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1653,20,'测试1,3,12,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1654,20,'测试1,3,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1655,20,'测试1,3,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1656,20,'测试1,3,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1657,20,'测试1,3,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1658,20,'测试1,3,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1659,20,'测试1,3,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1660,20,'测试1,3,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1661,20,'测试1,3,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1662,20,'测试1,3,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1663,20,'测试1,3,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1664,20,'测试1,3,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1665,20,'测试1,3,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1666,20,'测试1,3,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1667,20,'测试1,3,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1668,20,'测试1,3,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1669,20,'测试1,4,12,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1670,20,'测试1,4,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1671,20,'测试1,4,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1672,20,'测试1,4,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1673,20,'测试1,4,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1674,20,'测试1,4,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1675,20,'测试1,4,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1676,20,'测试1,4,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1677,20,'测试1,4,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1678,20,'测试1,4,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1679,20,'测试1,4,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1680,20,'测试1,4,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1681,20,'测试1,4,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1682,20,'测试1,4,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1683,20,'测试1,4,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1684,20,'测试1,4,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试1\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1685,20,'测试2,1,12,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1686,20,'测试2,1,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1687,20,'测试2,1,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1688,20,'测试2,1,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1689,20,'测试2,1,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1690,20,'测试2,1,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1691,20,'测试2,1,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1692,20,'测试2,1,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1693,20,'测试2,1,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1694,20,'测试2,1,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1695,20,'测试2,1,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1696,20,'测试2,1,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1697,20,'测试2,1,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1698,20,'测试2,1,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1699,20,'测试2,1,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1700,20,'测试2,1,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"1\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1701,20,'测试2,2,12,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1702,20,'测试2,2,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1703,20,'测试2,2,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1704,20,'测试2,2,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1705,20,'测试2,2,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1706,20,'测试2,2,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1707,20,'测试2,2,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1708,20,'测试2,2,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1709,20,'测试2,2,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1710,20,'测试2,2,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1711,20,'测试2,2,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1712,20,'测试2,2,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1713,20,'测试2,2,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1714,20,'测试2,2,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1715,20,'测试2,2,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1716,20,'测试2,2,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"2\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1717,20,'测试2,3,12,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1718,20,'测试2,3,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1719,20,'测试2,3,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1720,20,'测试2,3,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1721,20,'测试2,3,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1722,20,'测试2,3,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1723,20,'测试2,3,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1724,20,'测试2,3,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1725,20,'测试2,3,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1726,20,'测试2,3,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1727,20,'测试2,3,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1728,20,'测试2,3,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1729,20,'测试2,3,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1730,20,'测试2,3,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1731,20,'测试2,3,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1732,20,'测试2,3,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"3\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1733,20,'测试2,4,12,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"df \"}'),
	(1734,20,'测试2,4,12,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"再次\"}'),
	(1735,20,'测试2,4,12,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"撒旦\"}'),
	(1736,20,'测试2,4,12,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"12\",\"额为\":\"是\"}'),
	(1737,20,'测试2,4,a\'s,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"df \"}'),
	(1738,20,'测试2,4,a\'s,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"再次\"}'),
	(1739,20,'测试2,4,a\'s,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"撒旦\"}'),
	(1740,20,'测试2,4,a\'s,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"a\'s\",\"额为\":\"是\"}'),
	(1741,20,'测试2,4,d\'f,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"df \"}'),
	(1742,20,'测试2,4,d\'f,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"再次\"}'),
	(1743,20,'测试2,4,d\'f,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"撒旦\"}'),
	(1744,20,'测试2,4,d\'f,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"d\'f\",\"额为\":\"是\"}'),
	(1745,20,'测试2,4,s\'d,df ',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"df \"}'),
	(1746,20,'测试2,4,s\'d,再次',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"再次\"}'),
	(1747,20,'测试2,4,s\'d,撒旦',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"撒旦\"}'),
	(1748,20,'测试2,4,s\'d,是',10,0,20.00,'image/store/2020/12/22/813e675000584eb694f3defff1975fb4n8owt2wvsq.jpg','',10.00,'',30.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"测试\":\"测试2\",\"生成\":\"4\",\"从啊\":\"s\'d\",\"额为\":\"是\"}'),
	(1749,3,'海蓝色,128GB,值享焕新版',993,0,1.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,1,993,993,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"}'),
	(1750,3,'海蓝色,128GB,公开版',999,0,1.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,1,999,999,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"}'),
	(1751,3,'海蓝色,512GB,公开版',999,0,1.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,1,999,999,'{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"}'),
	(1752,3,'海蓝色,512GB,换修无忧年付版',999,0,1.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,1,999,999,'{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1753,6,'默认',992,0,99.30,'image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png','',0.00,'',150.00,0.00,0.00,0.00,0.00,1,992,992,NULL),
	(1754,7,'默认',992,0,100.00,'image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png','',0.00,'',150.00,0.00,0.00,0.00,0.00,1,992,992,NULL),
	(1755,8,'170/88A/M,牛仔蓝66',100,0,218.00,'image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png','',100.00,'',299.00,0.00,0.00,0.00,0.00,1,100,100,'{\"尺码\":\"170/88A/M\",\"颜色\":\"牛仔蓝66\"}'),
	(1756,8,'175/92A/L,牛仔蓝66',94,0,218.00,'image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png','',100.00,'',299.00,0.00,0.00,0.00,0.00,1,94,94,'{\"尺码\":\"175/92A/L\",\"颜色\":\"牛仔蓝66\"}'),
	(1757,8,'180/96A/XL,牛仔蓝66',100,0,218.00,'image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png','',100.00,'',299.00,0.00,0.00,0.00,0.00,1,100,100,'{\"尺码\":\"180/96A/XL\",\"颜色\":\"牛仔蓝66\"}'),
	(1758,8,'185/100A/XXL,牛仔蓝66',100,0,218.00,'image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png','',100.00,'',299.00,0.00,0.00,0.00,0.00,1,100,100,'{\"尺码\":\"185/100A/XXL\",\"颜色\":\"牛仔蓝66\"}'),
	(1759,8,'190/104A/XXXL,牛仔蓝66',100,0,218.00,'image/content/2020/12/22/a790d28b452e4c55a8033766aeb22503o5lks5poya.png','',100.00,'',299.00,0.00,0.00,0.00,0.00,1,100,100,'{\"尺码\":\"190/104A/XXXL\",\"颜色\":\"牛仔蓝66\"}'),
	(1849,10,'01,白色',0,0,0.30,'','',0.00,'',0.00,0.00,0.00,0.00,0.00,1,1,1,'{\"num\":\"01\",\"测试21\":\"白色\"}'),
	(1850,10,'01,黑色',0,0,0.30,'','',0.00,'',0.00,0.00,0.00,0.00,0.00,1,1,1,'{\"num\":\"01\",\"测试21\":\"黑色\"}'),
	(1851,11,'默认',992,0,100.10,'image/content/2020/12/15/1cf475d3fc0647d59f17ea724e2c8fe2wf6ohlvtzz.png','',0.00,'',150.00,0.00,0.00,0.00,0.00,1,992,992,NULL),
	(1852,7,'默认',10,12,100.00,'image/content/2020/12/16/6f9dba23a7964b209377746b776fc313od5aep3dat.jpg','',50.00,'',200.00,0.00,0.00,0.00,0.00,0,NULL,NULL,NULL),
	(1853,9,'海蓝色,128GB,值享焕新版',993,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"}'),
	(1854,9,'海蓝色,128GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"}'),
	(1855,9,'海蓝色,128GB,换修无忧年付版',998,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1856,9,'海蓝色,256GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"}'),
	(1857,9,'海蓝色,256GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"}'),
	(1858,9,'海蓝色,256GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1859,9,'海蓝色,512GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"}'),
	(1860,9,'海蓝色,512GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"}'),
	(1861,9,'海蓝色,512GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"海蓝色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1862,9,'石墨色,128GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"}'),
	(1863,9,'石墨色,128GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"}'),
	(1864,9,'石墨色,128GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1865,9,'石墨色,256GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"}'),
	(1866,9,'石墨色,256GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"}'),
	(1867,9,'石墨色,256GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1868,9,'石墨色,512GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"}'),
	(1869,9,'石墨色,512GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"}'),
	(1870,9,'石墨色,512GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"石墨色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1871,9,'金色,128GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"}'),
	(1872,9,'金色,128GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"}'),
	(1873,9,'金色,128GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1874,9,'金色,256GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"}'),
	(1875,9,'金色,256GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"}'),
	(1876,9,'金色,256GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1877,9,'金色,512GB,值享焕新版',990,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"}'),
	(1878,9,'金色,512GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"}'),
	(1879,9,'金色,512GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"金色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1880,9,'银色,128GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"值享焕新版\"}'),
	(1881,9,'银色,128GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"公开版\"}'),
	(1882,9,'银色,128GB,换修无忧年付版',998,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"128GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1883,9,'银色,256GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"值享焕新版\"}'),
	(1884,9,'银色,256GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"公开版\"}'),
	(1885,9,'银色,256GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"256GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1886,9,'银色,512GB,值享焕新版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"值享焕新版\"}'),
	(1887,9,'银色,512GB,公开版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"公开版\"}'),
	(1888,9,'银色,512GB,换修无忧年付版',999,0,10000.00,'image/store/2020/12/17/785aeb1dea144c0b9e87ae021f14d0d0djsnp7uksy.png','',5000.00,'',0.00,0.00,0.00,0.00,0.00,0,NULL,NULL,'{\"颜色\":\"银色\",\"版本\":\"512GB\",\"购买方式\":\"换修无忧年付版\"}'),
	(1889,10,'165/84A/S,燕麦54',100,0,159.00,'image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png','',100.00,'',199.00,0.00,0.00,0.00,0.00,2,100,NULL,NULL),
	(1890,9,'165/84A/S,燕麦54',100,0,159.00,'image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png','',100.00,'',199.00,0.00,0.00,0.00,0.00,3,100,100,'{\"尺码\":\"165/84A/S\",\"颜色\":\"燕麦54\"}'),
	(1891,9,'165/84A/S,粉红58',100,0,159.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'',199.00,0.00,0.00,0.00,0.00,3,100,100,'{\"尺码\":\"165/84A/S\",\"颜色\":\"粉红58\"}'),
	(1892,9,'165/84A/S,黑色53',100,0,159.00,'image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png','',100.00,'',199.00,0.00,0.00,0.00,0.00,3,100,100,'{\"尺码\":\"165/84A/S\",\"颜色\":\"黑色53\"}'),
	(1893,9,'170/88A/M,燕麦54',83,0,159.00,'image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png','',100.00,'',199.00,0.00,0.00,0.00,0.00,3,83,83,'{\"尺码\":\"170/88A/M\",\"颜色\":\"燕麦54\"}'),
	(1894,9,'170/88A/M,粉红58',97,0,159.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'',199.00,0.00,0.00,0.00,0.00,3,97,97,'{\"尺码\":\"170/88A/M\",\"颜色\":\"粉红58\"}'),
	(1895,9,'170/88A/M,黑色53',100,0,159.00,'image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png','',100.00,'',199.00,0.00,0.00,0.00,0.00,3,100,100,'{\"尺码\":\"170/88A/M\",\"颜色\":\"黑色53\"}'),
	(1896,9,'175/92A/L,燕麦54',100,0,159.00,'image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png','',100.00,'',199.00,0.00,0.00,0.00,0.00,3,100,100,'{\"尺码\":\"175/92A/L\",\"颜色\":\"燕麦54\"}'),
	(1897,9,'175/92A/L,粉红58',100,0,159.00,'image/store/2020/12/22/5699accd40724da7a33d717d12be688430b8y2zgp8.png','',100.00,'',199.00,0.00,0.00,0.00,0.00,3,100,100,'{\"尺码\":\"175/92A/L\",\"颜色\":\"粉红58\"}'),
	(1898,9,'175/92A/L,黑色53',100,0,159.00,'image/store/2020/12/22/fc67e23a99714525a2bab025e4935f95vnlvwzyldk.png','',100.00,'',199.00,0.00,0.00,0.00,0.00,3,100,100,'{\"尺码\":\"175/92A/L\",\"颜色\":\"黑色53\"}'),
	(1899,9,'180/96A/XL,燕麦54',100,0,159.00,'image/store/2020/12/22/a4ae34bbc6f3418c81b12f9fa7e5a5d48rgur851s7.png','',100.00,'',199.00,