package com.exception;

/**
 * Api异常类
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2020 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
public class ApiException extends RuntimeException{

    private ExceptionHandler exceptionHandler;

    public ApiException(ExceptionHandler exceptionHandler) {
        super(exceptionHandler.getMessage());
        this.exceptionHandler = exceptionHandler;
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(Throwable cause) {
        super(cause);
    }

    public ApiException(String message, Throwable cause) {
        super(message, cause);
    }

    public ExceptionHandler getErrorCode() {
        return exceptionHandler;
    }
}
