﻿/*
MySQL Backup
Source Server Version: 5.0.22
Source Database: jsh_erp
Date: 2017-07-03 12:28:15
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
--  Table structure for `jsh_account`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_account`;
CREATE TABLE `jsh_account` (
  `Id` bigint(20) NOT NULL auto_increment,
  `Name` varchar(50) default NULL COMMENT '名称',
  `SerialNo` varchar(50) default NULL COMMENT '编号',
  `InitialAmount` double default NULL COMMENT '期初金额',
  `CurrentAmount` double default NULL COMMENT '当前余额',
  `Remark` varchar(100) default NULL COMMENT '备注',
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_accounthead`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_accounthead`;
CREATE TABLE `jsh_accounthead` (
  `Id` bigint(20) NOT NULL auto_increment,
  `Type` varchar(50) default NULL COMMENT '类型(支出/收入/收款/付款/转账)',
  `OrganId` bigint(20) default NULL COMMENT '单位Id(收款/付款单位)',
  `HandsPersonId` bigint(20) default NULL COMMENT '经手人Id',
  `ChangeAmount` double default NULL COMMENT '变动金额(优惠/收款/付款/实付)',
  `TotalPrice` double default NULL COMMENT '合计金额',
  `AccountId` bigint(20) default NULL COMMENT '账户(收款/付款)',
  `BillNo` varchar(50) default NULL COMMENT '单据编号',
  `BillTime` datetime default NULL COMMENT '单据日期',
  `Remark` varchar(100) default NULL COMMENT '备注',
  PRIMARY KEY  (`Id`),
  KEY `FK9F4C0D8DB610FC06` (`OrganId`),
  KEY `FK9F4C0D8DAAE50527` (`AccountId`),
  KEY `FK9F4C0D8DC4170B37` (`HandsPersonId`),
  CONSTRAINT `FK9F4C0D8DAAE50527` FOREIGN KEY (`AccountId`) REFERENCES `jsh_account` (`Id`),
  CONSTRAINT `FK9F4C0D8DB610FC06` FOREIGN KEY (`OrganId`) REFERENCES `jsh_supplier` (`id`),
  CONSTRAINT `FK9F4C0D8DC4170B37` FOREIGN KEY (`HandsPersonId`) REFERENCES `jsh_person` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_accountitem`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_accountitem`;
CREATE TABLE `jsh_accountitem` (
  `Id` bigint(20) NOT NULL auto_increment,
  `HeaderId` bigint(20) NOT NULL COMMENT '表头Id',
  `AccountId` bigint(20) default NULL COMMENT '账户Id',
  `InOutItemId` bigint(20) default NULL COMMENT '收支项目Id',
  `EachAmount` double default NULL COMMENT '单项金额',
  `Remark` varchar(100) default NULL COMMENT '单据备注',
  PRIMARY KEY  (`Id`),
  KEY `FK9F4CBAC0AAE50527` (`AccountId`),
  KEY `FK9F4CBAC0C5FE6007` (`HeaderId`),
  KEY `FK9F4CBAC0D203EDC5` (`InOutItemId`),
  CONSTRAINT `FK9F4CBAC0AAE50527` FOREIGN KEY (`AccountId`) REFERENCES `jsh_account` (`Id`),
  CONSTRAINT `FK9F4CBAC0C5FE6007` FOREIGN KEY (`HeaderId`) REFERENCES `jsh_accounthead` (`Id`) ON DELETE CASCADE,
  CONSTRAINT `FK9F4CBAC0D203EDC5` FOREIGN KEY (`InOutItemId`) REFERENCES `jsh_inoutitem` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_app`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_app`;
CREATE TABLE `jsh_app` (
  `Id` bigint(20) NOT NULL auto_increment,
  `Number` varchar(50) default NULL,
  `Name` varchar(50) default NULL,
  `Type` varchar(50) default NULL,
  `Icon` varchar(50) default NULL,
  `URL` varchar(50) default NULL,
  `Width` varchar(50) default NULL,
  `Height` varchar(50) default NULL,
  `ReSize` bit(1) default NULL,
  `OpenMax` bit(1) default NULL,
  `Flash` bit(1) default NULL,
  `ZL` varchar(50) default NULL,
  `Sort` varchar(50) default NULL,
  `Remark` varchar(200) default NULL,
  `Enabled` bit(1) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_asset`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_asset`;
CREATE TABLE `jsh_asset` (
  `id` bigint(20) NOT NULL auto_increment,
  `assetnameID` bigint(20) NOT NULL,
  `location` varchar(255) default NULL COMMENT '位置',
  `labels` varchar(255) default NULL COMMENT '标签：以空格为分隔符',
  `status` smallint(6) default NULL COMMENT '资产的状态：0==在库，1==在用，2==消费',
  `userID` bigint(20) default NULL,
  `price` double default NULL COMMENT '购买价格',
  `purchasedate` datetime default NULL COMMENT '购买日期',
  `periodofvalidity` datetime default NULL COMMENT '有效日期',
  `warrantydate` datetime default NULL COMMENT '保修日期',
  `assetnum` varchar(255) default NULL COMMENT '资产编号',
  `serialnum` varchar(255) default NULL COMMENT '资产序列号',
  `supplier` bigint(20) NOT NULL,
  `description` longtext COMMENT '描述信息',
  `addMonth` longtext COMMENT '资产添加时间，统计报表使用',
  `createtime` datetime default NULL,
  `creator` bigint(20) default NULL,
  `updatetime` datetime default NULL,
  `updator` bigint(20) default NULL,
  PRIMARY KEY  (`id`),
  KEY `FK353690ED9B6CB285` (`assetnameID`),
  KEY `FK353690EDAD45B659` (`creator`),
  KEY `FK353690ED27D23FE4` (`supplier`),
  KEY `FK353690ED61FE182C` (`updator`),
  KEY `FK353690ED3E226853` (`userID`),
  CONSTRAINT `FK353690ED27D23FE4` FOREIGN KEY (`supplier`) REFERENCES `jsh_supplier` (`id`),
  CONSTRAINT `FK353690ED3E226853` FOREIGN KEY (`userID`) REFERENCES `jsh_user` (`id`),
  CONSTRAINT `FK353690ED61FE182C` FOREIGN KEY (`updator`) REFERENCES `jsh_user` (`id`),
  CONSTRAINT `FK353690ED9B6CB285` FOREIGN KEY (`assetnameID`) REFERENCES `jsh_assetname` (`id`),
  CONSTRAINT `FK353690EDAD45B659` FOREIGN KEY (`creator`) REFERENCES `jsh_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_assetcategory`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_assetcategory`;
CREATE TABLE `jsh_assetcategory` (
  `id` bigint(20) NOT NULL auto_increment,
  `assetname` varchar(255) NOT NULL COMMENT '资产类型名称',
  `isystem` tinyint(4) NOT NULL COMMENT '是否系统自带 0==系统 1==非系统',
  `description` varchar(500) default NULL COMMENT '描述信息',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_assetname`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_assetname`;
CREATE TABLE `jsh_assetname` (
  `id` bigint(20) NOT NULL auto_increment,
  `assetname` varchar(255) NOT NULL COMMENT '资产名称',
  `assetcategoryID` bigint(20) NOT NULL,
  `isystem` smallint(6) NOT NULL COMMENT '是否系统自带 0==系统 1==非系统',
  `description` longtext COMMENT '描述信息',
  `isconsumables` smallint(6) default NULL COMMENT '是否为耗材 0==否 1==是 耗材状态只能是消费',
  PRIMARY KEY  (`id`),
  KEY `FKA4ADCCF866BC8AD3` (`assetcategoryID`),
  CONSTRAINT `FKA4ADCCF866BC8AD3` FOREIGN KEY (`assetcategoryID`) REFERENCES `jsh_assetcategory` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_depot`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_depot`;
CREATE TABLE `jsh_depot` (
  `id` bigint(20) NOT NULL auto_increment COMMENT '主键',
  `name` varchar(20) default NULL COMMENT '仓库名称',
  `sort` varchar(10) default NULL COMMENT '排序',
  `remark` varchar(100) default NULL COMMENT '描述',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_depothead`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_depothead`;
CREATE TABLE `jsh_depothead` (
  `Id` bigint(20) NOT NULL auto_increment,
  `Type` varchar(50) default NULL COMMENT '类型(出库/入库)',
  `SubType` varchar(50) default NULL COMMENT '出入库分类',
  `ProjectId` bigint(20) NOT NULL COMMENT '项目Id',
  `Number` varchar(50) default NULL COMMENT '票据号',
  `OperPersonName` varchar(50) default NULL COMMENT '操作员名字',
  `CreateTime` datetime default NULL COMMENT '创建时间',
  `OperTime` datetime default NULL COMMENT '出入库时间',
  `OrganId` bigint(20) default NULL COMMENT '供应商Id',
  `HandsPersonId` bigint(20) default NULL COMMENT '采购/领料-经手人Id',
  `AccountId` bigint(20) default NULL COMMENT '账户Id',
  `ChangeAmount` double default NULL COMMENT '变动金额(收款/付款)',
  `AllocationProjectId` bigint(20) default NULL COMMENT '调拨时，对方项目Id',
  `TotalPrice` double default NULL COMMENT '合计金额',
  `PayType` varchar(50) default NULL,
  `Remark` varchar(1000) default NULL COMMENT '备注',
  PRIMARY KEY  (`Id`),
  KEY `FK2A80F214CA633ABA` (`AllocationProjectId`),
  KEY `FK2A80F214C4170B37` (`HandsPersonId`),
  KEY `FK2A80F214B610FC06` (`OrganId`),
  KEY `FK2A80F2142888F9A` (`ProjectId`),
  KEY `FK2A80F214AAE50527` (`AccountId`),
  CONSTRAINT `FK2A80F214AAE50527` FOREIGN KEY (`AccountId`) REFERENCES `jsh_account` (`Id`),
  CONSTRAINT `jsh_depothead_ibfk_1` FOREIGN KEY (`ProjectId`) REFERENCES `jsh_depot` (`id`),
  CONSTRAINT `jsh_depothead_ibfk_3` FOREIGN KEY (`OrganId`) REFERENCES `jsh_supplier` (`id`),
  CONSTRAINT `jsh_depothead_ibfk_4` FOREIGN KEY (`HandsPersonId`) REFERENCES `jsh_person` (`Id`),
  CONSTRAINT `jsh_depothead_ibfk_5` FOREIGN KEY (`AllocationProjectId`) REFERENCES `jsh_depot` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_depotitem`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_depotitem`;
CREATE TABLE `jsh_depotitem` (
  `Id` bigint(20) NOT NULL auto_increment,
  `HeaderId` bigint(20) NOT NULL COMMENT '表头Id',
  `MaterialId` bigint(20) NOT NULL COMMENT '材料Id',
  `OperNumber` double default NULL COMMENT '数量',
  `UnitPrice` double default NULL COMMENT '单价',
  `AllPrice` double default NULL COMMENT '金额',
  `Remark` varchar(200) default NULL COMMENT '描述',
  `Img` varchar(50) default NULL COMMENT '图片',
  `Incidentals` double default NULL COMMENT '运杂费',
  PRIMARY KEY  (`Id`),
  KEY `FK2A819F475D61CCF7` (`MaterialId`),
  KEY `FK2A819F474BB6190E` (`HeaderId`),
  CONSTRAINT `jsh_depotitem_ibfk_1` FOREIGN KEY (`HeaderId`) REFERENCES `jsh_depothead` (`Id`) ON DELETE CASCADE,
  CONSTRAINT `jsh_depotitem_ibfk_2` FOREIGN KEY (`MaterialId`) REFERENCES `jsh_material` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_functions`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_functions`;
CREATE TABLE `jsh_functions` (
  `Id` bigint(20) NOT NULL auto_increment,
  `Number` varchar(50) default NULL,
  `Name` varchar(50) default NULL,
  `PNumber` varchar(50) default NULL,
  `URL` varchar(100) default NULL,
  `State` bit(1) default NULL,
  `Sort` varchar(50) default NULL,
  `Enabled` bit(1) default NULL,
  `Type` varchar(50) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_inoutitem`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_inoutitem`;
CREATE TABLE `jsh_inoutitem` (
  `Id` bigint(20) NOT NULL auto_increment,
  `Name` varchar(50) default NULL COMMENT '名称',
  `Type` varchar(20) default NULL COMMENT '类型',
  `Remark` varchar(100) default NULL COMMENT '备注',
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_log`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_log`;
CREATE TABLE `jsh_log` (
  `id` bigint(20) NOT NULL auto_increment,
  `userID` bigint(20) NOT NULL COMMENT '操作用户ID',
  `operation` varchar(500) default NULL COMMENT '操作模块名称',
  `clientIP` varchar(50) default NULL COMMENT '客户端IP',
  `createtime` datetime default NULL COMMENT '创建时间',
  `status` tinyint(4) default NULL COMMENT '操作状态 0==成功，1==失败',
  `contentdetails` varchar(1000) default NULL COMMENT '操作详情',
  `remark` varchar(500) default NULL COMMENT '备注信息',
  PRIMARY KEY  (`id`),
  KEY `FKF2696AA13E226853` (`userID`),
  CONSTRAINT `FKF2696AA13E226853` FOREIGN KEY (`userID`) REFERENCES `jsh_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_material`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_material`;
CREATE TABLE `jsh_material` (
  `Id` bigint(20) NOT NULL auto_increment,
  `CategoryId` bigint(20) default NULL,
  `Name` varchar(50) default NULL COMMENT '名称',
  `Model` varchar(50) default NULL COMMENT '型号',
  `Color` varchar(50) default NULL COMMENT '颜色',
  `Unit` varchar(50) default NULL COMMENT '单位',
  `Remark` varchar(100) default NULL COMMENT '备注',
  `RetailPrice` double default NULL COMMENT '零售价',
  `LowPrice` double default NULL COMMENT '最低售价',
  `PresetPriceOne` double default NULL COMMENT '预设售价一',
  `PresetPriceTwo` double default NULL COMMENT '预设售价二',
  PRIMARY KEY  (`Id`),
  KEY `FK675951272AB6672C` (`CategoryId`),
  CONSTRAINT `FK675951272AB6672C` FOREIGN KEY (`CategoryId`) REFERENCES `jsh_materialcategory` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_materialcategory`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_materialcategory`;
CREATE TABLE `jsh_materialcategory` (
  `Id` bigint(20) NOT NULL auto_increment,
  `Name` varchar(50) default NULL COMMENT '名称',
  `CategoryLevel` smallint(6) default NULL COMMENT '等级',
  `ParentId` bigint(20) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FK3EE7F725237A77D8` (`ParentId`),
  CONSTRAINT `FK3EE7F725237A77D8` FOREIGN KEY (`ParentId`) REFERENCES `jsh_materialcategory` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_person`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_person`;
CREATE TABLE `jsh_person` (
  `Id` bigint(20) NOT NULL auto_increment,
  `Type` varchar(20) default NULL COMMENT '类型',
  `Name` varchar(50) default NULL COMMENT '姓名',
  `ProjectId` bigint(20) NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_role`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_role`;
CREATE TABLE `jsh_role` (
  `Id` bigint(20) NOT NULL auto_increment,
  `Name` varchar(50) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_supplier`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_supplier`;
CREATE TABLE `jsh_supplier` (
  `id` bigint(20) NOT NULL auto_increment,
  `supplier` varchar(255) NOT NULL COMMENT '供应商名称',
  `contacts` varchar(100) default NULL COMMENT '联系人',
  `phonenum` varchar(30) default NULL COMMENT '联系电话',
  `email` varchar(50) default NULL COMMENT '电子邮箱',
  `description` varchar(500) default NULL,
  `isystem` tinyint(4) default NULL,
  `type` varchar(20) default NULL COMMENT '类型',
  `enabled` bit(1) default NULL COMMENT '启用',
  `AdvanceIn` double default '0',
  `BeginNeedGet` double default NULL COMMENT '期初应收',
  `BeginNeedPay` double default NULL COMMENT '期初应付',
  `AllNeedGet` double default NULL COMMENT '累计应收',
  `AllNeedPay` double default NULL COMMENT '累计应付',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_user`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_user`;
CREATE TABLE `jsh_user` (
  `id` bigint(20) NOT NULL auto_increment,
  `username` varchar(255) NOT NULL COMMENT '用户姓名--例如张三',
  `loginame` varchar(255) default NULL COMMENT '登录用户名--可能为空',
  `password` varchar(50) default NULL COMMENT '登陆密码',
  `position` varchar(200) default NULL COMMENT '职位',
  `department` varchar(255) default NULL COMMENT '所属部门',
  `email` varchar(100) default NULL COMMENT '电子邮箱',
  `phonenum` varchar(100) default NULL COMMENT '手机号码',
  `ismanager` tinyint(4) NOT NULL default '1' COMMENT '是否为管理者 0==管理者 1==员工',
  `isystem` tinyint(4) NOT NULL default '1' COMMENT '是否系统自带数据 ',
  `status` tinyint(4) default NULL COMMENT '用户状态',
  `description` varchar(500) default NULL COMMENT '用户描述信息',
  `remark` varchar(500) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_userbusiness`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_userbusiness`;
CREATE TABLE `jsh_userbusiness` (
  `Id` bigint(20) NOT NULL auto_increment,
  `Type` varchar(50) default NULL,
  `KeyId` varchar(50) default NULL,
  `Value` varchar(10000) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jsh_visitaccount`
-- ----------------------------
DROP TABLE IF EXISTS `jsh_visitaccount`;
CREATE TABLE `jsh_visitaccount` (
  `Id` bigint(20) NOT NULL auto_increment,
  `ProjectId` bigint(20) NOT NULL,
  `LouHao` varchar(50) default NULL,
  `HuHao` varchar(50) default NULL,
  `HuiFang` varchar(50) default NULL,
  `LuoShi` varchar(50) default NULL,
  `Name` varchar(50) default NULL,
  `Tel` varchar(50) default NULL,
  `AddTime` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FKFF4AAE822888F9A` (`ProjectId`),
  CONSTRAINT `FKFF4AAE822888F9A` FOREIGN KEY (`ProjectId`) REFERENCES `jsh_depot` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Records 
-- ----------------------------
INSERT INTO `jsh_account` VALUES ('4','南通建行','652346523465234623','1200','215','建行账户'), ('9','流动总账','65234624523452364','2000','393','现在账户');
INSERT INTO `jsh_accounthead` VALUES ('3','收入','1','3','333',NULL,'9','33No','2016-12-10 00:00:00','444aa'), ('9','收入','1','3','213',NULL,'4','3134','2016-12-10 00:00:00','12341'), ('12','收入','1','3','123',NULL,'4','NO123','2016-12-10 00:00:00','666666'), ('14','支出','1','3','-55',NULL,'9','aa','2016-12-11 00:00:00','123'), ('15','收款','1','3','123',NULL,'9','34124','2016-12-11 00:00:00','123'), ('16','付款','1','3','1234',NULL,'4','234234','2016-12-11 00:00:00','2342'), ('18','收款','1','3','11',NULL,'4','123123','2016-12-18 00:00:00','123'), ('19','收入','1','3','333',NULL,'9','1234','2017-01-14 00:00:00','132'), ('21','支出','4','3','-132',NULL,'9','eqw','2017-01-14 00:00:00','12341'), ('22','收款','1','3','12',NULL,NULL,'234','2017-01-14 00:00:00','21'), ('23','付款','1','3','234',NULL,NULL,'3123','2017-01-14 00:00:00','234'), ('25','收入','1','4','12',NULL,'9','3214','2017-01-15 00:00:00','1234123'), ('26','收入','1','4','33',NULL,'9','1234we','2017-01-15 00:00:00','sss'), ('27','收入','1','4','11',NULL,'4','a1','2017-01-15 00:00:00','22'), ('28','支出','2','4','-333',NULL,'9','a2','2017-01-15 00:00:00','33334344'), ('29','收款','1','3','11',NULL,NULL,'123','2017-01-15 00:00:00','666666'), ('30','付款','2','4','22',NULL,NULL,'341aaa','2017-01-15 00:00:00','qwqw'), ('32','支出','2','4','-77',NULL,'9','hhhh','2017-01-15 00:00:00','tt'), ('33','收入','1','4','44',NULL,'9','s1qw','2017-01-15 00:00:00','wrerw123'), ('34','收入','1','3','33',NULL,'9','123','2017-01-21 00:00:00','dddd'), ('35','收入','1','3','1223','1224','9','aabb','2017-01-21 00:00:00','55fddd'), ('36','支出','2','4','-52','-55','9','bianhao1','2017-01-21 00:00:00','bzbz'), ('37','收款','1','4','4','22',NULL,'fff','2017-01-21 00:00:00','adas'), ('38','付款','2','3','3','-44',NULL,'234eq','2017-01-21 00:00:00','52345we'), ('39','转账',NULL,'4','44','44','9','aasss','2017-01-21 00:00:00','555ddd'), ('40','收款','6','4','33','100',NULL,'aaxx11','2017-04-09 00:00:00',''), ('41','转账',NULL,'4','1','1','9','aa','2017-06-03 00:00:00',''), ('42','收入','6','4','575','575','4','ffff','2017-06-16 00:00:00','66'), ('43','收款','2','4',NULL,'100',NULL,'abcdefg','2017-06-26 00:00:00',''), ('57','收预付款','8','3',NULL,'1000',NULL,'2342134','2017-06-27 00:00:00',''), ('58','收入','2','3','44','233','4','SR2017062901617','2017-06-29 00:00:00',''), ('59','收款','2','3',NULL,'33',NULL,'SK2017062901657','2017-06-29 00:00:00',''), ('60','付款','1','3',NULL,'-22',NULL,'FK2017062901710','2017-06-29 00:00:00',''), ('61','收预付款','9','3',NULL,'33',NULL,'SYF2017062901721','2017-06-29 00:00:00','aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa');
INSERT INTO `jsh_accountitem` VALUES ('3','9',NULL,'5',NULL,'123414'), ('6','12',NULL,'8','12','啊啊啊'), ('8','3',NULL,'9','11',''), ('9','3',NULL,'8','22',''), ('10','14',NULL,'10','123','123'), ('11','15','4','7','12341','124'), ('12','16',NULL,'1','3423','2342'), ('14','18','9',NULL,'11','123'), ('15','18','4',NULL,'22','aaa'), ('16','19',NULL,'5','12','2222'), ('18','21',NULL,'10','22','23'), ('19','22','4',NULL,'22','2'), ('20','23','9',NULL,'12','23aaa'), ('22','25',NULL,'5','11','aaaa'), ('23','26',NULL,'7','11','aaa'), ('24','26',NULL,'5','22','bbb'), ('25','27',NULL,'7','22','333333'), ('26','28',NULL,'11','33','4444'), ('27','29','9',NULL,'22','555'), ('28','30','9',NULL,'22','fffff'), ('30','32',NULL,'10','55','fsdasdf'), ('31','33',NULL,'7','44',''), ('32','34',NULL,'7','33','bzbz'), ('33','35',NULL,'5','1212','fzfz'), ('34','35',NULL,'7','12','lxlx'), ('35','36',NULL,'11','22','yyyy1'), ('36','36',NULL,'10','33','gggg2'), ('37','37','9',NULL,'22',''), ('38','38','4',NULL,'44','sadfa'), ('39','39','4',NULL,'44','2342qqqq'), ('40','40','9',NULL,'100',''), ('41','41','4',NULL,'1',''), ('42','42',NULL,'13','555',''), ('43','42',NULL,'14','20',''), ('44','43','9',NULL,'100',''), ('58','57','9',NULL,'1000',''), ('59','58',NULL,'13','233',''), ('60','59','4',NULL,'33',''), ('61','60','4',NULL,'22',''), ('62','61','4',NULL,'33','');
INSERT INTO `jsh_app` VALUES ('1','','企业邮箱','app','0000000001.png','../EmailManage/Email','600','400','\0','\0','\0','desk','010','','\0'), ('3','00','系统管理','app','0000000004.png','','1024','600','','\0','\0','desk','198','',''), ('6','','个人信息','app','0000000005.png','../user/password.jsp','600','400','\0','\0','\0','dock','200','',''), ('7','01','基础数据','app','0000000006.png','','1024','600','','\0','\0','desk','120','',''), ('8','02','进销存','app','0000000007.png','','1024','600','','\0','\0','desk','030','',''), ('20','13','公告管理','app','0000000020.png',NULL,'1024','600','','\0','\0','desk','125',NULL,'\0'), ('21','','今日留言','app','0000000021.png','../phone/msg','1024','600','','\0','\0','dock','000','','\0'), ('22','03','报表查询','app','0000000022.png','','1024','600','','\0','\0','desk','115','','');
INSERT INTO `jsh_asset` VALUES ('1','27','weizhi','','0',NULL,'11','2016-10-22 00:00:00','2016-10-21 00:00:00','2016-11-03 00:00:00','1231241','123124123','2','','2016-10','2016-10-22 20:04:48','63','2016-10-22 20:04:48','63');
INSERT INTO `jsh_assetcategory` VALUES ('14','递延资产','1','递延资产'), ('15','无形资产','1','无形资产'), ('16','长期投资','1','长期投资'), ('17','固定资产','1','固定资产'), ('18','流动资产','1','流动资产');
INSERT INTO `jsh_assetname` VALUES ('1','联想Y450','17','1','','1'), ('2','惠普打印机','15','1','','0'), ('12','乐萌水杯','16','1','','1'), ('13','机顶盒','17','1','机顶盒','0'), ('14','TCL电视','17','1','','1'), ('15','手机','17','1','','1'), ('16','硬盘','16','1','','0'), ('17','毛笔','17','1','','0'), ('18','杯子','17','1','','0'), ('19','建造师证书','15','1','','0'), ('20','算量软件','14','1','','1'), ('21','cad软件','15','1','','0'), ('22','办公桌','17','1','','0'), ('23','笔记本','17','1','笔记本','1'), ('24','打印机','17','1','打印机','0'), ('25','电脑','17','1','电脑','0'), ('26','电动车','16','1','电动车','0'), ('27','电源线','17','1','电源线','0');
INSERT INTO `jsh_depot` VALUES ('1','上海花边店','2','上海'), ('2','公司总部','1','总部'), ('3','苏州花边店','3','苏州');
INSERT INTO `jsh_depothead` VALUES ('31','出库','销售','1','123A','季圣华','2016-11-08 22:16:11','2016-11-08 00:00:00','2','1','4','33',NULL,'61','现付','444aaaa'), ('32','入库','采购','1','ww123','季圣华','2016-11-25 22:14:46','2016-11-25 00:00:00','1','2','4','-1',NULL,'-0.9','现付',''), ('33','入库','其它','1','234234','季圣华','2016-12-11 18:15:39','2016-12-11 00:00:00','1','2',NULL,NULL,NULL,NULL,'现付','12312'), ('38','入库','采购','3','123132','季圣华','2016-12-24 23:14:22','2016-12-24 00:00:00','1','1','9','-44',NULL,'-24','现付','312'), ('39','入库','采购','3','222','季圣华','2016-12-24 23:43:50','2016-12-24 00:00:00','4','2','9','-44',NULL,'-85.8','现付','3333'), ('41','入库','采购','1','555','季圣华','2017-01-02 15:53:30','2017-01-02 00:00:00','1','2','9','-66',NULL,'-22','现付',''), ('46','入库','采购','1','555','季圣华','2017-01-02 21:11:45','2017-01-02 00:00:00','1','2','9','-44',NULL,'-26.4','现付',''), ('47','入库','采购','1','66','季圣华','2017-01-02 21:13:01','2017-01-02 00:00:00','1','2','9','-66',NULL,'-66','现付',''), ('48','入库','采购','1','344','季圣华','2017-01-02 21:27:19','2017-01-02 00:00:00','1','1','4','-22',NULL,'-176','现付','3444'), ('49','入库','采购','1','333','季圣华','2017-01-02 21:33:19','2017-01-02 00:00:00','1','2','9','-66',NULL,'-66','现付','333'), ('50','入库','采购','1','4444','季圣华','2017-01-02 21:58:30','2017-01-02 00:00:00','1','1','9','-55',NULL,'-44','现付',''), ('51','入库','采购','1','aaa','季圣华','2017-01-07 18:25:33','2017-01-07 00:00:00','1','1','9','-55',NULL,'-55','现付','bbb'), ('52','出库','销售','1','aaa','季圣华','2017-01-08 10:49:21','2017-01-08 00:00:00','2','2','9','266',NULL,'266','现付','yayaya'), ('53','入库','销售退货','1','dddd','季圣华','2017-01-08 10:50:58','2017-01-08 00:00:00','2','2','9','-2',NULL,'-2','现付',''), ('54','入库','其它','1','abcde22','季圣华','2017-01-08 10:56:45','2017-01-08 00:00:00','4','2',NULL,NULL,NULL,'444','现付','aaaaa33'), ('56','入库','其它','1','AAF','季圣华','2017-01-08 11:50:13','2017-01-08 00:00:00','1','1',NULL,NULL,NULL,'64','现付','234234aa'), ('57','出库','其它','1','666aaa','季圣华','2017-01-08 11:53:00','2017-01-08 00:00:00','2','1',NULL,NULL,NULL,'66','现付','777bbb'), ('58','出库','采购退货','1','34234ww','季圣华','2017-01-08 11:53:58','2017-01-08 00:00:00','1','2','9','44',NULL,'44','现付','3w3w'), ('59','入库','采购','1','22','季圣华','2017-01-08 11:55:00','2017-01-08 00:00:00','1','1','9','-1324',NULL,'-1324','现付','33'), ('60','入库','销售退货','1','we','季圣华','2017-01-08 11:55:53','2017-01-08 00:00:00','5','1','9','-122',NULL,'-122','现付','wewe'), ('61','出库','其它','1','rrrr','季圣华','2017-01-08 11:58:58','2017-01-08 00:00:00','2','1',NULL,NULL,NULL,'66','现付','bbbb'), ('63','出库','调拨','1','aaaa','季圣华','2017-01-08 12:22:19','2017-01-08 00:00:00',NULL,'1',NULL,NULL,'3','42','现付','bbbb'), ('64','出库','调拨','1','42342qqq','季圣华','2017-01-08 12:33:19','2017-01-08 00:00:00',NULL,'2',NULL,NULL,'3','255','现付','wqer'), ('65','出库','调拨','3','42aa','季圣华','2017-01-08 12:33:46','2017-01-08 00:00:00',NULL,'2',NULL,NULL,'1','121','现付','2323bbbbb'), ('67','入库','采购','1','abcdefg','季圣华','2017-01-08 16:46:53','2017-01-08 00:00:00','4','1','9','-120',NULL,'-120','现付','aaawww'), ('68','出库','销售','1','asdfasdf','季圣华','2017-01-08 18:58:35','2017-01-08 00:00:00','2','1','9','44',NULL,'44','现付','asdfasdf'), ('69','入库','采购','1','x123','季圣华','2017-01-21 10:53:57','2017-01-21 00:00:00','1','1','9','-55',NULL,'-55','现付','aaaa1234'), ('70','出库','销售','3','aaa','季圣华','2017-04-08 13:31:17','2017-04-08 00:00:00','5','2','9','100',NULL,'633','现付',''), ('71','出库','销售','1','aaa123','季圣华','2017-04-09 16:19:22','2017-04-09 00:00:00','6','1','9','20',NULL,'333','现付',''), ('72','入库','采购','1','22aa','季圣华','2017-06-03 22:25:59','2017-06-03 00:00:00','1','2','9','-18',NULL,'-18','现付',''), ('73','出库','销售','1','afds123','季圣华','2017-06-03 22:29:35','2017-06-03 00:00:00','5','2','4','10',NULL,'10','现付',''), ('74','入库','销售退货','1','dsfs','季圣华','2017-06-03 22:47:31','2017-06-03 00:00:00','5','2','4','-5',NULL,'-5','现付',''), ('76','入库','采购','1','asdf','季圣华','2017-06-03 23:00:53','2017-06-03 00:00:00','1','2','4','-10',NULL,'-20','现付',''), ('77','出库','销售','3','22aa','季圣华','2017-06-05 00:13:47','2017-06-05 00:00:00','2','1','4','22',NULL,'26.8','现付',''), ('80','出库','零售','1','sfsdf','季圣华','2017-06-18 19:35:34','2017-06-18 00:00:00','2','2','4','24',NULL,'24','现付','sdf'), ('81','入库','零售退货','1','fsfsd','季圣华','2017-06-18 19:36:33','2017-06-18 00:00:00','2','1','4','-33',NULL,'-33','现付','sfd'), ('82','出库','零售','1','fasdf','季圣华','2017-06-18 19:53:49','2017-06-18 00:00:00','2','1','9','44',NULL,'44','现付',''), ('83','出库','零售','3','qwe3','季圣华','2017-06-18 22:56:17','2017-06-18 00:00:00','2','1','4','4',NULL,'4','现付','123123'), ('85','出库','零售','1','1233','季圣华','2017-06-20 00:34:45','2017-06-20 00:00:00','5','2','4','36',NULL,'36','现付','2314124'), ('86','出库','零售','1','hb3124312431','季圣华','2017-06-20 21:56:51','2017-06-20 00:00:00','9','1','4','11',NULL,'11','现付','beizhubeizhu123123'), ('87','出库','零售','1','LSCK20170620225532','季圣华','2017-06-20 22:03:32','2017-06-20 00:00:00','7','1','4','1',NULL,'1','现付','31312BEIZHU'), ('88','出库','零售','1','LSCK2017062023934','季圣华','2017-06-20 23:09:53','2017-06-20 00:00:00','8','1','4','2',NULL,'2','现付','12单据备注单据备注单据备注单据备注单据备注'), ('89','出库','零售','1','LSCK20170620232023','季圣华','2017-06-20 23:20:39','2017-06-20 00:00:00','7','2','4','1',NULL,'1','现付','beizhu11'), ('90','出库','零售','1','LSCK20170620234528','季圣华','2017-06-20 23:47:15','2017-06-20 00:00:00','8','1','4','24.31',NULL,'24.31','现付',''), ('91','出库','销售','1','XSCK20170621215516','季圣华','2017-06-21 21:55:50','2017-06-21 00:00:00','2','1','4','1.2',NULL,'1.2','现付',''), ('92','出库','零售','1','LSCK20170621232052','季圣华','2017-06-21 23:21:37','2017-06-21 00:00:00','8','1','4','4.6',NULL,'4.6','现付',''), ('103','出库','零售','1','LSCK20170629029','季圣华','2017-06-29 00:02:24','2017-06-29 00:00:00','8','1','9','12',NULL,'12','预付款','21341');
INSERT INTO `jsh_depotitem` VALUES ('1017','31','485','100','0.61','61','','',NULL), ('1018','32','498','1','0.9','0.9','','',NULL), ('1019','33','487','1','2',NULL,'','',NULL), ('1025','38','485','12','2','24','',NULL,NULL), ('1026','39','498','22','2.1','46.2','',NULL,NULL), ('1027','39','487','33','1.2','39.6','',NULL,NULL), ('1029','41','487','11','2','22','',NULL,NULL), ('1032','46','498','22','1.2','26.4','',NULL,NULL), ('1033','47','487','66','1','66','',NULL,NULL), ('1034','48','485','44','4','176','',NULL,NULL), ('1035','49','498','33','2','66','',NULL,NULL), ('1036','50','485','44','1','44','',NULL,NULL), ('1037','51','487','11','3','33','',NULL,NULL), ('1038','51','498','22','1','22','',NULL,NULL), ('1039','52','487','2','2','4','',NULL,NULL), ('1040','53','487','1','2','2','',NULL,NULL), ('1041','54','485','222','2','444','',NULL,NULL), ('1042','56','498','33','1.94','64','',NULL,NULL), ('1043','57','498','22','3','66','',NULL,NULL), ('1044','58','498','44','1','44','',NULL,NULL), ('1045','59','498','2244','0.59','1324','',NULL,NULL), ('1046','60','485','61','2','122','aaaaaa',NULL,NULL), ('1047','52','487','31','2','62','',NULL,NULL), ('1048','61','498','33','2','66','',NULL,NULL), ('1050','63','498','21','2','42','',NULL,NULL), ('1051','64','498','233','1','233','',NULL,NULL), ('1052','65','498','33','1','33','',NULL,NULL), ('1053','65','485','44','2','88','',NULL,NULL), ('1054','64','485','22','1','22','',NULL,NULL), ('1056','67','487','60','2','120','',NULL,NULL), ('1057','52','485','100','2','200','',NULL,NULL), ('1058','68','498','22','2','44','',NULL,NULL), ('1059','69','487','22','2','44','',NULL,NULL), ('1060','69','498','11','1','11','',NULL,NULL), ('1061','70','487','211','3','633','',NULL,NULL), ('1062','71','498','333','1','333','',NULL,NULL), ('1063','72','499','20','0.9','18','',NULL,NULL), ('1064','73','499','10','1','10','',NULL,NULL), ('1065','74','499','5','1','5','',NULL,NULL), ('1067','76','499','20','1','20','',NULL,NULL), ('1068','77','499','11','2.2','24.2','',NULL,NULL), ('1069','77','498','2','1.3','2.6','',NULL,NULL), ('1072','80','485','12','2','24','sdfsd',NULL,NULL), ('1073','81','485','11','3','33','',NULL,NULL), ('1074','82','487','22','2','44','',NULL,NULL), ('1075','83','498','2','2','4','',NULL,NULL), ('1077','85','498','12','3','36','',NULL,NULL), ('1078','86','498','11','1','11','',NULL,NULL), ('1079','87','487','1','1','1','',NULL,NULL), ('1080','88','487','1','2','2','',NULL,NULL), ('1081','89','498','1','1','1','',NULL,NULL), ('1082','90','498','11','2.21','24.31','',NULL,NULL), ('1083','91','498','1','1.2','1.2','',NULL,NULL), ('1084','92','487','1','1','1','',NULL,NULL), ('1085','92','498','1','1.2','1.2','',NULL,NULL), ('1086','92','498','2','1.2','2.4','',NULL,NULL), ('1097','103','498','10','1.2','12','',NULL,NULL);
INSERT INTO `jsh_functions` VALUES ('1','00','系统管理','0','','','0010','','电脑版'), ('2','01','基础数据','0','','','0020','','电脑版'), ('3','02','进销存','0','','','0030','','电脑版'), ('11','0001','系统管理','00','','\0','0110','','电脑版'), ('12','000101','应用管理','0001','../manage/app.jsp','\0','0132','','电脑版'), ('13','000102','角色管理','0001','../manage/role.jsp','\0','0130','','电脑版'), ('14','000103','用户管理','0001','../manage/user.jsp','\0','0140','','电脑版'), ('15','000104','日志管理','0001','../manage/log.jsp','\0','0160','','电脑版'), ('16','000105','功能管理','0001','../manage/functions.jsp','\0','0135','','电脑版'), ('21','0101','商品管理','01','','\0','0220','','电脑版'), ('22','010101','商品类别管理','0101','../materials/materialcategory.jsp','\0','0230','','电脑版'), ('23','010102','商品信息管理','0101','../materials/material.jsp','\0','0240','','电脑版'), ('24','0102','基本资料','01','','\0','0250','','电脑版'), ('25','010201','单位信息','0102','../manage/vendor.jsp','\0','0260','','电脑版'), ('26','010202','仓库管理','0102','../manage/depot.jsp','\0','0270','','电脑版'), ('31','010206','经手人管理','0102','../materials/person.jsp','\0','0284','','电脑版'), ('32','0202','入库管理','02','','\0','0330','','电脑版'), ('33','020201','采购入库','0202','../materials/purchase_in_list.jsp','\0','0340','','电脑版'), ('38','0203','出库管理','02','','\0','0390','','电脑版'), ('40','020306','调拨出库','0203','../materials/allocation_out_list.jsp','\0','0420','','电脑版'), ('41','020303','销售出库','0203','../materials/sale_out_list.jsp','\0','0410','','电脑版'), ('44','0204','财务管理','02','','\0','0450','','电脑版'), ('59','030101','库存状况','0301','../reports/in_out_stock_report.jsp','\0','0600','','电脑版'), ('194','010204','收支项目','0102','../manage/inOutItem.jsp','\0','0282','','电脑版'), ('195','010205','结算账户','0102','../manage/account.jsp','\0','0283','','电脑版'), ('196','03','报表查询','0','','','0040','','电脑版'), ('197','020402','收入单','0204','../financial/item_in.jsp','\0','0465','','电脑版'), ('198','0301','报表查询','03','','\0','0570','','电脑版'), ('199','020304','采购退货','0203','../materials/purchase_back_list.jsp','\0','0415','','电脑版'), ('200','020203','销售退货','0202','../materials/sale_back_list.jsp','\0','0350','','电脑版'), ('201','020204','其它入库','0202','../materials/other_in_list.jsp','\0','0360','','电脑版'), ('202','020305','其它出库','0203','../materials/other_out_list.jsp','\0','0418','','电脑版'), ('203','020403','支出单','0204','../financial/item_out.jsp','\0','0470','','电脑版'), ('204','020404','收款单','0204','../financial/money_in.jsp','\0','0475','','电脑版'), ('205','020405','付款单','0204','../financial/money_out.jsp','\0','0480','','电脑版'), ('206','020406','转账单','0204','../financial/giro.jsp','\0','0490','','电脑版'), ('207','030102','结算账户','0301','../reports/account_report.jsp','\0','0610','','电脑版'), ('208','030103','进货统计','0301','../reports/buy_in_report.jsp','\0','0620','','电脑版'), ('209','030104','销售统计','0301','../reports/sale_out_report.jsp','\0','0630','','电脑版'), ('210','020302','零售出库','0203','../materials/retail_out_list.jsp','\0','0405','','电脑版'), ('211','020202','零售退货','0202','../materials/retail_back_list.jsp','\0','0345','','电脑版'), ('212','020407','收预付款','0204','../financial/advance_in.jsp','\0','0495','','电脑版');
INSERT INTO `jsh_inoutitem` VALUES ('1','办公耗材','支出','办公耗材'), ('5','房租收入','收入','房租收入'), ('7','利息收入','收入','利息收入'), ('8','水电费','支出','水电费水电费'), ('9','快递费','支出','快递费'), ('10','交通报销费','支出','交通报销费'), ('11','差旅费','支出','差旅费'), ('12','全车贴膜-普通','收入',''), ('13','全车贴膜-高档','收入',''), ('14','洗车','收入',''), ('15','保养汽车','收入','');
INSERT INTO `jsh_log` VALUES ('1722','63','登录系统','192.168.1.104','2016-11-27 13:17:17','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1723','63','登录系统','192.168.1.104','2016-11-27 13:17:30','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1724','63','退出系统','192.168.1.104','2016-11-27 13:17:48','0','管理用户：jsh 退出系统','jsh 退出系统'), ('1725','65','登录系统','192.168.1.104','2016-11-27 13:17:52','0','管理用户：ls 登录系统','ls 登录系统'), ('1726','65','退出系统','192.168.1.104','2016-11-27 13:18:18','0','管理用户：ls 退出系统','ls 退出系统'), ('1727','63','登录系统','192.168.1.104','2016-11-27 13:18:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1728','63','更新UserBusiness','192.168.1.104','2016-11-27 13:18:44','0','更新UserBusiness的ID为  6 成功！','更新UserBusiness成功'), ('1729','63','退出系统','192.168.1.104','2016-11-27 13:18:48','0','管理用户：jsh 退出系统','jsh 退出系统'), ('1730','65','登录系统','192.168.1.104','2016-11-27 13:18:53','0','管理用户：ls 登录系统','ls 登录系统'), ('1731','63','登录系统','192.168.1.104','2016-12-04 10:38:50','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1732','63','增加物料','192.168.1.104','2016-12-04 10:40:52','0','增加物料名称为  11 成功！','增加物料成功'), ('1733','63','更新物料','192.168.1.104','2016-12-04 10:59:57','0','更新物料ID为  499 成功！','更新物料成功'), ('1734','63','更新物料','192.168.1.104','2016-12-04 11:00:13','0','更新物料ID为  499 成功！','更新物料成功'), ('1735','63','删除物料','192.168.1.104','2016-12-04 11:00:38','0','删除物料ID为  499 成功！','删除物料成功'), ('1736','63','增加物料','192.168.1.104','2016-12-04 11:02:35','0','增加物料名称为  11 成功！','增加物料成功'), ('1737','63','批量删除物料','192.168.1.104','2016-12-04 11:02:41','0','批量删除物料ID为  500 成功！','批量删除物料成功'), ('1738','63','更新功能','192.168.1.104','2016-12-04 11:04:43','0','更新功能ID为  26 成功！','更新功能成功'), ('1739','63','增加供应商','192.168.1.104','2016-12-04 11:38:13','0','增加供应商名称为  aa 成功！','增加供应商成功'), ('1740','63','增加供应商','192.168.1.104','2016-12-04 11:48:36','0','增加供应商名称为  aaaa 成功！','增加供应商成功'), ('1741','63','删除供应商','192.168.1.104','2016-12-04 11:48:53','0','删除供应商ID为  3,名称为  aa成功！','删除供应商成功'), ('1742','63','更新供应商','192.168.1.104','2016-12-04 11:48:59','0','更新供应商ID为  4 成功！','更新供应商成功'), ('1743','63','更新功能','192.168.1.104','2016-12-04 13:06:24','0','更新功能ID为  31 成功！','更新功能成功'), ('1744','63','删除功能','192.168.1.104','2016-12-04 13:06:47','0','删除功能ID为  30 成功！','删除功能成功'), ('1745','63','更新功能','192.168.1.104','2016-12-04 13:08:35','0','更新功能ID为  24 成功！','更新功能成功'), ('1746','63','更新功能','192.168.1.104','2016-12-04 13:09:52','0','更新功能ID为  24 成功！','更新功能成功'), ('1747','63','更新功能','192.168.1.104','2016-12-04 13:11:00','0','更新功能ID为  21 成功！','更新功能成功'), ('1748','63','更新功能','192.168.1.104','2016-12-04 13:11:08','0','更新功能ID为  22 成功！','更新功能成功'), ('1749','63','更新功能','192.168.1.104','2016-12-04 13:11:16','0','更新功能ID为  23 成功！','更新功能成功'), ('1750','63','更新功能','192.168.1.104','2016-12-04 13:11:31','0','更新功能ID为  23 成功！','更新功能成功'), ('1751','63','更新应用','192.168.1.104','2016-12-04 13:34:39','0','更新应用ID为  22 成功！','更新应用成功'), ('1752','63','更新应用','192.168.1.104','2016-12-04 13:35:13','0','更新应用ID为  22 成功！','更新应用成功'), ('1753','63','登录系统','192.168.1.104','2016-12-04 13:36:45','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1754','63','登录系统','192.168.1.104','2016-12-04 13:38:31','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1755','63','增加功能','192.168.1.104','2016-12-04 13:40:10','0','增加功能名称为  报表管理 成功！','增加功能成功'), ('1756','63','更新功能','192.168.1.104','2016-12-04 13:40:38','0','更新功能ID为  58 成功！','更新功能成功'), ('1757','63','更新功能','192.168.1.104','2016-12-04 13:40:54','0','更新功能ID为  59 成功！','更新功能成功'), ('1758','63','更新应用','192.168.1.104','2016-12-04 13:42:15','0','更新应用ID为  22 成功！','更新应用成功'), ('1759','63','更新功能','192.168.1.104','2016-12-04 13:43:23','0','更新功能ID为  58 成功！','更新功能成功'), ('1760','63','更新应用','192.168.1.104','2016-12-04 13:43:44','0','更新应用ID为  22 成功！','更新应用成功'), ('1761','63','更新应用','192.168.1.104','2016-12-04 13:47:17','0','更新应用ID为  22 成功！','更新应用成功'), ('1762','63','登录系统','192.168.112.102','2016-12-04 21:00:14','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1763','63','更新应用','192.168.112.102','2016-12-04 21:01:40','0','更新应用ID为  7 成功！','更新应用成功'), ('1764','63','更新应用','192.168.112.102','2016-12-04 21:02:40','0','更新应用ID为  7 成功！','更新应用成功'), ('1765','63','登录系统','192.168.112.102','2016-12-04 21:14:18','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1766','63','登录系统','192.168.112.102','2016-12-04 21:49:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1767','63','登录系统','192.168.4.108','2016-12-10 14:24:27','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1768','63','登录系统','192.168.4.108','2016-12-10 14:30:33','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1769','63','退出系统','192.168.4.108','2016-12-10 14:31:27','0','管理用户：jsh 退出系统','jsh 退出系统'), ('1770','63','登录系统','192.168.4.108','2016-12-10 14:31:33','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1771','63','增加经手人','192.168.4.108','2016-12-10 14:55:24','0','增加经手人名称为  赵五-财务 成功！','增加经手人成功'), ('1772','63','更新经手人','192.168.4.108','2016-12-10 14:55:33','0','更新经手人ID为  2 成功！','更新经手人成功'), ('1773','63','更新经手人','192.168.4.108','2016-12-10 14:55:45','0','更新经手人ID为  1 成功！','更新经手人成功'), ('1774','63','增加功能','192.168.4.108','2016-12-10 15:29:27','0','增加功能名称为  收入单 成功！','增加功能成功'), ('1775','63','更新UserBusiness','192.168.4.108','2016-12-10 15:30:47','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功'), ('1776','63','更新功能','192.168.4.108','2016-12-10 15:35:04','0','更新功能ID为  58 成功！','更新功能成功'), ('1777','63','更新功能','192.168.4.108','2016-12-10 15:35:59','0','更新功能ID为  58 成功！','更新功能成功'), ('1778','63','更新功能','192.168.4.108','2016-12-10 15:37:40','0','更新功能ID为  196 成功！','更新功能成功'), ('1779','63','更新功能','192.168.4.108','2016-12-10 15:39:07','0','更新功能ID为  196 成功！','更新功能成功'), ('1780','63','更新功能','192.168.4.108','2016-12-10 15:39:23','0','更新功能ID为  59 成功！','更新功能成功'), ('1781','63','删除功能','192.168.4.108','2016-12-10 15:39:45','0','删除功能ID为  58 成功！','删除功能成功'), ('1782','63','更新功能','192.168.4.108','2016-12-10 15:40:03','0','更新功能ID为  59 成功！','更新功能成功'), ('1783','63','更新UserBusiness','192.168.4.108','2016-12-10 15:41:52','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功'), ('1784','63','增加功能','192.168.4.108','2016-12-10 15:44:39','0','增加功能名称为  报表管理 成功！','增加功能成功'), ('1785','63','更新功能','192.168.4.108','2016-12-10 15:44:51','0','更新功能ID为  59 成功！','更新功能成功'), ('1786','63','更新功能','192.168.4.108','2016-12-10 15:46:30','0','更新功能ID为  198 成功！','更新功能成功'), ('1787','63','增加经手人','192.168.4.108','2016-12-10 16:48:36','0','增加经手人名称为  赵六-财务 成功！','增加经手人成功'), ('1788','63','更新经手人','192.168.4.108','2016-12-10 16:48:43','0','更新经手人ID为  3 成功！','更新经手人成功'), ('1789','63','更新经手人','192.168.4.108','2016-12-10 16:48:49','0','更新经手人ID为  3 成功！','更新经手人成功'), ('1790','63','增加仓库','192.168.4.108','2016-12-10 16:59:41','0','增加仓库名称为  总部 成功！','增加仓库成功'), ('1791','63','更新仓库','192.168.4.108','2016-12-10 16:59:52','0','更新仓库ID为  2 成功！','更新仓库成功'), ('1792','63','更新仓库','192.168.4.108','2016-12-10 17:00:03','0','更新仓库ID为  1 成功！','更新仓库成功'), ('1793','63','更新经手人','192.168.4.108','2016-12-10 17:00:15','0','更新经手人ID为  3 成功！','更新经手人成功'), ('1794','63','更新经手人','192.168.4.108','2016-12-10 17:00:23','0','更新经手人ID为  4 成功！','更新经手人成功'), ('1795','63','登录系统','192.168.4.108','2016-12-10 17:10:40','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1796','63','退出系统','192.168.4.108','2016-12-10 17:39:05','0','管理用户：jsh 退出系统','jsh 退出系统'), ('1797','63','登录系统','192.168.4.108','2016-12-10 17:39:16','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1798','63','批量删除功能','192.168.4.108','2016-12-10 17:44:39','0','批量删除功能ID为  51,193 成功！','批量删除功能成功'), ('1799','63','批量删除功能','192.168.4.108','2016-12-10 17:44:54','0','批量删除功能ID为  46,47,48,49,50 成功！','批量删除功能成功'), ('1800','63','批量删除功能','192.168.4.108','2016-12-10 17:45:26','0','批量删除功能ID为  52,53,54,55 成功！','批量删除功能成功'), ('1801','63','批量删除功能','192.168.4.108','2016-12-10 17:45:49','0','批量删除功能ID为  45 成功！','批量删除功能成功'), ('1802','63','登录系统','192.168.112.102','2016-12-10 20:19:13','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1803','63','增加财务','192.168.112.102','2016-12-10 20:20:06','0','增加财务编号为  33 成功！','增加财务成功'), ('1804','63','增加财务','192.168.112.102','2016-12-10 20:20:11','0','增加财务编号为  33 成功！','增加财务成功'), ('1805','63','增加财务','192.168.112.102','2016-12-10 20:20:12','0','增加财务编号为  33 成功！','增加财务成功'), ('1806','63','增加财务','192.168.112.102','2016-12-10 20:25:48','0','增加财务编号为  123 成功！','增加财务成功'), ('1807','63','登录系统','192.168.112.102','2016-12-10 20:50:11','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1808','63','增加财务','192.168.112.102','2016-12-10 20:51:41','0','增加财务编号为  3123 成功！','增加财务成功'), ('1809','63','增加财务','192.168.112.102','2016-12-10 20:53:58','0','增加财务编号为  3123 成功！','增加财务成功'), ('1810','63','增加财务','192.168.112.102','2016-12-10 21:08:57','0','增加财务编号为  123 成功！','增加财务成功'), ('1811','63','增加财务','192.168.112.102','2016-12-10 21:47:45','0','增加财务编号为  123 成功！','增加财务成功'), ('1812','63','保存财务明细','192.168.112.102','2016-12-10 21:47:46','0','保存财务明细对应主表编号为  8 成功！','保存财务明细成功'), ('1813','63','登录系统','192.168.112.102','2016-12-10 22:49:54','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1814','63','删除财务','192.168.112.102','2016-12-10 22:52:43','0','删除财务ID为  5 成功！','删除财务成功'), ('1815','63','批量删除财务','192.168.112.102','2016-12-10 22:52:49','0','批量删除财务ID为  4 成功！','批量删除财务成功'), ('1816','63','增加财务','192.168.112.102','2016-12-10 22:53:19','0','增加财务编号为  3134 成功！','增加财务成功'), ('1817','63','保存财务明细','192.168.112.102','2016-12-10 22:53:20','0','保存财务明细对应主表编号为  9 成功！','保存财务明细成功'), ('1818','63','删除财务','192.168.112.102','2016-12-10 22:53:35','0','删除财务ID为  7 成功！','删除财务成功'), ('1819','63','增加财务','192.168.112.102','2016-12-10 22:54:05','0','增加财务编号为  N123 成功！','增加财务成功'), ('1820','63','保存财务明细','192.168.112.102','2016-12-10 22:54:06','0','保存财务明细对应主表编号为  10 成功！','保存财务明细成功'), ('1821','63','更新财务','192.168.112.102','2016-12-10 22:54:28','0','更新财务ID为  10 成功！','更新财务成功');
INSERT INTO `jsh_log` VALUES ('1822','63','更新财务','192.168.112.102','2016-12-10 23:06:54','0','更新财务ID为  10 成功！','更新财务成功'), ('1823','63','增加财务','192.168.112.102','2016-12-10 23:07:51','0','增加财务编号为  124 成功！','增加财务成功'), ('1824','63','保存财务明细','192.168.112.102','2016-12-10 23:07:51','0','保存财务明细对应主表编号为  11 成功！','保存财务明细成功'), ('1825','63','登录系统','192.168.112.102','2016-12-10 23:09:32','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1826','63','更新财务','192.168.112.102','2016-12-10 23:09:55','0','更新财务ID为  10 成功！','更新财务成功'), ('1827','63','更新收支项目','192.168.112.102','2016-12-10 23:10:18','0','更新收支项目ID为  7 成功！','更新收支项目成功'), ('1828','63','更新收支项目','192.168.112.102','2016-12-10 23:10:32','0','更新收支项目ID为  5 成功！','更新收支项目成功'), ('1829','63','更新收支项目','192.168.112.102','2016-12-10 23:10:47','0','更新收支项目ID为  1 成功！','更新收支项目成功'), ('1830','63','增加收支项目','192.168.112.102','2016-12-10 23:11:05','0','增加收支项目名称为  水电费 成功！','增加收支项目成功'), ('1831','63','增加收支项目','192.168.112.102','2016-12-10 23:11:18','0','增加收支项目名称为  快递费 成功！','增加收支项目成功'), ('1832','63','增加收支项目','192.168.112.102','2016-12-10 23:11:30','0','增加收支项目名称为  交通报销费 成功！','增加收支项目成功'), ('1833','63','增加收支项目','192.168.112.102','2016-12-10 23:11:50','0','增加收支项目名称为  差旅费 成功！','增加收支项目成功'), ('1834','63','增加财务','192.168.112.102','2016-12-10 23:12:45','0','增加财务编号为  NO123 成功！','增加财务成功'), ('1835','63','保存财务明细','192.168.112.102','2016-12-10 23:12:46','0','保存财务明细对应主表编号为  12 成功！','保存财务明细成功'), ('1836','63','更新财务','192.168.112.102','2016-12-10 23:27:12','0','更新财务ID为  12 成功！','更新财务成功'), ('1837','63','更新财务','192.168.112.102','2016-12-10 23:27:46','0','更新财务ID为  12 成功！','更新财务成功'), ('1838','63','登录系统','192.168.112.102','2016-12-10 23:29:10','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1839','63','更新财务','192.168.112.102','2016-12-10 23:30:01','0','更新财务ID为  12 成功！','更新财务成功'), ('1840','63','更新财务','192.168.112.102','2016-12-10 23:30:43','0','更新财务ID为  12 成功！','更新财务成功'), ('1841','63','更新财务','192.168.112.102','2016-12-10 23:31:17','0','更新财务ID为  12 成功！','更新财务成功'), ('1842','63','更新财务','192.168.112.102','2016-12-10 23:38:58','0','更新财务ID为  12 成功！','更新财务成功'), ('1843','63','更新财务','192.168.112.102','2016-12-10 23:42:13','0','更新财务ID为  12 成功！','更新财务成功'), ('1844','63','登录系统','192.168.112.102','2016-12-10 23:45:16','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1845','63','更新财务','192.168.112.102','2016-12-10 23:45:34','0','更新财务ID为  12 成功！','更新财务成功'), ('1846','63','增加财务','192.168.112.102','2016-12-10 23:46:22','0','增加财务编号为  12312 成功！','增加财务成功'), ('1847','63','保存财务明细','192.168.112.102','2016-12-10 23:46:23','0','保存财务明细对应主表编号为  13 成功！','保存财务明细成功'), ('1848','63','更新财务','192.168.112.102','2016-12-10 23:46:50','0','更新财务ID为  13 成功！','更新财务成功'), ('1849','63','删除财务','192.168.112.102','2016-12-10 23:47:54','1','删除财务ID为  9 失败！','删除财务失败'), ('1850','63','删除财务','192.168.112.102','2016-12-10 23:48:00','1','删除财务ID为  10 失败！','删除财务失败'), ('1851','63','批量删除财务','192.168.112.102','2016-12-10 23:48:07','1','批量删除财务ID为  10 失败！','批量删除财务失败'), ('1852','63','删除财务','192.168.112.102','2016-12-10 23:53:36','0','删除财务ID为  10 成功！','删除财务成功'), ('1853','63','删除财务','192.168.112.102','2016-12-10 23:53:39','0','删除财务ID为  8 成功！','删除财务成功'), ('1854','63','批量删除财务','192.168.112.102','2016-12-10 23:53:44','0','批量删除财务ID为  6 成功！','批量删除财务成功'), ('1855','63','登录系统','192.168.4.107','2016-12-11 09:50:41','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1856','63','删除财务','192.168.4.107','2016-12-11 09:51:09','0','删除财务ID为  11 成功！','删除财务成功'), ('1857','63','增加财务','192.168.4.107','2016-12-11 09:51:42','0','增加财务编号为  N666 成功！','增加财务成功'), ('1858','63','保存财务明细','192.168.4.107','2016-12-11 09:51:43','0','保存财务明细对应主表编号为  13 成功！','保存财务明细成功'), ('1859','63','批量删除功能','192.168.4.107','2016-12-11 10:08:23','0','批量删除功能ID为  34,35,36,37,39 成功！','批量删除功能成功'), ('1860','63','批量删除功能','192.168.4.107','2016-12-11 10:08:49','0','批量删除功能ID为  42,43 成功！','批量删除功能成功'), ('1861','63','更新功能','192.168.4.107','2016-12-11 10:15:14','0','更新功能ID为  40 成功！','更新功能成功'), ('1862','63','更新功能','192.168.4.107','2016-12-11 10:15:32','0','更新功能ID为  41 成功！','更新功能成功'), ('1863','63','更新功能','192.168.4.107','2016-12-11 10:17:58','0','更新功能ID为  3 成功！','更新功能成功'), ('1864','63','更新功能','192.168.4.107','2016-12-11 10:18:32','0','更新功能ID为  3 成功！','更新功能成功'), ('1865','63','删除功能','192.168.4.107','2016-12-11 10:18:56','0','删除功能ID为  10 成功！','删除功能成功'), ('1866','63','更新功能','192.168.4.107','2016-12-11 10:20:32','0','更新功能ID为  196 成功！','更新功能成功'), ('1867','63','更新功能','192.168.4.107','2016-12-11 10:33:16','0','更新功能ID为  15 成功！','更新功能成功'), ('1868','63','更新功能','192.168.4.107','2016-12-11 10:34:36','0','更新功能ID为  14 成功！','更新功能成功'), ('1869','63','登录系统','192.168.4.107','2016-12-11 14:36:43','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1870','63','增加功能','192.168.4.107','2016-12-11 15:11:33','0','增加功能名称为  入库退货 成功！','增加功能成功'), ('1871','63','增加功能','192.168.4.107','2016-12-11 15:12:44','0','增加功能名称为  销售退货 成功！','增加功能成功'), ('1872','63','更新功能','192.168.4.107','2016-12-11 15:13:08','0','更新功能ID为  199 成功！','更新功能成功'), ('1873','63','更新UserBusiness','192.168.4.107','2016-12-11 15:13:39','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功'), ('1874','63','增加功能','192.168.4.107','2016-12-11 15:20:11','0','增加功能名称为  其他入库 成功！','增加功能成功'), ('1875','63','增加功能','192.168.4.107','2016-12-11 15:21:11','0','增加功能名称为  其他出库 成功！','增加功能成功'), ('1876','63','更新UserBusiness','192.168.4.107','2016-12-11 15:21:26','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功'), ('1877','63','更新功能','192.168.4.107','2016-12-11 15:24:06','0','更新功能ID为  200 成功！','更新功能成功'), ('1878','63','更新功能','192.168.4.107','2016-12-11 15:24:43','0','更新功能ID为  199 成功！','更新功能成功'), ('1879','63','更新UserBusiness','192.168.4.107','2016-12-11 15:25:05','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功'), ('1880','63','更新UserBusiness','192.168.4.107','2016-12-11 15:25:28','0','更新UserBusiness的ID为  6 成功！','更新UserBusiness成功'), ('1881','63','更新功能','192.168.4.107','2016-12-11 15:27:25','0','更新功能ID为  197 成功！','更新功能成功'), ('1882','63','更新功能','192.168.4.107','2016-12-11 15:30:42','0','更新功能ID为  197 成功！','更新功能成功'), ('1883','63','增加功能','192.168.4.107','2016-12-11 15:31:43','0','增加功能名称为  支出单 成功！','增加功能成功'), ('1884','63','更新功能','192.168.4.107','2016-12-11 15:31:56','0','更新功能ID为  203 成功！','更新功能成功'), ('1885','63','更新UserBusiness','192.168.4.107','2016-12-11 15:32:12','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功'), ('1886','63','更新UserBusiness','192.168.4.107','2016-12-11 15:32:23','0','更新UserBusiness的ID为  6 成功！','更新UserBusiness成功'), ('1887','63','更新功能','192.168.4.107','2016-12-11 15:39:07','0','更新功能ID为  197 成功！','更新功能成功'), ('1888','63','更新功能','192.168.4.107','2016-12-11 15:39:14','0','更新功能ID为  203 成功！','更新功能成功'), ('1889','63','增加功能','192.168.4.107','2016-12-11 15:40:32','0','增加功能名称为  收款单 成功！','增加功能成功'), ('1890','63','增加功能','192.168.4.107','2016-12-11 15:41:18','0','增加功能名称为  付款单 成功！','增加功能成功'), ('1891','63','增加功能','192.168.4.107','2016-12-11 15:42:11','0','增加功能名称为  转账单 成功！','增加功能成功'), ('1892','63','更新功能','192.168.4.107','2016-12-11 15:42:26','0','更新功能ID为  204 成功！','更新功能成功'), ('1893','63','更新UserBusiness','192.168.4.107','2016-12-11 15:42:37','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功'), ('1894','63','更新功能','192.168.4.107','2016-12-11 15:43:50','0','更新功能ID为  206 成功！','更新功能成功'), ('1895','63','登录系统','192.168.112.100','2016-12-11 18:02:00','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1896','63','增加仓管通','192.168.112.100','2016-12-11 18:15:39','0','增加仓管通编号为  234234 成功！','增加仓管通成功'), ('1897','63','保存仓管通明细','192.168.112.100','2016-12-11 18:15:40','0','保存仓管通明细对应主表编号为  33 成功！','保存仓管通明细成功'), ('1898','63','更新功能','192.168.112.100','2016-12-11 18:23:48','0','更新功能ID为  201 成功！','更新功能成功'), ('1899','63','更新功能','192.168.112.100','2016-12-11 18:23:58','0','更新功能ID为  202 成功！','更新功能成功'), ('1900','63','增加仓管通','192.168.112.100','2016-12-11 18:44:50','0','增加仓管通编号为  1234 成功！','增加仓管通成功'), ('1901','63','保存仓管通明细','192.168.112.100','2016-12-11 18:44:51','0','保存仓管通明细对应主表编号为  34 成功！','保存仓管通明细成功'), ('1902','63','登录系统','192.168.112.100','2016-12-11 20:14:46','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1903','63','更新财务','192.168.112.100','2016-12-11 21:29:17','0','更新财务ID为  13 成功！','更新财务成功'), ('1904','63','更新财务','192.168.112.100','2016-12-11 21:29:47','0','更新财务ID为  13 成功！','更新财务成功'), ('1905','63','更新财务','192.168.112.100','2016-12-11 21:30:26','0','更新财务ID为  9 成功！','更新财务成功'), ('1906','63','更新财务','192.168.112.100','2016-12-11 21:32:31','0','更新财务ID为  13 成功！','更新财务成功'), ('1907','63','更新财务','192.168.112.100','2016-12-11 21:44:38','0','更新财务ID为  13 成功！','更新财务成功'), ('1908','63','登录系统','192.168.112.100','2016-12-11 21:50:51','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1909','63','更新财务','192.168.112.100','2016-12-11 21:51:18','0','更新财务ID为  13 成功！','更新财务成功'), ('1910','63','更新财务','192.168.112.100','2016-12-11 21:59:18','0','更新财务ID为  13 成功！','更新财务成功'), ('1911','63','保存财务明细','192.168.112.100','2016-12-11 21:59:19','0','保存财务明细对应主表编号为  13 成功！','保存财务明细成功'), ('1912','63','更新财务','192.168.112.100','2016-12-11 22:00:04','0','更新财务ID为  12 成功！','更新财务成功'), ('1913','63','保存财务明细','192.168.112.100','2016-12-11 22:00:05','0','保存财务明细对应主表编号为  12 成功！','保存财务明细成功'), ('1914','63','更新财务','192.168.112.100','2016-12-11 22:01:32','0','更新财务ID为  13 成功！','更新财务成功'), ('1915','63','保存财务明细','192.168.112.100','2016-12-11 22:01:33','0','保存财务明细对应主表编号为  13 成功！','保存财务明细成功'), ('1916','63','更新仓管通','192.168.112.100','2016-12-11 22:08:09','0','更新仓管通ID为  32 成功！','更新仓管通成功'), ('1917','63','保存仓管通明细','192.168.112.100','2016-12-11 22:08:09','0','保存仓管通明细对应主表编号为  32 成功！','保存仓管通明细成功'), ('1918','63','登录系统','192.168.112.100','2016-12-11 22:29:23','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1919','63','登录系统','192.168.112.100','2016-12-11 22:29:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1920','63','删除财务','192.168.112.100','2016-12-11 22:30:04','0','删除财务ID为  1 成功！','删除财务成功'), ('1921','63','批量删除财务','192.168.112.100','2016-12-11 22:30:09','0','批量删除财务ID为  2 成功！','批量删除财务成功');
INSERT INTO `jsh_log` VALUES ('1922','63','更新财务','192.168.112.100','2016-12-11 22:30:25','0','更新财务ID为  3 成功！','更新财务成功'), ('1923','63','更新财务','192.168.112.100','2016-12-11 22:30:35','0','更新财务ID为  3 成功！','更新财务成功'), ('1924','63','保存财务明细','192.168.112.100','2016-12-11 22:30:35','0','保存财务明细对应主表编号为  3 成功！','保存财务明细成功'), ('1925','63','更新财务','192.168.112.100','2016-12-11 22:30:44','0','更新财务ID为  3 成功！','更新财务成功'), ('1926','63','保存财务明细','192.168.112.100','2016-12-11 22:30:44','0','保存财务明细对应主表编号为  3 成功！','保存财务明细成功'), ('1927','63','更新财务','192.168.112.100','2016-12-11 22:30:53','0','更新财务ID为  3 成功！','更新财务成功'), ('1928','63','增加仓管通','192.168.112.100','2016-12-11 22:31:49','0','增加仓管通编号为  bbb 成功！','增加仓管通成功'), ('1929','63','保存仓管通明细','192.168.112.100','2016-12-11 22:31:50','0','保存仓管通明细对应主表编号为  35 成功！','保存仓管通明细成功'), ('1930','63','更新仓管通','192.168.112.100','2016-12-11 22:32:16','0','更新仓管通ID为  35 成功！','更新仓管通成功'), ('1931','63','增加仓管通','192.168.112.100','2016-12-11 22:32:52','0','增加仓管通编号为  bb22 成功！','增加仓管通成功'), ('1932','63','保存仓管通明细','192.168.112.100','2016-12-11 22:32:53','0','保存仓管通明细对应主表编号为  36 成功！','保存仓管通明细成功'), ('1933','63','增加财务','192.168.112.100','2016-12-11 22:37:44','0','增加财务编号为  aa 成功！','增加财务成功'), ('1934','63','保存财务明细','192.168.112.100','2016-12-11 22:37:45','0','保存财务明细对应主表编号为  14 成功！','保存财务明细成功'), ('1935','63','增加财务','192.168.112.100','2016-12-11 22:38:12','0','增加财务编号为  34124 成功！','增加财务成功'), ('1936','63','保存财务明细','192.168.112.100','2016-12-11 22:38:12','0','保存财务明细对应主表编号为  15 成功！','保存财务明细成功'), ('1937','63','增加财务','192.168.112.100','2016-12-11 22:38:44','0','增加财务编号为  234234 成功！','增加财务成功'), ('1938','63','保存财务明细','192.168.112.100','2016-12-11 22:38:44','0','保存财务明细对应主表编号为  16 成功！','保存财务明细成功'), ('1939','63','增加财务','192.168.112.100','2016-12-11 22:39:23','0','增加财务编号为  234 成功！','增加财务成功'), ('1940','63','保存财务明细','192.168.112.100','2016-12-11 22:39:23','0','保存财务明细对应主表编号为  17 成功！','保存财务明细成功'), ('1941','63','登录系统','192.168.1.103','2016-12-18 11:47:14','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1942','63','增加财务','192.168.1.103','2016-12-18 12:57:39','0','增加财务编号为  123123 成功！','增加财务成功'), ('1943','63','保存财务明细','192.168.1.103','2016-12-18 12:57:40','0','保存财务明细对应主表编号为  18 成功！','保存财务明细成功'), ('1944','63','更新供应商','192.168.1.103','2016-12-18 13:02:15','0','更新供应商ID为  4 成功！','更新供应商成功'), ('1945','63','更新财务','192.168.1.103','2016-12-18 13:02:40','0','更新财务ID为  18 成功！','更新财务成功'), ('1946','63','保存财务明细','192.168.1.103','2016-12-18 13:02:41','0','保存财务明细对应主表编号为  18 成功！','保存财务明细成功'), ('1947','63','更新财务','192.168.1.103','2016-12-18 13:03:01','0','更新财务ID为  18 成功！','更新财务成功'), ('1948','63','保存财务明细','192.168.1.103','2016-12-18 13:03:02','0','保存财务明细对应主表编号为  18 成功！','保存财务明细成功'), ('1949','63','更新财务','192.168.1.103','2016-12-18 13:05:58','0','更新财务ID为  15 成功！','更新财务成功'), ('1950','63','保存财务明细','192.168.1.103','2016-12-18 13:05:58','0','保存财务明细对应主表编号为  15 成功！','保存财务明细成功'), ('1951','63','登录系统','192.168.112.101','2016-12-18 21:32:52','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1952','63','更新UserBusiness','192.168.112.101','2016-12-18 22:00:16','0','更新UserBusiness的ID为  18 成功！','更新UserBusiness成功'), ('1953','63','登录系统','127.0.0.1','2016-12-20 12:30:58','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1954','63','登录系统','127.0.0.1','2016-12-20 12:45:18','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1955','63','登录系统','192.168.112.102','2016-12-23 22:08:55','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1956','63','增加仓管通','192.168.112.102','2016-12-23 23:12:33','1','增加仓管通编号为  wrwq 失败！','增加仓管通失败'), ('1957','63','登录系统','192.168.112.102','2016-12-24 08:45:28','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1958','63','登录系统','192.168.112.102','2016-12-24 12:12:45','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1959','63','增加仓库','192.168.112.102','2016-12-24 12:33:18','0','增加仓库名称为  苏州花边店 成功！','增加仓库成功'), ('1960','63','更新UserBusiness','192.168.112.102','2016-12-24 12:44:03','0','更新UserBusiness的ID为  18 成功！','更新UserBusiness成功'), ('1961','63','更新UserBusiness','192.168.112.102','2016-12-24 13:10:12','0','更新UserBusiness的ID为  18 成功！','更新UserBusiness成功'), ('1962','63','增加经手人','192.168.112.102','2016-12-24 13:28:51','1','增加经手人名称为   失败！','增加经手人失败'), ('1963','63','增加经手人','192.168.112.102','2016-12-24 13:36:27','0','增加经手人名称为   成功！','增加经手人成功'), ('1964','63','增加经手人','192.168.112.102','2016-12-24 13:40:00','0','增加经手人名称为   成功！','增加经手人成功'), ('1965','63','增加经手人','192.168.112.102','2016-12-24 13:40:06','0','增加经手人名称为   成功！','增加经手人成功'), ('1966','63','增加经手人','192.168.112.102','2016-12-24 13:42:26','0','增加经手人名称为   成功！','增加经手人成功'), ('1967','63','增加经手人','192.168.112.102','2016-12-24 13:45:11','0','增加经手人名称为   成功！','增加经手人成功'), ('1968','63','增加经手人','192.168.112.102','2016-12-24 13:46:29','0','增加经手人名称为   成功！','增加经手人成功'), ('1969','63','批量删除经手人','192.168.112.102','2016-12-24 13:48:20','0','批量删除经手人ID为  5,6,7,8,9,10 成功！','批量删除经手人成功'), ('1970','63','增加经手人','192.168.112.102','2016-12-24 13:49:03','0','增加经手人名称为  655aaaa 成功！','增加经手人成功'), ('1971','63','增加经手人','192.168.112.102','2016-12-24 13:50:08','0','增加经手人名称为  11111 成功！','增加经手人成功'), ('1972','63','删除经手人','192.168.112.102','2016-12-24 13:50:11','0','删除经手人ID为  12 成功！','删除经手人成功'), ('1973','63','删除经手人','192.168.112.102','2016-12-24 13:50:15','0','删除经手人ID为  11 成功！','删除经手人成功'), ('1974','63','增加经手人','192.168.112.102','2016-12-24 13:50:31','0','增加经手人名称为  rrrrr 成功！','增加经手人成功'), ('1975','63','更新经手人','192.168.112.102','2016-12-24 13:50:36','0','更新经手人ID为  13 成功！','更新经手人成功'), ('1976','63','删除经手人','192.168.112.102','2016-12-24 13:53:27','0','删除经手人ID为  13 成功！','删除经手人成功'), ('1977','63','删除经手人','192.168.112.102','2016-12-24 13:55:13','1','删除经手人ID为  2 失败！','删除经手人失败'), ('1978','63','删除经手人','192.168.112.102','2016-12-24 13:55:19','1','删除经手人ID为  2 失败！','删除经手人失败'), ('1979','63','增加经手人','192.168.112.102','2016-12-24 13:55:25','0','增加经手人名称为  123123 成功！','增加经手人成功'), ('1980','63','删除经手人','192.168.112.102','2016-12-24 13:55:28','0','删除经手人ID为  14 成功！','删除经手人成功'), ('1981','63','删除经手人','192.168.112.102','2016-12-24 13:55:32','1','删除经手人ID为  2 失败！','删除经手人失败'), ('1982','63','删除经手人','192.168.112.102','2016-12-24 13:56:05','1','删除经手人ID为  2 失败！','删除经手人失败'), ('1983','63','更新经手人','192.168.112.102','2016-12-24 13:56:18','0','更新经手人ID为  2 成功！','更新经手人成功'), ('1984','63','更新经手人','192.168.112.102','2016-12-24 13:56:33','0','更新经手人ID为  2 成功！','更新经手人成功'), ('1985','63','增加仓管通','192.168.112.102','2016-12-24 14:07:11','1','增加仓管通编号为  1111 失败！','增加仓管通失败'), ('1986','63','增加仓管通','192.168.112.102','2016-12-24 14:07:20','1','增加仓管通编号为  1111 失败！','增加仓管通失败'), ('1987','63','增加仓管通','192.168.112.102','2016-12-24 14:17:53','1','增加仓管通编号为  33 失败！','增加仓管通失败'), ('1988','63','增加仓管通','192.168.112.102','2016-12-24 14:18:15','1','增加仓管通编号为  33 失败！','增加仓管通失败'), ('1989','63','增加仓管通','192.168.112.102','2016-12-24 14:33:03','0','增加仓管通编号为  123 成功！','增加仓管通成功'), ('1990','63','保存仓管通明细','192.168.112.102','2016-12-24 14:33:03','0','保存仓管通明细对应主表编号为  37 成功！','保存仓管通明细成功'), ('1991','63','更新仓管通','192.168.112.102','2016-12-24 14:35:40','0','更新仓管通ID为  37 成功！','更新仓管通成功'), ('1992','63','更新仓管通','192.168.112.102','2016-12-24 14:37:08','0','更新仓管通ID为  37 成功！','更新仓管通成功'), ('1993','63','保存仓管通明细','192.168.112.102','2016-12-24 14:37:08','0','保存仓管通明细对应主表编号为  37 成功！','保存仓管通明细成功'), ('1994','63','更新仓管通','192.168.112.102','2016-12-24 14:37:32','0','更新仓管通ID为  37 成功！','更新仓管通成功'), ('1995','63','更新仓管通','192.168.112.102','2016-12-24 14:51:08','0','更新仓管通ID为  37 成功！','更新仓管通成功'), ('1996','63','更新仓管通','192.168.112.102','2016-12-24 14:51:47','0','更新仓管通ID为  37 成功！','更新仓管通成功'), ('1997','63','保存仓管通明细','192.168.112.102','2016-12-24 14:51:48','0','保存仓管通明细对应主表编号为  37 成功！','保存仓管通明细成功'), ('1998','63','登录系统','192.168.112.102','2016-12-24 15:32:37','0','管理用户：jsh 登录系统','jsh 登录系统'), ('1999','63','登录系统','192.168.112.102','2016-12-24 16:14:10','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2000','63','登录系统','192.168.112.102','2016-12-24 17:43:55','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2001','63','登录系统','192.168.112.102','2016-12-24 17:45:17','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2002','63','登录系统','192.168.112.102','2016-12-24 19:47:51','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2003','63','更新仓管通','192.168.112.102','2016-12-24 22:12:26','0','更新仓管通ID为  37 成功！','更新仓管通成功'), ('2004','63','保存仓管通明细','192.168.112.102','2016-12-24 22:12:27','0','保存仓管通明细对应主表编号为  37 成功！','保存仓管通明细成功'), ('2005','63','更新仓管通','192.168.112.102','2016-12-24 22:54:10','0','更新仓管通ID为  37 成功！','更新仓管通成功'), ('2006','63','保存仓管通明细','192.168.112.102','2016-12-24 22:54:11','0','保存仓管通明细对应主表编号为  37 成功！','保存仓管通明细成功'), ('2007','63','更新仓管通','192.168.112.102','2016-12-24 23:01:32','0','更新仓管通ID为  37 成功！','更新仓管通成功'), ('2008','63','保存仓管通明细','192.168.112.102','2016-12-24 23:01:32','0','保存仓管通明细对应主表编号为  37 成功！','保存仓管通明细成功'), ('2009','63','增加仓管通','192.168.112.102','2016-12-24 23:14:22','0','增加仓管通编号为  123132 成功！','增加仓管通成功'), ('2010','63','更新仓管通','192.168.112.102','2016-12-24 23:29:31','0','更新仓管通ID为  38 成功！','更新仓管通成功'), ('2011','63','更新仓管通','192.168.112.102','2016-12-24 23:33:25','0','更新仓管通ID为  38 成功！','更新仓管通成功'), ('2012','63','更新仓管通','192.168.112.102','2016-12-24 23:37:28','0','更新仓管通ID为  38 成功！','更新仓管通成功'), ('2013','63','保存仓管通明细','192.168.112.102','2016-12-24 23:37:29','0','保存仓管通明细对应主表编号为  38 成功！','保存仓管通明细成功'), ('2014','63','更新仓管通','192.168.112.102','2016-12-24 23:41:41','0','更新仓管通ID为  38 成功！','更新仓管通成功'), ('2015','63','保存仓管通明细','192.168.112.102','2016-12-24 23:41:41','0','保存仓管通明细对应主表编号为  38 成功！','保存仓管通明细成功'), ('2016','63','增加仓管通','192.168.112.102','2016-12-24 23:43:50','0','增加仓管通编号为  222 成功！','增加仓管通成功'), ('2017','63','保存仓管通明细','192.168.112.102','2016-12-24 23:43:51','0','保存仓管通明细对应主表编号为  39 成功！','保存仓管通明细成功'), ('2018','63','更新仓管通','192.168.112.102','2016-12-24 23:44:16','0','更新仓管通ID为  39 成功！','更新仓管通成功'), ('2019','63','保存仓管通明细','192.168.112.102','2016-12-24 23:44:17','0','保存仓管通明细对应主表编号为  39 成功！','保存仓管通明细成功'), ('2020','63','更新仓管通','192.168.112.102','2016-12-24 23:46:56','0','更新仓管通ID为  39 成功！','更新仓管通成功'), ('2021','63','保存仓管通明细','192.168.112.102','2016-12-24 23:46:57','0','保存仓管通明细对应主表编号为  39 成功！','保存仓管通明细成功');
INSERT INTO `jsh_log` VALUES ('2022','63','更新仓管通','192.168.112.102','2016-12-24 23:50:37','0','更新仓管通ID为  39 成功！','更新仓管通成功'), ('2023','63','登录系统','192.168.112.102','2016-12-25 19:58:24','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2024','63','登录系统','192.168.112.102','2016-12-25 20:28:58','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2025','63','更新结算账户','192.168.112.102','2016-12-25 21:06:07','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2026','63','更新结算账户','192.168.112.102','2016-12-25 21:06:15','0','更新结算账户ID为  4 成功！','更新结算账户成功'), ('2027','63','登录系统','192.168.1.102','2017-01-02 12:49:25','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2028','63','增加仓管通','192.168.1.102','2017-01-02 13:17:47','1','增加仓管通编号为  12 失败！','增加仓管通失败'), ('2029','63','增加仓管通','192.168.1.102','2017-01-02 13:18:35','1','增加仓管通编号为  12 失败！','增加仓管通失败'), ('2030','63','增加仓管通','192.168.1.102','2017-01-02 13:19:41','1','增加仓管通编号为  12 失败！','增加仓管通失败'), ('2031','63','增加仓管通','192.168.1.102','2017-01-02 13:21:06','1','增加仓管通编号为  12 失败！','增加仓管通失败'), ('2032','63','增加仓管通','192.168.1.102','2017-01-02 13:23:30','1','增加仓管通编号为  222 失败！','增加仓管通失败'), ('2033','63','增加仓管通','192.168.1.102','2017-01-02 13:28:34','1','增加仓管通编号为  222 失败！','增加仓管通失败'), ('2034','63','增加仓管通','192.168.1.102','2017-01-02 13:32:18','0','增加仓管通编号为  222 成功！','增加仓管通成功'), ('2035','63','保存仓管通明细','192.168.1.102','2017-01-02 13:32:18','0','保存仓管通明细对应主表编号为  40 成功！','保存仓管通明细成功'), ('2036','63','登录系统','127.0.0.1','2017-01-02 15:52:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2037','63','增加仓管通','127.0.0.1','2017-01-02 15:53:30','0','增加仓管通编号为  555 成功！','增加仓管通成功'), ('2038','63','保存仓管通明细','127.0.0.1','2017-01-02 15:53:30','0','保存仓管通明细对应主表编号为  41 成功！','保存仓管通明细成功'), ('2039','63','删除仓管通','127.0.0.1','2017-01-02 15:55:22','0','删除仓管通ID为  40 成功！','删除仓管通成功'), ('2040','63','增加仓管通','127.0.0.1','2017-01-02 15:58:29','0','增加仓管通编号为  aaa 成功！','增加仓管通成功'), ('2041','63','保存仓管通明细','127.0.0.1','2017-01-02 15:58:29','0','保存仓管通明细对应主表编号为  42 成功！','保存仓管通明细成功'), ('2042','63','增加仓管通','127.0.0.1','2017-01-02 15:59:30','0','增加仓管通编号为  aaa 成功！','增加仓管通成功'), ('2043','63','增加仓管通','127.0.0.1','2017-01-02 15:59:33','0','增加仓管通编号为  aaa 成功！','增加仓管通成功'), ('2044','63','登录系统','192.168.112.102','2017-01-02 20:29:47','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2045','63','增加仓管通','192.168.112.102','2017-01-02 20:30:33','1','增加仓管通编号为  1212 失败！','增加仓管通失败'), ('2046','63','增加仓管通','192.168.112.102','2017-01-02 20:47:06','0','增加仓管通编号为  1212 成功！','增加仓管通成功'), ('2047','63','更新结算账户','','2017-01-02 20:47:06','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2048','63','保存仓管通明细','192.168.112.102','2017-01-02 20:47:07','0','保存仓管通明细对应主表编号为  45 成功！','保存仓管通明细成功'), ('2049','63','增加仓管通','192.168.112.102','2017-01-02 21:11:45','0','增加仓管通编号为  555 成功！','增加仓管通成功'), ('2050','63','保存仓管通明细','192.168.112.102','2017-01-02 21:11:45','0','保存仓管通明细对应主表编号为  46 成功！','保存仓管通明细成功'), ('2051','63','增加仓管通','192.168.112.102','2017-01-02 21:13:01','0','增加仓管通编号为  66 成功！','增加仓管通成功'), ('2052','63','保存仓管通明细','192.168.112.102','2017-01-02 21:13:02','0','保存仓管通明细对应主表编号为  47 成功！','保存仓管通明细成功'), ('2053','63','更新结算账户','','2017-01-02 21:13:02','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2054','63','增加仓管通','192.168.112.102','2017-01-02 21:27:19','0','增加仓管通编号为  344 成功！','增加仓管通成功'), ('2055','63','保存仓管通明细','192.168.112.102','2017-01-02 21:27:20','0','保存仓管通明细对应主表编号为  48 成功！','保存仓管通明细成功'), ('2056','63','增加仓管通','192.168.112.102','2017-01-02 21:33:19','0','增加仓管通编号为  333 成功！','增加仓管通成功'), ('2057','63','保存仓管通明细','192.168.112.102','2017-01-02 21:33:20','0','保存仓管通明细对应主表编号为  49 成功！','保存仓管通明细成功'), ('2058','63','更新结算账户','','2017-01-02 21:33:22','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2059','63','更新仓管通','192.168.112.102','2017-01-02 21:33:50','0','更新仓管通ID为  49 成功！','更新仓管通成功'), ('2060','63','更新仓管通','192.168.112.102','2017-01-02 21:33:52','0','更新仓管通ID为  49 成功！','更新仓管通成功'), ('2061','63','更新仓管通','192.168.112.102','2017-01-02 21:33:54','0','更新仓管通ID为  49 成功！','更新仓管通成功'), ('2062','63','更新仓管通','192.168.112.102','2017-01-02 21:33:55','0','更新仓管通ID为  49 成功！','更新仓管通成功'), ('2063','63','更新仓管通','192.168.112.102','2017-01-02 21:33:57','0','更新仓管通ID为  49 成功！','更新仓管通成功'), ('2064','63','更新仓管通','192.168.112.102','2017-01-02 21:35:22','0','更新仓管通ID为  49 成功！','更新仓管通成功'), ('2065','63','更新结算账户','','2017-01-02 21:35:24','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2066','63','更新仓管通','192.168.112.102','2017-01-02 21:35:38','0','更新仓管通ID为  49 成功！','更新仓管通成功'), ('2067','63','更新结算账户','','2017-01-02 21:35:40','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2068','63','更新仓管通','192.168.112.102','2017-01-02 21:36:30','0','更新仓管通ID为  49 成功！','更新仓管通成功'), ('2069','63','更新结算账户','','2017-01-02 21:36:31','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2070','63','更新仓管通','192.168.112.102','2017-01-02 21:37:44','0','更新仓管通ID为  49 成功！','更新仓管通成功'), ('2071','63','更新结算账户','','2017-01-02 21:37:44','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2072','63','更新仓管通','192.168.112.102','2017-01-02 21:43:52','0','更新仓管通ID为  49 成功！','更新仓管通成功'), ('2073','63','更新结算账户','','2017-01-02 21:43:52','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2074','63','登录系统','192.168.112.102','2017-01-02 21:57:41','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2075','63','增加仓管通','192.168.112.102','2017-01-02 21:58:30','0','增加仓管通编号为  4444 成功！','增加仓管通成功'), ('2076','63','保存仓管通明细','192.168.112.102','2017-01-02 21:58:31','0','保存仓管通明细对应主表编号为  50 成功！','保存仓管通明细成功'), ('2077','63','更新结算账户','','2017-01-02 21:58:31','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2078','63','登录系统','192.168.8.100','2017-01-05 12:56:43','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2079','63','登录系统','192.168.4.108','2017-01-07 13:24:07','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2080','63','登录系统','192.168.4.108','2017-01-07 13:42:12','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2081','63','登录系统','192.168.4.108','2017-01-07 14:48:20','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2082','63','登录系统','192.168.4.108','2017-01-07 15:00:14','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2083','63','登录系统','192.168.4.108','2017-01-07 15:03:54','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2084','63','登录系统','192.168.4.108','2017-01-07 15:26:02','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2085','63','登录系统','192.168.4.108','2017-01-07 15:34:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2086','63','登录系统','192.168.4.108','2017-01-07 15:53:08','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2087','63','登录系统','192.168.4.108','2017-01-07 16:07:15','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2088','63','登录系统','192.168.4.108','2017-01-07 16:31:48','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2089','63','登录系统','192.168.4.108','2017-01-07 18:00:11','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2090','63','登录系统','192.168.4.108','2017-01-07 18:11:37','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2091','63','增加仓管通','192.168.4.108','2017-01-07 18:25:34','0','增加仓管通编号为  aaa 成功！','增加仓管通成功'), ('2092','63','保存仓管通明细','192.168.4.108','2017-01-07 18:25:34','0','保存仓管通明细对应主表编号为  51 成功！','保存仓管通明细成功'), ('2093','63','更新结算账户','','2017-01-07 18:25:34','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2094','63','删除仓管通','192.168.4.108','2017-01-07 18:30:40','0','删除仓管通ID为  43 成功！','删除仓管通成功'), ('2095','63','删除仓管通','192.168.4.108','2017-01-07 18:30:42','0','删除仓管通ID为  42 成功！','删除仓管通成功'), ('2096','63','更新仓管通','192.168.4.108','2017-01-07 18:31:07','0','更新仓管通ID为  51 成功！','更新仓管通成功'), ('2097','63','保存仓管通明细','192.168.4.108','2017-01-07 18:31:07','0','保存仓管通明细对应主表编号为  51 成功！','保存仓管通明细成功'), ('2098','63','更新结算账户','','2017-01-07 18:31:07','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2099','63','增加仓管通','192.168.4.108','2017-01-07 18:32:28','0','增加仓管通编号为  aaaaaa 成功！','增加仓管通成功'), ('2100','63','更新结算账户','','2017-01-07 18:32:29','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2101','63','保存仓管通明细','192.168.4.108','2017-01-07 18:32:29','0','保存仓管通明细对应主表编号为  52 成功！','保存仓管通明细成功'), ('2102','63','更新仓管通','192.168.4.108','2017-01-07 18:33:01','0','更新仓管通ID为  52 成功！','更新仓管通成功'), ('2103','63','更新结算账户','','2017-01-07 18:33:01','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2104','63','更新仓管通','192.168.4.108','2017-01-07 18:33:13','0','更新仓管通ID为  52 成功！','更新仓管通成功'), ('2105','63','保存仓管通明细','192.168.4.108','2017-01-07 18:33:14','0','保存仓管通明细对应主表编号为  52 成功！','保存仓管通明细成功'), ('2106','63','更新结算账户','','2017-01-07 18:33:14','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2107','63','删除仓管通','192.168.4.108','2017-01-07 18:33:49','0','删除仓管通ID为  52 成功！','删除仓管通成功'), ('2108','63','增加仓管通','192.168.4.108','2017-01-07 18:34:16','0','增加仓管通编号为  aaaa 成功！','增加仓管通成功'), ('2109','63','保存仓管通明细','192.168.4.108','2017-01-07 18:34:17','0','保存仓管通明细对应主表编号为  53 成功！','保存仓管通明细成功'), ('2110','63','更新结算账户','','2017-01-07 18:34:17','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2111','63','更新仓管通','192.168.4.108','2017-01-07 18:34:29','0','更新仓管通ID为  53 成功！','更新仓管通成功'), ('2112','63','保存仓管通明细','192.168.4.108','2017-01-07 18:34:29','0','保存仓管通明细对应主表编号为  53 成功！','保存仓管通明细成功'), ('2113','63','更新结算账户','','2017-01-07 18:34:29','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2114','63','批量删除仓管通','192.168.4.108','2017-01-07 18:34:41','0','批量删除仓管通ID为  53 成功！','批量删除仓管通成功'), ('2115','63','登录系统','192.168.4.108','2017-01-07 20:50:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2116','63','增加供应商','192.168.4.108','2017-01-07 21:01:21','0','增加供应商名称为  客户BBBB 成功！','增加供应商成功'), ('2117','63','登录系统','192.168.4.108','2017-01-08 10:44:51','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2118','63','增加仓管通','192.168.4.108','2017-01-08 10:49:21','0','增加仓管通编号为  aaa 成功！','增加仓管通成功'), ('2119','63','保存仓管通明细','192.168.4.108','2017-01-08 10:49:21','0','保存仓管通明细对应主表编号为  52 成功！','保存仓管通明细成功'), ('2120','63','更新结算账户','','2017-01-08 10:49:21','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2121','63','增加仓管通','192.168.4.108','2017-01-08 10:50:58','0','增加仓管通编号为  dddd 成功！','增加仓管通成功');
INSERT INTO `jsh_log` VALUES ('2122','63','保存仓管通明细','192.168.4.108','2017-01-08 10:50:59','0','保存仓管通明细对应主表编号为  53 成功！','保存仓管通明细成功'), ('2123','63','更新结算账户','','2017-01-08 10:50:59','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2124','63','增加仓管通','192.168.4.108','2017-01-08 10:56:45','0','增加仓管通编号为  abcde 成功！','增加仓管通成功'), ('2125','63','保存仓管通明细','192.168.4.108','2017-01-08 10:56:45','0','保存仓管通明细对应主表编号为  54 成功！','保存仓管通明细成功'), ('2126','63','增加仓管通','192.168.4.108','2017-01-08 10:58:41','0','增加仓管通编号为  abbbb 成功！','增加仓管通成功'), ('2127','63','更新结算账户','','2017-01-08 10:58:41','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2128','63','登录系统','192.168.4.108','2017-01-08 11:19:36','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2129','63','更新仓管通','192.168.4.108','2017-01-08 11:42:30','0','更新仓管通ID为  54 成功！','更新仓管通成功'), ('2130','63','更新仓管通','192.168.4.108','2017-01-08 11:42:34','0','更新仓管通ID为  54 成功！','更新仓管通成功'), ('2131','63','更新仓管通','192.168.4.108','2017-01-08 11:47:06','0','更新仓管通ID为  54 成功！','更新仓管通成功'), ('2132','63','更新仓管通','192.168.4.108','2017-01-08 11:47:08','0','更新仓管通ID为  54 成功！','更新仓管通成功'), ('2133','63','更新仓管通','192.168.4.108','2017-01-08 11:49:38','0','更新仓管通ID为  54 成功！','更新仓管通成功'), ('2134','63','增加仓管通','192.168.4.108','2017-01-08 11:50:13','0','增加仓管通编号为  AAF 成功！','增加仓管通成功'), ('2135','63','保存仓管通明细','192.168.4.108','2017-01-08 11:50:14','0','保存仓管通明细对应主表编号为  56 成功！','保存仓管通明细成功'), ('2136','63','增加仓管通','192.168.4.108','2017-01-08 11:53:00','0','增加仓管通编号为  666aaa 成功！','增加仓管通成功'), ('2137','63','保存仓管通明细','192.168.4.108','2017-01-08 11:53:00','0','保存仓管通明细对应主表编号为  57 成功！','保存仓管通明细成功'), ('2138','63','删除仓管通','192.168.4.108','2017-01-08 11:53:31','0','删除仓管通ID为  55 成功！','删除仓管通成功'), ('2139','63','增加仓管通','192.168.4.108','2017-01-08 11:53:59','0','增加仓管通编号为  34234ww 成功！','增加仓管通成功'), ('2140','63','保存仓管通明细','192.168.4.108','2017-01-08 11:53:59','0','保存仓管通明细对应主表编号为  58 成功！','保存仓管通明细成功'), ('2141','63','增加仓管通','192.168.4.108','2017-01-08 11:55:00','0','增加仓管通编号为  22 成功！','增加仓管通成功'), ('2142','63','保存仓管通明细','192.168.4.108','2017-01-08 11:55:00','0','保存仓管通明细对应主表编号为  59 成功！','保存仓管通明细成功'), ('2143','63','增加仓管通','192.168.4.108','2017-01-08 11:55:53','0','增加仓管通编号为  we 成功！','增加仓管通成功'), ('2144','63','保存仓管通明细','192.168.4.108','2017-01-08 11:55:54','0','保存仓管通明细对应主表编号为  60 成功！','保存仓管通明细成功'), ('2145','63','更新仓管通','192.168.4.108','2017-01-08 11:56:10','0','更新仓管通ID为  60 成功！','更新仓管通成功'), ('2146','63','保存仓管通明细','192.168.4.108','2017-01-08 11:56:11','0','保存仓管通明细对应主表编号为  60 成功！','保存仓管通明细成功'), ('2147','63','更新仓管通','192.168.4.108','2017-01-08 11:56:58','0','更新仓管通ID为  52 成功！','更新仓管通成功'), ('2148','63','保存仓管通明细','192.168.4.108','2017-01-08 11:56:59','0','保存仓管通明细对应主表编号为  52 成功！','保存仓管通明细成功'), ('2149','63','更新仓管通','192.168.4.108','2017-01-08 11:57:10','0','更新仓管通ID为  52 成功！','更新仓管通成功'), ('2150','63','更新仓管通','192.168.4.108','2017-01-08 11:57:39','0','更新仓管通ID为  31 成功！','更新仓管通成功'), ('2151','63','保存仓管通明细','192.168.4.108','2017-01-08 11:57:39','0','保存仓管通明细对应主表编号为  31 成功！','保存仓管通明细成功'), ('2152','63','增加仓管通','192.168.4.108','2017-01-08 11:58:58','0','增加仓管通编号为  rrrr 成功！','增加仓管通成功'), ('2153','63','保存仓管通明细','192.168.4.108','2017-01-08 11:58:59','0','保存仓管通明细对应主表编号为  61 成功！','保存仓管通明细成功'), ('2154','63','批量删除仓管通','192.168.4.108','2017-01-08 11:59:17','0','批量删除仓管通ID为  35 成功！','批量删除仓管通成功'), ('2155','63','批量删除仓管通','192.168.4.108','2017-01-08 11:59:21','0','批量删除仓管通ID为  34 成功！','批量删除仓管通成功'), ('2156','63','增加仓管通','192.168.4.108','2017-01-08 12:15:56','0','增加仓管通编号为  asas 成功！','增加仓管通成功'), ('2157','63','保存仓管通明细','192.168.4.108','2017-01-08 12:16:05','0','保存仓管通明细对应主表编号为  62 成功！','保存仓管通明细成功'), ('2158','63','删除仓管通','192.168.4.108','2017-01-08 12:20:42','0','删除仓管通ID为  36 成功！','删除仓管通成功'), ('2159','63','更新仓管通','192.168.4.108','2017-01-08 12:20:58','0','更新仓管通ID为  62 成功！','更新仓管通成功'), ('2160','63','删除仓管通','192.168.4.108','2017-01-08 12:21:57','0','删除仓管通ID为  62 成功！','删除仓管通成功'), ('2161','63','增加仓管通','192.168.4.108','2017-01-08 12:22:19','0','增加仓管通编号为  aaaa 成功！','增加仓管通成功'), ('2162','63','保存仓管通明细','192.168.4.108','2017-01-08 12:22:19','0','保存仓管通明细对应主表编号为  63 成功！','保存仓管通明细成功'), ('2163','63','增加仓管通','192.168.4.108','2017-01-08 12:33:19','0','增加仓管通编号为  42342qqq 成功！','增加仓管通成功'), ('2164','63','保存仓管通明细','192.168.4.108','2017-01-08 12:33:20','0','保存仓管通明细对应主表编号为  64 成功！','保存仓管通明细成功'), ('2165','63','增加仓管通','192.168.4.108','2017-01-08 12:33:46','0','增加仓管通编号为  42 成功！','增加仓管通成功'), ('2166','63','保存仓管通明细','192.168.4.108','2017-01-08 12:33:47','0','保存仓管通明细对应主表编号为  65 成功！','保存仓管通明细成功'), ('2167','63','更新仓管通','192.168.4.108','2017-01-08 12:34:07','0','更新仓管通ID为  65 成功！','更新仓管通成功'), ('2168','63','更新仓管通','192.168.4.108','2017-01-08 12:34:42','0','更新仓管通ID为  65 成功！','更新仓管通成功'), ('2169','63','保存仓管通明细','192.168.4.108','2017-01-08 12:34:42','0','保存仓管通明细对应主表编号为  65 成功！','保存仓管通明细成功'), ('2170','63','更新用户','','2017-01-08 12:46:53','0','更新用户ID为  63密码信息 成功！','更新用户成功'), ('2171','63','登录系统','192.168.4.108','2017-01-08 12:47:01','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2172','63','更新用户','','2017-01-08 12:47:22','1','更新用户ID为  63密码信息 失败！','更新用户失败'), ('2173','63','更新用户','','2017-01-08 12:47:34','0','更新用户ID为  63密码信息 成功！','更新用户成功'), ('2174','63','登录系统','192.168.4.108','2017-01-08 12:47:40','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2175','63','登录系统','192.168.4.108','2017-01-08 12:47:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2176','63','登录系统','192.168.4.108','2017-01-08 16:28:18','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2177','63','更新仓管通','192.168.4.108','2017-01-08 16:30:24','0','更新仓管通ID为  64 成功！','更新仓管通成功'), ('2178','63','保存仓管通明细','192.168.4.108','2017-01-08 16:30:25','0','保存仓管通明细对应主表编号为  64 成功！','保存仓管通明细成功'), ('2179','63','增加仓管通','192.168.4.108','2017-01-08 16:45:12','0','增加仓管通编号为  ababab 成功！','增加仓管通成功'), ('2180','63','保存仓管通明细','192.168.4.108','2017-01-08 16:45:12','0','保存仓管通明细对应主表编号为  66 成功！','保存仓管通明细成功'), ('2181','63','登录系统','192.168.4.108','2017-01-08 16:46:01','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2182','63','删除仓管通','192.168.4.108','2017-01-08 16:46:16','0','删除仓管通ID为  66 成功！','删除仓管通成功'), ('2183','63','增加仓管通','192.168.4.108','2017-01-08 16:46:53','0','增加仓管通编号为  abcdefg 成功！','增加仓管通成功'), ('2184','63','保存仓管通明细','192.168.4.108','2017-01-08 16:46:54','0','保存仓管通明细对应主表编号为  67 成功！','保存仓管通明细成功'), ('2185','63','更新仓管通','192.168.4.108','2017-01-08 16:55:47','0','更新仓管通ID为  67 成功！','更新仓管通成功'), ('2186','63','保存仓管通明细','192.168.4.108','2017-01-08 16:55:47','0','保存仓管通明细对应主表编号为  67 成功！','保存仓管通明细成功'), ('2187','63','更新仓管通','192.168.4.108','2017-01-08 16:59:12','0','更新仓管通ID为  32 成功！','更新仓管通成功'), ('2188','63','保存仓管通明细','192.168.4.108','2017-01-08 16:59:12','0','保存仓管通明细对应主表编号为  32 成功！','保存仓管通明细成功'), ('2189','63','更新仓管通','192.168.4.108','2017-01-08 16:59:24','0','更新仓管通ID为  30 成功！','更新仓管通成功'), ('2190','63','保存仓管通明细','192.168.4.108','2017-01-08 16:59:24','0','保存仓管通明细对应主表编号为  30 成功！','保存仓管通明细成功'), ('2191','63','删除仓管通','192.168.4.108','2017-01-08 16:59:28','0','删除仓管通ID为  29 成功！','删除仓管通成功'), ('2192','63','更新仓管通','192.168.4.108','2017-01-08 16:59:41','0','更新仓管通ID为  41 成功！','更新仓管通成功'), ('2193','63','删除仓管通','192.168.4.108','2017-01-08 16:59:57','0','删除仓管通ID为  44 成功！','删除仓管通成功'), ('2194','63','更新仓管通','192.168.4.108','2017-01-08 17:00:03','0','更新仓管通ID为  45 成功！','更新仓管通成功'), ('2195','63','更新仓管通','192.168.4.108','2017-01-08 17:00:08','0','更新仓管通ID为  46 成功！','更新仓管通成功'), ('2196','63','更新仓管通','192.168.4.108','2017-01-08 17:00:11','0','更新仓管通ID为  47 成功！','更新仓管通成功'), ('2197','63','更新仓管通','192.168.4.108','2017-01-08 17:00:14','0','更新仓管通ID为  48 成功！','更新仓管通成功'), ('2198','63','更新仓管通','192.168.4.108','2017-01-08 17:00:17','0','更新仓管通ID为  49 成功！','更新仓管通成功'), ('2199','63','更新仓管通','192.168.4.108','2017-01-08 17:00:20','0','更新仓管通ID为  50 成功！','更新仓管通成功'), ('2200','63','更新仓管通','192.168.4.108','2017-01-08 17:00:22','0','更新仓管通ID为  51 成功！','更新仓管通成功'), ('2201','63','更新仓管通','192.168.4.108','2017-01-08 17:00:25','0','更新仓管通ID为  59 成功！','更新仓管通成功'), ('2202','63','更新仓管通','192.168.4.108','2017-01-08 17:00:27','0','更新仓管通ID为  67 成功！','更新仓管通成功'), ('2203','63','更新仓管通','192.168.4.108','2017-01-08 17:00:33','0','更新仓管通ID为  39 成功！','更新仓管通成功'), ('2204','63','删除仓管通','192.168.4.108','2017-01-08 17:00:36','0','删除仓管通ID为  37 成功！','删除仓管通成功'), ('2205','63','更新仓管通','192.168.4.108','2017-01-08 17:00:39','0','更新仓管通ID为  38 成功！','更新仓管通成功'), ('2206','63','更新仓管通','192.168.4.108','2017-01-08 17:00:43','0','更新仓管通ID为  39 成功！','更新仓管通成功'), ('2207','63','更新仓管通','192.168.4.108','2017-01-08 17:02:22','0','更新仓管通ID为  52 成功！','更新仓管通成功'), ('2208','63','更新仓管通','192.168.4.108','2017-01-08 17:02:25','0','更新仓管通ID为  31 成功！','更新仓管通成功'), ('2209','63','更新仓管通','192.168.4.108','2017-01-08 17:03:44','0','更新仓管通ID为  60 成功！','更新仓管通成功'), ('2210','63','更新仓管通','192.168.4.108','2017-01-08 17:03:48','0','更新仓管通ID为  53 成功！','更新仓管通成功'), ('2211','63','登录系统','192.168.4.108','2017-01-08 17:43:25','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2212','63','更新仓管通','192.168.4.108','2017-01-08 17:53:51','0','更新仓管通ID为  52 成功！','更新仓管通成功'), ('2213','63','保存仓管通明细','192.168.4.108','2017-01-08 17:53:51','0','保存仓管通明细对应主表编号为  52 成功！','保存仓管通明细成功'), ('2214','63','登录系统','192.168.4.108','2017-01-08 18:34:03','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2215','63','更新结算账户','192.168.4.108','2017-01-08 18:57:21','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2216','63','更新结算账户','192.168.4.108','2017-01-08 18:57:43','0','更新结算账户ID为  4 成功！','更新结算账户成功'), ('2217','63','增加仓管通','192.168.4.108','2017-01-08 18:58:35','0','增加仓管通编号为  asdfasdf 成功！','增加仓管通成功'), ('2218','63','保存仓管通明细','192.168.4.108','2017-01-08 18:58:35','0','保存仓管通明细对应主表编号为  68 成功！','保存仓管通明细成功'), ('2219','63','登录系统','192.168.4.104','2017-01-10 22:12:07','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2220','63','增加功能','192.168.4.104','2017-01-10 22:57:51','0','增加功能名称为  结算账户查询 成功！','增加功能成功'), ('2221','63','更新UserBusiness','192.168.4.104','2017-01-10 22:58:13','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功');
INSERT INTO `jsh_log` VALUES ('2222','63','更新UserBusiness','192.168.4.104','2017-01-10 22:58:23','0','更新UserBusiness的ID为  6 成功！','更新UserBusiness成功'), ('2223','63','登录系统','192.168.4.104','2017-01-10 23:01:34','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2224','63','增加功能','192.168.4.104','2017-01-10 23:12:46','0','增加功能名称为  进货统计 成功！','增加功能成功'), ('2225','63','增加功能','192.168.4.104','2017-01-10 23:13:43','0','增加功能名称为  销售统计 成功！','增加功能成功'), ('2226','63','更新功能','192.168.4.104','2017-01-10 23:13:59','0','更新功能ID为  208 成功！','更新功能成功'), ('2227','63','更新UserBusiness','192.168.4.104','2017-01-10 23:14:56','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功'), ('2228','63','更新UserBusiness','192.168.4.104','2017-01-10 23:15:05','0','更新UserBusiness的ID为  6 成功！','更新UserBusiness成功'), ('2229','63','更新功能','192.168.4.104','2017-01-10 23:16:37','0','更新功能ID为  59 成功！','更新功能成功'), ('2230','63','更新功能','192.168.4.104','2017-01-10 23:16:44','0','更新功能ID为  207 成功！','更新功能成功'), ('2231','63','登录系统','192.168.4.104','2017-01-11 23:34:56','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2232','63','登录系统','192.168.112.100','2017-01-11 23:41:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2233','63','登录系统','192.168.112.100','2017-01-11 23:51:19','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2234','63','登录系统','192.168.4.104','2017-01-12 00:16:19','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2235','63','登录系统','192.168.4.104','2017-01-12 00:16:48','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2236','63','登录系统','192.168.4.104','2017-01-12 00:17:16','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2237','63','登录系统','192.168.4.104','2017-01-12 00:21:13','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2238','63','登录系统','192.168.4.104','2017-01-12 00:24:07','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2239','63','登录系统','192.168.4.104','2017-01-12 00:26:52','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2240','63','登录系统','192.168.4.104','2017-01-12 00:27:09','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2241','63','登录系统','192.168.4.104','2017-01-12 00:32:05','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2242','63','登录系统','192.168.8.108','2017-01-12 12:39:58','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2243','63','登录系统','192.168.8.108','2017-01-12 12:42:01','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2244','63','登录系统','192.168.8.108','2017-01-12 18:20:19','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2245','63','登录系统','172.16.128.41','2017-01-14 01:55:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2246','63','增加财务','172.16.128.41','2017-01-14 02:18:56','0','增加财务编号为  1234 成功！','增加财务成功'), ('2247','63','保存财务明细','172.16.128.41','2017-01-14 02:18:56','0','保存财务明细对应主表编号为  19 成功！','保存财务明细成功'), ('2248','63','增加财务','172.16.128.41','2017-01-14 03:44:01','0','增加财务编号为  21341 成功！','增加财务成功'), ('2249','63','保存财务明细','172.16.128.41','2017-01-14 03:44:01','0','保存财务明细对应主表编号为  20 成功！','保存财务明细成功'), ('2250','63','增加财务','172.16.128.41','2017-01-14 03:44:58','0','增加财务编号为  eqw 成功！','增加财务成功'), ('2251','63','保存财务明细','172.16.128.41','2017-01-14 03:44:59','0','保存财务明细对应主表编号为  21 成功！','保存财务明细成功'), ('2252','63','增加财务','172.16.128.41','2017-01-14 03:45:21','0','增加财务编号为  234 成功！','增加财务成功'), ('2253','63','保存财务明细','172.16.128.41','2017-01-14 03:45:21','0','保存财务明细对应主表编号为  22 成功！','保存财务明细成功'), ('2254','63','增加财务','172.16.128.41','2017-01-14 03:45:46','0','增加财务编号为  3123 成功！','增加财务成功'), ('2255','63','保存财务明细','172.16.128.41','2017-01-14 03:45:47','0','保存财务明细对应主表编号为  23 成功！','保存财务明细成功'), ('2256','63','增加财务','172.16.128.41','2017-01-14 03:52:40','0','增加财务编号为  sssaaa 成功！','增加财务成功'), ('2257','63','保存财务明细','172.16.128.41','2017-01-14 03:52:41','0','保存财务明细对应主表编号为  24 成功！','保存财务明细成功'), ('2258','63','登录系统','192.168.1.104','2017-01-15 11:38:52','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2259','63','登录系统','192.168.1.104','2017-01-15 12:46:59','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2260','63','增加财务','192.168.1.104','2017-01-15 13:44:36','0','增加财务编号为  3214 成功！','增加财务成功'), ('2261','63','保存财务明细','192.168.1.104','2017-01-15 13:44:36','0','保存财务明细对应主表编号为  25 成功！','保存财务明细成功'), ('2262','63','更新财务','192.168.1.104','2017-01-15 13:44:48','0','更新财务ID为  25 成功！','更新财务成功'), ('2263','63','保存财务明细','192.168.1.104','2017-01-15 13:44:49','0','保存财务明细对应主表编号为  25 成功！','保存财务明细成功'), ('2264','63','登录系统','192.168.112.102','2017-01-15 21:05:42','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2265','63','增加财务','192.168.112.102','2017-01-15 21:06:45','0','增加财务编号为  1234we 成功！','增加财务成功'), ('2266','63','保存财务明细','192.168.112.102','2017-01-15 21:06:46','0','保存财务明细对应主表编号为  26 成功！','保存财务明细成功'), ('2267','63','增加财务','192.168.112.102','2017-01-15 23:20:48','0','增加财务编号为  a1 成功！','增加财务成功'), ('2268','63','保存财务明细','192.168.112.102','2017-01-15 23:20:49','0','保存财务明细对应主表编号为  27 成功！','保存财务明细成功'), ('2269','63','增加财务','192.168.112.102','2017-01-15 23:21:21','0','增加财务编号为  a2 成功！','增加财务成功'), ('2270','63','保存财务明细','192.168.112.102','2017-01-15 23:21:22','0','保存财务明细对应主表编号为  28 成功！','保存财务明细成功'), ('2271','63','增加财务','192.168.112.102','2017-01-15 23:21:51','0','增加财务编号为  123 成功！','增加财务成功'), ('2272','63','保存财务明细','192.168.112.102','2017-01-15 23:21:51','0','保存财务明细对应主表编号为  29 成功！','保存财务明细成功'), ('2273','63','更新财务','192.168.112.102','2017-01-15 23:22:15','0','更新财务ID为  29 成功！','更新财务成功'), ('2274','63','保存财务明细','192.168.112.102','2017-01-15 23:22:16','0','保存财务明细对应主表编号为  29 成功！','保存财务明细成功'), ('2275','63','更新财务','192.168.112.102','2017-01-15 23:22:54','0','更新财务ID为  29 成功！','更新财务成功'), ('2276','63','保存财务明细','192.168.112.102','2017-01-15 23:22:55','0','保存财务明细对应主表编号为  29 成功！','保存财务明细成功'), ('2277','63','更新财务','192.168.112.102','2017-01-15 23:23:02','0','更新财务ID为  29 成功！','更新财务成功'), ('2278','63','增加财务','192.168.112.102','2017-01-15 23:23:28','0','增加财务编号为  341aaa 成功！','增加财务成功'), ('2279','63','保存财务明细','192.168.112.102','2017-01-15 23:23:28','0','保存财务明细对应主表编号为  30 成功！','保存财务明细成功'), ('2280','63','增加财务','192.168.112.102','2017-01-15 23:35:02','0','增加财务编号为  aass 成功！','增加财务成功'), ('2281','63','保存财务明细','192.168.112.102','2017-01-15 23:35:03','0','保存财务明细对应主表编号为  31 成功！','保存财务明细成功'), ('2282','63','增加财务','192.168.112.102','2017-01-15 23:36:00','0','增加财务编号为  hhhh 成功！','增加财务成功'), ('2283','63','保存财务明细','192.168.112.102','2017-01-15 23:36:01','0','保存财务明细对应主表编号为  32 成功！','保存财务明细成功'), ('2284','63','增加财务','192.168.112.102','2017-01-15 23:36:48','0','增加财务编号为  s1qw 成功！','增加财务成功'), ('2285','63','保存财务明细','192.168.112.102','2017-01-15 23:36:49','0','保存财务明细对应主表编号为  33 成功！','保存财务明细成功'), ('2286','63','更新财务','192.168.112.102','2017-01-15 23:40:56','0','更新财务ID为  32 成功！','更新财务成功'), ('2287','63','更新财务','192.168.112.102','2017-01-15 23:47:06','0','更新财务ID为  33 成功！','更新财务成功'), ('2288','63','更新财务','192.168.112.102','2017-01-15 23:47:28','0','更新财务ID为  32 成功！','更新财务成功'), ('2289','63','更新财务','192.168.112.102','2017-01-15 23:47:58','0','更新财务ID为  30 成功！','更新财务成功'), ('2290','63','更新财务','192.168.112.102','2017-01-15 23:48:37','0','更新财务ID为  31 成功！','更新财务成功'), ('2291','63','登录系统','192.168.4.103','2017-01-17 22:29:20','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2292','63','登录系统','192.168.4.103','2017-01-17 23:03:13','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2293','63','登录系统','192.168.4.103','2017-01-17 23:05:20','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2294','63','登录系统','192.168.4.103','2017-01-17 23:07:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2295','63','登录系统','192.168.4.103','2017-01-17 23:12:26','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2296','63','登录系统','192.168.4.103','2017-01-17 23:15:27','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2297','63','登录系统','192.168.4.103','2017-01-17 23:37:58','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2298','63','登录系统','192.168.4.103','2017-01-17 23:40:36','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2299','63','登录系统','192.168.4.103','2017-01-17 23:42:15','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2300','63','登录系统','192.168.4.103','2017-01-17 23:43:23','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2301','63','登录系统','192.168.4.103','2017-01-17 23:43:45','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2302','63','登录系统','192.168.4.103','2017-01-17 23:44:09','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2303','63','登录系统','192.168.4.103','2017-01-17 23:45:02','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2304','63','登录系统','192.168.4.103','2017-01-17 23:46:06','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2305','63','登录系统','192.168.4.103','2017-01-17 23:46:24','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2306','63','登录系统','192.168.112.100','2017-01-18 22:30:06','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2307','63','登录系统','192.168.112.100','2017-01-18 22:32:38','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2308','63','登录系统','192.168.112.100','2017-01-18 22:39:58','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2309','63','登录系统','192.168.4.103','2017-01-18 23:57:00','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2310','63','登录系统','192.168.4.103','2017-01-19 00:00:48','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2311','63','登录系统','192.168.4.103','2017-01-19 00:03:16','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2312','63','登录系统','192.168.4.103','2017-01-19 00:08:51','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2313','63','登录系统','192.168.4.103','2017-01-19 00:15:30','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2314','63','登录系统','192.168.4.103','2017-01-19 00:17:38','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2315','63','登录系统','192.168.4.103','2017-01-19 00:17:59','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2316','63','登录系统','192.168.4.103','2017-01-19 00:18:49','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2317','63','登录系统','192.168.4.103','2017-01-19 00:19:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2318','63','登录系统','192.168.4.103','2017-01-19 00:20:43','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2319','63','退出系统','192.168.4.103','2017-01-19 00:21:26','0','管理用户：jsh 退出系统','jsh 退出系统'), ('2320','63','登录系统','192.168.4.103','2017-01-19 00:21:43','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2321','63','退出系统','192.168.4.103','2017-01-19 00:21:55','0','管理用户：jsh 退出系统','jsh 退出系统');
INSERT INTO `jsh_log` VALUES ('2322','63','登录系统','192.168.4.103','2017-01-19 00:22:08','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2323','63','登录系统','192.168.4.103','2017-01-19 00:23:47','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2324','63','登录系统','192.168.4.103','2017-01-19 00:27:30','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2325','63','登录系统','192.168.4.103','2017-01-19 00:30:19','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2326','63','登录系统','192.168.4.103','2017-01-19 22:02:39','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2327','63','登录系统','192.168.4.103','2017-01-19 22:12:47','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2328','63','登录系统','192.168.4.103','2017-01-19 22:17:18','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2329','63','登录系统','192.168.4.103','2017-01-19 22:18:04','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2330','63','登录系统','192.168.4.103','2017-01-19 22:19:01','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2331','63','登录系统','192.168.4.103','2017-01-19 22:21:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2332','63','登录系统','192.168.4.103','2017-01-19 22:24:20','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2333','63','登录系统','192.168.4.103','2017-01-19 22:27:37','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2334','63','登录系统','192.168.4.103','2017-01-19 22:29:50','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2335','63','登录系统','192.168.4.103','2017-01-19 22:32:00','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2336','63','登录系统','192.168.4.103','2017-01-19 22:32:08','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2337','63','登录系统','192.168.4.103','2017-01-19 22:32:55','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2338','63','登录系统','192.168.4.103','2017-01-19 22:33:06','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2339','63','登录系统','192.168.4.103','2017-01-19 22:35:59','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2340','63','登录系统','192.168.4.103','2017-01-19 22:39:37','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2341','63','登录系统','192.168.4.103','2017-01-19 22:40:36','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2342','63','登录系统','192.168.4.103','2017-01-19 22:42:36','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2343','63','登录系统','192.168.4.103','2017-01-19 22:43:00','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2344','63','登录系统','192.168.4.103','2017-01-19 22:43:28','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2345','63','登录系统','192.168.4.103','2017-01-19 22:44:17','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2346','63','登录系统','192.168.4.103','2017-01-19 22:44:51','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2347','63','登录系统','192.168.4.103','2017-01-19 22:45:30','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2348','63','登录系统','192.168.4.103','2017-01-19 22:47:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2349','63','登录系统','192.168.4.103','2017-01-19 22:49:12','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2350','63','登录系统','192.168.4.103','2017-01-19 23:07:32','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2351','63','登录系统','192.168.4.103','2017-01-19 23:16:06','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2352','63','更新财务','192.168.4.103','2017-01-19 23:17:43','0','更新财务ID为  33 成功！','更新财务成功'), ('2353','63','更新财务','192.168.4.103','2017-01-19 23:17:51','0','更新财务ID为  33 成功！','更新财务成功'), ('2354','63','更新供应商','192.168.4.103','2017-01-19 23:18:10','0','更新供应商ID为  2 成功！','更新供应商成功'), ('2355','63','更新供应商','192.168.4.103','2017-01-19 23:18:21','0','更新供应商ID为  2 成功！','更新供应商成功'), ('2356','63','登录系统','192.168.4.103','2017-01-19 23:44:02','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2357','63','登录系统','192.168.4.103','2017-01-19 23:49:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2358','63','登录系统','192.168.4.103','2017-01-19 23:55:56','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2359','63','登录系统','192.168.4.103','2017-01-20 00:11:46','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2360','63','登录系统','192.168.4.103','2017-01-20 00:15:12','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2361','63','登录系统','192.168.4.103','2017-01-20 00:15:36','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2362','63','登录系统','192.168.4.103','2017-01-20 00:19:04','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2363','63','登录系统','192.168.4.103','2017-01-21 00:30:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2364','63','登录系统','192.168.4.103','2017-01-21 00:30:23','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2365','63','登录系统','127.0.0.1','2017-01-21 00:34:04','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2366','63','登录系统','127.0.0.1','2017-01-21 00:42:15','0','管理用户：JSH 登录系统','JSH 登录系统'), ('2367','63','登录系统','192.168.4.103','2017-01-21 00:43:46','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2368','63','登录系统','192.168.112.104','2017-01-21 10:52:39','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2369','63','增加仓管通','192.168.112.104','2017-01-21 10:53:57','0','增加仓管通编号为  x123 成功！','增加仓管通成功'), ('2370','63','保存仓管通明细','192.168.112.104','2017-01-21 10:53:58','0','保存仓管通明细对应主表编号为  69 成功！','保存仓管通明细成功'), ('2371','63','更新仓管通','192.168.112.104','2017-01-21 10:54:53','0','更新仓管通ID为  69 成功！','更新仓管通成功'), ('2372','63','保存仓管通明细','192.168.112.104','2017-01-21 10:54:54','0','保存仓管通明细对应主表编号为  69 成功！','保存仓管通明细成功'), ('2373','63','登录系统','192.168.4.103','2017-01-21 13:39:32','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2374','63','登录系统','192.168.4.103','2017-01-21 15:23:58','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2375','63','登录系统','192.168.4.103','2017-01-21 19:02:29','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2376','63','登录系统','192.168.112.100','2017-01-21 22:05:37','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2377','63','增加财务','192.168.112.100','2017-01-21 22:39:33','0','增加财务编号为  123 成功！','增加财务成功'), ('2378','63','保存财务明细','192.168.112.100','2017-01-21 22:39:34','0','保存财务明细对应主表编号为  34 成功！','保存财务明细成功'), ('2379','63','登录系统','192.168.112.100','2017-01-21 22:41:27','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2380','63','增加财务','192.168.112.100','2017-01-21 22:42:06','0','增加财务编号为  aabb 成功！','增加财务成功'), ('2381','63','保存财务明细','192.168.112.100','2017-01-21 22:42:07','0','保存财务明细对应主表编号为  35 成功！','保存财务明细成功'), ('2382','63','更新财务','192.168.112.100','2017-01-21 22:42:54','0','更新财务ID为  35 成功！','更新财务成功'), ('2383','63','保存财务明细','192.168.112.100','2017-01-21 22:42:54','0','保存财务明细对应主表编号为  35 成功！','保存财务明细成功'), ('2384','63','更新财务','192.168.112.100','2017-01-21 22:44:36','0','更新财务ID为  35 成功！','更新财务成功'), ('2385','63','保存财务明细','192.168.112.100','2017-01-21 22:44:37','0','保存财务明细对应主表编号为  35 成功！','保存财务明细成功'), ('2386','63','增加财务','192.168.112.100','2017-01-21 22:52:46','0','增加财务编号为  bianhao1 成功！','增加财务成功'), ('2387','63','保存财务明细','192.168.112.100','2017-01-21 22:52:47','0','保存财务明细对应主表编号为  36 成功！','保存财务明细成功'), ('2388','63','更新财务','192.168.112.100','2017-01-21 22:53:42','0','更新财务ID为  36 成功！','更新财务成功'), ('2389','63','更新财务','192.168.112.100','2017-01-21 22:54:58','0','更新财务ID为  36 成功！','更新财务成功'), ('2390','63','保存财务明细','192.168.112.100','2017-01-21 22:54:59','0','保存财务明细对应主表编号为  36 成功！','保存财务明细成功'), ('2391','63','删除财务','192.168.112.100','2017-01-21 22:55:52','0','删除财务ID为  20 成功！','删除财务成功'), ('2392','63','删除财务','192.168.112.100','2017-01-21 22:55:57','0','删除财务ID为  13 成功！','删除财务成功'), ('2393','63','增加财务','192.168.112.100','2017-01-21 23:01:09','0','增加财务编号为  fff 成功！','增加财务成功'), ('2394','63','保存财务明细','192.168.112.100','2017-01-21 23:01:10','0','保存财务明细对应主表编号为  37 成功！','保存财务明细成功'), ('2395','63','增加财务','192.168.112.100','2017-01-21 23:01:40','0','增加财务编号为  234eq 成功！','增加财务成功'), ('2396','63','保存财务明细','192.168.112.100','2017-01-21 23:01:41','0','保存财务明细对应主表编号为  38 成功！','保存财务明细成功'), ('2397','63','增加财务','192.168.112.100','2017-01-21 23:04:17','0','增加财务编号为  aasss 成功！','增加财务成功'), ('2398','63','保存财务明细','192.168.112.100','2017-01-21 23:04:17','0','保存财务明细对应主表编号为  39 成功！','保存财务明细成功'), ('2399','63','登录系统','192.168.112.102','2017-01-22 22:07:39','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2400','63','增加结算账户','192.168.112.102','2017-01-22 22:08:15','0','增加结算账户名称为  1231 成功！','增加结算账户成功'), ('2401','63','增加结算账户','192.168.112.102','2017-01-22 22:16:52','0','增加结算账户名称为  模型111 成功！','增加结算账户成功'), ('2402','63','登录系统','192.168.112.102','2017-01-22 22:33:00','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2403','63','增加经手人','192.168.112.102','2017-01-22 22:33:20','1','增加经手人名称为  qaaa 失败！','增加经手人失败'), ('2404','63','增加商品类别','192.168.112.102','2017-01-22 22:35:14','0','增加商品类别名称为  aa 成功！','增加商品类别成功'), ('2405','63','删除商品类别','192.168.112.102','2017-01-22 22:35:19','0','删除商品类别ID为  3 成功！','删除商品类别成功'), ('2406','63','增加经手人','192.168.112.102','2017-01-22 22:35:51','1','增加经手人名称为  ddd 失败！','增加经手人失败'), ('2407','63','登录系统','192.168.112.102','2017-01-22 23:08:35','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2408','63','增加经手人','192.168.112.102','2017-01-22 23:09:05','1','增加经手人名称为  aaa 失败！','增加经手人失败'), ('2409','63','增加仓管通','192.168.112.102','2017-01-22 23:10:08','0','增加仓管通编号为  aa 成功！','增加仓管通成功'), ('2410','63','保存仓管通明细','192.168.112.102','2017-01-22 23:10:08','0','保存仓管通明细对应主表编号为  70 成功！','保存仓管通明细成功'), ('2411','63','更新商品类别','192.168.112.102','2017-01-22 23:10:35','0','更新商品类别ID为  2 成功！','更新商品类别成功'), ('2412','63','更新经手人','192.168.112.102','2017-01-22 23:10:50','0','更新经手人ID为  1 成功！','更新经手人成功'), ('2413','63','删除结算账户','192.168.112.102','2017-01-22 23:10:59','0','删除结算账户ID为  11,名称为  模型111成功！','删除结算账户成功'), ('2414','63','删除结算账户','192.168.112.102','2017-01-22 23:11:02','0','删除结算账户ID为  10,名称为  1231成功！','删除结算账户成功'), ('2415','63','增加结算账户','192.168.112.102','2017-01-22 23:11:13','0','增加结算账户名称为  aaaa 成功！','增加结算账户成功'), ('2416','63','删除结算账户','192.168.112.102','2017-01-22 23:11:17','0','删除结算账户ID为  14,名称为  aaaa成功！','删除结算账户成功'), ('2417','63','增加经手人','192.168.112.102','2017-01-22 23:11:30','1','增加经手人名称为  ddd 失败！','增加经手人失败'), ('2418','63','增加仓库','192.168.112.102','2017-01-22 23:12:24','0','增加仓库名称为  aa 成功！','增加仓库成功'), ('2419','63','删除仓库','192.168.112.102','2017-01-22 23:12:29','0','删除仓库ID为  4 成功！','删除仓库成功'), ('2420','63','登录系统','192.168.112.102','2017-01-22 23:21:53','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2421','63','增加结算账户','192.168.112.102','2017-01-22 23:26:48','0','增加结算账户名称为  43345q 成功！','增加结算账户成功');
INSERT INTO `jsh_log` VALUES ('2422','63','更新结算账户','192.168.112.102','2017-01-22 23:26:57','0','更新结算账户ID为  15 成功！','更新结算账户成功'), ('2423','63','删除结算账户','192.168.112.102','2017-01-22 23:27:03','0','删除结算账户ID为  15,名称为  43345q成功！','删除结算账户成功'), ('2424','63','登录系统','192.168.112.102','2017-01-22 23:38:02','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2425','63','增加结算账户','192.168.112.102','2017-01-22 23:38:23','0','增加结算账户名称为  3253 成功！','增加结算账户成功'), ('2426','63','删除结算账户','192.168.112.102','2017-01-22 23:38:28','0','删除结算账户ID为  16,名称为  3253成功！','删除结算账户成功'), ('2427','63','登录系统','192.168.112.102','2017-01-22 23:50:36','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2428','63','登录系统','192.168.112.102','2017-01-23 00:32:23','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2429','63','登录系统','192.168.112.102','2017-01-23 00:40:36','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2430','63','登录系统','192.168.112.102','2017-01-23 00:47:30','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2431','63','登录系统','192.168.8.102','2017-02-13 15:57:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2432','63','登录系统','192.168.112.102','2017-02-13 22:47:15','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2433','63','退出系统','192.168.112.102','2017-02-13 22:57:22','0','管理用户：jsh 退出系统','jsh 退出系统'), ('2434','63','登录系统','192.168.4.107','2017-02-14 23:42:37','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2435','63','登录系统','192.168.8.102','2017-02-15 11:09:38','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2436','63','登录系统','192.168.8.102','2017-02-15 11:28:00','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2437','63','更新仓管通','192.168.8.102','2017-02-15 11:28:27','0','更新仓管通ID为  70 成功！','更新仓管通成功'), ('2438','63','删除仓管通','192.168.8.102','2017-02-15 11:28:35','0','删除仓管通ID为  70 成功！','删除仓管通成功'), ('2439','63','登录系统','192.168.8.102','2017-02-15 11:31:33','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2440','63','登录系统','192.168.8.102','2017-02-15 11:42:16','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2441','63','登录系统','192.168.8.102','2017-02-15 11:53:02','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2442','63','登录系统','192.168.8.102','2017-02-15 12:35:14','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2443','63','登录系统','192.168.8.102','2017-02-15 12:39:19','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2444','63','登录系统','192.168.4.108','2017-02-15 22:09:46','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2445','63','登录系统','192.168.4.108','2017-02-15 22:16:17','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2446','63','登录系统','192.168.4.108','2017-02-15 23:23:00','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2447','63','登录系统','192.168.4.108','2017-02-15 23:27:14','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2448','63','登录系统','192.168.8.102','2017-02-17 16:14:54','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2449','63','登录系统','192.168.8.100','2017-02-21 18:12:11','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2450','63','登录系统','192.168.112.102','2017-02-21 21:24:07','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2451','63','登录系统','192.168.112.100','2017-02-22 20:48:56','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2452','63','登录系统','192.168.112.101','2017-02-26 19:01:23','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2453','63','登录系统','192.168.4.106','2017-02-26 20:10:59','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2454','63','登录系统','192.168.4.106','2017-02-26 20:13:03','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2455','63','登录系统','192.168.112.101','2017-02-26 20:44:43','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2456','63','登录系统','192.168.112.101','2017-02-26 20:53:34','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2457','63','登录系统','192.168.112.101','2017-02-26 21:00:10','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2458','63','登录系统','192.168.112.101','2017-02-26 21:04:45','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2459','63','登录系统','192.168.112.101','2017-02-26 21:05:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2460','63','登录系统','192.168.112.101','2017-03-05 19:26:46','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2461','63','登录系统','192.168.112.101','2017-03-05 20:31:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2462','63','登录系统','192.168.112.101','2017-03-05 20:49:38','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2463','63','登录系统','192.168.112.101','2017-03-05 20:53:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2464','63','登录系统','192.168.112.101','2017-03-05 21:02:39','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2465','63','登录系统','192.168.112.101','2017-03-05 21:05:23','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2466','63','登录系统','192.168.112.101','2017-03-05 21:07:46','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2467','63','登录系统','192.168.112.101','2017-03-05 21:20:11','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2468','63','登录系统','192.168.112.101','2017-03-05 21:27:28','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2469','63','登录系统','192.168.112.101','2017-03-05 21:41:34','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2470','63','登录系统','192.168.112.101','2017-03-05 21:50:29','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2471','63','登录系统','192.168.112.101','2017-03-05 22:04:38','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2472','63','登录系统','192.168.112.101','2017-03-05 22:09:56','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2473','63','登录系统','192.168.112.101','2017-03-05 22:09:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2474','63','登录系统','192.168.112.101','2017-03-05 22:11:53','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2475','63','登录系统','192.168.112.102','2017-03-12 20:12:50','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2476','63','更新供应商','192.168.112.102','2017-03-12 20:16:33','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2477','63','更新供应商','192.168.112.102','2017-03-12 20:29:58','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2478','63','更新供应商','192.168.112.102','2017-03-12 20:31:09','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2479','63','更新供应商','192.168.112.102','2017-03-12 20:31:45','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2480','63','登录系统','192.168.112.102','2017-03-12 20:32:39','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2481','63','更新供应商','192.168.112.102','2017-03-12 20:33:05','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2482','63','更新供应商','192.168.112.102','2017-03-12 20:33:21','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2483','63','更新供应商','192.168.112.102','2017-03-12 20:33:28','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2484','63','更新供应商','192.168.112.102','2017-03-12 20:40:39','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2485','63','登录系统','192.168.112.102','2017-03-12 22:13:17','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2486','63','登录系统','192.168.112.102','2017-03-12 22:19:24','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2487','63','登录系统','192.168.112.102','2017-03-12 22:22:53','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2488','63','登录系统','192.168.112.102','2017-03-12 22:24:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2489','63','登录系统','192.168.112.102','2017-03-19 20:56:16','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2490','63','登录系统','192.168.112.102','2017-03-19 21:08:12','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2491','63','登录系统','192.168.112.102','2017-03-19 21:15:28','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2492','63','登录系统','192.168.112.102','2017-03-19 21:18:43','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2493','63','登录系统','192.168.112.102','2017-03-19 21:23:12','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2494','63','删除仓管通','192.168.112.102','2017-03-19 21:27:22','0','删除仓管通ID为  45 成功！','删除仓管通成功'), ('2495','63','删除仓管通','192.168.112.102','2017-03-19 21:27:40','0','删除仓管通ID为  30 成功！','删除仓管通成功'), ('2496','63','登录系统','192.168.112.102','2017-03-19 21:36:25','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2497','63','登录系统','192.168.1.104','2017-04-04 09:51:32','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2498','63','登录系统','192.168.1.104','2017-04-04 10:43:13','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2499','63','登录系统','192.168.1.104','2017-04-04 10:49:14','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2500','63','登录系统','192.168.1.104','2017-04-04 10:53:24','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2501','63','登录系统','192.168.1.104','2017-04-04 10:54:38','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2502','63','登录系统','192.168.1.104','2017-04-04 10:56:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2503','63','登录系统','192.168.1.104','2017-04-04 11:02:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2504','63','登录系统','192.168.1.104','2017-04-04 11:15:37','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2505','63','登录系统','192.168.1.104','2017-04-04 11:20:24','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2506','63','登录系统','192.168.1.104','2017-04-04 11:23:36','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2507','63','登录系统','192.168.1.104','2017-04-04 11:28:34','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2508','63','登录系统','192.168.112.102','2017-04-08 10:06:00','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2509','63','登录系统','192.168.112.102','2017-04-08 10:38:08','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2510','63','登录系统','192.168.112.102','2017-04-08 10:51:49','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2511','63','登录系统','192.168.112.102','2017-04-08 11:10:47','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2512','63','登录系统','192.168.112.102','2017-04-08 11:33:00','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2513','63','登录系统','192.168.112.102','2017-04-08 11:37:32','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2514','63','登录系统','192.168.112.102','2017-04-08 12:21:09','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2515','63','登录系统','192.168.112.102','2017-04-08 12:27:10','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2516','63','登录系统','192.168.112.102','2017-04-08 12:30:19','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2517','63','登录系统','192.168.112.102','2017-04-08 12:33:10','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2518','63','登录系统','192.168.112.102','2017-04-08 12:47:04','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2519','63','登录系统','192.168.112.102','2017-04-08 13:03:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2520','63','登录系统','192.168.112.102','2017-04-08 13:13:05','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2521','63','登录系统','192.168.112.102','2017-04-08 13:19:50','0','管理用户：jsh 登录系统','jsh 登录系统');
INSERT INTO `jsh_log` VALUES ('2522','63','登录系统','192.168.112.102','2017-04-08 13:26:25','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2523','63','增加仓管通','192.168.112.102','2017-04-08 13:31:17','0','增加仓管通编号为  aaa 成功！','增加仓管通成功'), ('2524','63','保存仓管通明细','192.168.112.102','2017-04-08 13:31:18','0','保存仓管通明细对应主表编号为  70 成功！','保存仓管通明细成功'), ('2525','63','更新仓管通','192.168.112.102','2017-04-08 13:31:59','0','更新仓管通ID为  70 成功！','更新仓管通成功'), ('2526','63','登录系统','192.168.112.102','2017-04-08 13:36:33','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2527','63','登录系统','192.168.112.102','2017-04-08 21:09:15','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2528','63','登录系统','192.168.112.102','2017-04-08 21:21:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2529','63','登录系统','192.168.4.105','2017-04-09 16:08:24','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2530','63','更新供应商','192.168.4.105','2017-04-09 16:08:55','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2531','63','更新供应商','192.168.4.105','2017-04-09 16:09:13','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2532','63','更新供应商','192.168.4.105','2017-04-09 16:11:32','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2533','63','更新供应商','192.168.4.105','2017-04-09 16:16:13','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2534','63','更新供应商','192.168.4.105','2017-04-09 16:16:52','0','更新供应商ID为  4 成功！','更新供应商成功'), ('2535','63','更新供应商','192.168.4.105','2017-04-09 16:17:05','0','更新供应商ID为  4 成功！','更新供应商成功'), ('2536','63','更新供应商','192.168.4.105','2017-04-09 16:17:26','0','更新供应商ID为  4 成功！','更新供应商成功'), ('2537','63','更新供应商','192.168.4.105','2017-04-09 16:17:48','0','更新供应商ID为  1 成功！','更新供应商成功'), ('2538','63','增加供应商','192.168.4.105','2017-04-09 16:18:31','0','增加供应商名称为  南通宝贝家纺 成功！','增加供应商成功'), ('2539','63','增加仓管通','192.168.4.105','2017-04-09 16:19:22','0','增加仓管通编号为  aaa123 成功！','增加仓管通成功'), ('2540','63','保存仓管通明细','192.168.4.105','2017-04-09 16:19:22','0','保存仓管通明细对应主表编号为  71 成功！','保存仓管通明细成功'), ('2541','63','更新供应商','192.168.4.105','2017-04-09 16:19:56','0','更新供应商ID为  6 成功！','更新供应商成功'), ('2542','63','更新仓管通','192.168.4.105','2017-04-09 16:20:18','0','更新仓管通ID为  71 成功！','更新仓管通成功'), ('2543','63','登录系统','192.168.4.105','2017-04-09 16:32:49','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2544','63','增加财务','192.168.4.105','2017-04-09 16:33:32','0','增加财务编号为  aaxx11 成功！','增加财务成功'), ('2545','63','保存财务明细','192.168.4.105','2017-04-09 16:33:33','0','保存财务明细对应主表编号为  40 成功！','保存财务明细成功'), ('2546','63','更新财务','192.168.4.105','2017-04-09 16:34:52','0','更新财务ID为  40 成功！','更新财务成功'), ('2547','63','登录系统','192.168.4.105','2017-04-09 16:48:23','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2548','63','更新供应商','192.168.4.105','2017-04-09 16:48:53','0','更新供应商ID为  2 成功！','更新供应商成功'), ('2549','63','更新供应商','192.168.4.105','2017-04-09 16:49:13','0','更新供应商ID为  1 成功！','更新供应商成功'), ('2550','63','登录系统','192.168.100.163','2017-06-01 00:28:33','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2551','63','登录系统','192.168.100.163','2017-06-01 21:42:07','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2552','63','登录系统','192.168.100.163','2017-06-01 21:50:39','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2553','63','登录系统','192.168.100.163','2017-06-01 21:50:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2554','63','增加仓管通','192.168.100.163','2017-06-01 22:51:42','0','增加仓管通编号为  abcd1234 成功！','增加仓管通成功'), ('2555','63','保存仓管通明细','192.168.100.163','2017-06-01 22:51:42','0','保存仓管通明细对应主表编号为  72 成功！','保存仓管通明细成功'), ('2556','63','删除仓管通','192.168.100.163','2017-06-01 22:52:30','0','删除仓管通ID为  72 成功！','删除仓管通成功'), ('2557','63','登录系统','192.168.100.163','2017-06-01 23:14:48','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2558','63','登录系统','192.168.100.163','2017-06-02 22:46:54','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2559','63','登录系统','192.168.100.163','2017-06-03 20:35:43','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2560','63','登录系统','192.168.100.163','2017-06-03 22:17:24','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2561','63','增加商品','192.168.100.163','2017-06-03 22:24:55','0','增加商品名称为  棉线 成功！','增加商品成功'), ('2562','63','增加仓管通','192.168.100.163','2017-06-03 22:26:00','0','增加仓管通编号为  22aa 成功！','增加仓管通成功'), ('2563','63','保存仓管通明细','192.168.100.163','2017-06-03 22:26:00','0','保存仓管通明细对应主表编号为  72 成功！','保存仓管通明细成功'), ('2564','63','增加仓管通','192.168.100.163','2017-06-03 22:29:35','0','增加仓管通编号为  afds123 成功！','增加仓管通成功'), ('2565','63','保存仓管通明细','192.168.100.163','2017-06-03 22:29:35','0','保存仓管通明细对应主表编号为  73 成功！','保存仓管通明细成功'), ('2566','63','更新仓管通','192.168.100.163','2017-06-03 22:30:46','0','更新仓管通ID为  73 成功！','更新仓管通成功'), ('2567','63','更新仓管通','192.168.100.163','2017-06-03 22:31:09','0','更新仓管通ID为  73 成功！','更新仓管通成功'), ('2568','63','更新仓管通','192.168.100.163','2017-06-03 22:31:19','0','更新仓管通ID为  73 成功！','更新仓管通成功'), ('2569','63','增加仓管通','192.168.100.163','2017-06-03 22:47:31','0','增加仓管通编号为  dsfs 成功！','增加仓管通成功'), ('2570','63','保存仓管通明细','192.168.100.163','2017-06-03 22:47:31','0','保存仓管通明细对应主表编号为  74 成功！','保存仓管通明细成功'), ('2571','63','更新仓管通','192.168.100.163','2017-06-03 22:47:59','0','更新仓管通ID为  74 成功！','更新仓管通成功'), ('2572','63','增加财务','192.168.100.163','2017-06-03 22:53:38','0','增加财务编号为  aa 成功！','增加财务成功'), ('2573','63','保存财务明细','192.168.100.163','2017-06-03 22:53:38','0','保存财务明细对应主表编号为  41 成功！','保存财务明细成功'), ('2574','63','删除财务','192.168.100.163','2017-06-03 22:54:04','0','删除财务ID为  31 成功！','删除财务成功'), ('2575','63','删除财务','192.168.100.163','2017-06-03 22:54:05','0','删除财务ID为  24 成功！','删除财务成功'), ('2576','63','删除财务','192.168.100.163','2017-06-03 22:54:07','0','删除财务ID为  17 成功！','删除财务成功'), ('2577','63','增加仓管通','192.168.100.163','2017-06-03 22:59:46','0','增加仓管通编号为  aaa 成功！','增加仓管通成功'), ('2578','63','保存仓管通明细','192.168.100.163','2017-06-03 22:59:46','0','保存仓管通明细对应主表编号为  75 成功！','保存仓管通明细成功'), ('2579','63','删除仓管通','192.168.100.163','2017-06-03 23:00:05','0','删除仓管通ID为  75 成功！','删除仓管通成功'), ('2580','63','增加仓管通','192.168.100.163','2017-06-03 23:00:53','0','增加仓管通编号为  asdf 成功！','增加仓管通成功'), ('2581','63','保存仓管通明细','192.168.100.163','2017-06-03 23:00:53','0','保存仓管通明细对应主表编号为  76 成功！','保存仓管通明细成功'), ('2582','63','更新仓管通','192.168.100.163','2017-06-03 23:01:06','0','更新仓管通ID为  76 成功！','更新仓管通成功'), ('2583','63','保存仓管通明细','192.168.100.163','2017-06-03 23:01:06','0','保存仓管通明细对应主表编号为  76 成功！','保存仓管通明细成功'), ('2584','63','更新供应商','192.168.100.163','2017-06-03 23:01:21','0','更新供应商ID为  1 成功！','更新供应商成功'), ('2585','63','更新仓库','192.168.100.163','2017-06-03 23:02:15','0','更新仓库ID为  1 成功！','更新仓库成功'), ('2586','63','更新仓库','192.168.100.163','2017-06-03 23:02:21','0','更新仓库ID为  3 成功！','更新仓库成功'), ('2587','63','更新供应商','192.168.100.163','2017-06-03 23:03:15','0','更新供应商ID为  6 成功！','更新供应商成功'), ('2588','63','更新供应商','192.168.100.163','2017-06-03 23:03:33','0','更新供应商ID为  5 成功！','更新供应商成功'), ('2589','63','更新供应商','192.168.100.163','2017-06-03 23:03:50','0','更新供应商ID为  4 成功！','更新供应商成功'), ('2590','63','更新供应商','192.168.100.163','2017-06-03 23:04:11','0','更新供应商ID为  2 成功！','更新供应商成功'), ('2591','63','更新供应商','192.168.100.163','2017-06-03 23:04:16','0','更新供应商ID为  1 成功！','更新供应商成功'), ('2592','63','更新结算账户','192.168.100.163','2017-06-03 23:04:42','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2593','63','更新结算账户','192.168.100.163','2017-06-03 23:04:49','0','更新结算账户ID为  4 成功！','更新结算账户成功'), ('2594','63','更新结算账户','192.168.100.163','2017-06-03 23:05:01','0','更新结算账户ID为  9 成功！','更新结算账户成功'), ('2595','63','更新结算账户','192.168.100.163','2017-06-03 23:05:05','0','更新结算账户ID为  4 成功！','更新结算账户成功'), ('2596','63','更新结算账户','192.168.100.163','2017-06-03 23:05:21','0','更新结算账户ID为  4 成功！','更新结算账户成功'), ('2597','63','增加商品类别','192.168.100.163','2017-06-03 23:07:34','0','增加商品类别名称为  其他 成功！','增加商品类别成功'), ('2598','63','增加商品类别','192.168.100.163','2017-06-03 23:08:09','0','增加商品类别名称为  其他 成功！','增加商品类别成功'), ('2599','63','增加商品类别','192.168.100.163','2017-06-03 23:08:33','0','增加商品类别名称为  其他 成功！','增加商品类别成功'), ('2600','63','更新商品','192.168.100.163','2017-06-03 23:10:50','0','更新商品ID为  499 成功！','更新商品成功'), ('2601','63','更新商品','192.168.100.163','2017-06-03 23:10:56','0','更新商品ID为  499 成功！','更新商品成功'), ('2602','63','更新商品','192.168.100.163','2017-06-03 23:11:07','0','更新商品ID为  499 成功！','更新商品成功'), ('2603','63','更新商品','192.168.100.163','2017-06-03 23:12:08','0','更新商品ID为  485 成功！','更新商品成功'), ('2604','63','更新商品','192.168.100.163','2017-06-03 23:12:13','0','更新商品ID为  487 成功！','更新商品成功'), ('2605','63','更新商品','192.168.100.163','2017-06-03 23:12:36','0','更新商品ID为  498 成功！','更新商品成功'), ('2606','63','更新用户','','2017-06-03 23:29:02','0','更新用户ID为  63密码信息 成功！','更新用户成功'), ('2607','63','登录系统','192.168.100.163','2017-06-03 23:29:08','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2608','63','退出系统','192.168.100.163','2017-06-03 23:29:12','0','管理用户：jsh 退出系统','jsh 退出系统'), ('2609','63','登录系统','192.168.100.163','2017-06-03 23:29:18','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2610','63','更新用户','','2017-06-03 23:29:32','0','更新用户ID为  63密码信息 成功！','更新用户成功'), ('2611','63','登录系统','192.168.100.163','2017-06-03 23:29:34','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2612','63','退出系统','192.168.100.163','2017-06-03 23:29:37','0','管理用户：jsh 退出系统','jsh 退出系统'), ('2613','63','登录系统','192.168.100.163','2017-06-03 23:29:50','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2614','63','更新UserBusiness','192.168.100.163','2017-06-03 23:34:30','0','更新UserBusiness的ID为  6 成功！','更新UserBusiness成功'), ('2615','63','更新UserBusiness','192.168.100.163','2017-06-03 23:34:45','0','更新UserBusiness的ID为  2 成功！','更新UserBusiness成功'), ('2616','63','更新UserBusiness','192.168.100.163','2017-06-03 23:35:01','0','更新UserBusiness的ID为  6 成功！','更新UserBusiness成功'), ('2617','63','退出系统','192.168.100.163','2017-06-03 23:35:31','0','管理用户：jsh 退出系统','jsh 退出系统'), ('2618','64','登录系统','192.168.100.163','2017-06-03 23:35:37','0','管理用户：zs 登录系统','zs 登录系统'), ('2619','64','退出系统','192.168.100.163','2017-06-03 23:36:13','0','管理用户：zs 退出系统','zs 退出系统'), ('2620','63','登录系统','192.168.100.163','2017-06-03 23:36:19','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2621','63','更新UserBusiness','192.168.100.163','2017-06-03 23:36:40','0','更新UserBusiness的ID为  6 成功！','更新UserBusiness成功');
INSERT INTO `jsh_log` VALUES ('2622','63','退出系统','192.168.100.163','2017-06-03 23:36:46','0','管理用户：jsh 退出系统','jsh 退出系统'), ('2623','64','登录系统','192.168.100.163','2017-06-03 23:36:53','0','管理用户：zs 登录系统','zs 登录系统'), ('2624','64','退出系统','192.168.100.163','2017-06-03 23:37:18','0','管理用户：zs 退出系统','zs 退出系统'), ('2625','63','登录系统','192.168.100.163','2017-06-03 23:37:26','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2626','63','登录系统','192.168.100.163','2017-06-04 12:48:36','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2627','63','登录系统','192.168.100.163','2017-06-04 13:02:33','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2628','63','登录系统','192.168.100.163','2017-06-04 16:51:47','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2629','63','登录系统','192.168.100.163','2017-06-04 18:05:38','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2630','63','登录系统','192.168.100.163','2017-06-04 18:52:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2631','63','登录系统','192.168.100.163','2017-06-04 18:54:01','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2632','63','登录系统','192.168.100.163','2017-06-04 18:55:58','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2633','63','退出系统','192.168.100.163','2017-06-04 18:56:00','0','管理用户：jsh 退出系统','jsh 退出系统'), ('2634','63','登录系统','192.168.100.163','2017-06-04 18:56:01','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2635','63','退出系统','192.168.100.163','2017-06-04 18:56:04','0','管理用户：jsh 退出系统','jsh 退出系统'), ('2636','63','登录系统','192.168.100.163','2017-06-04 18:56:05','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2637','63','登录系统','192.168.100.163','2017-06-04 18:58:55','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2638','63','登录系统','192.168.100.163','2017-06-04 19:01:41','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2639','63','登录系统','192.168.100.163','2017-06-04 19:18:12','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2640','63','登录系统','192.168.100.163','2017-06-04 19:24:21','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2641','63','登录系统','192.168.100.163','2017-06-04 19:29:46','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2642','63','登录系统','192.168.100.163','2017-06-04 20:24:23','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2643','63','登录系统','192.168.100.163','2017-06-04 20:30:21','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2644','63','登录系统','192.168.100.163','2017-06-04 20:32:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2645','63','登录系统','192.168.100.163','2017-06-04 20:33:12','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2646','63','登录系统','192.168.100.163','2017-06-04 20:41:05','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2647','63','登录系统','192.168.100.163','2017-06-04 20:54:15','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2648','63','登录系统','192.168.100.163','2017-06-04 21:05:49','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2649','63','登录系统','192.168.100.163','2017-06-04 21:09:11','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2650','63','登录系统','192.168.100.163','2017-06-04 21:17:38','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2651','63','登录系统','192.168.100.163','2017-06-04 21:21:27','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2652','63','登录系统','192.168.100.163','2017-06-04 21:28:11','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2653','63','登录系统','192.168.100.163','2017-06-04 21:31:47','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2654','63','登录系统','192.168.100.163','2017-06-04 21:37:56','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2655','63','登录系统','192.168.100.163','2017-06-04 21:40:45','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2656','63','登录系统','192.168.100.163','2017-06-04 21:57:17','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2657','63','登录系统','192.168.100.163','2017-06-04 22:00:21','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2658','63','登录系统','192.168.100.163','2017-06-04 22:02:14','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2659','63','登录系统','192.168.100.163','2017-06-04 22:03:43','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2660','63','登录系统','192.168.100.163','2017-06-04 22:07:19','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2661','63','登录系统','192.168.100.163','2017-06-04 22:16:30','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2662','63','登录系统','192.168.100.163','2017-06-04 22:28:54','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2663','63','登录系统','192.168.100.163','2017-06-04 22:42:48','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2664','63','登录系统','192.168.100.163','2017-06-04 22:45:11','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2665','63','登录系统','192.168.100.163','2017-06-04 22:50:52','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2666','63','登录系统','192.168.100.163','2017-06-04 22:54:10','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2667','63','登录系统','192.168.100.163','2017-06-04 22:57:29','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2668','63','登录系统','192.168.100.163','2017-06-04 23:07:20','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2669','63','登录系统','192.168.100.163','2017-06-04 23:09:00','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2670','63','登录系统','192.168.100.163','2017-06-04 23:28:38','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2671','63','登录系统','192.168.100.163','2017-06-04 23:35:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2672','63','登录系统','192.168.100.163','2017-06-04 23:37:49','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2673','63','登录系统','192.168.100.163','2017-06-04 23:40:53','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2674','63','登录系统','192.168.100.163','2017-06-04 23:44:16','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2675','63','登录系统','192.168.100.163','2017-06-04 23:51:40','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2676','63','登录系统','192.168.100.163','2017-06-04 23:54:41','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2677','63','登录系统','192.168.100.163','2017-06-05 00:03:45','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2678','63','登录系统','192.168.100.163','2017-06-05 00:07:04','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2679','63','登录系统','192.168.100.163','2017-06-05 00:09:12','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2680','63','更新商品','192.168.100.163','2017-06-05 00:10:04','0','更新商品ID为  499 成功！','更新商品成功'), ('2681','63','登录系统','192.168.100.163','2017-06-05 00:11:49','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2682','63','增加仓管通','192.168.100.163','2017-06-05 00:13:47','0','增加仓管通编号为  22aa 成功！','增加仓管通成功'), ('2683','63','保存仓管通明细','192.168.100.163','2017-06-05 00:13:48','0','保存仓管通明细对应主表编号为  77 成功！','保存仓管通明细成功'), ('2684','63','更新仓管通','192.168.100.163','2017-06-05 00:14:43','0','更新仓管通ID为  77 成功！','更新仓管通成功'), ('2685','63','保存仓管通明细','192.168.100.163','2017-06-05 00:14:43','0','保存仓管通明细对应主表编号为  77 成功！','保存仓管通明细成功'), ('2686','63','登录系统','192.168.100.163','2017-06-05 00:22:29','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2687','63','登录系统','192.168.100.163','2017-06-05 00:25:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2688','63','登录系统','192.168.100.163','2017-06-05 21:35:46','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2689','63','登录系统','192.168.100.163','2017-06-05 21:40:34','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2690','63','登录系统','192.168.100.163','2017-06-05 22:05:46','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2691','63','登录系统','192.168.100.163','2017-06-05 22:08:38','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2692','63','登录系统','192.168.100.163','2017-06-05 22:10:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2693','63','登录系统','192.168.100.163','2017-06-05 22:12:28','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2694','63','登录系统','192.168.100.163','2017-06-05 22:14:20','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2695','63','登录系统','192.168.100.163','2017-06-05 22:16:05','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2696','63','登录系统','192.168.100.163','2017-06-06 21:44:41','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2697','63','登录系统','192.168.100.163','2017-06-08 21:34:20','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2698','63','登录系统','192.168.100.163','2017-06-08 22:33:21','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2699','63','更新仓管通','192.168.100.163','2017-06-08 22:33:33','0','更新仓管通ID为  76 成功！','更新仓管通成功'), ('2700','63','更新仓管通','192.168.100.163','2017-06-08 22:33:42','0','更新仓管通ID为  76 成功！','更新仓管通成功'), ('2701','63','更新应用','192.168.100.163','2017-06-08 22:33:55','0','更新应用ID为  21 成功！','更新应用成功'), ('2702','63','更新应用','192.168.100.163','2017-06-08 22:33:59','0','更新应用ID为  21 成功！','更新应用成功'), ('2703','63','更新应用','192.168.100.163','2017-06-08 22:34:05','0','更新应用ID为  21 成功！','更新应用成功'), ('2704','63','更新应用','192.168.100.163','2017-06-08 22:34:11','0','更新应用ID为  21 成功！','更新应用成功'), ('2705','63','更新应用','192.168.100.163','2017-06-08 22:34:53','0','更新应用ID为  21 成功！','更新应用成功'), ('2706','63','更新应用','192.168.100.163','2017-06-08 22:35:34','0','更新应用ID为  21 成功！','更新应用成功'), ('2707','63','增加应用','192.168.100.163','2017-06-08 22:37:14','0','增加应用名称为  ssss 成功！','增加应用成功'), ('2708','63','更新应用','192.168.100.163','2017-06-08 22:38:30','0','更新应用ID为  23 成功！','更新应用成功'), ('2709','63','登录系统','192.168.100.163','2017-06-08 22:39:14','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2710','63','更新应用','192.168.100.163','2017-06-08 22:39:33','0','更新应用ID为  23 成功！','更新应用成功'), ('2711','63','更新应用','192.168.100.163','2017-06-08 22:57:28','0','更新应用ID为  23 成功！','更新应用成功'), ('2712','63','更新应用','192.168.100.163','2017-06-08 22:57:42','0','更新应用ID为  23 成功！','更新应用成功'), ('2713','63','更新应用','192.168.100.163','2017-06-08 22:57:56','0','更新应用ID为  23 成功！','更新应用成功'), ('2714','63','更新应用','192.168.100.163','2017-06-08 22:58:04','0','更新应用ID为  23 成功！','更新应用成功'), ('2715','63','更新应用','192.168.100.163','2017-06-08 22:58:21','0','更新应用ID为  23 成功！','更新应用成功'), ('2716','63','更新应用','192.168.100.163','2017-06-08 22:59:26','0','更新应用ID为  23 成功！','更新应用成功'), ('2717','63','更新应用','192.168.100.163','2017-06-08 23:00:00','0','更新应用ID为  23 成功！','更新应用成功'), ('2718','63','增加应用','192.168.100.163','2017-06-08 23:02:47','0','增加应用名称为  123123 成功！','增加应用成功'), ('2719','63','删除应用','192.168.100.163','2017-06-08 23:04:46','0','删除应用ID为  24 成功！','删除应用成功'), ('2720','63','增加应用','192.168.100.163','2017-06-08 23:05:02','0','增加应用名称为  123 成功！','增加应用成功'), ('2721','63','删除应用','192.168.100.163','2017-06-08 23:05:22','0','删除应用ID为  25 成功！','删除应用成功');
INSERT INTO `jsh_log` VALUES ('2722','63','增加应用','192.168.100.163','2017-06-08 23:05:56','0','增加应用名称为  123 成功！','增加应用成功'), ('2723','63','删除应用','192.168.100.163','2017-06-08 23:07:18','0','删除应用ID为  26 成功！','删除应用成功'), ('2724','63','增加应用','192.168.100.163','2017-06-08 23:07:40','0','增加应用名称为  123 成功！','增加应用成功'), ('2725','63','删除应用','192.168.100.163','2017-06-08 23:11:06','0','删除应用ID为  27 成功！','删除应用成功'), ('2726','63','增加应用','192.168.100.163','2017-06-08 23:11:19','0','增加应用名称为  123 成功！','增加应用成功'), ('2727','63','登录系统','192.168.100.163','2017-06-08 23:13:59','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2728','63','删除应用','192.168.100.163','2017-06-08 23:14:15','0','删除应用ID为  28 成功！','删除应用成功'), ('2729','63','增加应用','192.168.100.163','2017-06-08 23:14:29','0','增加应用名称为  123 成功！','增加应用成功'), ('2730','63','登录系统','192.168.100.163','2017-06-08 23:27:02','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2731','63','删除应用','192.168.100.163','2017-06-08 23:27:20','0','删除应用ID为  29 成功！','删除应用成功'), ('2732','63','增加应用','192.168.100.163','2017-06-08 23:27:38','0','增加应用名称为  123 成功！','增加应用成功'), ('2733','63','登录系统','192.168.100.163','2017-06-08 23:30:43','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2734','63','删除应用','192.168.100.163','2017-06-08 23:30:52','0','删除应用ID为  30 成功！','删除应用成功'), ('2735','63','删除应用','192.168.100.163','2017-06-08 23:30:55','0','删除应用ID为  23 成功！','删除应用成功'), ('2736','63','增加应用','192.168.100.163','2017-06-08 23:31:39','0','增加应用名称为  123 成功！','增加应用成功'), ('2737','63','删除应用','192.168.100.163','2017-06-08 23:33:05','0','删除应用ID为  31 成功！','删除应用成功'), ('2738','63','增加应用','192.168.100.163','2017-06-08 23:33:14','0','增加应用名称为  123 成功！','增加应用成功'), ('2739','63','登录系统','192.168.100.163','2017-06-08 23:39:49','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2740','63','删除应用','192.168.100.163','2017-06-08 23:40:01','0','删除应用ID为  32 成功！','删除应用成功'), ('2741','63','增加应用','192.168.100.163','2017-06-08 23:40:09','0','增加应用名称为  123 成功！','增加应用成功'), ('2742','63','增加应用','192.168.100.163','2017-06-08 23:47:40','0','增加应用名称为  12311 成功！','增加应用成功'), ('2743','63','登录系统','192.168.100.163','2017-06-08 23:50:33','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2744','63','删除应用','192.168.100.163','2017-06-08 23:50:45','0','删除应用ID为  33 成功！','删除应用成功'), ('2745','63','删除应用','192.168.100.163','2017-06-08 23:50:47','0','删除应用ID为  34 成功！','删除应用成功'), ('2746','63','增加应用','192.168.100.163','2017-06-08 23:51:09','0','增加应用名称为  123 成功！','增加应用成功'), ('2747','63','登录系统','192.168.100.163','2017-06-08 23:54:24','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2748','63','删除应用','192.168.100.163','2017-06-08 23:54:44','0','删除应用ID为  35 成功！','删除应用成功'), ('2749','63','增加应用','192.168.100.163','2017-06-08 23:55:01','0','增加应用名称为  123 成功！','增加应用成功'), ('2750','63','登录系统','192.168.100.163','2017-06-09 21:26:36','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2751','63','删除应用','192.168.100.163','2017-06-09 21:28:03','0','删除应用ID为  36 成功！','删除应用成功'), ('2752','63','增加应用','192.168.100.163','2017-06-09 21:28:14','0','增加应用名称为  123 成功！','增加应用成功'), ('2753','63','登录系统','192.168.100.163','2017-06-09 21:52:29','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2754','63','删除应用','192.168.100.163','2017-06-09 21:52:41','0','删除应用ID为  23 成功！','删除应用成功'), ('2755','63','增加应用','192.168.100.163','2017-06-09 21:52:59','0','增加应用名称为  123 成功！','增加应用成功'), ('2756','63','登录系统','192.168.100.163','2017-06-09 21:58:35','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2757','63','增加应用','192.168.100.163','2017-06-09 21:58:51','0','增加应用名称为  123 成功！','增加应用成功'), ('2758','63','登录系统','192.168.100.163','2017-06-09 22:01:23','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2759','63','删除应用','192.168.100.163','2017-06-09 22:01:33','0','删除应用ID为  25 成功！','删除应用成功'), ('2760','63','登录系统','192.168.100.163','2017-06-11 18:49:11','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2761','63','登录系统','192.168.100.163','2017-06-11 18:51:54','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2762','63','登录系统','192.168.100.163','2017-06-11 18:56:15','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2763','63','登录系统','192.168.100.163','2017-06-11 19:01:41','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2764','63','登录系统','192.168.100.163','2017-06-11 19:03:28','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2765','63','登录系统','192.168.100.163','2017-06-11 19:18:20','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2766','63','登录系统','192.168.100.163','2017-06-11 20:43:48','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2767','63','登录系统','192.168.100.163','2017-06-11 21:24:06','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2768','63','登录系统','192.168.100.163','2017-06-11 21:36:32','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2769','63','登录系统','192.168.100.163','2017-06-11 23:17:03','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2770','63','登录系统','192.168.100.163','2017-06-11 23:26:29','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2771','63','登录系统','192.168.100.163','2017-06-11 23:29:33','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2772','63','增加应用','192.168.100.163','2017-06-11 23:30:23','0','增加应用名称为  123 成功！','增加应用成功'), ('2773','63','删除应用','192.168.100.163','2017-06-11 23:31:27','0','删除应用ID为  23 成功！','删除应用成功'), ('2774','63','增加应用','192.168.100.163','2017-06-11 23:32:04','0','增加应用名称为  123 成功！','增加应用成功'), ('2775','63','登录系统','192.168.100.163','2017-06-11 23:35:53','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2776','63','增加应用','192.168.100.163','2017-06-11 23:36:11','0','增加应用名称为  132 成功！','增加应用成功'), ('2777','63','删除应用','192.168.100.163','2017-06-11 23:36:15','0','删除应用ID为  24 成功！','删除应用成功'), ('2778','63','删除应用','192.168.100.163','2017-06-11 23:36:16','0','删除应用ID为  25 成功！','删除应用成功'), ('2779','63','登录系统','192.168.100.163','2017-06-11 23:38:10','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2780','63','增加应用','192.168.100.163','2017-06-11 23:38:28','0','增加应用名称为  3123 成功！','增加应用成功'), ('2781','63','登录系统','192.168.100.163','2017-06-12 22:11:39','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2782','63','登录系统','192.168.100.163','2017-06-12 22:45:59','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2783','63','登录系统','192.168.100.163','2017-06-12 22:46:10','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2784','63','删除应用','192.168.100.163','2017-06-12 22:46:22','0','删除应用ID为  26 成功！','删除应用成功'), ('2785','63','登录系统','192.168.100.163','2017-06-12 22:51:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2786','63','登录系统','192.168.100.163','2017-06-12 22:54:55','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2787','63','登录系统','192.168.100.163','2017-06-12 23:02:31','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2788','63','登录系统','192.168.100.163','2017-06-12 23:12:04','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2789','63','登录系统','192.168.100.163','2017-06-12 23:15:50','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2790','63','登录系统','192.168.100.163','2017-06-12 23:24:50','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2791','63','登录系统','192.168.100.163','2017-06-13 20:59:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2792','63','登录系统','192.168.100.163','2017-06-13 21:10:05','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2793','63','登录系统','192.168.100.163','2017-06-13 21:12:14','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2794','63','登录系统','192.168.100.163','2017-06-13 21:31:48','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2795','63','登录系统','192.168.100.163','2017-06-13 21:35:32','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2796','63','登录系统','192.168.100.163','2017-06-13 22:19:50','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2797','63','登录系统','192.168.100.163','2017-06-13 22:24:45','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2798','63','登录系统','192.168.100.163','2017-06-13 22:28:30','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2799','63','登录系统','192.168.100.163','2017-06-13 22:38:12','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2800','63','登录系统','192.168.100.163','2017-06-13 22:57:09','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2801','63','登录系统','192.168.100.163','2017-06-13 23:03:38','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2802','63','登录系统','192.168.100.163','2017-06-13 23:07:32','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2803','63','登录系统','192.168.100.163','2017-06-13 23:16:06','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2804','63','登录系统','192.168.100.163','2017-06-13 23:20:18','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2805','63','登录系统','192.168.100.163','2017-06-13 23:30:47','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2806','63','登录系统','192.168.100.163','2017-06-13 23:36:27','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2807','63','登录系统','192.168.100.163','2017-06-13 23:38:31','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2808','63','登录系统','192.168.100.163','2017-06-13 23:39:52','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2809','63','登录系统','192.168.100.163','2017-06-13 23:42:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2810','63','登录系统','192.168.100.163','2017-06-14 21:03:01','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2811','63','登录系统','192.168.100.163','2017-06-14 21:03:01','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2812','63','登录系统','192.168.100.163','2017-06-14 21:03:01','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2813','63','登录系统','192.168.100.163','2017-06-14 21:16:27','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2814','63','增加应用','192.168.100.163','2017-06-14 21:30:03','0','增加应用名称为  333 成功！','增加应用成功'), ('2815','63','删除应用','192.168.100.163','2017-06-14 21:30:52','0','删除应用ID为  23 成功！','删除应用成功'), ('2816','63','增加应用','192.168.100.163','2017-06-14 21:31:09','0','增加应用名称为  6666 成功！','增加应用成功'), ('2817','63','更新应用','192.168.100.163','2017-06-14 21:31:36','0','更新应用ID为  24 成功！','更新应用成功'), ('2818','63','退出系统','192.168.100.163','2017-06-14 21:31:59','0','管理用户：jsh 退出系统','jsh 退出系统'), ('2819','63','登录系统','192.168.100.163','2017-06-14 21:32:03','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2820','63','更新应用','192.168.100.163','2017-06-14 21:32:23','0','更新应用ID为  24 成功！','更新应用成功'), ('2821','63','更新应用','192.168.100.163','2017-06-14 21:33:36','0','更新应用ID为  24 成功！','更新应用成功');
INSERT INTO `jsh_log` VALUES ('2822','63','更新应用','192.168.100.163','2017-06-14 21:35:24','0','更新应用ID为  24 成功！','更新应用成功'), ('2823','63','更新应用','192.168.100.163','2017-06-14 21:35:30','0','更新应用ID为  24 成功！','更新应用成功'), ('2824','63','更新应用','192.168.100.163','2017-06-14 21:36:12','0','更新应用ID为  24 成功！','更新应用成功'), ('2825','63','更新应用','192.168.100.163','2017-06-14 21:37:08','0','更新应用ID为  24 成功！','更新应用成功'), ('2826','63','删除应用','192.168.100.163','2017-06-14 21:52:08','0','删除应用ID为  24 成功！','删除应用成功'), ('2827','63','增加应用','192.168.100.163','2017-06-14 21:52:36','0','增加应用名称为  aaa 成功！','增加应用成功'), ('2828','63','删除应用','192.168.100.163','2017-06-14 21:53:02','0','删除应用ID为  25 成功！','删除应用成功'), ('2829','63','增加应用','192.168.100.163','2017-06-14 21:53:39','0','增加应用名称为  aaa 成功！','增加应用成功'), ('2830','63','删除应用','192.168.100.163','2017-06-14 21:54:06','0','删除应用ID为  26 成功！','删除应用成功'), ('2831','63','增加应用','192.168.100.163','2017-06-14 21:56:45','0','增加应用名称为  afdd 成功！','增加应用成功'), ('2832','63','删除应用','192.168.100.163','2017-06-14 21:57:09','0','删除应用ID为  27 成功！','删除应用成功'), ('2833','63','增加应用','192.168.100.163','2017-06-14 21:58:32','0','增加应用名称为  aaaa 成功！','增加应用成功'), ('2834','63','删除应用','192.168.100.163','2017-06-14 21:58:36','0','删除应用ID为  28 成功！','删除应用成功'), ('2835','63','增加应用','192.168.100.163','2017-06-14 21:58:54','0','增加应用名称为  add 成功！','增加应用成功'), ('2836','63','删除应用','192.168.100.163','2017-06-14 21:58:59','0','删除应用ID为  29 成功！','删除应用成功'), ('2837','63','增加应用','192.168.100.163','2017-06-14 22:00:16','0','增加应用名称为  addd 成功！','增加应用成功'), ('2838','63','删除应用','192.168.100.163','2017-06-14 22:00:19','0','删除应用ID为  30 成功！','删除应用成功'), ('2839','63','增加应用','192.168.100.163','2017-06-14 22:00:27','0','增加应用名称为  sdsd 成功！','增加应用成功'), ('2840','63','删除应用','192.168.100.163','2017-06-14 22:01:33','0','删除应用ID为  31 成功！','删除应用成功'), ('2841','63','增加应用','192.168.100.163','2017-06-14 22:03:05','0','增加应用名称为  qweqw 成功！','增加应用成功'), ('2842','63','删除应用','192.168.100.163','2017-06-14 22:03:13','0','删除应用ID为  32 成功！','删除应用成功'), ('2843','63','增加应用','192.168.100.163','2017-06-14 22:07:07','0','增加应用名称为  adf 成功！','增加应用成功'), ('2844','63','删除应用','192.168.100.163','2017-06-14 22:07:13','0','删除应用ID为  33 成功！','删除应用成功'), ('2845','63','增加应用','192.168.100.163','2017-06-14 22:08:22','0','增加应用名称为  adadf 成功！','增加应用成功'), ('2846','63','删除应用','192.168.100.163','2017-06-14 22:09:54','0','删除应用ID为  34 成功！','删除应用成功'), ('2847','63','增加应用','192.168.100.163','2017-06-14 22:10:02','0','增加应用名称为  asdfadsf 成功！','增加应用成功'), ('2848','63','删除应用','192.168.100.163','2017-06-14 22:10:28','0','删除应用ID为  35 成功！','删除应用成功'), ('2849','63','增加应用','192.168.100.163','2017-06-14 22:10:34','0','增加应用名称为  asdf 成功！','增加应用成功'), ('2850','63','删除应用','192.168.100.163','2017-06-14 22:11:31','0','删除应用ID为  36 成功！','删除应用成功'), ('2851','63','增加应用','192.168.100.163','2017-06-14 22:13:04','0','增加应用名称为  asdfadf 成功！','增加应用成功'), ('2852','63','删除应用','192.168.100.163','2017-06-14 22:13:16','0','删除应用ID为  37 成功！','删除应用成功'), ('2853','63','增加应用','192.168.100.163','2017-06-14 22:13:49','0','增加应用名称为  adfadf 成功！','增加应用成功'), ('2854','63','删除应用','192.168.100.163','2017-06-14 22:13:52','0','删除应用ID为  38 成功！','删除应用成功'), ('2855','63','增加应用','192.168.100.163','2017-06-14 22:18:05','0','增加应用名称为  dsaff 成功！','增加应用成功'), ('2856','63','增加应用','192.168.100.163','2017-06-14 22:19:11','0','增加应用名称为  sadf 成功！','增加应用成功'), ('2857','63','删除应用','192.168.100.163','2017-06-14 22:19:28','0','删除应用ID为  39 成功！','删除应用成功'), ('2858','63','删除应用','192.168.100.163','2017-06-14 22:19:34','0','删除应用ID为  40 成功！','删除应用成功'), ('2859','63','增加应用','192.168.100.163','2017-06-14 22:52:27','0','增加应用名称为  werwqer 成功！','增加应用成功'), ('2860','63','删除应用','192.168.100.163','2017-06-14 22:52:32','0','删除应用ID为  41 成功！','删除应用成功'), ('2861','63','增加应用','192.168.100.163','2017-06-14 22:54:05','0','增加应用名称为  wqrqreq 成功！','增加应用成功'), ('2862','63','删除应用','192.168.100.163','2017-06-14 22:54:14','0','删除应用ID为  42 成功！','删除应用成功'), ('2863','63','更新应用','192.168.100.163','2017-06-14 22:56:48','0','更新应用ID为  21 成功！','更新应用成功'), ('2864','63','更新应用','192.168.100.163','2017-06-14 22:56:54','0','更新应用ID为  21 成功！','更新应用成功'), ('2865','63','增加应用','192.168.100.163','2017-06-14 22:58:19','0','增加应用名称为  asdfasdf 成功！','增加应用成功'), ('2866','63','更新应用','192.168.100.163','2017-06-14 22:58:44','0','更新应用ID为  43 成功！','更新应用成功'), ('2867','63','删除应用','192.168.100.163','2017-06-14 22:58:50','0','删除应用ID为  43 成功！','删除应用成功'), ('2868','63','增加应用','192.168.100.163','2017-06-14 23:00:48','0','增加应用名称为  qewrrr 成功！','增加应用成功'), ('2869','63','删除应用','192.168.100.163','2017-06-14 23:00:55','0','删除应用ID为  44 成功！','删除应用成功'), ('2870','63','增加应用','192.168.100.163','2017-06-14 23:01:02','0','增加应用名称为  qweqrewre 成功！','增加应用成功'), ('2871','63','删除应用','192.168.100.163','2017-06-14 23:01:08','0','删除应用ID为  45 成功！','删除应用成功'), ('2872','63','登录系统','192.168.100.163','2017-06-14 23:35:45','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2873','63','登录系统','192.168.100.163','2017-06-15 23:07:19','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2874','63','登录系统','192.168.100.163','2017-06-16 23:12:11','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2875','63','增加收支项目','192.168.100.163','2017-06-16 23:50:15','0','增加收支项目名称为  全车贴膜-普通 成功！','增加收支项目成功'), ('2876','63','增加收支项目','192.168.100.163','2017-06-16 23:50:28','0','增加收支项目名称为  全车贴膜-高档 成功！','增加收支项目成功'), ('2877','63','增加收支项目','192.168.100.163','2017-06-16 23:50:42','0','增加收支项目名称为  洗车 成功！','增加收支项目成功'), ('2878','63','增加收支项目','192.168.100.163','2017-06-16 23:51:09','0','增加收支项目名称为  保养汽车 成功！','增加收支项目成功'), ('2879','63','增加财务','192.168.100.163','2017-06-16 23:52:46','0','增加财务编号为  ffff 成功！','增加财务成功'), ('2880','63','保存财务明细','192.168.100.163','2017-06-16 23:52:47','0','保存财务明细对应主表编号为  42 成功！','保存财务明细成功'), ('2881','63','登录系统','192.168.100.163','2017-06-17 00:00:18','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2882','63','增加功能','192.168.100.163','2017-06-17 00:15:06','0','增加功能名称为  零售出库 成功！','增加功能成功'), ('2883','63','更新功能','192.168.100.163','2017-06-17 00:15:18','0','更新功能ID为  210 成功！','更新功能成功'), ('2884','63','更新功能','192.168.100.163','2017-06-17 00:15:42','0','更新功能ID为  40 成功！','更新功能成功'), ('2885','63','更新功能','192.168.100.163','2017-06-17 00:15:49','0','更新功能ID为  210 成功！','更新功能成功'), ('2886','63','更新UserBusiness','192.168.100.163','2017-06-17 00:16:12','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功'), ('2887','63','增加功能','192.168.100.163','2017-06-17 00:18:39','0','增加功能名称为  零售退货 成功！','增加功能成功'), ('2888','63','更新功能','192.168.100.163','2017-06-17 00:18:53','0','更新功能ID为  211 成功！','更新功能成功'), ('2889','63','更新功能','192.168.100.163','2017-06-17 00:19:28','0','更新功能ID为  211 成功！','更新功能成功'), ('2890','63','更新功能','192.168.100.163','2017-06-17 00:19:34','0','更新功能ID为  200 成功！','更新功能成功'), ('2891','63','更新功能','192.168.100.163','2017-06-17 00:19:37','0','更新功能ID为  201 成功！','更新功能成功'), ('2892','63','更新UserBusiness','192.168.100.163','2017-06-17 00:19:51','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功'), ('2893','63','更新功能','192.168.100.163','2017-06-17 00:27:01','0','更新功能ID为  210 成功！','更新功能成功'), ('2894','63','更新功能','192.168.100.163','2017-06-17 00:27:11','0','更新功能ID为  211 成功！','更新功能成功'), ('2895','63','登录系统','192.168.100.163','2017-06-18 18:19:08','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2896','63','登录系统','192.168.100.163','2017-06-18 18:33:22','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2897','63','增加仓管通','192.168.100.163','2017-06-18 18:53:02','0','增加仓管通编号为  sfd 成功！','增加仓管通成功'), ('2898','63','保存仓管通明细','192.168.100.163','2017-06-18 18:53:03','0','保存仓管通明细对应主表编号为  78 成功！','保存仓管通明细成功'), ('2899','63','增加仓管通','192.168.100.163','2017-06-18 18:59:49','0','增加仓管通编号为  fsdf 成功！','增加仓管通成功'), ('2900','63','保存仓管通明细','192.168.100.163','2017-06-18 18:59:49','0','保存仓管通明细对应主表编号为  79 成功！','保存仓管通明细成功'), ('2901','63','删除仓管通','192.168.100.163','2017-06-18 19:03:30','0','删除仓管通ID为  78 成功！','删除仓管通成功'), ('2902','63','增加仓管通','192.168.100.163','2017-06-18 19:35:34','0','增加仓管通编号为  sfsdf 成功！','增加仓管通成功'), ('2903','63','保存仓管通明细','192.168.100.163','2017-06-18 19:35:34','0','保存仓管通明细对应主表编号为  80 成功！','保存仓管通明细成功'), ('2904','63','增加仓管通','192.168.100.163','2017-06-18 19:36:33','0','增加仓管通编号为  fsfsd 成功！','增加仓管通成功'), ('2905','63','保存仓管通明细','192.168.100.163','2017-06-18 19:36:33','0','保存仓管通明细对应主表编号为  81 成功！','保存仓管通明细成功'), ('2906','63','删除仓管通','192.168.100.163','2017-06-18 19:46:39','0','删除仓管通ID为  79 成功！','删除仓管通成功'), ('2907','63','增加仓管通','192.168.100.163','2017-06-18 19:53:49','0','增加仓管通编号为  fasdf 成功！','增加仓管通成功'), ('2908','63','保存仓管通明细','192.168.100.163','2017-06-18 19:53:49','0','保存仓管通明细对应主表编号为  82 成功！','保存仓管通明细成功'), ('2909','63','增加仓管通','192.168.100.163','2017-06-18 22:56:17','0','增加仓管通编号为  qwe3 成功！','增加仓管通成功'), ('2910','63','保存仓管通明细','192.168.100.163','2017-06-18 22:56:17','0','保存仓管通明细对应主表编号为  83 成功！','保存仓管通明细成功'), ('2911','63','登录系统','192.168.100.163','2017-06-18 23:50:52','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2912','63','登录系统','192.168.100.163','2017-06-19 00:03:16','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2913','63','登录系统','192.168.100.163','2017-06-19 00:03:54','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2914','63','登录系统','192.168.100.163','2017-06-19 21:12:27','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2915','63','登录系统','192.168.100.163','2017-06-19 21:18:59','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2916','63','增加仓管通','192.168.100.163','2017-06-20 00:01:48','1','增加仓管通编号为  32141 失败！','增加仓管通失败'), ('2917','63','增加仓管通','192.168.100.163','2017-06-20 00:01:52','0','增加仓管通编号为  32141 成功！','增加仓管通成功'), ('2918','63','保存仓管通明细','192.168.100.163','2017-06-20 00:01:52','0','保存仓管通明细对应主表编号为  84 成功！','保存仓管通明细成功'), ('2919','63','登录系统','192.168.100.163','2017-06-20 00:32:08','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2920','63','登录系统','192.168.100.163','2017-06-20 00:34:18','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2921','63','增加仓管通','192.168.100.163','2017-06-20 00:34:45','0','增加仓管通编号为  1233 成功！','增加仓管通成功');
INSERT INTO `jsh_log` VALUES ('2922','63','保存仓管通明细','192.168.100.163','2017-06-20 00:34:45','0','保存仓管通明细对应主表编号为  85 成功！','保存仓管通明细成功'), ('2923','63','更新仓管通','192.168.100.163','2017-06-20 00:35:36','0','更新仓管通ID为  85 成功！','更新仓管通成功'), ('2924','63','保存仓管通明细','192.168.100.163','2017-06-20 00:35:36','0','保存仓管通明细对应主表编号为  85 成功！','保存仓管通明细成功'), ('2925','63','登录系统','192.168.100.163','2017-06-20 21:08:11','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2926','63','增加供应商','192.168.100.163','2017-06-20 21:18:12','0','增加供应商名称为  hy123456 成功！','增加供应商成功'), ('2927','63','更新供应商','192.168.100.163','2017-06-20 21:18:19','0','更新供应商ID为  7 成功！','更新供应商成功'), ('2928','63','更新供应商','192.168.100.163','2017-06-20 21:18:22','0','更新供应商ID为  7 成功！','更新供应商成功'), ('2929','63','更新供应商','192.168.100.163','2017-06-20 21:23:34','0','更新供应商ID为  7 成功！','更新供应商成功'), ('2930','63','更新供应商','192.168.100.163','2017-06-20 21:23:40','0','更新供应商ID为  7 成功！','更新供应商成功'), ('2931','63','增加供应商','192.168.100.163','2017-06-20 21:25:21','0','增加供应商名称为  hy00001 成功！','增加供应商成功'), ('2932','63','增加供应商','192.168.100.163','2017-06-20 21:25:52','0','增加供应商名称为  hy00002 成功！','增加供应商成功'), ('2933','63','登录系统','192.168.100.163','2017-06-20 21:42:31','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2934','63','退出系统','192.168.100.163','2017-06-20 21:47:41','0','管理用户：jsh 退出系统','jsh 退出系统'), ('2935','63','登录系统','192.168.100.163','2017-06-20 21:47:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2936','63','增加仓管通','192.168.100.163','2017-06-20 21:56:51','0','增加仓管通编号为  hb3124312431 成功！','增加仓管通成功'), ('2937','63','保存仓管通明细','192.168.100.163','2017-06-20 21:56:51','0','保存仓管通明细对应主表编号为  86 成功！','保存仓管通明细成功'), ('2938','63','更新仓管通','192.168.100.163','2017-06-20 21:57:24','0','更新仓管通ID为  86 成功！','更新仓管通成功'), ('2939','63','增加仓管通','192.168.100.163','2017-06-20 22:03:32','0','增加仓管通编号为  1231weraa 成功！','增加仓管通成功'), ('2940','63','保存仓管通明细','192.168.100.163','2017-06-20 22:03:32','0','保存仓管通明细对应主表编号为  87 成功！','保存仓管通明细成功'), ('2941','63','更新仓管通','192.168.100.163','2017-06-20 22:03:47','0','更新仓管通ID为  87 成功！','更新仓管通成功'), ('2942','63','更新仓管通','192.168.100.163','2017-06-20 22:55:55','0','更新仓管通ID为  87 成功！','更新仓管通成功'), ('2943','63','增加仓管通','192.168.100.163','2017-06-20 23:09:53','0','增加仓管通编号为  LSCK2017062023934 成功！','增加仓管通成功'), ('2944','63','保存仓管通明细','192.168.100.163','2017-06-20 23:09:53','0','保存仓管通明细对应主表编号为  88 成功！','保存仓管通明细成功'), ('2945','63','增加仓管通','192.168.100.163','2017-06-20 23:20:39','0','增加仓管通编号为  LSCK20170620232023 成功！','增加仓管通成功'), ('2946','63','保存仓管通明细','192.168.100.163','2017-06-20 23:20:39','0','保存仓管通明细对应主表编号为  89 成功！','保存仓管通明细成功'), ('2947','63','更新仓管通','192.168.100.163','2017-06-20 23:22:25','0','更新仓管通ID为  88 成功！','更新仓管通成功'), ('2948','63','更新仓管通','192.168.100.163','2017-06-20 23:22:48','0','更新仓管通ID为  89 成功！','更新仓管通成功'), ('2949','63','增加仓管通','192.168.100.163','2017-06-20 23:47:15','0','增加仓管通编号为  LSCK20170620234528 成功！','增加仓管通成功'), ('2950','63','保存仓管通明细','192.168.100.163','2017-06-20 23:47:15','0','保存仓管通明细对应主表编号为  90 成功！','保存仓管通明细成功'), ('2951','63','登录系统','192.168.100.163','2017-06-21 21:41:56','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2952','63','登录系统','192.168.100.163','2017-06-21 21:48:16','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2953','63','登录系统','192.168.100.163','2017-06-21 21:52:55','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2954','63','增加仓管通','192.168.100.163','2017-06-21 21:55:50','0','增加仓管通编号为  XSCK20170621215516 成功！','增加仓管通成功'), ('2955','63','保存仓管通明细','192.168.100.163','2017-06-21 21:55:50','0','保存仓管通明细对应主表编号为  91 成功！','保存仓管通明细成功'), ('2956','63','增加仓管通','192.168.100.163','2017-06-21 23:21:37','0','增加仓管通编号为  LSCK20170621232052 成功！','增加仓管通成功'), ('2957','63','保存仓管通明细','192.168.100.163','2017-06-21 23:21:37','0','保存仓管通明细对应主表编号为  92 成功！','保存仓管通明细成功'), ('2958','63','增加仓管通','192.168.100.163','2017-06-21 23:54:03','0','增加仓管通编号为  LSTH20170621235232 成功！','增加仓管通成功'), ('2959','63','保存仓管通明细','192.168.100.163','2017-06-21 23:54:03','0','保存仓管通明细对应主表编号为  93 成功！','保存仓管通明细成功'), ('2960','63','删除仓管通','192.168.100.163','2017-06-21 23:57:51','0','删除仓管通ID为  93 成功！','删除仓管通成功'), ('2961','63','登录系统','192.168.100.163','2017-06-22 21:18:42','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2962','63','登录系统','192.168.100.163','2017-06-22 22:09:34','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2963','63','更新仓管通','192.168.100.163','2017-06-22 22:35:46','0','更新仓管通ID为  67 成功！','更新仓管通成功'), ('2964','63','更新仓管通','192.168.100.163','2017-06-22 22:36:03','0','更新仓管通ID为  87 成功！','更新仓管通成功'), ('2965','63','更新仓管通','192.168.100.163','2017-06-22 22:37:32','0','更新仓管通ID为  83 成功！','更新仓管通成功'), ('2966','63','登录系统','192.168.100.163','2017-06-22 22:56:02','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2967','63','登录系统','192.168.100.163','2017-06-22 23:37:44','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2968','63','登录系统','192.168.100.163','2017-06-23 22:18:34','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2969','63','登录系统','192.168.100.163','2017-06-23 22:44:55','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2970','63','更新用户','','2017-06-23 22:48:32','0','更新用户ID为  63密码信息 成功！','更新用户成功'), ('2971','63','登录系统','192.168.100.163','2017-06-23 22:48:52','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2972','63','登录系统','192.168.100.163','2017-06-23 22:56:33','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2973','63','登录系统','192.168.100.163','2017-06-23 23:07:58','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2974','63','登录系统','192.168.100.163','2017-06-23 23:17:20','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2975','63','登录系统','192.168.100.163','2017-06-23 23:37:29','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2976','63','登录系统','192.168.100.163','2017-06-23 23:48:39','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2977','63','登录系统','192.168.100.163','2017-06-25 22:12:37','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2978','63','登录系统','192.168.100.163','2017-06-25 22:32:24','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2979','63','登录系统','192.168.100.163','2017-06-26 20:44:14','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2980','63','增加财务','192.168.100.163','2017-06-26 21:16:34','0','增加财务编号为  abcdefg 成功！','增加财务成功'), ('2981','63','保存财务明细','192.168.100.163','2017-06-26 21:16:34','0','保存财务明细对应主表编号为  43 成功！','保存财务明细成功'), ('2982','63','增加功能','192.168.100.163','2017-06-26 21:31:06','0','增加功能名称为  收预付款 成功！','增加功能成功'), ('2983','63','更新UserBusiness','192.168.100.163','2017-06-26 21:32:12','0','更新UserBusiness的ID为  5 成功！','更新UserBusiness成功'), ('2984','63','增加财务','192.168.100.163','2017-06-26 21:50:48','0','增加财务编号为  danju 成功！','增加财务成功'), ('2985','63','保存财务明细','192.168.100.163','2017-06-26 21:50:48','0','保存财务明细对应主表编号为  44 成功！','保存财务明细成功'), ('2986','63','登录系统','192.168.100.163','2017-06-26 22:38:26','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2987','63','登录系统','192.168.100.163','2017-06-26 22:40:40','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2988','63','更新财务','192.168.100.163','2017-06-26 23:00:07','0','更新财务ID为  44 成功！','更新财务成功'), ('2989','63','更新财务','192.168.100.163','2017-06-26 23:00:31','0','更新财务ID为  44 成功！','更新财务成功'), ('2990','63','更新财务','192.168.100.163','2017-06-26 23:06:49','0','更新财务ID为  44 成功！','更新财务成功'), ('2991','63','更新财务','192.168.100.163','2017-06-26 23:11:07','0','更新财务ID为  44 成功！','更新财务成功'), ('2992','63','更新供应商预付款','','2017-06-26 23:11:07','0','更新供应商ID为  8 成功！','更新供应商成功'), ('2993','63','更新供应商预付款','','2017-06-26 23:11:17','0','更新供应商ID为  8 成功！','更新供应商成功'), ('2994','63','更新财务','192.168.100.163','2017-06-26 23:11:17','0','更新财务ID为  44 成功！','更新财务成功'), ('2995','63','更新财务','192.168.100.163','2017-06-26 23:16:35','0','更新财务ID为  44 成功！','更新财务成功'), ('2996','63','更新供应商预付款','','2017-06-26 23:16:35','0','更新供应商ID为  8 成功！','更新供应商成功'), ('2997','63','登录系统','192.168.100.163','2017-06-26 23:48:42','0','管理用户：jsh 登录系统','jsh 登录系统'), ('2998','63','更新供应商预付款','','2017-06-26 23:49:09','0','更新供应商ID为  8 成功！','更新供应商成功'), ('2999','63','更新财务','192.168.100.163','2017-06-26 23:49:09','0','更新财务ID为  44 成功！','更新财务成功'), ('3000','63','更新财务','192.168.100.163','2017-06-26 23:49:55','0','更新财务ID为  44 成功！','更新财务成功'), ('3001','63','更新供应商预付款','','2017-06-26 23:49:55','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3002','63','登录系统','192.168.100.163','2017-06-26 23:52:46','0','管理用户：jsh 登录系统','jsh 登录系统'), ('3003','63','更新供应商预付款','','2017-06-26 23:53:01','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3004','63','更新财务','192.168.100.163','2017-06-26 23:53:01','0','更新财务ID为  44 成功！','更新财务成功'), ('3005','63','更新财务','192.168.100.163','2017-06-26 23:58:30','0','更新财务ID为  44 成功！','更新财务成功'), ('3006','63','更新供应商预付款','','2017-06-26 23:58:30','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3007','63','登录系统','192.168.100.163','2017-06-27 00:01:58','0','管理用户：jsh 登录系统','jsh 登录系统'), ('3008','63','更新财务','192.168.100.163','2017-06-27 00:02:16','0','更新财务ID为  44 成功！','更新财务成功'), ('3009','63','更新供应商预付款','','2017-06-27 00:02:16','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3010','63','登录系统','192.168.100.163','2017-06-27 00:27:16','0','管理用户：jsh 登录系统','jsh 登录系统'), ('3011','63','更新财务','192.168.100.163','2017-06-27 00:27:23','0','更新财务ID为  44 成功！','更新财务成功'), ('3012','63','更新供应商预付款','','2017-06-27 00:27:23','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3013','63','更新财务','192.168.100.163','2017-06-27 00:27:42','0','更新财务ID为  44 成功！','更新财务成功'), ('3014','63','更新供应商预付款','','2017-06-27 00:27:42','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3015','63','更新供应商','192.168.100.163','2017-06-27 00:28:37','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3016','63','更新财务','192.168.100.163','2017-06-27 00:28:47','0','更新财务ID为  44 成功！','更新财务成功'), ('3017','63','更新供应商预付款','','2017-06-27 00:28:47','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3018','63','更新供应商','192.168.100.163','2017-06-27 00:30:12','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3019','63','更新财务','192.168.100.163','2017-06-27 00:30:28','0','更新财务ID为  44 成功！','更新财务成功'), ('3020','63','保存财务明细','192.168.100.163','2017-06-27 00:30:29','0','保存财务明细对应主表编号为  44 成功！','保存财务明细成功'), ('3021','63','更新供应商预付款','','2017-06-27 00:30:29','0','更新供应商ID为  8 成功！','更新供应商成功');
INSERT INTO `jsh_log` VALUES ('3022','63','更新财务','192.168.100.163','2017-06-27 00:31:29','0','更新财务ID为  44 成功！','更新财务成功'), ('3023','63','更新供应商预付款','','2017-06-27 00:31:29','0','更新供应商ID为  9 成功！','更新供应商成功'), ('3024','63','登录系统','192.168.100.163','2017-06-27 20:43:10','0','管理用户：jsh 登录系统','jsh 登录系统'), ('3025','63','删除财务','192.168.100.163','2017-06-27 21:22:46','0','删除财务ID为  44 成功！','删除财务成功'), ('3026','63','更新供应商预付款','','2017-06-27 21:24:37','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3027','63','增加财务','192.168.100.163','2017-06-27 21:24:37','0','增加财务编号为  asdasd 成功！','增加财务成功'), ('3028','63','保存财务明细','192.168.100.163','2017-06-27 21:24:38','0','保存财务明细对应主表编号为  44 成功！','保存财务明细成功'), ('3029','63','更新供应商预付款','','2017-06-27 21:25:02','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3030','63','更新财务','192.168.100.163','2017-06-27 21:25:02','0','更新财务ID为  44 成功！','更新财务成功'), ('3031','63','保存财务明细','192.168.100.163','2017-06-27 21:25:02','0','保存财务明细对应主表编号为  44 成功！','保存财务明细成功'), ('3032','63','更新供应商预付款','','2017-06-27 21:25:18','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3033','63','更新财务','192.168.100.163','2017-06-27 21:25:18','0','更新财务ID为  44 成功！','更新财务成功'), ('3034','63','保存财务明细','192.168.100.163','2017-06-27 21:25:18','0','保存财务明细对应主表编号为  44 成功！','保存财务明细成功'), ('3035','63','更新供应商预付款','','2017-06-27 21:27:30','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3036','63','增加财务','192.168.100.163','2017-06-27 21:27:30','0','增加财务编号为  545qwe 成功！','增加财务成功'), ('3037','63','保存财务明细','192.168.100.163','2017-06-27 21:27:31','0','保存财务明细对应主表编号为  45 成功！','保存财务明细成功'), ('3038','63','更新供应商预付款','','2017-06-27 21:27:46','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3039','63','更新财务','192.168.100.163','2017-06-27 21:27:46','0','更新财务ID为  45 成功！','更新财务成功'), ('3040','63','保存财务明细','192.168.100.163','2017-06-27 21:27:46','0','保存财务明细对应主表编号为  45 成功！','保存财务明细成功'), ('3041','63','更新供应商预付款','','2017-06-27 21:28:02','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3042','63','更新财务','192.168.100.163','2017-06-27 21:28:02','0','更新财务ID为  45 成功！','更新财务成功'), ('3043','63','保存财务明细','192.168.100.163','2017-06-27 21:28:02','0','保存财务明细对应主表编号为  45 成功！','保存财务明细成功'), ('3044','63','更新供应商预付款','','2017-06-27 21:51:29','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3045','63','删除财务','192.168.100.163','2017-06-27 21:51:29','0','删除财务ID为  44 成功！','删除财务成功'), ('3046','63','更新供应商预付款','','2017-06-27 21:51:56','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3047','63','增加财务','192.168.100.163','2017-06-27 21:51:56','0','增加财务编号为  2314 成功！','增加财务成功'), ('3048','63','保存财务明细','192.168.100.163','2017-06-27 21:51:56','0','保存财务明细对应主表编号为  46 成功！','保存财务明细成功'), ('3049','63','更新供应商预付款','','2017-06-27 22:05:33','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3050','63','删除财务','192.168.100.163','2017-06-27 22:05:33','0','删除财务ID为  46 成功！','删除财务成功'), ('3051','63','批量删除财务','192.168.100.163','2017-06-27 22:05:41','0','批量删除财务ID为  45 成功！','批量删除财务成功'), ('3052','63','更新供应商预付款','','2017-06-27 22:07:07','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3053','63','增加财务','192.168.100.163','2017-06-27 22:07:07','0','增加财务编号为  123412 成功！','增加财务成功'), ('3054','63','保存财务明细','192.168.100.163','2017-06-27 22:07:07','0','保存财务明细对应主表编号为  47 成功！','保存财务明细成功'), ('3055','63','批量删除财务','192.168.100.163','2017-06-27 22:07:24','0','批量删除财务ID为  47 成功！','批量删除财务成功'), ('3056','63','更新供应商预付款','','2017-06-27 22:08:29','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3057','63','增加财务','192.168.100.163','2017-06-27 22:08:29','0','增加财务编号为  12341 成功！','增加财务成功'), ('3058','63','保存财务明细','192.168.100.163','2017-06-27 22:08:29','0','保存财务明细对应主表编号为  48 成功！','保存财务明细成功'), ('3059','63','批量删除财务','192.168.100.163','2017-06-27 22:08:33','0','批量删除财务ID为  48 成功！','批量删除财务成功'), ('3060','63','更新供应商预付款','','2017-06-27 22:11:23','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3061','63','增加财务','192.168.100.163','2017-06-27 22:11:23','0','增加财务编号为  wqeqw 成功！','增加财务成功'), ('3062','63','保存财务明细','192.168.100.163','2017-06-27 22:11:23','0','保存财务明细对应主表编号为  49 成功！','保存财务明细成功'), ('3063','63','批量删除财务','192.168.100.163','2017-06-27 22:15:27','0','批量删除财务ID为  49 成功！','批量删除财务成功'), ('3064','63','更新供应商预付款','','2017-06-27 22:17:18','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3065','63','增加财务','192.168.100.163','2017-06-27 22:17:18','0','增加财务编号为  2342 成功！','增加财务成功'), ('3066','63','保存财务明细','192.168.100.163','2017-06-27 22:17:18','0','保存财务明细对应主表编号为  50 成功！','保存财务明细成功'), ('3067','63','批量删除财务','192.168.100.163','2017-06-27 22:17:30','0','批量删除财务ID为  50 成功！','批量删除财务成功'), ('3068','63','更新供应商预付款','','2017-06-27 22:18:43','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3069','63','增加财务','192.168.100.163','2017-06-27 22:18:43','0','增加财务编号为  324234 成功！','增加财务成功'), ('3070','63','保存财务明细','192.168.100.163','2017-06-27 22:18:43','0','保存财务明细对应主表编号为  51 成功！','保存财务明细成功'), ('3071','63','批量删除财务','192.168.100.163','2017-06-27 22:18:53','0','批量删除财务ID为  51 成功！','批量删除财务成功'), ('3072','63','更新供应商预付款','','2017-06-27 22:20:01','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3073','63','增加财务','192.168.100.163','2017-06-27 22:20:01','0','增加财务编号为  4234 成功！','增加财务成功'), ('3074','63','保存财务明细','192.168.100.163','2017-06-27 22:20:01','0','保存财务明细对应主表编号为  52 成功！','保存财务明细成功'), ('3075','63','批量删除财务','192.168.100.163','2017-06-27 22:20:11','0','批量删除财务ID为  52 成功！','批量删除财务成功'), ('3076','63','更新供应商预付款','','2017-06-27 22:21:43','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3077','63','增加财务','192.168.100.163','2017-06-27 22:21:43','0','增加财务编号为  4223 成功！','增加财务成功'), ('3078','63','保存财务明细','192.168.100.163','2017-06-27 22:21:44','0','保存财务明细对应主表编号为  53 成功！','保存财务明细成功'), ('3079','63','更新供应商预付款','','2017-06-27 22:21:51','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3080','63','批量删除财务','192.168.100.163','2017-06-27 22:21:51','0','批量删除财务ID为  53 成功！','批量删除财务成功'), ('3081','63','更新供应商预付款','','2017-06-27 22:25:31','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3082','63','增加财务','192.168.100.163','2017-06-27 22:25:31','0','增加财务编号为  243423 成功！','增加财务成功'), ('3083','63','保存财务明细','192.168.100.163','2017-06-27 22:25:32','0','保存财务明细对应主表编号为  54 成功！','保存财务明细成功'), ('3084','63','更新供应商预付款','','2017-06-27 22:25:52','0','更新供应商ID为  9 成功！','更新供应商成功'), ('3085','63','增加财务','192.168.100.163','2017-06-27 22:25:52','0','增加财务编号为  2134124 成功！','增加财务成功'), ('3086','63','保存财务明细','192.168.100.163','2017-06-27 22:25:52','0','保存财务明细对应主表编号为  55 成功！','保存财务明细成功'), ('3087','63','增加财务','192.168.100.163','2017-06-27 22:26:12','0','增加财务编号为  42342 成功！','增加财务成功'), ('3088','63','更新供应商预付款','','2017-06-27 22:26:12','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3089','63','保存财务明细','192.168.100.163','2017-06-27 22:26:12','0','保存财务明细对应主表编号为  56 成功！','保存财务明细成功'), ('3090','63','更新供应商预付款','','2017-06-27 22:26:21','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3091','63','更新供应商预付款','','2017-06-27 22:26:21','0','更新供应商ID为  9 成功！','更新供应商成功'), ('3092','63','更新供应商预付款','','2017-06-27 22:26:21','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3093','63','批量删除财务','192.168.100.163','2017-06-27 22:26:21','0','批量删除财务ID为  56,55,54 成功！','批量删除财务成功'), ('3094','63','登录系统','192.168.100.163','2017-06-27 23:37:21','0','管理用户：jsh 登录系统','jsh 登录系统'), ('3095','63','更新供应商预付款','','2017-06-27 23:38:10','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3096','63','增加财务','192.168.100.163','2017-06-27 23:38:10','0','增加财务编号为  2342134 成功！','增加财务成功'), ('3097','63','保存财务明细','192.168.100.163','2017-06-27 23:38:10','0','保存财务明细对应主表编号为  57 成功！','保存财务明细成功'), ('3098','63','增加仓管通','192.168.100.163','2017-06-27 23:38:45','0','增加仓管通编号为  LSCK20170627233726 成功！','增加仓管通成功'), ('3099','63','保存仓管通明细','192.168.100.163','2017-06-27 23:38:45','0','保存仓管通明细对应主表编号为  93 成功！','保存仓管通明细成功'), ('3100','63','更新供应商预付款','','2017-06-27 23:38:45','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3101','63','登录系统','127.0.0.1','2017-06-28 20:48:57','0','管理用户：jsh 登录系统','jsh 登录系统'), ('3102','63','登录系统','192.168.100.163','2017-06-28 21:06:07','0','管理用户：jsh 登录系统','jsh 登录系统'), ('3103','63','登录系统','192.168.100.163','2017-06-28 21:22:18','0','管理用户：jsh 登录系统','jsh 登录系统'), ('3104','63','更新仓管通','192.168.100.163','2017-06-28 21:24:37','0','更新仓管通ID为  92 成功！','更新仓管通成功'), ('3105','63','登录系统','192.168.100.163','2017-06-28 21:27:29','0','管理用户：jsh 登录系统','jsh 登录系统'), ('3106','63','登录系统','192.168.100.163','2017-06-28 22:25:40','0','管理用户：jsh 登录系统','jsh 登录系统'), ('3107','63','增加仓管通','192.168.100.163','2017-06-28 22:42:13','0','增加仓管通编号为  LSCK20170628224159 成功！','增加仓管通成功'), ('3108','63','保存仓管通明细','192.168.100.163','2017-06-28 22:42:13','0','保存仓管通明细对应主表编号为  94 成功！','保存仓管通明细成功'), ('3109','63','更新供应商预付款','','2017-06-28 22:42:13','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3110','63','更新仓管通','192.168.100.163','2017-06-28 23:01:02','0','更新仓管通ID为  94 成功！','更新仓管通成功'), ('3111','63','保存仓管通明细','192.168.100.163','2017-06-28 23:01:02','0','保存仓管通明细对应主表编号为  94 成功！','保存仓管通明细成功'), ('3112','63','更新仓管通','192.168.100.163','2017-06-28 23:03:05','0','更新仓管通ID为  94 成功！','更新仓管通成功'), ('3113','63','保存仓管通明细','192.168.100.163','2017-06-28 23:03:05','0','保存仓管通明细对应主表编号为  94 成功！','保存仓管通明细成功'), ('3114','63','更新仓管通','192.168.100.163','2017-06-28 23:03:57','0','更新仓管通ID为  94 成功！','更新仓管通成功'), ('3115','63','保存仓管通明细','192.168.100.163','2017-06-28 23:03:58','0','保存仓管通明细对应主表编号为  94 成功！','保存仓管通明细成功'), ('3116','63','更新仓管通','192.168.100.163','2017-06-28 23:05:41','0','更新仓管通ID为  94 成功！','更新仓管通成功'), ('3117','63','保存仓管通明细','192.168.100.163','2017-06-28 23:05:41','0','保存仓管通明细对应主表编号为  94 成功！','保存仓管通明细成功'), ('3118','63','增加仓管通','192.168.100.163','2017-06-28 23:06:34','0','增加仓管通编号为  LSCK2017062823614 成功！','增加仓管通成功'), ('3119','63','保存仓管通明细','192.168.100.163','2017-06-28 23:06:34','0','保存仓管通明细对应主表编号为  95 成功！','保存仓管通明细成功'), ('3120','63','更新供应商预付款','','2017-06-28 23:06:35','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3121','63','更新仓管通','192.168.100.163','2017-06-28 23:07:07','0','更新仓管通ID为  95 成功！','更新仓管通成功');
INSERT INTO `jsh_log` VALUES ('3122','63','更新仓管通','192.168.100.163','2017-06-28 23:08:46','0','更新仓管通ID为  95 成功！','更新仓管通成功'), ('3123','63','更新供应商预付款','','2017-06-28 23:08:46','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3124','63','保存仓管通明细','192.168.100.163','2017-06-28 23:08:47','0','保存仓管通明细对应主表编号为  95 成功！','保存仓管通明细成功'), ('3125','63','更新仓管通','192.168.100.163','2017-06-28 23:09:07','0','更新仓管通ID为  95 成功！','更新仓管通成功'), ('3126','63','更新供应商预付款','','2017-06-28 23:09:07','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3127','63','保存仓管通明细','192.168.100.163','2017-06-28 23:09:07','0','保存仓管通明细对应主表编号为  95 成功！','保存仓管通明细成功'), ('3128','63','更新仓管通','192.168.100.163','2017-06-28 23:10:12','0','更新仓管通ID为  95 成功！','更新仓管通成功'), ('3129','63','更新供应商预付款','','2017-06-28 23:10:12','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3130','63','保存仓管通明细','192.168.100.163','2017-06-28 23:10:12','0','保存仓管通明细对应主表编号为  95 成功！','保存仓管通明细成功'), ('3131','63','更新供应商预付款','','2017-06-28 23:21:07','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3132','63','删除仓管通','192.168.100.163','2017-06-28 23:21:07','0','删除仓管通ID为  95 成功！','删除仓管通成功'), ('3133','63','批量删除仓管通','192.168.100.163','2017-06-28 23:32:12','0','批量删除仓管通ID为  94,93 成功！','批量删除仓管通成功'), ('3134','63','增加仓管通','192.168.100.163','2017-06-28 23:35:41','0','增加仓管通编号为  LSCK20170628233445 成功！','增加仓管通成功'), ('3135','63','更新供应商预付款','','2017-06-28 23:35:41','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3136','63','保存仓管通明细','192.168.100.163','2017-06-28 23:35:41','0','保存仓管通明细对应主表编号为  96 成功！','保存仓管通明细成功'), ('3137','63','更新供应商预付款','','2017-06-28 23:36:03','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3138','63','批量删除仓管通','192.168.100.163','2017-06-28 23:36:03','0','批量删除仓管通ID为  96 成功！','批量删除仓管通成功'), ('3139','63','增加仓管通','192.168.100.163','2017-06-28 23:36:27','0','增加仓管通编号为  LSCK20170628233610 成功！','增加仓管通成功'), ('3140','63','更新供应商预付款','','2017-06-28 23:36:27','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3141','63','保存仓管通明细','192.168.100.163','2017-06-28 23:36:27','0','保存仓管通明细对应主表编号为  97 成功！','保存仓管通明细成功'), ('3142','63','增加仓管通','192.168.100.163','2017-06-28 23:36:47','0','增加仓管通编号为  LSCK20170628233636 成功！','增加仓管通成功'), ('3143','63','更新供应商预付款','','2017-06-28 23:36:48','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3144','63','保存仓管通明细','192.168.100.163','2017-06-28 23:36:48','0','保存仓管通明细对应主表编号为  98 成功！','保存仓管通明细成功'), ('3145','63','更新供应商预付款','','2017-06-28 23:36:59','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3146','63','批量删除仓管通','192.168.100.163','2017-06-28 23:36:59','0','批量删除仓管通ID为  98,97 成功！','批量删除仓管通成功'), ('3147','63','更新供应商预付款','','2017-06-28 23:36:59','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3148','63','增加仓管通','192.168.100.163','2017-06-28 23:37:42','0','增加仓管通编号为  LSCK20170628233725 成功！','增加仓管通成功'), ('3149','63','更新供应商预付款','','2017-06-28 23:37:42','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3150','63','保存仓管通明细','192.168.100.163','2017-06-28 23:37:42','0','保存仓管通明细对应主表编号为  99 成功！','保存仓管通明细成功'), ('3151','63','增加仓管通','192.168.100.163','2017-06-28 23:38:00','0','增加仓管通编号为  LSCK20170628233749 成功！','增加仓管通成功'), ('3152','63','更新供应商预付款','','2017-06-28 23:38:00','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3153','63','保存仓管通明细','192.168.100.163','2017-06-28 23:38:01','0','保存仓管通明细对应主表编号为  100 成功！','保存仓管通明细成功'), ('3154','63','更新供应商预付款','','2017-06-28 23:38:04','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3155','63','删除仓管通','192.168.100.163','2017-06-28 23:38:04','0','删除仓管通ID为  100 成功！','删除仓管通成功'), ('3156','63','批量删除仓管通','192.168.100.163','2017-06-28 23:38:12','0','批量删除仓管通ID为  99 成功！','批量删除仓管通成功'), ('3157','63','更新供应商预付款','','2017-06-28 23:38:12','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3158','63','增加仓管通','192.168.100.163','2017-06-28 23:38:51','0','增加仓管通编号为  LSTH20170628233840 成功！','增加仓管通成功'), ('3159','63','保存仓管通明细','192.168.100.163','2017-06-28 23:38:51','0','保存仓管通明细对应主表编号为  101 成功！','保存仓管通明细成功'), ('3160','63','删除仓管通','192.168.100.163','2017-06-28 23:38:59','0','删除仓管通ID为  101 成功！','删除仓管通成功'), ('3161','63','更新仓管通','192.168.100.163','2017-06-28 23:39:06','0','更新仓管通ID为  81 成功！','更新仓管通成功'), ('3162','63','保存仓管通明细','192.168.100.163','2017-06-28 23:39:06','0','保存仓管通明细对应主表编号为  81 成功！','保存仓管通明细成功'), ('3163','63','更新供应商','192.168.100.163','2017-06-28 23:43:09','0','更新供应商ID为  9 成功！','更新供应商成功'), ('3164','63','增加供应商','192.168.100.163','2017-06-28 23:43:27','0','增加供应商名称为  42134 成功！','增加供应商成功'), ('3165','63','更新供应商','192.168.100.163','2017-06-28 23:43:42','0','更新供应商ID为  10 成功！','更新供应商成功'), ('3166','63','更新供应商','192.168.100.163','2017-06-28 23:43:50','0','更新供应商ID为  10 成功！','更新供应商成功'), ('3167','63','删除供应商','192.168.100.163','2017-06-28 23:43:54','0','删除供应商ID为  10,名称为  42134成功！','删除供应商成功'), ('3168','63','增加仓管通','192.168.100.163','2017-06-28 23:57:15','0','增加仓管通编号为  LSCK2017062823571 成功！','增加仓管通成功'), ('3169','63','更新供应商预付款','','2017-06-28 23:57:15','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3170','63','保存仓管通明细','192.168.100.163','2017-06-28 23:57:15','0','保存仓管通明细对应主表编号为  102 成功！','保存仓管通明细成功'), ('3171','63','更新仓管通','192.168.100.163','2017-06-28 23:57:33','0','更新仓管通ID为  102 成功！','更新仓管通成功'), ('3172','63','更新供应商预付款','','2017-06-28 23:57:33','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3173','63','登录系统','192.168.100.163','2017-06-29 00:00:39','0','管理用户：jsh 登录系统','jsh 登录系统'), ('3174','63','更新供应商预付款','','2017-06-29 00:01:49','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3175','63','删除仓管通','192.168.100.163','2017-06-29 00:01:49','0','删除仓管通ID为  102 成功！','删除仓管通成功'), ('3176','63','增加仓管通','192.168.100.163','2017-06-29 00:02:24','0','增加仓管通编号为  LSCK20170629029 成功！','增加仓管通成功'), ('3177','63','更新供应商预付款','','2017-06-29 00:02:24','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3178','63','保存仓管通明细','192.168.100.163','2017-06-29 00:02:24','0','保存仓管通明细对应主表编号为  103 成功！','保存仓管通明细成功'), ('3179','63','更新仓管通','192.168.100.163','2017-06-29 00:05:40','0','更新仓管通ID为  103 成功！','更新仓管通成功'), ('3180','63','更新仓管通','192.168.100.163','2017-06-29 00:06:10','0','更新仓管通ID为  103 成功！','更新仓管通成功'), ('3181','63','更新供应商预付款','','2017-06-29 00:06:10','0','更新供应商ID为  8 成功！','更新供应商成功'), ('3182','63','增加财务','192.168.100.163','2017-06-29 00:16:41','0','增加财务编号为  SR2017062901617 成功！','增加财务成功'), ('3183','63','保存财务明细','192.168.100.163','2017-06-29 00:16:41','0','保存财务明细对应主表编号为  58 成功！','保存财务明细成功'), ('3184','63','增加财务','192.168.100.163','2017-06-29 00:17:07','0','增加财务编号为  SK2017062901657 成功！','增加财务成功'), ('3185','63','保存财务明细','192.168.100.163','2017-06-29 00:17:07','0','保存财务明细对应主表编号为  59 成功！','保存财务明细成功'), ('3186','63','增加财务','192.168.100.163','2017-06-29 00:17:17','0','增加财务编号为  FK2017062901710 成功！','增加财务成功'), ('3187','63','保存财务明细','192.168.100.163','2017-06-29 00:17:17','0','保存财务明细对应主表编号为  60 成功！','保存财务明细成功'), ('3188','63','更新供应商预付款','','2017-06-29 00:17:28','0','更新供应商ID为  9 成功！','更新供应商成功'), ('3189','63','增加财务','192.168.100.163','2017-06-29 00:17:28','0','增加财务编号为  SYF2017062901721 成功！','增加财务成功'), ('3190','63','保存财务明细','192.168.100.163','2017-06-29 00:17:28','0','保存财务明细对应主表编号为  61 成功！','保存财务明细成功'), ('3191','63','更新财务','192.168.100.163','2017-06-29 00:25:02','0','更新财务ID为  61 成功！','更新财务成功'), ('3192','63','更新供应商预付款','','2017-06-29 00:25:03','0','更新供应商ID为  9 成功！','更新供应商成功');
INSERT INTO `jsh_material` VALUES ('485','1','棉线','A21-4321','米色','码','','1','1','1','1'), ('487','1','网布','12343','红色','码','','1','1','1','1'), ('498','1','蕾丝','B123','蓝色','码','','1.2','1','1.3','1.4'), ('499','1','棉线','A21-1234','米红色','码','','2.2','2','2.4','2.6');
INSERT INTO `jsh_materialcategory` VALUES ('1','根目录','1','1'), ('2','花边分类','1','1'), ('3','其他','1','1'), ('4','其他','2','3'), ('5','其他','3','4');
INSERT INTO `jsh_person` VALUES ('1','仓管员','张三-仓管','0'), ('2','仓管员','李四-仓管','0'), ('3','财务员','王五-财务','0'), ('4','财务员','赵六-财务','0');
INSERT INTO `jsh_role` VALUES ('4','管理员'), ('5','仓管员');
INSERT INTO `jsh_supplier` VALUES ('1','上海某某花边工厂','乔治','','','','1','供应商','\0','0',NULL,'20',NULL,NULL), ('2','客户AAAA','佩琪','','','','1','客户','\0','0',NULL,'30',NULL,NULL), ('4','苏州新源布料厂','龙哥','13000000000','312341@qq.com','55','1','供应商','\0','0','44',NULL,NULL,NULL), ('5','客户BBBB','彪哥','13000000000','666@qq.com','','1','客户','\0','0','20',NULL,NULL,NULL), ('6','南通宝贝家纺','姗姗','','','','1','客户','\0','0','20',NULL,NULL,NULL), ('7','非会员','宋江','13000000000','123456@qq.com','','1','散户','\0','0',NULL,NULL,NULL,NULL), ('8','hy00001','宋江','13000000000','','','1','散户','\0','944',NULL,NULL,NULL,NULL), ('9','hy00002','吴用','13000000000','','','1','散户','\0','33',NULL,NULL,NULL,NULL);
INSERT INTO `jsh_user` VALUES ('63','季圣华','jsh','e10adc3949ba59abbe56e057f20f883e','','','','','0','1','-1','',NULL), ('64','张三','zs','e10adc3949ba59abbe56e057f20f883e','','销售','','','0','1',NULL,'',NULL), ('65','李四','ls','e10adc3949ba59abbe56e057f20f883e','','销售','','','0','1',NULL,'',NULL);
INSERT INTO `jsh_userbusiness` VALUES ('1','RoleAPP','4','[21][1][8][11][10][19][16][15][12][7][17][20][18][3][6][22][23][24][25]'), ('2','RoleAPP','5','[8][7][6]'), ('3','RoleAPP','6','[21][1][8]'), ('4','RoleAPP','7','[21][1][8][11]'), ('5','RoleFunctions','4','[13][12][16][14][15][22][23][25][26][194][195][31][33][211][200][201][210][41][199][202][40][197][203][204][205][206][212][59][207][208][209]'), ('6','RoleFunctions','5','[22][23][25][26][194][195][31][33][200][201][41][199][202]'), ('7','RoleFunctions','6','[168][13][12][16][14][15][189][18][19]'), ('8','RoleAPP','8','[21][1][8][11][10]'), ('9','RoleFunctions','7','[168][13][12][16][14][15][189][18][19][132]'), ('10','RoleFunctions','8','[168][13][12][16][14][15][189][18][19][132][22][23][25][26][27][157][158][155][156][125][31][127][126][128][33][34][35][36][37][39][40][41][42][43][46][47][48][49][50][51][52][53][54][55][56][57][192][59][60][61][62][63][65][66][68][69][70][71][73][74][76][77][79][191][81][82][83][85][89][161][86][176][165][160][28][134][91][92][29][94][95][97][104][99][100][101][102][105][107][108][110][111][113][114][116][117][118][120][121][131][135][123][122][20][130][146][147][138][148][149][153][140][145][184][152][143][170][171][169][166][167][163][164][172][173][179][178][181][182][183][186][187]'), ('11','RoleFunctions','9','[168][13][12][16][14][15][189][18][19][132][22][23][25][26][27][157][158][155][156][125][31][127][126][128][33][34][35][36][37][39][40][41][42][43][46][47][48][49][50][51][52][53][54][55][56][57][192][59][60][61][62][63][65][66][68][69][70][71][73][74][76][77][79][191][81][82][83][85][89][161][86][176][165][160][28][134][91][92][29][94][95][97][104][99][100][101][102][105][107][108][110][111][113][114][116][117][118][120][121][131][135][123][122][20][130][146][147][138][148][149][153][140][145][184][152][143][170][171][169][166][167][163][164][172][173][179][178][181][182][183][186][187][188]'), ('12','UserRole','1','[5]'), ('13','UserRole','2','[6][7]'), ('14','UserDepot','2','[1][2][6][7]'), ('15','UserDepot','1','[1][2][5][6][7][10][12][14][15][17]'), ('16','UserRole','63','[4]'), ('17','RoleFunctions','13','[46][47][48][49]'), ('18','UserDepot','63','[1][3]'), ('19','UserDepot','5','[6][45][46][50]'), ('20','UserRole','5','[5]'), ('21','UserRole','64','[5]'), ('22','UserDepot','64','[1]'), ('23','UserRole','65','[5]'), ('24','UserDepot','65','[1]');
