/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.dashboard.inmem;

import com.alibaba.csp.sentinel.command.vo.NodeVo;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.fastjson.JSON;
import com.taobao.csp.sentinel.dashboard.datasource.entity.DegradeRuleEntity;
import com.taobao.csp.sentinel.dashboard.datasource.entity.FlowRuleEntity;
import com.taobao.csp.sentinel.dashboard.datasource.entity.SystemRuleEntity;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HttpHelper {
    private static Logger logger = LoggerFactory.getLogger(HttpHelper.class);
    private static final Charset defaultCharset = Charset.forName(SentinelConfig.charset());
    private CloseableHttpAsyncClient httpclient;
    private final String resourceUrlPath = "jsonTree";
    private final String clusterNodePath = "clusterNode";
    private final String getRulesPath = "getRules";
    private final String setRulesPath = "setRules";
    private final String flowRuleType = "flow";
    private final String degradeRuleType = "degrade";
    private final String systemRuleType = "system";

    public HttpHelper() {
        IOReactorConfig ioConfig = IOReactorConfig.custom().setConnectTimeout(3000).setSoTimeout(3000).setIoThreadCount(Runtime.getRuntime().availableProcessors() * 2).build();
        this.httpclient = HttpAsyncClients.custom().setRedirectStrategy((RedirectStrategy)new /* Unavailable Anonymous Inner Class!! */).setMaxConnTotal(4000).setMaxConnPerRoute(1000).setDefaultIOReactorConfig(ioConfig).build();
        this.httpclient.start();
    }

    public List<NodeVo> fetchResourceOfMachine(String ip, int port, String type) {
        String url = "http://" + ip + ":" + port + "/" + "jsonTree" + "?type=" + type;
        String body = this.httpGetContent(url);
        if (body == null) {
            return null;
        }
        try {
            return JSON.parseArray((String)body, NodeVo.class);
        }
        catch (Exception e) {
            logger.info("parse ResourceOfMachine error", (Throwable)e);
            return null;
        }
    }

    public List<NodeVo> fetchClusterNodeOfMachine(String ip, int port, boolean includeZero) {
        String url;
        String body;
        String type = "noZero";
        if (includeZero) {
            type = "zero";
        }
        if ((body = this.httpGetContent(url = "http://" + ip + ":" + port + "/" + "clusterNode" + "?type=" + type)) == null) {
            return null;
        }
        try {
            return JSON.parseArray((String)body, NodeVo.class);
        }
        catch (Exception e) {
            logger.info("parse ClusterNodeOfMachine error", (Throwable)e);
            return null;
        }
    }

    public List<FlowRuleEntity> fetchFlowRuleOfMachine(String app, String ip, int port) {
        String url = "http://" + ip + ":" + port + "/" + "getRules" + "?type=" + "flow";
        String body = this.httpGetContent(url);
        logger.info("FlowRule Body:{}", (Object)body);
        List rules = this.parseFlowRule(body);
        if (rules != null) {
            return rules.stream().map(rule -> FlowRuleEntity.fromFlowRule((String)app, (String)ip, (Integer)port, (FlowRule)rule)).collect(Collectors.toList());
        }
        return null;
    }

    public List<DegradeRuleEntity> fetchDegradeRuleOfMachine(String app, String ip, int port) {
        String url = "http://" + ip + ":" + port + "/" + "getRules" + "?type=" + "degrade";
        String body = this.httpGetContent(url);
        logger.info("Degrade Body:{}", (Object)body);
        List rules = this.parseDegradeRule(body);
        if (rules != null) {
            return rules.stream().map(rule -> DegradeRuleEntity.fromDegradeRule((String)app, (String)ip, (Integer)port, (DegradeRule)rule)).collect(Collectors.toList());
        }
        return null;
    }

    public List<SystemRuleEntity> fetchSystemRuleOfMachine(String app, String ip, int port) {
        String url = "http://" + ip + ":" + port + "/" + "getRules" + "?type=" + "system";
        String body = this.httpGetContent(url);
        logger.info("SystemRule Body:{}", (Object)body);
        List rules = this.parseSystemRule(body);
        if (rules != null) {
            return rules.stream().map(rule -> SystemRuleEntity.fromSystemRule((String)app, (String)ip, (Integer)port, (SystemRule)rule)).collect(Collectors.toList());
        }
        return null;
    }

    public boolean setFlowRuleOfMachine(String app, String ip, int port, List<FlowRuleEntity> rules) {
        if (rules == null) {
            return true;
        }
        if (ip == null) {
            throw new IllegalArgumentException("ip is null");
        }
        String data = JSON.toJSONString(rules.stream().map(FlowRuleEntity::toFlowRule).collect(Collectors.toList()));
        try {
            data = URLEncoder.encode(data, defaultCharset.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.info("encode rule error", (Throwable)e);
            return false;
        }
        String url = "http://" + ip + ":" + port + "/" + "setRules" + "?type=" + "flow" + "&data=" + data;
        String result = this.httpGetContent(url);
        logger.info("setFlowRule: " + result);
        return true;
    }

    public boolean setDegradeRuleOfMachine(String app, String ip, int port, List<DegradeRuleEntity> rules) {
        if (rules == null) {
            return true;
        }
        if (ip == null) {
            throw new IllegalArgumentException("ip is null");
        }
        String data = JSON.toJSONString(rules.stream().map(DegradeRuleEntity::toDegradeRule).collect(Collectors.toList()));
        try {
            data = URLEncoder.encode(data, defaultCharset.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.info("encode rule error", (Throwable)e);
            return false;
        }
        String url = "http://" + ip + ":" + port + "/" + "setRules" + "?type=" + "degrade" + "&data=" + data;
        String result = this.httpGetContent(url);
        logger.info("setDegradeRule: " + result);
        return true;
    }

    public boolean setSystemRuleOfMachine(String app, String ip, int port, List<SystemRuleEntity> rules) {
        if (rules == null) {
            return true;
        }
        if (ip == null) {
            throw new IllegalArgumentException("ip is null");
        }
        String data = JSON.toJSONString(rules.stream().map(SystemRuleEntity::toSystemRule).collect(Collectors.toList()));
        try {
            data = URLEncoder.encode(data, defaultCharset.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.info("encode rule error", (Throwable)e);
            return false;
        }
        String url = "http://" + ip + ":" + port + "/" + "setRules" + "?type=" + "system" + "&data=" + data;
        String result = this.httpGetContent(url);
        logger.info("setSystemRule: " + result);
        return true;
    }

    private List<FlowRule> parseFlowRule(String body) {
        try {
            return JSON.parseArray((String)body, FlowRule.class);
        }
        catch (Exception e) {
            logger.info("parser FlowRule error: ", (Throwable)e);
            return null;
        }
    }

    private List<DegradeRule> parseDegradeRule(String body) {
        try {
            return JSON.parseArray((String)body, DegradeRule.class);
        }
        catch (Exception e) {
            logger.info("parser DegradeRule error: ", (Throwable)e);
            return null;
        }
    }

    private List<SystemRule> parseSystemRule(String body) {
        try {
            return JSON.parseArray((String)body, SystemRule.class);
        }
        catch (Exception e) {
            logger.info("parser SystemRule error: ", (Throwable)e);
            return null;
        }
    }

    private String httpGetContent(String url) {
        HttpGet httpGet = new HttpGet(url);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference reference = new AtomicReference();
        this.httpclient.execute((HttpUriRequest)httpGet, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
        try {
            latch.await(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.info("wait http client error:", (Throwable)e);
        }
        return (String)reference.get();
    }

    private String getBody(HttpResponse response) throws Exception {
        Charset charset = null;
        try {
            String contentTypeStr = response.getFirstHeader("Content-type").getValue();
            ContentType contentType = ContentType.parse((String)contentTypeStr);
            charset = contentType.getCharset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)(charset != null ? charset : defaultCharset));
    }

    static /* synthetic */ String access$000(HttpHelper x0, HttpResponse x1) throws Exception {
        return x0.getBody(x1);
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }
}

