## How to contribute to Curve

### Report Bugs

**Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/opencurve/curve/issues).

If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/opencurve/curve/issues/new?assignees=&labels=bug&template=bug_report.md&title=). 
Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

### Suggesting Enhancements

Check if you're using the latest version of Curve.

If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/opencurve/curve/issues/new?assignees=&labels=enhancement&template=feature_request.md&title=). 

### Code Contribution

Please follow [google c++ styleguide](https://zh-google-styleguide.readthedocs.io/en/latest/google-cpp-styleguide/contents/)

**Write Test Code**. Make sure you pass the Unit test and Integration test. The test lines coverage rate must 80% above，branches coverage rate must 70% above.

[How to build and run test?](docs/cn/build_and_run.md#%E6%B5%8B%E8%AF%95%E7%94%A8%E4%BE%8B%E7%BC%96%E8%AF%91%E5%8F%8A%E6%89%A7%E8%A1%8C)

### Pull Requests

Please create pull request to opencurve/curve **master** branch. 

Please follow these steps to have your contribution considered by the maintainers:

* Follow all instructions in the template

* Follow the styleguides

* After you submit your pull request, verify that all status checks are passing

While the prerequisites above must be satisfied prior to having your pull request reviewed, the reviewer(s) may ask you to complete additional design work, tests, or other changes before your pull request can be ultimately accepted.
