/*
 *  Copyright (c) 2020 NetEase Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * Project: curve
 * Created Date: Monday December 24th 2018
 * Author: yangyaokai
 */

#include <gtest/gtest.h>
#include "src/fs/local_filesystem.h"

namespace curve {
namespace fs {

class LocalFSFactoryTest : public testing::Test {
 public:
    LocalFSFactoryTest() {}
    ~LocalFSFactoryTest() {}
};

TEST_F(LocalFSFactoryTest, CreateTest) {
    std::shared_ptr<LocalFileSystem> lfs1 =
        LocalFsFactory::CreateFs(FileSystemType::EXT4, "");
    ASSERT_NE(lfs1, nullptr);
    std::shared_ptr<LocalFileSystem> lfs2 =
        LocalFsFactory::CreateFs(FileSystemType::EXT4, "");
    // singleton
    ASSERT_EQ(lfs1.get(), lfs2.get());
}

}  // namespace fs
}  // namespace curve
