/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.buck.android.support.exopackage;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import com.facebook.buck.android.support.exopackage.ApplicationLike;
import com.facebook.buck.android.support.exopackage.DefaultApplicationLike;
import com.facebook.buck.android.support.exopackage.ExopackageDexLoader;
import com.facebook.buck.android.support.exopackage.ExopackageSoLoader;
import java.lang.reflect.Constructor;

public abstract class ExopackageApplication<T extends ApplicationLike>
extends Application {
    private static final int SECONDARY_DEX_MASK = 1;
    private static final int NATIVE_LIBRARY_MASK = 2;
    private final String delegateClassName;
    private final int exopackageFlags;
    private T delegate;

    protected ExopackageApplication(int exopackageFlags) {
        this(DefaultApplicationLike.class.getName(), exopackageFlags);
    }

    protected ExopackageApplication(String delegateClassName, int exopackageFlags) {
        this.delegateClassName = delegateClassName;
        this.exopackageFlags = exopackageFlags;
    }

    private boolean isExopackageEnabledForSecodaryDex() {
        return (this.exopackageFlags & 1) != 0;
    }

    private boolean isExopackageEnabledForNativeLibraries() {
        return (this.exopackageFlags & 2) != 0;
    }

    private T createDelegate() {
        if (this.isExopackageEnabledForSecodaryDex()) {
            ExopackageDexLoader.loadExopackageJars((Context)this);
        }
        if (this.isExopackageEnabledForNativeLibraries()) {
            ExopackageSoLoader.init((Context)this);
        }
        try {
            Class<?> implClass = Class.forName(this.delegateClassName);
            Constructor<?> constructor = implClass.getConstructor(Application.class);
            return (T)((ApplicationLike)constructor.newInstance(new Object[]{this}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void ensureDelegate() {
        if (this.delegate == null) {
            this.delegate = this.createDelegate();
        }
    }

    protected void onBaseContextAttached() {
    }

    public final T getDelegateIfPresent() {
        return this.delegate;
    }

    protected final void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.onBaseContextAttached();
        this.ensureDelegate();
    }

    public final void onCreate() {
        super.onCreate();
        this.ensureDelegate();
        this.delegate.onCreate();
    }

    public final void onTerminate() {
        super.onTerminate();
        if (this.delegate != null) {
            this.delegate.onTerminate();
        }
    }

    public final void onLowMemory() {
        super.onLowMemory();
        if (this.delegate != null) {
            this.delegate.onLowMemory();
        }
    }

    @TargetApi(value=14)
    public final void onTrimMemory(int level) {
        super.onTrimMemory(level);
        if (this.delegate != null) {
            this.delegate.onTrimMemory(level);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.delegate != null) {
            this.delegate.onConfigurationChanged(newConfig);
        }
    }
}

