/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * This file is used by the React Native website to show the props of core components
 * This file was generated by running scripts/generate-api-docs.js
 *
 * @generated SignedSource<<99203c7cf79ad84e3ce1e508a22416fe>>
 */

'use strict';

module.exports = [
  {
    "description": "A visual toggle between two mutually exclusive states.\n\nThis is a controlled component that requires an `onValueChange` callback that\nupdates the `value` prop in order for the component to reflect user actions.\nIf the `value` prop is not updated, the component will continue to render the\nsupplied `value` prop instead of the expected result of any user actions.",
    "displayName": "Switch",
    "methods": [],
    "props": {
      "disabled": {
        "required": false,
        "flowType": {
          "name": "boolean",
          "nullable": true
        },
        "description": "Whether the switch is disabled. Defaults to false."
      },
      "value": {
        "required": false,
        "flowType": {
          "name": "boolean",
          "nullable": true
        },
        "description": "Boolean value of the switch. Defaults to false."
      },
      "thumbColor": {
        "required": false,
        "flowType": {
          "name": "ColorValue",
          "nullable": true
        },
        "description": "Custom color for the switch thumb."
      },
      "trackColor": {
        "required": false,
        "flowType": {
          "name": "$ReadOnly",
          "elements": [
            {
              "name": "signature",
              "type": "object",
              "raw": "{|\n  false?: ?ColorValue,\n  true?: ?ColorValue,\n|}",
              "signature": {
                "properties": [
                  {
                    "key": "false",
                    "value": {
                      "name": "ColorValue",
                      "nullable": true,
                      "required": false
                    }
                  },
                  {
                    "key": "true",
                    "value": {
                      "name": "ColorValue",
                      "nullable": true,
                      "required": false
                    }
                  }
                ]
              }
            }
          ],
          "raw": "$ReadOnly<{|\n  false?: ?ColorValue,\n  true?: ?ColorValue,\n|}>",
          "nullable": true
        },
        "description": "Custom colors for the switch track.\n\nNOTE: On iOS when the switch value is false, the track shrinks into the\nborder. If you want to change the color of the background exposed by the\nshrunken track, use `ios_backgroundColor`."
      },
      "ios_backgroundColor": {
        "required": false,
        "flowType": {
          "name": "ColorValue",
          "nullable": true
        },
        "description": "On iOS, custom color for the background. This background color can be seen\neither when the switch value is false or when the switch is disabled (and\nthe switch is translucent)."
      },
      "onChange": {
        "required": false,
        "flowType": {
          "name": "signature",
          "type": "function",
          "raw": "(event: SwitchChangeEvent) => Promise<void> | void",
          "signature": {
            "arguments": [
              {
                "name": "event",
                "type": {
                  "name": "SyntheticEvent",
                  "elements": [
                    {
                      "name": "$ReadOnly",
                      "elements": [
                        {
                          "name": "signature",
                          "type": "object",
                          "raw": "{|\n  value: boolean,\n|}",
                          "signature": {
                            "properties": [
                              {
                                "key": "value",
                                "value": {
                                  "name": "boolean",
                                  "required": true
                                }
                              }
                            ]
                          }
                        }
                      ],
                      "raw": "$ReadOnly<{|\n  value: boolean,\n|}>"
                    }
                  ],
                  "raw": "SyntheticEvent<\n  $ReadOnly<{|\n    value: boolean,\n  |}>,\n>"
                }
              }
            ],
            "return": {
              "name": "union",
              "raw": "Promise<void> | void",
              "elements": [
                {
                  "name": "Promise",
                  "elements": [
                    {
                      "name": "void"
                    }
                  ],
                  "raw": "Promise<void>"
                },
                {
                  "name": "void"
                }
              ]
            }
          },
          "nullable": true
        },
        "description": "Called when the user tries to change the value of the switch.\n\nReceives the change event as an argument. If you want to only receive the\nnew value, use `onValueChange` instead."
      },
      "onValueChange": {
        "required": false,
        "flowType": {
          "name": "signature",
          "type": "function",
          "raw": "(value: boolean) => Promise<void> | void",
          "signature": {
            "arguments": [
              {
                "name": "value",
                "type": {
                  "name": "boolean"
                }
              }
            ],
            "return": {
              "name": "union",
              "raw": "Promise<void> | void",
              "elements": [
                {
                  "name": "Promise",
                  "elements": [
                    {
                      "name": "void"
                    }
                  ],
                  "raw": "Promise<void>"
                },
                {
                  "name": "void"
                }
              ]
            }
          },
          "nullable": true
        },
        "description": "Called when the user tries to change the value of the switch.\n\nReceives the new value as an argument. If you want to instead receive an\nevent, use `onChange`."
      }
    },
    "composes": [
      "ViewProps"
    ]
  }
]
