<?php
!defined('IN_ONEZ') && exit('Access Denied');
include_once(dirname(__FILE__).'/init.php');
$fee1=(float)onez('chat.group.plugin.credit')->option('cash_fee1');
$fee2=(float)onez('chat.group.plugin.credit')->option('cash_fee2');
$format=(int)onez('chat.group.plugin.credit')->option('format');
$payinfo=array();
if(!$G['user']['pay_alipay'] && !$G['user']['pay_weixin']){
  $payinfo[]=array('label'=>'真实姓名','type'=>'text','key'=>'pay_realname','hint'=>'','notempty'=>'真实姓名不能为空','group'=>'');
  $payinfo[]=array('label'=>'支付宝账号','type'=>'text','key'=>'pay_alipay','hint'=>'','notempty'=>'','group'=>'');
  $payinfo[]=array('label'=>'微信号账号','type'=>'text','key'=>'pay_weixin','hint'=>'','notempty'=>'','group'=>'');
  include_once(dirname(__FILE__).'/payinfo.php');
  return;
}
$A['title']='申请提现';
if(defined('IS_POST')){
  $onez=array(
    'key1'=>(float)onez()->gp('key1'),
    'key2'=>onez()->gp('key2'),
    'summary'=>onez()->gp('summary'),
  );
  $money=onez('chat.group.plugin.credit')->format($onez['key1']);
  if($money<=0){
    $A['tip']='提现金额有误';
    return $A;
  }
  
  $total=$money;
  $fee=0;
  if($fee1>0){
    $total+=$money*$fee1/100;
    $fee+=$money*$fee1/100;
  }
  if($fee2>0){
    $total+=$fee2;
    $fee+=$fee2;
  }
  $fee=onez('chat.group.plugin.credit')->format($fee);
  
  $total=onez('chat.group.plugin.credit')->format($total);
  $total<=0 && onez()->error('提现金额有误');
  
  if($total>onez('chat.group.plugin.credit')->value($G['userid'])){
    $A['tip']='账户余额不足，请充值！';
    return $A;
  }
  
  onez('chat.group.plugin.credit')->add($G['userid'],'money',-$money,'trun',"申请提现");
  if($fee>0){
    onez('chat.group.plugin.credit')->add($G['userid'],'money',-$fee,'trun',"提现手续费");
  }
  
  
  $item=array();
  $item['userid']=$G['userid'];
  $item['money1']=$money;
  $item['money2']=$total;
  $item['money3']=$fee;
  $item['money']=$money;
  $item['total']=$total;
  $item['fee']=$fee;
  $item['key2']=$onez['key2'];
  $item['token']='wait';
  $id=$G['this']->data()->open('cash')->insert($item);
  
  $A['tip']='提交成功';
  $A['exit']='1';
  $A['token']='page';
  $A['action']=$this->action('cash.log');
  return;
}
$A['right']=array(
  'subject'=>'提现记录',
  'token'=>'page',
  'action'=>$this->action('cash.log'),
);
$record[]=array(
  'type'=>'space',
  'height'=>'5',
);
$options=array();
if($G['user']['pay_alipay']){
  $text="支付宝|{$G['user']['pay_realname']}|{$G['user']['pay_alipay']}";
  $options[$text]=$text;
}
if($G['user']['pay_weixin']){
  $text="微信|{$G['user']['pay_realname']}|{$G['user']['pay_weixin']}";
  $options[$text]=$text;
}
$record[]=array(
  'type'=>'select',
  'label'=>'收款账号',
  'key'=>'key2',
  'options'=>$options,
  'value'=>key($options),
);
$record[]=array(
  'type'=>'info',
  'label'=>'我的'.onez('chat.group.plugin.credit')->name(),
  'value'=>onez('chat.group.plugin.credit')->value($G['userid']),
);
$record[]=array(
  'type'=>'input',
  'label'=>'提现金额',
  'key'=>'key1',
  'inputype'=>'number',
  'hint'=>'请正确填写您提现的金额',
  'notempty'=>'提现金额不能为空',
);
$record[]=array(
  'type'=>'info',
  'label'=>'手续费',
  'value'=>'<span class="fee_label">0.00</span>',
);
$record[]=array(
  'type'=>'info',
  'label'=>'支付总额',
  'value'=>'<span class="total_label">0.00</span>',
);
$record[]=array(
  'type'=>'input',
  'label'=>'备注信息',
  'key'=>'summary',
  'inputype'=>'textarea',
  'hint'=>'',
  'notempty'=>'',
);
$record[]=array(
  'type'=>'space',
  'height'=>'5',
);
$record[]=array(
  'type'=>'button',
  'style'=>'2',
  'name'=>'提交申请',
  'token'=>'submit',
);

$code='';
if($fee1>0){
  $code.="
    label+=' * $fee1%';
    fee+=value*$fee1/100;
    total+=value*$fee1/100;
  ";
}
if($fee2>0){
  $code.="
    label+=' + $fee2';
    fee+=$fee2;
    total+=$fee2;
  ";
}
$A['code']=<<<ONEZ
  page.ui.find('#input_key1').bind('input keyup',function(){
    var value=$(this).val();
    if(value.length<1 || isNaN(value)){
      value=0;
    }
    value=parseFloat(value+'');
    var total=value;
    var label='';
    var fee=0;
    $code
    if(label==''){
      label=fee.toFixed($format);
    }else{
      label=value+''+label;
      label+=' = '+fee.toFixed($format);
    }
    page.ui.find('.fee_label').html(label);
    page.ui.find('.total_label').html(total.toFixed($format));
  });
ONEZ;
