<?php
!defined('IN_ONEZ') && exit('Access Denied');
include_once(dirname(__FILE__).'/init.php');

$payinfo=array();
if(!$G['user']['pay_alipay'] && !$G['user']['pay_weixin']){
  $payinfo[]=array('label'=>'真实姓名','type'=>'text','key'=>'pay_realname','hint'=>'','notempty'=>'真实姓名不能为空','group'=>'');
  $payinfo[]=array('label'=>'支付宝账号','type'=>'text','key'=>'pay_alipay','hint'=>'','notempty'=>'','group'=>'');
  $payinfo[]=array('label'=>'微信号账号','type'=>'text','key'=>'pay_weixin','hint'=>'','notempty'=>'','group'=>'');
  include_once(dirname(__FILE__).'/payinfo.php');
  exit();
}

$groupid=onez()->gp('groupid');
$gid=(int)onez()->gp('gid');

$fee1=(float)onez('chat.group.plugin.credit')->option('cash_fee1');
$fee2=(float)onez('chat.group.plugin.credit')->option('cash_fee2');
$format=(int)onez('chat.group.plugin.credit')->option('format');

$G['title']='提现';

#初始化表单
$form=onez('admin')->widget('form')
  ->set('title',$G['title'])
  ->set('values',$item)
;
#创建表单项
$form->add(array('type'=>'hidden','key'=>'action','value'=>'save'));

$options=array();
if($G['user']['pay_alipay']){
  $text="支付宝|{$G['user']['pay_realname']}|{$G['user']['pay_alipay']}";
  $options[$text]=$text;
}
if($G['user']['pay_weixin']){
  $text="微信|{$G['user']['pay_realname']}|{$G['user']['pay_weixin']}";
  $options[$text]=$text;
}
$form->add(array('label'=>'收款账号','type'=>'select','key'=>'key2','options'=>$options));
$form->add(array('label'=>'我的'.onez('chat.group.plugin.credit')->name(),'type'=>'html','html'=>'<code>'.onez('chat.group.plugin.credit')->value($G['userid']).'</code>','hint'=>''));
$form->add(array('label'=>'提现金额','type'=>'text','key'=>'key1','hint'=>'','notempty'=>'提现金额不能为空','group'=>''));
$form->add(array('label'=>'手续费','type'=>'html','html'=>'<pre id="fee_label">0.00</pre>'));
$form->add(array('label'=>'支付总额','type'=>'html','html'=>'<pre id="total_label">0.00</pre>'));

$form->add(array('label'=>'备注信息','type'=>'textarea','key'=>'summary','hint'=>'','notempty'=>'','group'=>''));

#$charge_intro=onez('chat.group.plugin.credit')->option('charge_intro');
#$charge_intro && $form->add(array('label'=>'充值说明','type'=>'html','html'=>$charge_intro));

#处理提交
if($onez=$form->submit()){
  ob_clean();
  
  $money=onez('chat.group.plugin.credit')->format($onez['key1']);
  $money<=0 && onez()->error('提现金额有误');
  
  $total=$money;
  $fee=0;
  if($fee1>0){
    $total+=$money*$fee1/100;
    $fee+=$money*$fee1/100;
  }
  if($fee2>0){
    $total+=$fee2;
    $fee+=$fee2;
  }
  $fee=onez('chat.group.plugin.credit')->format($fee);
  
  $total=onez('chat.group.plugin.credit')->format($total);
  $total<=0 && onez()->error('提现金额有误');
  
  
  $total>onez('chat.group.plugin.credit')->value($G['userid']) && onez()->error('账户余额不足，请充值！');
  
  
  onez('chat.group.plugin.credit')->add($G['userid'],'money',-$money,'trun',"申请提现");
  if($fee>0){
    onez('chat.group.plugin.credit')->add($G['userid'],'money',-$fee,'trun',"提现手续费");
  }
  
  
  $item=array();
  $item['userid']=$G['userid'];
  $item['money1']=$money;
  $item['money2']=$total;
  $item['money3']=$fee;
  $item['money']=$money;
  $item['total']=$total;
  $item['fee']=$fee;
  $item['key2']=$onez['key2'];
  $item['token']='wait';
  $id=$G['this']->data()->open('cash')->insert($item);
  
  onez()->ok('操作成功',onez('chat.group.plugin.credit')->href('/group/cash.log.php'));
}
onez('admin')->header();
?>
<section class="content-header">
  <h1>
    <?=$G['title']?>
  </h1>
  <ol class="breadcrumb">
    <li>
      <a href="<?php echo onez()->href('/')?>">
        <i class="fa fa-dashboard">
        </i>
        管理首页
      </a>
    </li>
    <li class="active">
      <?=$G['title']?>
    </li>
  </ol>
</section>
<section class="content">
  <form id="form-common" method="post">
    <div class="box box-info">
      <div class="box-header with-border">
        <h3 class="box-title">
          <?=$G['title']?>
        </h3>
        <div class="box-tools pull-right">
        </div>
      </div>
      <div class="box-body">
        <?=$form->code()?>
      </div>
      <div class="box-footer clearfix">
        <button type="submit" class="btn btn-primary">
          立即提现
        </button>
        <a href="<?=onez('chat.group.plugin.credit')->href('/group/cash.log.php')?>" class="btn btn-info">查看申请记录</a>
      </div>
    </div>
    <input type="hidden" name="action" value="save" />
  </form>
</section>
<script type="text/javascript">
function seluser(obj){
  var data=$(obj).data();
  $('#input-userid').val(data.value);
  $('#input-uname').val(data.title);
}
$(function(){
  $('#input-key1').bind('input keyup',function(){
    var value=$(this).val();
    if(value.length<1 || isNaN(value)){
      value=0;
    }
    value=parseFloat(value+'');
    var total=value;
    var label='';
    var fee=0;
    <?if($fee1>0){?>
      label+=' * <?=$fee1?>%';
      fee+=value*<?=$fee1?>/100;
      total+=value*<?=$fee1?>/100;
    <?}?>
    <?if($fee2>0){?>
      label+=' + <?=$fee2?>';
      fee+=<?=$fee2?>;
      total+=<?=$fee2?>;
    <?}?>
    if(label==''){
      label=fee.toFixed(<?=$format?>);
    }else{
      label=value+''+label;
      label+=' = '+fee.toFixed(<?=$format?>);
    }
    $('#fee_label').html(label);
    $('#total_label').html(total.toFixed(<?=$format?>));
  });
  $('#form-common').bind('submit',function(){
    $.post(window.location.href,$(this).serialize()+'&ajax=1',function(data){
      onez.doit(data);
    },'json');
    return false;
  });
});
</script>
<?php
onez('admin')->footer();
?>