<?php

/* ========================================================================
 * $Id: ip.class.php 5785 2016-09-27 10:47:37Z onez $
 * 
 * Email: www@onez.cn
 * QQ: 6200103
 * HomePage: http://www.onezphp.com
 * ========================================================================
 * Copyright 2016-2017 佳蓝科技.
 * 
 * ======================================================================== */

class IpLocation {
  var $fp;
  var $firstip;
  var $lastip;
  var $totalip;
  function getlong() {
    //ȡlittle-endian4ֽתΪ
    $result = unpack('Vlong', fread($this->fp, 4));
    return $result['long'];
  }
  function getlong3() {
    //ȡlittle-endian3ֽתΪ
    $result = unpack('Vlong', fread($this->fp, 3).chr(0));
    return $result['long'];
  }
  function packip($ip) {
    // IPַתΪPHP5УIPַ򷵻False
    // ʱintvalFlaseתΪ-1֮ѹbig-endianַ
    return pack('N', intval(ip2long($ip)));
    }
  
  function getstring($data = "") {
    $char = fread($this->fp, 1);
    while (ord($char) > 0) {     // ַCʽ棬\0
        $data .= $char;           // ȡַӵַ֮
        $char = fread($this->fp, 1);
    }
    return $data;
  }
  
  function getarea() {
    $byte = fread($this->fp, 1);   // ־ֽ
    switch (ord($byte)) {
        case 0:                 // ûϢ
          $area = "";
          break;
        case 1:
        case 2:                 // ־ֽΪ12ʾϢض
          fseek($this->fp, $this->getlong3());
          $area = $this->getstring();
          break;
        default:             // 򣬱ʾϢûбض
          $area = $this->getstring($byte);
          break;
    }
    return $area;
  }
  
  function getlocation($ip) {
    if (!$this->fp) return null;         // ļûбȷ򿪣ֱӷؿ
    $location['ip'] = gethostbyname($ip);   // תΪIPַ
    $ip = $this->packip($location['ip']);   // IPַתΪɱȽϵIPַ
                                // ϷIPַᱻתΪ255.255.255.255
    // Է
    $l = 0;                   // ±߽
    $u = $this->totalip;         // ϱ߽
    $findip = $this->lastip;     // ûҵͷһIP¼QQWry.Datİ汾Ϣ
    while ($l <= $u) {           // ϱ߽С±߽ʱʧ
        $i = floor(($l + $u) / 2);   // м¼
        fseek($this->fp, $this->firstip + $i * 7);
        $beginip = strrev(fread($this->fp, 4));     // ȡм¼ĿʼIPַ
        // strrevǽlittle-endianѹIPַתΪbig-endianĸʽ
        // ԱڱȽϣͬ
        if ($ip < $beginip) {     // ûIPСм¼ĿʼIPַʱ
          $u = $i - 1;         // ϱ߽޸Ϊм¼һ
        }
        else {
          fseek($this->fp, $this->getlong3());
          $endip = strrev(fread($this->fp, 4));   // ȡм¼ĽIPַ
          if ($ip > $endip) {     // ûIPм¼ĽIPַʱ
            $l = $i + 1;     // ±߽޸Ϊм¼һ
          }
          else {             // ûIPм¼IPΧʱ
            $findip = $this->firstip + $i * 7;
            break;           // ʾҵ˳ѭ
          }
        }
    }
  
    //ȡҵIPλϢ
    fseek($this->fp, $findip);
    $location['beginip'] = long2ip($this->getlong());   // ûIPڷΧĿʼַ
    $offset = $this->getlong3();
    fseek($this->fp, $offset);
    $location['endip'] = long2ip($this->getlong());     // ûIPڷΧĽַ
    $byte = fread($this->fp, 1);   // ־ֽ
    switch (ord($byte)) {
        case 1:                 // ־ֽΪ1ʾҺϢͬʱض
          $countryOffset = $this->getlong3();         // ضַ
          fseek($this->fp, $countryOffset);
          $byte = fread($this->fp, 1);   // ־ֽ
          switch (ord($byte)) {
            case 2:           // ־ֽΪ2ʾϢֱض
                fseek($this->fp, $this->getlong3());
                $location['country'] = $this->getstring();
                fseek($this->fp, $countryOffset + 4);
                $location['area'] = $this->getarea();
                break;
            default:         // 򣬱ʾϢûбض
                $location['country'] = $this->getstring($byte);
                $location['area'] = $this->getarea();
                break;
          }
          break;
        case 2:                 // ־ֽΪ2ʾϢض
          fseek($this->fp, $this->getlong3());
          $location['country'] = $this->getstring();
          fseek($this->fp, $offset + 8);
          $location['area'] = $this->getarea();
          break;
        default:             // 򣬱ʾϢûбض
          $location['country'] = $this->getstring($byte);
          $location['area'] = $this->getarea();
          break;
    }
    if ($location['country'] == " CZ88.NET") {   // CZ88.NETʾûЧϢ
        $location['country'] = "unknown";
    }
    if ($location['area'] == " CZ88.NET") {
        $location['area'] = "";
    }
    foreach($location as $k=>$v){
      $location[$k]=onez()->iconv('gbk','utf-8',$v);
    }
    return $location;
  }
  
  /**
  * 캯 QQWry.Dat ļʼеϢ
  *
  * @param string $filename
  * @return IpLocation
  */
  function IpLocation() {
    $filename=dirname(__FILE__)."/wry.dat";
    if (($this->fp = @fopen($filename, 'rb')) !== false) {
        $this->firstip = $this->getlong();
        $this->lastip = $this->getlong();
        $this->totalip = ($this->lastip - $this->firstip) / 7;
        //עʹڳִнʱִ
        register_shutdown_function(array(&$this, '_IpLocation'));
    }
  }
  
  /**
  * ҳִнԶرմ򿪵ļ
  *
  */
  function _IpLocation() {
    fclose($this->fp);
  }
}
?>