var onez=onez||{};
onez.autosave=function(data){
  var that=this;
  that.data=data;
  that.method='local';
  that.cache_key='editor_cache_'+that.data.id.replace(/^[0-9a-zA-Z_]+/g,'_');
  that.cacheData='';
  if (!window.localStorage){
    that.method='remote';
  }
  that.save=function(){
    var data=that.data.editor.html();
    if(that.cacheData==data){
      return;
    }
    that.cacheData=data;
    if(that.method=='remote'){
      $.post('?_p=kindeditor&_m=cache_save',{id:that.data.id,data},function(data){
        if(typeof data.html=='string'){
          callback(data.html);
        }else{
          callback('');
        }
      },'json');
    }else{
      window.localStorage.setItem(that.cache_key,data);
    }
  };
  that.get=function(callback){
    if(that.method=='remote'){
      $.post('?_p=kindeditor&_m=cache_get',{id:that.data.id},function(data){
        if(typeof data.html=='string'){
          callback(data.html);
        }else{
          callback('');
        }
      },'json');
    }else{
      var html=window.localStorage.getItem(that.cache_key);
      if(html !== null){
        window.localStorage.removeItem(that.cache_key);
        callback(html);
      }else{
        callback('');
      }
    }
  };
  $('.editor-cache-tip-'+that.cache_key).remove();
  that.box_tip=$('<div class="editor-cache-tip-'+that.cache_key+'" style="padding: 5px 10px;background: #FEFEE9;border-top: 1px solid #CDCDCD !important;position: relative;z-index: 999;display:none"></div>').insertAfter($(that.data.id).prev().find('.statusbar'));
  that.get(function(html){
    if(html!=''){
      that.cacheData=html;
      that.box_tip.html('您有上次未提交成功的数据 <a style="color: #369;" href="javascript:;" class="editor-btn-recover"><strong>恢复数据</strong></a> <a style="color: #369;" href="javascript:;" class="editor-btn-cancel"><strong>取消</strong></a>').show();
      that.box_tip.find('.editor-btn-recover').bind('click',function(){
        $('.editor-cache-tip-'+that.cache_key).html('').hide();
        that.data.editor.html(that.cacheData);
      });
      that.box_tip.find('.editor-btn-recover').bind('click',function(){
        $('.editor-cache-tip-'+that.cache_key).html('').hide();
      });
    }
    setInterval(function() {
      if(!that.data.editor.isEmpty()){
        var d = new Date();
        var h = d.getHours();
        var m = d.getMinutes();
        var s = d.getSeconds();
        h = h < 10 ? '0' + h : h;
        m = m < 10 ? '0' + m : m;
        s = s < 10 ? '0' + s : s;
        that.save();
        that.box_tip.html('数据已于 ' + h + ':' + m + ':' + s +' 保存').show();
      }
    },5000);
  });
};
$(function(){
  (function(autosave){
    autosave.imgReader=function(item){
      var blob = item.getAsFile(),reader = new FileReader();
      reader.onload = function( e ){
        $.post('?_p=kindeditor&_m=base64',{data:e.target.result.split(';base64,')[1]},function(data){
          if(typeof data.error!='undefined'){
            onez.alert(data.error);
          }else if(typeof data.url!='undefined'){
            KindEditor.insertHtml(snapshot.data.id, '<img src="'+data.url+'" class="image" />');
          }
        },'json');
      };
      reader.readAsDataURL( blob );
    };
  })(onez.autosave);
});
$(function(){
  $(document).bind('onez-kindeditor-create',function(e,data){
    new onez.autosave(data);
  });
});