@extends('modstart::layout.frame')

@section('pageFavIco',\ModStart\Core\Assets\AssetsUtil::fix(modstart_config('siteFavIco')))
@section('pageTitle')@yield('pageTitleMain','') - {{modstart_config('siteName')}}@endsection
@section('pageKeywords',modstart_config('siteKeywords'))
@section('pageDescription',modstart_config('pageDescription'))

@section('headAppend')
    @parent
    <link rel="stylesheet" href="{{\ModStart\Core\Assets\AssetsUtil::fix('theme/'.modstart_config('siteTemplate','default').'/css/style.css')}}"/>
    {!! modstart_config('systemCounter') !!}
    <style type="text/css">
        @if(modstart_config('sitePrimaryColor',null))
            :root{
            --theme-color-primary: {{modstart_config('sitePrimaryColor')}};
            --theme-color-primary-light: {{modstart_config('sitePrimaryColor')}};
            --theme-color-primary-dark: {{modstart_config('sitePrimaryColor')}};
        }
        @endif
    </style>
@endsection

{!! \ModStart\ModStart::js('asset/common/fullscreen.js') !!}
@section('bodyAppend')
    @parent
    {!! modstart_config('systemCounterBody') !!}
    <script>
        $(function () {
            var $fullScreenTrigger = $('#fullScreenTrigger');
            var fullScreenCheck = function () {
                if (window.api.fullscreen.isFullScreen()) {
                    $fullScreenTrigger.find('i').removeClass('uk-icon-expand').addClass('uk-icon-compress');
                } else {
                    $fullScreenTrigger.find('i').removeClass('uk-icon-compress').addClass('uk-icon-expand');
                }
            };
            $fullScreenTrigger.on('click', function () {
                window.api.fullscreen.trigger(fullScreenCheck);
            });
            fullScreenCheck();
        });
    </script>
@endsection

@section('body')

    <header style="background-image:url('{{\ModStart\Core\Assets\AssetsUtil::fixOrDefault(modstart_config('blogBackground'),'theme/default/img/bg.jpg')}}');">
        <div class="container">
            <div class="avatar">
                <img src="{{\ModStart\Core\Assets\AssetsUtil::fixOrDefault(modstart_config('siteLogo'),'/placeholder/200x200')}}" />
            </div>
            <h1><a href="/">{{modstart_config('blogName','[博客名]')}}</a></h1>
            <h2>{{modstart_config('blogSlogan','[博客标语]')}}</h2>
            <ul class="menu">
                <li><a href="/" title="首页"><i class="iconfont icon-home"></i></a></li>
                @if(modstart_config('blogMessageEnable'))
                    <li><a href="/message" title="留言"><i class="iconfont icon-pinglun"></i></a></li>
                @endif
                @if(modstart_config('contactEmail'))
                    <li><a title="邮箱:{{modstart_config('contactEmail')}}" href="mailto:{{modstart_config('contactEmail')}}"><i class="iconfont icon-email"></i></a></li>
                @endif
                @if(modstart_config('contactWeibo'))
                    <li><a title="微博:{{modstart_config('contactWeibo')}}" href="{{modstart_config('contactWeibo')}}" target="_blank"><i class="iconfont icon-weibo"></i></a></li>
                @endif
                @if(modstart_config('contactWechat'))
                    <li><a title="微信:{{modstart_config('contactWechat')}}" href="javascript:;"><i class="iconfont icon-wechat"></i></a></li>
                @endif
                @if(modstart_config('contactQQ'))
                    <li><a title="QQ:{{modstart_config('contactQQ')}}" href="javascript:;"><i class="iconfont icon-qq-copy"></i></a></li>
                @endif
                <li><a href="javascript:;" id="fullScreenTrigger" title="全屏"><i class="iconfont icon-pc"></i></a></li>
            </ul>
            <div class="introduction">
                {!! \ModStart\Core\Util\HtmlUtil::text2html(modstart_config('blogIntroduction','[个人介绍]')) !!}
            </div>
        </div>
        <div class="copyright">
            <a href="http://www.miitbeian.gov.cn/" target="_blank">{{modstart_config('siteBeian','[备案编号]')}}</a>
            &copy;
            {{modstart_config('siteDomain','[网站域名]')}}
        </div>
    </header>

    <div id="body">
        <div class="container">
            @section('bodyContent')
            @show
        </div>
    </div>

@endsection
