SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for sql_admin
-- ----------------------------
DROP TABLE IF EXISTS `sql_admin`;
CREATE TABLE `sql_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '密码',
  `email` varchar(100) NOT NULL DEFAULT '' COMMENT '邮箱',
  `image_url` varchar(200) NOT NULL DEFAULT '' COMMENT '头像',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Records of sql_admin
-- ----------------------------
INSERT INTO `sql_admin` VALUES ('1', 'admin', '1babfed25891c649567732a63ae3d6cc', '', '');

-- ----------------------------
-- Table structure for sql_article
-- ----------------------------
DROP TABLE IF EXISTS `sql_article`;
CREATE TABLE `sql_article` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `keywords` varchar(100) DEFAULT '' COMMENT '标签',
  `description` varchar(200) DEFAULT '' COMMENT '摘要',
  `image_url` varchar(200) DEFAULT '' COMMENT '图片',
  `content` text COMMENT '内容',
  `author` varchar(20) DEFAULT '' COMMENT '文章作者',
  `source` varchar(30) DEFAULT '' COMMENT '文章来源',
  `hits` int(10) unsigned DEFAULT '0' COMMENT '点击量',
  `comment_num` int(11) NOT NULL DEFAULT '0' COMMENT '评论数量',
  `is_recommend` tinyint(1) DEFAULT '0' COMMENT '是否推荐',
  `is_top` tinyint(4) DEFAULT '0' COMMENT '是否置顶',
  `is_show` tinyint(1) DEFAULT '1' COMMENT '是否显示  0为不显示 1为显示',
  `url` varchar(250) DEFAULT '' COMMENT '文章链接',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `delete_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `category_id` (`category_id`) USING BTREE,
  KEY `hits` (`hits`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Records of sql_article
-- ----------------------------
INSERT INTO `sql_article` VALUES ('1', '2', '文章测试数据', '', '欢迎使用uumBlog（PHP版）测试版', '/uploads/Editor/20200524/eaa4fc061d09c2536447efbefafa4677.jpg', '&lt;p&gt;内容测试数据&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/Editor/20200524/eaa4fc061d09c2536447efbefafa4677.jpg&quot; style=&quot;max-width:100%;&quot;&gt;&lt;br&gt;&lt;/p&gt;', '', '', '8', '2', '0', '0', '1', '/article/1.html', '1590310459', '0', '0');

-- ----------------------------
-- Table structure for sql_category
-- ----------------------------
DROP TABLE IF EXISTS `sql_category`;
CREATE TABLE `sql_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT '父级id  顶级为0',
  `model_id` int(11) NOT NULL DEFAULT '0' COMMENT '模型id  对应model表',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `description` varchar(200) NOT NULL DEFAULT '' COMMENT '栏目描述',
  `is_menu` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否导航栏显示  1显示0不显示',
  `url` varchar(100) NOT NULL DEFAULT '' COMMENT '栏目链接',
  `sort` int(11) NOT NULL DEFAULT '1' COMMENT '排序 asc 升序',
  `create_time` int(11) NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  `delete_time` int(11) NOT NULL DEFAULT '0',
  `index_template` varchar(50) NOT NULL DEFAULT 'index' COMMENT '主页模版',
  `list_template` varchar(50) NOT NULL DEFAULT 'list' COMMENT '列表模板',
  `show_template` varchar(50) NOT NULL DEFAULT 'show' COMMENT '详情页模板',
  `image_url` varchar(200) NOT NULL DEFAULT '' COMMENT '封面url',
  `is_cover` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否有封面页',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Records of sql_category
-- ----------------------------
INSERT INTO `sql_category` VALUES ('1', '0', '2', '文章栏目', '', '1', '/article-index/1.html', '0', '1590310012', '1590310012', '0', 'index', 'lists', 'show', '', '0');
INSERT INTO `sql_category` VALUES ('2', '1', '2', '二级栏目', '', '1', '/article-lists/2.html', '0', '1590310027', '1590310027', '0', 'index', 'lists', 'show', '', '0');
INSERT INTO `sql_category` VALUES ('3', '0', '3', '图集展示', '', '1', '/picture-index/3.html', '0', '1590310045', '1590310045', '0', 'index', 'lists', 'show', '', '0');
INSERT INTO `sql_category` VALUES ('4', '0', '5', '下载模型', '', '1', '/download-index/4.html', '0', '1590310055', '1590310055', '0', 'index', 'lists', 'show', '', '0');
INSERT INTO `sql_category` VALUES ('5', '0', '6', '视频模型', '', '1', '/video-index/5.html', '0', '1590310065', '1590310065', '0', 'index', 'lists', 'show', '', '0');
INSERT INTO `sql_category` VALUES ('6', '0', '4', '链接模型', '', '1', 'https://www.usuuu.com', '0', '1590310080', '1590310080', '0', 'index', 'lists', 'show', '', '0');
INSERT INTO `sql_category` VALUES ('7', '0', '1', '关于', '', '1', '/page/7.html', '0', '1590310091', '1590310091', '0', 'index', 'lists', 'show', '', '0');

-- ----------------------------
-- Table structure for sql_comment
-- ----------------------------
DROP TABLE IF EXISTS `sql_comment`;
CREATE TABLE `sql_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `a_id` int(11) NOT NULL DEFAULT '0' COMMENT '内容id',
  `c_id` int(11) NOT NULL COMMENT '分类id',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT '父级id  如果不等于0  表示楼中楼',
  `content` varchar(200) NOT NULL DEFAULT '' COMMENT '评论内容',
  `send` varchar(200) NOT NULL DEFAULT '' COMMENT '发送者信息 后期增加用户登录时可变成用户id',
  `receive` varchar(200) NOT NULL COMMENT '接收者信息 后期增加用户登录时可变成用户id',
  `ip` varchar(20) NOT NULL DEFAULT '' COMMENT 'ip',
  `reply` int(11) NOT NULL DEFAULT '0' COMMENT '回复数量',
  `create_time` int(11) NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  `delete_time` int(11) NOT NULL DEFAULT '0',
  `is_status` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of sql_comment
-- ----------------------------
INSERT INTO `sql_comment` VALUES ('1', '1', '2', '0', '评论数据测试', '{\"qq\":\"547241650\",\"name\":\"\\u7a7a\\u767d\\u7684\\u8bb0\\u5fc6\\u3002\",\"image\":\"https:\\/\\/q.qlogo.cn\\/headimg_dl?dst_uin=547241650&spec=100\"}', '0', '127.0.0.1', '1', '1590310498', '1590310498', '0', '1');
INSERT INTO `sql_comment` VALUES ('2', '1', '2', '1', '回复测试', '{\"qq\":\"523179414\",\"name\":\"Jax\",\"image\":\"https:\\/\\/q.qlogo.cn\\/headimg_dl?dst_uin=523179414&spec=100\"}', '{\"qq\":\"547241650\",\"name\":\"\\u7a7a\\u767d\\u7684\\u8bb0\\u5fc6\\u3002\",\"image\":\"https:\\/\\/q.qlogo.cn\\/headimg_dl?dst_uin=547241650&spec=100\"}', '127.0.0.1', '0', '1590310562', '1590310562', '0', '1');
INSERT INTO `sql_comment` VALUES ('3', '1', '7', '0', '单页面评论测试', '{\"qq\":\"547241650\",\"name\":\"\\u7a7a\\u767d\\u7684\\u8bb0\\u5fc6\\u3002\",\"image\":\"https:\\/\\/q.qlogo.cn\\/headimg_dl?dst_uin=547241650&spec=100\"}', '0', '127.0.0.1', '0', '1590386156', '1590386156', '0', '1');
INSERT INTO `sql_comment` VALUES ('4', '1', '4', '0', '下载模型评论测试', '{\"qq\":\"547241650\",\"name\":\"\\u7a7a\\u767d\\u7684\\u8bb0\\u5fc6\\u3002\",\"image\":\"https:\\/\\/q.qlogo.cn\\/headimg_dl?dst_uin=547241650&spec=100\"}', '0', '127.0.0.1', '0', '1590390457', '1590390457', '0', '1');

-- ----------------------------
-- Table structure for sql_download
-- ----------------------------
DROP TABLE IF EXISTS `sql_download`;
CREATE TABLE `sql_download` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL,
  `title` varchar(50) NOT NULL COMMENT '标题',
  `image_url` varchar(200) DEFAULT '' COMMENT '封面图片',
  `file_url` varchar(200) DEFAULT '' COMMENT '下载文件',
  `demo_url` varchar(200) NOT NULL DEFAULT '' COMMENT '演示地址',
  `filename` varchar(100) DEFAULT NULL COMMENT '文件名',
  `keywords` varchar(100) DEFAULT '',
  `description` varchar(200) DEFAULT '' COMMENT '文件描述',
  `hits` int(11) DEFAULT '0' COMMENT '点击量',
  `download_num` int(11) DEFAULT '0' COMMENT '下载次数',
  `comment_num` int(11) NOT NULL DEFAULT '0' COMMENT '评论数',
  `is_recommend` tinyint(1) DEFAULT '0' COMMENT '是否推荐',
  `is_top` tinyint(4) DEFAULT '0' COMMENT '是否置顶',
  `is_show` tinyint(1) DEFAULT '0' COMMENT '是否显示 0为不显示 1为显示',
  `is_pwd` varchar(4) DEFAULT '0' COMMENT '是否需要密码  0为不需要',
  `url` varchar(200) DEFAULT NULL COMMENT '链接',
  `create_time` int(11) NOT NULL COMMENT '上传时间',
  `update_time` int(11) NOT NULL DEFAULT '0',
  `delete_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `category_id` (`category_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Records of sql_download
-- ----------------------------
INSERT INTO `sql_download` VALUES ('1', '4', '数据库下载', '/uploads/Editor/20200524/eaa4fc061d09c2536447efbefafa4677.jpg', '/uploads/files/20200525/0f45daeb41b3ef4d6ab0fbab669fbf68.rar', 'https://www.usuuu.com', 'sql.rar', '', '', '50', '4', '1', '0', '0', '1', '0', '/download/1.html', '1590385614', '0', '0');
INSERT INTO `sql_download` VALUES ('2', '4', '数据库下载', '/uploads/Editor/20200524/eaa4fc061d09c2536447efbefafa4677.jpg', '/uploads/files/20200525/0f45daeb41b3ef4d6ab0fbab669fbf68.rar', 'https://www.usuuu.com', 'sql.rar', '', '', '9', '1', '0', '0', '0', '1', '0', '/download/2.html', '1590385614', '0', '0');
INSERT INTO `sql_download` VALUES ('3', '4', '数据库下载（带密码的）', '/uploads/Editor/20200524/eaa4fc061d09c2536447efbefafa4677.jpg', '/uploads/files/20200525/0f45daeb41b3ef4d6ab0fbab669fbf68.rar', 'https://www.usuuu.com', 'sql.rar', '', '', '14', '0', '0', '0', '0', '1', '1234', '/download/3.html', '1590385614', '0', '0');

-- ----------------------------
-- Table structure for sql_models
-- ----------------------------
DROP TABLE IF EXISTS `sql_models`;
CREATE TABLE `sql_models` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '模型名称',
  `tablename` char(20) NOT NULL DEFAULT '' COMMENT '表名',
  `index_template` char(30) NOT NULL DEFAULT 'index' COMMENT '封面页模板',
  `list_template` char(30) NOT NULL DEFAULT 'list' COMMENT '列表模板',
  `show_template` char(30) NOT NULL DEFAULT 'show' COMMENT '详情页模板',
  `sort` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'asc 排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='模型表';

-- ----------------------------
-- Records of sql_models
-- ----------------------------
INSERT INTO `sql_models` VALUES ('1', '单页模型', 'page', 'index', 'list', 'show', '2');
INSERT INTO `sql_models` VALUES ('2', '文章模型', 'article', 'index', 'list', 'show', '1');
INSERT INTO `sql_models` VALUES ('3', '图集模型', 'picture', 'index', 'list', 'show', '3');
INSERT INTO `sql_models` VALUES ('4', '链接模型', 'link', 'index', 'list', 'show', '5');
INSERT INTO `sql_models` VALUES ('5', '下载模型', 'download', 'index', 'list', 'show', '4');
INSERT INTO `sql_models` VALUES ('6', '视频模型', 'video', 'index', 'list', 'show', '6');

-- ----------------------------
-- Table structure for sql_page
-- ----------------------------
DROP TABLE IF EXISTS `sql_page`;
CREATE TABLE `sql_page` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL COMMENT '分类ID',
  `title` varchar(200) NOT NULL COMMENT '标题',
  `keywords` varchar(100) DEFAULT '',
  `description` varchar(200) DEFAULT '' COMMENT '摘要',
  `content` text COMMENT '内容',
  `image_url` varchar(200) DEFAULT '' COMMENT '图片',
  `hits` int(11) NOT NULL DEFAULT '0' COMMENT '点击量',
  `is_show` tinyint(1) DEFAULT '1' COMMENT '是否显示  0不显示',
  `comment_num` int(11) NOT NULL DEFAULT '0' COMMENT '评论数',
  `url` varchar(100) DEFAULT '',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) NOT NULL DEFAULT '0',
  `delete_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `category_id` (`category_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Records of sql_page
-- ----------------------------
INSERT INTO `sql_page` VALUES ('1', '7', '关于', '', '', '&lt;p&gt;&lt;img src=&quot;/uploads/Editor/20200525/884646bdb310e8f10d583037b3753a6d.gif&quot; style=&quot;max-width:100%;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;栏目管理 &amp;gt; 单页模型 &amp;gt; 添加内容 （即可更改此内容）（支持富文本）&lt;/p&gt;', '', '4', '1', '1', '/page/id/1.html', '1590385804', '1590386125', '0');

-- ----------------------------
-- Table structure for sql_picture
-- ----------------------------
DROP TABLE IF EXISTS `sql_picture`;
CREATE TABLE `sql_picture` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目ID',
  `title` varchar(50) DEFAULT '' COMMENT '图片名称',
  `image_url` varchar(200) DEFAULT '' COMMENT '封面图片',
  `images` text COMMENT '图集地址json',
  `content` text COMMENT '详情',
  `keywords` varchar(100) DEFAULT '',
  `description` varchar(200) DEFAULT '' COMMENT '图片描述',
  `hits` int(11) DEFAULT '0' COMMENT '点击量',
  `is_recommend` tinyint(1) DEFAULT '0' COMMENT '是否推荐',
  `is_top` tinyint(4) DEFAULT '0' COMMENT '是否置顶',
  `is_show` tinyint(1) DEFAULT '0' COMMENT '是否显示 0不显示',
  `is_pwd` varchar(4) DEFAULT '0' COMMENT '是否需要密码  0不需要  不为0 就是密码',
  `comment_num` int(11) NOT NULL DEFAULT '0' COMMENT '评论数',
  `url` varchar(200) DEFAULT '' COMMENT '地址',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) NOT NULL DEFAULT '0',
  `delete_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `category_id` (`category_id`) USING BTREE,
  KEY `is_recommend` (`is_recommend`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Records of sql_picture
-- ----------------------------
INSERT INTO `sql_picture` VALUES ('1', '3', '图集测试数据', '/uploads/Editor/20200524/eaa4fc061d09c2536447efbefafa4677.jpg', '[\"\\/uploads\\/Editor\\/20200524\\/eaa4fc061d09c2536447efbefafa4677.jpg\",\"\\/uploads\\/images\\/20200524\\/b284332d1c1fc57bd9c14660f3b10f3f.jpg\",\"\\/uploads\\/images\\/20200524\\/34faad4aed39662dd20517ea6a393ebe.jpg\"]', '&lt;p&gt;这块前端还没弄完&lt;/p&gt;', '', '', '3', '0', '0', '1', '0', '0', '/picture/1.html', '1590310354', '0', '0');
INSERT INTO `sql_picture` VALUES ('2', '3', '我是有密码的图集', '/uploads/Editor/20200524/eaa4fc061d09c2536447efbefafa4677.jpg', '[\"\\/uploads\\/Editor\\/20200524\\/eaa4fc061d09c2536447efbefafa4677.jpg\",\"\\/uploads\\/images\\/20200524\\/b284332d1c1fc57bd9c14660f3b10f3f.jpg\"]', '&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '', '', '3', '0', '0', '1', '123', '0', '/picture/2.html', '1590386191', '0', '0');

-- ----------------------------
-- Table structure for sql_setting
-- ----------------------------
DROP TABLE IF EXISTS `sql_setting`;
CREATE TABLE `sql_setting` (
  `key` varchar(100) NOT NULL DEFAULT '',
  `value` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of sql_setting
-- ----------------------------
INSERT INTO `sql_setting` VALUES ('search_model', '{\"2\":{\"id\":\"2\",\"name\":\"\\u6587\\u7ae0\\u6a21\\u578b\"}}');
INSERT INTO `sql_setting` VALUES ('stationmaster_info', '{\"stationmaster_name\":\"\\u60a0\\u60a0\",\"stationmaster_occupation\":\"\\u5356\\u8863\\u670d\\u7684\\u5927\\u5a18\",\"stationmaster_motto\":\"\\u4e0d\\u77e5\\u9053\",\"stationmaster_qq\":\"547241650\",\"stationmaster_qqnet\":\"706684\",\"stationmaster_qqnet_code\":\"\"}');
INSERT INTO `sql_setting` VALUES ('file', '');
INSERT INTO `sql_setting` VALUES ('logo', '');
INSERT INTO `sql_setting` VALUES ('site_name', '悠悠吧');
INSERT INTO `sql_setting` VALUES ('qr_code', '');
INSERT INTO `sql_setting` VALUES ('site_url', 'https://www.usuuu.com');
INSERT INTO `sql_setting` VALUES ('icp', '');
INSERT INTO `sql_setting` VALUES ('copy', '');
INSERT INTO `sql_setting` VALUES ('site_statistice', '');
INSERT INTO `sql_setting` VALUES ('head_html', '');
INSERT INTO `sql_setting` VALUES ('comment_status', '1');
INSERT INTO `sql_setting` VALUES ('site_status', '1');
INSERT INTO `sql_setting` VALUES ('title_add', '-标题附加字');
INSERT INTO `sql_setting` VALUES ('keywords', '网站关键词');
INSERT INTO `sql_setting` VALUES ('description', '网站描述');
INSERT INTO `sql_setting` VALUES ('index_banner', '');
INSERT INTO `sql_setting` VALUES ('index_banner_bg', '');
INSERT INTO `sql_setting` VALUES ('uum_banner', '');
INSERT INTO `sql_setting` VALUES ('uum_banner_link', '');
INSERT INTO `sql_setting` VALUES ('download_info', '');
INSERT INTO `sql_setting` VALUES ('comment_ban_time', '1');
INSERT INTO `sql_setting` VALUES ('upload_type', '1');
INSERT INTO `sql_setting` VALUES ('template_name', 'uum');
INSERT INTO `sql_setting` VALUES ('links', '{\"1\":{\"sorts\":{\"1\":\"1\",\"2\":\"2\"},\"sort\":\"1\",\"id\":\"1\",\"name\":\"\\u60a0\\u60a0\\u5427\",\"link_url\":\"https:\\/\\/www.usuuu.com\\/\"},\"2\":{\"sorts\":{\"1\":\"1\",\"2\":\"2\"},\"sort\":\"2\",\"id\":\"2\",\"name\":\"\\u767e\\u5ea6\",\"link_url\":\"https:\\/\\/www.baidu.com\\/\"}}');
INSERT INTO `sql_setting` VALUES ('visit_num', '1536');
INSERT INTO `sql_setting` VALUES ('sitemap_model', '2,1,3,5,6');
INSERT INTO `sql_setting` VALUES ('changefreq', 'hourly');
INSERT INTO `sql_setting` VALUES ('qiniu_config', '{\"accessKey\":\"\",\"secretKey\":\"\",\"bucket\":\"\",\"domain\":\"\"}');
INSERT INTO `sql_setting` VALUES ('edit_type', '3');
INSERT INTO `sql_setting` VALUES ('site_name', '悠悠吧');
INSERT INTO `sql_setting` VALUES ('title_add', '-标题附加字');
INSERT INTO `sql_setting` VALUES ('keywords', '网站关键词');
INSERT INTO `sql_setting` VALUES ('description', '网站描述');
INSERT INTO `sql_setting` VALUES ('comment_examine', '1');
INSERT INTO `sql_setting` VALUES ('site_name', '悠悠吧');
INSERT INTO `sql_setting` VALUES ('title_add', '-标题附加字');
INSERT INTO `sql_setting` VALUES ('keywords', '网站关键词');
INSERT INTO `sql_setting` VALUES ('description', '网站描述');

-- ----------------------------
-- Table structure for sql_upload
-- ----------------------------
DROP TABLE IF EXISTS `sql_upload`;
CREATE TABLE `sql_upload` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_size` int(11) NOT NULL DEFAULT '0' COMMENT '文件大小 b',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '上传时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '可以 0不可用',
  `filename` varchar(200) NOT NULL DEFAULT '' COMMENT '文件名',
  `file_path` varchar(200) NOT NULL DEFAULT '' COMMENT '文件路径 本地的',
  `file_md5` varchar(100) NOT NULL DEFAULT '',
  `file_sha1` varchar(100) NOT NULL DEFAULT '',
  `suffix` varchar(20) NOT NULL DEFAULT '' COMMENT '文件后缀',
  `up_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '1 本地  2七牛 3oss',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Records of sql_upload
-- ----------------------------
INSERT INTO `sql_upload` VALUES ('1', '345633', '1590310335', '1', '01.jpg', '/uploads/Editor/20200524/eaa4fc061d09c2536447efbefafa4677.jpg', '9457ecc8c1ddbd2bb487ca5d5d87e55c', 'bd9bd2f27eb5b804a5f664d41de466491cc318ff', 'file', '1');
INSERT INTO `sql_upload` VALUES ('2', '47265', '1590310371', '1', '1.jpg', '/uploads/images/20200524/b284332d1c1fc57bd9c14660f3b10f3f.jpg', '12d3feae1f90152dbdb731cec5f1a806', 'a809f38d3f28e3e3b53da054634407b8d13c49d0', 'file', '1');
INSERT INTO `sql_upload` VALUES ('3', '329868', '1590310374', '1', '1-3.jpg', '/uploads/images/20200524/34faad4aed39662dd20517ea6a393ebe.jpg', '6b12f1fbb044f2814469b53e4e084487', '0dde04be4bd92eeb091b762b690b9f5e69987a9f', 'file', '1');
INSERT INTO `sql_upload` VALUES ('4', '41420', '1590310394', '1', '1490075211271.jpg', '/uploads/images/20200524/6f7a81a72ad6bf10f4d2f675833237f0.jpg', '6a029b0ba50a738bd24653152010efdb', '2558d6533cdd481a87f5bf8f9ff6b08b3183531a', 'file', '1');
INSERT INTO `sql_upload` VALUES ('5', '40528144', '1590310414', '1', '1.mp4', '/uploads/files/20200524/ebf8a8f4d2f77efd7f3d68c7559c5330.mp4', '6e8c776a14449daf771cbe10cc72807e', 'e36fca6888d68eeb67f9c8a35e2bb26e2e64412d', 'file', '1');
INSERT INTO `sql_upload` VALUES ('6', '1239803', '1590311188', '1', 'ebf8a8f4d2f77efd7f3d68c7559c5330.mp4', '/uploads/files/20200524/de0e21b57d8e093968a38855587aac31.mp4', '756a2dfb30e4765054d040ebbbe73079', 'fb285c629d4e0e5a7011afa1b62d9c3c7833d6fc', 'file', '1');
INSERT INTO `sql_upload` VALUES ('7', '4292', '1590385647', '1', 'sql.rar', '/uploads/files/20200525/0f45daeb41b3ef4d6ab0fbab669fbf68.rar', '6a0c5f95eb497af571360715f6ba8a3e', 'f5c2bcc415870b0d4806c9df9ead8d680710b763', 'file', '1');
INSERT INTO `sql_upload` VALUES ('8', '1989417', '1590386124', '1', '201908121445389879038166861.gif', '/uploads/Editor/20200525/884646bdb310e8f10d583037b3753a6d.gif', '43d35366a589e202763f74f07388b35f', '5c9481155a3d01efc3a866a2f21b340e0cc0c248', 'file', '1');

-- ----------------------------
-- Table structure for sql_video
-- ----------------------------
DROP TABLE IF EXISTS `sql_video`;
CREATE TABLE `sql_video` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '0' COMMENT '栏目id',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `image_url` varchar(200) NOT NULL DEFAULT '' COMMENT '封面图',
  `video_url` varchar(200) NOT NULL DEFAULT '' COMMENT '视频路径',
  `content` text COMMENT '内容  为空的话则直接显示视频播放器',
  `keywords` varchar(100) NOT NULL DEFAULT '' COMMENT '关键词',
  `description` varchar(200) NOT NULL DEFAULT '' COMMENT '描述',
  `hits` int(11) NOT NULL DEFAULT '0' COMMENT '点击量',
  `is_recommend` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0不推荐',
  `is_top` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否置顶  0不置顶',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0不显示',
  `comment_num` int(11) NOT NULL DEFAULT '0' COMMENT '评论数',
  `url` varchar(100) NOT NULL DEFAULT '',
  `create_time` int(11) NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  `delete_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Records of sql_video
-- ----------------------------
INSERT INTO `sql_video` VALUES ('1', '5', '视频测试数据', '/uploads/images/20200524/6f7a81a72ad6bf10f4d2f675833237f0.jpg', '/uploads/files/20200524/de0e21b57d8e093968a38855587aac31.mp4', '&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '', '', '5', '0', '0', '1', '0', '/video/1.html', '1590310383', '0', '0');
