<?php

namespace app\admin\controller;

use think\Controller;
use think\Db;
use think\Session;

class Login extends Controller{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        config('default_ajax_return','json');
    }

    //登录页面
    public function index(){
        //登录检测
        if(Session::has('admin.username')){
            $this->redirect('admin/index/index');
        }
        return $this->fetch();
    }

    //登录提交
    public function login(){
        if($this->request->isPost()){
            $param=$this->request->param();
            $arr=['code'=>0,'msg'=>'登录失败'];
            if(!captcha_check($param['captcha'])){
                $arr['msg']='验证码错误';
                return $arr;
            }
            $data=Db::name('admin')->where(['username'=>$param['username']])->find();
            //echo uum_get_pwd(123456);
            if(empty($data) || !uum_check_pwd($param['password'],$data['password'])){
                $arr['msg']='用户名或密码错误';
                return $arr;
            }
            session('admin',$data);
            $arr=['code'=>200,'msg'=>'登录成功'];
            return $arr;
        }
    }

    //登录退出
    public function logout(){
        session('admin',null);
        $arr=['code'=>200,'msg'=>'退出登录'];
        return $arr;
    }
}