<?php

namespace app\admin\model;

use think\Model;
use think\Url;

class Models extends Model  {

    //获取所有的模型数组
    public function adminGetModelSelect(){
        $data=$this->order('sort')->select()->toArray();
        return $data;
    }

    //根据模型id获取数据表名称
    public function adminGetTableNameToModelId($id){
        $data=$this->where(['id'=>$id])->field('id,name,tablename')->find();
        if(empty($data)){
            return false;
        }else{
            $data=$data->toArray();
        }
        return $data;
    }

    //根据数据表名称获取model数据
    public function adminGetModelDataToTableName($tablename){
        $data=$this->where(['tablename'=>$tablename])->field('id,name,tablename')->find();
        if(empty($data)){
            return false;
        }
        return $data->toArray();
    }

    //获取到所有的模型数组   一维结构
    public function adminGetModelArray(){
        $arr=[];
        $data=$this->adminGetModelSelect();
        foreach ($data as $val){
            $arr[$val['id']]=$val['tablename'];
        }
        return $arr;
    }

    //获取带不同url的model跳转链接(后台url)
    public function adminGetModelSelectAndUrl($id=0,$func='index'){
        if($id==0){
            $arr=[];
            $all_data=$this->adminGetModelSelect();
            foreach ($all_data as $val){
                $val['url']=url("".$val['tablename']."/".$func."");
                $arr[]=$val;
            }
            return $arr;
        }else{
            $one_data=$this->adminGetTableNameToModelId($id);
            $one_data['url']=url("".$one_data['tablename'] ."/".$func."");
            return $one_data;
        }
    }

    //生成url跳转链接
    public function getUrlToModelId($model_id,$param=[],$func='index'){
        $model_data=$this->adminGetTableNameToModelId($model_id);
        Url::root('/');
        $url=url('index/'.$model_data['tablename'].'/'.$func,[$param['param1']=>$param['param2']]);
        return $url;
    }
}