<?php

namespace app\index\controller;

class Article extends Common {
    public $is_auto=true;
    public $category_id;
    public $id;
    public $category_breadcrumb; //面包屑导航
    public $second_categorys;  //栏目导航
    public $recommend_list;    //推荐文章
    public $hot_list;          //热门文章
    public $category_data;     //栏目数据
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        if($this->is_auto){
            $this->category_id=$this->request->param('category/d', 0 ,'intval');
            $this->id=$this->request->param('id/d', 0 ,'intval');
        }
        //面包屑导航
        $this->category_breadcrumb=model('category')->indexGetCategoryBreadcrumbToModelId($this->category_id,$this->model_data['id']);
        //设置面包屑导航
        $this->assign('category_breadcrumb',$this->category_breadcrumb);
        //栏目导航
        $this->second_categorys=model('category')->indexGetSecondCategoryToModelId($this->model_data['id'],$this->category_id);
        //设置栏目导航
        $this->assign('second_categorys',$this->second_categorys);
        //栏目数据
        $this->category_data=model('category')->indexFindCategoryDataToId($this->category_id);
        if($this->category_id != 0){
            //推荐文章
            $this->recommend_list=model('article')->indexGetArticleToOrder(['is_recommend'=>1],['is_top','desc']);
            //热门文章
            $this->hot_list=model('article')->indexGetArticleToOrder([],['hits','desc']);
            $this->assign('recommend_list',$this->recommend_list);
            $this->assign('hot_list',$this->hot_list);
        }
        if($this->id != 0){
            //右侧栏相关文章
            $hot_list=model('article')->indexGetArticleToOrder(['category_id'=>$this->category_id],['hits','desc']);
            $this->assign('hot_list',$hot_list);
        }
    }

    //显示所有文章栏目的所有文章列表
    public function index(){
        $data=model('article')->indexGetArticleDataToCategoryId($this->category_id);
        // 获取分页显示
        $page = $data->render();

        $this->assign('page',$page);
        $this->assign('data',$data);
        $temp=(!empty($this->category_data['index_template']) ? $this->category_data['index_template'] : '');
        return $this->fetch($temp);

    }

    //显示某个栏目下的所有文章
    public function lists(){
        $data=model('article')->indexGetArticleDataToCategoryId($this->category_id);
        // 获取分页显示
        $page = $data->render();
        $this->assign('data',$data);
        $this->assign('page',$page);
        $temp=(!empty($this->category_data['list_template']) ? $this->category_data['list_template'] : '');
        return $this->fetch($temp);
    }

    //显示文章详情
    public function show(){
        $data=model('article')->indexFindArticleDataToId($this->id);
        //没有数据则跳转到404
        if(count($data) == 0){
            $this->redirect('/404.html');
        }
        $this->assign('data',$data);
        $this->is_auto=false;
        $this->category_id=$data['category_id'];
        $this->_initialize();
        //访问量增加
        uum_hits_add($this->id,$this->model_data['tablename']);
        $temp=(!empty($this->category_data['show_template']) ? $this->category_data['show_template'] : '');
        return $this->fetch($temp);
    }

}