<?php

namespace app\index\controller;

use think\Db;

class Download extends Common{
    public $is_auto=true;
    public $category_id;
    public $category_breadcrumb;
    public $category_data;
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        if($this->is_auto){
            $this->category_id=$this->request->param('category/d', 0 ,'intval');
        }
        //获取面包屑导航
        $this->category_breadcrumb=model('category')->indexGetCategoryBreadcrumbToModelId($this->category_id,$this->model_data['id']);
        $this->assign('category_breadcrumb',$this->category_breadcrumb);
        //栏目数据
        $this->category_data=model('category')->indexFindCategoryDataToId($this->category_id);
        //推荐文章
        $this->recommend_list=model('article')->indexGetArticleToOrder(['is_recommend'=>1],['is_top','desc']);
        //热门文章
        $this->hot_list=model('article')->indexGetArticleToOrder([],['hits','desc']);
        $this->assign('recommend_list',$this->recommend_list);
        $this->assign('hot_list',$this->hot_list);
    }

    //显示所有下载栏目的所有下载列表
    public function index(){
        $data=model('download')->indexGetDownloadDataToCategoryId($this->category_id);
        // 获取分页显示
        $page = $data->render();
        $this->assign('data',$data);
        $this->assign('page',$page);
        $temp=(!empty($this->category_data['index_template']) ? $this->category_data['index_template'] : '');
        return $this->fetch($temp);
    }

    //显示某个下载栏目下的所有下载列表
    public function lists(){
        $data=model('download')->indexGetDownloadDataToCategoryId($this->category_id);
        // 获取分页显示
        $page = $data->render();
        $this->assign('data',$data);
        $this->assign('page',$page);
        $temp=(!empty($this->category_data['list_template']) ? $this->category_data['list_template'] : '');
        return $this->fetch($temp);
    }

    //下载文件
    public function show(){
        $id=$this->request->param('id/d', 0 ,'intval');
        if($this->request->isAjax()){
            $id=$this->request->post('id/d', 0 ,'intval');
        }

        $data=model('download')->indexFindDownloadDataToId($id);
        if($id == 0 || count($data) == 0){
            //没有数据则跳转到404
            $this->redirect('/404.html');
        }
        $md5_file_url=md5($data['file_url'] . $id);

        if($this->request->isAjax()){
            //下载
            $pwd=$this->request->post('pwd/s');
            if($data['is_pwd'] != '0'){
                if ($pwd != $data['is_pwd']){
                    //记录ip 10分钟内错误5次封ip
                    return ['code'=>0,'msg'=>'密码错误'];
                }
            }

            session($md5_file_url,'1');
            return ['code'=>200,'msg'=>'下载成功'];

        }
        if(session("?$md5_file_url")){
            $file_url=$data['file_url'];
            if(!preg_match('/http:\/\/[\w.]+[\w\/]*[\w.]*\??[\w=&\+\%]*/is',$file_url)){
                $file_url =$this->request->domain() . $file_url;
            }
            $filename = basename($file_url);
            $mime = 'application/force-download';
            header('Pragma: public');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Cache-Control: private',false);
            header('Content-Type: '.$mime);
            header('Content-Disposition: attachment; filename="'.$filename.'"');
            header('Content-Transfer-Encoding: binary');
            header('Connection: close');
            readfile($file_url);
            session($md5_file_url,null);
            Db::name('download')->where('id',$id)->setInc('download_num');
        }

        $this->is_auto=false;
        $this->category_id=$data['category_id'];
        $this->_initialize();
        $this->assign('data',$data);

        //访问量增加
        uum_hits_add($id,$this->model_data['tablename']);
        //获取面包屑导航
        array_push($this->category_breadcrumb,['name'=>$data['title'],'url'=>'javascript:void(0)']);
        $this->assign('category_breadcrumb',$this->category_breadcrumb);
        $temp=(!empty($this->category_data['show_template']) ? $this->category_data['show_template'] : '');
        return $this->fetch($temp);


    }

}