<?php

namespace app\index\controller;

class Picture extends Common{
    public $is_auto=true;
    public $category_id;
    public $category_breadcrumb;
    public $category_data;
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        if($this->is_auto){
            $this->category_id=$this->request->param('category/d', 0 ,'intval');
        }
        $this->category_breadcrumb=model('category')->indexGetCategoryBreadcrumbToModelId($this->category_id,$this->model_data['id']);
        $this->assign('category_breadcrumb',$this->category_breadcrumb);
        $id=$this->request->param('id/d', 0 ,'intval');
        if($id != 0){
            //栏目导航
            $second_category=model('category')->indexGetSecondCategoryToModelId($this->model_data['id'],$this->category_id);
            $this->assign('second_category',$second_category);
        }
        //栏目数据
        $this->category_data=model('category')->indexFindCategoryDataToId($this->category_id);
        if($this->category_id != 0){
            //推荐文章
            $this->recommend_list=model('article')->indexGetArticleToOrder(['is_recommend'=>1],['is_top','desc']);
            //热门文章
            $this->hot_list=model('article')->indexGetArticleToOrder([],['hits','desc']);
            $this->assign('recommend_list',$this->recommend_list);
            $this->assign('hot_list',$this->hot_list);
        }
    }
    //显示所有图集栏目的所有列表
    public function index(){
        $data=model('picture')->indexGetPictureDataToCategoryId($this->category_id);
        // 获取分页显示
        $page = $data->render();
        $this->assign('data',$data);
        $this->assign('page',$page);
        $temp=(!empty($this->category_data['index_template']) ? $this->category_data['index_template'] : '');
        return $this->fetch($temp);
    }

    //显示某个图集栏目的所有列表
    public function lists(){
        $category_id=$this->request->param('category/d', 0 ,'intval');
        $data=model('picture')->indexGetPictureDataToCategoryId($category_id);
        // 获取分页显示
        $page = $data->render();
        $this->assign('data',$data);
        $this->assign('page',$page);
        $temp=(!empty($this->category_data['list_template']) ? $this->category_data['list_template'] : '');
        return $this->fetch($temp);
    }

    //显示图集详情
    public function show(){
        $id=$this->request->param('id/d', 0 ,'intval');
        if($this->request->isAjax()){
            $id=$this->request->post('id/d', 0 ,'intval');
        }
        $data=model('picture')->indexFindPictureDataToId($id);
        //没有数据则跳转到404
        if(count($data) == 0){
            $this->redirect('/404.html');
        }
        $md5_img_url=md5($data['images'] . $id);
        $is_pwd_img=0;
        if($data['is_pwd'] != '0'){
            if($this->request->isAjax()){
                $pwd=$this->request->post('pwd/s');
                if($pwd == $data['is_pwd']){
                    session($md5_img_url , time());
                    return ['code'=>200,'msg'=>'密码正确'];
                }else{
                    //做一些记录和限制
                    return ['code'=>0,'msg'=>'密码错误'];
                }
            }
            if(session("?$md5_img_url")){
               $expire=session($md5_img_url);
               if((time()-$expire) < 60*5){
                   $is_pwd_img=1;
               }else{
                   session($md5_img_url,null);
               }

            }
        }else{
            $is_pwd_img=1;
        }
        $data['is_pwd_img']=$is_pwd_img;
        $this->assign('data',$data);
        $this->is_auto=false;
        $this->category_id=$data['category_id'];
        $this->_initialize();
        //访问量增加
        uum_hits_add($id,$this->model_data['tablename']);
        $temp=(!empty($this->category_data['show_template']) ? $this->category_data['show_template'] : '');
        return $this->fetch($temp);
    }

}