<?php

namespace app\api\controller\v1\scratch;
use app\common\controller\RestBaseController;
use think\Db;
use app\common\lib\Upload;

use app\student\model\ScratchWorksPostModel;

class IndexController extends RestBaseController
{



    
    public function getUserInfo(){

        $userInfo = $this->user;

		$this->success('',$userInfo);

    }

	public function libraryList(){

        $param = $this->request->param();
        

        $type = isset($param['type'])? $param['type'] : '';
        $tag = !empty($param['tag'])?$param['tag']:'';
        $keywords = !empty($param['keywords'])?$param['keywords']:'';


        if ($type) {

            switch ($type) {
                case 'spriteLibrary':
                    $type = 'sprite';
                    break;
                case 'backdropLibrary':
                    $type = 'backdrop';
                    break;
                case 'costumeLibrary':
                    $type = 'costume';
                    break;
                case 'soundLibrary':
                    $type = 'sound';
                    break;
            }

            $where['post.post_type'] = $type;
        }

        
        $where['post.post_status'] = 1;
        $where['post.delete_time'] = 0;

        $join = [];

        if ($tag) {
            $tag_id = Db::name('library_tag')->where(['name'=>$tag,'tag_type'=>$type])->value('id');
            if ($tag_id) {
                array_push($join, ['__LIBRARY_TAG_POST__ tag_post', 'post.id = tag_post.post_id']);
                $where['tag_post.tag_id'] = $tag_id;
            } 
            
        }
        if (!empty($keywords)) {
            //$where['post.post_title'] = array('like',"%$keywords%");
            $where['post.post_title'] = $keywords;
        }

        $field = 'post.*';

        $library_select = Db::name('library_post')
            ->alias('post')
            ->field($field)
            ->join($join)
            ->where($where)
            ->order('post.id desc')
            ->group('post.id')
            ->paginate(30)
            ->toArray();
        foreach ($library_select['data'] as $key => $value) {
            $data_arr[] = json_decode($value['more']);
        }

        $library_select['data'] = !empty($data_arr) ? $data_arr : [] ;

        $this->success('ok',$library_select);
    }
     public function libraryTagList(){
        $param = $this->request->param();
        $type = $param['type'];

        
        switch ($type) {
            case 'spriteLibrary':
                $type = 'sprite';
                break;
            case 'backdropLibrary':
                $type = 'backdrop';
                break;
            case 'costumeLibrary':
                $type = 'costume';
                break;
            case 'soundLibrary':
                $type = 'sound';
                break;
        }

        $library_tag_select = Db::name('library_tag')
            ->where(['tag_type'=>$type,'tag_status'=>1,'status'=>1])
            ->select();


        $this->success('ok',$library_tag_select);
    }
    public function getInfo(){


        $param = $this->request->param();
        $id = decode($param['id']);

		$worksModel = new ScratchWorksPostModel();

        $project_find = $worksModel
	        ->where(['id' => $id])
	        ->find();
        if (!isset($project_find)) {
          $this->error('项目不存在!');
        }
		$project_find['post_title'] = $project_find['works_name'];

        $project_find['user'] = [
            'id'=>0,
            'avatar'=>'',
            'user_nickname'=>''
        ];
        

        

        // if (session('userId') == $project_find['user']['id']) {
        //     //unset($project_find['user']);
        // }
        $this->success('ok',$project_find);
    }
    
    public function scratch_index(){


        $param = $this->request->param();
        $id = decode($param['id']);

		$worksModel = new ScratchWorksPostModel();

        $project_find = $worksModel
            ->where(['id' => $id])
            ->find();
        if (!isset($project_find)) {
           $this->error('项目不存在!');
        }
        $s = json_decode(file_get_contents('./upload/'.$project_find['works_path']));

        $header['Access-Control-Allow-Origin'] = '*';
        $header['Access-Control-Allow-Credentials'] = 'true';


        $header['Access-Control-Allow-Headers'] = 'X-Requested-With,Content-Type,XX-Device-Type,XX-Token';
        $header['Access-Control-Allow-Methods'] = 'GET,POST,PATCH,PUT,DELETE,OPTIONS';

        returnD($s,$header);
    }

    public function create_post(){
        $vm = file_get_contents("php://input");
        $post_content = json_encode(json_decode($vm));


		$worksModel = new ScratchWorksPostModel();


        $param = $this->request->param();

        $title = isset($param['title'])?$param['title']:'作品'.time();

        //var_dump($vm);die;
        
        $time = time();

        $folder = './upload/works/'.date('Ymd',$time).'/';
		$folder2 = 'works/'.date('Ymd',$time).'/';
		$filename = md5(uniqid(md5(microtime(true)),true)).'.json';
		if(!is_dir($folder))
		{
		    mkdir($folder,0755,true);
		}

		file_put_contents($folder.$filename, $post_content);

        $data = [
            'works_name'=>$title,
            'works_path'=>$folder2.$filename
        ];


        $worksModel->save($data);

        $projectId = $worksModel->id;
        
        $returnD['autosave-interval'] = 120;
        $returnD['content-name'] = encode($projectId);
        $returnD['content-title'] = "VW50aXRsZWQtMTI=";
        $returnD['status'] = "ok";

        returnD($returnD);
    }

    public function edit_post(){

    }

    
    public function library_index(){

        $param = $this->request->param();
        $id = $param['id'];
        $suffix = $param['suffix'];

        $library_find = Db::name('library_post')
            ->where('post_id' , $id)
            ->field('post_id,file_path,suffix')
            ->find();
        if (!$library_find) {
        	$library_find = Db::name('library_post')
	            ->where('post_id' , $id.'.'.$suffix)
	            ->field('post_id,file_path,suffix')
	            ->find();
	            if (!$library_find) {
		            echo "404";die;
		        }
        }

        switch ($library_find['suffix']) {
          case 'mp3':
            $ContentType = 'application/octet-stream';
            $type = 'audio';
            break;
          case 'wav':
            $ContentType = 'application/octet-stream';
            $type = 'audio';
            break;
          case 'svg':
            $ContentType = 'image/svg+xml';
            $type = 'image';
            break;
          case 'png':
            $ContentType = 'image/png';
            $type = 'image';
            break;
          case 'jpg':
            $ContentType = 'image/jpeg';
            $type = 'image';
            break;
          case 'jpeg':
            $ContentType = 'image/jpeg';
            $type = 'image';
            break;
        }
        $fileName = './upload/'.$library_find['file_path'];
        //p($fileName);die;
        //vendor('getid3.getid3');
        //$audio = new \getID3();
        //$info =  $audio->analyze($fileName);  
        //p($info);

        $PSize = filesize($fileName);
        $picturedata = fread(fopen($fileName, "r"), $PSize);

        //$post_content = file_get_contents('../upload/'.$library_find['file_path']);

        $returnD = $picturedata;
        $header['Content-Type'] = $ContentType;
        $header['Accept-Ranges'] = 'bytes';
        $header['Content-Length'] = strlen($returnD);
        $header['Cache-Control'] = 'public, max-age=31536000';

        returnD($returnD,$header,$type);
    }

    public function library_create(){
        if (!session('userId')){
            $this->error('异常错误!');
        } 

        $param = $this->request->param();

        $id = $param['id'];
        $suffix = $param['suffix'];
        //$idInfo = explode('.',$id);
        $post_content = file_get_contents("php://input");

        $date = date('Ymd');

        $save_path = 'library/'.$date.'/'.$id;

        $path = './upload/'.$save_path;



        $pathmk = './upload/library/'.$date;
        if (!file_exists($pathmk)) {
            mkdir($pathmk,0777,true);
        }

        $myfile = fopen($path, "w");
        fwrite($myfile, $post_content);
        fclose($myfile);

        $data = [
            'user_id' => session('userId'),
            'post_id' => $id,
            //'post_content'=>$post_content,
            'suffix'=>$suffix,
            'file_path'=>$save_path
        ];

        Db::name('library_post')->insert($data);
        
        $returnD['status'] = 'ok';
        $returnD['content-name'] = $id;

        returnD($returnD);
    }
    public function upload()
    {
        if ($this->request->isPost()) {
            $id = decode(input('id'));

            $uploader = new Upload();

            $result = $uploader->upload();


            if ($result === false) {
                $this->error($uploader->getError());
            } else {
                $r = Db::name('scratch_works_post')
                        ->where(['id' => $id,'create_user_id'=>session('userId')])
                        ->update([
                            'thumbnail'=>$result['filepath'],
                            'update_time'=>time()
                        ]);
                Db::name('scratch_homework_post')
                        ->where(['works_id' => $id,'create_user_id'=>session('userId')])
                        ->update([
                            'thumbnail'=>$result['filepath'],
                            'update_time'=>time()
                        ]);

                $this->success("上传成功!", $result);
            }

        }
    }
       
}