<?php

namespace app\api\controller\v1\student;

use app\common\controller\RestUserBaseController;

use app\student\service\CourseService;
use app\student\service\LectureService;
use app\student\service\HomeworkService;

use app\student\model\ScratchHomeworkPostModel;

use think\Db;


class CourseController extends RestUserBaseController
{
	// 首页信息获取
	public function getHome()
	{
		$param = $this->request->param();

		$res = Db::name("school_student_post")->where('id',getStudentId())->find();

		$courseId = $res['course_id'];

		$courseService = new CourseService();
		
		$lectureService = new LectureService();

		$courseInfo = $courseService->getCourseInfo(['id'=>$courseId]);

		$courseInfo['lectures'] = [];
		$courseInfo['project'] = [];

		if ($courseInfo['subclass_type'] == 'project') {
			$courseInfo['project'] = $courseService->getCourseByParentId(['parent_id'=>$courseInfo['id']]);
		} elseif ($courseInfo['subclass_type'] == 'lecture') {
			$courseInfo['lectures'] = $lectureService->lectureListByCourseId(['course_id'=>$courseInfo['id']]);
		}
		
		if ($courseInfo) {
			$this->success('ok',$courseInfo);
		} else {
			$this->error('失败');
		}
	}
    //获取作业统计信息（Statistics）
    public function getHomeworksStatistics(){

        $WorksService = new HomeworkService();

        $res = $WorksService->getHomeworksStatistics();
        
        $this->success('',$res);
       
    }
	// 获取课程信息
	public function getCourseInfo()
	{
		$param = $this->request->param();

		
		$courseId = $param['id'];

		$courseService = new CourseService();
		
		$lectureService = new LectureService();

		$courseInfo = $courseService->getCourseInfo(['id'=>$courseId]);

		$courseInfo['lectures'] = [];
		$courseInfo['project'] = [];

		if ($courseInfo['subclass_type'] == 'project') {
			$courseInfo['project'] = [];
		} elseif ($courseInfo['subclass_type'] == 'lecture') {
			$courseInfo['lectures'] = $lectureService->lectureListByCourseId(['course_id'=>$courseInfo['id']]);
		}

		if ($courseInfo) {
			$this->success('ok',$courseInfo);
		} else {
			$this->error('失败');
		}
	}


	// 选择课程
	public function choiceCourse()
	{
		$param = $this->request->param();

		$courseId = $param['id'];

		$res = Db::name("school_student_post")->where('id',getStudentId())->update(['course_id'=>$courseId,'update_time'=>time()]);
		if ($res) {
    		cache('user_' . $this->userId , null, null ,'user');
			$this->success('ok');
		} else {
			$this->error('失败');
		}
		
	}
	// 作业完成情况列表
	public function getHomeworkResaltList()
	{
		$HomeworkResalt = [['option_id'=>1,'option_name'=>'全部完成'],['option_id'=>2,'option_name'=>'即将完成'],['option_id'=>3,'option_name'=>'完成一半'],['option_id'=>4,'option_name'=>'未完成']];

		$this->success('ok',$HomeworkResalt);
	}
	
	// 课程列表
	public function getCourseList()
	{
		$param = $this->request->param();

		$courseService = new CourseService();

		$courseData = $courseService->courseList($param);



		$this->success('ok',$courseData);
	}


	// 作业列表
	public function getHomework()
	{
		$param = $this->request->param();

		$courseService = new CourseService();

		$courseData = $courseService->homeworkList($param);



		$this->success('ok',$courseData);
	}

	// 创建作业
	public function createHomework()
	{
		$param = $this->request->param();

		$homeworkService = new HomeworkService(); 

		$createHomework = $homeworkService->createHomework($param);

		$this->success('ok',$createHomework);
	}
	
	// 重置学生作业
	public function resetHomework()
	{
		$param          = $this->request->param();
		$pass           = $param['pass'];
		$homeworksid    = $param['homeworkId'];
		
		if ($pass!=getOption('scratch_defaultvalue','overall')['reset_homework_pass']) {
			$this->error('密码错误！');
		}
		
		$scratchHomeworkPostMode = new ScratchHomeworkPostModel();

        $res = $scratchHomeworkPostMode->destroy($homeworksid);

		if ($res) {
			$this->success('重置成功！');
		} else {
			$this->error('重置失败！');
		}
	}	
	// 设置作业完成情况并设置作业评论
	public function setHomeworkResult()
	{
		$param          = $this->request->param();
		$pass           = $param['pass'];
        $homeworksid    = $param['homeworkId'];		
		
		if ($pass != getOption('scratch_defaultvalue','overall')['reset_homework_pass']) {
			$this->error('密码错误！');
		}
		
		$TeacherRemarks = [['option_id'=>1,'option_name'=>'哇，你很快就完成了，已经开始在做拓展训练，真的太棒了！'],['option_id'=>2,'option_name'=>'你已经快完成了，再补充一下细节即可，棒棒哒，老师为你加油哦！'],['option_id'=>3,'option_name'=>'你已经完成了一半，说明课上的内容都理解了，只是还需要加强熟练程度，很棒哦!下节课老师会带你巩固练习的！'],['option_id'=>4,'option_name'=>'如果还没有完成的话，可能是这节课内容比较多，不要紧，回去要自己看一看啊！把不理解的记录下来，下节课来问老师！']];
		
		$editData['homework_status'] = isset($param['resultId']) ? $param['resultId'] : 0;
		$editData['teacher_remark'] = $TeacherRemarks[$param['resultId']-1]['option_name'];
		
		$scratchHomeworkPostMode = new ScratchHomeworkPostModel();

        $res = $scratchHomeworkPostMode->save($editData,['id' => $homeworksid]);

		if ($res) {
			$this->success('设置成功！');
		} else {
			$this->error('设置失败！');
		}
	}
}
