<?php

namespace app\api\controller\v1\student;

use app\common\controller\RestUserBaseController;
use app\student\model\ScratchWorksPostModel;
use app\student\service\ScratchWorksPostService;

use think\Db;

class WorksController extends RestUserBaseController
{
    // 获取登录用户的作品列表信息
    public function getMyWorks()
    {
        $userId = $this->userId;

        $where['create_user_id'] = $userId;
  
        $pageNo = 1;
        $pageSize = 20;

        $field = '*';

        $worksModel = new ScratchWorksPostModel();

        // 查询课程列表
        $works      = $worksModel
            ->where($where)
            ->field($field)
            ->order('list_top desc')
            ->order('update_time desc')
            ->paginate(10)
            ->append(['status_text'])
            ->toArray();

        foreach ($works['data'] as $key => $value) {
            $works['data'][$key]['id'] = encode($value['id']);
        }

        $this->success('',$works);
    }
    //获取作品统计信息（Statistics）
    public function getMyWorksStatistics(){

        $WorksService = new ScratchWorksPostService();

        $res = $WorksService->getMyWorksStatistics();
        
        $this->success('',$res);     
    }    
    // 获取登录用户的回收站里的作品列表信息
    public function getRecycleMyWorks()
    {
        $userId = $this->userId;
        $where['create_user_id'] = $userId;
        $pageNo = 1;
        $pageSize = 20;

        $field = '*';

        $worksModel = new ScratchWorksPostModel();

        // 查询课程列表
        $works      = $worksModel
            ->onlyTrashed()
            ->where($where)
            ->field($field)
            ->order('update_time desc')
            ->paginate(10)
            ->append(['status_text'])
            ->toArray();

        foreach ($works['data'] as $key => $value) {
            $works['data'][$key]['id'] = encode($value['id']);
        }

        $this->success('',$works);
    }    

    // 删除登录用户的作业列表信息
    public function delMyWorks(){
        //以数组的形式接受参数
        $param = $this->request->param();
        
        $worksid = decode($param['id']);
        $worksModel = new ScratchWorksPostModel();
        
        if (isset($param['force'])) {//判断是否提交变量"force"
            $info = $worksModel->destroy($worksid,true);//永久删除
            //删除对应的作品文件


        }else{
            $info = $worksModel->destroy($worksid);
        }
        
        if ($info) {
            $this->success("删除成功");
        }else{
            $this->error("删除失败");
        }
        
    }
    // 置顶登录用户的作业列表信息
    public function topMyWorks(){
        //以数组的形式接受参数
        $param = $this->request->param();
        
        $worksid = decode($param['id']);
        $worksModel = new ScratchWorksPostModel();
        
        $info = $worksModel->save(['list_top' => 1],['id' => $worksid]);
        
        if ($info) {
            $this->success("置顶成功");
        }else{
            $this->error("置顶失败");
        }
    }    
    // 恢复登录用户的作品列表信息
    public function recoverMyWorks($id){
        $worksid = decode($id);
        $worksModel = new ScratchWorksPostModel();
        $info = $worksModel->restore(['id'=>$worksid]);
        if ($info) {
            $this->success("恢复成功");
        }else{
            $this->error("恢复成功");
        }
    }
    //修改作品信息
    public function modifyMyWorksInfo(){
        $param = $this->request->param();

        $WorksService = new ScratchWorksPostService();

        $res = $WorksService->editWorksInfo($param);
        
        if ($res) {
            $this->success('保存成功！');
        } else {
            $this->error('保存失败！');
        }        
    }
}
