<?php

namespace app\api\controller\v1\teacher;

use app\common\controller\RestUserBaseController;
use app\teacher\service\AccountService;
use think\Db;
use app\common\lib\Upload;
class AccountController extends RestUserBaseController
{
	// 获取登录用户信息
    public function getUserInfo()
    {

    	$userInfo = $this->user;
        $userInfo['role']['permissions'][] = ['permissionId'=>'dashboard'];
        $userInfo['role']['permissions'][] = ['permissionId'=>'user'];
		$this->success('',$userInfo);
    }
    // 获取登录用户的基本信息jfour
    public function getUserList()
    {
        $userModel = new AccountService();
        $res       = $userModel
                     ->getUserInfo();
        $this->success('',$res);
    }
    //修改登录用户的个人基本信息jfour
    public function modifyUserInfo(){
        $param = $this->request->param();

        $userModel = new AccountService();

        $res = $userModel->editUserInfo($param);
        
        if ($res) {
            $this->success('保存成功！');
        } else {
            $this->error('保存失败！');
        }        
    }
    //修改用户密码jfour
    public function editPassword(){
        $param = $this->request->param();

        $userModel = new AccountService();

        $res = $userModel->editPassword($param);
        
		if ($res['code']) {
			$this->success($res['msg']);
		} else {
			$this->error($res['msg']);
		}       
    }    
    /**
     * upload 上传
     */
    public function upload()
    {
        if ($this->request->isPost()) {

        	$id = input('id');

            $uploader = new Upload();

            $result = $uploader->upload();

            if ($result === false) {
                $this->error($uploader->getError());
            } else {

                $result['filepath'] = getAssetUrl($result['filepath']);

            	Db::name('user')->where('id',$id)->update(['avatar'=>$result['url']]);

                $this->success("上传成功!", $result);
            }

        } 
    }    
}
