<?php

namespace app\api\controller\v1\teacher;

use app\common\controller\RestBaseController;
use think\Db;
use think\facade\Validate;


class PublicController extends RestBaseController
{


    // 用户登录 TODO 增加最后登录信息记录,如 ip
    public function login()
    {
    	//参数验证
		$validate = new \think\Validate([
            'username' => 'require',
            'password' => 'require'
        ]);
        $validate->message([
            'username.require' => '请输入手机号,邮箱或用户名!',
            'password.require' => '请输入您的密码!'
        ]);

        $data = $this->request->param();
        if (!$validate->check($data)) {
            $this->error($validate->getError());
        }


    	//用户查询
        $userQuery = Db::name("user");
        if (Validate::is($data['username'], 'email')) {
            $userQuery = $userQuery->where('user_email', $data['username']);
        } else if (checkMobile($data['username'])) {
            $userQuery = $userQuery->where('mobile', $data['username']);
        } else {
            $userQuery = $userQuery->where('user_login', $data['username']);
        }

        $findUser = $userQuery->find();


        if (empty($findUser)) {
            $this->error("用户不存在!");
        } else {

        	// 判断用户类似 1 老师  2 学生
        	if ($findUser['user_type'] != 1) {
                $this->error("用户不存在!");
            }

            switch ($findUser['user_status']) {
                case 0:
                    $this->error('您已被拉黑!');
                case 2:
                    $this->error('账户还没有验证成功!');
            }

            if (!comparePassword($data['password'], $findUser['user_pass'])) {
                $this->error("密码不正确!");
            }
        }

        $allowedDeviceTypes = ['mobile', 'android', 'iphone', 'ipad', 'web', 'pc', 'mac'];

        if (empty($this->deviceType) && (empty($data['device_type']) || !in_array($data['device_type'], $this->allowedDeviceTypes))) {
            $this->error("请求错误,未知设备!");
        } else if(!empty($data['device_type'])) {
            $this->deviceType = $data['device_type'];
        }

        


        $token = generateUserToken($findUser['id'],$data['device_type']);

        //cache('token_' . $token  , $findUser['id'] , 24 * 3600 * 180 , 'token');

        $this->success("登录成功!", ['token' => $token]);
    }

    public function smsLogin()
    {
    	
    }

    // 用户退出
    public function logout()
    {
    	$deviceType = $this->deviceType;
    	$token = $this->token;

        $userId = $this->getUserId();

        removeToken($userId ,$deviceType, $token);

        $this->success("退出成功!");
    }



    // 找回密码
    public function passwordFind()
    {

        $this->success("退出成功!");
    }

    // 生成密码
    public function password()
    {
    	
        $this->success("ok!");
    }


    public function getSiteInfo()
    {
        $data = getOption('site_info','overall');

        $this->success('ok!',$data);
    }



}
