<?php

namespace app\api\controller\v1\teacher;

use app\common\controller\RestUserBaseController;
use app\teacher\service\ScratchClassesService;
use app\teacher\service\SchoolService;


class ScratchClassesController extends RestUserBaseController
{
	// 班级列表
	public function getClassesList()
	{
		$param = $this->request->param();

		$ScratchClassesService = new ScratchClassesService();

		$classesData = $ScratchClassesService->classesList($param);


		$schoolService = new SchoolService();

		$schoolData = $schoolService->schoolList();


		$this->success('ok',['classesData'=>$classesData,'schoolData'=>$schoolData]);
	}

	// 添加班级
	public function addClasses()
	{
		$param = $this->request->param();

		$ScratchClassesService = new ScratchClassesService();

		$res = $ScratchClassesService->addClasses($param);

		if ($res) {
			$this->success('添加成功！');
		} else {
			$this->error('添加失败！');
		}
		
		
	}

	// 编辑班级
	public function editClasses()
	{
		$param = $this->request->param();

		$ScratchClassesService = new ScratchClassesService();

		$res = $ScratchClassesService->editClasses($param);
		
		if ($res) {
			$this->success('保存成功！');
		} else {
			$this->error('保存失败！');
		}
	}

	// 删除班级
	public function delClasses()
	{
		$param = $this->request->param();

		$ScratchClassesService = new ScratchClassesService();

		$res = $ScratchClassesService->delClasses($param);
		
		if ($res) {
			$this->success('删除成功！');
		} else {
			$this->error('删除失败！');
		}
	}

	// 获取班级信息
	public function getClassesInfo()
	{
		$this->success('ok');
	}
}
