<?php

namespace app\api\controller\v1\teacher;

use app\common\controller\RestUserBaseController;

use app\teacher\service\ScratchCourseService;
use app\teacher\service\SchoolService;
use app\teacher\service\ScratchLectureService;
use app\teacher\service\ScratchClassesService;

use app\student\model\ScratchWorksPostModel;
use app\teacher\model\ScratchLecturePostModel;
use app\teacher\model\ScratchCoursePostModel;

class ScratchCourseController extends RestUserBaseController
{
	// 课程列表
	public function getCourseList()
	{
		$param = $this->request->param();

		$courseService = new ScratchCourseService();

		$courseData = $courseService->courseList($param);


		$schoolService = new SchoolService();

		$schoolData = $schoolService->schoolList();

		$ScratchClassesService = new ScratchClassesService();

		$classesData = $ScratchClassesService->classesData();

		$this->success('ok',['courseData'=>$courseData,'schoolData'=>$schoolData,'classesData'=>$classesData]);
	}

	// 获取课程信息
	public function getCourseInfo()
	{
		$param = $this->request->param();


		
		$courseId = $param['id'];

		$courseService = new ScratchCourseService();
		
		$lectureService = new ScratchLectureService();

		$courseInfo = $courseService->getCourseInfo(['id'=>$courseId]);

		$courseInfo['lectures'] = [];
		$courseInfo['project'] = [];

		if ($courseInfo['subclass_type'] == 'project') {
			$courseInfo['project'] = $courseService->getCourseByParentId(['parent_id'=>$courseInfo['id']]);
		} elseif ($courseInfo['subclass_type'] == 'lecture') {
			$courseInfo['lectures'] = $lectureService->lectureListByCourseId(['course_id'=>$courseInfo['id']]);
		}
		
		if ($courseInfo) {
			$this->success('ok',$courseInfo);
		} else {
			$this->error('失败');
		}
	}

	// 添加课程
	public function addCourse()
	{
		$param = $this->request->param();

		$courseService = new ScratchCourseService();

		$res = $courseService->addCourse($param);

		if ($res) {
			$this->success('添加成功！');
		} else {
			$this->error('添加失败！');
		}
	}

	// 修改课程
	public function editCourse()
	{
		$param = $this->request->param();
		
		$courseService = new ScratchCourseService();

		$res = $courseService->editCourse($param);

		if ($res) {
			$this->success('修改成功！');
		} else {
			$this->error('修改失败！');
		}
	}

	// 删除课程
	public function delCourse()
	{
		$param = $this->request->param();
		
		$courseService = new ScratchCourseService();

		$res = $courseService->delCourse($param);

		if ($res) {
			$this->success('删除成功！');
		} else {
			$this->error('删除失败！');
		}
	}

   // 获取登录用户的作品列表信息jfour
    public function getMyWorks()
    {
        $userId = $this->userId;

        $where['create_user_id'] = $userId;
  
        $pageNo = 1;
        $pageSize = 8;

        $field = '*';

        $worksModel = new ScratchWorksPostModel();

        // 查询课程列表
        $works      = $worksModel
            ->where($where)
            ->field($field)
            ->order('update_time desc')
            ->paginate($pageSize)
            ->append(['status_text'])
            ->toArray();
		
		$param = $this->request->param();
		$lecture_id = $param['lecture_id'];
        $ScratchLectureModel = new ScratchLecturePostModel();
        $start_work_id = $ScratchLectureModel->get($lecture_id)->start_works_id;
        $where['id'] = $start_work_id ? $start_work_id : 0;            
        // 查询课程列表
        $work      = $worksModel
            ->where($where)
            ->field($field)
            ->append(['status_text'])
            ->find();

        $this->success('',['work'=>$work,'works'=>$works]);
    }
    //设置课时的初始作品
    public function setSelectedWork(){
        $param = $this->request->param();
        $lecture_id = isset($param['lecture_id']) ? $param['lecture_id'] : 0;
        $work_id = isset($param['work_id']) ? $param['work_id'] : 0;
        
        $ScratchLectureModel = new ScratchLecturePostModel();
        $editData['start_works_id']   = isset($param['work_id']) ? $param['work_id'] : 0;
        
        $res = $ScratchLectureModel->save($editData,['id'=>$lecture_id]);
        
        if ($res) {
            $this->success('设置成功！');
        } else {
            $this->error('设置失败！');
        }
        
    }
    //设置课时的视频地址
    public function setLectureVideo(){
        $param = $this->request->param();
        $lecture_id = isset($param['lecture_id']) ? $param['lecture_id'] : 0;
        $video_path = isset($param['video_path']) ? $param['video_path'] : '';
        
        $ScratchLectureModel = new ScratchLecturePostModel();
        $editData['video_path']   = $video_path;
        
        $res = $ScratchLectureModel->save($editData,['id'=>$lecture_id]);
        
        if ($res) {
            $this->success('设置成功！');
        } else {
            $this->error('设置失败！');
        }
        
    }    
    //设置课程的图片
    public function setCoursePicture(){
        $param = $this->request->param();
        $course_id = isset($param['course_id']) ? $param['course_id'] : 0;
        $field = isset($param['field']) ? $param['field'] : '';
        $src = isset($param['src']) ? $param['src'] : '';
        
        $ScratchCoursePostModel = new ScratchCoursePostModel();
        $editData[$field]   = $src;
        
        $res = $ScratchCoursePostModel->save($editData,['id'=>$course_id]);
        
        if ($res) {
            $this->success('设置成功！');
        } else {
            $this->error('设置失败！');
        }
        
    }   
}
