<?php

namespace app\api\controller\v1\teacher;

use app\common\controller\RestUserBaseController;

use app\teacher\service\ScratchLectureService;
use app\teacher\service\SchoolService;

use app\common\lib\Upload;
use think\Db;

class ScratchLectureController extends RestUserBaseController
{
	

	// 添加课程
	public function addLecture()
	{
		$param = $this->request->param();

		$LectureService = new ScratchLectureService();

		$res = $LectureService->addLecture($param);

		if ($res) {
			$this->success('添加成功！');
		} else {
			$this->error('添加失败！');
		}
	}

	// 修改课程
	public function editLecture()
	{
		$param = $this->request->param();
		
		$LectureService = new ScratchLectureService();

		$res = $LectureService->editLecture($param);

		if ($res) {
			$this->success('修改成功！');
		} else {
			$this->error('修改失败！');
		}
	}

	// 删除课程
	public function delLecture()
	{
		$param = $this->request->param();
		
		$LectureService = new ScratchLectureService();

		$res = $LectureService->delLecture($param);

		if ($res) {
			$this->success('删除成功！');
		} else {
			$this->error('删除失败！');
		}
	}

	public function editLectureCoordinate()
	{
		$param = $this->request->param();
		
		$LectureService = new ScratchLectureService();

		$res = $LectureService->editLectureCoordinate($param);

		if ($res) {
			$this->success('修改成功！');
		} else {
			$this->error('修改失败！');
		}
	}


	/**
     * upload 上传
     */
    public function upload()
    {
        if ($this->request->isPost()) {

        	$id = input('id');
            
            $uploader = new Upload();

            $result = $uploader->upload();

            if ($result === false) {
                $this->error($uploader->getError());
            } else {

                $result['filepath'] = getAssetUrl($result['filepath']);
                if(input('subclass_type')=='lecture'){
                    Db::name('scratch_course_post')->where('id',$id)->update(['thumbnail'=>$result['url']]);
                }else{
            	    Db::name('scratch_lecture_post')->where('id',$id)->update(['thumbnail'=>$result['url']]);                    
                }


                $this->success("上传成功!", $result);
            }

        } 
    }


}
