<?php

namespace app\api\controller\v1\teacher;

use app\common\controller\RestUserBaseController;
use app\teacher\service\ScratchStudentService;
use app\teacher\service\SchoolService;
use app\teacher\service\ScratchClassesService;
use app\teacher\model\SchoolStudentPostModel;

use think\Db;

class ScratchStudentController extends RestUserBaseController
{

	/**
     * 学员列表
     * @return json
     */
	public function getStudentList()
	{

		$param = $this->request->param();

		$ScratchStudentService = new ScratchStudentService();

		$studentData = $ScratchStudentService->studentList($param);


		$schoolService = new SchoolService();

		$schoolData = $schoolService->schoolList();

		$ScratchClassesService = new ScratchClassesService();

		$classesData = $ScratchClassesService->classesData();


		$this->success('ok',['studentData'=>$studentData,'schoolData'=>$schoolData,'classesData'=>$classesData]);
	}

	// 添加学员
	public function addStudent()
	{
		$param = $this->request->param();

		foreach ($param['phone'] as $key => $value) {
			if(!checkMobile($value)){
				$this->error('请输入正确的手机号！');
			}
		}

		if (!isset($param['student_number'])) {
            $this->error('学号必填！');
        }

		$SchoolStudentPostModel = new SchoolStudentPostModel();

		$studentFind = $SchoolStudentPostModel
					->where('student_number',$param['student_number'])
					->find();
		if($studentFind){
			$this->error('学号重复！');
		}
		$userFind = Db::name('user')
					->where('user_login',$param['student_number'])
					->find();
		if($userFind){
			$this->error('学号重复！');
		}

		$ScratchStudentService = new ScratchStudentService();

		$res = $ScratchStudentService->addStudent($param);

		if ($res) {
			$this->success('添加成功！');
		} else {
			$this->error('添加失败！');
		}
		
		
	}

	// 编辑学员
	public function editStudent()
	{
		$param = $this->request->param();

		$ScratchStudentService = new ScratchStudentService();

		$SchoolStudentPostModel = new SchoolStudentPostModel();

		


		$res = $ScratchStudentService->editStudent($param);
		
		if ($res) {
			$this->success('保存成功！');
		} else {
			$this->error('保存失败！');
		}
	}

	// 删除学员
	public function delStudent()
	{
		$param = $this->request->param();

		$ScratchStudentService = new ScratchStudentService();

		$res = $ScratchStudentService->delStudent($param);
		
		if ($res) {
			$this->success('删除成功！');
		} else {
			$this->error('删除失败！');
		}
	}

	// 获取学员信息
	public function getStudentInfo()
	{
		$this->success('ok');
	}


	public function resetPassword($value='')
	{
		$param = $this->request->param();

		$ScratchStudentService = new ScratchStudentService();

		$res = $ScratchStudentService->resetPassword($param);
		
		$this->success('重置成功！');
	}
}
