<?php

namespace app\api\controller\v1\teacher;


use app\common\controller\RestUserBaseController;


class SettingController extends RestUserBaseController
{

	/**
     * 获取基础信息
     * @return json
     */
	public function getSetting()
	{

		$param = $this->request->param();

        $range = isset($param['range']) ? $param['range'] : 'overall';
		$settingType = $param['setting_type'];

		switch ($settingType) {
			case 'base':
				$data = getOption('site_info',$range);
				break;
			case 'logo':
				$data = getOption('site_logo',$range);
				break;
			case 'wxoa':
				$data = getOption('site_wxoa',$range);
				break;
			case 'defaultvalue':
				$data = getOption('site_defaultvalue',$range);
				break;
			case 'scratch_base':
				$data = getOption('scratch_info',$range);
				break;
			case 'scratch_logo':
				$data = getOption('scratch_logo',$range);
				break;
			case 'scratch_wxoa':
				$data = getOption('scratch_wxoa',$range);
				break;
			case 'scratch_defaultvalue':
				$data = getOption('scratch_defaultvalue',$range);
				break;					
		}
		$this->success('ok!',$data);
	}

	/**
     * 设置基本信息
     * @return json
     */
	public function editSetting()
	{

		$param = $this->request->param();

        $range = isset($param['range']) ? $param['range'] : 'overall';
		$settingType = $param['setting_type'];

		switch ($settingType) {
			case 'base':
				$editData['site_name'] = isset($param['site_name'])?$param['site_name']:'';
				$editData['copyright'] = isset($param['copyright'])?$param['copyright']:'';
				setOption('site_info', $editData,$range,0,true);
				break;
			case 'logo':
				//$editData['site_name'] = $param['site_name'];
				//$editData['copyright'] = $param['copyright'];
				//setOption('site_logo', $editData,'overall',1,true);
				break;
			case 'wxoa':
				$editData['AppId'] = isset($param['AppId'])?$param['AppId']:'';
				$editData['AppSecret'] = isset($param['AppSecret'])?$param['AppSecret']:'';
				setOption('site_wxoa', $editData,$range,0,true);
				break;
			case 'defaultvalue':
				$editData['pass'] = isset($param['pass'])?$param['pass']:'';
				setOption('site_defaultvalue', $editData,$range,0,true);
				break;
			// scratch 应用的设置
			case 'scratch_base':
				$editData['site_name'] = isset($param['site_name'])?$param['site_name']:'';
				$editData['copyright'] = isset($param['copyright'])?$param['copyright']:'';
				setOption('scratch_info', $editData,$range,0,true);
				break;
			case 'scratch_logo':
				//$editData['site_name'] = $param['site_name'];
				//$editData['copyright'] = $param['copyright'];
				//setOption('site_logo', $editData,'overall',1,true);
				break;
			case 'scratch_wxoa':
				$editData['AppId'] = isset($param['AppId'])?$param['AppId']:'';
				$editData['AppSecret'] = isset($param['AppSecret'])?$param['AppSecret']:'';
				setOption('scratch_wxoa', $editData,$range,0,true);
				break;
			case 'scratch_defaultvalue':
				$editData['pass'] = isset($param['pass'])?$param['pass']:'';
				$editData['reset_homework_pass'] = isset($param['reset_homework_pass'])?$param['reset_homework_pass']:'';
				$res = setOption('scratch_defaultvalue', $editData,$range,0,true);
				break;		    
		}
        
		$this->success('设置成功!');
	}

	

}
