<?php
namespace app\api\controller\v1\teacher;

use app\common\controller\RestUserBaseController;

use app\teacher\service\StaffService;

class StaffController extends RestUserBaseController
{

	// 请求员工列表
	public function getStaff()
	{
		$param = $this->request->param();

		$StaffService = new StaffService();

		$res = $StaffService->getStaff($param);

		if ($res) {
			$this->success('',$res);
		} else {
			$this->error('请求失败！');
		}
	}


	// 添加员工
	public function addStaff()
	{
		$param = $this->request->param();

		$StaffService = new StaffService();

		$res = $StaffService->addStaff($param);

		if ($res['code']) {
			$this->success($res['msg']);
		} else {
			$this->error($res['msg']);
		}
	}
	
	// 给员工生成学生账号
	public function addStaffStudentAcount()
	{
		$param = $this->request->param();

		$StaffService = new StaffService();

		$res = $StaffService->addStaffStudentAcount($param);

		if ($res['code']) {
			$this->success($res['msg']);
		} else {
			$this->error($res['msg']);
		}
	}	

	// 修改员工
	public function editStaff()
	{
		$param = $this->request->param();
		
		if ($param['id'] == 1) {
			$this->error('管理员信息不能修改！');
		}
		

		$StaffService = new StaffService();

		$res = $StaffService->editStaff($param);

		if ($res['code']) {
			$this->success($res['msg']);
		} else {
			$this->error($res['msg']);
		}
	}

	// 删除员工
	public function deleteStaff()
	{
		$param = $this->request->param();
		
		if ($param['id'] == 1) {
			$this->error('管理员信息不能删除！');
		}

		$StaffService = new StaffService();

		$res = $StaffService->deleteStaff($param);

		if ($res) {
			$this->success('删除成功！');
		} else {
			$this->error('删除失败！');
		}
	}

	public function resetPassword($value='')
	{
		$param = $this->request->param();

		$StaffService = new StaffService();

		$res = $StaffService->resetPassword($param);
		
		$this->success('重置成功！');
	}
	
	public function editStaffDept()
	{
		$param = $this->request->param();
		
		$StaffService = new StaffService();

		$res = $StaffService->editStaffDept($param);

		if ($res) {
			$this->success('修改成功！');
		} else {
			$this->error('修改失败！');
		}
	}

	

}
