<?php


use think\cache\driver\Redis;
use app\common\lib\Storage;
use app\common\lib\Convert;
use think\Loader;

use think\Response;
use think\exception\HttpResponseException;




/**
* 得到子级数组
* @param int
* @return array
*/
function getRecursionChild($arr,$myid,$pidName='parent_id',$childName='children'){
    $a = $newarr = array();
    if(is_array($arr)){
        foreach($arr as $key => $a){
            if($a[$pidName] == $myid) $newarr[$a['id']] = $a;
        }
    }
    return $newarr ? $newarr : false;
}

/**
* 得到所有子级id
* @param int
* @return array
*/
function getRecursionAllChildids($arr,$myid,$pidName='parent_id',$childName='children'){
    $child = array();
    $ids = array();
    $child = getRecursionChild($arr,$myid);
    $total = !empty($child) ? count($child) : 0;
    if($total > 0){
        foreach($child as $id => $value){
            $ids[] = $id;
            $ids = array_merge($ids,getRecursionAllChildids($arr,$id,$pidName,$childName));
        }
    }
    return $ids;
}

/**
 * 无限级递归数组
 * @return arr
 */
function getRecursionTree($list,$pidName='parent_id',$childName='children', $newArr=[], $pid = '0',$level = 0){
    $newArr = []; // 新数组用于存放数据
    if (!empty($list)) {
        foreach ($list as $k => &$v) {
            if ($v[$pidName] == $pid) { // 如果父ID与pid相同则为父级数组
               $v['level'] = $level; // 层级
               $v[$childName] = getRecursionTree($list,$pidName,$childName, $newArr, $v['id'],$level+1); // 递归处理数据
               $newArr[] = $v; // 新数据放入数组准备返回
            }
        }
    }
    return $newArr;
}


/**
 * 获取客户端IP地址
 * @param integer $type 返回类型 0 返回IP地址 1 返回IPV4地址数字
 * @param boolean $adv  是否进行高级模式获取（有可能被伪装）
 * @return string
 */
function get_client_ip($type = 0, $adv = true)
{
    return request()->ip($type, $adv);
}


/*
 * post 发送JSON 格式数据
 * @param $url string URL
 * @param $data_string string 请求的具体内容
 * @return array
 *      code 状态码
 *      result 返回结果
 */
function curlPost($url, $data_string) {
    //初始化
    $ch = curl_init();
    //设置post方式提交
    curl_setopt($ch, CURLOPT_POST, 1);
    //设置抓取的url
    curl_setopt($ch, CURLOPT_URL, $url);
    //设置post数据
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    //设置头文件的信息作为数据流输出
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Content-Length: ' . strlen($data_string))
    );
    ob_start();
     //执行命令
    curl_exec($ch);
    $return_content = ob_get_contents();
    ob_end_clean();
    $return_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    return $return_content;
}


/**
 * curl get 请求
 * @param $url
 * @return mixed
 */
function curlGet($url)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_FAILONERROR, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_AUTOREFERER, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    $SSL = substr($url, 0, 8) == "https://" ? true : false;
//    if ($SSL) {
//        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 信任任何证书
//        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2); // 检查证书中是否设置域名
//    }
    $content = curl_exec($ch);
    curl_close($ch);
    return $content;
}


/**
 * 简单对称加密算法之加密
 * @param String $string 需要加密的字串
 * @param String $skey 加密KEY
 */
// function encode($string = '', $skey = 'gshsgf') {
//     $strArr = str_split(base64_encode($string));
//     $strCount = count($strArr);
//     foreach (str_split($skey) as $key => $value)
//         $key < $strCount && $strArr[$key].=$value;
//     return str_replace(array('=', '+', '/'), array($skey, 'offox', 'goOfx'), join('', $strArr));
// }
/**
 * 简单对称加密算法之解密
 * @param String $string 需要解密的字串
 * @param String $skey 解密KEY
 */
// function decode($string = '', $skey = 'gshsgf') {
//     $strArr = str_split(str_replace( array($skey, 'offox', 'goOfx'), array('=', '+', '/'), $string), 2);
//     $strCount = count($strArr);
//     foreach (str_split($skey) as $key => $value)
//         $key < $strCount && $strArr[$key][1] === $value && $strArr[$key] = $strArr[$key][0];
//     return base64_decode(join('', $strArr));
// }

function encode($id = 0){
	$obj = new convert(32);
	$res = $obj->idToString($id);
	return $res;
}

function decode($string = ''){
    
    if(is_numeric($string)){
        return $string;
    }
	$obj = new convert(32);
	$res = $obj->stringToId($string);
	return $res;
}


function returnD($data = '',array $header = [],$type = 'json'){
        $result = $data;
        $header['Access-Control-Allow-Origin']  = '*';
        $header['Access-Control-Allow-Headers'] = 'X-Requested-With,Content-Type,XX-Device-Type,XX-Token';
        $header['Access-Control-Allow-Methods'] = 'GET,POST,PATCH,PUT,DELETE,OPTIONS';
        
        $response   = Response::create($result, $type)->header($header);
        throw new HttpResponseException($response);
}        


/**
 * @param string $address 地址
 * @param string $city  城市名
 * @return array
 */
function getLatLng($ak='', $address='',$city='')
{
    $result = [];
    $url ="http://api.map.baidu.com/geocoding/v3/?callback=showLocation&output=json&address=".$address."&city=".$city."&ak=".$ak;
    $data = file_get_contents($url);
    $data = str_replace('showLocation&&showLocation(', '', $data);
    $data = str_replace(')', '', $data);
    $data = json_decode($data,true);
    if (!empty($data) && $data['status'] == 0) {
        $result['lat'] = $data['result']['location']['lat'];
        $result['lng'] = $data['result']['location']['lng'];
        return $result;//返回经纬度结果
    }else{
        return 'null';
    }
 
}


/*
    PHP密码强度判断常用方法
 */
function checkPassword($pwd) {
    if ($pwd == null) {
        return ['code' => 0, 'data' => '', 'msg' => '密码不能为空'];
    }
    $pwd = trim($pwd);
    if (!strlen($pwd) >= 6) {//必须大于6个字符
        return ['code' => 0, 'data' => '', 'msg' => '密码必须大于6字符'];
    }
    if (preg_match("/^[0-9]+$/", $pwd)) { //必须含有特殊字符
        return ['code' => 0, 'data' => '', 'msg' => '密码不能全是数字，请包含数字，字母大小写或者特殊字符'];
    }
    if (preg_match("/^[a-zA-Z]+$/", $pwd)) {
        return ['code' => 0, 'data' => '', 'msg' => '密码不能全是字母，请包含数字，字母大小写或者特殊字符'];
    }
    if (preg_match("/^[0-9A-Z]+$/", $pwd)) {
        return ['code' => 0, 'data' => '', 'msg' => '请包含数字，字母大小写或者特殊字符'];
    }
    if (preg_match("/^[0-9a-z]+$/", $pwd)) {
        return ['code' => 0, 'data' => '', 'msg' => '请包含数字，字母大小写或者特殊字符'];
    }
    return true;
}

/**
* 中间加密 字符串截取法
*/
function encryptTel($tel) {
    $new_tel = substr($tel, 0, 3).'****'.substr($tel, 7);
    return $new_tel;
}

/**
 * 解密用strDecode加密的字符串
 * @param        $string    要解密的字符串
 * @param string $key       加密时salt
 * @param int    $expiry    多少秒后过期
 * @param string $operation 操作,默认为DECODE
 * @return bool|string
 */
function strDecode($string, $key = '', $expiry = 0, $operation = 'DECODE')
{
    $ckey_length = 4;

    $key  = md5($key ? $key : config("database.authcode"));
    $keya = md5(substr($key, 0, 16));
    $keyb = md5(substr($key, 16, 16));
    $keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length) : substr(md5(microtime()), -$ckey_length)) : '';

    $cryptkey   = $keya . md5($keya . $keyc);
    $key_length = strlen($cryptkey);

    $string        = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0) . substr(md5($string . $keyb), 0, 16) . $string;
    $string_length = strlen($string);

    $result = '';
    $box    = range(0, 255);

    $rndkey = [];
    for ($i = 0; $i <= 255; $i++) {
        $rndkey[$i] = ord($cryptkey[$i % $key_length]);
    }

    for ($j = $i = 0; $i < 256; $i++) {
        $j       = ($j + $box[$i] + $rndkey[$i]) % 256;
        $tmp     = $box[$i];
        $box[$i] = $box[$j];
        $box[$j] = $tmp;
    }

    for ($a = $j = $i = 0; $i < $string_length; $i++) {
        $a       = ($a + 1) % 256;
        $j       = ($j + $box[$a]) % 256;
        $tmp     = $box[$a];
        $box[$a] = $box[$j];
        $box[$j] = $tmp;
        $result  .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
    }

    if ($operation == 'DECODE') {
        if ((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26) . $keyb), 0, 16)) {
            return substr($result, 26);
        } else {
            return '';
        }
    } else {
        return $keyc . str_replace('=', '', base64_encode($result));
    }

}

/**
 * 加密字符串
 * @param        $string 要加密的字符串
 * @param string $key    salt
 * @param int    $expiry 多少秒后过期
 * @return bool|string
 */
function strEncode($string, $key = '', $expiry = 0)
{
    return strDecode($string, $key, $expiry, "ENCODE");
}


function getUserId()
{
    return session('userId');
}

function getStudentId()
{
    return session('studentId');
}


/**
 * 通过 uid 查找用户信息
 * @param $userId
 * @return array 用户信息

 */
function getUserInfoById($userId)
{
    $cacheData = cache('user_' . $userId );

    if(!$cacheData){
        $userQuery = Db::name("user")
        ->where('id', $userId);
        $cacheData  = $userQuery->find();

        if ($cacheData) {
            $cacheData['studentInfo'] = [];
            $studentQuery = Db::name("school_student_post")
            ->where('user_id', $userId);
            $studentFind  = $studentQuery->find();

            if ($studentFind) {
                $cacheData['studentInfo'] = $studentFind;
            }
            unset($cacheData['user_pass']);
            
            cache('user_' . $userId , $cacheData, null ,'user');
        } else {
            return false;
        }
    }

    return $cacheData;
}


/**
 * 通过 token 查找用户id
 * @param $token
 * @param $deviceType
 * @return int 用户Id

 */
function getUserIdByToken($token,$deviceType)
{
    $tokenData = cache('token_' . $token );

    if(empty($tokenData)){
        return false;
    } 
    if (!empty($tokenData['user_id'])) {
        // 判断缓存里面的过期时间 和 设备
        if ($tokenData['expire_time'] > time() ) {
            if ($tokenData['device_type'] == $deviceType) {
                $userId = $tokenData['user_id'];
                return $userId;
            }
                
        } else {
            $userId = $tokenData['user_id'];
            removeToken($userId,'',$token);
        }
    } else {
        cache('token_' . $token, null,null, 'token');
    }
    



    return false;
}


/**
 * 设置 token 到缓存
 * @param $userId
 * @param $deviceType
 * @return string 用户 token

 */
function setToken($userId,$deviceType)
{

    $time = 24 * 3600 * 1 ;

    $currentTime    = time();
    $expireTime     = $currentTime + $time;
    $token          = md5(uniqid()) . md5(uniqid());

    $tokenData = [
                    'token'       => $token,
                    'user_id'     => $userId,
                    'expire_time' => $expireTime,
                    'create_time' => $currentTime,
                    'device_type' => $deviceType
                ];


    cache('token_' . $token,$tokenData, $time ,'token');

    $tokenUserData = cache('token_user_' . $userId );

    $tokenUserData[] = $tokenData;
    cache('token_user_' . $userId,$tokenUserData ,null ,'token_user' );
    removeToken($userId);

    return $token;
}



 
/**
 * 删除缓存的 token 
 * @param $userId
 * @param $deviceType
 * @param $token
 * @return null

 */
function removeToken($userId,$deviceType = '',$token = ''){

    $time = 24 * 3600 * 180;

    if (!empty($userId)) {
        $tokenUserData = cache('token_user_' . $userId );
        if (!empty($tokenUserData)) {
            foreach ($tokenUserData as $key => $value) {
                $t = cache('token_' . $value['token']);
                if ($value['expire_time'] <= time() || !$t) {
                    unset($tokenUserData[$key]);
                    cache('token_' . $value['token'],null,null, 'token');
                }

                if (!empty($token) && !empty($deviceType)) {
                    if ($value['token'] == $token && $value['device_type'] == $deviceType ) {
                        unset($tokenUserData[$key]);
                        cache('token_' . $value['token'],null,null, 'token');
                    }
                }

                if (!empty($token)  && empty($deviceType)) {
                    if ($value['token'] == $token  ) {
                        unset($tokenUserData[$key]);
                        cache('token_' . $value['token'],null,null, 'token');
                    }
                }

                if (empty($token) && !empty($deviceType)) {
                    if ($value['device_type'] == $deviceType ) {
                        unset($tokenUserData[$key]);
                        cache('token_' . $value['token'],null,null, 'token');
                    }
                }
            }

            cache('token_user_' . $userId, $tokenUserData, $time, 'token_user');
        }
    }

}






/**
 * 生成用户 token
 * @param $userId
 * @param $deviceType
 * @return string 用户 token

 */
function generateUserToken($userId, $deviceType)
{

    $token = false;

    $tokenUserData = cache('token_user_' . $userId );

    if(!$tokenUserData){
        $token = setToken($userId, $deviceType);
    } else {
        foreach ($tokenUserData as $key => $value) {
            if ($deviceType == $value['device_type']) {
                if ($value['expire_time'] > time()) {
                    $tokenData = cache('token_'.$value['token']);
                    if ($tokenData) {
                        $token = $tokenData['token'];
                    } else {
                        $token = setToken($userId, $deviceType);
                    }
                } else {
                    removeToken($userId);
                }
            }
        }
        if ($token == false) {
            $token = setToken($userId, $deviceType);
        }
    }



    return $token;
}


/**
 * 检查手机格式，中国手机不带国家代码，国际手机号格式为：国家代码-手机号
 * @param $mobile
 * @return bool
 */
function checkMobile($mobile)
{
    if (preg_match('/(^(13\d|14\d|15\d|16\d|17\d|18\d|19\d)\d{8})$/', $mobile)) {
        return true;
    } else {
        if (preg_match('/^\d{1,4}-\d{5,11}$/', $mobile)) {
            if (preg_match('/^\d{1,4}-0+/', $mobile)) {
                //不能以0开头
                return false;
            }

            return true;
        }

        return false;
    }
}

/**
 * 区分大小写的文件存在判断
 * @param string $filename 文件地址
 * @return boolean
 */
function fileExistsCase($filename)
{
    if (is_file($filename)) {
        if (APP_DEBUG) {
            if (basename(realpath($filename)) != basename($filename))
                return false;
        }
        return true;
    }
    return false;
}

/**
 * 字符串命名风格转换
 * type 0 将Java风格转换为C的风格 1 将C风格转换为Java的风格
 * @param string  $name    字符串
 * @param integer $type    转换类型
 * @param bool    $ucfirst 首字母是否大写（驼峰规则）
 * @return string
 */
function parseName($name, $type = 0, $ucfirst = true)
{
    return Loader::parseName($name, $type, $ucfirst);
}

/**
 * 获取当前主题名
 * @return string
 */
function getCurrentTheme()
{
    if (PHP_SAPI != 'cli') {
        static $_currentTheme;

        if (!empty($_currentTheme)) {
            return $_currentTheme;
        }
    }

    $t     = 't';
    $theme = config('template.default_theme');

    $cmfDetectTheme = config('template.detect_theme');
    if ($cmfDetectTheme) {
        if (isset($_GET[$t])) {
            $theme = $_GET[$t];
            cookie('template', $theme, 864000);
        } elseif (cookie('template')) {
            $theme = cookie('template');
        }
    }


    $designT = '_design_theme';
    if (isset($_GET[$designT])) {
        $theme = $_GET[$designT];
        cookie('design_theme', $theme, 4);
    } elseif (cookie('design_theme')) {
        $theme = cookie('design_theme');
    }

    $_currentTheme = $theme;

    return $theme;
}

/**
 * 获取当前后台主题名
 * @return string
 */
function getCurrentAdminTheme()
{
    if (PHP_SAPI != 'cli') {

        static $_currentAdminTheme;

        if (!empty($_currentAdminTheme)) {
            return $_currentAdminTheme;
        }
    }

    $t     = '_at';
    $theme = config('template.admin_default_theme');

    $cmfDetectTheme = true;
    if ($cmfDetectTheme) {
        if (isset($_GET[$t])) {
            $theme = $_GET[$t];
            cookie('admin_theme', $theme, 864000);
        } elseif (cookie('admin_theme')) {
            $theme = cookie('admin_theme');
        }
    }


    $_currentAdminTheme = $theme;

    return $theme;
}


/**
 * 去除字符串中的指定字符
 * @param string $str   待处理字符串
 * @param string $chars 需去掉的特殊字符
 * @return string
 */
function stripChars($str, $chars = '?<*.>\'\"')
{
    return preg_replace('/[' . $chars . ']/is', '', $str);
}


/**
 * 密码加密方法
 * @param string $pw       要加密的原始密码
 * @param string $authCode 加密字符串
 * @return string
 */


function password($pw, $authCode = '')
{
    if (empty($authCode)) {
        $authCode = config('database.authcode');
    }
    $result = md5(md5($authCode . $pw));
    return $result;
}

function passwordOld($pw, $authCode = '')
{
    if (empty($authCode)) {
        $authCode = 'pCNIJBbyEvnPxgJxbO';
    }
    $result = "###" . md5(md5($authCode . $pw));
    return $result;
}


/**
 * 密码比较方法,所有涉及密码比较的地方都用这个方法
 * @param string $password     要比较的密码
 * @param string $passwordInDb 数据库保存的已经加密过的密码
 * @return boolean 密码相同，返回true
 */
function comparePassword($password, $passwordInDb)
{
    if (strpos($passwordInDb, "###") === 0) {
        return passwordOld($password) == $passwordInDb;
    } else {
        return password($password) == $passwordInDb;
    }
    return password($password) == $passwordInDb;
}


/**
 * 返回带协议的域名
 */
function getDomain()
{
    return request()->domain();
}


/**
 * 清空系统缓存
 */
function cmf_clear_cache()
{
    // 清除 opcache缓存
    if (function_exists("opcache_reset")) {
        opcache_reset();
    }

    $dirs     = [];
    $rootDirs = cmf_scan_dir(Env::get('runtime_path') . "*");
    //$noNeedClear=array(".","..","Data");
    $noNeedClear = ['.', '..', 'log'];
    $rootDirs    = array_diff($rootDirs, $noNeedClear);
    foreach ($rootDirs as $dir) {

        if ($dir != "." && $dir != "..") {
            $dir = Env::get('runtime_path') . $dir;
            if (is_dir($dir)) {
                //array_push ( $dirs, $dir );
                $tmpRootDirs = cmf_scan_dir($dir . "/*");
                foreach ($tmpRootDirs as $tDir) {
                    if ($tDir != "." && $tDir != "..") {
                        $tDir = $dir . '/' . $tDir;
                        if (is_dir($tDir)) {
                            array_push($dirs, $tDir);
                        } else {
//                            @unlink($tDir);
                        }
                    }
                }
            } else {
//                @unlink($dir);
            }
        }
    }
    $dirTool = new Dir("");
    foreach ($dirs as $dir) {
        $dirTool->delDir($dir);
    }
}


/**
 * 获取网站根目录
 * @return string 网站根目录
 */
function getRoot()
{
    $root = request()->root();
    $root = str_replace("//", '/', $root);
    $root = str_replace('/index.php', '', $root);
    if (defined('APP_NAMESPACE') && APP_NAMESPACE == 'api') {
        $root = preg_replace('/\/api(.php)$/', '', $root);
    }

    $root = rtrim($root, '/');

    return $root;
}

/**
 * 转化数据库保存文件的文件路径，为可以访问的url
 * @param string $file  文件路径，数据存储的文件相对路径
 * @param string $style 文件样式,支持各大云存储
 * @return string 文件链接
 */
function getAssetUrl($file, $style = 'watermark')
{
    if (empty($file)) {
        return '';
    }

    if (strpos($file, "http") === 0) {
        return $file;
    } else if (strpos($file, "/") === 0) {
        return getDomain() . $file;
    } else {
//        $storage = cmf_get_option('storage');
//        if (empty($storage['type'])) {
//            $storage['type'] = 'Local';
//        }
//        if ($storage['type'] != 'Local') {
//            $watermark = cmf_get_plugin_config($storage['type']);
//            $style     = empty($style) ? $watermark['styles_watermark'] : $style;
//        }
        $storage = Storage::instance();
        return $storage->getImageUrl($file, $style);
    }
}

/**
 * 随机字符串生成
 * @param int $len 生成的字符串长度
 * @return string
 */
function getRandomString($len = 6)
{
    $chars    = [
        "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k",
        "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v",
        "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G",
        "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R",
        "S", "T", "U", "V", "W", "X", "Y", "Z", "0", "1", "2",
        "3", "4", "5", "6", "7", "8", "9"
    ];
    $charsLen = count($chars) - 1;
    shuffle($chars);    // 将数组打乱
    $output = "";
    for ($i = 0; $i < $len; $i++) {
        $output .= $chars[mt_rand(0, $charsLen)];
    }
    return $output;
}


/**
 * 获取文件扩展名
 * @param string $filename 文件名
 * @return string 文件扩展名
 */
function getFileExtension($filename)
{
    $pathinfo = pathinfo($filename);
    return strtolower($pathinfo['extension']);
}

/**
 * 获取上传配置
 */
function getUploadSetting()
{
    $uploadSetting = getOption('upload_setting','overall');
    if (empty($uploadSetting) || empty($uploadSetting['file_types'])) {
        $uploadSetting = [
            'file_types' => [
                'image' => [
                    'upload_max_filesize' => '10240',//单位KB
                    'extensions'          => 'jpg,jpeg,png,gif,bmp4'
                ],
                'video' => [
                    'upload_max_filesize' => '204800',
                    'extensions'          => 'mp4,avi,wmv,rm,rmvb,mkv,mov'
                ],
                'audio' => [
                    'upload_max_filesize' => '10240',
                    'extensions'          => 'mp3,wma,wav'
                ],
                'file'  => [
                    'upload_max_filesize' => '10240',
                    'extensions'          => 'txt,pdf,doc,docx,xls,xlsx,ppt,pptx,zip,rar'
                ]
            ],
            'chunk_size' => 512,//单位KB
            'max_files'  => 20 //最大同时上传文件数
        ];
    }

    if (empty($uploadSetting['upload_max_filesize'])) {
        $uploadMaxFileSizeSetting = [];
        foreach ($uploadSetting['file_types'] as $setting) {
            $extensions = explode(',', trim($setting['extensions']));
            if (!empty($extensions)) {
                $uploadMaxFileSize = intval($setting['upload_max_filesize']) * 1024;//转化成B
                foreach ($extensions as $ext) {
                    if (!isset($uploadMaxFileSizeSetting[$ext]) || $uploadMaxFileSize > $uploadMaxFileSizeSetting[$ext]) {
                        $uploadMaxFileSizeSetting[$ext] = $uploadMaxFileSize;
                    }
                }
            }
        }

        $uploadSetting['upload_max_filesize'] = $uploadMaxFileSizeSetting;
    }

    return $uploadSetting;
}



// 获取网站信息
function getSiteInfo()
{
    return getOption('site_info','overall');
}


/**
 * 设置系统配置，通用
 * @param string $key     配置键值,都小写
 * @param array  $data    配置值，数组
 * @param string   $range 配置范围 personal,org,overall
 * @param bigint   $objId 对象id
 * @param bool   $replace 是否完全替换
 * @return bool 是否成功

 */
function setOption($key, $data, $range = 'overall', $objId = 0, $replace = false)
{
    if ($range != 'overall' && $range != 'org' && $range != 'personal') {
        return false;
    }

    if (!is_array($data) || empty($data) || !is_string($key) || empty($key)) {
        return false;
    }

    $key        = strtolower($key);
    $option     = [];
    $findOption = Db::name('config')->where('range', $range)->where('obj_id', $objId)->where('option_name', $key)->find();
    if ($findOption) {
        if (!$replace) {
            $oldOptionValue = json_decode($findOption['option_value'], true);
            if (!empty($oldOptionValue)) {
                $data = array_merge($oldOptionValue, $data);
            }
        }

        $option['option_value'] = json_encode($data);
        $option['range'] = $range;
        $option['obj_id'] = $objId;

        Db::name('config')->where('range', $range)->where('obj_id', $objId)->where('option_name', $key)->update($option);
//        echo Db::name('config')->getLastSql() . "\n";
    } else {
        $option['option_name']  = $key;
        $option['option_value'] = json_encode($data);
        $option['range'] = $range;
        $option['obj_id'] = $objId;
        Db::name('config')->insert($option);
    }

    cache('config_' . $range . '_' . $objId . '_' . $key, null , null , 'config');//删除缓存

    return true;
}

/**
 * 获取系统配置，通用
 * @param string $key 配置键值,都小写
 * @param string   $range 配置范围 personal,org,overall
 * @param bigint   $objId 对象id
 * @return array
 */
function getOption($key, $range = 'overall', $objId = 0)
{
    if ($range != 'overall' && $range != 'org' && $range != 'personal') {
        return false;
    }

    if (!is_string($key) || empty($key)) {
        return [];
    }

    if (PHP_SAPI != 'cli') {
        static $cmfGetOption;

        if (empty($cmfGetOption)) {
            $cmfGetOption = [];
        } else {
            if (!empty($cmfGetOption[$key])) {
                return $cmfGetOption[$key];
            }
        }
    }

    $optionValue = cache('config_' . $range . '_' . $objId . '_' . $key);

    if (empty($optionValue)) {
        $optionValue = Db::name('config')->where('range', $range)->where('obj_id', $objId)->where('option_name', $key)->value('option_value');
        if (!empty($optionValue)) {
            $optionValue = json_decode($optionValue, true);

            cache('config_' . $range . '_' . $objId . '_' . $key, $optionValue, null , 'config');
        }
    }

    $cmfGetOption[$key] = $optionValue;

    return $optionValue;
}



/*
    打印数组函数
*/
function p($data){
    // 定义样式
    $str='<pre style="display: block;padding: 9.5px;margin: 44px 0 0 0;font-size: 13px;line-height: 1.42857;color: #333;word-break: break-all;word-wrap: break-word;background-color: #F5F5F5;border: 1px solid #CCC;border-radius: 4px;">';
    // 如果是boolean或者null直接显示文字；否则print
    if (is_bool($data)) {
        $show_data=$data ? 'true' : 'false';
    }elseif (is_null($data)) {
        $show_data='null';
    }else{
        $show_data=print_r($data,true);
    }
    $str.=$show_data;
    $str.='</pre>';
    echo $str;
}