<?php

namespace app\student\model;

use think\Model;
// 软删除
use think\model\concern\SoftDelete;

class ScratchCoursePostModel extends Model
{
	// 软删除
	use SoftDelete;
    protected $deleteTime = 'delete_time';
    protected $defaultSoftDelete = 0;

    protected $createTime = 'create_time';
    protected $updateTime = 'update_time';

    // 自动完成
    protected $auto = [];
    protected $insert = ['create_user_id','status' => 1];  
    protected $update = []; 

    // 类型转换
    protected $type = [
        'status'        =>  'integer', // 数据状态


    ];



    public function setCreateUserIdAttr($value)
    {
        return getUserId();
    }

    public function getCreateUserIdAttr($value)
    {
        return getUserInfoById($value);
    }


    public function getThumbnailAttr($value)
    {
        return getAssetUrl($value);
    }


    // 获取器
    public function getStatusTextAttr($value,$data)
    {

        $status = [0=>'无效',1=>'有效',2=>'待审核'];



        return $status[$data['status']];
    }




    // 获取器
    public function getCourseStatusTextAttr($value,$data)
    {

        $status = [0=>'关闭',1=>'开启'];



        return $status[$data['course_status']];
    }





}