<?php

namespace app\student\model;

use think\Model;
// 引入框架软删除
use think\model\concern\SoftDelete;

class UserModel extends Model
{
	// 软删除
	use SoftDelete;
    protected $deleteTime = 'delete_time';
    protected $defaultSoftDelete = 0;

    protected $createTime = 'create_time';
    protected $updateTime = 'update_time';

    // 自动完成
    protected $auto = [];
    protected $insert = [];  
    protected $update = [];

    // 类型转换
    protected $type = [
        'status'        =>  'integer', // 数据状态
        'sex'       	=>  'integer', // 数据状态
    ];

    // 获取器
    public function getStatusTextAttr($value,$data)
    {
        $status = [0=>'无效',1=>'有效',2=>'待审核'];
        return $status[$data['status']];
    }
    public function getSexTextAttr($value,$data)
    {
        $sex = [0=>'保密',1=>'男',2=>'女'];
        return $sex[$data['sex']];
    }  
    public function getAvatarAttr($value,$data)
    {
        $avatar =  getAssetUrl($data['avatar']);
        return $avatar;
    }      
}