<?php

namespace app\student\service;

use app\student\model\ScratchCoursePostModel;
use app\student\model\ScratchLecturePostModel;
use think\Db;

use app\student\service\LectureService;


class CourseService 
{


    /**
     * 课程查询
     * @param      $filter
     * @param bool $isPage
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    // 二次查询。第一次查询主表，然后使用in 一次性查询相关的表详情，并组装出来。
    public function courseList($filter = array())
    {

        $where = [];
  
        $pageNo = 1;
        $pageSize = 20;

        if (!empty($filter['search'])) {
            $where['course_name'] = $filter['search'];
        }

        if (!empty($filter['school_id']) && $filter['school_id'] != 0) {
            $where['school_id'] = $filter['school_id'];
        }

        if (!empty($filter['course_status']) && $filter['course_status'] != 0) {
            $where['course_status'] = $filter['course_status'];
        }

        if (!empty($filter['pageNo']) && $filter['pageNo'] != 0 && is_int($filter['pageNo'])) {
            $pageNo = $filter['pageNo'];
        }

        if (!empty($filter['pageSize']) && $filter['pageSize'] != 0 && $filter['pageSize'] <= 100) {
            $pageSize = $filter['pageSize'];
        }



        $field = '*';


        $courseModel = new ScratchCoursePostModel();

        // 查询课程列表
        $course      = $courseModel
            ->where($where)
            ->where('parent_id',0)
            ->field($field)
            ->order('list_order ASC')
            ->select()
            ->append(['status_text','course_status_text'])
            ->toArray();

        $data = $course;
        $ids = [];
        foreach ($data as $key => $value) {
            $ids[] = $value['id'];
        }


        $studentId = getStudentId();



        //p($studentId);die;
        $locks = Db::name('scratch_student_course')
            ->where('course_id','in',$ids)
            ->where('student_id',$studentId)
            ->where('create_time', '>=', 0)
            ->where('delete_time', 0)
            ->order('update_time', 'DESC')
            ->select();

        

        // 数据组装
        foreach ($data as $key => $value) {
            $data[$key]['lock'] = 1;
            foreach ($locks as $k => $v) {
                if ($value['id'] == $v['course_id']) {
                    $data[$key]['lock'] = 0;
                }
            }

            
            

        }

        $course = $data;


        return $course;

    }



    public function getCourseByParentId($filter = array())
    {
        $where = [];
  



        if (!empty($filter['parent_id']) && $filter['parent_id'] != 0) {
            $where['parent_id'] = $filter['parent_id'];
        }



        $field = '*';


        $courseModel = new ScratchCoursePostModel();

        // 查询课时列表
        $course      = $courseModel
            ->where($where)
            ->field($field)
            ->append(['status_text','course_status_text'])
            ->order('list_order asc')
            ->select()
            ->toArray();

        $data = $course;
        $ids = [];
        $categoryIds = [];
        foreach ($data as $key => $value) {
            $ids[] = $value['id'];
        }


        




        // 数据组装
        foreach ($data as $key => $value) {
            

        }

        $course = $data;


        return $course;
    }


    public function homeworkList($filter = array())
    {
        $where = [];
  
        $courseInfo = $this->getCourseInfo(['id'=>$filter['id']]);

        $lectureService = new LectureService();

        $courseInfo['lectures'] = [];
        $courseInfo['project'] = [];

        if($courseInfo['subclass_type'] == 'lecture'){
            $courseInfo['lectures'] = $lectureService->lectureListByCourseId(['course_id'=>$courseInfo['id']]);
        } elseif ($courseInfo['subclass_type'] == 'project') {
            $projectList = $this->getCourseByParentId(['parent_id'=>$courseInfo['id']]);
            $ids = [];
            foreach ($projectList as $key => $value) {
                $ids[] = $value['id'];
            }

            $lectures = $lectureService->lectureListByCourseId(['course_id'=>$ids]);
            //p($lectures);die;
            foreach ($projectList as $key => $value) {
                $projectList[$key]['lectures'] = [];
                foreach ($lectures as $k => $v) {
                    if ($value['id'] == $v['course_id']) {
                        $projectList[$key]['lectures'][] = $v;
                        unset($lectures[$k]);
                    }
                    
                }
            }

            $courseInfo['project'] = $projectList;
        }



        


        return $courseInfo;
    }


    public function getCourseInfo($filter = array())
    {
        $courseModel = new ScratchCoursePostModel();
        $lectureModel = new ScratchLecturePostModel();

        $id      = isset($filter['id'])?$filter['id']:0;

        $courseFind = $courseModel
            ->append(['status_text','course_status_text','course_mode_text'])->find($id);

        

        


        return $courseFind;
    }

}